/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.training.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.google.common.collect.Maps;
import com.ovopark.api.GoldApi;
import com.ovopark.organize.common.base.BaseResult;
import com.ovopark.organize.common.model.pojo.UsersPojo;
import com.ovopark.organize.sdk.api.UserApi;
import com.ovopark.training.bo.JsonResult;
import com.ovopark.training.bo.Page;
import com.ovopark.training.enums.AttendRoleEnum;
import com.ovopark.training.enums.ProjectShiftStatusEnum;
import com.ovopark.training.enums.ProjectTaskSelfStatusEnum;
import com.ovopark.training.enums.ProjectTaskTypeEnum;
import com.ovopark.training.enums.YesNoEnum;
import com.ovopark.training.exception.CommonException;
import com.ovopark.training.mapper.TrainingAndMaterialMapper;
import com.ovopark.training.mapper.TrainingAttachMapper;
import com.ovopark.training.mapper.TrainingAttachUserMapper;
import com.ovopark.training.mapper.TrainingCertificateDetailMapper;
import com.ovopark.training.mapper.TrainingCertificateMapper;
import com.ovopark.training.mapper.TrainingChapterAttachMapper;
import com.ovopark.training.mapper.TrainingChapterAttachUserMapper;
import com.ovopark.training.mapper.TrainingChapterMapper;
import com.ovopark.training.mapper.TrainingChapterVideoMapper;
import com.ovopark.training.mapper.TrainingExamMapper;
import com.ovopark.training.mapper.TrainingGoldLogMapper;
import com.ovopark.training.mapper.TrainingJobDocumentMapper;
import com.ovopark.training.mapper.TrainingJobStudentAnalyseMapper;
import com.ovopark.training.mapper.TrainingJobUserTaskMapper;
import com.ovopark.training.mapper.TrainingLabelMapper;
import com.ovopark.training.mapper.TrainingLearnEndAttendMapper;
import com.ovopark.training.mapper.TrainingLearnExamineMapper;
import com.ovopark.training.mapper.TrainingLearnManagerMapper;
import com.ovopark.training.mapper.TrainingLearnProjectMapper;
import com.ovopark.training.mapper.TrainingLearnShiftMapper;
import com.ovopark.training.mapper.TrainingLearnTaskUserMapper;
import com.ovopark.training.mapper.TrainingLearnUserMapper;
import com.ovopark.training.mapper.TrainingLecturerMapper;
import com.ovopark.training.mapper.TrainingMapper;
import com.ovopark.training.mapper.TrainingMaterialMapper;
import com.ovopark.training.mapper.TrainingPaperMapper;
import com.ovopark.training.mapper.TrainingProjectDocumentMapper;
import com.ovopark.training.mapper.TrainingProjectTaskMapper;
import com.ovopark.training.mapper.TrainingTaskScheduleMapper;
import com.ovopark.training.mapper.TrainingUserPaperMapper;
import com.ovopark.training.mapper.TrainingUserViewTimeMapper;
import com.ovopark.training.mapper.TrainingVideoMapper;
import com.ovopark.training.mapper.TrainingWorkDocumentMapper;
import com.ovopark.training.mapper.TrainingWorkMapper;
import com.ovopark.training.mapper.TrainingWorkUserAnswerMapper;
import com.ovopark.training.model.Authenticator;
import com.ovopark.training.model.ClientInfo;
import com.ovopark.training.model.JPush;
import com.ovopark.training.model.ShiftManager;
import com.ovopark.training.model.TaskMessageBody;
import com.ovopark.training.model.Training;
import com.ovopark.training.model.TrainingAttach;
import com.ovopark.training.model.TrainingAttachUser;
import com.ovopark.training.model.TrainingCertificate;
import com.ovopark.training.model.TrainingCertificateDetail;
import com.ovopark.training.model.TrainingChapterAttach;
import com.ovopark.training.model.TrainingChapterAttachUser;
import com.ovopark.training.model.TrainingChapterVideo;
import com.ovopark.training.model.TrainingExam;
import com.ovopark.training.model.TrainingJobDocument;
import com.ovopark.training.model.TrainingJobUserTask;
import com.ovopark.training.model.TrainingLabel;
import com.ovopark.training.model.TrainingLearnEndAttend;
import com.ovopark.training.model.TrainingLearnExamine;
import com.ovopark.training.model.TrainingLearnManager;
import com.ovopark.training.model.TrainingLearnProject;
import com.ovopark.training.model.TrainingLearnShift;
import com.ovopark.training.model.TrainingLearnTaskUser;
import com.ovopark.training.model.TrainingLearnUser;
import com.ovopark.training.model.TrainingLecturer;
import com.ovopark.training.model.TrainingMaterial;
import com.ovopark.training.model.TrainingPaper;
import com.ovopark.training.model.TrainingProjectDocument;
import com.ovopark.training.model.TrainingProjectTask;
import com.ovopark.training.model.TrainingTaskSchedule;
import com.ovopark.training.model.TrainingUserPaper;
import com.ovopark.training.model.TrainingVideo;
import com.ovopark.training.model.TrainingWork;
import com.ovopark.training.model.TrainingWorkUserAnswer;
import com.ovopark.training.model.Users;
import com.ovopark.training.service.AppTrainingLearnProjectService;
import com.ovopark.training.service.JPushService;
import com.ovopark.training.service.TrainingCommonService;
import com.ovopark.training.service.TrainingJobCertificationService;
import com.ovopark.training.service.UserUtilService;
import com.ovopark.training.util.Arith;
import com.ovopark.training.util.ConstantsUtil;
import com.ovopark.training.util.DateUtils;
import com.ovopark.training.util.TencentLiveUtils;
import com.ovopark.training.vo.AppAttendMessageVo;
import com.ovopark.training.vo.AppAttendScanCodeVo;
import com.ovopark.training.vo.AppAttendTaskVo;
import com.ovopark.training.vo.AppAttendUserVo;
import com.ovopark.training.vo.AppAuditUserVo;
import com.ovopark.training.vo.AppShiftDateVo;
import com.ovopark.training.vo.AppStatusVo;
import com.ovopark.training.vo.AppTrainingProgressVo;
import com.ovopark.training.vo.AppTrainingProjectVo;
import com.ovopark.training.vo.AppTrainingShiftNumVo;
import com.ovopark.training.vo.AppTrainingShiftVo;
import com.ovopark.training.vo.AppTrainingTaskNumVo;
import com.ovopark.training.vo.AppTrainingTaskStatusVo;
import com.ovopark.training.vo.AppTrainingTaskVo;
import com.ovopark.training.vo.TrainingAttendAuditDetailVo;
import com.ovopark.training.vo.TrainingAttendAuditSaveVo;
import com.ovopark.training.vo.TrainingGoldLog;
import com.ovopark.training.vo.TrainingTaskScheduleVo;
import com.ovopark.training.vo.TrainingUserViewTimeVo;
import com.ovopark.training.vo.TrainingsVo;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Service(value="appTrainingLearnProjectService")
public class AppTrainingLearnProjectServiceImpl
implements AppTrainingLearnProjectService {
    private static final Logger log = LoggerFactory.getLogger(AppTrainingLearnProjectServiceImpl.class);
    @Resource
    private TrainingUserPaperMapper trainingUserPaperMapper;
    @Resource
    private TrainingProjectDocumentMapper documentMapper;
    @Resource
    private TrainingLecturerMapper lecturerMapper;
    @Resource
    private TrainingMapper trainingMapper;
    @Resource
    private TrainingLabelMapper trainingLabelMapper;
    @Resource
    private TrainingAttachMapper trainingAttachMapper;
    @Resource
    private TrainingAttachUserMapper trainingAttachUserMapper;
    @Resource
    private TrainingChapterAttachUserMapper trainingChapterAttachUserMapper;
    @Resource
    private TrainingVideoMapper trainingVideoMapper;
    @Resource
    private TrainingChapterAttachMapper trainingChapterAttachMapper;
    @Resource
    private TrainingChapterVideoMapper trainingChapterVideoMapper;
    @Resource
    private TrainingLearnProjectMapper trainingLearnProjectMapper;
    @Resource
    private TrainingProjectTaskMapper trainingProjectTaskMapper;
    @Resource
    private TrainingTaskScheduleMapper trainingTaskScheduleMapper;
    @Resource
    private TrainingChapterMapper trainingChapterMapper;
    @Resource
    private TrainingLearnUserMapper trainingLearnUserMapper;
    @Resource
    private TrainingLearnShiftMapper trainingLearnShiftMapper;
    @Resource
    private TrainingLearnTaskUserMapper trainingLearnTaskUserMapper;
    @Resource
    private TrainingLearnEndAttendMapper trainingLearnEndAttendMapper;
    @Resource
    private TrainingPaperMapper trainingPaperMapper;
    @Resource
    private TrainingExamMapper trainingExamMapper;
    @Autowired
    private com.ovopark.privilege.api.UserApi useApi;
    @Autowired
    private GoldApi goldApi;
    @Resource
    private TrainingLearnExamineMapper examineMapper;
    @Resource
    private TrainingLearnShiftMapper shiftMapper;
    @Resource
    private TrainingLearnManagerMapper learnManagerMapper;
    @Resource
    private TrainingCertificateDetailMapper certificateDetailMapper;
    @Resource
    private TrainingCertificateMapper certificateMapper;
    @Resource
    private TrainingJobDocumentMapper jobDocumentMapper;
    @Resource
    private TrainingJobUserTaskMapper jobUserTaskMapper;
    @Resource
    private TrainingJobCertificationService jobCertificationService;
    @Resource
    private TrainingJobStudentAnalyseMapper jobStudentAnalyseMapper;
    @Resource
    private UserApi userApi;
    @Resource
    private TrainingMaterialMapper trainingMaterialMapper;
    @Resource
    private TrainingAndMaterialMapper trainingAndMaterialMapper;
    @Resource
    private TrainingUserViewTimeMapper userViewTimeMapper;
    @Resource
    private JPushService jPushService;
    @Resource
    private UserUtilService userUtilService;
    @Autowired
    private MessageSource messageSource;
    @Autowired
    private TrainingCommonService commonService;
    @Resource
    private TrainingWorkMapper trainingWorkMapper;
    @Resource
    private TrainingWorkDocumentMapper trainingWorkDocumentMapper;
    @Resource
    private TrainingWorkUserAnswerMapper trainingWorkUserAnswerMapper;
    @Autowired
    private TrainingGoldLogMapper trainingGoldLogMapper;

    @Override
    public Page<AppTrainingShiftVo> selectMyProjectByPage(Page<AppTrainingShiftVo> page, Integer userId, Integer status) {
        List<AppTrainingShiftVo> shiftList = status.equals(1) ? this.trainingLearnProjectMapper.selectMyProjectByPage(page, userId, 2, null) : (status.equals(2) ? this.trainingLearnProjectMapper.selectMyProjectByPage(page, userId, 3, null) : this.trainingLearnProjectMapper.selectMyProjectByPage(page, userId, null, 4));
        if (!CollectionUtils.isEmpty(shiftList)) {
            Set<Integer> shiftIds = shiftList.stream().map(AppTrainingShiftVo::getShiftId).collect(Collectors.toSet());
            List<AppTrainingShiftNumVo> numList = this.trainingLearnUserMapper.summaryUserNum(shiftIds);
            Map<Integer, Integer> numMap = numList.stream().collect(Collectors.toMap(a -> a.getShiftId(), a -> a.getUserNum(), (x, y) -> x));
            List<AppTrainingTaskNumVo> taskNumList = this.trainingLearnTaskUserMapper.summaryFinishNum(shiftIds, userId);
            Map<Integer, AppTrainingTaskNumVo> taskNumMap = taskNumList.stream().collect(Collectors.toMap(a -> a.getShiftId(), a -> a, (x, y) -> x));
            for (AppTrainingShiftVo shiftVo : shiftList) {
                Integer shiftId = shiftVo.getShiftId();
                shiftVo.setUserNum(numMap.getOrDefault(shiftId, 0));
                AppTrainingTaskNumVo taskNumVo = taskNumMap.get(shiftId);
                if (Objects.nonNull(taskNumVo)) {
                    shiftVo.setTotalNum(taskNumVo.getTotalNum());
                    shiftVo.setFinishNum(taskNumVo.getFinishNum());
                } else {
                    shiftVo.setTotalNum(Integer.valueOf(0));
                    shiftVo.setFinishNum(Integer.valueOf(0));
                }
                if (!org.springframework.util.StringUtils.isEmpty((Object)shiftVo.getSupplemenName())) {
                    shiftVo.setShiftName(MessageFormat.format("{0}-{1}", shiftVo.getShiftName(), shiftVo.getSupplemenName()));
                }
                if (shiftVo.getIsNoTimeLimit() == null || shiftVo.getIsNoTimeLimit() != 1) continue;
                shiftVo.setEndTime(null);
            }
        }
        page.setContent(shiftList);
        return page;
    }

    @Override
    public AppTrainingShiftVo getAppTrainingShift(Integer shiftId, Integer userId) {
        TrainingLearnShift trainingLearnShift = (TrainingLearnShift)this.trainingLearnShiftMapper.selectById(shiftId);
        if (Objects.isNull(trainingLearnShift)) {
            AppTrainingShiftVo shiftVo = new AppTrainingShiftVo();
            shiftVo.setStatus(1);
            return shiftVo;
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.eq(TrainingLearnUser::getShiftId, (Object)shiftId)).eq(TrainingLearnUser::getIsDelete, (Object)0)).eq(TrainingLearnUser::getUserId, (Object)userId);
        List trainingLearnUserList = this.trainingLearnUserMapper.selectList((Wrapper)queryWrapper);
        if (CollectionUtils.isEmpty((Collection)trainingLearnUserList)) {
            TrainingLearnProject project = (TrainingLearnProject)this.trainingLearnProjectMapper.selectById(trainingLearnShift.getProjectId());
            AppTrainingShiftVo shiftVo = new AppTrainingShiftVo();
            shiftVo.setProjectName(project.getProjectName());
            shiftVo.setShiftName(org.springframework.util.StringUtils.isEmpty((Object)trainingLearnShift.getSupplemenName()) ? MessageFormat.format("{0}-{1}", trainingLearnShift.getShiftName(), trainingLearnShift.getGroupName()) : MessageFormat.format("{0}-{1}-{2}", trainingLearnShift.getShiftName(), trainingLearnShift.getGroupName(), trainingLearnShift.getSupplemenName()));
            Map<Integer, UsersPojo> usersPojoMap = this.userUtilService.selectUserMap(Arrays.stream(trainingLearnShift.getShiftManager().split(",")).map(Integer::parseInt).collect(Collectors.toList()));
            ArrayList<ShiftManager> shiftManagerList = new ArrayList<ShiftManager>();
            for (Map.Entry<Integer, UsersPojo> entry : usersPojoMap.entrySet()) {
                ShiftManager shiftManager = new ShiftManager();
                shiftManager.setId(entry.getKey().intValue());
                shiftManager.setHead(entry.getValue().getStaffImageUrl());
                shiftManager.setUserName(entry.getValue().getShowName());
                shiftManagerList.add(shiftManager);
            }
            shiftVo.setShiftManagerList(shiftManagerList);
            shiftVo.setStatus(2);
            return shiftVo;
        }
        AppTrainingShiftVo vo = this.trainingLearnProjectMapper.getAppTrainingShiftById(shiftId, userId);
        if (Objects.nonNull(vo)) {
            vo.setStatus(0);
            LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)wrapper.eq(TrainingLearnUser::getShiftId, (Object)shiftId)).eq(TrainingLearnUser::getIsDelete, (Object)0);
            Integer count = this.trainingLearnUserMapper.selectCount((Wrapper)wrapper);
            vo.setUserNum(count);
            AppTrainingTaskNumVo taskNumVo = this.trainingLearnTaskUserMapper.summaryFinishNumOneShift(shiftId, userId);
            if (Objects.nonNull(taskNumVo)) {
                vo.setTotalNum(taskNumVo.getTotalNum());
                vo.setFinishNum(taskNumVo.getFinishNum());
            } else {
                vo.setTotalNum(Integer.valueOf(0));
                vo.setFinishNum(Integer.valueOf(0));
            }
            if (!org.springframework.util.StringUtils.isEmpty((Object)vo.getSupplemenName())) {
                vo.setShiftName(MessageFormat.format("{0}-{1}", vo.getShiftName(), vo.getSupplemenName()));
            }
            if (vo.getIsNoTimeLimit() != null && vo.getIsNoTimeLimit() == 1) {
                vo.setEndTime(null);
            }
            BigDecimal totalScore = new BigDecimal(0);
            BigDecimal score = new BigDecimal(0);
            Integer isScore = 0;
            LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)wrapper1.eq(TrainingProjectTask::getProjectId, (Object)vo.getProjectId())).in(TrainingProjectTask::getTaskType, Arrays.asList(2, 3, 6));
            List tasks = this.trainingProjectTaskMapper.selectList((Wrapper)wrapper1);
            if (!CollectionUtils.isEmpty((Collection)tasks)) {
                List taskIds = tasks.stream().map(TrainingProjectTask::getId).distinct().collect(Collectors.toList());
                LambdaQueryWrapper wrapper2 = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)wrapper2.in(TrainingTaskSchedule::getTaskId, taskIds)).eq(TrainingTaskSchedule::getShiftId, (Object)shiftId);
                List taskScheduleList = this.trainingTaskScheduleMapper.selectList((Wrapper)wrapper2);
                if (!CollectionUtils.isEmpty((Collection)taskScheduleList)) {
                    List scheduleIds = taskScheduleList.stream().map(TrainingTaskSchedule::getId).distinct().collect(Collectors.toList());
                    LambdaQueryWrapper wrapper3 = new LambdaQueryWrapper();
                    ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper3.in(TrainingLearnTaskUser::getProjectTaskScheduleId, scheduleIds)).eq(TrainingLearnTaskUser::getShiftId, (Object)shiftId)).eq(TrainingLearnTaskUser::getUserId, (Object)userId)).in(TrainingLearnTaskUser::getTaskStatus, Arrays.asList(3, 4));
                    List taskUserList = this.trainingLearnTaskUserMapper.selectList((Wrapper)wrapper3);
                    Map<Object, Object> map = new HashMap();
                    if (!CollectionUtils.isEmpty((Collection)taskUserList)) {
                        map = taskUserList.stream().collect(Collectors.toMap(TrainingLearnTaskUser::getProjectTaskScheduleId, Function.identity()));
                    }
                    for (TrainingTaskSchedule schedule : taskScheduleList) {
                        if (org.springframework.util.StringUtils.isEmpty((Object)schedule.getTaskRate()) || org.springframework.util.StringUtils.isEmpty((Object)schedule.getFullScore())) continue;
                        totalScore = totalScore.add(schedule.getFullScore().multiply(schedule.getTaskRate()).multiply(BigDecimal.valueOf(0.01))).setScale(1, 4);
                        TrainingLearnTaskUser taskUser = (TrainingLearnTaskUser)map.get(schedule.getId());
                        if (org.springframework.util.StringUtils.isEmpty((Object)taskUser) || org.springframework.util.StringUtils.isEmpty((Object)taskUser.getScore())) continue;
                        score = score.add(taskUser.getScore().multiply(schedule.getTaskRate()).multiply(BigDecimal.valueOf(0.01))).setScale(1, 4);
                    }
                }
            }
            if (!org.springframework.util.StringUtils.isEmpty((Object)score)) {
                isScore = 1;
            }
            vo.setIsScore(isScore);
            vo.setTotalScore(totalScore);
            if (vo.getShiftStatus() == null || vo.getShiftStatus() != 4 || vo.getScore() == null) {
                vo.setScore(score);
            }
        }
        return vo;
    }

    @Override
    public List<AppTrainingTaskVo> selectTaskByShiftId(Integer userId, Integer shiftId, String versions) {
        ClientInfo clientInfo = Authenticator.getInstance().getCurrentClient();
        String version = "";
        String clientName = "";
        if (!org.springframework.util.StringUtils.isEmpty((Object)clientInfo)) {
            if (!org.springframework.util.StringUtils.isEmpty((Object)clientInfo.getVersion())) {
                String[] vers = clientInfo.getVersion().trim().split("_");
                version = vers[0];
            }
            if (!org.springframework.util.StringUtils.isEmpty((Object)clientInfo.getClient())) {
                clientName = clientInfo.getClient().trim();
            }
        }
        AppStatusVo appStatusVo = this.trainingLearnProjectMapper.getStatusByShiftId(shiftId);
        List<AppTrainingTaskVo> taskList = new ArrayList<AppTrainingTaskVo>();
        if (!org.springframework.util.StringUtils.isEmpty((Object)appStatusVo)) {
            taskList = YesNoEnum.YES.getKey().equals(appStatusVo.getIsThrough()) ? this.trainingLearnTaskUserMapper.selectTaskByShiftId(userId, shiftId, org.springframework.util.StringUtils.isEmpty((Object)versions) ? Integer.valueOf(1) : null) : this.trainingLearnTaskUserMapper.selectTaskByShiftIdSort(userId, shiftId, org.springframework.util.StringUtils.isEmpty((Object)versions) ? Integer.valueOf(1) : null);
            Boolean lockFlag = false;
            if (!CollectionUtils.isEmpty(taskList)) {
                List materialList;
                List trainingIdList = taskList.stream().map(AppTrainingTaskVo::getTrainingId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
                Map<Object, Object> trainingMap = new HashMap();
                if (!CollectionUtils.isEmpty(trainingIdList)) {
                    List trainings = this.trainingMapper.selectBatchIds(trainingIdList);
                    ArrayList<TrainingsVo> trainingVos = new ArrayList<TrainingsVo>();
                    LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
                    ((LambdaQueryWrapper)wrapper1.in(TrainingChapterAttach::getTrainingId, trainingIdList)).eq(TrainingChapterAttach::getIsDel, (Object)0);
                    List trainingChapterAttachList = this.trainingChapterAttachMapper.selectList((Wrapper)wrapper1);
                    Object trainingChapterAttachMap = new HashMap();
                    if (!CollectionUtils.isEmpty((Collection)trainingChapterAttachList)) {
                        trainingChapterAttachMap = trainingChapterAttachList.stream().collect(Collectors.groupingBy(TrainingChapterAttach::getTrainingId));
                    }
                    for (Training training : trainings) {
                        TrainingsVo vo = new TrainingsVo();
                        BeanUtils.copyProperties((Object)training, (Object)vo);
                        List attachList = (List)trainingChapterAttachMap.get(training.getId());
                        vo.setChapterNum(Integer.valueOf(CollectionUtils.isEmpty((Collection)attachList) ? 0 : attachList.size()));
                        trainingVos.add(vo);
                    }
                    trainingMap = trainingVos.stream().collect(Collectors.toMap(Training::getId, Function.identity()));
                }
                List materialIdList = taskList.stream().map(AppTrainingTaskVo::getMaterialId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
                Map<Object, Object> materialMap = new HashMap();
                if (!CollectionUtils.isEmpty(materialIdList) && !CollectionUtils.isEmpty((Collection)(materialList = this.trainingMaterialMapper.selectBatchIds(materialIdList)))) {
                    materialMap = materialList.stream().collect(Collectors.toMap(TrainingMaterial::getId, Function.identity()));
                    if (!"h5".equalsIgnoreCase(clientName) && version.compareTo("4.48.01") < 0) {
                        ArrayList<AppTrainingTaskVo> delList = new ArrayList<AppTrainingTaskVo>();
                        for (AppTrainingTaskVo task : taskList) {
                            TrainingMaterial material;
                            if (org.springframework.util.StringUtils.isEmpty((Object)task.getMaterialId()) || org.springframework.util.StringUtils.isEmpty((Object)(material = (TrainingMaterial)materialMap.get(task.getMaterialId())).getIsCommodity()) || material.getIsCommodity() != 1) continue;
                            delList.add(task);
                        }
                        if (!CollectionUtils.isEmpty(delList)) {
                            taskList.removeAll(delList);
                        }
                    }
                }
                Locale locale = Authenticator.getInstance().getCurrentClient().getLocale();
                String unStart = this.messageSource.getMessage("training.course.status.unstart", null, locale);
                String going = this.messageSource.getMessage("training.job.status.going", null, locale);
                String ended = this.messageSource.getMessage("training.job.status.ended", null, locale);
                for (int i = 0; i < taskList.size(); ++i) {
                    TrainingWork trainingWork;
                    Integer count;
                    AppTrainingTaskVo taskVo = taskList.get(i);
                    if (org.springframework.util.StringUtils.isEmpty((Object)taskVo.getTaskStatus())) {
                        taskVo.setTaskStatus(Integer.valueOf(0));
                    }
                    if (Objects.isNull(taskVo.getStartTime())) {
                        taskVo.setTaskSelfStatus(ProjectTaskSelfStatusEnum.DOING.getKey());
                        taskVo.setTaskSelfStatusStr(going);
                    } else if (taskVo.getStartTime().after(new Date())) {
                        taskVo.setTaskSelfStatus(ProjectTaskSelfStatusEnum.DEFAULT.getKey());
                        taskVo.setTaskSelfStatusStr(unStart);
                    } else if (!Objects.isNull(taskVo.getEndTime()) && taskVo.getEndTime().before(new Date())) {
                        taskVo.setTaskSelfStatus(ProjectTaskSelfStatusEnum.ENDED.getKey());
                        taskVo.setTaskSelfStatusStr(ended);
                    } else {
                        taskVo.setTaskSelfStatus(ProjectTaskSelfStatusEnum.DOING.getKey());
                        taskVo.setTaskSelfStatusStr(going);
                    }
                    if (YesNoEnum.YES.getKey().equals(appStatusVo.getIsThrough())) {
                        if (lockFlag.booleanValue()) {
                            taskVo.setTaskSelfStatus(ProjectTaskSelfStatusEnum.UNLOCK.getKey());
                            taskVo.setTaskSelfStatusStr(this.messageSource.getMessage("training.learn.shift.unlock.no", null, locale));
                        }
                        if (taskVo.getTaskStatus() != 4) {
                            lockFlag = true;
                        }
                    }
                    if (i == 0) {
                        taskVo.setIndex(Integer.valueOf(i + 1));
                    } else if (taskVo.getStartTimeStr().equals(taskList.get(i - 1).getStartTimeStr())) {
                        taskVo.setIndex(taskList.get(i - 1).getIndex());
                    } else {
                        taskVo.setIndex(Integer.valueOf(taskList.get(i - 1).getIndex() + 1));
                    }
                    if (ProjectTaskTypeEnum.COURSE.getKey().equals(taskVo.getTaskType())) {
                        Integer trainingId = taskVo.getTrainingId();
                        TrainingsVo trainingsVo = (TrainingsVo)trainingMap.get(taskVo.getTrainingId());
                        if (ObjectUtils.isEmpty((Object)trainingsVo)) continue;
                        if (!org.springframework.util.StringUtils.isEmpty((Object)trainingsVo.getProjectShow()) && trainingsVo.getProjectShow() < 5) {
                            if (trainingsVo.getIsChapter() == 0) {
                                LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
                                wrapper.eq(TrainingAttach::getTrainingId, (Object)trainingId);
                                Integer count2 = this.trainingAttachMapper.selectCount((Wrapper)wrapper);
                                LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
                                wrapper1.eq(TrainingVideo::getTrainingId, (Object)trainingId);
                                Integer count1 = this.trainingVideoMapper.selectCount((Wrapper)wrapper1);
                                taskVo.setChapterNum(Integer.valueOf(count2 + count1));
                            } else {
                                count = this.trainingChapterAttachMapper.selectCountByTrainingId(trainingId);
                                Integer count1 = this.trainingChapterVideoMapper.selectCountByTrainingId(trainingId);
                                taskVo.setChapterNum(Integer.valueOf(count + count1));
                            }
                            this.setTrainingInfo(taskVo);
                            continue;
                        }
                        taskVo.setTrainingVo(trainingsVo);
                        taskVo.setChapterNum(trainingsVo.getChapterNum());
                        if (org.springframework.util.StringUtils.isEmpty((Object)taskVo.getTaskStatus()) || taskVo.getTaskStatus() == 0) {
                            taskVo.setRate(Integer.valueOf(0));
                            continue;
                        }
                        Integer learnType = 2;
                        List<TrainingUserViewTimeVo> timeList = this.commonService.selectlearnProgress(taskVo.getTrainingId(), learnType, taskVo.getScheduleId(), userId, 1, taskVo.getIsSync());
                        if (!CollectionUtils.isEmpty(timeList)) {
                            BigDecimal readRate = BigDecimal.ZERO;
                            for (int m = 0; m < timeList.size(); ++m) {
                                TrainingUserViewTimeVo map = timeList.get(m);
                                readRate = readRate.add(map.getReadRate());
                            }
                            taskVo.setRate(Integer.valueOf(taskVo.getTaskStatus() != null && taskVo.getTaskStatus() == 4 ? 100 : readRate.divide(new BigDecimal(timeList.size() + ""), 2, 4).multiply(new BigDecimal("100")).intValue()));
                            continue;
                        }
                        taskVo.setRate(Integer.valueOf(0));
                        continue;
                    }
                    if (ProjectTaskTypeEnum.EXAM.getKey().equals(taskVo.getTaskType())) {
                        TrainingPaper paper = (TrainingPaper)this.trainingPaperMapper.selectById(taskVo.getPaperId());
                        if (org.springframework.util.StringUtils.isEmpty((Object)paper)) continue;
                        taskVo.setRepetitionNum(paper.getRepetitionNum());
                        taskVo.setPaperTime(Integer.valueOf(paper.getPaperTime() / 60));
                        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
                        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(TrainingUserPaper::getUserId, (Object)userId)).eq(TrainingUserPaper::getTrainingPaperId, (Object)taskVo.getPaperId())).ne(TrainingUserPaper::getPaperStatus, (Object)0)).eq(TrainingUserPaper::getSourceType, (Object)3)).eq(TrainingUserPaper::getSourceProjectId, (Object)taskVo.getProjectId())).eq(TrainingUserPaper::getSourceTaskId, (Object)taskVo.getScheduleId())).eq(TrainingUserPaper::getSourceShiftId, (Object)shiftId);
                        count = this.trainingUserPaperMapper.selectCount((Wrapper)wrapper);
                        taskVo.setPaperUserStatus(count == 0 ? "3" : "4");
                        continue;
                    }
                    if (ProjectTaskTypeEnum.MATERIAL.getKey().equals(taskVo.getTaskType())) {
                        TrainingTaskSchedule taskSchedule = (TrainingTaskSchedule)this.trainingTaskScheduleMapper.selectById(taskVo.getScheduleId());
                        if (ObjectUtils.isEmpty((Object)taskSchedule)) continue;
                        TrainingMaterial material = (TrainingMaterial)materialMap.get(taskSchedule.getMaterialId());
                        taskVo.setMaterial(material);
                        if (lockFlag.booleanValue()) continue;
                        BigDecimal finishTime = new BigDecimal(0);
                        if (!org.springframework.util.StringUtils.isEmpty((Object)material)) {
                            if (material.getIsVideo() != null && material.getIsVideo() == 1) {
                                finishTime = new BigDecimal(material.getDuration());
                                if (!org.springframework.util.StringUtils.isEmpty((Object)material.getFinishRate())) {
                                    finishTime = finishTime.multiply(material.getFinishRate()).divide(new BigDecimal(100), 0, 4);
                                }
                            } else if (material.getFinishTime() != null) {
                                finishTime = new BigDecimal(material.getFinishTime());
                            }
                        }
                        TrainingUserViewTimeVo userViewTimes = new TrainingUserViewTimeVo();
                        userViewTimes = taskSchedule.getIsSync() != null && taskSchedule.getIsSync() == 1 ? this.commonService.selectMaterialViewTime(userId, null, 0, taskSchedule.getMaterialId(), null) : this.commonService.selectMaterialViewTime(userId, taskSchedule.getId(), 2, taskSchedule.getMaterialId(), null);
                        if (!ObjectUtils.isEmpty((Object)userViewTimes) && !org.springframework.util.StringUtils.isEmpty((Object)userViewTimes.getMaterialId())) {
                            BigDecimal viewTime = new BigDecimal(userViewTimes.getViewTimes());
                            BigDecimal rate = BigDecimal.ONE;
                            if (finishTime.compareTo(BigDecimal.ZERO) > 0) {
                                rate = viewTime.divide(finishTime, 2, 1);
                            }
                            taskVo.setRate(Integer.valueOf(taskVo.getTaskStatus() != null && taskVo.getTaskStatus() == 4 ? 100 : rate.multiply(new BigDecimal(100)).intValue()));
                            taskVo.setNeedReadTimes(Integer.valueOf(viewTime.compareTo(finishTime) >= 0 ? 0 : finishTime.subtract(viewTime).intValue()));
                            continue;
                        }
                        taskVo.setTaskStatus(Integer.valueOf(1));
                        taskVo.setRate(Integer.valueOf(0));
                        continue;
                    }
                    if (!ProjectTaskTypeEnum.WORK.getKey().equals(taskVo.getTaskType()) || ObjectUtils.isEmpty((Object)(trainingWork = (TrainingWork)this.trainingWorkMapper.selectById(taskVo.getWorkId())))) continue;
                    taskVo.setTrainingWork(trainingWork);
                    if (lockFlag.booleanValue()) continue;
                    LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
                    ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper1.eq(TrainingWorkUserAnswer::getWorkId, (Object)taskVo.getWorkId())).eq(TrainingWorkUserAnswer::getUserId, (Object)userId)).orderByDesc(TrainingWorkUserAnswer::getId);
                    List userAnswerList = this.trainingWorkUserAnswerMapper.selectList((Wrapper)wrapper1);
                    if (!CollectionUtils.isEmpty((Collection)userAnswerList)) {
                        TrainingWorkUserAnswer userAnswer = (TrainingWorkUserAnswer)userAnswerList.get(0);
                        if (!org.springframework.util.StringUtils.isEmpty((Object)userAnswer.getStatus()) && userAnswer.getStatus() == 0) {
                            taskVo.setTaskStatus(Integer.valueOf(0));
                        } else if (!org.springframework.util.StringUtils.isEmpty((Object)userAnswer.getStatus())) {
                            taskVo.setTaskStatus(Integer.valueOf(userAnswer.getStatus() + 1));
                        }
                        if (org.springframework.util.StringUtils.isEmpty((Object)userAnswer.getScore())) continue;
                        taskVo.setScore(userAnswer.getScore());
                        continue;
                    }
                    taskVo.setTaskStatus(Integer.valueOf(0));
                }
            }
        }
        return taskList;
    }

    private void setTrainingInfo(AppTrainingTaskVo taskVo) {
        Training training = (Training)this.trainingMapper.selectById(taskVo.getTrainingId());
        if (Objects.nonNull(training)) {
            List<TrainingLabel> labelList;
            TrainingsVo vo = new TrainingsVo();
            BeanUtils.copyProperties((Object)training, (Object)vo);
            if (training.getStartTime() != null) {
                vo.setCreateTimeStr(DateUtils.format(training.getStartTime()));
            }
            if (training.getStartTime() != null) {
                long txTime = 0L;
                txTime = training.getDuration() == null || training.getDuration() == 0 ? training.getStartTime().getTime() / 1000L + 86400L : training.getStartTime().getTime() / 1000L + (long)(training.getDuration() * 60);
                vo.setRtmpPush("rtmp://3682.livepush.myqcloud.com/live/3682_" + training.getId() + "?bizid=3682&" + TencentLiveUtils.getSafeUrl("d2f12deefdc9b314cb31b107315fc65c", "3682_" + training.getId().toString(), txTime));
                vo.setRtmp("rtmp://3682.liveplay.myqcloud.com/live/3682_" + training.getId());
                vo.setFlv("http://3682.liveplay.myqcloud.com/live/3682_" + training.getId() + ".flv");
                vo.setHls("http://3682.liveplay.myqcloud.com/live/3682_" + training.getId() + ".m3u8");
            }
            if (!CollectionUtils.isEmpty(labelList = this.trainingLabelMapper.selectByTrainingId(training.getId()))) {
                vo.setLabelList(labelList);
            }
            taskVo.setTrainingVo(vo);
        }
    }

    @Override
    public void updateExamTaskStatus(Integer userPaperId) {
        TrainingUserPaper trainingUserPaper = (TrainingUserPaper)this.trainingUserPaperMapper.selectById(userPaperId);
        if (!ObjectUtils.isEmpty((Object)trainingUserPaper)) {
            Integer paperId = trainingUserPaper.getTrainingPaperId();
            Integer userId = trainingUserPaper.getUserId();
            TrainingPaper paper = (TrainingPaper)this.trainingPaperMapper.selectById(paperId);
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.eq(TrainingUserPaper::getUserId, (Object)userId);
            queryWrapper.eq(TrainingUserPaper::getTrainingPaperId, (Object)paperId);
            queryWrapper.eq(TrainingUserPaper::getSourceType, (Object)3);
            queryWrapper.eq(trainingUserPaper.getSourceProjectId() != null, TrainingUserPaper::getSourceProjectId, (Object)trainingUserPaper.getSourceProjectId());
            queryWrapper.eq(trainingUserPaper.getSourceTaskId() != null, TrainingUserPaper::getSourceTaskId, (Object)trainingUserPaper.getSourceTaskId());
            queryWrapper.eq(trainingUserPaper.getSourceShiftId() != null, TrainingUserPaper::getSourceShiftId, (Object)trainingUserPaper.getSourceShiftId());
            queryWrapper.orderByDesc(TrainingUserPaper::getId);
            List trainingUserPaperList = this.trainingUserPaperMapper.selectList((Wrapper)queryWrapper);
            TrainingTaskSchedule schedule = null;
            if (trainingUserPaper.getSourceTaskId() != null) {
                schedule = (TrainingTaskSchedule)this.trainingTaskScheduleMapper.selectById(trainingUserPaper.getSourceTaskId());
            }
            if (ObjectUtils.isEmpty(schedule)) {
                LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(TrainingTaskSchedule::getPaperId, (Object)paperId)).eq(trainingUserPaper.getSourceProjectId() != null, TrainingTaskSchedule::getProjectId, (Object)trainingUserPaper.getSourceProjectId())).eq(trainingUserPaper.getSourceTaskId() != null, TrainingTaskSchedule::getId, (Object)trainingUserPaper.getSourceTaskId())).eq(trainingUserPaper.getSourceShiftId() != null, TrainingTaskSchedule::getShiftId, (Object)trainingUserPaper.getSourceShiftId())).orderByDesc(TrainingTaskSchedule::getId);
                List scheduleList = this.trainingTaskScheduleMapper.selectList((Wrapper)wrapper);
                if (!CollectionUtils.isEmpty((Collection)scheduleList)) {
                    schedule = (TrainingTaskSchedule)scheduleList.get(0);
                }
            }
            if (Objects.nonNull(schedule)) {
                List<TrainingUserViewTimeVo> timeList;
                if (schedule.getTaskType() == 2) {
                    if (!CollectionUtils.isEmpty((Collection)trainingUserPaperList)) {
                        TrainingUserPaper temp = (TrainingUserPaper)trainingUserPaperList.get(0);
                        for (TrainingUserPaper userPaper : trainingUserPaperList) {
                            if (userPaper.getPaperStatus() == 1) continue;
                            if (Objects.isNull(paper.getScoreSelect()) || paper.getScoreSelect() == 1) {
                                if (temp.getPaperStatus() != 1 && !userPaper.getCreateTime().after(temp.getCreateTime())) continue;
                                temp = userPaper;
                                continue;
                            }
                            if (temp.getPaperStatus() != 1 && userPaper.getScore().intValue() <= temp.getScore().intValue()) continue;
                            temp = userPaper;
                        }
                        TrainingLearnTaskUser trainingLearnTaskUser = new TrainingLearnTaskUser();
                        if (Objects.nonNull(temp.getUpdateTime()) && temp.getPaperStatus() == 0) {
                            trainingLearnTaskUser.setTaskStatus(Integer.valueOf(1));
                        } else if (Objects.nonNull(temp.getUpdateTime()) && temp.getPaperStatus() == 1) {
                            trainingLearnTaskUser.setTaskStatus(Integer.valueOf(2));
                        } else {
                            BigDecimal percent;
                            BigDecimal result;
                            TrainingExam trainingExam;
                            BigDecimal score = temp.getScore();
                            BigDecimal org_score = new BigDecimal("100");
                            if (paper.getExamId() != null && !ObjectUtils.isEmpty((Object)(trainingExam = (TrainingExam)this.trainingExamMapper.selectById(paper.getExamId())))) {
                                org_score = trainingExam.getScore();
                            }
                            int status = score.compareTo(result = org_score.multiply(percent = new BigDecimal(paper.getPassLine()).divide(new BigDecimal("100")))) >= 0 ? 4 : 3;
                            trainingLearnTaskUser.setTaskStatus(Integer.valueOf(status));
                            trainingLearnTaskUser.setScore(temp.getScore());
                            long totalMs = 0L;
                            for (TrainingUserPaper userPaper : trainingUserPaperList) {
                                if (ObjectUtils.isEmpty((Object)userPaper.getSubmitTime()) || ObjectUtils.isEmpty((Object)userPaper.getUpdateTime())) continue;
                                totalMs += userPaper.getSubmitTime().getTime() - userPaper.getUpdateTime().getTime();
                            }
                            Integer avg = Math.toIntExact(totalMs / 1000L / (long)trainingUserPaperList.size());
                            trainingLearnTaskUser.setUseTime(avg);
                            trainingLearnTaskUser.setEndTime(new Date());
                        }
                        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
                        updateWrapper.eq(TrainingLearnTaskUser::getUserId, (Object)userId);
                        updateWrapper.eq(TrainingLearnTaskUser::getProjectTaskScheduleId, (Object)schedule.getId());
                        this.trainingLearnTaskUserMapper.update(trainingLearnTaskUser, (Wrapper)updateWrapper);
                    }
                } else if (schedule.getTaskType() == 1 && schedule.getTrainingId() != null && !CollectionUtils.isEmpty(timeList = this.commonService.selectlearnProgress(schedule.getTrainingId(), 2, schedule.getId(), userId, 1, schedule.getIsSync()))) {
                    boolean is = true;
                    for (TrainingUserViewTimeVo vo : timeList) {
                        if (vo.getIsFinish() != 0) continue;
                        is = false;
                        break;
                    }
                    LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
                    ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper1.eq(TrainingLearnTaskUser::getUserId, (Object)userId)).eq(TrainingLearnTaskUser::getProjectTaskScheduleId, (Object)schedule.getId())).orderByDesc(TrainingLearnTaskUser::getId);
                    List trainingLearnTaskUserList = this.trainingLearnTaskUserMapper.selectList((Wrapper)wrapper1);
                    if (!CollectionUtils.isEmpty((Collection)trainingLearnTaskUserList)) {
                        TrainingLearnTaskUser trainingLearnTaskUser = (TrainingLearnTaskUser)trainingLearnTaskUserList.get(0);
                        Date now = new Date();
                        if (is) {
                            trainingLearnTaskUser.setTaskStatus(Integer.valueOf(4));
                            if (org.springframework.util.StringUtils.isEmpty((Object)trainingLearnTaskUser.getStartTime())) {
                                trainingLearnTaskUser.setStartTime(now);
                            }
                            trainingLearnTaskUser.setEndTime(now);
                        } else {
                            trainingLearnTaskUser.setTaskStatus(Integer.valueOf(1));
                            if (org.springframework.util.StringUtils.isEmpty((Object)trainingLearnTaskUser.getStartTime())) {
                                trainingLearnTaskUser.setStartTime(now);
                            }
                        }
                        this.trainingLearnTaskUserMapper.updateById(trainingLearnTaskUser);
                    }
                }
                this.updateLearUserStatus(schedule.getShiftId(), userId);
            }
        }
    }

    @Override
    public Map<String, Object> getShowDetail(Integer userId, Integer shiftId) {
        HashMap map = Maps.newHashMap();
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(TrainingLearnUser::getUserId, (Object)userId);
        ((LambdaQueryWrapper)wrapper.eq(TrainingLearnUser::getShiftId, (Object)shiftId)).eq(TrainingLearnUser::getIsDelete, (Object)0);
        List list = this.trainingLearnUserMapper.selectList((Wrapper)wrapper);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return map;
        }
        TrainingLearnUser learnUser = (TrainingLearnUser)list.get(0);
        if (learnUser.getShowed() == 1) {
            return map;
        }
        if (Objects.nonNull(learnUser.getPassStatus()) && learnUser.getPassStatus() == 1) {
            TrainingCertificateDetail certificateDetail;
            String title = "";
            String url = "";
            Integer certificateId = learnUser.getCertificateId();
            if (Objects.nonNull(certificateId) && Objects.nonNull(certificateDetail = (TrainingCertificateDetail)this.certificateDetailMapper.selectById(certificateId))) {
                url = certificateDetail.getUrl();
                TrainingCertificate trainingCertificate = (TrainingCertificate)this.certificateMapper.selectById(certificateDetail.getCertificateId());
                if (Objects.nonNull(trainingCertificate)) {
                    title = trainingCertificate.getCertificateName();
                }
            }
            map.put("type", "allPass");
            map.put("title", title);
            map.put("url", url);
        } else {
            List<AppTrainingTaskStatusVo> taskStatus = this.trainingLearnTaskUserMapper.selectMyTasksStatus(userId, shiftId);
            int count = 0;
            int finishNum = 0;
            for (AppTrainingTaskStatusVo vo : taskStatus) {
                Integer taskType = vo.getTaskType();
                if (ProjectTaskTypeEnum.COURSE.getKey().equals(taskType) || ProjectTaskTypeEnum.MATERIAL.getKey().equals(taskType)) {
                    ++count;
                    if (vo.getTaskStatus() != 4) continue;
                    ++finishNum;
                    continue;
                }
                if (ProjectTaskTypeEnum.EXAM.getKey().equals(taskType)) {
                    ++count;
                    if (vo.getTaskStatus() != 2 && vo.getTaskStatus() != 3 && vo.getTaskStatus() != 4) continue;
                    ++finishNum;
                    continue;
                }
                if (ProjectTaskTypeEnum.OFFLINE.getKey().equals(taskType)) {
                    ++count;
                    LambdaQueryWrapper endAttendWrapper = new LambdaQueryWrapper();
                    endAttendWrapper.eq(TrainingLearnEndAttend::getTaskUserId, (Object)vo.getTaskUserId());
                    List endAttends = this.trainingLearnEndAttendMapper.selectList((Wrapper)endAttendWrapper);
                    if (CollectionUtils.isEmpty((Collection)endAttends)) continue;
                    ++finishNum;
                    continue;
                }
                if (!ProjectTaskTypeEnum.WORK.getKey().equals(taskType)) continue;
                ++count;
                if (vo.getTaskStatus() != 2 && vo.getTaskStatus() != 3 && vo.getTaskStatus() != 4) continue;
                ++finishNum;
            }
            if (count == finishNum) {
                map.put("type", "allFinish");
            }
        }
        if (Objects.nonNull(map.get("type"))) {
            learnUser.setShowed(Integer.valueOf(1));
            this.trainingLearnUserMapper.updateById(learnUser);
        }
        return map;
    }

    @Override
    public void updateScore(Integer paperId, Integer userId) {
        TrainingPaper paper;
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(TrainingTaskSchedule::getPaperId, (Object)paperId);
        TrainingTaskSchedule schedule = (TrainingTaskSchedule)this.trainingTaskScheduleMapper.selectOne((Wrapper)wrapper);
        if (Objects.nonNull(schedule) && Objects.nonNull(paper = (TrainingPaper)this.trainingPaperMapper.selectById(paperId))) {
            TrainingExam trainingExam = (TrainingExam)this.trainingExamMapper.selectById(paper.getExamId());
            BigDecimal score = org.springframework.util.StringUtils.isEmpty((Object)trainingExam) ? new BigDecimal(100) : trainingExam.getScore();
            Integer passLine = paper.getPassLine();
            Double passLineScore = score.multiply(new BigDecimal(passLine)).divide(new BigDecimal(100), 2, 4).doubleValue();
            Integer scoreSelect = Objects.isNull(paper.getScoreSelect()) ? 1 : paper.getScoreSelect();
            BigDecimal finialScore = null;
            List<Object> paperList = this.trainingUserPaperMapper.selectByUserIdAndPaperIdById(userId, paperId);
            if (!CollectionUtils.isEmpty(paperList = paperList.stream().filter(a -> Objects.nonNull(a.getSubmitTime()) && Objects.nonNull(a.getUpdateTime())).collect(Collectors.toList()))) {
                finialScore = scoreSelect == 0 ? paperList.stream().max(Comparator.comparing(TrainingUserPaper::getScore)).get().getScore() : (scoreSelect == 1 ? ((TrainingUserPaper)paperList.get(0)).getScore() : ((TrainingUserPaper)paperList.get(paperList.size() - 1)).getScore());
                long totalMs = 0L;
                for (TrainingUserPaper trainingUserPaper : paperList) {
                    totalMs += trainingUserPaper.getSubmitTime().getTime() - trainingUserPaper.getUpdateTime().getTime();
                }
                Integer avg = Math.toIntExact(totalMs / 1000L / (long)paperList.size());
                this.trainingLearnTaskUserMapper.updateLearnTaskScoreOrRate(schedule.getId(), userId, null, finialScore, finialScore.doubleValue() >= passLineScore ? 4 : 3, new Date(), avg);
                this.updateLearUserStatus(schedule.getShiftId(), userId);
            }
        }
    }

    @Override
    public void updateLearUserStatus(Integer shiftId, Integer userId) {
        Date now = new Date();
        TrainingLearnShift shift = (TrainingLearnShift)this.shiftMapper.selectById(shiftId);
        if (ObjectUtils.isEmpty((Object)shift)) {
            return;
        }
        TrainingLearnProject project = (TrainingLearnProject)this.trainingLearnProjectMapper.selectById(shift.getProjectId());
        if (ObjectUtils.isEmpty((Object)project)) {
            return;
        }
        HashSet<Integer> set = new HashSet<Integer>();
        set.add(shiftId);
        List<Object> list = new ArrayList();
        list = project.getStudyType() == 2 ? this.trainingLearnTaskUserMapper.selectSummaryFinishNum(set, userId) : this.trainingLearnTaskUserMapper.summaryFinishNum(set, userId);
        LambdaQueryWrapper wrapper0 = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper0.eq(TrainingLearnUser::getUserId, (Object)userId)).eq(TrainingLearnUser::getShiftId, (Object)shiftId)).eq(TrainingLearnUser::getIsDelete, (Object)0)).orderByDesc(TrainingLearnUser::getId)).last(" limit 1 ");
        TrainingLearnUser learnUsers = (TrainingLearnUser)this.trainingLearnUserMapper.selectOne((Wrapper)wrapper0);
        if (!ObjectUtils.isEmpty((Object)learnUsers)) {
            if (org.springframework.util.StringUtils.isEmpty((Object)learnUsers.getStartTime())) {
                learnUsers.setStartTime(new Date());
                learnUsers.setLearnStatus(Integer.valueOf(2));
                this.trainingLearnUserMapper.updateById(learnUsers);
            }
        } else {
            learnUsers = new TrainingLearnUser();
            learnUsers.setLearnStatus(Integer.valueOf(2));
            learnUsers.setIsDelete(Integer.valueOf(0));
            learnUsers.setUserId(userId);
            learnUsers.setStartTime(now);
            learnUsers.setCreateTime(now);
            learnUsers.setShiftId(shiftId);
            learnUsers.setEnterpriseId(project.getEnterpriseId());
            learnUsers.setExecutorId(userId);
            this.trainingLearnUserMapper.insert(learnUsers);
        }
        if (!CollectionUtils.isEmpty(list)) {
            AppTrainingTaskNumVo taskNumVo = (AppTrainingTaskNumVo)list.get(0);
            if (taskNumVo.getTotalNum().equals(taskNumVo.getFinishNum())) {
                LambdaQueryWrapper wrapper2;
                Integer learnStatus = 3;
                LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper1.eq(TrainingLearnTaskUser::getShiftId, (Object)shiftId)).eq(TrainingLearnTaskUser::getUserId, (Object)userId)).in(TrainingLearnTaskUser::getTaskStatus, Arrays.asList(3, 4))).isNotNull(TrainingLearnTaskUser::getScore);
                List taskUserList = this.trainingLearnTaskUserMapper.selectList((Wrapper)wrapper1);
                Integer passStatus = 0;
                BigDecimal scores = null;
                if (!CollectionUtils.isEmpty((Collection)taskUserList)) {
                    wrapper2 = new LambdaQueryWrapper();
                    ((LambdaQueryWrapper)wrapper2.eq(TrainingTaskSchedule::getShiftId, (Object)shiftId)).isNotNull(TrainingTaskSchedule::getTaskRate);
                    List scheduleList = this.trainingTaskScheduleMapper.selectList((Wrapper)wrapper2);
                    if (!CollectionUtils.isEmpty((Collection)scheduleList)) {
                        Map scheduleMap = scheduleList.stream().collect(Collectors.toMap(TrainingTaskSchedule::getId, Function.identity()));
                        BigDecimal score = BigDecimal.ZERO;
                        BigDecimal totalScore = BigDecimal.ZERO;
                        for (TrainingLearnTaskUser taskUser : taskUserList) {
                            TrainingTaskSchedule schedule = (TrainingTaskSchedule)scheduleMap.get(taskUser.getProjectTaskScheduleId());
                            if (ObjectUtils.isEmpty((Object)schedule)) continue;
                            if (!org.springframework.util.StringUtils.isEmpty((Object)schedule.getTaskRate())) {
                                score = taskUser.getScore().multiply(schedule.getTaskRate()).multiply(BigDecimal.valueOf(0.01)).add(score).setScale(1, 4);
                            }
                            if (org.springframework.util.StringUtils.isEmpty((Object)schedule.getTaskRate()) || org.springframework.util.StringUtils.isEmpty((Object)schedule.getFullScore())) continue;
                            totalScore = schedule.getFullScore().multiply(schedule.getTaskRate()).multiply(new BigDecimal(0.01)).add(totalScore).setScale(1, 4);
                        }
                        if (!ObjectUtils.isEmpty((Object)project) && !org.springframework.util.StringUtils.isEmpty((Object)project.getPassRate()) && score.compareTo(totalScore.multiply(project.getPassRate()).multiply(new BigDecimal("0.01"))) >= 0) {
                            passStatus = 1;
                        }
                        scores = score;
                    }
                }
                if (project.getStudyType() == 1) {
                    passStatus = 1;
                }
                if (passStatus == 1 && !org.springframework.util.StringUtils.isEmpty((Object)project.getCertificateId()) && learnUsers.getCertificateId() == null && !org.springframework.util.StringUtils.isEmpty((Object)project.getIsGet()) && project.getIsGet() == 1) {
                    Integer certificateDetailId = this.jobCertificationService.saveCertificateDetail(project.getCertificateId(), project.getCertificatePath(), userId, project.getCreater(), 3, project.getProjectName());
                    learnUsers.setCertificateId(certificateDetailId);
                }
                if (!ObjectUtils.isEmpty((Object)learnUsers)) {
                    learnUsers.setScore(scores);
                    learnUsers.setLearnStatus(learnStatus);
                    learnUsers.setPassStatus(passStatus);
                    learnUsers.setEndTime(now);
                    this.trainingLearnUserMapper.updateById(learnUsers);
                }
                this.getGoldByPass(userId, shift, passStatus, project);
                if (passStatus == 1) {
                    this.jPush(shiftId, userId, passStatus, learnUsers, project, shift);
                }
                if (!ObjectUtils.isEmpty((Object)shift) && !org.springframework.util.StringUtils.isEmpty((Object)shift.getStatus()) && shift.getStatus() < ProjectShiftStatusEnum.WAIT_END.getKey()) {
                    wrapper2 = new LambdaQueryWrapper();
                    ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper2.eq(TrainingLearnUser::getShiftId, (Object)shiftId)).and(wq -> {
                        LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wq.isNull(TrainingLearnUser::getPassStatus)).or()).eq(TrainingLearnUser::getPassStatus, (Object)0);
                    })).eq(TrainingLearnUser::getIsDelete, (Object)0);
                    List learnUserLists = this.trainingLearnUserMapper.selectList((Wrapper)wrapper2);
                    if (CollectionUtils.isEmpty((Collection)learnUserLists)) {
                        TrainingLearnShift learnShift = new TrainingLearnShift();
                        learnShift.setId(shiftId);
                        learnShift.setStatus(ProjectShiftStatusEnum.WAIT_END.getKey());
                        this.shiftMapper.updateById(learnShift);
                    }
                }
            } else {
                this.trainingLearnUserMapper.updateTaskUnFinishStatus(shiftId, userId);
            }
        }
    }

    private void jPush(Integer shiftId, Integer userId, Integer passStatus, TrainingLearnUser learnUsers, TrainingLearnProject project, TrainingLearnShift shift) {
        LambdaQueryWrapper wrapper6 = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper6.eq(TrainingLearnExamine::getUserId, (Object)userId)).eq(TrainingLearnExamine::getShiftId, (Object)shiftId)).and(wq -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wq.eq(TrainingLearnExamine::getIsAuto, (Object)1)).or()).eq(TrainingLearnExamine::getPassStatus, (Object)1);
        });
        List trainingLearnExamineList = this.examineMapper.selectList((Wrapper)wrapper6);
        if (CollectionUtils.isEmpty((Collection)trainingLearnExamineList)) {
            TrainingLearnExamine examine = new TrainingLearnExamine();
            examine.setPassStatus(passStatus);
            examine.setUserId(userId);
            examine.setShiftId(shiftId);
            examine.setLearnUserId(learnUsers.getId());
            examine.setIsAuto(Integer.valueOf(0));
            examine.setCreateTime(new Date());
            examine.setEnterpriseId(project.getEnterpriseId());
            this.examineMapper.insert(examine);
            TaskMessageBody body = new TaskMessageBody();
            body.setType(95);
            HashMap msg = Maps.newHashMap();
            String shiftName = org.springframework.util.StringUtils.isEmpty((Object)shift.getSupplemenName()) ? MessageFormat.format("{0}-{1}", shift.getShiftName(), shift.getGroupName()) : MessageFormat.format("{0}-{1}-{2}", shift.getShiftName(), shift.getGroupName(), shift.getSupplemenName());
            msg.put("projectId", shift.getProjectId());
            msg.put("shiftId", shift.getId());
            String learnTitle = "\u5b66\u4e60\u9879\u76ee";
            msg.put("title", learnTitle);
            body.setTaskJson(JSONObject.toJSONString((Object)msg));
            TrainingCertificate trainingCertificate = (TrainingCertificate)this.certificateMapper.selectById(project.getCertificateId());
            String title = "";
            if (Objects.nonNull(trainingCertificate)) {
                title = trainingCertificate.getCertificateName();
            }
            if (org.springframework.util.StringUtils.isEmpty((Object)title)) {
                String passExam = "\u606d\u559c\u4f60\u901a\u8fc7\u4e86\u300a{0}\u300b\u57f9\u8bad\uff0c\u70b9\u51fb\u67e5\u770b\u8be6\u60c5~";
                this.jPushService.sendWebSocket(learnTitle, MessageFormat.format(passExam, shiftName), userId, project.getEnterpriseId(), shift.getId(), "TYPE_TRAINING_PASS_TYPE", JSONObject.toJSONString((Object)msg), null, 1, 0, "training.learn.pass.exam", shiftName);
                this.jPushService.pushNotification(JPush.MASSAGE_TYPE_NOTIFY, "TYPE_TRAINING_PASS_TYPE", userId, learnTitle, MessageFormat.format(passExam, shiftName), body);
            } else {
                String passExamCert = "\u606d\u559c\u4f60\u901a\u8fc7\u4e86\u300a{0}\u300b\u57f9\u8bad\uff0c\u83b7\u5f97\u4e86\u300a{1}\u300b\u8bc1\u4e66\uff0c\u70b9\u51fb\u67e5\u770b\u8be6\u60c5~";
                this.jPushService.sendWebSocket(learnTitle, MessageFormat.format(passExamCert, shiftName, title), userId, project.getEnterpriseId(), shift.getId(), "TYPE_TRAINING_PASS_TYPE", JSONObject.toJSONString((Object)msg), null, 1, 0, "training.learn.pass.exam.cert", shiftName + "," + title);
                this.jPushService.pushNotification(JPush.MASSAGE_TYPE_NOTIFY, "TYPE_TRAINING_PASS_TYPE", userId, learnTitle, MessageFormat.format(passExamCert, shiftName, title), body);
            }
        }
        this.jPushService.deleteMessages(shift.getId(), "TYPE_TRAINING_SHIFT_TYPE", userId, null, 1);
    }

    private void getGoldByPass(Integer userId, TrainingLearnShift shift, Integer passStatus, TrainingLearnProject project) {
        LambdaQueryWrapper trainingGoldLogLambdaQueryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)trainingGoldLogLambdaQueryWrapper.eq(TrainingGoldLog::getProjectId, (Object)shift.getId())).eq(TrainingGoldLog::getUserId, (Object)userId)).eq(TrainingGoldLog::getType, (Object)ConstantsUtil.TrainingGoldLogTypeCode.LEARN_PROJECT);
        TrainingGoldLog goldLog = (TrainingGoldLog)this.trainingGoldLogMapper.selectOne((Wrapper)trainingGoldLogLambdaQueryWrapper);
        if (passStatus == 1 && project.getAwardGold() != 0 && ObjectUtils.isEmpty((Object)goldLog)) {
            com.ovopark.pojo.BaseResult goldBase;
            TrainingGoldLog trainingGoldLog = new TrainingGoldLog();
            UsersPojo usersPojo = (UsersPojo)this.userApi.getUserById(userId).getData();
            trainingGoldLog.setUserId(userId);
            trainingGoldLog.setProjectId(shift.getId());
            trainingGoldLog.setUserName(usersPojo.getUserName());
            trainingGoldLog.setType(ConstantsUtil.TrainingGoldLogTypeCode.LEARN_PROJECT);
            trainingGoldLog.setDescription("\u5b66\u4e60\u9879\u76ee\u5b8c\u6210-" + project.getProjectName() + "-" + shift.getShiftName());
            trainingGoldLog.setGoldNum(project.getAwardGold());
            trainingGoldLog.setResult(Integer.valueOf(1));
            trainingGoldLog.setCreateTime(new Date());
            String shiftName = shift.getShiftName();
            if (!org.springframework.util.StringUtils.isEmpty((Object)shift.getGroupName())) {
                shiftName = shiftName + "-" + shift.getGroupName();
            }
            if (!org.springframework.util.StringUtils.isEmpty((Object)shift.getSupplemenName())) {
                shiftName = shiftName + "-" + shift.getSupplemenName();
            }
            if ((goldBase = this.goldApi.addUserGoldWithTypeId(shift.getEnterpriseId(), project.getAwardGold(), "\u5b66\u4e60\u9879\u76ee\u5b8c\u6210-" + shiftName + "\uff0c\u91d1\u5e01+" + project.getAwardGold(), userId.toString(), Integer.valueOf(7), project.getId())).getIsError().booleanValue()) {
                trainingGoldLog.setResult(Integer.valueOf(0));
            }
            this.trainingGoldLogMapper.insert(trainingGoldLog);
        }
    }

    @Override
    public AppTrainingProjectVo selectProjectById(Integer projectId, Integer shiftId, Integer userId) {
        TrainingCertificateDetail certificateDetail;
        Integer certificateId;
        TrainingLearnProject project = (TrainingLearnProject)this.trainingLearnProjectMapper.selectById(projectId);
        AppTrainingProjectVo appTrainingProjectVo = new AppTrainingProjectVo();
        BigDecimal totalScore = new BigDecimal(0);
        if (Objects.nonNull(project)) {
            List leaders;
            BaseResult base;
            BeanUtils.copyProperties((Object)project, (Object)appTrainingProjectVo);
            LambdaQueryWrapper wrappers1 = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)wrappers1.eq(TrainingLearnManager::getManagerType, (Object)1)).eq(TrainingLearnManager::getProjectId, (Object)projectId);
            List leaderList = this.learnManagerMapper.selectList((Wrapper)wrappers1);
            LambdaQueryWrapper wrappers2 = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)wrappers2.eq(TrainingLearnManager::getManagerType, (Object)3)).eq(TrainingLearnManager::getShiftId, (Object)shiftId);
            List managerList = this.learnManagerMapper.selectList((Wrapper)wrappers2);
            appTrainingProjectVo.setCertificatePath(null);
            if (!CollectionUtils.isEmpty((Collection)leaderList) && (base = this.userApi.getUserByIdList(leaders = leaderList.stream().map(TrainingLearnManager::getUserId).filter(Objects::nonNull).distinct().collect(Collectors.toList()))) != null && !CollectionUtils.isEmpty((Collection)((Collection)base.getData()))) {
                List userPojoList = (List)base.getData();
                ArrayList<Users> users = new ArrayList<Users>();
                for (Object pojo : userPojoList) {
                    Users user = new Users();
                    BeanUtils.copyProperties((Object)pojo, (Object)user);
                    users.add(user);
                }
                appTrainingProjectVo.setLeaderList(users);
            }
            if (!CollectionUtils.isEmpty((Collection)managerList)) {
                BaseResult base2;
                String roleIdStr;
                com.ovopark.privilege.response.BaseResult baseResult;
                List roles;
                ArrayList managerUsers = new ArrayList();
                List leaders2 = managerList.stream().map(TrainingLearnManager::getUserId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
                if (!CollectionUtils.isEmpty(leaders2)) {
                    managerUsers.addAll(leaders2);
                }
                if (!CollectionUtils.isEmpty(roles = managerList.stream().map(TrainingLearnManager::getRoleId).filter(Objects::nonNull).distinct().collect(Collectors.toList())) && (baseResult = this.useApi.getUserByRoleIds(roleIdStr = StringUtils.join(roles, (String)","), project.getEnterpriseId())) != null && !CollectionUtils.isEmpty((Collection)((Collection)baseResult.getData()))) {
                    Object pojo;
                    pojo = ((List)baseResult.getData()).stream().map(com.ovopark.privilege.pojo.UsersPojo::getId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
                    managerUsers.addAll(pojo);
                }
                if ((base2 = this.userApi.getUserByIdList(managerUsers)) != null && !CollectionUtils.isEmpty((Collection)((Collection)base2.getData()))) {
                    List userPojoList = (List)base2.getData();
                    ArrayList<Users> users = new ArrayList<Users>();
                    for (UsersPojo pojo : userPojoList) {
                        Users user = new Users();
                        BeanUtils.copyProperties((Object)pojo, (Object)user);
                        users.add(user);
                    }
                    appTrainingProjectVo.setManagerList(users);
                }
            }
            LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)wrapper1.eq(TrainingProjectTask::getProjectId, (Object)projectId)).in(TrainingProjectTask::getTaskType, Arrays.asList(2, 3, 6));
            List tasks = this.trainingProjectTaskMapper.selectList((Wrapper)wrapper1);
            if (!CollectionUtils.isEmpty((Collection)tasks)) {
                List taskIds = tasks.stream().map(TrainingProjectTask::getId).distinct().collect(Collectors.toList());
                LambdaQueryWrapper wrapper2 = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)wrapper2.in(TrainingTaskSchedule::getTaskId, taskIds)).isNull(TrainingTaskSchedule::getShiftId);
                List taskScheduleList = this.trainingTaskScheduleMapper.selectList((Wrapper)wrapper2);
                for (TrainingTaskSchedule schedule : taskScheduleList) {
                    if (org.springframework.util.StringUtils.isEmpty((Object)schedule.getFullScore()) || org.springframework.util.StringUtils.isEmpty((Object)schedule.getTaskRate())) continue;
                    totalScore = totalScore.add(schedule.getFullScore().multiply(schedule.getTaskRate()).multiply(BigDecimal.valueOf(0.01))).setScale(1, 4);
                }
            }
        }
        appTrainingProjectVo.setTotalScore(totalScore);
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(TrainingLearnUser::getShiftId, (Object)shiftId);
        ((LambdaQueryWrapper)wrapper.eq(TrainingLearnUser::getUserId, (Object)userId)).eq(TrainingLearnUser::getIsDelete, (Object)0);
        TrainingLearnUser trainingLearnUser = (TrainingLearnUser)this.trainingLearnUserMapper.selectOne((Wrapper)wrapper);
        if (Objects.nonNull(trainingLearnUser) && Objects.nonNull(certificateId = trainingLearnUser.getCertificateId()) && Objects.nonNull(certificateDetail = (TrainingCertificateDetail)this.certificateDetailMapper.selectById(certificateId))) {
            appTrainingProjectVo.setCertificatePath(certificateDetail.getUrl());
        }
        return appTrainingProjectVo;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public String clickTask(Integer shiftId, Integer taskId, Integer userId) {
        Locale locale = Authenticator.getInstance().getCurrentClient().getLocale();
        TrainingProjectTask task = (TrainingProjectTask)this.trainingProjectTaskMapper.selectById(taskId);
        if (ObjectUtils.isEmpty((Object)task)) return JsonResult.error((String)this.messageSource.getMessage("training.learn.task.noexist", null, locale), null);
        Integer taskType = task.getTaskType();
        if (ProjectTaskTypeEnum.COURSE.getKey().equals(taskType)) {
            AppStatusVo appStatusVo = this.trainingLearnProjectMapper.getStatusByShiftId(shiftId);
            if (ObjectUtils.isEmpty((Object)appStatusVo)) return JsonResult.error((String)this.messageSource.getMessage("training.learn.project.absent", null, locale), null);
            if (appStatusVo.getIsNoTimeLimit() != null && appStatusVo.getIsNoTimeLimit() == 1) {
                appStatusVo.setEndTime(null);
            }
            if (2 == appStatusVo.getProjectStatus() || ProjectShiftStatusEnum.ENDED.getKey().equals(appStatusVo.getShiftStatus())) {
                return JsonResult.error((String)this.messageSource.getMessage("training.course.ended", null, locale), null);
            }
            if (Objects.nonNull(appStatusVo.getEndTime()) && appStatusVo.getEndTime().before(new Date())) {
                return JsonResult.error((String)this.messageSource.getMessage("training.learn.task.ended", null, locale), null);
            }
            LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
            wrapper.eq(TrainingTaskSchedule::getTaskId, (Object)taskId);
            wrapper.eq(TrainingTaskSchedule::getShiftId, (Object)shiftId);
            TrainingTaskSchedule trainingTaskSchedule = (TrainingTaskSchedule)this.trainingTaskScheduleMapper.selectOne((Wrapper)wrapper);
            if (ObjectUtils.isEmpty((Object)trainingTaskSchedule)) return JsonResult.error((String)this.messageSource.getMessage("training.learn.scheduling.absent", null, locale), null);
            if (Objects.nonNull(trainingTaskSchedule.getEndTime()) && trainingTaskSchedule.getEndTime().before(new Date())) {
                return JsonResult.error((String)this.messageSource.getMessage("training.learn.task.ended", null, locale), null);
            }
            if (Objects.nonNull(trainingTaskSchedule.getStartTime()) && trainingTaskSchedule.getStartTime().after(new Date())) {
                LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
                wrapper1.eq(TrainingLearnTaskUser::getProjectTaskScheduleId, (Object)trainingTaskSchedule.getId());
                ((LambdaQueryWrapper)wrapper1.eq(TrainingLearnTaskUser::getUserId, (Object)userId)).orderByDesc(TrainingLearnTaskUser::getId);
                List trainingLearnTaskUserList = this.trainingLearnTaskUserMapper.selectList((Wrapper)wrapper1);
                if (CollectionUtils.isEmpty((Collection)trainingLearnTaskUserList)) return JsonResult.error((String)this.messageSource.getMessage("training.learn.task.absent", null, locale), null);
                TrainingLearnTaskUser trainingLearnTaskUser = (TrainingLearnTaskUser)trainingLearnTaskUserList.get(0);
                if (trainingLearnTaskUser.getTaskStatus() == 0) return JsonResult.error((String)this.messageSource.getMessage("training.learn.task.nostart", null, locale), null);
                return JsonResult.error((String)this.messageSource.getMessage("training.learn.task.time.change", null, locale), null);
            }
        } else if (ProjectTaskTypeEnum.EXAM.getKey().equals(taskType)) {
            AppStatusVo appStatusVo = this.trainingLearnProjectMapper.getStatusByShiftId(shiftId);
            if (ObjectUtils.isEmpty((Object)appStatusVo)) return JsonResult.error((String)this.messageSource.getMessage("training.learn.project.absent", null, locale), null);
            if (appStatusVo.getIsNoTimeLimit() != null && appStatusVo.getIsNoTimeLimit() == 1) {
                appStatusVo.setEndTime(null);
            }
            if (2 == appStatusVo.getProjectStatus() || ProjectShiftStatusEnum.ENDED.getKey().equals(appStatusVo.getShiftStatus())) {
                return JsonResult.error((String)this.messageSource.getMessage("training.paper.ended", null, locale), null);
            }
            if (Objects.nonNull(appStatusVo.getEndTime()) && appStatusVo.getEndTime().before(new Date())) {
                return JsonResult.error((String)this.messageSource.getMessage("training.learn.project.expired", null, locale), null);
            }
            LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
            wrapper.eq(TrainingTaskSchedule::getTaskId, (Object)taskId);
            wrapper.eq(TrainingTaskSchedule::getShiftId, (Object)shiftId);
            TrainingTaskSchedule trainingTaskSchedule = (TrainingTaskSchedule)this.trainingTaskScheduleMapper.selectOne((Wrapper)wrapper);
            if (!ObjectUtils.isEmpty((Object)trainingTaskSchedule)) {
                if (Objects.nonNull(trainingTaskSchedule.getEndTime()) && trainingTaskSchedule.getEndTime().before(new Date())) {
                    return JsonResult.error((String)this.messageSource.getMessage("training.learn.project.expired", null, locale), null);
                }
                if (Objects.nonNull(trainingTaskSchedule.getStartTime()) && trainingTaskSchedule.getStartTime().after(new Date())) {
                    LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
                    wrapper1.eq(TrainingLearnTaskUser::getProjectTaskScheduleId, (Object)trainingTaskSchedule.getId());
                    ((LambdaQueryWrapper)wrapper1.eq(TrainingLearnTaskUser::getUserId, (Object)userId)).orderByDesc(TrainingLearnTaskUser::getId);
                    List trainingLearnTaskUserList = this.trainingLearnTaskUserMapper.selectList((Wrapper)wrapper1);
                    if (CollectionUtils.isEmpty((Collection)trainingLearnTaskUserList)) return JsonResult.error((String)this.messageSource.getMessage("training.learn.task.absent", null, locale), null);
                    TrainingLearnTaskUser trainingLearnTaskUser = (TrainingLearnTaskUser)trainingLearnTaskUserList.get(0);
                    if (trainingLearnTaskUser.getTaskStatus() == 0) return JsonResult.error((String)this.messageSource.getMessage("training.learn.task.nostart", null, locale), null);
                    return JsonResult.error((String)this.messageSource.getMessage("training.learn.task.paper.change", null, locale), null);
                }
            }
        } else if (ProjectTaskTypeEnum.OFFLINE.getKey().equals(taskType)) {
            LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
            wrapper.eq(TrainingTaskSchedule::getTaskId, (Object)taskId);
            wrapper.eq(TrainingTaskSchedule::getShiftId, (Object)shiftId);
            ((LambdaQueryWrapper)wrapper.orderByDesc(TrainingTaskSchedule::getId)).last(" limit 1 ");
            TrainingTaskSchedule trainingTaskSchedule = (TrainingTaskSchedule)this.trainingTaskScheduleMapper.selectOne((Wrapper)wrapper);
            if (ObjectUtils.isEmpty((Object)trainingTaskSchedule)) return JsonResult.error((String)this.messageSource.getMessage("training.learn.scheduling.absent", null, locale), null);
            if (Objects.isNull(trainingTaskSchedule.getStartTime()) || Objects.isNull(trainingTaskSchedule.getEndTime()) || org.springframework.util.StringUtils.isEmpty((Object)trainingTaskSchedule.getTaskPlace())) {
                return JsonResult.error((String)this.messageSource.getMessage("training.activity.noscheduling", null, locale), null);
            }
        } else if (ProjectTaskTypeEnum.MATERIAL.getKey().equals(taskType)) {
            LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
            wrapper.eq(TrainingTaskSchedule::getTaskId, (Object)taskId);
            wrapper.eq(TrainingTaskSchedule::getShiftId, (Object)shiftId);
            TrainingTaskSchedule trainingTaskSchedule = (TrainingTaskSchedule)this.trainingTaskScheduleMapper.selectOne((Wrapper)wrapper);
            if (trainingTaskSchedule != null) {
                AppStatusVo appStatusVo;
                LambdaQueryWrapper taskWrapper = new LambdaQueryWrapper();
                taskWrapper.eq(TrainingLearnTaskUser::getShiftId, (Object)shiftId);
                taskWrapper.eq(TrainingLearnTaskUser::getProjectTaskScheduleId, (Object)trainingTaskSchedule.getId());
                ((LambdaQueryWrapper)taskWrapper.eq(TrainingLearnTaskUser::getUserId, (Object)userId)).orderByDesc(TrainingLearnTaskUser::getId);
                List taskUserList = this.trainingLearnTaskUserMapper.selectList((Wrapper)taskWrapper);
                if (!CollectionUtils.isEmpty((Collection)taskUserList) && ((TrainingLearnTaskUser)taskUserList.get(0)).getStartTime() == null) {
                    TrainingLearnTaskUser taskUser = (TrainingLearnTaskUser)taskUserList.get(0);
                    taskUser.setStartTime(new Date());
                    this.trainingLearnTaskUserMapper.updateById(taskUser);
                }
                if ((appStatusVo = this.trainingLearnProjectMapper.getStatusByShiftId(shiftId)).getIsNoTimeLimit() != null && appStatusVo.getIsNoTimeLimit() == 1) {
                    appStatusVo.setEndTime(null);
                }
                if (2 == appStatusVo.getProjectStatus() || ProjectShiftStatusEnum.ENDED.getKey().equals(appStatusVo.getShiftStatus())) {
                    return JsonResult.error((String)this.messageSource.getMessage("training.learn.ended", null, locale), null);
                }
                if (Objects.nonNull(trainingTaskSchedule.getEndTime()) && trainingTaskSchedule.getEndTime().before(new Date())) {
                    return JsonResult.error((String)this.messageSource.getMessage("training.learn.task.ended", null, locale), null);
                }
                if (Objects.nonNull(appStatusVo.getEndTime()) && appStatusVo.getEndTime().before(new Date())) {
                    return JsonResult.error((String)this.messageSource.getMessage("training.learn.project.expire", null, locale), null);
                }
                if (Objects.nonNull(trainingTaskSchedule.getStartTime()) && trainingTaskSchedule.getStartTime().after(new Date())) {
                    LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
                    wrapper1.eq(TrainingLearnTaskUser::getProjectTaskScheduleId, (Object)trainingTaskSchedule.getId());
                    wrapper1.eq(TrainingLearnTaskUser::getUserId, (Object)userId);
                    TrainingLearnTaskUser trainingLearnTaskUser = (TrainingLearnTaskUser)this.trainingLearnTaskUserMapper.selectOne((Wrapper)wrapper1);
                    if (org.springframework.util.StringUtils.isEmpty((Object)trainingLearnTaskUser)) return JsonResult.error((String)this.messageSource.getMessage("training.learn.task.absent", null, locale), null);
                    if (trainingLearnTaskUser.getTaskStatus() == 0) return JsonResult.error((String)this.messageSource.getMessage("training.learn.task.nostart", null, locale), null);
                    return JsonResult.error((String)this.messageSource.getMessage("training.learn.task.paper.change", null, locale), null);
                }
            }
        } else if (ProjectTaskTypeEnum.WORK.getKey().equals(taskType)) {
            AppStatusVo appStatusVo = this.trainingLearnProjectMapper.getStatusByShiftId(shiftId);
            if (ObjectUtils.isEmpty((Object)appStatusVo)) return JsonResult.error((String)this.messageSource.getMessage("training.learn.project.absent", null, locale), null);
            if (appStatusVo.getIsNoTimeLimit() != null && appStatusVo.getIsNoTimeLimit() == 1) {
                appStatusVo.setEndTime(null);
            }
            if (2 == appStatusVo.getProjectStatus() || ProjectShiftStatusEnum.ENDED.getKey().equals(appStatusVo.getShiftStatus())) {
                return JsonResult.error((String)this.messageSource.getMessage("training.learn.project.ended", null, locale), null);
            }
            LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
            wrapper.eq(TrainingTaskSchedule::getTaskId, (Object)taskId);
            wrapper.eq(TrainingTaskSchedule::getShiftId, (Object)shiftId);
            ((LambdaQueryWrapper)wrapper.orderByDesc(TrainingTaskSchedule::getId)).last(" limit 1 ");
            TrainingTaskSchedule trainingTaskSchedule = (TrainingTaskSchedule)this.trainingTaskScheduleMapper.selectOne((Wrapper)wrapper);
            if (ObjectUtils.isEmpty((Object)trainingTaskSchedule)) return JsonResult.error((String)this.messageSource.getMessage("training.learn.scheduling.absent", null, locale), null);
            if (!org.springframework.util.StringUtils.isEmpty((Object)trainingTaskSchedule.getStartTime()) && trainingTaskSchedule.getStartTime().after(new Date())) {
                LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
                wrapper1.eq(TrainingLearnTaskUser::getProjectTaskScheduleId, (Object)trainingTaskSchedule.getId());
                ((LambdaQueryWrapper)wrapper1.eq(TrainingLearnTaskUser::getUserId, (Object)userId)).orderByDesc(TrainingLearnTaskUser::getId);
                List trainingLearnTaskUserList = this.trainingLearnTaskUserMapper.selectList((Wrapper)wrapper1);
                if (CollectionUtils.isEmpty((Collection)trainingLearnTaskUserList)) return JsonResult.error((String)this.messageSource.getMessage("training.learn.task.absent", null, locale), null);
                TrainingLearnTaskUser trainingLearnTaskUser = (TrainingLearnTaskUser)trainingLearnTaskUserList.get(0);
                if (ObjectUtils.isEmpty((Object)trainingLearnTaskUser) || trainingLearnTaskUser.getTaskStatus() <= 1) return JsonResult.error((String)this.messageSource.getMessage("training.learn.task.nostart", null, locale), null);
                return JsonResult.error((String)this.messageSource.getMessage("training.learn.task.paper.chang", null, locale), null);
            }
        }
        if (!ProjectTaskTypeEnum.COURSE.getKey().equals(taskType) && !ProjectTaskTypeEnum.EXAM.getKey().equals(taskType)) return JsonResult.success();
        this.updateTaskStatus(shiftId, taskId, userId);
        return JsonResult.success();
    }

    public void updateTaskStatus(Integer shiftId, Integer taskId, Integer userId) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(TrainingTaskSchedule::getTaskId, (Object)taskId);
        ((LambdaQueryWrapper)wrapper.eq(TrainingTaskSchedule::getShiftId, (Object)shiftId)).orderByDesc(TrainingTaskSchedule::getId);
        List trainingTaskScheduleList = this.trainingTaskScheduleMapper.selectList((Wrapper)wrapper);
        if (!CollectionUtils.isEmpty((Collection)trainingTaskScheduleList)) {
            Integer trainingId;
            TrainingTaskSchedule trainingTaskSchedule = (TrainingTaskSchedule)trainingTaskScheduleList.get(0);
            this.trainingLearnTaskUserMapper.updateTaskDefaultStatus(trainingTaskSchedule.getId(), userId);
            this.trainingLearnUserMapper.updateTaskDefaultStatus(shiftId, userId);
            LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
            wrapper1.eq(TrainingLearnTaskUser::getProjectTaskScheduleId, (Object)trainingTaskSchedule.getId());
            wrapper1.eq(TrainingLearnTaskUser::getUserId, (Object)userId);
            wrapper1.orderByDesc(TrainingLearnTaskUser::getId);
            List taskUserList = this.trainingLearnTaskUserMapper.selectList((Wrapper)wrapper1);
            TrainingLearnTaskUser taskUser = new TrainingLearnTaskUser();
            if (!CollectionUtils.isEmpty((Collection)taskUserList)) {
                taskUser = (TrainingLearnTaskUser)taskUserList.get(0);
            }
            if (!org.springframework.util.StringUtils.isEmpty((Object)(trainingId = trainingTaskSchedule.getTrainingId())) && !ObjectUtils.isEmpty((Object)taskUser) && YesNoEnum.YES.getKey().equals(taskUser.getIsFirst())) {
                AppStatusVo appStatusVo = this.trainingLearnProjectMapper.getStatusByShiftId(shiftId);
                if (!org.springframework.util.StringUtils.isEmpty((Object)appStatusVo) && YesNoEnum.YES.getKey().equals(appStatusVo.getIsSynchro())) {
                    Integer trainingIdOld = trainingTaskSchedule.getTrainingIdOld();
                    if (org.springframework.util.StringUtils.isEmpty((Object)trainingIdOld)) {
                        return;
                    }
                    Integer syncTrainingId = this.trainingTaskScheduleMapper.getSyncTrainingId(userId, trainingIdOld, trainingId, appStatusVo.getProjectId());
                    if (Objects.isNull(syncTrainingId)) {
                        return;
                    }
                    Training training = (Training)this.trainingMapper.selectById(trainingId);
                    if (training.getIsChapter() == 1) {
                        List<TrainingChapterAttachUser> chapterAttachUsers = this.trainingChapterAttachUserMapper.selectAttachFinish(null, userId, syncTrainingId, null, null);
                        if (CollectionUtils.isEmpty(chapterAttachUsers)) {
                            return;
                        }
                        ArrayList<TrainingChapterAttachUser> insertList = new ArrayList<TrainingChapterAttachUser>();
                        for (TrainingChapterAttachUser trainingChapterAttachUser : chapterAttachUsers) {
                            TrainingChapterAttachUser attachUser = new TrainingChapterAttachUser();
                            BeanUtils.copyProperties((Object)trainingChapterAttachUser, (Object)attachUser);
                            attachUser.setId(null);
                            attachUser.setTrainingId(trainingId);
                            attachUser.setCreateTime(new Date());
                            Integer newChapterId = this.trainingChapterMapper.getNewChapterId(trainingChapterAttachUser.getChapterId(), trainingId);
                            attachUser.setChapterId(newChapterId);
                            Integer newAttachId = attachUser.getIsVideo() == 1 ? this.trainingChapterVideoMapper.getNewAttachId(attachUser.getAttachId(), newChapterId) : this.trainingChapterAttachMapper.getNewAttachId(attachUser.getAttachId(), newChapterId);
                            attachUser.setAttachId(newAttachId);
                            insertList.add(attachUser);
                        }
                        this.trainingChapterAttachUserMapper.deleteByTrainingAndUserId(trainingId, userId);
                        this.trainingChapterAttachUserMapper.insertList(insertList);
                        this.updateChapterTrainingTask(trainingId, userId, trainingTaskSchedule);
                    } else {
                        List<TrainingAttachUser> trainingAttachUsers = this.trainingAttachUserMapper.selectAttachIsFinish(null, userId, syncTrainingId, null, null);
                        if (CollectionUtils.isEmpty(trainingAttachUsers)) {
                            return;
                        }
                        ArrayList<TrainingAttachUser> insertList = new ArrayList<TrainingAttachUser>();
                        for (TrainingAttachUser attachUser : trainingAttachUsers) {
                            TrainingAttachUser model = new TrainingAttachUser();
                            BeanUtils.copyProperties((Object)attachUser, (Object)model);
                            model.setId(null);
                            model.setTrainingId(trainingId);
                            model.setCreateTime(new Date());
                            Integer newAttachId = attachUser.getIsVideo() == 1 ? this.trainingVideoMapper.getNewAttachId(attachUser.getAttachId(), trainingId) : this.trainingAttachMapper.getNewAttachId(attachUser.getAttachId(), trainingId);
                            model.setAttachId(newAttachId);
                            insertList.add(model);
                        }
                        this.trainingAttachUserMapper.deleteByTrainingAndUserId(trainingId, userId);
                        this.trainingAttachUserMapper.insertList(insertList);
                        this.updateTrainingTask(trainingId, userId, trainingTaskSchedule);
                    }
                }
                TrainingLearnTaskUser taskUserDB = new TrainingLearnTaskUser();
                taskUserDB.setIsFirst(YesNoEnum.NO.getKey());
                taskUserDB.setId(taskUser.getId());
                this.trainingLearnTaskUserMapper.updateById(taskUserDB);
            }
        }
    }

    @Override
    public void updateRate(Integer trainingId, Integer userId) {
        AppStatusVo appStatusVo;
        Training training = (Training)this.trainingMapper.selectById(trainingId);
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(TrainingTaskSchedule::getTrainingId, (Object)trainingId);
        TrainingTaskSchedule schedule = (TrainingTaskSchedule)this.trainingTaskScheduleMapper.selectOne((Wrapper)wrapper);
        if (!ObjectUtils.isEmpty((Object)schedule) && !ObjectUtils.isEmpty((Object)(appStatusVo = this.trainingLearnProjectMapper.getStatusByShiftId(schedule.getShiftId())))) {
            if (training.getIsChapter() == 1) {
                this.updateChapterTrainingTask(trainingId, userId, schedule);
            } else {
                this.updateTrainingTask(trainingId, userId, schedule);
            }
        }
    }

    private void updateTrainingTask(Integer trainingId, Integer userId, TrainingTaskSchedule schedule) {
        TrainingAttachUser attachUser;
        List<TrainingAttachUser> trainingAttachUsers = this.trainingAttachUserMapper.selectAttachIsFinish(null, userId, trainingId, null, null);
        if (CollectionUtils.isEmpty(trainingAttachUsers)) {
            return;
        }
        List<TrainingAttach> attachList = this.trainingAttachMapper.selectByTrainingId(trainingId);
        List<TrainingVideo> videoList = this.trainingVideoMapper.selectByTrainingId(trainingId);
        Map<String, TrainingAttachUser> attachUserMap = trainingAttachUsers.stream().collect(Collectors.toMap(a -> MessageFormat.format("{0}:{1}", a.getAttachId(), a.getIsVideo()), a -> a, (x, y) -> x));
        if (CollectionUtils.isEmpty(attachList) && CollectionUtils.isEmpty(videoList)) {
            return;
        }
        Integer count = attachList.size() + videoList.size();
        Double percent = 0.0;
        Integer useTime = 0;
        Integer finishNum = 0;
        for (TrainingAttach attach : attachList) {
            attachUser = attachUserMap.get(MessageFormat.format("{0}:{1}", attach.getId(), 0));
            if (!Objects.nonNull(attachUser) || attachUser.getIsFinish() != 1) continue;
            Integer n = finishNum;
            Integer n2 = finishNum = Integer.valueOf(finishNum + 1);
            percent = Arith.add(percent, Arith.div(1.0, count.intValue(), 4));
        }
        for (TrainingVideo video : videoList) {
            attachUser = attachUserMap.get(MessageFormat.format("{0}:{1}", video.getId(), 1));
            if (!Objects.nonNull(attachUser)) continue;
            Integer videoSize = attachUser.getVideoSize();
            Integer playSize = attachUser.getPlaySize();
            useTime = useTime + playSize;
            if (playSize >= videoSize) {
                Integer n = finishNum;
                Integer n3 = finishNum = Integer.valueOf(finishNum + 1);
                percent = Arith.add(percent, Arith.div(1.0, count.intValue(), 4));
                continue;
            }
            percent = Arith.add(percent, Arith.div(Arith.div(playSize.intValue(), videoSize.intValue(), 4), count.intValue(), 4));
        }
        if (finishNum == count) {
            percent = 1.0;
        }
        Integer floor = (int)Math.floor(Arith.mul(percent, 100.0));
        this.trainingLearnTaskUserMapper.updateLearnTaskScoreOrRate(schedule.getId(), userId, floor, null, percent >= 1.0 ? Integer.valueOf(4) : null, percent >= 1.0 ? new Date() : null, useTime);
        this.updateLearUserStatus(schedule.getShiftId(), userId);
    }

    private void updateChapterTrainingTask(Integer trainingId, Integer userId, TrainingTaskSchedule schedule) {
        TrainingChapterAttachUser attachUser;
        List<TrainingChapterAttachUser> chapterAttachUsers = this.trainingChapterAttachUserMapper.selectAttachFinish(null, userId, trainingId, null, null);
        if (CollectionUtils.isEmpty(chapterAttachUsers)) {
            return;
        }
        Map<String, TrainingChapterAttachUser> attachUserMap = chapterAttachUsers.stream().collect(Collectors.toMap(a -> MessageFormat.format("{0}:{1}", a.getAttachId(), a.getIsVideo()), a -> a, (x, y) -> x));
        List<TrainingChapterAttach> attachList = this.trainingChapterAttachMapper.selectAllByTrainingId(trainingId);
        List<TrainingChapterVideo> videoList = this.trainingChapterVideoMapper.selectAllByTrainingId(trainingId);
        if (CollectionUtils.isEmpty(attachList) && CollectionUtils.isEmpty(videoList)) {
            return;
        }
        Integer count = attachList.size() + videoList.size();
        Double percent = 0.0;
        Integer useTime = 0;
        Integer finishNum = 0;
        for (TrainingChapterAttach chapterAttach : attachList) {
            attachUser = attachUserMap.get(MessageFormat.format("{0}:{1}", chapterAttach.getId(), 0));
            if (!Objects.nonNull(attachUser) || attachUser.getIsFinish() != 1) continue;
            Integer n = finishNum;
            Integer n2 = finishNum = Integer.valueOf(finishNum + 1);
            percent = Arith.add(percent, Arith.div(1.0, count.intValue(), 4));
        }
        for (TrainingChapterVideo chapterVideo : videoList) {
            attachUser = attachUserMap.get(MessageFormat.format("{0}:{1}", chapterVideo.getId(), 1));
            if (!Objects.nonNull(attachUser)) continue;
            Integer videoSize = attachUser.getVideoSize();
            Integer playSize = attachUser.getPlaySize();
            useTime = useTime + playSize;
            if (playSize >= videoSize) {
                Integer n = finishNum;
                Integer n3 = finishNum = Integer.valueOf(finishNum + 1);
                percent = Arith.add(percent, Arith.div(1.0, count.intValue(), 4));
                continue;
            }
            percent = Arith.add(percent, Arith.div(Arith.div(playSize.intValue(), videoSize.intValue(), 4), count.intValue(), 4));
        }
        if (finishNum == count) {
            percent = 1.0;
        }
        Integer floor = (int)Math.floor(Arith.mul(percent, 100.0));
        this.trainingLearnTaskUserMapper.updateLearnTaskScoreOrRate(schedule.getId(), userId, floor, null, percent >= 1.0 ? Integer.valueOf(4) : null, percent >= 1.0 ? new Date() : null, useTime);
        this.updateLearUserStatus(schedule.getShiftId(), userId);
    }

    @Override
    public Page<AppAttendTaskVo> selectAttendList(Page<AppAttendTaskVo> page, Integer userId, Integer status) {
        BaseResult userBase = this.userApi.getUserById(userId);
        Users user = new Users();
        if (userBase != null) {
            UsersPojo pojo = (UsersPojo)userBase.getData();
            user.setId(pojo.getId());
            user.setGroupId(pojo.getGroupId());
        }
        List<Integer> roleList = this.userUtilService.selectUserRoleList(user);
        List<AppAttendTaskVo> list = this.trainingLearnTaskUserMapper.selectAttendListByPage(page, userId, user.getGroupId(), status, roleList);
        Locale locale = Authenticator.getInstance().getCurrentClient().getLocale();
        String unStart = this.messageSource.getMessage("training.course.status.unstart", null, locale);
        String going = this.messageSource.getMessage("training.job.status.going", null, locale);
        String ended = this.messageSource.getMessage("training.job.status.ended", null, locale);
        for (AppAttendTaskVo appAttendTaskVo : list) {
            if (!org.springframework.util.StringUtils.isEmpty((Object)appAttendTaskVo.getLecturerId())) {
                List lecturers = Arrays.asList(appAttendTaskVo.getLecturerId().split(",")).stream().map(Integer::parseInt).collect(Collectors.toList());
                LambdaQueryWrapper wrapper2 = new LambdaQueryWrapper();
                wrapper2.in(TrainingLecturer::getId, lecturers);
                List lecturerList = this.lecturerMapper.selectList((Wrapper)wrapper2);
                appAttendTaskVo.setLecturer(lecturerList);
            }
            if (status == 1) {
                if (appAttendTaskVo.getStartTime().before(new Date())) {
                    appAttendTaskVo.setStatus(ProjectTaskSelfStatusEnum.DOING.getKey());
                    appAttendTaskVo.setStatusStr(going);
                } else {
                    appAttendTaskVo.setStatus(ProjectTaskSelfStatusEnum.DEFAULT.getKey());
                    appAttendTaskVo.setStatusStr(unStart);
                }
            } else {
                appAttendTaskVo.setStatus(ProjectTaskSelfStatusEnum.ENDED.getKey());
                appAttendTaskVo.setStatusStr(ended);
            }
            TrainingLearnShift learnShift = (TrainingLearnShift)this.shiftMapper.selectById(appAttendTaskVo.getShiftId());
            String taskName = appAttendTaskVo.getTaskName();
            if (!ObjectUtils.isEmpty((Object)learnShift)) {
                String groupName = org.springframework.util.StringUtils.isEmpty((Object)learnShift.getGroupName()) ? "" : "-" + learnShift.getGroupName();
                String supplemenName = org.springframework.util.StringUtils.isEmpty((Object)learnShift.getSupplemenName()) ? "" : "-" + learnShift.getSupplemenName();
                taskName = taskName + groupName + supplemenName;
            }
            appAttendTaskVo.setTaskName(taskName);
        }
        page.setContent(list);
        return page;
    }

    @Override
    public TrainingTaskScheduleVo selectAttendDetailByScheduleId(Integer scheduleId) {
        Date now = new Date();
        TrainingTaskScheduleVo scheduleVo = new TrainingTaskScheduleVo();
        TrainingTaskSchedule taskSchedule = (TrainingTaskSchedule)this.trainingTaskScheduleMapper.selectById(scheduleId);
        if (!ObjectUtils.isEmpty((Object)taskSchedule)) {
            BeanUtils.copyProperties((Object)taskSchedule, (Object)scheduleVo);
        }
        if (!org.springframework.util.StringUtils.isEmpty((Object)scheduleVo.getLecturerId())) {
            List lecturers = Arrays.asList(scheduleVo.getLecturerId().split(",")).stream().map(Integer::parseInt).collect(Collectors.toList());
            LambdaQueryWrapper wrapper2 = new LambdaQueryWrapper();
            wrapper2.in(TrainingLecturer::getId, lecturers);
            List lecturerList = this.lecturerMapper.selectList((Wrapper)wrapper2);
            scheduleVo.setLecturer(lecturerList);
        }
        List documentList = new ArrayList();
        LambdaQueryWrapper wrapper3 = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper3.eq(TrainingTaskSchedule::getTaskId, (Object)scheduleVo.getTaskId())).isNull(TrainingTaskSchedule::getShiftId)).orderByDesc(TrainingTaskSchedule::getId)).last(" limit 1");
        TrainingTaskSchedule taskNotShift = (TrainingTaskSchedule)this.trainingTaskScheduleMapper.selectOne((Wrapper)wrapper3);
        if (!ObjectUtils.isEmpty((Object)taskNotShift)) {
            LambdaQueryWrapper wrappers = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)wrappers.eq(TrainingProjectDocument::getProjectId, (Object)taskNotShift.getId())).eq(TrainingProjectDocument::getType, (Object)1);
            documentList = this.documentMapper.selectList((Wrapper)wrappers);
        }
        scheduleVo.setDocumentList(documentList);
        Locale locale = Authenticator.getInstance().getCurrentClient().getLocale();
        if (!org.springframework.util.StringUtils.isEmpty((Object)taskSchedule.getStartTime()) && !org.springframework.util.StringUtils.isEmpty((Object)taskSchedule.getEndTime())) {
            if (taskSchedule.getStartTime().before(now) && taskSchedule.getEndTime().after(now)) {
                String going = this.messageSource.getMessage("training.job.status.going", null, locale);
                scheduleVo.setStatus(ProjectTaskSelfStatusEnum.DOING.getKey());
                scheduleVo.setStatusStr(going);
            } else if (taskSchedule.getStartTime().after(now)) {
                String unStart = this.messageSource.getMessage("training.course.status.unstart", null, locale);
                scheduleVo.setStatus(ProjectTaskSelfStatusEnum.DEFAULT.getKey());
                scheduleVo.setStatusStr(unStart);
            } else {
                String ended = this.messageSource.getMessage("training.job.status.ended", null, locale);
                scheduleVo.setStatus(ProjectTaskSelfStatusEnum.ENDED.getKey());
                scheduleVo.setStatusStr(ended);
            }
        }
        TrainingProjectTask projectTask = (TrainingProjectTask)this.trainingProjectTaskMapper.selectById(taskSchedule.getTaskId());
        String taskName = projectTask.getTaskName();
        TrainingLearnShift learnShift = (TrainingLearnShift)this.shiftMapper.selectById(taskSchedule.getShiftId());
        if (learnShift != null) {
            String groupName;
            String string = learnShift.getGroupName() == null ? "" : (groupName = "".equals(learnShift.getGroupName().trim()) ? "" : "-" + learnShift.getGroupName());
            String supplemenName = learnShift.getSupplemenName() == null ? "" : ("".equals(learnShift.getSupplemenName().trim()) ? "" : "-" + learnShift.getSupplemenName());
            taskName = taskName + groupName + supplemenName;
        }
        scheduleVo.setTaskActName((Object)taskName);
        return scheduleVo;
    }

    @Override
    public AppAttendScanCodeVo getManagerScanCode(Integer scheduleId) {
        AppTrainingTaskNumVo numVo;
        AppAttendScanCodeVo attendScanCodeVo = new AppAttendScanCodeVo();
        TrainingTaskSchedule taskSchedule = (TrainingTaskSchedule)this.trainingTaskScheduleMapper.selectById(scheduleId);
        BeanUtils.copyProperties((Object)taskSchedule, (Object)attendScanCodeVo);
        attendScanCodeVo.setScheduleId(taskSchedule.getId());
        attendScanCodeVo.setSignStartStatus(YesNoEnum.YES.getKey());
        attendScanCodeVo.setSignEndStatus(YesNoEnum.YES.getKey());
        if (Objects.nonNull(attendScanCodeVo.getSignStart()) && Objects.nonNull(attendScanCodeVo.getSignStarts()) && attendScanCodeVo.getSignStart().after(new Date())) {
            attendScanCodeVo.setSignStartStatus(YesNoEnum.NO.getKey());
        }
        if (Objects.nonNull(attendScanCodeVo.getSignEnd()) && Objects.nonNull(attendScanCodeVo.getSignEnds()) && attendScanCodeVo.getSignEnd().after(new Date())) {
            attendScanCodeVo.setSignEndStatus(YesNoEnum.NO.getKey());
        }
        if (Objects.nonNull(taskSchedule.getStartTime()) && taskSchedule.getStartTime().after(new Date())) {
            attendScanCodeVo.setSignEndStatus(YesNoEnum.NO.getKey());
        }
        attendScanCodeVo.setSignStartFinishNum(Integer.valueOf(org.springframework.util.StringUtils.isEmpty((Object)(numVo = this.trainingLearnTaskUserMapper.summaryStartAttendNum(scheduleId))) ? 0 : numVo.getFinishNum()));
        attendScanCodeVo.setSignStartYetFinishNum(Integer.valueOf(org.springframework.util.StringUtils.isEmpty((Object)numVo) ? 0 : numVo.getYetFinishNum()));
        AppTrainingTaskNumVo numVo1 = this.trainingLearnTaskUserMapper.summaryEndAttendNum(scheduleId);
        attendScanCodeVo.setSignEndFinishNum(Integer.valueOf(org.springframework.util.StringUtils.isEmpty((Object)numVo1) ? 0 : numVo1.getFinishNum()));
        attendScanCodeVo.setSignEndYetFinishNum(Integer.valueOf(org.springframework.util.StringUtils.isEmpty((Object)numVo1) ? 0 : numVo1.getYetFinishNum()));
        attendScanCodeVo.setSignStartStr(MessageFormat.format("{0}:{1}:{2}", "OFFLINE_ATTEND", taskSchedule.getId().toString(), 1));
        attendScanCodeVo.setSignEndStr(MessageFormat.format("{0}:{1}:{2}", "OFFLINE_ATTEND", taskSchedule.getId().toString(), 2));
        return attendScanCodeVo;
    }

    @Override
    public Page<AppAttendUserVo> getAttendUserList(Page<AppAttendUserVo> page, Integer scheduleId, Integer type) {
        List<AppAttendUserVo> list = this.trainingLearnTaskUserMapper.selectStartAttendListByPage(page, scheduleId, type);
        if (!CollectionUtils.isEmpty(list)) {
            List<Integer> userIds = list.stream().map(AppAttendUserVo::getUserId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            Map<Integer, UsersPojo> userMap = this.userUtilService.selectUserMap(userIds);
            for (AppAttendUserVo vo : list) {
                UsersPojo pojo = userMap.get(vo.getUserId());
                if (pojo == null) continue;
                vo.setUserName(pojo.getShowName());
                vo.setThumbUrl(pojo.getThumbUrl());
            }
        }
        page.setContent(list);
        return page;
    }

    @Override
    public Map<String, Object> getAttendUserNum(Integer scheduleId) {
        return this.trainingLearnTaskUserMapper.getAttendUserNum(scheduleId);
    }

    @Override
    public void scanCode(String codeStr, Integer userId) {
        Date now = new Date();
        String[] arr = codeStr.split(":");
        if (arr.length == 3 && arr[0].equals("OFFLINE_ATTEND")) {
            Integer scheduleId = Integer.valueOf(arr[1]);
            Integer attendType = Integer.valueOf(arr[2]);
            TrainingTaskSchedule schedule = (TrainingTaskSchedule)this.trainingTaskScheduleMapper.selectById(scheduleId);
            if (!ObjectUtils.isEmpty((Object)schedule)) {
                LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
                wrapper.eq(TrainingLearnTaskUser::getProjectTaskScheduleId, (Object)scheduleId);
                wrapper.eq(TrainingLearnTaskUser::getUserId, (Object)userId);
                TrainingLearnTaskUser trainingLearnTaskUser = (TrainingLearnTaskUser)this.trainingLearnTaskUserMapper.selectOne((Wrapper)wrapper);
                if (!ObjectUtils.isEmpty((Object)trainingLearnTaskUser)) {
                    if (attendType == 1) {
                        if (Objects.nonNull(schedule.getSignStart()) && Objects.nonNull(schedule.getSignStarts()) && schedule.getSignStart().after(new Date())) {
                            throw new CommonException("ATTEND_TIME_NOT_UP");
                        }
                        if (Objects.nonNull(trainingLearnTaskUser.getStartTime())) {
                            HashMap<String, Date> map = new HashMap<String, Date>();
                            map.put("attendTime", trainingLearnTaskUser.getStartTime());
                            throw new CommonException("REPEAT_ATTEND", map);
                        }
                        if (trainingLearnTaskUser.getTaskStatus() != 3 && trainingLearnTaskUser.getTaskStatus() != 4 && org.springframework.util.StringUtils.isEmpty((Object)trainingLearnTaskUser.getEndTime())) {
                            TrainingJobUserTask jobUserTask;
                            Integer ifLate = 0;
                            Integer lateTime = 0;
                            if (Objects.nonNull(schedule.getSignStarts()) && schedule.getSignStarts().before(now)) {
                                ifLate = 1;
                                lateTime = Math.toIntExact((now.getTime() - schedule.getSignStarts().getTime()) / 60000L);
                            }
                            this.trainingLearnTaskUserMapper.updateTaskAttendStatus(scheduleId, userId, ifLate, lateTime, now);
                            this.trainingLearnUserMapper.updateTaskDefaultStatus(schedule.getShiftId(), userId);
                            LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
                            ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper1.eq(TrainingLearnTaskUser::getUserId, (Object)userId)).eq(TrainingLearnTaskUser::getProjectTaskScheduleId, (Object)scheduleId)).orderByDesc(TrainingLearnTaskUser::getId)).last(" limit 1");
                            TrainingLearnTaskUser learnTaskUser = (TrainingLearnTaskUser)this.trainingLearnTaskUserMapper.selectOne((Wrapper)wrapper1);
                            if (learnTaskUser != null && learnTaskUser.getJobUserTaskId() != null && (jobUserTask = (TrainingJobUserTask)this.jobUserTaskMapper.selectById(learnTaskUser.getJobUserTaskId())) != null) {
                                jobUserTask.setStartTime(new Date());
                                if (jobUserTask.getTaskStatus() == 0) {
                                    jobUserTask.setTaskStatus(Integer.valueOf(1));
                                }
                                this.jobUserTaskMapper.updateById(jobUserTask);
                            }
                        }
                    } else if (schedule.getStartTime().before(now) && trainingLearnTaskUser.getTaskStatus() != 3 && trainingLearnTaskUser.getTaskStatus() != 4) {
                        TrainingJobUserTask jobUserTask;
                        Integer ifEarly = 0;
                        Integer earlyTime = 0;
                        if (Objects.nonNull(schedule.getSignEnd()) && schedule.getSignEnd().after(now)) {
                            ifEarly = 1;
                            earlyTime = Math.toIntExact((schedule.getSignEnd().getTime() - now.getTime()) / 60000L);
                        }
                        this.trainingLearnTaskUserMapper.updateAttendEndTime(scheduleId, userId, ifEarly, now, earlyTime);
                        TrainingLearnEndAttend endAttend = new TrainingLearnEndAttend();
                        endAttend.setUserId(userId);
                        endAttend.setRecordTime(now);
                        endAttend.setTaskUserId(trainingLearnTaskUser.getId());
                        this.trainingLearnEndAttendMapper.insert(endAttend);
                        LambdaQueryWrapper wrapper2 = new LambdaQueryWrapper();
                        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper2.eq(TrainingLearnTaskUser::getUserId, (Object)userId)).eq(TrainingLearnTaskUser::getProjectTaskScheduleId, (Object)scheduleId)).orderByDesc(TrainingLearnTaskUser::getId)).last(" limit 1");
                        TrainingLearnTaskUser learnTaskUser = (TrainingLearnTaskUser)this.trainingLearnTaskUserMapper.selectOne((Wrapper)wrapper2);
                        if (learnTaskUser != null && learnTaskUser.getJobUserTaskId() != null && (jobUserTask = (TrainingJobUserTask)this.jobUserTaskMapper.selectById(learnTaskUser.getJobUserTaskId())) != null) {
                            jobUserTask.setEndTime(new Date());
                            if (jobUserTask.getTaskStatus() == 0 || jobUserTask.getTaskStatus() == 1) {
                                jobUserTask.setTaskStatus(Integer.valueOf(2));
                            }
                            if (jobUserTask.getStartTime() != null) {
                                jobUserTask.setUseTime(Integer.valueOf((int)(new Date().getTime() - jobUserTask.getStartTime().getTime() / 1000L)));
                            }
                            this.jobUserTaskMapper.updateById(jobUserTask);
                        }
                    }
                }
            }
        }
    }

    @Override
    public void leaveSign(String codeStr, Integer userId) {
        Integer scheduleId;
        TrainingTaskSchedule schedule;
        Date now = new Date();
        String[] arr = codeStr.split(":");
        if (arr.length == 3 && arr[0].equals("OFFLINE_ATTEND") && !org.springframework.util.StringUtils.isEmpty((Object)(schedule = (TrainingTaskSchedule)this.trainingTaskScheduleMapper.selectById(scheduleId = Integer.valueOf(arr[1]))))) {
            LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
            wrapper.eq(TrainingLearnTaskUser::getProjectTaskScheduleId, (Object)scheduleId);
            wrapper.eq(TrainingLearnTaskUser::getUserId, (Object)userId);
            TrainingLearnTaskUser trainingLearnTaskUser = (TrainingLearnTaskUser)this.trainingLearnTaskUserMapper.selectOne((Wrapper)wrapper);
            if (!org.springframework.util.StringUtils.isEmpty((Object)trainingLearnTaskUser)) {
                Integer ifEarly = 0;
                Integer earlyTime = 0;
                if (Objects.nonNull(schedule.getSignEnd()) && schedule.getSignEnd().after(now)) {
                    ifEarly = 1;
                    earlyTime = Math.toIntExact((schedule.getSignEnd().getTime() - now.getTime()) / 60000L);
                }
                this.trainingLearnTaskUserMapper.updateAttendEndTime(scheduleId, userId, ifEarly, now, earlyTime);
                this.trainingLearnTaskUserMapper.updateLearnTaskUserStatus(scheduleId, userId);
                this.trainingLearnUserMapper.updateTaskDefaultStatus(schedule.getShiftId(), userId);
                TrainingLearnEndAttend endAttend = new TrainingLearnEndAttend();
                endAttend.setUserId(userId);
                endAttend.setRecordTime(now);
                endAttend.setTaskUserId(trainingLearnTaskUser.getId());
                this.trainingLearnEndAttendMapper.insert(endAttend);
            }
        }
    }

    @Override
    public AppAttendScanCodeVo getMyAttendRecord(Integer scheduleId, Integer userId) {
        AppAttendScanCodeVo attendScanCodeVo = new AppAttendScanCodeVo();
        TrainingTaskSchedule taskSchedule = (TrainingTaskSchedule)this.trainingTaskScheduleMapper.selectById(scheduleId);
        BeanUtils.copyProperties((Object)taskSchedule, (Object)attendScanCodeVo);
        attendScanCodeVo.setScheduleId(taskSchedule.getId());
        attendScanCodeVo.setSignStartStatus(YesNoEnum.YES.getKey());
        attendScanCodeVo.setSignEndStatus(YesNoEnum.YES.getKey());
        if (Objects.nonNull(attendScanCodeVo.getSignStart()) && Objects.nonNull(attendScanCodeVo.getSignStarts()) && attendScanCodeVo.getSignStart().after(new Date())) {
            attendScanCodeVo.setSignStartStatus(YesNoEnum.NO.getKey());
        }
        if (Objects.nonNull(attendScanCodeVo.getSignEnd()) && Objects.nonNull(attendScanCodeVo.getSignEnds()) && attendScanCodeVo.getSignEnd().after(new Date())) {
            attendScanCodeVo.setSignEndStatus(YesNoEnum.NO.getKey());
        }
        if (Objects.nonNull(taskSchedule.getStartTime()) && taskSchedule.getStartTime().after(new Date())) {
            attendScanCodeVo.setSignEndStatus(YesNoEnum.NO.getKey());
        }
        AppTrainingTaskNumVo numVo = this.trainingLearnTaskUserMapper.summaryStartAttendNum(scheduleId);
        attendScanCodeVo.setSignStartFinishNum(numVo.getFinishNum());
        attendScanCodeVo.setSignStartYetFinishNum(numVo.getYetFinishNum());
        AppTrainingTaskNumVo numVo1 = this.trainingLearnTaskUserMapper.summaryEndAttendNum(scheduleId);
        attendScanCodeVo.setSignEndFinishNum(numVo1.getFinishNum());
        attendScanCodeVo.setSignEndYetFinishNum(numVo1.getYetFinishNum());
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(TrainingLearnTaskUser::getProjectTaskScheduleId, (Object)scheduleId);
        wrapper.eq(TrainingLearnTaskUser::getUserId, (Object)userId);
        TrainingLearnTaskUser trainingLearnTaskUser = (TrainingLearnTaskUser)this.trainingLearnTaskUserMapper.selectOne((Wrapper)wrapper);
        if (!ObjectUtils.isEmpty((Object)trainingLearnTaskUser)) {
            ArrayList<Date> list1 = new ArrayList<Date>();
            if (Objects.nonNull(trainingLearnTaskUser.getStartTime())) {
                list1.add(trainingLearnTaskUser.getStartTime());
            }
            ArrayList list2 = new ArrayList();
            LambdaQueryWrapper endAttendWrapper = new LambdaQueryWrapper();
            endAttendWrapper.eq(TrainingLearnEndAttend::getTaskUserId, (Object)trainingLearnTaskUser.getId());
            endAttendWrapper.orderByAsc(TrainingLearnEndAttend::getRecordTime);
            List endAttends = this.trainingLearnEndAttendMapper.selectList((Wrapper)endAttendWrapper);
            endAttends.forEach(a -> list2.add(a.getRecordTime()));
            attendScanCodeVo.setStartSignDateList(list1);
            attendScanCodeVo.setEndSignDateList(list2);
            attendScanCodeVo.setIfEarly(trainingLearnTaskUser.getIfEarly());
            attendScanCodeVo.setIfLate(trainingLearnTaskUser.getIfLate());
        }
        return attendScanCodeVo;
    }

    @Override
    public Page<AppAuditUserVo> getAuditList(Page<AppAuditUserVo> page, Integer scheduleId, Integer type) {
        List<AppAuditUserVo> list = this.trainingLearnTaskUserMapper.getAuditListByPage(page, scheduleId, type);
        TrainingTaskSchedule taskSchedule = (TrainingTaskSchedule)this.trainingTaskScheduleMapper.selectById(scheduleId);
        if (!org.springframework.util.StringUtils.isEmpty((Object)taskSchedule)) {
            Date startTime = taskSchedule.getStartTime();
            if (!CollectionUtils.isEmpty(list)) {
                List<Integer> userIds = list.stream().map(AppAuditUserVo::getUserId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
                Map<Integer, UsersPojo> userMap = this.userUtilService.selectUserMap(userIds);
                for (AppAuditUserVo vo : list) {
                    vo.setStartTime(startTime);
                    UsersPojo pojo = userMap.get(vo.getUserId());
                    if (pojo == null) continue;
                    vo.setUserName(pojo.getShowName());
                    vo.setThumbUrl(pojo.getThumbUrl());
                }
            }
        }
        page.setContent(list);
        return page;
    }

    @Override
    public Map<String, Object> getAuditNum(Integer scheduleId) {
        return this.trainingLearnTaskUserMapper.getAuditNum(scheduleId);
    }

    @Override
    public TrainingAttendAuditDetailVo getAuditDetail(Integer scheduleId, Integer userId) {
        TrainingAttendAuditDetailVo vo = new TrainingAttendAuditDetailVo();
        TrainingTaskSchedule taskSchedule = (TrainingTaskSchedule)this.trainingTaskScheduleMapper.selectById(scheduleId);
        BeanUtils.copyProperties((Object)taskSchedule, (Object)vo);
        vo.setScheduleId(taskSchedule.getId());
        TrainingProjectTask projectTask = (TrainingProjectTask)this.trainingProjectTaskMapper.selectById(taskSchedule.getTaskId());
        if (Objects.nonNull(projectTask)) {
            vo.setTaskName(projectTask.getTaskName());
        }
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(TrainingLearnTaskUser::getProjectTaskScheduleId, (Object)scheduleId);
        wrapper.eq(TrainingLearnTaskUser::getUserId, (Object)userId);
        TrainingLearnTaskUser trainingLearnTaskUser = (TrainingLearnTaskUser)this.trainingLearnTaskUserMapper.selectOne((Wrapper)wrapper);
        if (!org.springframework.util.StringUtils.isEmpty((Object)trainingLearnTaskUser)) {
            ArrayList<Date> list1 = new ArrayList<Date>();
            if (Objects.nonNull(trainingLearnTaskUser.getStartTime())) {
                list1.add(trainingLearnTaskUser.getStartTime());
            }
            ArrayList list2 = new ArrayList();
            LambdaQueryWrapper endAttendWrapper = new LambdaQueryWrapper();
            endAttendWrapper.eq(TrainingLearnEndAttend::getTaskUserId, (Object)trainingLearnTaskUser.getId());
            endAttendWrapper.orderByDesc(TrainingLearnEndAttend::getRecordTime);
            List endAttends = this.trainingLearnEndAttendMapper.selectList((Wrapper)endAttendWrapper);
            endAttends.forEach(a -> list2.add(a.getRecordTime()));
            vo.setTaskUserId(trainingLearnTaskUser.getId());
            vo.setStartSignDateList(list1);
            vo.setEndSignDateList(list2);
            vo.setIfEarly(trainingLearnTaskUser.getIfEarly());
            vo.setIfLate(trainingLearnTaskUser.getIfLate());
            vo.setLateTime(trainingLearnTaskUser.getLateTime());
            vo.setEarlyTime(trainingLearnTaskUser.getEarlyTime());
            vo.setUserId(userId);
            BaseResult base = this.userApi.getUserById(userId);
            if (base != null && Objects.nonNull(base.getData())) {
                vo.setUserName(((UsersPojo)base.getData()).getUserName());
                vo.setThumbUrl(((UsersPojo)base.getData()).getThumbUrl());
            }
        }
        return vo;
    }

    @Override
    public void saveAudit(TrainingAttendAuditSaveVo saveVo, Integer userId) {
        TrainingLearnTaskUser learnTaskUser;
        Integer taskUserId = saveVo.getTaskUserId();
        TrainingLearnTaskUser taskUser = new TrainingLearnTaskUser();
        taskUser.setId(taskUserId);
        taskUser.setScore(saveVo.getScore());
        taskUser.setTaskStatus(saveVo.getTaskStatus());
        taskUser.setContent(saveVo.getContent());
        this.trainingLearnTaskUserMapper.updateById(taskUser);
        List documentList = saveVo.getDocumentList();
        if (!CollectionUtils.isEmpty((Collection)documentList)) {
            for (TrainingProjectDocument document : documentList) {
                document.setCreater(userId);
                document.setCreateTime(new Date());
                document.setType(Integer.valueOf(4));
                document.setProjectId(taskUserId);
            }
            this.documentMapper.insertList(documentList);
        }
        if ((learnTaskUser = (TrainingLearnTaskUser)this.trainingLearnTaskUserMapper.selectById(taskUserId)).getJobUserTaskId() == null) {
            this.updateLearUserStatus(learnTaskUser.getShiftId(), learnTaskUser.getUserId());
        } else {
            TrainingJobUserTask jobUserTask = (TrainingJobUserTask)this.jobUserTaskMapper.selectById(learnTaskUser.getJobUserTaskId());
            if (jobUserTask != null) {
                if (!CollectionUtils.isEmpty((Collection)documentList)) {
                    for (TrainingProjectDocument document : documentList) {
                        TrainingJobDocument jobDocument = new TrainingJobDocument();
                        jobDocument.setName(document.getName());
                        jobDocument.setUrl(document.getUrl());
                        jobDocument.setSize(document.getSize());
                        jobDocument.setDuration(document.getDuration());
                        jobDocument.setCreater(userId);
                        jobDocument.setCreateTime(new Date());
                        jobDocument.setType(Integer.valueOf(3));
                        jobDocument.setJobId(jobUserTask.getId());
                        this.jobDocumentMapper.insert(jobDocument);
                    }
                }
                jobUserTask.setStartTime(learnTaskUser.getStartTime() == null ? null : learnTaskUser.getStartTime());
                jobUserTask.setEndTime(learnTaskUser.getEndTime() == null ? null : learnTaskUser.getEndTime());
                jobUserTask.setScore(learnTaskUser.getScore());
                jobUserTask.setUseTime(learnTaskUser.getUseTime());
                jobUserTask.setTaskStatus(learnTaskUser.getTaskStatus());
                this.jobUserTaskMapper.updateById(jobUserTask);
                this.jobCertificationService.getIsFinishAllTask(jobUserTask.getJobId(), jobUserTask.getUserId());
            }
        }
    }

    @Override
    public TrainingAttendAuditSaveVo getAuditResult(Integer scheduleId, Integer userId) {
        TrainingTaskSchedule schedule = (TrainingTaskSchedule)this.trainingTaskScheduleMapper.selectById(scheduleId);
        TrainingAttendAuditSaveVo vo = new TrainingAttendAuditSaveVo();
        if (!ObjectUtils.isEmpty((Object)schedule)) {
            if (schedule.getStartTime() != null && schedule.getStartTime().before(new Date())) {
                LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
                wrapper.eq(TrainingLearnTaskUser::getProjectTaskScheduleId, (Object)scheduleId);
                wrapper.eq(TrainingLearnTaskUser::getUserId, (Object)userId);
                TrainingLearnTaskUser trainingLearnTaskUser = (TrainingLearnTaskUser)this.trainingLearnTaskUserMapper.selectOne((Wrapper)wrapper);
                if (!(ObjectUtils.isEmpty((Object)trainingLearnTaskUser) || trainingLearnTaskUser.getTaskStatus() != 3 && trainingLearnTaskUser.getTaskStatus() != 4)) {
                    vo.setScore(trainingLearnTaskUser.getScore());
                    vo.setTaskStatus(trainingLearnTaskUser.getTaskStatus());
                    vo.setContent(trainingLearnTaskUser.getContent());
                    LambdaQueryWrapper wrappers = new LambdaQueryWrapper();
                    ((LambdaQueryWrapper)wrappers.eq(TrainingProjectDocument::getProjectId, (Object)trainingLearnTaskUser.getId())).eq(TrainingProjectDocument::getType, (Object)4);
                    List documentList = this.documentMapper.selectList((Wrapper)wrappers);
                    vo.setDocumentList(documentList);
                    TrainingProjectTask projectTask = (TrainingProjectTask)this.trainingProjectTaskMapper.selectById(schedule.getTaskId());
                    if (Objects.nonNull(projectTask)) {
                        vo.setTaskName(projectTask.getTaskName());
                    }
                } else {
                    vo.setErrorStr("YET_AUDIT");
                }
            } else {
                vo.setErrorStr("ACTIVITY_TIME_NOT_UP");
            }
        } else {
            vo.setErrorStr("TRAINING_TASK_NOT_EXIST");
        }
        return vo;
    }

    @Override
    public Map<String, Object> selectRoleByScheduleId(Integer scheduleId, Integer userId) {
        Locale locale = Authenticator.getInstance().getCurrentClient().getLocale();
        HashMap<String, Object> map = new HashMap<String, Object>();
        Integer count = this.trainingLearnTaskUserMapper.selectManagerCount(scheduleId, userId);
        if (count == 0) {
            map.put("roleId", AttendRoleEnum.STUDENT.getKey());
            map.put("roleName", this.messageSource.getMessage("training.course.student", null, locale));
        } else {
            Integer count1 = this.trainingLearnTaskUserMapper.selectStudentCount(scheduleId, userId);
            if (count1 > 0) {
                map.put("roleId", AttendRoleEnum.ALL.getKey());
                map.put("roleName", this.messageSource.getMessage("training.course.all", null, locale));
            } else {
                map.put("roleId", AttendRoleEnum.MANAGER.getKey());
                map.put("roleName", "\u7ba1\u7406\u5458");
            }
        }
        return map;
    }

    @Override
    public AppAttendMessageVo getAttendMessage(Integer scheduleId, Integer userId, Integer attendType) {
        Date now = new Date();
        AppAttendMessageVo appAttendMessageVo = new AppAttendMessageVo();
        TrainingTaskSchedule schedule = (TrainingTaskSchedule)this.trainingTaskScheduleMapper.selectById(scheduleId);
        if (!ObjectUtils.isEmpty((Object)schedule)) {
            appAttendMessageVo.setPath(schedule.getPath());
            if (!org.springframework.util.StringUtils.isEmpty((Object)schedule.getLecturerId())) {
                List lecturers = Arrays.asList(schedule.getLecturerId().split(",")).stream().map(Integer::parseInt).collect(Collectors.toList());
                LambdaQueryWrapper wrapper2 = new LambdaQueryWrapper();
                wrapper2.in(TrainingLecturer::getId, lecturers);
                List lecturerList = this.lecturerMapper.selectList((Wrapper)wrapper2);
                appAttendMessageVo.setLecturer(lecturerList);
            }
            appAttendMessageVo.setStartTime(schedule.getStartTime());
            appAttendMessageVo.setEndTime(schedule.getEndTime());
            appAttendMessageVo.setTaskPlace(schedule.getTaskPlace());
            TrainingProjectTask projectTask = (TrainingProjectTask)this.trainingProjectTaskMapper.selectById(schedule.getTaskId());
            if (!ObjectUtils.isEmpty((Object)projectTask)) {
                appAttendMessageVo.setTaskId(projectTask.getId());
                appAttendMessageVo.setTaskName(projectTask.getTaskName());
            } else {
                appAttendMessageVo.setErrorStr("TRAINING_TASK_NOT_EXIST");
            }
            appAttendMessageVo.setScheduleId(scheduleId);
            Locale locale = Authenticator.getInstance().getCurrentClient().getLocale();
            if (!org.springframework.util.StringUtils.isEmpty((Object)schedule.getStartTime()) && !org.springframework.util.StringUtils.isEmpty((Object)schedule.getEndTime())) {
                if (schedule.getStartTime().before(now) && schedule.getEndTime().after(now)) {
                    String going = this.messageSource.getMessage("training.job.status.going", null, locale);
                    appAttendMessageVo.setStatus(ProjectTaskSelfStatusEnum.DOING.getKey());
                    appAttendMessageVo.setStatusStr(going);
                } else if (schedule.getStartTime().after(now)) {
                    String unStart = this.messageSource.getMessage("training.course.status.unstart", null, locale);
                    appAttendMessageVo.setStatus(ProjectTaskSelfStatusEnum.DEFAULT.getKey());
                    appAttendMessageVo.setStatusStr(unStart);
                } else {
                    String ended = this.messageSource.getMessage("training.job.status.ended", null, locale);
                    appAttendMessageVo.setStatus(ProjectTaskSelfStatusEnum.ENDED.getKey());
                    appAttendMessageVo.setStatusStr(ended);
                }
            } else {
                appAttendMessageVo.setErrorStr("TASK_TIME_NOT_CONFIG");
            }
            LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
            wrapper.eq(TrainingLearnTaskUser::getProjectTaskScheduleId, (Object)scheduleId);
            wrapper.eq(TrainingLearnTaskUser::getUserId, (Object)userId);
            TrainingLearnTaskUser trainingLearnTaskUser = (TrainingLearnTaskUser)this.trainingLearnTaskUserMapper.selectOne((Wrapper)wrapper);
            appAttendMessageVo.setIfBelong(!ObjectUtils.isEmpty((Object)trainingLearnTaskUser) ? YesNoEnum.YES.getKey() : YesNoEnum.NO.getKey());
            if (!ObjectUtils.isEmpty((Object)trainingLearnTaskUser)) {
                appAttendMessageVo.setAllowAttendStatus("ATTEND_ALLOW");
                if (attendType == 1) {
                    if (!ObjectUtils.isEmpty((Object)schedule.getSignStart()) && !ObjectUtils.isEmpty((Object)schedule.getSignStarts()) && schedule.getSignStart().after(now)) {
                        appAttendMessageVo.setAllowAttendStatus("ATTEND_TIME_NOT_UP");
                    } else if (!ObjectUtils.isEmpty((Object)trainingLearnTaskUser.getStartTime())) {
                        appAttendMessageVo.setAllowAttendStatus("REPEAT_ATTEND");
                        appAttendMessageVo.setAttendTime(trainingLearnTaskUser.getStartTime());
                    } else if (trainingLearnTaskUser.getTaskStatus() == 3 || trainingLearnTaskUser.getTaskStatus() == 4) {
                        appAttendMessageVo.setAllowAttendStatus("START_ALREADY_AUDIT");
                    } else if (!ObjectUtils.isEmpty((Object)trainingLearnTaskUser.getEndTime())) {
                        appAttendMessageVo.setAllowAttendStatus("ALREADY_LEAVE_SIGN");
                    }
                } else {
                    if (!ObjectUtils.isEmpty((Object)schedule.getStartTime()) && schedule.getStartTime().after(now)) {
                        appAttendMessageVo.setAllowAttendStatus("ACTIVITY_TIME_NOT_UP");
                    } else if (trainingLearnTaskUser.getTaskStatus() == 3 || trainingLearnTaskUser.getTaskStatus() == 4) {
                        appAttendMessageVo.setAllowAttendStatus("END_ALREADY_AUDIT");
                    } else if (!ObjectUtils.isEmpty((Object)trainingLearnTaskUser.getStartTime())) {
                        appAttendMessageVo.setAllowAttendStatus("YET_START_SIGN");
                    }
                    appAttendMessageVo.setAttendTime(trainingLearnTaskUser.getEndTime());
                }
            } else {
                appAttendMessageVo.setErrorStr("LEARNING_USER_NOT_EXIST");
            }
        } else {
            appAttendMessageVo.setErrorStr("TRAINING_TASK_NOT_EXIST");
        }
        return appAttendMessageVo;
    }

    @Override
    public List<AppTrainingProgressVo> getTrainingProgressList(Integer userId) {
        ArrayList<AppTrainingProgressVo> reList = new ArrayList<AppTrainingProgressVo>();
        List<AppTrainingShiftVo> shiftVoList = this.trainingLearnProjectMapper.selectAllMyShift(userId);
        List<AppShiftDateVo> shiftStartTimeList = this.trainingLearnTaskUserMapper.getShiftStartTime(userId);
        List<AppShiftDateVo> shiftFinishTimeList = this.trainingLearnTaskUserMapper.getShiftFinishTime(userId);
        Map<Integer, Date> shiftStartTimeMap = shiftStartTimeList.stream().collect(Collectors.toMap(a -> a.getShiftId(), a -> a.getTime(), (x, y) -> x));
        Map<Integer, Date> shiftFinishTimeMap = shiftFinishTimeList.stream().collect(Collectors.toMap(a -> a.getShiftId(), a -> a.getTime(), (x, y) -> x));
        for (AppTrainingShiftVo shiftVo : shiftVoList) {
            Date shiftFinishTime;
            Integer passStatus;
            if (!org.springframework.util.StringUtils.isEmpty((Object)shiftVo.getSupplemenName())) {
                shiftVo.setShiftName(MessageFormat.format("{0}-{1}", shiftVo.getShiftName(), shiftVo.getSupplemenName()));
            }
            AppTrainingProgressVo progressVo = new AppTrainingProgressVo();
            progressVo.setActType(Integer.valueOf(0));
            progressVo.setTaskType(Integer.valueOf(0));
            progressVo.setTaskName(shiftVo.getShiftName());
            progressVo.setRecordTime(shiftVo.getCreateTime());
            progressVo.setRecordTimeStr(DateUtils.format(progressVo.getRecordTime()));
            reList.add(progressVo);
            Integer shiftId = shiftVo.getShiftId();
            Integer learnStatus = shiftVo.getLearnStatus();
            if (!Objects.nonNull(learnStatus) || learnStatus != 2 && learnStatus != 3) continue;
            Date shiftStartTime = shiftStartTimeMap.get(shiftId);
            if (Objects.nonNull(shiftStartTime)) {
                AppTrainingProgressVo vo = new AppTrainingProgressVo();
                vo.setActType(Integer.valueOf(1));
                vo.setTaskType(Integer.valueOf(0));
                vo.setTaskName(shiftVo.getShiftName());
                vo.setRecordTime(shiftStartTime);
                vo.setRecordTimeStr(DateUtils.format(shiftStartTime));
                reList.add(vo);
            }
            if (!Objects.nonNull(passStatus = shiftVo.getPassStatus()) || passStatus != 1 || !Objects.nonNull(shiftFinishTime = shiftFinishTimeMap.get(shiftId))) continue;
            AppTrainingProgressVo vo1 = new AppTrainingProgressVo();
            vo1.setActType(Integer.valueOf(2));
            vo1.setTaskType(Integer.valueOf(0));
            vo1.setTaskName(shiftVo.getShiftName());
            vo1.setRecordTime(shiftFinishTime);
            vo1.setRecordTimeStr(DateUtils.format(shiftFinishTime));
            if (Objects.nonNull(shiftStartTime)) {
                Double min = Arith.div(shiftFinishTime.getTime() - shiftStartTime.getTime(), 60000.0);
                vo1.setMinutes(min);
            }
            reList.add(vo1);
        }
        reList.sort(Comparator.comparing(AppTrainingProgressVo::getRecordTime).reversed());
        return reList;
    }
}

