/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.training.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.map.MapUtil;
import cn.hutool.json.JSONUtil;
import com.ovopark.organize.common.model.mo.UserAndParentNameMo;
import com.ovopark.organize.common.model.mo.UserTagMo;
import com.ovopark.organize.common.model.mo.UsersAndOrgsMo;
import com.ovopark.organize.common.model.pojo.DepAndTagsPojo;
import com.ovopark.organize.common.model.pojo.OrganizeLevelPojo;
import com.ovopark.organize.common.model.pojo.OrganizePojo;
import com.ovopark.organize.common.model.pojo.UsersOrgIdsAndTagsPojo;
import com.ovopark.organize.common.model.pojo.UsersPagePojo;
import com.ovopark.organize.sdk.api.DepartmentApi;
import com.ovopark.organize.sdk.api.OrganizeApi;
import com.ovopark.organize.sdk.api.TagApi;
import com.ovopark.organize.sdk.api.UserApi;
import com.ovopark.organize.sdk.api.UserOrganizeApi;
import com.ovopark.privilege.pojo.UsersPojo;
import com.ovopark.privilege.response.BaseResult;
import com.ovopark.training.bo.BusinessConstant;
import com.ovopark.training.bo.Page;
import com.ovopark.training.dto.DeptCourseSummarizeDto;
import com.ovopark.training.dto.DeptDimensionDto;
import com.ovopark.training.dto.DeptExamSummarizeDto;
import com.ovopark.training.dto.DeptStudySummarizeDto;
import com.ovopark.training.model.Users;
import com.ovopark.training.request.DeptSummarizeExportRequest;
import com.ovopark.training.request.DeptSummarizeQueryRequest;
import com.ovopark.training.response.DeptSummarizeResponse;
import com.ovopark.training.service.IDeptStatisticService;
import com.ovopark.training.service.IDimensionSummarizeService;
import com.ovopark.training.service.UserUtilService;
import com.ovopark.training.util.BeanSwitchUtils;
import com.ovopark.training.util.DateUtils;
import com.ovopark.training.util.ListUtil;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class DeptStatisticServiceImpl
implements IDeptStatisticService {
    private static final Logger log = LoggerFactory.getLogger(DeptStatisticServiceImpl.class);
    @Resource
    private DepartmentApi departmentApi;
    @Resource
    private OrganizeApi organizeApi;
    @Resource
    private UserOrganizeApi userOrganizeApi;
    @Resource
    private com.ovopark.privilege.api.UserApi useApi;
    @Resource
    private UserApi organizeUserApi;
    @Resource
    private TagApi tagApi;
    @Resource
    private UserUtilService userUtilService;
    @Resource
    private IDimensionSummarizeService dimensionSummarizeService;

    @Override
    public Page<DeptSummarizeResponse> queryDeptStatistics(DeptSummarizeQueryRequest request, Users user) {
        Page page = new Page();
        page.setPageSize(request.getPageSize());
        page.setPageNumber(request.getPageNumber());
        com.ovopark.organize.common.base.BaseResult<Map<String, List<Integer>>> originBaseData = this.queryDeptAndUserCount(request, user);
        if (originBaseData == null || org.springframework.util.StringUtils.isEmpty((Object)originBaseData.getData())) {
            return page;
        }
        List<String> originalDeptIds = this.operateDeptInfoToDeptId(originBaseData);
        List<Integer> userIdList = Optional.ofNullable(this.getUserIdListByRoleAndOrganize(request.getRoleIdList(), request.getShowName(), request.getOrganizeIdList(), user, request.getUserStatus(), originalDeptIds)).orElse(Collections.emptyList());
        Map<String, List<Integer>> baseMap = ((Map)originBaseData.getData()).entrySet().stream().filter(entry -> entry.getValue() != null && !((List)entry.getValue()).isEmpty()).filter(entry -> ((List)entry.getValue()).stream().anyMatch(userIdList::contains)).collect(Collectors.toMap(Map.Entry::getKey, entry -> ((List)entry.getValue()).stream().filter(userIdList::contains).collect(Collectors.toList())));
        Map<String, List<Integer>> deptNameAndPersonNumMap = this.operateDeptInfoAndGetNameList(baseMap, page, request.getQueryType());
        LinkedList<DeptDimensionDto> deptDimensionDtoLinkedList = this.operateDeptPageInfo(baseMap, page, request, user);
        if (CollectionUtils.isEmpty(deptDimensionDtoLinkedList)) {
            return page;
        }
        CompletableFuture<List<DeptStudySummarizeDto>> materialTaskResponse = this.dimensionSummarizeService.queryMaterialDimensionSummarize(deptDimensionDtoLinkedList, deptNameAndPersonNumMap, userIdList, request.getCountType());
        CompletableFuture<List<DeptStudySummarizeDto>> trainTaskResponse = this.dimensionSummarizeService.queryNewCourseDimensionSummarize(deptDimensionDtoLinkedList, deptNameAndPersonNumMap, userIdList, request.getCountType());
        CompletableFuture<List<DeptStudySummarizeDto>> studyProjectResponse = this.dimensionSummarizeService.queryStudyProjectDimensionSummarize(deptDimensionDtoLinkedList, deptNameAndPersonNumMap, userIdList, request.getCountType());
        CompletableFuture<List<DeptStudySummarizeDto>> postMapResponse = this.dimensionSummarizeService.queryTrainPlanDimensionSummarize(deptDimensionDtoLinkedList, deptNameAndPersonNumMap, userIdList, request.getCountType());
        CompletableFuture<List<DeptStudySummarizeDto>> trainPlanResponse = this.dimensionSummarizeService.queryPostMapDimensionSummarize(deptDimensionDtoLinkedList, deptNameAndPersonNumMap, userIdList, request.getCountType());
        CompletableFuture<List<DeptCourseSummarizeDto>> trainingTasksResponse = this.dimensionSummarizeService.queryTrainingCourseSummarize(deptDimensionDtoLinkedList, deptNameAndPersonNumMap, userIdList, request.getCountType(), user);
        CompletableFuture<List<DeptExamSummarizeDto>> examSummarizeDtosResponses = this.dimensionSummarizeService.queryExamSummarize(deptDimensionDtoLinkedList, deptNameAndPersonNumMap, userIdList, request.getCountType(), user);
        CompletableFuture.allOf(materialTaskResponse, trainTaskResponse, studyProjectResponse, postMapResponse, trainPlanResponse, trainingTasksResponse, examSummarizeDtosResponses);
        try {
            List<DeptStudySummarizeDto> materialLists = materialTaskResponse.get(10L, TimeUnit.SECONDS);
            List<DeptStudySummarizeDto> trainLists = trainTaskResponse.get(10L, TimeUnit.SECONDS);
            List<DeptStudySummarizeDto> studyProjectLists = studyProjectResponse.get(10L, TimeUnit.SECONDS);
            List<DeptStudySummarizeDto> postMapLists = postMapResponse.get(10L, TimeUnit.SECONDS);
            List<DeptStudySummarizeDto> trainPlanLists = trainPlanResponse.get(10L, TimeUnit.SECONDS);
            List<DeptCourseSummarizeDto> trainingTasks = trainingTasksResponse.get(10L, TimeUnit.SECONDS);
            List<DeptExamSummarizeDto> examSummarizeDtos = examSummarizeDtosResponses.get(10L, TimeUnit.SECONDS);
            Set<Integer> enableUserIds = this.queryDeptEnableUser(Arrays.asList("KNOWLEDGE_MATERIAL", "LEARNING_TASK", "STUDY_PROGRAM_APP", "JOB_MAP_APP", "KNOWLEDGE_LIBRARY"), user.getGroupId());
            ArrayList deptSummarizeResponses = new ArrayList();
            deptDimensionDtoLinkedList.forEach(x -> {
                DeptSummarizeResponse deptSummarizeResponse = new DeptSummarizeResponse();
                List deptUserList = Optional.ofNullable(deptNameAndPersonNumMap.get(x.getDeptName())).orElse(Collections.emptyList());
                deptSummarizeResponse.setDeptName(x.getDeptName());
                deptSummarizeResponse.setDeptId(x.getDeptId()).setIsLeaf(x.getIsLeaf()).setOrganizeLevel(x.getOrganizeLevel());
                deptUserList.retainAll(userIdList);
                deptSummarizeResponse.setDeptUserNum(Integer.valueOf(deptUserList.size()));
                deptUserList.retainAll(enableUserIds);
                deptSummarizeResponse.setEnableUserNum(Integer.valueOf(deptUserList.size()));
                this.queryStudySummarizeList(deptSummarizeResponse, materialLists, trainLists, studyProjectLists, postMapLists, trainPlanLists, (DeptDimensionDto)x, deptUserList.size(), request.getCountType());
                DeptCourseSummarizeDto deptCourseSummarizeDto = trainingTasks.stream().filter(train -> (!BusinessConstant.DeptStatisticsClass.PRE_DAY_STATISTICS_QUERY.equals(request.getCountType()) || x.getCalDay().equals(train.getCalDay())) && x.getDeptName().equals(train.getDeptName())).findFirst().get();
                BeanUtil.copyProperties((Object)deptCourseSummarizeDto, (Object)deptSummarizeResponse, (String[])new String[0]);
                Optional<DeptExamSummarizeDto> optional = examSummarizeDtos.stream().filter(train -> (!BusinessConstant.DeptStatisticsClass.PRE_DAY_STATISTICS_QUERY.equals(request.getCountType()) || x.getCalDay().equals(train.getCalDay())) && x.getDeptName().equals(train.getDeptName())).findFirst();
                DeptExamSummarizeDto deptExamSummarizeDto = optional.isPresent() ? optional.get() : new DeptExamSummarizeDto();
                BeanUtil.copyProperties((Object)deptExamSummarizeDto, (Object)deptSummarizeResponse, (String[])new String[0]);
                deptSummarizeResponse.setDeptId(x.getDeptId()).setIsLeaf(x.getIsLeaf()).setOrganizeLevel(x.getOrganizeLevel()).setEnableUserNum(Integer.valueOf(deptUserList.size()));
                deptSummarizeResponses.add(deptSummarizeResponse);
            });
            page.setContent(deptSummarizeResponses);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            log.error("\u67e5\u8be2\u90e8\u95e8\u7edf\u8ba1\u4fe1\u606f\u5931\u8d25,\u9519\u8bef\u4fe1\u606f\u4e3a", (Throwable)e);
            return new Page();
        }
        return page;
    }

    public DeptSummarizeResponse queryStudySummarizeList(DeptSummarizeResponse summarizeResponse, List<DeptStudySummarizeDto> materialLists, List<DeptStudySummarizeDto> trainLists, List<DeptStudySummarizeDto> studyProjectLists, List<DeptStudySummarizeDto> postMapLists, List<DeptStudySummarizeDto> trainPlanLists, DeptDimensionDto x, Integer deptUserNums, Integer countType) {
        ArrayList<DeptStudySummarizeDto> sameDeptValues = new ArrayList<DeptStudySummarizeDto>();
        this.addFilteredValuesFromList(sameDeptValues, materialLists, material -> (!BusinessConstant.DeptStatisticsClass.PRE_DAY_STATISTICS_QUERY.equals(countType) || x.getCalDay().equals(material.getCalDay())) && x.getDeptId().equals(material.getDeptId()));
        this.addFilteredValuesFromList(sameDeptValues, trainLists, train -> (!BusinessConstant.DeptStatisticsClass.PRE_DAY_STATISTICS_QUERY.equals(countType) || x.getCalDay().equals(train.getCalDay())) && x.getDeptId().equals(train.getDeptId()));
        this.addFilteredValuesFromList(sameDeptValues, studyProjectLists, studyProject -> (!BusinessConstant.DeptStatisticsClass.PRE_DAY_STATISTICS_QUERY.equals(countType) || x.getCalDay().equals(studyProject.getCalDay())) && x.getDeptId().equals(studyProject.getDeptId()));
        this.addFilteredValuesFromList(sameDeptValues, postMapLists, postMap -> (!BusinessConstant.DeptStatisticsClass.PRE_DAY_STATISTICS_QUERY.equals(countType) || x.getCalDay().equals(postMap.getCalDay())) && x.getDeptId().equals(postMap.getDeptId()));
        this.addFilteredValuesFromList(sameDeptValues, trainPlanLists, trainPlan -> (!BusinessConstant.DeptStatisticsClass.PRE_DAY_STATISTICS_QUERY.equals(countType) || x.getCalDay().equals(trainPlan.getCalDay())) && x.getDeptId().equals(trainPlan.getDeptId()));
        summarizeResponse.setCalDay(x.getCalDay());
        Set selfStudyUserIds = sameDeptValues.stream().filter(sameDept -> !CollectionUtils.isEmpty((Collection)sameDept.getSelfStudyUserIds())).flatMap(sameDept -> sameDept.getSelfStudyUserIds().stream()).collect(Collectors.toSet());
        summarizeResponse.setSelfStudyUserNum(Integer.valueOf(selfStudyUserIds.size()));
        Set taskStudyUserIds = sameDeptValues.stream().filter(sameDept -> !CollectionUtils.isEmpty((Collection)sameDept.getTaskStudyUserIds())).flatMap(sameDept -> sameDept.getTaskStudyUserIds().stream()).collect(Collectors.toSet());
        summarizeResponse.setTaskStudyUserNum(Integer.valueOf(taskStudyUserIds.size()));
        HashSet totalStudyUserIds = new HashSet(selfStudyUserIds);
        totalStudyUserIds.addAll(taskStudyUserIds);
        summarizeResponse.setTotalStudyUserNum(Integer.valueOf(totalStudyUserIds.size()));
        summarizeResponse.setTotalStudyRatio(new BigDecimal(summarizeResponse.getEnableUserNum()).compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : new BigDecimal(totalStudyUserIds.size()).divide(new BigDecimal(summarizeResponse.getEnableUserNum()), 4, RoundingMode.HALF_UP));
        summarizeResponse.setSelfStudyRatio(new BigDecimal(summarizeResponse.getEnableUserNum()).compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : new BigDecimal(selfStudyUserIds.size()).divide(new BigDecimal(summarizeResponse.getEnableUserNum()), 4, RoundingMode.HALF_UP));
        int totalSelfStudyTimes = sameDeptValues.stream().filter(y -> null != y.getSelfStudyTime()).mapToInt(DeptStudySummarizeDto::getSelfStudyTime).sum();
        summarizeResponse.setSelfStudyTimeStr(DateUtils.getUseTimeFormal(totalSelfStudyTimes));
        int totalTaskStudyTimes = sameDeptValues.stream().filter(y -> null != y.getTaskStudyTime()).mapToInt(DeptStudySummarizeDto::getTaskStudyTime).sum();
        summarizeResponse.setTaskStudyTimeStr(DateUtils.getUseTimeFormal(totalTaskStudyTimes));
        int totalStudyTime = totalTaskStudyTimes + totalSelfStudyTimes;
        summarizeResponse.setTotalStudyTimeStr(DateUtils.getUseTimeFormal(totalStudyTime));
        int preStudyStr = totalStudyUserIds.isEmpty() ? 0 : totalStudyTime / totalStudyUserIds.size();
        summarizeResponse.setPreStudyTimeStr(DateUtils.getUseTimeFormal(preStudyStr));
        int preTaskStudyStr = taskStudyUserIds.isEmpty() ? 0 : totalTaskStudyTimes / taskStudyUserIds.size();
        summarizeResponse.setPreTaskStudyTimeStr(DateUtils.getUseTimeFormal(preTaskStudyStr));
        int preSelfStudyTimeStr = selfStudyUserIds.isEmpty() ? 0 : totalSelfStudyTimes / selfStudyUserIds.size();
        summarizeResponse.setPreSelfStudyTimeStr(DateUtils.getUseTimeFormal(preSelfStudyTimeStr));
        return summarizeResponse;
    }

    @Override
    public List<DeptSummarizeResponse> queryDeptExcelStatistics(DeptSummarizeExportRequest request) {
        DeptSummarizeQueryRequest queryRequest = (DeptSummarizeQueryRequest)BeanSwitchUtils.bo2do((Object)request, DeptSummarizeQueryRequest.class);
        Page<DeptSummarizeResponse> page = this.queryDeptStatistics(queryRequest, request.getUsers());
        return page.getContent();
    }

    private void addFilteredValuesFromList(List<DeptStudySummarizeDto> sameDeptValues, List<DeptStudySummarizeDto> list, Predicate<DeptStudySummarizeDto> predicate) {
        if (list != null && !list.isEmpty()) {
            sameDeptValues.addAll(list.stream().filter(predicate).collect(Collectors.toList()));
        }
    }

    private List<String> operateDeptInfoToDeptId(com.ovopark.organize.common.base.BaseResult<Map<String, List<Integer>>> baseData) {
        Map organizeBaseMap = (Map)baseData.getData();
        List<Object> depNameList = new ArrayList(organizeBaseMap.keySet());
        depNameList = depNameList.stream().filter(item -> !item.contains("\u672a\u5206\u7ec4")).collect(Collectors.toList());
        ArrayList<String> deptIds = new ArrayList<String>();
        depNameList.forEach(x -> {
            String[] strArr = x.split(":");
            deptIds.add(strArr[0]);
        });
        return deptIds;
    }

    private LinkedList<DeptDimensionDto> operateDeptPageInfo(Map<String, List<Integer>> baseData, Page page, DeptSummarizeQueryRequest request, Users user) {
        Map<String, List<Integer>> organizeBaseMap = baseData;
        LinkedHashMap map = new LinkedHashMap();
        LinkedList<DeptDimensionDto> deptDimensionDtoLinkedList = new LinkedList<DeptDimensionDto>();
        List<String> depNameList = new ArrayList<String>(organizeBaseMap.keySet());
        depNameList = depNameList.stream().filter(item -> !item.contains("\u672a\u5206\u7ec4")).collect(Collectors.toList());
        ArrayList<String> deptNames = new ArrayList<String>(depNameList.size());
        ArrayList deList = new ArrayList();
        for (String depStr : depNameList) {
            String[] strArr = depStr.split(":");
            if (org.springframework.util.StringUtils.isEmpty((Object)strArr[0].substring(2))) continue;
            String string = strArr[0].substring(2);
        }
        HashMap<String, DeptDimensionDto> deptNameAndDetailMap = new HashMap<String, DeptDimensionDto>();
        Map<Object, Object> levelMap = new HashMap();
        OrganizeLevelPojo levelPojo = new OrganizeLevelPojo();
        levelPojo.setOrganizeIds(deList);
        levelPojo.setGroupId(user.getGroupId());
        com.ovopark.organize.common.base.BaseResult levelPojoBase = this.organizeApi.getAllOrganizeByIds(levelPojo);
        if (levelPojoBase != null && !CollectionUtils.isEmpty((Collection)((Collection)levelPojoBase.getData()))) {
            levelMap = ((List)levelPojoBase.getData()).stream().collect(Collectors.groupingBy(OrganizePojo::getId));
        }
        for (String x2 : depNameList) {
            String[] strArr = x2.split(":");
            deptNames.add(strArr.length > 3 ? strArr[3] : x2);
            DeptDimensionDto deptDimensionDto = new DeptDimensionDto();
            int organizeLevel = 2;
            if (strArr.length > 2 && strArr[2] != null && !"null".equals(strArr[2])) {
                organizeLevel = Integer.parseInt(strArr[2]);
            } else {
                List levelPojoList = (List)levelMap.get(Integer.valueOf(strArr[0].substring(2)));
                if (!CollectionUtils.isEmpty((Collection)levelPojoList) && !org.springframework.util.StringUtils.isEmpty((Object)((OrganizePojo)levelPojoList.get(0)).getOrgCode())) {
                    organizeLevel = ((OrganizePojo)levelPojoList.get(0)).getOrgCode().length() / 4;
                }
            }
            deptDimensionDto.setOrganizeLevel(Integer.valueOf(organizeLevel));
            deptDimensionDto.setIsLeaf(Boolean.valueOf(strArr.length <= 1 || !Boolean.parseBoolean(strArr[1])));
            deptDimensionDto.setDeptId(strArr[0]);
            deptNameAndDetailMap.put(strArr.length > 3 ? strArr[3] : x2, deptDimensionDto);
        }
        Page depPage = new Page();
        if (request.getCountType().equals(0)) {
            depPage = Integer.valueOf(1).equals(request.getQueryType()) ? ListUtil.myPage(deptNames, 1, deptNames.size()) : ListUtil.myPage(deptNames, page.getPageNumber(), page.getPageSize());
        } else {
            List<LocalDate> dataLists = DateUtils.getDatesBetween(request.getBeginDay(), request.getEndDay());
            ArrayList keyAndVal = new ArrayList();
            deptNames.forEach(x -> dataLists.forEach(data -> {
                String newData = x + data;
                keyAndVal.add(newData);
                map.put(newData, x);
            }));
            depPage = Integer.valueOf(1).equals(request.getQueryType()) ? ListUtil.myPage(keyAndVal, 1, keyAndVal.size()) : ListUtil.myPage(keyAndVal, page.getPageNumber(), page.getPageSize());
        }
        page.setPageCount(depPage.getPageCount());
        page.setTotalCount(depPage.getTotalCount());
        depPage.getContent().forEach(x -> {
            DeptDimensionDto deptDimensionDto = new DeptDimensionDto();
            if (request.getCountType().equals(1)) {
                deptDimensionDto.setDeptName((String)map.get(x));
                deptDimensionDto.setCalDay(DateUtils.stringToLocalDate(x.substring(((String)map.get(x)).length())));
            } else {
                deptDimensionDto.setDeptName(x);
            }
            deptDimensionDtoLinkedList.add(deptDimensionDto);
        });
        deptDimensionDtoLinkedList.forEach(x -> {
            DeptDimensionDto organizeDto = (DeptDimensionDto)deptNameAndDetailMap.get(x.getDeptName());
            x.setIsLeaf(organizeDto.getIsLeaf()).setOrganizeLevel(organizeDto.getOrganizeLevel()).setDeptId(organizeDto.getDeptId());
            if (request.getCountType().equals(1)) {
                LocalDate beginDate = deptDimensionDtoLinkedList.stream().filter(deptDimensionDto -> deptDimensionDto.getDeptName().equals(x.getDeptName())).min(Comparator.comparing(DeptDimensionDto::getCalDay)).get().getCalDay();
                LocalDate endDate = deptDimensionDtoLinkedList.stream().filter(deptDimensionDto -> deptDimensionDto.getDeptName().equals(x.getDeptName())).max(Comparator.comparing(DeptDimensionDto::getCalDay)).get().getCalDay();
                x.setBeginTime(beginDate).setEndTime(endDate);
            } else {
                x.setBeginTime(request.getBeginDay()).setEndTime(request.getEndDay());
            }
        });
        return deptDimensionDtoLinkedList;
    }

    private Set<Integer> queryRelatedTrainUserIds(Set<Integer> userIds, List<Integer> roleIds, List<Integer> tagIds, List<String> organizeIds, Users user) {
        if (!CollectionUtils.isEmpty(roleIds)) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("groupId", user.getGroupId());
            String roleIdStr = StringUtils.join(roleIds, (String)",");
            map.put("roleIds", roleIdStr);
            BaseResult base = this.useApi.getUserMapByRoleIds(map);
            if (base != null && !CollectionUtils.isEmpty((Map)((Map)base.getData()))) {
                Map roleAndUserPojoMap = (Map)base.getData();
                roleAndUserPojoMap.forEach((k, v) -> userIds.addAll(v.stream().map(UsersPojo::getId).distinct().collect(Collectors.toList())));
            }
        }
        if (!CollectionUtils.isEmpty(tagIds)) {
            DepAndTagsPojo pojo = new DepAndTagsPojo();
            pojo.setTagIds(tagIds);
            pojo.setGroupId(user.getGroupId());
            com.ovopark.organize.common.base.BaseResult base = this.tagApi.getUsersByTagIds(pojo);
            if (!base.getIsError().booleanValue() && !CollectionUtils.isEmpty((Collection)((Collection)base.getData()))) {
                userIds.addAll(((List)base.getData()).stream().map(UserTagMo::getId).distinct().collect(Collectors.toList()));
            }
        }
        if (!CollectionUtils.isEmpty(organizeIds)) {
            UsersAndOrgsMo mo = new UsersAndOrgsMo();
            mo.setGroupId(user.getGroupId());
            mo.setOrganizeIds(organizeIds);
            com.ovopark.organize.common.base.BaseResult userResult = this.userOrganizeApi.getUserByOrganizeIdsOrDepId(mo);
            if (!userResult.getIsError().booleanValue() && !CollectionUtils.isEmpty((Collection)((Collection)userResult.getData()))) {
                userIds.addAll(((List)userResult.getData()).stream().map(UserAndParentNameMo::getUserId).distinct().collect(Collectors.toList()));
            }
        }
        return userIds;
    }

    private Map<String, List<Integer>> operateDeptInfoAndGetNameList(Map<String, List<Integer>> baseData, Page page, Integer queryType) {
        Map<String, List<Integer>> organizeBaseMap = baseData;
        HashMap<String, List<Integer>> map = new HashMap<String, List<Integer>>();
        List<String> depNameList = new ArrayList<String>(organizeBaseMap.keySet());
        depNameList = depNameList.stream().filter(item -> !item.contains("\u672a\u5206\u7ec4")).collect(Collectors.toList());
        if (null == queryType || queryType != 1) {
            Page<String> depPage = ListUtil.myPage(depNameList, page.getPageNumber(), page.getPageSize());
            depNameList = depPage.getContent();
        }
        for (String x : depNameList) {
            String[] strArr = x.split(":");
            map.put(strArr.length > 3 ? strArr[3] : x, organizeBaseMap.get(x));
        }
        return map;
    }

    private com.ovopark.organize.common.base.BaseResult<Map<String, List<Integer>>> queryDeptAndUserCount(DeptSummarizeQueryRequest request, Users user) {
        UsersOrgIdsAndTagsPojo usersOrgIdsAndTagsPojo = new UsersOrgIdsAndTagsPojo();
        usersOrgIdsAndTagsPojo.setGroupId(user.getGroupId());
        usersOrgIdsAndTagsPojo.setLevel(Integer.valueOf(org.springframework.util.StringUtils.isEmpty((Object)request.getOrganizeLevel()) ? 1 : request.getOrganizeLevel()));
        usersOrgIdsAndTagsPojo.setShowIdAndName(Boolean.TRUE);
        if (org.springframework.util.StringUtils.isEmpty((Object)request.getParentId()) && !CollectionUtils.isEmpty((Collection)request.getOrganizeIdList())) {
            com.ovopark.organize.common.base.BaseResult baseResult;
            ArrayList<Integer> orIds = new ArrayList<Integer>();
            ArrayList<String> depS = new ArrayList<String>();
            for (String or : request.getOrganizeIdList()) {
                String[] str = or.split("_");
                if (str.length <= 1) continue;
                if ("O".equals(str[0])) {
                    Integer orId = Integer.valueOf(str[1]);
                    orIds.add(orId);
                    continue;
                }
                depS.add(or);
            }
            if (!CollectionUtils.isEmpty(depS) && (baseResult = this.departmentApi.changOrganizeIdsSdk(user.getGroupId(), depS)) != null && !CollectionUtils.isEmpty((Collection)((Collection)baseResult.getData()))) {
                orIds.addAll((Collection)baseResult.getData());
            }
            usersOrgIdsAndTagsPojo.setOrganizeId(orIds);
            Integer organizeLevel = null;
            com.ovopark.organize.common.base.BaseResult base = this.organizeApi.getOrganizeById((Integer)orIds.get(0));
            if (base != null && !org.springframework.util.StringUtils.isEmpty((Object)base.getData()) && !org.springframework.util.StringUtils.isEmpty((Object)((OrganizePojo)base.getData()).getOrgCode())) {
                organizeLevel = ((OrganizePojo)base.getData()).getOrgCode().length() / 4;
            }
            usersOrgIdsAndTagsPojo.setLevel(organizeLevel);
        }
        usersOrgIdsAndTagsPojo.setParentId(org.springframework.util.StringUtils.isEmpty((Object)request.getParentId()) ? null : Integer.valueOf(request.getParentId().substring(2)));
        return this.userOrganizeApi.getUserByLevel(usersOrgIdsAndTagsPojo);
    }

    public List<Integer> getUserIdListByRoleAndOrganize(List<Integer> roleIdList, String showName, List<String> organizeIdList, Users user, List<Integer> userStatus, List<String> deptIds) {
        HashSet<Integer> canWatchUserId = new HashSet<Integer>();
        if (userStatus.contains(0)) {
            List<Integer> userIdList = this.userUtilService.selectChildUserList(null, user, false);
            if (!CollectionUtils.isEmpty(roleIdList)) {
                List<Integer> userIds1 = this.userUtilService.selectUsersByRoles(roleIdList, user.getGroupId());
                userIdList.retainAll(userIds1);
            }
            if (!CollectionUtils.isEmpty(organizeIdList) || !org.springframework.util.StringUtils.isEmpty((Object)showName)) {
                Map<String, Object> userMap = this.userUtilService.getCheckParameters(showName, null, organizeIdList, user);
                List idList = (List)userMap.get("userList");
                userIdList.retainAll(idList);
            }
            canWatchUserId.addAll(userIdList);
        }
        if (userStatus.contains(1)) {
            ArrayList forzenUserIds = new ArrayList();
            List deptIdList = deptIds.stream().map(x -> x.substring(2)).collect(Collectors.toList());
            String organizeIdStr = String.join((CharSequence)",", deptIdList);
            UsersPagePojo usersPagePojo = new UsersPagePojo();
            usersPagePojo.setOrganizeId(organizeIdStr);
            usersPagePojo.setFrozenNum(Integer.valueOf(1));
            usersPagePojo.setUserId(user.getId());
            usersPagePojo.setPageSize(Integer.valueOf(Integer.MAX_VALUE));
            com.ovopark.organize.common.base.BaseResult frozenMapRes = this.organizeUserApi.getUsersPageSdk(usersPagePojo);
            if (frozenMapRes != null && MapUtil.isNotEmpty((Map)((Map)frozenMapRes.getData()))) {
                ((Map)frozenMapRes.getData()).forEach((k, v) -> {
                    if ("data".equals(k)) {
                        List lists = (List)v;
                        lists.forEach(userPojo -> userPojo.forEach((k3, v3) -> {
                            if ("id".equals(k3)) {
                                forzenUserIds.add(Integer.valueOf((Integer)v3));
                            }
                        }));
                    }
                });
            }
            canWatchUserId.addAll(forzenUserIds);
        }
        return new ArrayList<Integer>(canWatchUserId);
    }

    private Set<Integer> queryDeptEnableUser(List<String> privilegeNames, Integer groupId) {
        HashSet<Integer> userIdSet = new HashSet<Integer>();
        if (privilegeNames.contains("TRAINING")) {
            userIdSet.addAll(this.queryDeptAndEnableUser(groupId, "TRAINING"));
        }
        if (privilegeNames.contains("KNOWLEDGE_LIBRARY")) {
            userIdSet.addAll(this.queryDeptAndEnableUser(groupId, "KNOWLEDGE_LIBRARY"));
        }
        if (privilegeNames.contains("KNOWLEDGE_MATERIAL")) {
            userIdSet.addAll(this.queryDeptAndEnableUser(groupId, "KNOWLEDGE_MATERIAL"));
        }
        if (privilegeNames.contains("LEARNING_TASK")) {
            userIdSet.addAll(this.queryDeptAndEnableUser(groupId, "LEARNING_TASK"));
        }
        if (privilegeNames.contains("EXAM_MANAGE_APP")) {
            userIdSet.addAll(this.queryDeptAndEnableUser(groupId, "EXAM_MANAGE_APP"));
        }
        log.info("\u67e5\u8be2\u542f\u7528\u4eba\u6570\uff0c\u6a21\u5757\uff1a{},\u4f01\u4e1aid:{},\u542f\u7528\u4eba\u6570\u6570\u91cf\u4e3a\uff1a{}", new Object[]{JSONUtil.toJsonStr(privilegeNames), groupId, userIdSet.size()});
        return userIdSet;
    }

    private List<Integer> queryDeptAndEnableUser(Integer groupId, String privilegeName) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("groupId", groupId);
        parameters.put("privilegeName", privilegeName);
        BaseResult result = this.useApi.getHasPrivilegeUserIdList(parameters);
        if (result != null && !CollectionUtils.isEmpty((Collection)((Collection)result.getData()))) {
            return (List)result.getData();
        }
        return Collections.emptyList();
    }
}

