/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.training.service.impl;

import com.alibaba.fastjson.JSON;
import com.ovopark.training.service.KafkaProducerService;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.kafka.support.SendResult;
import org.springframework.stereotype.Service;
import org.springframework.util.concurrent.ListenableFuture;

@Service
public class KafkaProducerServiceImpl
implements KafkaProducerService {
    private static final Logger log = LoggerFactory.getLogger(KafkaProducerServiceImpl.class);
    @Autowired
    private KafkaTemplate<String, String> kafkaTemplate;
    public static final String KAFKA_SEND_SUCCESS_MES = "\u53d1\u9001\u6210\u529f";
    public static final String KAFKA_SEND_ERROR_MES = "\u53d1\u9001\u6d88\u606f\u8d85\u65f6";
    public static final String KAFKA_NO_RESULT_MES = "\u672a\u67e5\u8be2\u5230\u8fd4\u56de\u7ed3\u679c";
    public static final String KAFKA_NO_OFFSET_MES = "\u672a\u67e5\u5230\u8fd4\u56de\u6570\u636e\u7684offset";

    @Override
    public Map<String, Object> sndMesForTemplate(String topic, Object value, Integer isPartition, Integer partitionNum, String role) {
        String key = role + "-" + value.hashCode();
        String valueString = JSON.toJSONString((Object)value);
        if (isPartition == 1) {
            int partitionIndex = this.getPartitionIndex(key, partitionNum);
            ListenableFuture result = this.kafkaTemplate.send(topic, Integer.valueOf(partitionIndex), (Object)key, (Object)valueString);
            Map<String, Object> res = this.checkProRecord((ListenableFuture<SendResult<String, String>>)result);
            return res;
        }
        ListenableFuture result = this.kafkaTemplate.send(topic, (Object)key, (Object)valueString);
        Map<String, Object> res = this.checkProRecord((ListenableFuture<SendResult<String, String>>)result);
        return res;
    }

    @Override
    public Map<String, Object> sndMesForTemplate(Object value) {
        log.info("sndMesForTemplate=====start");
        String valueString = JSON.toJSONString((Object)value);
        log.info("sndMesForTemplate=====valueString:" + valueString);
        return null;
    }

    private int getPartitionIndex(String key, int partitionNum) {
        if (key == null) {
            Random random = new Random();
            return random.nextInt(partitionNum);
        }
        int result = Math.abs(key.hashCode()) % partitionNum;
        return result;
    }

    public Map<String, Object> checkProRecord(ListenableFuture<SendResult<String, String>> res) {
        HashMap<String, Object> m = new HashMap<String, Object>();
        if (res != null) {
            try {
                SendResult r = (SendResult)res.get();
                Long offsetIndex = r.getRecordMetadata().offset();
                if (offsetIndex != null && offsetIndex >= 0L) {
                    m.put("message", KAFKA_SEND_SUCCESS_MES);
                    return m;
                }
                m.put("message", KAFKA_NO_OFFSET_MES);
                return m;
            }
            catch (InterruptedException e) {
                log.error("", (Throwable)e);
                m.put("message", KAFKA_SEND_ERROR_MES);
                return m;
            }
            catch (ExecutionException e) {
                log.error("", (Throwable)e);
                m.put("message", KAFKA_SEND_ERROR_MES);
                return m;
            }
        }
        m.put("message", KAFKA_NO_RESULT_MES);
        return m;
    }
}

