/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.training.service.impl;

import cn.hutool.core.date.DateUtil;
import cn.hutool.json.JSONUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.ovopark.organize.common.model.pojo.UsersPojo;
import com.ovopark.training.bo.Page;
import com.ovopark.training.dto.BigDecimalDataDto;
import com.ovopark.training.dto.ChangeSituationDto;
import com.ovopark.training.dto.IntegerDataDetailDto;
import com.ovopark.training.dto.LearningCountDto;
import com.ovopark.training.dto.LearningCountInfoDto;
import com.ovopark.training.dto.PaperCountDto;
import com.ovopark.training.dto.PaperSessionsDto;
import com.ovopark.training.dto.SameSourcePaperCountInfoDto;
import com.ovopark.training.dto.StudyRankingDto;
import com.ovopark.training.dto.TimeFrameDto;
import com.ovopark.training.dto.TimeFrameSectioneDto;
import com.ovopark.training.dto.TrainingCountDto;
import com.ovopark.training.dto.TrainingRankingDto;
import com.ovopark.training.dto.UserOperateInfoDto;
import com.ovopark.training.dto.UserPaperInfoDto;
import com.ovopark.training.mapper.OperateCheckMapper;
import com.ovopark.training.mapper.TrainingExamMapper;
import com.ovopark.training.mapper.TrainingMapper;
import com.ovopark.training.mapper.TrainingPaperMapper;
import com.ovopark.training.mapper.TrainingUserPaperMapper;
import com.ovopark.training.mapper.TrainingUserViewTimeDayMapper;
import com.ovopark.training.mapper.TrainingUserViewTimeMapper;
import com.ovopark.training.mapper.UserOperateMapper;
import com.ovopark.training.model.OperateCheck;
import com.ovopark.training.model.TrainingExam;
import com.ovopark.training.model.TrainingPaper;
import com.ovopark.training.model.Users;
import com.ovopark.training.request.LearningOverviewReq;
import com.ovopark.training.service.LearningOverviewService;
import com.ovopark.training.service.UserUtilService;
import com.ovopark.training.util.DateUtils;
import com.ovopark.training.vo.CourseRankingVo;
import com.ovopark.training.vo.DataScreeningVo;
import com.ovopark.training.vo.PaperInfoVo;
import com.ovopark.training.vo.PaperTrendVo;
import com.ovopark.training.vo.StudyRankingVo;
import com.ovopark.training.vo.StudyTrendVo;
import com.ovopark.training.vo.TrainingInfoVo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class LearningOverviewServiceImpl
implements LearningOverviewService {
    private static final Logger log = LoggerFactory.getLogger(LearningOverviewServiceImpl.class);
    @Autowired
    private TrainingMapper trainingMapper;
    @Autowired
    private UserUtilService userUtilService;
    @Autowired
    private OperateCheckMapper operateCheckMapper;
    @Autowired
    private TrainingPaperMapper trainingPaperMapper;
    @Autowired
    private TrainingUserViewTimeMapper trainingUserViewTimeMapper;
    @Autowired
    private TrainingUserViewTimeDayMapper trainingUserViewTimeDayMapper;
    @Autowired
    private TrainingUserPaperMapper trainingUserPaperMapper;
    @Autowired
    private UserOperateMapper userOperateMapper;
    @Autowired
    private TrainingExamMapper trainingExamMapper;

    @Override
    public DataScreeningVo getDataScreening(LearningOverviewReq learningOverviewReq, Users user) {
        Integer selectType = learningOverviewReq.getSelectType();
        switch (selectType) {
            case 1: {
                return this.getLearningInfo(learningOverviewReq, user);
            }
            case 2: {
                return this.getPaperAndOperateInfo(learningOverviewReq, user);
            }
        }
        throw new RuntimeException("\u53c2\u6570\u5f02\u5e38");
    }

    private DataScreeningVo getLearningInfo(LearningOverviewReq learningOverviewReq, Users user) {
        TimeFrameDto timeFrameByCycleType = this.getTimeFrameByCycleType(new Date(), learningOverviewReq.getCountCycleType());
        log.info("\u7edf\u8ba1\u65f6\u95f4\u8303\u56f4\uff1a{}", (Object)JSONUtil.toJsonStr((Object)timeFrameByCycleType));
        Date countStartTime = timeFrameByCycleType.getCountStartTime();
        Date countEndTime = timeFrameByCycleType.getCountEndTime();
        List<TimeFrameSectioneDto> timeFrameSectioneList = timeFrameByCycleType.getTimeFrameSectioneList().stream().sorted(Comparator.comparing(TimeFrameSectioneDto::getSortId)).collect(Collectors.toList());
        log.info("\u7528\u6237\u4fe1\u606f\uff1a{}", (Object)user);
        List<Integer> canSeeUserIdList = this.getCanSeeUserIdListByUser(user);
        if (CollectionUtils.isEmpty(canSeeUserIdList)) {
            return new DataScreeningVo();
        }
        int allUserSize = canSeeUserIdList.size();
        DataScreeningVo result = new DataScreeningVo();
        List<LearningCountInfoDto> allLearingCountInfo = this.trainingUserViewTimeDayMapper.getAllLearningCountInfo(user.getGroupId(), countStartTime, countEndTime, canSeeUserIdList);
        Map<Integer, LearningCountDto> allLearningMapByTime = this.getAllLearning(allLearingCountInfo, user, canSeeUserIdList, countStartTime, countEndTime, timeFrameSectioneList);
        Map<Integer, LearningCountDto> allPaperAndOperateMapByTime = this.getPaperAndOperateLearing(user, canSeeUserIdList, countStartTime, countEndTime, timeFrameSectioneList, 4);
        ArrayList res = new ArrayList();
        timeFrameSectioneList.forEach(timeFrameSectioneDto -> {
            LearningCountDto allPaperAndOperate;
            Integer sortId = timeFrameSectioneDto.getSortId();
            ArrayList userIdList = new ArrayList();
            Long viewTime = 0L;
            LearningCountDto allLearning = (LearningCountDto)allLearningMapByTime.get(sortId);
            if (allLearning != null) {
                userIdList.addAll(allLearning.getUserIdList());
                viewTime = viewTime + allLearning.getViewTime();
            }
            if ((allPaperAndOperate = (LearningCountDto)allPaperAndOperateMapByTime.get(sortId)) != null) {
                userIdList.addAll(allPaperAndOperate.getUserIdList());
                viewTime = viewTime + allPaperAndOperate.getViewTime();
            }
            DataScreeningVo dataScreeningVo = new DataScreeningVo();
            int studyUserNum = userIdList.stream().distinct().collect(Collectors.toList()).size();
            dataScreeningVo.setStudyUserNum(Integer.valueOf(studyUserNum));
            dataScreeningVo.setStudyRate(BigDecimal.valueOf(studyUserNum).multiply(new BigDecimal(100)).divide(BigDecimal.valueOf(allUserSize), 2, 4));
            if (studyUserNum == 0) {
                dataScreeningVo.setPreUserStudyTime(new BigDecimal(0));
            } else {
                dataScreeningVo.setPreUserStudyTime(BigDecimal.valueOf(viewTime).divide(new BigDecimal(3600), 2, 4).divide(new BigDecimal(studyUserNum), 2, 4));
            }
            res.add(dataScreeningVo);
        });
        if (res.size() == 1) {
            return (DataScreeningVo)res.get(0);
        }
        DataScreeningVo compareDataScreening = (DataScreeningVo)res.get(0);
        DataScreeningVo dataScreening = (DataScreeningVo)res.get(1);
        BeanUtils.copyProperties((Object)dataScreening, (Object)result);
        result.setStudyUserNumChangeSituation(this.getIntegerChangeSituation(compareDataScreening.getStudyUserNum(), dataScreening.getStudyUserNum()));
        result.setStudyRateChangeSituation(this.getBigDecimalChangeSituation(compareDataScreening.getStudyRate(), dataScreening.getStudyRate()));
        result.setPreUserStudyTimeChangeSituation(this.getBigDecimalChangeSituation(compareDataScreening.getPreUserStudyTime(), dataScreening.getPreUserStudyTime()));
        log.info("\u5b66\u5458\u5b66\u4e60\u60c5\u51b5\uff1a{}", (Object)JSONUtil.toJsonStr((Object)result));
        return result;
    }

    private DataScreeningVo getPaperAndOperateInfo(LearningOverviewReq learningOverviewReq, Users user) {
        TimeFrameDto timeFrameByCycleType = this.getTimeFrameByCycleType(new Date(), learningOverviewReq.getCountCycleType());
        log.info("\u7edf\u8ba1\u65f6\u95f4\u8303\u56f4\uff1a{}", (Object)JSONUtil.toJsonStr((Object)timeFrameByCycleType));
        Date countStartTime = timeFrameByCycleType.getCountStartTime();
        Date countEndTime = timeFrameByCycleType.getCountEndTime();
        List<TimeFrameSectioneDto> timeFrameSectioneList = timeFrameByCycleType.getTimeFrameSectioneList().stream().sorted(Comparator.comparing(TimeFrameSectioneDto::getSortId)).collect(Collectors.toList());
        log.info("\u7528\u6237\u4fe1\u606f\uff1a{}", (Object)user);
        List<Integer> canSeeUserIdList = this.getCanSeeUserIdListByUser(user);
        if (CollectionUtils.isEmpty(canSeeUserIdList)) {
            return new DataScreeningVo();
        }
        DataScreeningVo result = new DataScreeningVo();
        Map<Integer, PaperCountDto> paperCheck = this.getPaperCheck(user, canSeeUserIdList, countStartTime, countEndTime, timeFrameSectioneList);
        Map<Integer, PaperCountDto> operateCheck = this.getOperateCheck(user, canSeeUserIdList, countStartTime, countEndTime, timeFrameSectioneList);
        ArrayList res = new ArrayList();
        timeFrameSectioneList.forEach(timeFrameSectioneDto -> {
            PaperCountDto operateCheckDto;
            Integer sortId = timeFrameSectioneDto.getSortId();
            ArrayList userIdList = new ArrayList();
            Long viewTime = 0L;
            DataScreeningVo dataScreeningVo = new DataScreeningVo();
            int checkUserTimes = 0;
            int passCheckUserTimes = 0;
            PaperCountDto paperCheckDto = (PaperCountDto)paperCheck.get(sortId);
            if (paperCheckDto != null) {
                checkUserTimes += paperCheckDto.getUserTimes().intValue();
                passCheckUserTimes += paperCheckDto.getPassUserTimes().intValue();
            }
            if ((operateCheckDto = (PaperCountDto)operateCheck.get(sortId)) != null) {
                checkUserTimes += operateCheckDto.getUserTimes().intValue();
                passCheckUserTimes += operateCheckDto.getPassUserTimes().intValue();
            }
            dataScreeningVo.setPaperUserNum(Integer.valueOf(checkUserTimes));
            dataScreeningVo.setPassPaperUserNum(Integer.valueOf(passCheckUserTimes));
            if (checkUserTimes == 0) {
                dataScreeningVo.setPassPaperRate(new BigDecimal(0));
            } else {
                dataScreeningVo.setPassPaperRate(BigDecimal.valueOf(passCheckUserTimes).multiply(new BigDecimal(100)).divide(BigDecimal.valueOf(checkUserTimes), 2, 4));
            }
            res.add(dataScreeningVo);
        });
        if (res.size() == 1) {
            return (DataScreeningVo)res.get(0);
        }
        DataScreeningVo compareDataScreening = (DataScreeningVo)res.get(0);
        DataScreeningVo dataScreening = (DataScreeningVo)res.get(1);
        BeanUtils.copyProperties((Object)dataScreening, (Object)result);
        result.setPaperUserNumChangeSituation(this.getIntegerChangeSituation(compareDataScreening.getPaperUserNum(), dataScreening.getPaperUserNum()));
        result.setPassPaperUserNumChangeSituation(this.getIntegerChangeSituation(compareDataScreening.getPassPaperUserNum(), dataScreening.getPassPaperUserNum()));
        result.setPassPaperRateChangeSituation(this.getBigDecimalChangeSituation(compareDataScreening.getPassPaperRate(), dataScreening.getPassPaperRate()));
        log.info("\u5b66\u5458\u8003\u8bd5\u60c5\u51b5\uff1a{}", (Object)JSONUtil.toJsonStr((Object)result));
        return result;
    }

    private Map<Integer, LearningCountDto> getAllLearning(List<LearningCountInfoDto> allLearingCountInfo, Users user, List<Integer> canSeeUserIdList, Date countStartTime, Date countEndTime, List<TimeFrameSectioneDto> timeFrameSectioneList) {
        ArrayList res = new ArrayList();
        timeFrameSectioneList.forEach(timeFrameSectioneDto -> {
            LearningCountDto learningCountDto = new LearningCountDto();
            learningCountDto.setDateSortId(timeFrameSectioneDto.getSortId());
            Date startTime = timeFrameSectioneDto.getStartTime();
            Date endTime = timeFrameSectioneDto.getEndTime();
            List<Object> timeSectionTrainingDataInfo = new ArrayList();
            long trainingViewTime = 0L;
            List<Object> trainingUserIdList = new ArrayList();
            if (!CollectionUtils.isEmpty((Collection)allLearingCountInfo) && !CollectionUtils.isEmpty(timeSectionTrainingDataInfo = allLearingCountInfo.stream().filter(learningCountInfoDto -> {
                Date createTime = learningCountInfoDto.getCreateTime();
                if (startTime == null) {
                    return createTime.before(endTime);
                }
                return createTime.after(startTime) && createTime.before(endTime);
            }).collect(Collectors.toList()))) {
                trainingViewTime = timeSectionTrainingDataInfo.stream().mapToLong(LearningCountInfoDto::getViewTime).sum();
                trainingUserIdList = timeSectionTrainingDataInfo.stream().map(LearningCountInfoDto::getUserId).distinct().collect(Collectors.toList());
            }
            learningCountDto.setViewTime(Long.valueOf(trainingViewTime));
            learningCountDto.setUserIdList(trainingUserIdList.stream().distinct().collect(Collectors.toList()));
            res.add(learningCountDto);
        });
        Map<Integer, LearningCountDto> result = res.stream().collect(Collectors.toMap(LearningCountDto::getDateSortId, learningCountDto -> learningCountDto));
        return result;
    }

    private Map<Integer, PaperCountDto> getOperateCheck(Users user, List<Integer> canSeeUserIdList, Date countStartTime, Date countEndTime, List<TimeFrameSectioneDto> timeFrameSectioneList) {
        ArrayList<PaperCountDto> res = new ArrayList<PaperCountDto>();
        List<UserOperateInfoDto> allUserOperateInfoDtoList = this.userOperateMapper.getUserOperateInfoByUserByDate(canSeeUserIdList, countStartTime, countEndTime, user.getGroupId());
        if (CollectionUtils.isEmpty(allUserOperateInfoDtoList)) {
            return new HashMap<Integer, PaperCountDto>();
        }
        for (TimeFrameSectioneDto timeFrameSectioneDto : timeFrameSectioneList) {
            PaperCountDto paperCountDto2 = new PaperCountDto();
            paperCountDto2.setDateSortId(timeFrameSectioneDto.getSortId());
            Date startTime = timeFrameSectioneDto.getStartTime();
            Date endTime = timeFrameSectioneDto.getEndTime();
            List userOperateInfoDtoList = allUserOperateInfoDtoList.stream().filter(userOperateInfoDto -> {
                Date createTime = userOperateInfoDto.getCreateTime();
                Date finishTime = userOperateInfoDto.getFinishTime();
                if (startTime == null) {
                    return createTime.before(endTime);
                }
                return createTime.after(startTime) && finishTime.before(endTime);
            }).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(userOperateInfoDtoList)) continue;
            AtomicInteger passCheckUserTimes = new AtomicInteger(0);
            AtomicInteger checkUserTimes = new AtomicInteger(0);
            ArrayList<Integer> passCheckUserIdList = new ArrayList<Integer>();
            ArrayList<Integer> checkUserIdList = new ArrayList<Integer>();
            Map<Integer, List<UserOperateInfoDto>> userOperateInfoMapByUserId = userOperateInfoDtoList.stream().collect(Collectors.groupingBy(UserOperateInfoDto::getOperateCheckId));
            for (Map.Entry<Integer, List<UserOperateInfoDto>> operateUserInfoEntry : userOperateInfoMapByUserId.entrySet()) {
                Optional<UserOperateInfoDto> maxScoreCheck;
                Integer checkNum;
                List<UserOperateInfoDto> value;
                Integer userId;
                Map<Integer, List<UserOperateInfoDto>> userOperateInfoByUserId;
                List<UserOperateInfoDto> userOperateInfoList = operateUserInfoEntry.getValue();
                if (CollectionUtils.isEmpty(userOperateInfoList)) continue;
                Integer scoreChoice = userOperateInfoList.get(0).getCheckScoreChoice();
                Integer minCheckNum = userOperateInfoList.get(0).getMinCheckNum();
                if (scoreChoice == 0) {
                    userOperateInfoByUserId = userOperateInfoList.stream().collect(Collectors.groupingBy(UserOperateInfoDto::getUserId));
                    for (Map.Entry<Integer, List<UserOperateInfoDto>> userOperateInfoByUserIdEntry : userOperateInfoByUserId.entrySet()) {
                        userId = userOperateInfoByUserIdEntry.getKey();
                        value = userOperateInfoByUserIdEntry.getValue();
                        checkNum = value.size();
                        if (checkNum < minCheckNum) {
                            checkUserTimes.incrementAndGet();
                            checkUserIdList.add(userId);
                            continue;
                        }
                        maxScoreCheck = value.stream().sorted(Comparator.comparing(UserOperateInfoDto::getScore).reversed()).findFirst();
                        if (!maxScoreCheck.isPresent()) continue;
                        checkUserTimes.incrementAndGet();
                        checkUserIdList.add(userId);
                        if (maxScoreCheck.get().getIsPass() != 1) continue;
                        passCheckUserTimes.incrementAndGet();
                        passCheckUserIdList.add(userId);
                    }
                    continue;
                }
                if (scoreChoice != 1) continue;
                userOperateInfoByUserId = userOperateInfoList.stream().collect(Collectors.groupingBy(UserOperateInfoDto::getUserId));
                for (Map.Entry<Integer, List<UserOperateInfoDto>> userOperateInfoByUserIdEntry : userOperateInfoByUserId.entrySet()) {
                    userId = userOperateInfoByUserIdEntry.getKey();
                    value = userOperateInfoByUserIdEntry.getValue();
                    checkNum = value.size();
                    if (checkNum < minCheckNum) {
                        checkUserTimes.incrementAndGet();
                        checkUserIdList.add(userId);
                        continue;
                    }
                    maxScoreCheck = value.stream().sorted(Comparator.comparing(UserOperateInfoDto::getFinishTime).reversed()).findFirst();
                    if (!maxScoreCheck.isPresent()) continue;
                    checkUserTimes.incrementAndGet();
                    checkUserIdList.add(userId);
                    if (maxScoreCheck.get().getIsPass() != 1) continue;
                    passCheckUserTimes.incrementAndGet();
                    passCheckUserIdList.add(userId);
                }
            }
            paperCountDto2.setUserTimes(Integer.valueOf(checkUserTimes.get()));
            paperCountDto2.setPassUserTimes(Integer.valueOf(passCheckUserTimes.get()));
            paperCountDto2.setUserIdList(checkUserIdList.stream().distinct().collect(Collectors.toList()));
            paperCountDto2.setPassUserIdList(passCheckUserIdList.stream().distinct().collect(Collectors.toList()));
            res.add(paperCountDto2);
        }
        Map<Integer, PaperCountDto> result = res.stream().collect(Collectors.toMap(PaperCountDto::getDateSortId, paperCountDto -> paperCountDto));
        return result;
    }

    private Map<Integer, PaperCountDto> getPaperCheck(Users user, List<Integer> canSeeUserIdList, Date countStartTime, Date countEndTime, List<TimeFrameSectioneDto> timeFrameSectioneList) {
        ArrayList<PaperCountDto> res = new ArrayList<PaperCountDto>();
        List<UserPaperInfoDto> allUserPaperInfoDtoList = this.trainingUserPaperMapper.getUserPaperInfoByUserByDate(canSeeUserIdList, countStartTime, countEndTime, user.getGroupId());
        if (CollectionUtils.isEmpty(allUserPaperInfoDtoList)) {
            return new HashMap<Integer, PaperCountDto>();
        }
        List examIdList = allUserPaperInfoDtoList.stream().map(UserPaperInfoDto::getExamId).distinct().collect(Collectors.toList());
        List trainingExams = this.trainingExamMapper.selectBatchIds(examIdList);
        Map<Integer, BigDecimal> examIdScoreMap = trainingExams.stream().collect(Collectors.toMap(TrainingExam::getId, TrainingExam::getScore, (oldData, newData) -> oldData));
        for (TimeFrameSectioneDto timeFrameSectioneDto : timeFrameSectioneList) {
            PaperCountDto paperCountDto2 = new PaperCountDto();
            paperCountDto2.setDateSortId(timeFrameSectioneDto.getSortId());
            Date startTime = timeFrameSectioneDto.getStartTime();
            Date endTime = timeFrameSectioneDto.getEndTime();
            List userPaperInfoDtoList = allUserPaperInfoDtoList.stream().filter(userPaperInfoDto -> {
                Date createTime = userPaperInfoDto.getCreateTime();
                Date submitTime = userPaperInfoDto.getSubmitTime();
                if (startTime == null) {
                    return createTime.before(endTime);
                }
                return createTime.after(startTime) && submitTime.before(endTime);
            }).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(userPaperInfoDtoList)) continue;
            AtomicInteger passPaperUserTimes = new AtomicInteger(0);
            AtomicInteger paperUserTimes = new AtomicInteger(0);
            ArrayList passPaperUserIdList = new ArrayList();
            ArrayList paperUserIdList = new ArrayList();
            Map<Integer, List<UserPaperInfoDto>> userPaperInfoMapByUserId = userPaperInfoDtoList.stream().collect(Collectors.groupingBy(UserPaperInfoDto::getPaperId));
            for (Map.Entry<Integer, List<UserPaperInfoDto>> entry : userPaperInfoMapByUserId.entrySet()) {
                List<UserPaperInfoDto> userPaperInfoList = entry.getValue();
                if (CollectionUtils.isEmpty(userPaperInfoList)) continue;
                Integer passLine = userPaperInfoList.get(0).getPassLine();
                Integer examId = userPaperInfoList.get(0).getExamId();
                BigDecimal examScore = examIdScoreMap.get(examId);
                if (null == examScore) continue;
                BigDecimal passScore = examScore.multiply(new BigDecimal(StringUtils.isEmpty((Object)passLine) ? 60 : passLine)).divide(new BigDecimal(100), 2, 4);
                Map paperInfoGroupBySourceType = userPaperInfoList.stream().collect(Collectors.groupingBy(UserPaperInfoDto::getSourceType, Collectors.toList()));
                paperInfoGroupBySourceType.forEach((sourceType, userPaperInfoListBySourceType) -> {
                    if (sourceType == 2) {
                        SameSourcePaperCountInfoDto sameSourcePaperCountInfoDto = this.countSameSourcePaperInfo((List<UserPaperInfoDto>)userPaperInfoListBySourceType, passScore);
                        paperUserTimes.addAndGet(sameSourcePaperCountInfoDto.getPaperUserTimes().get());
                        paperUserIdList.addAll(sameSourcePaperCountInfoDto.getPaperUserIdList());
                        passPaperUserTimes.addAndGet(sameSourcePaperCountInfoDto.getPassPaperUserTimes().get());
                        passPaperUserIdList.addAll(sameSourcePaperCountInfoDto.getPassPaperUserIdList());
                    } else if (sourceType == 1) {
                        Map paperInfoGroupBySourceProjectId = userPaperInfoListBySourceType.stream().collect(Collectors.groupingBy(UserPaperInfoDto::getSourceProjectId, Collectors.toList()));
                        paperInfoGroupBySourceProjectId.forEach((sourceProjectId, userPaperInfoListBySourceProjectId) -> {
                            SameSourcePaperCountInfoDto sameSourcePaperCountInfoDto = this.countSameSourcePaperInfo((List<UserPaperInfoDto>)userPaperInfoListBySourceProjectId, passScore);
                            paperUserTimes.addAndGet(sameSourcePaperCountInfoDto.getPaperUserTimes().get());
                            paperUserIdList.addAll(sameSourcePaperCountInfoDto.getPaperUserIdList());
                            passPaperUserTimes.addAndGet(sameSourcePaperCountInfoDto.getPassPaperUserTimes().get());
                            passPaperUserIdList.addAll(sameSourcePaperCountInfoDto.getPassPaperUserIdList());
                        });
                    } else {
                        Map paperInfoGroupBySourceTaskId = userPaperInfoListBySourceType.stream().filter(dto -> dto.getSourceTaskId() != null).collect(Collectors.groupingBy(UserPaperInfoDto::getSourceTaskId, Collectors.toList()));
                        paperInfoGroupBySourceTaskId.forEach((sourceTaskId, userPaperInfoListBySourceTaskId) -> {
                            SameSourcePaperCountInfoDto sameSourcePaperCountInfoDto = this.countSameSourcePaperInfo((List<UserPaperInfoDto>)userPaperInfoListBySourceTaskId, passScore);
                            paperUserTimes.addAndGet(sameSourcePaperCountInfoDto.getPaperUserTimes().get());
                            paperUserIdList.addAll(sameSourcePaperCountInfoDto.getPaperUserIdList());
                            passPaperUserTimes.addAndGet(sameSourcePaperCountInfoDto.getPassPaperUserTimes().get());
                            passPaperUserIdList.addAll(sameSourcePaperCountInfoDto.getPassPaperUserIdList());
                        });
                    }
                });
            }
            paperCountDto2.setUserTimes(Integer.valueOf(paperUserTimes.get()));
            paperCountDto2.setPassUserTimes(Integer.valueOf(passPaperUserTimes.get()));
            paperCountDto2.setUserIdList(paperUserIdList.stream().distinct().collect(Collectors.toList()));
            paperCountDto2.setPassUserIdList(passPaperUserIdList.stream().distinct().collect(Collectors.toList()));
            res.add(paperCountDto2);
        }
        Map<Integer, PaperCountDto> result = res.stream().collect(Collectors.toMap(PaperCountDto::getDateSortId, paperCountDto -> paperCountDto));
        return result;
    }

    private SameSourcePaperCountInfoDto countSameSourcePaperInfo(List<UserPaperInfoDto> userPaperInfoList, BigDecimal passScore) {
        AtomicInteger passPaperUserTimes = new AtomicInteger(0);
        AtomicInteger paperUserTimes = new AtomicInteger(0);
        ArrayList passPaperUserIdList = new ArrayList();
        ArrayList paperUserIdList = new ArrayList();
        Integer scoreSelect = userPaperInfoList.get(0).getScoreSelect();
        if (scoreSelect == 0) {
            List<UserPaperInfoDto> maxScoreUserPaperInfoList = userPaperInfoList.stream().collect(Collectors.groupingBy(UserPaperInfoDto::getUserId, Collectors.reducing((p1, p2) -> p1.getScore().compareTo(p2.getScore()) >= 0 ? p1 : p2))).values().stream().map(Optional::get).collect(Collectors.toList());
            maxScoreUserPaperInfoList.forEach(userPaperInfoDto -> {
                paperUserTimes.incrementAndGet();
                paperUserIdList.add(userPaperInfoDto.getUserId());
                if (userPaperInfoDto.getScore().compareTo(passScore) >= 0) {
                    passPaperUserTimes.incrementAndGet();
                    passPaperUserIdList.add(userPaperInfoDto.getUserId());
                }
            });
        } else if (scoreSelect == 1) {
            List<UserPaperInfoDto> lastScoreUserPaperInfoList = userPaperInfoList.stream().collect(Collectors.groupingBy(UserPaperInfoDto::getUserId, Collectors.reducing((p1, p2) -> p1.getSubmitTime().compareTo(p2.getSubmitTime()) >= 0 ? p1 : p2))).values().stream().map(Optional::get).collect(Collectors.toList());
            lastScoreUserPaperInfoList.forEach(userPaperInfoDto -> {
                paperUserTimes.incrementAndGet();
                paperUserIdList.add(userPaperInfoDto.getUserId());
                if (userPaperInfoDto.getScore().compareTo(passScore) >= 0) {
                    passPaperUserTimes.incrementAndGet();
                    passPaperUserIdList.add(userPaperInfoDto.getUserId());
                }
            });
        }
        SameSourcePaperCountInfoDto sameSourcePaperCountInfoDto = new SameSourcePaperCountInfoDto();
        sameSourcePaperCountInfoDto.setPassPaperUserTimes(passPaperUserTimes);
        sameSourcePaperCountInfoDto.setPassPaperUserIdList(passPaperUserIdList);
        sameSourcePaperCountInfoDto.setPaperUserTimes(paperUserTimes);
        sameSourcePaperCountInfoDto.setPaperUserIdList(paperUserIdList);
        return sameSourcePaperCountInfoDto;
    }

    private Map<Integer, LearningCountDto> getPaperAndOperateLearing(Users user, List<Integer> canSeeUserIdList, Date countStartTime, Date countEndTime, List<TimeFrameSectioneDto> timeFrameSectioneList, Integer type) {
        List<LearningCountInfoDto> paperLearingCountInfo = this.trainingUserPaperMapper.getLearningCountInfo(user.getGroupId(), countStartTime, countEndTime, canSeeUserIdList, type);
        List<LearningCountInfoDto> operateLearingCountInfo = type == 2 || type == 3 || type == 4 ? this.userOperateMapper.getLearningCountInfo(user.getGroupId(), countStartTime, countEndTime, canSeeUserIdList, type) : new ArrayList<LearningCountInfoDto>();
        if (CollectionUtils.isEmpty(paperLearingCountInfo) && CollectionUtils.isEmpty(operateLearingCountInfo)) {
            return new HashMap<Integer, LearningCountDto>();
        }
        ArrayList res = new ArrayList();
        timeFrameSectioneList.forEach(timeFrameSectioneDto -> {
            List timeSectionOperateDataInfo;
            List timeSectionPaperDataInfo;
            LearningCountDto learningCountDto = new LearningCountDto();
            learningCountDto.setDateSortId(timeFrameSectioneDto.getSortId());
            Date startTime = timeFrameSectioneDto.getStartTime();
            Date endTime = timeFrameSectioneDto.getEndTime();
            long paperViewTime = 0L;
            List<Object> paperUserIdList = new ArrayList();
            if (!CollectionUtils.isEmpty((Collection)paperLearingCountInfo) && !CollectionUtils.isEmpty(timeSectionPaperDataInfo = paperLearingCountInfo.stream().filter(learningCountInfoDto -> {
                Date createTime = learningCountInfoDto.getCreateTime();
                Date submitTime = learningCountInfoDto.getSubmitTime();
                if (startTime == null) {
                    return createTime.before(endTime);
                }
                return createTime.after(startTime) && submitTime.before(endTime);
            }).collect(Collectors.toList()))) {
                paperViewTime = timeSectionPaperDataInfo.stream().map(learningCountInfoDto -> {
                    long timeDif = DateUtils.getTimeDif(learningCountInfoDto.getSubmitTime(), learningCountInfoDto.getCreateTime());
                    return TimeUnit.MILLISECONDS.toSeconds(timeDif);
                }).mapToLong(Long::intValue).sum();
                paperUserIdList = timeSectionPaperDataInfo.stream().map(LearningCountInfoDto::getUserId).distinct().collect(Collectors.toList());
            }
            long operateViewTime = 0L;
            List<Object> operateUserIdList = new ArrayList();
            if (!CollectionUtils.isEmpty((Collection)operateLearingCountInfo) && !CollectionUtils.isEmpty(timeSectionOperateDataInfo = operateLearingCountInfo.stream().filter(learningCountInfoDto -> {
                Date createTime = learningCountInfoDto.getCreateTime();
                if (startTime == null) {
                    return createTime.before(endTime);
                }
                return createTime.after(startTime) && createTime.before(endTime);
            }).collect(Collectors.toList()))) {
                operateViewTime = timeSectionOperateDataInfo.stream().map(learningCountInfoDto -> {
                    long timeDif = (long)(learningCountInfoDto.getCheckDuration() * 60000) - Long.parseLong(learningCountInfoDto.getRemainingTime());
                    return TimeUnit.MILLISECONDS.toSeconds(timeDif);
                }).mapToLong(Long::intValue).sum();
                operateUserIdList = timeSectionOperateDataInfo.stream().map(LearningCountInfoDto::getUserId).distinct().collect(Collectors.toList());
            }
            learningCountDto.setViewTime(Long.valueOf(paperViewTime + operateViewTime));
            paperUserIdList.addAll(operateUserIdList);
            learningCountDto.setUserIdList(paperUserIdList.stream().distinct().collect(Collectors.toList()));
            res.add(learningCountDto);
        });
        Map<Integer, LearningCountDto> result = res.stream().collect(Collectors.toMap(LearningCountDto::getDateSortId, learningCountDto -> learningCountDto));
        return result;
    }

    private Map<Integer, LearningCountDto> getTaskLearning(List<LearningCountInfoDto> allLearingCountInfo, Users user, List<Integer> canSeeUserIdList, Date countStartTime, Date countEndTime, List<TimeFrameSectioneDto> timeFrameSectioneList) {
        List learnLearingCountInfo = allLearingCountInfo.stream().filter(dto -> dto.getLearnType().equals(2)).collect(Collectors.toList());
        List courseLearingCountInfo = allLearingCountInfo.stream().filter(dto -> dto.getLearnType().equals(4)).collect(Collectors.toList());
        List jobLearingCountInfo = allLearingCountInfo.stream().filter(dto -> dto.getLearnType().equals(3)).collect(Collectors.toList());
        Map<Integer, LearningCountDto> paperAndOperateLearing = this.getPaperAndOperateLearing(user, canSeeUserIdList, countStartTime, countEndTime, timeFrameSectioneList, 3);
        if (CollectionUtils.isEmpty(learnLearingCountInfo) && CollectionUtils.isEmpty(courseLearingCountInfo) && CollectionUtils.isEmpty(jobLearingCountInfo)) {
            return new HashMap<Integer, LearningCountDto>();
        }
        ArrayList res = new ArrayList();
        timeFrameSectioneList.forEach(timeFrameSectioneDto -> {
            List timeSectionJobDataInfo;
            List timeSectionCourseDataInfo;
            List timeSectionLearnDataInfo;
            LearningCountDto learningCountDto = new LearningCountDto();
            learningCountDto.setDateSortId(timeFrameSectioneDto.getSortId());
            Date startTime = timeFrameSectioneDto.getStartTime();
            Date endTime = timeFrameSectioneDto.getEndTime();
            long learnViewTime = 0L;
            List<Object> learnUserIdList = new ArrayList();
            if (!CollectionUtils.isEmpty((Collection)learnLearingCountInfo) && !CollectionUtils.isEmpty(timeSectionLearnDataInfo = learnLearingCountInfo.stream().filter(learningCountInfoDto -> {
                Date createTime = learningCountInfoDto.getCreateTime();
                if (startTime == null) {
                    return createTime.before(endTime);
                }
                return createTime.after(startTime) && createTime.before(endTime);
            }).collect(Collectors.toList()))) {
                learnViewTime = timeSectionLearnDataInfo.stream().mapToLong(LearningCountInfoDto::getViewTime).sum();
                learnUserIdList = timeSectionLearnDataInfo.stream().map(LearningCountInfoDto::getUserId).distinct().collect(Collectors.toList());
            }
            long courseViewTime = 0L;
            List<Object> courseUserIdList = new ArrayList();
            if (!CollectionUtils.isEmpty((Collection)courseLearingCountInfo) && !CollectionUtils.isEmpty(timeSectionCourseDataInfo = courseLearingCountInfo.stream().filter(learningCountInfoDto -> {
                Date createTime = learningCountInfoDto.getCreateTime();
                if (startTime == null) {
                    return createTime.before(endTime);
                }
                return createTime.after(startTime) && createTime.before(endTime);
            }).collect(Collectors.toList()))) {
                courseViewTime = timeSectionCourseDataInfo.stream().mapToLong(LearningCountInfoDto::getViewTime).sum();
                courseUserIdList = timeSectionCourseDataInfo.stream().map(LearningCountInfoDto::getUserId).distinct().collect(Collectors.toList());
            }
            long jobViewTime = 0L;
            List<Object> jobUserIdList = new ArrayList();
            if (!CollectionUtils.isEmpty((Collection)jobLearingCountInfo) && !CollectionUtils.isEmpty(timeSectionJobDataInfo = jobLearingCountInfo.stream().filter(learningCountInfoDto -> {
                Date createTime = learningCountInfoDto.getCreateTime();
                if (startTime == null) {
                    return createTime.before(endTime);
                }
                return createTime.after(startTime) && createTime.before(endTime);
            }).collect(Collectors.toList()))) {
                jobViewTime = timeSectionJobDataInfo.stream().mapToLong(LearningCountInfoDto::getViewTime).sum();
                jobUserIdList = timeSectionJobDataInfo.stream().map(LearningCountInfoDto::getUserId).distinct().collect(Collectors.toList());
            }
            learningCountDto.setViewTime(Long.valueOf(learnViewTime + courseViewTime + jobViewTime));
            learnUserIdList.addAll(courseUserIdList);
            learnUserIdList.addAll(jobUserIdList);
            learningCountDto.setUserIdList(learnUserIdList.stream().distinct().collect(Collectors.toList()));
            res.add(learningCountDto);
        });
        Map<Integer, LearningCountDto> learningCountDtoMap = res.stream().collect(Collectors.toMap(LearningCountDto::getDateSortId, learningCountDto -> learningCountDto));
        Map<Integer, LearningCountDto> result = this.mergeResult(learningCountDtoMap, paperAndOperateLearing);
        return result;
    }

    private Map<Integer, LearningCountDto> getAutonomousLearning(List<LearningCountInfoDto> allLearingCountInfo, Users user, List<Integer> canSeeUserIdList, Date countStartTime, Date countEndTime, List<TimeFrameSectioneDto> timeFrameSectioneList) {
        List trainingLearingCountInfo = allLearingCountInfo.stream().filter(dto -> dto.getLearnType().equals(1) && null == dto.getTaskId()).collect(Collectors.toList());
        List materialLearingCountInfo = allLearingCountInfo.stream().filter(dto -> dto.getLearnType().equals(0) && null == dto.getTaskId() && null == dto.getAttachId()).collect(Collectors.toList());
        Map<Integer, LearningCountDto> paperAndOperateLearing = this.getPaperAndOperateLearing(user, canSeeUserIdList, countStartTime, countEndTime, timeFrameSectioneList, 1);
        if (CollectionUtils.isEmpty(trainingLearingCountInfo) && CollectionUtils.isEmpty(materialLearingCountInfo)) {
            return new HashMap<Integer, LearningCountDto>();
        }
        ArrayList res = new ArrayList();
        timeFrameSectioneList.forEach(timeFrameSectioneDto -> {
            LearningCountDto learningCountDto = new LearningCountDto();
            learningCountDto.setDateSortId(timeFrameSectioneDto.getSortId());
            Date startTime = timeFrameSectioneDto.getStartTime();
            Date endTime = timeFrameSectioneDto.getEndTime();
            List<Object> timeSectionTrainingDataInfo = new ArrayList();
            long trainingViewTime = 0L;
            List<Object> trainingUserIdList = new ArrayList();
            if (!CollectionUtils.isEmpty((Collection)trainingLearingCountInfo) && !CollectionUtils.isEmpty(timeSectionTrainingDataInfo = trainingLearingCountInfo.stream().filter(learningCountInfoDto -> {
                Date createTime = learningCountInfoDto.getCreateTime();
                if (startTime == null) {
                    return createTime.before(endTime);
                }
                return createTime.after(startTime) && createTime.before(endTime);
            }).collect(Collectors.toList()))) {
                trainingViewTime = timeSectionTrainingDataInfo.stream().mapToLong(LearningCountInfoDto::getViewTime).sum();
                trainingUserIdList = timeSectionTrainingDataInfo.stream().map(LearningCountInfoDto::getUserId).distinct().collect(Collectors.toList());
            }
            long materialViewTime = 0L;
            List<Object> materialUserIdList = new ArrayList();
            if (!CollectionUtils.isEmpty((Collection)materialLearingCountInfo)) {
                List timeSectionMaterialDataInfo = materialLearingCountInfo.stream().filter(learningCountInfoDto -> {
                    Date createTime = learningCountInfoDto.getCreateTime();
                    if (startTime == null) {
                        return createTime.before(endTime);
                    }
                    return createTime.after(startTime) && createTime.before(endTime);
                }).collect(Collectors.toList());
                materialViewTime = timeSectionMaterialDataInfo.stream().mapToLong(LearningCountInfoDto::getViewTime).sum();
                materialUserIdList = timeSectionMaterialDataInfo.stream().map(LearningCountInfoDto::getUserId).distinct().collect(Collectors.toList());
            }
            learningCountDto.setViewTime(Long.valueOf(trainingViewTime + materialViewTime));
            trainingUserIdList.addAll(materialUserIdList);
            learningCountDto.setUserIdList(trainingUserIdList.stream().distinct().collect(Collectors.toList()));
            res.add(learningCountDto);
        });
        Map<Integer, LearningCountDto> learningCountDtoMap = res.stream().collect(Collectors.toMap(LearningCountDto::getDateSortId, learningCountDto -> learningCountDto));
        Map<Integer, LearningCountDto> result = this.mergeResult(learningCountDtoMap, paperAndOperateLearing);
        return result;
    }

    private Map<Integer, LearningCountDto> mergeResult(Map<Integer, LearningCountDto> trainingLearing, Map<Integer, LearningCountDto> paperAndOperateLearing) {
        trainingLearing.forEach((k, v) -> {
            if (paperAndOperateLearing.containsKey(k)) {
                LearningCountDto learningCountDto = (LearningCountDto)paperAndOperateLearing.get(k);
                v.setViewTime(Long.valueOf(learningCountDto.getViewTime() + v.getViewTime()));
                v.getUserIdList().addAll(learningCountDto.getUserIdList());
                v.setUserIdList(v.getUserIdList().stream().distinct().collect(Collectors.toList()));
            }
        });
        return trainingLearing;
    }

    @Override
    public StudyTrendVo getStudyTrend(LearningOverviewReq learningOverviewReq, Users user) {
        TimeFrameDto segmentationTimeFrameByCycleType = this.getSegmentationTimeFrameByCycleType(new Date(), learningOverviewReq.getCountCycleType());
        log.info("\u7edf\u8ba1\u65f6\u95f4\u8303\u56f4\uff1a{}", (Object)JSONUtil.toJsonStr((Object)segmentationTimeFrameByCycleType));
        Date countStartTime = segmentationTimeFrameByCycleType.getCountStartTime();
        Date countEndTime = segmentationTimeFrameByCycleType.getCountEndTime();
        List timeFrameSectioneList = segmentationTimeFrameByCycleType.getTimeFrameSectioneList();
        log.info("\u7528\u6237\u4fe1\u606f\uff1a{}", (Object)user);
        List<Integer> canSeeUserIdList = this.getCanSeeUserIdListByUser(user);
        if (CollectionUtils.isEmpty(canSeeUserIdList)) {
            return new StudyTrendVo();
        }
        StudyTrendVo result = new StudyTrendVo();
        List<LearningCountInfoDto> allLearingCountInfo = this.trainingUserViewTimeDayMapper.getAllLearningCountInfo(user.getGroupId(), countStartTime, countEndTime, canSeeUserIdList);
        Map<Integer, LearningCountDto> allLearningMapByTime = this.getAllLearning(allLearingCountInfo, user, canSeeUserIdList, countStartTime, countEndTime, timeFrameSectioneList);
        Map<Integer, LearningCountDto> allPaperAndOperateMapByTime = this.getPaperAndOperateLearing(user, canSeeUserIdList, countStartTime, countEndTime, timeFrameSectioneList, 4);
        StudyTrendVo studyTrendVo = new StudyTrendVo();
        ArrayList<String> dateList = new ArrayList<String>();
        ArrayList<IntegerDataDetailDto> studyUserNumList = new ArrayList<IntegerDataDetailDto>();
        ArrayList<BigDecimalDataDto> preUserStudyTimeList = new ArrayList<BigDecimalDataDto>();
        for (TimeFrameSectioneDto timeFrame : timeFrameSectioneList) {
            LearningCountDto allPaperAndOperateDto;
            Date startTime = timeFrame.getStartTime();
            String dateFormat = timeFrame.getDateFormat();
            Integer sortId = timeFrame.getSortId();
            ArrayList userIdList = new ArrayList();
            Long viewTime = 0L;
            LearningCountDto allLearningDto = allLearningMapByTime.get(sortId);
            if (allLearningDto != null) {
                userIdList.addAll(allLearningDto.getUserIdList());
                viewTime = viewTime + allLearningDto.getViewTime();
            }
            if ((allPaperAndOperateDto = allPaperAndOperateMapByTime.get(sortId)) != null) {
                userIdList.addAll(allPaperAndOperateDto.getUserIdList());
                viewTime = viewTime + allPaperAndOperateDto.getViewTime();
            }
            String date = DateUtils.format(startTime, dateFormat);
            dateList.add(date);
            long studyUserNum = userIdList.stream().distinct().count();
            studyUserNumList.add(new IntegerDataDetailDto(date, Integer.valueOf((int)studyUserNum)));
            BigDecimal preUserStudyTime = new BigDecimal(0);
            if (studyUserNum != 0L) {
                preUserStudyTime = BigDecimal.valueOf(viewTime).divide(new BigDecimal(3600), 2, 4).divide(new BigDecimal(studyUserNum), 2, 4);
            }
            preUserStudyTimeList.add(new BigDecimalDataDto(date, preUserStudyTime));
        }
        studyTrendVo.setDateList(dateList);
        studyTrendVo.setStudyUserNumList(studyUserNumList);
        studyTrendVo.setPreUserStudyTimeList(preUserStudyTimeList);
        return studyTrendVo;
    }

    @Override
    public PaperTrendVo getPaperTrend(LearningOverviewReq learningOverviewReq, Users user) {
        TimeFrameDto segmentationTimeFrameByCycleType = this.getSegmentationTimeFrameByCycleType(new Date(), learningOverviewReq.getCountCycleType());
        log.info("\u7edf\u8ba1\u65f6\u95f4\u8303\u56f4\uff1a{}", (Object)JSONUtil.toJsonStr((Object)segmentationTimeFrameByCycleType));
        Date countStartTime = segmentationTimeFrameByCycleType.getCountStartTime();
        Date countEndTime = segmentationTimeFrameByCycleType.getCountEndTime();
        List timeFrameSectioneList = segmentationTimeFrameByCycleType.getTimeFrameSectioneList();
        log.info("\u7528\u6237\u4fe1\u606f\uff1a{}", (Object)user);
        List<Integer> canSeeUserIdList = this.getCanSeeUserIdListByUser(user);
        if (CollectionUtils.isEmpty(canSeeUserIdList)) {
            return new PaperTrendVo();
        }
        PaperTrendVo result = new PaperTrendVo();
        Map<Integer, PaperCountDto> paperCheck = this.getPaperCheck(user, canSeeUserIdList, countStartTime, countEndTime, timeFrameSectioneList);
        Map<Integer, PaperCountDto> operateCheck = this.getOperateCheck(user, canSeeUserIdList, countStartTime, countEndTime, timeFrameSectioneList);
        ArrayList<String> dateList = new ArrayList<String>();
        ArrayList<IntegerDataDetailDto> checkUserNumList = new ArrayList<IntegerDataDetailDto>();
        ArrayList<BigDecimalDataDto> passCheckRateList = new ArrayList<BigDecimalDataDto>();
        for (TimeFrameSectioneDto timeFrame : timeFrameSectioneList) {
            PaperCountDto operateCheckDto;
            Date startTime = timeFrame.getStartTime();
            String dateFormat = timeFrame.getDateFormat();
            Integer sortId = timeFrame.getSortId();
            int checkUserTimes = 0;
            int passCheckUserTimes = 0;
            PaperCountDto paperCheckDto = paperCheck.get(sortId);
            if (paperCheckDto != null) {
                checkUserTimes += paperCheckDto.getUserTimes().intValue();
                passCheckUserTimes += paperCheckDto.getPassUserTimes().intValue();
            }
            if ((operateCheckDto = operateCheck.get(sortId)) != null) {
                checkUserTimes += operateCheckDto.getUserTimes().intValue();
                passCheckUserTimes += operateCheckDto.getPassUserTimes().intValue();
            }
            String date = DateUtils.format(startTime, dateFormat);
            dateList.add(date);
            checkUserNumList.add(new IntegerDataDetailDto(date, Integer.valueOf(checkUserTimes)));
            BigDecimal passCheckRate = new BigDecimal(0);
            if (checkUserTimes != 0) {
                passCheckRate = BigDecimal.valueOf(passCheckUserTimes).multiply(new BigDecimal(100)).divide(new BigDecimal(checkUserTimes), 2, 4);
            }
            passCheckRateList.add(new BigDecimalDataDto(date, passCheckRate));
        }
        result.setDateList(dateList);
        result.setPaperUserNumList(checkUserNumList);
        result.setPassPaperRateList(passCheckRateList);
        return result;
    }

    @Override
    public TrainingInfoVo getTrainingInfo(LearningOverviewReq learningOverviewReq, Users user) {
        TimeFrameDto timeFrameByCycleType = this.getTimeFrameByCycleType(new Date(), learningOverviewReq.getCountCycleType());
        log.info("\u7edf\u8ba1\u65f6\u95f4\u8303\u56f4\uff1a{}", (Object)JSONUtil.toJsonStr((Object)timeFrameByCycleType));
        Date countStartTime = timeFrameByCycleType.getCountStartTime();
        Date countEndTime = timeFrameByCycleType.getCountEndTime();
        List<TimeFrameSectioneDto> timeFrameSectioneList = timeFrameByCycleType.getTimeFrameSectioneList().stream().sorted(Comparator.comparing(TimeFrameSectioneDto::getSortId)).collect(Collectors.toList());
        log.info("\u7528\u6237\u4fe1\u606f\uff1a{}", (Object)user);
        List<Integer> canSeeUserIdList = this.getCanSeeUserIdListByUser(user);
        if (CollectionUtils.isEmpty(canSeeUserIdList)) {
            return new TrainingInfoVo();
        }
        TrainingCountDto trainingCount = this.getTrainingCount(user, timeFrameSectioneList);
        List<LearningCountInfoDto> allLearingCountInfo = this.trainingUserViewTimeMapper.getAllLearningCountInfo(user.getGroupId(), countStartTime, countEndTime, canSeeUserIdList);
        Map<Integer, LearningCountDto> autonomousLearning = this.getAutonomousLearning(allLearingCountInfo, user, canSeeUserIdList, countStartTime, countEndTime, timeFrameSectioneList);
        Map<Integer, LearningCountDto> taskLearning = this.getTaskLearning(allLearingCountInfo, user, canSeeUserIdList, countStartTime, countEndTime, timeFrameSectioneList);
        TrainingInfoVo result = new TrainingInfoVo();
        result.setTotalTrainingCount(trainingCount.getAllTrainingCount());
        result.setNewTrainingCount(trainingCount.getTrainingCountByTime());
        ArrayList previousDataList = new ArrayList();
        ArrayList currentDataList = new ArrayList();
        timeFrameSectioneList.forEach(timeFrameSectioneDto -> {
            Integer sortId = timeFrameSectioneDto.getSortId();
            LearningCountDto autonomousLearningDto = (LearningCountDto)autonomousLearning.get(sortId);
            int autonomousLearningUserNum = 0;
            Long autonomousLearningTime = 0L;
            if (autonomousLearningDto != null) {
                autonomousLearningUserNum = autonomousLearningDto.getUserIdList().size();
                autonomousLearningTime = autonomousLearningDto.getViewTime();
            }
            LearningCountDto taskLearningDto = (LearningCountDto)taskLearning.get(sortId);
            int taskLearningUserNum = 0;
            Long taskLearningTime = 0L;
            if (taskLearningDto != null) {
                taskLearningUserNum = taskLearningDto.getUserIdList().size();
                taskLearningTime = taskLearningDto.getViewTime();
            }
            BigDecimalDataDto preUserAutonomousLearningTime = new BigDecimalDataDto();
            BigDecimalDataDto preUserTaskLearningTime = new BigDecimalDataDto();
            if (autonomousLearningTime == 0L) {
                preUserAutonomousLearningTime.setData(new BigDecimal(0));
            } else {
                preUserAutonomousLearningTime.setData(BigDecimal.valueOf(autonomousLearningTime).divide(new BigDecimal(3600), 2, 4).divide(new BigDecimal(autonomousLearningUserNum), 2, 4));
            }
            if (taskLearningTime == 0L) {
                preUserTaskLearningTime.setData(new BigDecimal(0));
            } else {
                preUserTaskLearningTime.setData(BigDecimal.valueOf(taskLearningTime).divide(new BigDecimal(3600), 2, 4).divide(new BigDecimal(taskLearningUserNum), 2, 4));
            }
            if (sortId == 1) {
                previousDataList.add(preUserTaskLearningTime);
                previousDataList.add(preUserAutonomousLearningTime);
            } else if (sortId == 2) {
                currentDataList.add(preUserTaskLearningTime);
                currentDataList.add(preUserAutonomousLearningTime);
                result.setAutonomousLearningNum(Integer.valueOf(autonomousLearningUserNum));
                result.setAutonomousLearningTime(BigDecimal.valueOf(autonomousLearningTime).divide(new BigDecimal(3600), 2, 4));
                result.setTaskLearningNum(Integer.valueOf(taskLearningUserNum));
                result.setTaskLearningTime(BigDecimal.valueOf(taskLearningTime).divide(new BigDecimal(3600), 2, 4));
            }
        });
        result.setPreviousDataList(previousDataList);
        result.setCurrentDataList(currentDataList);
        return result;
    }

    private TrainingCountDto getTrainingCount(Users user, List<TimeFrameSectioneDto> timeFrameSectioneList) {
        Optional<TimeFrameSectioneDto> currentData = timeFrameSectioneList.stream().filter(timeFrameSectioneDto -> timeFrameSectioneDto.getSortId() == 2).findFirst();
        if (!currentData.isPresent()) {
            return new TrainingCountDto();
        }
        Date startTime = currentData.get().getStartTime();
        Date endTime = currentData.get().getEndTime();
        List<Integer> allTrainingCount = this.trainingMapper.getTrainingIdList(user.getGroupId(), null, endTime);
        List<Integer> trainingCountByTime = this.trainingMapper.getTrainingIdList(user.getGroupId(), startTime, endTime);
        TrainingCountDto res = new TrainingCountDto();
        res.setAllTrainingCount(Integer.valueOf(CollectionUtils.isEmpty(allTrainingCount) ? 0 : allTrainingCount.size()));
        res.setTrainingCountByTime(Integer.valueOf(CollectionUtils.isEmpty(trainingCountByTime) ? 0 : trainingCountByTime.size()));
        return res;
    }

    @Override
    public PaperInfoVo getPaperInfo(LearningOverviewReq learningOverviewReq, Users user) {
        TimeFrameDto timeFrameByCycleType = this.getTimeFrameByCycleType(new Date(), learningOverviewReq.getCountCycleType());
        log.info("\u7edf\u8ba1\u65f6\u95f4\u8303\u56f4\uff1a{}", (Object)JSONUtil.toJsonStr((Object)timeFrameByCycleType));
        List<TimeFrameSectioneDto> timeFrameSectioneList = timeFrameByCycleType.getTimeFrameSectioneList().stream().filter(timeFrameSectioneDto -> timeFrameSectioneDto.getSortId() == 2).collect(Collectors.toList());
        TimeFrameSectioneDto timeFrameSectione = (TimeFrameSectioneDto)timeFrameSectioneList.get(0);
        Date countStartTime = timeFrameSectione.getStartTime();
        Date countEndTime = timeFrameSectione.getEndTime();
        log.info("\u7528\u6237\u4fe1\u606f\uff1a{}", (Object)user);
        List<Integer> canSeeUserIdList = this.getCanSeeUserIdListByUser(user);
        if (CollectionUtils.isEmpty(canSeeUserIdList)) {
            return new PaperInfoVo();
        }
        Integer paperType = learningOverviewReq.getPaperType();
        PaperInfoVo result = new PaperInfoVo();
        int totalSessions = 0;
        int newSessions = 0;
        int checkUserTimes = 0;
        int passCheckUserTimes = 0;
        ArrayList checkUserIdList = new ArrayList();
        ArrayList passCheckUserIdList = new ArrayList();
        if (paperType.equals(1) || paperType.equals(2)) {
            PaperSessionsDto paperSessionsDto = this.getSessionsOfPaperCheck(user, timeFrameSectioneList);
            Map<Integer, PaperCountDto> paperCheck = this.getPaperCheck(user, canSeeUserIdList, countStartTime, countEndTime, timeFrameSectioneList);
            PaperCountDto paperCheckDto = paperCheck.get(2);
            if (paperCheckDto != null) {
                checkUserTimes += paperCheckDto.getUserTimes().intValue();
                passCheckUserTimes += paperCheckDto.getPassUserTimes().intValue();
                checkUserIdList.addAll(paperCheckDto.getUserIdList());
                passCheckUserIdList.addAll(paperCheckDto.getPassUserIdList());
            }
            totalSessions += paperSessionsDto.getTotalSessions().intValue();
            newSessions += paperSessionsDto.getNewSessions().intValue();
        }
        if (paperType.equals(1) || paperType.equals(3)) {
            PaperSessionsDto operateSessionsDto = this.getSessionsOfOperateCheck(user, timeFrameSectioneList);
            Map<Integer, PaperCountDto> operateCheck = this.getOperateCheck(user, canSeeUserIdList, countStartTime, countEndTime, timeFrameSectioneList);
            PaperCountDto operateCheckDto = operateCheck.get(2);
            if (operateCheckDto != null) {
                checkUserTimes += operateCheckDto.getUserTimes().intValue();
                passCheckUserTimes += operateCheckDto.getPassUserTimes().intValue();
                checkUserIdList.addAll(operateCheckDto.getUserIdList());
                passCheckUserIdList.addAll(operateCheckDto.getPassUserIdList());
            }
            totalSessions += operateSessionsDto.getTotalSessions().intValue();
            newSessions += operateSessionsDto.getNewSessions().intValue();
        }
        result.setTotalSessions(Integer.valueOf(totalSessions));
        result.setNewSessions(Integer.valueOf(newSessions));
        long paperNum = checkUserIdList.stream().distinct().count();
        long passPaperNum = passCheckUserIdList.stream().distinct().count();
        result.setPaperUserNum(Integer.valueOf((int)paperNum));
        result.setPassPaperUserNum(Integer.valueOf((int)passPaperNum));
        result.setPaperUserTimes(Integer.valueOf(checkUserTimes));
        result.setPassPaperUserTimes(Integer.valueOf(passCheckUserTimes));
        if (checkUserTimes == 0) {
            result.setPassPaperRate(new BigDecimal(0));
        } else {
            result.setPassPaperRate(BigDecimal.valueOf(passCheckUserTimes).multiply(new BigDecimal(100)).divide(BigDecimal.valueOf(checkUserTimes), 2, 4));
        }
        return result;
    }

    @Override
    public Page<CourseRankingVo> getTrainingRanking(LearningOverviewReq learningOverviewReq, Users user) {
        TimeFrameDto timeFrameByCycleType = this.getTimeFrameByCycleType(new Date(), learningOverviewReq.getCountCycleType());
        log.info("\u7edf\u8ba1\u65f6\u95f4\u8303\u56f4\uff1a{}", (Object)JSONUtil.toJsonStr((Object)timeFrameByCycleType));
        List timeFrameSectioneList = timeFrameByCycleType.getTimeFrameSectioneList().stream().filter(timeFrameSectioneDto -> timeFrameSectioneDto.getSortId() == 2).collect(Collectors.toList());
        TimeFrameSectioneDto timeFrameSectione = (TimeFrameSectioneDto)timeFrameSectioneList.get(0);
        Date countStartTime = timeFrameSectione.getStartTime();
        Date countEndTime = timeFrameSectione.getEndTime();
        log.info("\u7528\u6237\u4fe1\u606f\uff1a{}", (Object)user);
        List<Integer> canSeeUserIdList = this.getCanSeeUserIdListByUser(user);
        if (CollectionUtils.isEmpty(canSeeUserIdList)) {
            return new Page();
        }
        List<Integer> allTrainingIdList = this.trainingMapper.getTrainingIdList(user.getGroupId(), null, countEndTime);
        List<TrainingRankingDto> dataByTraining = this.trainingUserViewTimeMapper.getCourseRanking(user.getGroupId(), allTrainingIdList, countStartTime, countEndTime, canSeeUserIdList);
        HashMap<Integer, List> trainingIdAndUserIdListMap = new HashMap<Integer, List>();
        dataByTraining.forEach(trainingRankingDto -> {
            if (trainingIdAndUserIdListMap.containsKey(trainingRankingDto.getTrainingId())) {
                ((List)trainingIdAndUserIdListMap.get(trainingRankingDto.getTrainingId())).add(trainingRankingDto);
            } else {
                ArrayList<TrainingRankingDto> data = new ArrayList<TrainingRankingDto>();
                data.add((TrainingRankingDto)trainingRankingDto);
                trainingIdAndUserIdListMap.put(trainingRankingDto.getTrainingId(), data);
            }
        });
        ArrayList courseRankingVoList = new ArrayList();
        trainingIdAndUserIdListMap.forEach((trainingId, data) -> {
            CourseRankingVo courseRankingVo = new CourseRankingVo();
            List dataByDistinct = data.stream().collect(Collectors.toMap(TrainingRankingDto::getUserId, dto -> dto, (dto1, dto2) -> dto1)).values().stream().collect(Collectors.toList());
            long userNum = dataByDistinct.size();
            courseRankingVo.setLearningUserNum(Integer.valueOf((int)userNum));
            courseRankingVo.setTrainingTitle(((TrainingRankingDto)data.get(0)).getTrainingTitle());
            courseRankingVoList.add(courseRankingVo);
        });
        Integer pageNum = learningOverviewReq.getPageNum();
        Integer pageSize = learningOverviewReq.getPageSize();
        if (CollectionUtils.isEmpty(courseRankingVoList)) {
            return new Page();
        }
        List rankingVoList = courseRankingVoList.stream().sorted(Comparator.comparing(CourseRankingVo::getLearningUserNum).reversed()).collect(Collectors.toList());
        List records = rankingVoList.stream().skip((long)(pageNum - 1) * (long)pageSize.intValue()).limit(pageSize.intValue()).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(records)) {
            return new Page();
        }
        CourseRankingVo first = (CourseRankingVo)rankingVoList.get(0);
        Integer firstLearningUserNum = first.getLearningUserNum();
        int rank = (pageNum - 1) * pageSize + 1;
        for (CourseRankingVo dto : records) {
            dto.setCompareFirstRate(new BigDecimal(dto.getLearningUserNum()).multiply(new BigDecimal(100)).divide(new BigDecimal(firstLearningUserNum), 2, 4));
            dto.setRank(Integer.valueOf(rank));
            ++rank;
        }
        Page page = new Page();
        page.setPageNumber(pageNum.intValue());
        page.setPageSize(pageSize.intValue());
        page.setTotalCount(Long.valueOf(rankingVoList.size()));
        page.setPageCount(Long.valueOf((long)rankingVoList.size() / (long)pageSize.intValue() + 1L));
        page.setContent(records);
        return page;
    }

    @Override
    public Page<StudyRankingVo> getStudyRanking(LearningOverviewReq learningOverviewReq, Users user) {
        TimeFrameDto timeFrameByCycleType = this.getTimeFrameByCycleType(new Date(), learningOverviewReq.getCountCycleType());
        log.info("\u7edf\u8ba1\u65f6\u95f4\u8303\u56f4\uff1a{}", (Object)JSONUtil.toJsonStr((Object)timeFrameByCycleType));
        List timeFrameSectioneList = timeFrameByCycleType.getTimeFrameSectioneList().stream().filter(timeFrameSectioneDto -> timeFrameSectioneDto.getSortId() == 2).collect(Collectors.toList());
        TimeFrameSectioneDto timeFrameSectione = (TimeFrameSectioneDto)timeFrameSectioneList.get(0);
        Date countStartTime = timeFrameSectione.getStartTime();
        Date countEndTime = timeFrameSectione.getEndTime();
        log.info("\u7528\u6237\u4fe1\u606f\uff1a{}", (Object)user);
        List<Integer> canSeeUserIdList = this.getCanSeeUserIdListByUser(user);
        if (CollectionUtils.isEmpty(canSeeUserIdList)) {
            return new Page();
        }
        List<StudyRankingDto> dataByStudy = this.trainingUserViewTimeDayMapper.getStudyRanking(user.getGroupId(), countStartTime, countEndTime, canSeeUserIdList);
        List<StudyRankingDto> dataByPaper = this.getStudyRankingByPaper(user.getGroupId(), countStartTime, countEndTime, canSeeUserIdList);
        List<StudyRankingDto> dataByOperation = this.getStudyRankingByOperation(user.getGroupId(), countStartTime, countEndTime, canSeeUserIdList);
        HashMap<Integer, Long> userStudyListMap = new HashMap<Integer, Long>();
        dataByStudy.forEach(studyRankingDto -> {
            if (userStudyListMap.containsKey(studyRankingDto.getUserId())) {
                Long viewTime = (Long)userStudyListMap.get(studyRankingDto.getUserId());
                userStudyListMap.put(studyRankingDto.getUserId(), viewTime + studyRankingDto.getStudyTime());
            } else {
                userStudyListMap.put(studyRankingDto.getUserId(), studyRankingDto.getStudyTime());
            }
        });
        dataByPaper.forEach(studyRankingDto -> {
            if (userStudyListMap.containsKey(studyRankingDto.getUserId())) {
                Long viewTime = (Long)userStudyListMap.get(studyRankingDto.getUserId());
                userStudyListMap.put(studyRankingDto.getUserId(), viewTime + studyRankingDto.getStudyTime());
            } else {
                userStudyListMap.put(studyRankingDto.getUserId(), studyRankingDto.getStudyTime());
            }
        });
        dataByOperation.forEach(studyRankingDto -> {
            if (userStudyListMap.containsKey(studyRankingDto.getUserId())) {
                Long viewTime = (Long)userStudyListMap.get(studyRankingDto.getUserId());
                userStudyListMap.put(studyRankingDto.getUserId(), viewTime + studyRankingDto.getStudyTime());
            } else {
                userStudyListMap.put(studyRankingDto.getUserId(), studyRankingDto.getStudyTime());
            }
        });
        ArrayList allStudyUserInfoList = new ArrayList();
        userStudyListMap.forEach((userId, studyTime) -> {
            StudyRankingDto studyRankingDto = new StudyRankingDto();
            studyRankingDto.setUserId(userId);
            studyRankingDto.setStudyTime(studyTime);
            allStudyUserInfoList.add(studyRankingDto);
        });
        Integer pageNum = learningOverviewReq.getPageNum();
        Integer pageSize = learningOverviewReq.getPageSize();
        List<Integer> userIdList = allStudyUserInfoList.stream().map(StudyRankingDto::getUserId).collect(Collectors.toList());
        Map<Integer, UsersPojo> integerUsersPojoMap = this.userUtilService.selectUserMap(userIdList);
        Map<Integer, List<String>> integerListMap = this.userUtilService.selectOrganizeMap(userIdList, user.getGroupId());
        ArrayList<Object> allStudyUserInfoVoList = new ArrayList<Object>();
        for (StudyRankingDto studyRankingDto2 : allStudyUserInfoList) {
            BigDecimal studyTime2;
            UsersPojo usersPojo = integerUsersPojoMap.get(studyRankingDto2.getUserId());
            List<String> organizeList = integerListMap.get(studyRankingDto2.getUserId());
            if (usersPojo == null || CollectionUtils.isEmpty(organizeList) || (studyTime2 = new BigDecimal(studyRankingDto2.getStudyTime()).divide(new BigDecimal(3600), 2, 4)).compareTo(new BigDecimal(0)) <= 0) continue;
            StudyRankingVo studyRankingVo = new StudyRankingVo();
            studyRankingVo.setStudyTime(studyTime2);
            studyRankingVo.setUserName(usersPojo.getShowName());
            studyRankingVo.setDepartmentName(organizeList.get(0));
            allStudyUserInfoVoList.add(studyRankingVo);
        }
        if (CollectionUtils.isEmpty(allStudyUserInfoVoList)) {
            return new Page();
        }
        List allStudyUserInfoListSort = allStudyUserInfoVoList.stream().sorted(Comparator.comparing(StudyRankingVo::getStudyTime).reversed()).collect(Collectors.toList());
        List records = allStudyUserInfoListSort.stream().skip((long)(pageNum - 1) * (long)pageSize.intValue()).limit(pageSize.intValue()).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(records)) {
            return new Page();
        }
        StudyRankingVo first = (StudyRankingVo)allStudyUserInfoListSort.get(0);
        BigDecimal firstStudyTime = first.getStudyTime();
        int rank = (pageNum - 1) * pageSize + 1;
        for (StudyRankingVo record : records) {
            record.setCompareFirstRate(record.getStudyTime().multiply(new BigDecimal(100)).divide(firstStudyTime, 2, 4));
            record.setRank(Integer.valueOf(rank));
            ++rank;
        }
        Page page = new Page();
        page.setPageNumber(pageNum.intValue());
        page.setPageSize(pageSize.intValue());
        page.setTotalCount(Long.valueOf(allStudyUserInfoVoList.size()));
        page.setPageCount(Long.valueOf((long)allStudyUserInfoVoList.size() / (long)pageSize.intValue() + 1L));
        page.setContent(records);
        return page;
    }

    private List<StudyRankingDto> getStudyRankingByOperation(Integer groupId, Date countStartTime, Date countEndTime, List<Integer> canSeeUserIdList) {
        ArrayList<StudyRankingDto> res = new ArrayList<StudyRankingDto>();
        List<LearningCountInfoDto> operateLearingCountInfo = this.userOperateMapper.getStudyRankingByOperation(groupId, countStartTime, countEndTime, canSeeUserIdList);
        Map operateLearingCountInfoGroupByUser = operateLearingCountInfo.stream().collect(Collectors.groupingBy(LearningCountInfoDto::getUserId, Collectors.toList()));
        if (!CollectionUtils.isEmpty(operateLearingCountInfo)) {
            operateLearingCountInfoGroupByUser.forEach((userId, learningCountInfoDtos) -> {
                long paperViewTime = learningCountInfoDtos.stream().map(learningCountInfoDto -> {
                    long timeDif = (long)(learningCountInfoDto.getCheckDuration() * 60000) - Long.parseLong(learningCountInfoDto.getRemainingTime());
                    return TimeUnit.MILLISECONDS.toSeconds(timeDif);
                }).mapToLong(Long::intValue).sum();
                StudyRankingDto studyRankingDto = new StudyRankingDto();
                studyRankingDto.setUserId(userId);
                studyRankingDto.setStudyTime(Long.valueOf(paperViewTime));
                res.add(studyRankingDto);
            });
        }
        return res;
    }

    private List<StudyRankingDto> getStudyRankingByPaper(Integer groupId, Date countStartTime, Date countEndTime, List<Integer> canSeeUserIdList) {
        ArrayList<StudyRankingDto> res = new ArrayList<StudyRankingDto>();
        List<LearningCountInfoDto> paperLearingCountInfo = this.trainingUserPaperMapper.getStudyRankingByPaper(groupId, countStartTime, countEndTime, canSeeUserIdList);
        Map paperLearingCountInfoGroupByUser = paperLearingCountInfo.stream().collect(Collectors.groupingBy(LearningCountInfoDto::getUserId, Collectors.toList()));
        if (!CollectionUtils.isEmpty(paperLearingCountInfo)) {
            paperLearingCountInfoGroupByUser.forEach((userId, learningCountInfoDtos) -> {
                long paperViewTime = learningCountInfoDtos.stream().map(learningCountInfoDto -> {
                    long timeDif = DateUtils.getTimeDif(learningCountInfoDto.getSubmitTime(), learningCountInfoDto.getCreateTime());
                    return TimeUnit.MILLISECONDS.toSeconds(timeDif);
                }).mapToLong(Long::intValue).sum();
                StudyRankingDto studyRankingDto = new StudyRankingDto();
                studyRankingDto.setUserId(userId);
                studyRankingDto.setStudyTime(Long.valueOf(paperViewTime));
                res.add(studyRankingDto);
            });
        }
        return res;
    }

    private PaperSessionsDto getSessionsOfOperateCheck(Users user, List<TimeFrameSectioneDto> timeFrameSectioneList) {
        Integer paperSessionsByTime;
        Optional<TimeFrameSectioneDto> currentData = timeFrameSectioneList.stream().filter(timeFrameSectioneDto -> timeFrameSectioneDto.getSortId() == 2).findFirst();
        if (!currentData.isPresent()) {
            return new PaperSessionsDto();
        }
        PaperSessionsDto res = new PaperSessionsDto();
        Date startTime = currentData.get().getStartTime();
        Date endTime = currentData.get().getEndTime();
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(OperateCheck::getEnterpriseId, (Object)user.getGroupId());
        wrapper.le(OperateCheck::getCreateTime, (Object)endTime);
        wrapper.select(new SFunction[]{OperateCheck::getId, OperateCheck::getCreateTime});
        List allPaperSessionsList = this.operateCheckMapper.selectList((Wrapper)wrapper);
        Integer allPaperSessions = allPaperSessionsList.size();
        if (startTime == null) {
            paperSessionsByTime = allPaperSessions;
        } else {
            long paperSessionsByTimeCount = allPaperSessionsList.stream().filter(operateCheck -> operateCheck.getCreateTime().compareTo(startTime) > 0).count();
            paperSessionsByTime = (int)paperSessionsByTimeCount;
        }
        res.setTotalSessions(allPaperSessions);
        res.setNewSessions(paperSessionsByTime);
        return res;
    }

    private PaperSessionsDto getSessionsOfPaperCheck(Users user, List<TimeFrameSectioneDto> timeFrameSectioneList) {
        Integer paperSessionsByTime;
        Optional<TimeFrameSectioneDto> currentData = timeFrameSectioneList.stream().filter(timeFrameSectioneDto -> timeFrameSectioneDto.getSortId() == 2).findFirst();
        if (!currentData.isPresent()) {
            return new PaperSessionsDto();
        }
        PaperSessionsDto res = new PaperSessionsDto();
        Date startTime = currentData.get().getStartTime();
        Date endTime = currentData.get().getEndTime();
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(TrainingPaper::getEnterpriseId, (Object)user.getGroupId());
        wrapper.le(TrainingPaper::getCreateTime, (Object)endTime);
        wrapper.select(new SFunction[]{TrainingPaper::getId, TrainingPaper::getCreateTime});
        List allPaperSessionsList = this.trainingPaperMapper.selectList((Wrapper)wrapper);
        Integer allPaperSessions = allPaperSessionsList.size();
        if (startTime == null) {
            paperSessionsByTime = allPaperSessions;
        } else {
            long paperSessionsByTimeCount = allPaperSessionsList.stream().filter(trainingPaper -> trainingPaper.getCreateTime().compareTo(startTime) > 0).count();
            paperSessionsByTime = (int)paperSessionsByTimeCount;
        }
        res.setTotalSessions(allPaperSessions);
        res.setNewSessions(paperSessionsByTime);
        return res;
    }

    private TimeFrameDto getSegmentationTimeFrameByCycleType(Date nowTime, Integer cycleType) {
        List<Object> timeFrames = new ArrayList();
        Date judgmentTime = new Date();
        nowTime = DateUtils.getEndTimeOfDay(DateUtils.addDay(nowTime, -1));
        int sortId = 0;
        switch (cycleType) {
            case 1: {
                int i;
                sortId = 7;
                for (i = 0; i < 7; ++i) {
                    Date endTime;
                    Date startTime;
                    if (i == 0) {
                        startTime = DateUtils.getStartTimeOfDay(nowTime);
                        endTime = nowTime;
                    } else {
                        startTime = DateUtils.addDay(judgmentTime, -1);
                        endTime = DateUtils.getEndTimeOfDay(startTime);
                    }
                    judgmentTime = startTime;
                    TimeFrameSectioneDto timeFrameDto = new TimeFrameSectioneDto();
                    timeFrameDto.setSortId(Integer.valueOf(sortId - i));
                    timeFrameDto.setStartTime(startTime);
                    timeFrameDto.setEndTime(endTime);
                    timeFrameDto.setDateFormat("MM/dd");
                    timeFrames.add(timeFrameDto);
                }
                break;
            }
            case 2: {
                int i;
                sortId = 30;
                for (i = 0; i < 30; ++i) {
                    Date endTime;
                    Date startTime;
                    if (i == 0) {
                        startTime = DateUtils.getStartTimeOfDay(nowTime);
                        endTime = nowTime;
                    } else {
                        startTime = DateUtils.addDay(judgmentTime, -1);
                        endTime = DateUtils.getEndTimeOfDay(startTime);
                    }
                    judgmentTime = startTime;
                    TimeFrameSectioneDto timeFrameDto = new TimeFrameSectioneDto();
                    timeFrameDto.setSortId(Integer.valueOf(sortId - i));
                    timeFrameDto.setStartTime(startTime);
                    timeFrameDto.setEndTime(endTime);
                    timeFrameDto.setDateFormat("MM/dd");
                    timeFrames.add(timeFrameDto);
                }
                break;
            }
            case 3: {
                int i;
                sortId = 12;
                for (i = 0; i < 12; ++i) {
                    Date endTime;
                    Date startTime;
                    if (i == 0) {
                        startTime = DateUtils.getStartTimeOfDay(DateUtils.getFirstDayOfWeek(nowTime));
                        endTime = nowTime;
                    } else {
                        startTime = DateUtils.addDay(judgmentTime, -7);
                        endTime = DateUtils.getEndTimeOfDay(DateUtils.getLastDayOfWeek(startTime));
                    }
                    judgmentTime = startTime;
                    TimeFrameSectioneDto timeFrameDto = new TimeFrameSectioneDto();
                    timeFrameDto.setSortId(Integer.valueOf(sortId - i));
                    timeFrameDto.setStartTime(startTime);
                    timeFrameDto.setEndTime(endTime);
                    timeFrameDto.setDateFormat("MM/dd");
                    timeFrames.add(timeFrameDto);
                }
                break;
            }
            case 4: 
            case 5: {
                int i;
                sortId = 12;
                for (i = 0; i < 12; ++i) {
                    Date endTime;
                    Date startTime;
                    if (i == 0) {
                        startTime = DateUtils.getStartTimeOfDay(DateUtils.getFirstDayOfMonth(nowTime));
                        endTime = nowTime;
                    } else {
                        startTime = DateUtils.addMonth(judgmentTime, -1);
                        endTime = DateUtils.getEndTimeOfDay(DateUtils.getLastDayOfMonth(startTime));
                    }
                    judgmentTime = startTime;
                    TimeFrameSectioneDto timeFrameDto = new TimeFrameSectioneDto();
                    timeFrameDto.setSortId(Integer.valueOf(sortId - i));
                    timeFrameDto.setStartTime(startTime);
                    timeFrameDto.setEndTime(endTime);
                    timeFrameDto.setDateFormat("YY/MM");
                    timeFrames.add(timeFrameDto);
                }
                break;
            }
            default: {
                throw new RuntimeException("\u672a\u77e5\u7edf\u8ba1\u5468\u671f\u7c7b\u578b");
            }
        }
        timeFrames = timeFrames.stream().sorted(Comparator.comparing(TimeFrameSectioneDto::getSortId)).collect(Collectors.toList());
        TimeFrameDto timeFrameDto = new TimeFrameDto();
        timeFrameDto.setCountStartTime(((TimeFrameSectioneDto)timeFrames.get(0)).getStartTime());
        timeFrameDto.setCountEndTime(((TimeFrameSectioneDto)timeFrames.get(timeFrames.size() - 1)).getEndTime());
        timeFrameDto.setTimeFrameSectioneList(timeFrames);
        return timeFrameDto;
    }

    private ChangeSituationDto getIntegerChangeSituation(Integer oneData, Integer twoData) {
        ChangeSituationDto res = new ChangeSituationDto();
        Integer changeValue = twoData - oneData;
        if (changeValue > 0) {
            res.setStatus(Integer.valueOf(1));
        } else if (changeValue < 0) {
            res.setStatus(Integer.valueOf(2));
        } else {
            res.setStatus(Integer.valueOf(3));
        }
        res.setValue(new BigDecimal(Math.abs(changeValue)));
        return res;
    }

    private ChangeSituationDto getBigDecimalChangeSituation(BigDecimal oneData, BigDecimal twoData) {
        ChangeSituationDto res = new ChangeSituationDto();
        BigDecimal changeValue = twoData.subtract(oneData);
        if (changeValue.compareTo(new BigDecimal(0)) > 0) {
            res.setStatus(Integer.valueOf(1));
        } else if (changeValue.compareTo(new BigDecimal(0)) < 0) {
            res.setStatus(Integer.valueOf(2));
        } else {
            res.setStatus(Integer.valueOf(3));
        }
        res.setValue(changeValue.abs());
        return res;
    }

    private TimeFrameDto getTimeFrameByCycleType(Date nowTime, Integer cycleType) {
        Date compareEndTime;
        Date compareStartTime;
        Date endTime;
        Date startTime;
        switch (cycleType) {
            case 1: {
                Date firstDayOfWeek = DateUtils.getFirstDayOfWeek(nowTime);
                if (DateUtil.isSameDay((Date)firstDayOfWeek, (Date)nowTime)) {
                    startTime = DateUtils.addDay(firstDayOfWeek, -7);
                    endTime = DateUtils.getLastDayOfWeek(startTime);
                } else {
                    startTime = firstDayOfWeek;
                    endTime = DateUtils.addDay(nowTime, -1);
                }
                compareStartTime = DateUtils.addDay(startTime, -7);
                compareEndTime = DateUtils.addDay(endTime, -7);
                break;
            }
            case 2: {
                Date firstDayOfMonth = DateUtils.getFirstDayOfMonth(nowTime);
                if (DateUtils.getWeekOfMonth(nowTime) == 1) {
                    startTime = DateUtils.addMonth(firstDayOfMonth, -1);
                    endTime = DateUtils.getLastDayOfMonth(startTime);
                } else {
                    startTime = firstDayOfMonth;
                    endTime = DateUtils.addDay(nowTime, -1);
                }
                compareStartTime = DateUtils.addMonth(startTime, -1);
                compareEndTime = DateUtils.addMonth(endTime, -1);
                break;
            }
            case 3: {
                Date firstDayOfQuarter = DateUtils.getFirstDayOfQuarter(nowTime);
                if (DateUtils.getMonthOfQuarter(nowTime) == 1) {
                    startTime = DateUtils.addMonth(firstDayOfQuarter, -3);
                    endTime = DateUtils.getLastDayOfQuarter(startTime);
                } else {
                    startTime = firstDayOfQuarter;
                    endTime = DateUtils.addDay(nowTime, -1);
                }
                compareStartTime = DateUtils.addMonth(startTime, -3);
                compareEndTime = DateUtils.addMonth(endTime, -3);
                break;
            }
            case 4: {
                Date firstDayOfYear = DateUtils.getFirstDayOfYear(nowTime);
                if (DateUtils.getQuarterOfYear(nowTime) == 1) {
                    startTime = DateUtils.addYear(firstDayOfYear, -1);
                    endTime = DateUtils.getLastDayOfYear(startTime);
                } else {
                    startTime = firstDayOfYear;
                    endTime = DateUtils.addDay(nowTime, -1);
                }
                compareStartTime = DateUtils.addYear(startTime, -1);
                compareEndTime = DateUtils.addYear(endTime, -1);
                break;
            }
            case 5: {
                startTime = null;
                endTime = DateUtils.addDay(nowTime, -1);
                compareStartTime = null;
                compareEndTime = null;
                break;
            }
            default: {
                throw new RuntimeException("\u672a\u77e5\u7edf\u8ba1\u5468\u671f\u7c7b\u578b");
            }
        }
        ArrayList<TimeFrameSectioneDto> sectioneDtoList = new ArrayList<TimeFrameSectioneDto>();
        if (null != compareStartTime) {
            TimeFrameSectioneDto compareTimeFrameSectioneDto = new TimeFrameSectioneDto();
            compareTimeFrameSectioneDto.setSortId(Integer.valueOf(1));
            compareTimeFrameSectioneDto.setStartTime(DateUtils.getStartTimeOfDay(compareStartTime));
            compareTimeFrameSectioneDto.setEndTime(DateUtils.getEndTimeOfDay(compareEndTime));
            sectioneDtoList.add(compareTimeFrameSectioneDto);
        }
        TimeFrameSectioneDto timeFrameSectioneDto = new TimeFrameSectioneDto();
        timeFrameSectioneDto.setSortId(Integer.valueOf(2));
        timeFrameSectioneDto.setStartTime(startTime == null ? null : DateUtils.getStartTimeOfDay(startTime));
        timeFrameSectioneDto.setEndTime(DateUtils.getEndTimeOfDay(endTime));
        sectioneDtoList.add(timeFrameSectioneDto);
        TimeFrameDto res = new TimeFrameDto();
        res.setCountStartTime(compareStartTime == null ? null : DateUtils.getStartTimeOfDay(compareStartTime));
        res.setCountEndTime(DateUtils.getEndTimeOfDay(endTime));
        res.setTimeFrameSectioneList(sectioneDtoList);
        return res;
    }

    public List<Integer> getCanSeeUserIdListByUser(Users user) {
        List<Integer> userIdList = this.userUtilService.selectChildUserList(null, user, false);
        return userIdList;
    }
}

