/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.training.service.impl;

import com.alibaba.druid.util.StringUtils;
import com.ovopark.organize.common.base.BaseResult;
import com.ovopark.organize.common.model.mo.UserAndParentNameMo;
import com.ovopark.organize.common.model.mo.UsersAndOrgsMo;
import com.ovopark.organize.common.model.pojo.SimplePojo;
import com.ovopark.organize.sdk.api.OrganizeApi;
import com.ovopark.organize.sdk.api.UserApi;
import com.ovopark.organize.sdk.api.UserOrganizeApi;
import com.ovopark.training.mapper.OrganizeMapper;
import com.ovopark.training.mapper.UserOrganizeMapper;
import com.ovopark.training.model.Authenticator;
import com.ovopark.training.model.Organize;
import com.ovopark.training.model.Users;
import com.ovopark.training.service.OrganizeService;
import com.ovopark.training.util.ResultCheckUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class OrganizeServiceImpl
implements OrganizeService {
    private static final Logger log = LoggerFactory.getLogger(OrganizeServiceImpl.class);
    @Autowired
    private OrganizeMapper organizeMapper;
    @Autowired
    private UserOrganizeMapper userOrganizeMapper;
    @Autowired
    private UserApi userApi;
    @Autowired
    private UserOrganizeApi userOrganizeApi;
    @Autowired
    private OrganizeApi organizeApi;

    @Override
    public String getRootOrganize(int enterpriseId) {
        BaseResult result = this.organizeApi.getRootOrganize(Integer.valueOf(enterpriseId));
        if (ResultCheckUtils.okOrganizeWithData(result)) {
            return "O_" + result.getData();
        }
        return null;
    }

    public void findAllChildOrganizeids(List<Integer> organizeIds, Integer organizeId) {
        Users users = Authenticator.getInstance().getCurrentUser();
        List childOrganizeIds = (List)this.organizeApi.getChilldOrganizeByUserIdAndOrgId(users.getGroupId(), organizeId, users.getId()).getData();
        if (childOrganizeIds.size() > 0) {
            for (Integer cid : childOrganizeIds) {
                this.findAllChildOrganizeids(organizeIds, cid);
            }
        }
        organizeIds.add(organizeId);
    }

    @Override
    public List<Integer> findUserIdsByOrganize(List<Integer> organizeIds) {
        ArrayList<Integer> userIds = new ArrayList<Integer>();
        for (Integer organizeId : organizeIds) {
            List<Integer> userIds2 = this.findUserIds(organizeId);
            for (Integer userId : userIds2) {
                if (userIds.contains(userId)) continue;
                userIds.add(userId);
            }
        }
        return userIds;
    }

    private List<Integer> findUserIds(Integer organizeId) {
        ArrayList<Integer> resultUsers = new ArrayList();
        ArrayList<Integer> organizeIds = new ArrayList<Integer>();
        this.findAllChildOrganizeids(organizeIds, organizeId);
        UsersAndOrgsMo mo = new UsersAndOrgsMo();
        mo.setOrganizeIds(organizeIds.stream().map(String::valueOf).collect(Collectors.toList()));
        resultUsers = (List)this.userOrganizeApi.getUserByOrganizeIds(mo).getData();
        return resultUsers;
    }

    @Override
    public String getPOrganizeName(String name, Integer orgId, List<Organize> organizes) {
        Organize organize = null;
        for (Organize o : organizes) {
            if (!o.getId().equals(orgId)) continue;
            organize = o;
            break;
        }
        if (organize == null) {
            return name;
        }
        name = organize.getName() + "-" + name;
        if (organize.getPid() == null) {
            return name;
        }
        return this.getPOrganizeName(name, organize.getPid(), organizes);
    }

    @Override
    public List<Integer> getUserListNew(Users user, String organizeIds, String userIds, String userName, Integer enterpriseId) {
        List<Integer> rootRetainAll = null;
        try {
            rootRetainAll = new ArrayList<Integer>();
            List<Object> userIdsByOrganizeIdsList = new ArrayList();
            if (!StringUtils.isEmpty((CharSequence)organizeIds)) {
                List<String> organizeIdList = Arrays.asList(organizeIds.split(","));
                UsersAndOrgsMo mo = new UsersAndOrgsMo();
                mo.setGroupId(user.getGroupId());
                mo.setOrganizeIds(organizeIdList);
                BaseResult base = this.userOrganizeApi.getUserByOrganizeIdsOrDepId(mo);
                if (base != null && !CollectionUtils.isEmpty((Collection)((Collection)base.getData()))) {
                    userIdsByOrganizeIdsList = ((List)base.getData()).stream().map(UserAndParentNameMo::getUserId).distinct().collect(Collectors.toList());
                }
                if (org.apache.commons.collections.CollectionUtils.isEmpty(userIdsByOrganizeIdsList)) {
                    return null;
                }
            } else {
                BaseResult base = this.userApi.getSimpleUserByKeyWord(enterpriseId, null, null);
                if (base != null && !org.apache.commons.collections.CollectionUtils.isEmpty((Collection)((Collection)base.getData()))) {
                    userIdsByOrganizeIdsList = ((List)base.getData()).stream().map(SimplePojo::getId).distinct().collect(Collectors.toList());
                }
            }
            List<Object> userIdsByUserName = new ArrayList();
            if (!StringUtils.isEmpty((CharSequence)userName)) {
                BaseResult base = this.userApi.getSimpleUserByKeyWord(user.getGroupId(), userName, null);
                if (base != null && !CollectionUtils.isEmpty((Collection)((Collection)base.getData()))) {
                    userIdsByUserName = ((List)base.getData()).stream().map(SimplePojo::getId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
                }
                rootRetainAll = this.rootRetainAllNew(user, userIdsByOrganizeIdsList, userIdsByUserName);
            } else {
                rootRetainAll.addAll(userIdsByOrganizeIdsList);
            }
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
        }
        return rootRetainAll;
    }

    public List<Integer> rootRetainAllNew(Users user, List<Integer> ... argList) {
        List<Integer> userIdsList = argList[0];
        if (userIdsList != null && userIdsList.size() > 0) {
            for (int i = 0; i < argList.length; ++i) {
                if (argList[i] == null) continue;
                userIdsList.retainAll(argList[i]);
            }
        }
        return userIdsList;
    }
}

