/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.training.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ovopark.organize.common.base.BaseResult;
import com.ovopark.organize.common.model.mo.DataStatisticMo;
import com.ovopark.organize.common.model.mo.DataStatisticModule;
import com.ovopark.organize.sdk.api.DataStatisticApi;
import com.ovopark.training.mapper.TrainingChapterAttachMapper;
import com.ovopark.training.mapper.TrainingConfigMapper;
import com.ovopark.training.mapper.TrainingMapper;
import com.ovopark.training.mapper.TrainingMaterialMapper;
import com.ovopark.training.mapper.TrainingMaterialTypeMapper;
import com.ovopark.training.mapper.TrainingUserPaperMapper;
import com.ovopark.training.mapper.TrainingUserViewTimeCheckMapper;
import com.ovopark.training.mapper.TrainingUserViewTimeCourseMapper;
import com.ovopark.training.mapper.TrainingUserViewTimeJobMapper;
import com.ovopark.training.mapper.TrainingUserViewTimeLearnMapper;
import com.ovopark.training.mapper.TrainingUserViewTimeMapper;
import com.ovopark.training.mapper.TrainingUserViewTimeMaterialMapper;
import com.ovopark.training.mapper.TrainingUserViewTimeTrainingMapper;
import com.ovopark.training.model.Training;
import com.ovopark.training.model.TrainingChapterAttach;
import com.ovopark.training.model.TrainingConfig;
import com.ovopark.training.model.TrainingExam;
import com.ovopark.training.model.TrainingMaterial;
import com.ovopark.training.model.TrainingMaterialType;
import com.ovopark.training.model.TrainingPaper;
import com.ovopark.training.model.TrainingUserPaper;
import com.ovopark.training.model.TrainingUserViewTime;
import com.ovopark.training.model.TrainingUserViewTimeCheck;
import com.ovopark.training.model.TrainingUserViewTimeCourse;
import com.ovopark.training.model.TrainingUserViewTimeJob;
import com.ovopark.training.model.TrainingUserViewTimeLearn;
import com.ovopark.training.model.TrainingUserViewTimeMaterial;
import com.ovopark.training.model.TrainingUserViewTimeTraining;
import com.ovopark.training.model.Users;
import com.ovopark.training.service.TrainingCommonService;
import com.ovopark.training.service.UserUtilService;
import com.ovopark.training.service.resource.ResourceService;
import com.ovopark.training.service.resource.ResourceSinglePermissionService;
import com.ovopark.training.vo.TrainingDataShowVo;
import com.ovopark.training.vo.TrainingUserViewTimeVo;
import com.ovopark.training.vo.TrainingsVo;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.ibatis.annotations.Param;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
public class TrainingCommonServiceImpl
implements TrainingCommonService {
    private static final Logger log = LoggerFactory.getLogger(TrainingCommonServiceImpl.class);
    @Autowired
    private TrainingMapper trainingMapper;
    @Autowired
    private TrainingUserViewTimeMapper userViewTimeMapper;
    @Autowired
    private TrainingMaterialMapper trainingMaterialMapper;
    @Autowired
    private TrainingMaterialMapper materialMapper;
    @Autowired
    private TrainingChapterAttachMapper trainingChapterAttachMapper;
    @Autowired
    private TrainingUserPaperMapper trainingUserPaperMapper;
    @Autowired
    private UserUtilService userUtilService;
    @Autowired
    private TrainingConfigMapper trainingConfigMapper;
    @Autowired
    private TrainingUserViewTimeTrainingMapper trainingUserViewTimeTrainingMapper;
    @Autowired
    private TrainingUserViewTimeCourseMapper trainingUserViewTimeCourseMapper;
    @Autowired
    private TrainingUserViewTimeJobMapper trainingUserViewTimeJobMapper;
    @Autowired
    private TrainingUserViewTimeLearnMapper trainingUserViewTimeLearnMapper;
    @Autowired
    private TrainingUserViewTimeMaterialMapper trainingUserViewTimeMaterialMapper;
    @Autowired
    private TrainingUserViewTimeCheckMapper trainingUserViewTimeCheckMapper;
    @Resource
    private DataStatisticApi dataStatisticApi;
    @Autowired
    private TrainingMaterialTypeMapper trainingMaterialTypeMapper;
    @Autowired
    private ResourceSinglePermissionService resourceSinglePermissionService;
    @Autowired
    private ResourceService resourceService;

    @Override
    public List<TrainingUserViewTimeVo> selectlearnProgress(Integer trainingId, Integer learnType, Integer taskId, Integer userId, Integer turns, Integer isProgress) {
        if (turns == null) {
            turns = 1;
        }
        if (isProgress == null) {
            isProgress = 0;
        }
        ArrayList<TrainingUserViewTimeVo> list = new ArrayList<TrainingUserViewTimeVo>();
        LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)wrapper1.eq(TrainingChapterAttach::getTrainingId, (Object)trainingId)).eq(TrainingChapterAttach::getIsDel, (Object)0);
        List trainingChapterAttachList = this.trainingChapterAttachMapper.selectList((Wrapper)wrapper1);
        if (!CollectionUtils.isEmpty((Collection)trainingChapterAttachList)) {
            ArrayList<Integer> materialIdList = new ArrayList<Integer>();
            ArrayList<Integer> paperIdList = new ArrayList<Integer>();
            for (TrainingChapterAttach trainingChapterAttach : trainingChapterAttachList) {
                if (trainingChapterAttach.getMaterialId() != null) {
                    materialIdList.add(trainingChapterAttach.getMaterialId());
                    continue;
                }
                if (trainingChapterAttach.getPaperId() == null) continue;
                paperIdList.add(trainingChapterAttach.getPaperId());
            }
            Map<Object, Object> userViewMap = new HashMap();
            Map<Object, Object> materialMap = new HashMap();
            if (!CollectionUtils.isEmpty(materialIdList)) {
                List<TrainingUserViewTimeVo> trainingViewList = this.selectAllTimeByMaterial(isProgress == 1 ? null : trainingId, isProgress == 1 ? 0 : learnType, isProgress == 1 ? null : taskId, userId, turns, materialIdList);
                if (!CollectionUtils.isEmpty(trainingViewList)) {
                    userViewMap = trainingViewList.stream().collect(Collectors.toMap(TrainingUserViewTime::getMaterialId, Function.identity()));
                }
                LambdaQueryWrapper wrapper2 = new LambdaQueryWrapper();
                wrapper2.in(TrainingMaterial::getId, materialIdList);
                List mateList = this.materialMapper.selectList((Wrapper)wrapper2);
                materialMap = mateList.stream().collect(Collectors.toMap(TrainingMaterial::getId, Function.identity()));
            }
            Map<Object, Object> userPaperMap = new HashMap();
            if (!CollectionUtils.isEmpty(paperIdList)) {
                int sourceType = 1;
                if (learnType == 2) {
                    sourceType = 3;
                } else if (learnType == 3) {
                    sourceType = 4;
                } else if (learnType == 4) {
                    sourceType = 5;
                }
                LambdaQueryWrapper wrapper3 = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper3.eq(TrainingUserPaper::getUserId, (Object)userId)).in(TrainingUserPaper::getTrainingPaperId, paperIdList)).eq(TrainingUserPaper::getSourceType, (Object)sourceType)).eq(sourceType == 1, TrainingUserPaper::getSourceProjectId, (Object)trainingId)).eq(taskId != null, TrainingUserPaper::getSourceTaskId, (Object)taskId)).isNotNull(TrainingUserPaper::getSubmitTime);
                List trainingUserPaperList = this.trainingUserPaperMapper.selectList((Wrapper)wrapper3);
                if (!CollectionUtils.isEmpty((Collection)trainingUserPaperList)) {
                    userPaperMap = trainingUserPaperList.stream().collect(Collectors.groupingBy(TrainingUserPaper::getTrainingPaperId));
                }
            }
            TrainingUserViewTimeVo vo = null;
            for (TrainingChapterAttach trainingChapterAttach : trainingChapterAttachList) {
                vo = new TrainingUserViewTimeVo();
                vo.setIsFinish(Integer.valueOf(0));
                vo.setViewTimes(Integer.valueOf(0));
                vo.setReadRate(BigDecimal.ZERO);
                vo.setAttachId(trainingChapterAttach.getId());
                if (trainingChapterAttach.getMaterialId() != null) {
                    TrainingUserViewTimeVo userViewTimes;
                    vo.setMaterialId(trainingChapterAttach.getMaterialId());
                    TrainingMaterial material = (TrainingMaterial)materialMap.get(trainingChapterAttach.getMaterialId());
                    BigDecimal finishTime = new BigDecimal("30");
                    if (!ObjectUtils.isEmpty((Object)material)) {
                        if (material.getIsVideo() != null && material.getIsVideo() == 1 && !StringUtils.isEmpty((Object)material.getDuration())) {
                            finishTime = new BigDecimal(material.getDuration().toString());
                            if (!StringUtils.isEmpty((Object)material.getFinishRate())) {
                                finishTime = finishTime.multiply(material.getFinishRate()).divide(new BigDecimal("100"), 0, 1);
                            }
                        } else if (material.getFinishTime() != null) {
                            finishTime = new BigDecimal(material.getFinishTime().toString());
                        }
                    }
                    if (!ObjectUtils.isEmpty((Object)(userViewTimes = (TrainingUserViewTimeVo)userViewMap.get(trainingChapterAttach.getMaterialId()))) && userViewTimes.getMaterialId() != null) {
                        BigDecimal viewTime = new BigDecimal(userViewTimes.getViewTimes().toString());
                        BigDecimal rate = BigDecimal.ONE;
                        if (finishTime.compareTo(BigDecimal.ZERO) > 0) {
                            rate = viewTime.divide(finishTime, 2, 1);
                        }
                        vo.setViewTimes(Integer.valueOf(viewTime.intValue()));
                        vo.setReadRate(viewTime.compareTo(finishTime) >= 0 ? BigDecimal.ONE : rate);
                        vo.setReadTimes(Integer.valueOf(viewTime.compareTo(finishTime) >= 0 ? 0 : finishTime.subtract(viewTime).intValue()));
                        if (viewTime.compareTo(finishTime) >= 0) {
                            vo.setIsFinish(Integer.valueOf(1));
                        } else {
                            vo.setIsFinish(Integer.valueOf(0));
                        }
                        vo.setStartDate(userViewTimes.getStartDate());
                        vo.setEndDate(userViewTimes.getEndDate());
                    }
                } else if (trainingChapterAttach.getPaperId() != null) {
                    vo.setPaperId(trainingChapterAttach.getPaperId());
                    List trainingUserPaperList = (List)userPaperMap.get(trainingChapterAttach.getPaperId());
                    if (!CollectionUtils.isEmpty((Collection)trainingUserPaperList)) {
                        vo.setIsFinish(Integer.valueOf(1));
                        vo.setViewTimes(Integer.valueOf(0));
                        vo.setReadRate(BigDecimal.ONE);
                        Date startDate = null;
                        Date endDate = null;
                        for (TrainingUserPaper userPaper : trainingUserPaperList) {
                            if (userPaper.getUpdateTime() != null) {
                                if (startDate != null) {
                                    if (startDate.after(userPaper.getUpdateTime())) {
                                        startDate = userPaper.getUpdateTime();
                                    }
                                } else {
                                    startDate = userPaper.getUpdateTime();
                                }
                            }
                            if (userPaper.getSubmitTime() == null) continue;
                            if (endDate != null) {
                                if (!endDate.before(userPaper.getSubmitTime())) continue;
                                endDate = userPaper.getSubmitTime();
                                continue;
                            }
                            endDate = userPaper.getSubmitTime();
                        }
                        vo.setStartDate(startDate);
                        vo.setEndDate(endDate);
                    }
                }
                list.add(vo);
            }
        }
        return list;
    }

    @Override
    public void postData(String beginDate, Integer dayUserIds, Integer dayGroupIds) {
        DataStatisticMo mo = new DataStatisticMo();
        mo.setModule(DataStatisticModule.TRAINING);
        mo.setDate(LocalDate.parse(beginDate, DateTimeFormatter.ofPattern("yyyy-MM-dd")));
        mo.setNewUserCount(dayUserIds);
        mo.setNewEnterpriseCount(dayGroupIds);
        BaseResult result = this.dataStatisticApi.postData(mo);
    }

    @Override
    public Map<Integer, TrainingDataShowVo> selectTrainNumberContent(List<Integer> trainingIdList, Users user) {
        HashMap<Integer, TrainingDataShowVo> trainingMap = new HashMap<Integer, TrainingDataShowVo>();
        if (!CollectionUtils.isEmpty(trainingIdList)) {
            ArrayList<Integer> materialIdList = new ArrayList<Integer>();
            ArrayList<Integer> paperIdList = new ArrayList<Integer>();
            LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)wrapper1.in(TrainingChapterAttach::getTrainingId, trainingIdList)).eq(TrainingChapterAttach::getIsDel, (Object)0);
            List trainingChapterAttachList = this.trainingChapterAttachMapper.selectList((Wrapper)wrapper1);
            Map<Object, Object> attachMap = new HashMap();
            if (!CollectionUtils.isEmpty((Collection)trainingChapterAttachList)) {
                attachMap = trainingChapterAttachList.stream().collect(Collectors.groupingBy(TrainingChapterAttach::getTrainingId));
                for (TrainingChapterAttach trainingChapterAttach : trainingChapterAttachList) {
                    if (trainingChapterAttach.getMaterialId() != null) {
                        materialIdList.add(trainingChapterAttach.getMaterialId());
                        continue;
                    }
                    if (trainingChapterAttach.getPaperId() == null) continue;
                    paperIdList.add(trainingChapterAttach.getPaperId());
                }
            }
            Map<Object, Object> userViewTimeMap = new HashMap();
            List<TrainingUserViewTimeTraining> userViewTimeList = this.trainingUserViewTimeTrainingMapper.selectUserTrainingByTrainingType(user.getGroupId(), trainingIdList);
            if (!CollectionUtils.isEmpty(userViewTimeList)) {
                userViewTimeMap = userViewTimeList.stream().collect(Collectors.groupingBy(TrainingUserViewTime::getTrainingId));
            }
            Map<Object, Object> userPaperMap = new HashMap();
            if (!CollectionUtils.isEmpty(paperIdList)) {
                LambdaQueryWrapper wrapper2 = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper2.eq(user.getGroupId() != null, TrainingUserPaper::getEnterpriseId, (Object)user.getGroupId())).in(TrainingUserPaper::getTrainingPaperId, paperIdList)).eq(TrainingUserPaper::getSourceType, (Object)1)).isNotNull(TrainingUserPaper::getSubmitTime);
                List trainingUserPaperList = this.trainingUserPaperMapper.selectList((Wrapper)wrapper2);
                if (!CollectionUtils.isEmpty((Collection)trainingUserPaperList)) {
                    userPaperMap = trainingUserPaperList.stream().collect(Collectors.groupingBy(TrainingUserPaper::getTrainingPaperId));
                }
            }
            Map<Integer, List<Integer>> trainingUsersMap = this.resourceSinglePermissionService.getUserIdMapByTrainIdList(trainingIdList, user.getGroupId());
            TrainingDataShowVo trainingDataShowVo = null;
            List<Object> userIdList = null;
            ArrayList<Object> paperUserIdList = null;
            for (Integer trainingId : trainingIdList) {
                List trainingUserViewTimeList;
                trainingDataShowVo = new TrainingDataShowVo();
                userIdList = new ArrayList();
                List<Integer> userIds = trainingUsersMap.get(trainingId);
                List trainingChapterAttaches = (List)attachMap.get(trainingId);
                int attachNum = 0;
                int paperUserNum = 0;
                if (!CollectionUtils.isEmpty((Collection)trainingChapterAttaches)) {
                    attachNum = trainingChapterAttaches.size();
                    List paperIds = trainingChapterAttaches.stream().map(TrainingChapterAttach::getPaperId).filter(Objects::nonNull).collect(Collectors.toList());
                    trainingDataShowVo.setPaperIdList(paperIds);
                    if (!CollectionUtils.isEmpty(paperIds)) {
                        for (Integer paperId : paperIds) {
                            List trainingUserPaperList = (List)userPaperMap.get(paperId);
                            if (CollectionUtils.isEmpty((Collection)trainingUserPaperList)) continue;
                            for (TrainingUserPaper trainingUserPaper : trainingUserPaperList) {
                                if (trainingUserPaper.getSourceProjectId() == null || !trainingUserPaper.getSourceProjectId().equals(trainingId) || trainingUserPaper.getUserId() == null) continue;
                                userIdList.add(trainingUserPaper.getUserId());
                            }
                        }
                        if (!CollectionUtils.isEmpty(userIdList)) {
                            paperUserIdList = new ArrayList<Object>();
                            userIdList = userIdList.stream().distinct().collect(Collectors.toList());
                            if (!CollectionUtils.isEmpty(userIds)) {
                                userIdList.retainAll(userIds);
                            }
                            paperUserIdList.addAll(userIdList);
                            trainingDataShowVo.setPaperUserIdList(paperUserIdList);
                            paperUserNum = userIdList.size();
                        }
                    }
                }
                if (!CollectionUtils.isEmpty((Collection)(trainingUserViewTimeList = (List)userViewTimeMap.get(trainingId)))) {
                    List viewUserIds = trainingUserViewTimeList.stream().map(TrainingUserViewTime::getUserId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
                    userIdList.addAll(viewUserIds);
                }
                trainingDataShowVo.setUserIdList(userIds);
                if (!CollectionUtils.isEmpty(userIds)) {
                    userIdList.retainAll(userIds);
                }
                if (!CollectionUtils.isEmpty(userIdList)) {
                    userIdList = userIdList.stream().distinct().collect(Collectors.toList());
                }
                trainingDataShowVo.setAttachNum(Integer.valueOf(attachNum));
                trainingDataShowVo.setViewerIdList(userIdList);
                if (!CollectionUtils.isEmpty(userIdList)) {
                    trainingDataShowVo.setViewerNum(Integer.valueOf(userIdList.size()));
                } else {
                    trainingDataShowVo.setViewerNum(Integer.valueOf(0));
                }
                trainingDataShowVo.setPaperUserNum(Integer.valueOf(paperUserNum));
                trainingMap.put(trainingId, trainingDataShowVo);
            }
        }
        return trainingMap;
    }

    @Override
    public Map<Integer, TrainingDataShowVo> selectTrainNumberList(List<Integer> trainingIdList, Users user) {
        HashMap<Integer, TrainingDataShowVo> trainingMap = new HashMap<Integer, TrainingDataShowVo>();
        if (CollectionUtils.isEmpty(trainingIdList)) {
            return trainingMap;
        }
        List trainingList = this.trainingMapper.selectBatchIds(trainingIdList);
        if (CollectionUtils.isEmpty((Collection)trainingList)) {
            return trainingMap;
        }
        LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)wrapper1.in(TrainingChapterAttach::getTrainingId, trainingIdList)).eq(TrainingChapterAttach::getIsDel, (Object)0);
        List trainingChapterAttachList = this.trainingChapterAttachMapper.selectList((Wrapper)wrapper1);
        Map<Object, Object> attachMap = new HashMap();
        if (!CollectionUtils.isEmpty((Collection)trainingChapterAttachList)) {
            attachMap = trainingChapterAttachList.stream().collect(Collectors.groupingBy(TrainingChapterAttach::getTrainingId));
        }
        TrainingDataShowVo trainingDataShowVo = null;
        for (Training training : trainingList) {
            trainingDataShowVo = new TrainingDataShowVo();
            List trainingChapterAttaches = (List)attachMap.get(training.getId());
            int attachNum = 0;
            if (!CollectionUtils.isEmpty((Collection)trainingChapterAttaches)) {
                attachNum = trainingChapterAttaches.size();
            }
            trainingDataShowVo.setAttachNum(Integer.valueOf(attachNum));
            trainingDataShowVo.setViewerNum(training.getViewCount());
            trainingMap.put(training.getId(), trainingDataShowVo);
        }
        return trainingMap;
    }

    @Override
    public TrainingDataShowVo selectTrainingNumber(Integer trainingId, Users user) {
        TrainingDataShowVo trainingDataShowVo = new TrainingDataShowVo();
        ArrayList<Integer> materialIdList = new ArrayList<Integer>();
        ArrayList<Integer> paperIdList = new ArrayList<Integer>();
        LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)wrapper1.eq(TrainingChapterAttach::getTrainingId, (Object)trainingId)).eq(TrainingChapterAttach::getIsDel, (Object)0);
        List trainingChapterAttachList = this.trainingChapterAttachMapper.selectList((Wrapper)wrapper1);
        if (!CollectionUtils.isEmpty((Collection)trainingChapterAttachList)) {
            for (TrainingChapterAttach trainingChapterAttach : trainingChapterAttachList) {
                if (trainingChapterAttach.getMaterialId() != null) {
                    materialIdList.add(trainingChapterAttach.getMaterialId());
                    continue;
                }
                if (trainingChapterAttach.getPaperId() == null) continue;
                paperIdList.add(trainingChapterAttach.getPaperId());
            }
            trainingDataShowVo.setAttachNum(Integer.valueOf(trainingChapterAttachList.size()));
            trainingDataShowVo.setPaperIdList(paperIdList);
        }
        Map<Object, Object> userPaperMap = new HashMap();
        if (!CollectionUtils.isEmpty(paperIdList)) {
            LambdaQueryWrapper wrapper2 = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper2.eq(user.getGroupId() != null, TrainingUserPaper::getEnterpriseId, (Object)user.getGroupId())).in(TrainingUserPaper::getTrainingPaperId, paperIdList)).eq(TrainingUserPaper::getSourceType, (Object)1)).eq(TrainingUserPaper::getSourceProjectId, (Object)trainingId)).isNotNull(TrainingUserPaper::getSubmitTime);
            List trainingUserPaperList = this.trainingUserPaperMapper.selectList((Wrapper)wrapper2);
            if (!CollectionUtils.isEmpty((Collection)trainingUserPaperList)) {
                userPaperMap = trainingUserPaperList.stream().collect(Collectors.groupingBy(TrainingUserPaper::getTrainingPaperId));
            }
        }
        List<Object> userIdList = new ArrayList();
        ArrayList<Object> paperUserIdList = new ArrayList<Object>();
        if (!CollectionUtils.isEmpty(paperIdList)) {
            for (Integer paperId : paperIdList) {
                List trainingUserPaperList = (List)userPaperMap.get(paperId);
                if (CollectionUtils.isEmpty((Collection)trainingUserPaperList)) continue;
                for (TrainingUserPaper trainingUserPaper : trainingUserPaperList) {
                    if (trainingUserPaper.getUserId() == null) continue;
                    userIdList.add(trainingUserPaper.getUserId());
                }
            }
            if (!CollectionUtils.isEmpty(userIdList)) {
                userIdList = userIdList.stream().distinct().collect(Collectors.toList());
                paperUserIdList.addAll(userIdList);
            }
        }
        trainingDataShowVo.setPaperUserIdList(paperUserIdList);
        trainingDataShowVo.setPaperUserNum(Integer.valueOf(paperUserIdList.size()));
        List<Integer> usersList = this.trainingUserViewTimeTrainingMapper.selectDistinctUserByTimes(user.getGroupId(), trainingId, 1);
        if (!CollectionUtils.isEmpty(usersList)) {
            userIdList.addAll(usersList);
        }
        trainingDataShowVo.setViewerIdList(userIdList);
        if (!CollectionUtils.isEmpty(userIdList)) {
            trainingDataShowVo.setViewerNum(Integer.valueOf(userIdList.size()));
        } else {
            trainingDataShowVo.setViewerNum(Integer.valueOf(0));
        }
        return trainingDataShowVo;
    }

    @Override
    public Map<String, Object> isPaperStatus(TrainingPaper trainingPaper, TrainingExam trainingExam, List<TrainingUserPaper> userPapers) {
        int status = 0;
        BigDecimal score = BigDecimal.ZERO;
        boolean isWait = true;
        if (!ObjectUtils.isEmpty((Object)trainingPaper) && !CollectionUtils.isEmpty(userPapers)) {
            TrainingUserPaper temp = userPapers.get(0);
            for (TrainingUserPaper userPaper : userPapers) {
                if (userPaper.getPaperStatus() == 1) continue;
                if (Objects.isNull(trainingPaper.getScoreSelect()) || trainingPaper.getScoreSelect() == 1) {
                    if (temp.getPaperStatus() != 1 && !userPaper.getCreateTime().after(temp.getCreateTime())) continue;
                    temp = userPaper;
                    continue;
                }
                if (trainingPaper.getScoreSelect() == 0) {
                    if (temp.getPaperStatus() != 1 && userPaper.getScore().intValue() <= temp.getScore().intValue()) continue;
                    temp = userPaper;
                    continue;
                }
                if (trainingPaper.getScoreSelect() != 2 || temp.getPaperStatus() != 1 && !userPaper.getCreateTime().before(temp.getCreateTime())) continue;
                temp = userPaper;
            }
            if (temp.getPaperStatus().equals(2)) {
                isWait = false;
                score = temp.getScore();
            }
            if (!isWait) {
                BigDecimal passScore = new BigDecimal("60");
                if (!ObjectUtils.isEmpty((Object)trainingExam) && !StringUtils.isEmpty((Object)trainingExam.getScore())) {
                    passScore = trainingExam.getScore().multiply(new BigDecimal(StringUtils.isEmpty((Object)trainingPaper.getPassLine()) ? 60 : trainingPaper.getPassLine())).divide(new BigDecimal(100), 2, 4);
                }
                status = score.compareTo(passScore) < 0 ? 3 : 2;
            } else {
                status = 1;
            }
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("status", status);
        map.put("score", score);
        return map;
    }

    @Override
    public Map<String, Object> selectIsFinishTraining(Integer trainingId, Integer userId, Map<Integer, List<TrainingUserViewTimeVo>> viewMap, Map<Integer, List<TrainingUserViewTimeVo>> materialViewMap, Map<Integer, List<TrainingChapterAttach>> trainingChapterAttachMap, Map<Integer, TrainingMaterial> materialMap, Map<Integer, List<TrainingUserPaper>> userPaperMap) {
        List<TrainingChapterAttach> trainingChapterAttachList;
        HashMap<String, Object> map = new HashMap<String, Object>();
        int status = 0;
        int num = 0;
        int finishNum = 0;
        Date startDate = null;
        Date endDate = null;
        Date lastDate = null;
        BigDecimal useRate = BigDecimal.ZERO;
        BigDecimal studyTime = BigDecimal.ZERO;
        List<Object> userViewTimeVos = viewMap.get(trainingId);
        if (!CollectionUtils.isEmpty(userViewTimeVos)) {
            userViewTimeVos = userViewTimeVos.stream().filter(e -> e.getUserId().compareTo(userId) == 0).collect(Collectors.toList());
        }
        if (!CollectionUtils.isEmpty(trainingChapterAttachList = trainingChapterAttachMap.get(trainingId))) {
            for (TrainingChapterAttach trainingChapterAttach : trainingChapterAttachList) {
                List<TrainingUserPaper> trainingUserPaperList;
                ++num;
                if (trainingChapterAttach.getMaterialId() != null) {
                    TrainingMaterial material;
                    if (CollectionUtils.isEmpty(userViewTimeVos) || ObjectUtils.isEmpty((Object)(material = materialMap.get(trainingChapterAttach.getMaterialId())))) continue;
                    BigDecimal finishTime = new BigDecimal("30");
                    finishTime = !StringUtils.isEmpty((Object)material.getIsVideo()) && material.getIsVideo() == 1 ? new BigDecimal(material.getDuration()).multiply(material.getFinishRate()).divide(new BigDecimal("100"), 0, 1) : new BigDecimal(material.getFinishTime());
                    List<TrainingUserViewTimeVo> userMaterialViewTimeVos = materialViewMap.get(material.getId());
                    if (!CollectionUtils.isEmpty(userMaterialViewTimeVos)) {
                        for (TrainingUserViewTimeVo trainingUserViewTimeVo : userMaterialViewTimeVos) {
                            if (trainingUserViewTimeVo.getUserId().compareTo(userId) != 0 || trainingUserViewTimeVo.getViewTime() < 0) continue;
                            status = 1;
                            if (finishTime.compareTo(new BigDecimal(trainingUserViewTimeVo.getViewTime())) <= 0) {
                                ++finishNum;
                                useRate = useRate.add(BigDecimal.ONE);
                                continue;
                            }
                            if (finishTime.compareTo(BigDecimal.ZERO) <= 0) {
                                useRate = useRate.add(BigDecimal.ONE);
                                ++finishNum;
                                continue;
                            }
                            useRate = useRate.add(new BigDecimal(trainingUserViewTimeVo.getViewTime().toString()).divide(finishTime, 2, 1));
                        }
                    }
                    for (TrainingUserViewTimeVo trainingUserViewTimeVo : userViewTimeVos) {
                        if (trainingUserViewTimeVo.getUserId().compareTo(userId) != 0 || trainingUserViewTimeVo.getMaterialId().compareTo(trainingChapterAttach.getMaterialId()) != 0 || trainingUserViewTimeVo.getViewTime() < 0) continue;
                        studyTime = studyTime.add(new BigDecimal(trainingUserViewTimeVo.getViewTime().toString()));
                        if (StringUtils.isEmpty((Object)startDate)) {
                            startDate = trainingUserViewTimeVo.getStartDate();
                        } else if (startDate.after(trainingUserViewTimeVo.getStartDate())) {
                            startDate = trainingUserViewTimeVo.getStartDate();
                        }
                        if (StringUtils.isEmpty((Object)lastDate)) {
                            lastDate = trainingUserViewTimeVo.getEndDate();
                            continue;
                        }
                        if (!lastDate.before(trainingUserViewTimeVo.getEndDate())) continue;
                        lastDate = trainingUserViewTimeVo.getEndDate();
                    }
                    continue;
                }
                if (trainingChapterAttach.getPaperId() == null || CollectionUtils.isEmpty(trainingUserPaperList = userPaperMap.get(trainingChapterAttach.getPaperId()))) continue;
                boolean isNum = false;
                for (TrainingUserPaper trainingUserPaper : trainingUserPaperList) {
                    if (trainingUserPaper.getUserId() == null || trainingUserPaper.getUserId().compareTo(userId) != 0) continue;
                    status = 1;
                    isNum = true;
                    if (StringUtils.isEmpty(startDate)) {
                        startDate = trainingUserPaper.getUpdateTime();
                    } else if (startDate.after(trainingUserPaper.getUpdateTime())) {
                        startDate = trainingUserPaper.getUpdateTime();
                    }
                    if (StringUtils.isEmpty(lastDate)) {
                        lastDate = trainingUserPaper.getSubmitTime();
                        continue;
                    }
                    if (!lastDate.before(trainingUserPaper.getSubmitTime())) continue;
                    lastDate = trainingUserPaper.getSubmitTime();
                }
                if (!isNum) continue;
                ++finishNum;
                useRate = useRate.add(BigDecimal.ONE);
            }
        }
        if (finishNum > 0 && num == finishNum) {
            status = 2;
            endDate = lastDate;
        }
        map.put("status", status);
        map.put("startDate", startDate);
        map.put("endDate", endDate);
        map.put("lastDate", lastDate);
        map.put("studyTime", studyTime);
        BigDecimal studyRate = BigDecimal.ZERO;
        if (num > 0) {
            studyRate = useRate.multiply(new BigDecimal("100")).divide(new BigDecimal(num + ""), 0, 1);
        }
        map.put("studyRate", studyRate);
        return map;
    }

    @Override
    public TrainingConfig getTrainingConfig(Users user) {
        TrainingConfig trainingConfig = new TrainingConfig();
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(TrainingConfig::getEnterpriseId, (Object)user.getGroupId());
        List trainingConfigList = this.trainingConfigMapper.selectList((Wrapper)wrapper);
        if (CollectionUtils.isEmpty((Collection)trainingConfigList)) {
            trainingConfig.setEnterpriseId(user.getGroupId());
            trainingConfig.setOpenUnlearnData(Integer.valueOf(0));
            trainingConfig.setIsScreen(Integer.valueOf(0));
            this.trainingConfigMapper.insert(trainingConfig);
        } else {
            trainingConfig = (TrainingConfig)trainingConfigList.get(0);
        }
        return trainingConfig;
    }

    @Override
    public void updateTrainingConfig(Users user, TrainingConfig trainingConfig) {
        if (user.getGroupId() != null) {
            LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
            wrapper.eq(TrainingConfig::getEnterpriseId, (Object)user.getGroupId());
            List trainingConfigList = this.trainingConfigMapper.selectList((Wrapper)wrapper);
            if (CollectionUtils.isEmpty((Collection)trainingConfigList)) {
                TrainingConfig config = new TrainingConfig();
                config.setEnterpriseId(user.getGroupId());
                config.setOpenUnlearnData(Integer.valueOf(trainingConfig.getOpenUnlearnData() == null ? 0 : trainingConfig.getOpenUnlearnData()));
                config.setIsScreen(Integer.valueOf(trainingConfig.getIsScreen() == null ? 0 : trainingConfig.getIsScreen()));
                this.trainingConfigMapper.insert(config);
            } else {
                TrainingConfig config = (TrainingConfig)trainingConfigList.get(0);
                if (trainingConfig.getOpenUnlearnData() != null) {
                    config.setOpenUnlearnData(trainingConfig.getOpenUnlearnData());
                }
                if (trainingConfig.getIsScreen() != null) {
                    config.setIsScreen(trainingConfig.getIsScreen());
                }
                this.trainingConfigMapper.updateById(config);
            }
        }
    }

    @Override
    public TrainingUserViewTimeVo selectMaterialViewTime(Integer userId, Integer taskId, Integer learnType, Integer materialId, Integer turns) {
        TrainingUserViewTimeVo vo = null;
        List<Object> list = new ArrayList();
        switch (learnType) {
            case 0: {
                list = this.trainingUserViewTimeMaterialMapper.selectMaterialViewTime(userId, taskId, learnType, materialId, turns);
                break;
            }
            case 1: {
                list = this.trainingUserViewTimeTrainingMapper.selectMaterialViewTime(userId, taskId, learnType, materialId, turns);
                break;
            }
            case 2: {
                list = this.trainingUserViewTimeLearnMapper.selectMaterialViewTime(userId, taskId, learnType, materialId, turns);
                break;
            }
            case 3: {
                list = this.trainingUserViewTimeJobMapper.selectMaterialViewTime(userId, taskId, learnType, materialId, turns);
                break;
            }
            case 4: {
                list = this.trainingUserViewTimeCourseMapper.selectMaterialViewTime(userId, taskId, learnType, materialId, turns);
                break;
            }
            case 5: {
                list = this.trainingUserViewTimeCheckMapper.selectMaterialViewTime(userId, taskId, learnType, materialId, turns);
                break;
            }
        }
        if (!CollectionUtils.isEmpty(list)) {
            vo = (TrainingUserViewTimeVo)list.get(0);
        }
        return vo;
    }

    @Override
    public List<TrainingUserViewTimeVo> selectAllTimeByMaterial(Integer trainingId, Integer learnType, Integer taskId, Integer userId, Integer turns, List<Integer> materialIds) {
        List<Object> voList = new ArrayList();
        switch (learnType) {
            case 0: {
                voList = this.trainingUserViewTimeMaterialMapper.selectAllTimeByMaterial(trainingId, learnType, taskId, userId, turns, materialIds);
                break;
            }
            case 1: {
                voList = this.trainingUserViewTimeTrainingMapper.selectAllTimeByMaterial(trainingId, learnType, taskId, userId, turns, materialIds);
                break;
            }
            case 2: {
                voList = this.trainingUserViewTimeLearnMapper.selectAllTimeByMaterial(trainingId, learnType, taskId, userId, turns, materialIds);
                break;
            }
            case 3: {
                voList = this.trainingUserViewTimeJobMapper.selectAllTimeByMaterial(trainingId, learnType, taskId, userId, turns, materialIds);
                break;
            }
            case 4: {
                voList = this.trainingUserViewTimeCourseMapper.selectAllTimeByMaterial(trainingId, learnType, taskId, userId, turns, materialIds);
                break;
            }
            case 5: {
                voList = this.trainingUserViewTimeCheckMapper.selectAllTimeByMaterial(trainingId, learnType, taskId, userId, turns, materialIds);
                break;
            }
        }
        ArrayList<TrainingUserViewTimeVo> result = new ArrayList<TrainingUserViewTimeVo>();
        Map<Integer, List<TrainingUserViewTimeVo>> map = voList.stream().collect(Collectors.groupingBy(TrainingUserViewTime::getMaterialId));
        for (Map.Entry<Integer, List<TrainingUserViewTimeVo>> entry : map.entrySet()) {
            List<TrainingUserViewTimeVo> viewTimeVos = entry.getValue();
            TrainingUserViewTimeVo vo = viewTimeVos.get(0);
            vo.setViewTimes(Integer.valueOf(viewTimeVos.stream().mapToInt(TrainingUserViewTimeVo::getViewTimes).sum()));
            result.add(vo);
        }
        return result;
    }

    @Override
    public List<TrainingUserViewTimeVo> selectViewTimeByUserId(@Param(value="learnType") Integer learnType, @Param(value="userIdList") List<Integer> userIdList, @Param(value="materialIdList") List<Integer> materialIdList, @Param(value="trainingIdList") List<Integer> trainingIdList, @Param(value="taskId") Integer taskId) {
        List<TrainingUserViewTimeVo> voList = new ArrayList<TrainingUserViewTimeVo>();
        switch (learnType) {
            case 0: {
                voList = this.trainingUserViewTimeMaterialMapper.selectViewTimeByUserId(learnType, userIdList, materialIdList, trainingIdList, taskId);
                break;
            }
            case 1: {
                voList = this.trainingUserViewTimeTrainingMapper.selectViewTimeByUserId(learnType, userIdList, materialIdList, trainingIdList, taskId);
                break;
            }
            case 2: {
                voList = this.trainingUserViewTimeLearnMapper.selectViewTimeByUserId(learnType, userIdList, materialIdList, trainingIdList, taskId);
                break;
            }
            case 3: {
                voList = this.trainingUserViewTimeJobMapper.selectViewTimeByUserId(learnType, userIdList, materialIdList, trainingIdList, taskId);
                break;
            }
            case 4: {
                voList = this.trainingUserViewTimeCourseMapper.selectViewTimeByUserId(learnType, userIdList, materialIdList, trainingIdList, taskId);
                break;
            }
            case 5: {
                voList = this.trainingUserViewTimeCheckMapper.selectViewTimeByUserId(learnType, userIdList, materialIdList, trainingIdList, taskId);
                break;
            }
        }
        return voList;
    }

    @Override
    public List<TrainingUserViewTimeVo> selectViewTimeByUserMaterial(Integer userId, Integer turns, Integer trainingId, Integer learnType, Integer taskId) {
        List<TrainingUserViewTimeVo> voList = new ArrayList<TrainingUserViewTimeVo>();
        switch (learnType) {
            case 0: {
                voList = this.trainingUserViewTimeMaterialMapper.selectViewTimeByUserMaterial(userId, turns, trainingId, learnType, taskId);
                break;
            }
            case 1: {
                voList = this.trainingUserViewTimeTrainingMapper.selectViewTimeByUserMaterial(userId, turns, trainingId, learnType, taskId);
                break;
            }
            case 2: {
                voList = this.trainingUserViewTimeLearnMapper.selectViewTimeByUserMaterial(userId, turns, trainingId, learnType, taskId);
                break;
            }
            case 3: {
                voList = this.trainingUserViewTimeJobMapper.selectViewTimeByUserMaterial(userId, turns, trainingId, learnType, taskId);
                break;
            }
            case 4: {
                voList = this.trainingUserViewTimeCourseMapper.selectViewTimeByUserMaterial(userId, turns, trainingId, learnType, taskId);
                break;
            }
            case 5: {
                voList = this.trainingUserViewTimeCheckMapper.selectViewTimeByUserMaterial(userId, turns, trainingId, learnType, taskId);
                break;
            }
        }
        return voList;
    }

    @Override
    public List<? extends TrainingUserViewTime> selectTrainingUserViewTimeList(Users user, TrainingsVo trainingVo) {
        List trainingUserViewTimeList = new ArrayList();
        switch (trainingVo.getLearnType()) {
            case 1: {
                LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.eq(TrainingUserViewTime::getEnterpriseId, (Object)user.getGroupId())).eq(TrainingUserViewTime::getUserId, (Object)user.getId())).eq(TrainingUserViewTime::getTrainingId, (Object)trainingVo.getId())).eq(TrainingUserViewTime::getLearnType, (Object)trainingVo.getLearnType())).eq(trainingVo.getTaskId() != null, TrainingUserViewTime::getTaskId, (Object)trainingVo.getTaskId());
                trainingUserViewTimeList = this.trainingUserViewTimeTrainingMapper.selectList((Wrapper)queryWrapper);
                break;
            }
            case 2: {
                LambdaQueryWrapper queryWrapper1 = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper1.eq(TrainingUserViewTime::getEnterpriseId, (Object)user.getGroupId())).eq(TrainingUserViewTime::getUserId, (Object)user.getId())).eq(TrainingUserViewTime::getTrainingId, (Object)trainingVo.getId())).eq(TrainingUserViewTime::getLearnType, (Object)trainingVo.getLearnType())).eq(trainingVo.getTaskId() != null, TrainingUserViewTime::getTaskId, (Object)trainingVo.getTaskId());
                trainingUserViewTimeList = this.trainingUserViewTimeLearnMapper.selectList((Wrapper)queryWrapper1);
                break;
            }
            case 3: {
                LambdaQueryWrapper queryWrapper2 = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper2.eq(TrainingUserViewTime::getEnterpriseId, (Object)user.getGroupId())).eq(TrainingUserViewTime::getUserId, (Object)user.getId())).eq(TrainingUserViewTime::getTrainingId, (Object)trainingVo.getId())).eq(TrainingUserViewTime::getLearnType, (Object)trainingVo.getLearnType())).eq(trainingVo.getTaskId() != null, TrainingUserViewTime::getTaskId, (Object)trainingVo.getTaskId());
                trainingUserViewTimeList = this.trainingUserViewTimeJobMapper.selectList((Wrapper)queryWrapper2);
                break;
            }
            case 4: {
                LambdaQueryWrapper queryWrapper3 = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper3.eq(TrainingUserViewTime::getEnterpriseId, (Object)user.getGroupId())).eq(TrainingUserViewTime::getUserId, (Object)user.getId())).eq(TrainingUserViewTime::getTrainingId, (Object)trainingVo.getId())).eq(TrainingUserViewTime::getLearnType, (Object)trainingVo.getLearnType())).eq(trainingVo.getTaskId() != null, TrainingUserViewTime::getTaskId, (Object)trainingVo.getTaskId())).eq(trainingVo.getTurns() != null, TrainingUserViewTime::getTurns, (Object)trainingVo.getTurns());
                trainingUserViewTimeList = this.trainingUserViewTimeCourseMapper.selectList((Wrapper)queryWrapper3);
                break;
            }
            case 5: {
                LambdaQueryWrapper queryWrapper4 = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper4.eq(TrainingUserViewTime::getEnterpriseId, (Object)user.getGroupId())).eq(TrainingUserViewTime::getUserId, (Object)user.getId())).eq(TrainingUserViewTime::getTrainingId, (Object)trainingVo.getId())).eq(TrainingUserViewTime::getLearnType, (Object)trainingVo.getLearnType())).eq(trainingVo.getTaskId() != null, TrainingUserViewTime::getTaskId, (Object)trainingVo.getTaskId());
                trainingUserViewTimeList = this.trainingUserViewTimeCheckMapper.selectList((Wrapper)queryWrapper4);
                break;
            }
        }
        return trainingUserViewTimeList;
    }

    @Override
    public List<TrainingUserViewTimeVo> selectViewTimeByMaterial(Integer learnType, Integer userId, List<Integer> materialIdList, List<Integer> trainingIdList, Integer taskId, Integer turns) {
        List<TrainingUserViewTimeVo> voList = new ArrayList<TrainingUserViewTimeVo>();
        switch (learnType) {
            case 0: {
                voList = this.trainingUserViewTimeMaterialMapper.selectViewTimeByMaterial(learnType, userId, materialIdList, trainingIdList, taskId, turns);
                break;
            }
            case 1: {
                voList = this.trainingUserViewTimeTrainingMapper.selectViewTimeByMaterial(learnType, userId, materialIdList, trainingIdList, taskId, turns);
                break;
            }
            case 2: {
                voList = this.trainingUserViewTimeLearnMapper.selectViewTimeByMaterial(learnType, userId, materialIdList, trainingIdList, taskId, turns);
                break;
            }
            case 3: {
                voList = this.trainingUserViewTimeJobMapper.selectViewTimeByMaterial(learnType, userId, materialIdList, trainingIdList, taskId, turns);
                break;
            }
            case 4: {
                voList = this.trainingUserViewTimeCourseMapper.selectViewTimeByMaterial(learnType, userId, materialIdList, trainingIdList, taskId, turns);
                break;
            }
            case 5: {
                voList = this.trainingUserViewTimeCheckMapper.selectViewTimeByMaterial(learnType, userId, materialIdList, trainingIdList, taskId, turns);
                break;
            }
        }
        return voList;
    }

    @Override
    public List<? extends TrainingUserViewTime> selectLastTime(TrainingUserViewTimeVo viewTime, Users user) {
        List trainingUserViewTimeList = new ArrayList();
        switch (viewTime.getLearnType()) {
            case 0: {
                LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.eq(TrainingUserViewTime::getUserId, (Object)user.getId())).eq(!StringUtils.isEmpty((Object)viewTime.getMaterialId()), TrainingUserViewTime::getMaterialId, (Object)viewTime.getMaterialId())).eq(TrainingUserViewTime::getLearnType, (Object)viewTime.getLearnType())).eq(TrainingUserViewTime::getTurns, (Object)(viewTime.getTurns() == null ? 1 : viewTime.getTurns()));
                queryWrapper.orderByDesc(TrainingUserViewTimeMaterial::getUpdateTime);
                trainingUserViewTimeList = this.trainingUserViewTimeMaterialMapper.selectList((Wrapper)queryWrapper);
                break;
            }
            case 1: {
                LambdaQueryWrapper queryWrapper1 = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper1.eq(TrainingUserViewTime::getUserId, (Object)user.getId())).eq(!StringUtils.isEmpty((Object)viewTime.getMaterialId()), TrainingUserViewTime::getMaterialId, (Object)viewTime.getMaterialId())).eq(TrainingUserViewTime::getLearnType, (Object)viewTime.getLearnType())).eq(!StringUtils.isEmpty((Object)viewTime.getTrainingId()), TrainingUserViewTime::getTrainingId, (Object)viewTime.getTrainingId())).eq(!StringUtils.isEmpty((Object)viewTime.getAttachId()), TrainingUserViewTime::getAttachId, (Object)viewTime.getAttachId())).eq(!StringUtils.isEmpty((Object)viewTime.getTaskId()), TrainingUserViewTime::getTaskId, (Object)viewTime.getTaskId());
                queryWrapper1.orderByDesc(TrainingUserViewTimeTraining::getUpdateTime);
                trainingUserViewTimeList = this.trainingUserViewTimeTrainingMapper.selectList((Wrapper)queryWrapper1);
                break;
            }
            case 2: {
                LambdaQueryWrapper queryWrapper2 = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper2.eq(TrainingUserViewTime::getUserId, (Object)user.getId())).eq(!StringUtils.isEmpty((Object)viewTime.getMaterialId()), TrainingUserViewTime::getMaterialId, (Object)viewTime.getMaterialId())).eq(TrainingUserViewTime::getLearnType, (Object)viewTime.getLearnType())).eq(!StringUtils.isEmpty((Object)viewTime.getTaskId()), TrainingUserViewTime::getTaskId, (Object)viewTime.getTaskId());
                queryWrapper2.orderByDesc(TrainingUserViewTimeLearn::getUpdateTime);
                trainingUserViewTimeList = this.trainingUserViewTimeLearnMapper.selectList((Wrapper)queryWrapper2);
                break;
            }
            case 3: {
                LambdaQueryWrapper queryWrapper3 = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper3.eq(TrainingUserViewTime::getUserId, (Object)user.getId())).eq(!StringUtils.isEmpty((Object)viewTime.getMaterialId()), TrainingUserViewTime::getMaterialId, (Object)viewTime.getMaterialId())).eq(TrainingUserViewTime::getLearnType, (Object)viewTime.getLearnType())).eq(!StringUtils.isEmpty((Object)viewTime.getTaskId()), TrainingUserViewTime::getTaskId, (Object)viewTime.getTaskId());
                queryWrapper3.orderByDesc(TrainingUserViewTimeJob::getUpdateTime);
                trainingUserViewTimeList = this.trainingUserViewTimeJobMapper.selectList((Wrapper)queryWrapper3);
                break;
            }
            case 4: {
                LambdaQueryWrapper queryWrapper4 = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper4.eq(TrainingUserViewTime::getUserId, (Object)user.getId())).eq(!StringUtils.isEmpty((Object)viewTime.getMaterialId()), TrainingUserViewTime::getMaterialId, (Object)viewTime.getMaterialId())).eq(TrainingUserViewTime::getLearnType, (Object)viewTime.getLearnType())).eq(TrainingUserViewTime::getTurns, (Object)(viewTime.getTurns() == null ? 1 : viewTime.getTurns()))).eq(!StringUtils.isEmpty((Object)viewTime.getTaskId()), TrainingUserViewTime::getTaskId, (Object)viewTime.getTaskId());
                queryWrapper4.orderByDesc(TrainingUserViewTimeCourse::getUpdateTime);
                trainingUserViewTimeList = this.trainingUserViewTimeCourseMapper.selectList((Wrapper)queryWrapper4);
                break;
            }
            case 5: {
                LambdaQueryWrapper queryWrapper5 = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper5.eq(TrainingUserViewTime::getUserId, (Object)user.getId())).eq(!StringUtils.isEmpty((Object)viewTime.getMaterialId()), TrainingUserViewTime::getMaterialId, (Object)viewTime.getMaterialId())).eq(TrainingUserViewTime::getLearnType, (Object)viewTime.getLearnType())).eq(!StringUtils.isEmpty((Object)viewTime.getTrainingId()), TrainingUserViewTime::getTrainingId, (Object)viewTime.getTrainingId())).eq(!StringUtils.isEmpty((Object)viewTime.getAttachId()), TrainingUserViewTime::getAttachId, (Object)viewTime.getAttachId())).eq(!StringUtils.isEmpty((Object)viewTime.getTaskId()), TrainingUserViewTime::getTaskId, (Object)viewTime.getTaskId());
                queryWrapper5.orderByDesc(TrainingUserViewTimeCheck::getUpdateTime);
                trainingUserViewTimeList = this.trainingUserViewTimeCheckMapper.selectList((Wrapper)queryWrapper5);
                break;
            }
        }
        return trainingUserViewTimeList;
    }

    @Override
    public List<Integer> selectChildIdList(Integer materialTypeId) {
        ArrayList<Integer> idList = new ArrayList<Integer>();
        idList.add(materialTypeId);
        Map<Integer, List<TrainingMaterialType>> map = new HashMap<Integer, List<TrainingMaterialType>>();
        TrainingMaterialType trainingMaterialType = (TrainingMaterialType)this.trainingMaterialTypeMapper.selectById(materialTypeId);
        if (!ObjectUtils.isEmpty((Object)trainingMaterialType)) {
            Integer orginId = trainingMaterialType.getOriginId() == null ? materialTypeId : trainingMaterialType.getOriginId();
            LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
            if (trainingMaterialType.getEnterpriseId() != null) {
                wrapper1.eq(TrainingMaterialType::getEnterpriseId, (Object)trainingMaterialType.getEnterpriseId());
            } else {
                wrapper1.isNull(TrainingMaterialType::getEnterpriseId);
            }
            ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper1.eq(TrainingMaterialType::getModuleType, (Object)trainingMaterialType.getModuleType())).eq(TrainingMaterialType::getOriginId, (Object)orginId)).isNotNull(TrainingMaterialType::getSourceId)).orderByAsc(TrainingMaterialType::getSort)).orderByAsc(TrainingMaterialType::getId);
            List trainingMaterialTypeList = this.trainingMaterialTypeMapper.selectList((Wrapper)wrapper1);
            if (!CollectionUtils.isEmpty((Collection)trainingMaterialTypeList)) {
                map = trainingMaterialTypeList.stream().collect(Collectors.groupingBy(TrainingMaterialType::getSourceId));
            }
        }
        return this.fillChildTypeId(idList, map, materialTypeId);
    }

    private List<Integer> fillChildTypeId(List<Integer> typeIds, Map<Integer, List<TrainingMaterialType>> trainingMaterialTypeMap, Integer typeId) {
        List<TrainingMaterialType> list = trainingMaterialTypeMap.get(typeId);
        if (CollectionUtils.isEmpty(list)) {
            return typeIds;
        }
        for (TrainingMaterialType trainingMaterialType : list) {
            typeIds.add(trainingMaterialType.getId());
            this.fillChildTypeId(typeIds, trainingMaterialTypeMap, trainingMaterialType.getId());
        }
        return typeIds;
    }

    @Override
    public Map<String, Object> selectTrainingRate(Integer trainingId, Integer userId, Map<Integer, List<TrainingUserViewTimeVo>> materialViewMap, Map<Integer, List<TrainingChapterAttach>> trainingChapterAttachMap, Map<Integer, TrainingMaterial> materialMap, Map<Integer, List<TrainingUserPaper>> userPaperMap) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        int num = 0;
        BigDecimal useRate = BigDecimal.ZERO;
        List<TrainingChapterAttach> trainingChapterAttachList = trainingChapterAttachMap.get(trainingId);
        if (!CollectionUtils.isEmpty(trainingChapterAttachList)) {
            for (TrainingChapterAttach trainingChapterAttach : trainingChapterAttachList) {
                List<TrainingUserPaper> trainingUserPaperList;
                ++num;
                if (trainingChapterAttach.getMaterialId() != null) {
                    TrainingMaterial material = materialMap.get(trainingChapterAttach.getMaterialId());
                    if (ObjectUtils.isEmpty((Object)material)) continue;
                    BigDecimal finishTime = new BigDecimal("30");
                    finishTime = !StringUtils.isEmpty((Object)material.getIsVideo()) && material.getIsVideo() == 1 ? new BigDecimal(material.getDuration()).multiply(material.getFinishRate()).divide(new BigDecimal("100"), 0, 1) : new BigDecimal(material.getFinishTime());
                    List<TrainingUserViewTimeVo> userMaterialViewTimeVos = materialViewMap.get(material.getId());
                    if (CollectionUtils.isEmpty(userMaterialViewTimeVos)) continue;
                    for (TrainingUserViewTimeVo userViewTimeVo : userMaterialViewTimeVos) {
                        if (userViewTimeVo.getUserId().compareTo(userId) != 0 || userViewTimeVo.getViewTime() < 0) continue;
                        if (finishTime.compareTo(new BigDecimal(userViewTimeVo.getViewTime())) <= 0) {
                            useRate = useRate.add(BigDecimal.ONE);
                            continue;
                        }
                        if (finishTime.compareTo(BigDecimal.ZERO) <= 0) {
                            useRate = useRate.add(BigDecimal.ONE);
                            continue;
                        }
                        useRate = useRate.add(new BigDecimal(userViewTimeVo.getViewTime().toString()).divide(finishTime, 2, 1));
                    }
                    continue;
                }
                if (trainingChapterAttach.getPaperId() == null || CollectionUtils.isEmpty(trainingUserPaperList = userPaperMap.get(trainingChapterAttach.getPaperId()))) continue;
                boolean isNum = false;
                for (TrainingUserPaper trainingUserPaper : trainingUserPaperList) {
                    if (trainingUserPaper.getUserId() == null || trainingUserPaper.getUserId().compareTo(userId) != 0) continue;
                    isNum = true;
                }
                if (!isNum) continue;
                useRate = useRate.add(BigDecimal.ONE);
            }
        }
        BigDecimal studyRate = BigDecimal.ZERO;
        if (num > 0) {
            studyRate = useRate.multiply(new BigDecimal("100")).divide(new BigDecimal(num + ""), 0, 1);
        }
        map.put("studyRate", studyRate);
        return map;
    }

    @Override
    public Map<Integer, BigDecimal> getMaterialsRate(List<Integer> trainingMaterialIdList, Users user) {
        List trainingMaterialList = this.trainingMaterialMapper.selectBatchIds(trainingMaterialIdList);
        HashMap<Integer, BigDecimal> materialRateMap = new HashMap<Integer, BigDecimal>();
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)wrapper.eq(TrainingUserViewTime::getUserId, (Object)user.getId())).in(TrainingUserViewTime::getMaterialId, trainingMaterialIdList);
        List trainingUserViewTimeMaterialList = this.trainingUserViewTimeMaterialMapper.selectList((Wrapper)wrapper);
        Map<Object, Object> timeMap = new HashMap();
        if (!CollectionUtils.isEmpty((Collection)trainingUserViewTimeMaterialList)) {
            timeMap = trainingUserViewTimeMaterialList.stream().collect(Collectors.groupingBy(TrainingUserViewTime::getMaterialId));
        }
        for (TrainingMaterial trainingMaterial : trainingMaterialList) {
            BigDecimal finishTime = new BigDecimal("30");
            finishTime = !StringUtils.isEmpty((Object)trainingMaterial.getIsVideo()) && trainingMaterial.getIsVideo() == 1 ? new BigDecimal(trainingMaterial.getDuration()).multiply(trainingMaterial.getFinishRate()).divide(new BigDecimal("100"), 0, 1) : new BigDecimal(trainingMaterial.getFinishTime());
            BigDecimal useRate = BigDecimal.ZERO;
            List timeList = (List)timeMap.get(trainingMaterial.getId());
            if (!CollectionUtils.isEmpty((Collection)timeList)) {
                TrainingUserViewTimeMaterial trainingUserViewTimeMaterial = (TrainingUserViewTimeMaterial)timeList.get(0);
                useRate = finishTime.compareTo(new BigDecimal(trainingUserViewTimeMaterial.getViewTime())) <= 0 ? BigDecimal.ONE : (finishTime.compareTo(BigDecimal.ZERO) <= 0 ? BigDecimal.ONE : new BigDecimal(trainingUserViewTimeMaterial.getViewTime().toString()).divide(finishTime, 2, 1));
            }
            materialRateMap.put(trainingMaterial.getId(), useRate);
        }
        return materialRateMap;
    }

    @Override
    public Map<Integer, Integer> getMaterialStudyCount(List<Integer> trainingMaterialIdList, Users user) {
        HashMap<Integer, Integer> studyCountMap = new HashMap<Integer, Integer>();
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)wrapper.eq(user.getGroupId() != null, TrainingUserViewTime::getEnterpriseId, (Object)user.getGroupId())).in(TrainingUserViewTime::getMaterialId, trainingMaterialIdList);
        List trainingUserViewTimeMaterialList = this.trainingUserViewTimeMaterialMapper.selectList((Wrapper)wrapper);
        Map<Object, Object> timeMap = new HashMap();
        if (!CollectionUtils.isEmpty((Collection)trainingUserViewTimeMaterialList)) {
            timeMap = trainingUserViewTimeMaterialList.stream().collect(Collectors.groupingBy(TrainingUserViewTime::getMaterialId));
        }
        for (Integer materialId : trainingMaterialIdList) {
            List trainingUserViewTimeMaterials = (List)timeMap.get(materialId);
            Integer count = 0;
            if (!CollectionUtils.isEmpty((Collection)trainingUserViewTimeMaterials)) {
                List userIds = trainingUserViewTimeMaterials.stream().map(TrainingUserViewTime::getUserId).distinct().collect(Collectors.toList());
                count = userIds.size();
            }
            studyCountMap.put(materialId, count);
        }
        return studyCountMap;
    }
}

