/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.training.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ovopark.organize.common.base.BaseResult;
import com.ovopark.organize.common.model.pojo.DepartmentPojo;
import com.ovopark.organize.common.model.pojo.OrganizePojo;
import com.ovopark.organize.common.model.pojo.UsersPojo;
import com.ovopark.organize.sdk.api.DepartmentApi;
import com.ovopark.organize.sdk.api.OrganizeApi;
import com.ovopark.training.mapper.TrainingCourseConfigMapper;
import com.ovopark.training.mapper.TrainingCourseStageTaskMapper;
import com.ovopark.training.mapper.TrainingCourseUserTaskMapper;
import com.ovopark.training.mapper.TrainingExaminerMapper;
import com.ovopark.training.mapper.TrainingMapper;
import com.ovopark.training.mapper.TrainingPaperMapper;
import com.ovopark.training.mapper.TrainingPaperUserMapper;
import com.ovopark.training.mapper.TrainingReviewAssignerMapper;
import com.ovopark.training.mapper.TrainingReviewConfigMapper;
import com.ovopark.training.model.Authenticator;
import com.ovopark.training.model.CourseConfig;
import com.ovopark.training.model.ReviewHead;
import com.ovopark.training.model.Training;
import com.ovopark.training.model.TrainingCourseConfig;
import com.ovopark.training.model.TrainingCourseStageTask;
import com.ovopark.training.model.TrainingCourseUserTask;
import com.ovopark.training.model.TrainingExaminer;
import com.ovopark.training.model.TrainingPaper;
import com.ovopark.training.model.TrainingPaperUser;
import com.ovopark.training.model.TrainingReviewAssigner;
import com.ovopark.training.model.TrainingReviewHeadConfig;
import com.ovopark.training.model.Users;
import com.ovopark.training.service.TrainingCourseConfigService;
import com.ovopark.training.service.TrainingLearnProjectService;
import com.ovopark.training.service.UserUtilService;
import com.ovopark.training.vo.TrainingCourseConfigVo;
import com.ovopark.training.vo.TrainingCourseStageTaskVo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
public class TrainingCourseConfigServiceImpl
implements TrainingCourseConfigService {
    private static final Logger log = LoggerFactory.getLogger(TrainingCourseConfigServiceImpl.class);
    @Autowired
    private TrainingCourseConfigMapper trainingCourseConfigMapper;
    @Autowired
    private UserUtilService userUtilService;
    @Autowired
    private OrganizeApi organizeApi;
    @Autowired
    private DepartmentApi departmentApi;
    @Autowired
    private TrainingCourseStageTaskMapper courseStageTaskMapper;
    @Autowired
    private TrainingMapper trainingMapper;
    @Autowired
    private TrainingLearnProjectService learnProjectService;
    @Autowired
    private TrainingPaperMapper trainingPaperMapper;
    @Autowired
    private TrainingReviewConfigMapper trainingReviewConfigMapper;
    @Autowired
    private TrainingReviewAssignerMapper trainingReviewAssignerMapper;
    @Autowired
    private TrainingExaminerMapper trainingExaminerMapper;
    @Autowired
    private TrainingPaperUserMapper trainingPaperUserMapper;
    @Autowired
    private TrainingCourseUserTaskMapper courseUserTaskMapper;

    @Override
    public void saveConfig(List<TrainingCourseConfigVo> configVoList) {
        Users user = Authenticator.getInstance().getCurrentUser();
        for (TrainingCourseConfigVo configVo : configVoList) {
            TrainingCourseConfig config;
            if (Objects.nonNull(configVo.getId())) {
                config = new TrainingCourseConfig();
                config.setId(configVo.getId());
                config.setEnterpriseId(user.getGroupId().intValue());
                config.setCourseDirectorId(configVo.getCourseDirector());
                config.setCourseAreaId(configVo.getCourseArea());
                config.setUpdateTime(new Date());
                this.trainingCourseConfigMapper.updateById(config);
                continue;
            }
            config = new TrainingCourseConfig();
            config.setEnterpriseId(user.getGroupId().intValue());
            config.setCourseDirectorId(configVo.getCourseDirector());
            config.setCourseAreaId(configVo.getCourseArea());
            config.setCreateTime(new Date());
            config.setUpdateTime(new Date());
            this.trainingCourseConfigMapper.insert(config);
        }
    }

    @Override
    public void deleteConfig(String id) {
        String[] ids;
        for (String index : ids = id.split(",")) {
            if (StringUtils.isEmpty((Object)index)) continue;
            this.trainingCourseConfigMapper.deleteById(Integer.valueOf(Integer.parseInt(index)));
        }
    }

    @Override
    public void updateConfig(TrainingCourseConfig config) {
        config.setUpdateTime(new Date());
        this.trainingCourseConfigMapper.updateById(config);
    }

    @Override
    public List<TrainingCourseConfig> selectCourseDirectorConfig(Users users) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(TrainingCourseConfig::getEnterpriseId, (Object)users.getGroupId());
        List configList = this.trainingCourseConfigMapper.selectList((Wrapper)queryWrapper);
        for (TrainingCourseConfig config : configList) {
            Map<Integer, UsersPojo> userMap;
            if (!StringUtils.isEmpty((Object)config.getCourseDirectorId()) && !CollectionUtils.isEmpty(userMap = this.userUtilService.selectUserMap(Arrays.stream(config.getCourseDirectorId().split(",")).map(Integer::parseInt).collect(Collectors.toList())))) {
                ArrayList<ReviewHead> reviewHeads = new ArrayList<ReviewHead>();
                List userIds = Arrays.stream(config.getCourseDirectorId().split(",")).map(Integer::parseInt).collect(Collectors.toList());
                for (Integer userId : userIds) {
                    ReviewHead reviewHead = new ReviewHead();
                    reviewHead.setUserId(userId.intValue());
                    reviewHead.setUserName(userMap.get(userId).getShowName());
                    reviewHeads.add(reviewHead);
                }
                config.setUserNameList(reviewHeads);
            }
            if (StringUtils.isEmpty((Object)config.getCourseAreaId())) continue;
            String[] organizeIds = config.getCourseAreaId().split(",");
            ArrayList<CourseConfig> courseConfigList = new ArrayList<CourseConfig>();
            for (String organizeId : organizeIds) {
                BaseResult baseResult;
                CourseConfig courseConfig = new CourseConfig();
                if (organizeId.startsWith("O")) {
                    baseResult = this.organizeApi.getOrganizeById(Integer.valueOf(organizeId.replace("O_", "")));
                    if (!baseResult.getIsError().booleanValue()) {
                        courseConfig.setOrganizeId(organizeId);
                        courseConfig.setAreaName(((OrganizePojo)baseResult.getData()).getName());
                    }
                } else {
                    baseResult = this.departmentApi.getDepartmentById(Integer.valueOf(Integer.parseInt(organizeId.replace("S_", ""))));
                    if (!baseResult.getIsError().booleanValue()) {
                        courseConfig.setOrganizeId(organizeId);
                        courseConfig.setAreaName(((DepartmentPojo)baseResult.getData()).getName());
                    }
                }
                courseConfigList.add(courseConfig);
            }
            config.setAreaNameList(courseConfigList);
        }
        return configList;
    }

    @Override
    public int selectCourseDirectorCount(Users users) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(TrainingCourseConfig::getEnterpriseId, (Object)users.getGroupId());
        int count = 0;
        List configList = this.trainingCourseConfigMapper.selectList((Wrapper)queryWrapper);
        for (TrainingCourseConfig config : configList) {
            count += (int)Arrays.stream(config.getCourseDirectorId().split(",")).count();
        }
        return count;
    }

    @Override
    public Integer updateIsBindingTraining(TrainingCourseStageTaskVo courseStageTaskVo, Users user) {
        Date now = new Date();
        TrainingCourseStageTask courseStageTask = (TrainingCourseStageTask)this.courseStageTaskMapper.selectById(courseStageTaskVo.getId());
        Integer id = null;
        if (!StringUtils.isEmpty((Object)courseStageTask) && courseStageTask.getIsBinding() == 1) {
            if (courseStageTask.getTaskType() == 1) {
                Integer trainingOld = courseStageTask.getTrainingId();
                Training training = (Training)this.trainingMapper.selectById(courseStageTask.getTrainingId());
                if (!ObjectUtils.isEmpty((Object)training) && training.getSourceType() == 2) {
                    return -1;
                }
                courseStageTask.setTrainingIdOld(trainingOld);
                training.setId(null);
                training.setProjectShow(Integer.valueOf(4));
                training.setCreator(user.getId());
                training.setEnterpriseId(courseStageTask.getEnterpriseId());
                training.setStartTime(now);
                training.setUpdateTime(now);
                this.trainingMapper.insert(training);
                courseStageTask.setTrainingId(training.getId());
                id = training.getId();
                Integer trainingNew = courseStageTask.getTrainingId();
                this.learnProjectService.saveNewTrainingByOld(trainingNew, trainingOld);
            } else if (courseStageTask.getTaskType() == 2) {
                TrainingPaper paper = (TrainingPaper)this.trainingPaperMapper.selectById(courseStageTask.getPaperId());
                Integer oldPaperId = paper.getId();
                courseStageTask.setPaperIdOld(oldPaperId);
                TrainingReviewHeadConfig trainingReviewHeadConfig = new TrainingReviewHeadConfig();
                Integer reviewer = 1;
                LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)wrapper1.eq(TrainingReviewHeadConfig::getEnterpriseId, (Object)courseStageTask.getEnterpriseId())).orderByDesc(TrainingReviewHeadConfig::getId);
                List trainingReviewHeadConfigList = this.trainingReviewConfigMapper.selectList((Wrapper)wrapper1);
                if (!CollectionUtils.isEmpty((Collection)trainingReviewHeadConfigList)) {
                    trainingReviewHeadConfig = (TrainingReviewHeadConfig)trainingReviewHeadConfigList.get(0);
                    reviewer = trainingReviewHeadConfig.getReviewUser();
                }
                paper.setId(null);
                paper.setPaperState(Integer.valueOf(1));
                paper.setProjectShow(Integer.valueOf(4));
                paper.setCreater(user.getId());
                paper.setCreateTime(now);
                paper.setEnterpriseId(courseStageTask.getEnterpriseId());
                paper.setReviewerType(reviewer);
                this.trainingPaperMapper.insert(paper);
                if (reviewer == 4) {
                    LambdaQueryWrapper wrapper2 = new LambdaQueryWrapper();
                    ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper2.eq(TrainingReviewAssigner::getEnterpriseId, (Object)courseStageTask.getEnterpriseId())).eq(trainingReviewHeadConfig.getId() != null, TrainingReviewAssigner::getConfigId, (Object)trainingReviewHeadConfig.getId())).isNotNull(TrainingReviewAssigner::getAssigner);
                    List trainingReviewAssignerList = this.trainingReviewAssignerMapper.selectList((Wrapper)wrapper2);
                    if (!CollectionUtils.isEmpty((Collection)trainingReviewAssignerList)) {
                        ArrayList<TrainingExaminer> examList = new ArrayList<TrainingExaminer>();
                        for (TrainingReviewAssigner trainingReviewAssigner : trainingReviewAssignerList) {
                            TrainingExaminer exam = new TrainingExaminer();
                            exam.setTrainingPaperId(paper.getId());
                            exam.setUserId(Integer.valueOf(trainingReviewAssigner.getAssigner()));
                            exam.setEnterpriseId(paper.getEnterpriseId());
                            examList.add(exam);
                        }
                        this.trainingExaminerMapper.insertList(examList);
                    }
                }
                LambdaQueryWrapper paperUserWrapper = new LambdaQueryWrapper();
                paperUserWrapper.eq(TrainingPaperUser::getPaperId, (Object)oldPaperId);
                List paperUserList = this.trainingPaperUserMapper.selectList((Wrapper)paperUserWrapper);
                if (!CollectionUtils.isEmpty((Collection)paperUserList)) {
                    ArrayList<TrainingPaperUser> paperUsers = new ArrayList<TrainingPaperUser>();
                    for (TrainingPaperUser paperUser : paperUserList) {
                        paperUser.setId(null);
                        paperUser.setEnterpriseId(user.getGroupId());
                        paperUser.setPaperId(paper.getId());
                        paperUsers.add(paperUser);
                    }
                    this.trainingPaperUserMapper.insertList(paperUsers);
                }
                courseStageTask.setPaperId(paper.getId());
                id = paper.getId();
            }
            courseStageTask.setIsBinding(Integer.valueOf(0));
            this.courseStageTaskMapper.updateById(courseStageTask);
            LambdaUpdateWrapper delWrapper = new LambdaUpdateWrapper();
            delWrapper.eq(TrainingCourseUserTask::getTaskId, (Object)courseStageTask.getId());
            this.courseUserTaskMapper.delete((Wrapper)delWrapper);
        }
        return id;
    }
}

