/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.training.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ovopark.organize.common.model.mo.UserAndParentNameMo;
import com.ovopark.organize.common.model.mo.UserDutiesMo;
import com.ovopark.organize.common.model.mo.UsersAndOrgsMo;
import com.ovopark.organize.common.model.pojo.DepAndTagsPojo;
import com.ovopark.organize.common.model.pojo.SimplePojo;
import com.ovopark.organize.sdk.api.TagApi;
import com.ovopark.organize.sdk.api.UserApi;
import com.ovopark.organize.sdk.api.UserOrganizeApi;
import com.ovopark.privilege.api.RoleApi;
import com.ovopark.privilege.pojo.RolePojo;
import com.ovopark.privilege.pojo.UsersPojo;
import com.ovopark.privilege.response.BaseResult;
import com.ovopark.training.bo.Page;
import com.ovopark.training.mapper.TrainingCourseMapper;
import com.ovopark.training.mapper.TrainingCourseStageTaskMapper;
import com.ovopark.training.mapper.TrainingCourseUserMapper;
import com.ovopark.training.mapper.TrainingCourseUserTaskMapper;
import com.ovopark.training.mapper.TrainingExamMapper;
import com.ovopark.training.mapper.TrainingMaterialMapper;
import com.ovopark.training.mapper.TrainingPaperMapper;
import com.ovopark.training.mapper.TrainingPaperTurnsMapper;
import com.ovopark.training.mapper.TrainingPaperUserTurnsMapper;
import com.ovopark.training.mapper.TrainingUserPaperMapper;
import com.ovopark.training.mapper.TrainingUserViewTimeMapper;
import com.ovopark.training.mapper.TrainingWorkUserAnswerMapper;
import com.ovopark.training.model.TrainingCourse;
import com.ovopark.training.model.TrainingCourseStageTask;
import com.ovopark.training.model.TrainingCourseUser;
import com.ovopark.training.model.TrainingCourseUserTask;
import com.ovopark.training.model.TrainingExam;
import com.ovopark.training.model.TrainingMaterial;
import com.ovopark.training.model.TrainingPaper;
import com.ovopark.training.model.TrainingPaperTurns;
import com.ovopark.training.model.TrainingPaperUserTurns;
import com.ovopark.training.model.TrainingUserPaper;
import com.ovopark.training.model.TrainingUserViewTime;
import com.ovopark.training.model.TrainingWorkUserAnswer;
import com.ovopark.training.model.Users;
import com.ovopark.training.service.TrainingCommonService;
import com.ovopark.training.service.TrainingCourseExportService;
import com.ovopark.training.service.UserUtilService;
import com.ovopark.training.util.DateUtils;
import com.ovopark.training.util.ListUtil;
import com.ovopark.training.vo.TrainingCourseUserTaskVo;
import com.ovopark.training.vo.TrainingUserViewTimeVo;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Service
public class TrainingCourseExportServiceImpl
implements TrainingCourseExportService {
    private static final Logger log = LoggerFactory.getLogger(TrainingCourseExportServiceImpl.class);
    @Autowired
    private TrainingUserPaperMapper trainingUserPaperMapper;
    @Autowired
    private TrainingMaterialMapper materialMapper;
    @Autowired
    private TrainingCourseMapper courseMapper;
    @Autowired
    private TrainingCourseUserMapper courseUserMapper;
    @Autowired
    private TrainingCourseStageTaskMapper courseStageTaskMapper;
    @Autowired
    private TrainingCourseUserTaskMapper courseUserTaskMapper;
    @Autowired
    private TrainingPaperMapper trainingPaperMapper;
    @Autowired
    private UserApi userApi;
    @Autowired
    private com.ovopark.privilege.api.UserApi useApi;
    @Autowired
    private UserOrganizeApi userOrganizeApi;
    @Autowired
    private TrainingPaperTurnsMapper paperTurnsMapper;
    @Autowired
    private TrainingPaperUserTurnsMapper paperUserTurnsMapper;
    @Autowired
    private UserUtilService userUtilService;
    @Autowired
    private TrainingCommonService commonService;
    @Value(value="${training.webview.url}")
    private String trainingPaperUrl;
    @Autowired
    private TagApi tagApi;
    @Autowired
    private RoleApi roleApi;
    @Autowired
    private TrainingWorkUserAnswerMapper trainingWorkUserAnswerMapper;
    @Autowired
    private TrainingUserViewTimeMapper trainingUserViewTimeMapper;
    @Autowired
    private TrainingExamMapper trainingExamMapper;

    @Override
    public Page<TrainingCourseUserTaskVo> selectCourseTrainingByPage(Page<TrainingCourseUserTaskVo> page, Integer taskId, String name, Integer status, Users user) {
        List<Integer> userIds;
        com.ovopark.organize.common.base.BaseResult base;
        TrainingCourseStageTask stageTask = (TrainingCourseStageTask)this.courseStageTaskMapper.selectById(taskId);
        Integer taskType = stageTask.getTaskType();
        TrainingCourse course = (TrainingCourse)this.courseMapper.selectById(stageTask.getCourseId());
        List<Object> allUserIdList = new ArrayList();
        if (!org.springframework.util.StringUtils.isEmpty((Object)course.getAppointType()) && course.getAppointType() == 1) {
            LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)wrapper1.eq(TrainingCourseUser::getCourseId, (Object)course.getId())).eq(TrainingCourseUser::getCourseType, (Object)1);
            List courseUserList = this.courseUserMapper.selectList((Wrapper)wrapper1);
            if (!CollectionUtils.isEmpty((Collection)courseUserList)) {
                com.ovopark.organize.common.base.BaseResult simplePojoBaseResult;
                List tagIds;
                List list;
                DepAndTagsPojo pojo;
                String string;
                BaseResult baseResult;
                List roleIds;
                List userIds2 = courseUserList.stream().map(TrainingCourseUser::getUserId).distinct().filter(Objects::nonNull).collect(Collectors.toList());
                if (!CollectionUtils.isEmpty(userIds2)) {
                    allUserIdList.addAll(userIds2);
                }
                if (!CollectionUtils.isEmpty(roleIds = courseUserList.stream().map(TrainingCourseUser::getRoleId).filter(Objects::nonNull).distinct().collect(Collectors.toList())) && (baseResult = this.useApi.getUserByRoleIds(string = StringUtils.join(roleIds, (String)","), user.getGroupId())) != null && !CollectionUtils.isEmpty((Collection)((Collection)baseResult.getData()))) {
                    pojo = ((List)baseResult.getData()).stream().map(UsersPojo::getId).distinct().collect(Collectors.toList());
                    allUserIdList.addAll((Collection<Object>)pojo);
                }
                if (!CollectionUtils.isEmpty(list = courseUserList.stream().map(TrainingCourseUser::getOrganizeId).filter(Objects::nonNull).distinct().collect(Collectors.toList()))) {
                    UsersAndOrgsMo mo = new UsersAndOrgsMo();
                    mo.setGroupId(user.getGroupId());
                    mo.setOrganizeIds(list);
                    com.ovopark.organize.common.base.BaseResult userResult = this.userOrganizeApi.getUserByOrganizeIdsOrDepId(mo);
                    if (!userResult.getIsError().booleanValue() && !CollectionUtils.isEmpty((Collection)((Collection)userResult.getData()))) {
                        List users = ((List)userResult.getData()).stream().map(UserAndParentNameMo::getUserId).distinct().collect(Collectors.toList());
                        allUserIdList.addAll(users);
                    }
                }
                if (!CollectionUtils.isEmpty(tagIds = courseUserList.stream().map(TrainingCourseUser::getTagId).filter(Objects::nonNull).distinct().collect(Collectors.toList()))) {
                    pojo = new DepAndTagsPojo();
                    pojo.setGroupId(user.getGroupId());
                    pojo.setTagIds(tagIds);
                    pojo.setUserId(user.getId());
                    com.ovopark.organize.common.base.BaseResult tagResult = this.tagApi.getUsersByTags(pojo);
                    if (!tagResult.getIsError().booleanValue() && !CollectionUtils.isEmpty((Collection)((Collection)tagResult.getData()))) {
                        for (Map map : (List)tagResult.getData()) {
                            Integer id = (Integer)map.get("id");
                            allUserIdList.add(id);
                        }
                    }
                }
                allUserIdList = allUserIdList.stream().distinct().collect(Collectors.toList());
                if (course.getStatus() != 3 && !Objects.isNull(simplePojoBaseResult = this.userApi.getSimpleUserByKeyWord(user.getGroupId(), null, null)) && !CollectionUtils.isEmpty((Collection)((Collection)simplePojoBaseResult.getData()))) {
                    allUserIdList.retainAll(((List)simplePojoBaseResult.getData()).stream().map(SimplePojo::getId).distinct().collect(Collectors.toList()));
                }
            }
        } else {
            List base2 = (List)this.userApi.getSimpleUserByKeyWord(user.getGroupId(), null, null).getData();
            allUserIdList = base2.stream().map(SimplePojo::getId).collect(Collectors.toList());
        }
        if (!CollectionUtils.isEmpty(allUserIdList)) {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            com.ovopark.organize.common.base.BaseResult base3 = this.userApi.getUserGtCreateTime(course.getEnterpriseId(), format.format(course.getEndTime()));
            if (base3 != null && !CollectionUtils.isEmpty((Collection)((Collection)base3.getData()))) {
                List userRemoveList = (List)base3.getData();
                allUserIdList.removeAll(userRemoveList);
            }
        }
        if (!org.springframework.util.StringUtils.isEmpty((Object)name)) {
            com.ovopark.organize.common.base.BaseResult base2 = this.userApi.getSimpleUserByKeyWord(user.getGroupId(), name, null);
            if (base2 != null) {
                List userIdList = ((List)base2.getData()).stream().map(SimplePojo::getId).collect(Collectors.toList());
                allUserIdList.retainAll(userIdList);
            } else {
                allUserIdList = new ArrayList();
            }
        }
        if (CollectionUtils.isEmpty(allUserIdList)) {
            return page;
        }
        List<TrainingCourseUserTask> userTaskList = new ArrayList();
        LambdaQueryWrapper wrapper2 = new LambdaQueryWrapper();
        if (!org.springframework.util.StringUtils.isEmpty((Object)status)) {
            if (status == 1) {
                wrapper2.ne(TrainingCourseUserTask::getTaskStatus, (Object)1);
            } else if (status == 2) {
                wrapper2.notIn(TrainingCourseUserTask::getTaskStatus, Arrays.asList(1, 2));
            } else {
                wrapper2.in(TrainingCourseUserTask::getTaskStatus, status == 3 ? Arrays.asList(3, 4) : Collections.singletonList(status));
            }
        }
        wrapper2.eq(TrainingCourseUserTask::getTaskId, (Object)taskId);
        if (!CollectionUtils.isEmpty(allUserIdList)) {
            wrapper2.in(TrainingCourseUserTask::getUserId, allUserIdList);
        } else {
            wrapper2.isNull(TrainingCourseUserTask::getUserId);
        }
        wrapper2.orderByDesc(TrainingCourseUserTask::getStartTime);
        userTaskList = this.courseUserTaskMapper.selectList((Wrapper)wrapper2);
        Map<Object, Object> turnMap = new HashMap();
        if (!CollectionUtils.isEmpty(allUserIdList)) {
            LambdaQueryWrapper wrapperU = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapperU.eq(TrainingPaperUserTurns::getProjectId, (Object)stageTask.getCourseId())).eq(TrainingPaperUserTurns::getStageId, (Object)stageTask.getStageId())).eq(TrainingPaperUserTurns::getTurnType, (Object)4)).in(TrainingPaperUserTurns::getUserId, allUserIdList)).orderByDesc(TrainingPaperUserTurns::getTurns);
            List list = this.paperUserTurnsMapper.selectList((Wrapper)wrapperU);
            if (!CollectionUtils.isEmpty((Collection)list)) {
                turnMap = list.stream().collect(Collectors.toMap(TrainingPaperUserTurns::getUserId, e -> new ArrayList<TrainingPaperUserTurns>(Collections.singletonList(e)), (oldList, newList) -> {
                    oldList.addAll(newList);
                    return oldList;
                }));
            }
        }
        if (!CollectionUtils.isEmpty(userTaskList)) {
            ArrayList<TrainingCourseUserTask> delList = new ArrayList<TrainingCourseUserTask>();
            for (TrainingCourseUserTask courseUserTask : userTaskList) {
                List paperUserTurnsList = (List)turnMap.get(courseUserTask.getUserId());
                if (!CollectionUtils.isEmpty((Collection)paperUserTurnsList)) {
                    if (courseUserTask.getTurns().intValue() == ((TrainingPaperUserTurns)paperUserTurnsList.get(0)).getTurns().intValue()) continue;
                    delList.add(courseUserTask);
                    continue;
                }
                if (courseUserTask.getTurns() == 1) continue;
                delList.add(courseUserTask);
            }
            if (!CollectionUtils.isEmpty(delList)) {
                userTaskList.removeAll(delList);
            }
        }
        if (org.springframework.util.StringUtils.isEmpty((Object)status) || status == 1) {
            if (!CollectionUtils.isEmpty(userTaskList)) {
                List userIdList = userTaskList.stream().map(TrainingCourseUserTask::getUserId).distinct().collect(Collectors.toList());
                allUserIdList.removeAll(userIdList);
            }
            if (!CollectionUtils.isEmpty(allUserIdList)) {
                if (!org.springframework.util.StringUtils.isEmpty((Object)status)) {
                    userTaskList = new ArrayList();
                }
                for (Integer n : allUserIdList) {
                    List paperUserTurnsList = (List)turnMap.get(n);
                    TrainingCourseUserTask task = new TrainingCourseUserTask();
                    task.setTaskId(taskId);
                    task.setUserId(n);
                    task.setTaskStatus(Integer.valueOf(1));
                    task.setTurns(Integer.valueOf(!CollectionUtils.isEmpty((Collection)paperUserTurnsList) ? ((TrainingPaperUserTurns)paperUserTurnsList.get(0)).getTurns() : 1));
                    if (!org.springframework.util.StringUtils.isEmpty((Object)status) && status == 1 && task.getTurns() > 1) continue;
                    userTaskList.add(task);
                }
            } else if (!org.springframework.util.StringUtils.isEmpty((Object)status)) {
                userTaskList = new ArrayList();
            }
        }
        if (!org.springframework.util.StringUtils.isEmpty((Object)status) && status == 2) {
            LambdaQueryWrapper wrapper3 = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper3.eq(TrainingCourseUserTask::getTaskId, (Object)taskId)).in(TrainingCourseUserTask::getUserId, allUserIdList)).ne(TrainingCourseUserTask::getTaskStatus, (Object)1);
            List list = this.courseUserTaskMapper.selectList((Wrapper)wrapper3);
            if (!CollectionUtils.isEmpty((Collection)list)) {
                List userAlls = list.stream().map(TrainingCourseUserTask::getUserId).distinct().collect(Collectors.toList());
                if (!CollectionUtils.isEmpty(allUserIdList)) {
                    userAlls.retainAll(allUserIdList);
                    if (!CollectionUtils.isEmpty(userTaskList)) {
                        List userTaskAlls = userTaskList.stream().map(TrainingCourseUserTask::getUserId).distinct().collect(Collectors.toList());
                        userAlls.removeAll(userTaskAlls);
                    }
                    if (!CollectionUtils.isEmpty(userAlls)) {
                        userTaskList = new ArrayList();
                        for (Integer userId : userAlls) {
                            List paperUserTurnsList = (List)turnMap.get(userId);
                            TrainingCourseUserTask task = new TrainingCourseUserTask();
                            task.setTaskId(taskId);
                            task.setUserId(userId);
                            task.setTaskStatus(Integer.valueOf(2));
                            task.setTurns(Integer.valueOf(!CollectionUtils.isEmpty((Collection)paperUserTurnsList) ? ((TrainingPaperUserTurns)paperUserTurnsList.get(0)).getTurns() : 1));
                            userTaskList.add(task);
                        }
                    } else {
                        userTaskList = new ArrayList();
                    }
                } else {
                    userTaskList = new ArrayList();
                }
            } else {
                userTaskList = new ArrayList();
            }
        }
        ArrayList<TrainingCourseUserTaskVo> userTaskVos = new ArrayList<TrainingCourseUserTaskVo>();
        Page page2 = ListUtil.myPage(userTaskList, page.getPageNumber(), page.getPageSize());
        page.setTotalCount(page2.getTotalCount());
        page.setPageCount(page2.getPageCount());
        List userTasks = page2.getContent();
        if (!CollectionUtils.isEmpty((Collection)userTasks) && (base = this.userApi.getUserByIdList(userIds = userTasks.stream().map(TrainingCourseUserTask::getUserId).distinct().collect(Collectors.toList()))) != null && !CollectionUtils.isEmpty((Collection)((Collection)base.getData()))) {
            List<TrainingUserViewTimeVo> voTypeList;
            List<TrainingUserViewTimeVo> voList;
            Map<Object, Object> paperMap = new HashMap();
            Map<Object, Object> viewTimeMap = new HashMap();
            Map<Object, Object> viewTimeTypeMap = new HashMap();
            Map<Object, Object> paperTurnsMap = new HashMap();
            TrainingMaterial material = new TrainingMaterial();
            Map<Object, Object> trainingWorkUserAnswerMap = new HashMap();
            if (taskType == 1) {
                if (stageTask.getIsProgress() == 1) {
                    voList = this.commonService.selectViewTimeByUserId(0, userIds, null, Collections.singletonList(stageTask.getTrainingId()), null);
                    if (!CollectionUtils.isEmpty(voList)) {
                        viewTimeMap = voList.stream().collect(Collectors.groupingBy(TrainingUserViewTime::getUserId));
                    }
                    if (!CollectionUtils.isEmpty(voTypeList = this.commonService.selectViewTimeByUserId(4, userIds, null, Collections.singletonList(stageTask.getTrainingId()), taskId))) {
                        viewTimeTypeMap = voTypeList.stream().collect(Collectors.groupingBy(TrainingUserViewTime::getUserId));
                    }
                } else {
                    voList = this.commonService.selectViewTimeByUserId(4, userIds, null, Collections.singletonList(stageTask.getTrainingId()), taskId);
                    if (!CollectionUtils.isEmpty(voList)) {
                        viewTimeMap = voList.stream().collect(Collectors.groupingBy(TrainingUserViewTime::getUserId));
                        viewTimeTypeMap = voList.stream().collect(Collectors.groupingBy(TrainingUserViewTime::getUserId));
                    }
                }
            } else if (taskType == 2) {
                LambdaQueryWrapper wrapper4 = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper4.eq(TrainingPaperTurns::getProjectId, (Object)stageTask.getCourseId())).eq(TrainingPaperTurns::getTaskId, (Object)taskId)).eq(TrainingPaperTurns::getTurnType, (Object)4);
                List paperTurnsList = this.paperTurnsMapper.selectList((Wrapper)wrapper4);
                List<Integer> paperTurnsIdList = new ArrayList<Integer>();
                if (!CollectionUtils.isEmpty((Collection)paperTurnsList)) {
                    paperTurnsIdList = paperTurnsList.stream().map(TrainingPaperTurns::getPaperId).distinct().collect(Collectors.toList());
                    paperTurnsMap = paperTurnsList.stream().collect(Collectors.toMap(TrainingPaperTurns::getTurns, Function.identity()));
                }
                paperTurnsIdList.add(stageTask.getPaperId());
                LambdaQueryWrapper wrapper3 = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper3.in(TrainingUserPaper::getTrainingPaperId, paperTurnsIdList)).isNotNull(TrainingUserPaper::getSubmitTime)).in(TrainingUserPaper::getUserId, userIds)).eq(TrainingUserPaper::getSourceType, (Object)5)).eq(TrainingUserPaper::getSourceProjectId, (Object)stageTask.getCourseId())).eq(TrainingUserPaper::getSourceTaskId, (Object)taskId)).orderByDesc(TrainingUserPaper::getSubmitTime);
                List userPaperList = this.trainingUserPaperMapper.selectList((Wrapper)wrapper3);
                if (!CollectionUtils.isEmpty((Collection)userPaperList)) {
                    paperMap = userPaperList.stream().collect(Collectors.groupingBy(TrainingUserPaper::getUserId));
                }
            } else if (taskType == 5) {
                if (stageTask.getIsProgress() == 1) {
                    voList = this.trainingUserViewTimeMapper.selectViewTimeByuserId(0, userIds, Collections.singletonList(stageTask.getMaterialId()), null, null);
                    if (!CollectionUtils.isEmpty(voList)) {
                        viewTimeMap = voList.stream().collect(Collectors.groupingBy(TrainingUserViewTime::getUserId));
                    }
                    if (!CollectionUtils.isEmpty(voTypeList = this.trainingUserViewTimeMapper.selectViewTimeByuserId(4, userIds, Collections.singletonList(stageTask.getMaterialId()), null, taskId))) {
                        viewTimeTypeMap = voTypeList.stream().collect(Collectors.groupingBy(TrainingUserViewTime::getUserId));
                    }
                } else {
                    voList = this.trainingUserViewTimeMapper.selectViewTimeByuserId(4, userIds, Collections.singletonList(stageTask.getMaterialId()), null, taskId);
                    if (!CollectionUtils.isEmpty(voList)) {
                        viewTimeMap = voList.stream().collect(Collectors.groupingBy(TrainingUserViewTime::getUserId));
                        viewTimeTypeMap = voList.stream().collect(Collectors.groupingBy(TrainingUserViewTime::getUserId));
                    }
                }
                material = (TrainingMaterial)this.materialMapper.selectById(stageTask.getMaterialId());
            } else if (taskType == 6) {
                LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper1.eq(TrainingWorkUserAnswer::getWorkId, (Object)stageTask.getWorkId())).eq(TrainingWorkUserAnswer::getSourceType, (Object)5)).eq(TrainingWorkUserAnswer::getSourceTaskId, (Object)stageTask.getId())).ne(TrainingWorkUserAnswer::getStatus, (Object)0)).in(TrainingWorkUserAnswer::getUserId, userIds);
                List list = this.trainingWorkUserAnswerMapper.selectList((Wrapper)wrapper1);
                if (!CollectionUtils.isEmpty((Collection)list)) {
                    trainingWorkUserAnswerMap = list.stream().collect(Collectors.groupingBy(TrainingWorkUserAnswer::getUserId));
                }
            }
            Map<Object, Object> courseUserTaskMap = new HashMap();
            if (taskType == 1 || taskType == 5) {
                LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper1.eq(TrainingCourseUserTask::getTaskId, (Object)taskId)).eq(TrainingCourseUserTask::getTurns, (Object)1)).in(TrainingCourseUserTask::getUserId, userIds);
                List trainingCourseUserTasks = this.courseUserTaskMapper.selectList((Wrapper)wrapper1);
                if (!CollectionUtils.isEmpty((Collection)trainingCourseUserTasks)) {
                    courseUserTaskMap = trainingCourseUserTasks.stream().collect(Collectors.toMap(TrainingCourseUserTask::getUserId, e -> new ArrayList<TrainingCourseUserTask>(Collections.singletonList(e)), (oldList, newList) -> {
                        oldList.addAll(newList);
                        return oldList;
                    }));
                }
            }
            Map<Object, Object> courseUserTasksMap = new HashMap();
            LambdaQueryWrapper wrapper3 = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)wrapper3.eq(TrainingCourseUserTask::getTaskId, (Object)taskId)).in(TrainingCourseUserTask::getUserId, userIds);
            List trainingCourseUserTasks3 = this.courseUserTaskMapper.selectList((Wrapper)wrapper3);
            if (!CollectionUtils.isEmpty((Collection)trainingCourseUserTasks3)) {
                courseUserTasksMap = trainingCourseUserTasks3.stream().collect(Collectors.toMap(TrainingCourseUserTask::getUserId, e -> new ArrayList<TrainingCourseUserTask>(Collections.singletonList(e)), (oldList, newList) -> {
                    oldList.addAll(newList);
                    return oldList;
                }));
            }
            Map pojoMap = ((List)base.getData()).stream().collect(Collectors.toMap(com.ovopark.organize.common.model.pojo.UsersPojo::getId, Function.identity()));
            Map<Integer, String> userOrganizeMap = this.userUtilService.selectUserOrganizeName(user.getGroupId(), userIds);
            Map userRoleMap = new HashMap();
            if (!CollectionUtils.isEmpty(userIds)) {
                HashMap<String, Object> parameter = new HashMap<String, Object>();
                parameter.put("userIds", StringUtils.join(userIds, (String)","));
                parameter.put("groupId", user.getGroupId());
                BaseResult roleBase = this.roleApi.getUserRoleList(parameter);
                if (roleBase != null) {
                    userRoleMap = (Map)roleBase.getData();
                }
            }
            Map<Integer, UserDutiesMo> dutiesMap = this.userUtilService.selectDutiesMap(userIds, user.getGroupId());
            Map<Integer, String> parentMap = this.userUtilService.selectParentMap(userIds, user.getGroupId());
            Map<Integer, Integer> parentIdMap = this.userUtilService.selectParentIdMap(userIds, user.getGroupId());
            for (TrainingCourseUserTask userTask : userTasks) {
                TrainingCourseUserTaskVo taskVo = new TrainingCourseUserTaskVo();
                BeanUtils.copyProperties((Object)userTask, (Object)taskVo);
                com.ovopark.organize.common.model.pojo.UsersPojo pojo = (com.ovopark.organize.common.model.pojo.UsersPojo)pojoMap.get(taskVo.getUserId());
                taskVo.setUserName(ObjectUtils.isEmpty((Object)pojo) ? "" : pojo.getShowName());
                taskVo.setEmployeeNumber(ObjectUtils.isEmpty((Object)pojo) ? "" : pojo.getEmployeeNumber());
                taskVo.setOrganizeName(userOrganizeMap.get(taskVo.getUserId()));
                List userTaskList1 = (List)courseUserTasksMap.get(taskVo.getUserId());
                taskVo.setLearnCount(Integer.valueOf(0));
                if (!CollectionUtils.isEmpty((Collection)userTaskList1)) {
                    taskVo.setLearnCount(Integer.valueOf(userTaskList1.size()));
                }
                if (taskVo.getTaskStatus() != null && taskVo.getTaskStatus() == 1 && taskVo.getTurns() > 1 && taskVo.getLearnCount() > 0 && taskType != 6) {
                    taskVo.setTaskStatus(Integer.valueOf(2));
                }
                if (taskType == 1 || taskType == 5) {
                    List userTaskLists1;
                    if ((taskVo.getTurns() > 1 || !org.springframework.util.StringUtils.isEmpty((Object)status) && status == 2) && !CollectionUtils.isEmpty((Collection)(userTaskLists1 = (List)courseUserTaskMap.get(taskVo.getUserId())))) {
                        taskVo.setStartTime(((TrainingCourseUserTask)userTaskLists1.get(0)).getStartTime());
                    }
                    List timeVoList = (List)viewTimeMap.get(taskVo.getUserId());
                    Integer times = 0;
                    if (!CollectionUtils.isEmpty((Collection)timeVoList)) {
                        for (TrainingUserViewTimeVo vo : timeVoList) {
                            if (taskVo.getTurns().intValue() != vo.getTurns().intValue()) continue;
                            times = vo.getViewTimes();
                        }
                    }
                    List timeVoTypeList = (List)viewTimeTypeMap.get(taskVo.getUserId());
                    int totalTimes = 0;
                    if (!CollectionUtils.isEmpty((Collection)timeVoTypeList)) {
                        for (TrainingUserViewTimeVo vo : timeVoTypeList) {
                            if (org.springframework.util.StringUtils.isEmpty((Object)vo.getViewTimes())) continue;
                            totalTimes += vo.getViewTimes().intValue();
                        }
                    }
                    String timeStr = "00:00:00";
                    if (totalTimes != 0) {
                        timeStr = DateUtils.getUseTimeFormal(totalTimes);
                    }
                    taskVo.setTimeStr(timeStr);
                    if (taskVo.getTaskStatus() != 3 && taskVo.getTaskStatus() != 4) {
                        taskVo.setEndTime(null);
                    }
                    if (taskType == 5) {
                        BigDecimal finishTime = BigDecimal.ZERO;
                        if (material.getIsVideo() == 1) {
                            finishTime = new BigDecimal(material.getDuration());
                            if (!org.springframework.util.StringUtils.isEmpty((Object)material.getFinishRate())) {
                                finishTime = finishTime.multiply(material.getFinishRate()).divide(new BigDecimal("100"), 0, 1);
                            }
                        } else if (material.getFinishTime() != null) {
                            finishTime = new BigDecimal(material.getFinishTime());
                        }
                        BigDecimal rate = BigDecimal.ZERO;
                        if (finishTime.compareTo(BigDecimal.ZERO) > 0 && taskVo.getTaskStatus() != 1) {
                            rate = new BigDecimal(times).divide(finishTime, 2, 1);
                        }
                        taskVo.setReadRate(taskVo.getTaskStatus() == 3 || taskVo.getTaskStatus() == 4 ? new BigDecimal("100") : rate.multiply(new BigDecimal("100")));
                    }
                } else if (taskType == 2) {
                    if (taskVo.getTaskStatus() != 1) {
                        TrainingPaperTurns paperTurns = (TrainingPaperTurns)paperTurnsMap.get(taskVo.getTurns());
                        Integer paperId = stageTask.getPaperId();
                        TrainingPaper trainingPaper = (TrainingPaper)this.trainingPaperMapper.selectById(paperId);
                        if (!org.springframework.util.StringUtils.isEmpty((Object)paperTurns)) {
                            paperId = paperTurns.getPaperId();
                        }
                        List userPaperList = (List)paperMap.get(taskVo.getUserId());
                        int paperCount = 0;
                        if (!CollectionUtils.isEmpty((Collection)userPaperList)) {
                            paperCount = userPaperList.size();
                            ArrayList<TrainingUserPaper> userPapers = new ArrayList<TrainingUserPaper>();
                            for (TrainingUserPaper paper : userPaperList) {
                                if (paper.getTrainingPaperId().toString().equals(paperId.toString())) continue;
                                userPapers.add(paper);
                            }
                            if (!CollectionUtils.isEmpty(userPapers)) {
                                userPaperList.removeAll(userPapers);
                            }
                            if (!CollectionUtils.isEmpty((Collection)userPaperList)) {
                                double topScore = 0.0;
                                TrainingUserPaper topPaper = null;
                                TrainingUserPaper newPaper = null;
                                for (TrainingUserPaper paper : userPaperList) {
                                    if (!paper.getPaperStatus().equals(2)) continue;
                                    if (topScore <= paper.getScore().doubleValue()) {
                                        topScore = paper.getScore().doubleValue();
                                        topPaper = paper;
                                    }
                                    if (newPaper != null) continue;
                                    newPaper = paper;
                                }
                                if (taskVo.getTaskStatus() == 3 || taskVo.getTaskStatus() == 4 || taskVo.getTaskStatus() == 5) {
                                    if (trainingPaper.getScoreSelect() == null || trainingPaper.getScoreSelect() != null && trainingPaper.getScoreSelect().equals(1)) {
                                        taskVo.setScore(newPaper.getScore());
                                    } else if (trainingPaper.getScoreSelect() != null && trainingPaper.getScoreSelect().equals(0)) {
                                        taskVo.setScore(topPaper.getScore());
                                    }
                                } else {
                                    taskVo.setScore(new BigDecimal(-1));
                                }
                                int totalTime = 0;
                                for (TrainingUserPaper userPaper : userPaperList) {
                                    if (org.springframework.util.StringUtils.isEmpty((Object)userPaper.getSubmitTime()) || org.springframework.util.StringUtils.isEmpty((Object)userPaper.getUpdateTime())) continue;
                                    totalTime += (int)((userPaper.getSubmitTime().getTime() - userPaper.getUpdateTime().getTime()) / 1000L);
                                }
                                taskVo.setTimeStr(DateUtils.getUseTimeFormal(totalTime /= paperCount));
                            }
                        }
                        taskVo.setPaperCount(Integer.valueOf(paperCount));
                    }
                } else if (taskType == 6) {
                    Integer answerCount = 0;
                    List trainingWorkUserAnswerList = (List)trainingWorkUserAnswerMap.get(taskVo.getUserId());
                    if (!CollectionUtils.isEmpty((Collection)trainingWorkUserAnswerList)) {
                        answerCount = trainingWorkUserAnswerList.size();
                        for (TrainingWorkUserAnswer trainingWorkUserAnswer : trainingWorkUserAnswerList) {
                            if (trainingWorkUserAnswer.getIsLast() == null || trainingWorkUserAnswer.getIsLast() != 1 || taskVo.getTurns() != trainingWorkUserAnswer.getTurns()) continue;
                            taskVo.setScore(trainingWorkUserAnswer.getScore());
                            taskVo.setCommitTime(trainingWorkUserAnswer.getCommitTime());
                            break;
                        }
                    }
                    taskVo.setAnswerCount(answerCount);
                }
                if (!CollectionUtils.isEmpty((Collection)((Collection)userRoleMap.get(taskVo.getUserId())))) {
                    StringBuilder role = new StringBuilder();
                    for (RolePojo rolePojo : (List)userRoleMap.get(taskVo.getUserId())) {
                        role.append(rolePojo.getRoleName()).append(";\n");
                    }
                    taskVo.setRole(role.substring(0, role.length() - 2));
                }
                if (!CollectionUtils.isEmpty(dutiesMap) && dutiesMap.get(taskVo.getUserId()) != null) {
                    taskVo.setPost(dutiesMap.get(taskVo.getUserId()).getDutieName());
                }
                if (!CollectionUtils.isEmpty(parentMap)) {
                    taskVo.setParentName(parentMap.get(taskVo.getUserId()));
                }
                if (!CollectionUtils.isEmpty(parentIdMap)) {
                    taskVo.setParentUserId(parentIdMap.get(taskVo.getUserId()));
                }
                userTaskVos.add(taskVo);
            }
        }
        page.setContent(userTaskVos);
        return page;
    }

    @Override
    public List<TrainingCourseUserTaskVo> getCourseTrainingList(Integer taskId, String name, Integer status, Integer groupId, Integer userId) {
        List<Integer> list;
        com.ovopark.organize.common.base.BaseResult base;
        TrainingCourseStageTask stageTask = (TrainingCourseStageTask)this.courseStageTaskMapper.selectById(taskId);
        Integer taskType = stageTask.getTaskType();
        TrainingCourse course = (TrainingCourse)this.courseMapper.selectById(stageTask.getCourseId());
        List<Object> allUserIdList = new ArrayList();
        if (!org.springframework.util.StringUtils.isEmpty((Object)course.getAppointType()) && course.getAppointType() == 1) {
            LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)wrapper1.eq(TrainingCourseUser::getCourseId, (Object)course.getId())).eq(TrainingCourseUser::getCourseType, (Object)1);
            List courseUserList = this.courseUserMapper.selectList((Wrapper)wrapper1);
            if (!CollectionUtils.isEmpty((Collection)courseUserList)) {
                com.ovopark.organize.common.base.BaseResult simplePojoBaseResult;
                List tagIds;
                List list2;
                DepAndTagsPojo pojo;
                String string;
                BaseResult baseResult;
                List roleIds;
                List userIds2 = courseUserList.stream().map(TrainingCourseUser::getUserId).distinct().filter(Objects::nonNull).collect(Collectors.toList());
                if (!CollectionUtils.isEmpty(userIds2)) {
                    allUserIdList.addAll(userIds2);
                }
                if (!CollectionUtils.isEmpty(roleIds = courseUserList.stream().map(TrainingCourseUser::getRoleId).filter(Objects::nonNull).distinct().collect(Collectors.toList())) && (baseResult = this.useApi.getUserByRoleIds(string = StringUtils.join(roleIds, (String)","), groupId)) != null && !CollectionUtils.isEmpty((Collection)((Collection)baseResult.getData()))) {
                    pojo = ((List)baseResult.getData()).stream().map(UsersPojo::getId).distinct().collect(Collectors.toList());
                    allUserIdList.addAll((Collection<Object>)pojo);
                }
                if (!CollectionUtils.isEmpty(list2 = courseUserList.stream().map(TrainingCourseUser::getOrganizeId).filter(Objects::nonNull).distinct().collect(Collectors.toList()))) {
                    UsersAndOrgsMo mo = new UsersAndOrgsMo();
                    mo.setGroupId(groupId);
                    mo.setOrganizeIds(list2);
                    com.ovopark.organize.common.base.BaseResult userResult = this.userOrganizeApi.getUserByOrganizeIdsOrDepId(mo);
                    if (!userResult.getIsError().booleanValue() && !CollectionUtils.isEmpty((Collection)((Collection)userResult.getData()))) {
                        List users = ((List)userResult.getData()).stream().map(UserAndParentNameMo::getUserId).distinct().collect(Collectors.toList());
                        allUserIdList.addAll(users);
                    }
                }
                if (!CollectionUtils.isEmpty(tagIds = courseUserList.stream().map(TrainingCourseUser::getTagId).filter(Objects::nonNull).distinct().collect(Collectors.toList()))) {
                    pojo = new DepAndTagsPojo();
                    pojo.setGroupId(groupId);
                    pojo.setTagIds(tagIds);
                    pojo.setUserId(userId);
                    com.ovopark.organize.common.base.BaseResult tagResult = this.tagApi.getUsersByTags(pojo);
                    if (!tagResult.getIsError().booleanValue() && !CollectionUtils.isEmpty((Collection)((Collection)tagResult.getData()))) {
                        for (Map map : (List)tagResult.getData()) {
                            Integer id = (Integer)map.get("id");
                            allUserIdList.add(id);
                        }
                    }
                }
                allUserIdList = allUserIdList.stream().distinct().collect(Collectors.toList());
                if (course.getStatus() != 3 && !Objects.isNull(simplePojoBaseResult = this.userApi.getSimpleUserByKeyWord(groupId, null, null)) && !CollectionUtils.isEmpty((Collection)((Collection)simplePojoBaseResult.getData()))) {
                    allUserIdList.retainAll(((List)simplePojoBaseResult.getData()).stream().map(SimplePojo::getId).distinct().collect(Collectors.toList()));
                }
            }
        } else {
            List base2 = (List)this.userApi.getSimpleUserByKeyWord(groupId, null, null).getData();
            allUserIdList = base2.stream().map(SimplePojo::getId).collect(Collectors.toList());
        }
        if (!CollectionUtils.isEmpty(allUserIdList)) {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            com.ovopark.organize.common.base.BaseResult base3 = this.userApi.getUserGtCreateTime(course.getEnterpriseId(), format.format(course.getEndTime()));
            if (base3 != null && !CollectionUtils.isEmpty((Collection)((Collection)base3.getData()))) {
                List userRemoveList = (List)base3.getData();
                allUserIdList.removeAll(userRemoveList);
            }
        }
        if (!org.springframework.util.StringUtils.isEmpty((Object)name)) {
            com.ovopark.organize.common.base.BaseResult base2 = this.userApi.getSimpleUserByKeyWord(groupId, name, null);
            if (base2 != null) {
                List userIdList = ((List)base2.getData()).stream().map(SimplePojo::getId).collect(Collectors.toList());
                allUserIdList.retainAll(userIdList);
            } else {
                allUserIdList = new ArrayList();
            }
        }
        if (CollectionUtils.isEmpty(allUserIdList)) {
            return null;
        }
        List<TrainingCourseUserTask> userTaskList = new ArrayList();
        LambdaQueryWrapper wrapper2 = new LambdaQueryWrapper();
        if (!org.springframework.util.StringUtils.isEmpty((Object)status)) {
            if (status == 1) {
                wrapper2.ne(TrainingCourseUserTask::getTaskStatus, (Object)1);
            } else if (status == 2) {
                wrapper2.notIn(TrainingCourseUserTask::getTaskStatus, Arrays.asList(1, 2));
            } else {
                wrapper2.in(TrainingCourseUserTask::getTaskStatus, status == 3 ? Arrays.asList(3, 4) : Collections.singletonList(status));
            }
        }
        wrapper2.eq(TrainingCourseUserTask::getTaskId, (Object)taskId);
        if (!CollectionUtils.isEmpty(allUserIdList)) {
            wrapper2.in(TrainingCourseUserTask::getUserId, allUserIdList);
        } else {
            wrapper2.isNull(TrainingCourseUserTask::getUserId);
        }
        wrapper2.orderByDesc(TrainingCourseUserTask::getStartTime);
        userTaskList = this.courseUserTaskMapper.selectList((Wrapper)wrapper2);
        Map<Object, Object> turnMap = new HashMap();
        if (!CollectionUtils.isEmpty(allUserIdList)) {
            LambdaQueryWrapper wrapperU = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapperU.eq(TrainingPaperUserTurns::getProjectId, (Object)stageTask.getCourseId())).eq(TrainingPaperUserTurns::getStageId, (Object)stageTask.getStageId())).eq(TrainingPaperUserTurns::getTurnType, (Object)4)).in(TrainingPaperUserTurns::getUserId, allUserIdList)).orderByDesc(TrainingPaperUserTurns::getTurns);
            List list3 = this.paperUserTurnsMapper.selectList((Wrapper)wrapperU);
            if (!CollectionUtils.isEmpty((Collection)list3)) {
                turnMap = list3.stream().collect(Collectors.toMap(TrainingPaperUserTurns::getUserId, e -> new ArrayList<TrainingPaperUserTurns>(Collections.singletonList(e)), (oldList, newList) -> {
                    oldList.addAll(newList);
                    return oldList;
                }));
            }
        }
        if (!CollectionUtils.isEmpty(userTaskList)) {
            ArrayList<TrainingCourseUserTask> delList = new ArrayList<TrainingCourseUserTask>();
            for (TrainingCourseUserTask courseUserTask : userTaskList) {
                List paperUserTurnsList = (List)turnMap.get(courseUserTask.getUserId());
                if (!CollectionUtils.isEmpty((Collection)paperUserTurnsList)) {
                    if (courseUserTask.getTurns().intValue() == ((TrainingPaperUserTurns)paperUserTurnsList.get(0)).getTurns().intValue()) continue;
                    delList.add(courseUserTask);
                    continue;
                }
                if (courseUserTask.getTurns() == 1) continue;
                delList.add(courseUserTask);
            }
            if (!CollectionUtils.isEmpty(delList)) {
                userTaskList.removeAll(delList);
            }
        }
        if (org.springframework.util.StringUtils.isEmpty((Object)status) || status == 1) {
            if (!CollectionUtils.isEmpty(userTaskList)) {
                List userIdList = userTaskList.stream().map(TrainingCourseUserTask::getUserId).distinct().collect(Collectors.toList());
                allUserIdList.removeAll(userIdList);
            }
            if (!CollectionUtils.isEmpty(allUserIdList)) {
                if (!org.springframework.util.StringUtils.isEmpty((Object)status)) {
                    userTaskList = new ArrayList();
                }
                for (Integer n : allUserIdList) {
                    List paperUserTurnsList = (List)turnMap.get(n);
                    TrainingCourseUserTask task = new TrainingCourseUserTask();
                    task.setTaskId(taskId);
                    task.setUserId(n);
                    task.setTaskStatus(Integer.valueOf(1));
                    task.setTurns(Integer.valueOf(!CollectionUtils.isEmpty((Collection)paperUserTurnsList) ? ((TrainingPaperUserTurns)paperUserTurnsList.get(0)).getTurns() : 1));
                    if (!org.springframework.util.StringUtils.isEmpty((Object)status) && status == 1 && task.getTurns() > 1) continue;
                    userTaskList.add(task);
                }
            } else if (!org.springframework.util.StringUtils.isEmpty((Object)status)) {
                userTaskList = new ArrayList();
            }
        }
        if (!org.springframework.util.StringUtils.isEmpty((Object)status) && status == 2) {
            LambdaQueryWrapper wrapper3 = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper3.eq(TrainingCourseUserTask::getTaskId, (Object)taskId)).in(TrainingCourseUserTask::getUserId, allUserIdList)).ne(TrainingCourseUserTask::getTaskStatus, (Object)1);
            List list4 = this.courseUserTaskMapper.selectList((Wrapper)wrapper3);
            if (!CollectionUtils.isEmpty((Collection)list4)) {
                List userAlls = list4.stream().map(TrainingCourseUserTask::getUserId).distinct().collect(Collectors.toList());
                if (!CollectionUtils.isEmpty(allUserIdList)) {
                    userAlls.retainAll(allUserIdList);
                    if (!CollectionUtils.isEmpty(userTaskList)) {
                        List userTaskAlls = userTaskList.stream().map(TrainingCourseUserTask::getUserId).distinct().collect(Collectors.toList());
                        userAlls.removeAll(userTaskAlls);
                    }
                    if (!CollectionUtils.isEmpty(userAlls)) {
                        userTaskList = new ArrayList();
                        for (Integer id : userAlls) {
                            List paperUserTurnsList = (List)turnMap.get(id);
                            TrainingCourseUserTask task = new TrainingCourseUserTask();
                            task.setTaskId(taskId);
                            task.setUserId(id);
                            task.setTaskStatus(Integer.valueOf(2));
                            task.setTurns(Integer.valueOf(!CollectionUtils.isEmpty((Collection)paperUserTurnsList) ? ((TrainingPaperUserTurns)paperUserTurnsList.get(0)).getTurns() : 1));
                            userTaskList.add(task);
                        }
                    } else {
                        userTaskList = new ArrayList();
                    }
                } else {
                    userTaskList = new ArrayList();
                }
            } else {
                userTaskList = new ArrayList();
            }
        }
        ArrayList<TrainingCourseUserTaskVo> userTaskVos = new ArrayList<TrainingCourseUserTaskVo>();
        if (!CollectionUtils.isEmpty(userTaskList) && (base = this.userApi.getUserByIdList(list = userTaskList.stream().map(TrainingCourseUserTask::getUserId).distinct().collect(Collectors.toList()))) != null && !CollectionUtils.isEmpty((Collection)((Collection)base.getData()))) {
            List<TrainingUserViewTimeVo> voTypeList;
            List<TrainingUserViewTimeVo> voList;
            Map<Object, Object> paperMap = new HashMap();
            Map<Object, Object> viewTimeMap = new HashMap();
            Map<Object, Object> viewTimeTypeMap = new HashMap();
            Map<Object, Object> paperTurnsMap = new HashMap();
            TrainingMaterial material = new TrainingMaterial();
            Map<Object, Object> trainingWorkUserAnswerMap = new HashMap();
            if (taskType == 1) {
                if (stageTask.getIsProgress() == 1) {
                    voList = this.commonService.selectViewTimeByUserId(0, list, null, Collections.singletonList(stageTask.getTrainingId()), null);
                    if (!CollectionUtils.isEmpty(voList)) {
                        viewTimeMap = voList.stream().collect(Collectors.groupingBy(TrainingUserViewTime::getUserId));
                    }
                    if (!CollectionUtils.isEmpty(voTypeList = this.commonService.selectViewTimeByUserId(4, list, null, Collections.singletonList(stageTask.getTrainingId()), taskId))) {
                        viewTimeTypeMap = voTypeList.stream().collect(Collectors.groupingBy(TrainingUserViewTime::getUserId));
                    }
                } else {
                    voList = this.commonService.selectViewTimeByUserId(4, list, null, Collections.singletonList(stageTask.getTrainingId()), taskId);
                    if (!CollectionUtils.isEmpty(voList)) {
                        viewTimeMap = voList.stream().collect(Collectors.groupingBy(TrainingUserViewTime::getUserId));
                        viewTimeTypeMap = voList.stream().collect(Collectors.groupingBy(TrainingUserViewTime::getUserId));
                    }
                }
            } else if (taskType == 2) {
                LambdaQueryWrapper wrapper4 = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper4.eq(TrainingPaperTurns::getProjectId, (Object)stageTask.getCourseId())).eq(TrainingPaperTurns::getTaskId, (Object)taskId)).eq(TrainingPaperTurns::getTurnType, (Object)4);
                List paperTurnsList = this.paperTurnsMapper.selectList((Wrapper)wrapper4);
                List<Integer> paperTurnsIdList = new ArrayList<Integer>();
                if (!CollectionUtils.isEmpty((Collection)paperTurnsList)) {
                    paperTurnsIdList = paperTurnsList.stream().map(TrainingPaperTurns::getPaperId).distinct().collect(Collectors.toList());
                    paperTurnsMap = paperTurnsList.stream().collect(Collectors.toMap(TrainingPaperTurns::getTurns, Function.identity()));
                }
                paperTurnsIdList.add(stageTask.getPaperId());
                LambdaQueryWrapper wrapper3 = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper3.in(TrainingUserPaper::getTrainingPaperId, paperTurnsIdList)).isNotNull(TrainingUserPaper::getSubmitTime)).in(TrainingUserPaper::getUserId, list)).eq(TrainingUserPaper::getSourceType, (Object)5)).eq(TrainingUserPaper::getSourceProjectId, (Object)stageTask.getCourseId())).eq(TrainingUserPaper::getSourceTaskId, (Object)taskId)).orderByDesc(TrainingUserPaper::getSubmitTime);
                List userPaperList = this.trainingUserPaperMapper.selectList((Wrapper)wrapper3);
                if (!CollectionUtils.isEmpty((Collection)userPaperList)) {
                    paperMap = userPaperList.stream().collect(Collectors.groupingBy(TrainingUserPaper::getUserId));
                }
            } else if (taskType == 5) {
                if (stageTask.getIsProgress() == 1) {
                    voList = this.trainingUserViewTimeMapper.selectViewTimeByuserId(0, list, Collections.singletonList(stageTask.getMaterialId()), null, null);
                    if (!CollectionUtils.isEmpty(voList)) {
                        viewTimeMap = voList.stream().collect(Collectors.groupingBy(TrainingUserViewTime::getUserId));
                    }
                    if (!CollectionUtils.isEmpty(voTypeList = this.trainingUserViewTimeMapper.selectViewTimeByuserId(4, list, Collections.singletonList(stageTask.getMaterialId()), null, taskId))) {
                        viewTimeTypeMap = voTypeList.stream().collect(Collectors.groupingBy(TrainingUserViewTime::getUserId));
                    }
                } else {
                    voList = this.trainingUserViewTimeMapper.selectViewTimeByuserId(4, list, Collections.singletonList(stageTask.getMaterialId()), null, taskId);
                    if (!CollectionUtils.isEmpty(voList)) {
                        viewTimeMap = voList.stream().collect(Collectors.groupingBy(TrainingUserViewTime::getUserId));
                        viewTimeTypeMap = voList.stream().collect(Collectors.groupingBy(TrainingUserViewTime::getUserId));
                    }
                }
                material = (TrainingMaterial)this.materialMapper.selectById(stageTask.getMaterialId());
            } else if (taskType == 6) {
                LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper1.eq(TrainingWorkUserAnswer::getWorkId, (Object)stageTask.getWorkId())).eq(TrainingWorkUserAnswer::getSourceType, (Object)5)).eq(TrainingWorkUserAnswer::getSourceTaskId, (Object)stageTask.getId())).ne(TrainingWorkUserAnswer::getStatus, (Object)0)).in(TrainingWorkUserAnswer::getUserId, list);
                List list5 = this.trainingWorkUserAnswerMapper.selectList((Wrapper)wrapper1);
                if (!CollectionUtils.isEmpty((Collection)list5)) {
                    trainingWorkUserAnswerMap = list5.stream().collect(Collectors.groupingBy(TrainingWorkUserAnswer::getUserId));
                }
            }
            Map<Object, Object> courseUserTaskMap = new HashMap();
            if (taskType == 1 || taskType == 5) {
                LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper1.eq(TrainingCourseUserTask::getTaskId, (Object)taskId)).eq(TrainingCourseUserTask::getTurns, (Object)1)).in(TrainingCourseUserTask::getUserId, list);
                List trainingCourseUserTasks = this.courseUserTaskMapper.selectList((Wrapper)wrapper1);
                if (!CollectionUtils.isEmpty((Collection)trainingCourseUserTasks)) {
                    courseUserTaskMap = trainingCourseUserTasks.stream().collect(Collectors.toMap(TrainingCourseUserTask::getUserId, e -> new ArrayList<TrainingCourseUserTask>(Collections.singletonList(e)), (oldList, newList) -> {
                        oldList.addAll(newList);
                        return oldList;
                    }));
                }
            }
            Map<Object, Object> courseUserTasksMap = new HashMap();
            LambdaQueryWrapper wrapper3 = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)wrapper3.eq(TrainingCourseUserTask::getTaskId, (Object)taskId)).in(TrainingCourseUserTask::getUserId, list);
            List trainingCourseUserTasks3 = this.courseUserTaskMapper.selectList((Wrapper)wrapper3);
            if (!CollectionUtils.isEmpty((Collection)trainingCourseUserTasks3)) {
                courseUserTasksMap = trainingCourseUserTasks3.stream().collect(Collectors.toMap(TrainingCourseUserTask::getUserId, e -> new ArrayList<TrainingCourseUserTask>(Collections.singletonList(e)), (oldList, newList) -> {
                    oldList.addAll(newList);
                    return oldList;
                }));
            }
            Map pojoMap = ((List)base.getData()).stream().collect(Collectors.toMap(com.ovopark.organize.common.model.pojo.UsersPojo::getId, Function.identity()));
            Map<Integer, String> userOrganizeMap = this.userUtilService.selectUserOrganizeName(groupId, list);
            Map userRoleMap = new HashMap();
            if (!CollectionUtils.isEmpty(list)) {
                HashMap<String, Object> parameter = new HashMap<String, Object>();
                parameter.put("userIds", StringUtils.join(list, (String)","));
                parameter.put("groupId", groupId);
                BaseResult roleBase = this.roleApi.getUserRoleList(parameter);
                if (roleBase != null) {
                    userRoleMap = (Map)roleBase.getData();
                }
            }
            Map<Integer, UserDutiesMo> dutiesMap = this.userUtilService.selectDutiesMap(list, groupId);
            Map<Integer, String> parentMap = this.userUtilService.selectParentMap(list, groupId);
            Map<Integer, Integer> parentIdMap = this.userUtilService.selectParentIdMap(list, groupId);
            for (TrainingCourseUserTask userTask : userTaskList) {
                TrainingCourseUserTaskVo taskVo = new TrainingCourseUserTaskVo();
                BeanUtils.copyProperties((Object)userTask, (Object)taskVo);
                com.ovopark.organize.common.model.pojo.UsersPojo pojo = (com.ovopark.organize.common.model.pojo.UsersPojo)pojoMap.get(taskVo.getUserId());
                taskVo.setUserName(ObjectUtils.isEmpty((Object)pojo) ? "" : pojo.getShowName());
                taskVo.setUserAccount(ObjectUtils.isEmpty((Object)pojo) ? "" : pojo.getUserName());
                taskVo.setEmployeeNumber(ObjectUtils.isEmpty((Object)pojo) ? "" : pojo.getEmployeeNumber());
                taskVo.setOrganizeName(userOrganizeMap.get(taskVo.getUserId()));
                List userTaskList1 = (List)courseUserTasksMap.get(taskVo.getUserId());
                taskVo.setLearnCount(Integer.valueOf(0));
                if (!CollectionUtils.isEmpty((Collection)userTaskList1)) {
                    taskVo.setLearnCount(Integer.valueOf(userTaskList1.size()));
                }
                if (taskVo.getTaskStatus() != null && taskVo.getTaskStatus() == 1 && taskVo.getTurns() > 1 && taskVo.getLearnCount() > 0 && taskType != 6) {
                    taskVo.setTaskStatus(Integer.valueOf(2));
                }
                if (taskType == 1 || taskType == 5) {
                    List userTaskLists1;
                    if ((taskVo.getTurns() > 1 || !org.springframework.util.StringUtils.isEmpty((Object)status) && status == 2) && !CollectionUtils.isEmpty((Collection)(userTaskLists1 = (List)courseUserTaskMap.get(taskVo.getUserId())))) {
                        taskVo.setStartTime(((TrainingCourseUserTask)userTaskLists1.get(0)).getStartTime());
                    }
                    List timeVoList = (List)viewTimeMap.get(taskVo.getUserId());
                    Integer times = 0;
                    if (!CollectionUtils.isEmpty((Collection)timeVoList)) {
                        for (TrainingUserViewTimeVo vo : timeVoList) {
                            if (taskVo.getTurns().intValue() != vo.getTurns().intValue()) continue;
                            times = vo.getViewTimes();
                        }
                    }
                    List timeVoTypeList = (List)viewTimeTypeMap.get(taskVo.getUserId());
                    int totalTimes = 0;
                    if (!CollectionUtils.isEmpty((Collection)timeVoTypeList)) {
                        for (TrainingUserViewTimeVo vo : timeVoTypeList) {
                            if (org.springframework.util.StringUtils.isEmpty((Object)vo.getViewTimes())) continue;
                            totalTimes += vo.getViewTimes().intValue();
                        }
                    }
                    String timeStr = "00:00:00";
                    if (totalTimes != 0) {
                        timeStr = DateUtils.getUseTimeFormal(totalTimes);
                    }
                    taskVo.setTimeStr(timeStr);
                    if (taskVo.getTaskStatus() != 3 && taskVo.getTaskStatus() != 4) {
                        taskVo.setEndTime(null);
                    }
                    if (taskType == 5) {
                        BigDecimal finishTime = BigDecimal.ZERO;
                        if (material.getIsVideo() == 1) {
                            finishTime = new BigDecimal(material.getDuration());
                            if (!org.springframework.util.StringUtils.isEmpty((Object)material.getFinishRate())) {
                                finishTime = finishTime.multiply(material.getFinishRate()).divide(new BigDecimal("100"), 0, 1);
                            }
                        } else if (material.getFinishTime() != null) {
                            finishTime = new BigDecimal(material.getFinishTime());
                        }
                        BigDecimal rate = BigDecimal.ZERO;
                        if (finishTime.compareTo(BigDecimal.ZERO) > 0 && taskVo.getTaskStatus() != 1) {
                            rate = new BigDecimal(times).divide(finishTime, 2, 1);
                        }
                        taskVo.setReadRate(taskVo.getTaskStatus() == 3 || taskVo.getTaskStatus() == 4 ? new BigDecimal("100") : rate.multiply(new BigDecimal("100")));
                    }
                } else if (taskType == 2) {
                    if (taskVo.getTaskStatus() != 1) {
                        TrainingPaperTurns paperTurns = (TrainingPaperTurns)paperTurnsMap.get(taskVo.getTurns());
                        Integer paperId = stageTask.getPaperId();
                        TrainingPaper trainingPaper = (TrainingPaper)this.trainingPaperMapper.selectById(paperId);
                        if (!org.springframework.util.StringUtils.isEmpty((Object)paperTurns)) {
                            paperId = paperTurns.getPaperId();
                        }
                        List userPaperList = (List)paperMap.get(taskVo.getUserId());
                        int paperCount = 0;
                        if (!CollectionUtils.isEmpty((Collection)userPaperList)) {
                            paperCount = userPaperList.size();
                            ArrayList<TrainingUserPaper> userPapers = new ArrayList<TrainingUserPaper>();
                            for (TrainingUserPaper paper : userPaperList) {
                                if (paper.getTrainingPaperId().toString().equals(paperId.toString())) continue;
                                userPapers.add(paper);
                            }
                            if (!CollectionUtils.isEmpty(userPapers)) {
                                userPaperList.removeAll(userPapers);
                            }
                            if (!CollectionUtils.isEmpty((Collection)userPaperList)) {
                                double topScore = 0.0;
                                TrainingUserPaper topPaper = null;
                                TrainingUserPaper newPaper = null;
                                for (TrainingUserPaper paper : userPaperList) {
                                    if (!paper.getPaperStatus().equals(2)) continue;
                                    if (topScore <= paper.getScore().doubleValue()) {
                                        topScore = paper.getScore().doubleValue();
                                        topPaper = paper;
                                    }
                                    if (newPaper != null) continue;
                                    newPaper = paper;
                                }
                                if (taskVo.getTaskStatus() == 3 || taskVo.getTaskStatus() == 4 || taskVo.getTaskStatus() == 5) {
                                    if (trainingPaper.getScoreSelect() == null || trainingPaper.getScoreSelect() != null && trainingPaper.getScoreSelect().equals(1)) {
                                        taskVo.setScore(newPaper.getScore());
                                    } else if (trainingPaper.getScoreSelect() != null && trainingPaper.getScoreSelect().equals(0)) {
                                        taskVo.setScore(topPaper.getScore());
                                    }
                                } else {
                                    taskVo.setScore(new BigDecimal(-1));
                                }
                                int totalTime = 0;
                                for (TrainingUserPaper userPaper : userPaperList) {
                                    if (org.springframework.util.StringUtils.isEmpty((Object)userPaper.getSubmitTime()) || org.springframework.util.StringUtils.isEmpty((Object)userPaper.getUpdateTime())) continue;
                                    totalTime += (int)((userPaper.getSubmitTime().getTime() - userPaper.getUpdateTime().getTime()) / 1000L);
                                }
                                taskVo.setTimeStr(DateUtils.getUseTimeFormal(totalTime /= paperCount));
                            }
                        }
                        taskVo.setPaperCount(Integer.valueOf(paperCount));
                    }
                } else if (taskType == 6) {
                    Integer answerCount = 0;
                    List trainingWorkUserAnswerList = (List)trainingWorkUserAnswerMap.get(taskVo.getUserId());
                    if (!CollectionUtils.isEmpty((Collection)trainingWorkUserAnswerList)) {
                        answerCount = trainingWorkUserAnswerList.size();
                        for (TrainingWorkUserAnswer trainingWorkUserAnswer : trainingWorkUserAnswerList) {
                            if (trainingWorkUserAnswer.getIsLast() == null || trainingWorkUserAnswer.getIsLast() != 1 || taskVo.getTurns() != trainingWorkUserAnswer.getTurns()) continue;
                            taskVo.setScore(trainingWorkUserAnswer.getScore());
                            taskVo.setCommitTime(trainingWorkUserAnswer.getCommitTime());
                            break;
                        }
                    }
                    taskVo.setAnswerCount(answerCount);
                }
                if (!CollectionUtils.isEmpty((Collection)((Collection)userRoleMap.get(taskVo.getUserId())))) {
                    StringBuilder role = new StringBuilder();
                    for (RolePojo rolePojo : (List)userRoleMap.get(taskVo.getUserId())) {
                        role.append(rolePojo.getRoleName()).append(";\n");
                    }
                    taskVo.setRole(role.substring(0, role.length() - 2));
                }
                if (!CollectionUtils.isEmpty(dutiesMap) && dutiesMap.get(taskVo.getUserId()) != null) {
                    taskVo.setPost(dutiesMap.get(taskVo.getUserId()).getDutieName());
                }
                if (!CollectionUtils.isEmpty(parentMap)) {
                    taskVo.setParentName(parentMap.get(taskVo.getUserId()));
                }
                if (!CollectionUtils.isEmpty(parentIdMap)) {
                    taskVo.setParentUserId(parentIdMap.get(taskVo.getUserId()));
                }
                userTaskVos.add(taskVo);
            }
        }
        return userTaskVos;
    }

    @Override
    public Page<TrainingCourseUserTaskVo> selectCourseTrainingByPage2(Page<TrainingCourseUserTaskVo> page, Integer taskId, String name, Integer status, Users user) {
        List<Integer> userIds;
        com.ovopark.organize.common.base.BaseResult base;
        TrainingCourseStageTask stageTask = (TrainingCourseStageTask)this.courseStageTaskMapper.selectById(taskId);
        Integer taskType = stageTask.getTaskType();
        TrainingCourse course = (TrainingCourse)this.courseMapper.selectById(stageTask.getCourseId());
        List<Object> allUserIdList = new ArrayList();
        if (!org.springframework.util.StringUtils.isEmpty((Object)course.getAppointType()) && course.getAppointType() == 1) {
            LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)wrapper1.eq(TrainingCourseUser::getCourseId, (Object)course.getId())).eq(TrainingCourseUser::getCourseType, (Object)1);
            List courseUserList = this.courseUserMapper.selectList((Wrapper)wrapper1);
            if (!CollectionUtils.isEmpty((Collection)courseUserList)) {
                com.ovopark.organize.common.base.BaseResult simplePojoBaseResult;
                List tagIds;
                List list;
                DepAndTagsPojo pojo;
                String string;
                BaseResult baseResult;
                List roleIds;
                List userIds2 = courseUserList.stream().map(TrainingCourseUser::getUserId).distinct().filter(Objects::nonNull).collect(Collectors.toList());
                if (!CollectionUtils.isEmpty(userIds2)) {
                    allUserIdList.addAll(userIds2);
                }
                if (!CollectionUtils.isEmpty(roleIds = courseUserList.stream().map(TrainingCourseUser::getRoleId).filter(Objects::nonNull).distinct().collect(Collectors.toList())) && (baseResult = this.useApi.getUserByRoleIds(string = StringUtils.join(roleIds, (String)","), user.getGroupId())) != null && !CollectionUtils.isEmpty((Collection)((Collection)baseResult.getData()))) {
                    pojo = ((List)baseResult.getData()).stream().map(UsersPojo::getId).distinct().collect(Collectors.toList());
                    allUserIdList.addAll((Collection<Object>)pojo);
                }
                if (!CollectionUtils.isEmpty(list = courseUserList.stream().map(TrainingCourseUser::getOrganizeId).filter(Objects::nonNull).distinct().collect(Collectors.toList()))) {
                    UsersAndOrgsMo mo = new UsersAndOrgsMo();
                    mo.setGroupId(user.getGroupId());
                    mo.setOrganizeIds(list);
                    com.ovopark.organize.common.base.BaseResult userResult = this.userOrganizeApi.getUserByOrganizeIdsOrDepId(mo);
                    if (!userResult.getIsError().booleanValue() && !CollectionUtils.isEmpty((Collection)((Collection)userResult.getData()))) {
                        List users = ((List)userResult.getData()).stream().map(UserAndParentNameMo::getUserId).distinct().collect(Collectors.toList());
                        allUserIdList.addAll(users);
                    }
                }
                if (!CollectionUtils.isEmpty(tagIds = courseUserList.stream().map(TrainingCourseUser::getTagId).filter(Objects::nonNull).distinct().collect(Collectors.toList()))) {
                    pojo = new DepAndTagsPojo();
                    pojo.setGroupId(user.getGroupId());
                    pojo.setTagIds(tagIds);
                    pojo.setUserId(user.getId());
                    com.ovopark.organize.common.base.BaseResult tagResult = this.tagApi.getUsersByTags(pojo);
                    if (!tagResult.getIsError().booleanValue() && !CollectionUtils.isEmpty((Collection)((Collection)tagResult.getData()))) {
                        for (Map map : (List)tagResult.getData()) {
                            Integer id = (Integer)map.get("id");
                            allUserIdList.add(id);
                        }
                    }
                }
                allUserIdList = allUserIdList.stream().distinct().collect(Collectors.toList());
                if (course.getStatus() != 3 && !Objects.isNull(simplePojoBaseResult = this.userApi.getSimpleUserByKeyWord(user.getGroupId(), null, null)) && !CollectionUtils.isEmpty((Collection)((Collection)simplePojoBaseResult.getData()))) {
                    allUserIdList.retainAll(((List)simplePojoBaseResult.getData()).stream().map(SimplePojo::getId).distinct().collect(Collectors.toList()));
                }
            }
        } else {
            List base2 = (List)this.userApi.getSimpleUserByKeyWord(user.getGroupId(), null, null).getData();
            allUserIdList = base2.stream().map(SimplePojo::getId).collect(Collectors.toList());
        }
        if (!CollectionUtils.isEmpty(allUserIdList)) {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            com.ovopark.organize.common.base.BaseResult base3 = this.userApi.getUserGtCreateTime(course.getEnterpriseId(), format.format(course.getEndTime()));
            if (base3 != null && !CollectionUtils.isEmpty((Collection)((Collection)base3.getData()))) {
                List userRemoveList = (List)base3.getData();
                allUserIdList.removeAll(userRemoveList);
            }
        }
        if (!org.springframework.util.StringUtils.isEmpty((Object)name)) {
            com.ovopark.organize.common.base.BaseResult base2 = this.userApi.getSimpleUserByKeyWord(user.getGroupId(), name, null);
            if (base2 != null) {
                List userIdList = ((List)base2.getData()).stream().map(SimplePojo::getId).collect(Collectors.toList());
                allUserIdList.retainAll(userIdList);
            } else {
                allUserIdList = new ArrayList();
            }
        }
        if (CollectionUtils.isEmpty(allUserIdList)) {
            return page;
        }
        List<TrainingCourseUserTask> userTaskList = new ArrayList();
        LambdaQueryWrapper wrapper2 = new LambdaQueryWrapper();
        if (!org.springframework.util.StringUtils.isEmpty((Object)status)) {
            if (status == 1) {
                wrapper2.ne(TrainingCourseUserTask::getTaskStatus, (Object)1);
            } else if (status == 2) {
                wrapper2.notIn(TrainingCourseUserTask::getTaskStatus, Arrays.asList(1, 2));
            } else {
                wrapper2.in(TrainingCourseUserTask::getTaskStatus, status == 3 ? Arrays.asList(3, 4) : Collections.singletonList(status));
            }
        }
        wrapper2.eq(TrainingCourseUserTask::getTaskId, (Object)taskId);
        if (!CollectionUtils.isEmpty(allUserIdList)) {
            wrapper2.in(TrainingCourseUserTask::getUserId, allUserIdList);
        } else {
            wrapper2.isNull(TrainingCourseUserTask::getUserId);
        }
        wrapper2.orderByDesc(TrainingCourseUserTask::getStartTime);
        userTaskList = this.courseUserTaskMapper.selectList((Wrapper)wrapper2);
        Map<Object, Object> turnMap = new HashMap();
        if (!CollectionUtils.isEmpty(allUserIdList)) {
            LambdaQueryWrapper wrapperU = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapperU.eq(TrainingPaperUserTurns::getProjectId, (Object)stageTask.getCourseId())).eq(TrainingPaperUserTurns::getStageId, (Object)stageTask.getStageId())).eq(TrainingPaperUserTurns::getTurnType, (Object)4)).in(TrainingPaperUserTurns::getUserId, allUserIdList)).orderByDesc(TrainingPaperUserTurns::getTurns);
            List list = this.paperUserTurnsMapper.selectList((Wrapper)wrapperU);
            if (!CollectionUtils.isEmpty((Collection)list)) {
                turnMap = list.stream().collect(Collectors.toMap(TrainingPaperUserTurns::getUserId, e -> new ArrayList<TrainingPaperUserTurns>(Collections.singletonList(e)), (oldList, newList) -> {
                    oldList.addAll(newList);
                    return oldList;
                }));
            }
        }
        if (!CollectionUtils.isEmpty(userTaskList)) {
            ArrayList<TrainingCourseUserTask> delList = new ArrayList<TrainingCourseUserTask>();
            for (TrainingCourseUserTask courseUserTask : userTaskList) {
                List paperUserTurnsList = (List)turnMap.get(courseUserTask.getUserId());
                if (!CollectionUtils.isEmpty((Collection)paperUserTurnsList)) {
                    if (courseUserTask.getTurns().intValue() == ((TrainingPaperUserTurns)paperUserTurnsList.get(0)).getTurns().intValue()) continue;
                    delList.add(courseUserTask);
                    continue;
                }
                if (courseUserTask.getTurns() == 1) continue;
                delList.add(courseUserTask);
            }
            if (!CollectionUtils.isEmpty(delList)) {
                userTaskList.removeAll(delList);
            }
        }
        if (org.springframework.util.StringUtils.isEmpty((Object)status) || status == 1) {
            if (!CollectionUtils.isEmpty(userTaskList)) {
                List userIdList = userTaskList.stream().map(TrainingCourseUserTask::getUserId).distinct().collect(Collectors.toList());
                allUserIdList.removeAll(userIdList);
            }
            if (!CollectionUtils.isEmpty(allUserIdList)) {
                if (!org.springframework.util.StringUtils.isEmpty((Object)status)) {
                    userTaskList = new ArrayList();
                }
                for (Integer n : allUserIdList) {
                    List paperUserTurnsList = (List)turnMap.get(n);
                    TrainingCourseUserTask task = new TrainingCourseUserTask();
                    task.setTaskId(taskId);
                    task.setUserId(n);
                    task.setTaskStatus(Integer.valueOf(1));
                    task.setTurns(Integer.valueOf(!CollectionUtils.isEmpty((Collection)paperUserTurnsList) ? ((TrainingPaperUserTurns)paperUserTurnsList.get(0)).getTurns() : 1));
                    if (!org.springframework.util.StringUtils.isEmpty((Object)status) && status == 1 && task.getTurns() > 1) continue;
                    userTaskList.add(task);
                }
            } else if (!org.springframework.util.StringUtils.isEmpty((Object)status)) {
                userTaskList = new ArrayList();
            }
        }
        if (!org.springframework.util.StringUtils.isEmpty((Object)status) && status == 2) {
            LambdaQueryWrapper wrapper3 = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper3.eq(TrainingCourseUserTask::getTaskId, (Object)taskId)).in(TrainingCourseUserTask::getUserId, allUserIdList)).ne(TrainingCourseUserTask::getTaskStatus, (Object)1);
            List list = this.courseUserTaskMapper.selectList((Wrapper)wrapper3);
            if (!CollectionUtils.isEmpty((Collection)list)) {
                List userAlls = list.stream().map(TrainingCourseUserTask::getUserId).distinct().collect(Collectors.toList());
                if (!CollectionUtils.isEmpty(allUserIdList)) {
                    userAlls.retainAll(allUserIdList);
                    if (!CollectionUtils.isEmpty(userTaskList)) {
                        List userTaskAlls = userTaskList.stream().map(TrainingCourseUserTask::getUserId).distinct().collect(Collectors.toList());
                        userAlls.removeAll(userTaskAlls);
                    }
                    if (!CollectionUtils.isEmpty(userAlls)) {
                        userTaskList = new ArrayList();
                        for (Integer userId : userAlls) {
                            List paperUserTurnsList = (List)turnMap.get(userId);
                            TrainingCourseUserTask task = new TrainingCourseUserTask();
                            task.setTaskId(taskId);
                            task.setUserId(userId);
                            task.setTaskStatus(Integer.valueOf(2));
                            task.setTurns(Integer.valueOf(!CollectionUtils.isEmpty((Collection)paperUserTurnsList) ? ((TrainingPaperUserTurns)paperUserTurnsList.get(0)).getTurns() : 1));
                            userTaskList.add(task);
                        }
                    } else {
                        userTaskList = new ArrayList();
                    }
                } else {
                    userTaskList = new ArrayList();
                }
            } else {
                userTaskList = new ArrayList();
            }
        }
        ArrayList<TrainingCourseUserTaskVo> result = new ArrayList<TrainingCourseUserTaskVo>();
        Page page2 = ListUtil.myPage(userTaskList, page.getPageNumber(), page.getPageSize());
        page.setTotalCount(page2.getTotalCount());
        page.setPageCount(page2.getPageCount());
        List userTasks = page2.getContent();
        if (!CollectionUtils.isEmpty((Collection)userTasks) && (base = this.userApi.getUserByIdList(userIds = userTasks.stream().map(TrainingCourseUserTask::getUserId).distinct().collect(Collectors.toList()))) != null && !CollectionUtils.isEmpty((Collection)((Collection)base.getData()))) {
            List<TrainingUserViewTimeVo> voTypeList;
            List<TrainingUserViewTimeVo> voList;
            Map<Object, Object> paperMap = new HashMap();
            Map<Object, Object> viewTimeMap = new HashMap();
            Map<Object, Object> viewTimeTypeMap = new HashMap();
            Map<Object, Object> paperTurnsMap = new HashMap();
            TrainingMaterial material = new TrainingMaterial();
            Map<Object, Object> trainingWorkUserAnswerMap = new HashMap();
            if (taskType == 1) {
                if (stageTask.getIsProgress() == 1) {
                    voList = this.commonService.selectViewTimeByUserId(0, userIds, null, Collections.singletonList(stageTask.getTrainingId()), null);
                    if (!CollectionUtils.isEmpty(voList)) {
                        viewTimeMap = voList.stream().collect(Collectors.groupingBy(TrainingUserViewTime::getUserId));
                    }
                    if (!CollectionUtils.isEmpty(voTypeList = this.commonService.selectViewTimeByUserId(4, userIds, null, Collections.singletonList(stageTask.getTrainingId()), taskId))) {
                        viewTimeTypeMap = voTypeList.stream().collect(Collectors.groupingBy(TrainingUserViewTime::getUserId));
                    }
                } else {
                    voList = this.commonService.selectViewTimeByUserId(4, userIds, null, Collections.singletonList(stageTask.getTrainingId()), taskId);
                    if (!CollectionUtils.isEmpty(voList)) {
                        viewTimeMap = voList.stream().collect(Collectors.groupingBy(TrainingUserViewTime::getUserId));
                        viewTimeTypeMap = voList.stream().collect(Collectors.groupingBy(TrainingUserViewTime::getUserId));
                    }
                }
            } else if (taskType == 2) {
                LambdaQueryWrapper wrapper4 = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper4.eq(TrainingPaperTurns::getProjectId, (Object)stageTask.getCourseId())).eq(TrainingPaperTurns::getTaskId, (Object)taskId)).eq(TrainingPaperTurns::getTurnType, (Object)4);
                List paperTurnsList = this.paperTurnsMapper.selectList((Wrapper)wrapper4);
                List<Integer> paperTurnsIdList = new ArrayList<Integer>();
                if (!CollectionUtils.isEmpty((Collection)paperTurnsList)) {
                    paperTurnsIdList = paperTurnsList.stream().map(TrainingPaperTurns::getPaperId).distinct().collect(Collectors.toList());
                    paperTurnsMap = paperTurnsList.stream().collect(Collectors.toMap(TrainingPaperTurns::getTurns, Function.identity()));
                }
                paperTurnsIdList.add(stageTask.getPaperId());
                LambdaQueryWrapper wrapper3 = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper3.in(TrainingUserPaper::getTrainingPaperId, paperTurnsIdList)).isNotNull(TrainingUserPaper::getSubmitTime)).in(TrainingUserPaper::getUserId, userIds)).eq(TrainingUserPaper::getSourceType, (Object)5)).eq(TrainingUserPaper::getSourceProjectId, (Object)stageTask.getCourseId())).eq(TrainingUserPaper::getSourceTaskId, (Object)taskId)).orderByDesc(TrainingUserPaper::getSubmitTime);
                List userPaperList = this.trainingUserPaperMapper.selectList((Wrapper)wrapper3);
                if (!CollectionUtils.isEmpty((Collection)userPaperList)) {
                    paperMap = userPaperList.stream().collect(Collectors.groupingBy(TrainingUserPaper::getUserId));
                }
            } else if (taskType == 5) {
                if (stageTask.getIsProgress() == 1) {
                    voList = this.trainingUserViewTimeMapper.selectViewTimeByuserId(0, userIds, Collections.singletonList(stageTask.getMaterialId()), null, null);
                    if (!CollectionUtils.isEmpty(voList)) {
                        viewTimeMap = voList.stream().collect(Collectors.groupingBy(TrainingUserViewTime::getUserId));
                    }
                    if (!CollectionUtils.isEmpty(voTypeList = this.trainingUserViewTimeMapper.selectViewTimeByuserId(4, userIds, Collections.singletonList(stageTask.getMaterialId()), null, taskId))) {
                        viewTimeTypeMap = voTypeList.stream().collect(Collectors.groupingBy(TrainingUserViewTime::getUserId));
                    }
                } else {
                    voList = this.trainingUserViewTimeMapper.selectViewTimeByuserId(4, userIds, Collections.singletonList(stageTask.getMaterialId()), null, taskId);
                    if (!CollectionUtils.isEmpty(voList)) {
                        viewTimeMap = voList.stream().collect(Collectors.groupingBy(TrainingUserViewTime::getUserId));
                        viewTimeTypeMap = voList.stream().collect(Collectors.groupingBy(TrainingUserViewTime::getUserId));
                    }
                }
                material = (TrainingMaterial)this.materialMapper.selectById(stageTask.getMaterialId());
            } else if (taskType == 6) {
                LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper1.eq(TrainingWorkUserAnswer::getWorkId, (Object)stageTask.getWorkId())).eq(TrainingWorkUserAnswer::getSourceType, (Object)5)).eq(TrainingWorkUserAnswer::getSourceTaskId, (Object)stageTask.getId())).ne(TrainingWorkUserAnswer::getStatus, (Object)0)).in(TrainingWorkUserAnswer::getUserId, userIds);
                List list = this.trainingWorkUserAnswerMapper.selectList((Wrapper)wrapper1);
                if (!CollectionUtils.isEmpty((Collection)list)) {
                    trainingWorkUserAnswerMap = list.stream().collect(Collectors.groupingBy(TrainingWorkUserAnswer::getUserId));
                }
            }
            Map<Object, Object> courseUserTaskMap = new HashMap();
            if (taskType == 1 || taskType == 5) {
                LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper1.eq(TrainingCourseUserTask::getTaskId, (Object)taskId)).eq(TrainingCourseUserTask::getTurns, (Object)1)).in(TrainingCourseUserTask::getUserId, userIds);
                List trainingCourseUserTasks = this.courseUserTaskMapper.selectList((Wrapper)wrapper1);
                if (!CollectionUtils.isEmpty((Collection)trainingCourseUserTasks)) {
                    courseUserTaskMap = trainingCourseUserTasks.stream().collect(Collectors.toMap(TrainingCourseUserTask::getUserId, e -> new ArrayList<TrainingCourseUserTask>(Collections.singletonList(e)), (oldList, newList) -> {
                        oldList.addAll(newList);
                        return oldList;
                    }));
                }
            }
            Map<Object, Object> courseUserTasksMap = new HashMap();
            LambdaQueryWrapper wrapper3 = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)wrapper3.eq(TrainingCourseUserTask::getTaskId, (Object)taskId)).in(TrainingCourseUserTask::getUserId, userIds);
            List trainingCourseUserTasks3 = this.courseUserTaskMapper.selectList((Wrapper)wrapper3);
            if (!CollectionUtils.isEmpty((Collection)trainingCourseUserTasks3)) {
                courseUserTasksMap = trainingCourseUserTasks3.stream().collect(Collectors.toMap(TrainingCourseUserTask::getUserId, e -> new ArrayList<TrainingCourseUserTask>(Collections.singletonList(e)), (oldList, newList) -> {
                    oldList.addAll(newList);
                    return oldList;
                }));
            }
            Map pojoMap = ((List)base.getData()).stream().collect(Collectors.toMap(com.ovopark.organize.common.model.pojo.UsersPojo::getId, Function.identity()));
            Map<Integer, String> userOrganizeMap = this.userUtilService.selectUserOrganizeName(user.getGroupId(), userIds);
            for (TrainingCourseUserTask userTask : userTasks) {
                TrainingCourseUserTaskVo taskVo = new TrainingCourseUserTaskVo();
                BeanUtils.copyProperties((Object)userTask, (Object)taskVo);
                com.ovopark.organize.common.model.pojo.UsersPojo pojo = (com.ovopark.organize.common.model.pojo.UsersPojo)pojoMap.get(taskVo.getUserId());
                taskVo.setUserName(ObjectUtils.isEmpty((Object)pojo) ? "" : pojo.getShowName());
                taskVo.setEmployeeNumber(ObjectUtils.isEmpty((Object)pojo) ? "" : pojo.getEmployeeNumber());
                taskVo.setOrganizeName(userOrganizeMap.get(taskVo.getUserId()));
                List userTaskList1 = (List)courseUserTasksMap.get(taskVo.getUserId());
                taskVo.setLearnCount(Integer.valueOf(0));
                if (!CollectionUtils.isEmpty((Collection)userTaskList1)) {
                    taskVo.setLearnCount(Integer.valueOf(userTaskList1.size()));
                }
                if (taskVo.getTaskStatus() != null && taskVo.getTaskStatus() == 1 && taskVo.getTurns() > 1 && taskVo.getLearnCount() > 0 && taskType != 6) {
                    taskVo.setTaskStatus(Integer.valueOf(2));
                }
                if (taskType == 1 || taskType == 5) {
                    List userTaskLists1;
                    if ((taskVo.getTurns() > 1 || !org.springframework.util.StringUtils.isEmpty((Object)status) && status == 2) && !CollectionUtils.isEmpty((Collection)(userTaskLists1 = (List)courseUserTaskMap.get(taskVo.getUserId())))) {
                        taskVo.setStartTime(((TrainingCourseUserTask)userTaskLists1.get(0)).getStartTime());
                    }
                    List timeVoList = (List)viewTimeMap.get(taskVo.getUserId());
                    Integer times = 0;
                    if (!CollectionUtils.isEmpty((Collection)timeVoList)) {
                        for (TrainingUserViewTimeVo vo : timeVoList) {
                            if (taskVo.getTurns().intValue() != vo.getTurns().intValue()) continue;
                            times = vo.getViewTimes();
                        }
                    }
                    List timeVoTypeList = (List)viewTimeTypeMap.get(taskVo.getUserId());
                    int totalTimes = 0;
                    if (!CollectionUtils.isEmpty((Collection)timeVoTypeList)) {
                        for (TrainingUserViewTimeVo vo : timeVoTypeList) {
                            if (org.springframework.util.StringUtils.isEmpty((Object)vo.getViewTimes())) continue;
                            totalTimes += vo.getViewTimes().intValue();
                        }
                    }
                    String timeStr = "00:00:00";
                    if (totalTimes != 0) {
                        timeStr = DateUtils.getUseTimeFormal(totalTimes);
                    }
                    taskVo.setTimeStr(timeStr);
                    if (taskVo.getTaskStatus() != 3 && taskVo.getTaskStatus() != 4) {
                        taskVo.setEndTime(null);
                    }
                    if (taskType == 5) {
                        BigDecimal finishTime = BigDecimal.ZERO;
                        if (material.getIsVideo() == 1) {
                            finishTime = new BigDecimal(material.getDuration());
                            if (!org.springframework.util.StringUtils.isEmpty((Object)material.getFinishRate())) {
                                finishTime = finishTime.multiply(material.getFinishRate()).divide(new BigDecimal("100"), 0, 1);
                            }
                        } else if (material.getFinishTime() != null) {
                            finishTime = new BigDecimal(material.getFinishTime());
                        }
                        BigDecimal rate = BigDecimal.ZERO;
                        if (finishTime.compareTo(BigDecimal.ZERO) > 0 && taskVo.getTaskStatus() != 1) {
                            rate = new BigDecimal(times).divide(finishTime, 2, 1);
                        }
                        taskVo.setReadRate(taskVo.getTaskStatus() == 3 || taskVo.getTaskStatus() == 4 ? new BigDecimal("100") : rate.multiply(new BigDecimal("100")));
                    }
                } else if (taskType == 2) {
                    if (taskVo.getTaskStatus() != 1) {
                        List userPaperList;
                        TrainingExam trainingExam;
                        TrainingPaperTurns paperTurns = (TrainingPaperTurns)paperTurnsMap.get(taskVo.getTurns());
                        Integer paperId = stageTask.getPaperId();
                        TrainingPaper trainingPaper = (TrainingPaper)this.trainingPaperMapper.selectById(paperId);
                        BigDecimal org_score = new BigDecimal("100");
                        if (trainingPaper.getExamId() != null && !ObjectUtils.isEmpty((Object)(trainingExam = (TrainingExam)this.trainingExamMapper.selectById(trainingPaper.getExamId())))) {
                            org_score = trainingExam.getScore();
                        }
                        if (!org.springframework.util.StringUtils.isEmpty((Object)paperTurns)) {
                            paperId = paperTurns.getPaperId();
                        }
                        if (!CollectionUtils.isEmpty((Collection)(userPaperList = (List)paperMap.get(taskVo.getUserId())))) {
                            for (TrainingUserPaper paper : userPaperList) {
                                TrainingCourseUserTaskVo task = new TrainingCourseUserTaskVo();
                                BeanUtils.copyProperties((Object)taskVo, (Object)task);
                                task.setCommitTime(paper.getSubmitTime());
                                task.setTimeStr(DateUtils.getUseTimeFormal(new BigDecimal((paper.getSubmitTime().getTime() - paper.getUpdateTime().getTime()) / 1000L).intValue()));
                                if (Objects.nonNull(paper.getUpdateTime()) && paper.getPaperStatus() == 0) {
                                    task.setTaskStatus(Integer.valueOf(2));
                                    task.setScore(new BigDecimal(-2));
                                } else if (Objects.nonNull(paper.getUpdateTime()) && paper.getPaperStatus() == 1) {
                                    task.setTaskStatus(Integer.valueOf(5));
                                    task.setScore(new BigDecimal(-1));
                                } else {
                                    task.setTaskStatus(Integer.valueOf(this.isPass(org_score, paper.getScore(), trainingPaper.getPassLine())));
                                    task.setScore(paper.getScore());
                                }
                                result.add(task);
                            }
                            continue;
                        }
                    }
                } else if (taskType == 6) {
                    Integer answerCount = 0;
                    List trainingWorkUserAnswerList = (List)trainingWorkUserAnswerMap.get(taskVo.getUserId());
                    if (!CollectionUtils.isEmpty((Collection)trainingWorkUserAnswerList)) {
                        answerCount = trainingWorkUserAnswerList.size();
                        for (TrainingWorkUserAnswer trainingWorkUserAnswer : trainingWorkUserAnswerList) {
                            if (trainingWorkUserAnswer.getIsLast() == null || trainingWorkUserAnswer.getIsLast() != 1 || taskVo.getTurns() != trainingWorkUserAnswer.getTurns()) continue;
                            taskVo.setScore(trainingWorkUserAnswer.getScore());
                            taskVo.setCommitTime(trainingWorkUserAnswer.getCommitTime());
                            break;
                        }
                    }
                    taskVo.setAnswerCount(answerCount);
                }
                result.add(taskVo);
            }
        }
        page.setContent(result);
        return page;
    }

    @Override
    public List<TrainingCourseUserTaskVo> getCourseTrainingList2(Integer taskId, String name, Integer status, Integer groupId, Integer userId) {
        List<Integer> list;
        com.ovopark.organize.common.base.BaseResult base;
        TrainingCourseStageTask stageTask = (TrainingCourseStageTask)this.courseStageTaskMapper.selectById(taskId);
        Integer taskType = stageTask.getTaskType();
        TrainingCourse course = (TrainingCourse)this.courseMapper.selectById(stageTask.getCourseId());
        List<Object> allUserIdList = new ArrayList();
        if (!org.springframework.util.StringUtils.isEmpty((Object)course.getAppointType()) && course.getAppointType() == 1) {
            LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)wrapper1.eq(TrainingCourseUser::getCourseId, (Object)course.getId())).eq(TrainingCourseUser::getCourseType, (Object)1);
            List courseUserList = this.courseUserMapper.selectList((Wrapper)wrapper1);
            if (!CollectionUtils.isEmpty((Collection)courseUserList)) {
                com.ovopark.organize.common.base.BaseResult simplePojoBaseResult;
                List tagIds;
                List orgIds;
                DepAndTagsPojo pojo;
                String roleIdStr;
                BaseResult baseResult;
                List roleIds;
                List userIds2 = courseUserList.stream().map(TrainingCourseUser::getUserId).distinct().filter(Objects::nonNull).collect(Collectors.toList());
                if (!CollectionUtils.isEmpty(userIds2)) {
                    allUserIdList.addAll(userIds2);
                }
                if (!CollectionUtils.isEmpty(roleIds = courseUserList.stream().map(TrainingCourseUser::getRoleId).filter(Objects::nonNull).distinct().collect(Collectors.toList())) && (baseResult = this.useApi.getUserByRoleIds(roleIdStr = StringUtils.join(roleIds, (String)","), groupId)) != null && !CollectionUtils.isEmpty((Collection)((Collection)baseResult.getData()))) {
                    pojo = ((List)baseResult.getData()).stream().map(UsersPojo::getId).distinct().collect(Collectors.toList());
                    allUserIdList.addAll((Collection<Object>)pojo);
                }
                if (!CollectionUtils.isEmpty(orgIds = courseUserList.stream().map(TrainingCourseUser::getOrganizeId).filter(Objects::nonNull).distinct().collect(Collectors.toList()))) {
                    UsersAndOrgsMo mo = new UsersAndOrgsMo();
                    mo.setGroupId(groupId);
                    mo.setOrganizeIds(orgIds);
                    com.ovopark.organize.common.base.BaseResult userResult = this.userOrganizeApi.getUserByOrganizeIdsOrDepId(mo);
                    if (!userResult.getIsError().booleanValue() && !CollectionUtils.isEmpty((Collection)((Collection)userResult.getData()))) {
                        List users = ((List)userResult.getData()).stream().map(UserAndParentNameMo::getUserId).distinct().collect(Collectors.toList());
                        allUserIdList.addAll(users);
                    }
                }
                if (!CollectionUtils.isEmpty(tagIds = courseUserList.stream().map(TrainingCourseUser::getTagId).filter(Objects::nonNull).distinct().collect(Collectors.toList()))) {
                    pojo = new DepAndTagsPojo();
                    pojo.setGroupId(groupId);
                    pojo.setTagIds(tagIds);
                    pojo.setUserId(userId);
                    com.ovopark.organize.common.base.BaseResult tagResult = this.tagApi.getUsersByTags(pojo);
                    if (!tagResult.getIsError().booleanValue() && !CollectionUtils.isEmpty((Collection)((Collection)tagResult.getData()))) {
                        for (Map map : (List)tagResult.getData()) {
                            Integer id = (Integer)map.get("id");
                            allUserIdList.add(id);
                        }
                    }
                }
                allUserIdList = allUserIdList.stream().distinct().collect(Collectors.toList());
                if (course.getStatus() != 3 && !Objects.isNull(simplePojoBaseResult = this.userApi.getSimpleUserByKeyWord(groupId, null, null)) && !CollectionUtils.isEmpty((Collection)((Collection)simplePojoBaseResult.getData()))) {
                    allUserIdList.retainAll(((List)simplePojoBaseResult.getData()).stream().map(SimplePojo::getId).distinct().collect(Collectors.toList()));
                }
            }
        } else {
            List base2 = (List)this.userApi.getSimpleUserByKeyWord(groupId, null, null).getData();
            allUserIdList = base2.stream().map(SimplePojo::getId).collect(Collectors.toList());
        }
        if (!CollectionUtils.isEmpty(allUserIdList)) {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            com.ovopark.organize.common.base.BaseResult base3 = this.userApi.getUserGtCreateTime(course.getEnterpriseId(), format.format(course.getEndTime()));
            if (base3 != null && !CollectionUtils.isEmpty((Collection)((Collection)base3.getData()))) {
                List userRemoveList = (List)base3.getData();
                allUserIdList.removeAll(userRemoveList);
            }
        }
        if (!org.springframework.util.StringUtils.isEmpty((Object)name)) {
            com.ovopark.organize.common.base.BaseResult base2 = this.userApi.getSimpleUserByKeyWord(groupId, name, null);
            if (base2 != null) {
                List userIdList = ((List)base2.getData()).stream().map(SimplePojo::getId).collect(Collectors.toList());
                allUserIdList.retainAll(userIdList);
            } else {
                allUserIdList = new ArrayList();
            }
        }
        if (CollectionUtils.isEmpty(allUserIdList)) {
            return null;
        }
        List<TrainingCourseUserTask> userTaskList = new ArrayList();
        LambdaQueryWrapper wrapper2 = new LambdaQueryWrapper();
        if (!org.springframework.util.StringUtils.isEmpty((Object)status)) {
            if (status == 1) {
                wrapper2.ne(TrainingCourseUserTask::getTaskStatus, (Object)1);
            } else if (status == 2) {
                wrapper2.notIn(TrainingCourseUserTask::getTaskStatus, Arrays.asList(1, 2));
            } else {
                wrapper2.in(TrainingCourseUserTask::getTaskStatus, status == 3 ? Arrays.asList(3, 4) : Collections.singletonList(status));
            }
        }
        wrapper2.eq(TrainingCourseUserTask::getTaskId, (Object)taskId);
        if (!CollectionUtils.isEmpty(allUserIdList)) {
            wrapper2.in(TrainingCourseUserTask::getUserId, allUserIdList);
        } else {
            wrapper2.isNull(TrainingCourseUserTask::getUserId);
        }
        wrapper2.orderByDesc(TrainingCourseUserTask::getStartTime);
        userTaskList = this.courseUserTaskMapper.selectList((Wrapper)wrapper2);
        Map<Object, Object> turnMap = new HashMap();
        if (!CollectionUtils.isEmpty(allUserIdList)) {
            LambdaQueryWrapper wrapperU = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapperU.eq(TrainingPaperUserTurns::getProjectId, (Object)stageTask.getCourseId())).eq(TrainingPaperUserTurns::getStageId, (Object)stageTask.getStageId())).eq(TrainingPaperUserTurns::getTurnType, (Object)4)).in(TrainingPaperUserTurns::getUserId, allUserIdList)).orderByDesc(TrainingPaperUserTurns::getTurns);
            List paperUserTurns = this.paperUserTurnsMapper.selectList((Wrapper)wrapperU);
            if (!CollectionUtils.isEmpty((Collection)paperUserTurns)) {
                turnMap = paperUserTurns.stream().collect(Collectors.toMap(TrainingPaperUserTurns::getUserId, e -> new ArrayList<TrainingPaperUserTurns>(Collections.singletonList(e)), (oldList, newList) -> {
                    oldList.addAll(newList);
                    return oldList;
                }));
            }
        }
        Map userRoleMap = new HashMap();
        if (!CollectionUtils.isEmpty(allUserIdList)) {
            HashMap<String, Object> parameter = new HashMap<String, Object>();
            parameter.put("userIds", StringUtils.join(allUserIdList, (String)","));
            parameter.put("groupId", groupId);
            BaseResult roleBase = this.roleApi.getUserRoleList(parameter);
            if (roleBase != null) {
                userRoleMap = (Map)roleBase.getData();
            }
        }
        Map<Integer, UserDutiesMo> dutiesMap = this.userUtilService.selectDutiesMap(allUserIdList, groupId);
        Map<Integer, String> parentMap = this.userUtilService.selectParentMap(allUserIdList, groupId);
        Map<Integer, Integer> parentIdMap = this.userUtilService.selectParentIdMap(allUserIdList, groupId);
        if (!CollectionUtils.isEmpty(userTaskList)) {
            ArrayList<TrainingCourseUserTask> delList = new ArrayList<TrainingCourseUserTask>();
            for (TrainingCourseUserTask courseUserTask : userTaskList) {
                List paperUserTurnsList = (List)turnMap.get(courseUserTask.getUserId());
                if (!CollectionUtils.isEmpty((Collection)paperUserTurnsList)) {
                    if (courseUserTask.getTurns().intValue() == ((TrainingPaperUserTurns)paperUserTurnsList.get(0)).getTurns().intValue()) continue;
                    delList.add(courseUserTask);
                    continue;
                }
                if (courseUserTask.getTurns() == 1) continue;
                delList.add(courseUserTask);
            }
            if (!CollectionUtils.isEmpty(delList)) {
                userTaskList.removeAll(delList);
            }
        }
        if (org.springframework.util.StringUtils.isEmpty((Object)status) || status == 1) {
            if (!CollectionUtils.isEmpty(userTaskList)) {
                List userIdList = userTaskList.stream().map(TrainingCourseUserTask::getUserId).distinct().collect(Collectors.toList());
                allUserIdList.removeAll(userIdList);
            }
            if (!CollectionUtils.isEmpty(allUserIdList)) {
                if (!org.springframework.util.StringUtils.isEmpty((Object)status)) {
                    userTaskList = new ArrayList();
                }
                for (Integer n : allUserIdList) {
                    List paperUserTurnsList = (List)turnMap.get(n);
                    TrainingCourseUserTask task = new TrainingCourseUserTask();
                    task.setTaskId(taskId);
                    task.setUserId(n);
                    task.setTaskStatus(Integer.valueOf(1));
                    task.setTurns(Integer.valueOf(!CollectionUtils.isEmpty((Collection)paperUserTurnsList) ? ((TrainingPaperUserTurns)paperUserTurnsList.get(0)).getTurns() : 1));
                    if (!org.springframework.util.StringUtils.isEmpty((Object)status) && status == 1 && task.getTurns() > 1) continue;
                    userTaskList.add(task);
                }
            } else if (!org.springframework.util.StringUtils.isEmpty((Object)status)) {
                userTaskList = new ArrayList();
            }
        }
        if (!org.springframework.util.StringUtils.isEmpty((Object)status) && status == 2) {
            LambdaQueryWrapper wrapper3 = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper3.eq(TrainingCourseUserTask::getTaskId, (Object)taskId)).in(TrainingCourseUserTask::getUserId, allUserIdList)).ne(TrainingCourseUserTask::getTaskStatus, (Object)1);
            List list2 = this.courseUserTaskMapper.selectList((Wrapper)wrapper3);
            if (!CollectionUtils.isEmpty((Collection)list2)) {
                List userAlls = list2.stream().map(TrainingCourseUserTask::getUserId).distinct().collect(Collectors.toList());
                if (!CollectionUtils.isEmpty(allUserIdList)) {
                    userAlls.retainAll(allUserIdList);
                    if (!CollectionUtils.isEmpty(userTaskList)) {
                        List userTaskAlls = userTaskList.stream().map(TrainingCourseUserTask::getUserId).distinct().collect(Collectors.toList());
                        userAlls.removeAll(userTaskAlls);
                    }
                    if (!CollectionUtils.isEmpty(userAlls)) {
                        userTaskList = new ArrayList();
                        for (Integer id : userAlls) {
                            List paperUserTurnsList = (List)turnMap.get(id);
                            TrainingCourseUserTask task = new TrainingCourseUserTask();
                            task.setTaskId(taskId);
                            task.setUserId(id);
                            task.setTaskStatus(Integer.valueOf(2));
                            task.setTurns(Integer.valueOf(!CollectionUtils.isEmpty((Collection)paperUserTurnsList) ? ((TrainingPaperUserTurns)paperUserTurnsList.get(0)).getTurns() : 1));
                            userTaskList.add(task);
                        }
                    } else {
                        userTaskList = new ArrayList();
                    }
                } else {
                    userTaskList = new ArrayList();
                }
            } else {
                userTaskList = new ArrayList();
            }
        }
        ArrayList<TrainingCourseUserTaskVo> result = new ArrayList<TrainingCourseUserTaskVo>();
        if (!CollectionUtils.isEmpty(userTaskList) && (base = this.userApi.getUserByIdList(list = userTaskList.stream().map(TrainingCourseUserTask::getUserId).distinct().collect(Collectors.toList()))) != null && !CollectionUtils.isEmpty((Collection)((Collection)base.getData()))) {
            List<TrainingUserViewTimeVo> voTypeList;
            List<TrainingUserViewTimeVo> voList;
            Map<Object, Object> paperMap = new HashMap();
            Map<Object, Object> viewTimeMap = new HashMap();
            Map<Object, Object> viewTimeTypeMap = new HashMap();
            Map<Object, Object> paperTurnsMap = new HashMap();
            TrainingMaterial material = new TrainingMaterial();
            Map<Object, Object> trainingWorkUserAnswerMap = new HashMap();
            if (taskType == 1) {
                if (stageTask.getIsProgress() == 1) {
                    voList = this.commonService.selectViewTimeByUserId(0, list, null, Collections.singletonList(stageTask.getTrainingId()), null);
                    if (!CollectionUtils.isEmpty(voList)) {
                        viewTimeMap = voList.stream().collect(Collectors.groupingBy(TrainingUserViewTime::getUserId));
                    }
                    if (!CollectionUtils.isEmpty(voTypeList = this.commonService.selectViewTimeByUserId(4, list, null, Collections.singletonList(stageTask.getTrainingId()), taskId))) {
                        viewTimeTypeMap = voTypeList.stream().collect(Collectors.groupingBy(TrainingUserViewTime::getUserId));
                    }
                } else {
                    voList = this.commonService.selectViewTimeByUserId(4, list, null, Collections.singletonList(stageTask.getTrainingId()), taskId);
                    if (!CollectionUtils.isEmpty(voList)) {
                        viewTimeMap = voList.stream().collect(Collectors.groupingBy(TrainingUserViewTime::getUserId));
                        viewTimeTypeMap = voList.stream().collect(Collectors.groupingBy(TrainingUserViewTime::getUserId));
                    }
                }
            } else if (taskType == 2) {
                LambdaQueryWrapper wrapper4 = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper4.eq(TrainingPaperTurns::getProjectId, (Object)stageTask.getCourseId())).eq(TrainingPaperTurns::getTaskId, (Object)taskId)).eq(TrainingPaperTurns::getTurnType, (Object)4);
                List paperTurnsList = this.paperTurnsMapper.selectList((Wrapper)wrapper4);
                List<Integer> paperTurnsIdList = new ArrayList<Integer>();
                if (!CollectionUtils.isEmpty((Collection)paperTurnsList)) {
                    paperTurnsIdList = paperTurnsList.stream().map(TrainingPaperTurns::getPaperId).distinct().collect(Collectors.toList());
                    paperTurnsMap = paperTurnsList.stream().collect(Collectors.toMap(TrainingPaperTurns::getTurns, Function.identity()));
                }
                paperTurnsIdList.add(stageTask.getPaperId());
                LambdaQueryWrapper wrapper3 = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper3.in(TrainingUserPaper::getTrainingPaperId, paperTurnsIdList)).isNotNull(TrainingUserPaper::getSubmitTime)).in(TrainingUserPaper::getUserId, list)).eq(TrainingUserPaper::getSourceType, (Object)5)).eq(TrainingUserPaper::getSourceProjectId, (Object)stageTask.getCourseId())).eq(TrainingUserPaper::getSourceTaskId, (Object)taskId)).orderByDesc(TrainingUserPaper::getSubmitTime);
                List userPaperList = this.trainingUserPaperMapper.selectList((Wrapper)wrapper3);
                if (!CollectionUtils.isEmpty((Collection)userPaperList)) {
                    paperMap = userPaperList.stream().collect(Collectors.groupingBy(TrainingUserPaper::getUserId));
                }
            } else if (taskType == 5) {
                if (stageTask.getIsProgress() == 1) {
                    voList = this.trainingUserViewTimeMapper.selectViewTimeByuserId(0, list, Collections.singletonList(stageTask.getMaterialId()), null, null);
                    if (!CollectionUtils.isEmpty(voList)) {
                        viewTimeMap = voList.stream().collect(Collectors.groupingBy(TrainingUserViewTime::getUserId));
                    }
                    if (!CollectionUtils.isEmpty(voTypeList = this.trainingUserViewTimeMapper.selectViewTimeByuserId(4, list, Collections.singletonList(stageTask.getMaterialId()), null, taskId))) {
                        viewTimeTypeMap = voTypeList.stream().collect(Collectors.groupingBy(TrainingUserViewTime::getUserId));
                    }
                } else {
                    voList = this.trainingUserViewTimeMapper.selectViewTimeByuserId(4, list, Collections.singletonList(stageTask.getMaterialId()), null, taskId);
                    if (!CollectionUtils.isEmpty(voList)) {
                        viewTimeMap = voList.stream().collect(Collectors.groupingBy(TrainingUserViewTime::getUserId));
                        viewTimeTypeMap = voList.stream().collect(Collectors.groupingBy(TrainingUserViewTime::getUserId));
                    }
                }
                material = (TrainingMaterial)this.materialMapper.selectById(stageTask.getMaterialId());
            } else if (taskType == 6) {
                LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper1.eq(TrainingWorkUserAnswer::getWorkId, (Object)stageTask.getWorkId())).eq(TrainingWorkUserAnswer::getSourceType, (Object)5)).eq(TrainingWorkUserAnswer::getSourceTaskId, (Object)stageTask.getId())).ne(TrainingWorkUserAnswer::getStatus, (Object)0)).in(TrainingWorkUserAnswer::getUserId, list);
                List list3 = this.trainingWorkUserAnswerMapper.selectList((Wrapper)wrapper1);
                if (!CollectionUtils.isEmpty((Collection)list3)) {
                    trainingWorkUserAnswerMap = list3.stream().collect(Collectors.groupingBy(TrainingWorkUserAnswer::getUserId));
                }
            }
            Map<Object, Object> courseUserTaskMap = new HashMap();
            if (taskType == 1 || taskType == 5) {
                LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper1.eq(TrainingCourseUserTask::getTaskId, (Object)taskId)).eq(TrainingCourseUserTask::getTurns, (Object)1)).in(TrainingCourseUserTask::getUserId, list);
                List trainingCourseUserTasks = this.courseUserTaskMapper.selectList((Wrapper)wrapper1);
                if (!CollectionUtils.isEmpty((Collection)trainingCourseUserTasks)) {
                    courseUserTaskMap = trainingCourseUserTasks.stream().collect(Collectors.toMap(TrainingCourseUserTask::getUserId, e -> new ArrayList<TrainingCourseUserTask>(Collections.singletonList(e)), (oldList, newList) -> {
                        oldList.addAll(newList);
                        return oldList;
                    }));
                }
            }
            Map<Object, Object> courseUserTasksMap = new HashMap();
            LambdaQueryWrapper wrapper3 = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)wrapper3.eq(TrainingCourseUserTask::getTaskId, (Object)taskId)).in(TrainingCourseUserTask::getUserId, list);
            List trainingCourseUserTasks3 = this.courseUserTaskMapper.selectList((Wrapper)wrapper3);
            if (!CollectionUtils.isEmpty((Collection)trainingCourseUserTasks3)) {
                courseUserTasksMap = trainingCourseUserTasks3.stream().collect(Collectors.toMap(TrainingCourseUserTask::getUserId, e -> new ArrayList<TrainingCourseUserTask>(Collections.singletonList(e)), (oldList, newList) -> {
                    oldList.addAll(newList);
                    return oldList;
                }));
            }
            Map pojoMap = ((List)base.getData()).stream().collect(Collectors.toMap(com.ovopark.organize.common.model.pojo.UsersPojo::getId, Function.identity()));
            Map<Integer, String> userOrganizeMap = this.userUtilService.selectUserOrganizeName(groupId, list);
            for (TrainingCourseUserTask userTask : userTaskList) {
                TrainingCourseUserTaskVo taskVo = new TrainingCourseUserTaskVo();
                BeanUtils.copyProperties((Object)userTask, (Object)taskVo);
                com.ovopark.organize.common.model.pojo.UsersPojo pojo = (com.ovopark.organize.common.model.pojo.UsersPojo)pojoMap.get(taskVo.getUserId());
                taskVo.setUserName(ObjectUtils.isEmpty((Object)pojo) ? "" : pojo.getShowName());
                taskVo.setUserAccount(ObjectUtils.isEmpty((Object)pojo) ? "" : pojo.getUserName());
                taskVo.setEmployeeNumber(ObjectUtils.isEmpty((Object)pojo) ? "" : pojo.getEmployeeNumber());
                taskVo.setOrganizeName(userOrganizeMap.get(taskVo.getUserId()));
                if (!CollectionUtils.isEmpty(dutiesMap) && dutiesMap.get(taskVo.getUserId()) != null) {
                    taskVo.setPost(dutiesMap.get(taskVo.getUserId()).getDutieName());
                }
                List userTaskList1 = (List)courseUserTasksMap.get(taskVo.getUserId());
                taskVo.setLearnCount(Integer.valueOf(0));
                if (!CollectionUtils.isEmpty((Collection)userTaskList1)) {
                    taskVo.setLearnCount(Integer.valueOf(userTaskList1.size()));
                }
                if (taskVo.getTaskStatus() != null && taskVo.getTaskStatus() == 1 && taskVo.getTurns() > 1 && taskVo.getLearnCount() > 0 && taskType != 6) {
                    taskVo.setTaskStatus(Integer.valueOf(2));
                }
                if (taskType == 1 || taskType == 5) {
                    List userTaskLists1;
                    if ((taskVo.getTurns() > 1 || !org.springframework.util.StringUtils.isEmpty((Object)status) && status == 2) && !CollectionUtils.isEmpty((Collection)(userTaskLists1 = (List)courseUserTaskMap.get(taskVo.getUserId())))) {
                        taskVo.setStartTime(((TrainingCourseUserTask)userTaskLists1.get(0)).getStartTime());
                    }
                    List timeVoList = (List)viewTimeMap.get(taskVo.getUserId());
                    Integer times = 0;
                    if (!CollectionUtils.isEmpty((Collection)timeVoList)) {
                        for (TrainingUserViewTimeVo vo : timeVoList) {
                            if (taskVo.getTurns().intValue() != vo.getTurns().intValue()) continue;
                            times = vo.getViewTimes();
                        }
                    }
                    List timeVoTypeList = (List)viewTimeTypeMap.get(taskVo.getUserId());
                    int totalTimes = 0;
                    if (!CollectionUtils.isEmpty((Collection)timeVoTypeList)) {
                        for (TrainingUserViewTimeVo vo : timeVoTypeList) {
                            if (org.springframework.util.StringUtils.isEmpty((Object)vo.getViewTimes())) continue;
                            totalTimes += vo.getViewTimes().intValue();
                        }
                    }
                    String timeStr = "00:00:00";
                    if (totalTimes != 0) {
                        timeStr = DateUtils.getUseTimeFormal(totalTimes);
                    }
                    taskVo.setTimeStr(timeStr);
                    if (taskVo.getTaskStatus() != 3 && taskVo.getTaskStatus() != 4) {
                        taskVo.setEndTime(null);
                    }
                    if (taskType == 5) {
                        BigDecimal finishTime = BigDecimal.ZERO;
                        if (material.getIsVideo() == 1) {
                            finishTime = new BigDecimal(material.getDuration());
                            if (!org.springframework.util.StringUtils.isEmpty((Object)material.getFinishRate())) {
                                finishTime = finishTime.multiply(material.getFinishRate()).divide(new BigDecimal("100"), 0, 1);
                            }
                        } else if (material.getFinishTime() != null) {
                            finishTime = new BigDecimal(material.getFinishTime());
                        }
                        BigDecimal rate = BigDecimal.ZERO;
                        if (finishTime.compareTo(BigDecimal.ZERO) > 0 && taskVo.getTaskStatus() != 1) {
                            rate = new BigDecimal(times).divide(finishTime, 2, 1);
                        }
                        taskVo.setReadRate(taskVo.getTaskStatus() == 3 || taskVo.getTaskStatus() == 4 ? new BigDecimal("100") : rate.multiply(new BigDecimal("100")));
                    }
                } else if (taskType == 2) {
                    if (taskVo.getTaskStatus() != 1) {
                        List userPaperList;
                        TrainingExam trainingExam;
                        TrainingPaperTurns paperTurns = (TrainingPaperTurns)paperTurnsMap.get(taskVo.getTurns());
                        Integer paperId = stageTask.getPaperId();
                        TrainingPaper trainingPaper = (TrainingPaper)this.trainingPaperMapper.selectById(paperId);
                        BigDecimal org_score = new BigDecimal("100");
                        if (trainingPaper.getExamId() != null && !ObjectUtils.isEmpty((Object)(trainingExam = (TrainingExam)this.trainingExamMapper.selectById(trainingPaper.getExamId())))) {
                            org_score = trainingExam.getScore();
                        }
                        if (!org.springframework.util.StringUtils.isEmpty((Object)paperTurns)) {
                            paperId = paperTurns.getPaperId();
                        }
                        if (!CollectionUtils.isEmpty((Collection)(userPaperList = (List)paperMap.get(taskVo.getUserId())))) {
                            for (TrainingUserPaper paper : userPaperList) {
                                TrainingCourseUserTaskVo task = new TrainingCourseUserTaskVo();
                                BeanUtils.copyProperties((Object)taskVo, (Object)task);
                                task.setCommitTime(paper.getSubmitTime());
                                task.setTimeStr(DateUtils.getUseTimeFormal(new BigDecimal((paper.getSubmitTime().getTime() - paper.getUpdateTime().getTime()) / 1000L).intValue()));
                                if (Objects.nonNull(paper.getUpdateTime()) && paper.getPaperStatus() == 0) {
                                    task.setTaskStatus(Integer.valueOf(2));
                                    task.setScore(new BigDecimal(-2));
                                } else if (Objects.nonNull(paper.getUpdateTime()) && paper.getPaperStatus() == 1) {
                                    task.setTaskStatus(Integer.valueOf(5));
                                    task.setScore(new BigDecimal(-1));
                                } else {
                                    task.setTaskStatus(Integer.valueOf(this.isPass(org_score, paper.getScore(), trainingPaper.getPassLine())));
                                    task.setScore(paper.getScore());
                                }
                                result.add(task);
                            }
                            continue;
                        }
                    }
                } else if (taskType == 6) {
                    Integer answerCount = 0;
                    List trainingWorkUserAnswerList = (List)trainingWorkUserAnswerMap.get(taskVo.getUserId());
                    if (!CollectionUtils.isEmpty((Collection)trainingWorkUserAnswerList)) {
                        answerCount = trainingWorkUserAnswerList.size();
                        for (TrainingWorkUserAnswer trainingWorkUserAnswer : trainingWorkUserAnswerList) {
                            if (trainingWorkUserAnswer.getIsLast() == null || trainingWorkUserAnswer.getIsLast() != 1 || taskVo.getTurns() != trainingWorkUserAnswer.getTurns()) continue;
                            taskVo.setScore(trainingWorkUserAnswer.getScore());
                            taskVo.setCommitTime(trainingWorkUserAnswer.getCommitTime());
                            break;
                        }
                    }
                    taskVo.setAnswerCount(answerCount);
                }
                if (!CollectionUtils.isEmpty((Collection)((Collection)userRoleMap.get(taskVo.getUserId())))) {
                    StringBuilder role = new StringBuilder();
                    for (RolePojo rolePojo : (List)userRoleMap.get(taskVo.getUserId())) {
                        role.append(rolePojo.getRoleName()).append(";\n");
                    }
                    taskVo.setRole(role.substring(0, role.length() - 2));
                }
                if (!CollectionUtils.isEmpty(dutiesMap) && dutiesMap.get(taskVo.getUserId()) != null) {
                    taskVo.setPost(dutiesMap.get(taskVo.getUserId()).getDutieName());
                }
                if (!CollectionUtils.isEmpty(parentMap)) {
                    taskVo.setParentName(parentMap.get(taskVo.getUserId()));
                }
                if (!CollectionUtils.isEmpty(parentIdMap)) {
                    taskVo.setParentUserId(parentIdMap.get(taskVo.getUserId()));
                }
                result.add(taskVo);
            }
        }
        return result;
    }

    private int isPass(BigDecimal org_score, BigDecimal score, int passLine) {
        BigDecimal percent = new BigDecimal(passLine).divide(new BigDecimal(100));
        BigDecimal result = org_score.multiply(percent);
        if (score.compareTo(result) >= 0) {
            return 3;
        }
        return 4;
    }
}

