/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.training.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ovopark.cloud.log.model.LogPojo;
import com.ovopark.cloud.log.sdk.LogApi;
import com.ovopark.organize.common.base.BaseResult;
import com.ovopark.organize.common.model.mo.UserAndParentNameMo;
import com.ovopark.organize.common.model.mo.UserDutiesMo;
import com.ovopark.organize.common.model.mo.UserTagMo;
import com.ovopark.organize.common.model.mo.UsersAndOrgsMo;
import com.ovopark.organize.common.model.pojo.DepAndTagsPojo;
import com.ovopark.organize.common.model.pojo.DepartmentPojo;
import com.ovopark.organize.common.model.pojo.OrganizePojo;
import com.ovopark.organize.common.model.pojo.SimplePojo;
import com.ovopark.organize.common.model.pojo.UsersPojo;
import com.ovopark.organize.sdk.api.DepartmentApi;
import com.ovopark.organize.sdk.api.OrganizeApi;
import com.ovopark.organize.sdk.api.TagApi;
import com.ovopark.organize.sdk.api.UserApi;
import com.ovopark.organize.sdk.api.UserOrganizeApi;
import com.ovopark.privilege.api.RoleApi;
import com.ovopark.privilege.mo.UserRoleMo;
import com.ovopark.privilege.pojo.RolePojo;
import com.ovopark.training.bo.JsonResult;
import com.ovopark.training.bo.Page;
import com.ovopark.training.mapper.TrainingAndMaterialMapper;
import com.ovopark.training.mapper.TrainingCertificateDetailMapper;
import com.ovopark.training.mapper.TrainingChapterAttachMapper;
import com.ovopark.training.mapper.TrainingChapterMapper;
import com.ovopark.training.mapper.TrainingCourseMapper;
import com.ovopark.training.mapper.TrainingCoursePushMapper;
import com.ovopark.training.mapper.TrainingCoursePushUserMapper;
import com.ovopark.training.mapper.TrainingCourseStageMapper;
import com.ovopark.training.mapper.TrainingCourseStageTaskMapper;
import com.ovopark.training.mapper.TrainingCourseUserAnalyseMapper;
import com.ovopark.training.mapper.TrainingCourseUserMapper;
import com.ovopark.training.mapper.TrainingCourseUserTaskMapper;
import com.ovopark.training.mapper.TrainingExamMapper;
import com.ovopark.training.mapper.TrainingExamQuestionMapper;
import com.ovopark.training.mapper.TrainingExaminerMapper;
import com.ovopark.training.mapper.TrainingMapper;
import com.ovopark.training.mapper.TrainingMaterialMapper;
import com.ovopark.training.mapper.TrainingPaperMapper;
import com.ovopark.training.mapper.TrainingPaperTurnsMapper;
import com.ovopark.training.mapper.TrainingPaperUserMapper;
import com.ovopark.training.mapper.TrainingPaperUserTurnsMapper;
import com.ovopark.training.mapper.TrainingQuestionMapper;
import com.ovopark.training.mapper.TrainingQuestionTypeMapper;
import com.ovopark.training.mapper.TrainingUserLastViewMapper;
import com.ovopark.training.mapper.TrainingUserPaperMapper;
import com.ovopark.training.mapper.TrainingUserQuestionMapper;
import com.ovopark.training.mapper.TrainingUserViewTimeMapper;
import com.ovopark.training.mapper.TrainingWorkMapper;
import com.ovopark.training.mapper.TrainingWorkUserAnswerMapper;
import com.ovopark.training.model.Authenticator;
import com.ovopark.training.model.ClientInfo;
import com.ovopark.training.model.JPush;
import com.ovopark.training.model.PaperAnalyse;
import com.ovopark.training.model.Role;
import com.ovopark.training.model.TaskMessageBody;
import com.ovopark.training.model.Training;
import com.ovopark.training.model.TrainingAndMaterial;
import com.ovopark.training.model.TrainingCertificateDetail;
import com.ovopark.training.model.TrainingChapter;
import com.ovopark.training.model.TrainingChapterAttach;
import com.ovopark.training.model.TrainingCourse;
import com.ovopark.training.model.TrainingCoursePush;
import com.ovopark.training.model.TrainingCoursePushUser;
import com.ovopark.training.model.TrainingCourseStage;
import com.ovopark.training.model.TrainingCourseStageTask;
import com.ovopark.training.model.TrainingCourseUser;
import com.ovopark.training.model.TrainingCourseUserAnalyse;
import com.ovopark.training.model.TrainingCourseUserTask;
import com.ovopark.training.model.TrainingExam;
import com.ovopark.training.model.TrainingExamQuestion;
import com.ovopark.training.model.TrainingExaminer;
import com.ovopark.training.model.TrainingMaterial;
import com.ovopark.training.model.TrainingPaper;
import com.ovopark.training.model.TrainingPaperTurns;
import com.ovopark.training.model.TrainingPaperUser;
import com.ovopark.training.model.TrainingPaperUserTurns;
import com.ovopark.training.model.TrainingQuestion;
import com.ovopark.training.model.TrainingQuestionType;
import com.ovopark.training.model.TrainingUserLastView;
import com.ovopark.training.model.TrainingUserPaper;
import com.ovopark.training.model.TrainingUserQuestion;
import com.ovopark.training.model.TrainingUserViewTime;
import com.ovopark.training.model.TrainingWork;
import com.ovopark.training.model.TrainingWorkUserAnswer;
import com.ovopark.training.model.Users;
import com.ovopark.training.service.JPushService;
import com.ovopark.training.service.TrainingCommonService;
import com.ovopark.training.service.TrainingCourseConfigService;
import com.ovopark.training.service.TrainingCourseService;
import com.ovopark.training.service.TrainingJobCertificationService;
import com.ovopark.training.service.TrainingPaperService;
import com.ovopark.training.service.TrainingWorkService;
import com.ovopark.training.service.UserUtilService;
import com.ovopark.training.util.CommonUtil;
import com.ovopark.training.util.DateUtils;
import com.ovopark.training.util.ListUtil;
import com.ovopark.training.vo.CourseAnalyseSearchVo;
import com.ovopark.training.vo.CoursePushListVo;
import com.ovopark.training.vo.CoursePushNumVo;
import com.ovopark.training.vo.CoursePushUserVo;
import com.ovopark.training.vo.OrgVo;
import com.ovopark.training.vo.PaperAnalyseVo;
import com.ovopark.training.vo.TagVo;
import com.ovopark.training.vo.TrainingChapterAttachVo;
import com.ovopark.training.vo.TrainingChapterVo;
import com.ovopark.training.vo.TrainingCourseMobile;
import com.ovopark.training.vo.TrainingCoursePushVo;
import com.ovopark.training.vo.TrainingCourseStageTaskVo;
import com.ovopark.training.vo.TrainingCourseStageVo;
import com.ovopark.training.vo.TrainingCourseUserTaskVo;
import com.ovopark.training.vo.TrainingCourseVo;
import com.ovopark.training.vo.TrainingMaterialVo;
import com.ovopark.training.vo.TrainingPapersVo;
import com.ovopark.training.vo.TrainingUserPaperVo;
import com.ovopark.training.vo.TrainingUserViewTimeVo;
import com.ovopark.training.vo.TrainingWorkVo;
import com.ovopark.training.vo.TrainingsVo;
import com.ovopark.training.vo.WorkNotifyVo;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.URLEncoder;
import java.sql.JDBCType;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Font;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Service
public class TrainingCourseServiceImpl
implements TrainingCourseService {
    private static final Logger log = LoggerFactory.getLogger(TrainingCourseServiceImpl.class);
    @Autowired
    private TrainingMapper trainingMapper;
    @Autowired
    private TrainingChapterMapper trainingChapterMapper;
    @Autowired
    private TrainingUserPaperMapper trainingUserPaperMapper;
    @Autowired
    private TrainingChapterAttachMapper trainingChapterAttachMapper;
    @Autowired
    private TrainingMaterialMapper materialMapper;
    @Autowired
    private TrainingAndMaterialMapper andMaterialMapper;
    @Autowired
    private TrainingCourseMapper courseMapper;
    @Autowired
    private TrainingCourseUserMapper courseUserMapper;
    @Autowired
    private TrainingCourseStageMapper courseStageMapper;
    @Autowired
    private TrainingCourseStageTaskMapper courseStageTaskMapper;
    @Autowired
    private TrainingCourseUserTaskMapper courseUserTaskMapper;
    @Autowired
    private TrainingPaperMapper trainingPaperMapper;
    @Autowired
    private TrainingExamMapper examMapper;
    @Autowired
    private TrainingExaminerMapper trainingExaminerMapper;
    @Autowired
    private TrainingPaperUserMapper trainingPaperUserMapper;
    @Autowired
    private JPushService jPushService;
    @Autowired
    private UserApi userApi;
    @Autowired
    private com.ovopark.privilege.api.UserApi useApi;
    @Autowired
    private OrganizeApi organizeApi;
    @Autowired
    private UserOrganizeApi userOrganizeApi;
    @Autowired
    private RoleApi roleApi;
    @Autowired
    private TrainingUserLastViewMapper lastViewMapper;
    @Autowired
    private TrainingPaperTurnsMapper paperTurnsMapper;
    @Autowired
    private TrainingPaperUserTurnsMapper paperUserTurnsMapper;
    @Autowired
    private UserUtilService userUtilService;
    @Autowired
    private TrainingCommonService commonService;
    @Value(value="${training.webview.url}")
    private String trainingPaperUrl;
    @Autowired
    private TagApi tagApi;
    @Autowired
    private DepartmentApi departmentApi;
    @Autowired
    private TrainingCourseConfigService trainingCourseConfigService;
    @Autowired
    private TrainingCoursePushMapper trainingCoursePushMapper;
    @Autowired
    private TrainingCoursePushUserMapper trainingCoursePushUserMapper;
    @Autowired
    private TrainingExamMapper trainingExamMapper;
    @Autowired
    private TrainingCertificateDetailMapper certificateDetailMapper;
    @Autowired
    private TrainingCourseUserAnalyseMapper trainingCourseUserAnalyseMapper;
    @Autowired
    private TrainingUserQuestionMapper trainingUserQuestionMapper;
    @Autowired
    private TrainingQuestionMapper trainingQuestionMapper;
    @Autowired
    private TrainingQuestionTypeMapper trainingQuestionTypeMapper;
    @Autowired
    private TrainingExamQuestionMapper trainingExamQuestionMapper;
    @Autowired
    private TrainingCourseMapper trainingCourseMapper;
    @Autowired
    private TrainingWorkMapper trainingWorkMapper;
    @Autowired
    private TrainingWorkUserAnswerMapper trainingWorkUserAnswerMapper;
    @Autowired
    private LogApi logApi;
    @Autowired
    private MessageSource messageSource;
    @Autowired
    private TrainingUserViewTimeMapper trainingUserViewTimeMapper;
    @Autowired
    private TrainingWorkService trainingWorkService;
    @Autowired
    private TrainingJobCertificationService trainingJobCertificationService;
    @Autowired
    private TrainingPaperService trainingPaperService;

    @Override
    public TrainingCourseVo selectTrainingCourse(TrainingCourseVo trainingCourseVo, Users user) {
        TrainingCourse trainingCourse = (TrainingCourse)this.courseMapper.selectById(trainingCourseVo.getId());
        BeanUtils.copyProperties((Object)trainingCourse, (Object)trainingCourseVo);
        LambdaUpdateWrapper courseUserWrapper1 = new LambdaUpdateWrapper();
        courseUserWrapper1.eq(!org.springframework.util.StringUtils.isEmpty((Object)user.getGroupId()), TrainingCourseUser::getEnterpriseId, (Object)user.getGroupId());
        ((LambdaUpdateWrapper)courseUserWrapper1.eq(TrainingCourseUser::getCourseId, (Object)trainingCourseVo.getId())).in(TrainingCourseUser::getCourseType, Collections.singletonList("1"));
        List courseUserList1 = this.courseUserMapper.selectList((Wrapper)courseUserWrapper1);
        if (!CollectionUtils.isEmpty((Collection)courseUserList1)) {
            com.ovopark.privilege.response.BaseResult base;
            List userIds1 = courseUserList1.stream().map(TrainingCourseUser::getUserId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            List roleIds = courseUserList1.stream().map(TrainingCourseUser::getRoleId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            List organizeIds = courseUserList1.stream().map(TrainingCourseUser::getOrganizeId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            List tagIds = courseUserList1.stream().map(TrainingCourseUser::getTagId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(userIds1)) {
                List pojoList1 = (List)this.userApi.getSimpleUserByIdList(userIds1).getData();
                Iterator appointList = new ArrayList();
                if (!CollectionUtils.isEmpty((Collection)pojoList1)) {
                    for (SimplePojo pojo : pojoList1) {
                        Users user1 = new Users();
                        user1.setId(pojo.getId());
                        user1.setShowName(pojo.getName());
                        appointList.add((Users)user1);
                    }
                    trainingCourseVo.setAppointList(appointList);
                }
            }
            if (!CollectionUtils.isEmpty(organizeIds)) {
                ArrayList<OrgVo> orgList = new ArrayList<OrgVo>();
                for (String organizeId : organizeIds) {
                    String[] depSplit;
                    OrgVo org;
                    OrganizePojo pojo;
                    BaseResult result;
                    if (organizeId.startsWith("O_")) {
                        String[] orgSplit = organizeId.split("O_");
                        result = this.organizeApi.getOrganizeById(Integer.valueOf(Integer.parseInt(orgSplit[1])));
                        if (result.getIsError().booleanValue() || result.getData() == null) continue;
                        pojo = (OrganizePojo)result.getData();
                        org = new OrgVo();
                        org.setId(organizeId);
                        org.setName(pojo.getName());
                        orgList.add(org);
                        continue;
                    }
                    if (!organizeId.startsWith("S_") || (result = this.departmentApi.getDepartmentById(Integer.valueOf(Integer.parseInt((depSplit = organizeId.split("S_"))[1])))).getIsError().booleanValue() || result.getData() == null) continue;
                    pojo = (DepartmentPojo)result.getData();
                    org = new OrgVo();
                    org.setId(organizeId);
                    org.setName(pojo.getName());
                    orgList.add(org);
                }
                trainingCourseVo.setOrganizeList(orgList);
            }
            if (!CollectionUtils.isEmpty(tagIds)) {
                ArrayList<TagVo> tagList = new ArrayList<TagVo>();
                for (Object tagId : tagIds) {
                    BaseResult result = this.tagApi.getUsersTagById((Integer)tagId);
                    if (result.getIsError().booleanValue() || result.getData() == null) continue;
                    UserTagMo pojo = (UserTagMo)result.getData();
                    TagVo tag = new TagVo();
                    tag.setId(pojo.getId());
                    tag.setName(pojo.getTagName());
                    tagList.add(tag);
                }
                trainingCourseVo.setTagList(tagList);
            }
            if (!CollectionUtils.isEmpty(roleIds) && (base = this.roleApi.getRolePojoByIdList(roleIds)) != null && !CollectionUtils.isEmpty((Collection)((Collection)base.getData()))) {
                ArrayList rolesList = new ArrayList();
                for (SimplePojo pojo : (List)base.getData()) {
                    Role role = new Role();
                    role.setId(pojo.getId());
                    role.setRoleName(pojo.getRoleName());
                    rolesList.add(role);
                }
                trainingCourseVo.setAppointRoleList((List)rolesList);
            }
        }
        LambdaUpdateWrapper courseUserWrapper2 = new LambdaUpdateWrapper();
        courseUserWrapper2.eq(!org.springframework.util.StringUtils.isEmpty((Object)user.getGroupId()), TrainingCourseUser::getEnterpriseId, (Object)user.getGroupId());
        ((LambdaUpdateWrapper)courseUserWrapper2.eq(TrainingCourseUser::getCourseId, (Object)trainingCourseVo.getId())).in(TrainingCourseUser::getCourseType, Arrays.asList("2"));
        List courseUserList2 = this.courseUserMapper.selectList((Wrapper)courseUserWrapper2);
        if (!CollectionUtils.isEmpty((Collection)courseUserList2)) {
            List userIds2 = courseUserList2.stream().map(TrainingCourseUser::getUserId).distinct().collect(Collectors.toList());
            List pojoList2 = (List)this.userApi.getSimpleUserByIdList(userIds2).getData();
            ArrayList<Users> managerList = new ArrayList<Users>();
            if (!CollectionUtils.isEmpty((Collection)pojoList2)) {
                for (SimplePojo pojo : pojoList2) {
                    Users user2 = new Users();
                    user2.setId(pojo.getId());
                    user2.setShowName(pojo.getName());
                    managerList.add(user2);
                }
                trainingCourseVo.setManagerList(managerList);
            }
        }
        LambdaUpdateWrapper courseStageWrapper = new LambdaUpdateWrapper();
        courseStageWrapper.eq(!org.springframework.util.StringUtils.isEmpty((Object)user.getGroupId()), TrainingCourseStage::getEnterpriseId, (Object)user.getGroupId());
        courseStageWrapper.eq(TrainingCourseStage::getCourseId, (Object)trainingCourseVo.getId());
        courseStageWrapper.orderByAsc(TrainingCourseStage::getStageSort);
        List courseStageList = this.courseStageMapper.selectList((Wrapper)courseStageWrapper);
        LambdaUpdateWrapper courseStageTaskWrapper = new LambdaUpdateWrapper();
        courseStageTaskWrapper.eq(!org.springframework.util.StringUtils.isEmpty((Object)user.getGroupId()), TrainingCourseStageTask::getEnterpriseId, (Object)user.getGroupId());
        courseStageTaskWrapper.eq(TrainingCourseStageTask::getCourseId, (Object)trainingCourseVo.getId());
        courseStageTaskWrapper.orderByAsc(TrainingCourseStageTask::getTaskSort);
        List courseStageTaskList = this.courseStageTaskMapper.selectList((Wrapper)courseStageTaskWrapper);
        Map<Integer, List<TrainingCourseStageTask>> stageTaskMap = courseStageTaskList.stream().collect(Collectors.groupingBy(TrainingCourseStageTask::getStageId));
        List materialIds = courseStageTaskList.stream().map(TrainingCourseStageTask::getMaterialId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        Map<Object, Object> materialMap = new HashMap();
        if (!CollectionUtils.isEmpty(materialIds)) {
            List trainingMaterialList = this.materialMapper.selectBatchIds(materialIds);
            materialMap = trainingMaterialList.stream().collect(Collectors.toMap(TrainingMaterial::getId, Function.identity()));
        }
        if (!CollectionUtils.isEmpty((Collection)courseStageList)) {
            ArrayList<TrainingCourseStageVo> courseStageVoList = new ArrayList<TrainingCourseStageVo>();
            for (TrainingCourseStage courseStage : courseStageList) {
                TrainingCourseStageVo courseStageVo = new TrainingCourseStageVo();
                BeanUtils.copyProperties((Object)courseStage, (Object)courseStageVo);
                List<TrainingCourseStageTask> stageTaskList = stageTaskMap.get(courseStage.getId());
                if (!CollectionUtils.isEmpty(stageTaskList)) {
                    ArrayList<TrainingCourseStageTaskVo> taskVoList = new ArrayList<TrainingCourseStageTaskVo>();
                    for (TrainingCourseStageTask task : stageTaskList) {
                        TrainingMaterial trainingMaterial;
                        TrainingCourseStageTaskVo taskVo = new TrainingCourseStageTaskVo();
                        BeanUtils.copyProperties((Object)task, (Object)taskVo);
                        if (taskVo.getMaterialId() != null && !ObjectUtils.isEmpty((Object)(trainingMaterial = (TrainingMaterial)materialMap.get(taskVo.getMaterialId())))) {
                            taskVo.setFileType(trainingMaterial.getFileType());
                            taskVo.setUrl(trainingMaterial.getMaterialPath());
                        }
                        taskVoList.add(taskVo);
                    }
                    courseStageVo.setTaskList(taskVoList);
                }
                courseStageVoList.add(courseStageVo);
            }
            trainingCourseVo.setStageList(courseStageVoList);
        }
        return trainingCourseVo;
    }

    private List<Integer> getTrainingCourseUserIds(TrainingCourseVo trainingCourseVo, Users user) {
        List<Integer> pushUserIds = new ArrayList<Integer>();
        if (trainingCourseVo.getAppointType() == 0) {
            BaseResult base = this.userApi.getSimpleUserByKeyWord(user.getGroupId(), null, null);
            if (base != null && !CollectionUtils.isEmpty((Collection)((Collection)base.getData()))) {
                pushUserIds = ((List)base.getData()).stream().map(SimplePojo::getId).distinct().collect(Collectors.toList());
            }
        } else {
            List tagList;
            List tagList1;
            List organizeList;
            List organizeList1;
            String roleIdStr;
            com.ovopark.privilege.response.BaseResult baseResult;
            List rolesList;
            List rolesList1;
            if (!CollectionUtils.isEmpty((Collection)trainingCourseVo.getAppointList())) {
                List usersList = trainingCourseVo.getAppointList();
                List userIds1 = usersList.stream().map(Users::getId).distinct().collect(Collectors.toList());
                pushUserIds.addAll(userIds1);
            }
            if (!(CollectionUtils.isEmpty((Collection)trainingCourseVo.getAppointRoleList()) || CollectionUtils.isEmpty(rolesList1 = (rolesList = trainingCourseVo.getAppointRoleList()).stream().map(Role::getId).distinct().collect(Collectors.toList())) || (baseResult = this.useApi.getUserByRoleIds(roleIdStr = StringUtils.join(rolesList1, (String)","), user.getGroupId())) == null || CollectionUtils.isEmpty((Collection)((Collection)baseResult.getData())))) {
                List pojo = ((List)baseResult.getData()).stream().map(com.ovopark.privilege.pojo.UsersPojo::getId).distinct().collect(Collectors.toList());
                pushUserIds.addAll(pojo);
            }
            if (!CollectionUtils.isEmpty((Collection)trainingCourseVo.getOrganizeList()) && !CollectionUtils.isEmpty(organizeList1 = (organizeList = trainingCourseVo.getOrganizeList()).stream().map(OrgVo::getId).distinct().collect(Collectors.toList()))) {
                UsersAndOrgsMo mo = new UsersAndOrgsMo();
                mo.setGroupId(user.getGroupId());
                mo.setOrganizeIds(organizeList1);
                BaseResult userResult = this.userOrganizeApi.getUserByOrganizeIdsOrDepId(mo);
                if (!userResult.getIsError().booleanValue() && !CollectionUtils.isEmpty((Collection)((Collection)userResult.getData()))) {
                    List users = ((List)userResult.getData()).stream().map(UserAndParentNameMo::getUserId).distinct().collect(Collectors.toList());
                    pushUserIds.addAll(users);
                }
            }
            if (!CollectionUtils.isEmpty((Collection)trainingCourseVo.getTagList()) && !CollectionUtils.isEmpty(tagList1 = (tagList = trainingCourseVo.getTagList()).stream().map(TagVo::getId).distinct().collect(Collectors.toList()))) {
                DepAndTagsPojo pojo = new DepAndTagsPojo();
                pojo.setGroupId(user.getGroupId());
                pojo.setTagIds(tagList1);
                pojo.setUserId(user.getId());
                BaseResult tagResult = this.tagApi.getUsersByTags(pojo);
                if (!tagResult.getIsError().booleanValue() && !CollectionUtils.isEmpty((Collection)((Collection)tagResult.getData()))) {
                    for (Map map : (List)tagResult.getData()) {
                        Integer id = (Integer)map.get("id");
                        pushUserIds.add(id);
                    }
                }
            }
        }
        return pushUserIds;
    }

    @Override
    public Integer saveTrainingCourse(final TrainingCourseVo trainingCourseVo, Users user) {
        TrainingCourseUser courseUser;
        ArrayList<Object> courseUserList;
        List usersList;
        Date now = new Date();
        List<Integer> pushUserIds = this.getTrainingCourseUserIds(trainingCourseVo, user);
        if (trainingCourseVo.getStatus() == 1) {
            if (!org.springframework.util.StringUtils.isEmpty((Object)trainingCourseVo.getStartTime()) && trainingCourseVo.getStartTime().before(new Date())) {
                trainingCourseVo.setStatus(Integer.valueOf(2));
            }
            if (!org.springframework.util.StringUtils.isEmpty((Object)trainingCourseVo.getEndTime()) && trainingCourseVo.getEndTime().before(new Date())) {
                trainingCourseVo.setStatus(Integer.valueOf(3));
            }
        }
        final Locale locale = Authenticator.getInstance().getCurrentClient().getLocale();
        if (org.springframework.util.StringUtils.isEmpty((Object)trainingCourseVo.getId())) {
            trainingCourseVo.setEnterpriseId(user.getGroupId());
            trainingCourseVo.setCreater(user.getId());
            trainingCourseVo.setCreateTime(now);
            this.courseMapper.insert(trainingCourseVo);
            if (!(trainingCourseVo.getStatus() != 1 && trainingCourseVo.getStatus() != 2 || CollectionUtils.isEmpty(pushUserIds))) {
                final List<Integer> finalPushUserIds = pushUserIds;
                CommonUtil.handleTask(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            String startName = "\u57f9\u8bad\u8ba1\u5212\u5f00\u59cb : \u300a{0}\u300b";
                            TrainingCourseServiceImpl.this.jPushService.sendWebSocketAll(trainingCourseVo.getCourseName(), MessageFormat.format(startName, trainingCourseVo.getCourseName()), finalPushUserIds, trainingCourseVo.getEnterpriseId(), trainingCourseVo.getId(), "TYPE_COURSE_SYSTEM", JSONObject.toJSONString((Object)trainingCourseVo), trainingCourseVo.getEndTime(), 1, 1, "training.job.course.start", trainingCourseVo.getCourseName());
                            if (trainingCourseVo.getStatus() == 2 && trainingCourseVo.getIsPush() != null && trainingCourseVo.getIsPush() == 1) {
                                TrainingCourseMobile push = new TrainingCourseMobile();
                                BeanUtils.copyProperties((Object)trainingCourseVo, (Object)push);
                                SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm");
                                TaskMessageBody body = new TaskMessageBody();
                                body.setType(98);
                                body.setTaskJson(JSONObject.toJSONString((Object)push));
                                TrainingCourseServiceImpl.this.jPushService.pushNotificationAll(JPush.MASSAGE_TYPE_NOTIFY, "TYPE_COURSE_SYSTEM", finalPushUserIds, trainingCourseVo.getCourseName(), TrainingCourseServiceImpl.this.messageSource.getMessage("training.course.task.new", null, locale) + "\n" + TrainingCourseServiceImpl.this.messageSource.getMessage("training.paper.exam.expiration", null, locale) + ":" + format.format(trainingCourseVo.getStartTime()) + TrainingCourseServiceImpl.this.messageSource.getMessage("training.paper.expire.to", null, locale) + format.format(trainingCourseVo.getEndTime()), body);
                            }
                        }
                        catch (Exception e) {
                            log.error("\u57f9\u8bad\u63a8\u9001\u4fe1\u606f", (Throwable)e);
                        }
                    }
                });
            }
        } else {
            Integer oldStatus = 2;
            final TrainingCourse trainingCourseOld = (TrainingCourse)this.courseMapper.selectById(trainingCourseVo.getId());
            if (!ObjectUtils.isEmpty((Object)trainingCourseOld)) {
                oldStatus = trainingCourseOld.getStatus();
            }
            this.courseMapper.updateById(trainingCourseVo);
            if (org.springframework.util.StringUtils.isEmpty((Object)trainingCourseVo.getRelearnCount())) {
                this.courseMapper.updateRelearnCount(trainingCourseVo.getId());
            }
            if (oldStatus == 0) {
                if (!(CollectionUtils.isEmpty(pushUserIds) || trainingCourseVo.getStatus() != 1 && trainingCourseVo.getStatus() != 2)) {
                    final List<Integer> finalPushUserIds = pushUserIds;
                    CommonUtil.handleTask(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                String startName = "\u57f9\u8bad\u8ba1\u5212\u5f00\u59cb : \u300a{0}\u300b";
                                TrainingCourseServiceImpl.this.jPushService.sendWebSocketAll(trainingCourseVo.getCourseName(), MessageFormat.format(startName, trainingCourseVo.getCourseName()), finalPushUserIds, trainingCourseOld.getEnterpriseId(), trainingCourseVo.getId(), "TYPE_COURSE_SYSTEM", JSONObject.toJSONString((Object)trainingCourseVo), trainingCourseVo.getEndTime(), 1, 1, "training.job.course.start", trainingCourseVo.getCourseName());
                                if (trainingCourseVo.getStatus() == 2 && trainingCourseVo.getIsPush() != null && trainingCourseVo.getIsPush() == 1) {
                                    TrainingCourseMobile push = new TrainingCourseMobile();
                                    BeanUtils.copyProperties((Object)trainingCourseVo, (Object)push);
                                    SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm");
                                    TaskMessageBody body = new TaskMessageBody();
                                    body.setType(98);
                                    body.setTaskJson(JSONObject.toJSONString((Object)push));
                                    TrainingCourseServiceImpl.this.jPushService.pushNotificationAll(JPush.MASSAGE_TYPE_NOTIFY, "TYPE_COURSE_SYSTEM", finalPushUserIds, trainingCourseVo.getCourseName(), TrainingCourseServiceImpl.this.messageSource.getMessage("training.course.task.new", null, locale) + "\n" + TrainingCourseServiceImpl.this.messageSource.getMessage("training.paper.exam.expiration", null, locale) + ":" + format.format(trainingCourseVo.getStartTime()) + TrainingCourseServiceImpl.this.messageSource.getMessage("training.paper.expire.to", null, locale) + format.format(trainingCourseVo.getEndTime()), body);
                                }
                            }
                            catch (Exception e) {
                                log.error("\u8349\u7a3f\u57f9\u8bad\u91cd\u63a8\u9001\u4fe1\u606f", (Throwable)e);
                            }
                        }
                    });
                }
            } else if (trainingCourseVo.getStatus() == 1 || trainingCourseVo.getStatus() == 2) {
                List<Object> userIds = new ArrayList();
                if (trainingCourseVo.getAppointType() == 0) {
                    BaseResult base = this.userApi.getSimpleUserByKeyWord(user.getGroupId(), null, null);
                    if (base != null && !CollectionUtils.isEmpty((Collection)((Collection)base.getData()))) {
                        userIds = ((List)base.getData()).stream().map(SimplePojo::getId).distinct().collect(Collectors.toList());
                    }
                } else {
                    LambdaQueryWrapper userWrapper = new LambdaQueryWrapper();
                    ((LambdaQueryWrapper)userWrapper.eq(TrainingCourseUser::getCourseType, (Object)1)).eq(TrainingCourseUser::getCourseId, (Object)trainingCourseVo.getId());
                    List courseUserList2 = this.courseUserMapper.selectList((Wrapper)userWrapper);
                    if (!CollectionUtils.isEmpty((Collection)courseUserList2)) {
                        String roleIdStr;
                        com.ovopark.privilege.response.BaseResult baseResult;
                        List userIds1 = courseUserList2.stream().map(TrainingCourseUser::getUserId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
                        List roleIds = courseUserList2.stream().map(TrainingCourseUser::getRoleId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
                        List tagIds = courseUserList2.stream().map(TrainingCourseUser::getTagId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
                        List orgIds = courseUserList2.stream().map(TrainingCourseUser::getOrganizeId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
                        if (!CollectionUtils.isEmpty(userIds1)) {
                            userIds.addAll(userIds1);
                        }
                        if (!CollectionUtils.isEmpty((Collection)roleIds) && (baseResult = this.useApi.getUserByRoleIds(roleIdStr = StringUtils.join((Collection)roleIds, (String)","), user.getGroupId())) != null && !CollectionUtils.isEmpty((Collection)((Collection)baseResult.getData()))) {
                            List pojo = ((List)baseResult.getData()).stream().map(com.ovopark.privilege.pojo.UsersPojo::getId).distinct().collect(Collectors.toList());
                            userIds.addAll(pojo);
                        }
                        if (!CollectionUtils.isEmpty(tagIds)) {
                            DepAndTagsPojo pojo = new DepAndTagsPojo();
                            pojo.setGroupId(user.getGroupId());
                            pojo.setTagIds(tagIds);
                            pojo.setUserId(user.getId());
                            BaseResult tagResult = this.tagApi.getUsersByTags(pojo);
                            if (!tagResult.getIsError().booleanValue() && !CollectionUtils.isEmpty((Collection)((Collection)tagResult.getData()))) {
                                for (Map map : (List)tagResult.getData()) {
                                    Integer id = (Integer)map.get("id");
                                    userIds.add(id);
                                }
                            }
                        }
                        if (!CollectionUtils.isEmpty(orgIds)) {
                            UsersAndOrgsMo mo = new UsersAndOrgsMo();
                            mo.setGroupId(user.getGroupId());
                            mo.setOrganizeIds(orgIds);
                            BaseResult userResult = this.userOrganizeApi.getUserByOrganizeIdsOrDepId(mo);
                            if (!userResult.getIsError().booleanValue() && !CollectionUtils.isEmpty((Collection)((Collection)userResult.getData()))) {
                                List users = ((List)userResult.getData()).stream().map(UserAndParentNameMo::getUserId).distinct().collect(Collectors.toList());
                                userIds.addAll(users);
                            }
                        }
                    }
                }
                userIds.removeAll(pushUserIds);
                if (!CollectionUtils.isEmpty(userIds)) {
                    final ArrayList finalUserIds = userIds;
                    CommonUtil.handleTask(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                for (Integer userId : finalUserIds) {
                                    TrainingCourseServiceImpl.this.jPushService.deleteMessages(trainingCourseVo.getId(), "TYPE_COURSE_SYSTEM", userId, null, 1);
                                }
                            }
                            catch (Exception e) {
                                log.error("\u5220\u9664\u63a8\u9001\u4fe1\u606f", (Throwable)e);
                            }
                        }
                    });
                }
            }
            LambdaUpdateWrapper courseUserWrapper = new LambdaUpdateWrapper();
            courseUserWrapper.eq(!org.springframework.util.StringUtils.isEmpty((Object)user.getGroupId()), TrainingCourseUser::getEnterpriseId, (Object)user.getGroupId());
            ((LambdaUpdateWrapper)courseUserWrapper.eq(TrainingCourseUser::getCourseId, (Object)trainingCourseVo.getId())).in(TrainingCourseUser::getCourseType, Arrays.asList("1", "2"));
            this.courseUserMapper.delete((Wrapper)courseUserWrapper);
        }
        if (!CollectionUtils.isEmpty((Collection)trainingCourseVo.getAppointList())) {
            usersList = trainingCourseVo.getAppointList();
            courseUserList = new ArrayList<TrainingCourseUser>();
            for (Object users : usersList) {
                courseUser = new TrainingCourseUser();
                courseUser.setCourseId(trainingCourseVo.getId());
                courseUser.setCourseType(Integer.valueOf(1));
                courseUser.setUserId(users.getId());
                courseUser.setEnterpriseId(user.getGroupId());
                courseUser.setCreater(user.getId());
                courseUser.setCreateTime(now);
                courseUserList.add(courseUser);
            }
            this.courseUserMapper.insertList(courseUserList);
        }
        if (!CollectionUtils.isEmpty((Collection)trainingCourseVo.getAppointRoleList())) {
            List rolesList = trainingCourseVo.getAppointRoleList();
            courseUserList = new ArrayList();
            for (Role role : rolesList) {
                courseUser = new TrainingCourseUser();
                courseUser.setCourseId(trainingCourseVo.getId());
                courseUser.setCourseType(Integer.valueOf(1));
                courseUser.setRoleId(role.getId());
                courseUser.setEnterpriseId(user.getGroupId());
                courseUser.setCreater(user.getId());
                courseUser.setCreateTime(now);
                courseUserList.add(courseUser);
            }
            this.courseUserMapper.insertList(courseUserList);
        }
        if (!CollectionUtils.isEmpty((Collection)trainingCourseVo.getTagList())) {
            List tagList = trainingCourseVo.getTagList();
            courseUserList = new ArrayList();
            for (TagVo tag : tagList) {
                courseUser = new TrainingCourseUser();
                courseUser.setCourseId(trainingCourseVo.getId());
                courseUser.setCourseType(Integer.valueOf(1));
                courseUser.setTagId(tag.getId());
                courseUser.setEnterpriseId(user.getGroupId());
                courseUser.setCreater(user.getId());
                courseUser.setCreateTime(now);
                courseUserList.add(courseUser);
            }
            this.courseUserMapper.insertList(courseUserList);
        }
        if (!CollectionUtils.isEmpty((Collection)trainingCourseVo.getOrganizeList())) {
            List orgList = trainingCourseVo.getOrganizeList();
            courseUserList = new ArrayList();
            for (OrgVo org : orgList) {
                courseUser = new TrainingCourseUser();
                courseUser.setCourseId(trainingCourseVo.getId());
                courseUser.setCourseType(Integer.valueOf(1));
                courseUser.setOrganizeId(org.getId());
                courseUser.setEnterpriseId(user.getGroupId());
                courseUser.setCreater(user.getId());
                courseUser.setCreateTime(now);
                courseUserList.add(courseUser);
            }
            this.courseUserMapper.insertList(courseUserList);
        }
        if (!CollectionUtils.isEmpty(pushUserIds)) {
            LambdaUpdateWrapper wrapper3 = new LambdaUpdateWrapper();
            wrapper3.eq(TrainingCourseUserTask::getCourseId, (Object)trainingCourseVo.getId());
            wrapper3.notIn(TrainingCourseUserTask::getUserId, pushUserIds);
            this.courseUserTaskMapper.delete((Wrapper)wrapper3);
        }
        if (!CollectionUtils.isEmpty((Collection)trainingCourseVo.getManagerList())) {
            usersList = trainingCourseVo.getManagerList();
            courseUserList = new ArrayList();
            for (Object users : usersList) {
                courseUser = new TrainingCourseUser();
                courseUser.setCourseId(trainingCourseVo.getId());
                courseUser.setCourseType(Integer.valueOf(2));
                courseUser.setUserId(users.getId());
                courseUser.setEnterpriseId(user.getGroupId());
                courseUser.setCreater(user.getId());
                courseUser.setCreateTime(now);
                courseUserList.add(courseUser);
            }
            this.courseUserMapper.insertList(courseUserList);
        }
        if (!CollectionUtils.isEmpty((Collection)trainingCourseVo.getStageList())) {
            List trainingCourseStageTasks;
            List stageVoList = trainingCourseVo.getStageList();
            ArrayList<Integer> stageIdList = new ArrayList<Integer>();
            ArrayList<Integer> taskIdList = new ArrayList<Integer>();
            for (TrainingCourseStageVo stageVo : stageVoList) {
                if (org.springframework.util.StringUtils.isEmpty((Object)stageVo.getId())) {
                    stageVo.setCourseId(trainingCourseVo.getId());
                    stageVo.setEnterpriseId(user.getGroupId());
                    stageVo.setCreater(user.getId());
                    stageVo.setCreateTime(now);
                    this.courseStageMapper.insert(stageVo);
                    stageIdList.add(stageVo.getId());
                } else {
                    this.courseStageMapper.updateById(stageVo);
                    stageIdList.add(stageVo.getId());
                }
                if (CollectionUtils.isEmpty((Collection)stageVo.getTaskList())) continue;
                List taskVoList = stageVo.getTaskList();
                for (TrainingCourseStageTaskVo taskVo : taskVoList) {
                    if (org.springframework.util.StringUtils.isEmpty((Object)taskVo.getId())) {
                        taskVo.setCourseId(trainingCourseVo.getId());
                        taskVo.setStageId(stageVo.getId());
                        taskVo.setEnterpriseId(user.getGroupId());
                        taskVo.setCreater(user.getId());
                        taskVo.setCreateTime(now);
                        if (taskVo.getTaskType() == 6 && trainingCourseVo.getIsCopy() != null && trainingCourseVo.getIsCopy() == 1 && taskVo.getWorkId() != null) {
                            taskVo.setWorkIdOld(taskVo.getWorkId());
                            TrainingWork work = this.trainingWorkService.insertSameWork(taskVo.getWorkId(), 5);
                            taskVo.setWorkId(work.getId());
                        }
                        this.courseStageTaskMapper.insert(taskVo);
                        taskIdList.add(taskVo.getId());
                        if (taskVo.getIsBinding() != 0 && taskVo.getTaskType() != 2) continue;
                        taskVo.setIsBinding(Integer.valueOf(1));
                        this.courseStageTaskMapper.updateById(taskVo);
                        this.trainingCourseConfigService.updateIsBindingTraining(taskVo, user);
                        continue;
                    }
                    this.courseStageTaskMapper.updateById(taskVo);
                    taskIdList.add(taskVo.getId());
                }
            }
            LambdaUpdateWrapper wrapper1 = new LambdaUpdateWrapper();
            wrapper1.eq(TrainingCourseStage::getCourseId, (Object)trainingCourseVo.getId());
            if (!CollectionUtils.isEmpty(stageIdList)) {
                wrapper1.notIn(TrainingCourseStage::getId, stageIdList);
            }
            this.courseStageMapper.delete((Wrapper)wrapper1);
            LambdaQueryWrapper wrapper4 = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)wrapper4.eq(TrainingCourseStageTask::getCourseId, (Object)trainingCourseVo.getId())).eq(TrainingCourseStageTask::getIsBinding, (Object)0);
            if (!CollectionUtils.isEmpty(taskIdList)) {
                wrapper4.notIn(TrainingCourseStageTask::getId, taskIdList);
            }
            if (!CollectionUtils.isEmpty((Collection)(trainingCourseStageTasks = this.courseStageTaskMapper.selectList((Wrapper)wrapper4)))) {
                List paperIds;
                List trainingIds = trainingCourseStageTasks.stream().map(TrainingCourseStageTask::getTrainingId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
                if (!CollectionUtils.isEmpty(trainingIds)) {
                    LambdaUpdateWrapper wrapper0 = new LambdaUpdateWrapper();
                    wrapper0.in(Training::getId, trainingIds);
                    this.trainingMapper.delete((Wrapper)wrapper0);
                    LambdaUpdateWrapper wrapper2 = new LambdaUpdateWrapper();
                    wrapper2.in(TrainingAndMaterial::getTrainingId, trainingIds);
                    this.andMaterialMapper.delete((Wrapper)wrapper2);
                    LambdaQueryWrapper wrapper3 = new LambdaQueryWrapper();
                    ((LambdaQueryWrapper)wrapper3.in(TrainingChapter::getTrainingId, trainingIds)).eq(TrainingChapter::getIsDel, (Object)0);
                    List chapterList = this.trainingChapterMapper.selectList((Wrapper)wrapper3);
                    if (!CollectionUtils.isEmpty((Collection)chapterList)) {
                        List chapterIds = chapterList.stream().map(TrainingChapter::getId).collect(Collectors.toList());
                        this.trainingChapterMapper.deleteBatchIds(chapterIds);
                        LambdaUpdateWrapper wrapper5 = new LambdaUpdateWrapper();
                        wrapper5.in(TrainingChapterAttach::getChapterId, chapterIds);
                        this.trainingChapterAttachMapper.delete((Wrapper)wrapper5);
                    }
                }
                if (!CollectionUtils.isEmpty(paperIds = trainingCourseStageTasks.stream().map(TrainingCourseStageTask::getPaperId).filter(Objects::nonNull).distinct().collect(Collectors.toList()))) {
                    LambdaUpdateWrapper wrapper0 = new LambdaUpdateWrapper();
                    wrapper0.in(TrainingPaper::getId, paperIds);
                    this.trainingPaperMapper.delete((Wrapper)wrapper0);
                }
            }
            LambdaUpdateWrapper wrapper2 = new LambdaUpdateWrapper();
            wrapper2.eq(TrainingCourseStageTask::getCourseId, (Object)trainingCourseVo.getId());
            if (!CollectionUtils.isEmpty(taskIdList)) {
                wrapper2.notIn(TrainingCourseStageTask::getId, taskIdList);
            }
            this.courseStageTaskMapper.delete((Wrapper)wrapper2);
            LambdaUpdateWrapper wrapper3 = new LambdaUpdateWrapper();
            wrapper3.eq(TrainingCourseUserTask::getCourseId, (Object)trainingCourseVo.getId());
            if (!CollectionUtils.isEmpty(taskIdList)) {
                wrapper3.notIn(TrainingCourseUserTask::getTaskId, taskIdList);
            }
            this.courseUserTaskMapper.delete((Wrapper)wrapper3);
        }
        if (trainingCourseVo.getStatus() == 3) {
            this.updateRoleUsersByClose(trainingCourseVo.getId(), user.getId(), user.getGroupId());
        }
        CommonUtil.handleTask(new Runnable(){

            @Override
            public void run() {
                TrainingCourseServiceImpl.this.saveCourseEndWay(trainingCourseVo.getId());
            }
        });
        return trainingCourseVo.getId();
    }

    @Override
    public Integer saveCopyTrainingCourse(TrainingCourseVo trainingCourseVo, Users user) {
        Locale locale = Authenticator.getInstance().getCurrentClient().getLocale();
        Date now = new Date();
        TrainingCourse trainingCourse = (TrainingCourse)this.courseMapper.selectById(trainingCourseVo.getId());
        trainingCourse.setStatus(Integer.valueOf(0));
        trainingCourse.setId(null);
        trainingCourse.setCourseName(trainingCourse.getCourseName() + "-" + this.messageSource.getMessage("training.copy", null, locale));
        trainingCourse.setCreater(user.getId());
        trainingCourse.setCreateTime(now);
        this.courseMapper.insert(trainingCourse);
        LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
        wrapper1.eq(TrainingCourseUser::getCourseId, (Object)trainingCourseVo.getId());
        List trainingCourseUserList = this.courseUserMapper.selectList((Wrapper)wrapper1);
        if (!CollectionUtils.isEmpty((Collection)trainingCourseUserList)) {
            for (TrainingCourseUser trainingCourseUser : trainingCourseUserList) {
                trainingCourseUser.setId(null);
                trainingCourseUser.setCourseId(trainingCourse.getId());
                trainingCourseUser.setCreater(user.getId());
                trainingCourseUser.setCreateTime(now);
            }
            this.courseUserMapper.insertList(trainingCourseUserList);
        }
        LambdaQueryWrapper wrapper2 = new LambdaQueryWrapper();
        wrapper2.eq(TrainingCourseStage::getCourseId, (Object)trainingCourseVo.getId());
        List trainingCourseStageList = this.courseStageMapper.selectList((Wrapper)wrapper2);
        LambdaQueryWrapper wrapper3 = new LambdaQueryWrapper();
        wrapper3.eq(TrainingCourseStageTask::getCourseId, (Object)trainingCourseVo.getId());
        List trainingCourseStageTaskList = this.courseStageTaskMapper.selectList((Wrapper)wrapper3);
        Map<Object, Object> trainingCourseStageTaskMap = new HashMap();
        if (!CollectionUtils.isEmpty((Collection)trainingCourseStageTaskList)) {
            trainingCourseStageTaskMap = trainingCourseStageTaskList.stream().collect(Collectors.groupingBy(TrainingCourseStageTask::getStageId));
        }
        if (!CollectionUtils.isEmpty((Collection)trainingCourseStageList)) {
            for (TrainingCourseStage trainingCourseStage : trainingCourseStageList) {
                List trainingCourseStageTasks = (List)trainingCourseStageTaskMap.get(trainingCourseStage.getId());
                trainingCourseStage.setId(null);
                trainingCourseStage.setCourseId(trainingCourse.getId());
                trainingCourseStage.setCreater(user.getId());
                trainingCourseStage.setCreateTime(now);
                this.courseStageMapper.insert(trainingCourseStage);
                if (CollectionUtils.isEmpty((Collection)trainingCourseStageTasks)) continue;
                for (TrainingCourseStageTask trainingCourseStageTask : trainingCourseStageTasks) {
                    trainingCourseStageTask.setId(null);
                    trainingCourseStageTask.setCourseId(trainingCourse.getId());
                    trainingCourseStageTask.setStageId(trainingCourseStage.getId());
                    trainingCourseStageTask.setCreater(user.getId());
                    trainingCourseStageTask.setCreateTime(now);
                    if (trainingCourseStageTask.getTaskType() == 6 && trainingCourseStageTask.getWorkId() != null) {
                        trainingCourseStageTask.setIsBinding(Integer.valueOf(0));
                        trainingCourseStageTask.setWorkIdOld(trainingCourseStageTask.getWorkId());
                        TrainingWork work = this.trainingWorkService.insertSameWork(trainingCourseStageTask.getWorkId(), 5);
                        trainingCourseStageTask.setWorkId(work.getId());
                    } else if (trainingCourseStageTask.getTaskType() == 2 && trainingCourseStageTask.getPaperId() != null) {
                        trainingCourseStageTask.setIsBinding(Integer.valueOf(0));
                        trainingCourseStageTask.setPaperIdOld(trainingCourseStageTask.getPaperId());
                        Integer trainingPaperId = this.trainingPaperService.insertSamePaper(trainingCourseStageTask.getPaperId(), 4, user);
                        trainingCourseStageTask.setPaperId(trainingPaperId);
                    }
                    this.courseStageTaskMapper.insert(trainingCourseStageTask);
                }
            }
        }
        return trainingCourse.getId();
    }

    @Override
    public void updateTrainingCourse(TrainingCourseVo trainingCourseVo, Users user) {
        if (!org.springframework.util.StringUtils.isEmpty((Object)trainingCourseVo.getStatus()) && trainingCourseVo.getStatus() == 3) {
            trainingCourseVo.setEndTime(new Date());
            trainingCourseVo.setIsClose(Integer.valueOf(1));
        }
        this.courseMapper.updateById(trainingCourseVo);
        if (!org.springframework.util.StringUtils.isEmpty((Object)trainingCourseVo.getStatus())) {
            if (trainingCourseVo.getStatus() == 3) {
                SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                this.jPushService.updateMessagesByObjectType(trainingCourseVo.getId(), "TYPE_COURSE_SYSTEM", null, null, 1, format.format(new Date()));
                this.updateRoleUsersByClose(trainingCourseVo.getId(), user.getId(), user.getGroupId());
            } else if (trainingCourseVo.getStatus() == 0) {
                this.jPushService.deleteMessages(trainingCourseVo.getId(), "TYPE_COURSE_SYSTEM", null, null, 1);
            }
        }
    }

    @Override
    public String deleteCourse(TrainingCourseVo courseVo, Users user, LogPojo pojo) {
        TrainingCourse trainingCourse = (TrainingCourse)this.courseMapper.selectById(courseVo.getId());
        if (!pojo.getEnterpriseId().equals(trainingCourse.getEnterpriseId())) {
            return JsonResult.error((String)"NO_PERMISSION", (Object)"\u65e0\u6743\u9650\u5220\u9664");
        }
        if (!(org.springframework.util.StringUtils.isEmpty((Object)courseVo.getId()) || org.springframework.util.StringUtils.isEmpty((Object)trainingCourse) || org.springframework.util.StringUtils.isEmpty((Object)trainingCourse.getIsPush()) || trainingCourse.getIsPush() != 1)) {
            try {
                this.jPushService.deleteMessages(trainingCourse.getId(), "TYPE_COURSE_SYSTEM", null, null, 1);
            }
            catch (Exception e) {
                log.error("\u5220\u9664\u63a8\u9001\u4fe1\u606f", (Throwable)e);
            }
        }
        this.courseMapper.deleteById(courseVo.getId());
        LambdaUpdateWrapper wrapper1 = new LambdaUpdateWrapper();
        wrapper1.eq(TrainingCourseStage::getCourseId, (Object)courseVo.getId());
        this.courseStageMapper.delete((Wrapper)wrapper1);
        LambdaQueryWrapper wrapper4 = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)wrapper4.eq(TrainingCourseStageTask::getCourseId, (Object)courseVo.getId())).eq(TrainingCourseStageTask::getIsBinding, (Object)0);
        List trainingCourseStageTasks = this.courseStageTaskMapper.selectList((Wrapper)wrapper4);
        if (!CollectionUtils.isEmpty((Collection)trainingCourseStageTasks)) {
            List paperIds;
            List trainingIds = trainingCourseStageTasks.stream().map(TrainingCourseStageTask::getTrainingId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(trainingIds)) {
                LambdaUpdateWrapper wrapper0 = new LambdaUpdateWrapper();
                wrapper0.in(Training::getId, trainingIds);
                this.trainingMapper.delete((Wrapper)wrapper0);
                LambdaUpdateWrapper wrapper2 = new LambdaUpdateWrapper();
                wrapper2.in(TrainingAndMaterial::getTrainingId, trainingIds);
                this.andMaterialMapper.delete((Wrapper)wrapper2);
                LambdaQueryWrapper wrapper3 = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)wrapper3.in(TrainingChapter::getTrainingId, trainingIds)).eq(TrainingChapter::getIsDel, (Object)0);
                List chapterList = this.trainingChapterMapper.selectList((Wrapper)wrapper3);
                if (!CollectionUtils.isEmpty((Collection)chapterList)) {
                    List chapterIds = chapterList.stream().map(TrainingChapter::getId).collect(Collectors.toList());
                    this.trainingChapterMapper.deleteBatchIds(chapterIds);
                    LambdaUpdateWrapper wrapper5 = new LambdaUpdateWrapper();
                    wrapper5.in(TrainingChapterAttach::getChapterId, chapterIds);
                    this.trainingChapterAttachMapper.delete((Wrapper)wrapper5);
                }
            }
            if (!CollectionUtils.isEmpty(paperIds = trainingCourseStageTasks.stream().map(TrainingCourseStageTask::getPaperId).filter(Objects::nonNull).distinct().collect(Collectors.toList()))) {
                LambdaUpdateWrapper wrapper0 = new LambdaUpdateWrapper();
                wrapper0.in(TrainingPaper::getId, paperIds);
                this.trainingPaperMapper.delete((Wrapper)wrapper0);
            }
        }
        LambdaUpdateWrapper wrapper2 = new LambdaUpdateWrapper();
        wrapper2.eq(TrainingCourseStageTask::getCourseId, (Object)courseVo.getId());
        this.courseStageTaskMapper.delete((Wrapper)wrapper2);
        LambdaUpdateWrapper wrapper3 = new LambdaUpdateWrapper();
        wrapper3.eq(TrainingCourseUserTask::getCourseId, (Object)courseVo.getId());
        this.courseUserTaskMapper.delete((Wrapper)wrapper3);
        pojo.setI18nParam(trainingCourse.getCourseName());
        this.logApi.save(pojo);
        return JsonResult.success();
    }

    @Override
    public Integer saveTrainingCourseStage(TrainingCourseStageVo stageVo, Users user) {
        if (org.springframework.util.StringUtils.isEmpty((Object)stageVo.getId())) {
            stageVo.setEnterpriseId(user.getGroupId());
            stageVo.setCreater(user.getId());
            stageVo.setCreateTime(new Date());
            this.courseStageMapper.insert(stageVo);
        } else {
            this.courseStageMapper.updateById(stageVo);
        }
        return stageVo.getId();
    }

    @Override
    public void deleteCourseStage(TrainingCourseStageVo courseStageVo, Users user) {
        TrainingCourseStage courStage = (TrainingCourseStage)this.courseStageMapper.selectById(courseStageVo.getId());
        Integer courseId = courStage.getCourseId();
        this.courseStageMapper.deleteById(courseStageVo.getId());
        LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
        wrapper1.eq(TrainingCourseStageTask::getStageId, (Object)courseStageVo.getId());
        List taskList = this.courseStageTaskMapper.selectList((Wrapper)wrapper1);
        if (!CollectionUtils.isEmpty((Collection)taskList)) {
            List taskIdList = taskList.stream().map(TrainingCourseStageTask::getId).collect(Collectors.toList());
            this.courseStageTaskMapper.deleteBatchIds(taskIdList);
            LambdaUpdateWrapper wrapper2 = new LambdaUpdateWrapper();
            wrapper2.in(TrainingCourseUserTask::getTaskId, taskIdList);
            this.courseUserTaskMapper.delete((Wrapper)wrapper2);
        }
        LambdaQueryWrapper wrapper3 = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)wrapper3.eq(TrainingCourseStage::getCourseId, (Object)courseId)).orderByAsc(TrainingCourseStage::getStageSort);
        List courseStages = this.courseStageMapper.selectList((Wrapper)wrapper3);
        if (!CollectionUtils.isEmpty((Collection)courseStages)) {
            for (int i = 0; i < courseStages.size(); ++i) {
                ((TrainingCourseStage)courseStages.get(i)).setStageSort(Integer.valueOf(i + 1));
            }
            this.courseStageMapper.updateList(courseStages);
        }
    }

    @Override
    public Integer saveTrainingCourseStageTask(TrainingCourseStageTaskVo taskVo, Users user) {
        if (org.springframework.util.StringUtils.isEmpty((Object)taskVo.getId())) {
            taskVo.setEnterpriseId(user.getGroupId());
            taskVo.setCreater(user.getId());
            taskVo.setCreateTime(new Date());
            this.courseStageTaskMapper.insert(taskVo);
        } else {
            this.courseStageTaskMapper.updateById(taskVo);
        }
        return taskVo.getId();
    }

    @Override
    public void deleteCourseStageTask(TrainingCourseStageTaskVo courseStageTaskVo, Users user) {
        final TrainingCourseStageTask courStageTask = (TrainingCourseStageTask)this.courseStageTaskMapper.selectById(courseStageTaskVo.getId());
        if (courStageTask.getTaskType() == 1 && courStageTask.getIsBinding() == 0) {
            LambdaUpdateWrapper wrapper0 = new LambdaUpdateWrapper();
            wrapper0.eq(Training::getId, (Object)courStageTask.getTrainingId());
            this.trainingMapper.delete((Wrapper)wrapper0);
            LambdaUpdateWrapper wrapper2 = new LambdaUpdateWrapper();
            wrapper2.eq(TrainingAndMaterial::getTrainingId, (Object)courStageTask.getTrainingId());
            this.andMaterialMapper.delete((Wrapper)wrapper2);
            LambdaQueryWrapper wrapper3 = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)wrapper3.eq(TrainingChapter::getTrainingId, (Object)courStageTask.getTrainingId())).eq(TrainingChapter::getIsDel, (Object)0);
            List chapterList = this.trainingChapterMapper.selectList((Wrapper)wrapper3);
            if (!CollectionUtils.isEmpty((Collection)chapterList)) {
                List chapterIds = chapterList.stream().map(TrainingChapter::getId).collect(Collectors.toList());
                this.trainingChapterMapper.deleteBatchIds(chapterIds);
                LambdaUpdateWrapper wrapper4 = new LambdaUpdateWrapper();
                wrapper4.in(TrainingChapterAttach::getChapterId, chapterIds);
                this.trainingChapterAttachMapper.delete((Wrapper)wrapper4);
            }
        }
        this.courseStageTaskMapper.deleteById(courseStageTaskVo.getId());
        LambdaUpdateWrapper wrapper1 = new LambdaUpdateWrapper();
        wrapper1.eq(TrainingCourseUserTask::getTaskId, (Object)courseStageTaskVo.getId());
        this.courseUserTaskMapper.delete((Wrapper)wrapper1);
        LambdaQueryWrapper wrapper3 = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)wrapper3.eq(TrainingCourseStageTask::getStageId, (Object)courStageTask.getStageId())).orderByAsc(TrainingCourseStageTask::getTaskSort);
        List courseStageTasks = this.courseStageTaskMapper.selectList((Wrapper)wrapper3);
        if (!CollectionUtils.isEmpty((Collection)courseStageTasks)) {
            for (int i = 0; i < courseStageTasks.size(); ++i) {
                ((TrainingCourseStageTask)courseStageTasks.get(i)).setTaskSort(Integer.valueOf(i + 1));
            }
            this.courseStageTaskMapper.updateList(courseStageTasks);
        }
        CommonUtil.handleTask(new Runnable(){

            @Override
            public void run() {
                TrainingCourseServiceImpl.this.saveCourseEndWay(courStageTask.getCourseId());
            }
        });
    }

    public void saveCourseEndWay(Integer courseId) {
        if (courseId != null) {
            LambdaQueryWrapper wrapper2 = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper2.eq(TrainingCourseUserTask::getCourseId, (Object)courseId)).in(TrainingCourseUserTask::getTaskStatus, Arrays.asList(3, 4))).eq(TrainingCourseUserTask::getIsLast, (Object)1);
            List userTasks = this.courseUserTaskMapper.selectList((Wrapper)wrapper2);
            if (!CollectionUtils.isEmpty((Collection)userTasks)) {
                List userIds = userTasks.stream().map(TrainingCourseUserTask::getUserId).distinct().collect(Collectors.toList());
                for (Integer userId : userIds) {
                    this.getIsFinishCourse(Collections.singletonList(courseId), userId);
                }
            }
        }
    }

    @Override
    public void updateStageSort(List<TrainingCourseStage> voList, Users user) {
        if (!CollectionUtils.isEmpty(voList)) {
            for (int i = 0; i < voList.size(); ++i) {
                voList.get(i).setStageSort(Integer.valueOf(i + 1));
            }
            this.courseStageMapper.updateList(voList);
        }
    }

    @Override
    public void updateTaskSort(List<TrainingCourseStageTask> voList, Users user) {
        if (!CollectionUtils.isEmpty(voList)) {
            for (int i = 0; i < voList.size(); ++i) {
                voList.get(i).setTaskSort(Integer.valueOf(i + 1));
            }
            this.courseStageTaskMapper.updateList(voList);
        }
    }

    @Override
    public Page<TrainingCourseVo> selectTrainingCourseByPage(Page<TrainingCourseVo> page, Users user, String courseName, Integer status) {
        List<TrainingCourseVo> list = this.courseMapper.selectTrainingCourseByPage(page, user.getGroupId(), courseName, status);
        if (!CollectionUtils.isEmpty(list)) {
            List createrList = list.stream().map(TrainingCourse::getCreater).distinct().collect(Collectors.toList());
            BaseResult pojoBaseList = this.userApi.getSimpleUserByIdList(createrList);
            Map<Object, Object> pojoMap = new HashMap();
            if (pojoBaseList != null) {
                List pojoList = (List)pojoBaseList.getData();
                pojoMap = pojoList.stream().collect(Collectors.toMap(SimplePojo::getId, Function.identity()));
            }
            List<Integer> idList = list.stream().map(TrainingCourse::getId).distinct().collect(Collectors.toList());
            LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)wrapper1.in(TrainingCourseUser::getCourseId, idList)).eq(TrainingCourseUser::getCourseType, (Object)1);
            List courseUserList = this.courseUserMapper.selectList((Wrapper)wrapper1);
            Map<Object, Object> courseUserMap = new HashMap();
            if (!CollectionUtils.isEmpty((Collection)courseUserList)) {
                courseUserMap = courseUserList.stream().collect(Collectors.groupingBy(TrainingCourseUser::getCourseId));
            }
            List<Object> appointAllIdList = new ArrayList();
            int appointAllNum = 0;
            BaseResult simplePojoBaseResult = this.userApi.getSimpleUserByKeyWord(user.getGroupId(), null, null);
            if (simplePojoBaseResult != null && !CollectionUtils.isEmpty((Collection)((Collection)simplePojoBaseResult.getData()))) {
                appointAllIdList = ((List)simplePojoBaseResult.getData()).stream().map(SimplePojo::getId).distinct().collect(Collectors.toList());
                appointAllNum = appointAllIdList.size();
            }
            List<TrainingCourseUserTaskVo> userTaskVos = this.courseUserTaskMapper.selectTaskByUser(idList, Arrays.asList(3, 4));
            ArrayList<TrainingCourseUserTaskVo> userTaskVosNoDelF = new ArrayList<TrainingCourseUserTaskVo>(userTaskVos);
            Iterator iterator = userTaskVosNoDelF.iterator();
            while (iterator.hasNext()) {
                TrainingCourseUserTaskVo next = (TrainingCourseUserTaskVo)iterator.next();
                if (appointAllIdList.contains(next.getUserId())) continue;
                iterator.remove();
            }
            Map<Object, Object> UserTaskMap = new HashMap();
            Map<Object, Object> UserTaskMapNoDelF = new HashMap();
            if (!CollectionUtils.isEmpty(userTaskVos)) {
                UserTaskMap = userTaskVos.stream().collect(Collectors.groupingBy(TrainingCourseUserTask::getCourseId));
            }
            if (!CollectionUtils.isEmpty(userTaskVosNoDelF)) {
                UserTaskMapNoDelF = userTaskVosNoDelF.stream().collect(Collectors.groupingBy(TrainingCourseUserTask::getCourseId));
            }
            for (TrainingCourseVo courseVo : list) {
                int appointNum = appointAllNum;
                ArrayList<Object> appointAllIds = new ArrayList<Object>(appointAllIdList);
                courseVo.setCreateName(pojoMap.get(courseVo.getCreater()) != null ? ((SimplePojo)pojoMap.get(courseVo.getCreater())).getName() : "");
                if (courseVo.getAppointType() == 1) {
                    List courseUsers = (List)courseUserMap.get(courseVo.getId());
                    if (!CollectionUtils.isEmpty((Collection)courseUsers)) {
                        String roleIdStr;
                        com.ovopark.privilege.response.BaseResult baseResult;
                        List<Object> allId = new ArrayList();
                        List userIds = courseUsers.stream().map(TrainingCourseUser::getUserId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
                        List roleIds = courseUsers.stream().map(TrainingCourseUser::getRoleId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
                        List organizeIds = courseUsers.stream().map(TrainingCourseUser::getOrganizeId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
                        List tagIds = courseUsers.stream().map(TrainingCourseUser::getTagId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
                        if (!CollectionUtils.isEmpty(userIds)) {
                            allId.addAll(userIds);
                        }
                        if (!CollectionUtils.isEmpty(roleIds) && (baseResult = this.useApi.getUserByRoleIds(roleIdStr = StringUtils.join(roleIds, (String)","), user.getGroupId())) != null && !CollectionUtils.isEmpty((Collection)((Collection)baseResult.getData()))) {
                            List pojo = (List)baseResult.getData();
                            List collect = pojo.stream().map(com.ovopark.privilege.pojo.UsersPojo::getId).collect(Collectors.toList());
                            allId.addAll(collect);
                        }
                        if (!CollectionUtils.isEmpty(organizeIds)) {
                            UsersAndOrgsMo mo = new UsersAndOrgsMo();
                            mo.setGroupId(user.getGroupId());
                            mo.setOrganizeIds(organizeIds);
                            BaseResult userResult = this.userOrganizeApi.getUserByOrganizeIdsOrDepId(mo);
                            if (!userResult.getIsError().booleanValue() && !CollectionUtils.isEmpty((Collection)((Collection)userResult.getData()))) {
                                List users = ((List)userResult.getData()).stream().map(UserAndParentNameMo::getUserId).distinct().collect(Collectors.toList());
                                allId.addAll(users);
                            }
                        }
                        if (!CollectionUtils.isEmpty(tagIds)) {
                            DepAndTagsPojo pojo = new DepAndTagsPojo();
                            pojo.setGroupId(user.getGroupId());
                            pojo.setTagIds(tagIds);
                            pojo.setUserId(user.getId());
                            BaseResult tagResult = this.tagApi.getUsersByTags(pojo);
                            if (!tagResult.getIsError().booleanValue() && !CollectionUtils.isEmpty((Collection)((Collection)tagResult.getData()))) {
                                List collect = ((List)tagResult.getData()).stream().map(u -> (int)((Integer)u.get("id"))).collect(Collectors.toList());
                                allId.addAll(collect);
                            }
                        }
                        allId = allId.stream().distinct().collect(Collectors.toList());
                        if (courseVo.getStatus() != 3) {
                            allId.retainAll(appointAllIds);
                            appointNum = allId.size();
                        } else {
                            appointNum = allId.size();
                        }
                    }
                } else if (courseVo.getStatus() == 3 && !CollectionUtils.isEmpty(appointAllIds)) {
                    SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    BaseResult base = this.userApi.getUserGtCreateTime(courseVo.getEnterpriseId(), format.format(courseVo.getEndTime()));
                    if (base != null && !CollectionUtils.isEmpty((Collection)((Collection)base.getData()))) {
                        List userRemoveList = (List)base.getData();
                        appointAllIds.removeAll(userRemoveList);
                        appointNum = appointAllIds.size();
                    }
                }
                courseVo.setAppointNum(Integer.valueOf(appointNum));
                int finishNum = 0;
                List courseUserTaskList = null;
                courseUserTaskList = courseVo.getStatus() != 3 ? (List)UserTaskMapNoDelF.get(courseVo.getId()) : (List)UserTaskMap.get(courseVo.getId());
                if (!CollectionUtils.isEmpty((Collection)courseUserTaskList)) {
                    for (TrainingCourseUserTaskVo vo : courseUserTaskList) {
                        if (courseVo.getTaskNum() > vo.getTaskNum()) continue;
                        ++finishNum;
                    }
                }
                courseVo.setFinishNum(Integer.valueOf(finishNum));
                String finishRateValue = "";
                if (appointNum > 0) {
                    BigDecimal finishRate = new BigDecimal(finishNum * 100).divide(new BigDecimal(appointNum), 2, 4);
                    finishRateValue = finishRate.toString() + "%";
                } else {
                    finishRateValue = "-";
                }
                courseVo.setFinishRateValue(finishRateValue);
            }
        }
        page.setContent(list);
        return page;
    }

    @Override
    public TrainingCourseVo selectCourseUserStatus(TrainingCourseVo courseVo, Users user) {
        BaseResult simplePojoBaseResult;
        TrainingCourse course = (TrainingCourse)this.courseMapper.selectById(courseVo.getId());
        List<Object> appointNumsList = new ArrayList();
        if (!(course.getStatus() == 3 && course.getAppointType() == 1 || (simplePojoBaseResult = this.userApi.getSimpleUserByKeyWord(user.getGroupId(), null, null)) == null || CollectionUtils.isEmpty((Collection)((Collection)simplePojoBaseResult.getData())))) {
            appointNumsList = ((List)simplePojoBaseResult.getData()).stream().map(SimplePojo::getId).distinct().collect(Collectors.toList());
        }
        if (!CollectionUtils.isEmpty(appointNumsList)) {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            BaseResult base = this.userApi.getUserGtCreateTime(course.getEnterpriseId(), format.format(course.getEndTime()));
            if (base != null && !CollectionUtils.isEmpty((Collection)((Collection)base.getData()))) {
                List userRemoveList = (List)base.getData();
                appointNumsList.removeAll(userRemoveList);
            }
        }
        if (!ObjectUtils.isEmpty((Object)course)) {
            BeanUtils.copyProperties((Object)course, (Object)courseVo);
            LambdaQueryWrapper wrapper0 = new LambdaQueryWrapper();
            wrapper0.eq(TrainingCourseStageTask::getCourseId, (Object)courseVo.getId());
            List stageTaskList = this.courseStageTaskMapper.selectList((Wrapper)wrapper0);
            int taskCount = stageTaskList.size();
            Map stageTasksMap = stageTaskList.stream().collect(Collectors.toMap(TrainingCourseStageTask::getId, Function.identity()));
            List<Object> allIds = new ArrayList();
            int allCount = 0;
            if (!org.springframework.util.StringUtils.isEmpty((Object)courseVo.getAppointType()) && courseVo.getAppointType() == 1) {
                List tagIds;
                List organizeIds;
                DepAndTagsPojo pojo;
                String roleIdStr;
                com.ovopark.privilege.response.BaseResult baseResult;
                List roleIds;
                LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)wrapper1.eq(TrainingCourseUser::getCourseId, (Object)courseVo.getId())).eq(TrainingCourseUser::getCourseType, (Object)1);
                List courseUserList = this.courseUserMapper.selectList((Wrapper)wrapper1);
                List userIds = courseUserList.stream().map(TrainingCourseUser::getUserId).distinct().filter(Objects::nonNull).collect(Collectors.toList());
                if (!CollectionUtils.isEmpty(userIds)) {
                    allIds.addAll(userIds);
                }
                if (!CollectionUtils.isEmpty(roleIds = courseUserList.stream().map(TrainingCourseUser::getRoleId).filter(Objects::nonNull).distinct().collect(Collectors.toList())) && (baseResult = this.useApi.getUserByRoleIds(roleIdStr = StringUtils.join(roleIds, (String)","), user.getGroupId())) != null && !CollectionUtils.isEmpty((Collection)((Collection)baseResult.getData()))) {
                    pojo = ((List)baseResult.getData()).stream().map(com.ovopark.privilege.pojo.UsersPojo::getId).distinct().collect(Collectors.toList());
                    allIds.addAll((Collection<Object>)pojo);
                }
                if (!CollectionUtils.isEmpty(organizeIds = courseUserList.stream().map(TrainingCourseUser::getOrganizeId).filter(Objects::nonNull).distinct().collect(Collectors.toList()))) {
                    UsersAndOrgsMo mo = new UsersAndOrgsMo();
                    mo.setGroupId(user.getGroupId());
                    mo.setOrganizeIds(organizeIds);
                    BaseResult userResult = this.userOrganizeApi.getUserByOrganizeIdsOrDepId(mo);
                    if (!userResult.getIsError().booleanValue() && !CollectionUtils.isEmpty((Collection)((Collection)userResult.getData()))) {
                        List users = ((List)userResult.getData()).stream().map(UserAndParentNameMo::getUserId).distinct().collect(Collectors.toList());
                        allIds.addAll(users);
                    }
                }
                if (!CollectionUtils.isEmpty(tagIds = courseUserList.stream().map(TrainingCourseUser::getTagId).filter(Objects::nonNull).distinct().collect(Collectors.toList()))) {
                    pojo = new DepAndTagsPojo();
                    pojo.setGroupId(user.getGroupId());
                    pojo.setTagIds(tagIds);
                    pojo.setUserId(user.getId());
                    BaseResult tagResult = this.tagApi.getUsersByTags(pojo);
                    if (!tagResult.getIsError().booleanValue() && !CollectionUtils.isEmpty((Collection)((Collection)tagResult.getData()))) {
                        for (Map map : (List)tagResult.getData()) {
                            Integer id = (Integer)map.get("id");
                            allIds.add(id);
                        }
                    }
                }
                allIds = allIds.stream().distinct().collect(Collectors.toList());
                allCount = allIds.size();
                if (course.getStatus() != 3) {
                    allIds.retainAll(appointNumsList);
                    allCount = allIds.size();
                }
            } else {
                allIds = appointNumsList;
                allCount = allIds.size();
            }
            courseVo.setAllCount(Integer.valueOf(allCount));
            List userStartList = new ArrayList();
            if (!CollectionUtils.isEmpty(allIds)) {
                LambdaQueryWrapper wrapper2 = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper2.eq(TrainingCourseUserTask::getCourseId, (Object)courseVo.getId())).ne(TrainingCourseUserTask::getTaskStatus, (Object)1)).in(TrainingCourseUserTask::getUserId, allIds);
                userStartList = this.courseUserTaskMapper.selectList((Wrapper)wrapper2);
            }
            Integer notCount = allCount;
            if (!CollectionUtils.isEmpty(userStartList)) {
                List startUserIdList = userStartList.stream().map(TrainingCourseUserTask::getUserId).distinct().filter(Objects::nonNull).collect(Collectors.toList());
                if (course.getStatus() != 3) {
                    startUserIdList.retainAll(appointNumsList);
                }
                notCount = allCount - startUserIdList.size();
            }
            courseVo.setNotCount(notCount);
            List finishList = new ArrayList();
            if (!CollectionUtils.isEmpty(allIds)) {
                LambdaQueryWrapper wrapper3 = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper3.eq(TrainingCourseUserTask::getCourseId, (Object)courseVo.getId())).in(TrainingCourseUserTask::getTaskStatus, Arrays.asList(3, 4))).in(TrainingCourseUserTask::getUserId, allIds);
                finishList = this.courseUserTaskMapper.selectList((Wrapper)wrapper3);
            }
            if (course.getStatus() != 3 && !CollectionUtils.isEmpty(finishList)) {
                Iterator iterator = finishList.iterator();
                while (iterator.hasNext()) {
                    TrainingCourseUserTask next = (TrainingCourseUserTask)iterator.next();
                    if (appointNumsList.contains(next.getUserId())) continue;
                    iterator.remove();
                }
            }
            int onTimeCount = 0;
            Integer overTimeCount = 0;
            LambdaQueryWrapper wrapperU = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapperU.eq(TrainingPaperUserTurns::getProjectId, (Object)courseVo.getId())).eq(TrainingPaperUserTurns::getTurnType, (Object)4)).orderByDesc(TrainingPaperUserTurns::getTurns);
            List paperUserTurns = this.paperUserTurnsMapper.selectList((Wrapper)wrapperU);
            Map<Object, Object> turnMap = new HashMap();
            if (!CollectionUtils.isEmpty((Collection)paperUserTurns)) {
                turnMap = paperUserTurns.stream().collect(Collectors.groupingBy(TrainingPaperUserTurns::getUserId));
            }
            BigDecimal finishRate = new BigDecimal(0);
            if (!CollectionUtils.isEmpty(finishList)) {
                ArrayList<TrainingCourseUserTask> delList = new ArrayList<TrainingCourseUserTask>();
                block2: for (TrainingCourseUserTask courseUserTask : finishList) {
                    TrainingCourseStageTask task = (TrainingCourseStageTask)stageTasksMap.get(courseUserTask.getTaskId());
                    List paperUserTurnsList = (List)turnMap.get(courseUserTask.getUserId());
                    if (!CollectionUtils.isEmpty((Collection)paperUserTurnsList)) {
                        for (TrainingPaperUserTurns userTurns : paperUserTurnsList) {
                            if (task.getStageId().intValue() != userTurns.getStageId().intValue() || courseUserTask.getTurns().intValue() == userTurns.getTurns().intValue()) continue;
                            delList.add(courseUserTask);
                            continue block2;
                        }
                        continue;
                    }
                    if (courseUserTask.getTurns() == 1) continue;
                    delList.add(courseUserTask);
                }
                if (!CollectionUtils.isEmpty(delList)) {
                    finishList.removeAll(delList);
                }
                Map<Integer, List<TrainingCourseUserTask>> userTaskMap = finishList.stream().collect(Collectors.groupingBy(TrainingCourseUserTask::getUserId));
                List finishUserIdList = finishList.stream().map(TrainingCourseUserTask::getUserId).distinct().collect(Collectors.toList());
                block4: for (Integer userId : finishUserIdList) {
                    List<TrainingCourseUserTask> userTasks = userTaskMap.get(userId);
                    if (userTasks.size() < taskCount) continue;
                    ++onTimeCount;
                    for (TrainingCourseUserTask userTask : userTasks) {
                        if (userTask.getTaskStatus() != 4) continue;
                        Integer n = overTimeCount;
                        Integer n2 = overTimeCount = Integer.valueOf(overTimeCount + 1);
                        continue block4;
                    }
                }
                finishRate = new BigDecimal(onTimeCount).divide(new BigDecimal(allCount), 4, 4);
                onTimeCount -= overTimeCount.intValue();
            }
            courseVo.setFinishRate(finishRate);
            courseVo.setOnTimeCount(Integer.valueOf(onTimeCount));
            courseVo.setOverTimeCount(overTimeCount);
            courseVo.setGoingCount(Integer.valueOf(Math.max(allCount - onTimeCount - overTimeCount - notCount, 0)));
        }
        return courseVo;
    }

    @Override
    public List<Integer> selectCourseOrganizeStatus(Integer courseId, Integer organizeId, String organizName, Users user) {
        List organizeIdList = null;
        organizeIdList = organizeId != null ? (List)this.organizeApi.getChilldOrganizeByUserIdAndOrgId(user.getGroupId(), organizeId, user.getId()).getData() : (List)this.organizeApi.getChilldOrganizeByUserIdAndOrgId(user.getGroupId(), null, user.getId()).getData();
        return organizeIdList;
    }

    @Override
    public Page<TrainingCourseUserTaskVo> selectCourseUserAnalysisByPage(Page<TrainingCourseUserTaskVo> page, Integer courseId, Users user, String name, Integer status, String organizeIds, Integer turns, Integer sort, String roles) {
        BaseResult base;
        com.ovopark.privilege.response.BaseResult userByRoleId;
        BaseResult simplePojoBaseResult;
        Page newPage = new Page();
        TrainingCourse course = (TrainingCourse)this.courseMapper.selectById(courseId);
        if (ObjectUtils.isEmpty((Object)course)) {
            return newPage;
        }
        List<Object> appointIdList = new ArrayList();
        if (!(course.getStatus() == 3 && course.getAppointType() == 1 || (simplePojoBaseResult = this.userApi.getSimpleUserByKeyWord(user.getGroupId(), null, null)) == null || CollectionUtils.isEmpty((Collection)((Collection)simplePojoBaseResult.getData())))) {
            appointIdList = ((List)simplePojoBaseResult.getData()).stream().map(SimplePojo::getId).distinct().collect(Collectors.toList());
        }
        LambdaQueryWrapper wrapper0 = new LambdaQueryWrapper();
        wrapper0.eq(TrainingCourseStageTask::getCourseId, (Object)courseId);
        List stageTaskList = this.courseStageTaskMapper.selectList((Wrapper)wrapper0);
        int taskCount = stageTaskList.size();
        List<Object> userIdList = new ArrayList();
        Map stageTasksMap = stageTaskList.stream().collect(Collectors.toMap(TrainingCourseStageTask::getId, Function.identity()));
        List<Object> allUserIdList = new ArrayList<Object>();
        if (!org.springframework.util.StringUtils.isEmpty((Object)course.getAppointType()) && course.getAppointType() == 1) {
            LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)wrapper1.eq(TrainingCourseUser::getCourseId, (Object)courseId)).eq(TrainingCourseUser::getCourseType, (Object)1);
            List courseUserList = this.courseUserMapper.selectList((Wrapper)wrapper1);
            if (!CollectionUtils.isEmpty((Collection)courseUserList)) {
                String roleIdStr;
                com.ovopark.privilege.response.BaseResult baseResult;
                ArrayList<Integer> userIds = new ArrayList<Integer>();
                ArrayList<Integer> roleIds = new ArrayList<Integer>();
                ArrayList<String> orgIds = new ArrayList<String>();
                ArrayList<Integer> tagIds = new ArrayList<Integer>();
                for (TrainingCourseUser trainingCourseUser : courseUserList) {
                    if (trainingCourseUser.getUserId() != null) {
                        userIds.add(trainingCourseUser.getUserId());
                        continue;
                    }
                    if (trainingCourseUser.getRoleId() != null) {
                        roleIds.add(trainingCourseUser.getRoleId());
                        continue;
                    }
                    if (!org.springframework.util.StringUtils.isEmpty((Object)trainingCourseUser.getOrganizeId())) {
                        orgIds.add(trainingCourseUser.getOrganizeId());
                        continue;
                    }
                    if (trainingCourseUser.getTagId() == null) continue;
                    tagIds.add(trainingCourseUser.getTagId());
                }
                if (!CollectionUtils.isEmpty(userIds)) {
                    allUserIdList.addAll(userIds);
                }
                if (!CollectionUtils.isEmpty(roleIds) && (baseResult = this.useApi.getUserByRoleIds(roleIdStr = StringUtils.join(roleIds, (String)","), user.getGroupId())) != null && !CollectionUtils.isEmpty((Collection)((Collection)baseResult.getData()))) {
                    List pojo = ((List)baseResult.getData()).stream().map(com.ovopark.privilege.pojo.UsersPojo::getId).distinct().collect(Collectors.toList());
                    allUserIdList.addAll(pojo);
                }
                if (!CollectionUtils.isEmpty(orgIds)) {
                    UsersAndOrgsMo mo = new UsersAndOrgsMo();
                    mo.setGroupId(user.getGroupId());
                    mo.setOrganizeIds(orgIds);
                    BaseResult userResult = this.userOrganizeApi.getUserByOrganizeIdsOrDepId(mo);
                    if (!userResult.getIsError().booleanValue() && !CollectionUtils.isEmpty((Collection)((Collection)userResult.getData()))) {
                        List users = ((List)userResult.getData()).stream().map(UserAndParentNameMo::getUserId).distinct().collect(Collectors.toList());
                        allUserIdList.addAll(users);
                    }
                }
                if (!CollectionUtils.isEmpty(tagIds)) {
                    DepAndTagsPojo pojo = new DepAndTagsPojo();
                    pojo.setGroupId(user.getGroupId());
                    pojo.setTagIds(tagIds);
                    pojo.setUserId(user.getId());
                    BaseResult tagResult = this.tagApi.getUsersByTags(pojo);
                    if (!tagResult.getIsError().booleanValue() && !CollectionUtils.isEmpty((Collection)((Collection)tagResult.getData()))) {
                        for (Map map : (List)tagResult.getData()) {
                            Integer id = (Integer)map.get("id");
                            allUserIdList.add(id);
                        }
                    }
                }
            }
            allUserIdList = allUserIdList.stream().distinct().collect(Collectors.toList());
            if (course.getStatus() != 3) {
                allUserIdList.retainAll(appointIdList);
            }
        } else {
            allUserIdList.addAll(appointIdList);
        }
        if (!org.springframework.util.StringUtils.isEmpty((Object)name)) {
            BaseResult base2 = this.userApi.getSimpleUserByKeyWord(user.getGroupId(), name, null);
            if (base2 != null) {
                userIdList = ((List)base2.getData()).stream().map(SimplePojo::getId).collect(Collectors.toList());
                allUserIdList.retainAll(userIdList);
            } else {
                allUserIdList = new ArrayList();
            }
        }
        if (organizeIds != null && !"".equals(organizeIds)) {
            List<String> organizeIdList = Arrays.asList(organizeIds.split(","));
            UsersAndOrgsMo mo = new UsersAndOrgsMo();
            mo.setGroupId(user.getGroupId());
            mo.setOrganizeIds(organizeIdList);
            BaseResult base3 = this.userOrganizeApi.getUserByOrganizeIdsOrDepId(mo);
            if (base3 != null && !CollectionUtils.isEmpty((Collection)((Collection)base3.getData()))) {
                List userIds = ((List)base3.getData()).stream().map(UserAndParentNameMo::getUserId).distinct().collect(Collectors.toList());
                allUserIdList.retainAll(userIds);
            } else {
                allUserIdList = new ArrayList();
            }
        }
        if (!CollectionUtils.isEmpty(allUserIdList)) {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            BaseResult base4 = this.userApi.getUserGtCreateTime(course.getEnterpriseId(), format.format(course.getEndTime()));
            if (base4 != null && !CollectionUtils.isEmpty((Collection)((Collection)base4.getData()))) {
                List userRemoveList = (List)base4.getData();
                allUserIdList.removeAll(userRemoveList);
            }
        }
        LambdaQueryWrapper wrapper2 = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper2.eq(TrainingCourseUserTask::getCourseId, (Object)courseId)).ne(TrainingCourseUserTask::getTaskStatus, (Object)1)).orderByDesc(TrainingCourseUserTask::getTurns);
        List userStartList = this.courseUserTaskMapper.selectList((Wrapper)wrapper2);
        if (course.getStatus() != 3) {
            Iterator iterator = userStartList.iterator();
            while (iterator.hasNext()) {
                TrainingCourseUserTask next = (TrainingCourseUserTask)iterator.next();
                if (appointIdList.contains(next.getUserId())) continue;
                iterator.remove();
            }
        }
        Map<Object, Object> onTaskMap = new HashMap();
        if (!CollectionUtils.isEmpty((Collection)userStartList)) {
            onTaskMap = userStartList.stream().collect(Collectors.groupingBy(TrainingCourseUserTask::getUserId));
        }
        LambdaQueryWrapper wrapperU = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapperU.eq(TrainingPaperUserTurns::getProjectId, (Object)courseId)).eq(TrainingPaperUserTurns::getTurnType, (Object)4)).orderByDesc(TrainingPaperUserTurns::getTurns);
        List paperUserTurns = this.paperUserTurnsMapper.selectList((Wrapper)wrapperU);
        Map<Object, Object> turnMap = new HashMap();
        if (!CollectionUtils.isEmpty((Collection)paperUserTurns)) {
            turnMap = paperUserTurns.stream().collect(Collectors.groupingBy(TrainingPaperUserTurns::getUserId));
        }
        LambdaQueryWrapper wrapper3 = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper3.eq(TrainingCourseUserTask::getCourseId, (Object)courseId)).in(TrainingCourseUserTask::getTaskStatus, Arrays.asList(3, 4))).orderByDesc(TrainingCourseUserTask::getTurns);
        List finishList = this.courseUserTaskMapper.selectList((Wrapper)wrapper3);
        if (course.getStatus() != 3) {
            Iterator iterator = finishList.iterator();
            while (iterator.hasNext()) {
                TrainingCourseUserTask next = (TrainingCourseUserTask)iterator.next();
                if (appointIdList.contains(next.getUserId())) continue;
                iterator.remove();
            }
        }
        Map<Object, Object> userTaskMap = new HashMap();
        if (!CollectionUtils.isEmpty((Collection)finishList)) {
            ArrayList<TrainingCourseUserTask> delList = new ArrayList<TrainingCourseUserTask>();
            block4: for (TrainingCourseUserTask courseUserTask : finishList) {
                TrainingCourseStageTask task = (TrainingCourseStageTask)stageTasksMap.get(courseUserTask.getTaskId());
                List paperUserTurnsList = (List)turnMap.get(courseUserTask.getUserId());
                if (!CollectionUtils.isEmpty((Collection)paperUserTurnsList)) {
                    Iterator iterator = paperUserTurnsList.iterator();
                    while (iterator.hasNext()) {
                        TrainingPaperUserTurns userTurns = (TrainingPaperUserTurns)iterator.next();
                        if (task.getStageId().intValue() != userTurns.getStageId().intValue() || courseUserTask.getTurns().intValue() == userTurns.getTurns().intValue()) continue;
                        delList.add(courseUserTask);
                        continue block4;
                    }
                    continue;
                }
                if (courseUserTask.getTurns() == 1) continue;
                delList.add(courseUserTask);
            }
            if (!CollectionUtils.isEmpty(delList)) {
                finishList.removeAll(delList);
            }
            userTaskMap = finishList.stream().collect(Collectors.groupingBy(TrainingCourseUserTask::getUserId));
        }
        if (!org.springframework.util.StringUtils.isEmpty((Object)status)) {
            List<Object> startUserIdList = new ArrayList();
            if (!CollectionUtils.isEmpty((Collection)userStartList)) {
                startUserIdList = userStartList.stream().map(TrainingCourseUserTask::getUserId).distinct().collect(Collectors.toList());
            }
            if (status == 1) {
                allUserIdList.removeAll(startUserIdList);
            } else {
                ArrayList<Integer> overList = new ArrayList<Integer>();
                ArrayList<Integer> onList = new ArrayList<Integer>();
                if (!CollectionUtils.isEmpty((Collection)finishList)) {
                    List finishUserIdList = finishList.stream().map(TrainingCourseUserTask::getUserId).distinct().collect(Collectors.toList());
                    block6: for (Integer userId : finishUserIdList) {
                        List userTasks = (List)userTaskMap.get(userId);
                        if (userTasks.size() < taskCount) continue;
                        onList.add(userId);
                        for (TrainingCourseUserTask userTask : userTasks) {
                            if (userTask.getTaskStatus() != 4) continue;
                            overList.add(userId);
                            continue block6;
                        }
                    }
                    startUserIdList.removeAll(onList);
                    onList.removeAll(overList);
                }
                if (status == 2) {
                    allUserIdList.retainAll(startUserIdList);
                } else if (status == 3) {
                    allUserIdList.retainAll(onList);
                } else if (status == 4) {
                    allUserIdList.retainAll(overList);
                }
            }
        }
        List<Object> roleList = new ArrayList();
        if (!org.springframework.util.StringUtils.isEmpty((Object)roles) && (userByRoleId = this.roleApi.geteByGroupIdAndRoleIds(roleList = Arrays.stream(roles.split(",")).map(Integer::parseInt).collect(Collectors.toList()), user.getGroupId())) != null) {
            List userIdByRoleId = ((List)userByRoleId.getData()).stream().map(UserRoleMo::getUserId).collect(Collectors.toList());
            allUserIdList.retainAll(userIdByRoleId);
        }
        ArrayList<TrainingCourseUserTaskVo> userTaskList = new ArrayList<TrainingCourseUserTaskVo>();
        if (!CollectionUtils.isEmpty(allUserIdList) && (base = this.userApi.getUserByIdList(allUserIdList)) != null && !CollectionUtils.isEmpty((Collection)((Collection)base.getData()))) {
            Map pojoMap = ((List)base.getData()).stream().collect(Collectors.toMap(UsersPojo::getId, Function.identity()));
            Map<Integer, String> userOrganizeMap = this.userUtilService.selectUserOrganizeName(user.getGroupId(), allUserIdList);
            Map<Integer, String> parentMap = this.userUtilService.selectParentMap(allUserIdList, user.getGroupId());
            Map userRoleMap = new HashMap();
            if (!CollectionUtils.isEmpty(allUserIdList)) {
                HashMap<String, Object> parameter = new HashMap<String, Object>();
                parameter.put("userIds", StringUtils.join(allUserIdList, (String)","));
                parameter.put("groupId", user.getGroupId());
                com.ovopark.privilege.response.BaseResult roleBase = this.roleApi.getUserRoleList(parameter);
                if (roleBase != null) {
                    userRoleMap = (Map)roleBase.getData();
                }
            }
            Map<Integer, UserDutiesMo> dutiesMap = this.userUtilService.selectDutiesMap(allUserIdList, user.getGroupId());
            Map<Integer, Integer> parentIdMap = this.userUtilService.selectParentIdMap(allUserIdList, user.getGroupId());
            Map<Object, Object> trainingCourseUserAnalyseMap = new HashMap();
            Map<Object, Object> trainingCertificateDetailMap = new HashMap();
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)queryWrapper.eq(TrainingCourseUserAnalyse::getCourseId, (Object)courseId)).in(TrainingCourseUserAnalyse::getUserId, allUserIdList);
            queryWrapper.eq(TrainingCourseUserAnalyse::getPassStatus, (Object)1);
            List trainingCourseUserAnalyseList = this.trainingCourseUserAnalyseMapper.selectList((Wrapper)queryWrapper);
            if (!CollectionUtils.isEmpty((Collection)trainingCourseUserAnalyseList)) {
                List list;
                trainingCourseUserAnalyseMap = trainingCourseUserAnalyseList.stream().collect(Collectors.groupingBy(TrainingCourseUserAnalyse::getUserId));
                ArrayList<Integer> cerIdList = new ArrayList<Integer>();
                for (TrainingCourseUserAnalyse trainingCourseUserAnalyse : trainingCourseUserAnalyseList) {
                    if (trainingCourseUserAnalyse.getCertificateId() == null || trainingCourseUserAnalyse.getCertificateId() == 0) continue;
                    cerIdList.add(trainingCourseUserAnalyse.getCertificateId());
                }
                if (!CollectionUtils.isEmpty(cerIdList) && !CollectionUtils.isEmpty((Collection)(list = this.certificateDetailMapper.selectBatchIds(cerIdList)))) {
                    trainingCertificateDetailMap = list.stream().collect(Collectors.toMap(TrainingCertificateDetail::getId, Function.identity()));
                }
            }
            for (Integer n : allUserIdList) {
                Integer detailId;
                List userTasks;
                TrainingCourseUserTaskVo taskVo = new TrainingCourseUserTaskVo();
                taskVo.setUserId(n);
                UsersPojo pojo = (UsersPojo)pojoMap.get(n);
                taskVo.setUserName(pojo.getShowName());
                taskVo.setShowName(pojo.getUserName());
                taskVo.setParentName(parentMap.get(n));
                taskVo.setTaskNum(Integer.valueOf(taskCount));
                taskVo.setEmployeeNumber(pojo.getEmployeeNumber());
                ArrayList roleName = new ArrayList();
                if (!CollectionUtils.isEmpty((Collection)((Collection)userRoleMap.get(n)))) {
                    ((List)userRoleMap.get(n)).forEach(rolePojo -> roleName.add(rolePojo.getRoleName()));
                }
                taskVo.setRole(String.join((CharSequence)";\n", roleName));
                if (!CollectionUtils.isEmpty(dutiesMap) && dutiesMap.get(taskVo.getUserId()) != null) {
                    taskVo.setPost(dutiesMap.get(taskVo.getUserId()).getDutieName());
                }
                if (!CollectionUtils.isEmpty(parentIdMap)) {
                    taskVo.setParentUserId(parentIdMap.get(taskVo.getUserId()));
                }
                taskVo.setOrganizeName(userOrganizeMap.get(n));
                taskVo.setFinishNum(Integer.valueOf(0));
                taskVo.setTaskStatus(Integer.valueOf(1));
                List onTasks = (List)onTaskMap.get(n);
                if (!CollectionUtils.isEmpty((Collection)onTasks)) {
                    taskVo.setTaskStatus(Integer.valueOf(2));
                    Date startTime = ((TrainingCourseUserTask)onTasks.get(0)).getStartTime();
                    for (TrainingCourseUserTask userTask : onTasks) {
                        if (!startTime.after(userTask.getStartTime())) continue;
                        startTime = userTask.getStartTime();
                    }
                    taskVo.setStartTime(startTime);
                }
                if (!CollectionUtils.isEmpty((Collection)(userTasks = (List)userTaskMap.get(n)))) {
                    ArrayList<Integer> finishsList = new ArrayList<Integer>();
                    Date endTime = ((TrainingCourseUserTask)userTasks.get(0)).getEndTime();
                    for (TrainingCourseUserTask userTask : userTasks) {
                        if (endTime.before(userTask.getEndTime())) {
                            endTime = userTask.getEndTime();
                        }
                        if (finishsList.contains(userTask.getTaskId())) continue;
                        finishsList.add(userTask.getTaskId());
                    }
                    taskVo.setFinishNum(Integer.valueOf(finishsList.size()));
                    if (userTasks.size() >= taskCount) {
                        taskVo.setTaskStatus(Integer.valueOf(3));
                        if (endTime.after(course.getEndTime())) {
                            taskVo.setTaskStatus(Integer.valueOf(4));
                        }
                        taskVo.setEndTime(endTime);
                    }
                }
                taskVo.setAppointTime(course.getCreateTime());
                List trainingCourseUserAnalyses = (List)trainingCourseUserAnalyseMap.get(n);
                if (!CollectionUtils.isEmpty((Collection)trainingCourseUserAnalyses) && !ObjectUtils.isEmpty(trainingCourseUserAnalyses.get(0)) && (detailId = ((TrainingCourseUserAnalyse)trainingCourseUserAnalyses.get(0)).getCertificateId()) != null) {
                    TrainingCertificateDetail detailList = (TrainingCertificateDetail)trainingCertificateDetailMap.get(detailId);
                    taskVo.setCertificateId(ObjectUtils.isEmpty((Object)detailList) ? null : detailList.getCertificateId());
                    taskVo.setCertificatePath(ObjectUtils.isEmpty((Object)detailList) ? "" : detailList.getUrl());
                }
                taskVo.setIsGet(course.getIsGet());
                userTaskList.add(taskVo);
            }
        }
        List<Object> result = new ArrayList();
        result = sort == 2 ? userTaskList.stream().sorted(Comparator.comparingInt(TrainingCourseUserTaskVo::getFinishNum)).collect(Collectors.toList()) : (sort == 1 ? userTaskList.stream().sorted(Comparator.comparingInt(TrainingCourseUserTaskVo::getFinishNum).reversed()).collect(Collectors.toList()) : userTaskList);
        newPage = ListUtil.myPage(result, page.getPageNumber(), page.getPageSize());
        return newPage;
    }

    @Override
    public List<TrainingCourseUserTaskVo> getCourseUserAnalysisList(Integer courseId, String name, Integer status, String organizeIds, Integer turns, String roles, Integer groupId, Integer userId) {
        ArrayList<TrainingCourseUserTaskVo> userTaskList = new ArrayList<TrainingCourseUserTaskVo>();
        try {
            BaseResult base;
            BaseResult simplePojoBaseResult;
            TrainingCourse course = (TrainingCourse)this.courseMapper.selectById(courseId);
            List<Object> appointIdList = new ArrayList();
            if (!(course.getStatus() == 3 && course.getAppointType() == 1 || (simplePojoBaseResult = this.userApi.getSimpleUserByKeyWord(groupId, null, null)) == null || CollectionUtils.isEmpty((Collection)((Collection)simplePojoBaseResult.getData())))) {
                appointIdList = ((List)simplePojoBaseResult.getData()).stream().map(SimplePojo::getId).distinct().collect(Collectors.toList());
            }
            LambdaQueryWrapper wrapper0 = new LambdaQueryWrapper();
            wrapper0.eq(TrainingCourseStageTask::getCourseId, (Object)courseId);
            List stageTaskList = this.courseStageTaskMapper.selectList((Wrapper)wrapper0);
            int taskCount = stageTaskList.size();
            List<Object> userIdList = new ArrayList();
            Map stageTasksMap = stageTaskList.stream().collect(Collectors.toMap(TrainingCourseStageTask::getId, Function.identity()));
            List<Object> allUserIdList = new ArrayList<Object>();
            if (!org.springframework.util.StringUtils.isEmpty((Object)course.getAppointType()) && course.getAppointType() == 1) {
                LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)wrapper1.eq(TrainingCourseUser::getCourseId, (Object)courseId)).eq(TrainingCourseUser::getCourseType, (Object)1);
                List courseUserList = this.courseUserMapper.selectList((Wrapper)wrapper1);
                if (!CollectionUtils.isEmpty((Collection)courseUserList)) {
                    String roleIdStr;
                    com.ovopark.privilege.response.BaseResult baseResult;
                    ArrayList<Integer> userIds = new ArrayList<Integer>();
                    ArrayList<Integer> roleIds = new ArrayList<Integer>();
                    ArrayList<String> orgIds = new ArrayList<String>();
                    ArrayList<Integer> tagIds = new ArrayList<Integer>();
                    for (TrainingCourseUser trainingCourseUser : courseUserList) {
                        if (trainingCourseUser.getUserId() != null) {
                            userIds.add(trainingCourseUser.getUserId());
                            continue;
                        }
                        if (trainingCourseUser.getRoleId() != null) {
                            roleIds.add(trainingCourseUser.getRoleId());
                            continue;
                        }
                        if (!org.springframework.util.StringUtils.isEmpty((Object)trainingCourseUser.getOrganizeId())) {
                            orgIds.add(trainingCourseUser.getOrganizeId());
                            continue;
                        }
                        if (trainingCourseUser.getTagId() == null) continue;
                        tagIds.add(trainingCourseUser.getTagId());
                    }
                    if (!CollectionUtils.isEmpty(userIds)) {
                        allUserIdList.addAll(userIds);
                    }
                    if (!CollectionUtils.isEmpty(roleIds) && (baseResult = this.useApi.getUserByRoleIds(roleIdStr = StringUtils.join(roleIds, (String)","), groupId)) != null && !CollectionUtils.isEmpty((Collection)((Collection)baseResult.getData()))) {
                        List pojo = ((List)baseResult.getData()).stream().map(com.ovopark.privilege.pojo.UsersPojo::getId).distinct().collect(Collectors.toList());
                        allUserIdList.addAll(pojo);
                    }
                    if (!CollectionUtils.isEmpty(orgIds)) {
                        UsersAndOrgsMo mo = new UsersAndOrgsMo();
                        mo.setGroupId(groupId);
                        mo.setOrganizeIds(orgIds);
                        BaseResult userResult = this.userOrganizeApi.getUserByOrganizeIdsOrDepId(mo);
                        if (!userResult.getIsError().booleanValue() && !CollectionUtils.isEmpty((Collection)((Collection)userResult.getData()))) {
                            List users = ((List)userResult.getData()).stream().map(UserAndParentNameMo::getUserId).distinct().collect(Collectors.toList());
                            allUserIdList.addAll(users);
                        }
                    }
                    if (!CollectionUtils.isEmpty(tagIds)) {
                        DepAndTagsPojo pojo = new DepAndTagsPojo();
                        pojo.setGroupId(groupId);
                        pojo.setTagIds(tagIds);
                        pojo.setUserId(userId);
                        BaseResult tagResult = this.tagApi.getUsersByTags(pojo);
                        if (!tagResult.getIsError().booleanValue() && !CollectionUtils.isEmpty((Collection)((Collection)tagResult.getData()))) {
                            for (Map map : (List)tagResult.getData()) {
                                Integer id = (Integer)map.get("id");
                                allUserIdList.add(id);
                            }
                        }
                    }
                }
                allUserIdList = allUserIdList.stream().distinct().collect(Collectors.toList());
                if (course.getStatus() != 3) {
                    allUserIdList.retainAll(appointIdList);
                }
            } else {
                allUserIdList.addAll(appointIdList);
            }
            if (!org.springframework.util.StringUtils.isEmpty((Object)name)) {
                BaseResult base2 = this.userApi.getSimpleUserByKeyWord(groupId, name, null);
                if (base2 != null) {
                    userIdList = ((List)base2.getData()).stream().map(SimplePojo::getId).collect(Collectors.toList());
                    allUserIdList.retainAll(userIdList);
                } else {
                    allUserIdList = new ArrayList();
                }
            }
            if (organizeIds != null && !"".equals(organizeIds)) {
                List<String> organizeIdList = Arrays.asList(organizeIds.split(","));
                UsersAndOrgsMo mo = new UsersAndOrgsMo();
                mo.setGroupId(groupId);
                mo.setOrganizeIds(organizeIdList);
                BaseResult base3 = this.userOrganizeApi.getUserByOrganizeIdsOrDepId(mo);
                if (base3 != null && !CollectionUtils.isEmpty((Collection)((Collection)base3.getData()))) {
                    List userIds = ((List)base3.getData()).stream().map(UserAndParentNameMo::getUserId).distinct().collect(Collectors.toList());
                    allUserIdList.retainAll(userIds);
                } else {
                    allUserIdList = new ArrayList();
                }
            }
            if (!CollectionUtils.isEmpty(allUserIdList)) {
                SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                BaseResult base4 = this.userApi.getUserGtCreateTime(course.getEnterpriseId(), format.format(course.getEndTime()));
                if (base4 != null && !CollectionUtils.isEmpty((Collection)((Collection)base4.getData()))) {
                    List userRemoveList = (List)base4.getData();
                    allUserIdList.removeAll(userRemoveList);
                }
            }
            LambdaQueryWrapper wrapper2 = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper2.eq(TrainingCourseUserTask::getCourseId, (Object)courseId)).ne(TrainingCourseUserTask::getTaskStatus, (Object)1)).orderByDesc(TrainingCourseUserTask::getTurns);
            List userStartList = this.courseUserTaskMapper.selectList((Wrapper)wrapper2);
            if (course.getStatus() != 3) {
                Iterator iterator = userStartList.iterator();
                while (iterator.hasNext()) {
                    TrainingCourseUserTask next = (TrainingCourseUserTask)iterator.next();
                    if (appointIdList.contains(next.getUserId())) continue;
                    iterator.remove();
                }
            }
            Map<Object, Object> onTaskMap = new HashMap();
            if (!CollectionUtils.isEmpty((Collection)userStartList)) {
                onTaskMap = userStartList.stream().collect(Collectors.groupingBy(TrainingCourseUserTask::getUserId));
            }
            LambdaQueryWrapper wrapperU = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapperU.eq(TrainingPaperUserTurns::getProjectId, (Object)courseId)).eq(TrainingPaperUserTurns::getTurnType, (Object)4)).orderByDesc(TrainingPaperUserTurns::getTurns);
            List paperUserTurns = this.paperUserTurnsMapper.selectList((Wrapper)wrapperU);
            Map<Object, Object> turnMap = new HashMap();
            if (!CollectionUtils.isEmpty((Collection)paperUserTurns)) {
                turnMap = paperUserTurns.stream().collect(Collectors.groupingBy(TrainingPaperUserTurns::getUserId));
            }
            LambdaQueryWrapper wrapper3 = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper3.eq(TrainingCourseUserTask::getCourseId, (Object)courseId)).in(TrainingCourseUserTask::getTaskStatus, Arrays.asList(3, 4))).orderByDesc(TrainingCourseUserTask::getTurns);
            List finishList = this.courseUserTaskMapper.selectList((Wrapper)wrapper3);
            if (course.getStatus() != 3) {
                Iterator iterator = finishList.iterator();
                while (iterator.hasNext()) {
                    TrainingCourseUserTask next = (TrainingCourseUserTask)iterator.next();
                    if (appointIdList.contains(next.getUserId())) continue;
                    iterator.remove();
                }
            }
            Map<Object, Object> userTaskMap = new HashMap();
            if (!CollectionUtils.isEmpty((Collection)finishList)) {
                ArrayList<TrainingCourseUserTask> delList = new ArrayList<TrainingCourseUserTask>();
                block6: for (TrainingCourseUserTask courseUserTask : finishList) {
                    TrainingCourseStageTask task = (TrainingCourseStageTask)stageTasksMap.get(courseUserTask.getTaskId());
                    List paperUserTurnsList = (List)turnMap.get(courseUserTask.getUserId());
                    if (!CollectionUtils.isEmpty((Collection)paperUserTurnsList)) {
                        Iterator iterator = paperUserTurnsList.iterator();
                        while (iterator.hasNext()) {
                            TrainingPaperUserTurns userTurns = (TrainingPaperUserTurns)iterator.next();
                            if (task.getStageId().intValue() != userTurns.getStageId().intValue() || courseUserTask.getTurns().intValue() == userTurns.getTurns().intValue()) continue;
                            delList.add(courseUserTask);
                            continue block6;
                        }
                        continue;
                    }
                    if (courseUserTask.getTurns() == 1) continue;
                    delList.add(courseUserTask);
                }
                if (!CollectionUtils.isEmpty(delList)) {
                    finishList.removeAll(delList);
                }
                userTaskMap = finishList.stream().collect(Collectors.groupingBy(TrainingCourseUserTask::getUserId));
            }
            if (!org.springframework.util.StringUtils.isEmpty((Object)status)) {
                List<Object> startUserIdList = new ArrayList();
                if (!CollectionUtils.isEmpty((Collection)userStartList)) {
                    startUserIdList = userStartList.stream().map(TrainingCourseUserTask::getUserId).distinct().collect(Collectors.toList());
                }
                if (status == 1) {
                    allUserIdList.removeAll(startUserIdList);
                } else {
                    ArrayList<Integer> overList = new ArrayList<Integer>();
                    ArrayList<Integer> onList = new ArrayList<Integer>();
                    if (!CollectionUtils.isEmpty((Collection)finishList)) {
                        List finishUserIdList = finishList.stream().map(TrainingCourseUserTask::getUserId).distinct().collect(Collectors.toList());
                        block8: for (Integer finishUserId : finishUserIdList) {
                            List userTasks = (List)userTaskMap.get(finishUserId);
                            if (userTasks.size() < taskCount) continue;
                            onList.add(finishUserId);
                            for (TrainingCourseUserTask userTask : userTasks) {
                                if (userTask.getTaskStatus() != 4) continue;
                                overList.add(finishUserId);
                                continue block8;
                            }
                        }
                        startUserIdList.removeAll(onList);
                        onList.removeAll(overList);
                    }
                    if (status == 2) {
                        allUserIdList.retainAll(startUserIdList);
                    } else if (status == 3) {
                        allUserIdList.retainAll(onList);
                    } else if (status == 4) {
                        allUserIdList.retainAll(overList);
                    }
                }
            }
            List<Object> roleList = new ArrayList();
            if (!org.springframework.util.StringUtils.isEmpty((Object)roles)) {
                roleList = Arrays.asList(roles.split(","));
            }
            if (!CollectionUtils.isEmpty(allUserIdList) && (base = this.userApi.getUserByIdList(allUserIdList)) != null && !CollectionUtils.isEmpty((Collection)((Collection)base.getData()))) {
                Map pojoMap = ((List)base.getData()).stream().collect(Collectors.toMap(UsersPojo::getId, Function.identity()));
                Map<Integer, String> userOrganizeMap = this.userUtilService.selectUserOrganizeName(groupId, allUserIdList);
                Map<Integer, String> parentMap = this.userUtilService.selectParentMap(allUserIdList, groupId);
                Map userRoleMap = new HashMap();
                if (!CollectionUtils.isEmpty(allUserIdList)) {
                    HashMap<String, Object> parameter = new HashMap<String, Object>();
                    parameter.put("userIds", StringUtils.join(allUserIdList, (String)","));
                    parameter.put("groupId", groupId);
                    com.ovopark.privilege.response.BaseResult roleBase = this.roleApi.getUserRoleList(parameter);
                    if (roleBase != null) {
                        userRoleMap = (Map)roleBase.getData();
                    }
                }
                Map<Integer, UserDutiesMo> dutiesMap = this.userUtilService.selectDutiesMap(allUserIdList, groupId);
                Map<Integer, Integer> parentIdMap = this.userUtilService.selectParentIdMap(allUserIdList, groupId);
                Map<Object, Object> trainingCourseUserAnalyseMap = new HashMap();
                Map<Object, Object> trainingCertificateDetailMap = new HashMap();
                LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)queryWrapper.eq(TrainingCourseUserAnalyse::getCourseId, (Object)courseId)).in(TrainingCourseUserAnalyse::getUserId, allUserIdList);
                queryWrapper.eq(TrainingCourseUserAnalyse::getPassStatus, (Object)1);
                List trainingCourseUserAnalyseList = this.trainingCourseUserAnalyseMapper.selectList((Wrapper)queryWrapper);
                if (!CollectionUtils.isEmpty((Collection)trainingCourseUserAnalyseList)) {
                    List list;
                    trainingCourseUserAnalyseMap = trainingCourseUserAnalyseList.stream().collect(Collectors.groupingBy(TrainingCourseUserAnalyse::getUserId));
                    ArrayList<Integer> cerIdList = new ArrayList<Integer>();
                    for (TrainingCourseUserAnalyse trainingCourseUserAnalyse : trainingCourseUserAnalyseList) {
                        if (trainingCourseUserAnalyse.getCertificateId() == null || trainingCourseUserAnalyse.getCertificateId() == 0) continue;
                        cerIdList.add(trainingCourseUserAnalyse.getCertificateId());
                    }
                    if (!CollectionUtils.isEmpty(cerIdList) && !CollectionUtils.isEmpty((Collection)(list = this.certificateDetailMapper.selectBatchIds(cerIdList)))) {
                        trainingCertificateDetailMap = list.stream().collect(Collectors.toMap(TrainingCertificateDetail::getId, Function.identity()));
                    }
                }
                for (Integer n : allUserIdList) {
                    Integer detailId;
                    List userTasks;
                    ArrayList roleName = new ArrayList();
                    if (!CollectionUtils.isEmpty((Collection)((Collection)userRoleMap.get(n)))) {
                        ((List)userRoleMap.get(n)).forEach(rolePojo -> roleName.add(rolePojo.getRoleName()));
                        if (!org.springframework.util.StringUtils.isEmpty((Object)roles)) {
                            if (roleList.stream().noneMatch(roleName::contains)) continue;
                        }
                    }
                    TrainingCourseUserTaskVo taskVo = new TrainingCourseUserTaskVo();
                    taskVo.setUserId(n);
                    UsersPojo pojo = (UsersPojo)pojoMap.get(n);
                    taskVo.setUserName(pojo.getShowName());
                    taskVo.setShowName(pojo.getUserName());
                    taskVo.setParentName(parentMap.get(n));
                    taskVo.setTaskNum(Integer.valueOf(taskCount));
                    taskVo.setEmployeeNumber(pojo.getEmployeeNumber());
                    taskVo.setRole(String.join((CharSequence)";\n", roleName));
                    if (!CollectionUtils.isEmpty(dutiesMap) && dutiesMap.get(taskVo.getUserId()) != null) {
                        taskVo.setPost(dutiesMap.get(taskVo.getUserId()).getDutieName());
                    }
                    if (!CollectionUtils.isEmpty(parentIdMap)) {
                        taskVo.setParentUserId(parentIdMap.get(taskVo.getUserId()));
                    }
                    taskVo.setOrganizeName(userOrganizeMap.get(n));
                    taskVo.setFinishNum(Integer.valueOf(0));
                    taskVo.setTaskStatus(Integer.valueOf(1));
                    List onTasks = (List)onTaskMap.get(n);
                    if (!CollectionUtils.isEmpty((Collection)onTasks)) {
                        taskVo.setTaskStatus(Integer.valueOf(2));
                        Date startTime = ((TrainingCourseUserTask)onTasks.get(0)).getStartTime();
                        for (TrainingCourseUserTask userTask : onTasks) {
                            if (!startTime.after(userTask.getStartTime())) continue;
                            startTime = userTask.getStartTime();
                        }
                        taskVo.setStartTime(startTime);
                    }
                    if (!CollectionUtils.isEmpty((Collection)(userTasks = (List)userTaskMap.get(n)))) {
                        ArrayList<Integer> finishsList = new ArrayList<Integer>();
                        Date endTime = ((TrainingCourseUserTask)userTasks.get(0)).getEndTime();
                        for (TrainingCourseUserTask userTask : userTasks) {
                            if (endTime.before(userTask.getEndTime())) {
                                endTime = userTask.getEndTime();
                            }
                            if (finishsList.contains(userTask.getTaskId())) continue;
                            finishsList.add(userTask.getTaskId());
                        }
                        taskVo.setFinishNum(Integer.valueOf(finishsList.size()));
                        if (userTasks.size() >= taskCount) {
                            taskVo.setTaskStatus(Integer.valueOf(3));
                            if (endTime.after(course.getEndTime())) {
                                taskVo.setTaskStatus(Integer.valueOf(4));
                            }
                            taskVo.setEndTime(endTime);
                        }
                    }
                    taskVo.setAppointTime(course.getCreateTime());
                    List trainingCourseUserAnalyses = (List)trainingCourseUserAnalyseMap.get(n);
                    if (!CollectionUtils.isEmpty((Collection)trainingCourseUserAnalyses) && !ObjectUtils.isEmpty(trainingCourseUserAnalyses.get(0)) && (detailId = ((TrainingCourseUserAnalyse)trainingCourseUserAnalyses.get(0)).getCertificateId()) != null) {
                        TrainingCertificateDetail detailList = (TrainingCertificateDetail)trainingCertificateDetailMap.get(detailId);
                        taskVo.setCertificateId(ObjectUtils.isEmpty((Object)detailList) ? null : detailList.getCertificateId());
                        taskVo.setCertificatePath(ObjectUtils.isEmpty((Object)detailList) ? "" : detailList.getUrl());
                    }
                    taskVo.setIsGet(course.getIsGet());
                    userTaskList.add(taskVo);
                }
            }
        }
        catch (NumberFormatException e) {
            log.error("", (Throwable)e);
        }
        return userTaskList;
    }

    @Override
    public TrainingCourseVo selectUserRelearnCourse(TrainingCourseStageTaskVo stageTaskVo, Users user) {
        TrainingCourseVo courseVo = new TrainingCourseVo();
        TrainingCourse course = (TrainingCourse)this.courseMapper.selectById(stageTaskVo.getCourseId());
        BeanUtils.copyProperties((Object)course, (Object)courseVo);
        LambdaUpdateWrapper courseStageWrapper = new LambdaUpdateWrapper();
        courseStageWrapper.eq(TrainingCourseStage::getCourseId, (Object)courseVo.getId());
        if (!org.springframework.util.StringUtils.isEmpty((Object)stageTaskVo.getStageId())) {
            courseStageWrapper.eq(TrainingCourseStage::getId, (Object)stageTaskVo.getStageId());
        }
        courseStageWrapper.orderByAsc(TrainingCourseStage::getStageSort);
        List courseStageList = this.courseStageMapper.selectList((Wrapper)courseStageWrapper);
        List courseStageIdList = courseStageList.stream().map(TrainingCourseStage::getId).distinct().collect(Collectors.toList());
        LambdaUpdateWrapper courseStageTaskWrapper = new LambdaUpdateWrapper();
        ((LambdaUpdateWrapper)courseStageTaskWrapper.eq(TrainingCourseStageTask::getCourseId, (Object)courseVo.getId())).in(TrainingCourseStageTask::getStageId, courseStageIdList);
        courseStageTaskWrapper.orderByAsc(TrainingCourseStageTask::getTaskSort);
        List courseStageTaskList = this.courseStageTaskMapper.selectList((Wrapper)courseStageTaskWrapper);
        Map<Object, Object> taskMap = new HashMap();
        if (!CollectionUtils.isEmpty((Collection)courseStageTaskList)) {
            taskMap = courseStageTaskList.stream().collect(Collectors.groupingBy(TrainingCourseStageTask::getStageId));
        }
        LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)wrapper1.eq(TrainingCourseUserTask::getUserId, (Object)stageTaskVo.getUserId())).orderByDesc(TrainingCourseUserTask::getId);
        List userTasks = this.courseUserTaskMapper.selectList((Wrapper)wrapper1);
        Map<Object, Object> courseUserTaskMap = new HashMap();
        if (!CollectionUtils.isEmpty((Collection)userTasks)) {
            courseUserTaskMap = userTasks.stream().collect(Collectors.groupingBy(TrainingCourseUserTask::getTaskId));
        }
        List paperIdList = courseStageTaskList.stream().map(TrainingCourseStageTask::getPaperId).distinct().filter(Objects::nonNull).collect(Collectors.toList());
        Map<Object, Object> userPaperMap = new HashMap();
        Map<Object, Object> paperTurnsMap = new HashMap();
        if (!CollectionUtils.isEmpty(paperIdList)) {
            LambdaQueryWrapper wrapper2 = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)wrapper2.eq(TrainingPaperTurns::getProjectId, (Object)courseVo.getId())).eq(TrainingPaperTurns::getTurnType, (Object)4);
            List paperTurnsList = this.paperTurnsMapper.selectList((Wrapper)wrapper2);
            if (!CollectionUtils.isEmpty((Collection)paperTurnsList)) {
                paperIdList.addAll(paperTurnsList.stream().map(TrainingPaperTurns::getPaperId).distinct().collect(Collectors.toList()));
                paperIdList = paperIdList.stream().distinct().collect(Collectors.toList());
                paperTurnsMap = paperTurnsList.stream().collect(Collectors.groupingBy(TrainingPaperTurns::getTaskId));
            }
            LambdaQueryWrapper wrapper3 = new LambdaQueryWrapper();
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.eq(TrainingCourseStageTask::getCourseId, (Object)courseVo.getId())).in(TrainingCourseStageTask::getPaperId, paperIdList)).in(TrainingCourseStageTask::getStageId, courseStageIdList);
            List taskList = this.courseStageTaskMapper.selectList((Wrapper)queryWrapper);
            List taskIdList = taskList.stream().map(TrainingCourseStageTask::getId).collect(Collectors.toList());
            ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper3.in(TrainingUserPaper::getTrainingPaperId, paperIdList)).eq(TrainingUserPaper::getUserId, (Object)stageTaskVo.getUserId())).eq(TrainingUserPaper::getSourceType, (Object)5)).in(TrainingUserPaper::getSourceTaskId, taskIdList)).orderByDesc(TrainingUserPaper::getSubmitTime);
            List userPaperList = this.trainingUserPaperMapper.selectList((Wrapper)wrapper3);
            if (!CollectionUtils.isEmpty((Collection)userPaperList)) {
                userPaperMap = userPaperList.stream().collect(Collectors.groupingBy(TrainingUserPaper::getTrainingPaperId));
            }
        }
        List materialIdList = courseStageTaskList.stream().map(TrainingCourseStageTask::getMaterialId).distinct().collect(Collectors.toList());
        Map<Object, Object> materialMap = new HashMap();
        if (!CollectionUtils.isEmpty(materialIdList)) {
            List materials = this.materialMapper.selectBatchIds(materialIdList);
            materialMap = materials.stream().collect(Collectors.toMap(TrainingMaterial::getId, Function.identity()));
        }
        List workIdList = courseStageTaskList.stream().map(TrainingCourseStageTask::getWorkId).distinct().collect(Collectors.toList());
        Map<Object, Object> workUserAnswerMap = new HashMap();
        if (!CollectionUtils.isEmpty(workIdList)) {
            LambdaQueryWrapper wrapper2 = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper2.eq(TrainingWorkUserAnswer::getUserId, (Object)stageTaskVo.getUserId())).in(TrainingWorkUserAnswer::getWorkId, workIdList)).eq(TrainingWorkUserAnswer::getSourceType, (Object)5)).eq(TrainingWorkUserAnswer::getSourceProjectId, (Object)stageTaskVo.getCourseId())).orderByDesc(TrainingWorkUserAnswer::getId);
            List trainingWorkUserAnswerList = this.trainingWorkUserAnswerMapper.selectList((Wrapper)wrapper2);
            if (!CollectionUtils.isEmpty((Collection)trainingWorkUserAnswerList)) {
                workUserAnswerMap = trainingWorkUserAnswerList.stream().collect(Collectors.groupingBy(TrainingWorkUserAnswer::getWorkId));
            }
        }
        LambdaQueryWrapper wrapper0 = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper0.eq(TrainingPaperUserTurns::getUserId, (Object)stageTaskVo.getUserId())).eq(TrainingPaperUserTurns::getProjectId, (Object)stageTaskVo.getCourseId())).eq(TrainingPaperUserTurns::getTurnType, (Object)4)).orderByDesc(TrainingPaperUserTurns::getTurns);
        List paperUserTurnsList = this.paperUserTurnsMapper.selectList((Wrapper)wrapper0);
        Map<Object, Object> uMap = new HashMap();
        if (!CollectionUtils.isEmpty((Collection)paperUserTurnsList)) {
            uMap = paperUserTurnsList.stream().collect(Collectors.groupingBy(TrainingPaperUserTurns::getStageId));
        }
        ArrayList<TrainingCourseStageVo> stageVos = new ArrayList<TrainingCourseStageVo>();
        for (TrainingCourseStage courseStage : courseStageList) {
            ArrayList<TrainingCourseUserTaskVo> userTaskVoList;
            TrainingCourseStageVo courseStageVo;
            block49: {
                courseStageVo = new TrainingCourseStageVo();
                BeanUtils.copyProperties((Object)courseStage, (Object)courseStageVo);
                List stageTaskList = (List)taskMap.get(courseStage.getId());
                userTaskVoList = new ArrayList<TrainingCourseUserTaskVo>();
                if (CollectionUtils.isEmpty((Collection)stageTaskList)) break block49;
                Integer turns = 1;
                List paperUserTurns = (List)uMap.get(courseStage.getId());
                if (!CollectionUtils.isEmpty((Collection)paperUserTurns)) {
                    turns = ((TrainingPaperUserTurns)paperUserTurns.get(0)).getTurns();
                }
                if (!org.springframework.util.StringUtils.isEmpty((Object)stageTaskVo.getTurns())) {
                    turns = stageTaskVo.getTurns();
                }
                courseStageVo.setTurns(turns);
                for (TrainingCourseStageTask stageTask : stageTaskList) {
                    TrainingCourseUserTaskVo userTaskVo;
                    block51: {
                        block53: {
                            TrainingUserViewTimeVo trainingViewVo;
                            block52: {
                                block50: {
                                    TrainingMaterial material;
                                    userTaskVo = new TrainingCourseUserTaskVo();
                                    userTaskVo.setTaskName(stageTask.getTaskName());
                                    userTaskVo.setTaskType(stageTask.getTaskType());
                                    if (stageTask.getTaskType() == 5 && !org.springframework.util.StringUtils.isEmpty((Object)stageTask.getMaterialId()) && !ObjectUtils.isEmpty((Object)(material = (TrainingMaterial)materialMap.get(stageTask.getMaterialId())))) {
                                        userTaskVo.setFileType(material.getFileType());
                                        userTaskVo.setUrl(material.getMaterialPath());
                                    }
                                    TrainingCourseUserTask userTask = null;
                                    List userTaskList = (List)courseUserTaskMap.get(stageTask.getId());
                                    if (CollectionUtils.isEmpty((Collection)userTaskList)) {
                                        userTaskVo.setCourseId(stageTask.getCourseId());
                                        userTaskVo.setUserId(stageTaskVo.getUserId());
                                        userTaskVo.setTaskId(stageTask.getId());
                                        userTaskVo.setTaskStatus(Integer.valueOf(1));
                                        userTaskVo.setTurns(turns);
                                        userTaskVoList.add(userTaskVo);
                                        continue;
                                    }
                                    for (TrainingCourseUserTask trainingCourseUserTask : userTaskList) {
                                        if (trainingCourseUserTask.getTurns() == null || !turns.equals(trainingCourseUserTask.getTurns())) continue;
                                        userTask = trainingCourseUserTask;
                                        break;
                                    }
                                    if (ObjectUtils.isEmpty(userTask)) {
                                        userTaskVo.setCourseId(stageTask.getCourseId());
                                        userTaskVo.setUserId(stageTaskVo.getUserId());
                                        userTaskVo.setTaskId(stageTask.getId());
                                        userTaskVo.setTaskStatus(Integer.valueOf(1));
                                        userTaskVo.setTurns(turns);
                                        userTaskVoList.add(userTaskVo);
                                        continue;
                                    }
                                    BeanUtils.copyProperties(userTask, (Object)userTaskVo);
                                    if (stageTask.getTaskType() != 1 || org.springframework.util.StringUtils.isEmpty((Object)stageTask.getTrainingId())) break block50;
                                    Integer learnType = 4;
                                    List<TrainingUserViewTimeVo> timeList = this.commonService.selectlearnProgress(stageTask.getTrainingId(), learnType, stageTask.getId(), stageTaskVo.getUserId(), turns, stageTask.getIsProgress());
                                    if (!CollectionUtils.isEmpty(timeList)) {
                                        BigDecimal readRate = BigDecimal.ZERO;
                                        int times = 0;
                                        for (TrainingUserViewTimeVo map : timeList) {
                                            readRate = readRate.add(map.getReadRate());
                                            times += map.getViewTimes().intValue();
                                        }
                                        userTaskVo.setReadRate(readRate.divide(new BigDecimal("" + timeList.size()), 2, 1));
                                        userTaskVo.setTimeStr(DateUtils.getUseTimeFormal(times));
                                    } else {
                                        userTaskVo.setReadRate(BigDecimal.ZERO);
                                    }
                                    break block51;
                                }
                                if (stageTask.getTaskType() != 2 || org.springframework.util.StringUtils.isEmpty((Object)stageTask.getPaperId())) break block52;
                                List turnsList = (List)paperTurnsMap.get(stageTask.getId());
                                Integer paperId = null;
                                if (!CollectionUtils.isEmpty((Collection)turnsList)) {
                                    for (TrainingPaperTurns paperTurns : turnsList) {
                                        if (paperTurns.getTurns().intValue() != turns.intValue()) continue;
                                        paperId = paperTurns.getPaperId();
                                    }
                                }
                                if (paperId == null) {
                                    paperId = stageTask.getPaperId();
                                }
                                userTaskVo.setPaperId(paperId);
                                List userPapers = (List)userPaperMap.get(paperId);
                                int paperCount = 0;
                                if (!CollectionUtils.isEmpty((Collection)userPapers)) {
                                    paperCount = userPapers.size();
                                    int totalTime = 0;
                                    BigDecimal topScore = new BigDecimal(-1);
                                    Double newScore = null;
                                    for (TrainingUserPaper userPaper : userPapers) {
                                        if (userPaper.getPaperStatus().equals(2)) {
                                            if (userPaper.getScore().doubleValue() >= topScore.doubleValue()) {
                                                topScore = userPaper.getScore();
                                            }
                                            if (newScore == null) {
                                                newScore = userPaper.getScore().doubleValue();
                                            }
                                        }
                                        if (org.springframework.util.StringUtils.isEmpty((Object)userPaper.getSubmitTime()) || org.springframework.util.StringUtils.isEmpty((Object)userPaper.getUpdateTime())) continue;
                                        totalTime += (int)((userPaper.getSubmitTime().getTime() - userPaper.getUpdateTime().getTime()) / 1000L);
                                    }
                                    TrainingPaper paper = (TrainingPaper)this.trainingPaperMapper.selectById(paperId);
                                    TrainingExam exam = (TrainingExam)this.trainingExamMapper.selectById(paper.getExamId());
                                    double passScore = (double)paper.getPassLine().intValue() * exam.getScore().doubleValue() / 100.0;
                                    if (paper.getScoreSelect() == null || paper.getScoreSelect() != null && paper.getScoreSelect().equals(1)) {
                                        if (newScore != null) {
                                            userTaskVo.setScore(new BigDecimal(newScore));
                                            if (newScore >= passScore) {
                                                userTaskVo.setTaskStatus(Integer.valueOf(3));
                                            } else {
                                                userTaskVo.setTaskStatus(Integer.valueOf(5));
                                            }
                                        } else {
                                            userTaskVo.setTaskStatus(Integer.valueOf(6));
                                        }
                                    } else if (paper.getScoreSelect() != null && paper.getScoreSelect().equals(0)) {
                                        if (topScore.doubleValue() > -1.0) {
                                            userTaskVo.setScore(topScore);
                                            if (topScore.doubleValue() >= passScore) {
                                                userTaskVo.setTaskStatus(Integer.valueOf(3));
                                            } else {
                                                userTaskVo.setTaskStatus(Integer.valueOf(5));
                                            }
                                        } else {
                                            userTaskVo.setTaskStatus(Integer.valueOf(6));
                                        }
                                    }
                                    userTaskVo.setTimeStr(DateUtils.getUseTimeFormal(totalTime /= paperCount));
                                }
                                userTaskVo.setPaperCount(Integer.valueOf(paperCount));
                                break block51;
                            }
                            if (stageTask.getTaskType() != 5 || org.springframework.util.StringUtils.isEmpty((Object)stageTask.getMaterialId())) break block53;
                            TrainingMaterial material = (TrainingMaterial)materialMap.get(stageTask.getMaterialId());
                            if (ObjectUtils.isEmpty((Object)material)) break block51;
                            BigDecimal finishTime = BigDecimal.ZERO;
                            finishTime = material.getIsVideo() == 1 ? new BigDecimal(material.getDuration().toString()) : (org.springframework.util.StringUtils.isEmpty((Object)material.getFinishTime()) ? BigDecimal.ZERO : new BigDecimal(material.getFinishTime()));
                            int learnType = 4;
                            if (stageTask.getIsProgress() == 1) {
                                learnType = 0;
                            }
                            if (!org.springframework.util.StringUtils.isEmpty((Object)(trainingViewVo = this.commonService.selectMaterialViewTime(stageTaskVo.getUserId(), (Integer)(learnType == 0 && turns == 1 ? null : stageTask.getId()), learnType, material.getId(), turns)))) {
                                BigDecimal viewTime = new BigDecimal(org.springframework.util.StringUtils.isEmpty((Object)trainingViewVo.getViewTimes()) ? "0" : trainingViewVo.getViewTimes().toString());
                                BigDecimal readRate = finishTime.compareTo(new BigDecimal(0)) > 0 ? viewTime.divide(finishTime, 2, 1) : BigDecimal.ONE;
                                userTaskVo.setReadRate(readRate.compareTo(new BigDecimal(1)) >= 0 ? BigDecimal.ONE : readRate);
                                int times = viewTime.intValue();
                                userTaskVo.setTimeStr(DateUtils.getUseTimeFormal(times));
                            } else {
                                userTaskVo.setReadRate(BigDecimal.ZERO);
                            }
                            break block51;
                        }
                        if (stageTask.getTaskType() == 6 && !org.springframework.util.StringUtils.isEmpty((Object)stageTask.getWorkId())) {
                            List trainingWorkUserAnswerList;
                            userTaskVo.setWorkId(stageTask.getWorkId());
                            if (userTaskVo.getStartTime() != null && userTaskVo.getEndTime() != null) {
                                if (DateUtils.format(userTaskVo.getStartTime(), "yyyy-MM-dd HH:mm").equals(DateUtils.format(userTaskVo.getEndTime(), "yyyy-MM-dd HH:mm"))) {
                                    userTaskVo.setStartTime(null);
                                } else {
                                    int times = (int)((userTaskVo.getEndTime().getTime() - userTaskVo.getStartTime().getTime()) / 1000L);
                                    userTaskVo.setTimeStr(DateUtils.getUseTimeFormal(times));
                                }
                            }
                            if (!CollectionUtils.isEmpty((Collection)(trainingWorkUserAnswerList = (List)workUserAnswerMap.get(stageTask.getWorkId())))) {
                                for (TrainingWorkUserAnswer trainingWorkUserAnswer : trainingWorkUserAnswerList) {
                                    if (trainingWorkUserAnswer.getTurns() == null || !trainingWorkUserAnswer.getTurns().equals(turns)) continue;
                                    userTaskVo.setWorkUserAnswerId(trainingWorkUserAnswer.getId());
                                    userTaskVo.setScore(trainingWorkUserAnswer.getScore());
                                    break;
                                }
                            }
                        }
                    }
                    userTaskVoList.add(userTaskVo);
                }
            }
            courseStageVo.setUserTaskList(userTaskVoList);
            stageVos.add(courseStageVo);
        }
        courseVo.setStageList(stageVos);
        return courseVo;
    }

    @Override
    public TrainingCourseVo selectCourseTaskAnalysis(TrainingCourseVo courseVo, Users user) {
        TrainingCourse course = (TrainingCourse)this.courseMapper.selectById(courseVo.getId());
        if (!ObjectUtils.isEmpty((Object)course)) {
            BeanUtils.copyProperties((Object)course, (Object)courseVo);
            LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)wrapper1.eq(TrainingCourseStage::getCourseId, (Object)courseVo.getId())).orderByAsc(TrainingCourseStage::getStageSort);
            List stageList = this.courseStageMapper.selectList((Wrapper)wrapper1);
            if (!CollectionUtils.isEmpty((Collection)stageList)) {
                LambdaQueryWrapper wrapper2 = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)wrapper2.eq(TrainingCourseStageTask::getCourseId, (Object)courseVo.getId())).orderByAsc(TrainingCourseStageTask::getTaskSort);
                List stageTaskList = this.courseStageTaskMapper.selectList((Wrapper)wrapper2);
                if (!CollectionUtils.isEmpty((Collection)stageTaskList)) {
                    Map<Integer, List<TrainingCourseStageTask>> stageTaskMap = stageTaskList.stream().collect(Collectors.groupingBy(TrainingCourseStageTask::getStageId));
                    List materialIds = stageTaskList.stream().map(TrainingCourseStageTask::getMaterialId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
                    Map<Object, Object> materialMap = new HashMap();
                    if (!CollectionUtils.isEmpty(materialIds)) {
                        List trainingMaterialList = this.materialMapper.selectBatchIds(materialIds);
                        materialMap = trainingMaterialList.stream().collect(Collectors.toMap(TrainingMaterial::getId, Function.identity()));
                    }
                    ArrayList<TrainingCourseStageVo> stageVoList = new ArrayList<TrainingCourseStageVo>();
                    List<Object> notCourseList = new ArrayList();
                    if (courseVo.getAppointType() == 1) {
                        BaseResult simplePojoBaseResult;
                        LambdaQueryWrapper wrapper3 = new LambdaQueryWrapper();
                        ((LambdaQueryWrapper)wrapper3.eq(TrainingCourseUser::getCourseId, (Object)courseVo.getId())).eq(TrainingCourseUser::getCourseType, (Object)1);
                        List courseUserList = this.courseUserMapper.selectList((Wrapper)wrapper3);
                        if (!CollectionUtils.isEmpty((Collection)courseUserList)) {
                            List tagIds;
                            List orgIds;
                            DepAndTagsPojo pojo;
                            String roleIdStr;
                            com.ovopark.privilege.response.BaseResult baseResult;
                            List roleIds;
                            List userIds = courseUserList.stream().map(TrainingCourseUser::getUserId).distinct().filter(Objects::nonNull).collect(Collectors.toList());
                            if (!CollectionUtils.isEmpty(userIds)) {
                                notCourseList.addAll(userIds);
                            }
                            if (!CollectionUtils.isEmpty(roleIds = courseUserList.stream().map(TrainingCourseUser::getRoleId).filter(Objects::nonNull).distinct().collect(Collectors.toList())) && (baseResult = this.useApi.getUserByRoleIds(roleIdStr = StringUtils.join(roleIds, (String)","), user.getGroupId())) != null && !CollectionUtils.isEmpty((Collection)((Collection)baseResult.getData()))) {
                                pojo = ((List)baseResult.getData()).stream().map(com.ovopark.privilege.pojo.UsersPojo::getId).distinct().collect(Collectors.toList());
                                notCourseList.addAll((Collection<Object>)pojo);
                            }
                            if (!CollectionUtils.isEmpty(orgIds = courseUserList.stream().map(TrainingCourseUser::getOrganizeId).filter(Objects::nonNull).distinct().collect(Collectors.toList()))) {
                                UsersAndOrgsMo mo = new UsersAndOrgsMo();
                                mo.setGroupId(user.getGroupId());
                                mo.setOrganizeIds(orgIds);
                                BaseResult userResult = this.userOrganizeApi.getUserByOrganizeIdsOrDepId(mo);
                                if (!userResult.getIsError().booleanValue() && !CollectionUtils.isEmpty((Collection)((Collection)userResult.getData()))) {
                                    List users = ((List)userResult.getData()).stream().map(UserAndParentNameMo::getUserId).distinct().collect(Collectors.toList());
                                    notCourseList.addAll(users);
                                }
                            }
                            if (!CollectionUtils.isEmpty(tagIds = courseUserList.stream().map(TrainingCourseUser::getTagId).filter(Objects::nonNull).distinct().collect(Collectors.toList()))) {
                                pojo = new DepAndTagsPojo();
                                pojo.setGroupId(user.getGroupId());
                                pojo.setTagIds(tagIds);
                                pojo.setUserId(user.getId());
                                BaseResult tagResult = this.tagApi.getUsersByTags(pojo);
                                if (!tagResult.getIsError().booleanValue() && !CollectionUtils.isEmpty((Collection)((Collection)tagResult.getData()))) {
                                    for (Map map : (List)tagResult.getData()) {
                                        Integer id = (Integer)map.get("id");
                                        notCourseList.add(id);
                                    }
                                }
                            }
                        }
                        notCourseList = notCourseList.stream().distinct().collect(Collectors.toList());
                        if (course.getStatus() != 3 && !Objects.isNull(simplePojoBaseResult = this.userApi.getSimpleUserByKeyWord(courseVo.getEnterpriseId(), null, null)) && !CollectionUtils.isEmpty((Collection)((Collection)simplePojoBaseResult.getData()))) {
                            notCourseList.retainAll(((List)simplePojoBaseResult.getData()).stream().map(SimplePojo::getId).distinct().collect(Collectors.toList()));
                        }
                    } else {
                        List pojoList = (List)this.userApi.getSimpleUserByKeyWord(courseVo.getEnterpriseId(), null, null).getData();
                        notCourseList = pojoList.stream().map(SimplePojo::getId).distinct().collect(Collectors.toList());
                    }
                    if (!CollectionUtils.isEmpty(notCourseList)) {
                        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                        BaseResult base = this.userApi.getUserGtCreateTime(course.getEnterpriseId(), format.format(course.getEndTime()));
                        if (base != null && !CollectionUtils.isEmpty((Collection)((Collection)base.getData()))) {
                            List userRemoveList = (List)base.getData();
                            notCourseList.removeAll(userRemoveList);
                        }
                    }
                    Map<Object, Object> turnMap = new HashMap();
                    Map<Object, Object> finishTaskMap = new HashMap();
                    Map<Object, Object> goingTaskMap = new HashMap();
                    if (!CollectionUtils.isEmpty(notCourseList)) {
                        LambdaQueryWrapper wrapper4 = new LambdaQueryWrapper();
                        ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper4.eq(TrainingCourseUserTask::getCourseId, (Object)courseVo.getId())).in(TrainingCourseUserTask::getUserId, notCourseList)).in(TrainingCourseUserTask::getTaskStatus, Arrays.asList(3, 4));
                        List finishTaskList = this.courseUserTaskMapper.selectList((Wrapper)wrapper4);
                        if (!CollectionUtils.isEmpty((Collection)finishTaskList)) {
                            finishTaskMap = finishTaskList.stream().collect(Collectors.groupingBy(TrainingCourseUserTask::getTaskId));
                        }
                        LambdaQueryWrapper wrapper5 = new LambdaQueryWrapper();
                        ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper5.eq(TrainingCourseUserTask::getCourseId, (Object)courseVo.getId())).in(TrainingCourseUserTask::getUserId, notCourseList)).ne(TrainingCourseUserTask::getTaskStatus, (Object)1);
                        List goingTaskList = this.courseUserTaskMapper.selectList((Wrapper)wrapper5);
                        if (!CollectionUtils.isEmpty((Collection)goingTaskList)) {
                            goingTaskMap = goingTaskList.stream().collect(Collectors.groupingBy(TrainingCourseUserTask::getTaskId));
                        }
                        LambdaQueryWrapper wrapperU = new LambdaQueryWrapper();
                        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapperU.eq(TrainingPaperUserTurns::getProjectId, (Object)courseVo.getId())).eq(TrainingPaperUserTurns::getTurnType, (Object)4)).in(TrainingPaperUserTurns::getUserId, notCourseList)).orderByDesc(TrainingPaperUserTurns::getTurns);
                        List paperUserTurns = this.paperUserTurnsMapper.selectList((Wrapper)wrapperU);
                        if (!CollectionUtils.isEmpty((Collection)paperUserTurns)) {
                            turnMap = paperUserTurns.stream().collect(Collectors.groupingBy(TrainingPaperUserTurns::getUserId));
                        }
                    }
                    for (TrainingCourseStage stage : stageList) {
                        TrainingCourseStageVo stageVo = new TrainingCourseStageVo();
                        BeanUtils.copyProperties((Object)stage, (Object)stageVo);
                        ArrayList<Object> goingStageList = new ArrayList<Object>();
                        goingStageList.addAll(notCourseList);
                        ArrayList<Object> finishStageList = new ArrayList<Object>();
                        finishStageList.addAll(notCourseList);
                        ArrayList<TrainingCourseStageTaskVo> taskVoList = new ArrayList<TrainingCourseStageTaskVo>();
                        List<TrainingCourseStageTask> taskList = stageTaskMap.get(stageVo.getId());
                        for (TrainingCourseStageTask task : taskList) {
                            TrainingMaterial trainingMaterial;
                            TrainingCourseStageTaskVo taskVo = new TrainingCourseStageTaskVo();
                            BeanUtils.copyProperties((Object)task, (Object)taskVo);
                            if (task.getMaterialId() != null && !ObjectUtils.isEmpty((Object)(trainingMaterial = (TrainingMaterial)materialMap.get(task.getMaterialId())))) {
                                taskVo.setFileType(trainingMaterial.getFileType());
                                taskVo.setUrl(trainingMaterial.getMaterialPath());
                            }
                            int finishCount = 0;
                            List<Object> finishUser = new ArrayList();
                            List userFinishList = (List)finishTaskMap.get(taskVo.getId());
                            if (!CollectionUtils.isEmpty((Collection)userFinishList)) {
                                ArrayList<TrainingCourseUserTask> delList = new ArrayList<TrainingCourseUserTask>();
                                for (TrainingCourseUserTask courseUserTask : userFinishList) {
                                    List paperUserTurnsList = (List)turnMap.get(courseUserTask.getUserId());
                                    if (!CollectionUtils.isEmpty((Collection)paperUserTurnsList)) {
                                        for (TrainingPaperUserTurns userTurns : paperUserTurnsList) {
                                            if (userTurns.getStageId().intValue() != taskVo.getStageId().intValue() || courseUserTask.getTurns().intValue() == userTurns.getTurns().intValue()) continue;
                                            delList.add(courseUserTask);
                                        }
                                        continue;
                                    }
                                    if (courseUserTask.getTurns() == 1) continue;
                                    delList.add(courseUserTask);
                                }
                                if (!CollectionUtils.isEmpty(delList)) {
                                    userFinishList.removeAll(delList);
                                }
                                finishUser = userFinishList.stream().map(TrainingCourseUserTask::getUserId).distinct().collect(Collectors.toList());
                                finishCount = finishUser.size();
                            }
                            finishStageList.retainAll(finishUser);
                            taskVo.setFinishCount(Integer.valueOf(finishCount));
                            int goingCount = 0;
                            List<Object> goingUser = new ArrayList();
                            List userGoingList = (List)goingTaskMap.get(taskVo.getId());
                            if (!CollectionUtils.isEmpty((Collection)userGoingList)) {
                                ArrayList<TrainingCourseUserTask> delList = new ArrayList<TrainingCourseUserTask>();
                                for (TrainingCourseUserTask courseUserTask : userGoingList) {
                                    List paperUserTurnsList = (List)turnMap.get(courseUserTask.getUserId());
                                    if (!CollectionUtils.isEmpty((Collection)paperUserTurnsList)) {
                                        for (TrainingPaperUserTurns userTurns : paperUserTurnsList) {
                                            if (userTurns.getStageId().intValue() != taskVo.getStageId().intValue() || courseUserTask.getTurns().intValue() == userTurns.getTurns().intValue()) continue;
                                            delList.add(courseUserTask);
                                        }
                                        continue;
                                    }
                                    if (courseUserTask.getTurns() == 1) continue;
                                    delList.add(courseUserTask);
                                }
                                if (!CollectionUtils.isEmpty(delList)) {
                                    userGoingList.removeAll(delList);
                                }
                                goingUser = userGoingList.stream().map(TrainingCourseUserTask::getUserId).distinct().collect(Collectors.toList());
                                goingUser.removeAll(finishUser);
                                goingCount = goingUser.size();
                            }
                            goingStageList.retainAll(goingUser);
                            taskVo.setGoingCount(Integer.valueOf(goingCount));
                            taskVo.setNotCount(Integer.valueOf(notCourseList.size() - finishCount - goingCount));
                            taskVoList.add(taskVo);
                        }
                        stageVo.setTaskList(taskVoList);
                        stageVo.setGoingCount(Integer.valueOf(goingStageList.size()));
                        stageVo.setFinishCount(Integer.valueOf(finishStageList.size()));
                        stageVo.setNotCount(Integer.valueOf(notCourseList.size() - finishStageList.size() - goingStageList.size()));
                        stageVoList.add(stageVo);
                    }
                    courseVo.setStageList(stageVoList);
                }
            }
        }
        return courseVo;
    }

    @Override
    public TrainingCourseUserTaskVo selectCourseUserTaskStatus(TrainingCourseStageTaskVo courseVo, Users user) {
        TrainingCourseStageTask stageTask = (TrainingCourseStageTask)this.courseStageTaskMapper.selectById(courseVo.getId());
        TrainingCourse course = (TrainingCourse)this.courseMapper.selectById(stageTask.getCourseId());
        List<Object> notCourseList = new ArrayList();
        if (course.getAppointType() == 1) {
            LambdaQueryWrapper wrapper3 = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)wrapper3.eq(TrainingCourseUser::getCourseId, (Object)course.getId())).eq(TrainingCourseUser::getCourseType, (Object)1);
            List courseUserList = this.courseUserMapper.selectList((Wrapper)wrapper3);
            if (!CollectionUtils.isEmpty((Collection)courseUserList)) {
                BaseResult simplePojoBaseResult;
                List tagIds;
                List orgIds;
                DepAndTagsPojo pojo;
                String roleIdStr;
                com.ovopark.privilege.response.BaseResult baseResult;
                List roleIds;
                List userIds = courseUserList.stream().map(TrainingCourseUser::getUserId).distinct().filter(Objects::nonNull).collect(Collectors.toList());
                if (!CollectionUtils.isEmpty(userIds)) {
                    notCourseList.addAll(userIds);
                }
                if (!CollectionUtils.isEmpty(roleIds = courseUserList.stream().map(TrainingCourseUser::getRoleId).filter(Objects::nonNull).distinct().collect(Collectors.toList())) && (baseResult = this.useApi.getUserByRoleIds(roleIdStr = StringUtils.join(roleIds, (String)","), user.getGroupId())) != null && !CollectionUtils.isEmpty((Collection)((Collection)baseResult.getData()))) {
                    pojo = ((List)baseResult.getData()).stream().map(com.ovopark.privilege.pojo.UsersPojo::getId).distinct().collect(Collectors.toList());
                    notCourseList.addAll((Collection<Object>)pojo);
                }
                if (!CollectionUtils.isEmpty(orgIds = courseUserList.stream().map(TrainingCourseUser::getOrganizeId).filter(Objects::nonNull).distinct().collect(Collectors.toList()))) {
                    UsersAndOrgsMo mo = new UsersAndOrgsMo();
                    mo.setGroupId(user.getGroupId());
                    mo.setOrganizeIds(orgIds);
                    BaseResult userResult = this.userOrganizeApi.getUserByOrganizeIdsOrDepId(mo);
                    if (!userResult.getIsError().booleanValue() && !CollectionUtils.isEmpty((Collection)((Collection)userResult.getData()))) {
                        List users = ((List)userResult.getData()).stream().map(UserAndParentNameMo::getUserId).distinct().collect(Collectors.toList());
                        notCourseList.addAll(users);
                    }
                }
                if (!CollectionUtils.isEmpty(tagIds = courseUserList.stream().map(TrainingCourseUser::getTagId).filter(Objects::nonNull).distinct().collect(Collectors.toList()))) {
                    pojo = new DepAndTagsPojo();
                    pojo.setGroupId(user.getGroupId());
                    pojo.setTagIds(tagIds);
                    pojo.setUserId(user.getId());
                    BaseResult tagResult = this.tagApi.getUsersByTags(pojo);
                    if (!tagResult.getIsError().booleanValue() && !CollectionUtils.isEmpty((Collection)((Collection)tagResult.getData()))) {
                        for (Map map : (List)tagResult.getData()) {
                            Integer id = (Integer)map.get("id");
                            notCourseList.add(id);
                        }
                    }
                }
                notCourseList = notCourseList.stream().distinct().collect(Collectors.toList());
                if (course.getStatus() != 3 && !Objects.isNull(simplePojoBaseResult = this.userApi.getSimpleUserByKeyWord(course.getEnterpriseId(), null, null)) && !CollectionUtils.isEmpty((Collection)((Collection)simplePojoBaseResult.getData()))) {
                    notCourseList.retainAll(((List)simplePojoBaseResult.getData()).stream().map(SimplePojo::getId).distinct().collect(Collectors.toList()));
                }
            }
        } else {
            List pojoList = (List)this.userApi.getSimpleUserByKeyWord(course.getEnterpriseId(), null, null).getData();
            notCourseList = pojoList.stream().map(SimplePojo::getId).distinct().collect(Collectors.toList());
        }
        if (!CollectionUtils.isEmpty(notCourseList)) {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            BaseResult base = this.userApi.getUserGtCreateTime(course.getEnterpriseId(), format.format(course.getEndTime()));
            if (base != null && !CollectionUtils.isEmpty((Collection)((Collection)base.getData()))) {
                List userRemoveList = (List)base.getData();
                notCourseList.removeAll(userRemoveList);
            }
        }
        TrainingCourseUserTaskVo userTaskVo = new TrainingCourseUserTaskVo();
        userTaskVo.setTotalCount(Integer.valueOf(notCourseList.size()));
        LambdaQueryWrapper wrapperU = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapperU.eq(TrainingPaperUserTurns::getProjectId, (Object)stageTask.getCourseId())).eq(TrainingPaperUserTurns::getStageId, (Object)stageTask.getStageId())).eq(TrainingPaperUserTurns::getTurnType, (Object)4)).in(TrainingPaperUserTurns::getUserId, notCourseList)).orderByDesc(TrainingPaperUserTurns::getTurns);
        List paperUserTurns = this.paperUserTurnsMapper.selectList((Wrapper)wrapperU);
        Map<Object, Object> turnMap = new HashMap();
        if (!CollectionUtils.isEmpty((Collection)paperUserTurns)) {
            turnMap = paperUserTurns.stream().collect(Collectors.groupingBy(TrainingPaperUserTurns::getUserId));
        }
        Integer finishCount = 0;
        LambdaQueryWrapper wrapper2 = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper2.eq(TrainingCourseUserTask::getTaskId, (Object)courseVo.getId())).in(TrainingCourseUserTask::getUserId, notCourseList)).in(TrainingCourseUserTask::getTaskStatus, Arrays.asList(3, 4));
        List taskList2 = this.courseUserTaskMapper.selectList((Wrapper)wrapper2);
        if (!CollectionUtils.isEmpty((Collection)taskList2)) {
            ArrayList<TrainingCourseUserTask> delList = new ArrayList<TrainingCourseUserTask>();
            for (TrainingCourseUserTask courseUserTask : taskList2) {
                List paperUserTurnsList = (List)turnMap.get(courseUserTask.getUserId());
                if (!CollectionUtils.isEmpty((Collection)paperUserTurnsList)) {
                    if (courseUserTask.getTurns().intValue() == ((TrainingPaperUserTurns)paperUserTurnsList.get(0)).getTurns().intValue()) continue;
                    delList.add(courseUserTask);
                    continue;
                }
                if (courseUserTask.getTurns() == 1) continue;
                delList.add(courseUserTask);
            }
            if (!CollectionUtils.isEmpty(delList)) {
                taskList2.removeAll(delList);
            }
            finishCount = taskList2.size();
        }
        userTaskVo.setFinishCount(finishCount);
        Integer failCount = 0;
        LambdaQueryWrapper wrapper3 = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper3.eq(TrainingCourseUserTask::getTaskId, (Object)courseVo.getId())).in(TrainingCourseUserTask::getUserId, notCourseList)).eq(TrainingCourseUserTask::getTaskStatus, (Object)5);
        List taskList3 = this.courseUserTaskMapper.selectList((Wrapper)wrapper3);
        if (!CollectionUtils.isEmpty((Collection)taskList3)) {
            ArrayList<TrainingCourseUserTask> delList = new ArrayList<TrainingCourseUserTask>();
            for (TrainingCourseUserTask courseUserTask : taskList3) {
                List paperUserTurnsList = (List)turnMap.get(courseUserTask.getUserId());
                if (!CollectionUtils.isEmpty((Collection)paperUserTurnsList)) {
                    if (courseUserTask.getTurns().intValue() == ((TrainingPaperUserTurns)paperUserTurnsList.get(0)).getTurns().intValue()) continue;
                    delList.add(courseUserTask);
                    continue;
                }
                if (courseUserTask.getTurns() == 1) continue;
                delList.add(courseUserTask);
            }
            if (!CollectionUtils.isEmpty(delList)) {
                taskList3.removeAll(delList);
            }
            failCount = taskList3.size();
        }
        userTaskVo.setFailCount(failCount);
        int waitCount = 0;
        LambdaQueryWrapper wrapper4 = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper4.eq(TrainingCourseUserTask::getTaskId, (Object)courseVo.getId())).in(TrainingCourseUserTask::getUserId, notCourseList)).eq(TrainingCourseUserTask::getTaskStatus, (Object)6);
        List taskList4 = this.courseUserTaskMapper.selectList((Wrapper)wrapper4);
        if (!CollectionUtils.isEmpty((Collection)taskList4)) {
            ArrayList<TrainingCourseUserTask> delList = new ArrayList<TrainingCourseUserTask>();
            for (TrainingCourseUserTask courseUserTask : taskList4) {
                List paperUserTurnsList = (List)turnMap.get(courseUserTask.getUserId());
                if (!CollectionUtils.isEmpty((Collection)paperUserTurnsList)) {
                    if (courseUserTask.getTurns().intValue() == ((TrainingPaperUserTurns)paperUserTurnsList.get(0)).getTurns().intValue()) continue;
                    delList.add(courseUserTask);
                    continue;
                }
                if (courseUserTask.getTurns() == 1) continue;
                delList.add(courseUserTask);
            }
            if (!CollectionUtils.isEmpty(delList)) {
                taskList4.removeAll(delList);
            }
            waitCount = taskList4.size();
        }
        userTaskVo.setWaitCount(Integer.valueOf(waitCount));
        int goingCount = 0;
        LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper1.eq(TrainingCourseUserTask::getTaskId, (Object)courseVo.getId())).in(TrainingCourseUserTask::getUserId, notCourseList)).ne(TrainingCourseUserTask::getTaskStatus, (Object)1);
        List taskList1 = this.courseUserTaskMapper.selectList((Wrapper)wrapper1);
        if (!CollectionUtils.isEmpty((Collection)taskList1)) {
            ArrayList<TrainingCourseUserTask> delList = new ArrayList<TrainingCourseUserTask>();
            for (TrainingCourseUserTask courseUserTask : taskList1) {
                List paperUserTurnsList = (List)turnMap.get(courseUserTask.getUserId());
                if (!CollectionUtils.isEmpty((Collection)paperUserTurnsList)) {
                    if (courseUserTask.getTurns().intValue() == ((TrainingPaperUserTurns)paperUserTurnsList.get(0)).getTurns().intValue()) continue;
                    delList.add(courseUserTask);
                    continue;
                }
                if (courseUserTask.getTurns() == 1) continue;
                delList.add(courseUserTask);
            }
            if (!CollectionUtils.isEmpty(delList)) {
                taskList1.removeAll(delList);
            }
            List userIds = taskList1.stream().map(TrainingCourseUserTask::getUserId).distinct().collect(Collectors.toList());
            if (!CollectionUtils.isEmpty((Collection)taskList2)) {
                List userIds2 = taskList2.stream().map(TrainingCourseUserTask::getUserId).distinct().collect(Collectors.toList());
                userIds.removeAll(userIds2);
            }
            if (!CollectionUtils.isEmpty((Collection)taskList3)) {
                List userIds3 = taskList3.stream().map(TrainingCourseUserTask::getUserId).distinct().collect(Collectors.toList());
                userIds.removeAll(userIds3);
            }
            if (!CollectionUtils.isEmpty((Collection)taskList4)) {
                List userIds4 = taskList4.stream().map(TrainingCourseUserTask::getUserId).distinct().collect(Collectors.toList());
                userIds.removeAll(userIds4);
            }
            goingCount = userIds.size();
        }
        userTaskVo.setGoingCount(Integer.valueOf(goingCount));
        userTaskVo.setNotCount(Integer.valueOf(notCourseList.size() - goingCount - finishCount - failCount - waitCount));
        return userTaskVo;
    }

    @Override
    public List<TrainingCourseUserTaskVo> selectCourseUserPaper(TrainingCourseUserTaskVo courseUserTaskVo, Users user) {
        ArrayList<TrainingCourseUserTaskVo> courseUserTaskVos;
        block87: {
            courseUserTaskVos = new ArrayList<TrainingCourseUserTaskVo>();
            try {
                List paperId;
                LambdaQueryWrapper wrapper2;
                TrainingCourseStageTask courseStageTask = (TrainingCourseStageTask)this.courseStageTaskMapper.selectById(courseUserTaskVo.getTaskId());
                if (org.springframework.util.StringUtils.isEmpty((Object)courseStageTask)) break block87;
                LambdaQueryWrapper wrapper0 = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper0.eq(TrainingCourseUserTask::getCourseId, (Object)courseStageTask.getCourseId())).eq(TrainingCourseUserTask::getTaskId, (Object)courseStageTask.getId())).eq(TrainingCourseUserTask::getUserId, (Object)courseUserTaskVo.getUserId());
                List courseUserTasks = this.courseUserTaskMapper.selectList((Wrapper)wrapper0);
                Map<Object, Object> courseUserTaskMap = new HashMap();
                if (!CollectionUtils.isEmpty((Collection)courseUserTasks)) {
                    courseUserTaskMap = courseUserTasks.stream().collect(Collectors.toMap(TrainingCourseUserTask::getTurns, Function.identity()));
                }
                LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper1.eq(TrainingPaperUserTurns::getProjectId, (Object)courseStageTask.getCourseId())).eq(TrainingPaperUserTurns::getStageId, (Object)courseStageTask.getStageId())).eq(TrainingPaperUserTurns::getTurnType, (Object)4)).eq(TrainingPaperUserTurns::getUserId, (Object)courseUserTaskVo.getUserId())).orderByDesc(TrainingPaperUserTurns::getTurns);
                List paperUserTurnsList = this.paperUserTurnsMapper.selectList((Wrapper)wrapper1);
                Integer turns = 1;
                if (!CollectionUtils.isEmpty((Collection)paperUserTurnsList)) {
                    turns = ((TrainingPaperUserTurns)paperUserTurnsList.get(0)).getTurns();
                }
                Map<Object, Object> paperTurnsMap = new HashMap();
                Map<Object, Object> userPaperMap = new HashMap();
                TrainingMaterial material = new TrainingMaterial();
                BigDecimal score = new BigDecimal(100);
                Map<Object, Object> materialsMap = new HashMap();
                Map<Object, Object> viewTimeVoMap = new HashMap();
                Map<Object, Object> chapterAttachMap = new HashMap();
                List<Object> chapterList = new ArrayList();
                Map<Object, Object> trainingWorkUserAnswerMap = new HashMap();
                Map<Object, Object> papersMap = new HashMap();
                if (courseStageTask.getTaskType() == 1) {
                    List<TrainingChapterAttach> attachList;
                    wrapper2 = new LambdaQueryWrapper();
                    wrapper2.eq(TrainingAndMaterial::getTrainingId, (Object)courseStageTask.getTrainingId());
                    List andMaterialList = this.andMaterialMapper.selectList((Wrapper)wrapper2);
                    if (!CollectionUtils.isEmpty((Collection)andMaterialList)) {
                        List<TrainingUserViewTimeVo> userViewTimeVos;
                        List materialIds = andMaterialList.stream().map(TrainingAndMaterial::getMaterialId).distinct().collect(Collectors.toList());
                        List materials = this.materialMapper.selectBatchIds(materialIds);
                        materialsMap = materials.stream().collect(Collectors.toMap(TrainingMaterial::getId, Function.identity()));
                        int learnType = 4;
                        if (courseStageTask.getIsProgress() == 1) {
                            learnType = 0;
                        }
                        if (!CollectionUtils.isEmpty(userViewTimeVos = this.trainingUserViewTimeMapper.selectViewTimeByUserMaterial(courseUserTaskVo.getUserId(), courseUserTaskVo.getTurns(), (Integer)(learnType == 0 && turns == 1 ? null : courseStageTask.getTrainingId()), learnType, learnType == 0 ? null : courseStageTask.getId()))) {
                            viewTimeVoMap = userViewTimeVos.stream().collect(Collectors.toMap(TrainingUserViewTime::getMaterialId, Function.identity()));
                        }
                    }
                    if (!CollectionUtils.isEmpty(chapterList = this.trainingChapterMapper.selectByTrainingId(courseStageTask.getTrainingId())) && !CollectionUtils.isEmpty(attachList = this.trainingChapterAttachMapper.selectAllByTrainingId(courseStageTask.getTrainingId()))) {
                        chapterAttachMap = attachList.stream().collect(Collectors.groupingBy(TrainingChapterAttach::getChapterId));
                        paperId = attachList.stream().map(TrainingChapterAttach::getPaperId).distinct().collect(Collectors.toList());
                        if (!CollectionUtils.isEmpty(paperId)) {
                            List papers;
                            LambdaQueryWrapper wrapper4 = new LambdaQueryWrapper();
                            ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper4.eq(TrainingUserPaper::getUserId, (Object)courseUserTaskVo.getUserId())).in(TrainingUserPaper::getTrainingPaperId, (Collection)paperId)).eq(TrainingUserPaper::getSourceType, (Object)5)).eq(TrainingUserPaper::getSourceProjectId, (Object)courseStageTask.getCourseId())).eq(TrainingUserPaper::getSourceTaskId, (Object)courseUserTaskVo.getTaskId())).isNotNull(TrainingUserPaper::getSubmitTime)).orderByAsc(TrainingUserPaper::getCreateTime);
                            List userPaperList = this.trainingUserPaperMapper.selectList((Wrapper)wrapper4);
                            if (!CollectionUtils.isEmpty((Collection)userPaperList)) {
                                userPaperMap = userPaperList.stream().collect(Collectors.groupingBy(TrainingUserPaper::getTrainingPaperId));
                            }
                            if (!CollectionUtils.isEmpty((Collection)(papers = this.trainingPaperMapper.selectBatchIds(paperId)))) {
                                papersMap = papers.stream().collect(Collectors.toMap(TrainingPaper::getId, Function.identity()));
                            }
                        }
                    }
                } else if (courseStageTask.getTaskType() == 2) {
                    ArrayList<Integer> paperIdList = new ArrayList<Integer>();
                    paperIdList.add(courseStageTask.getPaperId());
                    LambdaQueryWrapper wrapper22 = new LambdaQueryWrapper();
                    ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper22.eq(TrainingPaperTurns::getProjectId, (Object)courseStageTask.getCourseId())).eq(TrainingPaperTurns::getTaskId, (Object)courseStageTask.getId())).eq(TrainingPaperTurns::getTurnType, (Object)4);
                    List paperTurnsList = this.paperTurnsMapper.selectList((Wrapper)wrapper22);
                    if (!CollectionUtils.isEmpty((Collection)paperTurnsList)) {
                        paperTurnsMap = paperTurnsList.stream().collect(Collectors.toMap(TrainingPaperTurns::getTurns, Function.identity()));
                        List paperIds = paperTurnsList.stream().map(TrainingPaperTurns::getPaperId).distinct().collect(Collectors.toList());
                        paperIdList.addAll(paperIds);
                    }
                    if (!CollectionUtils.isEmpty(paperIdList)) {
                        LambdaQueryWrapper wrapper3 = new LambdaQueryWrapper();
                        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper3.eq(TrainingUserPaper::getUserId, (Object)courseUserTaskVo.getUserId())).in(TrainingUserPaper::getTrainingPaperId, paperIdList)).eq(TrainingUserPaper::getSourceType, (Object)5)).eq(TrainingUserPaper::getSourceProjectId, (Object)courseStageTask.getCourseId())).eq(TrainingUserPaper::getSourceTaskId, (Object)courseUserTaskVo.getTaskId())).orderByAsc(TrainingUserPaper::getCreateTime);
                        List userPaperList = this.trainingUserPaperMapper.selectList((Wrapper)wrapper3);
                        if (!CollectionUtils.isEmpty((Collection)userPaperList)) {
                            userPaperMap = userPaperList.stream().collect(Collectors.groupingBy(TrainingUserPaper::getTrainingPaperId));
                        }
                    }
                    TrainingPaper paper = (TrainingPaper)this.trainingPaperMapper.selectById(courseStageTask.getPaperId());
                    BigDecimal totalScore = new BigDecimal(100);
                    if (!org.springframework.util.StringUtils.isEmpty((Object)paper) && !org.springframework.util.StringUtils.isEmpty((Object)paper.getExamId())) {
                        TrainingExam exam = (TrainingExam)this.examMapper.selectById(paper.getExamId());
                        totalScore = exam.getScore();
                    }
                    score = totalScore.multiply(new BigDecimal(paper.getPassLine() == null ? 60 : paper.getPassLine())).divide(new BigDecimal(100), 2, 4);
                } else if (courseStageTask.getTaskType() == 5) {
                    material = (TrainingMaterial)this.materialMapper.selectById(courseStageTask.getMaterialId());
                } else if (courseStageTask.getTaskType() == 6) {
                    wrapper2 = new LambdaQueryWrapper();
                    ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper2.eq(TrainingWorkUserAnswer::getWorkId, (Object)courseStageTask.getWorkId())).eq(TrainingWorkUserAnswer::getSourceType, (Object)5)).eq(TrainingWorkUserAnswer::getSourceTaskId, (Object)courseStageTask.getId())).eq(TrainingWorkUserAnswer::getUserId, (Object)courseUserTaskVo.getUserId())).orderByDesc(TrainingWorkUserAnswer::getCommitTime);
                    List list = this.trainingWorkUserAnswerMapper.selectList((Wrapper)wrapper2);
                    if (!CollectionUtils.isEmpty((Collection)list)) {
                        trainingWorkUserAnswerMap = list.stream().collect(Collectors.groupingBy(TrainingWorkUserAnswer::getTurns));
                    }
                }
                for (int i = 0; i < turns; ++i) {
                    List trainingWorkUserAnswerList;
                    if (!org.springframework.util.StringUtils.isEmpty((Object)courseUserTaskVo.getTurns())) {
                        i = courseUserTaskVo.getTurns() - 1;
                    }
                    TrainingCourseUserTask courseUserTask = (TrainingCourseUserTask)courseUserTaskMap.get(i + 1);
                    TrainingCourseUserTaskVo trainingCourseUserTaskVo = new TrainingCourseUserTaskVo();
                    if (!ObjectUtils.isEmpty((Object)courseUserTask)) {
                        BeanUtils.copyProperties((Object)courseUserTask, (Object)trainingCourseUserTaskVo);
                    }
                    if (courseStageTask.getTaskType() == 1) {
                        TrainingsVo trainingsVo = new TrainingsVo();
                        if (!CollectionUtils.isEmpty(chapterList)) {
                            ArrayList<TrainingChapterVo> chapterVoList = new ArrayList<TrainingChapterVo>();
                            Integer materialNum = 0;
                            Integer paperNum = 0;
                            Integer materialFinishNum = 0;
                            Integer paperFinishNum = 0;
                            for (TrainingChapter trainingChapter : chapterList) {
                                TrainingChapterVo chapterVo = new TrainingChapterVo();
                                BeanUtils.copyProperties((Object)trainingChapter, (Object)chapterVo);
                                List chapterAttachList = (List)chapterAttachMap.get(trainingChapter.getId());
                                if (!CollectionUtils.isEmpty((Collection)chapterAttachList)) {
                                    ArrayList<TrainingChapterAttachVo> attachVoList = new ArrayList<TrainingChapterAttachVo>();
                                    for (TrainingChapterAttach chapterAttach : chapterAttachList) {
                                        Integer trainingCourseUserTask;
                                        Object queryWrapper;
                                        Integer material1;
                                        Integer userViewTimeVo;
                                        TrainingChapterAttachVo chapterAttachVo = new TrainingChapterAttachVo();
                                        BeanUtils.copyProperties((Object)chapterAttach, (Object)chapterAttachVo);
                                        if (chapterAttachVo.getMaterialId() != null) {
                                            Integer n = materialNum;
                                            Integer n2 = materialNum = Integer.valueOf(materialNum + 1);
                                            userViewTimeVo = (TrainingUserViewTimeVo)viewTimeVoMap.get(chapterAttachVo.getMaterialId());
                                            material1 = (TrainingMaterial)materialsMap.get(chapterAttachVo.getMaterialId());
                                            TrainingMaterialVo materialVo = new TrainingMaterialVo();
                                            BeanUtils.copyProperties((Object)material1, (Object)materialVo);
                                            if (userViewTimeVo != null) {
                                                queryWrapper = new LambdaQueryWrapper();
                                                queryWrapper.eq(TrainingCourseUserTask::getCourseId, (Object)courseStageTask.getCourseId());
                                                queryWrapper.eq(TrainingCourseUserTask::getTaskId, (Object)courseStageTask.getId());
                                                queryWrapper.eq(TrainingCourseUserTask::getUserId, (Object)courseUserTaskVo.getUserId());
                                                trainingCourseUserTask = (TrainingCourseUserTask)this.courseUserTaskMapper.selectOne((Wrapper)queryWrapper);
                                                if (trainingCourseUserTask != null) {
                                                    materialVo.setStartDate(trainingCourseUserTask.getStartTime());
                                                }
                                                materialVo.setEndDate(userViewTimeVo.getEndDate());
                                                BigDecimal finishTime = new BigDecimal(0);
                                                finishTime = materialVo.getIsVideo() == 1 ? new BigDecimal(materialVo.getDuration()) : (org.springframework.util.StringUtils.isEmpty((Object)materialVo.getFinishTime()) ? new BigDecimal(0) : new BigDecimal(materialVo.getFinishTime()));
                                                BigDecimal viewTime = new BigDecimal(org.springframework.util.StringUtils.isEmpty((Object)userViewTimeVo.getViewTimes()) ? 0 : userViewTimeVo.getViewTimes());
                                                BigDecimal readRate = finishTime.compareTo(new BigDecimal(0)) > 0 ? viewTime.divide(finishTime, 2, 1) : new BigDecimal(1);
                                                materialVo.setReadRate(readRate.compareTo(new BigDecimal(1)) >= 0 ? new BigDecimal(1) : readRate);
                                                int times = viewTime.intValue();
                                                materialVo.setTimeStr(DateUtils.getUseTimeFormal(times));
                                                if (readRate.compareTo(new BigDecimal(1)) < 0) {
                                                    materialVo.setTaskStatus(Integer.valueOf(2));
                                                    materialVo.setEndDate(null);
                                                } else {
                                                    materialVo.setTaskStatus(Integer.valueOf(3));
                                                    Integer n3 = materialFinishNum;
                                                    Integer n4 = materialFinishNum = Integer.valueOf(materialFinishNum + 1);
                                                    if (trainingCourseUserTask != null) {
                                                        if (trainingCourseUserTask.getEndTime().after(userViewTimeVo.getEndDate())) {
                                                            materialVo.setEndDate(trainingCourseUserTask.getEndTime());
                                                        } else {
                                                            materialVo.setEndDate(userViewTimeVo.getEndDate());
                                                        }
                                                    }
                                                }
                                            } else {
                                                materialVo.setReadRate(new BigDecimal(0));
                                                materialVo.setTaskStatus(Integer.valueOf(1));
                                                materialVo.setEndDate(null);
                                            }
                                            chapterAttachVo.setMaterialVo(materialVo);
                                        } else if (chapterAttachVo.getPaperId() != null) {
                                            List userPaperList;
                                            userViewTimeVo = paperNum;
                                            material1 = paperNum = Integer.valueOf(paperNum + 1);
                                            TrainingPapersVo paperVo = new TrainingPapersVo();
                                            TrainingPaper paper = (TrainingPaper)papersMap.get(chapterAttachVo.getPaperId());
                                            if (paper != null) {
                                                BeanUtils.copyProperties((Object)paper, (Object)paperVo);
                                            }
                                            if (!CollectionUtils.isEmpty((Collection)(userPaperList = (List)userPaperMap.get(chapterAttachVo.getPaperId())))) {
                                                queryWrapper = paperFinishNum;
                                                trainingCourseUserTask = paperFinishNum = Integer.valueOf(paperFinishNum + 1);
                                                TrainingUserPaper userPaper = null;
                                                if (paper.getScoreSelect() == null || paper.getScoreSelect() != null && paper.getScoreSelect().equals(1)) {
                                                    for (int j = userPaperList.size() - 1; j >= 0; --j) {
                                                        TrainingUserPaper up = (TrainingUserPaper)userPaperList.get(j);
                                                        if (!up.getPaperStatus().equals(2) || userPaper != null) continue;
                                                        userPaper = up;
                                                        break;
                                                    }
                                                } else if (paper.getScoreSelect() != null && paper.getScoreSelect().equals(0)) {
                                                    for (TrainingUserPaper up : userPaperList) {
                                                        if (!up.getPaperStatus().equals(2) || userPaper != null && !(userPaper.getScore().doubleValue() < up.getScore().doubleValue())) continue;
                                                        userPaper = up;
                                                    }
                                                }
                                                if (ObjectUtils.isEmpty(userPaper)) {
                                                    userPaper = (TrainingUserPaper)userPaperList.get(0);
                                                }
                                                paperVo.setScore(userPaper.getScore());
                                                paperVo.setSubmitTime(userPaper.getSubmitTime());
                                                paperVo.setPaperCount(Integer.valueOf(userPaperList.size()));
                                                int totalTime = 0;
                                                int num = 0;
                                                for (TrainingUserPaper userPaper1 : userPaperList) {
                                                    if (userPaper1.getSubmitTime() == null || userPaper1.getUpdateTime() == null) continue;
                                                    int time = (int)(userPaper1.getSubmitTime().getTime() - userPaper1.getUpdateTime().getTime()) / 1000;
                                                    totalTime += time;
                                                    ++num;
                                                }
                                                if (num != 0) {
                                                    totalTime /= num;
                                                }
                                                paperVo.setTimeStr(DateUtils.getUseTimeFormal(totalTime));
                                                if (userPaper.getPaperStatus() == 1) {
                                                    paperVo.setStatus(Integer.valueOf(4));
                                                    paperVo.setScore(new BigDecimal(-1));
                                                } else {
                                                    BigDecimal totalScore = new BigDecimal(100);
                                                    if (!org.springframework.util.StringUtils.isEmpty((Object)paper) && !org.springframework.util.StringUtils.isEmpty((Object)paper.getExamId())) {
                                                        TrainingExam exam = (TrainingExam)this.examMapper.selectById(paper.getExamId());
                                                        totalScore = exam.getScore();
                                                    }
                                                    BigDecimal passScore = totalScore.multiply(new BigDecimal(paper == null || paper.getPassLine() == null ? 60 : paper.getPassLine())).divide(new BigDecimal(100), 2, 4);
                                                    if (userPaper.getScore().compareTo(passScore) < 0) {
                                                        paperVo.setStatus(Integer.valueOf(1));
                                                    } else {
                                                        paperVo.setStatus(Integer.valueOf(2));
                                                    }
                                                }
                                            } else {
                                                paperVo.setStatus(Integer.valueOf(3));
                                            }
                                            chapterAttachVo.setPaperVo(paperVo);
                                        }
                                        attachVoList.add(chapterAttachVo);
                                    }
                                    chapterVo.setAttachVoList(attachVoList);
                                }
                                chapterVoList.add(chapterVo);
                            }
                            trainingsVo.setChapterVos(chapterVoList);
                            trainingsVo.setMaterialCount(materialNum);
                            trainingsVo.setMaterialFinishCount(materialFinishNum);
                            trainingsVo.setPaperCount(paperNum);
                            trainingsVo.setPaperFinishCount(paperFinishNum);
                        }
                        trainingCourseUserTaskVo.setTrainingsVo(trainingsVo);
                    } else if (courseStageTask.getTaskType() == 2) {
                        paperId = courseStageTask.getPaperId();
                        if (i > 0 && !org.springframework.util.StringUtils.isEmpty(paperTurnsMap)) {
                            paperId = ((TrainingPaperTurns)paperTurnsMap.get(i + 1)).getPaperId();
                        }
                        List userPaperList = (List)userPaperMap.get(paperId);
                        ArrayList<TrainingUserPaperVo> userPaperVoList = new ArrayList<TrainingUserPaperVo>();
                        if (!CollectionUtils.isEmpty((Collection)userPaperList)) {
                            TrainingPaper trainingPaper = (TrainingPaper)this.trainingPaperMapper.selectById(((TrainingUserPaper)userPaperList.get(0)).getTrainingPaperId());
                            Integer topScoreId = null;
                            Integer newScoreId = null;
                            double topScore = 0.0;
                            for (int j = userPaperList.size() - 1; j >= 0; --j) {
                                TrainingUserPaper userPaper = (TrainingUserPaper)userPaperList.get(j);
                                if (!userPaper.getPaperStatus().equals(2)) continue;
                                if (userPaper.getScore().doubleValue() > topScore) {
                                    topScore = userPaper.getScore().doubleValue();
                                    topScoreId = userPaper.getId();
                                }
                                if (newScoreId != null) continue;
                                newScoreId = userPaper.getId();
                            }
                            for (TrainingUserPaper userPaper : userPaperList) {
                                TrainingUserPaperVo userPaperVo = new TrainingUserPaperVo();
                                BeanUtils.copyProperties((Object)userPaper, (Object)userPaperVo);
                                userPaperVo.setScoreSelect(trainingPaper.getScoreSelect());
                                if (!org.springframework.util.StringUtils.isEmpty((Object)userPaper.getSubmitTime())) {
                                    int totalTime = (int)((userPaper.getSubmitTime().getTime() - userPaper.getUpdateTime().getTime()) / 1000L);
                                    userPaperVo.setTimeStr(DateUtils.getUseTimeFormal(totalTime));
                                }
                                if (userPaper.getPaperStatus() == 1) {
                                    userPaperVo.setPaperStatus(Integer.valueOf(6));
                                    userPaperVo.setScore(new BigDecimal(-1));
                                } else if (userPaper.getPaperStatus() == 0) {
                                    userPaperVo.setPaperStatus(Integer.valueOf(1));
                                    if (!org.springframework.util.StringUtils.isEmpty((Object)userPaper.getUpdateTime())) {
                                        userPaperVo.setPaperStatus(Integer.valueOf(2));
                                    }
                                    userPaperVo.setScore(new BigDecimal(-1));
                                } else {
                                    if (trainingPaper.getScoreSelect() == null || trainingPaper.getScoreSelect() != null && trainingPaper.getScoreSelect().equals(1)) {
                                        if (userPaper.getId().equals(newScoreId)) {
                                            userPaperVo.setIsSelect(1);
                                        } else {
                                            userPaperVo.setIsSelect(0);
                                        }
                                    } else if (trainingPaper.getScoreSelect() != null && trainingPaper.getScoreSelect().equals(0)) {
                                        if (userPaper.getId().equals(topScoreId)) {
                                            userPaperVo.setIsSelect(1);
                                        } else {
                                            userPaperVo.setIsSelect(0);
                                        }
                                    }
                                    if (score.compareTo(userPaperVo.getScore()) > 0) {
                                        userPaperVo.setPaperStatus(Integer.valueOf(5));
                                    } else {
                                        userPaperVo.setPaperStatus(Integer.valueOf(3));
                                    }
                                }
                                userPaperVoList.add(userPaperVo);
                            }
                        }
                        trainingCourseUserTaskVo.setTrainingUserPaperVoList(userPaperVoList);
                    } else if (courseStageTask.getTaskType() == 5 && !org.springframework.util.StringUtils.isEmpty((Object)material)) {
                        BigDecimal finishTime = BigDecimal.ZERO;
                        finishTime = material.getIsVideo() == 1 ? new BigDecimal(material.getDuration()) : (org.springframework.util.StringUtils.isEmpty((Object)material.getFinishTime()) ? new BigDecimal(0) : new BigDecimal(material.getFinishTime()));
                        int learnType = 4;
                        TrainingUserViewTimeVo trainingViewVo = this.commonService.selectMaterialViewTime(courseUserTaskVo.getUserId(), (Integer)(learnType == 0 && i == 0 ? null : courseStageTask.getId()), learnType, material.getId(), i + 1);
                        if (!org.springframework.util.StringUtils.isEmpty((Object)trainingViewVo)) {
                            BigDecimal viewTime = new BigDecimal(org.springframework.util.StringUtils.isEmpty((Object)trainingViewVo.getViewTimes()) ? 0 : trainingViewVo.getViewTimes());
                            BigDecimal readRate = finishTime.compareTo(BigDecimal.ZERO) > 0 ? viewTime.divide(finishTime, 2, 1) : BigDecimal.ONE;
                            trainingCourseUserTaskVo.setReadRate(viewTime.compareTo(finishTime) >= 0 ? BigDecimal.ONE : readRate);
                            int times = viewTime.intValue();
                            trainingCourseUserTaskVo.setTimeStr(DateUtils.getUseTimeFormal(times));
                        } else {
                            trainingCourseUserTaskVo.setReadRate(new BigDecimal(0));
                            trainingCourseUserTaskVo.setTaskStatus(Integer.valueOf(1));
                            trainingCourseUserTaskVo.setTurns(Integer.valueOf(i + 1));
                        }
                    } else if (courseStageTask.getTaskType() == 6 && !CollectionUtils.isEmpty((Collection)(trainingWorkUserAnswerList = (List)trainingWorkUserAnswerMap.get(i + 1)))) {
                        TrainingWorkUserAnswer trainingWorkUserAnswer = (TrainingWorkUserAnswer)trainingWorkUserAnswerList.get(0);
                        trainingCourseUserTaskVo.setTurns(Integer.valueOf(i + 1));
                        trainingCourseUserTaskVo.setAnswerCount(Integer.valueOf(trainingWorkUserAnswerList.size()));
                        trainingCourseUserTaskVo.setCommitTime(trainingWorkUserAnswer.getCommitTime());
                        trainingCourseUserTaskVo.setScore(trainingWorkUserAnswer.getScore());
                        trainingCourseUserTaskVo.setWorkId(trainingWorkUserAnswer.getWorkId());
                        trainingCourseUserTaskVo.setWorkUserAnswerId(trainingWorkUserAnswer.getId());
                    }
                    courseUserTaskVos.add(trainingCourseUserTaskVo);
                    if (org.springframework.util.StringUtils.isEmpty((Object)courseUserTaskVo.getTurns())) {
                        continue;
                    }
                    break;
                }
            }
            catch (Exception e) {
                log.error("", (Throwable)e);
            }
        }
        return courseUserTaskVos;
    }

    @Override
    public TrainingCourseVo selectAppCourse(TrainingCourseVo courseVo, Users user) {
        BaseResult base;
        TrainingCourse trainingCourse = (TrainingCourse)this.courseMapper.selectById(courseVo.getId());
        if (ObjectUtils.isEmpty((Object)trainingCourse)) {
            return courseVo;
        }
        if (trainingCourse.getEnterpriseId() != null && !trainingCourse.getEnterpriseId().equals(user.getGroupId())) {
            return courseVo;
        }
        BeanUtils.copyProperties((Object)trainingCourse, (Object)courseVo);
        LambdaQueryWrapper wrapperU = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapperU.eq(TrainingPaperUserTurns::getUserId, (Object)user.getId())).eq(TrainingPaperUserTurns::getProjectId, (Object)courseVo.getId())).orderByDesc(TrainingPaperUserTurns::getTurns);
        List paperUserTurns = this.paperUserTurnsMapper.selectList((Wrapper)wrapperU);
        Map<Object, Object> turnMap = new HashMap();
        Integer turns = 1;
        if (!CollectionUtils.isEmpty((Collection)paperUserTurns)) {
            turns = ((TrainingPaperUserTurns)paperUserTurns.get(0)).getTurns();
            turnMap = paperUserTurns.stream().collect(Collectors.groupingBy(TrainingPaperUserTurns::getStageId));
        }
        courseVo.setTurns(turns);
        LambdaQueryWrapper courseUserWrapper1 = new LambdaQueryWrapper();
        courseUserWrapper1.eq(!org.springframework.util.StringUtils.isEmpty((Object)user.getGroupId()), TrainingCourseUser::getEnterpriseId, (Object)user.getGroupId());
        ((LambdaQueryWrapper)courseUserWrapper1.eq(TrainingCourseUser::getCourseId, (Object)courseVo.getId())).eq(TrainingCourseUser::getCourseType, (Object)1);
        List courseUserList1 = this.courseUserMapper.selectList((Wrapper)courseUserWrapper1);
        if (!CollectionUtils.isEmpty((Collection)courseUserList1)) {
            com.ovopark.privilege.response.BaseResult base2;
            List roleIds;
            List pojoList1;
            List userIds1 = courseUserList1.stream().map(TrainingCourseUser::getUserId).distinct().collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(userIds1) && !CollectionUtils.isEmpty((Collection)(pojoList1 = (List)this.userApi.getUserByIdList(userIds1).getData()))) {
                ArrayList<Users> appointList = new ArrayList<Users>();
                for (Object pojo : pojoList1) {
                    Users user1 = new Users();
                    user1.setId(pojo.getId());
                    user1.setShowName(pojo.getShowName());
                    user1.setThumbUrl(pojo.getThumbUrl());
                    appointList.add(user1);
                }
                courseVo.setAppointList(appointList);
            }
            if (!CollectionUtils.isEmpty(roleIds = courseUserList1.stream().map(TrainingCourseUser::getRoleId).filter(Objects::nonNull).distinct().collect(Collectors.toList())) && (base2 = this.roleApi.getRolePojoByIdList(roleIds)) != null && !CollectionUtils.isEmpty((Collection)((Collection)base2.getData()))) {
                ArrayList<Role> rolesList = new ArrayList<Role>();
                for (RolePojo pojo : (List)base2.getData()) {
                    Role role = new Role();
                    role.setId(pojo.getId());
                    role.setRoleName(pojo.getRoleName());
                    rolesList.add(role);
                }
                courseVo.setAppointRoleList(rolesList);
            }
        }
        if (!org.springframework.util.StringUtils.isEmpty((Object)courseVo.getCreater()) && (base = this.userApi.getUserById(courseVo.getCreater())) != null) {
            UsersPojo pojo = (UsersPojo)base.getData();
            courseVo.setCreateName(pojo.getShowName());
            courseVo.setCreateUrl(pojo.getThumbUrl());
        }
        LambdaQueryWrapper courseStageTaskWrapper = new LambdaQueryWrapper();
        courseStageTaskWrapper.eq(TrainingCourseStageTask::getCourseId, (Object)courseVo.getId());
        courseStageTaskWrapper.orderByAsc(TrainingCourseStageTask::getTaskSort);
        List courseStageTaskList = this.courseStageTaskMapper.selectList((Wrapper)courseStageTaskWrapper);
        if (!CollectionUtils.isEmpty((Collection)courseStageTaskList)) {
            Integer detailId;
            TrainingCertificateDetail detailList;
            courseVo.setTaskNum(Integer.valueOf(courseStageTaskList.size()));
            int finishNum1 = 0;
            Integer finishNum2 = 0;
            for (TrainingCourseStageTask stageTask : courseStageTaskList) {
                Integer userTurns = 1;
                List userTurnsList = (List)turnMap.get(stageTask.getStageId());
                if (!CollectionUtils.isEmpty((Collection)userTurnsList)) {
                    userTurns = ((TrainingPaperUserTurns)userTurnsList.get(0)).getTurns();
                }
                LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper1.eq(TrainingCourseUserTask::getCourseId, (Object)courseVo.getId())).eq(TrainingCourseUserTask::getUserId, (Object)user.getId())).eq(TrainingCourseUserTask::getTaskId, (Object)stageTask.getId())).eq(TrainingCourseUserTask::getTurns, (Object)userTurns)).orderByDesc(TrainingCourseUserTask::getId)).last(" limit 1");
                TrainingCourseUserTask userTask1 = (TrainingCourseUserTask)this.courseUserTaskMapper.selectOne((Wrapper)wrapper1);
                if (org.springframework.util.StringUtils.isEmpty((Object)userTask1)) continue;
                if (userTask1.getTaskStatus() == 3) {
                    ++finishNum1;
                    continue;
                }
                if (userTask1.getTaskStatus() != 4) continue;
                Integer n = finishNum2;
                Integer n2 = finishNum2 = Integer.valueOf(finishNum2 + 1);
            }
            if (courseVo.getStatus() == 3 && finishNum1 < courseStageTaskList.size()) {
                courseVo.setStatus(Integer.valueOf(4));
            }
            courseVo.setFinishTaskNum(Integer.valueOf(finishNum1 + finishNum2));
            LambdaUpdateWrapper courseUserWrapper2 = new LambdaUpdateWrapper();
            courseUserWrapper2.eq(!org.springframework.util.StringUtils.isEmpty((Object)user.getGroupId()), TrainingCourseUser::getEnterpriseId, (Object)user.getGroupId());
            ((LambdaUpdateWrapper)courseUserWrapper2.eq(TrainingCourseUser::getCourseId, (Object)courseVo.getId())).in(TrainingCourseUser::getCourseType, Collections.singletonList("2"));
            List courseUserList2 = this.courseUserMapper.selectList((Wrapper)courseUserWrapper2);
            if (!CollectionUtils.isEmpty((Collection)courseUserList2)) {
                List userIds2 = courseUserList2.stream().map(TrainingCourseUser::getUserId).distinct().collect(Collectors.toList());
                List pojoList2 = (List)this.userApi.getSimpleUserByIdList(userIds2).getData();
                ArrayList<Users> managerList = new ArrayList<Users>();
                if (!CollectionUtils.isEmpty((Collection)pojoList2)) {
                    for (SimplePojo pojo : pojoList2) {
                        Users user2 = new Users();
                        user2.setId(pojo.getId());
                        user2.setShowName(pojo.getName());
                        managerList.add(user2);
                    }
                    courseVo.setManagerList(managerList);
                }
            }
            if (Objects.isNull(courseVo.getIsGet()) || courseVo.getIsGet() == 0) {
                courseVo.setIsGet(Integer.valueOf(0));
                courseVo.setCertificateId(Integer.valueOf(0));
                courseVo.setCertificateName("");
                courseVo.setCertificatePath("");
            } else {
                courseVo.setIsGet(Integer.valueOf(1));
                courseVo.setCertificateId(trainingCourse.getCertificateId());
                courseVo.setCertificateName(trainingCourse.getCertificateName());
                courseVo.setCertificatePath(trainingCourse.getCertificatePath());
            }
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.eq(TrainingCourseUserAnalyse::getUserId, (Object)user.getId());
            queryWrapper.eq(TrainingCourseUserAnalyse::getCourseId, (Object)courseVo.getId());
            queryWrapper.eq(TrainingCourseUserAnalyse::getPassStatus, (Object)1);
            List trainingCourseUserAnalyses = this.trainingCourseUserAnalyseMapper.selectList((Wrapper)queryWrapper);
            String url = "";
            if (!CollectionUtils.isEmpty((Collection)trainingCourseUserAnalyses) && ((TrainingCourseUserAnalyse)trainingCourseUserAnalyses.get(0)).getCertificateId() != null && !ObjectUtils.isEmpty((Object)(detailList = (TrainingCertificateDetail)this.certificateDetailMapper.selectById(detailId = ((TrainingCourseUserAnalyse)trainingCourseUserAnalyses.get(0)).getCertificateId())))) {
                url = detailList.getUrl();
            }
            courseVo.setMyCertificatePath(url);
        }
        return courseVo;
    }

    @Override
    public TrainingCourseVo selectAppCourseContent(TrainingCourseVo courseVo, Users user) {
        TrainingCourse trainingCourse;
        ClientInfo clientInfo = Authenticator.getInstance().getCurrentClient();
        String version = "";
        String clientName = "";
        if (!org.springframework.util.StringUtils.isEmpty((Object)clientInfo)) {
            if (!org.springframework.util.StringUtils.isEmpty((Object)clientInfo.getVersion())) {
                String[] vers = clientInfo.getVersion().trim().split("_");
                version = vers[0];
            }
            if (!org.springframework.util.StringUtils.isEmpty((Object)clientInfo.getClient())) {
                clientName = clientInfo.getClient().trim();
            }
        }
        if (ObjectUtils.isEmpty((Object)(trainingCourse = (TrainingCourse)this.courseMapper.selectById(courseVo.getId())))) {
            return courseVo;
        }
        if (trainingCourse.getEnterpriseId() != null && !trainingCourse.getEnterpriseId().equals(user.getGroupId())) {
            return courseVo;
        }
        Integer isRelearn = trainingCourse.getIsRelearn();
        Integer relearnCount = trainingCourse.getRelearnCount();
        if (isRelearn == 0) {
            relearnCount = 0;
        }
        LambdaUpdateWrapper courseStageWrapper = new LambdaUpdateWrapper();
        courseStageWrapper.eq(TrainingCourseStage::getCourseId, (Object)courseVo.getId());
        courseStageWrapper.orderByAsc(TrainingCourseStage::getStageSort);
        List courseStageList = this.courseStageMapper.selectList((Wrapper)courseStageWrapper);
        LambdaUpdateWrapper courseStageTaskWrapper = new LambdaUpdateWrapper();
        courseStageTaskWrapper.eq(TrainingCourseStageTask::getCourseId, (Object)courseVo.getId());
        courseStageTaskWrapper.orderByAsc(TrainingCourseStageTask::getTaskSort);
        List courseStageTaskList = this.courseStageTaskMapper.selectList((Wrapper)courseStageTaskWrapper);
        if (!CollectionUtils.isEmpty((Collection)courseStageTaskList)) {
            List trainingIdList = courseStageTaskList.stream().map(TrainingCourseStageTask::getTrainingId).distinct().filter(Objects::nonNull).collect(Collectors.toList());
            Map<Object, Object> trainingMap = new HashMap();
            if (!CollectionUtils.isEmpty(trainingIdList)) {
                List trainings = this.trainingMapper.selectBatchIds(trainingIdList);
                ArrayList<TrainingsVo> trainingVos = new ArrayList<TrainingsVo>();
                LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)wrapper1.in(TrainingChapterAttach::getTrainingId, trainingIdList)).eq(TrainingChapterAttach::getIsDel, (Object)0);
                List trainingChapterAttachList = this.trainingChapterAttachMapper.selectList((Wrapper)wrapper1);
                Map<Object, Object> trainingChapterAttachMap = new HashMap();
                if (!CollectionUtils.isEmpty((Collection)trainingChapterAttachList)) {
                    trainingChapterAttachMap = trainingChapterAttachList.stream().collect(Collectors.groupingBy(TrainingChapterAttach::getTrainingId));
                }
                for (Training training : trainings) {
                    TrainingsVo vo = new TrainingsVo();
                    BeanUtils.copyProperties((Object)training, (Object)vo);
                    List attachList = (List)trainingChapterAttachMap.get(training.getId());
                    vo.setChapterNum(Integer.valueOf(CollectionUtils.isEmpty((Collection)attachList) ? 0 : attachList.size()));
                    trainingVos.add(vo);
                }
                trainingMap = trainingVos.stream().collect(Collectors.toMap(Training::getId, Function.identity()));
            }
            List paperIdList = courseStageTaskList.stream().map(TrainingCourseStageTask::getPaperId).distinct().filter(Objects::nonNull).collect(Collectors.toList());
            Map<Object, Object> paperMap = new HashMap();
            Map<Object, Object> userPaperMap = new HashMap();
            Map<Object, Object> paperTurnsMap = new HashMap();
            if (!CollectionUtils.isEmpty(paperIdList)) {
                LambdaQueryWrapper wrapper2 = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)wrapper2.eq(TrainingPaperTurns::getProjectId, (Object)courseVo.getId())).eq(TrainingPaperTurns::getTurnType, (Object)4);
                List paperTurnsList = this.paperTurnsMapper.selectList((Wrapper)wrapper2);
                if (!CollectionUtils.isEmpty((Collection)paperTurnsList)) {
                    paperIdList.addAll(paperTurnsList.stream().map(TrainingPaperTurns::getPaperId).distinct().collect(Collectors.toList()));
                    paperIdList = paperIdList.stream().distinct().collect(Collectors.toList());
                    paperTurnsMap = paperTurnsList.stream().collect(Collectors.groupingBy(TrainingPaperTurns::getTaskId));
                }
                List papers = this.trainingPaperMapper.selectBatchIds(paperIdList);
                paperMap = papers.stream().collect(Collectors.toMap(TrainingPaper::getId, Function.identity()));
                LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper1.in(TrainingUserPaper::getTrainingPaperId, paperIdList)).eq(TrainingUserPaper::getUserId, (Object)user.getId())).in(TrainingUserPaper::getPaperStatus, Arrays.asList(1, 2))).eq(TrainingUserPaper::getSourceType, (Object)5)).eq(TrainingUserPaper::getSourceProjectId, (Object)courseVo.getId())).orderByDesc(TrainingUserPaper::getSubmitTime);
                List userPaperList = this.trainingUserPaperMapper.selectList((Wrapper)wrapper1);
                if (!CollectionUtils.isEmpty((Collection)userPaperList)) {
                    userPaperMap = userPaperList.stream().collect(Collectors.groupingBy(TrainingUserPaper::getTrainingPaperId));
                }
            }
            LambdaQueryWrapper wrapper4 = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper4.eq(TrainingPaperUserTurns::getProjectId, (Object)courseVo.getId())).eq(TrainingPaperUserTurns::getTurnType, (Object)4)).eq(TrainingPaperUserTurns::getUserId, (Object)user.getId())).orderByDesc(TrainingPaperUserTurns::getTurns);
            List paperUserTurnsList = this.paperUserTurnsMapper.selectList((Wrapper)wrapper4);
            Map<Object, Object> userTurnsMap = new HashMap();
            if (!CollectionUtils.isEmpty((Collection)paperUserTurnsList)) {
                userTurnsMap = paperUserTurnsList.stream().collect(Collectors.groupingBy(TrainingPaperUserTurns::getStageId));
            }
            List materialIdList = courseStageTaskList.stream().map(TrainingCourseStageTask::getMaterialId).distinct().collect(Collectors.toList());
            Map<Object, Object> materialMap = new HashMap();
            if (!CollectionUtils.isEmpty(materialIdList)) {
                List materials = this.materialMapper.selectBatchIds(materialIdList);
                materialMap = materials.stream().collect(Collectors.toMap(TrainingMaterial::getId, Function.identity()));
                if (!"h5".equalsIgnoreCase(clientName) && version.compareTo("4.48.01") < 0) {
                    ArrayList<TrainingCourseStageTask> delList = new ArrayList<TrainingCourseStageTask>();
                    for (TrainingCourseStageTask task : courseStageTaskList) {
                        TrainingMaterial material;
                        if (org.springframework.util.StringUtils.isEmpty((Object)task.getMaterialId()) || org.springframework.util.StringUtils.isEmpty((Object)(material = (TrainingMaterial)materialMap.get(task.getMaterialId())).getIsCommodity()) || material.getIsCommodity() != 1) continue;
                        delList.add(task);
                    }
                    if (!CollectionUtils.isEmpty(delList)) {
                        courseStageTaskList.removeAll(delList);
                    }
                }
            }
            List workIdList = courseStageTaskList.stream().map(TrainingCourseStageTask::getWorkId).distinct().collect(Collectors.toList());
            Map<Object, Object> workMap = new HashMap();
            if (!CollectionUtils.isEmpty(workIdList)) {
                List trainingWorkList = this.trainingWorkMapper.selectBatchIds(workIdList);
                workMap = trainingWorkList.stream().collect(Collectors.toMap(TrainingWork::getId, Function.identity()));
            }
            Map<Integer, List<TrainingCourseStageTask>> stageTaskMap = courseStageTaskList.stream().collect(Collectors.groupingBy(TrainingCourseStageTask::getStageId));
            if (!CollectionUtils.isEmpty((Collection)courseStageList)) {
                LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper1.eq(TrainingCourseUserTask::getCourseId, (Object)courseVo.getId())).eq(TrainingCourseUserTask::getUserId, (Object)user.getId())).orderByDesc(TrainingCourseUserTask::getTurns);
                List userTaskList = this.courseUserTaskMapper.selectList((Wrapper)wrapper1);
                Map<Object, Object> userTaskMap = new HashMap();
                if (!CollectionUtils.isEmpty((Collection)userTaskList)) {
                    userTaskMap = userTaskList.stream().collect(Collectors.groupingBy(TrainingCourseUserTask::getTaskId));
                }
                LambdaQueryWrapper lastWrapper = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)lastWrapper.eq(TrainingUserLastView::getProjectId, (Object)courseVo.getId())).eq(TrainingUserLastView::getLearnType, (Object)4)).eq(TrainingUserLastView::getUserId, (Object)user.getId())).orderByDesc(TrainingUserLastView::getId);
                List viewList = this.lastViewMapper.selectList((Wrapper)lastWrapper);
                Integer taskId = null;
                if (!CollectionUtils.isEmpty((Collection)viewList)) {
                    taskId = ((TrainingUserLastView)viewList.get(0)).getTaskId();
                }
                Integer isStage = trainingCourse.getIsStage();
                int isLock = 1;
                boolean isNextLock = true;
                int isPaperTypes = 0;
                boolean isStageFinish = true;
                ArrayList<TrainingCourseStageVo> courseStageVoList = new ArrayList<TrainingCourseStageVo>();
                for (int i = 0; i < courseStageList.size(); ++i) {
                    List<TrainingCourseStageTask> stageTaskList;
                    TrainingCourseStage courseStage = (TrainingCourseStage)courseStageList.get(i);
                    TrainingCourseStageVo courseStageVo = new TrainingCourseStageVo();
                    BeanUtils.copyProperties((Object)courseStage, (Object)courseStageVo);
                    courseStageVo.setRounds(relearnCount);
                    int isPaperType = 0;
                    List userTurnsList = (List)userTurnsMap.get(courseStage.getId());
                    Integer turns = 1;
                    if (!CollectionUtils.isEmpty((Collection)userTurnsList)) {
                        turns = ((TrainingPaperUserTurns)userTurnsList.get(0)).getTurns();
                    }
                    courseStageVo.setTurns(turns);
                    if (isStage == 1) {
                        isLock = 1;
                    }
                    if (!CollectionUtils.isEmpty(stageTaskList = stageTaskMap.get(courseStage.getId()))) {
                        ArrayList<TrainingCourseStageTaskVo> taskVoList = new ArrayList<TrainingCourseStageTaskVo>();
                        for (int j = 0; j < stageTaskList.size(); ++j) {
                            TrainingCourseStageTask task = stageTaskList.get(j);
                            if (courseStage.getIsThrough() == 1) {
                                isLock = 1;
                            }
                            TrainingCourseStageTaskVo taskVo = new TrainingCourseStageTaskVo();
                            if (ObjectUtils.isEmpty((Object)task)) continue;
                            BeanUtils.copyProperties((Object)task, (Object)taskVo);
                            if (taskId != null && taskVo.getId().intValue() == taskId.intValue()) {
                                taskVo.setIsLastView(Integer.valueOf(1));
                            }
                            Integer taskStatus = 1;
                            List userTasksList = (List)userTaskMap.get(taskVo.getId());
                            if (!CollectionUtils.isEmpty((Collection)userTasksList) && turns == ((TrainingCourseUserTask)userTasksList.get(0)).getTurns()) {
                                taskStatus = ((TrainingCourseUserTask)userTasksList.get(0)).getTaskStatus();
                            }
                            taskVo.setTaskStatus(taskStatus);
                            if (!isNextLock) {
                                isLock = 0;
                            }
                            isNextLock = taskStatus != 3 && taskStatus != 4;
                            if (taskVo.getTaskType() == 1 && !org.springframework.util.StringUtils.isEmpty((Object)taskVo.getTrainingId())) {
                                TrainingsVo trainingsVo = (TrainingsVo)trainingMap.get(taskVo.getTrainingId());
                                taskVo.setTrainingsVo(trainingsVo);
                                Integer learnType = 4;
                                List<TrainingUserViewTimeVo> timeList = this.commonService.selectlearnProgress(taskVo.getTrainingId(), learnType, taskVo.getId(), user.getId(), turns, taskVo.getIsProgress());
                                if (!CollectionUtils.isEmpty((Collection)timeList)) {
                                    BigDecimal readRate = BigDecimal.ZERO;
                                    Iterator iterator = timeList.iterator();
                                    while (iterator.hasNext()) {
                                        TrainingUserViewTimeVo map = (TrainingUserViewTimeVo)iterator.next();
                                        readRate = readRate.add(map.getReadRate());
                                    }
                                    taskVo.setReadRate(readRate.divide(new BigDecimal("" + timeList.size()), 2, 4));
                                } else {
                                    taskVo.setReadRate(BigDecimal.ZERO);
                                }
                            } else if (taskVo.getTaskType() == 2 && !org.springframework.util.StringUtils.isEmpty((Object)taskVo.getPaperId())) {
                                List hasUserPapers;
                                List turnsList = (List)paperTurnsMap.get(taskVo.getId());
                                Integer paperId = null;
                                if (!CollectionUtils.isEmpty((Collection)turnsList)) {
                                    for (TrainingPaperTurns paperTurns : turnsList) {
                                        if (paperTurns.getTurns().intValue() != turns.intValue()) continue;
                                        paperId = paperTurns.getPaperId();
                                        break;
                                    }
                                }
                                if (paperId == null) {
                                    paperId = taskVo.getPaperId();
                                }
                                taskVo.setPaperId(paperId);
                                TrainingPaper paper = (TrainingPaper)paperMap.get(paperId);
                                TrainingPapersVo papersVo = new TrainingPapersVo();
                                if (ObjectUtils.isEmpty((Object)paper)) continue;
                                BeanUtils.copyProperties((Object)paper, (Object)papersVo);
                                taskVo.setTrainingPapersVo(papersVo);
                                List userPaperList = (List)userPaperMap.get(papersVo.getId());
                                ArrayList<Object> userPapers = new ArrayList<Object>();
                                if (!CollectionUtils.isEmpty((Collection)userPaperList)) {
                                    for (Object trainingUserPaper : userPaperList) {
                                        if (ObjectUtils.isEmpty((Object)trainingUserPaper) || trainingUserPaper.getSourceTaskId() == null || trainingUserPaper.getSourceTaskId().compareTo(taskVo.getId()) != 0) continue;
                                        userPapers.add(trainingUserPaper);
                                    }
                                }
                                TrainingUserPaper selectPaper = null;
                                if (!CollectionUtils.isEmpty(userPapers)) {
                                    Object trainingUserPaper;
                                    selectPaper = (TrainingUserPaper)userPapers.get(0);
                                    trainingUserPaper = userPapers.iterator();
                                    while (trainingUserPaper.hasNext()) {
                                        TrainingUserPaper userPaper = (TrainingUserPaper)trainingUserPaper.next();
                                        if (userPaper.getPaperStatus() == 1) continue;
                                        if (Objects.isNull(paper.getScoreSelect()) || paper.getScoreSelect() == 1) {
                                            if (selectPaper.getPaperStatus() != 1 && !userPaper.getCreateTime().after(selectPaper.getCreateTime())) continue;
                                            selectPaper = userPaper;
                                            continue;
                                        }
                                        if (paper.getScoreSelect() == 0) {
                                            if (selectPaper.getPaperStatus() != 1 && userPaper.getScore().intValue() <= selectPaper.getScore().intValue()) continue;
                                            selectPaper = userPaper;
                                            continue;
                                        }
                                        if (paper.getScoreSelect() != 2 || selectPaper.getPaperStatus() != 1 && !userPaper.getCreateTime().before(selectPaper.getCreateTime())) continue;
                                        selectPaper = userPaper;
                                    }
                                }
                                if (selectPaper != null) {
                                    taskVo.setScore(CollectionUtils.isEmpty(userPapers) ? BigDecimal.ZERO : selectPaper.getScore());
                                } else {
                                    taskVo.setScore(BigDecimal.ZERO);
                                }
                                if (!CollectionUtils.isEmpty(userPapers) && ((TrainingUserPaper)userPapers.get(0)).getPaperStatus() == 2) {
                                    BigDecimal passLine;
                                    TrainingExam exam;
                                    BigDecimal score1 = selectPaper.getScore();
                                    BigDecimal totalScore = new BigDecimal("100");
                                    if (paper.getExamId() != null && !org.springframework.util.StringUtils.isEmpty((Object)(exam = (TrainingExam)this.examMapper.selectById(paper.getExamId()))) && exam.getScore() != null) {
                                        totalScore = exam.getScore();
                                    }
                                    if (score1.compareTo(totalScore.multiply(passLine = new BigDecimal(paper.getPassLine() == null ? "60" : paper.getPassLine().toString()).divide(new BigDecimal("100"), 2, 4))) < 0) {
                                        taskVo.setTaskStatus(Integer.valueOf(5));
                                    }
                                }
                                if (taskVo.getTaskStatus() == 5 && !CollectionUtils.isEmpty(userPapers) && CollectionUtils.isEmpty(hasUserPapers = userPapers.stream().filter(e -> e.getPaperStatus() == 1).collect(Collectors.toList())) && paper.getRepetitionNum() != null && userPapers.size() >= paper.getRepetitionNum()) {
                                    isPaperType = 1;
                                }
                                if (taskStatus == 1) {
                                    taskVo.setScore(null);
                                    taskVo.setTaskStatus(Integer.valueOf(1));
                                }
                            } else if (taskVo.getTaskType() == 5 && !org.springframework.util.StringUtils.isEmpty((Object)taskVo.getMaterialId())) {
                                TrainingMaterial material = (TrainingMaterial)materialMap.get(taskVo.getMaterialId());
                                TrainingMaterialVo materialVo = new TrainingMaterialVo();
                                if (!ObjectUtils.isEmpty((Object)material)) {
                                    BeanUtils.copyProperties((Object)material, (Object)materialVo);
                                    BigDecimal duration = BigDecimal.ZERO;
                                    if (materialVo.getIsVideo() == 1 && !org.springframework.util.StringUtils.isEmpty((Object)materialVo.getDuration()) && !org.springframework.util.StringUtils.isEmpty((Object)materialVo.getFinishRate())) {
                                        duration = new BigDecimal(materialVo.getDuration().toString()).multiply(materialVo.getFinishRate()).divide(new BigDecimal("100"), 0, 4);
                                    }
                                    materialVo.setDuration(Integer.valueOf(duration.intValue()));
                                    BigDecimal finishTime = BigDecimal.ZERO;
                                    finishTime = materialVo.getIsVideo() == 1 ? new BigDecimal(materialVo.getDuration().toString()) : (org.springframework.util.StringUtils.isEmpty((Object)materialVo.getFinishTime()) ? BigDecimal.ZERO : new BigDecimal(materialVo.getFinishTime().toString()));
                                    int learnType = 4;
                                    TrainingUserViewTimeVo trainingViewVo = this.commonService.selectMaterialViewTime(user.getId(), (Integer)(learnType == 0 && turns == 1 ? null : taskVo.getId()), learnType, materialVo.getId(), turns);
                                    if (!org.springframework.util.StringUtils.isEmpty((Object)trainingViewVo)) {
                                        BigDecimal viewTime = new BigDecimal(org.springframework.util.StringUtils.isEmpty((Object)trainingViewVo.getViewTimes()) ? 0 : trainingViewVo.getViewTimes());
                                        BigDecimal readRate = finishTime.compareTo(new BigDecimal(0)) > 0 ? viewTime.divide(finishTime, 2, 1) : BigDecimal.ONE;
                                        taskVo.setReadRate(viewTime.compareTo(finishTime) >= 0 ? BigDecimal.ONE : readRate);
                                        taskVo.setNeedReadTimes(Integer.valueOf(viewTime.compareTo(finishTime) >= 0 ? 0 : finishTime.subtract(viewTime).intValue()));
                                    } else {
                                        taskVo.setReadRate(BigDecimal.ZERO);
                                    }
                                }
                                taskVo.setTrainingMaterialsVo(materialVo);
                            } else if (taskVo.getTaskType() == 6 && !org.springframework.util.StringUtils.isEmpty((Object)taskVo.getWorkId())) {
                                TrainingWork trainingWork = (TrainingWork)workMap.get(taskVo.getWorkId());
                                TrainingWorkVo trainingWorkVo = new TrainingWorkVo();
                                if (!ObjectUtils.isEmpty((Object)trainingWork)) {
                                    BeanUtils.copyProperties((Object)trainingWork, (Object)trainingWorkVo);
                                    if (taskVo.getTaskStatus() == 5 && trainingWork.getIsResubmit() != null && trainingWork.getIsResubmit() == 0) {
                                        isPaperType = 1;
                                    }
                                }
                                taskVo.setTrainingWorkVo(trainingWorkVo);
                            }
                            if (isStage == 0 && j == 0) {
                                isLock = 0;
                            } else if (isStage == 1 && i == 0 && j == 0) {
                                isLock = 0;
                            }
                            if (isStage == 1 && i != 0 && j == 0 && !isStageFinish) {
                                isLock = 1;
                            }
                            if (isStage == 1 && taskStatus != 3 && taskStatus != 4) {
                                isStageFinish = false;
                            }
                            taskVo.setIsLock(Integer.valueOf(isLock));
                            if (isLock == 1 && isPaperType == 1) {
                                isPaperType = 0;
                            }
                            taskVoList.add(taskVo);
                        }
                        courseStageVo.setTaskList(taskVoList);
                        if (isRelearn == 1) {
                            courseStageVo.setIsPaperType(Integer.valueOf(isPaperType));
                            if (isPaperType == 1) {
                                courseStageVo.setShowContent(this.messageSource.getMessage("training.course.stage.task.unpass", null, Authenticator.getInstance().getCurrentClient().getLocale()));
                            }
                        }
                        if (isPaperType == 1) {
                            isPaperTypes = 1;
                        }
                    }
                    courseStageVoList.add(courseStageVo);
                }
                courseVo.setStageList(courseStageVoList);
                if (isRelearn == 2) {
                    courseVo.setIsPaperType(Integer.valueOf(isPaperTypes));
                    if (isPaperTypes == 1) {
                        courseVo.setShowContent(this.messageSource.getMessage("training.course.task.unpass", null, Authenticator.getInstance().getCurrentClient().getLocale()));
                    }
                }
            }
        }
        return courseVo;
    }

    @Override
    public void updateAppCourseRelearn(TrainingCourseStageVo courseStageVo, Users user) {
        TrainingCourse course = (TrainingCourse)this.courseMapper.selectById(courseStageVo.getCourseId());
        LambdaQueryWrapper wrapper0 = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper0.eq(TrainingPaperTurns::getProjectId, (Object)courseStageVo.getCourseId())).eq(TrainingPaperTurns::getTurnType, (Object)4)).orderByDesc(TrainingPaperTurns::getTurns);
        List paperTurnsList = this.paperTurnsMapper.selectList((Wrapper)wrapper0);
        Map<Object, Object> map = new HashMap();
        if (!CollectionUtils.isEmpty((Collection)paperTurnsList)) {
            map = paperTurnsList.stream().collect(Collectors.groupingBy(TrainingPaperTurns::getTaskId));
        }
        LambdaQueryWrapper wrapper4 = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper4.eq(TrainingPaperUserTurns::getProjectId, (Object)courseStageVo.getCourseId())).eq(TrainingPaperUserTurns::getStageId, (Object)courseStageVo.getId())).eq(TrainingPaperUserTurns::getTurnType, (Object)4)).eq(TrainingPaperUserTurns::getUserId, (Object)user.getId())).orderByDesc(TrainingPaperUserTurns::getTurns);
        List paperUserTurnsList = this.paperUserTurnsMapper.selectList((Wrapper)wrapper4);
        Integer newTurns = 2;
        if (!CollectionUtils.isEmpty((Collection)paperUserTurnsList)) {
            newTurns = ((TrainingPaperUserTurns)paperUserTurnsList.get(0)).getTurns() + 1;
        }
        if (course.getIsRelearn() == 1) {
            TrainingPaperUserTurns paperUserTurns;
            LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper1.eq(TrainingCourseStageTask::getCourseId, (Object)courseStageVo.getCourseId())).eq(TrainingCourseStageTask::getTaskType, (Object)2)).eq(TrainingCourseStageTask::getStageId, (Object)courseStageVo.getId());
            List stageTaskList = this.courseStageTaskMapper.selectList((Wrapper)wrapper1);
            for (TrainingCourseStageTask stageTask : stageTaskList) {
                List turnsList = (List)map.get(stageTask.getId());
                if (!CollectionUtils.isEmpty((Collection)turnsList) && (CollectionUtils.isEmpty((Collection)turnsList) || ((TrainingPaperTurns)turnsList.get(0)).getTurns() >= newTurns)) continue;
                Integer newPaperId = this.copyPaper(stageTask.getPaperId());
                TrainingPaperTurns paperTurns = new TrainingPaperTurns();
                paperTurns.setProjectId(stageTask.getCourseId());
                paperTurns.setTaskId(stageTask.getId());
                paperTurns.setPaperId(newPaperId);
                paperTurns.setTurns(newTurns);
                paperTurns.setTurnType(Integer.valueOf(4));
                paperTurns.setEnterpriseId(stageTask.getEnterpriseId());
                paperTurns.setCreater(user.getId());
                paperTurns.setCreateTime(new Date());
                this.paperTurnsMapper.insert(paperTurns);
            }
            LambdaQueryWrapper wrapper2 = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper2.eq(TrainingPaperUserTurns::getProjectId, (Object)courseStageVo.getCourseId())).eq(TrainingPaperUserTurns::getStageId, (Object)courseStageVo.getId())).eq(TrainingPaperUserTurns::getUserId, (Object)user.getId())).eq(TrainingPaperUserTurns::getTurnType, (Object)4)).orderByDesc(TrainingPaperUserTurns::getTurns);
            List paperUserTurnList = this.paperUserTurnsMapper.selectList((Wrapper)wrapper2);
            if (!CollectionUtils.isEmpty((Collection)paperUserTurnList)) {
                paperUserTurns = (TrainingPaperUserTurns)paperUserTurnList.get(0);
                paperUserTurns.setTurns(newTurns);
                this.paperUserTurnsMapper.updateById(paperUserTurns);
                if (paperUserTurnList.size() > 1) {
                    for (int i = 1; i < paperUserTurnList.size(); ++i) {
                        this.paperUserTurnsMapper.deleteById(((TrainingPaperUserTurns)paperUserTurnList.get(i)).getId());
                    }
                }
            } else {
                paperUserTurns = new TrainingPaperUserTurns();
                paperUserTurns.setProjectId(courseStageVo.getCourseId());
                paperUserTurns.setStageId(courseStageVo.getId());
                paperUserTurns.setUserId(user.getId());
                paperUserTurns.setTurns(newTurns);
                paperUserTurns.setTurnType(Integer.valueOf(4));
                paperUserTurns.setEnterpriseId(course.getEnterpriseId());
                paperUserTurns.setCreater(user.getId());
                paperUserTurns.setCreateTime(new Date());
                this.paperUserTurnsMapper.insert(paperUserTurns);
            }
            LambdaQueryWrapper wrapper5 = new LambdaQueryWrapper();
            wrapper5.eq(TrainingCourseStageTask::getStageId, (Object)courseStageVo.getId());
            List trainingCourseStageTaskList = this.courseStageTaskMapper.selectList((Wrapper)wrapper5);
            List taskIds = trainingCourseStageTaskList.stream().map(TrainingCourseStageTask::getId).collect(Collectors.toList());
            LambdaUpdateWrapper wrapper3 = new LambdaUpdateWrapper();
            ((LambdaUpdateWrapper)wrapper3.eq(TrainingCourseUserTask::getUserId, (Object)user.getId())).in(TrainingCourseUserTask::getTaskId, taskIds);
            wrapper3.set(TrainingCourseUserTask::getIsLast, (Object)0);
            this.courseUserTaskMapper.update(null, (Wrapper)wrapper3);
        } else if (course.getIsRelearn() == 2) {
            LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)wrapper1.eq(TrainingCourseStageTask::getCourseId, (Object)courseStageVo.getCourseId())).eq(TrainingCourseStageTask::getTaskType, (Object)2);
            List stageTaskList = this.courseStageTaskMapper.selectList((Wrapper)wrapper1);
            for (TrainingCourseStageTask stageTask : stageTaskList) {
                List turnsList = (List)map.get(stageTask.getId());
                if (!CollectionUtils.isEmpty((Collection)turnsList) && (CollectionUtils.isEmpty((Collection)turnsList) || ((TrainingPaperTurns)turnsList.get(0)).getTurns() >= newTurns)) continue;
                Integer newPaperId = this.copyPaper(stageTask.getPaperId());
                TrainingPaperTurns paperTurns = new TrainingPaperTurns();
                paperTurns.setProjectId(stageTask.getCourseId());
                paperTurns.setTaskId(stageTask.getId());
                paperTurns.setPaperId(newPaperId);
                paperTurns.setTurns(newTurns);
                paperTurns.setTurnType(Integer.valueOf(4));
                paperTurns.setEnterpriseId(stageTask.getEnterpriseId());
                paperTurns.setCreater(user.getId());
                paperTurns.setCreateTime(new Date());
                this.paperTurnsMapper.insert(paperTurns);
            }
            LambdaQueryWrapper wrapper2 = new LambdaQueryWrapper();
            wrapper2.eq(TrainingCourseStage::getCourseId, (Object)courseStageVo.getCourseId());
            List stageList = this.courseStageMapper.selectList((Wrapper)wrapper2);
            for (TrainingCourseStage stage : stageList) {
                TrainingPaperUserTurns paperUserTurns;
                LambdaQueryWrapper wrapper3 = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper3.eq(TrainingPaperUserTurns::getProjectId, (Object)courseStageVo.getCourseId())).eq(TrainingPaperUserTurns::getStageId, (Object)stage.getId())).eq(TrainingPaperUserTurns::getUserId, (Object)user.getId())).eq(TrainingPaperUserTurns::getTurnType, (Object)4)).orderByDesc(TrainingPaperUserTurns::getTurns);
                List paperUserTurnList = this.paperUserTurnsMapper.selectList((Wrapper)wrapper3);
                if (!CollectionUtils.isEmpty((Collection)paperUserTurnList)) {
                    paperUserTurns = (TrainingPaperUserTurns)paperUserTurnList.get(0);
                    paperUserTurns.setTurns(newTurns);
                    this.paperUserTurnsMapper.updateById(paperUserTurns);
                    if (paperUserTurnList.size() <= 1) continue;
                    for (int i = 1; i < paperUserTurnList.size(); ++i) {
                        this.paperUserTurnsMapper.deleteById(((TrainingPaperUserTurns)paperUserTurnList.get(i)).getId());
                    }
                    continue;
                }
                paperUserTurns = new TrainingPaperUserTurns();
                paperUserTurns.setProjectId(stage.getCourseId());
                paperUserTurns.setStageId(stage.getId());
                paperUserTurns.setUserId(user.getId());
                paperUserTurns.setTurns(newTurns);
                paperUserTurns.setTurnType(Integer.valueOf(4));
                paperUserTurns.setEnterpriseId(stage.getEnterpriseId());
                paperUserTurns.setCreater(user.getId());
                paperUserTurns.setCreateTime(new Date());
                this.paperUserTurnsMapper.insert(paperUserTurns);
            }
            LambdaUpdateWrapper wrapper3 = new LambdaUpdateWrapper();
            ((LambdaUpdateWrapper)wrapper3.eq(TrainingCourseUserTask::getCourseId, (Object)courseStageVo.getCourseId())).eq(TrainingCourseUserTask::getUserId, (Object)user.getId());
            wrapper3.set(TrainingCourseUserTask::getIsLast, (Object)0);
            this.courseUserTaskMapper.update(null, (Wrapper)wrapper3);
        }
    }

    public Integer copyPaper(Integer paperId) {
        TrainingPaper paper = (TrainingPaper)this.trainingPaperMapper.selectById(paperId);
        paper.setId(null);
        paper.setPaperState(Integer.valueOf(2));
        paper.setProjectShow(Integer.valueOf(4));
        paper.setIsTraining(Integer.valueOf(1));
        paper.setCreateTime(new Date());
        this.trainingPaperMapper.insert(paper);
        LambdaQueryWrapper userWrapper1 = new LambdaQueryWrapper();
        userWrapper1.eq(TrainingExaminer::getTrainingPaperId, (Object)paperId);
        List userList1 = this.trainingExaminerMapper.selectList((Wrapper)userWrapper1);
        if (!CollectionUtils.isEmpty((Collection)userList1)) {
            ArrayList<TrainingExaminer> examList = new ArrayList<TrainingExaminer>();
            for (TrainingExaminer examiner : userList1) {
                TrainingExaminer exam = new TrainingExaminer();
                exam.setTrainingPaperId(paper.getId());
                exam.setUserId(examiner.getUserId());
                exam.setEnterpriseId(paper.getEnterpriseId());
                examList.add(exam);
            }
            this.trainingExaminerMapper.insertList(examList);
        }
        LambdaQueryWrapper paperUserWrapper = new LambdaQueryWrapper();
        paperUserWrapper.eq(TrainingPaperUser::getPaperId, (Object)paperId);
        List paperUserList = this.trainingPaperUserMapper.selectList((Wrapper)paperUserWrapper);
        if (!CollectionUtils.isEmpty((Collection)paperUserList)) {
            ArrayList<TrainingPaperUser> paperUsers = new ArrayList<TrainingPaperUser>();
            for (TrainingPaperUser paperUser : paperUserList) {
                paperUser.setId(null);
                paperUser.setEnterpriseId(paper.getEnterpriseId());
                paperUser.setPaperId(paper.getId());
                paperUsers.add(paperUser);
            }
            this.trainingPaperUserMapper.insertList(paperUsers);
        }
        return paper.getId();
    }

    @Override
    public void updateAppCourseRelearnNew(List<TrainingCourseStageVo> courseStageVoList, Users user) {
        TrainingCourseStageVo courseStageVo = courseStageVoList.get(0);
        TrainingCourse course = (TrainingCourse)this.courseMapper.selectById(courseStageVo.getCourseId());
        LambdaQueryWrapper wrapper0 = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper0.eq(TrainingPaperTurns::getProjectId, (Object)courseStageVo.getCourseId())).eq(TrainingPaperTurns::getTurnType, (Object)4)).orderByDesc(TrainingPaperTurns::getTurns);
        List paperTurnsList = this.paperTurnsMapper.selectList((Wrapper)wrapper0);
        Map<Object, Object> map = new HashMap();
        if (!CollectionUtils.isEmpty((Collection)paperTurnsList)) {
            map = paperTurnsList.stream().collect(Collectors.groupingBy(TrainingPaperTurns::getTaskId));
        }
        if (course.getIsRelearn() == 1) {
            for (TrainingCourseStageVo stageVo : courseStageVoList) {
                TrainingPaperUserTurns paperUserTurns;
                Integer newTurns = 2;
                LambdaQueryWrapper wrapper4 = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper4.eq(TrainingPaperUserTurns::getProjectId, (Object)stageVo.getCourseId())).eq(TrainingPaperUserTurns::getStageId, (Object)stageVo.getId())).eq(TrainingPaperUserTurns::getTurnType, (Object)4)).eq(TrainingPaperUserTurns::getUserId, (Object)user.getId())).orderByDesc(TrainingPaperUserTurns::getTurns);
                List paperUserTurnsList = this.paperUserTurnsMapper.selectList((Wrapper)wrapper4);
                if (!CollectionUtils.isEmpty((Collection)paperUserTurnsList)) {
                    newTurns = ((TrainingPaperUserTurns)paperUserTurnsList.get(0)).getTurns() + 1;
                }
                LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper1.eq(TrainingCourseStageTask::getCourseId, (Object)stageVo.getCourseId())).eq(TrainingCourseStageTask::getTaskType, (Object)2)).eq(TrainingCourseStageTask::getStageId, (Object)stageVo.getId());
                List stageTaskList = this.courseStageTaskMapper.selectList((Wrapper)wrapper1);
                for (TrainingCourseStageTask stageTask : stageTaskList) {
                    List turnsList = (List)map.get(stageTask.getId());
                    if (!CollectionUtils.isEmpty((Collection)turnsList) && (CollectionUtils.isEmpty((Collection)turnsList) || ((TrainingPaperTurns)turnsList.get(0)).getTurns() >= newTurns)) continue;
                    Integer newPaperId = this.copyPaper(stageTask.getPaperId());
                    TrainingPaperTurns paperTurns = new TrainingPaperTurns();
                    paperTurns.setProjectId(stageTask.getCourseId());
                    paperTurns.setTaskId(stageTask.getId());
                    paperTurns.setPaperId(newPaperId);
                    paperTurns.setTurns(newTurns);
                    paperTurns.setTurnType(Integer.valueOf(4));
                    paperTurns.setEnterpriseId(stageTask.getEnterpriseId());
                    paperTurns.setCreater(user.getId());
                    paperTurns.setCreateTime(new Date());
                    this.paperTurnsMapper.insert(paperTurns);
                }
                LambdaQueryWrapper wrapper2 = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper2.eq(TrainingPaperUserTurns::getProjectId, (Object)stageVo.getCourseId())).eq(TrainingPaperUserTurns::getStageId, (Object)stageVo.getId())).eq(TrainingPaperUserTurns::getUserId, (Object)user.getId())).eq(TrainingPaperUserTurns::getTurnType, (Object)4)).orderByDesc(TrainingPaperUserTurns::getTurns);
                List paperUserTurnList = this.paperUserTurnsMapper.selectList((Wrapper)wrapper2);
                if (!CollectionUtils.isEmpty((Collection)paperUserTurnList)) {
                    paperUserTurns = (TrainingPaperUserTurns)paperUserTurnList.get(0);
                    paperUserTurns.setTurns(newTurns);
                    this.paperUserTurnsMapper.updateById(paperUserTurns);
                    if (paperUserTurnList.size() <= 1) continue;
                    for (int i = 1; i < paperUserTurnList.size(); ++i) {
                        this.paperUserTurnsMapper.deleteById(((TrainingPaperUserTurns)paperUserTurnList.get(i)).getId());
                    }
                    continue;
                }
                paperUserTurns = new TrainingPaperUserTurns();
                paperUserTurns.setProjectId(stageVo.getCourseId());
                paperUserTurns.setStageId(stageVo.getId());
                paperUserTurns.setUserId(user.getId());
                paperUserTurns.setTurns(newTurns);
                paperUserTurns.setTurnType(Integer.valueOf(4));
                paperUserTurns.setEnterpriseId(course.getEnterpriseId());
                paperUserTurns.setCreater(user.getId());
                paperUserTurns.setCreateTime(new Date());
                this.paperUserTurnsMapper.insert(paperUserTurns);
            }
            List trainingCourseStageId = courseStageVoList.stream().map(TrainingCourseStage::getId).collect(Collectors.toList());
            LambdaQueryWrapper wrapper4 = new LambdaQueryWrapper();
            wrapper4.in(TrainingCourseStageTask::getStageId, trainingCourseStageId);
            List trainingCourseStageTaskList = this.courseStageTaskMapper.selectList((Wrapper)wrapper4);
            List taskIds = trainingCourseStageTaskList.stream().map(TrainingCourseStageTask::getId).collect(Collectors.toList());
            LambdaUpdateWrapper wrapper3 = new LambdaUpdateWrapper();
            ((LambdaUpdateWrapper)wrapper3.eq(TrainingCourseUserTask::getUserId, (Object)user.getId())).in(TrainingCourseUserTask::getTaskId, taskIds);
            wrapper3.set(TrainingCourseUserTask::getIsLast, (Object)0);
            this.courseUserTaskMapper.update(null, (Wrapper)wrapper3);
        } else if (course.getIsRelearn() == 2) {
            Integer newTurns = 2;
            LambdaQueryWrapper wrapper4 = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper4.eq(TrainingPaperUserTurns::getProjectId, (Object)courseStageVo.getCourseId())).eq(TrainingPaperUserTurns::getStageId, (Object)courseStageVo.getId())).eq(TrainingPaperUserTurns::getTurnType, (Object)4)).eq(TrainingPaperUserTurns::getUserId, (Object)user.getId())).orderByDesc(TrainingPaperUserTurns::getTurns);
            List paperUserTurnsList = this.paperUserTurnsMapper.selectList((Wrapper)wrapper4);
            if (!CollectionUtils.isEmpty((Collection)paperUserTurnsList)) {
                newTurns = ((TrainingPaperUserTurns)paperUserTurnsList.get(0)).getTurns() + 1;
            }
            LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)wrapper1.eq(TrainingCourseStageTask::getCourseId, (Object)courseStageVo.getCourseId())).eq(TrainingCourseStageTask::getTaskType, (Object)2);
            List stageTaskList = this.courseStageTaskMapper.selectList((Wrapper)wrapper1);
            for (TrainingCourseStageTask stageTask : stageTaskList) {
                List turnsList = (List)map.get(stageTask.getId());
                if (!CollectionUtils.isEmpty((Collection)turnsList) && (CollectionUtils.isEmpty((Collection)turnsList) || ((TrainingPaperTurns)turnsList.get(0)).getTurns() >= newTurns)) continue;
                Integer newPaperId = this.copyPaper(stageTask.getPaperId());
                TrainingPaperTurns paperTurns = new TrainingPaperTurns();
                paperTurns.setProjectId(stageTask.getCourseId());
                paperTurns.setTaskId(stageTask.getId());
                paperTurns.setPaperId(newPaperId);
                paperTurns.setTurns(newTurns);
                paperTurns.setTurnType(Integer.valueOf(4));
                paperTurns.setEnterpriseId(stageTask.getEnterpriseId());
                paperTurns.setCreater(user.getId());
                paperTurns.setCreateTime(new Date());
                this.paperTurnsMapper.insert(paperTurns);
            }
            LambdaQueryWrapper wrapper2 = new LambdaQueryWrapper();
            wrapper2.eq(TrainingCourseStage::getCourseId, (Object)courseStageVo.getCourseId());
            List stageList = this.courseStageMapper.selectList((Wrapper)wrapper2);
            for (TrainingCourseStage stage : stageList) {
                TrainingPaperUserTurns paperUserTurns;
                LambdaQueryWrapper wrapper3 = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper3.eq(TrainingPaperUserTurns::getProjectId, (Object)courseStageVo.getCourseId())).eq(TrainingPaperUserTurns::getStageId, (Object)stage.getId())).eq(TrainingPaperUserTurns::getUserId, (Object)user.getId())).eq(TrainingPaperUserTurns::getTurnType, (Object)4)).orderByDesc(TrainingPaperUserTurns::getTurns);
                List paperUserTurnList = this.paperUserTurnsMapper.selectList((Wrapper)wrapper3);
                if (!CollectionUtils.isEmpty((Collection)paperUserTurnList)) {
                    paperUserTurns = (TrainingPaperUserTurns)paperUserTurnList.get(0);
                    paperUserTurns.setTurns(newTurns);
                    this.paperUserTurnsMapper.updateById(paperUserTurns);
                    if (paperUserTurnList.size() <= 1) continue;
                    for (int i = 1; i < paperUserTurnList.size(); ++i) {
                        this.paperUserTurnsMapper.deleteById(((TrainingPaperUserTurns)paperUserTurnList.get(i)).getId());
                    }
                    continue;
                }
                paperUserTurns = new TrainingPaperUserTurns();
                paperUserTurns.setProjectId(stage.getCourseId());
                paperUserTurns.setStageId(stage.getId());
                paperUserTurns.setUserId(user.getId());
                paperUserTurns.setTurns(newTurns);
                paperUserTurns.setTurnType(Integer.valueOf(4));
                paperUserTurns.setEnterpriseId(stage.getEnterpriseId());
                paperUserTurns.setCreater(user.getId());
                paperUserTurns.setCreateTime(new Date());
                this.paperUserTurnsMapper.insert(paperUserTurns);
            }
            LambdaUpdateWrapper wrapper3 = new LambdaUpdateWrapper();
            ((LambdaUpdateWrapper)wrapper3.eq(TrainingCourseUserTask::getCourseId, (Object)courseStageVo.getCourseId())).eq(TrainingCourseUserTask::getUserId, (Object)user.getId());
            wrapper3.set(TrainingCourseUserTask::getIsLast, (Object)0);
            this.courseUserTaskMapper.update(null, (Wrapper)wrapper3);
        }
    }

    @Override
    public Page<TrainingCourseVo> selectAppTrainingHistory(Page<TrainingCourseVo> page, Integer taskType, Integer taskStatus, Users user) {
        List taskList;
        LambdaQueryWrapper wrapper1;
        LambdaQueryWrapper courseWrapper;
        if (taskStatus == null) {
            taskStatus = 3;
        }
        List<Integer> courseIds = new ArrayList<Integer>();
        Map<Object, Object> userTaskMap = new HashMap();
        Map<Object, Object> stageTaskMap = new HashMap();
        List<Object> baseCourseIds = new ArrayList();
        if (taskStatus == 1 || taskStatus == 2 || taskStatus == 4) {
            BaseResult tagResult;
            List<Integer> roleList;
            if (user.getGroupId() != null) {
                courseWrapper = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)courseWrapper.eq(TrainingCourse::getAppointType, (Object)0)).eq(user.getGroupId() != null, TrainingCourse::getEnterpriseId, (Object)user.getGroupId());
                List courses1 = this.courseMapper.selectList((Wrapper)courseWrapper);
                if (!CollectionUtils.isEmpty((Collection)courses1)) {
                    List base1 = courses1.stream().map(TrainingCourse::getId).distinct().collect(Collectors.toList());
                    baseCourseIds.addAll(base1);
                }
            }
            if (!CollectionUtils.isEmpty(roleList = this.userUtilService.selectUserRoleList(user))) {
                LambdaQueryWrapper courseWrapper1 = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)((LambdaQueryWrapper)courseWrapper1.eq(TrainingCourseUser::getCourseType, (Object)1)).in(TrainingCourseUser::getRoleId, roleList)).eq(user.getGroupId() != null, TrainingCourseUser::getEnterpriseId, (Object)user.getGroupId());
                List courses1 = this.courseUserMapper.selectList((Wrapper)courseWrapper1);
                if (!CollectionUtils.isEmpty((Collection)courses1)) {
                    List base1 = courses1.stream().map(TrainingCourseUser::getCourseId).distinct().collect(Collectors.toList());
                    baseCourseIds.addAll(base1);
                }
            }
            if (!(tagResult = this.tagApi.getUsersTagByUserId(user.getId())).getIsError().booleanValue() && !CollectionUtils.isEmpty((Collection)((Collection)tagResult.getData()))) {
                LambdaQueryWrapper courseWrapper1 = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)((LambdaQueryWrapper)courseWrapper1.eq(TrainingCourseUser::getCourseType, (Object)1)).in(TrainingCourseUser::getTagId, (Collection)((List)tagResult.getData()).stream().map(UserTagMo::getId).distinct().collect(Collectors.toList()))).eq(user.getGroupId() != null, TrainingCourseUser::getEnterpriseId, (Object)user.getGroupId());
                List courses1 = this.courseUserMapper.selectList((Wrapper)courseWrapper1);
                if (!CollectionUtils.isEmpty((Collection)courses1)) {
                    List base1 = courses1.stream().map(TrainingCourseUser::getCourseId).distinct().collect(Collectors.toList());
                    baseCourseIds.addAll(base1);
                }
            }
            ArrayList<String> orgIds = new ArrayList<String>();
            UsersAndOrgsMo mo = new UsersAndOrgsMo();
            mo.setGroupId(user.getGroupId());
            mo.setUserId(user.getId());
            mo.setRetainAll(Boolean.valueOf(false));
            mo.setShowAllPath(Boolean.valueOf(true));
            BaseResult orgResult = this.userOrganizeApi.getUserOrganizeByUserIdAndOrg(mo);
            if (!orgResult.getIsError().booleanValue() && !CollectionUtils.isEmpty((Map)((Map)orgResult.getData()))) {
                List list;
                Map map = (Map)orgResult.getData();
                if (!CollectionUtils.isEmpty((Collection)((Collection)map.get("O_")))) {
                    list = (List)map.get("O_");
                    for (Integer id : list) {
                        orgIds.add("O_" + id);
                    }
                }
                if (!CollectionUtils.isEmpty((Collection)((Collection)map.get("S_")))) {
                    list = (List)map.get("S_");
                    for (Integer id : list) {
                        orgIds.add("S_" + id);
                    }
                }
            }
            if (!CollectionUtils.isEmpty(orgIds)) {
                LambdaQueryWrapper courseWrapper1 = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)((LambdaQueryWrapper)courseWrapper1.eq(TrainingCourseUser::getCourseType, (Object)1)).in(TrainingCourseUser::getOrganizeId, orgIds)).eq(user.getGroupId() != null, TrainingCourseUser::getEnterpriseId, (Object)user.getGroupId());
                List courses1 = this.courseUserMapper.selectList((Wrapper)courseWrapper1);
                if (!CollectionUtils.isEmpty((Collection)courses1)) {
                    List base1 = courses1.stream().map(TrainingCourseUser::getCourseId).distinct().collect(Collectors.toList());
                    baseCourseIds.addAll(base1);
                }
            }
            LambdaQueryWrapper courseWrapper2 = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)courseWrapper2.eq(TrainingCourseUser::getCourseType, (Object)1)).eq(TrainingCourseUser::getUserId, (Object)user.getId());
            List courses2 = this.courseUserMapper.selectList((Wrapper)courseWrapper2);
            if (!CollectionUtils.isEmpty((Collection)courses2)) {
                List base2 = courses2.stream().map(TrainingCourseUser::getCourseId).distinct().collect(Collectors.toList());
                baseCourseIds.addAll(base2);
            }
            if (!CollectionUtils.isEmpty(baseCourseIds)) {
                LambdaQueryWrapper wrapper5 = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)wrapper5.eq(!org.springframework.util.StringUtils.isEmpty((Object)user.getGroupId()), TrainingCourseStageTask::getEnterpriseId, (Object)user.getGroupId())).in(TrainingCourseStageTask::getCourseId, baseCourseIds);
                List courseStageTaskList = this.courseStageTaskMapper.selectList((Wrapper)wrapper5);
                stageTaskMap = courseStageTaskList.stream().collect(Collectors.groupingBy(TrainingCourseStageTask::getCourseId));
            }
        }
        if (taskStatus == 1) {
            if (!CollectionUtils.isEmpty(baseCourseIds)) {
                baseCourseIds = baseCourseIds.stream().distinct().collect(Collectors.toList());
                courseWrapper = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)((LambdaQueryWrapper)courseWrapper.eq(TrainingCourse::getStatus, (Object)1)).in(TrainingCourse::getId, baseCourseIds)).eq(user.getGroupId() != null, TrainingCourse::getEnterpriseId, (Object)user.getGroupId());
                List courses3 = this.courseMapper.selectList((Wrapper)courseWrapper);
                if (!CollectionUtils.isEmpty((Collection)courses3)) {
                    courseIds = courses3.stream().map(TrainingCourse::getId).distinct().collect(Collectors.toList());
                }
            }
        } else if (taskStatus == 2) {
            wrapper1 = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)wrapper1.eq(TrainingCourse::getStatus, (Object)2)).eq(user.getGroupId() != null, TrainingCourse::getEnterpriseId, (Object)user.getGroupId());
            List courseList1 = this.courseMapper.selectList((Wrapper)wrapper1);
            if (!CollectionUtils.isEmpty((Collection)courseList1)) {
                List courseIds1 = courseList1.stream().map(TrainingCourse::getId).collect(Collectors.toList());
                courseIds.addAll(courseIds1);
            }
            LambdaQueryWrapper wrapper2 = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper2.eq(TrainingCourse::getStatus, (Object)3)).eq(TrainingCourse::getIsOverdue, (Object)1)).eq(user.getGroupId() != null, TrainingCourse::getEnterpriseId, (Object)user.getGroupId());
            List courseList2 = this.courseMapper.selectList((Wrapper)wrapper2);
            if (!CollectionUtils.isEmpty((Collection)courseList2)) {
                List courseIds2 = courseList2.stream().map(TrainingCourse::getId).collect(Collectors.toList());
                courseIds.addAll(courseIds2);
            }
            if (!CollectionUtils.isEmpty(courseIds)) {
                courseIds.retainAll(baseCourseIds);
                if (!CollectionUtils.isEmpty(courseIds)) {
                    LambdaQueryWrapper wrapper3 = new LambdaQueryWrapper();
                    ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper3.eq(TrainingCourseUserTask::getUserId, (Object)user.getId())).in(TrainingCourseUserTask::getTaskStatus, Arrays.asList(3, 4))).isNotNull(TrainingCourseUserTask::getCourseId);
                    List userTaskList = this.courseUserTaskMapper.selectList((Wrapper)wrapper3);
                    if (!CollectionUtils.isEmpty((Collection)userTaskList)) {
                        List courseIdsList = userTaskList.stream().map(TrainingCourseUserTask::getCourseId).distinct().collect(Collectors.toList());
                        LambdaQueryWrapper wrapperU = new LambdaQueryWrapper();
                        ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapperU.eq(TrainingPaperUserTurns::getUserId, (Object)user.getId())).eq(TrainingPaperUserTurns::getTurnType, (Object)4)).orderByDesc(TrainingPaperUserTurns::getTurns);
                        List paperUserTurns = this.paperUserTurnsMapper.selectList((Wrapper)wrapperU);
                        Map<Object, Object> turnMap = new HashMap();
                        if (!CollectionUtils.isEmpty((Collection)paperUserTurns)) {
                            turnMap = paperUserTurns.stream().collect(Collectors.groupingBy(TrainingPaperUserTurns::getStageId));
                        }
                        LambdaQueryWrapper wrapper4 = new LambdaQueryWrapper();
                        wrapper4.in(TrainingCourseStageTask::getCourseId, courseIdsList);
                        List courseStageTasks = this.courseStageTaskMapper.selectList((Wrapper)wrapper4);
                        Map taskMap = courseStageTasks.stream().collect(Collectors.toMap(TrainingCourseStageTask::getId, Function.identity()));
                        ArrayList<Object> delList = new ArrayList<Object>();
                        for (Object courseUserTask : userTaskList) {
                            TrainingCourseStageTask task = (TrainingCourseStageTask)taskMap.get(courseUserTask.getTaskId());
                            List userTurnsList = (List)turnMap.get(task.getStageId());
                            if (CollectionUtils.isEmpty((Collection)userTurnsList) || ((TrainingPaperUserTurns)userTurnsList.get(0)).getTurns().intValue() == courseUserTask.getTurns().intValue()) continue;
                            delList.add(courseUserTask);
                        }
                        if (!CollectionUtils.isEmpty(delList)) {
                            userTaskList.removeAll(delList);
                        }
                        if (!CollectionUtils.isEmpty((Collection)userTaskList)) {
                            List courseIdList = userTaskList.stream().map(TrainingCourseUserTask::getCourseId).distinct().collect(Collectors.toList());
                            userTaskMap = userTaskList.stream().collect(Collectors.groupingBy(TrainingCourseUserTask::getCourseId));
                            for (Integer courseId : courseIdList) {
                                List taskList2 = (List)userTaskMap.get(courseId);
                                List stageTaskList = (List)stageTaskMap.get(courseId);
                                if (CollectionUtils.isEmpty((Collection)stageTaskList)) {
                                    courseIds.remove(courseId);
                                    continue;
                                }
                                if (CollectionUtils.isEmpty((Collection)taskList2) || taskList2.size() < stageTaskList.size()) continue;
                                courseIds.remove(courseId);
                            }
                        }
                    }
                }
            }
        } else if (taskStatus == 3) {
            wrapper1 = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper1.eq(TrainingCourseUserTask::getUserId, (Object)user.getId())).in(TrainingCourseUserTask::getTaskStatus, Arrays.asList(3, 4))).isNotNull(TrainingCourseUserTask::getCourseId);
            List userTaskList = this.courseUserTaskMapper.selectList((Wrapper)wrapper1);
            if (!CollectionUtils.isEmpty((Collection)userTaskList)) {
                LambdaQueryWrapper wrapperU = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapperU.eq(TrainingPaperUserTurns::getUserId, (Object)user.getId())).eq(TrainingPaperUserTurns::getTurnType, (Object)4)).orderByDesc(TrainingPaperUserTurns::getTurns);
                List paperUserTurns = this.paperUserTurnsMapper.selectList((Wrapper)wrapperU);
                Map<Object, Object> turnMap = new HashMap();
                if (!CollectionUtils.isEmpty((Collection)paperUserTurns)) {
                    turnMap = paperUserTurns.stream().collect(Collectors.groupingBy(TrainingPaperUserTurns::getStageId));
                }
                List courseIdsList = userTaskList.stream().map(TrainingCourseUserTask::getCourseId).distinct().collect(Collectors.toList());
                LambdaQueryWrapper wrapper3 = new LambdaQueryWrapper();
                wrapper3.in(TrainingCourseStageTask::getCourseId, courseIdsList);
                List courseStageTasks = this.courseStageTaskMapper.selectList((Wrapper)wrapper3);
                Map taskMap = courseStageTasks.stream().collect(Collectors.toMap(TrainingCourseStageTask::getId, Function.identity()));
                ArrayList<TrainingCourseUserTask> delList = new ArrayList<TrainingCourseUserTask>();
                for (TrainingCourseUserTask courseUserTask : userTaskList) {
                    TrainingCourseStageTask task = (TrainingCourseStageTask)taskMap.get(courseUserTask.getTaskId());
                    List userTurnsList = (List)turnMap.get(task.getStageId());
                    if (CollectionUtils.isEmpty((Collection)userTurnsList) || ((TrainingPaperUserTurns)userTurnsList.get(0)).getTurns().intValue() == courseUserTask.getTurns().intValue()) continue;
                    delList.add(courseUserTask);
                }
                if (!CollectionUtils.isEmpty(delList)) {
                    userTaskList.removeAll(delList);
                }
                List courseIdList = userTaskList.stream().map(TrainingCourseUserTask::getCourseId).distinct().collect(Collectors.toList());
                userTaskMap = userTaskList.stream().collect(Collectors.groupingBy(TrainingCourseUserTask::getCourseId));
                LambdaQueryWrapper wrapper2 = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)wrapper2.eq(!org.springframework.util.StringUtils.isEmpty((Object)user.getGroupId()), TrainingCourseStageTask::getEnterpriseId, (Object)user.getGroupId())).in(TrainingCourseStageTask::getCourseId, courseIdList);
                List courseStageTaskList = this.courseStageTaskMapper.selectList((Wrapper)wrapper2);
                stageTaskMap = courseStageTaskList.stream().collect(Collectors.groupingBy(TrainingCourseStageTask::getCourseId));
                for (Integer courseId : courseIdList) {
                    taskList = (List)userTaskMap.get(courseId);
                    if (CollectionUtils.isEmpty((Collection)taskList) || taskList.size() < ((List)stageTaskMap.get(courseId)).size()) continue;
                    courseIds.add(courseId);
                }
            }
        } else if (taskStatus == 4) {
            LambdaQueryWrapper wrapper2 = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper2.eq(TrainingCourse::getStatus, (Object)3)).eq(TrainingCourse::getIsOverdue, (Object)0)).eq(user.getGroupId() != null, TrainingCourse::getEnterpriseId, (Object)user.getGroupId());
            List courseList2 = this.courseMapper.selectList((Wrapper)wrapper2);
            if (!CollectionUtils.isEmpty((Collection)courseList2)) {
                List courseIds2 = courseList2.stream().map(TrainingCourse::getId).collect(Collectors.toList());
                courseIds.addAll(courseIds2);
            }
            if (!CollectionUtils.isEmpty(courseIds)) {
                courseIds.retainAll(baseCourseIds);
                if (!CollectionUtils.isEmpty(courseIds)) {
                    LambdaQueryWrapper wrapper3 = new LambdaQueryWrapper();
                    ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper3.eq(TrainingCourseUserTask::getUserId, (Object)user.getId())).in(TrainingCourseUserTask::getTaskStatus, Arrays.asList(3, 4))).isNotNull(TrainingCourseUserTask::getCourseId);
                    List userTaskList = this.courseUserTaskMapper.selectList((Wrapper)wrapper3);
                    if (!CollectionUtils.isEmpty((Collection)userTaskList)) {
                        List courseIdsList = userTaskList.stream().map(TrainingCourseUserTask::getCourseId).distinct().collect(Collectors.toList());
                        LambdaQueryWrapper wrapperU = new LambdaQueryWrapper();
                        ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapperU.eq(TrainingPaperUserTurns::getUserId, (Object)user.getId())).eq(TrainingPaperUserTurns::getTurnType, (Object)4)).orderByDesc(TrainingPaperUserTurns::getTurns);
                        List paperUserTurns = this.paperUserTurnsMapper.selectList((Wrapper)wrapperU);
                        Map<Object, Object> turnMap = new HashMap();
                        if (!CollectionUtils.isEmpty((Collection)paperUserTurns)) {
                            turnMap = paperUserTurns.stream().collect(Collectors.groupingBy(TrainingPaperUserTurns::getStageId));
                        }
                        LambdaQueryWrapper wrapper4 = new LambdaQueryWrapper();
                        wrapper4.in(TrainingCourseStageTask::getCourseId, courseIdsList);
                        List courseStageTasks = this.courseStageTaskMapper.selectList((Wrapper)wrapper4);
                        Map taskMap = courseStageTasks.stream().collect(Collectors.toMap(TrainingCourseStageTask::getId, Function.identity()));
                        ArrayList<TrainingCourseUserTask> delList = new ArrayList<TrainingCourseUserTask>();
                        for (TrainingCourseUserTask courseUserTask : userTaskList) {
                            TrainingCourseStageTask task = (TrainingCourseStageTask)taskMap.get(courseUserTask.getTaskId());
                            List userTurnsList = (List)turnMap.get(task.getStageId());
                            if (CollectionUtils.isEmpty((Collection)userTurnsList) || ((TrainingPaperUserTurns)userTurnsList.get(0)).getTurns().intValue() == courseUserTask.getTurns().intValue()) continue;
                            delList.add(courseUserTask);
                        }
                        if (!CollectionUtils.isEmpty(delList)) {
                            userTaskList.removeAll(delList);
                        }
                        if (!CollectionUtils.isEmpty((Collection)userTaskList)) {
                            List courseIdList = userTaskList.stream().map(TrainingCourseUserTask::getCourseId).distinct().collect(Collectors.toList());
                            userTaskMap = userTaskList.stream().collect(Collectors.groupingBy(TrainingCourseUserTask::getCourseId));
                            for (Integer courseId : courseIdList) {
                                taskList = (List)userTaskMap.get(courseId);
                                List stageTaskList = (List)stageTaskMap.get(courseId);
                                if (CollectionUtils.isEmpty((Collection)stageTaskList)) {
                                    courseIds.remove(courseId);
                                    continue;
                                }
                                if (CollectionUtils.isEmpty((Collection)taskList) || taskList.size() < stageTaskList.size()) continue;
                                courseIds.remove(courseId);
                            }
                        }
                    }
                }
            }
        }
        List<Object> taskVoList = new ArrayList();
        if (!CollectionUtils.isEmpty(courseIds)) {
            taskVoList = this.courseStageTaskMapper.selectCourseHistoryByPage(page, user.getId(), user.getGroupId(), courseIds, user.getCreateTime());
        }
        if (!CollectionUtils.isEmpty(taskVoList)) {
            Iterator iterator = taskVoList.iterator();
            while (iterator.hasNext()) {
                TrainingCourseVo vo;
                List stageTaskList = (List)stageTaskMap.get((vo = (TrainingCourseVo)iterator.next()).getId());
                vo.setTaskNum(Integer.valueOf(CollectionUtils.isEmpty((Collection)stageTaskList) ? 0 : stageTaskList.size()));
                List userTasksList = (List)userTaskMap.get(vo.getId());
                vo.setFinishTaskNum(Integer.valueOf(CollectionUtils.isEmpty((Collection)userTasksList) ? 0 : userTasksList.size()));
                if (org.springframework.util.StringUtils.isEmpty((Object)vo.getStatus()) || vo.getStatus() != 3 || taskStatus != 2) continue;
                vo.setTaskStatus(Integer.valueOf(2));
            }
        }
        page.setContent(taskVoList);
        return page;
    }

    @Override
    public void saveCourseTaskStart(Integer id, Integer taskType, Integer userId, Integer taskId, Integer turns) {
        TrainingCourseStageTask trainingCourseStageTask;
        Date now = new Date();
        ArrayList<TrainingCourseUserTask> saveTaskList = new ArrayList<TrainingCourseUserTask>();
        if (turns == null) {
            turns = 1;
        }
        if (taskType == 1) {
            TrainingCourseStageTask task;
            LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper1.eq(TrainingCourseStageTask::getTaskType, (Object)1)).eq(TrainingCourseStageTask::getTrainingId, (Object)id)).eq(TrainingCourseStageTask::getIsProgress, (Object)1)).ne(taskId != null, TrainingCourseStageTask::getId, (Object)taskId)).isNotNull(TrainingCourseStageTask::getCourseId);
            List stageTaskList = this.courseStageTaskMapper.selectList((Wrapper)wrapper1);
            if (taskId != null && !ObjectUtils.isEmpty((Object)(task = (TrainingCourseStageTask)this.courseStageTaskMapper.selectById(taskId)))) {
                stageTaskList.add(task);
            }
            if (!CollectionUtils.isEmpty((Collection)stageTaskList)) {
                List stageTaskIds = stageTaskList.stream().map(TrainingCourseStageTask::getId).distinct().collect(Collectors.toList());
                LambdaQueryWrapper wrapper2 = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper2.eq(TrainingCourseUserTask::getUserId, (Object)userId)).in(TrainingCourseUserTask::getTaskId, stageTaskIds)).eq(TrainingCourseUserTask::getTurns, (Object)turns);
                List userTaskList = this.courseUserTaskMapper.selectList((Wrapper)wrapper2);
                Map<Object, Object> map = new HashMap();
                if (!CollectionUtils.isEmpty((Collection)userTaskList)) {
                    map = userTaskList.stream().collect(Collectors.groupingBy(TrainingCourseUserTask::getTaskId));
                }
                for (TrainingCourseStageTask stageTask : stageTaskList) {
                    List userTasks = (List)map.get(stageTask.getId());
                    if (!CollectionUtils.isEmpty((Collection)userTasks)) continue;
                    TrainingCourseUserTask userTask = new TrainingCourseUserTask();
                    userTask.setCourseId(stageTask.getCourseId());
                    userTask.setTaskId(stageTask.getId());
                    userTask.setUserId(userId);
                    userTask.setTurns(turns);
                    userTask.setStartTime(now);
                    userTask.setTaskStatus(Integer.valueOf(2));
                    userTask.setEnterpriseId(stageTask.getEnterpriseId());
                    userTask.setCreater(userId);
                    userTask.setCreateTime(now);
                    saveTaskList.add(userTask);
                }
            }
        } else if (taskType == 2) {
            TrainingUserPaper userPaper = (TrainingUserPaper)this.trainingUserPaperMapper.selectById(id);
            if (!(org.springframework.util.StringUtils.isEmpty((Object)userPaper) || org.springframework.util.StringUtils.isEmpty((Object)userPaper.getTrainingPaperId()) || org.springframework.util.StringUtils.isEmpty((Object)userPaper.getUserId()))) {
                Integer paperId = userPaper.getTrainingPaperId();
                userId = userPaper.getUserId();
                LambdaQueryWrapper wrapper0 = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper0.eq(TrainingPaperTurns::getPaperId, (Object)paperId)).eq(TrainingPaperTurns::getTurnType, (Object)4)).orderByDesc(TrainingPaperTurns::getTurns);
                List paperTurnsList = this.paperTurnsMapper.selectList((Wrapper)wrapper0);
                if (!CollectionUtils.isEmpty((Collection)paperTurnsList)) {
                    for (TrainingPaperTurns paperTurns : paperTurnsList) {
                        LambdaQueryWrapper wrapper2 = new LambdaQueryWrapper();
                        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper2.eq(TrainingCourseUserTask::getUserId, (Object)userId)).eq(TrainingCourseUserTask::getCourseId, (Object)paperTurns.getProjectId())).eq(TrainingCourseUserTask::getTaskId, (Object)paperTurns.getTaskId())).eq(TrainingCourseUserTask::getTurns, (Object)paperTurns.getTurns());
                        List userTaskList = this.courseUserTaskMapper.selectList((Wrapper)wrapper2);
                        if (CollectionUtils.isEmpty((Collection)userTaskList)) {
                            TrainingCourseUserTask userTask = new TrainingCourseUserTask();
                            userTask.setCourseId(paperTurns.getProjectId());
                            userTask.setTaskId(paperTurns.getTaskId());
                            userTask.setUserId(userId);
                            userTask.setTurns(paperTurns.getTurns());
                            userTask.setStartTime(now);
                            userTask.setTaskStatus(Integer.valueOf(2));
                            userTask.setEnterpriseId(paperTurns.getEnterpriseId());
                            userTask.setCreater(userId);
                            userTask.setCreateTime(now);
                            saveTaskList.add(userTask);
                            continue;
                        }
                        for (TrainingCourseUserTask courseUserTask : userTaskList) {
                            if (!org.springframework.util.StringUtils.isEmpty((Object)courseUserTask.getStartTime())) continue;
                            courseUserTask.setStartTime(new Date());
                            courseUserTask.setTaskStatus(Integer.valueOf(2));
                            this.courseUserTaskMapper.updateById(courseUserTask);
                        }
                    }
                } else {
                    LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
                    ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper1.eq(TrainingCourseStageTask::getTaskType, (Object)2)).eq(TrainingCourseStageTask::getPaperId, (Object)paperId)).isNotNull(TrainingCourseStageTask::getCourseId);
                    List stageTaskList = this.courseStageTaskMapper.selectList((Wrapper)wrapper1);
                    if (!CollectionUtils.isEmpty((Collection)stageTaskList) && !org.springframework.util.StringUtils.isEmpty((Object)userId)) {
                        List stageTaskIds = stageTaskList.stream().map(TrainingCourseStageTask::getId).collect(Collectors.toList());
                        LambdaQueryWrapper wrapper2 = new LambdaQueryWrapper();
                        ((LambdaQueryWrapper)wrapper2.eq(TrainingCourseUserTask::getUserId, (Object)userId)).in(TrainingCourseUserTask::getTaskId, stageTaskIds);
                        List userTaskList = this.courseUserTaskMapper.selectList((Wrapper)wrapper2);
                        Map<Object, Object> map = new HashMap();
                        if (!CollectionUtils.isEmpty((Collection)userTaskList)) {
                            map = userTaskList.stream().collect(Collectors.groupingBy(TrainingCourseUserTask::getTaskId));
                        }
                        for (TrainingCourseStageTask stageTask : stageTaskList) {
                            List userTasks = (List)map.get(stageTask.getId());
                            if (CollectionUtils.isEmpty((Collection)userTasks)) {
                                TrainingCourseUserTask userTask = new TrainingCourseUserTask();
                                userTask.setCourseId(stageTask.getCourseId());
                                userTask.setTaskId(stageTask.getId());
                                userTask.setUserId(userId);
                                userTask.setTurns(turns);
                                userTask.setStartTime(now);
                                userTask.setTaskStatus(Integer.valueOf(2));
                                userTask.setEnterpriseId(stageTask.getEnterpriseId());
                                userTask.setCreater(userId);
                                userTask.setCreateTime(now);
                                saveTaskList.add(userTask);
                                continue;
                            }
                            for (TrainingCourseUserTask courseUserTask : userTaskList) {
                                if (!org.springframework.util.StringUtils.isEmpty((Object)courseUserTask.getStartTime())) continue;
                                courseUserTask.setStartTime(new Date());
                                courseUserTask.setTaskStatus(Integer.valueOf(2));
                                this.courseUserTaskMapper.updateById(courseUserTask);
                            }
                        }
                    }
                }
            }
        } else if (taskType == 5) {
            TrainingCourseStageTask task;
            LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper1.eq(TrainingCourseStageTask::getTaskType, (Object)5)).eq(TrainingCourseStageTask::getMaterialId, (Object)id)).eq(TrainingCourseStageTask::getIsProgress, (Object)1)).ne(taskId != null, TrainingCourseStageTask::getId, (Object)taskId)).isNotNull(TrainingCourseStageTask::getCourseId);
            List stageTaskList = this.courseStageTaskMapper.selectList((Wrapper)wrapper1);
            if (taskId != null && !ObjectUtils.isEmpty((Object)(task = (TrainingCourseStageTask)this.courseStageTaskMapper.selectById(taskId)))) {
                stageTaskList.add(task);
            }
            if (!CollectionUtils.isEmpty((Collection)stageTaskList) && !org.springframework.util.StringUtils.isEmpty((Object)userId)) {
                List stageTaskIds = stageTaskList.stream().map(TrainingCourseStageTask::getId).distinct().collect(Collectors.toList());
                LambdaQueryWrapper wrapper2 = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper2.eq(TrainingCourseUserTask::getUserId, (Object)userId)).in(TrainingCourseUserTask::getTaskId, stageTaskIds)).eq(TrainingCourseUserTask::getTurns, (Object)turns);
                List userTaskList = this.courseUserTaskMapper.selectList((Wrapper)wrapper2);
                Map<Object, Object> map = new HashMap();
                if (!CollectionUtils.isEmpty((Collection)userTaskList)) {
                    map = userTaskList.stream().collect(Collectors.groupingBy(TrainingCourseUserTask::getTaskId));
                }
                for (TrainingCourseStageTask stageTask : stageTaskList) {
                    List userTasks = (List)map.get(stageTask.getId());
                    if (!CollectionUtils.isEmpty((Collection)userTasks)) continue;
                    TrainingCourseUserTask userTask = new TrainingCourseUserTask();
                    userTask.setCourseId(stageTask.getCourseId());
                    userTask.setTaskId(stageTask.getId());
                    userTask.setUserId(userId);
                    userTask.setTurns(turns);
                    userTask.setStartTime(now);
                    userTask.setTaskStatus(Integer.valueOf(2));
                    userTask.setEnterpriseId(stageTask.getEnterpriseId());
                    userTask.setCreater(userId);
                    userTask.setCreateTime(now);
                    saveTaskList.add(userTask);
                }
            }
        } else if (taskType == 6 && taskId != null && !ObjectUtils.isEmpty((Object)(trainingCourseStageTask = (TrainingCourseStageTask)this.courseStageTaskMapper.selectById(taskId))) && !org.springframework.util.StringUtils.isEmpty((Object)userId)) {
            LambdaQueryWrapper wrapper2 = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper2.eq(TrainingCourseUserTask::getUserId, (Object)userId)).eq(TrainingCourseUserTask::getTaskId, (Object)taskId)).eq(TrainingCourseUserTask::getTurns, (Object)turns)).orderByAsc(TrainingCourseUserTask::getId);
            List userTaskList = this.courseUserTaskMapper.selectList((Wrapper)wrapper2);
            int taskStatus = 1;
            if (!CollectionUtils.isEmpty((Collection)userTaskList)) {
                for (int i = 0; i < userTaskList.size(); ++i) {
                    TrainingCourseUserTask userTask;
                    if (i == 0) {
                        userTask = (TrainingCourseUserTask)userTaskList.get(0);
                        if (userTask.getStartTime() == null) {
                            userTask.setStartTime(now);
                        }
                        userTask.setTaskStatus(Integer.valueOf(taskStatus));
                        this.courseUserTaskMapper.updateById(userTask);
                        continue;
                    }
                    userTask = (TrainingCourseUserTask)userTaskList.get(i);
                    this.courseUserTaskMapper.deleteById(userTask.getId());
                }
            } else {
                TrainingCourseUserTask userTask = new TrainingCourseUserTask();
                userTask.setCourseId(trainingCourseStageTask.getCourseId());
                userTask.setTaskId(trainingCourseStageTask.getId());
                userTask.setUserId(userId);
                userTask.setStartTime(now);
                userTask.setTaskStatus(Integer.valueOf(taskStatus));
                userTask.setTurns(turns);
                userTask.setEnterpriseId(trainingCourseStageTask.getEnterpriseId());
                userTask.setCreater(userId);
                userTask.setCreateTime(now);
                saveTaskList.add(userTask);
            }
        }
        if (!CollectionUtils.isEmpty(saveTaskList)) {
            this.courseUserTaskMapper.insertList(saveTaskList);
        }
    }

    @Override
    public void saveCourseTaskEnd(Integer id, Integer taskType, Integer userId, Integer taskId, Integer turns) {
        TrainingCourseStageTask trainingCourseStageTask;
        ArrayList<TrainingCourseStageTask> stageTaskList;
        Date now = new Date();
        final ArrayList<Integer> finishList = new ArrayList<Integer>();
        if (taskType == 1) {
            TrainingCourseStageTask task;
            stageTaskList = new ArrayList<TrainingCourseStageTask>();
            if (taskId != null && !ObjectUtils.isEmpty((Object)(task = (TrainingCourseStageTask)this.courseStageTaskMapper.selectById(taskId)))) {
                stageTaskList.add(task);
            }
            if (!CollectionUtils.isEmpty(stageTaskList)) {
                List stageTaskIds = stageTaskList.stream().map(TrainingCourseStageTask::getId).distinct().collect(Collectors.toList());
                List courseIds = stageTaskList.stream().map(TrainingCourseStageTask::getCourseId).distinct().collect(Collectors.toList());
                LambdaQueryWrapper wrapper3 = new LambdaQueryWrapper();
                wrapper3.in(TrainingCourse::getId, courseIds);
                List courseList = this.courseMapper.selectList((Wrapper)wrapper3);
                Map courseMap = courseList.stream().collect(Collectors.toMap(TrainingCourse::getId, Function.identity()));
                LambdaQueryWrapper wrapper2 = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper2.eq(TrainingCourseUserTask::getUserId, (Object)userId)).in(TrainingCourseUserTask::getTaskId, stageTaskIds)).eq(TrainingCourseUserTask::getTurns, (Object)turns)).orderByAsc(TrainingCourseUserTask::getId);
                List userTaskList = this.courseUserTaskMapper.selectList((Wrapper)wrapper2);
                Map<Object, Object> map = new HashMap();
                if (!CollectionUtils.isEmpty((Collection)userTaskList)) {
                    map = userTaskList.stream().collect(Collectors.groupingBy(TrainingCourseUserTask::getTaskId));
                }
                for (TrainingCourseStageTask stageTask : stageTaskList) {
                    List userTasks;
                    List<TrainingUserViewTimeVo> timeList;
                    Integer taskStatus = 3;
                    TrainingCourse course = (TrainingCourse)courseMap.get(stageTask.getCourseId());
                    if (!org.springframework.util.StringUtils.isEmpty((Object)course) && !org.springframework.util.StringUtils.isEmpty((Object)course.getEndTime()) && course.getEndTime().before(now)) {
                        taskStatus = 4;
                    }
                    if (!CollectionUtils.isEmpty(timeList = this.commonService.selectlearnProgress(id, 4, stageTask.getId(), userId, turns, stageTask.getIsProgress()))) {
                        Integer is = 1;
                        for (TrainingUserViewTimeVo vo : timeList) {
                            if (vo.getIsFinish() != 0) continue;
                            is = 0;
                            break;
                        }
                        if (is == 0) {
                            taskStatus = 2;
                        }
                    }
                    if (!CollectionUtils.isEmpty((Collection)(userTasks = (List)map.get(stageTask.getId())))) {
                        for (int i = 0; i < userTasks.size(); ++i) {
                            TrainingCourseUserTask userTask;
                            if (i == 0) {
                                userTask = (TrainingCourseUserTask)userTasks.get(0);
                                userTask.setEndTime(now);
                                userTask.setTaskStatus(taskStatus);
                                this.courseUserTaskMapper.updateById(userTask);
                                if (taskStatus != 3 && taskStatus != 4) continue;
                                finishList.add(userTask.getCourseId());
                                continue;
                            }
                            userTask = (TrainingCourseUserTask)userTasks.get(i);
                            this.courseUserTaskMapper.deleteById(userTask.getId());
                        }
                        continue;
                    }
                    TrainingCourseUserTask userTask = new TrainingCourseUserTask();
                    userTask.setCourseId(stageTask.getCourseId());
                    userTask.setTaskId(stageTask.getId());
                    userTask.setUserId(userId);
                    userTask.setStartTime(now);
                    userTask.setEndTime(now);
                    userTask.setTurns(turns);
                    userTask.setTaskStatus(taskStatus);
                    userTask.setEnterpriseId(stageTask.getEnterpriseId());
                    userTask.setCreater(userId);
                    userTask.setCreateTime(now);
                    this.courseUserTaskMapper.insert(userTask);
                    if (taskStatus != 3 && taskStatus != 4) continue;
                    finishList.add(userTask.getCourseId());
                }
            }
        } else if (taskType == 2) {
            TrainingUserPaper trainingUserPaper = (TrainingUserPaper)this.trainingUserPaperMapper.selectById(id);
            if (!ObjectUtils.isEmpty((Object)trainingUserPaper)) {
                userId = trainingUserPaper.getUserId();
                taskId = trainingUserPaper.getSourceTaskId();
                TrainingCourseStageTask task = null;
                if (taskId != null) {
                    task = (TrainingCourseStageTask)this.courseStageTaskMapper.selectById(taskId);
                }
                if (task != null && task.getTaskType() == 1 && task.getTrainingId() != null) {
                    List<TrainingUserViewTimeVo> timeList = this.commonService.selectlearnProgress(task.getTrainingId(), 4, task.getId(), userId, 1, task.getIsProgress());
                    if (!CollectionUtils.isEmpty(timeList)) {
                        TrainingCourse course;
                        Date startDate = null;
                        Date endDate = null;
                        boolean is = true;
                        for (TrainingUserViewTimeVo vo : timeList) {
                            if (vo.getIsFinish() == 0) {
                                is = false;
                            }
                            if (vo.getStartDate() != null) {
                                if (startDate != null) {
                                    if (startDate.after(vo.getStartDate())) {
                                        startDate = vo.getStartDate();
                                    }
                                } else {
                                    startDate = vo.getStartDate();
                                }
                            }
                            if (vo.getEndDate() == null) continue;
                            if (endDate != null) {
                                if (!endDate.before(vo.getEndDate())) continue;
                                endDate = vo.getEndDate();
                                continue;
                            }
                            endDate = vo.getEndDate();
                        }
                        Integer taskStatus = 2;
                        if (is) {
                            taskStatus = 3;
                        }
                        if (!ObjectUtils.isEmpty((Object)(course = (TrainingCourse)this.courseMapper.selectById(task.getCourseId()))) && !org.springframework.util.StringUtils.isEmpty((Object)course.getEndTime()) && course.getEndTime().before(now) && taskStatus == 3) {
                            taskStatus = 4;
                        }
                        LambdaQueryWrapper wrapper2 = new LambdaQueryWrapper();
                        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper2.eq(TrainingCourseUserTask::getUserId, (Object)userId)).eq(TrainingCourseUserTask::getCourseId, (Object)task.getCourseId())).eq(TrainingCourseUserTask::getTaskId, (Object)taskId)).orderByDesc(TrainingCourseUserTask::getId);
                        List userTaskList = this.courseUserTaskMapper.selectList((Wrapper)wrapper2);
                        TrainingCourseUserTask userTask = new TrainingCourseUserTask();
                        if (!CollectionUtils.isEmpty((Collection)userTaskList)) {
                            userTask = (TrainingCourseUserTask)userTaskList.get(0);
                            userTask.setTaskStatus(taskStatus);
                            if (is) {
                                if (org.springframework.util.StringUtils.isEmpty((Object)userTask.getStartTime())) {
                                    userTask.setStartTime(startDate);
                                }
                                userTask.setEndTime(now);
                            } else if (org.springframework.util.StringUtils.isEmpty((Object)userTask.getStartTime())) {
                                userTask.setStartTime(startDate);
                            }
                            this.courseUserTaskMapper.updateById(userTask);
                        } else {
                            userTask.setCourseId(task.getCourseId());
                            userTask.setTaskId(task.getId());
                            userTask.setUserId(userId);
                            userTask.setTurns(Integer.valueOf(1));
                            userTask.setStartTime(startDate);
                            userTask.setEndTime(endDate);
                            userTask.setTaskStatus(taskStatus);
                            userTask.setEnterpriseId(task.getEnterpriseId());
                            userTask.setCreater(userId);
                            userTask.setCreateTime(now);
                            this.courseUserTaskMapper.insert(userTask);
                        }
                        if (taskStatus == 3 || taskStatus == 4) {
                            finishList.add(task.getCourseId());
                        }
                    }
                } else {
                    Object wrapper1;
                    int taskStatus = 3;
                    if (trainingUserPaper.getPaperStatus() == 1) {
                        taskStatus = 6;
                    } else {
                        TrainingPaper trainingPaper = (TrainingPaper)this.trainingPaperMapper.selectById(trainingUserPaper.getTrainingPaperId());
                        TrainingExam exam = (TrainingExam)this.trainingExamMapper.selectById(trainingPaper.getExamId());
                        wrapper1 = new LambdaQueryWrapper();
                        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper1.eq(TrainingUserPaper::getTrainingPaperId, (Object)trainingPaper.getId())).eq(TrainingUserPaper::getUserId, (Object)userId)).isNotNull(TrainingUserPaper::getSubmitTime)).eq(TrainingUserPaper::getSourceType, (Object)5)).eq(taskId != null, TrainingUserPaper::getSourceTaskId, (Object)taskId)).orderByDesc(TrainingUserPaper::getId);
                        List userPapers = this.trainingUserPaperMapper.selectList((Wrapper)wrapper1);
                        Map<String, Object> paperStatusMap = this.commonService.isPaperStatus(trainingPaper, exam, userPapers);
                        if (paperStatusMap.get("status").toString().equals("3")) {
                            taskStatus = 5;
                        }
                    }
                    LambdaQueryWrapper wrapper0 = new LambdaQueryWrapper();
                    ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper0.eq(TrainingPaperTurns::getPaperId, (Object)trainingUserPaper.getTrainingPaperId())).eq(TrainingPaperTurns::getTurnType, (Object)4)).orderByDesc(TrainingPaperTurns::getTurns);
                    List paperTurnsList = this.paperTurnsMapper.selectList((Wrapper)wrapper0);
                    if (!CollectionUtils.isEmpty((Collection)paperTurnsList)) {
                        for (TrainingPaperTurns paperTurns : paperTurnsList) {
                            LambdaQueryWrapper wrapper2 = new LambdaQueryWrapper();
                            ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper2.eq(TrainingCourseUserTask::getUserId, (Object)userId)).eq(TrainingCourseUserTask::getCourseId, (Object)paperTurns.getProjectId())).eq(TrainingCourseUserTask::getTaskId, (Object)paperTurns.getTaskId())).eq(TrainingCourseUserTask::getTurns, (Object)paperTurns.getTurns())).orderByAsc(TrainingCourseUserTask::getId);
                            List userTaskList = this.courseUserTaskMapper.selectList((Wrapper)wrapper2);
                            if (!CollectionUtils.isEmpty((Collection)userTaskList)) {
                                for (int i = 0; i < userTaskList.size(); ++i) {
                                    TrainingCourseUserTask userTask;
                                    if (i == 0) {
                                        userTask = (TrainingCourseUserTask)userTaskList.get(0);
                                        userTask.setEndTime(now);
                                        if (taskStatus != 6 || userTask.getTaskStatus() != 3 && userTask.getTaskStatus() != 4 && userTask.getTaskStatus() != 5) {
                                            userTask.setTaskStatus(Integer.valueOf(taskStatus));
                                        }
                                        this.courseUserTaskMapper.updateById(userTask);
                                        if (taskStatus != 3) continue;
                                        finishList.add(userTask.getCourseId());
                                        continue;
                                    }
                                    userTask = (TrainingCourseUserTask)userTaskList.get(i);
                                    this.courseUserTaskMapper.deleteById(userTask.getId());
                                }
                                continue;
                            }
                            TrainingCourseUserTask userTask = new TrainingCourseUserTask();
                            userTask.setCourseId(paperTurns.getProjectId());
                            userTask.setTaskId(paperTurns.getTaskId());
                            userTask.setUserId(userId);
                            userTask.setTurns(paperTurns.getTurns());
                            userTask.setStartTime(now);
                            userTask.setEndTime(now);
                            userTask.setTaskStatus(Integer.valueOf(taskStatus));
                            userTask.setEnterpriseId(paperTurns.getEnterpriseId());
                            userTask.setCreater(userId);
                            userTask.setCreateTime(now);
                            this.courseUserTaskMapper.insert(userTask);
                            if (taskStatus != 3) continue;
                            finishList.add(userTask.getCourseId());
                        }
                    } else {
                        wrapper1 = new LambdaQueryWrapper();
                        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper1.eq(TrainingCourseStageTask::getTaskType, (Object)2)).eq(TrainingCourseStageTask::getPaperId, (Object)trainingUserPaper.getTrainingPaperId())).eq(!org.springframework.util.StringUtils.isEmpty((Object)trainingUserPaper.getSourceTaskId()), TrainingCourseStageTask::getId, (Object)trainingUserPaper.getSourceTaskId())).isNotNull(TrainingCourseStageTask::getCourseId);
                        List stageTaskList2 = this.courseStageTaskMapper.selectList((Wrapper)wrapper1);
                        if (!CollectionUtils.isEmpty((Collection)stageTaskList2) && !org.springframework.util.StringUtils.isEmpty((Object)userId)) {
                            List stageTaskIds = stageTaskList2.stream().map(TrainingCourseStageTask::getId).collect(Collectors.toList());
                            List courseIds = stageTaskList2.stream().map(TrainingCourseStageTask::getCourseId).distinct().collect(Collectors.toList());
                            LambdaQueryWrapper wrapper3 = new LambdaQueryWrapper();
                            wrapper3.in(TrainingCourse::getId, courseIds);
                            List courseList = this.courseMapper.selectList((Wrapper)wrapper3);
                            Map courseMap = courseList.stream().collect(Collectors.toMap(TrainingCourse::getId, Function.identity()));
                            LambdaQueryWrapper wrapper2 = new LambdaQueryWrapper();
                            ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper2.eq(TrainingCourseUserTask::getUserId, (Object)userId)).in(TrainingCourseUserTask::getTaskId, stageTaskIds)).orderByAsc(TrainingCourseUserTask::getId);
                            List userTaskList = this.courseUserTaskMapper.selectList((Wrapper)wrapper2);
                            Map<Object, Object> map = new HashMap();
                            if (!CollectionUtils.isEmpty((Collection)userTaskList)) {
                                map = userTaskList.stream().collect(Collectors.groupingBy(TrainingCourseUserTask::getTaskId));
                            }
                            for (TrainingCourseStageTask stageTask : stageTaskList2) {
                                List userTasks;
                                Integer taskStatuss = taskStatus;
                                TrainingCourse course = (TrainingCourse)courseMap.get(stageTask.getCourseId());
                                if (!org.springframework.util.StringUtils.isEmpty((Object)course) && !org.springframework.util.StringUtils.isEmpty((Object)course.getEndTime()) && course.getEndTime().before(now) && taskStatus == 3) {
                                    taskStatuss = 4;
                                }
                                if (!CollectionUtils.isEmpty((Collection)(userTasks = (List)map.get(stageTask.getId())))) {
                                    for (int i = 0; i < userTasks.size(); ++i) {
                                        TrainingCourseUserTask userTask;
                                        if (i == 0) {
                                            userTask = (TrainingCourseUserTask)userTasks.get(0);
                                            userTask.setEndTime(now);
                                            if (taskStatus != 6 || userTask.getTaskStatus() != 3 && userTask.getTaskStatus() != 4 && userTask.getTaskStatus() != 5) {
                                                userTask.setTaskStatus(Integer.valueOf(taskStatus));
                                            }
                                            this.courseUserTaskMapper.updateById(userTask);
                                            if (taskStatus != 3) continue;
                                            finishList.add(userTask.getCourseId());
                                            continue;
                                        }
                                        userTask = (TrainingCourseUserTask)userTasks.get(i);
                                        this.courseUserTaskMapper.deleteById(userTask.getId());
                                    }
                                    continue;
                                }
                                TrainingCourseUserTask userTask = new TrainingCourseUserTask();
                                userTask.setCourseId(stageTask.getCourseId());
                                userTask.setTaskId(stageTask.getId());
                                userTask.setUserId(userId);
                                userTask.setTurns(Integer.valueOf(1));
                                userTask.setStartTime(now);
                                userTask.setEndTime(now);
                                userTask.setTaskStatus(taskStatuss);
                                userTask.setEnterpriseId(stageTask.getEnterpriseId());
                                userTask.setCreater(userId);
                                userTask.setCreateTime(now);
                                this.courseUserTaskMapper.insert(userTask);
                                if (taskStatus != 3) continue;
                                finishList.add(userTask.getCourseId());
                            }
                        }
                    }
                }
            }
        } else if (taskType == 5) {
            TrainingCourseStageTask task;
            stageTaskList = new ArrayList();
            if (taskId != null && !ObjectUtils.isEmpty((Object)(task = (TrainingCourseStageTask)this.courseStageTaskMapper.selectById(taskId)))) {
                stageTaskList.add(task);
            }
            if (!CollectionUtils.isEmpty(stageTaskList) && !org.springframework.util.StringUtils.isEmpty((Object)userId)) {
                List stageTaskIds = stageTaskList.stream().map(TrainingCourseStageTask::getId).distinct().collect(Collectors.toList());
                List courseIds = stageTaskList.stream().map(TrainingCourseStageTask::getCourseId).distinct().collect(Collectors.toList());
                LambdaQueryWrapper wrapper3 = new LambdaQueryWrapper();
                wrapper3.in(TrainingCourse::getId, courseIds);
                List courseList = this.courseMapper.selectList((Wrapper)wrapper3);
                Map courseMap = courseList.stream().collect(Collectors.toMap(TrainingCourse::getId, Function.identity()));
                LambdaQueryWrapper wrapper2 = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper2.eq(TrainingCourseUserTask::getUserId, (Object)userId)).in(TrainingCourseUserTask::getTaskId, stageTaskIds)).eq(TrainingCourseUserTask::getTurns, (Object)turns)).orderByAsc(TrainingCourseUserTask::getId);
                List userTaskList = this.courseUserTaskMapper.selectList((Wrapper)wrapper2);
                Map<Object, Object> map = new HashMap();
                if (!CollectionUtils.isEmpty((Collection)userTaskList)) {
                    map = userTaskList.stream().collect(Collectors.groupingBy(TrainingCourseUserTask::getTaskId));
                }
                for (TrainingCourseStageTask stageTask : stageTaskList) {
                    List userTasks;
                    int isPass;
                    int taskStatus = 3;
                    TrainingCourse course = (TrainingCourse)courseMap.get(stageTask.getCourseId());
                    if (!org.springframework.util.StringUtils.isEmpty((Object)course) && !org.springframework.util.StringUtils.isEmpty((Object)course.getEndTime()) && course.getEndTime().before(now)) {
                        taskStatus = 4;
                    }
                    if ((isPass = this.selectUserMaterialProgress(id, 4, userId, stageTask.getId(), stageTask.getIsProgress(), turns)) == 0) {
                        taskStatus = 2;
                    }
                    if (!CollectionUtils.isEmpty((Collection)(userTasks = (List)map.get(stageTask.getId())))) {
                        for (int i = 0; i < userTasks.size(); ++i) {
                            TrainingCourseUserTask userTask;
                            if (i == 0) {
                                userTask = (TrainingCourseUserTask)userTasks.get(0);
                                userTask.setEndTime(now);
                                userTask.setTaskStatus(Integer.valueOf(taskStatus));
                                this.courseUserTaskMapper.updateById(userTask);
                                if (taskStatus != 3 && taskStatus != 4) continue;
                                finishList.add(userTask.getCourseId());
                                continue;
                            }
                            userTask = (TrainingCourseUserTask)userTasks.get(i);
                            this.courseUserTaskMapper.deleteById(userTask.getId());
                        }
                        continue;
                    }
                    TrainingCourseUserTask userTask = new TrainingCourseUserTask();
                    userTask.setCourseId(stageTask.getCourseId());
                    userTask.setTaskId(stageTask.getId());
                    userTask.setUserId(userId);
                    userTask.setStartTime(now);
                    userTask.setEndTime(now);
                    userTask.setTaskStatus(Integer.valueOf(taskStatus));
                    userTask.setTurns(turns);
                    userTask.setEnterpriseId(stageTask.getEnterpriseId());
                    userTask.setCreater(userId);
                    userTask.setCreateTime(now);
                    this.courseUserTaskMapper.insert(userTask);
                    if (taskStatus != 3 && taskStatus != 4) continue;
                    finishList.add(userTask.getCourseId());
                }
            }
        } else if (taskType == 6 && taskId != null && !ObjectUtils.isEmpty((Object)(trainingCourseStageTask = (TrainingCourseStageTask)this.courseStageTaskMapper.selectById(taskId))) && !org.springframework.util.StringUtils.isEmpty((Object)userId)) {
            TrainingWorkUserAnswer trainingWorkUserAnswer;
            TrainingCourse trainingCourse = (TrainingCourse)this.courseMapper.selectById(trainingCourseStageTask.getCourseId());
            LambdaQueryWrapper wrapper2 = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper2.eq(TrainingCourseUserTask::getUserId, (Object)userId)).eq(TrainingCourseUserTask::getTaskId, (Object)taskId)).eq(TrainingCourseUserTask::getTurns, (Object)turns)).orderByAsc(TrainingCourseUserTask::getId);
            List userTaskList = this.courseUserTaskMapper.selectList((Wrapper)wrapper2);
            int taskStatus = 3;
            if (!ObjectUtils.isEmpty((Object)trainingCourse) && !org.springframework.util.StringUtils.isEmpty((Object)trainingCourse.getEndTime()) && trainingCourse.getEndTime().before(now)) {
                taskStatus = 4;
            }
            if (!ObjectUtils.isEmpty((Object)(trainingWorkUserAnswer = (TrainingWorkUserAnswer)this.trainingWorkUserAnswerMapper.selectById(id))) && trainingWorkUserAnswer.getStatus() != null) {
                if (trainingWorkUserAnswer.getStatus() == 1) {
                    taskStatus = 6;
                } else if (trainingWorkUserAnswer.getStatus() == 2) {
                    taskStatus = 5;
                } else if (trainingWorkUserAnswer.getStatus() == 0) {
                    taskStatus = 1;
                }
            } else {
                taskStatus = 1;
            }
            if (!CollectionUtils.isEmpty((Collection)userTaskList)) {
                for (int i = 0; i < userTaskList.size(); ++i) {
                    TrainingCourseUserTask userTask;
                    if (i == 0) {
                        userTask = (TrainingCourseUserTask)userTaskList.get(0);
                        if (userTask.getStartTime() == null) {
                            userTask.setStartTime(now);
                        }
                        if (userTask.getTaskStatus() != 6) {
                            userTask.setEndTime(now);
                        }
                        userTask.setTaskStatus(Integer.valueOf(taskStatus));
                        this.courseUserTaskMapper.updateById(userTask);
                        if (taskStatus != 3 && taskStatus != 4) continue;
                        finishList.add(userTask.getCourseId());
                        continue;
                    }
                    userTask = (TrainingCourseUserTask)userTaskList.get(i);
                    this.courseUserTaskMapper.deleteById(userTask.getId());
                }
            } else {
                TrainingCourseUserTask userTask = new TrainingCourseUserTask();
                userTask.setCourseId(trainingCourseStageTask.getCourseId());
                userTask.setTaskId(trainingCourseStageTask.getId());
                userTask.setUserId(userId);
                userTask.setStartTime(now);
                userTask.setEndTime(now);
                userTask.setTaskStatus(Integer.valueOf(taskStatus));
                userTask.setTurns(turns);
                userTask.setEnterpriseId(trainingCourseStageTask.getEnterpriseId());
                userTask.setCreater(userId);
                userTask.setCreateTime(now);
                this.courseUserTaskMapper.insert(userTask);
                if (taskStatus == 3 || taskStatus == 4) {
                    finishList.add(userTask.getCourseId());
                }
            }
        }
        if (!CollectionUtils.isEmpty(finishList)) {
            final Integer finalUserId = userId;
            CommonUtil.handleTask(new Runnable(){

                @Override
                public void run() {
                    TrainingCourseServiceImpl.this.getIsFinishCourse(finishList, finalUserId);
                }
            });
        }
    }

    @Override
    public void getIsFinishCourse(List<Integer> courseIds, Integer userId) {
        Date now = new Date();
        try {
            courseIds = courseIds.stream().distinct().collect(Collectors.toList());
            List courseList = this.courseMapper.selectBatchIds(courseIds);
            if (!CollectionUtils.isEmpty((Collection)courseList)) {
                Map courseMap = courseList.stream().collect(Collectors.toMap(TrainingCourse::getId, Function.identity()));
                List courseIdList = courseList.stream().map(TrainingCourse::getId).collect(Collectors.toList());
                LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
                wrapper1.in(TrainingCourseStageTask::getCourseId, courseIdList);
                List stageTasks = this.courseStageTaskMapper.selectList((Wrapper)wrapper1);
                Map<Object, Object> map1 = new HashMap();
                if (!CollectionUtils.isEmpty((Collection)stageTasks)) {
                    map1 = stageTasks.stream().collect(Collectors.groupingBy(TrainingCourseStageTask::getCourseId));
                }
                LambdaQueryWrapper wrapper2 = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper2.in(TrainingCourseUserTask::getCourseId, courseIdList)).eq(TrainingCourseUserTask::getUserId, (Object)userId)).in(TrainingCourseUserTask::getTaskStatus, Arrays.asList(3, 4))).eq(TrainingCourseUserTask::getIsLast, (Object)1);
                List userTasks = this.courseUserTaskMapper.selectList((Wrapper)wrapper2);
                Map<Object, Object> map2 = new HashMap();
                if (!CollectionUtils.isEmpty((Collection)userTasks)) {
                    map2 = userTasks.stream().collect(Collectors.groupingBy(TrainingCourseUserTask::getCourseId));
                }
                LambdaQueryWrapper wrapper3 = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper3.eq(TrainingCourseUserAnalyse::getUserId, (Object)userId)).in(TrainingCourseUserAnalyse::getCourseId, courseIdList)).orderByDesc(TrainingCourseUserAnalyse::getId);
                List trainingCourseUserAnalyseList = this.trainingCourseUserAnalyseMapper.selectList((Wrapper)wrapper3);
                Map<Object, Object> trainingCourseUserAnalyseMap = new HashMap();
                if (!CollectionUtils.isEmpty((Collection)trainingCourseUserAnalyseList)) {
                    trainingCourseUserAnalyseMap = trainingCourseUserAnalyseList.stream().collect(Collectors.groupingBy(TrainingCourseUserAnalyse::getCourseId));
                }
                for (Integer courseId : courseIdList) {
                    List task1 = (List)map1.get(courseId);
                    List task2 = (List)map2.get(courseId);
                    if (!CollectionUtils.isEmpty((Collection)task1) && !CollectionUtils.isEmpty((Collection)task2) && task1.size() <= task2.size()) {
                        TrainingCourseUserAnalyse trainingCourseUserAnalyse;
                        List trainingCourseUserAnalyses;
                        this.jPushService.deleteMessages(courseId, "TYPE_COURSE_SYSTEM", userId, null, 1);
                        TrainingCourse trainingCourse = (TrainingCourse)courseMap.get(courseId);
                        Integer certificateDetailId = null;
                        if (!org.springframework.util.StringUtils.isEmpty((Object)trainingCourse.getIsGet()) && trainingCourse.getIsGet() == 1 && !org.springframework.util.StringUtils.isEmpty((Object)trainingCourse.getCertificateId())) {
                            certificateDetailId = this.trainingJobCertificationService.saveCertificateDetail(trainingCourse.getCertificateId(), trainingCourse.getCertificatePath(), userId, trainingCourse.getCreater(), 5, trainingCourse.getCourseName());
                        }
                        if (CollectionUtils.isEmpty((Collection)(trainingCourseUserAnalyses = (List)trainingCourseUserAnalyseMap.get(courseId)))) {
                            trainingCourseUserAnalyse = new TrainingCourseUserAnalyse();
                            trainingCourseUserAnalyse.setCertificateId(certificateDetailId);
                            trainingCourseUserAnalyse.setUserId(userId);
                            trainingCourseUserAnalyse.setPassStatus(Integer.valueOf(1));
                            trainingCourseUserAnalyse.setCourseId(courseId);
                            trainingCourseUserAnalyse.setCreateTime(now);
                            trainingCourseUserAnalyse.setCreater(userId);
                            this.trainingCourseUserAnalyseMapper.insert(trainingCourseUserAnalyse);
                            continue;
                        }
                        trainingCourseUserAnalyse = (TrainingCourseUserAnalyse)trainingCourseUserAnalyses.get(0);
                        trainingCourseUserAnalyse.setCertificateId(certificateDetailId);
                        trainingCourseUserAnalyse.setPassStatus(Integer.valueOf(1));
                        this.trainingCourseUserAnalyseMapper.updateById(trainingCourseUserAnalyse);
                        if (trainingCourseUserAnalyses.size() <= 1) continue;
                        List trainingCourseUserAnalyseIds = trainingCourseUserAnalyses.stream().map(TrainingCourseUserAnalyse::getId).collect(Collectors.toList());
                        trainingCourseUserAnalyseIds.remove(trainingCourseUserAnalyse.getId());
                        this.trainingCourseUserAnalyseMapper.deleteBatchIds(trainingCourseUserAnalyseIds);
                        continue;
                    }
                    List trainingCourseUserAnalyses = (List)trainingCourseUserAnalyseMap.get(courseId);
                    if (CollectionUtils.isEmpty((Collection)trainingCourseUserAnalyses)) {
                        TrainingCourseUserAnalyse trainingCourseUserAnalyse = new TrainingCourseUserAnalyse();
                        trainingCourseUserAnalyse.setUserId(userId);
                        trainingCourseUserAnalyse.setPassStatus(Integer.valueOf(0));
                        trainingCourseUserAnalyse.setCourseId(courseId);
                        trainingCourseUserAnalyse.setCreateTime(now);
                        trainingCourseUserAnalyse.setCreater(userId);
                        this.trainingCourseUserAnalyseMapper.insert(trainingCourseUserAnalyse);
                        continue;
                    }
                    if (trainingCourseUserAnalyses.size() <= 1) continue;
                    List trainingCourseUserAnalyseIds = trainingCourseUserAnalyses.stream().map(TrainingCourseUserAnalyse::getId).collect(Collectors.toList());
                    trainingCourseUserAnalyseIds.remove(((TrainingCourseUserAnalyse)trainingCourseUserAnalyses.get(0)).getId());
                    this.trainingCourseUserAnalyseMapper.deleteBatchIds(trainingCourseUserAnalyseIds);
                }
            }
        }
        catch (Exception e) {
            log.error("getIsFinishCourse", (Throwable)e);
        }
    }

    @Override
    public void updateRoleUsersByClose(Integer courseId, Integer userId, Integer groupId) {
        LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)wrapper1.eq(TrainingCourseUser::getCourseType, (Object)1)).eq(TrainingCourseUser::getCourseId, (Object)courseId);
        List courseUserList = this.courseUserMapper.selectList((Wrapper)wrapper1);
        if (!CollectionUtils.isEmpty((Collection)courseUserList)) {
            List orgIds;
            List tagIds;
            List<Object> userIdList = new ArrayList();
            userIdList = courseUserList.stream().map(TrainingCourseUser::getUserId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            List<Integer> roleList = courseUserList.stream().map(TrainingCourseUser::getRoleId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            List<Integer> pojoList = this.userUtilService.selectUsersByRoles(roleList, ((TrainingCourseUser)courseUserList.get(0)).getEnterpriseId());
            if (!CollectionUtils.isEmpty(pojoList)) {
                pojoList.removeAll(userIdList);
                userIdList.addAll(pojoList);
                ArrayList<TrainingCourseUser> courseUsers = new ArrayList<TrainingCourseUser>();
                for (Integer pojoId : pojoList) {
                    TrainingCourseUser courseUser = new TrainingCourseUser();
                    courseUser.setCourseId(courseId);
                    courseUser.setUserId(pojoId);
                    courseUser.setCourseType(Integer.valueOf(1));
                    courseUser.setCreater(userId);
                    courseUser.setCreateTime(new Date());
                    courseUser.setEnterpriseId(((TrainingCourseUser)courseUserList.get(0)).getEnterpriseId());
                    courseUsers.add(courseUser);
                }
                this.courseUserMapper.insertList(courseUsers);
            }
            if (!CollectionUtils.isEmpty(tagIds = courseUserList.stream().map(TrainingCourseUser::getTagId).filter(Objects::nonNull).distinct().collect(Collectors.toList()))) {
                DepAndTagsPojo pojo = new DepAndTagsPojo();
                pojo.setGroupId(groupId);
                pojo.setTagIds(tagIds);
                pojo.setUserId(userId);
                BaseResult tagResult = this.tagApi.getUsersByTags(pojo);
                if (!tagResult.getIsError().booleanValue() && !CollectionUtils.isEmpty((Collection)((Collection)tagResult.getData()))) {
                    ArrayList<TrainingCourseUser> courseUsers = new ArrayList<TrainingCourseUser>();
                    for (Map map : (List)tagResult.getData()) {
                        Integer id = (Integer)map.get("id");
                        if (userIdList.contains(id)) continue;
                        userIdList.add(id);
                        TrainingCourseUser courseUser = new TrainingCourseUser();
                        courseUser.setCourseId(courseId);
                        courseUser.setUserId(id);
                        courseUser.setCourseType(Integer.valueOf(1));
                        courseUser.setCreater(userId);
                        courseUser.setCreateTime(new Date());
                        courseUser.setEnterpriseId(groupId);
                        courseUsers.add(courseUser);
                    }
                    this.courseUserMapper.insertList(courseUsers);
                }
            }
            if (!CollectionUtils.isEmpty(orgIds = courseUserList.stream().map(TrainingCourseUser::getOrganizeId).filter(Objects::nonNull).distinct().collect(Collectors.toList()))) {
                UsersAndOrgsMo mo = new UsersAndOrgsMo();
                mo.setGroupId(groupId);
                mo.setOrganizeIds(orgIds);
                BaseResult userResult = this.userOrganizeApi.getUserByOrganizeIdsOrDepId(mo);
                if (!userResult.getIsError().booleanValue() && !CollectionUtils.isEmpty((Collection)((Collection)userResult.getData()))) {
                    List users = ((List)userResult.getData()).stream().map(UserAndParentNameMo::getUserId).distinct().collect(Collectors.toList());
                    ArrayList<TrainingCourseUser> courseUsers = new ArrayList<TrainingCourseUser>();
                    users.removeAll(userIdList);
                    if (!CollectionUtils.isEmpty(users)) {
                        for (Integer id : users) {
                            TrainingCourseUser courseUser = new TrainingCourseUser();
                            courseUser.setCourseId(courseId);
                            courseUser.setUserId(id);
                            courseUser.setCourseType(Integer.valueOf(1));
                            courseUser.setCreater(userId);
                            courseUser.setCreateTime(new Date());
                            courseUser.setEnterpriseId(groupId);
                            courseUsers.add(courseUser);
                        }
                        this.courseUserMapper.insertList(courseUsers);
                    }
                }
            }
            LambdaUpdateWrapper wrapper2 = new LambdaUpdateWrapper();
            ((LambdaUpdateWrapper)((LambdaUpdateWrapper)wrapper2.eq(TrainingCourseUser::getCourseType, (Object)1)).eq(TrainingCourseUser::getCourseId, (Object)courseId)).isNull(TrainingCourseUser::getUserId);
            this.courseUserMapper.delete((Wrapper)wrapper2);
        }
    }

    public int selectUserMaterialProgress(Integer materialId, Integer learnType, Integer userId, Integer taskId, Integer isProgress, Integer turns) {
        int isPass = 0;
        if (materialId != null) {
            TrainingUserViewTimeVo trainingViewVo;
            if (isProgress == 1) {
                learnType = 0;
                taskId = null;
            }
            if (!org.springframework.util.StringUtils.isEmpty((Object)(trainingViewVo = this.trainingUserViewTimeMapper.selectMaterialViewTime(userId, taskId, learnType, materialId, turns)))) {
                BigDecimal viewTime;
                TrainingMaterial material = (TrainingMaterial)this.materialMapper.selectById(materialId);
                BigDecimal finishTime = new BigDecimal(0);
                if (material.getIsVideo() == 1) {
                    finishTime = new BigDecimal(material.getDuration());
                    if (!org.springframework.util.StringUtils.isEmpty((Object)material.getFinishRate())) {
                        finishTime = finishTime.multiply(material.getFinishRate()).divide(new BigDecimal(100), 0, 4);
                    }
                } else if (!org.springframework.util.StringUtils.isEmpty((Object)material.getFinishTime())) {
                    finishTime = new BigDecimal(material.getFinishTime());
                }
                if ((viewTime = new BigDecimal(org.springframework.util.StringUtils.isEmpty((Object)trainingViewVo.getViewTimes()) ? 0 : trainingViewVo.getViewTimes())).compareTo(finishTime) >= 0) {
                    isPass = 1;
                }
            }
        }
        return isPass;
    }

    @Override
    public String addCoursePush(TrainingCoursePushVo push) {
        TrainingCoursePushUser pushUser;
        TaskMessageBody body;
        WorkNotifyVo vo;
        Object base;
        BaseResult simplePojoBaseResult;
        Integer id;
        BaseResult tagResult;
        List tagIds;
        List users;
        BaseResult userResult;
        UsersAndOrgsMo mo;
        List orgIds;
        Object pojo;
        String roleIdStr;
        com.ovopark.privilege.response.BaseResult baseResult;
        List roleIds;
        List userIds;
        LambdaQueryWrapper wrapper1;
        TrainingCourse course;
        List<Object> userIdList;
        push.setPushTime(new Date());
        push.setPushStatus(Integer.valueOf(2));
        this.trainingCoursePushMapper.insert(push);
        if (push.getPushType().equals(0)) {
            userIdList = new ArrayList();
            course = (TrainingCourse)this.courseMapper.selectById(push.getCourseId());
            if (!org.springframework.util.StringUtils.isEmpty((Object)course.getAppointType()) && course.getAppointType() == 1) {
                wrapper1 = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)wrapper1.eq(TrainingCourseUser::getCourseId, (Object)course.getId())).eq(TrainingCourseUser::getCourseType, (Object)1);
                List list = this.courseUserMapper.selectList((Wrapper)wrapper1);
                if (!CollectionUtils.isEmpty((Collection)list)) {
                    userIds = list.stream().map(TrainingCourseUser::getUserId).distinct().filter(Objects::nonNull).collect(Collectors.toList());
                    if (!CollectionUtils.isEmpty(userIds)) {
                        userIdList.addAll(userIds);
                    }
                    if (!CollectionUtils.isEmpty(roleIds = list.stream().map(TrainingCourseUser::getRoleId).filter(Objects::nonNull).distinct().collect(Collectors.toList())) && (baseResult = this.useApi.getUserByRoleIds(roleIdStr = StringUtils.join(roleIds, (String)","), push.getEnterpriseId())) != null && !CollectionUtils.isEmpty((Collection)((Collection)baseResult.getData()))) {
                        pojo = ((List)baseResult.getData()).stream().map(com.ovopark.privilege.pojo.UsersPojo::getId).distinct().collect(Collectors.toList());
                        userIdList.addAll((Collection<Object>)pojo);
                    }
                    if (!CollectionUtils.isEmpty(orgIds = list.stream().map(TrainingCourseUser::getOrganizeId).filter(Objects::nonNull).distinct().collect(Collectors.toList()))) {
                        mo = new UsersAndOrgsMo();
                        mo.setGroupId(push.getEnterpriseId());
                        mo.setOrganizeIds(orgIds);
                        userResult = this.userOrganizeApi.getUserByOrganizeIdsOrDepId(mo);
                        if (!userResult.getIsError().booleanValue() && !CollectionUtils.isEmpty((Collection)((Collection)userResult.getData()))) {
                            users = ((List)userResult.getData()).stream().map(UserAndParentNameMo::getUserId).distinct().collect(Collectors.toList());
                            userIdList.addAll(users);
                        }
                    }
                    if (!CollectionUtils.isEmpty(tagIds = list.stream().map(TrainingCourseUser::getTagId).filter(Objects::nonNull).distinct().collect(Collectors.toList()))) {
                        pojo = new DepAndTagsPojo();
                        pojo.setGroupId(push.getEnterpriseId());
                        pojo.setTagIds(tagIds);
                        pojo.setUserId(push.getPushUserId());
                        tagResult = this.tagApi.getUsersByTags(pojo);
                        if (!tagResult.getIsError().booleanValue() && !CollectionUtils.isEmpty((Collection)((Collection)tagResult.getData()))) {
                            for (Map map : (List)tagResult.getData()) {
                                id = (Integer)map.get("id");
                                userIdList.add(id);
                            }
                        }
                    }
                    userIdList = userIdList.stream().distinct().collect(Collectors.toList());
                    if (course.getStatus() != 3 && !Objects.isNull(simplePojoBaseResult = this.userApi.getSimpleUserByKeyWord(push.getEnterpriseId(), null, null)) && !CollectionUtils.isEmpty((Collection)((Collection)simplePojoBaseResult.getData()))) {
                        userIdList.retainAll(((List)simplePojoBaseResult.getData()).stream().map(SimplePojo::getId).distinct().collect(Collectors.toList()));
                    }
                }
            } else {
                base = (List)this.userApi.getSimpleUserByKeyWord(push.getEnterpriseId(), null, null).getData();
                userIdList = base.stream().map(SimplePojo::getId).collect(Collectors.toList());
            }
            for (Integer n : userIdList) {
                vo = new WorkNotifyVo();
                vo.setTitle(push.getPushTitle());
                vo.setId(push.getCourseId());
                body = new TaskMessageBody();
                body.setType(98);
                body.setTaskJson(JSONObject.toJSONString((Object)vo));
                try {
                    this.jPushService.sendWebSocket(push.getPushTitle(), push.getPushContent(), n, push.getEnterpriseId(), push.getId(), "TYPE_TRAINING_COURSE_PUSH", JSONObject.toJSONString((Object)vo), new Date(), 1, 0, null, null);
                    this.jPushService.pushNotification(JPush.MASSAGE_TYPE_NOTIFY, "TYPE_TRAINING_COURSE_PUSH", n, push.getPushTitle(), push.getPushContent(), body);
                    pushUser = new TrainingCoursePushUser();
                    pushUser.setPushTime(new Date());
                    pushUser.setCoursePushId(push.getId());
                    pushUser.setUserId(n);
                    pushUser.setIsSuccess(Integer.valueOf(1));
                    this.trainingCoursePushUserMapper.insert(pushUser);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        if (push.getPushType().equals(1)) {
            TrainingCourse course2 = (TrainingCourse)this.courseMapper.selectById(push.getCourseId());
            LambdaQueryWrapper wrapper0 = new LambdaQueryWrapper();
            wrapper0.eq(TrainingCourseStageTask::getCourseId, (Object)push.getCourseId());
            List stageTaskList = this.courseStageTaskMapper.selectList((Wrapper)wrapper0);
            int n = stageTaskList.size();
            Map stageTasksMap = stageTaskList.stream().collect(Collectors.toMap(TrainingCourseStageTask::getId, Function.identity()));
            Map<Object, Object> courseUserMap = new HashMap();
            List<Object> allUserIdList = new ArrayList();
            if (!org.springframework.util.StringUtils.isEmpty((Object)course2.getAppointType()) && course2.getAppointType() == 1) {
                List list;
                List orgIds2;
                String roleIdStr2;
                com.ovopark.privilege.response.BaseResult baseResult2;
                List roleIds2;
                LambdaQueryWrapper wrapper12 = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper12.eq(TrainingCourseUser::getCourseId, (Object)push.getCourseId())).eq(TrainingCourseUser::getCourseType, (Object)1)).isNotNull(TrainingCourseUser::getUserId);
                List courseUserList2 = this.courseUserMapper.selectList((Wrapper)wrapper12);
                if (!CollectionUtils.isEmpty((Collection)courseUserList2)) {
                    List userIds2 = courseUserList2.stream().map(TrainingCourseUser::getUserId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
                    if (!CollectionUtils.isEmpty(userIds2)) {
                        allUserIdList.addAll(userIds2);
                    }
                    courseUserMap = courseUserList2.stream().collect(Collectors.toMap(TrainingCourseUser::getUserId, Function.identity(), (v1, v2) -> v1));
                }
                LambdaQueryWrapper wrapper2 = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper2.eq(TrainingCourseUser::getCourseId, (Object)push.getCourseId())).eq(TrainingCourseUser::getCourseType, (Object)1)).isNotNull(TrainingCourseUser::getRoleId);
                List courseUserList22 = this.courseUserMapper.selectList((Wrapper)wrapper2);
                if (!(CollectionUtils.isEmpty((Collection)courseUserList22) || CollectionUtils.isEmpty(roleIds2 = courseUserList22.stream().map(TrainingCourseUser::getRoleId).filter(Objects::nonNull).distinct().collect(Collectors.toList())) || (baseResult2 = this.useApi.getUserByRoleIds(roleIdStr2 = StringUtils.join(roleIds2, (String)","), push.getEnterpriseId())) == null || CollectionUtils.isEmpty((Collection)((Collection)baseResult2.getData())))) {
                    List pojo2 = ((List)baseResult2.getData()).stream().map(com.ovopark.privilege.pojo.UsersPojo::getId).distinct().collect(Collectors.toList());
                    allUserIdList.addAll(pojo2);
                }
                LambdaQueryWrapper wrapper3 = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper3.eq(TrainingCourseUser::getCourseId, (Object)push.getCourseId())).eq(TrainingCourseUser::getCourseType, (Object)1)).isNotNull(TrainingCourseUser::getOrganizeId);
                List courseUserList3 = this.courseUserMapper.selectList((Wrapper)wrapper3);
                if (!CollectionUtils.isEmpty((Collection)courseUserList3) && !CollectionUtils.isEmpty(orgIds2 = courseUserList3.stream().map(TrainingCourseUser::getOrganizeId).filter(Objects::nonNull).distinct().collect(Collectors.toList()))) {
                    UsersAndOrgsMo mo2 = new UsersAndOrgsMo();
                    mo2.setGroupId(push.getEnterpriseId());
                    mo2.setOrganizeIds(orgIds2);
                    BaseResult baseResult3 = this.userOrganizeApi.getUserByOrganizeIdsOrDepId(mo2);
                    if (!baseResult3.getIsError().booleanValue() && !CollectionUtils.isEmpty((Collection)((Collection)baseResult3.getData()))) {
                        List users2 = ((List)baseResult3.getData()).stream().map(UserAndParentNameMo::getUserId).distinct().collect(Collectors.toList());
                        allUserIdList.addAll(users2);
                    }
                }
                LambdaQueryWrapper wrapper4 = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper4.eq(TrainingCourseUser::getCourseId, (Object)push.getCourseId())).eq(TrainingCourseUser::getCourseType, (Object)1)).isNotNull(TrainingCourseUser::getTagId);
                List courseUserList4 = this.courseUserMapper.selectList((Wrapper)wrapper4);
                if (!CollectionUtils.isEmpty((Collection)courseUserList4) && !CollectionUtils.isEmpty(list = courseUserList4.stream().map(TrainingCourseUser::getTagId).filter(Objects::nonNull).distinct().collect(Collectors.toList()))) {
                    DepAndTagsPojo pojo3 = new DepAndTagsPojo();
                    pojo3.setGroupId(push.getEnterpriseId());
                    pojo3.setTagIds(list);
                    pojo3.setUserId(push.getPushUserId());
                    BaseResult tagResult2 = this.tagApi.getUsersByTags(pojo3);
                    if (!tagResult2.getIsError().booleanValue() && !CollectionUtils.isEmpty((Collection)((Collection)tagResult2.getData()))) {
                        for (Map map : (List)tagResult2.getData()) {
                            Integer id2 = (Integer)map.get("id");
                            allUserIdList.add(id2);
                        }
                    }
                }
                allUserIdList = allUserIdList.stream().distinct().collect(Collectors.toList());
            } else {
                List base2 = (List)this.userApi.getSimpleUserByKeyWord(push.getEnterpriseId(), null, null).getData();
                allUserIdList = base2.stream().map(SimplePojo::getId).collect(Collectors.toList());
            }
            LambdaQueryWrapper wrapperU = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapperU.eq(TrainingPaperUserTurns::getProjectId, (Object)push.getCourseId())).eq(TrainingPaperUserTurns::getTurnType, (Object)4)).orderByDesc(TrainingPaperUserTurns::getTurns);
            List paperUserTurns = this.paperUserTurnsMapper.selectList((Wrapper)wrapperU);
            Map<Object, Object> turnMap = new HashMap();
            if (!CollectionUtils.isEmpty((Collection)paperUserTurns)) {
                turnMap = paperUserTurns.stream().collect(Collectors.groupingBy(TrainingPaperUserTurns::getUserId));
            }
            LambdaQueryWrapper wrapper3 = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper3.eq(TrainingCourseUserTask::getCourseId, (Object)push.getCourseId())).in(TrainingCourseUserTask::getTaskStatus, Arrays.asList(3, 4))).orderByDesc(TrainingCourseUserTask::getTurns);
            List finishList = this.courseUserTaskMapper.selectList((Wrapper)wrapper3);
            Map<Object, Object> userTaskMap = new HashMap();
            if (!CollectionUtils.isEmpty((Collection)finishList)) {
                ArrayList<TrainingCourseUserTask> delList = new ArrayList<TrainingCourseUserTask>();
                block9: for (TrainingCourseUserTask trainingCourseUserTask : finishList) {
                    TrainingCourseStageTask task = (TrainingCourseStageTask)stageTasksMap.get(trainingCourseUserTask.getTaskId());
                    List paperUserTurnsList = (List)turnMap.get(trainingCourseUserTask.getUserId());
                    if (!CollectionUtils.isEmpty((Collection)paperUserTurnsList)) {
                        for (TrainingPaperUserTurns userTurns : paperUserTurnsList) {
                            if (task.getStageId().intValue() != userTurns.getStageId().intValue() || trainingCourseUserTask.getTurns().intValue() == userTurns.getTurns().intValue()) continue;
                            delList.add(trainingCourseUserTask);
                            continue block9;
                        }
                        continue;
                    }
                    if (trainingCourseUserTask.getTurns() == 1) continue;
                    delList.add(trainingCourseUserTask);
                }
                if (!CollectionUtils.isEmpty(delList)) {
                    finishList.removeAll(delList);
                }
                userTaskMap = finishList.stream().collect(Collectors.groupingBy(TrainingCourseUserTask::getUserId));
            }
            ArrayList<Integer> onList = new ArrayList<Integer>();
            if (!CollectionUtils.isEmpty((Collection)finishList)) {
                ArrayList<Integer> overList = new ArrayList<Integer>();
                if (!CollectionUtils.isEmpty((Collection)finishList)) {
                    List list = finishList.stream().map(TrainingCourseUserTask::getUserId).distinct().collect(Collectors.toList());
                    block11: for (Integer userId : list) {
                        List userTasks = (List)userTaskMap.get(userId);
                        if (userTasks.size() < n) continue;
                        onList.add(userId);
                        for (TrainingCourseUserTask userTask : userTasks) {
                            if (userTask.getTaskStatus() != 4) continue;
                            overList.add(userId);
                            continue block11;
                        }
                    }
                }
            }
            allUserIdList.removeAll(onList);
            for (Integer n2 : allUserIdList) {
                WorkNotifyVo vo2 = new WorkNotifyVo();
                vo2.setTitle(push.getPushTitle());
                vo2.setId(push.getCourseId());
                TaskMessageBody body2 = new TaskMessageBody();
                body2.setType(98);
                body2.setTaskJson(JSONObject.toJSONString((Object)vo2));
                try {
                    this.jPushService.sendWebSocket(push.getPushTitle(), push.getPushContent(), n2, push.getEnterpriseId(), push.getId(), "TYPE_TRAINING_COURSE_PUSH", JSONObject.toJSONString((Object)vo2), new Date(), 1, 0, null, null);
                    this.jPushService.pushNotification(JPush.MASSAGE_TYPE_NOTIFY, "TYPE_TRAINING_COURSE_PUSH", n2, push.getPushTitle(), push.getPushContent(), body2);
                    TrainingCoursePushUser pushUser2 = new TrainingCoursePushUser();
                    pushUser2.setPushTime(new Date());
                    pushUser2.setCoursePushId(push.getId());
                    pushUser2.setUserId(n2);
                    pushUser2.setIsSuccess(Integer.valueOf(1));
                    this.trainingCoursePushUserMapper.insert(pushUser2);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        if (push.getPushType().equals(2)) {
            userIdList = new ArrayList();
            course = (TrainingCourse)this.courseMapper.selectById(push.getCourseId());
            if (!org.springframework.util.StringUtils.isEmpty((Object)course.getAppointType()) && course.getAppointType() == 1) {
                wrapper1 = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)wrapper1.eq(TrainingCourseUser::getCourseId, (Object)course.getId())).eq(TrainingCourseUser::getCourseType, (Object)1);
                List list = this.courseUserMapper.selectList((Wrapper)wrapper1);
                if (!CollectionUtils.isEmpty((Collection)list)) {
                    userIds = list.stream().map(TrainingCourseUser::getUserId).distinct().filter(Objects::nonNull).collect(Collectors.toList());
                    if (!CollectionUtils.isEmpty(userIds)) {
                        userIdList.addAll(userIds);
                    }
                    if (!CollectionUtils.isEmpty(roleIds = list.stream().map(TrainingCourseUser::getRoleId).filter(Objects::nonNull).distinct().collect(Collectors.toList())) && (baseResult = this.useApi.getUserByRoleIds(roleIdStr = StringUtils.join(roleIds, (String)","), push.getEnterpriseId())) != null && !CollectionUtils.isEmpty((Collection)((Collection)baseResult.getData()))) {
                        pojo = ((List)baseResult.getData()).stream().map(com.ovopark.privilege.pojo.UsersPojo::getId).distinct().collect(Collectors.toList());
                        userIdList.addAll((Collection<Object>)pojo);
                    }
                    if (!CollectionUtils.isEmpty(orgIds = list.stream().map(TrainingCourseUser::getOrganizeId).filter(Objects::nonNull).distinct().collect(Collectors.toList()))) {
                        mo = new UsersAndOrgsMo();
                        mo.setGroupId(push.getEnterpriseId());
                        mo.setOrganizeIds(orgIds);
                        userResult = this.userOrganizeApi.getUserByOrganizeIdsOrDepId(mo);
                        if (!userResult.getIsError().booleanValue() && !CollectionUtils.isEmpty((Collection)((Collection)userResult.getData()))) {
                            users = ((List)userResult.getData()).stream().map(UserAndParentNameMo::getUserId).distinct().collect(Collectors.toList());
                            userIdList.addAll(users);
                        }
                    }
                    if (!CollectionUtils.isEmpty(tagIds = list.stream().map(TrainingCourseUser::getTagId).filter(Objects::nonNull).distinct().collect(Collectors.toList()))) {
                        pojo = new DepAndTagsPojo();
                        pojo.setGroupId(push.getEnterpriseId());
                        pojo.setTagIds(tagIds);
                        pojo.setUserId(push.getPushUserId());
                        tagResult = this.tagApi.getUsersByTags(pojo);
                        if (!tagResult.getIsError().booleanValue() && !CollectionUtils.isEmpty((Collection)((Collection)tagResult.getData()))) {
                            for (Map map : (List)tagResult.getData()) {
                                id = (Integer)map.get("id");
                                userIdList.add(id);
                            }
                        }
                    }
                    userIdList = userIdList.stream().distinct().collect(Collectors.toList());
                    if (course.getStatus() != 3 && !Objects.isNull(simplePojoBaseResult = this.userApi.getSimpleUserByKeyWord(push.getEnterpriseId(), null, null)) && !CollectionUtils.isEmpty((Collection)((Collection)simplePojoBaseResult.getData()))) {
                        userIdList.retainAll(((List)simplePojoBaseResult.getData()).stream().map(SimplePojo::getId).distinct().collect(Collectors.toList()));
                    }
                }
            } else {
                base = (List)this.userApi.getSimpleUserByKeyWord(push.getEnterpriseId(), null, null).getData();
                userIdList = base.stream().map(SimplePojo::getId).collect(Collectors.toList());
            }
            if (!CollectionUtils.isEmpty((Collection)push.getUserIdList())) {
                for (Integer n : push.getUserIdList()) {
                    vo = new WorkNotifyVo();
                    vo.setTitle(push.getPushTitle());
                    vo.setId(push.getCourseId());
                    if (!userIdList.contains(n)) {
                        vo.setIsContain(Integer.valueOf(0));
                    }
                    body = new TaskMessageBody();
                    body.setType(98);
                    body.setTaskJson(JSONObject.toJSONString((Object)vo));
                    try {
                        this.jPushService.sendWebSocket(push.getPushTitle(), push.getPushContent(), n, push.getEnterpriseId(), push.getId(), "TYPE_TRAINING_COURSE_PUSH", JSONObject.toJSONString((Object)vo), new Date(), 1, 0, null, null);
                        this.jPushService.pushNotification(JPush.MASSAGE_TYPE_NOTIFY, "TYPE_TRAINING_COURSE_PUSH", n, push.getPushTitle(), push.getPushContent(), body);
                        pushUser = new TrainingCoursePushUser();
                        pushUser.setPushTime(new Date());
                        pushUser.setCoursePushId(push.getId());
                        pushUser.setUserId(n);
                        pushUser.setIsSuccess(Integer.valueOf(1));
                        this.trainingCoursePushUserMapper.insert(pushUser);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return JsonResult.success();
    }

    @Override
    public String getCoursePushList(Integer courseId) {
        ArrayList<CoursePushListVo> result = new ArrayList<CoursePushListVo>();
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(TrainingCoursePush::getCourseId, (Object)courseId);
        wrapper.orderByDesc(TrainingCoursePush::getPushTime);
        List pushList = this.trainingCoursePushMapper.selectList((Wrapper)wrapper);
        if (!CollectionUtils.isEmpty((Collection)pushList)) {
            for (TrainingCoursePush push : pushList) {
                CoursePushListVo vo = new CoursePushListVo();
                BaseResult userResult = this.userApi.getUserById(push.getPushUserId());
                if (!userResult.getIsError().booleanValue() && userResult.getData() != null) {
                    UsersPojo pojo = (UsersPojo)userResult.getData();
                    vo.setPushUserName(pojo.getShowName());
                }
                vo.setPushTime(push.getPushTime());
                vo.setPushType(push.getPushType());
                LambdaQueryWrapper userWrapper = new LambdaQueryWrapper();
                userWrapper.eq(TrainingCoursePushUser::getCoursePushId, (Object)push.getId());
                List pushUserList = this.trainingCoursePushUserMapper.selectList((Wrapper)userWrapper);
                vo.setCoursePushId(push.getId());
                vo.setPushNum(pushUserList.size());
                vo.setSuccessNum(pushUserList.size());
                vo.setPushStatus(push.getPushStatus().intValue());
                vo.setPushContent(push.getPushContent());
                result.add(vo);
            }
        }
        return JsonResult.success(result);
    }

    @Override
    public String getCoursePushUserByPage(Users user, Page<CoursePushUserVo> page, Integer coursePushId, String userName, Integer isSuccess) {
        Map<String, Object> userMap;
        List userIds = null;
        if (!org.springframework.util.StringUtils.isEmpty((Object)userName) && CollectionUtils.isEmpty((Collection)(userIds = (List)(userMap = this.userUtilService.getCheckParameters(userName, null, null, user)).get("userList")))) {
            return JsonResult.success(page);
        }
        ArrayList<CoursePushUserVo> result = new ArrayList<CoursePushUserVo>();
        List<TrainingCoursePushUser> pushUserList = this.trainingCoursePushUserMapper.selectByPage(page, coursePushId, userIds, isSuccess);
        if (!CollectionUtils.isEmpty(pushUserList)) {
            List<Integer> pushUserIdList = pushUserList.stream().map(TrainingCoursePushUser::getUserId).collect(Collectors.toList());
            Map userRoleMap = new HashMap();
            if (!CollectionUtils.isEmpty(pushUserIdList)) {
                HashMap<String, Object> parameter = new HashMap<String, Object>();
                parameter.put("userIds", StringUtils.join(pushUserIdList, (String)","));
                parameter.put("groupId", user.getGroupId());
                com.ovopark.privilege.response.BaseResult base = this.roleApi.getUserRoleList(parameter);
                if (base != null) {
                    userRoleMap = (Map)base.getData();
                }
            }
            Map<Integer, UserDutiesMo> dutiesMap = this.userUtilService.selectDutiesMap(pushUserIdList, user.getGroupId());
            Map<Integer, String> parentMap = this.userUtilService.selectParentMap(pushUserIdList, user.getGroupId());
            Map<Integer, Integer> parentIdMap = this.userUtilService.selectParentIdMap(pushUserIdList, user.getGroupId());
            for (TrainingCoursePushUser pushUser : pushUserList) {
                CoursePushUserVo vo = new CoursePushUserVo();
                BaseResult userResult = this.userApi.getUserById(pushUser.getUserId());
                if (!userResult.getIsError().booleanValue() && userResult.getData() != null) {
                    UsersPojo pojo = (UsersPojo)userResult.getData();
                    vo.setUserName(pojo.getShowName());
                    vo.setEmployeeNumber(pojo.getEmployeeNumber());
                    ArrayList<Integer> userIdList = new ArrayList<Integer>();
                    userIdList.add(pushUser.getUserId());
                    Map<Integer, List<String>> organizeMap = this.userUtilService.selectOrganizeMap(userIdList, user.getGroupId());
                    if (!CollectionUtils.isEmpty(organizeMap)) {
                        vo.setOrganizes(String.join((CharSequence)";\n", (Iterable<? extends CharSequence>)organizeMap.get(pushUser.getUserId())));
                    }
                    vo.setIsSuccess(pushUser.getIsSuccess());
                }
                if (!CollectionUtils.isEmpty((Collection)((Collection)userRoleMap.get(pushUser.getUserId())))) {
                    StringBuilder role = new StringBuilder();
                    for (RolePojo rolePojo : (List)userRoleMap.get(pushUser.getUserId())) {
                        role.append(rolePojo.getRoleName()).append(";\n");
                    }
                    vo.setRole(role.substring(0, role.length() - 2));
                }
                if (!CollectionUtils.isEmpty(dutiesMap) && dutiesMap.get(pushUser.getUserId()) != null) {
                    vo.setPost(dutiesMap.get(pushUser.getUserId()).getDutieName());
                }
                if (!CollectionUtils.isEmpty(parentMap)) {
                    vo.setParentName(parentMap.get(pushUser.getUserId()));
                }
                if (!CollectionUtils.isEmpty(parentIdMap)) {
                    vo.setParentUserId(parentIdMap.get(pushUser.getUserId()));
                }
                result.add(vo);
            }
        }
        page.setContent(result);
        return JsonResult.success(page);
    }

    @Override
    public String getCoursePushNum(Users user, Integer coursePushId, String userName) {
        List totalList;
        Map<String, Object> userMap;
        CoursePushNumVo result = new CoursePushNumVo();
        List userIds = null;
        if (!org.springframework.util.StringUtils.isEmpty((Object)userName) && CollectionUtils.isEmpty((Collection)(userIds = (List)(userMap = this.userUtilService.getCheckParameters(userName, null, null, user)).get("userList")))) {
            return JsonResult.success((Object)result);
        }
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(TrainingCoursePushUser::getCoursePushId, (Object)coursePushId);
        if (!CollectionUtils.isEmpty(userIds)) {
            wrapper.in(TrainingCoursePushUser::getUserId, (Collection)userIds);
        }
        if (!CollectionUtils.isEmpty((Collection)(totalList = this.trainingCoursePushUserMapper.selectList((Wrapper)wrapper)))) {
            result.setTotalNum(totalList.size());
            result.setSuccessNum(totalList.size());
        }
        return JsonResult.success((Object)result);
    }

    @Override
    public String vaildPush(Integer enterpriseId, Integer courseId) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(TrainingCoursePush::getEnterpriseId, (Object)enterpriseId);
        wrapper.eq(TrainingCoursePush::getCourseId, (Object)courseId);
        wrapper.between(TrainingCoursePush::getPushTime, (Object)DateUtils.getStartTimeOfDay(new Date()), (Object)DateUtils.getEndTimeOfDay(new Date()));
        List list = this.trainingCoursePushMapper.selectList((Wrapper)wrapper);
        if (!CollectionUtils.isEmpty((Collection)list)) {
            return JsonResult.success((Object)(2 - list.size()));
        }
        return JsonResult.success((Object)2);
    }

    @Override
    public PaperAnalyseVo selectCoursePaperAnalyse(CourseAnalyseSearchVo vo) {
        PaperAnalyseVo paperAnalyseVo = new PaperAnalyseVo();
        Locale locale = Authenticator.getInstance().getCurrentClient().getLocale();
        TrainingPaper trainingPaper = (TrainingPaper)this.trainingPaperMapper.selectById(Integer.valueOf(vo.getPaperId()));
        paperAnalyseVo.setPaperName(trainingPaper.getTitle());
        TrainingExam trainingExam = (TrainingExam)this.trainingExamMapper.selectById(trainingPaper.getExamId());
        LambdaQueryWrapper queryWrapper2 = new LambdaQueryWrapper();
        queryWrapper2.ne(TrainingUserPaper::getSubmitTime, (Object)JDBCType.NULL);
        queryWrapper2.eq(TrainingUserPaper::getSourceProjectId, (Object)vo.getCourseId());
        queryWrapper2.eq(TrainingUserPaper::getSourceTaskId, (Object)vo.getTaskId());
        List userPaperList = this.trainingUserPaperMapper.selectList((Wrapper)queryWrapper2);
        if (CollectionUtils.isEmpty((Collection)userPaperList)) {
            paperAnalyseVo.setPaperAnalyseList(Collections.emptyList());
            return paperAnalyseVo;
        }
        List userPaperIdList = userPaperList.stream().map(TrainingUserPaper::getId).collect(Collectors.toList());
        LambdaQueryWrapper queryWrapper3 = new LambdaQueryWrapper();
        queryWrapper3.in(!CollectionUtils.isEmpty(userPaperIdList), TrainingUserQuestion::getUserPaperId, userPaperIdList);
        queryWrapper3.like(Objects.nonNull(vo.getQuestionName()), TrainingUserQuestion::getName, (Object)vo.getQuestionName());
        List trainingUserQuestionList = this.trainingUserQuestionMapper.selectList((Wrapper)queryWrapper3);
        Map<Integer, List<TrainingUserQuestion>> questionMap = trainingUserQuestionList.stream().collect(Collectors.groupingBy(TrainingUserQuestion::getQuestionId));
        ArrayList<PaperAnalyse> dataList = new ArrayList<PaperAnalyse>();
        AtomicInteger sort = new AtomicInteger(0);
        for (Map.Entry<Integer, List<TrainingUserQuestion>> entry : questionMap.entrySet()) {
            PaperAnalyse paperAnalyse = new PaperAnalyse();
            paperAnalyse.setSort(sort.incrementAndGet());
            List<TrainingUserQuestion> paperAnalyseList = entry.getValue();
            paperAnalyse.setId(paperAnalyseList.get(0).getId().intValue());
            List analyseCount = paperAnalyseList.stream().filter(e -> e.getIsEmpty() == 0).collect(Collectors.toList());
            List analyseRight = paperAnalyseList.stream().filter(e -> e.getIsCorrect() == 1).collect(Collectors.toList());
            paperAnalyse.setAnswerUser(analyseCount.size());
            paperAnalyse.setAnswerRightUser(analyseRight.size());
            if (analyseCount.size() == 0) {
                paperAnalyse.setAnswerRightRate("-");
                paperAnalyse.setAnswerRight(new BigDecimal(-1));
            }
            paperAnalyse.setAnswerRightRate(this.computeProportion2(analyseRight.size(), analyseCount.size()));
            paperAnalyse.setAnswerRight(this.computeProportion3(analyseRight.size(), analyseCount.size()));
            int questionType = paperAnalyseList.get(0).getQuestionType();
            String typeName = "";
            if (questionType == 0) {
                paperAnalyse.setOrder(1);
                typeName = this.messageSource.getMessage("training.user.details.singleChoiceQuestion", null, locale);
            } else if (questionType == 3) {
                paperAnalyse.setOrder(2);
                typeName = this.messageSource.getMessage("training.user.details.multipleChoiceQuestion", null, locale);
            } else if (questionType == 4) {
                paperAnalyse.setOrder(3);
                typeName = this.messageSource.getMessage("training.user.details.trueOrFalseQuestions", null, locale);
            } else if (questionType == 2) {
                paperAnalyse.setOrder(4);
                typeName = this.messageSource.getMessage("training.user.details.fillBlankQuestion", null, locale);
            } else if (questionType == 1) {
                paperAnalyse.setOrder(5);
                typeName = this.messageSource.getMessage("training.user.details.essayQuestion", null, locale);
            } else {
                paperAnalyse.setOrder(6);
            }
            paperAnalyse.setType(typeName);
            if (trainingExam.getExamClass() == 1) {
                TrainingExamQuestion examQuestion = (TrainingExamQuestion)this.trainingExamQuestionMapper.selectById(entry.getKey());
                TrainingQuestion question = (TrainingQuestion)this.trainingQuestionMapper.selectById(examQuestion.getQuestionId());
                if (Objects.isNull(question.getTypeId())) {
                    paperAnalyse.setQuestionType("");
                } else {
                    paperAnalyse.setQuestionType(((TrainingQuestionType)this.trainingQuestionTypeMapper.selectById(question.getTypeId())).getTitle());
                }
                paperAnalyse.setName(question.getName());
            } else {
                TrainingQuestion question = (TrainingQuestion)this.trainingQuestionMapper.selectById(entry.getKey());
                if (Objects.isNull(question.getTypeId())) {
                    paperAnalyse.setQuestionType("");
                } else {
                    paperAnalyse.setQuestionType(((TrainingQuestionType)this.trainingQuestionTypeMapper.selectById(question.getTypeId())).getTitle());
                }
                paperAnalyse.setName(question.getName());
            }
            dataList.add(paperAnalyse);
        }
        List<Object> temp = new ArrayList();
        temp = trainingExam.getExamClass() == 1 ? dataList.stream().sorted(Comparator.comparing(PaperAnalyse::getId)).collect(Collectors.toList()) : dataList.stream().sorted(Comparator.comparing(PaperAnalyse::getOrder).thenComparing(PaperAnalyse::getId)).collect(Collectors.toList());
        if (vo.getOrderBy() != 0 && vo.getOrderBy() == 1) {
            temp = vo.getOrder() == 1 ? dataList.stream().sorted(Comparator.comparing(PaperAnalyse::getAnswerRight)).collect(Collectors.toList()) : dataList.stream().sorted(Comparator.comparing(PaperAnalyse::getAnswerRight).reversed()).collect(Collectors.toList());
        }
        for (int i = 0; i < temp.size(); ++i) {
            ((PaperAnalyse)temp.get(i)).setSort(i + 1);
        }
        paperAnalyseVo.setPaperAnalyseList(temp);
        return paperAnalyseVo;
    }

    @Override
    public void selectCourseAnalyseByExcel(HttpServletResponse response, CourseAnalyseSearchVo vo) {
        Locale locale = Authenticator.getInstance().getCurrentClient().getLocale();
        TrainingCourse trainingCourse = (TrainingCourse)this.trainingCourseMapper.selectById(Integer.valueOf(vo.getCourseId()));
        PaperAnalyseVo paperAnalyseVo = this.selectCoursePaperAnalyse(vo);
        if (Objects.isNull(paperAnalyseVo)) {
            return;
        }
        String fileName = MessageFormat.format("{0}_{1}.xlsx", trainingCourse.getCourseName(), this.messageSource.getMessage("training.question.detail", null, locale));
        HSSFWorkbook wb = new HSSFWorkbook();
        HSSFSheet sheet = wb.createSheet(fileName);
        HSSFCellStyle titleSty = wb.createCellStyle();
        HSSFFont font = wb.createFont();
        font.setFontHeightInPoints((short)16);
        titleSty.setFont((Font)font);
        HSSFRow row = sheet.createRow(0);
        row.createCell(0).setCellValue(this.messageSource.getMessage("training.project.number", null, locale));
        row.createCell(1).setCellValue(this.messageSource.getMessage("training.paper.topic", null, locale));
        row.createCell(2).setCellValue(this.messageSource.getMessage("training.user.details.type", null, locale));
        row.createCell(3).setCellValue(this.messageSource.getMessage("training.user.subject.bank", null, locale));
        String answerNum = this.messageSource.getMessage("training.course.answer.num", null, locale);
        row.createCell(4).setCellValue(answerNum);
        String answerRightNum = this.messageSource.getMessage("training.course.answer.right.num", null, locale);
        row.createCell(5).setCellValue(answerRightNum);
        row.createCell(6).setCellValue(this.messageSource.getMessage("training.course.answer.num", null, locale));
        List paperAnalyseList = paperAnalyseVo.getPaperAnalyseList();
        for (int i = 0; i < paperAnalyseList.size(); ++i) {
            row = sheet.createRow(i + 1);
            PaperAnalyse paperAnalyse = (PaperAnalyse)paperAnalyseList.get(i);
            row.createCell(0).setCellValue((double)paperAnalyse.getSort());
            row.createCell(1).setCellValue(paperAnalyse.getName());
            row.createCell(2).setCellValue(paperAnalyse.getType());
            row.createCell(3).setCellValue(paperAnalyse.getQuestionType());
            row.createCell(4).setCellValue((double)paperAnalyse.getAnswerUser());
            row.createCell(5).setCellValue((double)paperAnalyse.getAnswerRightUser());
            row.createCell(6).setCellValue(paperAnalyse.getAnswerRightRate());
        }
        try {
            response.setContentType("application/vnd.ms-excel; charset=utf-8");
            response.setHeader("Content-Disposition", "attachment; filename=" + URLEncoder.encode(fileName, "UTF-8"));
            ServletOutputStream out = response.getOutputStream();
            wb.write((OutputStream)out);
            out.flush();
            out.close();
            wb.close();
        }
        catch (IOException e) {
            log.error(e.getMessage());
        }
    }

    private String computeProportion2(int count, int total) {
        if (total == 0) {
            return "-";
        }
        if (total < count) {
            return String.valueOf(new BigDecimal(100)).concat("%");
        }
        BigDecimal percentage = BigDecimal.valueOf(count).divide(BigDecimal.valueOf(total), 4, RoundingMode.HALF_UP).multiply(new BigDecimal(100));
        return String.valueOf(percentage.setScale(2, RoundingMode.HALF_UP)).concat("%");
    }

    private BigDecimal computeProportion3(int count, int total) {
        if (total == 0) {
            return new BigDecimal(-1);
        }
        if (total < count) {
            return new BigDecimal(100);
        }
        BigDecimal percentage = BigDecimal.valueOf(count).divide(BigDecimal.valueOf(total), 4, RoundingMode.HALF_UP).multiply(new BigDecimal(100));
        return percentage.setScale(2, RoundingMode.HALF_UP);
    }

    @Override
    public Map<String, Object> selectIsCoursePower(Integer courseId, Users user) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        int status = 0;
        List userList = new ArrayList();
        TrainingCourse trainingCourse = (TrainingCourse)this.courseMapper.selectById(courseId);
        if (!ObjectUtils.isEmpty((Object)trainingCourse) && user.getGroupId() != null && user.getGroupId().equals(trainingCourse.getEnterpriseId())) {
            if (trainingCourse.getAppointType() == 1) {
                LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
                wrapper1.eq(TrainingCourseUser::getCourseId, (Object)courseId);
                List trainingCourseUserList = this.courseUserMapper.selectList((Wrapper)wrapper1);
                if (!CollectionUtils.isEmpty((Collection)trainingCourseUserList)) {
                    ArrayList<Integer> managerIds = new ArrayList<Integer>();
                    List<Integer> roleList = this.userUtilService.selectUserRoleList(user);
                    List<Integer> tagList = this.userUtilService.selectUserTagList(user);
                    List<String> organizeList = this.userUtilService.selectUserOrganizeList(user);
                    boolean is = false;
                    for (TrainingCourseUser trainingCourseUser : trainingCourseUserList) {
                        if (trainingCourseUser.getCourseType() == 1) {
                            if (!(trainingCourseUser.getUserId() != null && trainingCourseUser.getUserId().equals(user.getId()) || trainingCourseUser.getRoleId() != null && !CollectionUtils.isEmpty(roleList) && roleList.contains(trainingCourseUser.getRoleId()) || trainingCourseUser.getTagId() != null && !CollectionUtils.isEmpty(tagList) && tagList.contains(trainingCourseUser.getTagId())) && (trainingCourseUser.getOrganizeId() == null || CollectionUtils.isEmpty(organizeList) || !organizeList.contains(trainingCourseUser.getOrganizeId()))) continue;
                            is = true;
                            continue;
                        }
                        if (trainingCourseUser.getUserId() == null) continue;
                        managerIds.add(trainingCourseUser.getUserId());
                    }
                    if (!is) {
                        BaseResult base;
                        status = 2;
                        if (!CollectionUtils.isEmpty(managerIds) && (base = this.userApi.getUserByIdList(managerIds)) != null && !CollectionUtils.isEmpty((Collection)((Collection)base.getData()))) {
                            userList = (List)base.getData();
                        }
                    }
                }
            }
        } else {
            status = 1;
        }
        map.put("status", status);
        map.put("userList", userList);
        return map;
    }

    @Override
    public TrainingCourse getTrainingCourseById(Integer courseId) {
        return (TrainingCourse)this.courseMapper.selectById(courseId);
    }
}

