/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.training.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ovopark.organize.common.model.pojo.UsersPojo;
import com.ovopark.training.bo.Page;
import com.ovopark.training.mapper.TrainingAndMaterialMapper;
import com.ovopark.training.mapper.TrainingChapterAttachMapper;
import com.ovopark.training.mapper.TrainingChapterMapper;
import com.ovopark.training.mapper.TrainingFeeChapterAttachMapper;
import com.ovopark.training.mapper.TrainingFeeChapterMapper;
import com.ovopark.training.mapper.TrainingFeeMapper;
import com.ovopark.training.mapper.TrainingHistoryMapper;
import com.ovopark.training.mapper.TrainingMapper;
import com.ovopark.training.mapper.TrainingMaterialMapper;
import com.ovopark.training.mapper.TrainingMaterialTypeMapper;
import com.ovopark.training.mapper.TrainingOrderInfoMapper;
import com.ovopark.training.model.Authenticator;
import com.ovopark.training.model.Training;
import com.ovopark.training.model.TrainingAndMaterial;
import com.ovopark.training.model.TrainingChapter;
import com.ovopark.training.model.TrainingChapterAttach;
import com.ovopark.training.model.TrainingFee;
import com.ovopark.training.model.TrainingFeeChapter;
import com.ovopark.training.model.TrainingFeeChapterAttach;
import com.ovopark.training.model.TrainingHistory;
import com.ovopark.training.model.TrainingMaterial;
import com.ovopark.training.model.TrainingMaterialType;
import com.ovopark.training.model.TrainingOrderInfo;
import com.ovopark.training.model.Users;
import com.ovopark.training.service.TrainingFeeService;
import com.ovopark.training.service.UserUtilService;
import com.ovopark.training.vo.TrainingFeeChapterAttachVo;
import com.ovopark.training.vo.TrainingFeeChapterVo;
import com.ovopark.training.vo.TrainingFeeVo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
public class TrainingFeeServiceImpl
implements TrainingFeeService {
    private static final Logger log = LoggerFactory.getLogger(TrainingFeeServiceImpl.class);
    @Autowired
    private TrainingFeeMapper trainingFeeMapper;
    @Autowired
    private TrainingFeeChapterMapper trainingFeeChapterMapper;
    @Autowired
    private TrainingFeeChapterAttachMapper trainingFeeChapterAttachMapper;
    @Autowired
    private TrainingMapper trainingMapper;
    @Autowired
    private TrainingOrderInfoMapper trainingOrderInfoMapper;
    @Autowired
    private TrainingChapterMapper trainingChapterMapper;
    @Autowired
    private TrainingChapterAttachMapper trainingChapterAttachMapper;
    @Autowired
    private TrainingMaterialMapper materialMapper;
    @Autowired
    private TrainingMaterialTypeMapper materialTypeMapper;
    @Autowired
    private TrainingAndMaterialMapper andMaterialMapper;
    @Autowired
    private UserUtilService userUtilService;
    @Autowired
    private TrainingHistoryMapper trainingHistoryMapper;
    @Autowired
    private MessageSource messageSource;

    @Override
    public void saveTrainingFee(TrainingFeeVo trainingFeeVo, Users user) {
        Date date = new Date();
        if (!StringUtils.isEmpty((Object)trainingFeeVo)) {
            if (StringUtils.isEmpty((Object)trainingFeeVo.getId())) {
                trainingFeeVo.setCreator(user.getId());
                trainingFeeVo.setStartTime(date);
                trainingFeeVo.setUpdater(user.getId());
                trainingFeeVo.setUpdateTime(date);
                this.trainingFeeMapper.insert(trainingFeeVo);
            } else {
                trainingFeeVo.setUpdater(user.getId());
                trainingFeeVo.setUpdateTime(date);
                LambdaUpdateWrapper wrapper1 = new LambdaUpdateWrapper();
                wrapper1.eq(TrainingFeeChapter::getTrainingId, (Object)trainingFeeVo.getId());
                this.trainingFeeChapterMapper.delete((Wrapper)wrapper1);
                LambdaUpdateWrapper wrapper2 = new LambdaUpdateWrapper();
                wrapper2.eq(TrainingFeeChapterAttach::getTrainingId, (Object)trainingFeeVo.getId());
                this.trainingFeeChapterAttachMapper.delete((Wrapper)wrapper2);
                this.trainingFeeMapper.updateById(trainingFeeVo);
            }
            if (!CollectionUtils.isEmpty((Collection)trainingFeeVo.getTrainingFeeChapterVoList())) {
                ArrayList<TrainingFeeChapterAttach> trainingFeeChapterAttaches = new ArrayList<TrainingFeeChapterAttach>();
                for (TrainingFeeChapterVo trainingFeeChapterVo : trainingFeeVo.getTrainingFeeChapterVoList()) {
                    trainingFeeChapterVo.setTrainingId(trainingFeeVo.getId());
                    trainingFeeChapterVo.setCreater(user.getId());
                    trainingFeeChapterVo.setCreateTime(date);
                    this.trainingFeeChapterMapper.insert(trainingFeeChapterVo);
                    if (CollectionUtils.isEmpty((Collection)trainingFeeChapterVo.getTrainingFeeChapterAttachVoList())) continue;
                    for (TrainingFeeChapterAttachVo trainingFeeChapterAttachVo : trainingFeeChapterVo.getTrainingFeeChapterAttachVoList()) {
                        TrainingFeeChapterAttach trainingFeeChapterAttach = new TrainingFeeChapterAttach();
                        BeanUtils.copyProperties((Object)trainingFeeChapterAttachVo, (Object)trainingFeeChapterAttach);
                        trainingFeeChapterAttach.setTrainingId(trainingFeeVo.getId());
                        trainingFeeChapterAttach.setChapterId(trainingFeeChapterVo.getId());
                        trainingFeeChapterAttach.setCreater(user.getId());
                        trainingFeeChapterAttach.setCreateTime(date);
                        trainingFeeChapterAttaches.add(trainingFeeChapterAttach);
                    }
                }
                if (!CollectionUtils.isEmpty(trainingFeeChapterAttaches)) {
                    this.trainingFeeChapterAttachMapper.insertList(trainingFeeChapterAttaches);
                }
            }
        }
    }

    @Override
    public TrainingFeeVo selectTrainingFeeDetail(TrainingFeeVo trainingFeeVo, Users user) {
        TrainingFee trainingFee = (TrainingFee)this.trainingFeeMapper.selectById(trainingFeeVo.getId());
        if (!StringUtils.isEmpty((Object)trainingFee)) {
            BeanUtils.copyProperties((Object)trainingFee, (Object)trainingFeeVo);
            if (!StringUtils.isEmpty((Object)trainingFeeVo.getTrainingType())) {
                TrainingMaterialType trainingMaterialType = (TrainingMaterialType)this.materialTypeMapper.selectById(trainingFeeVo.getTrainingType());
                trainingFeeVo.setTrainingTypeName(StringUtils.isEmpty((Object)trainingMaterialType) ? "" : trainingMaterialType.getMaterialTypeName());
            }
            LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)wrapper1.eq(TrainingFeeChapter::getTrainingId, (Object)trainingFeeVo.getId())).orderByAsc(TrainingFeeChapter::getChapterSort);
            List trainingFeeChapterList = this.trainingFeeChapterMapper.selectList((Wrapper)wrapper1);
            ArrayList<TrainingFeeChapterVo> trainingFeeChapterVos = new ArrayList<TrainingFeeChapterVo>();
            if (!CollectionUtils.isEmpty((Collection)trainingFeeChapterList)) {
                LambdaQueryWrapper wrapper2 = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)wrapper2.eq(TrainingFeeChapterAttach::getTrainingId, (Object)trainingFeeVo.getId())).orderByAsc(TrainingFeeChapterAttach::getAttachSort);
                List trainingFeeChapterAttacheList = this.trainingFeeChapterAttachMapper.selectList((Wrapper)wrapper2);
                Map<Object, Object> attachMap = new HashMap();
                Map<Object, Object> materialMap = new HashMap();
                if (!CollectionUtils.isEmpty((Collection)trainingFeeChapterAttacheList)) {
                    attachMap = trainingFeeChapterAttacheList.stream().collect(Collectors.groupingBy(TrainingFeeChapterAttach::getChapterId));
                    List materialIds = trainingFeeChapterAttacheList.stream().map(TrainingFeeChapterAttach::getMaterialId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
                    if (!CollectionUtils.isEmpty(materialIds)) {
                        List trainingMaterialList = this.materialMapper.selectBatchIds(materialIds);
                        materialMap = trainingMaterialList.stream().collect(Collectors.toMap(TrainingMaterial::getId, Function.identity()));
                    }
                }
                for (TrainingFeeChapter trainingFeeChapter : trainingFeeChapterList) {
                    TrainingFeeChapterVo trainingFeeChapterVo = new TrainingFeeChapterVo();
                    BeanUtils.copyProperties((Object)trainingFeeChapter, (Object)trainingFeeChapterVo);
                    List trainingFeeChapterAttachList = (List)attachMap.get(trainingFeeChapter.getId());
                    ArrayList<TrainingFeeChapterAttachVo> trainingFeeChapterAttachVoList = new ArrayList<TrainingFeeChapterAttachVo>();
                    if (!CollectionUtils.isEmpty((Collection)trainingFeeChapterAttachList)) {
                        for (TrainingFeeChapterAttach trainingFeeChapterAttach : trainingFeeChapterAttachList) {
                            TrainingMaterial trainingMaterial;
                            TrainingFeeChapterAttachVo trainingFeeChapterAttachVo = new TrainingFeeChapterAttachVo();
                            BeanUtils.copyProperties((Object)trainingFeeChapterAttach, (Object)trainingFeeChapterAttachVo);
                            if (trainingFeeChapterAttachVo.getMaterialId() != null && !ObjectUtils.isEmpty((Object)(trainingMaterial = (TrainingMaterial)materialMap.get(trainingFeeChapterAttachVo.getMaterialId())))) {
                                trainingFeeChapterAttachVo.setFileType(trainingMaterial.getFileType());
                                trainingFeeChapterAttachVo.setUrl(trainingMaterial.getMaterialPath());
                            }
                            trainingFeeChapterAttachVoList.add(trainingFeeChapterAttachVo);
                        }
                    }
                    trainingFeeChapterVo.setTrainingFeeChapterAttachVoList(trainingFeeChapterAttachVoList);
                    trainingFeeChapterVos.add(trainingFeeChapterVo);
                }
            }
            trainingFeeVo.setTrainingFeeChapterVoList(trainingFeeChapterVos);
        }
        return trainingFeeVo;
    }

    @Override
    public Integer saveCopyTrainingFee(Integer trainingFeeId, Users user) {
        Date date = new Date();
        Training training = new Training();
        TrainingFee trainingFee = (TrainingFee)this.trainingFeeMapper.selectById(trainingFeeId);
        if (!StringUtils.isEmpty((Object)trainingFee)) {
            Locale locale = Authenticator.getInstance().getCurrentClient().getLocale();
            LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper1.eq(TrainingMaterialType::getEnterpriseId, (Object)user.getGroupId())).eq(TrainingMaterialType::getIsTrade, (Object)2)).eq(TrainingMaterialType::getMaterialTypeLevel, (Object)1);
            List trainingMaterialTypeList = this.materialTypeMapper.selectList((Wrapper)wrapper1);
            Integer materialTypeId = null;
            if (CollectionUtils.isEmpty((Collection)trainingMaterialTypeList)) {
                TrainingMaterialType trainingMaterialType = new TrainingMaterialType();
                trainingMaterialType.setMaterialTypeLevel(Integer.valueOf(1));
                trainingMaterialType.setMaterialTypeName(this.messageSource.getMessage("training.learn.platform.subject", null, locale));
                trainingMaterialType.setEnterpriseId(user.getGroupId());
                trainingMaterialType.setCreater(user.getId());
                trainingMaterialType.setCreateTime(date);
                trainingMaterialType.setUpdater(user.getId());
                trainingMaterialType.setUpdateTime(date);
                trainingMaterialType.setModuleType(Integer.valueOf(5));
                trainingMaterialType.setIsTrade(Integer.valueOf(2));
                Integer sort = Integer.MAX_VALUE;
                trainingMaterialType.setSort(sort);
                this.materialTypeMapper.insert(trainingMaterialType);
                materialTypeId = trainingMaterialType.getId();
            } else {
                materialTypeId = ((TrainingMaterialType)trainingMaterialTypeList.get(0)).getId();
            }
            BeanUtils.copyProperties((Object)trainingFee, (Object)training);
            training.setTrainingType(materialTypeId);
            training.setEnterpriseId(user.getGroupId());
            training.setCreator(user.getId());
            training.setStartTime(date);
            training.setUpdateTime(date);
            training.setIsChapter(Integer.valueOf(1));
            training.setSourceType(Integer.valueOf(2));
            training.setAddType(Integer.valueOf(1));
            training.setProjectShow(Integer.valueOf(5));
            training.setTrainingFeeId(trainingFeeId);
            this.trainingMapper.insert(training);
            LambdaQueryWrapper wrapper3 = new LambdaQueryWrapper();
            wrapper3.eq(TrainingFeeChapter::getTrainingId, (Object)trainingFeeId);
            List trainingFeeChapterList = this.trainingFeeChapterMapper.selectList((Wrapper)wrapper3);
            if (!CollectionUtils.isEmpty((Collection)trainingFeeChapterList)) {
                LambdaQueryWrapper wrapper4 = new LambdaQueryWrapper();
                wrapper4.eq(TrainingFeeChapterAttach::getTrainingId, (Object)trainingFeeId);
                List trainingFeeChapterAttachList = this.trainingFeeChapterAttachMapper.selectList((Wrapper)wrapper4);
                Map<Object, Object> attachMap = new HashMap();
                Map<Object, Object> materialMap = new HashMap();
                if (!CollectionUtils.isEmpty((Collection)trainingFeeChapterAttachList)) {
                    attachMap = trainingFeeChapterAttachList.stream().collect(Collectors.toMap(TrainingFeeChapterAttach::getChapterId, e -> new ArrayList<TrainingFeeChapterAttach>(Arrays.asList(e)), (oldList, newList) -> {
                        oldList.addAll(newList);
                        return oldList;
                    }));
                    List materialIdList = trainingFeeChapterAttachList.stream().map(TrainingFeeChapterAttach::getMaterialId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
                    if (!CollectionUtils.isEmpty(materialIdList)) {
                        List materialList = this.materialMapper.selectBatchIds(materialIdList);
                        materialMap = materialList.stream().collect(Collectors.toMap(TrainingMaterial::getId, Function.identity()));
                    }
                }
                ArrayList<TrainingChapterAttach> trainingChapterAttachList = new ArrayList<TrainingChapterAttach>();
                ArrayList<TrainingAndMaterial> trainingAndMaterialList = new ArrayList<TrainingAndMaterial>();
                for (TrainingFeeChapter trainingFeeChapter : trainingFeeChapterList) {
                    TrainingChapter trainingChapter = new TrainingChapter();
                    BeanUtils.copyProperties((Object)trainingFeeChapter, (Object)trainingChapter);
                    trainingChapter.setTrainingId(training.getId());
                    trainingChapter.setCreateTime(date);
                    this.trainingChapterMapper.insert(trainingChapter);
                    List trainingFeeChapterAttaches = (List)attachMap.get(trainingFeeChapter.getId());
                    if (CollectionUtils.isEmpty((Collection)trainingFeeChapterAttaches)) continue;
                    for (TrainingFeeChapterAttach trainingFeeChapterAttach : trainingFeeChapterAttaches) {
                        TrainingChapterAttach trainingChapterAttach = new TrainingChapterAttach();
                        BeanUtils.copyProperties((Object)trainingFeeChapterAttach, (Object)trainingChapterAttach);
                        trainingChapterAttach.setId(null);
                        trainingChapterAttach.setTrainingId(training.getId());
                        trainingChapterAttach.setChapterId(trainingChapter.getId());
                        trainingChapterAttach.setCreateTime(date);
                        trainingChapterAttach.setEnterpriseId(user.getGroupId());
                        if (!StringUtils.isEmpty((Object)trainingFeeChapterAttach.getMaterialId()) && !StringUtils.isEmpty((Object)materialMap.get(trainingFeeChapterAttach.getMaterialId()))) {
                            trainingChapterAttach.setUrl(((TrainingMaterial)materialMap.get(trainingFeeChapterAttach.getMaterialId())).getMaterialPath());
                            TrainingAndMaterial trainingAndMaterial = new TrainingAndMaterial();
                            trainingAndMaterial.setTrainingId(training.getId());
                            trainingAndMaterial.setChapterId(trainingChapter.getId());
                            trainingAndMaterial.setMaterialId(trainingFeeChapterAttach.getMaterialId());
                            trainingAndMaterial.setCreateTime(date);
                            trainingAndMaterial.setCreater(user.getId());
                            trainingAndMaterialList.add(trainingAndMaterial);
                        }
                        trainingChapterAttachList.add(trainingChapterAttach);
                    }
                }
                if (!CollectionUtils.isEmpty(trainingChapterAttachList)) {
                    this.trainingChapterAttachMapper.insertList(trainingChapterAttachList);
                }
                if (!CollectionUtils.isEmpty(trainingAndMaterialList)) {
                    this.andMaterialMapper.insertList(trainingAndMaterialList);
                }
            }
        }
        return training.getId();
    }

    @Override
    public Page<TrainingFeeVo> selectTrainingFeeByPage(TrainingFeeVo trainingFeeVo, Users user) {
        Page page = new Page();
        page.setPageNumber(trainingFeeVo.getPageNumber().intValue());
        page.setPageSize(trainingFeeVo.getPageSize().intValue());
        List<TrainingFeeVo> trainingFeeVoList = this.trainingFeeMapper.selectTrainingFeeByPage((Page<TrainingFeeVo>)page, trainingFeeVo.getTitle(), trainingFeeVo.getTrainingType(), trainingFeeVo.getStatus(), trainingFeeVo.getFeeWay(), trainingFeeVo.getCreator(), trainingFeeVo.getBeginDate(), trainingFeeVo.getEndDate());
        if (!CollectionUtils.isEmpty(trainingFeeVoList)) {
            List trainingMaterialTypeList;
            List<Integer> updaters = trainingFeeVoList.stream().map(TrainingFee::getUpdater).distinct().collect(Collectors.toList());
            Map<Integer, UsersPojo> pojoMap = this.userUtilService.selectUserMap(updaters);
            List trainingFeeIds = trainingFeeVoList.stream().map(TrainingFee::getId).distinct().collect(Collectors.toList());
            LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
            wrapper1.in(TrainingFeeChapterAttach::getTrainingId, trainingFeeIds);
            List trainingFeeChapterAttaches = this.trainingFeeChapterAttachMapper.selectList((Wrapper)wrapper1);
            Map<Object, Object> attachMap = new HashMap();
            if (!CollectionUtils.isEmpty((Collection)trainingFeeChapterAttaches)) {
                attachMap = trainingFeeChapterAttaches.stream().collect(Collectors.toMap(TrainingFeeChapterAttach::getTrainingId, e -> new ArrayList<TrainingFeeChapterAttach>(Arrays.asList(e)), (oldList, newList) -> {
                    oldList.addAll(newList);
                    return oldList;
                }));
            }
            List typeIds = trainingFeeVoList.stream().map(TrainingFee::getTrainingType).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            Map<Object, Object> typeMap = new HashMap();
            if (!CollectionUtils.isEmpty(typeIds) && !CollectionUtils.isEmpty((Collection)(trainingMaterialTypeList = this.materialTypeMapper.selectBatchIds(typeIds)))) {
                typeMap = trainingMaterialTypeList.stream().collect(Collectors.toMap(TrainingMaterialType::getId, Function.identity()));
            }
            LambdaQueryWrapper wrapper2 = new LambdaQueryWrapper();
            wrapper2.in(TrainingOrderInfo::getTrainingFeeId, trainingFeeIds);
            List trainingOrderInfoList = this.trainingOrderInfoMapper.selectList((Wrapper)wrapper2);
            Map<Object, Object> orderMap = new HashMap();
            if (!CollectionUtils.isEmpty((Collection)trainingOrderInfoList)) {
                orderMap = trainingOrderInfoList.stream().collect(Collectors.toMap(TrainingOrderInfo::getTrainingFeeId, e -> new ArrayList<TrainingOrderInfo>(Arrays.asList(e)), (oldList, newList) -> {
                    oldList.addAll(newList);
                    return oldList;
                }));
            }
            LambdaQueryWrapper wrapper3 = new LambdaQueryWrapper();
            wrapper3.in(TrainingHistory::getTrainingFeeId, trainingFeeIds);
            List trainingHistoryList = this.trainingHistoryMapper.selectList((Wrapper)wrapper3);
            Map<Object, Object> historyMap = new HashMap();
            if (!CollectionUtils.isEmpty((Collection)trainingHistoryList)) {
                historyMap = trainingHistoryList.stream().collect(Collectors.toMap(TrainingHistory::getTrainingFeeId, e -> new ArrayList<TrainingHistory>(Arrays.asList(e)), (oldList, newList) -> {
                    oldList.addAll(newList);
                    return oldList;
                }));
            }
            Iterator<TrainingFeeVo> iterator = trainingFeeVoList.iterator();
            while (iterator.hasNext()) {
                TrainingFeeVo feeVo;
                TrainingMaterialType materialType = (TrainingMaterialType)typeMap.get((feeVo = iterator.next()).getTrainingType());
                feeVo.setTrainingTypeName(StringUtils.isEmpty((Object)materialType) ? "" : materialType.getMaterialTypeName());
                List orderInfoList = (List)orderMap.get(feeVo.getId());
                Integer enterpriseNum = 0;
                Integer buyerNum = 0;
                if (!CollectionUtils.isEmpty((Collection)orderInfoList)) {
                    for (TrainingOrderInfo orderInfo : orderInfoList) {
                        Integer n;
                        Integer n2;
                        if (orderInfo.getBuyType() == 1) {
                            n2 = enterpriseNum;
                            n = enterpriseNum = Integer.valueOf(enterpriseNum + 1);
                            continue;
                        }
                        if (orderInfo.getBuyType() != 2) continue;
                        n2 = buyerNum;
                        n = buyerNum = Integer.valueOf(buyerNum + 1);
                    }
                }
                feeVo.setEnterpriseNum(enterpriseNum);
                feeVo.setBuyerNum(buyerNum);
                Integer viewerNum = 0;
                List historyList = (List)historyMap.get(feeVo.getId());
                if (!CollectionUtils.isEmpty((Collection)historyList)) {
                    List userIds = historyList.stream().map(TrainingHistory::getUserId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
                    viewerNum = userIds.size();
                }
                feeVo.setViewerNum(viewerNum);
                feeVo.setIsBuy(Integer.valueOf(CollectionUtils.isEmpty((Collection)orderInfoList) ? 0 : 1));
                List attachList = (List)attachMap.get(feeVo.getId());
                feeVo.setAttachNum(Integer.valueOf(CollectionUtils.isEmpty((Collection)attachList) ? 0 : attachList.size()));
                UsersPojo pojo = pojoMap.get(feeVo.getUpdater());
                if (StringUtils.isEmpty((Object)pojo)) continue;
                feeVo.setUpdaterName(pojo.getShowName());
            }
            page.setContent(trainingFeeVoList);
        }
        return page;
    }

    @Override
    public void updateTrainingFeeStatus(List<TrainingFee> trainingFeeList, Users user) {
        if (!CollectionUtils.isEmpty(trainingFeeList)) {
            for (TrainingFee trainingFee : trainingFeeList) {
                TrainingFee fee = new TrainingFee();
                fee.setId(trainingFee.getId());
                fee.setStatus(trainingFee.getStatus());
                fee.setUpdater(user.getId());
                fee.setUpdateTime(new Date());
                this.trainingFeeMapper.updateById(fee);
            }
        }
    }

    @Override
    public void updateTrainingFeeType(List<TrainingFee> trainingFeeList, Users user) {
        if (!CollectionUtils.isEmpty(trainingFeeList)) {
            for (TrainingFee trainingFee : trainingFeeList) {
                TrainingFee fee = new TrainingFee();
                fee.setId(trainingFee.getId());
                fee.setTrainingType(trainingFee.getTrainingType());
                fee.setUpdater(user.getId());
                fee.setUpdateTime(new Date());
                this.trainingFeeMapper.updateById(fee);
            }
        }
    }

    @Override
    public void deleteTrainingFee(List<TrainingFee> trainingFeeList, Users user) {
        if (!CollectionUtils.isEmpty(trainingFeeList)) {
            for (TrainingFee trainingFee : trainingFeeList) {
                TrainingFee fee = new TrainingFee();
                fee.setId(trainingFee.getId());
                fee.setIsDelete(Integer.valueOf(1));
                fee.setUpdater(user.getId());
                fee.setUpdateTime(new Date());
                this.trainingFeeMapper.updateById(fee);
            }
        }
    }

    @Override
    public Boolean cheackSameTrainingName(TrainingFeeVo trainingFeeVo, Users user) {
        Boolean isSame = true;
        if (!ObjectUtils.isEmpty((Object)trainingFeeVo) && !StringUtils.isEmpty((Object)trainingFeeVo.getTitle())) {
            List trainingFeeList;
            LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
            wrapper1.isNull(TrainingFee::getEnterpriseId);
            wrapper1.eq(TrainingFee::getTitle, (Object)trainingFeeVo.getTitle().trim());
            if (trainingFeeVo.getId() != null) {
                wrapper1.ne(TrainingFee::getId, (Object)trainingFeeVo.getId());
            }
            if (!CollectionUtils.isEmpty((Collection)(trainingFeeList = this.trainingFeeMapper.selectList((Wrapper)wrapper1)))) {
                isSame = false;
            }
        }
        return isSame;
    }
}

