/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.training.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.ovopark.cloud.log.model.LogPojo;
import com.ovopark.cloud.log.sdk.LogApi;
import com.ovopark.organize.common.base.BaseResult;
import com.ovopark.organize.common.model.mo.UserAndParentNameMo;
import com.ovopark.organize.common.model.mo.UserDutiesMo;
import com.ovopark.organize.common.model.pojo.SimplePojo;
import com.ovopark.organize.common.model.pojo.UsersPojo;
import com.ovopark.organize.sdk.api.UserApi;
import com.ovopark.organize.sdk.api.UserOrganizeApi;
import com.ovopark.privilege.api.RoleApi;
import com.ovopark.privilege.pojo.RolePojo;
import com.ovopark.training.bo.JsonResult;
import com.ovopark.training.bo.Page;
import com.ovopark.training.enums.ProjectShiftStatusEnum;
import com.ovopark.training.mapper.TrainingAndLecturerMapper;
import com.ovopark.training.mapper.TrainingAndMaterialMapper;
import com.ovopark.training.mapper.TrainingAttachMapper;
import com.ovopark.training.mapper.TrainingCertificateDetailMapper;
import com.ovopark.training.mapper.TrainingCertificateMapper;
import com.ovopark.training.mapper.TrainingChapterAttachMapper;
import com.ovopark.training.mapper.TrainingChapterMapper;
import com.ovopark.training.mapper.TrainingChapterVideoMapper;
import com.ovopark.training.mapper.TrainingExamMapper;
import com.ovopark.training.mapper.TrainingExaminerMapper;
import com.ovopark.training.mapper.TrainingLabelTrainingMapper;
import com.ovopark.training.mapper.TrainingLearnExamineMapper;
import com.ovopark.training.mapper.TrainingLearnManagerMapper;
import com.ovopark.training.mapper.TrainingLearnProjectMapper;
import com.ovopark.training.mapper.TrainingLearnShiftMapper;
import com.ovopark.training.mapper.TrainingLearnShiftRecordMapper;
import com.ovopark.training.mapper.TrainingLearnShiftReviewerMapper;
import com.ovopark.training.mapper.TrainingLearnTaskUserMapper;
import com.ovopark.training.mapper.TrainingLearnUserMapper;
import com.ovopark.training.mapper.TrainingLecturerMapper;
import com.ovopark.training.mapper.TrainingMapper;
import com.ovopark.training.mapper.TrainingMaterialMapper;
import com.ovopark.training.mapper.TrainingMaterialTypeMapper;
import com.ovopark.training.mapper.TrainingPaperMapper;
import com.ovopark.training.mapper.TrainingPaperTrainingMapper;
import com.ovopark.training.mapper.TrainingProjectDocumentMapper;
import com.ovopark.training.mapper.TrainingProjectTaskMapper;
import com.ovopark.training.mapper.TrainingTaskScheduleMapper;
import com.ovopark.training.mapper.TrainingUserPaperMapper;
import com.ovopark.training.mapper.TrainingUserViewTimeLearnMapper;
import com.ovopark.training.mapper.TrainingVideoMapper;
import com.ovopark.training.mapper.TrainingWorkDocumentMapper;
import com.ovopark.training.mapper.TrainingWorkReviewerMapper;
import com.ovopark.training.mapper.TrainingWorkUserAnswerMapper;
import com.ovopark.training.model.Authenticator;
import com.ovopark.training.model.JPush;
import com.ovopark.training.model.Role;
import com.ovopark.training.model.TaskMessageBody;
import com.ovopark.training.model.Training;
import com.ovopark.training.model.TrainingAndLecturer;
import com.ovopark.training.model.TrainingAndMaterial;
import com.ovopark.training.model.TrainingAttach;
import com.ovopark.training.model.TrainingCertificate;
import com.ovopark.training.model.TrainingCertificateDetail;
import com.ovopark.training.model.TrainingChapter;
import com.ovopark.training.model.TrainingChapterAttach;
import com.ovopark.training.model.TrainingChapterVideo;
import com.ovopark.training.model.TrainingExam;
import com.ovopark.training.model.TrainingExaminer;
import com.ovopark.training.model.TrainingLabelTraining;
import com.ovopark.training.model.TrainingLearnExamine;
import com.ovopark.training.model.TrainingLearnManager;
import com.ovopark.training.model.TrainingLearnProject;
import com.ovopark.training.model.TrainingLearnShift;
import com.ovopark.training.model.TrainingLearnShiftRecord;
import com.ovopark.training.model.TrainingLearnShiftReviewer;
import com.ovopark.training.model.TrainingLearnTaskUser;
import com.ovopark.training.model.TrainingLearnUser;
import com.ovopark.training.model.TrainingLecturer;
import com.ovopark.training.model.TrainingMaterial;
import com.ovopark.training.model.TrainingMaterialType;
import com.ovopark.training.model.TrainingPaper;
import com.ovopark.training.model.TrainingPaperTraining;
import com.ovopark.training.model.TrainingProjectDocument;
import com.ovopark.training.model.TrainingProjectTask;
import com.ovopark.training.model.TrainingTaskSchedule;
import com.ovopark.training.model.TrainingUserPaper;
import com.ovopark.training.model.TrainingUserViewTime;
import com.ovopark.training.model.TrainingVideo;
import com.ovopark.training.model.TrainingWork;
import com.ovopark.training.model.TrainingWorkDocument;
import com.ovopark.training.model.TrainingWorkReviewer;
import com.ovopark.training.model.TrainingWorkUserAnswer;
import com.ovopark.training.model.Users;
import com.ovopark.training.service.CommonRemoteService;
import com.ovopark.training.service.JPushService;
import com.ovopark.training.service.TrainingCertificateService;
import com.ovopark.training.service.TrainingCommonService;
import com.ovopark.training.service.TrainingJobCertificationService;
import com.ovopark.training.service.TrainingLearnProjectService;
import com.ovopark.training.service.TrainingLearnShiftService;
import com.ovopark.training.service.TrainingWorkService;
import com.ovopark.training.service.UserUtilService;
import com.ovopark.training.util.CommonUtil;
import com.ovopark.training.util.DateUtils;
import com.ovopark.training.vo.OpenProject;
import com.ovopark.training.vo.OpenProjectShift;
import com.ovopark.training.vo.OpenUserLean;
import com.ovopark.training.vo.StudentReportCountVo;
import com.ovopark.training.vo.StudentReportRequestVo;
import com.ovopark.training.vo.StudentReportVo;
import com.ovopark.training.vo.TrainingCertificateDetailVo;
import com.ovopark.training.vo.TrainingChapterAttachVo;
import com.ovopark.training.vo.TrainingLearnProjectVo;
import com.ovopark.training.vo.TrainingLearnShiftRecordVo;
import com.ovopark.training.vo.TrainingLearnShiftVo;
import com.ovopark.training.vo.TrainingLearnTaskUserVo;
import com.ovopark.training.vo.TrainingLearnUserVo;
import com.ovopark.training.vo.TrainingProjectTaskVo;
import com.ovopark.training.vo.TrainingTaskScheduleVo;
import com.ovopark.training.vo.TrainingUserViewTimeVo;
import com.ovopark.training.vo.TrainingWorkUserAnswerVo;
import com.ovopark.training.vo.TrainingWorkVo;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Service
public class TrainingLearnProjectServiceImpl
implements TrainingLearnProjectService {
    private static final Logger log = LoggerFactory.getLogger(TrainingLearnProjectServiceImpl.class);
    @Autowired
    private TrainingLearnProjectMapper learnMapper;
    @Autowired
    private TrainingProjectTaskMapper projectMapper;
    @Autowired
    private TrainingLearnShiftMapper shiftMapper;
    @Autowired
    private TrainingTaskScheduleMapper scheduleMapper;
    @Autowired
    private TrainingProjectDocumentMapper documentMapper;
    @Autowired
    private TrainingLearnUserMapper learnUserMapper;
    @Autowired
    private TrainingWorkDocumentMapper trainingWorkDocumentMapper;
    @Autowired
    private TrainingMaterialTypeMapper materialTypeMapper;
    @Autowired
    private TrainingExaminerMapper trainingExaminerMapper;
    @Autowired
    private TrainingLecturerMapper lecturerMapper;
    @Autowired
    private TrainingLearnTaskUserMapper taskUserMapper;
    @Autowired
    private TrainingUserPaperMapper userPaperMapper;
    @Autowired
    private TrainingMapper trainingMapper;
    @Autowired
    private TrainingPaperMapper trainingPaperMapper;
    @Autowired
    private TrainingCertificateMapper certificateMapper;
    @Autowired
    private TrainingCertificateDetailMapper certificateDetailMapper;
    @Autowired
    private TrainingLearnExamineMapper examineMapper;
    @Autowired
    private TrainingAttachMapper trainingAttachMapper;
    @Autowired
    private TrainingVideoMapper trainingVideoMapper;
    @Autowired
    private TrainingLabelTrainingMapper tltMapper;
    @Autowired
    private TrainingPaperTrainingMapper trainingPaperTrainingMapper;
    @Autowired
    private TrainingChapterMapper trainingChapterMapper;
    @Autowired
    private TrainingChapterAttachMapper trainingChapterAttachMapper;
    @Autowired
    private TrainingChapterVideoMapper trainingChapterVideoMapper;
    @Autowired
    private TrainingAndLecturerMapper andLecturerMapper;
    @Autowired
    private TrainingAndMaterialMapper andMaterialMapper;
    @Autowired
    private CommonRemoteService commonRemoteService;
    @Autowired
    private TrainingLearnManagerMapper managerMapper;
    @Autowired
    private TrainingExamMapper trainingExamMapper;
    @Autowired
    private TrainingCertificateService certificateService;
    @Autowired
    private UserApi userApi;
    @Autowired
    private RoleApi roleApi;
    @Autowired
    private UserOrganizeApi userOrganizeApi;
    @Resource
    private JPushService jPushService;
    @Resource
    private UserUtilService userUtilService;
    @Autowired
    private TrainingWorkService trainingWorkService;
    @Autowired
    private TrainingTaskScheduleMapper trainingTaskScheduleMapper;
    @Autowired
    private TrainingWorkUserAnswerMapper trainingWorkUserAnswerMapper;
    @Autowired
    private TrainingWorkReviewerMapper trainingWorkReviewerMapper;
    @Autowired
    private TrainingLearnShiftRecordMapper trainingLearnShiftRecordMapper;
    @Autowired
    private TrainingLearnShiftReviewerMapper trainingLearnShiftReviewerMapper;
    @Autowired
    private TrainingLearnShiftService trainingLearnShiftService;
    @Autowired
    private TrainingUserViewTimeLearnMapper trainingUserViewTimeLearnMapper;
    @Autowired
    private TrainingCommonService trainingCommonService;
    @Autowired
    private MessageSource messageSource;
    @Autowired
    private LogApi logApi;
    @Autowired
    private TrainingJobCertificationService jobCertificationService;
    @Autowired
    private TrainingMaterialMapper trainingMaterialMapper;
    ExecutorService cachedThreadPool = Executors.newCachedThreadPool();

    @Override
    public Page<TrainingLearnShiftVo> selectLearnByPage(Page<TrainingLearnShiftVo> page, Users user, List<Integer> creaters, String startTime, String endTime) {
        List<TrainingLearnShiftVo> list = this.learnMapper.selectLearnByPage(page, user.getGroupId(), creaters, startTime, endTime);
        if (list != null && list.size() > 0) {
            List<Integer> creatorId = list.stream().map(TrainingLearnShift::getCreatorId).distinct().collect(Collectors.toList());
            Map<Integer, UsersPojo> pojoMap = this.userUtilService.selectUserMap(creatorId);
            Map<Integer, List<String>> userOrganizeMap = this.userUtilService.selectOrganizeMap(creatorId, user.getGroupId());
            for (TrainingLearnShiftVo vo : list) {
                vo.setCreatorName(pojoMap.get(vo.getCreatorId()).getShowName());
                vo.setUserName(pojoMap.get(vo.getCreatorId()).getEmployeeNumber());
                List<String> nameList = userOrganizeMap.get(vo.getCreatorId());
                if (CollectionUtils.isEmpty(nameList)) continue;
                vo.setOrganizeName(String.join((CharSequence)";", nameList));
            }
        }
        page.setContent(list);
        return page;
    }

    @Override
    public Integer selectLearnPageNum(Page<TrainingLearnProjectVo> page, Users user, Integer id, String projectName, Integer projectType, Integer status, List<Integer> creaters, String startTime, String endTime) {
        List<TrainingLearnProjectVo> list = null;
        Integer size = page.getPageSize();
        page.setPageSize(9999);
        ArrayList<Integer> statusList = new ArrayList();
        if (status != null) {
            statusList = Arrays.asList(status);
        }
        ArrayList<Integer> typeIdList = new ArrayList();
        if (projectType != null) {
            typeIdList = this.trainingCommonService.selectChildIdList(projectType);
        }
        if (this.commonRemoteService.isSuper(user.getId()).booleanValue()) {
            list = this.learnMapper.selectLearnProjectByPage(page, user.getGroupId(), projectName, typeIdList, statusList, creaters, startTime, endTime, null, null);
        } else {
            List<Integer> roleList = this.userUtilService.selectUserRoleList(user);
            list = this.learnMapper.selectLearnProjectByPage(page, user.getGroupId(), projectName, typeIdList, statusList, creaters, startTime, endTime, user.getId(), roleList);
        }
        int current = 0;
        if (list != null && list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                if (id.intValue() != list.get(i).getId().intValue()) continue;
                current = i + 1;
                break;
            }
        }
        current = current % size == 0 ? current / size : current / size + 1;
        return current;
    }

    @Override
    public List<TrainingLearnManager> getLearnManagerRole(Integer projectId, Users user) {
        List<Integer> roleList;
        ArrayList<TrainingLearnManager> managerLists = new ArrayList<TrainingLearnManager>();
        LambdaQueryWrapper managerWrapper1 = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)managerWrapper1.eq(TrainingLearnManager::getProjectId, (Object)projectId)).eq(TrainingLearnManager::getUserId, (Object)user.getId())).eq(TrainingLearnManager::getManagerType, (Object)2);
        List managerLists11 = this.managerMapper.selectList((Wrapper)managerWrapper1);
        if (!CollectionUtils.isEmpty((Collection)managerLists11)) {
            managerLists.addAll(managerLists11);
        }
        if (!CollectionUtils.isEmpty(roleList = this.userUtilService.selectUserRoleList(user))) {
            LambdaQueryWrapper managerWrapper2 = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)managerWrapper2.eq(TrainingLearnManager::getProjectId, (Object)projectId)).in(TrainingLearnManager::getRoleId, roleList)).eq(TrainingLearnManager::getManagerType, (Object)2);
            List managerLists12 = this.managerMapper.selectList((Wrapper)managerWrapper2);
            if (!CollectionUtils.isEmpty((Collection)managerLists12)) {
                managerLists.addAll(managerLists12);
            }
        }
        return managerLists;
    }

    @Override
    public Page<TrainingLearnProjectVo> selectLearnProjectByPage(Page<TrainingLearnProjectVo> page, Users user, String projectName, Integer projectType, String status, List<Integer> creaters, String startTime, String endTime) {
        List<String> str;
        List<TrainingLearnProjectVo> list = null;
        ArrayList<Integer> statusList = new ArrayList();
        if (!org.springframework.util.StringUtils.isEmpty((Object)status) && !CollectionUtils.isEmpty(str = Arrays.asList(status.trim().split(",")))) {
            statusList = str.stream().map(Integer::parseInt).collect(Collectors.toList());
        }
        ArrayList<Integer> typeIdList = new ArrayList();
        if (projectType != null) {
            typeIdList = this.trainingCommonService.selectChildIdList(projectType);
        }
        if (this.commonRemoteService.isSuper(user.getId()).booleanValue()) {
            list = this.learnMapper.selectLearnProjectByPage(page, user.getGroupId(), projectName, typeIdList, statusList, creaters, startTime, endTime, null, null);
        } else {
            List<Integer> roleList = this.userUtilService.selectUserRoleList(user);
            list = this.learnMapper.selectLearnProjectByPage(page, user.getGroupId(), projectName, typeIdList, statusList, creaters, startTime, endTime, user.getId(), roleList);
        }
        if (!CollectionUtils.isEmpty(list)) {
            List userIds = list.stream().map(TrainingLearnProject::getCreater).distinct().collect(Collectors.toList());
            List userPojoList = (List)this.userApi.getUserByIdList(userIds).getData();
            Map<Object, Object> trainingVoMap = new HashMap();
            if (!CollectionUtils.isEmpty((Collection)userPojoList)) {
                trainingVoMap = userPojoList.stream().collect(Collectors.toMap(UsersPojo::getId, Function.identity()));
            }
            for (TrainingLearnProjectVo vo : list) {
                vo.setCreateName(org.springframework.util.StringUtils.isEmpty((Object)trainingVoMap.get(vo.getCreater())) ? "" : ((UsersPojo)trainingVoMap.get(vo.getCreater())).getShowName());
                LambdaQueryWrapper shiftWrapper = new LambdaQueryWrapper();
                shiftWrapper.eq(TrainingLearnShift::getProjectId, (Object)vo.getId());
                LambdaQueryWrapper managerWrapper0 = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)((LambdaQueryWrapper)managerWrapper0.eq(TrainingLearnManager::getProjectId, (Object)vo.getId())).eq(TrainingLearnManager::getUserId, (Object)user.getId())).eq(TrainingLearnManager::getManagerType, (Object)1);
                List managerLists0 = this.managerMapper.selectList((Wrapper)managerWrapper0);
                if (!this.commonRemoteService.isSuper(user.getId()).booleanValue() && CollectionUtils.isEmpty((Collection)managerLists0)) {
                    List shiftIds;
                    List<TrainingLearnManager> managerLists1 = this.getLearnManagerRole(vo.getId(), user);
                    LambdaQueryWrapper managerWrapper2 = new LambdaQueryWrapper();
                    ((LambdaQueryWrapper)((LambdaQueryWrapper)managerWrapper2.eq(TrainingLearnManager::getProjectId, (Object)vo.getId())).eq(TrainingLearnManager::getUserId, (Object)user.getId())).eq(TrainingLearnManager::getManagerType, (Object)3);
                    List managerLists2 = this.managerMapper.selectList((Wrapper)managerWrapper2);
                    if (!CollectionUtils.isEmpty(managerLists1) && CollectionUtils.isEmpty((Collection)managerLists2)) {
                        shiftWrapper.eq(TrainingLearnShift::getCreatorId, (Object)user.getId());
                    } else if (!CollectionUtils.isEmpty(managerLists1) && !CollectionUtils.isEmpty((Collection)managerLists2)) {
                        shiftIds = managerLists2.stream().map(TrainingLearnManager::getShiftId).collect(Collectors.toList());
                        shiftWrapper.and(wq -> {
                            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wq.eq(TrainingLearnShift::getCreatorId, (Object)user.getId())).or()).in(TrainingLearnShift::getId, (Collection)shiftIds);
                        });
                    } else if (CollectionUtils.isEmpty(managerLists1) && !CollectionUtils.isEmpty((Collection)managerLists2)) {
                        shiftIds = managerLists2.stream().map(TrainingLearnManager::getShiftId).collect(Collectors.toList());
                        shiftWrapper.in(TrainingLearnShift::getId, shiftIds);
                    }
                }
                List shiftList = this.shiftMapper.selectList((Wrapper)shiftWrapper);
                vo.setShiftNum(shiftList.size());
                int finishNum = 0;
                if (!CollectionUtils.isEmpty((Collection)shiftList)) {
                    for (TrainingLearnShift shift : shiftList) {
                        if (shift.getStatus() != 4) continue;
                        ++finishNum;
                    }
                }
                vo.setFinishNum(finishNum);
            }
        }
        page.setContent(list);
        return page;
    }

    @Override
    public List<TrainingLearnProjectVo> selectLearnProject(TrainingLearnProjectVo project, Users user) {
        ArrayList<TrainingLearnProjectVo> projectVoList = new ArrayList<TrainingLearnProjectVo>();
        TrainingLearnProject learnProject = (TrainingLearnProject)this.learnMapper.selectById(project.getId());
        if (!org.springframework.util.StringUtils.isEmpty((Object)learnProject)) {
            TrainingMaterialType trainingMaterialType;
            com.ovopark.privilege.response.BaseResult base;
            ArrayList<Users> users;
            TrainingLearnProjectVo learnProjectVo = new TrainingLearnProjectVo();
            BeanUtils.copyProperties((Object)learnProject, (Object)learnProjectVo);
            LambdaQueryWrapper managerWrapper1 = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)managerWrapper1.eq(TrainingLearnManager::getProjectId, (Object)learnProjectVo.getId())).eq(TrainingLearnManager::getManagerType, (Object)1);
            List managerList1 = this.managerMapper.selectList((Wrapper)managerWrapper1);
            if (!CollectionUtils.isEmpty((Collection)managerList1)) {
                List managerUsers = managerList1.stream().map(TrainingLearnManager::getUserId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
                BaseResult base2 = this.userApi.getSimpleUserByIdList(managerUsers);
                users = new ArrayList<Users>();
                if (base2 != null && !CollectionUtils.isEmpty((Collection)((Collection)base2.getData()))) {
                    List userPojoList = (List)base2.getData();
                    for (SimplePojo pojo : userPojoList) {
                        Users use = new Users();
                        use.setId(pojo.getId());
                        use.setShowName(pojo.getName());
                        users.add(use);
                    }
                }
                learnProjectVo.setLeaderList(users);
            }
            LambdaQueryWrapper managerWrapper2 = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)managerWrapper2.eq(TrainingLearnManager::getProjectId, (Object)learnProjectVo.getId())).eq(TrainingLearnManager::getManagerType, (Object)2);
            List managerList2 = this.managerMapper.selectList((Wrapper)managerWrapper2);
            if (!CollectionUtils.isEmpty((Collection)managerList2)) {
                BaseResult base3;
                users = new ArrayList();
                List leaders = managerList2.stream().map(TrainingLearnManager::getUserId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
                if (!CollectionUtils.isEmpty(leaders) && (base3 = this.userApi.getSimpleUserByIdList(leaders)) != null && !CollectionUtils.isEmpty((Collection)((Collection)base3.getData()))) {
                    List userPojoList = (List)base3.getData();
                    for (Object pojo : userPojoList) {
                        Users use = new Users();
                        use.setId(pojo.getId());
                        use.setShowName(pojo.getName());
                        users.add(use);
                    }
                }
                learnProjectVo.setManagerList(users);
                List roles = managerList2.stream().map(TrainingLearnManager::getRoleId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
                ArrayList<Role> roleList = new ArrayList<Role>();
                if (!CollectionUtils.isEmpty(roles) && (base = this.roleApi.getRolePojoByIdList(roles)) != null && !CollectionUtils.isEmpty((Collection)((Collection)base.getData()))) {
                    for (Object pojo : (List)base.getData()) {
                        Role role = new Role();
                        role.setId(pojo.getId());
                        role.setRoleName(pojo.getRoleName());
                        roleList.add(role);
                    }
                }
                learnProjectVo.setManagerRoleList(roleList);
            }
            if (learnProjectVo.getIsSetEnd() == 1 && learnProjectVo.getReviewType() == 2) {
                List userIds;
                LambdaQueryWrapper wrapper2 = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)wrapper2.eq(TrainingLearnManager::getProjectId, (Object)learnProjectVo.getId())).eq(TrainingLearnManager::getManagerType, (Object)4);
                List reviewList = this.managerMapper.selectList((Wrapper)wrapper2);
                if (!CollectionUtils.isEmpty((Collection)reviewList) && !CollectionUtils.isEmpty(userIds = reviewList.stream().map(TrainingLearnManager::getUserId).filter(Objects::nonNull).distinct().collect(Collectors.toList()))) {
                    ArrayList<Users> users2 = new ArrayList<Users>();
                    base = this.userApi.getSimpleUserByIdList(userIds);
                    if (base != null && !CollectionUtils.isEmpty((Collection)((Collection)base.getData()))) {
                        List userPojoList = (List)base.getData();
                        for (SimplePojo pojo : userPojoList) {
                            Users use = new Users();
                            use.setId(pojo.getId());
                            use.setShowName(pojo.getName());
                            users2.add(use);
                        }
                    }
                    learnProjectVo.setReviewerList(users2);
                }
            }
            if (learnProjectVo.getProjectType() != null && !ObjectUtils.isEmpty((Object)(trainingMaterialType = (TrainingMaterialType)this.materialTypeMapper.selectById(learnProjectVo.getProjectType())))) {
                learnProjectVo.setProjectTypeName(trainingMaterialType.getMaterialTypeName());
                learnProjectVo.setMaterialTypeLevel(trainingMaterialType.getMaterialTypeLevel());
                learnProjectVo.setSourceId(trainingMaterialType.getSourceId());
                learnProjectVo.setOriginId(trainingMaterialType.getOriginId());
            }
            LambdaQueryWrapper wrappers = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)wrappers.eq(TrainingProjectTask::getProjectId, (Object)project.getId())).orderByAsc(TrainingProjectTask::getSort);
            List proList = this.projectMapper.selectList((Wrapper)wrappers);
            LambdaQueryWrapper wrappers1 = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)wrappers1.eq(TrainingTaskSchedule::getProjectId, (Object)project.getId())).isNull(TrainingTaskSchedule::getShiftId)).orderByAsc(TrainingTaskSchedule::getSort);
            List trainingTaskScheduleList = this.scheduleMapper.selectList((Wrapper)wrappers1);
            Map<Object, Object> trainingTaskScheduleMap = new HashMap();
            Map<Object, Object> materialMap = new HashMap();
            if (!CollectionUtils.isEmpty((Collection)trainingTaskScheduleList)) {
                trainingTaskScheduleMap = trainingTaskScheduleList.stream().collect(Collectors.groupingBy(TrainingTaskSchedule::getTaskId));
                List materialIds = trainingTaskScheduleList.stream().map(TrainingTaskSchedule::getMaterialId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
                if (!CollectionUtils.isEmpty(materialIds)) {
                    List trainingMaterialList = this.trainingMaterialMapper.selectBatchIds(materialIds);
                    materialMap = trainingMaterialList.stream().collect(Collectors.toMap(TrainingMaterial::getId, Function.identity()));
                }
            }
            ArrayList<TrainingProjectTaskVo> taskVoList = new ArrayList<TrainingProjectTaskVo>();
            BigDecimal totalScore = BigDecimal.ZERO;
            for (TrainingProjectTask task : proList) {
                TrainingProjectTaskVo taskVo = new TrainingProjectTaskVo();
                BeanUtils.copyProperties((Object)task, (Object)taskVo);
                List sclist = (List)trainingTaskScheduleMap.get(taskVo.getId());
                ArrayList<TrainingTaskScheduleVo> scheduleVoList = new ArrayList<TrainingTaskScheduleVo>();
                if (!CollectionUtils.isEmpty((Collection)sclist)) {
                    TrainingMaterial trainingMaterial;
                    TrainingTaskSchedule trainingTaskSchedule = (TrainingTaskSchedule)sclist.get(0);
                    if (trainingTaskSchedule.getTaskType() == 5 && trainingTaskSchedule.getMaterialId() != null && !ObjectUtils.isEmpty((Object)(trainingMaterial = (TrainingMaterial)materialMap.get(trainingTaskSchedule.getMaterialId())))) {
                        taskVo.setFileType(trainingMaterial.getFileType());
                        taskVo.setUrl(trainingMaterial.getMaterialPath());
                    }
                    trainingMaterial = sclist.iterator();
                    while (trainingMaterial.hasNext()) {
                        TrainingTaskSchedule taskSchedule = (TrainingTaskSchedule)trainingMaterial.next();
                        TrainingTaskScheduleVo scheduleVo = new TrainingTaskScheduleVo();
                        BeanUtils.copyProperties((Object)taskSchedule, (Object)scheduleVo);
                        if (!org.springframework.util.StringUtils.isEmpty((Object)scheduleVo.getLecturerId())) {
                            List lecturers = Arrays.stream(scheduleVo.getLecturerId().split(",")).map(Integer::parseInt).collect(Collectors.toList());
                            LambdaQueryWrapper wrappers2 = new LambdaQueryWrapper();
                            wrappers2.in(TrainingLecturer::getId, lecturers);
                            List lecturerList = this.lecturerMapper.selectList((Wrapper)wrappers2);
                            scheduleVo.setLecturer(lecturerList);
                        }
                        if (!org.springframework.util.StringUtils.isEmpty((Object)scheduleVo.getExamineId())) {
                            List<Integer> managers = Arrays.stream(scheduleVo.getExamineId().split(",")).map(Integer::parseInt).collect(Collectors.toList());
                            ArrayList<Users> users3 = new ArrayList<Users>();
                            Map<Integer, UsersPojo> pojoMap = this.userUtilService.selectUserMap(managers);
                            if (!ObjectUtils.isEmpty(pojoMap)) {
                                for (UsersPojo pojo : pojoMap.values()) {
                                    Users user1 = new Users();
                                    BeanUtils.copyProperties((Object)pojo, (Object)user1);
                                    users3.add(user1);
                                }
                            }
                            scheduleVo.setExamList(users3);
                        }
                        if (scheduleVo.getTrainingId() != null) {
                            scheduleVo.setTraining((Training)this.trainingMapper.selectById(scheduleVo.getTrainingId()));
                        } else if (scheduleVo.getPaperId() != null) {
                            scheduleVo.setTrainingPaper((TrainingPaper)this.trainingPaperMapper.selectById(scheduleVo.getPaperId()));
                        }
                        if (!org.springframework.util.StringUtils.isEmpty((Object)scheduleVo.getFullScore()) && !org.springframework.util.StringUtils.isEmpty((Object)scheduleVo.getTaskRate())) {
                            totalScore = scheduleVo.getFullScore().multiply(scheduleVo.getTaskRate()).multiply(new BigDecimal(0.01)).add(totalScore);
                        }
                        scheduleVoList.add(scheduleVo);
                    }
                }
                taskVo.setScheduleList(scheduleVoList);
                taskVoList.add(taskVo);
            }
            learnProjectVo.setTaskList(taskVoList);
            learnProjectVo.setTaskNum(proList.size());
            learnProjectVo.setTotalScore(totalScore);
            LambdaQueryWrapper shiftWrapper = new LambdaQueryWrapper();
            LambdaQueryWrapper managerWrapper0 = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)managerWrapper0.eq(TrainingLearnManager::getProjectId, (Object)project.getId())).eq(TrainingLearnManager::getUserId, (Object)user.getId())).eq(TrainingLearnManager::getManagerType, (Object)1);
            List managerLists0 = this.managerMapper.selectList((Wrapper)managerWrapper0);
            if (!this.commonRemoteService.isSuper(user.getId()).booleanValue() && CollectionUtils.isEmpty((Collection)managerLists0)) {
                List shiftIdes;
                List<TrainingLearnManager> managerLists1 = this.getLearnManagerRole(project.getId(), user);
                LambdaQueryWrapper managerWrappers2 = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)((LambdaQueryWrapper)managerWrappers2.eq(TrainingLearnManager::getProjectId, (Object)project.getId())).eq(TrainingLearnManager::getUserId, (Object)user.getId())).eq(TrainingLearnManager::getManagerType, (Object)3);
                List managerLists2 = this.managerMapper.selectList((Wrapper)managerWrappers2);
                LambdaQueryWrapper wrapperIn = new LambdaQueryWrapper();
                wrapperIn.eq(TrainingLearnShift::getProjectId, (Object)project.getId());
                if (!CollectionUtils.isEmpty(managerLists1) && CollectionUtils.isEmpty((Collection)managerLists2)) {
                    wrapperIn.eq(TrainingLearnShift::getCreatorId, (Object)user.getId());
                } else if (!CollectionUtils.isEmpty(managerLists1) && !CollectionUtils.isEmpty((Collection)managerLists2)) {
                    shiftIdes = managerLists2.stream().map(TrainingLearnManager::getShiftId).collect(Collectors.toList());
                    wrapperIn.and(wq -> {
                        LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wq.eq(TrainingLearnShift::getCreatorId, (Object)user.getId())).or()).in(TrainingLearnShift::getId, (Collection)shiftIdes);
                    });
                } else if (CollectionUtils.isEmpty(managerLists1) && !CollectionUtils.isEmpty((Collection)managerLists2)) {
                    shiftIdes = managerLists2.stream().map(TrainingLearnManager::getShiftId).collect(Collectors.toList());
                    wrapperIn.in(TrainingLearnShift::getId, shiftIdes);
                }
                List shiftList = this.shiftMapper.selectList((Wrapper)wrapperIn);
                if (!CollectionUtils.isEmpty((Collection)shiftList)) {
                    List shiftIds = shiftList.stream().map(TrainingLearnShift::getId).collect(Collectors.toList());
                    shiftWrapper.in(TrainingLearnShift::getId, shiftIds);
                }
            }
            shiftWrapper.eq(TrainingLearnShift::getProjectId, (Object)project.getId());
            List shiftList = this.shiftMapper.selectList((Wrapper)shiftWrapper);
            learnProjectVo.setShiftNum(shiftList.size());
            if (shiftList != null && shiftList.size() > 0) {
                LambdaQueryWrapper userWrapper = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)userWrapper.in(TrainingLearnUser::getShiftId, (Collection)shiftList.stream().map(TrainingLearnShift::getId).collect(Collectors.toList()))).ne(TrainingLearnUser::getIsDelete, (Object)1);
                List learnUserList = this.learnUserMapper.selectList((Wrapper)userWrapper);
                learnProjectVo.setUserNum(learnUserList.size());
            } else {
                learnProjectVo.setUserNum(0);
            }
            ArrayList<Integer> notNumList = new ArrayList<Integer>();
            notNumList.add(0);
            notNumList.add(1);
            shiftWrapper.in(TrainingLearnShift::getStatus, notNumList);
            List notList = this.shiftMapper.selectList((Wrapper)shiftWrapper);
            learnProjectVo.setNotNum(notList.size());
            LambdaQueryWrapper shiftWrapper1 = new LambdaQueryWrapper();
            shiftWrapper1.eq(TrainingLearnShift::getProjectId, (Object)project.getId());
            shiftWrapper1.eq(TrainingLearnShift::getStatus, (Object)2);
            List ingList = this.shiftMapper.selectList((Wrapper)shiftWrapper1);
            learnProjectVo.setIngNum(ingList.size());
            LambdaQueryWrapper shiftWrapper2 = new LambdaQueryWrapper();
            shiftWrapper2.eq(TrainingLearnShift::getProjectId, (Object)project.getId());
            shiftWrapper2.in(TrainingLearnShift::getStatus, Arrays.asList(3, 5));
            List waitList = this.shiftMapper.selectList((Wrapper)shiftWrapper2);
            learnProjectVo.setWaitNum(waitList.size());
            LambdaQueryWrapper shiftWrapper3 = new LambdaQueryWrapper();
            shiftWrapper3.eq(TrainingLearnShift::getProjectId, (Object)project.getId());
            shiftWrapper3.eq(TrainingLearnShift::getStatus, (Object)4);
            List finishList = this.shiftMapper.selectList((Wrapper)shiftWrapper3);
            learnProjectVo.setFinishNum(finishList.size());
            projectVoList.add(learnProjectVo);
        }
        return projectVoList;
    }

    @Override
    public TrainingLearnProjectVo selectLearnProjectRate(TrainingTaskScheduleVo scheduleVo, Users user) {
        TrainingLearnProjectVo learnProjectVo = new TrainingLearnProjectVo();
        TrainingLearnProject learnProject = (TrainingLearnProject)this.learnMapper.selectById(scheduleVo.getProjectId());
        if (!org.springframework.util.StringUtils.isEmpty((Object)learnProject)) {
            BeanUtils.copyProperties((Object)learnProject, (Object)learnProjectVo);
            LambdaQueryWrapper wrappers = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)wrappers.eq(TrainingTaskSchedule::getProjectId, (Object)learnProject.getId())).eq(TrainingTaskSchedule::getShiftId, (Object)scheduleVo.getShiftId())).orderByAsc(TrainingTaskSchedule::getSort);
            List proList = this.scheduleMapper.selectList((Wrapper)wrappers);
            BigDecimal totalScore = new BigDecimal(0);
            ArrayList<TrainingTaskScheduleVo> scheduleVoList = new ArrayList<TrainingTaskScheduleVo>();
            if (!CollectionUtils.isEmpty((Collection)proList)) {
                for (TrainingTaskSchedule schedule : proList) {
                    TrainingProjectTaskVo taskVo = new TrainingProjectTaskVo();
                    BeanUtils.copyProperties((Object)schedule, (Object)taskVo);
                    TrainingTaskScheduleVo taskScheduleVo = new TrainingTaskScheduleVo();
                    BeanUtils.copyProperties((Object)schedule, (Object)taskScheduleVo);
                    if (!org.springframework.util.StringUtils.isEmpty((Object)taskScheduleVo.getFullScore()) && !org.springframework.util.StringUtils.isEmpty((Object)taskScheduleVo.getTaskRate())) {
                        totalScore = taskScheduleVo.getFullScore().multiply(taskScheduleVo.getTaskRate()).multiply(new BigDecimal(0.01)).add(totalScore).setScale(2, 4);
                    }
                    scheduleVoList.add(taskScheduleVo);
                }
            }
            learnProjectVo.setScheduleList(scheduleVoList);
            learnProjectVo.setTotalScore(totalScore);
        }
        return learnProjectVo;
    }

    @Override
    public Integer saveLearnProject(TrainingLearnProjectVo project, Users user) {
        TrainingLearnManager learnManager;
        Date now = new Date();
        if (project.getId() == null) {
            project.setEnterpriseId(user.getGroupId());
            project.setCreater(user.getId());
            project.setCreateTime(now);
            this.learnMapper.insert(project);
        } else {
            TrainingLearnProject trainingLearnProject = (TrainingLearnProject)this.learnMapper.selectById(project.getId());
            this.learnMapper.updateById(project);
            if (project.getIsRelease() == null && project.getIsThrough() == null && project.getIsSynchro() == null) {
                LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
                ((LambdaUpdateWrapper)wrapper.eq(TrainingLearnManager::getProjectId, (Object)project.getId())).in(TrainingLearnManager::getManagerType, Arrays.asList(1, 2, 4));
                this.managerMapper.delete((Wrapper)wrapper);
            }
            if (!ObjectUtils.isEmpty((Object)trainingLearnProject) && trainingLearnProject.getIsSetEnd() == 1 && trainingLearnProject.getReviewType() != 0 && project.getIsSetEnd() != null && (project.getIsSetEnd() == 0 || project.getIsSetEnd() == 1 && project.getReviewType() != null && project.getReviewType() == 0)) {
                this.updateSetEndType(project, user, now, trainingLearnProject);
            }
        }
        ArrayList<TrainingLearnManager> managerList = new ArrayList<TrainingLearnManager>();
        if (!CollectionUtils.isEmpty((Collection)project.getLeaderList())) {
            for (Users users : project.getLeaderList()) {
                learnManager = new TrainingLearnManager();
                learnManager.setProjectId(project.getId());
                learnManager.setUserId(users.getId());
                learnManager.setManagerType(Integer.valueOf(1));
                learnManager.setCreater(project.getCreater());
                learnManager.setCreateTime(now);
                managerList.add(learnManager);
            }
        }
        if (!CollectionUtils.isEmpty((Collection)project.getManagerList())) {
            for (Users users : project.getManagerList()) {
                learnManager = new TrainingLearnManager();
                learnManager.setProjectId(project.getId());
                learnManager.setUserId(users.getId());
                learnManager.setManagerType(Integer.valueOf(2));
                learnManager.setCreater(project.getCreater());
                learnManager.setCreateTime(now);
                managerList.add(learnManager);
            }
        }
        if (!CollectionUtils.isEmpty((Collection)project.getManagerRoleList())) {
            for (Role roles : project.getManagerRoleList()) {
                learnManager = new TrainingLearnManager();
                learnManager.setProjectId(project.getId());
                learnManager.setRoleId(roles.getId());
                learnManager.setManagerType(Integer.valueOf(2));
                learnManager.setCreater(project.getCreater());
                learnManager.setCreateTime(now);
                managerList.add(learnManager);
            }
        }
        if (!CollectionUtils.isEmpty((Collection)project.getReviewerList())) {
            for (Users users : project.getReviewerList()) {
                learnManager = new TrainingLearnManager();
                learnManager.setProjectId(project.getId());
                learnManager.setUserId(users.getId());
                learnManager.setManagerType(Integer.valueOf(4));
                learnManager.setCreater(project.getCreater());
                learnManager.setCreateTime(now);
                managerList.add(learnManager);
            }
        }
        if (!CollectionUtils.isEmpty(managerList)) {
            this.managerMapper.insertList(managerList);
        }
        LambdaQueryWrapper scheduleWrapper = new LambdaQueryWrapper();
        scheduleWrapper.eq(TrainingTaskSchedule::getProjectId, (Object)project.getId());
        List list = this.scheduleMapper.selectList((Wrapper)scheduleWrapper);
        if (!CollectionUtils.isEmpty((Collection)list) && project.getIsSynchro() != null) {
            for (TrainingTaskSchedule trainingTaskSchedule : list) {
                trainingTaskSchedule.setIsSync(project.getIsSynchro());
                this.scheduleMapper.updateById(trainingTaskSchedule);
            }
        }
        return project.getId();
    }

    private void updateSetEndType(TrainingLearnProjectVo project, Users user, Date now, TrainingLearnProject trainingLearnProject) {
        LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper1.eq(TrainingLearnShiftRecord::getProjectId, (Object)project.getId())).eq(TrainingLearnShiftRecord::getIsLast, (Object)1)).ne(TrainingLearnShiftRecord::getStatus, (Object)3);
        List trainingLearnShiftRecordList = this.trainingLearnShiftRecordMapper.selectList((Wrapper)wrapper1);
        if (!CollectionUtils.isEmpty((Collection)trainingLearnShiftRecordList)) {
            LambdaUpdateWrapper wrapper2 = new LambdaUpdateWrapper();
            ((LambdaUpdateWrapper)((LambdaUpdateWrapper)wrapper2.eq(TrainingLearnShiftRecord::getProjectId, (Object)project.getId())).eq(TrainingLearnShiftRecord::getIsLast, (Object)1)).ne(TrainingLearnShiftRecord::getStatus, (Object)3);
            TrainingLearnShiftRecord trainingLearnShiftRecordOld = new TrainingLearnShiftRecord();
            trainingLearnShiftRecordOld.setIsLast(Integer.valueOf(0));
            this.trainingLearnShiftRecordMapper.update(trainingLearnShiftRecordOld, (Wrapper)wrapper2);
            ArrayList<Integer> shiftIdList = new ArrayList<Integer>();
            ArrayList<TrainingLearnShiftRecord> learnShiftRecordList = new ArrayList<TrainingLearnShiftRecord>();
            for (TrainingLearnShiftRecord record : trainingLearnShiftRecordList) {
                TrainingLearnShiftRecord trainingLearnShiftRecord = new TrainingLearnShiftRecord();
                trainingLearnShiftRecord.setCreater(user.getId());
                trainingLearnShiftRecord.setCreateTime(now);
                trainingLearnShiftRecord.setShiftId(record.getShiftId());
                trainingLearnShiftRecord.setProjectId(project.getId());
                trainingLearnShiftRecord.setStatus(Integer.valueOf(3));
                trainingLearnShiftRecord.setIsLast(Integer.valueOf(1));
                trainingLearnShiftRecord.setIsUpdateReview(Integer.valueOf(1));
                trainingLearnShiftRecord.setEnterpriseId(trainingLearnProject.getEnterpriseId());
                learnShiftRecordList.add(trainingLearnShiftRecord);
                shiftIdList.add(record.getShiftId());
            }
            if (!CollectionUtils.isEmpty(learnShiftRecordList)) {
                this.trainingLearnShiftRecordMapper.insertList(learnShiftRecordList);
                ArrayList<TrainingLearnShiftReviewer> trainingLearnShiftReviewerList = new ArrayList<TrainingLearnShiftReviewer>();
                TrainingLearnShiftReviewer trainingLearnShiftReviewer = null;
                for (TrainingLearnShiftRecord trainingLearnShiftRecord : learnShiftRecordList) {
                    trainingLearnShiftReviewer = new TrainingLearnShiftReviewer();
                    trainingLearnShiftReviewer.setRecordId(trainingLearnShiftRecord.getId());
                    trainingLearnShiftReviewer.setUserId(user.getId());
                    trainingLearnShiftReviewer.setCreater(user.getId());
                    trainingLearnShiftReviewer.setCreateTime(now);
                    trainingLearnShiftReviewer.setEnterpriseId(trainingLearnProject.getEnterpriseId());
                    trainingLearnShiftReviewerList.add(trainingLearnShiftReviewer);
                }
                if (!CollectionUtils.isEmpty(trainingLearnShiftReviewerList)) {
                    this.trainingLearnShiftReviewerMapper.insertList(trainingLearnShiftReviewerList);
                }
            }
            if (!CollectionUtils.isEmpty(shiftIdList)) {
                LambdaUpdateWrapper wrapper3 = new LambdaUpdateWrapper();
                wrapper3.in(TrainingLearnShift::getId, shiftIdList);
                TrainingLearnShift trainingLearnShiftOld = new TrainingLearnShift();
                trainingLearnShiftOld.setStatus(Integer.valueOf(4));
                this.shiftMapper.update(trainingLearnShiftOld, (Wrapper)wrapper3);
            }
        }
    }

    @Override
    public String deleteLearnProject(TrainingLearnProjectVo project, Users user, LogPojo pojo) {
        LambdaQueryWrapper wrapper0 = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)wrapper0.eq(TrainingLearnProject::getId, (Object)project.getId())).eq(TrainingLearnProject::getEnterpriseId, (Object)user.getGroupId());
        List trainingLearnProjectList = this.learnMapper.selectList((Wrapper)wrapper0);
        if (!CollectionUtils.isEmpty((Collection)trainingLearnProjectList)) {
            TrainingLearnProject learn = (TrainingLearnProject)this.learnMapper.selectById(project.getId());
            if (!pojo.getEnterpriseId().equals(learn.getEnterpriseId())) {
                return JsonResult.error((String)"NO_PERMISSION", (Object)"\u65e0\u6743\u9650\u5220\u9664");
            }
            LambdaQueryWrapper wrapper4 = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)wrapper4.eq(TrainingTaskSchedule::getProjectId, (Object)project.getId())).in(TrainingTaskSchedule::getTaskType, Arrays.asList(1, 2));
            List trainingTaskScheduleList = this.scheduleMapper.selectList((Wrapper)wrapper4);
            LambdaUpdateWrapper wrapper1 = new LambdaUpdateWrapper();
            wrapper1.eq(TrainingLearnShift::getProjectId, (Object)project.getId());
            List trainingLearnShiftList = this.shiftMapper.selectList((Wrapper)wrapper1);
            for (TrainingLearnShift shift : trainingLearnShiftList) {
                LogPojo childLog = new LogPojo();
                BeanUtils.copyProperties((Object)pojo, (Object)childLog);
                childLog.setOperation("study_program_class_delete");
                childLog.setI18nKey("operation.study_program_class_delete.description");
                this.trainingLearnShiftService.deleteShift(shift.getId(), user, childLog);
            }
            this.learnMapper.deleteById(project.getId());
            LambdaUpdateWrapper wrapper2 = new LambdaUpdateWrapper();
            wrapper2.eq(TrainingProjectTask::getProjectId, (Object)project.getId());
            this.projectMapper.delete((Wrapper)wrapper2);
            if (!CollectionUtils.isEmpty((Collection)trainingTaskScheduleList)) {
                List paperIds;
                LambdaUpdateWrapper wrapper7;
                List trainingIdList = trainingTaskScheduleList.stream().map(TrainingTaskSchedule::getTrainingId).filter(Objects::nonNull).collect(Collectors.toList());
                if (!CollectionUtils.isEmpty(trainingIdList)) {
                    this.trainingMapper.deleteBatchIds(trainingIdList);
                    LambdaUpdateWrapper wrapper6 = new LambdaUpdateWrapper();
                    wrapper6.in(TrainingAndMaterial::getTrainingId, trainingIdList);
                    this.andMaterialMapper.delete((Wrapper)wrapper6);
                    wrapper7 = new LambdaUpdateWrapper();
                    wrapper7.in(TrainingChapter::getTrainingId, trainingIdList);
                    this.trainingChapterMapper.delete((Wrapper)wrapper7);
                    LambdaUpdateWrapper wrapper8 = new LambdaUpdateWrapper();
                    wrapper8.in(TrainingChapterAttach::getTrainingId, trainingIdList);
                    this.trainingChapterAttachMapper.delete((Wrapper)wrapper8);
                }
                if (!CollectionUtils.isEmpty(paperIds = trainingTaskScheduleList.stream().map(TrainingTaskSchedule::getPaperId).filter(Objects::nonNull).distinct().collect(Collectors.toList()))) {
                    wrapper7 = new LambdaUpdateWrapper();
                    wrapper7.in(TrainingPaper::getId, paperIds);
                    this.trainingPaperMapper.delete((Wrapper)wrapper7);
                }
            }
            LambdaUpdateWrapper wrapper3 = new LambdaUpdateWrapper();
            wrapper3.eq(TrainingTaskSchedule::getProjectId, (Object)project.getId());
            this.scheduleMapper.delete((Wrapper)wrapper3);
            pojo.setI18nParam(learn.getProjectName());
            this.logApi.save(pojo);
        }
        return JsonResult.success();
    }

    @Override
    public Integer selectIsShift(TrainingLearnShiftVo project) {
        Integer num = 0;
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(TrainingLearnShift::getProjectId, (Object)project.getProjectId());
        List shiftList = this.shiftMapper.selectList((Wrapper)wrapper);
        if (shiftList != null && shiftList.size() > 0) {
            num = 1;
        }
        return num;
    }

    @Override
    public TrainingProjectTaskVo selectProjectTask(TrainingProjectTaskVo project) {
        TrainingProjectTaskVo taskVo = new TrainingProjectTaskVo();
        TrainingProjectTask task = (TrainingProjectTask)this.projectMapper.selectById(project.getId());
        if (task != null) {
            BeanUtils.copyProperties((Object)task, (Object)taskVo);
            LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
            wrapper.eq(TrainingTaskSchedule::getTaskId, (Object)project.getId());
            List scheduleList = project.getScheduleList();
            if (scheduleList != null && scheduleList.size() > 0) {
                wrapper.eq(TrainingTaskSchedule::getShiftId, (Object)((TrainingTaskScheduleVo)scheduleList.get(0)).getShiftId());
            } else {
                wrapper.isNull(TrainingTaskSchedule::getShiftId);
            }
            List list = this.scheduleMapper.selectList((Wrapper)wrapper);
            ArrayList<TrainingTaskScheduleVo> scheduleVoList = new ArrayList<TrainingTaskScheduleVo>();
            for (TrainingTaskSchedule taskSchedule : list) {
                TrainingTaskScheduleVo scheduleVo = new TrainingTaskScheduleVo();
                BeanUtils.copyProperties((Object)taskSchedule, (Object)scheduleVo);
                if (scheduleVo.getLecturerId() != null && !"".equals(scheduleVo.getLecturerId())) {
                    List lecturers = Arrays.asList(scheduleVo.getLecturerId().split(",")).stream().map(Integer::parseInt).collect(Collectors.toList());
                    LambdaQueryWrapper wrapper2 = new LambdaQueryWrapper();
                    wrapper2.in(TrainingLecturer::getId, lecturers);
                    List lecturerList = this.lecturerMapper.selectList((Wrapper)wrapper2);
                    scheduleVo.setLecturer(lecturerList);
                }
                if (scheduleVo.getExamineId() != null && !"".equals(scheduleVo.getExamineId())) {
                    List<Integer> managers = Arrays.asList(scheduleVo.getExamineId().split(",")).stream().map(Integer::parseInt).collect(Collectors.toList());
                    ArrayList<Users> users = new ArrayList<Users>();
                    Map<Integer, UsersPojo> pojoMap = this.userUtilService.selectUserMap(managers);
                    if (!ObjectUtils.isEmpty(pojoMap)) {
                        for (UsersPojo pojo : pojoMap.values()) {
                            Users user1 = new Users();
                            BeanUtils.copyProperties((Object)pojo, (Object)user1);
                            users.add(user1);
                        }
                    }
                    scheduleVo.setExamList(users);
                }
                LambdaQueryWrapper wrappers = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)wrappers.eq(TrainingProjectDocument::getProjectId, (Object)scheduleVo.getId())).eq(TrainingProjectDocument::getType, (Object)1);
                List documentList = this.documentMapper.selectList((Wrapper)wrappers);
                scheduleVo.setDocumentList(documentList);
                if (scheduleVo.getTrainingId() != null) {
                    scheduleVo.setTraining((Training)this.trainingMapper.selectById(scheduleVo.getTrainingId()));
                }
                if (scheduleVo.getPaperId() != null) {
                    scheduleVo.setTrainingPaper((TrainingPaper)this.trainingPaperMapper.selectById(scheduleVo.getPaperId()));
                }
                scheduleVoList.add(scheduleVo);
            }
            taskVo.setScheduleList(scheduleVoList);
        }
        return taskVo;
    }

    @Override
    public Integer saveProjectTask(final TrainingProjectTaskVo project, Users user) {
        final TrainingLearnProject learnProject = (TrainingLearnProject)this.learnMapper.selectById(project.getProjectId());
        if (org.springframework.util.StringUtils.isEmpty((Object)project.getId())) {
            final List scheduleList = project.getScheduleList();
            if (!CollectionUtils.isEmpty((Collection)scheduleList)) {
                for (TrainingTaskScheduleVo scheduleVo : scheduleList) {
                    if (learnProject.getIsSynchro() != null && learnProject.getIsSynchro() == 1) {
                        scheduleVo.setIsSync(Integer.valueOf(1));
                    } else {
                        scheduleVo.setIsSync(Integer.valueOf(0));
                    }
                    LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
                    ((LambdaUpdateWrapper)wrapper.eq(TrainingProjectTask::getProjectId, (Object)project.getProjectId())).orderByDesc(TrainingProjectTask::getSort);
                    List taskList = this.projectMapper.selectList((Wrapper)wrapper);
                    if (taskList != null && taskList.size() > 0) {
                        project.setSort(Integer.valueOf(((TrainingProjectTask)taskList.get(0)).getSort() + 1));
                    } else {
                        project.setSort(Integer.valueOf(1));
                    }
                    project.setTaskName(scheduleVo.getTaskActName().toString());
                    this.projectMapper.insert(project);
                    scheduleVo.setTaskName(scheduleVo.getTaskActName().toString());
                    scheduleVo.setSort(project.getSort());
                    scheduleVo.setTaskType(project.getTaskType());
                    scheduleVo.setProjectId(project.getProjectId());
                    scheduleVo.setTaskId(project.getId());
                    if (!org.springframework.util.StringUtils.isEmpty((Object)scheduleVo.getFullScore()) && !org.springframework.util.StringUtils.isEmpty((Object)scheduleVo.getQualifiedScore()) && scheduleVo.getFullScore().compareTo(BigDecimal.ZERO) > 0) {
                        scheduleVo.setPassLine(scheduleVo.getQualifiedScore().divide(scheduleVo.getFullScore(), 2, 4).multiply(new BigDecimal(100)));
                    }
                    if (scheduleVo.getTrainingId() != null) {
                        Integer trainingOld = scheduleVo.getTrainingId();
                        Training training = (Training)this.trainingMapper.selectById(scheduleVo.getTrainingId());
                        scheduleVo.setTrainingIdOld(training.getId());
                        training.setId(null);
                        training.setTitle(project.getTaskName());
                        if (!org.springframework.util.StringUtils.isEmpty((Object)training.getProjectShow()) && training.getProjectShow() >= 5) {
                            training.setProjectShow(Integer.valueOf(6));
                        } else {
                            training.setProjectShow(Integer.valueOf(1));
                        }
                        training.setCreator(project.getCreater());
                        training.setUpdateTime(new Date());
                        this.trainingMapper.insertSelective(training);
                        scheduleVo.setTrainingId(training.getId());
                        Integer trainingNew = scheduleVo.getTrainingId();
                        this.saveNewTrainingByOld(trainingNew, trainingOld);
                    } else if (scheduleVo.getPaperId() != null) {
                        List managers;
                        TrainingPaper paper = (TrainingPaper)this.trainingPaperMapper.selectById(scheduleVo.getPaperId());
                        scheduleVo.setPaperIdOld(paper.getId());
                        paper.setId(null);
                        paper.setTitle(project.getTaskName());
                        paper.setProjectShow(Integer.valueOf(1));
                        paper.setCreater(project.getCreater());
                        paper.setCreateTime(new Date());
                        paper.setReviewerType(Integer.valueOf(4));
                        this.trainingPaperMapper.insert(paper);
                        LambdaQueryWrapper managerWrapper1 = new LambdaQueryWrapper();
                        ((LambdaQueryWrapper)managerWrapper1.eq(TrainingLearnManager::getProjectId, (Object)learnProject.getId())).eq(TrainingLearnManager::getManagerType, (Object)2);
                        List managerList1 = this.managerMapper.selectList((Wrapper)managerWrapper1);
                        ArrayList<TrainingExaminer> examinerList = new ArrayList<TrainingExaminer>();
                        if (!CollectionUtils.isEmpty((Collection)managerList1) && !CollectionUtils.isEmpty(managers = managerList1.stream().map(TrainingLearnManager::getUserId).filter(Objects::nonNull).distinct().collect(Collectors.toList()))) {
                            for (Integer manager : managers) {
                                TrainingExaminer exam = new TrainingExaminer();
                                exam.setTrainingPaperId(paper.getId());
                                exam.setUserId(manager);
                                exam.setEnterpriseId(paper.getEnterpriseId());
                                examinerList.add(exam);
                            }
                        }
                        if (CollectionUtils.isEmpty(examinerList)) {
                            LambdaQueryWrapper managerWrapper2 = new LambdaQueryWrapper();
                            ((LambdaQueryWrapper)managerWrapper2.eq(TrainingLearnManager::getProjectId, (Object)learnProject.getId())).eq(TrainingLearnManager::getManagerType, (Object)1);
                            List managerList2 = this.managerMapper.selectList((Wrapper)managerWrapper2);
                            if (!CollectionUtils.isEmpty((Collection)managerList2)) {
                                List managers2 = managerList2.stream().map(TrainingLearnManager::getUserId).collect(Collectors.toList());
                                for (Integer manager : managers2) {
                                    TrainingExaminer exam = new TrainingExaminer();
                                    exam.setTrainingPaperId(paper.getId());
                                    exam.setUserId(manager);
                                    exam.setEnterpriseId(paper.getEnterpriseId());
                                    examinerList.add(exam);
                                }
                            }
                        }
                        if (!CollectionUtils.isEmpty(examinerList)) {
                            this.trainingExaminerMapper.insertList(examinerList);
                        }
                        scheduleVo.setPaperId(paper.getId());
                        BigDecimal score = new BigDecimal(100);
                        if (!org.springframework.util.StringUtils.isEmpty((Object)paper.getExamId())) {
                            TrainingExam exam = (TrainingExam)this.trainingExamMapper.selectById(paper.getExamId());
                            score = exam.getScore();
                        }
                        scheduleVo.setPassLine(new BigDecimal(paper.getPassLine()));
                        scheduleVo.setFullScore(score);
                        scheduleVo.setQualifiedScore(score.multiply(scheduleVo.getPassLine()).divide(new BigDecimal(100), 1, 4));
                        scheduleVo.setStartTime(paper.getStartTime());
                        scheduleVo.setEndTime(paper.getEndTime());
                    } else if (!org.springframework.util.StringUtils.isEmpty((Object)scheduleVo.getTrainingWorkVo())) {
                        TrainingWorkVo vo = scheduleVo.getTrainingWorkVo();
                        vo.setSourceType(Integer.valueOf(3));
                        Integer workId = this.trainingWorkService.insertWork(vo, user);
                        scheduleVo.setWorkId(workId);
                        scheduleVo.setStartTime(vo.getStartTime());
                        scheduleVo.setEndTime(vo.getEndTime());
                        scheduleVo.setFullScore(vo.getFullScore());
                        scheduleVo.setQualifiedScore(vo.getPassScore());
                        if (!org.springframework.util.StringUtils.isEmpty((Object)vo.getFullScore()) && !org.springframework.util.StringUtils.isEmpty((Object)vo.getPassScore()) && vo.getFullScore().compareTo(BigDecimal.ZERO) > 0) {
                            scheduleVo.setPassLine(vo.getPassScore().divide(vo.getFullScore(), 2, 4).multiply(new BigDecimal(100)));
                        }
                    }
                    scheduleVo.setCreater(project.getCreater());
                    scheduleVo.setCreateTime(new Date());
                    this.scheduleMapper.insert(scheduleVo);
                    List documentList = scheduleVo.getDocumentList();
                    if (documentList == null || documentList.size() <= 0) continue;
                    for (TrainingProjectDocument document : documentList) {
                        document.setProjectId(scheduleVo.getId());
                        document.setType(Integer.valueOf(1));
                        document.setCreater(project.getCreater());
                        document.setCreateTime(new Date());
                        this.documentMapper.insert(document);
                    }
                }
                this.cachedThreadPool.execute(new Runnable(){

                    @Override
                    public void run() {
                        block20: {
                            try {
                                LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
                                ((LambdaQueryWrapper)wrapper.eq(TrainingLearnShift::getProjectId, (Object)learnProject.getId())).ne(TrainingLearnShift::getStatus, (Object)4);
                                List shiftList = TrainingLearnProjectServiceImpl.this.shiftMapper.selectList((Wrapper)wrapper);
                                if (CollectionUtils.isEmpty((Collection)shiftList)) break block20;
                                for (TrainingTaskScheduleVo schedule : scheduleList) {
                                    for (TrainingLearnShift shift : shiftList) {
                                        schedule.setShiftId(shift.getId());
                                        if (schedule.getTrainingId() != null) {
                                            Integer trainingOld = schedule.getTrainingId();
                                            Training training = (Training)TrainingLearnProjectServiceImpl.this.trainingMapper.selectById(schedule.getTrainingId());
                                            training.setId(null);
                                            training.setTitle(project.getTaskName());
                                            if (!org.springframework.util.StringUtils.isEmpty((Object)training.getProjectShow()) && training.getProjectShow() >= 5) {
                                                training.setProjectShow(Integer.valueOf(6));
                                            } else {
                                                training.setProjectShow(Integer.valueOf(1));
                                            }
                                            training.setCreator(project.getCreater());
                                            training.setUpdateTime(new Date());
                                            TrainingLearnProjectServiceImpl.this.trainingMapper.insertSelective(training);
                                            schedule.setTrainingId(training.getId());
                                            Integer trainingNew = schedule.getTrainingId();
                                            TrainingLearnProjectServiceImpl.this.saveNewTrainingByOld(trainingNew, trainingOld);
                                        } else if (schedule.getPaperId() != null) {
                                            TrainingPaper paper = (TrainingPaper)TrainingLearnProjectServiceImpl.this.trainingPaperMapper.selectById(schedule.getPaperId());
                                            paper.setId(null);
                                            paper.setTitle(project.getTaskName());
                                            paper.setProjectShow(Integer.valueOf(1));
                                            paper.setCreater(project.getCreater());
                                            paper.setCreateTime(new Date());
                                            TrainingLearnProjectServiceImpl.this.trainingPaperMapper.insert(paper);
                                            LambdaQueryWrapper managerWrapper = new LambdaQueryWrapper();
                                            ((LambdaQueryWrapper)managerWrapper.eq(TrainingLearnManager::getShiftId, (Object)shift.getId())).eq(TrainingLearnManager::getManagerType, (Object)3);
                                            List managerList = TrainingLearnProjectServiceImpl.this.managerMapper.selectList((Wrapper)managerWrapper);
                                            if (!CollectionUtils.isEmpty((Collection)managerList)) {
                                                for (TrainingLearnManager manager : managerList) {
                                                    TrainingExaminer exam = new TrainingExaminer();
                                                    exam.setTrainingPaperId(paper.getId());
                                                    exam.setUserId(manager.getUserId());
                                                    exam.setEnterpriseId(paper.getEnterpriseId());
                                                    TrainingLearnProjectServiceImpl.this.trainingExaminerMapper.insert(exam);
                                                }
                                            } else {
                                                LambdaQueryWrapper managerWrapper1 = new LambdaQueryWrapper();
                                                ((LambdaQueryWrapper)managerWrapper1.eq(TrainingLearnManager::getShiftId, (Object)shift.getId())).eq(TrainingLearnManager::getManagerType, (Object)1);
                                                List managerList1 = TrainingLearnProjectServiceImpl.this.managerMapper.selectList((Wrapper)managerWrapper1);
                                                if (!CollectionUtils.isEmpty((Collection)managerList1)) {
                                                    List managers = managerList1.stream().map(TrainingLearnManager::getUserId).collect(Collectors.toList());
                                                    for (Integer manager : managers) {
                                                        TrainingExaminer exam = new TrainingExaminer();
                                                        exam.setTrainingPaperId(paper.getId());
                                                        exam.setUserId(manager);
                                                        exam.setEnterpriseId(paper.getEnterpriseId());
                                                        TrainingLearnProjectServiceImpl.this.trainingExaminerMapper.insert(exam);
                                                    }
                                                }
                                            }
                                            schedule.setPaperId(paper.getId());
                                            schedule.setStartTime(paper.getStartTime());
                                            schedule.setEndTime(paper.getEndTime());
                                        } else if (!org.springframework.util.StringUtils.isEmpty((Object)schedule.getTrainingWorkVo())) {
                                            schedule.setWorkIdOld(schedule.getWorkId());
                                            TrainingWork trainingWork = TrainingLearnProjectServiceImpl.this.trainingWorkService.insertSameWork(schedule.getWorkId(), 3);
                                            schedule.setWorkId(trainingWork.getId());
                                        }
                                        TrainingLearnProjectServiceImpl.this.scheduleMapper.insert(schedule);
                                        List documentList = schedule.getDocumentList();
                                        if (!CollectionUtils.isEmpty((Collection)documentList)) {
                                            for (TrainingProjectDocument document : documentList) {
                                                document.setProjectId(schedule.getId());
                                                document.setType(Integer.valueOf(1));
                                                document.setCreater(project.getCreater());
                                                document.setCreateTime(new Date());
                                                TrainingLearnProjectServiceImpl.this.documentMapper.insert(document);
                                            }
                                        }
                                        LambdaQueryWrapper learnUserLambdaQueryWrapper = new LambdaQueryWrapper();
                                        ((LambdaQueryWrapper)learnUserLambdaQueryWrapper.eq(TrainingLearnUser::getShiftId, (Object)shift.getId())).eq(TrainingLearnUser::getIsDelete, (Object)0);
                                        List learnUserList = TrainingLearnProjectServiceImpl.this.learnUserMapper.selectList((Wrapper)learnUserLambdaQueryWrapper);
                                        if (!CollectionUtils.isEmpty((Collection)learnUserList)) {
                                            ArrayList<TrainingLearnTaskUser> learnTaskUserList = new ArrayList<TrainingLearnTaskUser>();
                                            for (TrainingLearnUser learnUser : learnUserList) {
                                                TrainingLearnTaskUser learnTaskUser = new TrainingLearnTaskUser();
                                                learnTaskUser.setTaskStatus(Integer.valueOf(0));
                                                learnTaskUser.setUserId(learnUser.getUserId());
                                                learnTaskUser.setLearnUserId(learnUser.getId());
                                                learnTaskUser.setProjectTaskScheduleId(schedule.getId());
                                                learnTaskUser.setShiftId(shift.getId());
                                                learnTaskUser.setEnterpriseId(learnProject.getEnterpriseId());
                                                learnTaskUser.setCreatorId(project.getCreater());
                                                learnTaskUser.setCreateTime(new Date());
                                                learnTaskUserList.add(learnTaskUser);
                                                if (learnUser.getLearnStatus() != 3) continue;
                                                TrainingLearnProjectServiceImpl.this.learnUserMapper.updateOnlyStatusById(learnUser.getId());
                                            }
                                            TrainingLearnProjectServiceImpl.this.taskUserMapper.insertBatch(learnTaskUserList);
                                        }
                                        if (shift.getStatus() != 3) continue;
                                        shift.setStatus(Integer.valueOf(2));
                                        TrainingLearnProjectServiceImpl.this.shiftMapper.updateById(shift);
                                    }
                                }
                            }
                            catch (Exception e) {
                                log.error("\u65b0\u589e\u4efb\u52a1\u540e\uff0c\u9700\u8981\u5bf9\u5df2\u6709\u7684\u672a\u7ed3\u73ed\u7684\u73ed\u6b21\u8865\u5145\u65b0\u589e\u4efb\u52a1\u53ca\u73ed\u6b21\u4eba\u5458\u4efb\u52a1", (Throwable)e);
                            }
                        }
                    }
                });
            }
        } else {
            List scheduleList = project.getScheduleList();
            if (!CollectionUtils.isEmpty((Collection)scheduleList)) {
                for (TrainingTaskScheduleVo scheduleVo : scheduleList) {
                    if (!org.springframework.util.StringUtils.isEmpty((Object)scheduleVo.getTaskActName())) {
                        project.setTaskName(scheduleVo.getTaskActName().toString());
                        scheduleVo.setTaskName(scheduleVo.getTaskActName().toString());
                    }
                    this.projectMapper.updateById(project);
                    TrainingTaskSchedule sch = (TrainingTaskSchedule)this.scheduleMapper.selectById(scheduleVo.getId());
                    if (sch.getPaperId() == null && sch.getTrainingId() == null) {
                        this.scheduleMapper.updateSignTimeById(scheduleVo.getId());
                        this.scheduleMapper.updateTimeById(scheduleVo.getId());
                        if (!org.springframework.util.StringUtils.isEmpty((Object)scheduleVo.getFullScore()) && !org.springframework.util.StringUtils.isEmpty((Object)scheduleVo.getQualifiedScore())) {
                            if (scheduleVo.getFullScore().compareTo(new BigDecimal(0)) > 0) {
                                scheduleVo.setPassLine(scheduleVo.getQualifiedScore().divide(scheduleVo.getFullScore(), 2, 4).multiply(new BigDecimal(100)));
                            } else {
                                scheduleVo.setPassLine(null);
                            }
                        }
                    }
                    this.scheduleMapper.updateById(scheduleVo);
                    List documentList = scheduleVo.getDocumentList();
                    LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
                    ((LambdaUpdateWrapper)wrapper.eq(TrainingProjectDocument::getProjectId, (Object)scheduleVo.getId())).eq(TrainingProjectDocument::getType, (Object)1);
                    this.documentMapper.delete((Wrapper)wrapper);
                    if (!CollectionUtils.isEmpty((Collection)documentList)) {
                        for (TrainingProjectDocument document : documentList) {
                            document.setProjectId(scheduleVo.getId());
                            document.setType(Integer.valueOf(1));
                            document.setCreater(project.getCreater());
                            document.setCreateTime(new Date());
                            this.documentMapper.insert(document);
                        }
                    }
                    LambdaQueryWrapper wrapper0 = new LambdaQueryWrapper();
                    ((LambdaQueryWrapper)wrapper0.eq(TrainingLearnShift::getProjectId, (Object)learnProject.getId())).ne(TrainingLearnShift::getStatus, (Object)4);
                    List shiftList = this.shiftMapper.selectList((Wrapper)wrapper0);
                    if (CollectionUtils.isEmpty((Collection)shiftList)) continue;
                    List shiftIdList = shiftList.stream().map(TrainingLearnShift::getId).collect(Collectors.toList());
                    LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
                    ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper1.eq(TrainingTaskSchedule::getProjectId, (Object)learnProject.getId())).eq(TrainingTaskSchedule::getTaskId, (Object)project.getId())).in(TrainingTaskSchedule::getShiftId, shiftIdList);
                    List taskScheduleLists = this.scheduleMapper.selectList((Wrapper)wrapper1);
                    Map<Object, Object> scheduleMap = new HashMap();
                    if (!CollectionUtils.isEmpty((Collection)taskScheduleLists)) {
                        scheduleMap = taskScheduleLists.stream().collect(Collectors.groupingBy(TrainingTaskSchedule::getShiftId));
                    }
                    for (TrainingLearnShift learnShift : shiftList) {
                        List taskLists = (List)scheduleMap.get(learnShift.getId());
                        if (CollectionUtils.isEmpty((Collection)taskLists)) continue;
                        TrainingTaskSchedule taskSchedule = (TrainingTaskSchedule)taskLists.get(0);
                        taskSchedule.setDescription(org.springframework.util.StringUtils.isEmpty((Object)scheduleVo.getDescription()) ? "" : scheduleVo.getDescription());
                        taskSchedule.setIsOut(Integer.valueOf(org.springframework.util.StringUtils.isEmpty((Object)scheduleVo.getIsOut()) ? 0 : scheduleVo.getIsOut()));
                        taskSchedule.setOutRate(org.springframework.util.StringUtils.isEmpty((Object)scheduleVo.getOutRate()) ? new BigDecimal("0") : scheduleVo.getOutRate());
                        taskSchedule.setIsScore(Integer.valueOf(org.springframework.util.StringUtils.isEmpty((Object)scheduleVo.getIsScore()) ? 0 : scheduleVo.getIsScore()));
                        taskSchedule.setFullScore(org.springframework.util.StringUtils.isEmpty((Object)scheduleVo.getFullScore()) ? new BigDecimal("0") : scheduleVo.getFullScore());
                        taskSchedule.setQualifiedScore(org.springframework.util.StringUtils.isEmpty((Object)scheduleVo.getQualifiedScore()) ? new BigDecimal("0") : scheduleVo.getQualifiedScore());
                        if (!org.springframework.util.StringUtils.isEmpty((Object)scheduleVo.getPassLine())) {
                            taskSchedule.setPassLine(scheduleVo.getPassLine());
                        }
                        taskSchedule.setPath(scheduleVo.getPath());
                        this.scheduleMapper.updateById(taskSchedule);
                        LambdaUpdateWrapper wrapper2 = new LambdaUpdateWrapper();
                        ((LambdaUpdateWrapper)wrapper2.eq(TrainingProjectDocument::getProjectId, (Object)taskSchedule.getId())).eq(TrainingProjectDocument::getType, (Object)1);
                        this.documentMapper.delete((Wrapper)wrapper2);
                        if (documentList != null && documentList.size() > 0) {
                            for (TrainingProjectDocument document : documentList) {
                                document.setProjectId(taskSchedule.getId());
                                document.setType(Integer.valueOf(1));
                                document.setCreater(project.getCreater());
                                document.setCreateTime(new Date());
                                this.documentMapper.insert(document);
                            }
                        }
                        if (taskSchedule.getPaperId() == null || taskSchedule.getPaperIdOld() == null) continue;
                        TrainingPaper paperOld = (TrainingPaper)this.trainingPaperMapper.selectById(taskSchedule.getPaperIdOld());
                        TrainingPaper paper = (TrainingPaper)this.trainingPaperMapper.selectById(taskSchedule.getPaperId());
                        paper.setIsCommitShow(paperOld.getIsCommitShow());
                        paper.setIsEndShow(paperOld.getIsEndShow());
                        paper.setIsRankShow(paperOld.getIsRankShow());
                        this.trainingPaperMapper.updateById(paper);
                    }
                }
            }
        }
        return project.getId();
    }

    @Override
    public void saveNewTrainingByOld(Integer trainingNew, Integer trainingOld) {
        List<TrainingLabelTraining> list;
        Object chapterId;
        List<TrainingChapter> trainingChapterList;
        List<TrainingPaperTraining> trainingPaperTrainingList = this.trainingPaperTrainingMapper.selectByTrainingId(trainingOld);
        if (!CollectionUtils.isEmpty(trainingPaperTrainingList)) {
            for (TrainingPaperTraining trainingPaperTraining : trainingPaperTrainingList) {
                trainingPaperTraining.setTrainingId(trainingNew);
                this.trainingPaperTrainingMapper.insert(trainingPaperTraining);
            }
        }
        if (!CollectionUtils.isEmpty(trainingChapterList = this.trainingChapterMapper.selectByTrainingId(trainingOld))) {
            for (TrainingChapter trainingChapter : trainingChapterList) {
                List<TrainingChapterAttachVo> list2;
                chapterId = trainingChapter.getId();
                trainingChapter.setTrainingId(trainingNew);
                this.trainingChapterMapper.insert(trainingChapter);
                List<TrainingChapterVideo> chapterVideoList = this.trainingChapterVideoMapper.selectByChapterId((Integer)chapterId);
                if (!CollectionUtils.isEmpty(chapterVideoList)) {
                    for (TrainingChapterVideo trainingChapterVideo : chapterVideoList) {
                        trainingChapterVideo.setId(null);
                        trainingChapterVideo.setChapterId(trainingChapter.getId());
                        this.trainingChapterVideoMapper.insert(trainingChapterVideo);
                    }
                }
                if (!CollectionUtils.isEmpty(list2 = this.trainingChapterAttachMapper.selectByChapterId((Integer)chapterId))) {
                    for (TrainingChapterAttach chapterAttach : list2) {
                        chapterAttach.setId(null);
                        chapterAttach.setTrainingId(trainingNew);
                        chapterAttach.setChapterId(trainingChapter.getId());
                        this.trainingChapterAttachMapper.insert(chapterAttach);
                    }
                }
                LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)lambdaQueryWrapper.eq(TrainingAndMaterial::getTrainingId, (Object)trainingOld)).eq(TrainingAndMaterial::getChapterId, chapterId);
                List andMaterialList = this.andMaterialMapper.selectList((Wrapper)lambdaQueryWrapper);
                if (CollectionUtils.isEmpty((Collection)andMaterialList)) continue;
                for (TrainingAndMaterial andMaterial : andMaterialList) {
                    andMaterial.setTrainingId(trainingNew);
                    andMaterial.setChapterId(trainingChapter.getId());
                    andMaterial.setCreateTime(new Date());
                    this.andMaterialMapper.insert(andMaterial);
                }
            }
        } else {
            List<TrainingAttach> attachList;
            List<TrainingVideo> videoList;
            LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
            lambdaQueryWrapper.eq(TrainingAndMaterial::getTrainingId, (Object)trainingOld);
            List andMaterialList = this.andMaterialMapper.selectList((Wrapper)lambdaQueryWrapper);
            if (!CollectionUtils.isEmpty((Collection)andMaterialList)) {
                chapterId = andMaterialList.iterator();
                while (chapterId.hasNext()) {
                    TrainingAndMaterial andMaterial = (TrainingAndMaterial)chapterId.next();
                    andMaterial.setTrainingId(trainingNew);
                    andMaterial.setCreateTime(new Date());
                    this.andMaterialMapper.insert(andMaterial);
                }
            }
            if (!CollectionUtils.isEmpty(videoList = this.trainingVideoMapper.selectByTrainingId(trainingOld))) {
                for (TrainingVideo trainingVideo : videoList) {
                    trainingVideo.setId(null);
                    trainingVideo.setTrainingId(trainingNew);
                    this.trainingVideoMapper.insert(trainingVideo);
                }
            }
            if (!CollectionUtils.isEmpty(attachList = this.trainingAttachMapper.selectByTrainingId(trainingOld))) {
                for (TrainingAttach trainingAttach : attachList) {
                    trainingAttach.setId(null);
                    trainingAttach.setTrainingId(trainingNew);
                    this.trainingAttachMapper.insert(trainingAttach);
                }
            }
        }
        if (!CollectionUtils.isEmpty(list = this.tltMapper.selectByTrainingId(trainingOld))) {
            for (TrainingLabelTraining tlt : list) {
                tlt.setId(null);
                tlt.setTrainingId(trainingNew);
                this.tltMapper.insertSelective(tlt);
            }
        }
        LambdaQueryWrapper wrapper2 = new LambdaQueryWrapper();
        wrapper2.eq(TrainingAndLecturer::getTrainingId, (Object)trainingOld);
        List andLecturerList = this.andLecturerMapper.selectList((Wrapper)wrapper2);
        if (!CollectionUtils.isEmpty((Collection)andLecturerList)) {
            for (TrainingAndLecturer trainingAndLecturer : andLecturerList) {
                trainingAndLecturer.setTrainingId(trainingNew);
                this.andLecturerMapper.insert(trainingAndLecturer);
            }
        }
    }

    @Override
    public void saveProjectTaskSort(TrainingProjectTaskVo project) {
        LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
        ((LambdaUpdateWrapper)wrapper.eq(TrainingProjectTask::getProjectId, (Object)project.getProjectId())).orderByAsc(TrainingProjectTask::getSort);
        List taskList = this.projectMapper.selectList((Wrapper)wrapper);
        if (!CollectionUtils.isEmpty((Collection)taskList) && !org.springframework.util.StringUtils.isEmpty((Object)project.getSortList())) {
            Map map = taskList.stream().collect(Collectors.toMap(TrainingProjectTask::getSort, Function.identity()));
            String[] sortStr = project.getSortList().split(",");
            List<String> sorts = Arrays.asList(sortStr);
            List sortList = sorts.stream().map(Integer::parseInt).collect(Collectors.toList());
            for (int i = 0; i < taskList.size(); ++i) {
                TrainingProjectTask task = (TrainingProjectTask)map.get(sortList.get(i));
                if (org.springframework.util.StringUtils.isEmpty((Object)task)) continue;
                task.setSort(Integer.valueOf(i + 1));
                this.projectMapper.updateById(task);
                LambdaUpdateWrapper wrapper1 = new LambdaUpdateWrapper();
                wrapper1.eq(TrainingTaskSchedule::getTaskId, (Object)task.getId());
                TrainingTaskSchedule schedule = new TrainingTaskSchedule();
                schedule.setSort(task.getSort());
                this.scheduleMapper.update(schedule, (Wrapper)wrapper1);
            }
        }
    }

    @Override
    public Integer selectIsFinishShift(TrainingLearnShift project) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(TrainingLearnShift::getProjectId, (Object)project.getProjectId())).eq(TrainingLearnShift::getCreatorId, (Object)project.getCreatorId())).ne(TrainingLearnShift::getStatus, (Object)4);
        List list = this.shiftMapper.selectList((Wrapper)wrapper);
        if (list != null && list.size() > 0) {
            return 1;
        }
        return 0;
    }

    @Override
    public void deleteProjectTask(TrainingProjectTaskVo project) {
        List schList;
        TrainingProjectTask projectTask = (TrainingProjectTask)this.projectMapper.selectById(project.getId());
        LambdaQueryWrapper shiftWrapper0 = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)shiftWrapper0.eq(TrainingLearnShift::getProjectId, (Object)projectTask.getProjectId())).eq(TrainingLearnShift::getStatus, (Object)4);
        List learnShiftList0 = this.shiftMapper.selectList((Wrapper)shiftWrapper0);
        List<Object> shiftInt0 = new ArrayList();
        if (!CollectionUtils.isEmpty((Collection)learnShiftList0)) {
            shiftInt0 = learnShiftList0.stream().map(TrainingLearnShift::getId).collect(Collectors.toList());
        }
        LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
        wrapper1.eq(TrainingTaskSchedule::getTaskId, (Object)project.getId());
        if (!CollectionUtils.isEmpty(shiftInt0)) {
            List<Object> finalShiftInt = shiftInt0;
            wrapper1.and(wp -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wp.notIn(TrainingTaskSchedule::getShiftId, (Collection)finalShiftInt)).or()).isNull(TrainingTaskSchedule::getShiftId);
            });
        }
        if (!CollectionUtils.isEmpty((Collection)(schList = this.scheduleMapper.selectList((Wrapper)wrapper1)))) {
            List paperIds;
            LambdaUpdateWrapper wrapper2;
            List scheduleIds = schList.stream().map(TrainingTaskSchedule::getId).collect(Collectors.toList());
            List trainingIds = schList.stream().map(TrainingTaskSchedule::getTrainingId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(trainingIds)) {
                LambdaUpdateWrapper wrapper0 = new LambdaUpdateWrapper();
                wrapper0.in(Training::getId, trainingIds);
                this.trainingMapper.delete((Wrapper)wrapper0);
                wrapper2 = new LambdaUpdateWrapper();
                wrapper2.in(TrainingAndMaterial::getTrainingId, trainingIds);
                this.andMaterialMapper.delete((Wrapper)wrapper2);
                LambdaQueryWrapper wrapper3 = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)wrapper3.in(TrainingChapter::getTrainingId, trainingIds)).eq(TrainingChapter::getIsDel, (Object)0);
                List chapterList = this.trainingChapterMapper.selectList((Wrapper)wrapper3);
                if (!CollectionUtils.isEmpty((Collection)chapterList)) {
                    List chapterIds = chapterList.stream().map(TrainingChapter::getId).collect(Collectors.toList());
                    this.trainingChapterMapper.deleteBatchIds(chapterIds);
                    LambdaUpdateWrapper wrapper4 = new LambdaUpdateWrapper();
                    wrapper4.in(TrainingChapterAttach::getChapterId, chapterIds);
                    this.trainingChapterAttachMapper.delete((Wrapper)wrapper4);
                }
            }
            if (!CollectionUtils.isEmpty(paperIds = schList.stream().map(TrainingTaskSchedule::getPaperId).filter(Objects::nonNull).distinct().collect(Collectors.toList()))) {
                LambdaUpdateWrapper wrapper0 = new LambdaUpdateWrapper();
                wrapper0.in(TrainingPaper::getId, paperIds);
                this.trainingPaperMapper.delete((Wrapper)wrapper0);
            }
            wrapper2 = new LambdaUpdateWrapper();
            wrapper2.in(TrainingLearnTaskUser::getProjectTaskScheduleId, scheduleIds);
            this.taskUserMapper.delete((Wrapper)wrapper2);
            this.scheduleMapper.deleteBatchIds(scheduleIds);
            this.projectMapper.deleteById(project.getId());
            LambdaQueryWrapper shiftWrapper = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)shiftWrapper.eq(TrainingLearnShift::getProjectId, (Object)projectTask.getProjectId())).in(TrainingLearnShift::getStatus, Arrays.asList(1, 2, 3, 5));
            List learnShiftList = this.shiftMapper.selectList((Wrapper)shiftWrapper);
            if (!CollectionUtils.isEmpty((Collection)learnShiftList)) {
                List shiftInt = learnShiftList.stream().map(TrainingLearnShift::getId).collect(Collectors.toList());
                TrainingLearnProject learnProject = (TrainingLearnProject)this.learnMapper.selectById(projectTask.getProjectId());
                LambdaQueryWrapper learnUserWrapper = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)learnUserWrapper.in(TrainingLearnUser::getShiftId, shiftInt)).eq(TrainingLearnUser::getIsDelete, (Object)0);
                List learnUserList = this.learnUserMapper.selectList((Wrapper)learnUserWrapper);
                LambdaQueryWrapper taskUserWrapper = new LambdaQueryWrapper();
                taskUserWrapper.in(TrainingLearnTaskUser::getShiftId, shiftInt);
                List taskUserList1 = this.taskUserMapper.selectList((Wrapper)taskUserWrapper);
                Map<Integer, List<TrainingLearnTaskUser>> shiftMap1 = taskUserList1.stream().collect(Collectors.groupingBy(TrainingLearnTaskUser::getShiftId));
                Map<Integer, List<TrainingLearnTaskUser>> userMap1 = taskUserList1.stream().collect(Collectors.groupingBy(TrainingLearnTaskUser::getLearnUserId));
                if (learnProject.getStudyType() == 2) {
                    taskUserWrapper.in(TrainingLearnTaskUser::getTaskStatus, Arrays.asList(3, 4));
                } else {
                    taskUserWrapper.eq(TrainingLearnTaskUser::getTaskStatus, (Object)4);
                }
                List taskUserList2 = this.taskUserMapper.selectList((Wrapper)taskUserWrapper);
                Map<Integer, List<TrainingLearnTaskUser>> shiftMap2 = null;
                Map<Integer, List<TrainingLearnTaskUser>> userMap2 = null;
                if (!CollectionUtils.isEmpty((Collection)taskUserList2)) {
                    shiftMap2 = taskUserList2.stream().collect(Collectors.groupingBy(TrainingLearnTaskUser::getShiftId));
                    userMap2 = taskUserList2.stream().collect(Collectors.groupingBy(TrainingLearnTaskUser::getLearnUserId));
                }
                for (TrainingLearnShift learnShift : learnShiftList) {
                    if (shiftMap1 == null || shiftMap2 == null) continue;
                    List<TrainingLearnTaskUser> taskList1 = shiftMap1.get(learnShift.getId());
                    List<TrainingLearnTaskUser> taskList2 = shiftMap2.get(learnShift.getId());
                    if (CollectionUtils.isEmpty(taskList1) || CollectionUtils.isEmpty(taskList2) || taskList1.size() != taskList2.size() || learnShift.getStatus() == 4 || learnShift.getStatus() == 5) continue;
                    learnShift.setStatus(Integer.valueOf(3));
                    this.shiftMapper.updateById(learnShift);
                }
                for (TrainingLearnUser learnUser : learnUserList) {
                    if (userMap1 == null || userMap2 == null) continue;
                    List<TrainingLearnTaskUser> userList1 = userMap1.get(learnUser.getId());
                    List<TrainingLearnTaskUser> userList2 = userMap2.get(learnUser.getId());
                    if (CollectionUtils.isEmpty(userList1) || CollectionUtils.isEmpty(userList2) || userList1.size() != userList2.size()) continue;
                    Integer passStatus = 1;
                    BigDecimal scores = null;
                    LambdaQueryWrapper wrapper3 = new LambdaQueryWrapper();
                    ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper3.eq(TrainingLearnTaskUser::getShiftId, (Object)learnUser.getShiftId())).eq(TrainingLearnTaskUser::getUserId, (Object)learnUser.getUserId())).in(TrainingLearnTaskUser::getTaskStatus, Arrays.asList(3, 4))).isNotNull(TrainingLearnTaskUser::getScore);
                    List taskUserList = this.taskUserMapper.selectList((Wrapper)wrapper3);
                    if (!CollectionUtils.isEmpty((Collection)taskUserList)) {
                        LambdaQueryWrapper wrapper4 = new LambdaQueryWrapper();
                        ((LambdaQueryWrapper)wrapper4.eq(TrainingTaskSchedule::getShiftId, (Object)learnUser.getShiftId())).isNotNull(TrainingTaskSchedule::getTaskRate);
                        List scheduleList = this.scheduleMapper.selectList((Wrapper)wrapper4);
                        if (!CollectionUtils.isEmpty((Collection)scheduleList)) {
                            Map scheduleMap = scheduleList.stream().collect(Collectors.toMap(TrainingTaskSchedule::getId, Function.identity()));
                            BigDecimal score = BigDecimal.ZERO;
                            BigDecimal totalScore = BigDecimal.ZERO;
                            for (TrainingLearnTaskUser taskUser : taskUserList) {
                                TrainingTaskSchedule schedule = (TrainingTaskSchedule)scheduleMap.get(taskUser.getProjectTaskScheduleId());
                                score = taskUser.getScore().multiply(schedule.getTaskRate()).multiply(BigDecimal.valueOf(0.01)).add(score).setScale(1, 4);
                                totalScore = schedule.getFullScore().multiply(schedule.getTaskRate()).multiply(new BigDecimal(0.01)).add(totalScore).setScale(1, 4);
                            }
                            if (!org.springframework.util.StringUtils.isEmpty((Object)learnProject) && !org.springframework.util.StringUtils.isEmpty((Object)learnProject.getPassRate()) && score.compareTo(totalScore.multiply(learnProject.getPassRate()).multiply(new BigDecimal(0.01))) < 0) {
                                passStatus = 0;
                            }
                            scores = score;
                        }
                    }
                    learnUser.setScore(scores);
                    learnUser.setLearnStatus(Integer.valueOf(3));
                    learnUser.setPassStatus(passStatus);
                    TrainingLearnExamine examine = new TrainingLearnExamine();
                    examine.setPassStatus(passStatus);
                    examine.setUserId(learnUser.getUserId());
                    examine.setShiftId(learnUser.getShiftId());
                    examine.setLearnUserId(learnUser.getId());
                    examine.setIsAuto(Integer.valueOf(0));
                    examine.setCreateTime(new Date());
                    examine.setEnterpriseId(learnUser.getEnterpriseId());
                    this.examineMapper.insert(examine);
                    if (!org.springframework.util.StringUtils.isEmpty((Object)learnProject.getCertificateId()) && learnUser.getCertificateId() == null && !org.springframework.util.StringUtils.isEmpty((Object)learnProject.getIsGet()) && learnProject.getIsGet() == 1) {
                        Integer certificateDetailId = this.jobCertificationService.saveCertificateDetail(learnProject.getCertificateId(), learnProject.getCertificatePath(), learnUser.getUserId(), project.getCreater(), 3, learnProject.getProjectName());
                        learnUser.setCertificateId(certificateDetailId);
                    }
                    this.learnUserMapper.updateById(learnUser);
                }
            }
        }
    }

    @Override
    public Integer saveTaskSchedule(TrainingTaskScheduleVo project, Users user) {
        TrainingProjectTask task = (TrainingProjectTask)this.projectMapper.selectById(project.getTaskId());
        if (project.getId() != null) {
            if (task.getTaskType() == 2) {
                String userIds = project.getLecturerId();
                TrainingTaskSchedule schedule = (TrainingTaskSchedule)this.scheduleMapper.selectById(project.getId());
                TrainingPaper paper = (TrainingPaper)this.trainingPaperMapper.selectById(schedule.getPaperId());
                this.trainingPaperMapper.updateDelTimeById(paper.getId());
                paper.setStartTime(project.getStartTime());
                paper.setEndTime(project.getEndTime());
                if (!org.springframework.util.StringUtils.isEmpty((Object)paper.getEndTime()) && paper.getEndTime().before(new Date())) {
                    paper.setPaperState(Integer.valueOf(3));
                } else if (org.springframework.util.StringUtils.isEmpty((Object)paper.getStartTime()) || !org.springframework.util.StringUtils.isEmpty((Object)paper.getStartTime()) && paper.getStartTime().before(new Date())) {
                    paper.setPaperState(Integer.valueOf(2));
                } else if (!org.springframework.util.StringUtils.isEmpty((Object)paper.getStartTime()) && paper.getStartTime().after(new Date())) {
                    paper.setPaperState(Integer.valueOf(1));
                }
                if (project.getReviewerType() != null) {
                    paper.setReviewerType(project.getReviewerType());
                }
                this.trainingPaperMapper.updateById(paper);
                LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
                wrapper.eq(TrainingExaminer::getTrainingPaperId, (Object)schedule.getPaperId());
                this.trainingExaminerMapper.delete((Wrapper)wrapper);
                if (!org.springframework.util.StringUtils.isEmpty((Object)userIds)) {
                    String[] userIdStrs = userIds.split(",");
                    ArrayList<TrainingExaminer> examinerList = new ArrayList<TrainingExaminer>();
                    for (int i = 0; i < userIdStrs.length; ++i) {
                        TrainingExaminer trainingExaminer = new TrainingExaminer();
                        trainingExaminer.setTrainingPaperId(schedule.getPaperId());
                        trainingExaminer.setEnterpriseId(user.getGroupId());
                        trainingExaminer.setUserId(Integer.valueOf(Integer.parseInt(userIdStrs[i])));
                        examinerList.add(trainingExaminer);
                    }
                    if (!CollectionUtils.isEmpty(examinerList)) {
                        this.trainingExaminerMapper.insertList(examinerList);
                    }
                }
                project.setLecturerId(null);
            }
            this.scheduleMapper.updateSignTimeById(project.getId());
            this.scheduleMapper.updateTimeById(project.getId());
            this.scheduleMapper.updateById(project);
            List documentList = project.getDocumentList();
            if (documentList != null && documentList.size() > 0) {
                LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
                ((LambdaUpdateWrapper)wrapper.eq(TrainingProjectDocument::getProjectId, (Object)project.getId())).eq(TrainingProjectDocument::getType, (Object)1);
                this.documentMapper.delete((Wrapper)wrapper);
                for (TrainingProjectDocument document : documentList) {
                    document.setProjectId(project.getId());
                    document.setType(Integer.valueOf(1));
                    document.setCreater(project.getCreater());
                    document.setCreateTime(new Date());
                    this.documentMapper.insert(document);
                }
            }
            return 1;
        }
        return 0;
    }

    @Override
    public Integer selectShiftStatus(TrainingLearnShiftVo project) {
        TrainingLearnShift shift = (TrainingLearnShift)this.shiftMapper.selectById(project.getId());
        if (shift.getStatus() == 0 || shift.getStatus() == 1) {
            return 0;
        }
        return 1;
    }

    @Override
    public void saveFinishShift(TrainingLearnShiftVo project, Users user) {
        final Date now = new Date();
        final TrainingLearnShift learn = (TrainingLearnShift)this.shiftMapper.selectById(project.getId());
        project.setStatus(Integer.valueOf(4));
        TrainingLearnProject trainingLearnProject = (TrainingLearnProject)this.learnMapper.selectById(learn.getProjectId());
        LambdaUpdateWrapper wrapper0 = new LambdaUpdateWrapper();
        wrapper0.eq(TrainingLearnShiftRecord::getShiftId, (Object)project.getId());
        TrainingLearnShiftRecord trainingLearnShiftRecordOld = new TrainingLearnShiftRecord();
        trainingLearnShiftRecordOld.setIsLast(Integer.valueOf(0));
        this.trainingLearnShiftRecordMapper.update(trainingLearnShiftRecordOld, (Wrapper)wrapper0);
        TrainingLearnShiftRecord trainingLearnShiftRecord = new TrainingLearnShiftRecord();
        trainingLearnShiftRecord.setCreater(user.getId());
        trainingLearnShiftRecord.setCreateTime(now);
        trainingLearnShiftRecord.setShiftId(project.getId());
        trainingLearnShiftRecord.setProjectId(learn.getProjectId());
        if (trainingLearnProject.getIsSetEnd() == 1 && trainingLearnProject.getReviewType() != 0) {
            if (learn.getStatus() != 4) {
                trainingLearnShiftRecord.setStatus(Integer.valueOf(1));
            } else {
                trainingLearnShiftRecord.setStatus(Integer.valueOf(3));
            }
        } else {
            trainingLearnShiftRecord.setStatus(Integer.valueOf(3));
        }
        trainingLearnShiftRecord.setEnterpriseId(trainingLearnProject.getEnterpriseId());
        trainingLearnShiftRecord.setFinishDocument(project.getFinishDocument());
        this.trainingLearnShiftRecordMapper.insert(trainingLearnShiftRecord);
        if (!CollectionUtils.isEmpty((Collection)project.getDocumentList())) {
            ArrayList<TrainingProjectDocument> trainingProjectDocumentList = new ArrayList<TrainingProjectDocument>();
            for (TrainingProjectDocument document : project.getDocumentList()) {
                document.setProjectId(trainingLearnShiftRecord.getId());
                document.setType(Integer.valueOf(5));
                document.setCreater(user.getId());
                document.setCreateTime(now);
                trainingProjectDocumentList.add(document);
            }
            this.documentMapper.insertList(trainingProjectDocumentList);
        }
        if (trainingLearnProject.getIsSetEnd() == 1 && trainingLearnProject.getReviewType() != 0) {
            List trainingLearnManagerList;
            LambdaQueryWrapper wrapper1;
            project.setStatus(Integer.valueOf(5));
            ArrayList<TrainingLearnShiftReviewer> trainingLearnShiftReviewerList = new ArrayList<TrainingLearnShiftReviewer>();
            TrainingLearnShiftReviewer trainingLearnShiftReviewer = null;
            if (trainingLearnProject.getReviewType() == 1) {
                wrapper1 = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)wrapper1.eq(TrainingLearnManager::getProjectId, (Object)learn.getProjectId())).eq(TrainingLearnManager::getManagerType, (Object)1);
                trainingLearnManagerList = this.managerMapper.selectList((Wrapper)wrapper1);
                if (!CollectionUtils.isEmpty((Collection)trainingLearnManagerList)) {
                    for (TrainingLearnManager trainingLearnManager : trainingLearnManagerList) {
                        if (trainingLearnManager.getUserId() == null) continue;
                        trainingLearnShiftReviewer = new TrainingLearnShiftReviewer();
                        trainingLearnShiftReviewer.setRecordId(trainingLearnShiftRecord.getId());
                        trainingLearnShiftReviewer.setUserId(trainingLearnManager.getUserId());
                        trainingLearnShiftReviewer.setCreater(user.getId());
                        trainingLearnShiftReviewer.setCreateTime(now);
                        trainingLearnShiftReviewer.setEnterpriseId(trainingLearnProject.getEnterpriseId());
                        trainingLearnShiftReviewerList.add(trainingLearnShiftReviewer);
                    }
                }
            } else if (trainingLearnProject.getReviewType() == 2) {
                wrapper1 = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)wrapper1.eq(TrainingLearnManager::getProjectId, (Object)learn.getProjectId())).eq(TrainingLearnManager::getManagerType, (Object)4);
                trainingLearnManagerList = this.managerMapper.selectList((Wrapper)wrapper1);
                if (!CollectionUtils.isEmpty((Collection)trainingLearnManagerList)) {
                    for (TrainingLearnManager trainingLearnManager : trainingLearnManagerList) {
                        if (trainingLearnManager.getUserId() == null) continue;
                        trainingLearnShiftReviewer = new TrainingLearnShiftReviewer();
                        trainingLearnShiftReviewer.setRecordId(trainingLearnShiftRecord.getId());
                        trainingLearnShiftReviewer.setUserId(trainingLearnManager.getUserId());
                        trainingLearnShiftReviewer.setCreater(user.getId());
                        trainingLearnShiftReviewer.setCreateTime(now);
                        trainingLearnShiftReviewer.setEnterpriseId(trainingLearnProject.getEnterpriseId());
                        trainingLearnShiftReviewerList.add(trainingLearnShiftReviewer);
                    }
                }
            }
            if (!CollectionUtils.isEmpty(trainingLearnShiftReviewerList)) {
                this.trainingLearnShiftReviewerMapper.insertList(trainingLearnShiftReviewerList);
            }
        }
        if (learn.getStatus() != 4) {
            project.setFinishTime(now);
            project.setFinisher(user.getId());
        }
        this.shiftMapper.updateById(project);
        LambdaQueryWrapper wrapper8 = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)wrapper8.eq(TrainingLearnUser::getShiftId, (Object)project.getId())).eq(TrainingLearnUser::getIsDelete, (Object)0);
        List learnUserList = this.learnUserMapper.selectList((Wrapper)wrapper8);
        if (!CollectionUtils.isEmpty((Collection)learnUserList)) {
            LambdaQueryWrapper wrapper5 = new LambdaQueryWrapper();
            wrapper5.eq(TrainingTaskSchedule::getShiftId, (Object)learn.getId());
            List taskSchedules = this.scheduleMapper.selectList((Wrapper)wrapper5);
            Integer learnTask = CollectionUtils.isEmpty((Collection)taskSchedules) ? 0 : taskSchedules.size();
            LambdaQueryWrapper wrapper6 = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)wrapper6.eq(TrainingLearnTaskUser::getShiftId, (Object)learn.getId())).eq(TrainingLearnTaskUser::getTaskStatus, (Object)4);
            List taskUsersList = this.taskUserMapper.selectList((Wrapper)wrapper6);
            Map<Object, Object> finishTaskMap = new HashMap();
            if (!CollectionUtils.isEmpty((Collection)taskUsersList)) {
                finishTaskMap = taskUsersList.stream().collect(Collectors.groupingBy(TrainingLearnTaskUser::getLearnUserId));
            }
            for (TrainingLearnUser learnUser : learnUserList) {
                learnUser.setLearnTask(learnTask);
                List finishTaskList = (List)finishTaskMap.get(learnUser.getId());
                learnUser.setFinishTask(Integer.valueOf(CollectionUtils.isEmpty((Collection)finishTaskList) ? 0 : finishTaskList.size()));
                this.learnUserMapper.updateById(learnUser);
            }
        }
        LambdaQueryWrapper learnWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)learnWrapper.eq(TrainingLearnUser::getShiftId, (Object)project.getId())).isNull(TrainingLearnUser::getPassStatus)).eq(TrainingLearnUser::getIsDelete, (Object)0);
        final List userList = this.learnUserMapper.selectList((Wrapper)learnWrapper);
        if (!CollectionUtils.isEmpty((Collection)userList)) {
            List userIds = userList.stream().map(TrainingLearnUser::getUserId).distinct().collect(Collectors.toList());
            LambdaQueryWrapper wrapper2 = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)wrapper2.eq(TrainingProjectTask::getProjectId, (Object)learn.getProjectId())).in(TrainingProjectTask::getTaskType, Arrays.asList(2, 3, 6));
            List tasks = this.projectMapper.selectList((Wrapper)wrapper2);
            Map<Object, Object> scheduleMap = new HashMap();
            Map<Object, Object> taskUserMap = new HashMap();
            if (!CollectionUtils.isEmpty((Collection)tasks)) {
                List taskIds = tasks.stream().map(TrainingProjectTask::getId).distinct().collect(Collectors.toList());
                LambdaQueryWrapper wrapper4 = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper4.in(TrainingTaskSchedule::getTaskId, taskIds)).eq(TrainingTaskSchedule::getShiftId, (Object)learn.getId())).isNotNull(TrainingTaskSchedule::getTaskRate);
                List taskScheduleList = this.scheduleMapper.selectList((Wrapper)wrapper4);
                if (!CollectionUtils.isEmpty((Collection)taskScheduleList)) {
                    scheduleMap = taskScheduleList.stream().collect(Collectors.toMap(TrainingTaskSchedule::getId, Function.identity()));
                    List scheduleIds = taskScheduleList.stream().map(TrainingTaskSchedule::getId).distinct().collect(Collectors.toList());
                    TrainingLearnTaskUser userUpdate = new TrainingLearnTaskUser();
                    userUpdate.setScore(BigDecimal.ZERO);
                    LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
                    ((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)wrapper.eq(TrainingLearnTaskUser::getShiftId, (Object)learn.getId())).notIn(TrainingLearnTaskUser::getTaskStatus, Arrays.asList(3, 4))).in(TrainingLearnTaskUser::getProjectTaskScheduleId, scheduleIds)).isNull(TrainingLearnTaskUser::getScore);
                    this.taskUserMapper.update(userUpdate, (Wrapper)wrapper);
                    LambdaQueryWrapper wrapper3 = new LambdaQueryWrapper();
                    ((LambdaQueryWrapper)wrapper3.in(TrainingLearnTaskUser::getUserId, userIds)).eq(TrainingLearnTaskUser::getShiftId, (Object)learn.getId());
                    ((LambdaQueryWrapper)wrapper3.in(TrainingLearnTaskUser::getTaskStatus, Arrays.asList(3, 4))).in(TrainingLearnTaskUser::getProjectTaskScheduleId, scheduleIds);
                    List taskUserList = this.taskUserMapper.selectList((Wrapper)wrapper3);
                    if (!CollectionUtils.isEmpty((Collection)taskUserList)) {
                        taskUserMap = taskUserList.stream().collect(Collectors.groupingBy(TrainingLearnTaskUser::getLearnUserId));
                    }
                }
            }
            for (TrainingLearnUser learnUser : userList) {
                learnUser.setPassStatus(Integer.valueOf(0));
                List taskUsers = (List)taskUserMap.get(learnUser.getId());
                if (!CollectionUtils.isEmpty((Collection)taskUsers)) {
                    BigDecimal score = BigDecimal.ZERO;
                    for (TrainingLearnTaskUser taskUser : taskUsers) {
                        TrainingTaskSchedule taskSchedule = (TrainingTaskSchedule)scheduleMap.get(taskUser.getProjectTaskScheduleId());
                        if (ObjectUtils.isEmpty((Object)taskSchedule) || taskUser.getScore() == null || taskSchedule.getTaskRate() == null) continue;
                        score = taskUser.getScore().multiply(taskSchedule.getTaskRate()).multiply(BigDecimal.valueOf(0.01)).add(score).setScale(1, 4);
                    }
                    learnUser.setScore(score);
                }
                this.learnUserMapper.updateById(learnUser);
            }
        }
        LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
        ((LambdaUpdateWrapper)wrapper.eq(TrainingProjectDocument::getProjectId, (Object)project.getId())).eq(TrainingProjectDocument::getType, (Object)3);
        this.documentMapper.delete((Wrapper)wrapper);
        if (!CollectionUtils.isEmpty((Collection)project.getDocumentList())) {
            ArrayList<TrainingProjectDocument> trainingProjectDocumentList = new ArrayList<TrainingProjectDocument>();
            for (TrainingProjectDocument document : project.getDocumentList()) {
                document.setProjectId(project.getId());
                document.setType(Integer.valueOf(3));
                document.setCreater(user.getId());
                document.setCreateTime(now);
                trainingProjectDocumentList.add(document);
            }
            this.documentMapper.insertList(trainingProjectDocumentList);
        }
        final Locale locale = Authenticator.getInstance().getCurrentClient().getLocale();
        final String learnName = this.messageSource.getMessage("training.learn.title", null, locale);
        CommonUtil.handleTask(new Runnable(){

            @Override
            public void run() {
                try {
                    if (!CollectionUtils.isEmpty((Collection)userList)) {
                        for (TrainingLearnUser learnUser : userList) {
                            TaskMessageBody body = new TaskMessageBody();
                            body.setType(95);
                            HashMap msg = Maps.newHashMap();
                            String shiftName = org.springframework.util.StringUtils.isEmpty((Object)learn.getSupplemenName()) ? MessageFormat.format("{0}-{1}", learn.getShiftName(), learn.getGroupName()) : MessageFormat.format("{0}-{1}-{2}", learn.getShiftName(), learn.getGroupName(), learn.getSupplemenName());
                            msg.put("projectId", learn.getProjectId());
                            msg.put("shiftId", learn.getId());
                            msg.put("title", learnName);
                            body.setTaskJson(JSONObject.toJSONString((Object)msg));
                            TrainingLearnProjectServiceImpl.this.jPushService.sendWebSocket(learnName, TrainingLearnProjectServiceImpl.this.messageSource.getMessage("training.course.fail.data", new Object[]{shiftName}, locale), learnUser.getUserId(), learnUser.getEnterpriseId(), learn.getId(), "TYPE_TRAINING_PASS_TYPE", JSONObject.toJSONString((Object)msg), null, 1, 0, "training.course.fail.data", shiftName);
                            TrainingLearnProjectServiceImpl.this.jPushService.pushNotification(JPush.MASSAGE_TYPE_NOTIFY, "TYPE_TRAINING_PASS_TYPE", learnUser.getUserId(), learnName, MessageFormat.format(TrainingLearnProjectServiceImpl.this.messageSource.getMessage("training.course.fail.data", null, locale), shiftName), body);
                        }
                    }
                    SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    TrainingLearnProjectServiceImpl.this.jPushService.updateMessagesByObjectType(learn.getId(), "TYPE_TRAINING_SHIFT_TYPE", null, null, 1, format.format(now));
                }
                catch (Exception e) {
                    log.error("\u7ed3\u73ed\u63a8\u9001\uff1a", (Throwable)e);
                }
            }
        });
    }

    @Override
    public Integer selectNotFinishShift(TrainingLearnProjectVo project) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)wrapper.eq(TrainingLearnShift::getProjectId, (Object)project.getId())).ne(TrainingLearnShift::getStatus, (Object)4);
        List shiftList = this.shiftMapper.selectList((Wrapper)wrapper);
        return shiftList.size();
    }

    @Override
    public TrainingLearnShiftVo selectFinishShift(TrainingLearnShiftVo project) {
        TrainingLearnShiftVo vo = new TrainingLearnShiftVo();
        TrainingLearnShift learn = (TrainingLearnShift)this.shiftMapper.selectById(project.getId());
        BeanUtils.copyProperties((Object)learn, (Object)vo);
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)wrapper.eq(TrainingProjectDocument::getProjectId, (Object)project.getId())).eq(TrainingProjectDocument::getType, (Object)3);
        List document = this.documentMapper.selectList((Wrapper)wrapper);
        vo.setDocumentList(document);
        return vo;
    }

    @Override
    public TrainingLearnProjectVo selectFinishProject(TrainingLearnProjectVo project) {
        TrainingLearnProjectVo vo = new TrainingLearnProjectVo();
        TrainingLearnProject learn = (TrainingLearnProject)this.learnMapper.selectById(project.getId());
        if (!ObjectUtils.isEmpty((Object)learn)) {
            BeanUtils.copyProperties((Object)learn, (Object)vo);
        }
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)wrapper.eq(TrainingProjectDocument::getProjectId, (Object)project.getId())).eq(TrainingProjectDocument::getType, (Object)2);
        List document = this.documentMapper.selectList((Wrapper)wrapper);
        vo.setDocumentList(document);
        return vo;
    }

    @Override
    public TrainingLearnProjectVo selectShiftTask(TrainingProjectTaskVo project) {
        List materialIds;
        TrainingLearnProjectVo projectVo = new TrainingLearnProjectVo();
        projectVo.setIsClash(0);
        TrainingLearnProject learn = (TrainingLearnProject)this.learnMapper.selectById(project.getProjectId());
        BeanUtils.copyProperties((Object)learn, (Object)projectVo);
        Integer isThrough = projectVo.getIsThrough();
        Integer shiftId = ((TrainingTaskScheduleVo)project.getScheduleList().get(0)).getShiftId();
        LambdaQueryWrapper wrapper0 = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper0.eq(TrainingTaskSchedule::getShiftId, (Object)shiftId)).orderByAsc(TrainingTaskSchedule::getSort)).orderByAsc(TrainingTaskSchedule::getId);
        List taskList = this.scheduleMapper.selectList((Wrapper)wrapper0);
        Map<Object, Object> materialMap = new HashMap();
        if (!CollectionUtils.isEmpty((Collection)taskList) && !CollectionUtils.isEmpty(materialIds = taskList.stream().map(TrainingTaskSchedule::getMaterialId).filter(Objects::nonNull).distinct().collect(Collectors.toList()))) {
            List trainingMaterialList = this.trainingMaterialMapper.selectBatchIds(materialIds);
            materialMap = trainingMaterialList.stream().collect(Collectors.toMap(TrainingMaterial::getId, Function.identity()));
        }
        LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper1.eq(TrainingTaskSchedule::getProjectId, (Object)project.getProjectId())).isNull(TrainingTaskSchedule::getShiftId)).eq(TrainingTaskSchedule::getTaskType, (Object)3);
        List shiftNullList = this.scheduleMapper.selectList((Wrapper)wrapper1);
        Map<Object, Object> taskMap = new HashMap();
        if (!CollectionUtils.isEmpty((Collection)shiftNullList)) {
            taskMap = shiftNullList.stream().collect(Collectors.groupingBy(TrainingTaskSchedule::getTaskId));
        }
        ArrayList<TrainingProjectTaskVo> taskVoList = new ArrayList<TrainingProjectTaskVo>();
        Date endTime = null;
        for (TrainingTaskSchedule task : taskList) {
            TrainingMaterial trainingMaterial;
            TrainingProjectTaskVo taskVo = new TrainingProjectTaskVo();
            BeanUtils.copyProperties((Object)task, (Object)taskVo);
            taskVo.setId(task.getTaskId());
            ArrayList<TrainingTaskScheduleVo> scheduleVoList = new ArrayList<TrainingTaskScheduleVo>();
            TrainingTaskScheduleVo scheduleVo = new TrainingTaskScheduleVo();
            BeanUtils.copyProperties((Object)task, (Object)scheduleVo);
            if (task.getMaterialId() != null && !ObjectUtils.isEmpty((Object)(trainingMaterial = (TrainingMaterial)materialMap.get(task.getMaterialId())))) {
                taskVo.setFileType(trainingMaterial.getFileType());
                taskVo.setUrl(trainingMaterial.getMaterialPath());
            }
            if (isThrough == 1) {
                if (scheduleVo.getStartTime() != null && scheduleVo.getEndTime() != null && endTime != null && endTime.compareTo(scheduleVo.getStartTime()) > 0) {
                    projectVo.setIsClash(1);
                }
                if (scheduleVo.getEndTime() != null) {
                    endTime = scheduleVo.getEndTime();
                }
            }
            if (scheduleVo.getLecturerId() != null && !"".equals(scheduleVo.getLecturerId())) {
                List lecturers = Arrays.asList(scheduleVo.getLecturerId().split(",")).stream().map(Integer::parseInt).collect(Collectors.toList());
                LambdaQueryWrapper wrapper2 = new LambdaQueryWrapper();
                wrapper2.in(TrainingLecturer::getId, lecturers);
                List lecturerList = this.lecturerMapper.selectList((Wrapper)wrapper2);
                scheduleVo.setLecturer(lecturerList);
            }
            List documentList = null;
            List taskDocList = (List)taskMap.get(task.getTaskId());
            if (!CollectionUtils.isEmpty((Collection)taskDocList)) {
                LambdaQueryWrapper wrappers = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)wrappers.eq(TrainingProjectDocument::getProjectId, (Object)((TrainingTaskSchedule)taskDocList.get(0)).getId())).eq(TrainingProjectDocument::getType, (Object)1);
                documentList = this.documentMapper.selectList((Wrapper)wrappers);
            }
            scheduleVo.setDocumentList(documentList);
            scheduleVoList.add(scheduleVo);
            taskVo.setScheduleList(scheduleVoList);
            taskVoList.add(taskVo);
        }
        projectVo.setTaskList(taskVoList);
        return projectVo;
    }

    @Override
    public List<TrainingLearnShift> selectShiftName(TrainingLearnShiftVo shift, Users user) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        LambdaQueryWrapper managerWrapper0 = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)managerWrapper0.eq(TrainingLearnManager::getProjectId, (Object)shift.getProjectId())).eq(TrainingLearnManager::getUserId, (Object)user.getId())).eq(TrainingLearnManager::getManagerType, (Object)1);
        List managerLists0 = this.managerMapper.selectList((Wrapper)managerWrapper0);
        if (!this.commonRemoteService.isSuper(user.getId()).booleanValue() && CollectionUtils.isEmpty((Collection)managerLists0)) {
            List<TrainingLearnManager> managerLists1 = this.getLearnManagerRole(shift.getProjectId(), user);
            LambdaQueryWrapper managerWrapper2 = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)managerWrapper2.eq(TrainingLearnManager::getProjectId, (Object)shift.getProjectId())).eq(TrainingLearnManager::getUserId, (Object)user.getId())).eq(TrainingLearnManager::getManagerType, (Object)3);
            List managerLists2 = this.managerMapper.selectList((Wrapper)managerWrapper2);
            if (!CollectionUtils.isEmpty(managerLists1) && CollectionUtils.isEmpty((Collection)managerLists2)) {
                wrapper.eq(TrainingLearnShift::getCreatorId, (Object)user.getId());
            } else if (!CollectionUtils.isEmpty(managerLists1) && !CollectionUtils.isEmpty((Collection)managerLists2)) {
                List shiftIds = managerLists2.stream().map(TrainingLearnManager::getShiftId).collect(Collectors.toList());
                wrapper.and(wq -> {
                    LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wq.eq(TrainingLearnShift::getCreatorId, (Object)user.getId())).or()).in(TrainingLearnShift::getId, (Collection)shiftIds);
                });
            } else if (CollectionUtils.isEmpty(managerLists1) && !CollectionUtils.isEmpty((Collection)managerLists2)) {
                List shiftIds = managerLists2.stream().map(TrainingLearnManager::getShiftId).collect(Collectors.toList());
                wrapper.in(TrainingLearnShift::getId, shiftIds);
            }
        }
        ((LambdaQueryWrapper)wrapper.eq(TrainingLearnShift::getProjectId, (Object)shift.getProjectId())).orderByDesc(TrainingLearnShift::getId);
        List shiftList = this.shiftMapper.selectList((Wrapper)wrapper);
        return shiftList;
    }

    @Override
    public List<TrainingLearnShift> selectShiftGroupName(TrainingLearnShiftVo shift, Users user) {
        List shiftIds = null;
        Integer type = null;
        LambdaQueryWrapper managerWrapper0 = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)managerWrapper0.eq(TrainingLearnManager::getProjectId, (Object)shift.getProjectId())).eq(TrainingLearnManager::getUserId, (Object)user.getId())).eq(TrainingLearnManager::getManagerType, (Object)1);
        List managerLists0 = this.managerMapper.selectList((Wrapper)managerWrapper0);
        if (!this.commonRemoteService.isSuper(user.getId()).booleanValue() && CollectionUtils.isEmpty((Collection)managerLists0)) {
            List<TrainingLearnManager> managerLists1 = this.getLearnManagerRole(shift.getProjectId(), user);
            LambdaQueryWrapper managerWrapper2 = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)managerWrapper2.eq(TrainingLearnManager::getProjectId, (Object)shift.getProjectId())).eq(TrainingLearnManager::getUserId, (Object)user.getId())).eq(TrainingLearnManager::getManagerType, (Object)3);
            List managerLists2 = this.managerMapper.selectList((Wrapper)managerWrapper2);
            if (!CollectionUtils.isEmpty(managerLists1) && CollectionUtils.isEmpty((Collection)managerLists2)) {
                type = 1;
            } else if (!CollectionUtils.isEmpty(managerLists1) && !CollectionUtils.isEmpty((Collection)managerLists2)) {
                shiftIds = managerLists2.stream().map(TrainingLearnManager::getShiftId).collect(Collectors.toList());
                type = 2;
            } else if (CollectionUtils.isEmpty(managerLists1) && !CollectionUtils.isEmpty((Collection)managerLists2)) {
                shiftIds = managerLists2.stream().map(TrainingLearnManager::getShiftId).collect(Collectors.toList());
                type = 3;
            }
        }
        return this.shiftMapper.selectShiftGroupName(shift.getProjectId(), type, user.getId(), shiftIds);
    }

    @Override
    public Map<String, Object> selectTaskAnalysis(TrainingLearnShiftVo shift, Users user) {
        List shiftList;
        HashMap<String, Object> map = new HashMap<String, Object>();
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(TrainingLearnShift::getProjectId, (Object)shift.getProjectId());
        LambdaQueryWrapper managerWrapper0 = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)managerWrapper0.eq(TrainingLearnManager::getProjectId, (Object)shift.getProjectId())).eq(TrainingLearnManager::getUserId, (Object)user.getId())).eq(TrainingLearnManager::getManagerType, (Object)1);
        List managerLists0 = this.managerMapper.selectList((Wrapper)managerWrapper0);
        if (!this.commonRemoteService.isSuper(user.getId()).booleanValue() && CollectionUtils.isEmpty((Collection)managerLists0)) {
            List shiftIds;
            List<TrainingLearnManager> managerLists1 = this.getLearnManagerRole(shift.getProjectId(), user);
            LambdaQueryWrapper managerWrapper2 = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)managerWrapper2.eq(TrainingLearnManager::getProjectId, (Object)shift.getProjectId())).eq(TrainingLearnManager::getUserId, (Object)user.getId())).eq(TrainingLearnManager::getManagerType, (Object)3);
            List managerLists2 = this.managerMapper.selectList((Wrapper)managerWrapper2);
            if (!CollectionUtils.isEmpty(managerLists1) && CollectionUtils.isEmpty((Collection)managerLists2)) {
                wrapper.eq(TrainingLearnShift::getCreatorId, (Object)user.getId());
            } else if (!CollectionUtils.isEmpty(managerLists1) && !CollectionUtils.isEmpty((Collection)managerLists2)) {
                shiftIds = managerLists2.stream().map(TrainingLearnManager::getShiftId).collect(Collectors.toList());
                wrapper.and(wq -> {
                    LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wq.eq(TrainingLearnShift::getCreatorId, (Object)user.getId())).or()).in(TrainingLearnShift::getId, (Collection)shiftIds);
                });
            } else if (CollectionUtils.isEmpty(managerLists1) && !CollectionUtils.isEmpty((Collection)managerLists2)) {
                shiftIds = managerLists2.stream().map(TrainingLearnManager::getShiftId).collect(Collectors.toList());
                wrapper.in(TrainingLearnShift::getId, shiftIds);
            }
        }
        if (shift.getId() != null) {
            wrapper.eq(TrainingLearnShift::getId, (Object)shift.getId());
        }
        if (shift.getGroupName() != null) {
            wrapper.eq(TrainingLearnShift::getGroupName, (Object)shift.getGroupName());
        }
        if (shift.getCreatorId() != null) {
            wrapper.in(TrainingLearnShift::getCreatorId, new Object[]{shift.getCreatorId()});
        }
        if (!CollectionUtils.isEmpty((Collection)(shiftList = this.shiftMapper.selectList((Wrapper)wrapper)))) {
            List shiftIds = shiftList.stream().map(TrainingLearnShift::getId).collect(Collectors.toList());
            map.put("shiftNum", shiftIds.size());
            LambdaQueryWrapper wrapper3 = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)wrapper3.in(TrainingLearnUser::getShiftId, shiftIds)).ne(TrainingLearnUser::getIsDelete, (Object)1);
            List learnUserList = this.learnUserMapper.selectList((Wrapper)wrapper3);
            map.put("learnUserNum", learnUserList.size());
            LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
            wrapper1.in(TrainingTaskSchedule::getShiftId, shiftIds);
            List scheduleList = this.scheduleMapper.selectList((Wrapper)wrapper1);
            List taskIds = scheduleList.stream().map(TrainingTaskSchedule::getTaskId).collect(Collectors.toList());
            List taskList = new ArrayList();
            if (!CollectionUtils.isEmpty(taskIds)) {
                LambdaQueryWrapper wrapper2 = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)wrapper2.in(TrainingProjectTask::getId, taskIds)).orderByAsc(TrainingProjectTask::getSort);
                taskList = this.projectMapper.selectList((Wrapper)wrapper2);
                map.put("taskNum", taskList.size());
            } else {
                map.put("taskNum", 0);
            }
            Map<Integer, List<TrainingTaskSchedule>> taskScheduleMap = scheduleList.stream().collect(Collectors.groupingBy(TrainingTaskSchedule::getTaskId));
            List materialIds = scheduleList.stream().map(TrainingTaskSchedule::getMaterialId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            Map<Object, Object> materialMap = new HashMap();
            if (!CollectionUtils.isEmpty(materialIds)) {
                List trainingMaterialList = this.trainingMaterialMapper.selectBatchIds(materialIds);
                materialMap = trainingMaterialList.stream().collect(Collectors.toMap(TrainingMaterial::getId, Function.identity()));
            }
            int taskFinishNum = 0;
            int taskNums = 0;
            int taskFinishNums = 0;
            ArrayList taskMapList = Lists.newArrayList();
            LambdaQueryWrapper wrapper4 = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)wrapper4.in(TrainingLearnTaskUser::getShiftId, shiftIds)).isNotNull(TrainingLearnTaskUser::getProjectTaskScheduleId);
            List trainingLearnTaskUserLists = this.taskUserMapper.selectList((Wrapper)wrapper4);
            Map<Object, Object> learnTaskUserMap = new HashMap();
            if (!CollectionUtils.isEmpty((Collection)trainingLearnTaskUserLists)) {
                learnTaskUserMap = trainingLearnTaskUserLists.stream().collect(Collectors.groupingBy(TrainingLearnTaskUser::getShiftId));
            }
            for (TrainingProjectTask task : taskList) {
                TrainingProjectTaskVo taskVo = new TrainingProjectTaskVo();
                taskVo.setSort(task.getSort());
                taskVo.setTaskId(task.getId());
                taskVo.setTaskType(task.getTaskType());
                taskVo.setTaskName(task.getTaskName());
                int shiftNum = 0;
                int userPassNum = 0;
                int userNum = 0;
                List<TrainingTaskSchedule> trainingTaskSchedules = taskScheduleMap.get(task.getId());
                List<Object> trainingTaskScheduleIds = Lists.newArrayList();
                if (!CollectionUtils.isEmpty(trainingTaskSchedules)) {
                    TrainingMaterial trainingMaterial;
                    trainingTaskScheduleIds = trainingTaskSchedules.stream().map(TrainingTaskSchedule::getId).collect(Collectors.toList());
                    TrainingTaskSchedule trainingTaskSchedule = trainingTaskSchedules.get(0);
                    if (trainingTaskSchedule.getTaskType() == 5 && trainingTaskSchedule.getMaterialId() != null && !ObjectUtils.isEmpty((Object)(trainingMaterial = (TrainingMaterial)materialMap.get(trainingTaskSchedule.getMaterialId())))) {
                        taskVo.setFileType(trainingMaterial.getFileType());
                        taskVo.setUrl(trainingMaterial.getMaterialPath());
                    }
                }
                for (Integer shiftId : shiftIds) {
                    ArrayList trainingLearnTaskUserList = Lists.newArrayList();
                    List trainingLearnTaskUsers = (List)learnTaskUserMap.get(shiftId);
                    if (!CollectionUtils.isEmpty((Collection)trainingLearnTaskUsers) && !CollectionUtils.isEmpty((Collection)trainingTaskScheduleIds)) {
                        for (TrainingLearnTaskUser trainingLearnTaskUser : trainingLearnTaskUsers) {
                            if (!trainingTaskScheduleIds.contains(trainingLearnTaskUser.getProjectTaskScheduleId())) continue;
                            trainingLearnTaskUserList.add(trainingLearnTaskUser);
                        }
                    }
                    if (CollectionUtils.isEmpty((Collection)trainingLearnTaskUserList)) continue;
                    int userNum1 = trainingLearnTaskUserList.size();
                    userNum += userNum1;
                    int userNum2 = 0;
                    if (!CollectionUtils.isEmpty((Collection)trainingLearnTaskUserList)) {
                        for (TrainingLearnTaskUser learnTaskUser : trainingLearnTaskUserList) {
                            if (learnTaskUser.getTaskStatus() == null || learnTaskUser.getTaskStatus() != 4) continue;
                            ++userNum2;
                        }
                    }
                    userPassNum += userNum2;
                    if (userNum2 < userNum1) continue;
                    ++shiftNum;
                }
                taskVo.setShiftPassNum(shiftNum);
                taskVo.setShiftPassRate(shiftIds.size() > 0 ? Math.round(100 * shiftNum / shiftIds.size()) : 0);
                taskVo.setUserPassNum(userPassNum);
                taskVo.setUserPassRate(userNum > 0 ? Math.round(100 * userPassNum / userNum) : 0);
                taskFinishNums += userPassNum;
                taskNums += userNum;
                if (shiftNum >= shiftIds.size()) {
                    ++taskFinishNum;
                }
                taskMapList.add(taskVo);
            }
            map.put("taskFinishNum", taskFinishNum);
            map.put("taskFinishRate", taskNums > 0 ? Math.round(100 * taskFinishNums / taskNums) : 0);
            map.put("taskList", taskMapList);
        }
        return map;
    }

    @Override
    public Map<String, Object> selectUserPaperStatus(Map<String, Object> project) {
        Map<String, Object> userMap;
        Users user = (Users)project.get("user");
        HashMap<String, Object> map = new HashMap<String, Object>();
        int total = 0;
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(TrainingTaskSchedule::getTaskId, project.get("taskId"));
        List scheduleList = this.scheduleMapper.selectList((Wrapper)wrapper);
        List scheduleIds = scheduleList.stream().map(TrainingTaskSchedule::getId).collect(Collectors.toList());
        TrainingTaskSchedule schedule = (TrainingTaskSchedule)scheduleList.get(0);
        List<Object> shiftIds = scheduleList.stream().map(TrainingTaskSchedule::getShiftId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        LambdaQueryWrapper managerWrapper0 = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)managerWrapper0.eq(TrainingLearnManager::getProjectId, (Object)schedule.getProjectId())).eq(TrainingLearnManager::getUserId, (Object)user.getId())).eq(TrainingLearnManager::getManagerType, (Object)1);
        List managerLists0 = this.managerMapper.selectList((Wrapper)managerWrapper0);
        if (!this.commonRemoteService.isSuper(user.getId()).booleanValue() && CollectionUtils.isEmpty((Collection)managerLists0)) {
            List shiftIdes;
            List<TrainingLearnManager> managerLists1 = this.getLearnManagerRole(schedule.getProjectId(), user);
            LambdaQueryWrapper managerWrapper2 = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)managerWrapper2.eq(TrainingLearnManager::getProjectId, (Object)schedule.getProjectId())).eq(TrainingLearnManager::getUserId, (Object)user.getId())).eq(TrainingLearnManager::getManagerType, (Object)3);
            List managerLists2 = this.managerMapper.selectList((Wrapper)managerWrapper2);
            LambdaQueryWrapper wrapperIn = new LambdaQueryWrapper();
            wrapperIn.eq(TrainingLearnShift::getProjectId, (Object)schedule.getProjectId());
            if (!CollectionUtils.isEmpty(managerLists1) && CollectionUtils.isEmpty((Collection)managerLists2)) {
                wrapperIn.eq(TrainingLearnShift::getCreatorId, (Object)user.getId());
            } else if (!CollectionUtils.isEmpty(managerLists1) && !CollectionUtils.isEmpty((Collection)managerLists2)) {
                shiftIdes = managerLists2.stream().map(TrainingLearnManager::getShiftId).collect(Collectors.toList());
                wrapperIn.and(wq -> {
                    LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wq.eq(TrainingLearnShift::getCreatorId, (Object)user.getId())).or()).in(TrainingLearnShift::getId, (Collection)shiftIdes);
                });
            } else if (CollectionUtils.isEmpty(managerLists1) && !CollectionUtils.isEmpty((Collection)managerLists2)) {
                shiftIdes = managerLists2.stream().map(TrainingLearnManager::getShiftId).collect(Collectors.toList());
                wrapperIn.in(TrainingLearnShift::getId, shiftIdes);
            }
            List shiftList = this.shiftMapper.selectList((Wrapper)wrapperIn);
            if (!CollectionUtils.isEmpty((Collection)shiftList)) {
                shiftIds = shiftList.stream().map(TrainingLearnShift::getId).collect(Collectors.toList());
            }
        }
        String bool = "0";
        List userList = null;
        if (project.get("creater") != null && !"".equals(project.get("creater")) && (userMap = this.userUtilService.getCheckParameters(project.get("creater").toString(), null, null, user)).get("isEffect").toString().equals("1") && CollectionUtils.isEmpty((Collection)(userList = (List)userMap.get("userList")))) {
            bool = "1";
        }
        if (project.get("shiftId") != null) {
            Integer shiftId = Integer.parseInt(project.get("shiftId").toString());
            if (!CollectionUtils.isEmpty(shiftIds)) {
                shiftIds.retainAll(Collections.singletonList(shiftId));
            } else {
                shiftIds = Collections.singletonList(shiftId);
            }
        }
        LambdaQueryWrapper wrappers = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)wrappers.in(TrainingLearnTaskUser::getProjectTaskScheduleId, scheduleIds)).isNotNull(TrainingLearnTaskUser::getTaskStatus);
        if (!CollectionUtils.isEmpty(userList)) {
            wrappers.in(TrainingLearnTaskUser::getUserId, userList);
        }
        if (!CollectionUtils.isEmpty(shiftIds)) {
            wrappers.in(TrainingLearnTaskUser::getShiftId, shiftIds);
        }
        List taskUserList = this.taskUserMapper.selectList((Wrapper)wrappers);
        Map<Object, Object> taskMap = new HashMap();
        if (!CollectionUtils.isEmpty((Collection)taskUserList)) {
            taskMap = taskUserList.stream().collect(Collectors.groupingBy(TrainingLearnTaskUser::getTaskStatus));
        }
        for (int i = 0; i < 5; ++i) {
            List ltUserList = (List)taskMap.get(i);
            if (!CollectionUtils.isEmpty((Collection)ltUserList) && "0".equals(bool)) {
                map.put(i + "", ltUserList.size());
                total += ltUserList.size();
                continue;
            }
            map.put(i + "", 0);
        }
        map.put("total", total);
        return map;
    }

    @Override
    public List<TrainingLearnTaskUserVo> getUserPaperTask(Map<String, Object> project) {
        Map<String, Object> userMap;
        Users user = (Users)JSON.parseObject((String)JSON.toJSONString((Object)project.get("user")), Users.class);
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)wrapper.eq(TrainingTaskSchedule::getTaskId, project.get("taskId"))).isNotNull(TrainingTaskSchedule::getShiftId);
        List scheduleList = this.scheduleMapper.selectList((Wrapper)wrapper);
        List<Integer> scheduleIds = scheduleList.stream().map(TrainingTaskSchedule::getId).collect(Collectors.toList());
        TrainingTaskSchedule schedule = (TrainingTaskSchedule)scheduleList.get(0);
        List<Object> shiftIds = scheduleList.stream().map(TrainingTaskSchedule::getShiftId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        LambdaQueryWrapper managerWrapper0 = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)managerWrapper0.eq(TrainingLearnManager::getProjectId, (Object)schedule.getProjectId())).eq(TrainingLearnManager::getUserId, (Object)user.getId())).eq(TrainingLearnManager::getManagerType, (Object)1);
        List managerLists0 = this.managerMapper.selectList((Wrapper)managerWrapper0);
        if (!this.commonRemoteService.isSuper(user.getId()).booleanValue() && CollectionUtils.isEmpty((Collection)managerLists0)) {
            List shiftIdes;
            List<TrainingLearnManager> managerLists1 = this.getLearnManagerRole(schedule.getProjectId(), user);
            LambdaQueryWrapper managerWrapper2 = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)managerWrapper2.eq(TrainingLearnManager::getProjectId, (Object)schedule.getProjectId())).eq(TrainingLearnManager::getUserId, (Object)user.getId())).eq(TrainingLearnManager::getManagerType, (Object)3);
            List managerLists2 = this.managerMapper.selectList((Wrapper)managerWrapper2);
            LambdaQueryWrapper wrapperIn = new LambdaQueryWrapper();
            wrapperIn.eq(TrainingLearnShift::getProjectId, (Object)schedule.getProjectId());
            if (!CollectionUtils.isEmpty(managerLists1) && CollectionUtils.isEmpty((Collection)managerLists2)) {
                wrapperIn.eq(TrainingLearnShift::getCreatorId, (Object)user.getId());
            } else if (!CollectionUtils.isEmpty(managerLists1) && !CollectionUtils.isEmpty((Collection)managerLists2)) {
                shiftIdes = managerLists2.stream().map(TrainingLearnManager::getShiftId).collect(Collectors.toList());
                wrapperIn.and(wq -> {
                    LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wq.eq(TrainingLearnShift::getCreatorId, (Object)user.getId())).or()).in(TrainingLearnShift::getId, (Collection)shiftIdes);
                });
            } else if (CollectionUtils.isEmpty(managerLists1) && !CollectionUtils.isEmpty((Collection)managerLists2)) {
                shiftIdes = managerLists2.stream().map(TrainingLearnManager::getShiftId).collect(Collectors.toList());
                wrapperIn.in(TrainingLearnShift::getId, shiftIdes);
            }
            List shiftList = this.shiftMapper.selectList((Wrapper)wrapperIn);
            if (!CollectionUtils.isEmpty((Collection)shiftList)) {
                shiftIds = shiftList.stream().map(TrainingLearnShift::getId).collect(Collectors.toList());
            }
        }
        String bool = "0";
        List userList = null;
        if (project.get("creater") != null && !"".equals(project.get("creater")) && (userMap = this.userUtilService.getCheckParameters(project.get("creater").toString(), null, null, user)).get("isEffect").toString().equals("1") && CollectionUtils.isEmpty((Collection)(userList = (List)userMap.get("userList")))) {
            bool = "1";
        }
        if (project.get("shiftId") != null) {
            Integer shiftId = Integer.parseInt(project.get("shiftId").toString());
            if (!CollectionUtils.isEmpty(shiftIds)) {
                shiftIds.retainAll(Arrays.asList(shiftId));
            } else {
                shiftIds = Arrays.asList(shiftId);
            }
        }
        ArrayList<Integer> taskStatuss = new ArrayList<Integer>();
        if (project.get("taskStatus") != null) {
            Integer taskStatus = Integer.parseInt(project.get("taskStatus").toString());
            taskStatuss.add(taskStatus);
        }
        List<TrainingLearnTaskUserVo> taskUserList = null;
        if ("0".equals(bool) && !CollectionUtils.isEmpty(taskUserList = this.taskUserMapper.selectUserTasksByExecl(scheduleIds, userList, shiftIds, taskStatuss))) {
            List<Integer> userIds = taskUserList.stream().map(TrainingLearnTaskUser::getUserId).distinct().collect(Collectors.toList());
            Map<Integer, UsersPojo> usersMap = this.userUtilService.selectUserMap(userIds);
            Map<Integer, List<String>> userOrganizeMap = this.userUtilService.selectOrganizeMap(userIds, user.getGroupId());
            List shiftIdList = taskUserList.stream().map(TrainingLearnTaskUser::getShiftId).distinct().collect(Collectors.toList());
            List shiftList = this.shiftMapper.selectBatchIds(shiftIdList);
            Map shiftMap = shiftList.stream().collect(Collectors.toMap(TrainingLearnShift::getId, Function.identity()));
            HashMap<String, Object> parameter = new HashMap<String, Object>();
            parameter.put("userIds", StringUtils.join(userIds, (String)","));
            parameter.put("groupId", user.getGroupId());
            com.ovopark.privilege.response.BaseResult base = this.roleApi.getUserRoleList(parameter);
            Map roleMap = (Map)base.getData();
            Map<Integer, UserDutiesMo> dutiesMap = this.userUtilService.selectDutiesMap(userIds, user.getGroupId());
            Map<Integer, String> parentMap = this.userUtilService.selectParentMap(userIds, user.getGroupId());
            Map<Integer, Integer> parentIdMap = this.userUtilService.selectParentIdMap(userIds, user.getGroupId());
            for (TrainingLearnTaskUserVo learnTaskUserVo : taskUserList) {
                TrainingLearnShift shiftVo = (TrainingLearnShift)shiftMap.get(learnTaskUserVo.getShiftId());
                learnTaskUserVo.setShiftName(shiftVo.getShiftName());
                learnTaskUserVo.setGroupName(shiftVo.getGroupName());
                learnTaskUserVo.setSupplemenName(shiftVo.getSupplemenName());
                UsersPojo pojo = usersMap.get(learnTaskUserVo.getUserId());
                learnTaskUserVo.setEmployeeNumber(pojo == null ? "" : pojo.getEmployeeNumber());
                learnTaskUserVo.setUserName(pojo == null ? "" : pojo.getShowName());
                learnTaskUserVo.setUserAccount(pojo == null ? "" : pojo.getUserName());
                List<String> userStr = userOrganizeMap.get(learnTaskUserVo.getUserId());
                if (!CollectionUtils.isEmpty(userStr)) {
                    learnTaskUserVo.setOrganizeName(String.join((CharSequence)";\n", userStr));
                }
                TrainingTaskSchedule taskSchedule = (TrainingTaskSchedule)this.scheduleMapper.selectById(learnTaskUserVo.getProjectTaskScheduleId());
                learnTaskUserVo.setTaskStartTime(taskSchedule.getStartTime());
                learnTaskUserVo.setTaskEndTime(taskSchedule.getEndTime());
                learnTaskUserVo.setRole(this.spliceRoleName(roleMap, learnTaskUserVo.getUserId()));
                if (!CollectionUtils.isEmpty(dutiesMap) && dutiesMap.get(learnTaskUserVo.getUserId()) != null) {
                    learnTaskUserVo.setPost(dutiesMap.get(learnTaskUserVo.getUserId()).getDutieName());
                }
                if (!CollectionUtils.isEmpty(parentMap)) {
                    learnTaskUserVo.setParentName(parentMap.get(learnTaskUserVo.getUserId()));
                }
                if (!CollectionUtils.isEmpty(parentIdMap)) {
                    learnTaskUserVo.setParentUserId(parentIdMap.get(learnTaskUserVo.getUserId()));
                }
                if (org.springframework.util.StringUtils.isEmpty((Object)taskSchedule.getPaperId())) continue;
                LambdaQueryWrapper userWrapper = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)userWrapper.eq(TrainingUserPaper::getUserId, (Object)learnTaskUserVo.getUserId())).eq(TrainingUserPaper::getTrainingPaperId, (Object)taskSchedule.getPaperId())).eq(TrainingUserPaper::getSourceType, (Object)3)).eq(TrainingUserPaper::getSourceTaskId, (Object)learnTaskUserVo.getProjectTaskScheduleId())).eq(TrainingUserPaper::getSourceShiftId, (Object)learnTaskUserVo.getShiftId())).isNotNull(TrainingUserPaper::getSubmitTime);
                userWrapper.orderByDesc(TrainingUserPaper::getId);
                List userPaperList = this.userPaperMapper.selectList((Wrapper)userWrapper);
                if (!CollectionUtils.isEmpty((Collection)userPaperList)) {
                    BigDecimal score;
                    TrainingPaper trainingPaper = (TrainingPaper)this.trainingPaperMapper.selectById(taskSchedule.getPaperId());
                    TrainingExam exam = (TrainingExam)this.trainingExamMapper.selectById(trainingPaper.getExamId());
                    if (trainingPaper.getScoreSelect() != null && trainingPaper.getScoreSelect() == 0) {
                        List tempList = userPaperList.stream().filter(e -> e.getPaperStatus() == 2).collect(Collectors.toList());
                        TrainingUserPaper temp = CollectionUtils.isEmpty(tempList) ? (TrainingUserPaper)userPaperList.get(0) : (TrainingUserPaper)tempList.stream().sorted(Comparator.comparing(TrainingUserPaper::getScore).reversed()).collect(Collectors.toList()).get(0);
                        if (temp.getPaperStatus() == 1) {
                            learnTaskUserVo.setTaskStatus(Integer.valueOf(2));
                            learnTaskUserVo.setScore(new BigDecimal(-1));
                            learnTaskUserVo.setCommitTime(temp.getSubmitTime());
                        } else if (temp.getPaperStatus() == 2) {
                            score = temp.getScore();
                            learnTaskUserVo.setScore(score);
                            learnTaskUserVo.setEndTime(temp.getSubmitTime());
                            learnTaskUserVo.setCommitTime(temp.getSubmitTime());
                            if (!org.springframework.util.StringUtils.isEmpty((Object)exam) && score.multiply(new BigDecimal(100)).compareTo(exam.getScore().multiply(new BigDecimal(trainingPaper.getPassLine()))) < 0) {
                                learnTaskUserVo.setTaskStatus(Integer.valueOf(3));
                            } else {
                                learnTaskUserVo.setTaskStatus(Integer.valueOf(4));
                            }
                        }
                    } else {
                        List tempList = userPaperList.stream().filter(e -> e.getPaperStatus() == 2).collect(Collectors.toList());
                        TrainingUserPaper temp = CollectionUtils.isEmpty(tempList) ? (TrainingUserPaper)userPaperList.get(0) : (TrainingUserPaper)tempList.get(0);
                        if (temp.getPaperStatus() == 1) {
                            learnTaskUserVo.setTaskStatus(Integer.valueOf(2));
                            learnTaskUserVo.setCommitTime(temp.getSubmitTime());
                        } else if (temp.getPaperStatus() == 2) {
                            score = temp.getScore();
                            learnTaskUserVo.setScore(score);
                            learnTaskUserVo.setEndTime(temp.getSubmitTime());
                            learnTaskUserVo.setCommitTime(temp.getSubmitTime());
                            if (!org.springframework.util.StringUtils.isEmpty((Object)exam) && score.multiply(new BigDecimal(100)).compareTo(exam.getScore().multiply(new BigDecimal(trainingPaper.getPassLine()))) < 0) {
                                learnTaskUserVo.setTaskStatus(Integer.valueOf(3));
                            } else {
                                learnTaskUserVo.setTaskStatus(Integer.valueOf(4));
                            }
                        }
                    }
                    learnTaskUserVo.setPaperCount(Integer.valueOf(userPaperList.size()));
                }
                if (learnTaskUserVo.getUseTime() != null) {
                    int useTime = learnTaskUserVo.getUseTime();
                    learnTaskUserVo.setUseTimeFormal(DateUtils.getUseTimeFormal(useTime));
                }
                learnTaskUserVo.setTrainingPaperId(taskSchedule.getPaperId());
            }
        }
        return taskUserList;
    }

    @Override
    public Page<TrainingLearnTaskUserVo> selectUserPaperTaskByPage(Page<TrainingLearnTaskUserVo> page, Map<String, Object> project) {
        Map<String, Object> userMap;
        Users user = (Users)project.get("user");
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)wrapper.eq(TrainingTaskSchedule::getTaskId, project.get("taskId"))).isNotNull(TrainingTaskSchedule::getShiftId);
        List scheduleList = this.scheduleMapper.selectList((Wrapper)wrapper);
        List<Integer> scheduleIds = scheduleList.stream().map(TrainingTaskSchedule::getId).collect(Collectors.toList());
        TrainingTaskSchedule schedule = (TrainingTaskSchedule)scheduleList.get(0);
        List<Object> shiftIds = scheduleList.stream().map(TrainingTaskSchedule::getShiftId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        LambdaQueryWrapper managerWrapper0 = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)managerWrapper0.eq(TrainingLearnManager::getProjectId, (Object)schedule.getProjectId())).eq(TrainingLearnManager::getUserId, (Object)user.getId())).eq(TrainingLearnManager::getManagerType, (Object)1);
        List managerLists0 = this.managerMapper.selectList((Wrapper)managerWrapper0);
        if (!this.commonRemoteService.isSuper(user.getId()).booleanValue() && CollectionUtils.isEmpty((Collection)managerLists0)) {
            List shiftIdes;
            List<TrainingLearnManager> managerLists1 = this.getLearnManagerRole(schedule.getProjectId(), user);
            LambdaQueryWrapper managerWrapper2 = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)managerWrapper2.eq(TrainingLearnManager::getProjectId, (Object)schedule.getProjectId())).eq(TrainingLearnManager::getUserId, (Object)user.getId())).eq(TrainingLearnManager::getManagerType, (Object)3);
            List managerLists2 = this.managerMapper.selectList((Wrapper)managerWrapper2);
            LambdaQueryWrapper wrapperIn = new LambdaQueryWrapper();
            wrapperIn.eq(TrainingLearnShift::getProjectId, (Object)schedule.getProjectId());
            if (!CollectionUtils.isEmpty(managerLists1) && CollectionUtils.isEmpty((Collection)managerLists2)) {
                wrapperIn.eq(TrainingLearnShift::getCreatorId, (Object)user.getId());
            } else if (!CollectionUtils.isEmpty(managerLists1) && !CollectionUtils.isEmpty((Collection)managerLists2)) {
                shiftIdes = managerLists2.stream().map(TrainingLearnManager::getShiftId).collect(Collectors.toList());
                wrapperIn.and(wq -> {
                    LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wq.eq(TrainingLearnShift::getCreatorId, (Object)user.getId())).or()).in(TrainingLearnShift::getId, (Collection)shiftIdes);
                });
            } else if (CollectionUtils.isEmpty(managerLists1) && !CollectionUtils.isEmpty((Collection)managerLists2)) {
                shiftIdes = managerLists2.stream().map(TrainingLearnManager::getShiftId).collect(Collectors.toList());
                wrapperIn.in(TrainingLearnShift::getId, shiftIdes);
            }
            List shiftList = this.shiftMapper.selectList((Wrapper)wrapperIn);
            if (!CollectionUtils.isEmpty((Collection)shiftList)) {
                shiftIds = shiftList.stream().map(TrainingLearnShift::getId).collect(Collectors.toList());
            }
        }
        String bool = "0";
        List userList = null;
        if (project.get("creater") != null && !"".equals(project.get("creater")) && (userMap = this.userUtilService.getCheckParameters(project.get("creater").toString(), null, null, user)).get("isEffect").toString().equals("1") && CollectionUtils.isEmpty((Collection)(userList = (List)userMap.get("userList")))) {
            bool = "1";
        }
        if (project.get("shiftId") != null) {
            Integer shiftId = Integer.parseInt(project.get("shiftId").toString());
            if (!CollectionUtils.isEmpty(shiftIds)) {
                shiftIds.retainAll(Arrays.asList(shiftId));
            } else {
                shiftIds = Arrays.asList(shiftId);
            }
        }
        ArrayList<Integer> taskStatuss = new ArrayList<Integer>();
        if (project.get("taskStatus") != null) {
            Integer taskStatus = Integer.parseInt(project.get("taskStatus").toString());
            taskStatuss.add(taskStatus);
        }
        List<TrainingLearnTaskUserVo> taskUserList = null;
        if ("0".equals(bool) && !CollectionUtils.isEmpty(taskUserList = this.taskUserMapper.selectUserTasksByPage(page, scheduleIds, userList, shiftIds, taskStatuss))) {
            List<Integer> userIds = taskUserList.stream().map(TrainingLearnTaskUser::getUserId).distinct().collect(Collectors.toList());
            Map<Integer, UsersPojo> usersMap = this.userUtilService.selectUserMap(userIds);
            Map<Integer, List<String>> userOrganizeMap = this.userUtilService.selectOrganizeMap(userIds, user.getGroupId());
            List shiftIdList = taskUserList.stream().map(TrainingLearnTaskUser::getShiftId).distinct().collect(Collectors.toList());
            List shiftList = this.shiftMapper.selectBatchIds(shiftIdList);
            Map shiftMap = shiftList.stream().collect(Collectors.toMap(TrainingLearnShift::getId, Function.identity()));
            HashMap<String, Object> parameter = new HashMap<String, Object>();
            parameter.put("userIds", StringUtils.join(userIds, (String)","));
            parameter.put("groupId", user.getGroupId());
            com.ovopark.privilege.response.BaseResult base = this.roleApi.getUserRoleList(parameter);
            Map roleMap = (Map)base.getData();
            Map<Integer, UserDutiesMo> dutiesMap = this.userUtilService.selectDutiesMap(userIds, user.getGroupId());
            Map<Integer, String> parentMap = this.userUtilService.selectParentMap(userIds, user.getGroupId());
            Map<Integer, Integer> parentIdMap = this.userUtilService.selectParentIdMap(userIds, user.getGroupId());
            for (TrainingLearnTaskUserVo learnTaskUserVo : taskUserList) {
                TrainingLearnShift shiftVo = (TrainingLearnShift)shiftMap.get(learnTaskUserVo.getShiftId());
                learnTaskUserVo.setShiftName(shiftVo.getShiftName());
                learnTaskUserVo.setGroupName(shiftVo.getGroupName());
                learnTaskUserVo.setSupplemenName(shiftVo.getSupplemenName());
                UsersPojo pojo = usersMap.get(learnTaskUserVo.getUserId());
                learnTaskUserVo.setEmployeeNumber(pojo == null ? "" : pojo.getEmployeeNumber());
                learnTaskUserVo.setUserName(pojo == null ? "" : pojo.getShowName());
                learnTaskUserVo.setUserAccount(pojo == null ? "" : pojo.getUserName());
                List<String> userStr = userOrganizeMap.get(learnTaskUserVo.getUserId());
                if (!CollectionUtils.isEmpty(userStr)) {
                    learnTaskUserVo.setOrganizeName(String.join((CharSequence)";\n", userStr));
                }
                TrainingTaskSchedule taskSchedule = (TrainingTaskSchedule)this.scheduleMapper.selectById(learnTaskUserVo.getProjectTaskScheduleId());
                learnTaskUserVo.setTaskStartTime(taskSchedule.getStartTime());
                learnTaskUserVo.setTaskEndTime(taskSchedule.getEndTime());
                learnTaskUserVo.setRole(this.spliceRoleName(roleMap, learnTaskUserVo.getUserId()));
                if (!CollectionUtils.isEmpty(dutiesMap) && dutiesMap.get(learnTaskUserVo.getUserId()) != null) {
                    learnTaskUserVo.setPost(dutiesMap.get(learnTaskUserVo.getUserId()).getDutieName());
                }
                if (!CollectionUtils.isEmpty(parentMap)) {
                    learnTaskUserVo.setParentName(parentMap.get(learnTaskUserVo.getUserId()));
                }
                if (!CollectionUtils.isEmpty(parentIdMap)) {
                    learnTaskUserVo.setParentUserId(parentIdMap.get(learnTaskUserVo.getUserId()));
                }
                if (org.springframework.util.StringUtils.isEmpty((Object)taskSchedule.getPaperId())) continue;
                LambdaQueryWrapper userWrapper = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)userWrapper.eq(TrainingUserPaper::getUserId, (Object)learnTaskUserVo.getUserId())).eq(TrainingUserPaper::getTrainingPaperId, (Object)taskSchedule.getPaperId())).eq(TrainingUserPaper::getSourceType, (Object)3)).eq(TrainingUserPaper::getSourceTaskId, (Object)learnTaskUserVo.getProjectTaskScheduleId())).eq(TrainingUserPaper::getSourceShiftId, (Object)learnTaskUserVo.getShiftId())).isNotNull(TrainingUserPaper::getSubmitTime);
                userWrapper.orderByDesc(TrainingUserPaper::getId);
                List userPaperList = this.userPaperMapper.selectList((Wrapper)userWrapper);
                if (!CollectionUtils.isEmpty((Collection)userPaperList)) {
                    BigDecimal score;
                    TrainingPaper trainingPaper = (TrainingPaper)this.trainingPaperMapper.selectById(taskSchedule.getPaperId());
                    TrainingExam exam = (TrainingExam)this.trainingExamMapper.selectById(trainingPaper.getExamId());
                    if (trainingPaper.getScoreSelect() != null && trainingPaper.getScoreSelect() == 0) {
                        List tempList = userPaperList.stream().filter(e -> e.getPaperStatus() == 2).collect(Collectors.toList());
                        TrainingUserPaper temp = CollectionUtils.isEmpty(tempList) ? (TrainingUserPaper)userPaperList.get(0) : (TrainingUserPaper)tempList.stream().sorted(Comparator.comparing(TrainingUserPaper::getScore).reversed()).collect(Collectors.toList()).get(0);
                        if (temp.getPaperStatus() == 1) {
                            learnTaskUserVo.setTaskStatus(Integer.valueOf(2));
                            learnTaskUserVo.setScore(new BigDecimal(-1));
                            learnTaskUserVo.setCommitTime(temp.getSubmitTime());
                        } else if (temp.getPaperStatus() == 2) {
                            score = temp.getScore();
                            learnTaskUserVo.setScore(score);
                            learnTaskUserVo.setEndTime(temp.getSubmitTime());
                            learnTaskUserVo.setCommitTime(temp.getSubmitTime());
                            if (!org.springframework.util.StringUtils.isEmpty((Object)exam) && score.multiply(new BigDecimal(100)).compareTo(exam.getScore().multiply(new BigDecimal(trainingPaper.getPassLine()))) < 0) {
                                learnTaskUserVo.setTaskStatus(Integer.valueOf(3));
                            } else {
                                learnTaskUserVo.setTaskStatus(Integer.valueOf(4));
                            }
                        }
                    } else {
                        List tempList = userPaperList.stream().filter(e -> e.getPaperStatus() == 2).collect(Collectors.toList());
                        TrainingUserPaper temp = CollectionUtils.isEmpty(tempList) ? (TrainingUserPaper)userPaperList.get(0) : (TrainingUserPaper)tempList.get(0);
                        if (temp.getPaperStatus() == 1) {
                            learnTaskUserVo.setTaskStatus(Integer.valueOf(2));
                            learnTaskUserVo.setCommitTime(temp.getSubmitTime());
                        } else if (temp.getPaperStatus() == 2) {
                            score = temp.getScore();
                            learnTaskUserVo.setScore(score);
                            learnTaskUserVo.setEndTime(temp.getSubmitTime());
                            learnTaskUserVo.setCommitTime(temp.getSubmitTime());
                            if (!org.springframework.util.StringUtils.isEmpty((Object)exam) && score.multiply(new BigDecimal(100)).compareTo(exam.getScore().multiply(new BigDecimal(trainingPaper.getPassLine()))) < 0) {
                                learnTaskUserVo.setTaskStatus(Integer.valueOf(3));
                            } else {
                                learnTaskUserVo.setTaskStatus(Integer.valueOf(4));
                            }
                        }
                    }
                    learnTaskUserVo.setPaperCount(Integer.valueOf(userPaperList.size()));
                }
                if (learnTaskUserVo.getUseTime() != null) {
                    int useTime = learnTaskUserVo.getUseTime();
                    learnTaskUserVo.setUseTimeFormal(DateUtils.getUseTimeFormal(useTime));
                }
                learnTaskUserVo.setTrainingPaperId(taskSchedule.getPaperId());
            }
        }
        page.setContent(taskUserList);
        return page;
    }

    @Override
    public List<TrainingLearnTaskUserVo> getUserPaperTask2(Map<String, Object> project) {
        Map<String, Object> userMap;
        Users user = (Users)JSON.parseObject((String)JSON.toJSONString((Object)project.get("user")), Users.class);
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)wrapper.eq(TrainingTaskSchedule::getTaskId, project.get("taskId"))).isNotNull(TrainingTaskSchedule::getShiftId);
        List scheduleList = this.scheduleMapper.selectList((Wrapper)wrapper);
        List<Integer> scheduleIds = scheduleList.stream().map(TrainingTaskSchedule::getId).collect(Collectors.toList());
        TrainingTaskSchedule schedule = (TrainingTaskSchedule)scheduleList.get(0);
        List<Object> shiftIds = scheduleList.stream().map(TrainingTaskSchedule::getShiftId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        LambdaQueryWrapper managerWrapper0 = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)managerWrapper0.eq(TrainingLearnManager::getProjectId, (Object)schedule.getProjectId())).eq(TrainingLearnManager::getUserId, (Object)user.getId())).eq(TrainingLearnManager::getManagerType, (Object)1);
        List managerLists0 = this.managerMapper.selectList((Wrapper)managerWrapper0);
        if (!this.commonRemoteService.isSuper(user.getId()).booleanValue() && CollectionUtils.isEmpty((Collection)managerLists0)) {
            List shiftIdes;
            List<TrainingLearnManager> managerLists1 = this.getLearnManagerRole(schedule.getProjectId(), user);
            LambdaQueryWrapper managerWrapper2 = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)managerWrapper2.eq(TrainingLearnManager::getProjectId, (Object)schedule.getProjectId())).eq(TrainingLearnManager::getUserId, (Object)user.getId())).eq(TrainingLearnManager::getManagerType, (Object)3);
            List managerLists2 = this.managerMapper.selectList((Wrapper)managerWrapper2);
            LambdaQueryWrapper wrapperIn = new LambdaQueryWrapper();
            wrapperIn.eq(TrainingLearnShift::getProjectId, (Object)schedule.getProjectId());
            if (!CollectionUtils.isEmpty(managerLists1) && CollectionUtils.isEmpty((Collection)managerLists2)) {
                wrapperIn.eq(TrainingLearnShift::getCreatorId, (Object)user.getId());
            } else if (!CollectionUtils.isEmpty(managerLists1) && !CollectionUtils.isEmpty((Collection)managerLists2)) {
                shiftIdes = managerLists2.stream().map(TrainingLearnManager::getShiftId).collect(Collectors.toList());
                wrapperIn.and(wq -> {
                    LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wq.eq(TrainingLearnShift::getCreatorId, (Object)user.getId())).or()).in(TrainingLearnShift::getId, (Collection)shiftIdes);
                });
            } else if (CollectionUtils.isEmpty(managerLists1) && !CollectionUtils.isEmpty((Collection)managerLists2)) {
                shiftIdes = managerLists2.stream().map(TrainingLearnManager::getShiftId).collect(Collectors.toList());
                wrapperIn.in(TrainingLearnShift::getId, shiftIdes);
            }
            List shiftList = this.shiftMapper.selectList((Wrapper)wrapperIn);
            if (!CollectionUtils.isEmpty((Collection)shiftList)) {
                shiftIds = shiftList.stream().map(TrainingLearnShift::getId).collect(Collectors.toList());
            }
        }
        String bool = "0";
        List userList = null;
        if (project.get("creater") != null && !"".equals(project.get("creater")) && (userMap = this.userUtilService.getCheckParameters(project.get("creater").toString(), null, null, user)).get("isEffect").toString().equals("1") && CollectionUtils.isEmpty((Collection)(userList = (List)userMap.get("userList")))) {
            bool = "1";
        }
        if (project.get("shiftId") != null) {
            Integer shiftId = Integer.parseInt(project.get("shiftId").toString());
            if (!CollectionUtils.isEmpty(shiftIds)) {
                shiftIds.retainAll(Arrays.asList(shiftId));
            } else {
                shiftIds = Arrays.asList(shiftId);
            }
        }
        ArrayList<Integer> taskStatuss = new ArrayList<Integer>();
        if (project.get("taskStatus") != null) {
            Integer taskStatus = Integer.parseInt(project.get("taskStatus").toString());
            taskStatuss.add(taskStatus);
        }
        List<TrainingLearnTaskUserVo> taskUserList = null;
        ArrayList<TrainingLearnTaskUserVo> result = new ArrayList<TrainingLearnTaskUserVo>();
        if ("0".equals(bool) && !CollectionUtils.isEmpty(taskUserList = this.taskUserMapper.selectUserTasksByExecl(scheduleIds, userList, shiftIds, taskStatuss))) {
            List<Integer> userIds = taskUserList.stream().map(TrainingLearnTaskUser::getUserId).distinct().collect(Collectors.toList());
            Map<Integer, UsersPojo> usersMap = this.userUtilService.selectUserMap(userIds);
            Map<Integer, List<String>> userOrganizeMap = this.userUtilService.selectOrganizeMap(userIds, user.getGroupId());
            List shiftIdList = taskUserList.stream().map(TrainingLearnTaskUser::getShiftId).distinct().collect(Collectors.toList());
            List shiftList = this.shiftMapper.selectBatchIds(shiftIdList);
            Map shiftMap = shiftList.stream().collect(Collectors.toMap(TrainingLearnShift::getId, Function.identity()));
            HashMap<String, Object> parameter = new HashMap<String, Object>();
            parameter.put("userIds", StringUtils.join(userIds, (String)","));
            parameter.put("groupId", user.getGroupId());
            com.ovopark.privilege.response.BaseResult base = this.roleApi.getUserRoleList(parameter);
            Map roleMap = (Map)base.getData();
            Map<Integer, UserDutiesMo> dutiesMap = this.userUtilService.selectDutiesMap(userIds, user.getGroupId());
            Map<Integer, String> parentMap = this.userUtilService.selectParentMap(userIds, user.getGroupId());
            Map<Integer, Integer> parentIdMap = this.userUtilService.selectParentIdMap(userIds, user.getGroupId());
            for (TrainingLearnTaskUserVo learnTaskUserVo : taskUserList) {
                TrainingLearnTaskUserVo vo = new TrainingLearnTaskUserVo();
                TrainingLearnShift shiftVo = (TrainingLearnShift)shiftMap.get(learnTaskUserVo.getShiftId());
                learnTaskUserVo.setShiftName(shiftVo.getShiftName());
                learnTaskUserVo.setGroupName(shiftVo.getGroupName());
                learnTaskUserVo.setSupplemenName(shiftVo.getSupplemenName());
                UsersPojo pojo = usersMap.get(learnTaskUserVo.getUserId());
                learnTaskUserVo.setEmployeeNumber(pojo == null ? "" : pojo.getEmployeeNumber());
                learnTaskUserVo.setUserName(pojo == null ? "" : pojo.getShowName());
                learnTaskUserVo.setUserAccount(pojo == null ? "" : pojo.getUserName());
                List<String> userStr = userOrganizeMap.get(learnTaskUserVo.getUserId());
                if (!CollectionUtils.isEmpty(userStr)) {
                    learnTaskUserVo.setOrganizeName(String.join((CharSequence)";", userStr));
                }
                TrainingTaskSchedule taskSchedule = (TrainingTaskSchedule)this.scheduleMapper.selectById(learnTaskUserVo.getProjectTaskScheduleId());
                learnTaskUserVo.setTaskStartTime(taskSchedule.getStartTime());
                learnTaskUserVo.setTaskEndTime(taskSchedule.getEndTime());
                learnTaskUserVo.setRole(this.spliceRoleName(roleMap, learnTaskUserVo.getUserId()));
                if (!CollectionUtils.isEmpty(dutiesMap) && dutiesMap.get(learnTaskUserVo.getUserId()) != null) {
                    learnTaskUserVo.setPost(dutiesMap.get(learnTaskUserVo.getUserId()).getDutieName());
                }
                if (!CollectionUtils.isEmpty(parentMap)) {
                    learnTaskUserVo.setParentName(parentMap.get(learnTaskUserVo.getUserId()));
                }
                if (!CollectionUtils.isEmpty(parentIdMap)) {
                    learnTaskUserVo.setParentUserId(parentIdMap.get(learnTaskUserVo.getUserId()));
                }
                if (!org.springframework.util.StringUtils.isEmpty((Object)taskSchedule.getPaperId())) {
                    LambdaQueryWrapper userWrapper = new LambdaQueryWrapper();
                    ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)userWrapper.eq(TrainingUserPaper::getUserId, (Object)learnTaskUserVo.getUserId())).eq(TrainingUserPaper::getTrainingPaperId, (Object)taskSchedule.getPaperId())).eq(TrainingUserPaper::getSourceType, (Object)3)).eq(TrainingUserPaper::getSourceTaskId, (Object)learnTaskUserVo.getProjectTaskScheduleId())).eq(TrainingUserPaper::getSourceShiftId, (Object)learnTaskUserVo.getShiftId())).isNotNull(TrainingUserPaper::getSubmitTime);
                    userWrapper.orderByDesc(TrainingUserPaper::getId);
                    List userPaperList = this.userPaperMapper.selectList((Wrapper)userWrapper);
                    if (!CollectionUtils.isEmpty((Collection)userPaperList)) {
                        for (TrainingUserPaper userPaper : userPaperList) {
                            TrainingPaper paper = (TrainingPaper)this.trainingPaperMapper.selectById(userPaper.getTrainingPaperId());
                            BigDecimal org_score = ((TrainingExam)this.trainingExamMapper.selectById(paper.getExamId())).getScore();
                            vo = new TrainingLearnTaskUserVo();
                            BeanUtils.copyProperties((Object)learnTaskUserVo, (Object)vo);
                            vo.setTrainingPaperId(userPaper.getTrainingPaperId());
                            vo.setCommitTime(userPaper.getSubmitTime());
                            vo.setUseTime(Integer.valueOf(new BigDecimal((userPaper.getSubmitTime().getTime() - userPaper.getUpdateTime().getTime()) / 1000L).intValue()));
                            vo.setUseTimeFormal(DateUtils.getUseTimeFormal(vo.getUseTime()));
                            if (Objects.nonNull(userPaper.getUpdateTime()) && userPaper.getPaperStatus() == 0) {
                                vo.setTaskStatus(Integer.valueOf(2));
                                vo.setScore(new BigDecimal(-2));
                            } else if (Objects.nonNull(userPaper.getUpdateTime()) && userPaper.getPaperStatus() == 1) {
                                vo.setTaskStatus(Integer.valueOf(5));
                                vo.setScore(new BigDecimal(-1));
                            } else {
                                vo.setTaskStatus(Integer.valueOf(this.isPass(org_score, userPaper.getScore(), paper.getPassLine())));
                                vo.setScore(userPaper.getScore());
                            }
                            result.add(vo);
                        }
                        continue;
                    }
                    if (learnTaskUserVo.getUseTime() != null) {
                        int useTime = learnTaskUserVo.getUseTime();
                        learnTaskUserVo.setUseTimeFormal(DateUtils.getUseTimeFormal(useTime));
                    }
                    learnTaskUserVo.setTrainingPaperId(taskSchedule.getPaperId());
                }
                BeanUtils.copyProperties((Object)learnTaskUserVo, (Object)vo);
                result.add(vo);
            }
        }
        return result;
    }

    @Override
    public Page<TrainingLearnTaskUserVo> selectUserPaperTaskByPage2(Page<TrainingLearnTaskUserVo> page, Map<String, Object> project) {
        Map<String, Object> userMap;
        Users user = (Users)project.get("user");
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)wrapper.eq(TrainingTaskSchedule::getTaskId, project.get("taskId"))).isNotNull(TrainingTaskSchedule::getShiftId);
        List scheduleList = this.scheduleMapper.selectList((Wrapper)wrapper);
        List<Integer> scheduleIds = scheduleList.stream().map(TrainingTaskSchedule::getId).collect(Collectors.toList());
        TrainingTaskSchedule schedule = (TrainingTaskSchedule)scheduleList.get(0);
        List<Object> shiftIds = scheduleList.stream().map(TrainingTaskSchedule::getShiftId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        LambdaQueryWrapper managerWrapper0 = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)managerWrapper0.eq(TrainingLearnManager::getProjectId, (Object)schedule.getProjectId())).eq(TrainingLearnManager::getUserId, (Object)user.getId())).eq(TrainingLearnManager::getManagerType, (Object)1);
        List managerLists0 = this.managerMapper.selectList((Wrapper)managerWrapper0);
        if (!this.commonRemoteService.isSuper(user.getId()).booleanValue() && CollectionUtils.isEmpty((Collection)managerLists0)) {
            List shiftIdes;
            List<TrainingLearnManager> managerLists1 = this.getLearnManagerRole(schedule.getProjectId(), user);
            LambdaQueryWrapper managerWrapper2 = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)managerWrapper2.eq(TrainingLearnManager::getProjectId, (Object)schedule.getProjectId())).eq(TrainingLearnManager::getUserId, (Object)user.getId())).eq(TrainingLearnManager::getManagerType, (Object)3);
            List managerLists2 = this.managerMapper.selectList((Wrapper)managerWrapper2);
            LambdaQueryWrapper wrapperIn = new LambdaQueryWrapper();
            wrapperIn.eq(TrainingLearnShift::getProjectId, (Object)schedule.getProjectId());
            if (!CollectionUtils.isEmpty(managerLists1) && CollectionUtils.isEmpty((Collection)managerLists2)) {
                wrapperIn.eq(TrainingLearnShift::getCreatorId, (Object)user.getId());
            } else if (!CollectionUtils.isEmpty(managerLists1) && !CollectionUtils.isEmpty((Collection)managerLists2)) {
                shiftIdes = managerLists2.stream().map(TrainingLearnManager::getShiftId).collect(Collectors.toList());
                wrapperIn.and(wq -> {
                    LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wq.eq(TrainingLearnShift::getCreatorId, (Object)user.getId())).or()).in(TrainingLearnShift::getId, (Collection)shiftIdes);
                });
            } else if (CollectionUtils.isEmpty(managerLists1) && !CollectionUtils.isEmpty((Collection)managerLists2)) {
                shiftIdes = managerLists2.stream().map(TrainingLearnManager::getShiftId).collect(Collectors.toList());
                wrapperIn.in(TrainingLearnShift::getId, shiftIdes);
            }
            List shiftList = this.shiftMapper.selectList((Wrapper)wrapperIn);
            if (!CollectionUtils.isEmpty((Collection)shiftList)) {
                shiftIds = shiftList.stream().map(TrainingLearnShift::getId).collect(Collectors.toList());
            }
        }
        String bool = "0";
        List userList = null;
        if (project.get("creater") != null && !"".equals(project.get("creater")) && (userMap = this.userUtilService.getCheckParameters(project.get("creater").toString(), null, null, user)).get("isEffect").toString().equals("1") && CollectionUtils.isEmpty((Collection)(userList = (List)userMap.get("userList")))) {
            bool = "1";
        }
        if (project.get("shiftId") != null) {
            Integer shiftId = Integer.parseInt(project.get("shiftId").toString());
            if (!CollectionUtils.isEmpty(shiftIds)) {
                shiftIds.retainAll(Arrays.asList(shiftId));
            } else {
                shiftIds = Arrays.asList(shiftId);
            }
        }
        ArrayList<Integer> taskStatuss = new ArrayList<Integer>();
        if (project.get("taskStatus") != null) {
            Integer taskStatus = Integer.parseInt(project.get("taskStatus").toString());
            taskStatuss.add(taskStatus);
        }
        List<TrainingLearnTaskUserVo> taskUserList = null;
        ArrayList<TrainingLearnTaskUserVo> result = new ArrayList<TrainingLearnTaskUserVo>();
        if ("0".equals(bool) && !CollectionUtils.isEmpty(taskUserList = this.taskUserMapper.selectUserTasksByPage(page, scheduleIds, userList, shiftIds, taskStatuss))) {
            List<Integer> userIds = taskUserList.stream().map(TrainingLearnTaskUser::getUserId).distinct().collect(Collectors.toList());
            Map<Integer, UsersPojo> usersMap = this.userUtilService.selectUserMap(userIds);
            Map<Integer, List<String>> userOrganizeMap = this.userUtilService.selectOrganizeMap(userIds, user.getGroupId());
            List shiftIdList = taskUserList.stream().map(TrainingLearnTaskUser::getShiftId).distinct().collect(Collectors.toList());
            List shiftList = this.shiftMapper.selectBatchIds(shiftIdList);
            Map shiftMap = shiftList.stream().collect(Collectors.toMap(TrainingLearnShift::getId, Function.identity()));
            for (TrainingLearnTaskUserVo learnTaskUserVo : taskUserList) {
                TrainingLearnTaskUserVo vo = new TrainingLearnTaskUserVo();
                TrainingLearnShift shiftVo = (TrainingLearnShift)shiftMap.get(learnTaskUserVo.getShiftId());
                learnTaskUserVo.setShiftName(shiftVo.getShiftName());
                learnTaskUserVo.setGroupName(shiftVo.getGroupName());
                learnTaskUserVo.setSupplemenName(shiftVo.getSupplemenName());
                UsersPojo pojo = usersMap.get(learnTaskUserVo.getUserId());
                learnTaskUserVo.setEmployeeNumber(pojo == null ? "" : pojo.getEmployeeNumber());
                learnTaskUserVo.setUserName(pojo == null ? "" : pojo.getShowName());
                List<String> userStr = userOrganizeMap.get(learnTaskUserVo.getUserId());
                if (!CollectionUtils.isEmpty(userStr)) {
                    learnTaskUserVo.setOrganizeName(String.join((CharSequence)";", userStr));
                }
                TrainingTaskSchedule taskSchedule = (TrainingTaskSchedule)this.scheduleMapper.selectById(learnTaskUserVo.getProjectTaskScheduleId());
                learnTaskUserVo.setTaskStartTime(taskSchedule.getStartTime());
                learnTaskUserVo.setTaskEndTime(taskSchedule.getEndTime());
                if (!org.springframework.util.StringUtils.isEmpty((Object)taskSchedule.getPaperId())) {
                    LambdaQueryWrapper userWrapper = new LambdaQueryWrapper();
                    ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)userWrapper.eq(TrainingUserPaper::getUserId, (Object)learnTaskUserVo.getUserId())).eq(TrainingUserPaper::getTrainingPaperId, (Object)taskSchedule.getPaperId())).eq(TrainingUserPaper::getSourceType, (Object)3)).eq(TrainingUserPaper::getSourceTaskId, (Object)learnTaskUserVo.getProjectTaskScheduleId())).eq(TrainingUserPaper::getSourceShiftId, (Object)learnTaskUserVo.getShiftId())).isNotNull(TrainingUserPaper::getSubmitTime);
                    userWrapper.orderByDesc(TrainingUserPaper::getId);
                    List userPaperList = this.userPaperMapper.selectList((Wrapper)userWrapper);
                    if (!CollectionUtils.isEmpty((Collection)userPaperList)) {
                        for (TrainingUserPaper userPaper : userPaperList) {
                            TrainingExam trainingExam;
                            TrainingPaper paper = (TrainingPaper)this.trainingPaperMapper.selectById(userPaper.getTrainingPaperId());
                            BigDecimal org_score = new BigDecimal("100");
                            if (paper.getExamId() != null && !ObjectUtils.isEmpty((Object)(trainingExam = (TrainingExam)this.trainingExamMapper.selectById(paper.getExamId())))) {
                                org_score = trainingExam.getScore();
                            }
                            vo = new TrainingLearnTaskUserVo();
                            BeanUtils.copyProperties((Object)learnTaskUserVo, (Object)vo);
                            vo.setTrainingPaperId(userPaper.getTrainingPaperId());
                            vo.setCommitTime(userPaper.getSubmitTime());
                            vo.setUseTime(Integer.valueOf(new BigDecimal((userPaper.getSubmitTime().getTime() - userPaper.getUpdateTime().getTime()) / 1000L).intValue()));
                            vo.setUseTimeFormal(DateUtils.getUseTimeFormal(vo.getUseTime()));
                            if (Objects.nonNull(userPaper.getUpdateTime()) && userPaper.getPaperStatus() == 0) {
                                vo.setTaskStatus(Integer.valueOf(2));
                                vo.setScore(new BigDecimal(-2));
                            } else if (Objects.nonNull(userPaper.getUpdateTime()) && userPaper.getPaperStatus() == 1) {
                                vo.setTaskStatus(Integer.valueOf(5));
                                vo.setScore(new BigDecimal(-1));
                            } else {
                                vo.setTaskStatus(Integer.valueOf(this.isPass(org_score, userPaper.getScore(), paper.getPassLine())));
                                vo.setScore(userPaper.getScore());
                            }
                            result.add(vo);
                        }
                        continue;
                    }
                    if (learnTaskUserVo.getUseTime() != null) {
                        int useTime = learnTaskUserVo.getUseTime();
                        learnTaskUserVo.setUseTimeFormal(DateUtils.getUseTimeFormal(useTime));
                    }
                    learnTaskUserVo.setTrainingPaperId(taskSchedule.getPaperId());
                }
                BeanUtils.copyProperties((Object)learnTaskUserVo, (Object)vo);
                result.add(vo);
            }
        }
        page.setContent(result);
        return page;
    }

    private int isPass(BigDecimal org_score, BigDecimal score, int passLine) {
        BigDecimal percent = new BigDecimal(passLine).divide(new BigDecimal(100));
        BigDecimal result = org_score.multiply(percent);
        if (score.compareTo(result) >= 0) {
            return 3;
        }
        return 4;
    }

    @Override
    public List<TrainingLearnTaskUserVo> selectUserPaperDetail(TrainingUserPaper project) {
        ArrayList<TrainingLearnTaskUserVo> voList = new ArrayList<TrainingLearnTaskUserVo>();
        LambdaQueryWrapper userWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)userWrapper.eq(TrainingUserPaper::getUserId, (Object)project.getUserId())).eq(TrainingUserPaper::getTrainingPaperId, (Object)project.getTrainingPaperId())).eq(TrainingUserPaper::getSourceType, (Object)5)).isNotNull(TrainingUserPaper::getSubmitTime)).orderByAsc(TrainingUserPaper::getSubmitTime);
        List paperList = this.userPaperMapper.selectList((Wrapper)userWrapper);
        for (TrainingUserPaper userPaper : paperList) {
            TrainingLearnTaskUserVo vo = new TrainingLearnTaskUserVo();
            vo.setEndTime(userPaper.getSubmitTime());
            vo.setScore(userPaper.getScore());
            if (userPaper.getSubmitTime() != null && userPaper.getUpdateTime() != null) {
                int useTime = (int)((userPaper.getSubmitTime().getTime() - userPaper.getUpdateTime().getTime()) / 1000L);
                vo.setUseTimeFormal(DateUtils.getUseTimeFormal(useTime));
            }
            voList.add(vo);
        }
        return voList;
    }

    @Override
    public List<TrainingLearnTaskUserVo> getUserOfflineTask(Map<String, Object> project) {
        Map<String, Object> userMap;
        Users user = (Users)JSON.parseObject((String)JSON.toJSONString((Object)project.get("user")), Users.class);
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)wrapper.eq(TrainingTaskSchedule::getTaskId, project.get("taskId"))).isNotNull(TrainingTaskSchedule::getShiftId);
        List scheduleList = this.scheduleMapper.selectList((Wrapper)wrapper);
        List<Integer> scheduleIds = scheduleList.stream().map(TrainingTaskSchedule::getId).collect(Collectors.toList());
        TrainingTaskSchedule schedule = (TrainingTaskSchedule)scheduleList.get(0);
        List<Integer> shiftIds = scheduleList.stream().map(TrainingTaskSchedule::getShiftId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        LambdaQueryWrapper managerWrapper0 = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)managerWrapper0.eq(TrainingLearnManager::getProjectId, (Object)schedule.getProjectId())).eq(TrainingLearnManager::getUserId, (Object)user.getId())).eq(TrainingLearnManager::getManagerType, (Object)1);
        List managerLists0 = this.managerMapper.selectList((Wrapper)managerWrapper0);
        if (!this.commonRemoteService.isSuper(user.getId()).booleanValue() && CollectionUtils.isEmpty((Collection)managerLists0)) {
            List shiftIdes;
            List<TrainingLearnManager> managerLists1 = this.getLearnManagerRole(schedule.getProjectId(), user);
            LambdaQueryWrapper managerWrapper2 = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)managerWrapper2.eq(TrainingLearnManager::getProjectId, (Object)schedule.getProjectId())).eq(TrainingLearnManager::getUserId, (Object)user.getId())).eq(TrainingLearnManager::getManagerType, (Object)3);
            List managerLists2 = this.managerMapper.selectList((Wrapper)managerWrapper2);
            LambdaQueryWrapper wrapperIn = new LambdaQueryWrapper();
            wrapperIn.eq(TrainingLearnShift::getProjectId, (Object)schedule.getProjectId());
            if (!CollectionUtils.isEmpty(managerLists1) && CollectionUtils.isEmpty((Collection)managerLists2)) {
                wrapperIn.eq(TrainingLearnShift::getCreatorId, (Object)user.getId());
            } else if (!CollectionUtils.isEmpty(managerLists1) && !CollectionUtils.isEmpty((Collection)managerLists2)) {
                shiftIdes = managerLists2.stream().map(TrainingLearnManager::getShiftId).collect(Collectors.toList());
                wrapperIn.and(wq -> {
                    LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wq.eq(TrainingLearnShift::getCreatorId, (Object)user.getId())).or()).in(TrainingLearnShift::getId, (Collection)shiftIdes);
                });
            } else if (CollectionUtils.isEmpty(managerLists1) && !CollectionUtils.isEmpty((Collection)managerLists2)) {
                shiftIdes = managerLists2.stream().map(TrainingLearnManager::getShiftId).collect(Collectors.toList());
                wrapperIn.in(TrainingLearnShift::getId, shiftIdes);
            }
            List shiftList = this.shiftMapper.selectList((Wrapper)wrapperIn);
            if (!CollectionUtils.isEmpty((Collection)shiftList)) {
                shiftIds = shiftList.stream().map(TrainingLearnShift::getId).collect(Collectors.toList());
            }
        }
        String bool = "0";
        List userList = null;
        if (project.get("creater") != null && !"".equals(project.get("creater")) && (userMap = this.userUtilService.getCheckParameters(project.get("creater").toString(), null, null, user)).get("isEffect").toString().equals("1") && CollectionUtils.isEmpty((Collection)(userList = (List)userMap.get("userList")))) {
            bool = "1";
        }
        if (project.get("shiftId") != null) {
            Integer shiftId = Integer.parseInt(project.get("shiftId").toString());
            if (!CollectionUtils.isEmpty(shiftIds)) {
                shiftIds.retainAll(Arrays.asList(shiftId));
            } else {
                shiftIds = Arrays.asList(shiftId);
            }
        }
        List<TrainingLearnTaskUserVo> taskUserList = null;
        if ("0".equals(bool) && !CollectionUtils.isEmpty(taskUserList = this.taskUserMapper.selectUserTasksByExecl(scheduleIds, userList, shiftIds, null))) {
            List<Integer> userIds = taskUserList.stream().map(TrainingLearnTaskUser::getUserId).distinct().collect(Collectors.toList());
            Map<Integer, UsersPojo> usersMap = this.userUtilService.selectUserMap(userIds);
            Map<Integer, List<String>> userOrganizeMap = this.userUtilService.selectOrganizeMap(userIds, user.getGroupId());
            List shiftIdList = taskUserList.stream().map(TrainingLearnTaskUser::getShiftId).distinct().collect(Collectors.toList());
            List shiftList = this.shiftMapper.selectBatchIds(shiftIdList);
            Map shiftMap = shiftList.stream().collect(Collectors.toMap(TrainingLearnShift::getId, Function.identity()));
            HashMap<String, Object> parameter = new HashMap<String, Object>();
            parameter.put("userIds", StringUtils.join(userIds, (String)","));
            parameter.put("groupId", user.getGroupId());
            com.ovopark.privilege.response.BaseResult base = this.roleApi.getUserRoleList(parameter);
            Map roleMap = (Map)base.getData();
            Map<Integer, UserDutiesMo> dutiesMap = this.userUtilService.selectDutiesMap(userIds, user.getGroupId());
            Map<Integer, String> parentMap = this.userUtilService.selectParentMap(userIds, user.getGroupId());
            Map<Integer, Integer> parentIdMap = this.userUtilService.selectParentIdMap(userIds, user.getGroupId());
            for (TrainingLearnTaskUserVo learnTaskUserVo : taskUserList) {
                int cutTime;
                TrainingLearnShift shiftVo = (TrainingLearnShift)shiftMap.get(learnTaskUserVo.getShiftId());
                learnTaskUserVo.setShiftName(shiftVo.getShiftName());
                learnTaskUserVo.setGroupName(shiftVo.getGroupName());
                learnTaskUserVo.setSupplemenName(shiftVo.getSupplemenName());
                UsersPojo pojo = usersMap.get(learnTaskUserVo.getUserId());
                learnTaskUserVo.setEmployeeNumber(pojo == null ? "" : pojo.getEmployeeNumber());
                learnTaskUserVo.setUserName(pojo == null ? "" : pojo.getShowName());
                learnTaskUserVo.setUserAccount(pojo == null ? "" : pojo.getUserName());
                List<String> userStr = userOrganizeMap.get(learnTaskUserVo.getUserId());
                if (!CollectionUtils.isEmpty(userStr)) {
                    learnTaskUserVo.setOrganizeName(String.join((CharSequence)";\n", userStr));
                }
                TrainingTaskSchedule sc = (TrainingTaskSchedule)this.scheduleMapper.selectById(learnTaskUserVo.getProjectTaskScheduleId());
                int actTime = 0;
                if (sc != null) {
                    learnTaskUserVo.setTaskStartTime(sc.getStartTime());
                    learnTaskUserVo.setTaskEndTime(sc.getEndTime());
                    if (sc.getStartTime() != null && sc.getEndTime() != null) {
                        actTime = (int)(sc.getEndTime().getTime() - sc.getStartTime().getTime());
                        learnTaskUserVo.setActTime(new BigDecimal((double)actTime / 3600000.0).setScale(1, 4));
                    }
                }
                int userTime = 0;
                if (learnTaskUserVo.getStartTime() != null && learnTaskUserVo.getEndTime() != null) {
                    if (sc != null) {
                        if (!(sc.getEndTime() != null && learnTaskUserVo.getStartTime().compareTo(sc.getEndTime()) >= 0 || sc.getStartTime() != null && learnTaskUserVo.getEndTime().compareTo(sc.getStartTime()) <= 0)) {
                            userTime = sc.getStartTime() != null && learnTaskUserVo.getStartTime().compareTo(sc.getStartTime()) < 0 ? (int)(learnTaskUserVo.getEndTime().getTime() - sc.getStartTime().getTime()) : (sc.getEndTime() != null && learnTaskUserVo.getEndTime().compareTo(sc.getEndTime()) > 0 ? (int)(sc.getEndTime().getTime() - learnTaskUserVo.getStartTime().getTime()) : (int)(learnTaskUserVo.getEndTime().getTime() - learnTaskUserVo.getStartTime().getTime()));
                        }
                    } else {
                        userTime = (int)(learnTaskUserVo.getEndTime().getTime() - learnTaskUserVo.getStartTime().getTime());
                    }
                }
                if (userTime > actTime) {
                    userTime = actTime;
                }
                int n = cutTime = actTime > userTime ? actTime - userTime : 0;
                learnTaskUserVo.setOutRate(new BigDecimal(actTime == 0 ? 0.0 : (actTime >= userTime ? 100.0 * (double)userTime / (double)actTime : 100.0)).setScale(2, 4));
                learnTaskUserVo.setUseTimeVo(new BigDecimal((double)userTime / 3600000.0).setScale(1, 4));
                learnTaskUserVo.setCutTimeVo(new BigDecimal((double)cutTime / 3600000.0).setScale(1, 4));
                int num = 0;
                if (learnTaskUserVo.getStartTime() == null) {
                    ++num;
                }
                if (learnTaskUserVo.getEndTime() == null) {
                    ++num;
                }
                learnTaskUserVo.setIsAllTime(Integer.valueOf(num));
                learnTaskUserVo.setRole(this.spliceRoleName(roleMap, learnTaskUserVo.getUserId()));
                if (!CollectionUtils.isEmpty(dutiesMap) && dutiesMap.get(learnTaskUserVo.getUserId()) != null) {
                    learnTaskUserVo.setPost(dutiesMap.get(learnTaskUserVo.getUserId()).getDutieName());
                }
                if (!CollectionUtils.isEmpty(parentMap)) {
                    learnTaskUserVo.setParentName(parentMap.get(learnTaskUserVo.getUserId()));
                }
                if (CollectionUtils.isEmpty(parentIdMap)) continue;
                learnTaskUserVo.setParentUserId(parentIdMap.get(learnTaskUserVo.getUserId()));
            }
        }
        return taskUserList;
    }

    @Override
    public Page<TrainingLearnTaskUserVo> selectUserOfflineTaskByPage(Page<TrainingLearnTaskUserVo> page, Map<String, Object> project) {
        Map<String, Object> userMap;
        Users user = (Users)project.get("user");
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)wrapper.eq(TrainingTaskSchedule::getTaskId, project.get("taskId"))).isNotNull(TrainingTaskSchedule::getShiftId);
        List scheduleList = this.scheduleMapper.selectList((Wrapper)wrapper);
        List<Integer> scheduleIds = scheduleList.stream().map(TrainingTaskSchedule::getId).collect(Collectors.toList());
        TrainingTaskSchedule schedule = (TrainingTaskSchedule)scheduleList.get(0);
        List<Integer> shiftIds = scheduleList.stream().map(TrainingTaskSchedule::getShiftId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        LambdaQueryWrapper managerWrapper0 = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)managerWrapper0.eq(TrainingLearnManager::getProjectId, (Object)schedule.getProjectId())).eq(TrainingLearnManager::getUserId, (Object)user.getId())).eq(TrainingLearnManager::getManagerType, (Object)1);
        List managerLists0 = this.managerMapper.selectList((Wrapper)managerWrapper0);
        if (!this.commonRemoteService.isSuper(user.getId()).booleanValue() && CollectionUtils.isEmpty((Collection)managerLists0)) {
            List shiftIdes;
            List<TrainingLearnManager> managerLists1 = this.getLearnManagerRole(schedule.getProjectId(), user);
            LambdaQueryWrapper managerWrapper2 = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)managerWrapper2.eq(TrainingLearnManager::getProjectId, (Object)schedule.getProjectId())).eq(TrainingLearnManager::getUserId, (Object)user.getId())).eq(TrainingLearnManager::getManagerType, (Object)3);
            List managerLists2 = this.managerMapper.selectList((Wrapper)managerWrapper2);
            LambdaQueryWrapper wrapperIn = new LambdaQueryWrapper();
            wrapperIn.eq(TrainingLearnShift::getProjectId, (Object)schedule.getProjectId());
            if (!CollectionUtils.isEmpty(managerLists1) && CollectionUtils.isEmpty((Collection)managerLists2)) {
                wrapperIn.eq(TrainingLearnShift::getCreatorId, (Object)user.getId());
            } else if (!CollectionUtils.isEmpty(managerLists1) && !CollectionUtils.isEmpty((Collection)managerLists2)) {
                shiftIdes = managerLists2.stream().map(TrainingLearnManager::getShiftId).collect(Collectors.toList());
                wrapperIn.and(wq -> {
                    LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wq.eq(TrainingLearnShift::getCreatorId, (Object)user.getId())).or()).in(TrainingLearnShift::getId, (Collection)shiftIdes);
                });
            } else if (CollectionUtils.isEmpty(managerLists1) && !CollectionUtils.isEmpty((Collection)managerLists2)) {
                shiftIdes = managerLists2.stream().map(TrainingLearnManager::getShiftId).collect(Collectors.toList());
                wrapperIn.in(TrainingLearnShift::getId, shiftIdes);
            }
            List shiftList = this.shiftMapper.selectList((Wrapper)wrapperIn);
            if (!CollectionUtils.isEmpty((Collection)shiftList)) {
                shiftIds = shiftList.stream().map(TrainingLearnShift::getId).collect(Collectors.toList());
            }
        }
        String bool = "0";
        List userList = null;
        if (project.get("creater") != null && !"".equals(project.get("creater")) && (userMap = this.userUtilService.getCheckParameters(project.get("creater").toString(), null, null, user)).get("isEffect").toString().equals("1") && CollectionUtils.isEmpty((Collection)(userList = (List)userMap.get("userList")))) {
            bool = "1";
        }
        if (project.get("shiftId") != null) {
            Integer shiftId = Integer.parseInt(project.get("shiftId").toString());
            if (!CollectionUtils.isEmpty(shiftIds)) {
                shiftIds.retainAll(Arrays.asList(shiftId));
            } else {
                shiftIds = Arrays.asList(shiftId);
            }
        }
        List<TrainingLearnTaskUserVo> taskUserList = null;
        if ("0".equals(bool) && !CollectionUtils.isEmpty(taskUserList = this.taskUserMapper.selectUserTasksByPage(page, scheduleIds, userList, shiftIds, null))) {
            List<Integer> userIds = taskUserList.stream().map(TrainingLearnTaskUser::getUserId).distinct().collect(Collectors.toList());
            Map<Integer, UsersPojo> usersMap = this.userUtilService.selectUserMap(userIds);
            Map<Integer, List<String>> userOrganizeMap = this.userUtilService.selectOrganizeMap(userIds, user.getGroupId());
            List shiftIdList = taskUserList.stream().map(TrainingLearnTaskUser::getShiftId).distinct().collect(Collectors.toList());
            List shiftList = this.shiftMapper.selectBatchIds(shiftIdList);
            Map shiftMap = shiftList.stream().collect(Collectors.toMap(TrainingLearnShift::getId, Function.identity()));
            HashMap<String, Object> parameter = new HashMap<String, Object>();
            parameter.put("userIds", StringUtils.join(userIds, (String)","));
            parameter.put("groupId", user.getGroupId());
            com.ovopark.privilege.response.BaseResult base = this.roleApi.getUserRoleList(parameter);
            Map roleMap = (Map)base.getData();
            Map<Integer, UserDutiesMo> dutiesMap = this.userUtilService.selectDutiesMap(userIds, user.getGroupId());
            Map<Integer, String> parentMap = this.userUtilService.selectParentMap(userIds, user.getGroupId());
            Map<Integer, Integer> parentIdMap = this.userUtilService.selectParentIdMap(userIds, user.getGroupId());
            for (TrainingLearnTaskUserVo learnTaskUserVo : taskUserList) {
                int cutTime;
                TrainingLearnShift shiftVo = (TrainingLearnShift)shiftMap.get(learnTaskUserVo.getShiftId());
                learnTaskUserVo.setShiftName(shiftVo.getShiftName());
                learnTaskUserVo.setGroupName(shiftVo.getGroupName());
                learnTaskUserVo.setSupplemenName(shiftVo.getSupplemenName());
                UsersPojo pojo = usersMap.get(learnTaskUserVo.getUserId());
                learnTaskUserVo.setEmployeeNumber(pojo == null ? "" : pojo.getEmployeeNumber());
                learnTaskUserVo.setUserName(pojo == null ? "" : pojo.getShowName());
                List<String> userStr = userOrganizeMap.get(learnTaskUserVo.getUserId());
                if (!CollectionUtils.isEmpty(userStr)) {
                    learnTaskUserVo.setOrganizeName(String.join((CharSequence)";\n", userStr));
                }
                TrainingTaskSchedule sc = (TrainingTaskSchedule)this.scheduleMapper.selectById(learnTaskUserVo.getProjectTaskScheduleId());
                int actTime = 0;
                if (sc != null) {
                    learnTaskUserVo.setTaskStartTime(sc.getStartTime());
                    learnTaskUserVo.setTaskEndTime(sc.getEndTime());
                    if (sc.getStartTime() != null && sc.getEndTime() != null) {
                        actTime = (int)(sc.getEndTime().getTime() - sc.getStartTime().getTime());
                        learnTaskUserVo.setActTime(new BigDecimal((double)actTime / 3600000.0).setScale(1, 4));
                    }
                }
                int userTime = 0;
                if (learnTaskUserVo.getStartTime() != null && learnTaskUserVo.getEndTime() != null) {
                    if (sc != null) {
                        if (!(sc.getEndTime() != null && learnTaskUserVo.getStartTime().compareTo(sc.getEndTime()) >= 0 || sc.getStartTime() != null && learnTaskUserVo.getEndTime().compareTo(sc.getStartTime()) <= 0)) {
                            userTime = sc.getStartTime() != null && learnTaskUserVo.getStartTime().compareTo(sc.getStartTime()) < 0 ? (int)(learnTaskUserVo.getEndTime().getTime() - sc.getStartTime().getTime()) : (sc.getEndTime() != null && learnTaskUserVo.getEndTime().compareTo(sc.getEndTime()) > 0 ? (int)(sc.getEndTime().getTime() - learnTaskUserVo.getStartTime().getTime()) : (int)(learnTaskUserVo.getEndTime().getTime() - learnTaskUserVo.getStartTime().getTime()));
                        }
                    } else {
                        userTime = (int)(learnTaskUserVo.getEndTime().getTime() - learnTaskUserVo.getStartTime().getTime());
                    }
                }
                if (userTime > actTime) {
                    userTime = actTime;
                }
                int n = cutTime = actTime > userTime ? actTime - userTime : 0;
                learnTaskUserVo.setOutRate(new BigDecimal(actTime == 0 ? 0.0 : (actTime >= userTime ? 100.0 * (double)userTime / (double)actTime : 100.0)).setScale(2, 4));
                learnTaskUserVo.setUseTimeVo(new BigDecimal((double)userTime / 3600000.0).setScale(1, 4));
                learnTaskUserVo.setCutTimeVo(new BigDecimal((double)cutTime / 3600000.0).setScale(1, 4));
                int num = 0;
                if (learnTaskUserVo.getStartTime() == null) {
                    ++num;
                }
                if (learnTaskUserVo.getEndTime() == null) {
                    ++num;
                }
                learnTaskUserVo.setIsAllTime(Integer.valueOf(num));
                learnTaskUserVo.setRole(this.spliceRoleName(roleMap, learnTaskUserVo.getUserId()));
                if (!CollectionUtils.isEmpty(dutiesMap) && dutiesMap.get(learnTaskUserVo.getUserId()) != null) {
                    learnTaskUserVo.setPost(dutiesMap.get(learnTaskUserVo.getUserId()).getDutieName());
                }
                if (!CollectionUtils.isEmpty(parentMap)) {
                    learnTaskUserVo.setParentName(parentMap.get(learnTaskUserVo.getUserId()));
                }
                if (CollectionUtils.isEmpty(parentIdMap)) continue;
                learnTaskUserVo.setParentUserId(parentIdMap.get(learnTaskUserVo.getUserId()));
            }
        }
        page.setContent(taskUserList);
        return page;
    }

    @Override
    public Page<TrainingLearnTaskUserVo> selectUserWorkTaskByPage(Page<TrainingLearnTaskUserVo> page, Map<String, Object> project) {
        Map<String, Object> userMap;
        Users user = (Users)project.get("user");
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)wrapper.eq(TrainingTaskSchedule::getTaskId, project.get("taskId"))).isNotNull(TrainingTaskSchedule::getShiftId);
        List scheduleList = this.scheduleMapper.selectList((Wrapper)wrapper);
        List<Integer> scheduleIds = scheduleList.stream().map(TrainingTaskSchedule::getId).collect(Collectors.toList());
        TrainingTaskSchedule schedule = (TrainingTaskSchedule)scheduleList.get(0);
        List<Object> shiftIds = scheduleList.stream().map(TrainingTaskSchedule::getShiftId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        List workIds = scheduleList.stream().map(TrainingTaskSchedule::getWorkId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        Map scheduleMap = scheduleList.stream().collect(Collectors.toMap(TrainingTaskSchedule::getId, Function.identity()));
        LambdaQueryWrapper managerWrapper0 = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)managerWrapper0.eq(TrainingLearnManager::getProjectId, (Object)schedule.getProjectId())).eq(TrainingLearnManager::getUserId, (Object)user.getId())).eq(TrainingLearnManager::getManagerType, (Object)1);
        List managerLists0 = this.managerMapper.selectList((Wrapper)managerWrapper0);
        if (!this.commonRemoteService.isSuper(user.getId()).booleanValue() && CollectionUtils.isEmpty((Collection)managerLists0)) {
            List shiftIdes;
            List<TrainingLearnManager> managerLists1 = this.getLearnManagerRole(schedule.getProjectId(), user);
            LambdaQueryWrapper managerWrapper2 = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)managerWrapper2.eq(TrainingLearnManager::getProjectId, (Object)schedule.getProjectId())).eq(TrainingLearnManager::getUserId, (Object)user.getId())).eq(TrainingLearnManager::getManagerType, (Object)3);
            List managerLists2 = this.managerMapper.selectList((Wrapper)managerWrapper2);
            LambdaQueryWrapper wrapperIn = new LambdaQueryWrapper();
            wrapperIn.eq(TrainingLearnShift::getProjectId, (Object)schedule.getProjectId());
            if (!CollectionUtils.isEmpty(managerLists1) && CollectionUtils.isEmpty((Collection)managerLists2)) {
                wrapperIn.eq(TrainingLearnShift::getCreatorId, (Object)user.getId());
            } else if (!CollectionUtils.isEmpty(managerLists1) && !CollectionUtils.isEmpty((Collection)managerLists2)) {
                shiftIdes = managerLists2.stream().map(TrainingLearnManager::getShiftId).collect(Collectors.toList());
                wrapperIn.and(wq -> {
                    LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wq.eq(TrainingLearnShift::getCreatorId, (Object)user.getId())).or()).in(TrainingLearnShift::getId, (Collection)shiftIdes);
                });
            } else if (CollectionUtils.isEmpty(managerLists1) && !CollectionUtils.isEmpty((Collection)managerLists2)) {
                shiftIdes = managerLists2.stream().map(TrainingLearnManager::getShiftId).collect(Collectors.toList());
                wrapperIn.in(TrainingLearnShift::getId, shiftIdes);
            }
            List shiftList = this.shiftMapper.selectList((Wrapper)wrapperIn);
            if (!CollectionUtils.isEmpty((Collection)shiftList)) {
                shiftIds = shiftList.stream().map(TrainingLearnShift::getId).collect(Collectors.toList());
            }
        }
        String bool = "0";
        List<Integer> userList = new ArrayList<Integer>();
        if (!org.springframework.util.StringUtils.isEmpty((Object)project.get("creater")) && !"".equals(project.get("creater")) && (userMap = this.userUtilService.getCheckParameters(project.get("creater").toString(), null, null, user)).get("isEffect").toString().equals("1") && CollectionUtils.isEmpty(userList = (List)userMap.get("userList"))) {
            bool = "1";
        }
        if (project.get("shiftId") != null) {
            Integer shiftId = Integer.parseInt(project.get("shiftId").toString());
            if (!CollectionUtils.isEmpty(shiftIds)) {
                shiftIds.retainAll(Arrays.asList(shiftId));
            } else {
                shiftIds = Arrays.asList(shiftId);
            }
        }
        ArrayList<Integer> taskStatuss = new ArrayList<Integer>();
        if (project.get("taskStatus") != null) {
            Integer taskStatus = Integer.parseInt(project.get("taskStatus").toString());
            if (taskStatus == 1) {
                taskStatuss.addAll(Arrays.asList(0, 1));
            } else {
                taskStatuss.add(taskStatus);
            }
        }
        List<Object> taskUserList = new ArrayList();
        if ("0".equals(bool) && !CollectionUtils.isEmpty(taskUserList = this.taskUserMapper.selectUserTasksByPage(page, scheduleIds, userList, shiftIds, taskStatuss))) {
            List<Integer> userIds = taskUserList.stream().map(TrainingLearnTaskUser::getUserId).distinct().collect(Collectors.toList());
            Map<Integer, UsersPojo> usersMap = this.userUtilService.selectUserMap(userIds);
            Map<Integer, List<String>> userOrganizeMap = this.userUtilService.selectOrganizeMap(userIds, user.getGroupId());
            List shiftIdList = taskUserList.stream().map(TrainingLearnTaskUser::getShiftId).distinct().collect(Collectors.toList());
            List shiftList = this.shiftMapper.selectBatchIds(shiftIdList);
            Map shiftMap = shiftList.stream().collect(Collectors.toMap(TrainingLearnShift::getId, Function.identity()));
            LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper1.in(TrainingWorkUserAnswer::getWorkId, workIds)).in(TrainingWorkUserAnswer::getUserId, userIds)).eq(TrainingWorkUserAnswer::getIsLast, (Object)1);
            List workUserAnswers = this.trainingWorkUserAnswerMapper.selectList((Wrapper)wrapper1);
            Map<Object, Object> workUserMap = new HashMap();
            if (!CollectionUtils.isEmpty((Collection)workUserAnswers)) {
                workUserMap = workUserAnswers.stream().collect(Collectors.toMap(TrainingWorkUserAnswer::getWorkId, e -> new ArrayList<TrainingWorkUserAnswer>(Arrays.asList(e)), (oldList, newList) -> {
                    oldList.addAll(newList);
                    return oldList;
                }));
            }
            LambdaQueryWrapper wrapper2 = new LambdaQueryWrapper();
            wrapper2.in(TrainingWorkReviewer::getWorkId, workIds);
            List trainingWorkReviewerList = this.trainingWorkReviewerMapper.selectList((Wrapper)wrapper2);
            Map<Object, Object> reviewerMap = new HashMap();
            if (!CollectionUtils.isEmpty((Collection)trainingWorkReviewerList)) {
                reviewerMap = trainingWorkReviewerList.stream().collect(Collectors.toMap(TrainingWorkReviewer::getWorkId, e -> new ArrayList<TrainingWorkReviewer>(Arrays.asList(e)), (oldList, newList) -> {
                    oldList.addAll(newList);
                    return oldList;
                }));
            }
            HashMap<String, Object> parameter = new HashMap<String, Object>();
            parameter.put("userIds", StringUtils.join(userIds, (String)","));
            parameter.put("groupId", user.getGroupId());
            com.ovopark.privilege.response.BaseResult base = this.roleApi.getUserRoleList(parameter);
            Map roleMap = (Map)base.getData();
            Map<Integer, UserDutiesMo> dutiesMap = this.userUtilService.selectDutiesMap(userIds, user.getGroupId());
            Map<Integer, String> parentMap = this.userUtilService.selectParentMap(userIds, user.getGroupId());
            Map<Integer, Integer> parentIdMap = this.userUtilService.selectParentIdMap(userIds, user.getGroupId());
            for (TrainingLearnTaskUserVo trainingLearnTaskUserVo : taskUserList) {
                TrainingLearnShift shiftVo = (TrainingLearnShift)shiftMap.get(trainingLearnTaskUserVo.getShiftId());
                trainingLearnTaskUserVo.setShiftName(shiftVo.getShiftName());
                trainingLearnTaskUserVo.setGroupName(shiftVo.getGroupName());
                trainingLearnTaskUserVo.setSupplemenName(shiftVo.getSupplemenName());
                trainingLearnTaskUserVo.setShiftStatus(shiftVo.getStatus());
                UsersPojo pojo = usersMap.get(trainingLearnTaskUserVo.getUserId());
                trainingLearnTaskUserVo.setEmployeeNumber(pojo == null ? "" : pojo.getEmployeeNumber());
                trainingLearnTaskUserVo.setUserName(pojo == null ? "" : pojo.getShowName());
                List<String> userStr = userOrganizeMap.get(trainingLearnTaskUserVo.getUserId());
                if (!CollectionUtils.isEmpty(userStr)) {
                    trainingLearnTaskUserVo.setOrganizeName(String.join((CharSequence)";\n", userStr));
                }
                TrainingTaskSchedule taskSchedule = (TrainingTaskSchedule)scheduleMap.get(trainingLearnTaskUserVo.getProjectTaskScheduleId());
                trainingLearnTaskUserVo.setStartTime(taskSchedule.getStartTime());
                trainingLearnTaskUserVo.setEndTime(taskSchedule.getEndTime());
                trainingLearnTaskUserVo.setWorkId(taskSchedule.getWorkId());
                Boolean isPower = false;
                List trainingWorkUserAnswers = (List)workUserMap.get(taskSchedule.getWorkId());
                if (!CollectionUtils.isEmpty((Collection)trainingWorkUserAnswers)) {
                    for (TrainingWorkUserAnswer userAnswer : trainingWorkUserAnswers) {
                        List reviewers;
                        if (userAnswer.getUserId().compareTo(trainingLearnTaskUserVo.getUserId()) != 0) continue;
                        trainingLearnTaskUserVo.setTaskStatus(Integer.valueOf(userAnswer.getStatus() + 1));
                        trainingLearnTaskUserVo.setScore(userAnswer.getScore());
                        trainingLearnTaskUserVo.setCommitTime(userAnswer.getCommitTime());
                        trainingLearnTaskUserVo.setUserAnswerId(userAnswer.getId());
                        if (!org.springframework.util.StringUtils.isEmpty((Object)userAnswer.getLeaderId())) {
                            if (userAnswer.getLeaderId().compareTo(user.getId()) != 0) continue;
                            isPower = true;
                            continue;
                        }
                        List reviewerList = (List)reviewerMap.get(taskSchedule.getWorkId());
                        if (CollectionUtils.isEmpty((Collection)reviewerList) || !(reviewers = reviewerList.stream().map(TrainingWorkReviewer::getUserId).distinct().collect(Collectors.toList())).contains(user.getId())) continue;
                        isPower = true;
                    }
                } else {
                    trainingLearnTaskUserVo.setTaskStatus(Integer.valueOf(1));
                }
                trainingLearnTaskUserVo.setIsPower(isPower);
                trainingLearnTaskUserVo.setRole(this.spliceRoleName(roleMap, trainingLearnTaskUserVo.getUserId()));
                if (!CollectionUtils.isEmpty(dutiesMap) && dutiesMap.get(trainingLearnTaskUserVo.getUserId()) != null) {
                    trainingLearnTaskUserVo.setPost(dutiesMap.get(trainingLearnTaskUserVo.getUserId()).getDutieName());
                }
                if (!CollectionUtils.isEmpty(parentMap)) {
                    trainingLearnTaskUserVo.setParentName(parentMap.get(trainingLearnTaskUserVo.getUserId()));
                }
                if (CollectionUtils.isEmpty(parentIdMap)) continue;
                trainingLearnTaskUserVo.setParentUserId(parentIdMap.get(trainingLearnTaskUserVo.getUserId()));
            }
        }
        page.setContent(taskUserList);
        return page;
    }

    public List<TrainingLearnTaskUserVo> selectUserWorkTaskByExecl(Map project) {
        Map<String, Object> userMap;
        Users user = (Users)project.get("user");
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)wrapper.eq(TrainingTaskSchedule::getTaskId, project.get("taskId"))).isNotNull(TrainingTaskSchedule::getShiftId);
        List scheduleList = this.scheduleMapper.selectList((Wrapper)wrapper);
        List<Integer> scheduleIds = scheduleList.stream().map(TrainingTaskSchedule::getId).collect(Collectors.toList());
        TrainingTaskSchedule schedule = (TrainingTaskSchedule)scheduleList.get(0);
        TrainingLearnProject learnProject = (TrainingLearnProject)this.learnMapper.selectById(schedule.getProjectId());
        List<Object> shiftIds = scheduleList.stream().map(TrainingTaskSchedule::getShiftId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        List workIds = scheduleList.stream().map(TrainingTaskSchedule::getWorkId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        Map scheduleMap = scheduleList.stream().collect(Collectors.toMap(TrainingTaskSchedule::getId, Function.identity()));
        LambdaQueryWrapper managerWrapper0 = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)managerWrapper0.eq(TrainingLearnManager::getProjectId, (Object)schedule.getProjectId())).eq(TrainingLearnManager::getUserId, (Object)user.getId())).eq(TrainingLearnManager::getManagerType, (Object)1);
        List managerLists0 = this.managerMapper.selectList((Wrapper)managerWrapper0);
        if (!this.commonRemoteService.isSuper(user.getId()).booleanValue() && CollectionUtils.isEmpty((Collection)managerLists0)) {
            List shiftIdes;
            List<TrainingLearnManager> managerLists1 = this.getLearnManagerRole(schedule.getProjectId(), user);
            LambdaQueryWrapper managerWrapper2 = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)managerWrapper2.eq(TrainingLearnManager::getProjectId, (Object)schedule.getProjectId())).eq(TrainingLearnManager::getUserId, (Object)user.getId())).eq(TrainingLearnManager::getManagerType, (Object)3);
            List managerLists2 = this.managerMapper.selectList((Wrapper)managerWrapper2);
            LambdaQueryWrapper wrapperIn = new LambdaQueryWrapper();
            wrapperIn.eq(TrainingLearnShift::getProjectId, (Object)schedule.getProjectId());
            if (!CollectionUtils.isEmpty(managerLists1) && CollectionUtils.isEmpty((Collection)managerLists2)) {
                wrapperIn.eq(TrainingLearnShift::getCreatorId, (Object)user.getId());
            } else if (!CollectionUtils.isEmpty(managerLists1) && !CollectionUtils.isEmpty((Collection)managerLists2)) {
                shiftIdes = managerLists2.stream().map(TrainingLearnManager::getShiftId).collect(Collectors.toList());
                wrapperIn.and(wq -> {
                    LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wq.eq(TrainingLearnShift::getCreatorId, (Object)user.getId())).or()).in(TrainingLearnShift::getId, (Collection)shiftIdes);
                });
            } else if (CollectionUtils.isEmpty(managerLists1) && !CollectionUtils.isEmpty((Collection)managerLists2)) {
                shiftIdes = managerLists2.stream().map(TrainingLearnManager::getShiftId).collect(Collectors.toList());
                wrapperIn.in(TrainingLearnShift::getId, shiftIdes);
            }
            List shiftList = this.shiftMapper.selectList((Wrapper)wrapperIn);
            if (!CollectionUtils.isEmpty((Collection)shiftList)) {
                shiftIds = shiftList.stream().map(TrainingLearnShift::getId).collect(Collectors.toList());
            }
        }
        String bool = "0";
        List<Integer> userList = new ArrayList<Integer>();
        if (!org.springframework.util.StringUtils.isEmpty(project.get("creater")) && !"".equals(project.get("creater")) && (userMap = this.userUtilService.getCheckParameters(project.get("creater").toString(), null, null, user)).get("isEffect").toString().equals("1") && CollectionUtils.isEmpty(userList = (List)userMap.get("userList"))) {
            bool = "1";
        }
        if (project.get("shiftId") != null) {
            Integer shiftId = Integer.parseInt(project.get("shiftId").toString());
            if (!CollectionUtils.isEmpty(shiftIds)) {
                shiftIds.retainAll(Arrays.asList(shiftId));
            } else {
                shiftIds = Arrays.asList(shiftId);
            }
        }
        ArrayList<Integer> taskStatuss = new ArrayList<Integer>();
        if (project.get("taskStatus") != null) {
            Integer taskStatus = Integer.parseInt(project.get("taskStatus").toString());
            if (taskStatus == 1) {
                taskStatuss.addAll(Arrays.asList(0, 1));
            } else {
                taskStatuss.add(taskStatus);
            }
        }
        List<TrainingLearnTaskUserVo> taskUserList = new ArrayList<TrainingLearnTaskUserVo>();
        if ("0".equals(bool) && !CollectionUtils.isEmpty(taskUserList = this.taskUserMapper.selectUserTasksByExecl(scheduleIds, userList, shiftIds, taskStatuss))) {
            List<Integer> userIds = taskUserList.stream().map(TrainingLearnTaskUser::getUserId).distinct().collect(Collectors.toList());
            Map<Integer, UsersPojo> usersMap = this.userUtilService.selectUserMap(userIds);
            Map<Integer, List<String>> userOrganizeMap = this.userUtilService.selectOrganizeMap(userIds, user.getGroupId());
            List shiftIdList = taskUserList.stream().map(TrainingLearnTaskUser::getShiftId).distinct().collect(Collectors.toList());
            List shiftList = this.shiftMapper.selectBatchIds(shiftIdList);
            Map shiftMap = shiftList.stream().collect(Collectors.toMap(TrainingLearnShift::getId, Function.identity()));
            LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper1.in(TrainingWorkUserAnswer::getWorkId, workIds)).in(TrainingWorkUserAnswer::getUserId, userIds)).eq(TrainingWorkUserAnswer::getIsLast, (Object)1);
            List workUserAnswers = this.trainingWorkUserAnswerMapper.selectList((Wrapper)wrapper1);
            Map<Object, Object> workUserMap = new HashMap();
            Map<Object, Object> remarkerMap = new HashMap();
            Map<Object, Object> userDocumentMap = new HashMap();
            if (!CollectionUtils.isEmpty((Collection)workUserAnswers)) {
                List userAnswers;
                workUserMap = workUserAnswers.stream().collect(Collectors.toMap(TrainingWorkUserAnswer::getWorkId, e -> new ArrayList<TrainingWorkUserAnswer>(Arrays.asList(e)), (oldList, newList) -> {
                    oldList.addAll(newList);
                    return oldList;
                }));
                List<Integer> remarkers = workUserAnswers.stream().map(TrainingWorkUserAnswer::getRemarker).filter(Objects::nonNull).distinct().collect(Collectors.toList());
                if (!CollectionUtils.isEmpty(remarkers)) {
                    remarkerMap = this.userUtilService.selectUserMap(remarkers);
                }
                if (!CollectionUtils.isEmpty(userAnswers = workUserAnswers.stream().map(TrainingWorkUserAnswer::getId).collect(Collectors.toList()))) {
                    LambdaQueryWrapper wrapper2 = new LambdaQueryWrapper();
                    ((LambdaQueryWrapper)wrapper2.eq(TrainingWorkDocument::getDocumentType, (Object)2)).in(TrainingWorkDocument::getAnswerId, userAnswers);
                    List workDocuments = this.trainingWorkDocumentMapper.selectList((Wrapper)wrapper2);
                    if (!CollectionUtils.isEmpty((Collection)workDocuments)) {
                        userDocumentMap = workDocuments.stream().collect(Collectors.toMap(TrainingWorkDocument::getAnswerId, e -> new ArrayList<TrainingWorkDocument>(Arrays.asList(e)), (oldList, newList) -> {
                            oldList.addAll(newList);
                            return oldList;
                        }));
                    }
                }
            }
            for (TrainingLearnTaskUserVo learnTaskUserVo : taskUserList) {
                TrainingLearnShift shiftVo = (TrainingLearnShift)shiftMap.get(learnTaskUserVo.getShiftId());
                learnTaskUserVo.setShiftName(shiftVo.getShiftName());
                learnTaskUserVo.setGroupName(shiftVo.getGroupName());
                learnTaskUserVo.setSupplemenName(shiftVo.getSupplemenName());
                UsersPojo pojo = usersMap.get(learnTaskUserVo.getUserId());
                learnTaskUserVo.setEmployeeNumber(pojo == null ? "" : pojo.getEmployeeNumber());
                learnTaskUserVo.setUserName(pojo == null ? "" : pojo.getShowName());
                List<String> userStr = userOrganizeMap.get(learnTaskUserVo.getUserId());
                if (!CollectionUtils.isEmpty(userStr)) {
                    learnTaskUserVo.setOrganizeName(String.join((CharSequence)";", userStr));
                }
                TrainingTaskSchedule taskSchedule = (TrainingTaskSchedule)scheduleMap.get(learnTaskUserVo.getProjectTaskScheduleId());
                learnTaskUserVo.setStartTime(taskSchedule.getStartTime());
                learnTaskUserVo.setEndTime(taskSchedule.getEndTime());
                learnTaskUserVo.setProjectName(learnProject.getProjectName());
                learnTaskUserVo.setTaskName(schedule.getTaskName());
                List trainingWorkUserAnswers = (List)workUserMap.get(taskSchedule.getWorkId());
                if (!CollectionUtils.isEmpty((Collection)trainingWorkUserAnswers)) {
                    for (TrainingWorkUserAnswer userAnswer : trainingWorkUserAnswers) {
                        if (userAnswer.getUserId().compareTo(learnTaskUserVo.getUserId()) != 0) continue;
                        learnTaskUserVo.setTaskStatus(Integer.valueOf(userAnswer.getStatus() + 1));
                        learnTaskUserVo.setScore(userAnswer.getScore());
                        TrainingWorkUserAnswerVo workUserAnswerVo = new TrainingWorkUserAnswerVo();
                        BeanUtils.copyProperties((Object)userAnswer, (Object)workUserAnswerVo);
                        UsersPojo remarkPojo = (UsersPojo)remarkerMap.get(workUserAnswerVo.getRemarker());
                        workUserAnswerVo.setRemarkerName(remarkPojo == null ? "" : remarkPojo.getShowName());
                        workUserAnswerVo.setWorkDocumentList((List)userDocumentMap.get(workUserAnswerVo.getId()));
                        learnTaskUserVo.setWorkUserAnswerVo(workUserAnswerVo);
                    }
                    continue;
                }
                learnTaskUserVo.setTaskStatus(Integer.valueOf(1));
            }
        }
        return taskUserList;
    }

    @Override
    public TrainingLearnProjectVo selectLearnProjectVo(TrainingTaskScheduleVo trainingTaskScheduleVo) {
        TrainingLearnProjectVo vo = new TrainingLearnProjectVo();
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(TrainingTaskSchedule::getTaskId, (Object)trainingTaskScheduleVo.getTaskId());
        List scheduleList = this.scheduleMapper.selectList((Wrapper)wrapper);
        TrainingLearnProject project = (TrainingLearnProject)this.learnMapper.selectById(((TrainingTaskSchedule)scheduleList.get(0)).getProjectId());
        BeanUtils.copyProperties((Object)project, (Object)vo);
        return vo;
    }

    @Override
    public List<TrainingLearnUserVo> getUserTask(Map<String, Object> project) {
        List<TrainingLearnUserVo> taskUserList = new ArrayList<TrainingLearnUserVo>();
        try {
            List pojoList;
            BaseResult base;
            Users user = (Users)JSON.parseObject((String)JSON.toJSONString((Object)project.get("user")), Users.class);
            Integer projectId = Integer.parseInt(project.get("projectId").toString());
            Integer isShiftId = 0;
            List<Integer> shiftIds = null;
            LambdaQueryWrapper managerWrapper0 = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)managerWrapper0.eq(TrainingLearnManager::getProjectId, (Object)projectId)).eq(TrainingLearnManager::getUserId, (Object)user.getId())).eq(TrainingLearnManager::getManagerType, (Object)1);
            List managerLists0 = this.managerMapper.selectList((Wrapper)managerWrapper0);
            if (!this.commonRemoteService.isSuper(user.getId()).booleanValue() && CollectionUtils.isEmpty((Collection)managerLists0)) {
                List shiftIdes;
                List<TrainingLearnManager> managerLists1 = this.getLearnManagerRole(projectId, user);
                LambdaQueryWrapper managerWrapper2 = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)((LambdaQueryWrapper)managerWrapper2.eq(TrainingLearnManager::getProjectId, (Object)projectId)).eq(TrainingLearnManager::getUserId, (Object)user.getId())).eq(TrainingLearnManager::getManagerType, (Object)3);
                List managerLists2 = this.managerMapper.selectList((Wrapper)managerWrapper2);
                LambdaQueryWrapper wrapperIn = new LambdaQueryWrapper();
                wrapperIn.eq(TrainingLearnShift::getProjectId, (Object)projectId);
                if (!CollectionUtils.isEmpty(managerLists1) && CollectionUtils.isEmpty((Collection)managerLists2)) {
                    wrapperIn.eq(TrainingLearnShift::getCreatorId, (Object)user.getId());
                } else if (!CollectionUtils.isEmpty(managerLists1) && !CollectionUtils.isEmpty((Collection)managerLists2)) {
                    shiftIdes = managerLists2.stream().map(TrainingLearnManager::getShiftId).collect(Collectors.toList());
                    wrapperIn.and(wq -> {
                        LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wq.eq(TrainingLearnShift::getCreatorId, (Object)user.getId())).or()).in(TrainingLearnShift::getId, (Collection)shiftIdes);
                    });
                } else if (CollectionUtils.isEmpty(managerLists1) && !CollectionUtils.isEmpty((Collection)managerLists2)) {
                    shiftIdes = managerLists2.stream().map(TrainingLearnManager::getShiftId).collect(Collectors.toList());
                    wrapperIn.in(TrainingLearnShift::getId, shiftIdes);
                }
                List shiftList = this.shiftMapper.selectList((Wrapper)wrapperIn);
                if (!CollectionUtils.isEmpty((Collection)shiftList)) {
                    shiftIds = shiftList.stream().map(TrainingLearnShift::getId).collect(Collectors.toList());
                }
                isShiftId = 1;
            }
            List<Integer> userList = new ArrayList<Integer>();
            String groupName = null;
            if (!org.springframework.util.StringUtils.isEmpty((Object)project.get("userName")) && (base = this.userApi.getSimpleUserByKeyWord(user.getGroupId(), project.get("userName").toString(), null)) != null) {
                pojoList = (List)base.getData();
                userList = pojoList.stream().map(SimplePojo::getId).distinct().collect(Collectors.toList());
            }
            if (project.get("id") != null) {
                Integer shiftId = Integer.parseInt(project.get("id").toString());
                if (!CollectionUtils.isEmpty(shiftIds)) {
                    shiftIds.retainAll(Arrays.asList(shiftId));
                } else {
                    shiftIds = Arrays.asList(shiftId);
                }
            }
            if (project.get("groupName") != null) {
                groupName = project.get("groupName").toString();
            }
            if (!(CollectionUtils.isEmpty(shiftIds) && isShiftId == 1 || !org.springframework.util.StringUtils.isEmpty((Object)project.get("userName")) && CollectionUtils.isEmpty(userList))) {
                taskUserList = this.learnUserMapper.selectUserTaskByExcel(shiftIds, projectId, groupName, userList, user.getGroupId(), project.get("creatorId") == null ? null : Integer.valueOf(project.get("creatorId").toString()));
            }
            if (!CollectionUtils.isEmpty(taskUserList)) {
                List shiftList;
                List detailList;
                List certificateIds;
                List<Integer> userIds = taskUserList.stream().map(TrainingLearnUser::getUserId).distinct().collect(Collectors.toList());
                pojoList = (List)this.userApi.getUserByIdList(userIds).getData();
                Map<Object, Object> pojoMap = new HashMap();
                if (!CollectionUtils.isEmpty((Collection)pojoList)) {
                    pojoMap = pojoList.stream().collect(Collectors.toMap(UsersPojo::getId, Function.identity()));
                }
                Map userOrganizeMap = (Map)this.userOrganizeApi.getUserOrganizeFirstByUserIds(user.getGroupId(), userIds, null).getData();
                Map<Object, Object> parentMap = new HashMap();
                if (!CollectionUtils.isEmpty(userIds)) {
                    parentMap = this.userUtilService.selectParentMap(userIds, user.getGroupId());
                }
                LambdaQueryWrapper wrapper2 = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)wrapper2.eq(TrainingProjectTask::getProjectId, (Object)projectId)).in(TrainingProjectTask::getTaskType, Arrays.asList(2, 3));
                List tasks = this.projectMapper.selectList((Wrapper)wrapper2);
                Map<Object, Object> scheduleMap = new HashMap();
                List<Object> scheduleIds = new ArrayList();
                if (!CollectionUtils.isEmpty((Collection)tasks)) {
                    List taskIds = tasks.stream().map(TrainingProjectTask::getId).distinct().collect(Collectors.toList());
                    LambdaQueryWrapper wrapper4 = new LambdaQueryWrapper();
                    ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper4.in(TrainingTaskSchedule::getTaskId, taskIds)).isNotNull(TrainingTaskSchedule::getShiftId)).isNotNull(TrainingTaskSchedule::getTaskRate);
                    List taskScheduleList = this.scheduleMapper.selectList((Wrapper)wrapper4);
                    if (!CollectionUtils.isEmpty((Collection)taskScheduleList)) {
                        scheduleMap = taskScheduleList.stream().collect(Collectors.toMap(TrainingTaskSchedule::getId, Function.identity()));
                        scheduleIds = taskScheduleList.stream().map(TrainingTaskSchedule::getId).distinct().collect(Collectors.toList());
                    }
                }
                LambdaQueryWrapper wrapper5 = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)wrapper5.eq(TrainingTaskSchedule::getProjectId, (Object)projectId)).isNull(TrainingTaskSchedule::getShiftId);
                List allTaskList = this.scheduleMapper.selectList((Wrapper)wrapper5);
                List learnUserIds = taskUserList.stream().map(TrainingLearnUser::getId).distinct().collect(Collectors.toList());
                LambdaQueryWrapper wrapper6 = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper6.in(TrainingLearnTaskUser::getLearnUserId, learnUserIds)).eq(TrainingLearnTaskUser::getTaskStatus, (Object)4)).orderByDesc(TrainingLearnTaskUser::getEndTime);
                List finishTaskUsers = this.taskUserMapper.selectList((Wrapper)wrapper6);
                Map<Object, Object> finishMap = new HashMap();
                if (!CollectionUtils.isEmpty((Collection)finishTaskUsers)) {
                    finishMap = finishTaskUsers.stream().collect(Collectors.toMap(TrainingLearnTaskUser::getLearnUserId, e -> new ArrayList<TrainingLearnTaskUser>(Arrays.asList(e)), (oldList, newList) -> {
                        oldList.addAll(newList);
                        return oldList;
                    }));
                }
                LambdaQueryWrapper wrapper7 = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)wrapper7.in(TrainingLearnTaskUser::getLearnUserId, learnUserIds)).in(TrainingLearnTaskUser::getTaskStatus, Arrays.asList(3, 4));
                List doTaskUsers = this.taskUserMapper.selectList((Wrapper)wrapper7);
                Map<Object, Object> doMap = new HashMap();
                if (!CollectionUtils.isEmpty((Collection)doTaskUsers)) {
                    doMap = doTaskUsers.stream().collect(Collectors.toMap(TrainingLearnTaskUser::getLearnUserId, e -> new ArrayList<TrainingLearnTaskUser>(Arrays.asList(e)), (oldList, newList) -> {
                        oldList.addAll(newList);
                        return oldList;
                    }));
                }
                TrainingLearnProject learnProject = (TrainingLearnProject)this.learnMapper.selectById(projectId);
                Map<Object, Object> certificateMap = new HashMap();
                if (!(org.springframework.util.StringUtils.isEmpty((Object)learnProject.getIsGet()) || learnProject.getIsGet() != 1 || CollectionUtils.isEmpty(certificateIds = taskUserList.stream().map(TrainingLearnUser::getCertificateId).filter(Objects::nonNull).distinct().collect(Collectors.toList())) || CollectionUtils.isEmpty((Collection)(detailList = this.certificateDetailMapper.selectBatchIds(certificateIds))))) {
                    certificateMap = detailList.stream().collect(Collectors.toMap(TrainingCertificateDetail::getId, Function.identity()));
                }
                Map<Object, Object> shiftMap = new HashMap();
                if (!CollectionUtils.isEmpty(shiftIds) && !CollectionUtils.isEmpty((Collection)(shiftList = this.shiftMapper.selectBatchIds(shiftIds)))) {
                    shiftMap = shiftList.stream().collect(Collectors.toMap(TrainingLearnShift::getId, Function.identity()));
                }
                LambdaQueryWrapper wrapper8 = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)wrapper8.in(TrainingLearnExamine::getLearnUserId, learnUserIds)).eq(TrainingLearnExamine::getIsAuto, (Object)1);
                List examineLists = this.examineMapper.selectList((Wrapper)wrapper8);
                Map<Object, Object> examineMap = new HashMap();
                if (!CollectionUtils.isEmpty((Collection)examineLists)) {
                    examineMap = examineLists.stream().collect(Collectors.toMap(TrainingLearnExamine::getLearnUserId, e -> new ArrayList<TrainingLearnExamine>(Arrays.asList(e)), (oldList, newList) -> {
                        oldList.addAll(newList);
                        return oldList;
                    }));
                }
                HashMap<String, Object> parameter = new HashMap<String, Object>();
                parameter.put("userIds", StringUtils.join(userIds, (String)","));
                parameter.put("groupId", user.getGroupId());
                com.ovopark.privilege.response.BaseResult base2 = this.roleApi.getUserRoleList(parameter);
                Map roleMap = (Map)base2.getData();
                Map<Integer, UserDutiesMo> dutiesMap = this.userUtilService.selectDutiesMap(userIds, user.getGroupId());
                for (TrainingLearnUserVo vo : taskUserList) {
                    TrainingCertificateDetail detail;
                    List doTaskUserList;
                    List taskUsers;
                    vo.setJobNumber(org.springframework.util.StringUtils.isEmpty((Object)pojoMap.get(vo.getUserId())) ? "" : ((UsersPojo)pojoMap.get(vo.getUserId())).getEmployeeNumber());
                    vo.setUserName(org.springframework.util.StringUtils.isEmpty((Object)pojoMap.get(vo.getUserId())) ? "" : ((UsersPojo)pojoMap.get(vo.getUserId())).getShowName());
                    vo.setUserAccount(org.springframework.util.StringUtils.isEmpty((Object)pojoMap.get(vo.getUserId())) ? "" : ((UsersPojo)pojoMap.get(vo.getUserId())).getUserName());
                    List userStr = (List)userOrganizeMap.get(vo.getUserId());
                    if (!CollectionUtils.isEmpty((Collection)userStr)) {
                        vo.setDepartment(String.join((CharSequence)";\n", userStr));
                    }
                    vo.setParentName((String)parentMap.get(vo.getUserId()));
                    vo.setRole(this.spliceRoleName(roleMap, vo.getUserId()));
                    if (!CollectionUtils.isEmpty(dutiesMap) && dutiesMap.get(vo.getUserId()) != null) {
                        vo.setPost(dutiesMap.get(vo.getUserId()).getDutieName());
                    }
                    if (!CollectionUtils.isEmpty(parentMap)) {
                        vo.setParentName((String)parentMap.get(vo.getUserId()));
                    }
                    if (org.springframework.util.StringUtils.isEmpty((Object)vo.getScore()) && !CollectionUtils.isEmpty(scheduleIds) && !CollectionUtils.isEmpty((Collection)(taskUsers = (List)doMap.get(vo.getId())))) {
                        BigDecimal score = null;
                        for (Object taskUser : taskUsers) {
                            TrainingTaskSchedule taskSchedule = (TrainingTaskSchedule)scheduleMap.get(taskUser.getProjectTaskScheduleId());
                            if (org.springframework.util.StringUtils.isEmpty((Object)taskSchedule)) continue;
                            if (score == null) {
                                score = new BigDecimal(0);
                            }
                            score = taskUser.getScore().multiply(taskSchedule.getTaskRate()).multiply(BigDecimal.valueOf(0.01)).add(score).setScale(1, 4);
                        }
                        vo.setScore(score);
                    }
                    List taskUsers2 = (List)finishMap.get(vo.getId());
                    if (vo.getStatus() != null && vo.getStatus() != 4) {
                        vo.setLearnTask(Integer.valueOf(allTaskList.size()));
                        vo.setFinishTask(Integer.valueOf(taskUsers2 == null ? 0 : taskUsers2.size()));
                    }
                    if (taskUsers2 != null && allTaskList.size() == taskUsers2.size() && taskUsers2.size() > 0 && org.springframework.util.StringUtils.isEmpty((Object)vo.getEndTime())) {
                        vo.setEndTime(((TrainingLearnTaskUser)taskUsers2.get(0)).getEndTime());
                    }
                    if (org.springframework.util.StringUtils.isEmpty((Object)vo.getPassStatus()) && !CollectionUtils.isEmpty((Collection)(doTaskUserList = (List)doMap.get(vo.getId()))) && allTaskList.size() == doTaskUserList.size()) {
                        BigDecimal score;
                        Object taskUser;
                        BigDecimal totalScore = new BigDecimal(0);
                        taskUser = allTaskList.iterator();
                        while (taskUser.hasNext()) {
                            TrainingTaskSchedule schedule = (TrainingTaskSchedule)taskUser.next();
                            if (org.springframework.util.StringUtils.isEmpty((Object)schedule.getFullScore())) continue;
                            totalScore = totalScore.add(schedule.getFullScore());
                        }
                        Integer pass = 0;
                        BigDecimal bigDecimal = score = vo.getScore() == null ? new BigDecimal(0) : vo.getScore();
                        if (learnProject.getStudyType() == 1) {
                            if (!CollectionUtils.isEmpty((Collection)taskUsers2) && allTaskList.size() == taskUsers2.size()) {
                                pass = 1;
                            }
                        } else if (learnProject.getStudyType() == 2) {
                            if (score.compareTo(totalScore.multiply(learnProject.getPassRate()).multiply(BigDecimal.valueOf(0.01))) >= 0) {
                                pass = 1;
                            }
                        } else if (learnProject.getStudyType() == 3 && allTaskList.size() == taskUsers2.size() && score.compareTo(totalScore.multiply(learnProject.getPassRate()).multiply(BigDecimal.valueOf(0.01))) >= 0) {
                            pass = 1;
                        }
                        vo.setPassStatus(pass);
                    }
                    if (vo.getStatus() > 1) {
                        LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
                        ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper1.eq(TrainingLearnTaskUser::getLearnUserId, (Object)vo.getId())).isNotNull(TrainingLearnTaskUser::getStartTime)).orderByAsc(TrainingLearnTaskUser::getStartTime);
                        List taskUsers3 = this.taskUserMapper.selectList((Wrapper)wrapper1);
                        if (!CollectionUtils.isEmpty((Collection)taskUsers3)) {
                            vo.setStartTime(((TrainingLearnTaskUser)taskUsers3.get(0)).getStartTime());
                        }
                    }
                    if (vo.getCertificateId() != null && !org.springframework.util.StringUtils.isEmpty((Object)(detail = (TrainingCertificateDetail)certificateMap.get(vo.getCertificateId())))) {
                        vo.setUrl(detail.getUrl());
                    }
                    if (vo.getShiftId() != null) {
                        TrainingLearnShift shift = (TrainingLearnShift)shiftMap.get(vo.getShiftId());
                        if (!org.springframework.util.StringUtils.isEmpty((Object)shift) && shift.getStatus() == 4) {
                            vo.setIsFinishShift(Integer.valueOf(1));
                        } else {
                            vo.setIsFinishShift(Integer.valueOf(0));
                        }
                    }
                    if (vo.getId() == null) continue;
                    List examineList = (List)examineMap.get(vo.getId());
                    if (examineList != null && examineList.size() > 0) {
                        vo.setIsAuto(Integer.valueOf(1));
                        continue;
                    }
                    vo.setIsAuto(Integer.valueOf(0));
                }
            }
        }
        catch (NumberFormatException e2) {
            log.error("", (Throwable)e2);
        }
        return taskUserList;
    }

    public Map selectLearnUserStatus(Map project) {
        BaseResult base;
        Page page = new Page();
        page.setPageSize(9999);
        page.setPageNumber(1);
        Users user = (Users)project.get("user");
        Integer projectId = Integer.parseInt(project.get("projectId").toString());
        List<Integer> shiftIds = null;
        LambdaQueryWrapper managerWrapper0 = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)managerWrapper0.eq(TrainingLearnManager::getProjectId, (Object)projectId)).eq(TrainingLearnManager::getUserId, (Object)user.getId())).eq(TrainingLearnManager::getManagerType, (Object)1);
        List managerLists0 = this.managerMapper.selectList((Wrapper)managerWrapper0);
        Integer isShiftId = 0;
        if (!this.commonRemoteService.isSuper(user.getId()).booleanValue() && CollectionUtils.isEmpty((Collection)managerLists0)) {
            List shiftIdes;
            List<TrainingLearnManager> managerLists1 = this.getLearnManagerRole(projectId, user);
            LambdaQueryWrapper managerWrapper2 = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)managerWrapper2.eq(TrainingLearnManager::getProjectId, (Object)projectId)).eq(TrainingLearnManager::getUserId, (Object)user.getId())).eq(TrainingLearnManager::getManagerType, (Object)3);
            List managerLists2 = this.managerMapper.selectList((Wrapper)managerWrapper2);
            LambdaQueryWrapper wrapperIn = new LambdaQueryWrapper();
            wrapperIn.eq(TrainingLearnShift::getProjectId, (Object)projectId);
            if (!CollectionUtils.isEmpty(managerLists1) && CollectionUtils.isEmpty((Collection)managerLists2)) {
                wrapperIn.eq(TrainingLearnShift::getCreatorId, (Object)user.getId());
            } else if (!CollectionUtils.isEmpty(managerLists1) && !CollectionUtils.isEmpty((Collection)managerLists2)) {
                shiftIdes = managerLists2.stream().map(TrainingLearnManager::getShiftId).collect(Collectors.toList());
                wrapperIn.and(wq -> {
                    LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wq.eq(TrainingLearnShift::getCreatorId, (Object)user.getId())).or()).in(TrainingLearnShift::getId, (Collection)shiftIdes);
                });
            } else if (CollectionUtils.isEmpty(managerLists1) && !CollectionUtils.isEmpty((Collection)managerLists2)) {
                shiftIdes = managerLists2.stream().map(TrainingLearnManager::getShiftId).collect(Collectors.toList());
                wrapperIn.in(TrainingLearnShift::getId, shiftIdes);
            }
            List shiftList = this.shiftMapper.selectList((Wrapper)wrapperIn);
            if (!CollectionUtils.isEmpty((Collection)shiftList)) {
                shiftIds = shiftList.stream().map(TrainingLearnShift::getId).collect(Collectors.toList());
            }
            isShiftId = 1;
        }
        List<Integer> userList = new ArrayList<Integer>();
        String groupName = null;
        if (!org.springframework.util.StringUtils.isEmpty(project.get("userName")) && (base = this.userApi.getSimpleUserByKeyWord(user.getGroupId(), project.get("userName").toString(), null)) != null) {
            List pojoList = (List)base.getData();
            userList = pojoList.stream().map(SimplePojo::getId).distinct().collect(Collectors.toList());
        }
        if (project.get("id") != null) {
            Integer shiftId = Integer.parseInt(project.get("id").toString());
            if (!CollectionUtils.isEmpty(shiftIds)) {
                shiftIds.retainAll(Arrays.asList(shiftId));
            } else {
                shiftIds = Arrays.asList(shiftId);
            }
        }
        if (project.get("groupName") != null) {
            groupName = project.get("groupName").toString();
        }
        List<TrainingLearnUserVo> taskUserList = null;
        if (!(CollectionUtils.isEmpty(shiftIds) && isShiftId == 1 || !org.springframework.util.StringUtils.isEmpty(project.get("userName")) && CollectionUtils.isEmpty(userList))) {
            taskUserList = this.learnUserMapper.selectUserTaskByPage((Page<TrainingLearnUserVo>)page, shiftIds, projectId, groupName, userList, user.getGroupId(), project.get("creatorId") == null ? null : Integer.valueOf(project.get("creatorId").toString()));
        }
        int noNum = 0;
        int ingNum = 0;
        int finishNum = 0;
        if (!CollectionUtils.isEmpty(taskUserList)) {
            for (TrainingLearnUserVo vo : taskUserList) {
                if (vo.getLearnStatus() == 0 || vo.getLearnStatus() == 1) {
                    ++noNum;
                    continue;
                }
                if (vo.getLearnStatus() == 2) {
                    ++ingNum;
                    continue;
                }
                if (vo.getLearnStatus() != 3) continue;
                ++finishNum;
            }
        }
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("totalNum", CollectionUtils.isEmpty((Collection)taskUserList) ? 0 : taskUserList.size());
        map.put("noNum", noNum);
        map.put("ingNum", ingNum);
        map.put("finishNum", finishNum);
        return map;
    }

    @Override
    public Page<StudentReportVo> studentReportByPage(StudentReportRequestVo vo) {
        com.baomidou.mybatisplus.extension.plugins.pagination.Page page = new com.baomidou.mybatisplus.extension.plugins.pagination.Page((long)vo.getPageNumber().intValue(), (long)vo.getPageSize().intValue());
        com.baomidou.mybatisplus.extension.plugins.pagination.Page<StudentReportVo> studentReportVoPage = this.learnMapper.studentReports(page, this.getQuery(vo));
        Page result = new Page();
        result.setPageNumber(vo.getPageNumber().intValue());
        result.setPageSize(vo.getPageSize().intValue());
        result.setPageCount(Long.valueOf(0L));
        result.setTotalCount(Long.valueOf(0L));
        if (studentReportVoPage != null && !CollectionUtils.isEmpty((Collection)studentReportVoPage.getRecords())) {
            result.setPageCount(Long.valueOf(studentReportVoPage.getPages()));
            result.setTotalCount(Long.valueOf(studentReportVoPage.getTotal()));
            List<Integer> creatorIds = studentReportVoPage.getRecords().stream().map(it -> it.getCreatorId()).distinct().collect(Collectors.toList());
            Map<Integer, UsersPojo> userMap = this.userUtilService.selectUserMap(creatorIds);
            List<Integer> userIds = studentReportVoPage.getRecords().stream().map(it -> it.getUserId()).distinct().collect(Collectors.toList());
            Map userOrganizeMap = (Map)this.userOrganizeApi.getUserOrganizeFirstByUserIds(vo.getEnterpriseId(), userIds, null).getData();
            Map<Object, Object> parentMap = new HashMap();
            if (!CollectionUtils.isEmpty(userIds)) {
                parentMap = this.userUtilService.selectParentMap(userIds, vo.getEnterpriseId());
            }
            List records = studentReportVoPage.getRecords();
            Iterator iterator = records.iterator();
            while (iterator.hasNext()) {
                StudentReportVo rec;
                rec.setCreatorName(userMap.get((rec = (StudentReportVo)iterator.next()).getCreatorId()) == null ? "" : userMap.get(rec.getCreatorId()).getShowName());
                List userStr = (List)userOrganizeMap.get(rec.getUserId());
                if (!CollectionUtils.isEmpty((Collection)userStr)) {
                    rec.setOrganizeName(String.join((CharSequence)";", userStr));
                }
                rec.setParentName((String)parentMap.get(rec.getUserId()));
            }
            result.setContent(records);
        }
        return result;
    }

    @Override
    public List<StudentReportVo> studentReports(StudentReportRequestVo vo) {
        List<StudentReportVo> studentReportVoList = this.learnMapper.studentReportList(this.getQuery(vo));
        if (!CollectionUtils.isEmpty(studentReportVoList)) {
            List<Integer> creatorIds = studentReportVoList.stream().map(it -> it.getCreatorId()).distinct().collect(Collectors.toList());
            Map<Integer, UsersPojo> userMap = this.userUtilService.selectUserMap(creatorIds);
            List<Integer> userIds = studentReportVoList.stream().map(it -> it.getUserId()).distinct().collect(Collectors.toList());
            Map userOrganizeMap = (Map)this.userOrganizeApi.getUserOrganizeFirstByUserIds(vo.getEnterpriseId(), userIds, null).getData();
            Map<Object, Object> parentMap = new HashMap();
            if (!CollectionUtils.isEmpty(userIds)) {
                parentMap = this.userUtilService.selectParentMap(userIds, vo.getEnterpriseId());
            }
            for (StudentReportVo rec : studentReportVoList) {
                rec.setCreatorName(userMap.get(rec.getCreatorId()) == null ? "" : userMap.get(rec.getCreatorId()).getShowName());
                List userStr = (List)userOrganizeMap.get(rec.getUserId());
                if (!CollectionUtils.isEmpty((Collection)userStr)) {
                    rec.setOrganizeName(String.join((CharSequence)";", userStr));
                }
                rec.setParentName((String)parentMap.get(rec.getUserId()));
            }
        }
        return studentReportVoList;
    }

    @Override
    public StudentReportCountVo studentReportCount(StudentReportRequestVo vo) {
        List<StudentReportCountVo> studentReportCountVos = this.learnMapper.studentReportCount(this.getQuery(vo));
        StudentReportCountVo result = new StudentReportCountVo();
        if (!CollectionUtils.isEmpty(studentReportCountVos)) {
            result.setTotal(Integer.valueOf(studentReportCountVos.size()));
            for (StudentReportCountVo studentReportCountVo : studentReportCountVos) {
                if (studentReportCountVo.getIngNum() > 0) {
                    result.setIngNum(Integer.valueOf(result.getIngNum() + 1));
                    continue;
                }
                if (studentReportCountVo.getNoNum() > 0) {
                    result.setNoNum(Integer.valueOf(result.getNoNum() + 1));
                    continue;
                }
                if (studentReportCountVo.getTotal() == studentReportCountVo.getPassNum()) {
                    result.setPassNum(Integer.valueOf(result.getPassNum() + 1));
                }
                if (studentReportCountVo.getTotal() != studentReportCountVo.getFinishNum()) continue;
                result.setFinishNum(Integer.valueOf(result.getFinishNum() + 1));
            }
        }
        return result;
    }

    private QueryWrapper getQuery(StudentReportRequestVo vo) {
        String keyWord;
        List organizeIds;
        List creatorIds;
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"e.enterprise_id", (Object)vo.getEnterpriseId());
        queryWrapper.ge((Object)"e.create_time", (Object)vo.getShiftStartCreateTime());
        queryWrapper.eq((Object)"e.is_delete", (Object)0);
        if (vo.getShiftStatus() != null) {
            if (vo.getShiftStatus() == ProjectShiftStatusEnum.NOT_ONLINE.getKey()) {
                queryWrapper.le((Object)"d.status", (Object)ProjectShiftStatusEnum.WAIT_START.getKey());
            } else if (vo.getShiftStatus() == ProjectShiftStatusEnum.ONLINE.getKey()) {
                queryWrapper.gt((Object)"d.status", (Object)ProjectShiftStatusEnum.WAIT_START.getKey());
            } else {
                queryWrapper.eq((Object)"d.status", (Object)vo.getShiftStatus());
            }
        }
        if (!CollectionUtils.isEmpty((Collection)(creatorIds = vo.getCreatorIds()))) {
            if (creatorIds.size() == 1) {
                queryWrapper.eq((Object)"d.creator_id", creatorIds.get(0));
            } else {
                queryWrapper.in((Object)"d.creator_id", (Collection)creatorIds);
            }
        }
        queryWrapper.ge((Object)"d.create_time", (Object)vo.getShiftStartCreateTime());
        queryWrapper.le((Object)"d.create_time", (Object)vo.getShiftEndCreateTime());
        if (vo.getShiftStartTime() != null && vo.getShiftEndTime() != null) {
            queryWrapper.ge((Object)"d.start_time", (Object)vo.getShiftStartTime());
            queryWrapper.lt((Object)"d.start_time", (Object)vo.getShiftEndTime());
        }
        if (vo.getDutiesId() != null) {
            queryWrapper.eq((Object)"h.id", (Object)vo.getDutiesId());
        }
        if (vo.getLearnStatus() != null) {
            queryWrapper.eq((Object)"e.learn_status", (Object)vo.getLearnStatus());
        }
        if (!CollectionUtils.isEmpty((Collection)(organizeIds = vo.getOrganizeIds()))) {
            ArrayList<Integer> organizeList = new ArrayList<Integer>();
            for (String org : organizeIds) {
                organizeList.add(Integer.valueOf(org.substring(2)));
            }
            BaseResult base = this.userOrganizeApi.getUserOrganizeByOrgIds(vo.getEnterpriseId(), organizeList);
            if (base != null && !CollectionUtils.isEmpty((Collection)((Collection)base.getData()))) {
                queryWrapper.in((Object)"e.user_id", (Collection)((List)base.getData()).stream().map(UserAndParentNameMo::getUserId).distinct().collect(Collectors.toList()));
            } else {
                queryWrapper.isNull((Object)"e.user_id");
            }
        }
        if (!org.springframework.util.StringUtils.isEmpty((Object)vo.getShiftName())) {
            String shiftName = vo.getShiftName().replace("-", "").trim();
            queryWrapper.like((Object)"CONCAT(d.shift_name,d.group_name,d.supplemen_name)", (Object)shiftName);
        }
        if (!org.springframework.util.StringUtils.isEmpty((Object)(keyWord = vo.getKeyWord()))) {
            queryWrapper.and(wrapper -> {
                QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)((QueryWrapper)wrapper.like((Object)"f.show_name", (Object)keyWord.trim())).or()).eq((Object)"f.employee_number", (Object)keyWord.trim());
            });
        }
        return queryWrapper;
    }

    @Override
    public void saveTaskRate(List<TrainingTaskScheduleVo> scheduleVoList, Users user) {
        if (!CollectionUtils.isEmpty(scheduleVoList)) {
            TrainingTaskScheduleVo scheduleVo = scheduleVoList.get(0);
            TrainingProjectTask projectTask = (TrainingProjectTask)this.projectMapper.selectById(scheduleVo.getTaskId());
            TrainingLearnProject project = (TrainingLearnProject)this.learnMapper.selectById(projectTask.getProjectId());
            LambdaQueryWrapper wrapper0 = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)wrapper0.eq(TrainingLearnShift::getProjectId, (Object)projectTask.getProjectId())).eq(TrainingLearnShift::getStatus, (Object)4);
            List shiftList0 = this.shiftMapper.selectList((Wrapper)wrapper0);
            List<Object> shiftIdList = new ArrayList();
            if (!CollectionUtils.isEmpty((Collection)shiftList0)) {
                shiftIdList = shiftList0.stream().map(TrainingLearnShift::getId).distinct().collect(Collectors.toList());
            }
            for (TrainingTaskScheduleVo vo : scheduleVoList) {
                LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
                wrapper.eq(TrainingTaskSchedule::getTaskId, (Object)vo.getTaskId());
                if (!CollectionUtils.isEmpty(shiftIdList)) {
                    List<Object> finalShiftIdList = shiftIdList;
                    wrapper.and(wp -> {
                        LambdaUpdateWrapper cfr_ignored_0 = (LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)wp.notIn(TrainingTaskSchedule::getShiftId, (Collection)finalShiftIdList)).or()).isNull(TrainingTaskSchedule::getShiftId);
                    });
                }
                this.scheduleMapper.update(vo, (Wrapper)wrapper);
            }
            LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper1.eq(TrainingLearnShift::getProjectId, (Object)projectTask.getProjectId())).in(TrainingLearnShift::getStatus, Arrays.asList(2, 3, 5))).isNull(TrainingLearnShift::getJobShiftId);
            List shiftList = this.shiftMapper.selectList((Wrapper)wrapper1);
            if (!CollectionUtils.isEmpty((Collection)shiftList)) {
                List shiftIds = shiftList.stream().map(TrainingLearnShift::getId).distinct().collect(Collectors.toList());
                LambdaQueryWrapper wrapper2 = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper2.eq(TrainingLearnUser::getIsDelete, (Object)0)).in(TrainingLearnUser::getShiftId, shiftIds)).isNotNull(TrainingLearnUser::getScore);
                List learnUserList = this.learnUserMapper.selectList((Wrapper)wrapper2);
                if (!CollectionUtils.isEmpty((Collection)learnUserList)) {
                    LambdaQueryWrapper wrapper3 = new LambdaQueryWrapper();
                    ((LambdaQueryWrapper)wrapper3.in(TrainingTaskSchedule::getShiftId, shiftIds)).isNotNull(TrainingTaskSchedule::getTaskRate);
                    List taskSchedules = this.scheduleMapper.selectList((Wrapper)wrapper3);
                    if (!CollectionUtils.isEmpty((Collection)taskSchedules)) {
                        Map map = taskSchedules.stream().collect(Collectors.toMap(TrainingTaskSchedule::getId, Function.identity()));
                        List userIds = learnUserList.stream().map(TrainingLearnUser::getUserId).distinct().collect(Collectors.toList());
                        LambdaQueryWrapper wrapper4 = new LambdaQueryWrapper();
                        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper4.in(TrainingLearnTaskUser::getShiftId, shiftIds)).in(TrainingLearnTaskUser::getUserId, userIds)).isNotNull(TrainingLearnTaskUser::getScore)).isNull(TrainingLearnTaskUser::getJobUserTaskId);
                        List learnTaskUsers = this.taskUserMapper.selectList((Wrapper)wrapper4);
                        if (!CollectionUtils.isEmpty((Collection)learnTaskUsers)) {
                            Map<Integer, List> taskUserMap = learnTaskUsers.stream().collect(Collectors.toMap(TrainingLearnTaskUser::getUserId, e -> new ArrayList<TrainingLearnTaskUser>(Arrays.asList(e)), (oldList, newList) -> {
                                oldList.addAll(newList);
                                return oldList;
                            }));
                            for (TrainingLearnUser learnUser : learnUserList) {
                                List taskUserList = taskUserMap.get(learnUser.getUserId());
                                Integer shiftId = learnUser.getShiftId();
                                BigDecimal score = new BigDecimal(0);
                                BigDecimal totalScore = new BigDecimal(0);
                                if (!CollectionUtils.isEmpty((Collection)taskUserList)) {
                                    for (TrainingLearnTaskUser learnTaskUser : taskUserList) {
                                        TrainingTaskSchedule taskSchedule;
                                        if (learnTaskUser.getShiftId().intValue() != shiftId.intValue() || org.springframework.util.StringUtils.isEmpty((Object)(taskSchedule = (TrainingTaskSchedule)map.get(learnTaskUser.getProjectTaskScheduleId())))) continue;
                                        score = score.add(learnTaskUser.getScore().multiply(taskSchedule.getTaskRate()).multiply(BigDecimal.valueOf(0.01))).setScale(1, 4);
                                        totalScore = totalScore.add(taskSchedule.getFullScore().multiply(taskSchedule.getTaskRate()).multiply(BigDecimal.valueOf(0.01))).setScale(1, 4);
                                    }
                                }
                                learnUser.setScore(score);
                                if (project.getStudyType() == 2) {
                                    if (score.compareTo(totalScore.multiply(project.getPassRate()).multiply(new BigDecimal(0.01))) < 0) {
                                        learnUser.setPassStatus(Integer.valueOf(0));
                                    } else {
                                        learnUser.setPassStatus(Integer.valueOf(1));
                                    }
                                }
                                this.learnUserMapper.updateById(learnUser);
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public List<TrainingProjectTaskVo> selectStudyRate(TrainingTaskScheduleVo scheduleVo, Users user) {
        ArrayList<TrainingProjectTaskVo> projectTaskVo = new ArrayList<TrainingProjectTaskVo>();
        LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper1.eq(TrainingProjectTask::getProjectId, (Object)scheduleVo.getProjectId())).in(TrainingProjectTask::getTaskType, Arrays.asList(2, 3))).orderByAsc(TrainingProjectTask::getSort);
        List tasks = this.projectMapper.selectList((Wrapper)wrapper1);
        if (!CollectionUtils.isEmpty((Collection)tasks)) {
            for (TrainingProjectTask projectTask : tasks) {
                TrainingProjectTaskVo vo = new TrainingProjectTaskVo();
                BeanUtils.copyProperties((Object)projectTask, (Object)vo);
                LambdaQueryWrapper wrapper2 = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper2.eq(TrainingTaskSchedule::getTaskId, (Object)vo.getId())).isNull(TrainingTaskSchedule::getShiftId)).last(" limit 1 ");
                TrainingTaskSchedule taskSchedule = (TrainingTaskSchedule)this.scheduleMapper.selectOne((Wrapper)wrapper2);
                TrainingTaskScheduleVo taskScheduleVo = new TrainingTaskScheduleVo();
                BeanUtils.copyProperties((Object)taskSchedule, (Object)taskScheduleVo);
                ArrayList<TrainingTaskScheduleVo> scheduleVoList = new ArrayList<TrainingTaskScheduleVo>();
                scheduleVoList.add(taskScheduleVo);
                vo.setScheduleList(scheduleVoList);
                projectTaskVo.add(vo);
            }
        }
        return projectTaskVo;
    }

    @Override
    public void updateLearnProjectIsFinish(Integer projectId, Integer shiftId, Integer userId) {
        Locale locale = Authenticator.getInstance().getCurrentClient().getLocale();
        TrainingLearnProject project = (TrainingLearnProject)this.learnMapper.selectById(projectId);
        LambdaQueryWrapper scheduleWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)scheduleWrapper.eq(TrainingTaskSchedule::getProjectId, (Object)projectId)).eq(TrainingTaskSchedule::getShiftId, (Object)shiftId);
        List trainingTaskScheduleList = this.scheduleMapper.selectList((Wrapper)scheduleWrapper);
        if (!CollectionUtils.isEmpty((Collection)trainingTaskScheduleList)) {
            List idList = trainingTaskScheduleList.stream().map(TrainingTaskSchedule::getId).collect(Collectors.toList());
            TrainingLearnUser learnUser = new TrainingLearnUser();
            LambdaQueryWrapper learnUserWrapper = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)learnUserWrapper.eq(TrainingLearnUser::getUserId, (Object)userId)).eq(TrainingLearnUser::getShiftId, (Object)shiftId)).eq(TrainingLearnUser::getIsDelete, (Object)0)).orderByDesc(TrainingLearnUser::getId);
            List learnUserList = this.learnUserMapper.selectList((Wrapper)learnUserWrapper);
            if (!CollectionUtils.isEmpty((Collection)learnUserList)) {
                learnUser = (TrainingLearnUser)learnUserList.get(0);
                if (!org.springframework.util.StringUtils.isEmpty((Object)learnUser.getStartTime())) {
                    learnUser.setStartTime(new Date());
                    learnUser.setLearnStatus(Integer.valueOf(2));
                    this.learnUserMapper.updateById(learnUser);
                }
            } else {
                learnUser.setLearnStatus(Integer.valueOf(2));
                learnUser.setIsDelete(Integer.valueOf(0));
                learnUser.setUserId(userId);
                learnUser.setCreateTime(new Date());
                learnUser.setShiftId(shiftId);
                learnUser.setEnterpriseId(project.getEnterpriseId());
                learnUser.setExecutorId(userId);
                this.learnUserMapper.insert(learnUser);
            }
            LambdaQueryWrapper learnWrapper = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)learnWrapper.eq(TrainingLearnTaskUser::getUserId, (Object)userId)).eq(TrainingLearnTaskUser::getShiftId, (Object)shiftId)).in(TrainingLearnTaskUser::getProjectTaskScheduleId, idList);
            if (project.getStudyType() == 2) {
                learnWrapper.in(TrainingLearnTaskUser::getTaskStatus, Arrays.asList(3, 4));
            } else {
                learnWrapper.eq(TrainingLearnTaskUser::getTaskStatus, (Object)4);
            }
            List list = this.taskUserMapper.selectList((Wrapper)learnWrapper);
            if (!CollectionUtils.isEmpty((Collection)list)) {
                if (list.size() == idList.size()) {
                    Integer passStatus = 0;
                    BigDecimal scores = null;
                    LambdaQueryWrapper wrapper3 = new LambdaQueryWrapper();
                    ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper3.eq(TrainingLearnTaskUser::getShiftId, (Object)shiftId)).eq(TrainingLearnTaskUser::getUserId, (Object)userId)).in(TrainingLearnTaskUser::getTaskStatus, Arrays.asList(3, 4))).isNotNull(TrainingLearnTaskUser::getScore);
                    List taskUserList = this.taskUserMapper.selectList((Wrapper)wrapper3);
                    if (!CollectionUtils.isEmpty((Collection)taskUserList)) {
                        LambdaQueryWrapper wrapper4 = new LambdaQueryWrapper();
                        ((LambdaQueryWrapper)wrapper4.eq(TrainingTaskSchedule::getShiftId, (Object)shiftId)).isNotNull(TrainingTaskSchedule::getTaskRate);
                        List scheduleList = this.scheduleMapper.selectList((Wrapper)wrapper4);
                        if (!CollectionUtils.isEmpty((Collection)scheduleList)) {
                            Map scheduleMap = scheduleList.stream().collect(Collectors.toMap(TrainingTaskSchedule::getId, Function.identity()));
                            BigDecimal score = new BigDecimal(0);
                            BigDecimal totalScore = new BigDecimal(0);
                            for (TrainingLearnTaskUser taskUsers : taskUserList) {
                                TrainingTaskSchedule schedule = (TrainingTaskSchedule)scheduleMap.get(taskUsers.getProjectTaskScheduleId());
                                if (org.springframework.util.StringUtils.isEmpty((Object)schedule.getTaskRate())) continue;
                                score = taskUsers.getScore().multiply(schedule.getTaskRate()).multiply(BigDecimal.valueOf(0.01)).add(score).setScale(1, 4);
                                if (org.springframework.util.StringUtils.isEmpty((Object)schedule.getFullScore())) continue;
                                totalScore = schedule.getFullScore().multiply(schedule.getTaskRate()).multiply(new BigDecimal(0.01)).add(totalScore).setScale(1, 4);
                            }
                            if (!org.springframework.util.StringUtils.isEmpty((Object)project) && !org.springframework.util.StringUtils.isEmpty((Object)project.getPassRate()) && score.compareTo(totalScore.multiply(project.getPassRate()).multiply(new BigDecimal(0.01))) >= 0) {
                                passStatus = 1;
                            }
                            scores = score;
                        }
                    }
                    if (project.getStudyType() == 1) {
                        passStatus = 1;
                    }
                    if (!org.springframework.util.StringUtils.isEmpty((Object)learnUser)) {
                        learnUser.setScore(scores);
                        learnUser.setLearnStatus(Integer.valueOf(3));
                        learnUser.setPassStatus(passStatus);
                        learnUser.setEndTime(new Date());
                        this.learnUserMapper.updateById(learnUser);
                    }
                    if (passStatus == 1) {
                        TrainingLearnExamine examine = new TrainingLearnExamine();
                        examine.setPassStatus(passStatus);
                        examine.setUserId(userId);
                        examine.setShiftId(shiftId);
                        examine.setLearnUserId(learnUser.getId());
                        examine.setIsAuto(Integer.valueOf(0));
                        examine.setCreateTime(new Date());
                        examine.setEnterpriseId(project.getEnterpriseId());
                        this.examineMapper.insert(examine);
                        String title = "";
                        if (!org.springframework.util.StringUtils.isEmpty((Object)project.getCertificateId()) && !org.springframework.util.StringUtils.isEmpty((Object)project.getIsGet()) && project.getIsGet() == 1) {
                            LambdaQueryWrapper certWrapper = new LambdaQueryWrapper();
                            ((LambdaQueryWrapper)certWrapper.eq(TrainingCertificateDetail::getCertificateId, (Object)project.getCertificateId())).eq(TrainingCertificateDetail::getUserId, (Object)userId);
                            List details = this.certificateDetailMapper.selectList((Wrapper)certWrapper);
                            if (!CollectionUtils.isEmpty((Collection)details)) {
                                TrainingCertificateDetail detail = (TrainingCertificateDetail)details.get(0);
                                if (detail.getStatus() != 1) {
                                    detail.setStatus(Integer.valueOf(1));
                                    detail.setIsAlways(Integer.valueOf(1));
                                    if (!org.springframework.util.StringUtils.isEmpty((Object)project.getProjectName())) {
                                        detail.setTaskName(project.getProjectName());
                                    }
                                    this.certificateDetailMapper.updateById(detail);
                                }
                                learnUser.setCertificateId(detail.getId());
                            } else {
                                ArrayList<TrainingCertificateDetailVo> voList = new ArrayList<TrainingCertificateDetailVo>();
                                TrainingCertificateDetailVo vo = new TrainingCertificateDetailVo();
                                vo.setUserId(userId);
                                vo.setCertificateId(project.getCertificateId());
                                vo.setUrl(project.getCertificatePath());
                                vo.setOrigin(Integer.valueOf(3));
                                if (!org.springframework.util.StringUtils.isEmpty((Object)project.getProjectName())) {
                                    vo.setTaskName(project.getProjectName());
                                }
                                Map<Integer, UsersPojo> userMap = this.userUtilService.selectUserMap(Arrays.asList(userId, project.getCreater()));
                                vo.setUserName(userMap.get(userId).getShowName());
                                voList.add(vo);
                                UsersPojo pojo = userMap.get(project.getCreater());
                                Users user = new Users();
                                BeanUtils.copyProperties((Object)pojo, (Object)user);
                                List<TrainingCertificateDetailVo> voc = this.certificateService.insertCertificateDetail(voList, user);
                                if (!CollectionUtils.isEmpty(voc)) {
                                    learnUser.setCertificateId(voc.get(0).getId());
                                }
                            }
                            this.learnUserMapper.updateById(learnUser);
                            TrainingCertificate trainingCertificate = (TrainingCertificate)this.certificateMapper.selectById(project.getCertificateId());
                            if (!org.springframework.util.StringUtils.isEmpty((Object)trainingCertificate)) {
                                title = trainingCertificate.getCertificateName();
                            }
                        }
                        String learnName = this.messageSource.getMessage("training.learn.title", null, locale);
                        TrainingLearnShift shift = (TrainingLearnShift)this.shiftMapper.selectById(shiftId);
                        TaskMessageBody body = new TaskMessageBody();
                        body.setType(95);
                        HashMap msg = Maps.newHashMap();
                        String shiftName = org.springframework.util.StringUtils.isEmpty((Object)shift.getSupplemenName()) ? MessageFormat.format("{0}-{1}", shift.getShiftName(), shift.getGroupName()) : MessageFormat.format("{0}-{1}-{2}", shift.getShiftName(), shift.getGroupName(), shift.getSupplemenName());
                        msg.put("projectId", shift.getProjectId());
                        msg.put("shiftId", shift.getId());
                        msg.put("title", learnName);
                        body.setTaskJson(JSONObject.toJSONString((Object)msg));
                        if (org.springframework.util.StringUtils.isEmpty((Object)title)) {
                            this.jPushService.sendWebSocket(learnName, this.messageSource.getMessage("training.learn.pass.exam", new Object[]{shiftName}, locale), userId, project.getEnterpriseId(), shift.getId(), "TYPE_TRAINING_PASS_TYPE", JSONObject.toJSONString((Object)msg), null, 1, 0, "training.learn.pass.exam", shiftName);
                            this.jPushService.pushNotification(JPush.MASSAGE_TYPE_NOTIFY, "TYPE_TRAINING_PASS_TYPE", userId, learnName, MessageFormat.format(this.messageSource.getMessage("training.learn.pass.exam", null, locale), shiftName), body);
                        } else {
                            this.jPushService.sendWebSocket(learnName, this.messageSource.getMessage("training.learn.pass.exam.cert", new Object[]{shiftName, title}, locale), userId, project.getEnterpriseId(), shift.getId(), "TYPE_TRAINING_PASS_TYPE", JSONObject.toJSONString((Object)msg), null, 1, 0, "training.learn.pass.exam.cert", shiftName + "," + title);
                            this.jPushService.pushNotification(JPush.MASSAGE_TYPE_NOTIFY, "TYPE_TRAINING_PASS_TYPE", userId, learnName, this.messageSource.getMessage("training.learn.pass.exam.cert", new Object[]{shiftName, title}, locale), body);
                        }
                        if (!org.springframework.util.StringUtils.isEmpty((Object)shift) && !org.springframework.util.StringUtils.isEmpty((Object)shift.getStatus()) && shift.getStatus() < ProjectShiftStatusEnum.WAIT_END.getKey()) {
                            LambdaQueryWrapper wrapper2 = new LambdaQueryWrapper();
                            ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper2.eq(TrainingLearnUser::getShiftId, (Object)shiftId)).and(wq -> {
                                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wq.isNull(TrainingLearnUser::getPassStatus)).or()).eq(TrainingLearnUser::getPassStatus, (Object)0);
                            })).eq(TrainingLearnUser::getIsDelete, (Object)0);
                            List learnUserLists = this.learnUserMapper.selectList((Wrapper)wrapper2);
                            if (CollectionUtils.isEmpty((Collection)learnUserLists)) {
                                TrainingLearnShift learnShift = new TrainingLearnShift();
                                learnShift.setId(shiftId);
                                learnShift.setStatus(ProjectShiftStatusEnum.WAIT_END.getKey());
                                this.shiftMapper.updateById(learnShift);
                            }
                        }
                    }
                } else if (learnUser != null) {
                    this.learnUserMapper.updateOnlyStatusById(learnUser.getId());
                } else {
                    learnUser = new TrainingLearnUser();
                    learnUser.setLearnStatus(Integer.valueOf(2));
                    learnUser.setIsDelete(Integer.valueOf(0));
                    learnUser.setUserId(userId);
                    learnUser.setCreateTime(new Date());
                    learnUser.setShiftId(shiftId);
                    learnUser.setEnterpriseId(project.getEnterpriseId());
                    learnUser.setExecutorId(userId);
                    this.learnUserMapper.insert(learnUser);
                }
            } else if (!org.springframework.util.StringUtils.isEmpty((Object)learnUser)) {
                this.learnUserMapper.updateOnlyStatusById(learnUser.getId());
            } else {
                learnUser = new TrainingLearnUser();
                learnUser.setLearnStatus(Integer.valueOf(2));
                learnUser.setIsDelete(Integer.valueOf(0));
                learnUser.setUserId(userId);
                learnUser.setCreateTime(new Date());
                learnUser.setShiftId(shiftId);
                learnUser.setEnterpriseId(project.getEnterpriseId());
                learnUser.setExecutorId(userId);
                this.learnUserMapper.insert(learnUser);
            }
        }
    }

    @Override
    public List<TrainingLearnShiftRecordVo> selectLearnShiftReviewRecord(TrainingLearnShiftVo trainingLearnShiftVo, Users user) {
        ArrayList<TrainingLearnShiftRecordVo> trainingLearnShiftRecordVoList = new ArrayList<TrainingLearnShiftRecordVo>();
        LambdaQueryWrapper wrapper2 = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)wrapper2.eq(TrainingLearnShiftRecord::getShiftId, (Object)trainingLearnShiftVo.getId())).orderByDesc(TrainingLearnShiftRecord::getCreateTime);
        List trainingLearnShiftRecordList = this.trainingLearnShiftRecordMapper.selectList((Wrapper)wrapper2);
        if (!CollectionUtils.isEmpty((Collection)trainingLearnShiftRecordList)) {
            ArrayList<Integer> userIdList = new ArrayList<Integer>();
            List userIds1 = trainingLearnShiftRecordList.stream().map(TrainingLearnShiftRecord::getCreater).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            List userIds2 = trainingLearnShiftRecordList.stream().map(TrainingLearnShiftRecord::getReviewer).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            userIdList.addAll(userIds1);
            userIdList.addAll(userIds2);
            Map<Integer, UsersPojo> usersPojoMap = this.userUtilService.selectUserMap(userIdList);
            List trainingLearnShiftRecordIdList = trainingLearnShiftRecordList.stream().map(TrainingLearnShiftRecord::getId).collect(Collectors.toList());
            LambdaQueryWrapper wrapper3 = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)wrapper3.in(TrainingProjectDocument::getProjectId, trainingLearnShiftRecordIdList)).eq(TrainingProjectDocument::getType, (Object)5);
            List trainingProjectDocumentList = this.documentMapper.selectList((Wrapper)wrapper3);
            Map<Object, Object> documentMap = new HashMap();
            if (!CollectionUtils.isEmpty((Collection)trainingProjectDocumentList)) {
                documentMap = trainingProjectDocumentList.stream().collect(Collectors.groupingBy(TrainingProjectDocument::getProjectId));
            }
            TrainingLearnShiftRecordVo learnShiftRecordVo = null;
            for (TrainingLearnShiftRecord learnShiftRecord : trainingLearnShiftRecordList) {
                UsersPojo usersPojo;
                learnShiftRecordVo = new TrainingLearnShiftRecordVo();
                BeanUtils.copyProperties((Object)learnShiftRecord, (Object)learnShiftRecordVo);
                if (learnShiftRecord.getCreater() != null && !ObjectUtils.isEmpty((Object)(usersPojo = usersPojoMap.get(learnShiftRecord.getCreater())))) {
                    learnShiftRecordVo.setCreaterName(usersPojo.getShowName());
                }
                if (learnShiftRecord.getReviewer() != null && !ObjectUtils.isEmpty((Object)(usersPojo = usersPojoMap.get(learnShiftRecord.getReviewer())))) {
                    learnShiftRecordVo.setReviewerName(usersPojo.getShowName());
                }
                learnShiftRecordVo.setDocumentList((List)documentMap.get(learnShiftRecord.getId()));
                trainingLearnShiftRecordVoList.add(learnShiftRecordVo);
            }
        }
        return trainingLearnShiftRecordVoList;
    }

    @Override
    public void saveLearnShiftReviewRecord(TrainingLearnShiftVo trainingLearnShiftVo, Users user) {
        Date now = new Date();
        TrainingLearnShift trainingLearnShift = (TrainingLearnShift)this.shiftMapper.selectById(trainingLearnShiftVo.getId());
        TrainingLearnProject trainingLearnProject = (TrainingLearnProject)this.learnMapper.selectById(trainingLearnShift.getProjectId());
        if (trainingLearnShift.getStatus() == 4) {
            TrainingLearnShiftRecord trainingLearnShiftRecord = new TrainingLearnShiftRecord();
            trainingLearnShiftRecord.setCreater(user.getId());
            trainingLearnShiftRecord.setCreateTime(now);
            trainingLearnShiftRecord.setShiftId(trainingLearnShift.getId());
            trainingLearnShiftRecord.setProjectId(trainingLearnShift.getProjectId());
            trainingLearnShiftRecord.setStatus(Integer.valueOf(4));
            trainingLearnShiftRecord.setIsLast(Integer.valueOf(0));
            trainingLearnShiftRecord.setEnterpriseId(trainingLearnProject.getEnterpriseId());
            trainingLearnShiftRecord.setFinishDocument(trainingLearnShiftVo.getFinishDocument());
            this.trainingLearnShiftRecordMapper.insert(trainingLearnShiftRecord);
            if (!CollectionUtils.isEmpty((Collection)trainingLearnShiftVo.getDocumentList())) {
                ArrayList<TrainingProjectDocument> trainingProjectDocumentList = new ArrayList<TrainingProjectDocument>();
                for (TrainingProjectDocument document : trainingLearnShiftVo.getDocumentList()) {
                    document.setProjectId(trainingLearnShiftRecord.getId());
                    document.setType(Integer.valueOf(5));
                    document.setCreater(user.getId());
                    document.setCreateTime(now);
                    trainingProjectDocumentList.add(document);
                }
                this.documentMapper.insertList(trainingProjectDocumentList);
            }
            this.shiftMapper.updateById(trainingLearnShiftVo);
            LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
            ((LambdaUpdateWrapper)wrapper.eq(TrainingProjectDocument::getProjectId, (Object)trainingLearnShiftVo.getId())).eq(TrainingProjectDocument::getType, (Object)3);
            this.documentMapper.delete((Wrapper)wrapper);
            if (!CollectionUtils.isEmpty((Collection)trainingLearnShiftVo.getDocumentList())) {
                ArrayList<TrainingProjectDocument> trainingProjectDocumentList = new ArrayList<TrainingProjectDocument>();
                for (TrainingProjectDocument document : trainingLearnShiftVo.getDocumentList()) {
                    document.setProjectId(trainingLearnShiftVo.getId());
                    document.setType(Integer.valueOf(3));
                    document.setCreater(user.getId());
                    document.setCreateTime(now);
                    trainingProjectDocumentList.add(document);
                }
                this.documentMapper.insertList(trainingProjectDocumentList);
            }
        }
    }

    @Override
    public Page<TrainingLearnShiftRecordVo> selectLearnShiftRecordByPage(Page<TrainingLearnShiftRecordVo> page, Users user, String shiftName, Integer status, String createrName, String startTime, String endTime, Integer sortStatus) {
        Map<String, Object> userMap;
        List<Integer> userIdList = new ArrayList<Integer>();
        if (!org.springframework.util.StringUtils.isEmpty((Object)createrName) && CollectionUtils.isEmpty(userIdList = (List)(userMap = this.userUtilService.getCheckParameters(createrName, null, null, user)).get("userList"))) {
            return page;
        }
        List<TrainingLearnShiftRecordVo> trainingLearnShiftRecordVoList = this.trainingLearnShiftRecordMapper.selectLearnShiftRecordByPage(page, user.getId(), userIdList, status, shiftName, startTime, endTime, sortStatus);
        if (!CollectionUtils.isEmpty(trainingLearnShiftRecordVoList)) {
            ArrayList<Integer> userIds = new ArrayList<Integer>();
            List createrIds = trainingLearnShiftRecordVoList.stream().map(TrainingLearnShiftRecord::getCreater).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            List reviewerIds = trainingLearnShiftRecordVoList.stream().map(TrainingLearnShiftRecord::getReviewer).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(createrIds)) {
                userIds.addAll(createrIds);
            }
            if (!CollectionUtils.isEmpty(reviewerIds)) {
                userIds.addAll(reviewerIds);
            }
            if (!CollectionUtils.isEmpty(userIds)) {
                Locale locale = Authenticator.getInstance().getCurrentClient().getLocale();
                String systemName = this.messageSource.getMessage("training.paper.task.system", null, locale);
                Map<Integer, UsersPojo> userMap2 = this.userUtilService.selectUserMap(userIds);
                for (TrainingLearnShiftRecordVo trainingLearnShiftRecordVo : trainingLearnShiftRecordVoList) {
                    UsersPojo usersPojo;
                    if (trainingLearnShiftRecordVo.getCreater() != null && !ObjectUtils.isEmpty((Object)(usersPojo = userMap2.get(trainingLearnShiftRecordVo.getCreater())))) {
                        trainingLearnShiftRecordVo.setCreaterName(usersPojo.getShowName());
                    }
                    if (trainingLearnShiftRecordVo.getReviewer() != null && !ObjectUtils.isEmpty((Object)(usersPojo = userMap2.get(trainingLearnShiftRecordVo.getReviewer())))) {
                        trainingLearnShiftRecordVo.setReviewerName(usersPojo.getShowName());
                    }
                    if (status != 2 || !org.springframework.util.StringUtils.isEmpty((Object)trainingLearnShiftRecordVo.getReviewerName())) continue;
                    trainingLearnShiftRecordVo.setReviewerName(systemName);
                    trainingLearnShiftRecordVo.setReviewTime(trainingLearnShiftRecordVo.getCreateTime());
                }
            }
        }
        page.setContent(trainingLearnShiftRecordVoList);
        return page;
    }

    @Override
    public TrainingLearnShiftVo selectShiftReviewRecord(TrainingLearnShiftRecordVo trainingLearnShiftRecordVo, Users user) {
        TrainingLearnShift trainingLearnShift;
        TrainingLearnShiftVo trainingLearnShiftVo = new TrainingLearnShiftVo();
        TrainingLearnShiftRecord trainingLearnShiftRecord = (TrainingLearnShiftRecord)this.trainingLearnShiftRecordMapper.selectById(trainingLearnShiftRecordVo.getId());
        if (!ObjectUtils.isEmpty((Object)trainingLearnShiftRecord) && !ObjectUtils.isEmpty((Object)(trainingLearnShift = (TrainingLearnShift)this.shiftMapper.selectById(trainingLearnShiftRecord.getShiftId())))) {
            Map<String, Object> userMap;
            BeanUtils.copyProperties((Object)trainingLearnShift, (Object)trainingLearnShiftVo);
            TrainingLearnProject trainingLearnProject = (TrainingLearnProject)this.learnMapper.selectById(trainingLearnShift.getProjectId());
            trainingLearnShiftVo.setProjectName(trainingLearnProject.getProjectName());
            trainingLearnShiftVo.setShiftName(trainingLearnShiftVo.getShiftName() + (org.springframework.util.StringUtils.isEmpty((Object)trainingLearnShiftVo.getGroupName()) ? "" : "-" + trainingLearnShiftVo.getGroupName()) + (org.springframework.util.StringUtils.isEmpty((Object)trainingLearnShiftVo.getSupplemenName()) ? "" : "-" + trainingLearnShiftVo.getSupplemenName()));
            Integer classNum = 0;
            Integer finishNum = 0;
            Integer passNum = 0;
            LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)wrapper1.eq(TrainingLearnUser::getShiftId, (Object)trainingLearnShift.getId())).eq(TrainingLearnUser::getIsDelete, (Object)0);
            List trainingLearnUserList = this.learnUserMapper.selectList((Wrapper)wrapper1);
            if (!CollectionUtils.isEmpty((Collection)trainingLearnUserList)) {
                for (TrainingLearnUser trainingLearnUser : trainingLearnUserList) {
                    Integer n;
                    Integer n2;
                    if (trainingLearnUser.getLearnStatus() != null && trainingLearnUser.getLearnStatus() == 3) {
                        n2 = finishNum;
                        n = finishNum = Integer.valueOf(finishNum + 1);
                        if (trainingLearnUser.getPassStatus() != null && trainingLearnUser.getPassStatus() == 1) {
                            n2 = passNum;
                            n = passNum = Integer.valueOf(passNum + 1);
                        }
                    }
                    n2 = classNum;
                    n = classNum = Integer.valueOf(classNum + 1);
                }
            }
            trainingLearnShiftVo.setClassNum(classNum);
            trainingLearnShiftVo.setFinishCount(finishNum);
            trainingLearnShiftVo.setPassNum(passNum);
            ArrayList<TrainingLearnShiftRecordVo> trainingLearnShiftRecordVoList = new ArrayList<TrainingLearnShiftRecordVo>();
            LambdaQueryWrapper wrapper2 = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)wrapper2.eq(TrainingLearnShiftRecord::getShiftId, (Object)trainingLearnShift.getId())).orderByAsc(TrainingLearnShiftRecord::getCreateTime);
            List trainingLearnShiftRecordList = this.trainingLearnShiftRecordMapper.selectList((Wrapper)wrapper2);
            if (!CollectionUtils.isEmpty((Collection)trainingLearnShiftRecordList)) {
                ArrayList<Integer> userIdList = new ArrayList<Integer>();
                List userIds1 = trainingLearnShiftRecordList.stream().map(TrainingLearnShiftRecord::getCreater).filter(Objects::nonNull).distinct().collect(Collectors.toList());
                List userIds2 = trainingLearnShiftRecordList.stream().map(TrainingLearnShiftRecord::getReviewer).filter(Objects::nonNull).distinct().collect(Collectors.toList());
                userIdList.addAll(userIds1);
                userIdList.addAll(userIds2);
                Map<Integer, UsersPojo> usersPojoMap = this.userUtilService.selectUserMap(userIdList);
                List trainingLearnShiftRecordIdList = trainingLearnShiftRecordList.stream().map(TrainingLearnShiftRecord::getId).collect(Collectors.toList());
                LambdaQueryWrapper wrapper3 = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)wrapper3.in(TrainingProjectDocument::getProjectId, trainingLearnShiftRecordIdList)).eq(TrainingProjectDocument::getType, (Object)5);
                List trainingProjectDocumentList = this.documentMapper.selectList((Wrapper)wrapper3);
                Map<Object, Object> documentMap = new HashMap();
                if (!CollectionUtils.isEmpty((Collection)trainingProjectDocumentList)) {
                    documentMap = trainingProjectDocumentList.stream().collect(Collectors.groupingBy(TrainingProjectDocument::getProjectId));
                }
                TrainingLearnShiftRecordVo learnShiftRecordVo = null;
                for (TrainingLearnShiftRecord learnShiftRecord : trainingLearnShiftRecordList) {
                    UsersPojo usersPojo;
                    learnShiftRecordVo = new TrainingLearnShiftRecordVo();
                    BeanUtils.copyProperties((Object)learnShiftRecord, (Object)learnShiftRecordVo);
                    if (learnShiftRecord.getCreater() != null && !ObjectUtils.isEmpty((Object)(usersPojo = usersPojoMap.get(learnShiftRecord.getCreater())))) {
                        learnShiftRecordVo.setCreaterName(usersPojo.getShowName());
                    }
                    if (learnShiftRecord.getReviewer() != null && !ObjectUtils.isEmpty((Object)(usersPojo = usersPojoMap.get(learnShiftRecord.getReviewer())))) {
                        learnShiftRecordVo.setReviewerName(usersPojo.getShowName());
                    }
                    learnShiftRecordVo.setDocumentList((List)documentMap.get(learnShiftRecord.getId()));
                    trainingLearnShiftRecordVoList.add(learnShiftRecordVo);
                }
            }
            trainingLearnShiftVo.setTrainingLearnShiftRecordVoList(trainingLearnShiftRecordVoList);
            Integer reviewNum = 0;
            Boolean isHave = true;
            List<Integer> userIdList = new ArrayList<Integer>();
            if (!org.springframework.util.StringUtils.isEmpty((Object)trainingLearnShiftRecordVo.getCreaterName()) && CollectionUtils.isEmpty(userIdList = (List)(userMap = this.userUtilService.getCheckParameters(trainingLearnShiftRecordVo.getCreaterName(), null, null, user)).get("userList"))) {
                isHave = false;
            }
            List<Object> trainingLearnShiftRecordVos = new ArrayList();
            if (isHave.booleanValue()) {
                trainingLearnShiftRecordVos = this.trainingLearnShiftRecordMapper.selectLearnShiftRecordList(user.getId(), userIdList, trainingLearnShiftRecordVo.getShiftName(), trainingLearnShiftRecordVo.getStartTime(), trainingLearnShiftRecordVo.getEndTime());
            }
            trainingLearnShiftVo.setReviewNum(Integer.valueOf(trainingLearnShiftRecordVos.size() > 1 ? trainingLearnShiftRecordVos.size() - 1 : 0));
        }
        return trainingLearnShiftVo;
    }

    @Override
    public TrainingLearnShiftRecordVo saveShiftReviewRecord(TrainingLearnShiftRecordVo trainingLearnShiftRecordVo, Users user) {
        Map<String, Object> userMap;
        Date now = new Date();
        Integer trainingLearnShiftRecordId = trainingLearnShiftRecordVo.getId();
        trainingLearnShiftRecordVo.setReviewer(user.getId());
        trainingLearnShiftRecordVo.setReviewTime(now);
        List<Integer> userIdList = new ArrayList<Integer>();
        if (!org.springframework.util.StringUtils.isEmpty((Object)trainingLearnShiftRecordVo.getCreaterName()) && CollectionUtils.isEmpty(userIdList = (List)(userMap = this.userUtilService.getCheckParameters(trainingLearnShiftRecordVo.getCreaterName(), null, null, user)).get("userList"))) {
            return new TrainingLearnShiftRecordVo();
        }
        List<TrainingLearnShiftRecordVo> trainingLearnShiftRecordVoList = this.trainingLearnShiftRecordMapper.selectLearnShiftRecordList(user.getId(), userIdList, trainingLearnShiftRecordVo.getShiftName(), trainingLearnShiftRecordVo.getStartTime(), trainingLearnShiftRecordVo.getEndTime());
        this.trainingLearnShiftRecordMapper.updateById(trainingLearnShiftRecordVo);
        TrainingLearnShiftRecord trainingLearnShiftRecord = (TrainingLearnShiftRecord)this.trainingLearnShiftRecordMapper.selectById(trainingLearnShiftRecordVo.getId());
        TrainingLearnShift trainingLearnShift = new TrainingLearnShift();
        trainingLearnShift.setId(trainingLearnShiftRecord.getShiftId());
        String text = "";
        String key = "";
        Locale locale = Authenticator.getInstance().getCurrentClient().getLocale();
        if (trainingLearnShiftRecordVo.getStatus() == 2) {
            trainingLearnShift.setStatus(Integer.valueOf(3));
            text = this.messageSource.getMessage("training.learn.class.close.unpass", null, locale);
            key = "training.learn.class.close.unpass";
        } else {
            trainingLearnShift.setStatus(Integer.valueOf(4));
            text = this.messageSource.getMessage("training.learn.class.close.pass", null, locale);
            key = "training.learn.class.close.pass";
        }
        this.shiftMapper.updateById(trainingLearnShift);
        trainingLearnShift = (TrainingLearnShift)this.shiftMapper.selectById(trainingLearnShiftRecord.getShiftId());
        String leftName = trainingLearnShift.getShiftName() + "-" + trainingLearnShift.getGroupName() + (org.springframework.util.StringUtils.isEmpty((Object)trainingLearnShift.getSupplemenName()) ? "" : "-" + trainingLearnShift.getSupplemenName());
        HashMap<String, Object> pushMap = new HashMap<String, Object>();
        pushMap.put("id", trainingLearnShift.getId());
        pushMap.put("title", leftName);
        TaskMessageBody body = new TaskMessageBody();
        body.setType(148);
        body.setTaskJson(JSONObject.toJSONString((Object)trainingLearnShift));
        this.jPushService.sendWebSocket(leftName, text, trainingLearnShiftRecord.getCreater(), trainingLearnShiftRecord.getEnterpriseId(), trainingLearnShiftRecord.getShiftId(), "TYPE_SHIFT_REVIEW_NEWS", JSONObject.toJSONString(pushMap), null, 0, 0, key, null);
        this.jPushService.pushNotification(JPush.MASSAGE_TYPE_NOTIFY, "TYPE_SHIFT_REVIEW_NEWS", trainingLearnShiftRecord.getCreater(), leftName, text, body);
        trainingLearnShiftRecordVo = new TrainingLearnShiftRecordVo();
        if (!CollectionUtils.isEmpty(trainingLearnShiftRecordVoList)) {
            Integer nextId = trainingLearnShiftRecordVoList.get(0).getId();
            Boolean isExist = false;
            for (TrainingLearnShiftRecordVo vo : trainingLearnShiftRecordVoList) {
                if (isExist.booleanValue()) {
                    nextId = vo.getId();
                    break;
                }
                if (!vo.getId().equals(trainingLearnShiftRecordId)) continue;
                isExist = true;
            }
            if (!nextId.equals(trainingLearnShiftRecordId)) {
                trainingLearnShiftRecordVo.setId(nextId);
            }
        }
        return trainingLearnShiftRecordVo;
    }

    @Override
    public TrainingLearnShiftRecordVo selectShiftReviewRecordNumber(Users user) {
        TrainingLearnShiftRecordVo trainingLearnShiftRecordVo = new TrainingLearnShiftRecordVo();
        List<TrainingLearnShiftRecordVo> recordVoList1 = this.trainingLearnShiftRecordMapper.selectLearnShiftRecordListByStatus(user.getId(), 1);
        trainingLearnShiftRecordVo.setReviewingCount(Integer.valueOf(CollectionUtils.isEmpty(recordVoList1) ? 0 : recordVoList1.size()));
        List<TrainingLearnShiftRecordVo> recordVoList2 = this.trainingLearnShiftRecordMapper.selectLearnShiftRecordListByStatus(user.getId(), 2);
        trainingLearnShiftRecordVo.setReviewedCount(Integer.valueOf(CollectionUtils.isEmpty(recordVoList2) ? 0 : recordVoList2.size()));
        return trainingLearnShiftRecordVo;
    }

    @Override
    public String spliceRoleName(Map<Integer, List<RolePojo>> roleMap, Integer userId) {
        StringBuilder role = new StringBuilder();
        if (!CollectionUtils.isEmpty((Collection)roleMap.get(userId))) {
            for (RolePojo rolePojo : roleMap.get(userId)) {
                role.append(rolePojo.getRoleName()).append(";\n");
            }
        }
        return org.springframework.util.StringUtils.isEmpty((Object)role.toString()) ? null : role.substring(0, role.length() - 2);
    }

    @Override
    public Page<TrainingLearnTaskUserVo> selectUserTrainTaskByPage(Page<TrainingLearnTaskUserVo> page, Map<String, Object> project) {
        Map<String, Object> userMap;
        Users user = (Users)project.get("user");
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)wrapper.eq(TrainingTaskSchedule::getTaskId, project.get("taskId"))).isNotNull(TrainingTaskSchedule::getShiftId);
        List scheduleList = this.scheduleMapper.selectList((Wrapper)wrapper);
        List<Integer> scheduleIds = scheduleList.stream().map(TrainingTaskSchedule::getId).collect(Collectors.toList());
        TrainingTaskSchedule schedule = (TrainingTaskSchedule)scheduleList.get(0);
        List<Object> shiftIds = scheduleList.stream().map(TrainingTaskSchedule::getShiftId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        LambdaQueryWrapper managerWrapper0 = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)managerWrapper0.eq(TrainingLearnManager::getProjectId, (Object)schedule.getProjectId())).eq(TrainingLearnManager::getUserId, (Object)user.getId())).eq(TrainingLearnManager::getManagerType, (Object)1);
        List managerLists0 = this.managerMapper.selectList((Wrapper)managerWrapper0);
        if (!this.commonRemoteService.isSuper(user.getId()).booleanValue() && CollectionUtils.isEmpty((Collection)managerLists0)) {
            List shiftIdes;
            List<TrainingLearnManager> managerLists1 = this.getLearnManagerRole(schedule.getProjectId(), user);
            LambdaQueryWrapper managerWrapper2 = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)managerWrapper2.eq(TrainingLearnManager::getProjectId, (Object)schedule.getProjectId())).eq(TrainingLearnManager::getUserId, (Object)user.getId())).eq(TrainingLearnManager::getManagerType, (Object)3);
            List managerLists2 = this.managerMapper.selectList((Wrapper)managerWrapper2);
            LambdaQueryWrapper wrapperIn = new LambdaQueryWrapper();
            wrapperIn.eq(TrainingLearnShift::getProjectId, (Object)schedule.getProjectId());
            if (!CollectionUtils.isEmpty(managerLists1) && CollectionUtils.isEmpty((Collection)managerLists2)) {
                wrapperIn.eq(TrainingLearnShift::getCreatorId, (Object)user.getId());
            } else if (!CollectionUtils.isEmpty(managerLists1) && !CollectionUtils.isEmpty((Collection)managerLists2)) {
                shiftIdes = managerLists2.stream().map(TrainingLearnManager::getShiftId).collect(Collectors.toList());
                wrapperIn.and(wq -> {
                    LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wq.eq(TrainingLearnShift::getCreatorId, (Object)user.getId())).or()).in(TrainingLearnShift::getId, (Collection)shiftIdes);
                });
            } else if (CollectionUtils.isEmpty(managerLists1) && !CollectionUtils.isEmpty((Collection)managerLists2)) {
                shiftIdes = managerLists2.stream().map(TrainingLearnManager::getShiftId).collect(Collectors.toList());
                wrapperIn.in(TrainingLearnShift::getId, shiftIdes);
            }
            List shiftList = this.shiftMapper.selectList((Wrapper)wrapperIn);
            if (!CollectionUtils.isEmpty((Collection)shiftList)) {
                shiftIds = shiftList.stream().map(TrainingLearnShift::getId).collect(Collectors.toList());
            }
        }
        List userList = null;
        String bool = "0";
        if (project.get("creater") != null && !"".equals(project.get("creater")) && (userMap = this.userUtilService.getCheckParameters(project.get("creater").toString(), null, null, user)).get("isEffect").toString().equals("1") && CollectionUtils.isEmpty((Collection)(userList = (List)userMap.get("userList")))) {
            bool = "1";
        }
        if (project.get("shiftId") != null) {
            Integer shiftId = Integer.parseInt(project.get("shiftId").toString());
            if (!CollectionUtils.isEmpty(shiftIds)) {
                shiftIds.retainAll(Collections.singletonList(shiftId));
            } else {
                shiftIds = Collections.singletonList(shiftId);
            }
        }
        ArrayList<Integer> taskStatuss = new ArrayList<Integer>();
        if (project.get("taskStatus") != null) {
            Integer taskStatus = Integer.parseInt(project.get("taskStatus").toString());
            taskStatuss.add(taskStatus);
        }
        List<TrainingLearnTaskUserVo> taskUserList = null;
        if ("0".equals(bool) && !CollectionUtils.isEmpty(taskUserList = this.taskUserMapper.selectUserTasksByPage(page, scheduleIds, userList, shiftIds, taskStatuss))) {
            List<Integer> userIds = taskUserList.stream().map(TrainingLearnTaskUser::getUserId).distinct().collect(Collectors.toList());
            Map<Integer, UsersPojo> usersMap = this.userUtilService.selectUserMap(userIds);
            Map<Integer, List<String>> userOrganizeMap = this.userUtilService.selectOrganizeMap(userIds, user.getGroupId());
            List shiftIdList = taskUserList.stream().map(TrainingLearnTaskUser::getShiftId).distinct().collect(Collectors.toList());
            List shiftList = this.shiftMapper.selectBatchIds(shiftIdList);
            Map shiftMap = shiftList.stream().collect(Collectors.toMap(TrainingLearnShift::getId, Function.identity()));
            List<Integer> scheduleIdList = taskUserList.stream().map(TrainingLearnTaskUser::getProjectTaskScheduleId).distinct().collect(Collectors.toList());
            List trainingTaskScheduleList = this.scheduleMapper.selectBatchIds(scheduleIdList);
            Map scheduleMap = trainingTaskScheduleList.stream().collect(Collectors.toMap(TrainingTaskSchedule::getId, Function.identity()));
            List<TrainingUserViewTimeVo> userViewTimeVoList = this.trainingUserViewTimeLearnMapper.selectUserTaskViewTimes(user.getGroupId(), userIds, 2, scheduleIdList);
            Map<Object, Object> userViewMap = new HashMap();
            if (!CollectionUtils.isEmpty(userViewTimeVoList)) {
                userViewMap = userViewTimeVoList.stream().collect(Collectors.toMap(TrainingUserViewTime::getUserId, e -> new ArrayList<TrainingUserViewTimeVo>(Collections.singletonList(e)), (oldList, newList) -> {
                    oldList.addAll(newList);
                    return oldList;
                }));
            }
            HashMap<String, Object> parameter = new HashMap<String, Object>();
            parameter.put("userIds", StringUtils.join(userIds, (String)","));
            parameter.put("groupId", user.getGroupId());
            com.ovopark.privilege.response.BaseResult base = this.roleApi.getUserRoleList(parameter);
            Map roleMap = (Map)base.getData();
            Map<Integer, UserDutiesMo> dutiesMap = this.userUtilService.selectDutiesMap(userIds, user.getGroupId());
            Map<Integer, String> parentMap = this.userUtilService.selectParentMap(userIds, user.getGroupId());
            Map<Integer, Integer> parentIdMap = this.userUtilService.selectParentIdMap(userIds, user.getGroupId());
            for (TrainingLearnTaskUserVo learnTaskUserVo : taskUserList) {
                List<String> userStr;
                TrainingLearnShift shiftVo = (TrainingLearnShift)shiftMap.get(learnTaskUserVo.getShiftId());
                learnTaskUserVo.setShiftName(shiftVo.getShiftName());
                learnTaskUserVo.setGroupName(shiftVo.getGroupName());
                learnTaskUserVo.setSupplemenName(shiftVo.getSupplemenName());
                learnTaskUserVo.setShiftStatus(shiftVo.getStatus());
                UsersPojo pojo = usersMap.get(learnTaskUserVo.getUserId());
                learnTaskUserVo.setEmployeeNumber(pojo == null ? "" : pojo.getEmployeeNumber());
                learnTaskUserVo.setUserName(pojo == null ? "" : pojo.getShowName());
                learnTaskUserVo.setUserAccount(pojo == null ? "" : pojo.getUserName());
                learnTaskUserVo.setRole(this.spliceRoleName(roleMap, learnTaskUserVo.getUserId()));
                if (!CollectionUtils.isEmpty(dutiesMap) && dutiesMap.get(learnTaskUserVo.getUserId()) != null) {
                    learnTaskUserVo.setPost(dutiesMap.get(learnTaskUserVo.getUserId()).getDutieName());
                }
                if (!CollectionUtils.isEmpty(parentMap)) {
                    learnTaskUserVo.setParentName(parentMap.get(learnTaskUserVo.getUserId()));
                }
                if (!CollectionUtils.isEmpty(parentIdMap)) {
                    learnTaskUserVo.setParentUserId(parentIdMap.get(learnTaskUserVo.getUserId()));
                }
                if (!CollectionUtils.isEmpty(userStr = userOrganizeMap.get(learnTaskUserVo.getUserId()))) {
                    learnTaskUserVo.setOrganizeName(String.join((CharSequence)";\n", userStr));
                }
                TrainingTaskSchedule sc = (TrainingTaskSchedule)scheduleMap.get(learnTaskUserVo.getProjectTaskScheduleId());
                learnTaskUserVo.setTaskStartTime(sc.getStartTime());
                learnTaskUserVo.setTaskEndTime(sc.getEndTime());
                List userViewTimes = (List)userViewMap.get(learnTaskUserVo.getUserId());
                if (!CollectionUtils.isEmpty((Collection)userViewTimes)) {
                    int useTime = 0;
                    for (TrainingUserViewTimeVo vo : userViewTimes) {
                        if (learnTaskUserVo.getProjectTaskScheduleId() == null || !learnTaskUserVo.getProjectTaskScheduleId().equals(vo.getTaskId())) continue;
                        useTime = vo.getViewTimes();
                    }
                    learnTaskUserVo.setUseTimeFormal(DateUtils.getUseTimeFormal(useTime));
                }
                if (learnTaskUserVo.getTaskStatus() != 0 && learnTaskUserVo.getTaskStatus() != 1 && learnTaskUserVo.getTaskStatus() != 2) continue;
                learnTaskUserVo.setEndTime(null);
            }
        }
        page.setContent(taskUserList);
        return page;
    }

    @Override
    public String getOpenProjectList(Integer enterpriseId, Date startDate, Date endDate) {
        List list;
        ArrayList<OpenProject> result = new ArrayList<OpenProject>();
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(TrainingLearnProject::getEnterpriseId, (Object)enterpriseId);
        if (startDate != null) {
            wrapper.ge(TrainingLearnProject::getCreateTime, (Object)startDate);
        }
        if (endDate != null) {
            wrapper.le(TrainingLearnProject::getCreateTime, (Object)endDate);
        }
        if (!CollectionUtils.isEmpty((Collection)(list = this.learnMapper.selectList((Wrapper)wrapper)))) {
            for (TrainingLearnProject project : list) {
                OpenProject vo = new OpenProject();
                vo.setProjectId(project.getId());
                vo.setProjectName(project.getProjectName());
                vo.setPrefix(project.getPrefix());
                if (project.getProjectType() != null) {
                    TrainingMaterialType materialType = (TrainingMaterialType)this.materialTypeMapper.selectById(project.getProjectType());
                    vo.setProjectTypeName(materialType.getMaterialTypeName());
                }
                vo.setDescription(project.getDescription());
                LambdaQueryWrapper leaderWrapper = new LambdaQueryWrapper();
                leaderWrapper.eq(TrainingLearnManager::getProjectId, (Object)project.getId());
                leaderWrapper.eq(TrainingLearnManager::getManagerType, (Object)1);
                List leaderList = this.managerMapper.selectList((Wrapper)leaderWrapper);
                if (!CollectionUtils.isEmpty((Collection)leaderList)) {
                    vo.setLeaderList(leaderList.stream().map(TrainingLearnManager::getUserId).collect(Collectors.toList()));
                }
                LambdaQueryWrapper taskWrapper = new LambdaQueryWrapper();
                taskWrapper.eq(TrainingTaskSchedule::getProjectId, (Object)project.getId());
                taskWrapper.isNull(TrainingTaskSchedule::getShiftId);
                List selectList = this.trainingTaskScheduleMapper.selectList((Wrapper)taskWrapper);
                if (!CollectionUtils.isEmpty((Collection)selectList)) {
                    vo.setTaskNum(selectList.size());
                }
                LambdaQueryWrapper managerWrapper = new LambdaQueryWrapper();
                managerWrapper.eq(TrainingLearnManager::getProjectId, (Object)project.getId());
                managerWrapper.eq(TrainingLearnManager::getManagerType, (Object)2);
                List managerList = this.managerMapper.selectList((Wrapper)managerWrapper);
                if (!CollectionUtils.isEmpty((Collection)managerList)) {
                    vo.setManagerList(managerList.stream().map(TrainingLearnManager::getUserId).collect(Collectors.toList()));
                }
                ArrayList<OpenProjectShift> shiftVoList = new ArrayList<OpenProjectShift>();
                LambdaQueryWrapper shiftWrapper = new LambdaQueryWrapper();
                shiftWrapper.eq(TrainingLearnShift::getProjectId, (Object)project.getId());
                shiftWrapper.ne(TrainingLearnShift::getStatus, (Object)0);
                List shiftList = this.shiftMapper.selectList((Wrapper)shiftWrapper);
                if (!CollectionUtils.isEmpty((Collection)shiftList)) {
                    for (TrainingLearnShift shift : shiftList) {
                        OpenProjectShift shiftVo = new OpenProjectShift();
                        shiftVo.setShiftId(shift.getId());
                        shiftVo.setShiftName(shift.getShiftName());
                        shiftVo.setStatus(shift.getStatus());
                        shiftVo.setCreator(shift.getCreatorId());
                        shiftVo.setCreateTime(shift.getCreateTime());
                        shiftVoList.add(shiftVo);
                    }
                    vo.setShiftList(shiftVoList);
                    List shiftIds = shiftList.stream().map(TrainingLearnShift::getId).collect(Collectors.toList());
                    LambdaQueryWrapper userWrapper = new LambdaQueryWrapper();
                    userWrapper.in(TrainingLearnUser::getShiftId, shiftIds);
                    List userList = this.learnUserMapper.selectList((Wrapper)userWrapper);
                    Set userSet = userList.stream().map(TrainingLearnUser::getUserId).collect(Collectors.toSet());
                    vo.setNeedUserList(new ArrayList(userSet));
                }
                vo.setStatus(project.getStatus());
                vo.setCreator(project.getCreater());
                vo.setCreateTime(project.getCreateTime());
                result.add(vo);
            }
        }
        return JsonResult.success(result);
    }

    @Override
    public String getOpenUserLeanList(Integer enterpriseId, Date startDate, Date endDate) {
        List list;
        ArrayList<OpenUserLean> result = new ArrayList<OpenUserLean>();
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(TrainingLearnUser::getEnterpriseId, (Object)enterpriseId);
        if (startDate != null) {
            wrapper.ge(TrainingLearnUser::getCreateTime, (Object)startDate);
        }
        if (endDate != null) {
            wrapper.le(TrainingLearnUser::getCreateTime, (Object)endDate);
        }
        if (!CollectionUtils.isEmpty((Collection)(list = this.learnUserMapper.selectList((Wrapper)wrapper)))) {
            for (TrainingLearnUser user : list) {
                OpenUserLean vo = new OpenUserLean();
                vo.setLearnUserId(user.getId());
                vo.setUserId(user.getUserId());
                TrainingLearnShift shift = (TrainingLearnShift)this.shiftMapper.selectById(user.getShiftId());
                if (shift != null) {
                    vo.setProjectId(shift.getProjectId());
                }
                vo.setShiftId(user.getShiftId());
                LambdaQueryWrapper userWrapper = new LambdaQueryWrapper();
                userWrapper.eq(TrainingLearnTaskUser::getUserId, (Object)user.getUserId());
                userWrapper.eq(TrainingLearnTaskUser::getShiftId, (Object)user.getShiftId());
                List userList = this.taskUserMapper.selectList((Wrapper)userWrapper);
                if (!CollectionUtils.isEmpty((Collection)userList)) {
                    vo.setTaskNum(userList.size());
                }
                vo.setStartTime(user.getStartTime());
                vo.setEndTime(user.getEndTime());
                vo.setPassStatus(user.getPassStatus());
                vo.setCertificateId(user.getCertificateId());
                result.add(vo);
            }
        }
        return JsonResult.success(result);
    }
}

