/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.training.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.google.common.collect.Maps;
import com.ovopark.api.RedisBaseApi;
import com.ovopark.cloud.log.model.LogPojo;
import com.ovopark.cloud.log.sdk.LogApi;
import com.ovopark.organize.common.model.pojo.UsersPojo;
import com.ovopark.training.bo.JsonResult;
import com.ovopark.training.bo.Page;
import com.ovopark.training.mapper.TrainingExaminerMapper;
import com.ovopark.training.mapper.TrainingLearnManagerMapper;
import com.ovopark.training.mapper.TrainingLearnProjectMapper;
import com.ovopark.training.mapper.TrainingLearnShiftMapper;
import com.ovopark.training.mapper.TrainingLearnUserMapper;
import com.ovopark.training.mapper.TrainingMapper;
import com.ovopark.training.mapper.TrainingPaperMapper;
import com.ovopark.training.mapper.TrainingProjectDocumentMapper;
import com.ovopark.training.mapper.TrainingTaskScheduleMapper;
import com.ovopark.training.model.Authenticator;
import com.ovopark.training.model.JPush;
import com.ovopark.training.model.TaskMessageBody;
import com.ovopark.training.model.Training;
import com.ovopark.training.model.TrainingExaminer;
import com.ovopark.training.model.TrainingLearnManager;
import com.ovopark.training.model.TrainingLearnProject;
import com.ovopark.training.model.TrainingLearnShift;
import com.ovopark.training.model.TrainingLearnUser;
import com.ovopark.training.model.TrainingPaper;
import com.ovopark.training.model.TrainingProjectDocument;
import com.ovopark.training.model.TrainingTaskSchedule;
import com.ovopark.training.model.TrainingWork;
import com.ovopark.training.model.Users;
import com.ovopark.training.service.DynamicTaskService;
import com.ovopark.training.service.JPushService;
import com.ovopark.training.service.TrainingLearnProjectService;
import com.ovopark.training.service.TrainingLearnShiftService;
import com.ovopark.training.service.TrainingWorkService;
import com.ovopark.training.service.UserUtilService;
import com.ovopark.training.util.DateUtils;
import com.ovopark.training.vo.TrainingLearnProjectVo;
import com.ovopark.training.vo.TrainingLearnShiftVo;
import com.ovopark.training.vo.TrainingLearnUserVo;
import com.ovopark.training.vo.TrainingProjectTaskVo;
import com.ovopark.training.vo.TrainingTaskScheduleVo;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
public class TrainingLearnShiftServiceImpl
implements TrainingLearnShiftService {
    private static final Logger log = LoggerFactory.getLogger(TrainingLearnShiftServiceImpl.class);
    @Autowired
    private TrainingLearnShiftMapper trainingLearnShiftMapper;
    @Autowired
    private TrainingTaskScheduleMapper trainingTaskScheduleMapper;
    @Autowired
    private TrainingLearnUserMapper trainingLearnUserMapper;
    @Autowired
    private TrainingLearnProjectService trainingLearnProjectService;
    @Autowired
    private TrainingMapper trainingMapper;
    @Autowired
    private TrainingExaminerMapper trainingExaminerMapper;
    @Autowired
    private TrainingPaperMapper trainingPaperMapper;
    @Autowired
    private TrainingLearnManagerMapper trainingLearnManagerMapper;
    @Autowired
    private TrainingLearnProjectService learnProjectService;
    @Autowired
    private TrainingProjectDocumentMapper documentMapper;
    @Autowired
    private UserUtilService userUtilService;
    @Autowired
    private TrainingWorkService trainingWorkService;
    @Autowired
    private JPushService jPushService;
    @Autowired
    private DynamicTaskService dynamicTaskService;
    @Autowired
    private RedisBaseApi redisBaseApi;
    @Autowired
    private TrainingLearnProjectMapper trainingLearnProjectMapper;
    @Autowired
    private LogApi logApi;
    @Autowired
    private MessageSource messageSource;

    @Override
    public Integer saveTrainingLearnShift(TrainingLearnShiftVo trainingLearnShift, Integer userId) {
        Date now = new Date();
        trainingLearnShift.setCreateTime(now);
        if (trainingLearnShift.getId() == null) {
            String[] managerStr;
            List<String> manageres;
            this.trainingLearnShiftMapper.insert(trainingLearnShift);
            List<Object> managers = new ArrayList();
            if (!StringUtils.isEmpty((Object)trainingLearnShift.getShiftManager()) && !CollectionUtils.isEmpty(manageres = Arrays.asList(managerStr = trainingLearnShift.getShiftManager().split(",")))) {
                managers = manageres.stream().map(Integer::parseInt).collect(Collectors.toList());
                ArrayList<TrainingLearnManager> learnManagerList = new ArrayList<TrainingLearnManager>();
                for (Integer n : managers) {
                    TrainingLearnManager trainingLearnManager = new TrainingLearnManager();
                    trainingLearnManager.setProjectId(trainingLearnShift.getProjectId());
                    trainingLearnManager.setUserId(n);
                    trainingLearnManager.setShiftId(trainingLearnShift.getId());
                    trainingLearnManager.setCreateTime(now);
                    trainingLearnManager.setManagerType(Integer.valueOf(3));
                    trainingLearnManager.setCreater(userId);
                    learnManagerList.add(trainingLearnManager);
                }
                this.trainingLearnManagerMapper.insertList(learnManagerList);
            }
            try {
                ArrayList<TrainingExaminer> examList = new ArrayList<TrainingExaminer>();
                ArrayList<TrainingProjectDocument> projectDocuments = new ArrayList<TrainingProjectDocument>();
                LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)wrapper.eq(TrainingTaskSchedule::getProjectId, (Object)trainingLearnShift.getProjectId())).isNull(TrainingTaskSchedule::getShiftId);
                List scheduleList = this.trainingTaskScheduleMapper.selectList((Wrapper)wrapper);
                if (!CollectionUtils.isEmpty((Collection)scheduleList)) {
                    for (TrainingTaskSchedule schedule : scheduleList) {
                        schedule.setShiftId(trainingLearnShift.getId());
                        schedule.setCreater(trainingLearnShift.getCreatorId());
                        schedule.setCreateTime(new Date());
                        if (schedule.getTrainingId() != null) {
                            Training training = (Training)this.trainingMapper.selectById(schedule.getTrainingId());
                            if (training != null) {
                                Integer trainingOld = training.getId();
                                training.setId(null);
                                training.setTitle(training.getTitle());
                                if (!StringUtils.isEmpty((Object)training.getProjectShow()) && training.getProjectShow() >= 5) {
                                    training.setProjectShow(Integer.valueOf(6));
                                } else {
                                    training.setProjectShow(Integer.valueOf(1));
                                }
                                training.setCreator(trainingLearnShift.getCreatorId());
                                training.setUpdateTime(new Date());
                                this.trainingMapper.insert(training);
                                schedule.setTrainingId(training.getId());
                                schedule.setTrainingIdOld(trainingOld);
                                this.learnProjectService.saveNewTrainingByOld(training.getId(), trainingOld);
                            }
                        } else if (schedule.getPaperId() != null) {
                            TrainingPaper paper = (TrainingPaper)this.trainingPaperMapper.selectById(schedule.getPaperId());
                            if (paper != null) {
                                schedule.setPaperIdOld(schedule.getPaperId());
                                paper.setId(null);
                                paper.setPaperState(Integer.valueOf(1));
                                paper.setProjectShow(Integer.valueOf(1));
                                paper.setCreater(trainingLearnShift.getCreatorId());
                                paper.setCreateTime(new Date());
                                this.trainingPaperMapper.insert(paper);
                                if (!CollectionUtils.isEmpty(managers)) {
                                    for (Integer n : managers) {
                                        TrainingExaminer exam = new TrainingExaminer();
                                        exam.setTrainingPaperId(paper.getId());
                                        exam.setUserId(n);
                                        exam.setEnterpriseId(paper.getEnterpriseId());
                                        examList.add(exam);
                                    }
                                }
                                schedule.setPaperId(paper.getId());
                                schedule.setStartTime(paper.getStartTime());
                                schedule.setEndTime(paper.getEndTime());
                            }
                        } else if (!StringUtils.isEmpty((Object)schedule.getWorkId())) {
                            schedule.setWorkIdOld(schedule.getWorkId());
                            TrainingWork work = this.trainingWorkService.insertSameWork(schedule.getWorkId(), 3);
                            schedule.setWorkId(work.getId());
                            schedule.setStartTime(work.getStartTime());
                            schedule.setEndTime(work.getEndTime());
                        }
                        LambdaQueryWrapper documentWrapper = new LambdaQueryWrapper();
                        ((LambdaQueryWrapper)documentWrapper.eq(TrainingProjectDocument::getProjectId, (Object)schedule.getId())).eq(TrainingProjectDocument::getType, (Object)1);
                        List documentList = this.documentMapper.selectList((Wrapper)documentWrapper);
                        this.trainingTaskScheduleMapper.insert(schedule);
                        if (CollectionUtils.isEmpty((Collection)documentList)) continue;
                        for (TrainingProjectDocument document : documentList) {
                            document.setId(null);
                            document.setProjectId(schedule.getId());
                            document.setCreater(userId);
                            document.setCreateTime(new Date());
                            projectDocuments.add(document);
                        }
                    }
                    if (!CollectionUtils.isEmpty(examList)) {
                        this.trainingExaminerMapper.insertList(examList);
                    }
                    if (!CollectionUtils.isEmpty(projectDocuments)) {
                        this.documentMapper.insertList(projectDocuments);
                    }
                }
            }
            catch (Exception e) {
                log.error("\u65b0\u589e\u73ed\u6b21\u540e\uff0c\u9700\u8981\u751f\u6210\u76f8\u5e94\u7684\u73ed\u6b21\u4efb\u52a1", (Throwable)e);
            }
        }
        return trainingLearnShift.getId();
    }

    @Override
    public String deleteShift(Integer shiftId, Users user, LogPojo pojo) {
        LambdaQueryWrapper wrapper0 = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)wrapper0.eq(TrainingLearnShift::getId, (Object)shiftId)).eq(TrainingLearnShift::getEnterpriseId, (Object)user.getGroupId());
        List trainingLearnShiftList = this.trainingLearnShiftMapper.selectList((Wrapper)wrapper0);
        if (!CollectionUtils.isEmpty((Collection)trainingLearnShiftList)) {
            TrainingLearnShift shift = (TrainingLearnShift)trainingLearnShiftList.get(0);
            if (!pojo.getEnterpriseId().equals(shift.getEnterpriseId())) {
                return JsonResult.error((String)"NO_PERMISSION", (Object)"\u65e0\u6743\u9650\u5220\u9664");
            }
            TrainingLearnProject projcet = (TrainingLearnProject)this.trainingLearnProjectMapper.selectById(shift.getProjectId());
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.eq(TrainingLearnUser::getShiftId, (Object)shiftId);
            List list = this.trainingLearnUserMapper.selectList((Wrapper)queryWrapper);
            List userIdList = list.stream().map(TrainingLearnUser::getUserId).distinct().collect(Collectors.toList());
            this.trainingLearnShiftMapper.deleteById(shiftId);
            LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
            wrapper.eq(TrainingTaskSchedule::getShiftId, (Object)shiftId);
            int flag = this.trainingTaskScheduleMapper.delete((Wrapper)wrapper);
            if (flag > 0) {
                Iterator iterator = userIdList.iterator();
                while (iterator.hasNext()) {
                    int userId = (Integer)iterator.next();
                    this.jPushService.deleteMessages(shiftId, "TYPE_TRAINING_SHIFT_TYPE", userId, null, 1);
                }
            }
            if (!StringUtils.isEmpty((Object)shift.getSupplemenName())) {
                pojo.setI18nParam("\u300a" + projcet.getProjectName() + "\u300b,\u300a" + shift.getShiftName() + "-" + shift.getGroupName() + "-" + shift.getSupplemenName() + "\u300b");
            } else {
                pojo.setI18nParam("\u300a" + projcet.getProjectName() + "\u300b,\u300a" + shift.getShiftName() + "-" + shift.getGroupName() + "\u300b");
            }
            this.logApi.save(pojo);
        }
        return JsonResult.success();
    }

    @Override
    public Integer updateShift(TrainingLearnShiftVo trainingLearnShift, Integer userId) {
        Integer learnShiftId = 0;
        Date now = new Date();
        if (trainingLearnShift.getId() != null) {
            String[] managerStr;
            List<String> manageres;
            this.trainingLearnShiftMapper.updateById(trainingLearnShift);
            learnShiftId = trainingLearnShift.getId();
            List<Integer> trainingLearnManagers = this.trainingLearnManagerMapper.selectByshiftId(learnShiftId);
            this.trainingLearnManagerMapper.deleteBatchIds(trainingLearnManagers);
            if (!StringUtils.isEmpty((Object)trainingLearnShift.getShiftManager()) && !CollectionUtils.isEmpty(manageres = Arrays.asList(managerStr = trainingLearnShift.getShiftManager().split(",")))) {
                List managers = manageres.stream().map(Integer::parseInt).collect(Collectors.toList());
                ArrayList<TrainingLearnManager> learnManagerList = new ArrayList<TrainingLearnManager>();
                for (Integer manager : managers) {
                    TrainingLearnManager trainingLearnManager = new TrainingLearnManager();
                    trainingLearnManager.setProjectId(trainingLearnShift.getProjectId());
                    trainingLearnManager.setUserId(manager);
                    trainingLearnManager.setShiftId(trainingLearnShift.getId());
                    trainingLearnManager.setCreateTime(now);
                    trainingLearnManager.setManagerType(Integer.valueOf(3));
                    trainingLearnManager.setCreater(userId);
                    learnManagerList.add(trainingLearnManager);
                }
                this.trainingLearnManagerMapper.insertList(learnManagerList);
                LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)wrapper.eq(TrainingTaskSchedule::getShiftId, (Object)learnShiftId)).eq(TrainingTaskSchedule::getTaskType, (Object)2);
                List scheduleList = this.trainingTaskScheduleMapper.selectList((Wrapper)wrapper);
                if (!CollectionUtils.isEmpty((Collection)scheduleList)) {
                    List paperIds;
                    ArrayList<TrainingExaminer> examList = new ArrayList<TrainingExaminer>();
                    if (!CollectionUtils.isEmpty(managers) && !CollectionUtils.isEmpty(paperIds = scheduleList.stream().map(TrainingTaskSchedule::getPaperId).filter(Objects::nonNull).distinct().collect(Collectors.toList()))) {
                        LambdaUpdateWrapper wrapper1 = new LambdaUpdateWrapper();
                        wrapper1.in(TrainingExaminer::getTrainingPaperId, paperIds);
                        this.trainingExaminerMapper.delete((Wrapper)wrapper1);
                        TrainingLearnShift learnShift = (TrainingLearnShift)this.trainingLearnShiftMapper.selectById(learnShiftId);
                        for (Integer paperId : paperIds) {
                            for (Integer manager : managers) {
                                TrainingExaminer exam = new TrainingExaminer();
                                exam.setTrainingPaperId(paperId);
                                exam.setUserId(manager);
                                exam.setEnterpriseId(learnShift.getEnterpriseId());
                                examList.add(exam);
                            }
                        }
                    }
                    if (!CollectionUtils.isEmpty(examList)) {
                        this.trainingExaminerMapper.insertList(examList);
                    }
                }
            }
        }
        return learnShiftId;
    }

    @Override
    public Page<TrainingLearnShiftVo> selectLearnShiftByPage(Page<TrainingLearnShiftVo> page, Users user, String shiftName, Integer status, List<Integer> creatorId, String startTime, String endTime, String createTime, Integer enterpriseId, Integer projectId, Integer isSuperAdmin) {
        List<Object> trainingLearnShiftVos = new ArrayList();
        Integer root = 1;
        if (isSuperAdmin == 1) {
            root = 0;
            trainingLearnShiftVos = this.trainingLearnShiftMapper.selectLearnShiftByPage(page, enterpriseId, shiftName, status, creatorId, startTime, endTime, createTime, projectId);
        } else {
            trainingLearnShiftVos = this.trainingLearnShiftMapper.selectLearnShifHelpManagerByPage(page, enterpriseId, shiftName, status, creatorId, startTime, endTime, createTime, projectId, user.getId(), isSuperAdmin, 1);
            if (trainingLearnShiftVos == null || trainingLearnShiftVos.size() <= 0) {
                root = 2;
                trainingLearnShiftVos = this.trainingLearnShiftMapper.selectLearnShifManagerByPage(page, enterpriseId, shiftName, status, creatorId, startTime, endTime, createTime, projectId, user.getId(), isSuperAdmin, 2);
            }
        }
        if (!CollectionUtils.isEmpty(trainingLearnShiftVos)) {
            Map<Integer, UsersPojo> userMap = this.userUtilService.selectUserMap(trainingLearnShiftVos.stream().map(TrainingLearnShift::getCreatorId).collect(Collectors.toList()));
            for (TrainingLearnShiftVo trainingLearnShiftVo : trainingLearnShiftVos) {
                UsersPojo usersPojo = userMap.get(trainingLearnShiftVo.getCreatorId());
                trainingLearnShiftVo.setCreatorName(usersPojo.getShowName());
                if (trainingLearnShiftVo.getShiftManager() != null && !trainingLearnShiftVo.getShiftManager().equals("")) {
                    List<Integer> shiftManager = Arrays.asList(trainingLearnShiftVo.getShiftManager().split(",")).stream().map(Integer::parseInt).collect(Collectors.toList());
                    ArrayList<Users> users = new ArrayList<Users>();
                    Map<Integer, UsersPojo> pojoMap = this.userUtilService.selectUserMap(shiftManager);
                    if (!ObjectUtils.isEmpty(pojoMap)) {
                        for (UsersPojo pojo : pojoMap.values()) {
                            Users user1 = new Users();
                            BeanUtils.copyProperties((Object)pojo, (Object)user1);
                            users.add(user1);
                        }
                    }
                    trainingLearnShiftVo.setShiftManagers(users);
                }
                List<TrainingLearnUserVo> learnUserVoList = this.trainingLearnUserMapper.selectUserByShiftId(trainingLearnShiftVo.getId());
                Integer classNum = 0;
                Integer passNum = 0;
                for (TrainingLearnUserVo trainingLearnUserVo : learnUserVoList) {
                    Integer n;
                    Integer n2;
                    if (trainingLearnUserVo.getPassStatus() != null && trainingLearnUserVo.getPassStatus() == 1) {
                        n2 = passNum;
                        n = passNum = Integer.valueOf(passNum + 1);
                    }
                    n2 = classNum;
                    n = classNum = Integer.valueOf(classNum + 1);
                }
                trainingLearnShiftVo.setClassNum(classNum);
                trainingLearnShiftVo.setPassNum(passNum);
            }
        }
        page.setContent(trainingLearnShiftVos);
        return page;
    }

    @Override
    public Integer releaseTrainingLearnShift(String startTime, String endTime, Integer shiftId, Integer status, Integer isOnlineNow, Integer isNotimeLimit, Integer projectId, Integer isSendMessage) {
        Integer learnShiftId = 0;
        if (shiftId != null) {
            Object endTimedL;
            TrainingLearnShift trainingLearnShift = (TrainingLearnShift)this.trainingLearnShiftMapper.selectById(shiftId);
            TrainingTaskSchedule trainingTaskSchedule = this.trainingTaskScheduleMapper.selectTaskScheduleByShiftId(shiftId);
            TrainingProjectTaskVo project = new TrainingProjectTaskVo();
            ArrayList<TrainingTaskScheduleVo> scheduleList = new ArrayList<TrainingTaskScheduleVo>();
            TrainingTaskScheduleVo taskScheduleVo = new TrainingTaskScheduleVo();
            Integer isClash = 0;
            taskScheduleVo.setShiftId(shiftId);
            scheduleList.add(taskScheduleVo);
            project.setProjectId(trainingLearnShift.getProjectId());
            project.setScheduleList(scheduleList);
            TrainingLearnProjectVo trainingLearnProjectVo = this.trainingLearnProjectService.selectShiftTask(project);
            if (trainingLearnProjectVo != null) {
                isClash = trainingLearnProjectVo.getIsClash();
            }
            if (trainingTaskSchedule != null) {
                Date taskEndTime = trainingTaskSchedule.getEndTime();
                if (trainingLearnShift != null) {
                    if (startTime != null && !"".equals(startTime)) {
                        Date startTimed = DateUtils.parse(startTime);
                        trainingLearnShift.setStartTime(startTimed);
                    }
                    Date endTimed = null;
                    if (endTime != null && !"".equals(endTime)) {
                        endTimed = DateUtils.parse(endTime);
                        trainingLearnShift.setEndTime(endTimed);
                    }
                    trainingLearnShift.setStatus(status);
                    trainingLearnShift.setIsOnlineNow(isOnlineNow);
                    trainingLearnShift.setIsNotimeLimit(isNotimeLimit);
                    trainingLearnShift.setIsSendMessage(isSendMessage);
                    List<TrainingLearnUserVo> trainingLearnUser = this.trainingLearnUserMapper.selectUserByShiftId(shiftId);
                    if (isClash == 0) {
                        if (trainingLearnUser != null && trainingLearnUser.size() > 0) {
                            if (isOnlineNow == 1) {
                                if (trainingLearnUser != null && trainingLearnUser.size() > 0) {
                                    for (TrainingLearnUserVo trainingLearnUserVo : trainingLearnUser) {
                                        if (trainingLearnUserVo.getLearnStatus() != 0) continue;
                                        trainingLearnUserVo.setLearnStatus(Integer.valueOf(1));
                                        this.trainingLearnUserMapper.updateById(trainingLearnUserVo);
                                    }
                                }
                                if (trainingLearnShift.getStartTime() == null) {
                                    trainingLearnShift.setStartTime(new Date());
                                }
                            }
                            List<TrainingTaskSchedule> trainingTaskSchedules = this.trainingTaskScheduleMapper.selectTaskScheduleByShiftIds(shiftId);
                            for (TrainingTaskSchedule taskSchedule : trainingTaskSchedules) {
                                if (taskSchedule.getPaperId() == null) continue;
                                TrainingPaper trainingPaper = (TrainingPaper)this.trainingPaperMapper.selectById(taskSchedule.getPaperId());
                                trainingPaper.setPaperState(Integer.valueOf(1));
                                this.trainingPaperMapper.updateById(trainingPaper);
                            }
                            if (isNotimeLimit == 1) {
                                learnShiftId = trainingLearnShift.getId();
                                if (trainingLearnShift.getEndTime() != null) {
                                    trainingLearnShift.setEndTime(null);
                                }
                                this.trainingLearnShiftMapper.updateById(trainingLearnShift);
                            } else {
                                if (taskEndTime != null && endTimed != null) {
                                    Long taskEndTimeL = taskEndTime.getTime();
                                    endTimedL = endTimed.getTime();
                                    if (taskEndTimeL <= (Long)endTimedL) {
                                        learnShiftId = trainingLearnShift.getId();
                                        this.trainingLearnShiftMapper.updateById(trainingLearnShift);
                                    } else {
                                        learnShiftId = -1;
                                    }
                                }
                                learnShiftId = trainingLearnShift.getId();
                                this.trainingLearnShiftMapper.updateById(trainingLearnShift);
                            }
                        } else {
                            learnShiftId = -3;
                        }
                    } else {
                        learnShiftId = -4;
                    }
                }
            } else {
                learnShiftId = -2;
            }
            int shiftStatus = trainingLearnShift.getStatus();
            if (status == 0) {
                this.redisBaseApi.set(String.valueOf(shiftId), "1");
                this.dynamicTaskService.stop(shiftId);
            } else if (isOnlineNow == 1) {
                LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
                queryWrapper.eq(TrainingLearnUser::getShiftId, (Object)shiftId);
                List learnUserList = this.trainingLearnUserMapper.selectList((Wrapper)queryWrapper);
                List<Integer> userIdList = learnUserList.stream().map(TrainingLearnUser::getUserId).distinct().collect(Collectors.toList());
                Locale locale = Authenticator.getInstance().getCurrentClient().getLocale();
                endTimedL = userIdList.iterator();
                while (endTimedL.hasNext()) {
                    int userId = (Integer)endTimedL.next();
                    this.jPushService.deleteMessages(trainingLearnShift.getId(), "TYPE_TRAINING_SHIFT_TYPE", userId, null, 1);
                }
                String dutTime = trainingLearnShift.getIsNotimeLimit() == 1 ? MessageFormat.format(this.messageSource.getMessage("training.learn.schedule.content.one", null, locale), DateUtils.format(trainingLearnShift.getStartTime(), "yyyy-MM-dd HH:mm")) : MessageFormat.format(this.messageSource.getMessage("training.learn.schedule.content.two", null, locale), DateUtils.format(trainingLearnShift.getStartTime(), "yyyy-MM-dd HH:mm"), DateUtils.format(trainingLearnShift.getEndTime(), "yyyy-MM-dd HH:mm"));
                String shiftName = StringUtils.isEmpty((Object)trainingLearnShift.getSupplemenName()) ? MessageFormat.format("{0}-{1}", trainingLearnShift.getShiftName(), trainingLearnShift.getGroupName()) : MessageFormat.format("{0}-{1}-{2}", trainingLearnShift.getShiftName(), trainingLearnShift.getGroupName(), trainingLearnShift.getSupplemenName());
                TaskMessageBody body = new TaskMessageBody();
                body.setType(115);
                HashMap msg = Maps.newHashMap();
                msg.put("projectId", trainingLearnShift.getProjectId());
                msg.put("shiftId", trainingLearnShift.getId());
                msg.put("title", this.messageSource.getMessage("training.learn.shift.name", null, locale));
                body.setTaskJson(JSONObject.toJSONString((Object)msg));
                this.jPushService.sendWebSocketAll(this.messageSource.getMessage("training.learn.shift.name", null, locale), this.messageSource.getMessage("training.learn.schedule.inline", new Object[]{shiftName}, locale), userIdList, trainingLearnShift.getEnterpriseId(), trainingLearnShift.getId(), "TYPE_TRAINING_SHIFT_TYPE", JSONObject.toJSONString((Object)msg), Objects.isNull(trainingLearnShift.getEndTime()) ? null : trainingLearnShift.getEndTime(), 1, 1, "training.learn.schedule.inline", shiftName);
                if (isSendMessage == 1) {
                    this.jPushService.pushNotificationAll(JPush.MASSAGE_TYPE_NOTIFY, "TYPE_TRAINING_SHIFT_TYPE", userIdList, shiftName, dutTime, body);
                }
            } else if (shiftStatus == 1) {
                this.dynamicTaskService.stop(trainingLearnShift.getId());
                this.dynamicTaskService.addTask(Collections.singletonList(trainingLearnShift));
            }
        }
        return learnShiftId;
    }

    @Override
    public TrainingLearnShiftVo selectReleaseLearnShift(Integer shiftId, Integer enterpriseId) {
        TrainingLearnShiftVo trainingLearnShift = null;
        if (enterpriseId != null && shiftId != null) {
            UsersPojo usersPojo;
            trainingLearnShift = this.trainingLearnShiftMapper.selectShiftById(shiftId, enterpriseId);
            if (ObjectUtils.isEmpty((Object)trainingLearnShift)) {
                return trainingLearnShift;
            }
            String name = "";
            if (trainingLearnShift.getCreatorId() != null && !ObjectUtils.isEmpty((Object)(usersPojo = this.userUtilService.selectUser(trainingLearnShift.getCreatorId())))) {
                name = usersPojo.getShowName();
            }
            trainingLearnShift.setCreatorName(name);
            if (!StringUtils.isEmpty((Object)trainingLearnShift.getShiftManager())) {
                List<Integer> shiftManager = Arrays.asList(trainingLearnShift.getShiftManager().split(",")).stream().map(Integer::parseInt).collect(Collectors.toList());
                ArrayList<Users> users = new ArrayList<Users>();
                Map<Integer, UsersPojo> pojoMap = this.userUtilService.selectUserMap(shiftManager);
                if (!ObjectUtils.isEmpty(pojoMap)) {
                    for (UsersPojo pojo : pojoMap.values()) {
                        Users user1 = new Users();
                        BeanUtils.copyProperties((Object)pojo, (Object)user1);
                        users.add(user1);
                    }
                }
                trainingLearnShift.setShiftManagers(users);
            }
        }
        return trainingLearnShift;
    }

    @Override
    public Integer selectIsUserShift(Integer projectId, Integer type, Users user) {
        Integer is = 0;
        if (type == 1) {
            LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)wrapper.eq(TrainingLearnManager::getProjectId, (Object)projectId)).in(TrainingLearnManager::getManagerType, Arrays.asList(1, 2));
            List learnManagerList = this.trainingLearnManagerMapper.selectList((Wrapper)wrapper);
            if (!CollectionUtils.isEmpty((Collection)learnManagerList)) {
                List<Integer> users;
                List<Integer> roleList;
                List userList = learnManagerList.stream().map(TrainingLearnManager::getUserId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
                if (!CollectionUtils.isEmpty(userList) && userList.contains(user.getId())) {
                    is = 1;
                }
                if (is == 0 && !CollectionUtils.isEmpty(roleList = learnManagerList.stream().map(TrainingLearnManager::getRoleId).filter(Objects::nonNull).distinct().collect(Collectors.toList())) && !CollectionUtils.isEmpty(users = this.userUtilService.selectUsersByRoles(roleList, user.getGroupId())) && users.contains(user.getId())) {
                    is = 1;
                }
            }
        }
        return is;
    }

    @Override
    public List<TrainingTaskSchedule> getShiftPaperIdByTask(Integer taskId, Users user) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(TrainingTaskSchedule::getTaskId, (Object)taskId)).eq(TrainingTaskSchedule::getTaskType, (Object)2)).isNotNull(TrainingTaskSchedule::getShiftId);
        wrapper.select(new SFunction[]{TrainingTaskSchedule::getShiftId, TrainingTaskSchedule::getPaperId});
        List list = this.trainingTaskScheduleMapper.selectList((Wrapper)wrapper);
        return list;
    }
}

