/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.training.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ovopark.api.RedisBaseApi;
import com.ovopark.organize.common.model.pojo.UsersPojo;
import com.ovopark.pojo.BaseResult;
import com.ovopark.training.bo.Page;
import com.ovopark.training.bo.UserBo;
import com.ovopark.training.mapper.TrainingCourseMapper;
import com.ovopark.training.mapper.TrainingExamMapper;
import com.ovopark.training.mapper.TrainingJobCertificationMapper;
import com.ovopark.training.mapper.TrainingLearnShiftMapper;
import com.ovopark.training.mapper.TrainingLoginUserMapper;
import com.ovopark.training.mapper.TrainingMapper;
import com.ovopark.training.mapper.TrainingPaperMapper;
import com.ovopark.training.mapper.TrainingPaperMarkLogMapper;
import com.ovopark.training.mapper.TrainingUserPaperMapper;
import com.ovopark.training.mapper.TrainingUserQuestionAttaMapper;
import com.ovopark.training.mapper.TrainingUserQuestionMapper;
import com.ovopark.training.mapper.TrainingUserQuestionPictureMapper;
import com.ovopark.training.model.Authenticator;
import com.ovopark.training.model.JPush;
import com.ovopark.training.model.TaskMessageBody;
import com.ovopark.training.model.Training;
import com.ovopark.training.model.TrainingCourse;
import com.ovopark.training.model.TrainingExam;
import com.ovopark.training.model.TrainingJobCertification;
import com.ovopark.training.model.TrainingLearnShift;
import com.ovopark.training.model.TrainingLoginUser;
import com.ovopark.training.model.TrainingPaper;
import com.ovopark.training.model.TrainingPaperMarkLog;
import com.ovopark.training.model.TrainingUserPaper;
import com.ovopark.training.model.TrainingUserQuestion;
import com.ovopark.training.model.TrainingUserQuestionAtta;
import com.ovopark.training.model.TrainingUserQuestionPicture;
import com.ovopark.training.model.Users;
import com.ovopark.training.service.AppTrainingLearnProjectService;
import com.ovopark.training.service.GoldService;
import com.ovopark.training.service.TrainingCourseService;
import com.ovopark.training.service.TrainingJobCertificationService;
import com.ovopark.training.service.TrainingMarkPaperService;
import com.ovopark.training.service.TrainingPaperService;
import com.ovopark.training.service.UserUtilService;
import com.ovopark.training.service.impl.JPushServiceImpl;
import com.ovopark.training.util.DateUtils;
import com.ovopark.training.util.StringsUtils;
import com.ovopark.training.vo.TrainingOptionsVo;
import com.ovopark.training.vo.TrainingPaperMarkLogVo;
import com.ovopark.training.vo.TrainingPapersVo;
import com.ovopark.training.vo.TrainingUserPaperVo;
import com.ovopark.training.vo.TrainingUserQuestionVo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
public class TrainingMarkPaperServiceImpl
implements TrainingMarkPaperService {
    private static final Logger log = LoggerFactory.getLogger(TrainingMarkPaperServiceImpl.class);
    @Autowired
    private UserUtilService userUtilService;
    @Autowired
    private TrainingUserPaperMapper trainingUserPaperMapper;
    @Autowired
    private TrainingPaperMapper trainingPaperMapper;
    @Autowired
    private TrainingExamMapper trainingExamMapper;
    @Autowired
    private TrainingMapper trainingMapper;
    @Autowired
    private TrainingUserQuestionMapper trainingUserQuestionMapper;
    @Autowired
    private TrainingUserQuestionAttaMapper trainingUserQuestionAttaMapper;
    @Autowired
    private TrainingLearnShiftMapper trainingLearnShiftMapper;
    @Autowired
    private TrainingJobCertificationMapper trainingJobCertificationMapper;
    @Autowired
    private TrainingCourseMapper trainingCourseMapper;
    @Autowired
    private TrainingUserQuestionPictureMapper trainingUserQuestionPictureMapper;
    @Autowired
    private TrainingPaperMarkLogMapper trainingPaperMarkLogMapper;
    @Autowired
    private RedisBaseApi redisBaseApi;
    @Autowired
    private JPushServiceImpl jPushService;
    @Autowired
    private GoldService goldService;
    @Autowired
    private TrainingJobCertificationService jobCertificationService;
    @Resource
    private AppTrainingLearnProjectService appTrainingLearnProjectService;
    @Autowired
    private TrainingCourseService trainingCourseService;
    @Autowired
    private MessageSource messageSource;
    @Autowired
    private TrainingPaperService trainingPaperService;
    @Autowired
    private TrainingLoginUserMapper trainingLoginUserMapper;

    @Override
    public Page<TrainingUserPaperVo> selectMarkPapersByPage(Page<TrainingUserPaperVo> page, Users user, Integer paperStatus, String userName, String paperName, String startTime, String endTime, Integer sourceType, Integer sortStatus, String userPaperName, Integer userPaperType) {
        List<TrainingUserPaperVo> userPaperVoList;
        Map<String, Object> userMap;
        List<Integer> limitUserIds = new ArrayList<Integer>();
        List<Integer> loginUserIds = new ArrayList<Integer>();
        if (!StringUtils.isEmpty((Object)userName)) {
            userMap = this.userUtilService.getCheckParameters(userName, null, null, user);
            if (userMap.get("isEffect").toString().equals("1")) {
                limitUserIds = (List)userMap.get("userList");
            }
            loginUserIds = this.trainingPaperService.getVisitorByName(userName);
            if (CollectionUtils.isEmpty(limitUserIds) && CollectionUtils.isEmpty(loginUserIds)) {
                return page;
            }
        }
        if (!StringUtils.isEmpty((Object)userPaperName)) {
            userMap = this.userUtilService.getCheckParameters(userPaperName, null, null, user);
            if (userMap.get("isEffect").toString().equals("1")) {
                limitUserIds = (List)userMap.get("userList");
            }
            loginUserIds = this.trainingPaperService.getVisitorByName(userPaperName);
        }
        if (!CollectionUtils.isEmpty(userPaperVoList = this.trainingUserPaperMapper.selectMarkPapersByPage(page, user.getId(), limitUserIds, loginUserIds, paperStatus, paperName, startTime, endTime, sourceType, sortStatus, userPaperName, userName, userPaperType))) {
            BigDecimal passScore = null;
            List<Integer> userIdList = new ArrayList<Integer>();
            ArrayList<Integer> paperIdList = new ArrayList<Integer>();
            ArrayList<Integer> trainingIdList = new ArrayList<Integer>();
            ArrayList<Integer> shiftIdList = new ArrayList<Integer>();
            ArrayList<Integer> jobIdList = new ArrayList<Integer>();
            ArrayList<Integer> courseIdList = new ArrayList<Integer>();
            for (TrainingUserPaperVo userPaperVo : userPaperVoList) {
                if (userPaperVo.getUserId() != null) {
                    userIdList.add(userPaperVo.getUserId());
                }
                if (userPaperVo.getLoginUserId() != null) {
                    userIdList.add(userPaperVo.getLoginUserId());
                }
                if (userPaperVo.getMarkingUserId() != null) {
                    userIdList.add(userPaperVo.getMarkingUserId());
                }
                paperIdList.add(userPaperVo.getTrainingPaperId());
                if (userPaperVo.getSourceType() == null || userPaperVo.getSourceProjectId() == null) continue;
                if (userPaperVo.getSourceType() == 1) {
                    trainingIdList.add(userPaperVo.getSourceProjectId());
                    continue;
                }
                if (userPaperVo.getSourceType() == 3) {
                    if (userPaperVo.getSourceShiftId() == null) continue;
                    shiftIdList.add(userPaperVo.getSourceShiftId());
                    continue;
                }
                if (userPaperVo.getSourceType() == 4) {
                    jobIdList.add(userPaperVo.getSourceProjectId());
                    continue;
                }
                if (userPaperVo.getSourceType() != 5) continue;
                courseIdList.add(userPaperVo.getSourceProjectId());
            }
            if (!CollectionUtils.isEmpty(userIdList)) {
                userIdList = userIdList.stream().distinct().collect(Collectors.toList());
            }
            Map<Integer, UsersPojo> usersPojoMap = this.userUtilService.selectUserMap(userIdList);
            Map<Object, Object> trainingMap = new HashMap();
            if (!CollectionUtils.isEmpty(trainingIdList)) {
                List trainingList = this.trainingMapper.selectBatchIds(trainingIdList);
                trainingMap = trainingList.stream().collect(Collectors.toMap(Training::getId, Function.identity()));
            }
            Map<Object, Object> learnShiftMap = new HashMap();
            if (!CollectionUtils.isEmpty(shiftIdList)) {
                List learnShiftList = this.trainingLearnShiftMapper.selectBatchIds(shiftIdList);
                learnShiftMap = learnShiftList.stream().collect(Collectors.toMap(TrainingLearnShift::getId, Function.identity()));
            }
            Map<Object, Object> jobMap = new HashMap();
            if (!CollectionUtils.isEmpty(jobIdList)) {
                List jobList = this.trainingJobCertificationMapper.selectBatchIds(jobIdList);
                jobMap = jobList.stream().collect(Collectors.toMap(TrainingJobCertification::getId, Function.identity()));
            }
            Map<Object, Object> courseMap = new HashMap();
            if (!CollectionUtils.isEmpty(courseIdList)) {
                List courseList = this.trainingCourseMapper.selectBatchIds(courseIdList);
                courseMap = courseList.stream().collect(Collectors.toMap(TrainingCourse::getId, Function.identity()));
            }
            List trainingPaperList = this.trainingPaperMapper.selectBatchIds(paperIdList);
            Map<Object, Object> paperMap = new HashMap();
            Map<Object, Object> examMap = new HashMap();
            if (!CollectionUtils.isEmpty((Collection)trainingPaperList)) {
                paperMap = trainingPaperList.stream().collect(Collectors.toMap(TrainingPaper::getId, Function.identity()));
                List examIdList = trainingPaperList.stream().map(TrainingPaper::getExamId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
                if (!CollectionUtils.isEmpty(examIdList)) {
                    List trainingExamList = this.trainingExamMapper.selectBatchIds(examIdList);
                    examMap = trainingExamList.stream().collect(Collectors.toMap(TrainingExam::getId, Function.identity()));
                }
            }
            Locale locale = Authenticator.getInstance().getCurrentClient().getLocale();
            for (TrainingUserPaperVo userPaperVo : userPaperVoList) {
                TrainingExam exam;
                UsersPojo usersPojo;
                userPaperVo.setIsRemark(Integer.valueOf(1));
                if (userPaperVo.getUserId() != null) {
                    usersPojo = usersPojoMap.get(userPaperVo.getUserId());
                    if (!ObjectUtils.isEmpty((Object)usersPojo)) {
                        userPaperVo.setUserName(usersPojo.getShowName());
                        userPaperVo.setUserUrl(usersPojo.getThumbUrl());
                        userPaperVo.setIsVisitor(Integer.valueOf(0));
                    }
                } else {
                    if (userPaperVo.getLoginUserId() != null && !ObjectUtils.isEmpty((Object)(usersPojo = usersPojoMap.get(userPaperVo.getLoginUserId())))) {
                        userPaperVo.setUserName(usersPojo.getShowName());
                    }
                    if (StringUtils.isEmpty((Object)userPaperVo.getUserName())) {
                        userPaperVo.setUserName(userPaperVo.getLoginShowName());
                    }
                    userPaperVo.setIsVisitor(Integer.valueOf(1));
                }
                if (userPaperVo.getMarkingUserId() != null) {
                    usersPojo = usersPojoMap.get(userPaperVo.getMarkingUserId());
                    if (!ObjectUtils.isEmpty((Object)usersPojo)) {
                        userPaperVo.setMarkUserName(usersPojo.getShowName());
                    }
                } else {
                    userPaperVo.setMarkUserName(this.messageSource.getMessage("training.paper.task.system", null, locale));
                }
                TrainingPaper trainingPaper = (TrainingPaper)paperMap.get(userPaperVo.getTrainingPaperId());
                userPaperVo.setSourceProjectName("");
                if (userPaperVo.getSourceType() != null && userPaperVo.getSourceProjectId() != null) {
                    TrainingCourse trainingCourse;
                    if (userPaperVo.getSourceType() == 1) {
                        Training training = (Training)trainingMap.get(userPaperVo.getSourceProjectId());
                        if (!ObjectUtils.isEmpty((Object)training)) {
                            userPaperVo.setSourceProjectName(training.getTitle());
                            if (training.getStatus() == 1) {
                                userPaperVo.setIsRemark(Integer.valueOf(0));
                            }
                        }
                    } else if (userPaperVo.getSourceType() == 2) {
                        if (!ObjectUtils.isEmpty((Object)trainingPaper) && trainingPaper.getPaperState() == 3) {
                            userPaperVo.setIsRemark(Integer.valueOf(0));
                        }
                    } else if (userPaperVo.getSourceType() == 3) {
                        TrainingLearnShift trainingLearnShift;
                        if (userPaperVo.getSourceShiftId() != null && !ObjectUtils.isEmpty((Object)(trainingLearnShift = (TrainingLearnShift)learnShiftMap.get(userPaperVo.getSourceShiftId())))) {
                            userPaperVo.setSourceProjectName(trainingLearnShift.getShiftName() + "-" + trainingLearnShift.getGroupName() + (trainingLearnShift.getSupplemenName() != null ? "-" + trainingLearnShift.getSupplemenName() : ""));
                            if (trainingLearnShift.getStatus() == 4) {
                                userPaperVo.setIsRemark(Integer.valueOf(0));
                            }
                        }
                    } else if (userPaperVo.getSourceType() == 4) {
                        TrainingJobCertification trainingJobCertification = (TrainingJobCertification)jobMap.get(userPaperVo.getSourceProjectId());
                        if (!ObjectUtils.isEmpty((Object)trainingJobCertification)) {
                            userPaperVo.setSourceProjectName(trainingJobCertification.getCertificationName());
                            if (trainingJobCertification.getStatus() == 2) {
                                userPaperVo.setIsRemark(Integer.valueOf(0));
                            }
                        }
                    } else if (userPaperVo.getSourceType() == 5 && !ObjectUtils.isEmpty((Object)(trainingCourse = (TrainingCourse)courseMap.get(userPaperVo.getSourceProjectId())))) {
                        userPaperVo.setSourceProjectName(trainingCourse.getCourseName());
                        if (trainingCourse.getStatus() == 3 && trainingCourse.getIsOverdue() == 0) {
                            userPaperVo.setIsRemark(Integer.valueOf(0));
                        }
                    }
                }
                passScore = new BigDecimal("60");
                if (!ObjectUtils.isEmpty((Object)trainingPaper) && trainingPaper.getPassLine() != null && trainingPaper.getExamId() != null && !ObjectUtils.isEmpty((Object)(exam = (TrainingExam)examMap.get(trainingPaper.getExamId())))) {
                    passScore = exam.getScore().multiply(new BigDecimal(trainingPaper.getPassLine().toString())).multiply(new BigDecimal("0.01")).setScale(2, 4);
                }
                if (userPaperVo.getScore() == null || userPaperVo.getPaperStatus() != 2) continue;
                if (userPaperVo.getScore().compareTo(passScore) >= 0) {
                    userPaperVo.setPassStatus(Integer.valueOf(2));
                    continue;
                }
                userPaperVo.setPassStatus(Integer.valueOf(3));
            }
            page.setContent(userPaperVoList);
        }
        return page;
    }

    @Override
    public Map<String, Object> selectMarkPaperNum(Users user) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        List<TrainingUserPaperVo> userPaperVos1 = this.trainingUserPaperMapper.selectMarkPapersList(user.getId(), 1);
        List<TrainingUserPaperVo> userPaperVos2 = this.trainingUserPaperMapper.selectMarkPapersList(user.getId(), 2);
        map.put("markingNum", CollectionUtils.isEmpty(userPaperVos1) ? 0 : userPaperVos1.size());
        map.put("markedNum", CollectionUtils.isEmpty(userPaperVos2) ? 0 : userPaperVos2.size());
        return map;
    }

    @Override
    public TrainingPapersVo selectMarkingPaper(Users user, TrainingPapersVo trainingPapersVo) {
        TrainingUserPaper trainingUserPaper = (TrainingUserPaper)this.trainingUserPaperMapper.selectById(trainingPapersVo.getUserPaperId());
        if (!ObjectUtils.isEmpty((Object)trainingUserPaper)) {
            this.saveMarkingPaperUsers(user, trainingPapersVo);
            ArrayList<TrainingUserQuestionVo> userQuestionVoList = new ArrayList<TrainingUserQuestionVo>();
            UserBo bo = new UserBo();
            if (trainingUserPaper.getUserId() != null) {
                Map<Integer, List<String>> userOrganizeMap;
                List<String> userStr;
                UsersPojo usersPojo = this.userUtilService.selectUser(trainingUserPaper.getUserId());
                if (!ObjectUtils.isEmpty((Object)usersPojo)) {
                    bo.setId(usersPojo.getId());
                    bo.setUserName(usersPojo.getUserName());
                    bo.setShowName(usersPojo.getShowName());
                    bo.setThumbUrl(usersPojo.getThumbUrl());
                }
                bo.setOrganizes(CollectionUtils.isEmpty(userStr = (userOrganizeMap = this.userUtilService.selectOrganizeMap(Collections.singletonList(trainingUserPaper.getUserId()), usersPojo.getGroupId())).get(trainingUserPaper.getUserId())) ? "" : userStr.get(0));
            } else if (trainingUserPaper.getLoginUserId() != null) {
                LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)wrapper1.eq(TrainingLoginUser::getUserId, (Object)trainingUserPaper.getLoginUserId())).orderByDesc(TrainingLoginUser::getId);
                List trainingLoginUserList = this.trainingLoginUserMapper.selectList((Wrapper)wrapper1);
                if (!CollectionUtils.isEmpty((Collection)trainingLoginUserList)) {
                    TrainingLoginUser trainingLoginUser = (TrainingLoginUser)trainingLoginUserList.get(0);
                    bo.setId(trainingLoginUser.getId());
                    bo.setUserName(trainingLoginUser.getShowName());
                    bo.setShowName(trainingLoginUser.getShowName());
                    bo.setOrganizes(trainingLoginUser.getDepartment());
                }
            }
            trainingPapersVo.setUserBo(bo);
            trainingPapersVo.setTitle(trainingUserPaper.getTitle());
            trainingPapersVo.setSubmitTime(trainingUserPaper.getSubmitTime());
            if (trainingUserPaper.getUpdateTime() != null && trainingUserPaper.getSubmitTime() != null) {
                int totalTime = (int)((trainingUserPaper.getSubmitTime().getTime() - trainingUserPaper.getUpdateTime().getTime()) / 1000L);
                trainingPapersVo.setTimeStr(DateUtils.getUseTimeFormal(totalTime));
            }
            trainingPapersVo.setSourceType(trainingUserPaper.getSourceType());
            if (trainingUserPaper.getSourceType() != null) {
                TrainingCourse trainingCourse;
                if (trainingUserPaper.getSourceType() == 1 && trainingUserPaper.getSourceProjectId() != null) {
                    Training training = (Training)this.trainingMapper.selectById(trainingUserPaper.getSourceProjectId());
                    if (!ObjectUtils.isEmpty((Object)training)) {
                        trainingPapersVo.setProjectName(training.getTitle());
                    }
                } else if (trainingUserPaper.getSourceType() == 3 && trainingUserPaper.getSourceShiftId() != null) {
                    TrainingLearnShift trainingLearnShift = (TrainingLearnShift)this.trainingLearnShiftMapper.selectById(trainingUserPaper.getSourceShiftId());
                    if (!ObjectUtils.isEmpty((Object)trainingLearnShift)) {
                        trainingPapersVo.setProjectName(trainingLearnShift.getShiftName() + "-" + trainingLearnShift.getGroupName() + (trainingLearnShift.getSupplemenName() != null ? "-" + trainingLearnShift.getSupplemenName() : ""));
                    }
                } else if (trainingUserPaper.getSourceType() == 4 && trainingUserPaper.getSourceProjectId() != null) {
                    TrainingJobCertification trainingJobCertification = (TrainingJobCertification)this.trainingJobCertificationMapper.selectById(trainingUserPaper.getSourceProjectId());
                    if (!ObjectUtils.isEmpty((Object)trainingJobCertification)) {
                        trainingPapersVo.setProjectName(trainingJobCertification.getCertificationName());
                    }
                } else if (trainingUserPaper.getSourceType() == 5 && trainingUserPaper.getSourceProjectId() != null && !ObjectUtils.isEmpty((Object)(trainingCourse = (TrainingCourse)this.trainingCourseMapper.selectById(trainingUserPaper.getSourceProjectId())))) {
                    trainingPapersVo.setProjectName(trainingCourse.getCourseName());
                }
            }
            BigDecimal totalScore = new BigDecimal("100");
            BigDecimal passLine = new BigDecimal("60");
            TrainingPaper trainingPaper = (TrainingPaper)this.trainingPaperMapper.selectById(trainingUserPaper.getTrainingPaperId());
            if (!ObjectUtils.isEmpty((Object)trainingPaper)) {
                TrainingExam trainingExam;
                if (trainingPaper.getPassLine() != null) {
                    passLine = new BigDecimal(trainingPaper.getPassLine().toString());
                }
                if (trainingPaper.getExamId() != null && !ObjectUtils.isEmpty((Object)(trainingExam = (TrainingExam)this.trainingExamMapper.selectById(trainingPaper.getExamId())))) {
                    totalScore = trainingExam.getScore();
                    trainingPapersVo.setQuestionCount(trainingExam.getCount());
                }
            }
            trainingPapersVo.setTotalScore(totalScore);
            trainingPapersVo.setPassScore(totalScore.multiply(passLine).divide(new BigDecimal("100"), 1, 4));
            LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
            wrapper1.eq(TrainingUserQuestion::getUserPaperId, (Object)trainingPapersVo.getUserPaperId());
            List trainingUserQuestionList = this.trainingUserQuestionMapper.selectList((Wrapper)wrapper1);
            if (!CollectionUtils.isEmpty((Collection)trainingUserQuestionList)) {
                if (trainingPapersVo.getQuestionCount() == null) {
                    trainingPapersVo.setQuestionCount(Integer.valueOf(trainingUserQuestionList.size()));
                }
                ArrayList<Integer> userQuestionIdList = new ArrayList<Integer>();
                for (TrainingUserQuestion userQuestion : trainingUserQuestionList) {
                    if (userQuestion.getQuestionType() != 1) continue;
                    userQuestionIdList.add(userQuestion.getId());
                }
                Map<Object, Object> pictureMap = new HashMap();
                Map<Object, Object> questionAttaMap = new HashMap();
                if (!CollectionUtils.isEmpty(userQuestionIdList)) {
                    LambdaQueryWrapper wrapper3 = new LambdaQueryWrapper();
                    ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper3.in(TrainingUserQuestionPicture::getUserQuestionId, userQuestionIdList)).eq(TrainingUserQuestionPicture::getPictureType, (Object)1)).eq(TrainingUserQuestionPicture::getIsDelete, (Object)0);
                    List userQuestionPictures = this.trainingUserQuestionPictureMapper.selectList((Wrapper)wrapper3);
                    if (!CollectionUtils.isEmpty((Collection)userQuestionPictures)) {
                        pictureMap = userQuestionPictures.stream().collect(Collectors.groupingBy(TrainingUserQuestionPicture::getUserQuestionId));
                    }
                    LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
                    ((LambdaQueryWrapper)wrapper.in(TrainingUserQuestionAtta::getUserQuestionId, userQuestionIdList)).isNull(TrainingUserQuestionAtta::getMarkLogId);
                    List trainingUserQuestionAttaList = this.trainingUserQuestionAttaMapper.selectList((Wrapper)wrapper);
                    if (!CollectionUtils.isEmpty((Collection)trainingUserQuestionAttaList)) {
                        questionAttaMap = trainingUserQuestionAttaList.stream().collect(Collectors.groupingBy(TrainingUserQuestionAtta::getUserQuestionId));
                    }
                }
                LambdaQueryWrapper wrapper2 = new LambdaQueryWrapper();
                wrapper2.eq(TrainingPaperMarkLog::getUserPaperId, (Object)trainingPapersVo.getUserPaperId());
                List trainingPaperMarkLogList = this.trainingPaperMarkLogMapper.selectList((Wrapper)wrapper2);
                Map<Object, Object> logMap = new HashMap();
                if (!CollectionUtils.isEmpty((Collection)trainingPaperMarkLogList)) {
                    logMap = trainingPaperMarkLogList.stream().collect(Collectors.groupingBy(TrainingPaperMarkLog::getUserQuestionId));
                }
                for (TrainingUserQuestion trainingUserQuestion : trainingUserQuestionList) {
                    TrainingUserQuestionVo userQuestionVo = new TrainingUserQuestionVo();
                    BeanUtils.copyProperties((Object)trainingUserQuestion, (Object)userQuestionVo);
                    List optionsList = new ArrayList();
                    if (!StringUtils.isEmpty((Object)userQuestionVo.getOptionsData())) {
                        optionsList = JSONObject.parseArray((String)userQuestionVo.getOptionsData(), TrainingOptionsVo.class);
                        if (userQuestionVo.getQuestionType() == 2 && !CollectionUtils.isEmpty(optionsList)) {
                            for (TrainingOptionsVo vo : optionsList) {
                                List<String> optionsLists = StringsUtils.String2List(vo.getOptionsName(), "&");
                                if (!CollectionUtils.isEmpty(optionsLists)) {
                                    if (!StringUtils.isEmpty((Object)vo.getAnswer()) && optionsLists.contains(vo.getAnswer().trim())) {
                                        vo.setIsCorrect(Integer.valueOf(1));
                                        continue;
                                    }
                                    vo.setIsCorrect(Integer.valueOf(0));
                                    continue;
                                }
                                vo.setIsCorrect(Integer.valueOf(1));
                            }
                        }
                    }
                    userQuestionVo.setOptionsVoList(optionsList);
                    userQuestionVo.setOptionsData(null);
                    List logList = (List)logMap.get(trainingUserQuestion.getId());
                    if (!CollectionUtils.isEmpty((Collection)logList)) {
                        userQuestionVo.setIsLog(Integer.valueOf(1));
                    } else {
                        userQuestionVo.setIsLog(Integer.valueOf(0));
                    }
                    if (trainingUserQuestion.getQuestionType() == 1) {
                        List questionPictureList = (List)pictureMap.get(trainingUserQuestion.getId());
                        userQuestionVo.setUserQuestionPictureList(questionPictureList);
                        List questionAttaList = (List)questionAttaMap.get(trainingUserQuestion.getId());
                        userQuestionVo.setAttaList(questionAttaList);
                    }
                    userQuestionVoList.add(userQuestionVo);
                }
            }
            trainingPapersVo.setUserQuestionVoList(userQuestionVoList);
        }
        return trainingPapersVo;
    }

    @Override
    public List<TrainingPaperMarkLogVo> selectPaperMarkLog(Users user, TrainingPaperMarkLogVo trainingPaperMarkLogVo) {
        ArrayList<TrainingPaperMarkLogVo> list = new ArrayList<TrainingPaperMarkLogVo>();
        LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)wrapper1.eq(TrainingPaperMarkLog::getUserQuestionId, (Object)trainingPaperMarkLogVo.getUserQuestionId())).orderByAsc(TrainingPaperMarkLog::getId);
        List trainingPaperMarkLogList = this.trainingPaperMarkLogMapper.selectList((Wrapper)wrapper1);
        if (!CollectionUtils.isEmpty((Collection)trainingPaperMarkLogList)) {
            List<Integer> markUserIdList = trainingPaperMarkLogList.stream().map(TrainingPaperMarkLog::getMarkUserId).distinct().collect(Collectors.toList());
            Map<Integer, UsersPojo> markUserPojoMap = this.userUtilService.selectUserMap(markUserIdList);
            List markLogIdList = trainingPaperMarkLogList.stream().map(TrainingPaperMarkLog::getId).distinct().collect(Collectors.toList());
            Map<Object, Object> questionAttaMap = new HashMap();
            LambdaQueryWrapper wrapper2 = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)wrapper2.in(TrainingUserQuestionAtta::getMarkLogId, markLogIdList)).isNull(TrainingUserQuestionAtta::getUserQuestionId);
            List trainingUserQuestionAttaList = this.trainingUserQuestionAttaMapper.selectList((Wrapper)wrapper2);
            if (!CollectionUtils.isEmpty((Collection)trainingUserQuestionAttaList)) {
                questionAttaMap = trainingUserQuestionAttaList.stream().collect(Collectors.groupingBy(TrainingUserQuestionAtta::getMarkLogId));
            }
            TrainingPaperMarkLogVo paperMarkLogVo = null;
            for (TrainingPaperMarkLog trainingPaperMarkLog : trainingPaperMarkLogList) {
                paperMarkLogVo = new TrainingPaperMarkLogVo();
                BeanUtils.copyProperties((Object)trainingPaperMarkLog, (Object)paperMarkLogVo);
                UsersPojo pojo = markUserPojoMap.get(trainingPaperMarkLog.getMarkUserId());
                if (!ObjectUtils.isEmpty((Object)pojo)) {
                    paperMarkLogVo.setMarkUserName(pojo.getShowName());
                }
                List userQuestionAttaList = (List)questionAttaMap.get(trainingPaperMarkLog.getId());
                paperMarkLogVo.setTrainingUserQuestionAttaList(userQuestionAttaList);
                list.add(paperMarkLogVo);
            }
        }
        return list;
    }

    @Override
    public TrainingPapersVo saveMarkPaper(Users user, TrainingPapersVo trainingPapersVo) {
        Date now = new Date();
        BigDecimal score = BigDecimal.ZERO;
        List trainingUserQuestionVoList = trainingPapersVo.getUserQuestionVoList();
        if (!CollectionUtils.isEmpty((Collection)trainingUserQuestionVoList)) {
            LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
            wrapper1.eq(TrainingUserQuestion::getUserPaperId, (Object)trainingPapersVo.getUserPaperId());
            List trainingUserQuestionList = this.trainingUserQuestionMapper.selectList((Wrapper)wrapper1);
            Map trainingUserQuestionMap = trainingUserQuestionList.stream().collect(Collectors.toMap(TrainingUserQuestion::getId, Function.identity()));
            TrainingPaperMarkLog trainingPaperMarkLog = null;
            ArrayList<TrainingUserQuestionAtta> trainingUserQuestionAttaList = new ArrayList<TrainingUserQuestionAtta>();
            TrainingUserQuestion trainingUserQuestion = null;
            ArrayList<Integer> trainingUserQuestionIdList = new ArrayList<Integer>();
            for (TrainingUserQuestionVo trainingUserQuestionVo : trainingUserQuestionVoList) {
                TrainingUserQuestionAtta userQuestionAtta;
                TrainingUserQuestion userQuestion;
                if (trainingUserQuestionVo.getScore() != null) {
                    score = score.add(trainingUserQuestionVo.getScore());
                }
                if (ObjectUtils.isEmpty((Object)(userQuestion = (TrainingUserQuestion)trainingUserQuestionMap.get(trainingUserQuestionVo.getId()))) || trainingUserQuestionVo.getScore() == null || (userQuestion.getScore() == null || trainingUserQuestionVo.getScore().compareTo(userQuestion.getScore()) == 0 && (trainingUserQuestionVo.getScore().compareTo(BigDecimal.ZERO) != 0 || userQuestion.getIsReviewed() != null && userQuestion.getIsReviewed() != 0)) && (trainingUserQuestionVo.getQuestionType() != 1 || userQuestion.getScore() != null && (trainingUserQuestionVo.getComment() == null || trainingUserQuestionVo.getComment().equals(userQuestion.getComment())))) continue;
                trainingUserQuestion = new TrainingUserQuestion();
                trainingUserQuestion.setId(trainingUserQuestionVo.getId());
                trainingUserQuestion.setIsCorrect(trainingUserQuestionVo.getIsCorrect());
                trainingUserQuestion.setScore(trainingUserQuestionVo.getScore());
                trainingUserQuestion.setIsReviewed(Integer.valueOf(1));
                trainingPaperMarkLog = new TrainingPaperMarkLog();
                trainingPaperMarkLog.setUserPaperId(trainingPapersVo.getUserPaperId());
                trainingPaperMarkLog.setUserQuestionId(trainingUserQuestionVo.getId());
                trainingPaperMarkLog.setMarkUserId(user.getId());
                trainingPaperMarkLog.setIsCorrect(trainingUserQuestionVo.getIsCorrect());
                trainingPaperMarkLog.setScore(trainingUserQuestionVo.getScore());
                trainingPaperMarkLog.setCreateTime(now);
                trainingPaperMarkLog.setEnterpriseId(user.getGroupId());
                if (trainingUserQuestionVo.getQuestionType() != null && trainingUserQuestionVo.getQuestionType() == 1 && trainingUserQuestionVo.getComment() != null && !trainingUserQuestionVo.getComment().equals(userQuestion.getComment())) {
                    trainingUserQuestion.setComment(trainingUserQuestionVo.getComment());
                    trainingPaperMarkLog.setComment(trainingUserQuestionVo.getComment());
                    if (!CollectionUtils.isEmpty((Collection)trainingUserQuestionVo.getAttaList())) {
                        userQuestionAtta = null;
                        for (TrainingUserQuestionAtta trainingUserQuestionAtta : trainingUserQuestionVo.getAttaList()) {
                            userQuestionAtta = new TrainingUserQuestionAtta();
                            userQuestionAtta.setName(trainingUserQuestionAtta.getName());
                            userQuestionAtta.setUrl(trainingUserQuestionAtta.getUrl());
                            userQuestionAtta.setUserQuestionId(trainingUserQuestionVo.getId());
                            userQuestionAtta.setMarkLogId(null);
                            userQuestionAtta.setCreateTime(now);
                            trainingUserQuestionAttaList.add(userQuestionAtta);
                            trainingUserQuestionIdList.add(trainingUserQuestionVo.getId());
                        }
                    }
                }
                this.trainingUserQuestionMapper.updateById(trainingUserQuestion);
                this.trainingPaperMarkLogMapper.insert(trainingPaperMarkLog);
                if (trainingUserQuestionVo.getQuestionType() == null || trainingUserQuestionVo.getQuestionType() != 1 || CollectionUtils.isEmpty((Collection)trainingUserQuestionVo.getAttaList()) || CollectionUtils.isEmpty((Collection)trainingUserQuestionVo.getAttaList())) continue;
                userQuestionAtta = null;
                for (TrainingUserQuestionAtta trainingUserQuestionAtta : trainingUserQuestionVo.getAttaList()) {
                    userQuestionAtta = new TrainingUserQuestionAtta();
                    userQuestionAtta.setName(trainingUserQuestionAtta.getName());
                    userQuestionAtta.setUrl(trainingUserQuestionAtta.getUrl());
                    userQuestionAtta.setMarkLogId(trainingPaperMarkLog.getId());
                    userQuestionAtta.setUserQuestionId(null);
                    userQuestionAtta.setCreateTime(now);
                    trainingUserQuestionAttaList.add(userQuestionAtta);
                }
            }
            if (!CollectionUtils.isEmpty(trainingUserQuestionIdList)) {
                LambdaUpdateWrapper wrapper2 = new LambdaUpdateWrapper();
                wrapper2.in(TrainingUserQuestionAtta::getUserQuestionId, trainingUserQuestionIdList);
                this.trainingUserQuestionAttaMapper.delete((Wrapper)wrapper2);
            }
            if (!CollectionUtils.isEmpty(trainingUserQuestionAttaList)) {
                this.trainingUserQuestionAttaMapper.insertList(trainingUserQuestionAttaList);
            }
        }
        TrainingUserPaper trainingUserPaper = new TrainingUserPaper();
        trainingUserPaper.setId(trainingPapersVo.getUserPaperId());
        trainingUserPaper.setPaperStatus(trainingPapersVo.getPaperState());
        trainingUserPaper.setScore(score);
        if (trainingPapersVo.getPaperState() != null && trainingPapersVo.getPaperState() == 2) {
            trainingUserPaper.setMarkingUserId(user.getId());
            trainingUserPaper.setMarkingTime(now);
        }
        trainingUserPaper.setIsAutoRead(Integer.valueOf(0));
        this.trainingUserPaperMapper.updateById(trainingUserPaper);
        if (trainingUserPaper.getPaperStatus() == 2 && (trainingUserPaper = (TrainingUserPaper)this.trainingUserPaperMapper.selectById(trainingUserPaper.getId())).getUserId() != null) {
            TrainingPaper trainingPaper = (TrainingPaper)this.trainingPaperMapper.selectById(trainingUserPaper.getTrainingPaperId());
            BigDecimal passLine = new BigDecimal("60");
            BigDecimal totalScore = BigDecimal.ONE;
            if (!ObjectUtils.isEmpty((Object)trainingPaper)) {
                TrainingExam trainingExam;
                BigDecimal bigDecimal = passLine = trainingPaper.getPassLine() != null ? new BigDecimal(trainingPaper.getPassLine().toString()) : new BigDecimal("60");
                if (trainingPaper.getExamId() != null && !ObjectUtils.isEmpty((Object)(trainingExam = (TrainingExam)this.trainingExamMapper.selectById(trainingPaper.getExamId()))) && trainingExam.getScore() != null) {
                    totalScore = trainingExam.getScore().divide(new BigDecimal("100"), 5);
                }
            }
            BigDecimal passScore = totalScore.multiply(passLine);
            Locale locale = Authenticator.getInstance().getCurrentClient().getLocale();
            String text = "";
            String key = "";
            if (passScore.compareTo(trainingUserPaper.getScore()) <= 0) {
                text = this.messageSource.getMessage("training.paper.pass.data", null, locale);
                key = "training.paper.pass.data";
            } else {
                text = this.messageSource.getMessage("training.paper.unpass.data", null, locale);
                key = "training.paper.unpass.data";
            }
            try {
                TaskMessageBody body = new TaskMessageBody();
                body.setType(137);
                body.setTaskJson(JSONObject.toJSONString((Object)trainingUserPaper));
                this.jPushService.sendWebSocket(trainingUserPaper.getTitle(), text, trainingUserPaper.getUserId(), user.getGroupId(), trainingUserPaper.getId(), "TYPE_TRAINING_PAPER_EXAMINEE", JSONObject.toJSONString((Object)trainingUserPaper), null, 0, 0, key, null);
                this.jPushService.pushNotification(JPush.MASSAGE_TYPE_NOTIFY, "TYPE_TRAINING_PAPER_EXAMINEE", trainingUserPaper.getUserId(), trainingUserPaper.getTitle(), text, body);
            }
            catch (Exception e) {
                log.error("\u9605\u5377--\u63a8\u9001\u6d88\u606f\u5931\u8d25", (Throwable)e);
            }
        }
        if (trainingPapersVo.getIsNextPaper() != null && trainingPapersVo.getIsNextPaper() == 1) {
            trainingPapersVo = this.selectNextUserPaper(user, trainingPapersVo);
        }
        if (trainingUserPaper.getPaperStatus() == 2) {
            try {
                this.goldService.getGoldModuleEnterpriseDetailByEnterpriseId(user.getGroupId(), "TRSINING_PAPER");
            }
            catch (Exception e) {
                log.error("\u9605\u5377--\u91d1\u5e01\u5f02\u5e38", (Throwable)e);
            }
            if (!StringUtils.isEmpty((Object)trainingUserPaper.getSourceType())) {
                if (trainingUserPaper.getSourceType() == 3) {
                    try {
                        this.appTrainingLearnProjectService.updateExamTaskStatus(trainingUserPaper.getId());
                    }
                    catch (Exception e) {
                        log.error("\u9605\u5377--\u63d0\u4ea4\u8bd5\u5377\u9879\u76ee\u5b66\u4e60\u65b0\u52a0\u903b\u8f91", (Throwable)e);
                    }
                } else if (trainingUserPaper.getSourceType() == 4) {
                    try {
                        this.jobCertificationService.updatePaperStatus(trainingUserPaper.getId());
                    }
                    catch (Exception e) {
                        log.error("\u5c97\u4f4d\u5b66\u4e60\u65b0\u52a0\u903b\u8f91", (Throwable)e);
                    }
                } else if (trainingUserPaper.getSourceType() == 5) {
                    try {
                        this.trainingCourseService.saveCourseTaskEnd(trainingUserPaper.getId(), 2, null, null, null);
                    }
                    catch (Exception e) {
                        log.error("\u57f9\u8bad\u8ba1\u5212\u8003\u8bd5\u7ed3\u675f", (Throwable)e);
                    }
                }
            }
        }
        return trainingPapersVo;
    }

    @Override
    public Map<String, Object> selectMarkingPaperUsers(Users user, TrainingPapersVo trainingPapersVo) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Integer isExist = 0;
        BaseResult baseResult = this.redisBaseApi.sGet("Training_MarkingPaperUsers_" + trainingPapersVo.getUserPaperId());
        if (baseResult != null && !baseResult.getIsError().booleanValue() && !ObjectUtils.isEmpty((Object)baseResult.getData())) {
            Map<Integer, UsersPojo> usersPojoMap;
            Date now = new Date();
            ArrayList<Integer> userIds = new ArrayList<Integer>();
            Set base = (Set)baseResult.getData();
            for (String value : base) {
                long timeDiff;
                String time;
                String[] valueStr = value.replace("[", "").replace("]", "").split("__");
                String userId = valueStr[0];
                if (StringUtils.isEmpty((Object)userId.trim()) || user.getId().toString().equals(userId) || StringUtils.isEmpty((Object)(time = valueStr[1]).trim()) || (timeDiff = DateUtils.getTimeDif(now, DateUtils.parse(time))) >= 1800000L) continue;
                userIds.add(Integer.valueOf(userId));
            }
            if (!(CollectionUtils.isEmpty(userIds) || ObjectUtils.isEmpty(usersPojoMap = this.userUtilService.selectUserMap(userIds)) || CollectionUtils.isEmpty(usersPojoMap.values()))) {
                isExist = 1;
                map.put("userList", usersPojoMap.values());
            }
        }
        map.put("isExist", isExist);
        return map;
    }

    public void saveMarkingPaperUsers(Users user, TrainingPapersVo trainingPapersVo) {
        Date now = new Date();
        BaseResult baseResult = this.redisBaseApi.sGet("Training_MarkingPaperUsers_" + trainingPapersVo.getUserPaperId());
        HashSet<String> setList = new HashSet<String>();
        setList.add(user.getId().toString() + "__" + DateUtils.format(now));
        if (baseResult != null && !baseResult.getIsError().booleanValue() && !ObjectUtils.isEmpty((Object)baseResult.getData())) {
            Set base = (Set)baseResult.getData();
            for (String value : base) {
                long timeDiff;
                String time;
                String userId;
                String[] valueStr = value.replace("[", "").replace("]", "").split("__");
                String string = userId = StringUtils.isEmpty((Object)valueStr[0].trim()) ? "" : valueStr[0].trim();
                if (user.getId().toString().equals(userId) || StringUtils.isEmpty((Object)(time = valueStr.length > 1 ? valueStr[1] : "").trim()) || (timeDiff = DateUtils.getTimeDif(now, DateUtils.parse(time))) >= 1800000L) continue;
                setList.add(userId + "__" + time);
            }
            this.redisBaseApi.remove("Training_MarkingPaperUsers_" + trainingPapersVo.getUserPaperId());
        }
        this.redisBaseApi.sSetExpire("Training_MarkingPaperUsers_" + trainingPapersVo.getUserPaperId(), 1800000L, new String[]{String.valueOf(setList)});
    }

    @Override
    public void delMarkingPaperUsers(Users user, TrainingPapersVo trainingPapersVo) {
        BaseResult baseResult = this.redisBaseApi.sGet("Training_MarkingPaperUsers_" + trainingPapersVo.getUserPaperId());
        if (baseResult != null && !baseResult.getIsError().booleanValue() && !ObjectUtils.isEmpty((Object)baseResult.getData())) {
            Date now = new Date();
            Set base = (Set)baseResult.getData();
            HashSet<String> setList = new HashSet<String>();
            for (String value : base) {
                long timeDiff;
                String time;
                String[] valueStr = value.replace("[", "").replace("]", "").split("__");
                String userId = valueStr[0];
                if (StringUtils.isEmpty((Object)userId.trim()) || user.getId().toString().equals(userId) || StringUtils.isEmpty((Object)(time = valueStr[1]).trim()) || (timeDiff = DateUtils.getTimeDif(now, DateUtils.parse(time))) >= 1800000L) continue;
                setList.add(userId + "__" + time);
            }
            this.redisBaseApi.remove("Training_MarkingPaperUsers_" + trainingPapersVo.getUserPaperId());
            if (!CollectionUtils.isEmpty(setList)) {
                this.redisBaseApi.sSetExpire("Training_MarkingPaperUsers_" + trainingPapersVo.getUserPaperId(), 1800000L, new String[]{String.valueOf(setList)});
            }
        }
    }

    @Override
    public TrainingPapersVo selectNextUserPaper(Users user, TrainingPapersVo trainingPapersVo) {
        List<Integer> trainingUserPaperIds;
        Map<String, Object> userMap;
        Integer nextId = null;
        Integer trainingUserPaperId = trainingPapersVo.getUserPaperId();
        List<Integer> limitUserIds = new ArrayList<Integer>();
        List<Integer> loginUserIds = new ArrayList<Integer>();
        if (!StringUtils.isEmpty((Object)trainingPapersVo.getUserName())) {
            userMap = this.userUtilService.getCheckParameters(trainingPapersVo.getUserName(), null, null, user);
            if (userMap.get("isEffect").toString().equals("1")) {
                limitUserIds = (List)userMap.get("userList");
            }
            loginUserIds = this.trainingPaperService.getVisitorByName(trainingPapersVo.getUserName());
            if (CollectionUtils.isEmpty(limitUserIds) && CollectionUtils.isEmpty(loginUserIds)) {
                trainingPapersVo.setUserPaperId(null);
                return trainingPapersVo;
            }
        }
        if (!StringUtils.isEmpty((Object)trainingPapersVo.getUserPaperName())) {
            userMap = this.userUtilService.getCheckParameters(trainingPapersVo.getUserPaperName(), null, null, user);
            if (userMap.get("isEffect").toString().equals("1")) {
                limitUserIds = (List)userMap.get("userList");
            }
            loginUserIds = this.trainingPaperService.getVisitorByName(trainingPapersVo.getUserPaperName());
        }
        if (!CollectionUtils.isEmpty(trainingUserPaperIds = this.trainingUserPaperMapper.selectNextUserPaperByUserId(user.getId(), trainingUserPaperId, limitUserIds, loginUserIds, trainingPapersVo.getPaperName(), trainingPapersVo.getStartTime() != null ? DateUtils.format(trainingPapersVo.getStartTime(), "yyyy-MM-dd") : null, trainingPapersVo.getEndTime() != null ? DateUtils.format(trainingPapersVo.getEndTime(), "yyyy-MM-dd") : null, trainingPapersVo.getSourceType(), trainingPapersVo.getUserPaperName(), trainingPapersVo.getUserName(), trainingPapersVo.getUserPaperType()))) {
            nextId = trainingUserPaperIds.get(0);
            Boolean isExist = false;
            for (Integer userPaperId : trainingUserPaperIds) {
                if (isExist.booleanValue()) {
                    nextId = userPaperId;
                    break;
                }
                if (!userPaperId.equals(trainingUserPaperId)) continue;
                isExist = true;
            }
            if (nextId.equals(trainingUserPaperId)) {
                trainingPapersVo.setUserPaperId(null);
            } else {
                trainingPapersVo.setUserPaperId(nextId);
            }
        } else {
            trainingPapersVo.setUserPaperId(null);
        }
        return trainingPapersVo;
    }
}

