/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.training.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.google.common.collect.Lists;
import com.ovopark.training.bo.JsonResult;
import com.ovopark.training.mapper.TrainingAndMaterialMapper;
import com.ovopark.training.mapper.TrainingMaterialAttachMapper;
import com.ovopark.training.mapper.TrainingMaterialMapper;
import com.ovopark.training.mapper.TrainingMaterialParameterMapper;
import com.ovopark.training.mapper.TrainingMaterialProductPictureMapper;
import com.ovopark.training.mapper.TrainingMaterialTypeMapper;
import com.ovopark.training.model.Authenticator;
import com.ovopark.training.model.TrainingAndMaterial;
import com.ovopark.training.model.TrainingMaterial;
import com.ovopark.training.model.TrainingMaterialAttach;
import com.ovopark.training.model.TrainingMaterialParameter;
import com.ovopark.training.model.TrainingMaterialProductPicture;
import com.ovopark.training.model.TrainingMaterialType;
import com.ovopark.training.model.TrainingResource;
import com.ovopark.training.model.Users;
import com.ovopark.training.service.TrainingMaterialProductService;
import com.ovopark.training.service.TrainingMaterialService;
import com.ovopark.training.service.materialtype.MaterialTypeService;
import com.ovopark.training.service.permission.material.MaterialPermissionFacade;
import com.ovopark.training.service.permission.material.MaterialSinglePermissionService;
import com.ovopark.training.service.permission.material.MaterialTypePermissionService;
import com.ovopark.training.service.resource.ResourceService;
import com.ovopark.training.util.CommonUtil;
import com.ovopark.training.util.ExcelUtil;
import com.ovopark.training.util.ListUtil;
import com.ovopark.training.util.OssHelper;
import com.ovopark.training.util.StorageModule;
import com.ovopark.training.vo.TrainingMaterialTypeVo;
import com.ovopark.training.vo.TrainingMaterialVo;
import java.io.ByteArrayOutputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.poi.ss.usermodel.PictureData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.multipart.MultipartFile;

@Service
public class TrainingMaterialProductServiceImpl
implements TrainingMaterialProductService {
    private static final Logger log = LoggerFactory.getLogger(TrainingMaterialProductServiceImpl.class);
    @Autowired
    private TrainingMaterialMapper materialMapper;
    @Autowired
    private TrainingMaterialTypeMapper materialTypeMapper;
    @Autowired
    private TrainingMaterialProductPictureMapper materialProductPictureMapper;
    @Autowired
    private TrainingMaterialParameterMapper materialParameterMapper;
    @Autowired
    private TrainingAndMaterialMapper andMaterialMapper;
    @Autowired
    private MessageSource messageSource;
    @Autowired
    private TrainingMaterialService materialService;
    @Autowired
    private TrainingMaterialAttachMapper trainingMaterialAttachMapper;
    @Autowired
    private MaterialSinglePermissionService materialSinglePermissionService;
    @Autowired
    private MaterialPermissionFacade materialPermissionFacade;
    @Autowired
    private ResourceService resourceService;
    @Autowired
    private MaterialTypePermissionService materialTypePermissionService;
    @Autowired
    private MaterialTypeService materialTypeService;
    @Value(value="${ossUp.url}")
    private String ossUpUrl;
    @Value(value="${linuxDown.url}")
    private String linuxDownUrl;
    @Value(value="${training.material.product.picture}")
    private String productPicture;

    @Override
    public String selectMaterialProduct(TrainingMaterialVo materialVo, Users user) {
        TrainingMaterial material = (TrainingMaterial)this.materialMapper.selectById(materialVo.getId());
        if (!ObjectUtils.isEmpty((Object)material)) {
            TrainingMaterialType materialType;
            BeanUtils.copyProperties((Object)material, (Object)materialVo);
            if (!StringUtils.isEmpty((Object)material.getMaterialTypeId()) && !ObjectUtils.isEmpty((Object)(materialType = (TrainingMaterialType)this.materialTypeMapper.selectById(material.getMaterialTypeId())))) {
                materialVo.setMaterialTypeName(materialType.getMaterialTypeName());
            }
            LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)wrapper.eq(TrainingMaterialProductPicture::getMaterialId, (Object)materialVo.getId())).orderByAsc(TrainingMaterialProductPicture::getSort);
            List pictureList = this.materialProductPictureMapper.selectList((Wrapper)wrapper);
            ArrayList<TrainingMaterialProductPicture> mainProductPictureList = new ArrayList<TrainingMaterialProductPicture>();
            ArrayList<TrainingMaterialProductPicture> productPictureList = new ArrayList<TrainingMaterialProductPicture>();
            if (!CollectionUtils.isEmpty((Collection)pictureList)) {
                for (TrainingMaterialProductPicture picture : pictureList) {
                    if (picture.getPictureType() == 1) {
                        mainProductPictureList.add(picture);
                        continue;
                    }
                    if (picture.getPictureType() != 2) continue;
                    productPictureList.add(picture);
                }
            }
            materialVo.setProductMainPictureList(mainProductPictureList);
            materialVo.setProductPictureList(productPictureList);
            LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)wrapper1.eq(TrainingMaterialParameter::getMaterialId, (Object)materialVo.getId())).orderByAsc(TrainingMaterialParameter::getSort);
            List parameterList = this.materialParameterMapper.selectList((Wrapper)wrapper1);
            materialVo.setParameterList(parameterList);
        }
        return JsonResult.success((Object)materialVo);
    }

    @Override
    public String insertMaterialProduct(TrainingMaterialVo materialVo, Users user) {
        Locale locale = Authenticator.getInstance().getCurrentClient().getLocale();
        Date now = new Date();
        if (!ObjectUtils.isEmpty((Object)materialVo)) {
            materialVo.setEnterpriseId(user.getGroupId());
            materialVo.setShowName(materialVo.getMaterialName());
            if (!this.IsRepaetProductName(materialVo).booleanValue()) {
                materialVo.setIsCommodity(Integer.valueOf(1));
                materialVo.setShowName(materialVo.getMaterialName());
                materialVo.setFileType(Integer.valueOf(7));
                boolean valid = this.materialPermissionFacade.validMaterialTypeId(user, 3, materialVo.getMaterialTypeId());
                if (!valid) {
                    return JsonResult.error((String)this.messageSource.getMessage("training.material.power.data", null, locale), null);
                }
                materialVo.setCreater(user.getId());
                materialVo.setCreateTime(now);
                materialVo.setUpdater(user.getId());
                materialVo.setUpdateTime(now);
                this.materialMapper.insert(materialVo);
                if (materialVo.getMaterialTypeId() != null) {
                    TrainingMaterialType type = new TrainingMaterialType();
                    type.setId(materialVo.getMaterialTypeId());
                    type.setUpdateTime(now);
                    type.setUpdater(user.getId());
                    this.materialTypeMapper.updateById(type);
                }
                this.materialSinglePermissionService.insertMaterial(materialVo);
                this.saveProductPicture(materialVo, user);
                this.saveProductParameter(materialVo, user);
                List attachList = materialVo.getTrainingMaterialAttachList();
                if (!CollectionUtils.isEmpty((Collection)attachList)) {
                    for (TrainingMaterialAttach attachVo : attachList) {
                        attachVo.setMaterialId(materialVo.getId());
                        attachVo.setEnterpriseId(user.getGroupId());
                        attachVo.setCreateTime(now);
                        this.trainingMaterialAttachMapper.insert(attachVo);
                    }
                }
            } else {
                return JsonResult.error((String)this.messageSource.getMessage("training.material.goods.exist", null, locale), null);
            }
        }
        return JsonResult.success();
    }

    @Override
    public String updateMaterialProduct(TrainingMaterialVo materialVo, Users user) {
        Date now = new Date();
        Locale locale = Authenticator.getInstance().getCurrentClient().getLocale();
        if (!ObjectUtils.isEmpty((Object)materialVo)) {
            materialVo.setEnterpriseId(user.getGroupId());
            materialVo.setUpdateTime(now);
            materialVo.setUpdater(user.getId());
            if (!StringUtils.isEmpty((Object)materialVo.getMaterialName())) {
                materialVo.setShowName(materialVo.getMaterialName());
            }
            TrainingMaterial material = (TrainingMaterial)this.materialMapper.selectById(materialVo.getId());
            Boolean is = true;
            if (!StringUtils.isEmpty((Object)materialVo.getProductCode()) && (StringUtils.isEmpty((Object)material.getProductCode()) || !material.getProductCode().equals(materialVo.getProductCode())) && this.IsRepaetProductName(materialVo).booleanValue()) {
                is = false;
            }
            if (is.booleanValue()) {
                TrainingMaterial trainingMaterial = (TrainingMaterial)this.materialMapper.selectById(materialVo.getId());
                List<Integer> materialTypeIds = Arrays.asList(trainingMaterial.getMaterialTypeId(), materialVo.getMaterialTypeId());
                Set<Integer> validMaterialTypeIdSet = this.materialPermissionFacade.getValidMaterialTypeIdSet(user, 3, materialTypeIds);
                if (!validMaterialTypeIdSet.contains(trainingMaterial.getMaterialTypeId()) || !validMaterialTypeIdSet.contains(materialVo.getMaterialTypeId())) {
                    return JsonResult.error((String)this.messageSource.getMessage("training.material.not.power.data", null, locale), null);
                }
                this.materialMapper.updateById(materialVo);
                this.saveProductPicture(materialVo, user);
                this.saveProductParameter(materialVo, user);
                LambdaUpdateWrapper attachWrapper = new LambdaUpdateWrapper();
                ((LambdaUpdateWrapper)((LambdaUpdateWrapper)attachWrapper.eq(TrainingMaterialAttach::getMaterialId, (Object)materialVo.getId())).eq(TrainingMaterialAttach::getType, (Object)1)).set(TrainingMaterialAttach::getIsDel, (Object)1);
                this.trainingMaterialAttachMapper.update(null, (Wrapper)attachWrapper);
                List attachList = materialVo.getTrainingMaterialAttachList();
                if (!CollectionUtils.isEmpty((Collection)attachList)) {
                    for (TrainingMaterialAttach attachVo : attachList) {
                        attachVo.setMaterialId(materialVo.getId());
                        attachVo.setEnterpriseId(user.getGroupId());
                        attachVo.setCreateTime(now);
                        this.trainingMaterialAttachMapper.insert(attachVo);
                    }
                }
            } else {
                return JsonResult.error((String)this.messageSource.getMessage("training.material.goods.exist", null, locale), null);
            }
        }
        return JsonResult.success();
    }

    @Override
    public void saveProductPicture(TrainingMaterialVo materialVo, Users user) {
        Integer n;
        Integer n2;
        ArrayList<TrainingMaterialProductPicture> pictureList = new ArrayList<TrainingMaterialProductPicture>();
        Integer sort = 1;
        if (!CollectionUtils.isEmpty((Collection)materialVo.getProductMainPictureList())) {
            for (TrainingMaterialProductPicture picture : materialVo.getProductMainPictureList()) {
                picture.setId(null);
                picture.setMaterialId(materialVo.getId());
                picture.setPictureType(Integer.valueOf(1));
                picture.setEnterpriseId(user.getGroupId());
                picture.setCreater(user.getId());
                picture.setCreateTime(new Date());
                picture.setSort(sort);
                n2 = sort;
                n = sort = Integer.valueOf(sort + 1);
                pictureList.add(picture);
            }
        }
        if (!CollectionUtils.isEmpty((Collection)materialVo.getProductPictureList())) {
            for (TrainingMaterialProductPicture picture : materialVo.getProductPictureList()) {
                picture.setId(null);
                picture.setMaterialId(materialVo.getId());
                picture.setPictureType(Integer.valueOf(2));
                picture.setEnterpriseId(user.getGroupId());
                picture.setCreater(user.getId());
                picture.setCreateTime(new Date());
                picture.setSort(sort);
                n2 = sort;
                n = sort = Integer.valueOf(sort + 1);
                pictureList.add(picture);
            }
        }
        LambdaUpdateWrapper wrapper1 = new LambdaUpdateWrapper();
        wrapper1.eq(TrainingMaterialProductPicture::getMaterialId, (Object)materialVo.getId());
        this.materialProductPictureMapper.delete((Wrapper)wrapper1);
        if (!CollectionUtils.isEmpty(pictureList)) {
            this.materialProductPictureMapper.insertList(pictureList);
        }
    }

    @Override
    public void saveProductParameter(TrainingMaterialVo materialVo, Users user) {
        ArrayList<TrainingMaterialParameter> parameterList = new ArrayList<TrainingMaterialParameter>();
        Integer sort = 1;
        if (!CollectionUtils.isEmpty((Collection)materialVo.getParameterList())) {
            for (TrainingMaterialParameter parameter : materialVo.getParameterList()) {
                parameter.setId(null);
                parameter.setMaterialId(materialVo.getId());
                parameter.setEnterpriseId(user.getGroupId());
                parameter.setCreater(user.getId());
                parameter.setCreateTime(new Date());
                parameter.setSort(sort);
                Integer n = sort;
                Integer n2 = sort = Integer.valueOf(sort + 1);
                parameterList.add(parameter);
            }
        }
        LambdaUpdateWrapper wrapper2 = new LambdaUpdateWrapper();
        wrapper2.eq(TrainingMaterialParameter::getMaterialId, (Object)materialVo.getId());
        this.materialParameterMapper.delete((Wrapper)wrapper2);
        if (!CollectionUtils.isEmpty(parameterList)) {
            this.materialParameterMapper.insertList(parameterList);
        }
    }

    @Override
    public String delMaterial(List<TrainingMaterial> materialList, Users user) {
        String isNum = "0";
        if (!CollectionUtils.isEmpty(materialList)) {
            ArrayList<Integer> intList = new ArrayList<Integer>();
            intList.add(2);
            intList.add(3);
            List<Integer> materialIds = materialList.stream().map(TrainingMaterial::getId).collect(Collectors.toList());
            Set<Integer> validMaterialTypeIdSet = this.materialPermissionFacade.getValidMaterialTypeIdSet(user, 3, materialIds);
            ArrayList<Integer> materialIdList = new ArrayList<Integer>();
            materialList = this.materialMapper.selectBatchIds(materialIds);
            for (TrainingMaterial material : materialList) {
                if (validMaterialTypeIdSet.contains(material.getMaterialTypeId())) {
                    materialIdList.add(material.getId());
                    continue;
                }
                isNum = "1";
            }
            if (!CollectionUtils.isEmpty(materialIdList)) {
                TrainingMaterial material;
                LambdaUpdateWrapper wrapper1 = new LambdaUpdateWrapper();
                wrapper1.in(TrainingMaterial::getId, materialIdList);
                material = new TrainingMaterial();
                material.setIsDel(Integer.valueOf(1));
                material.setUpdateTime(new Date());
                material.setUpdater(user.getId());
                this.materialMapper.update(material, (Wrapper)wrapper1);
                LambdaUpdateWrapper wrapper2 = new LambdaUpdateWrapper();
                wrapper2.in(TrainingAndMaterial::getMaterialId, materialIdList);
                this.andMaterialMapper.delete((Wrapper)wrapper2);
            }
        }
        if ("1".equals(isNum)) {
            Locale locale = Authenticator.getInstance().getCurrentClient().getLocale();
            return JsonResult.error((String)this.messageSource.getMessage("training.material.not.power.delete", null, locale), null);
        }
        return JsonResult.success();
    }

    @Override
    public Map<String, List> importMaterialType(MultipartFile file, Users user) {
        Locale locale = Authenticator.getInstance().getCurrentClient().getLocale();
        HashMap<String, List> result = new HashMap<String, List>();
        ArrayList<TrainingMaterialTypeVo> errorTypeList = new ArrayList<TrainingMaterialTypeVo>();
        try {
            Boolean isError = true;
            if (file.getOriginalFilename().substring(file.getOriginalFilename().lastIndexOf(".") + 1).equals("xlsx")) {
                isError = false;
            }
            if (isError.booleanValue()) {
                TrainingMaterialTypeVo vo = new TrainingMaterialTypeVo();
                String typeError = this.messageSource.getMessage("training.material.type.error", null, locale);
                vo.setRemark(typeError);
                errorTypeList.add(vo);
                result.put("errorTypeList", errorTypeList);
                return result;
            }
            List<List<Object>> excelList = ExcelUtil.getBankListByExcel1(file.getInputStream(), file.getOriginalFilename(), 0);
            isError = true;
            if (!(CollectionUtils.isEmpty(excelList) || CollectionUtils.isEmpty((Collection)excelList.get(1)) || StringUtils.isEmpty((Object)excelList.get(1).get(0)) || !excelList.get(1).get(0).toString().trim().equals("\u4e00\u7ea7\u5206\u7c7b") || CollectionUtils.isEmpty((Collection)excelList.get(1)) || StringUtils.isEmpty((Object)excelList.get(1).get(3)) || !excelList.get(1).get(3).toString().trim().equals("\u56db\u7ea7\u5206\u7c7b"))) {
                isError = false;
            }
            if (isError.booleanValue()) {
                TrainingMaterialTypeVo vo = new TrainingMaterialTypeVo();
                String typeError = this.messageSource.getMessage("training.material.type.error", null, locale);
                vo.setRemark(typeError);
                errorTypeList.add(vo);
                result.put("errorTypeList", errorTypeList);
                return result;
            }
            int questionNum = excelList.size() - 2;
            if (questionNum < 1) {
                TrainingMaterialTypeVo vo = new TrainingMaterialTypeVo();
                String noData = this.messageSource.getMessage("training.material.type.nodata", null, locale);
                vo.setRemark(noData);
                errorTypeList.add(vo);
                result.put("errorTypeList", errorTypeList);
                return result;
            }
            if (questionNum > 1000) {
                TrainingMaterialTypeVo vo = new TrainingMaterialTypeVo();
                String tooMore = this.messageSource.getMessage("training.material.type.toomore", null, locale);
                vo.setRemark(tooMore);
                errorTypeList.add(vo);
                result.put("errorTypeList", errorTypeList);
                return result;
            }
            Integer levelId1 = null;
            Integer levelId2 = null;
            Integer levelId3 = null;
            Integer levelId4 = null;
            for (int i = 2; i < excelList.size(); ++i) {
                List<Object> list = excelList.get(i);
                if (!CollectionUtils.isEmpty(list)) {
                    for (int j = 0; j < list.size(); ++j) {
                        TrainingMaterialTypeVo vo = new TrainingMaterialTypeVo();
                        vo.setRowNum(Integer.valueOf(i + 1));
                        vo.setMaterialTypeLevel(Integer.valueOf(j + 1));
                        vo.setModuleType(Integer.valueOf(1));
                        vo.setEnterpriseId(user.getGroupId());
                        if (!StringUtils.isEmpty((Object)list.get(j)) && j < 5) {
                            String typeName = list.get(j).toString();
                            LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
                            ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper1.eq(TrainingMaterialType::getEnterpriseId, (Object)user.getGroupId())).eq(TrainingMaterialType::getMaterialTypeLevel, (Object)(j + 1))).eq(TrainingMaterialType::getMaterialTypeName, (Object)typeName)).eq(TrainingMaterialType::getModuleType, (Object)1);
                            if (j == 1 && levelId1 != null) {
                                ((LambdaQueryWrapper)wrapper1.eq(TrainingMaterialType::getSourceId, levelId1)).eq(TrainingMaterialType::getOriginId, levelId1);
                            } else if (j == 2 && levelId1 != null && levelId2 != null) {
                                ((LambdaQueryWrapper)wrapper1.eq(TrainingMaterialType::getSourceId, levelId2)).eq(TrainingMaterialType::getOriginId, levelId1);
                            } else if (j == 3 && levelId1 != null && levelId3 != null) {
                                ((LambdaQueryWrapper)wrapper1.eq(TrainingMaterialType::getSourceId, levelId3)).eq(TrainingMaterialType::getOriginId, levelId1);
                            } else if (j == 4 && levelId1 != null && levelId4 != null) {
                                ((LambdaQueryWrapper)wrapper1.eq(TrainingMaterialType::getSourceId, levelId4)).eq(TrainingMaterialType::getOriginId, levelId1);
                            }
                            wrapper1.orderByDesc(TrainingMaterialType::getId);
                            List materialTypeList = this.materialTypeMapper.selectList((Wrapper)wrapper1);
                            if (CollectionUtils.isEmpty((Collection)materialTypeList)) {
                                String noUpClassify;
                                vo.setMaterialTypeName(typeName);
                                vo.setCreater(user.getId());
                                vo.setCreateTime(new Date());
                                vo.setUpdateTime(new Date());
                                vo.setUpdater(user.getId());
                                if (j == 0) {
                                    levelId1 = this.insertMaterialType((TrainingMaterialType)vo);
                                    continue;
                                }
                                if (j == 1) {
                                    if (levelId1 != null) {
                                        vo.setSourceId(levelId1);
                                        vo.setOriginId(levelId1);
                                        levelId2 = this.insertMaterialType((TrainingMaterialType)vo);
                                        continue;
                                    }
                                    String noclassify = this.messageSource.getMessage("training.material.no.lassify", null, locale);
                                    vo.setRemark(noclassify);
                                    errorTypeList.add(vo);
                                    continue;
                                }
                                if (j == 2) {
                                    if (levelId1 != null && levelId2 != null) {
                                        vo.setSourceId(levelId2);
                                        vo.setOriginId(levelId1);
                                        levelId3 = this.insertMaterialType((TrainingMaterialType)vo);
                                        continue;
                                    }
                                    noUpClassify = this.messageSource.getMessage("training.material.no.upClassify", null, locale);
                                    vo.setRemark(noUpClassify);
                                    errorTypeList.add(vo);
                                    continue;
                                }
                                if (j == 3) {
                                    if (levelId1 != null && levelId3 != null) {
                                        vo.setSourceId(levelId3);
                                        vo.setOriginId(levelId1);
                                        levelId4 = this.insertMaterialType((TrainingMaterialType)vo);
                                        continue;
                                    }
                                    noUpClassify = this.messageSource.getMessage("training.material.no.upClassify", null, locale);
                                    vo.setRemark(noUpClassify);
                                    errorTypeList.add(vo);
                                    continue;
                                }
                                if (j != 4) continue;
                                if (levelId1 != null && levelId4 != null) {
                                    vo.setSourceId(levelId4);
                                    vo.setOriginId(levelId1);
                                    this.insertMaterialType((TrainingMaterialType)vo);
                                    continue;
                                }
                                noUpClassify = this.messageSource.getMessage("training.material.no.upClassify", null, locale);
                                vo.setRemark(noUpClassify);
                                errorTypeList.add(vo);
                                continue;
                            }
                            if (j == 0) {
                                levelId1 = ((TrainingMaterialType)materialTypeList.get(0)).getId();
                                continue;
                            }
                            if (j == 1) {
                                levelId2 = ((TrainingMaterialType)materialTypeList.get(0)).getId();
                                continue;
                            }
                            if (j == 2) {
                                levelId3 = ((TrainingMaterialType)materialTypeList.get(0)).getId();
                                continue;
                            }
                            if (j != 3) continue;
                            levelId4 = ((TrainingMaterialType)materialTypeList.get(0)).getId();
                            continue;
                        }
                        if (i != 2 || j != 0) continue;
                        String noUpClassify = this.messageSource.getMessage("training.material.no.lassify", null, locale);
                        vo.setRemark(noUpClassify);
                        errorTypeList.add(vo);
                    }
                    if (list.size() == 1) {
                        levelId2 = null;
                        levelId3 = null;
                        levelId4 = null;
                        continue;
                    }
                    if (list.size() == 2) {
                        levelId3 = null;
                        levelId4 = null;
                        continue;
                    }
                    if (list.size() != 3) continue;
                    levelId4 = null;
                    continue;
                }
                levelId1 = null;
                levelId2 = null;
                levelId3 = null;
                levelId4 = null;
            }
        }
        catch (Exception e) {
            log.error("\u8bd5\u9898\u6a21\u677f\u5bfc\u5165", (Throwable)e);
            TrainingMaterialTypeVo vo = new TrainingMaterialTypeVo();
            String typeError = this.messageSource.getMessage("training.material.type.error", null, locale);
            vo.setRemark(typeError);
            errorTypeList.add(vo);
        }
        result.put("errorTypeList", errorTypeList);
        return result;
    }

    public Integer insertMaterialType(TrainingMaterialType materialType) {
        List<TrainingMaterialType> levelList = this.materialTypeMapper.selectMaterialTypeByLevel(materialType);
        if (!CollectionUtils.isEmpty(levelList)) {
            TrainingMaterialType level = levelList.get(0);
            Integer sort = level.getSort() != null ? level.getSort() + 1 : 0;
            materialType.setSort(sort);
        }
        this.materialTypeMapper.insert(materialType);
        this.materialTypePermissionService.onMaterialTypeCreate(materialType);
        return materialType.getId();
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    @Override
    public Map<String, List<TrainingMaterialVo>> importMaterialProduct(MultipartFile file, Users user) {
        locale = Authenticator.getInstance().getCurrentClient().getLocale();
        result = new HashMap<String, List<TrainingMaterialVo>>();
        errorTypeList = new ArrayList<TrainingMaterialVo>();
        try {
            isError = true;
            if (file.getOriginalFilename().substring(file.getOriginalFilename().lastIndexOf(".") + 1).equals("xlsx")) {
                isError = false;
            }
            if (isError) {
                vo = new TrainingMaterialVo();
                typeError = this.messageSource.getMessage("training.material.type.error", null, locale);
                vo.setRemark(typeError);
                errorTypeList.add(vo);
                result.put("errorTypeList", errorTypeList);
                return result;
            }
            excelList = ExcelUtil.getBankListByExcel(file.getInputStream(), file.getOriginalFilename(), 0);
            if (!CollectionUtils.isEmpty(excelList) && !CollectionUtils.isEmpty((Collection)excelList.get(1)) && !StringUtils.isEmpty((Object)excelList.get(1).get(0)) && excelList.get(1).get(0).toString().trim().equals("\u5546\u54c1\u540d\u79f0\uff08\u5fc5\u586b\uff09") && !StringUtils.isEmpty((Object)excelList.get(1).get(3)) && excelList.get(1).get(3).toString().trim().equals("\u5206\u7c7b")) {
                isError = false;
            }
            if (isError) {
                vo = new TrainingMaterialVo();
                typeError = this.messageSource.getMessage("training.material.type.error", null, locale);
                vo.setRemark(typeError);
                errorTypeList.add(vo);
                result.put("errorTypeList", errorTypeList);
                return result;
            }
            questionNum = excelList.size() - 3;
            if (questionNum < 1) {
                vo = new TrainingMaterialVo();
                nodata = this.messageSource.getMessage("training.material.type.nodata", null, locale);
                vo.setRemark(nodata);
                errorTypeList.add(vo);
                result.put("errorTypeList", errorTypeList);
                return result;
            }
            if (questionNum > 10000) {
                vo = new TrainingMaterialVo();
                toomore = this.messageSource.getMessage("training.material.type.toomore", null, locale);
                vo.setRemark(toomore);
                errorTypeList.add(vo);
                result.put("errorTypeList", errorTypeList);
                return result;
            }
            picturesMap = ExcelUtil.getRowPictures(file.getOriginalFilename(), file.getInputStream());
            wrapper2 = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper2.eq((Object)(SFunction & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getEnterpriseId(), (Lcom/ovopark/training/model/TrainingMaterial;)Ljava/lang/Object;)(), (Object)user.getGroupId())).eq((Object)(SFunction & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getIsCommodity(), (Lcom/ovopark/training/model/TrainingMaterial;)Ljava/lang/Object;)(), (Object)1)).eq((Object)(SFunction & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getIsDel(), (Lcom/ovopark/training/model/TrainingMaterial;)Ljava/lang/Object;)(), (Object)0)).isNotNull((Object)(SFunction & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getProductCode(), (Lcom/ovopark/training/model/TrainingMaterial;)Ljava/lang/Object;)())).ne((Object)(SFunction & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getProductCode(), (Lcom/ovopark/training/model/TrainingMaterial;)Ljava/lang/Object;)(), (Object)"");
            materialNames = this.materialMapper.selectList((Wrapper)wrapper2);
            materialNameMap = new HashMap<K, V>();
            if (!CollectionUtils.isEmpty((Collection)materialNames)) {
                materialNameMap = materialNames.stream().collect(Collectors.groupingBy((Function<TrainingMaterial, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getProductCode(), (Lcom/ovopark/training/model/TrainingMaterial;)Ljava/lang/String;)()));
            }
            typeNameMap = this.selectMaterialTypeMap(user);
            productCodeList = new ArrayList<String>();
            pictureList = new ArrayList<E>();
            parameterList = new ArrayList<E>();
            list1 = new ArrayList<HashMap<K, V>>();
            list2 = new ArrayList<HashMap<K, V>>();
            materialTypeIds = this.materialTypeService.getMaterialTypeByUserPowerV2(user, 1, 1);
            for (i = 3; i < excelList.size(); ++i) {
                block58: {
                    block57: {
                        list = excelList.get(i);
                        if (CollectionUtils.isEmpty(list)) continue;
                        vo = new TrainingMaterialVo();
                        vo.setRowNum(Integer.valueOf(i + 1));
                        vo.setEnterpriseId(user.getGroupId());
                        if (!StringUtils.isEmpty((Object)list.get(0))) {
                            if (list.get(0).toString().trim().length() > 100) {
                                nameTooMore = this.messageSource.getMessage("training.material.goods.name.toomore", null, locale);
                                vo.setRemark(nameTooMore);
                                errorTypeList.add(vo);
                                continue;
                            }
                        } else {
                            list10 = list.stream().filter((Predicate<Object>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$importMaterialProduct$0(java.lang.Object ), (Ljava/lang/Object;)Z)()).collect(Collectors.toList());
                            if (!CollectionUtils.isEmpty(list10)) continue;
                            noName = this.messageSource.getMessage("training.material.goods.no.name", null, locale);
                            vo.setRemark(noName);
                            errorTypeList.add(vo);
                            continue;
                        }
                        vo.setMaterialName(list.get(0).toString().trim());
                        if (list.size() <= 1 || StringUtils.isEmpty((Object)list.get(1))) break block57;
                        if (!this.IsStr(list.get(1).toString().trim()).booleanValue()) ** GOTO lbl110
                        if (list.get(1).toString().trim().length() <= 20) {
                            vo.setProductCode(list.get(1).toString().trim());
                            materialList = (List)materialNameMap.get(vo.getProductCode());
                            if (!CollectionUtils.isEmpty((Collection)materialList)) {
                                goodsExist = this.messageSource.getMessage("training.material.goods.exist", null, locale);
                                vo.setRemark(goodsExist);
                                errorTypeList.add(vo);
                                continue;
                            }
                            if (!CollectionUtils.isEmpty(productCodeList) && productCodeList.contains(vo.getProductCode())) {
                                goodsExist = this.messageSource.getMessage("training.material.goods.exist", null, locale);
                                vo.setRemark(goodsExist);
                                errorTypeList.add(vo);
                                continue;
                            }
                            productCodeList.add(vo.getProductCode());
                        } else {
                            nameTooMore = this.messageSource.getMessage("training.material.goods.name.toomore", null, locale);
                            vo.setRemark(nameTooMore);
                            errorTypeList.add(vo);
                            continue;
lbl110:
                            // 1 sources

                            nameError = this.messageSource.getMessage("training.material.goods.name.error", null, locale);
                            vo.setRemark(nameError);
                            errorTypeList.add(vo);
                            continue;
                        }
                    }
                    if (list.size() <= 2 || StringUtils.isEmpty((Object)list.get(2))) break block58;
                    code = list.get(2).toString().trim().replaceAll("\uff0c", ",");
                    if (!this.IsIntegerNumber(code).booleanValue()) ** GOTO lbl138
                    strs = code.split(",");
                    if (strs.length <= 10) {
                        x = false;
                        for (Object str : strs) {
                            if (str.length() <= 20) continue;
                            codeTooMore = this.messageSource.getMessage("training.material.goods.code.name.toomore", null, locale);
                            vo.setRemark(codeTooMore);
                            errorTypeList.add(vo);
                            x = true;
                            break;
                        }
                        if (x) continue;
                        vo.setBarCode(code);
                    } else {
                        codeTooMore = this.messageSource.getMessage("training.material.goods.code.toomore", null, locale);
                        vo.setRemark(codeTooMore);
                        errorTypeList.add(vo);
                        continue;
lbl138:
                        // 1 sources

                        codeError = this.messageSource.getMessage("training.material.goods.code.error", null, locale);
                        vo.setRemark(codeError);
                        errorTypeList.add(vo);
                        continue;
                    }
                }
                typeIds = null;
                if (list.size() <= 3 || StringUtils.isEmpty((Object)list.get(3)) || StringUtils.isEmpty((Object)list.get(3).toString().trim())) ** GOTO lbl160
                typeId = typeNameMap.get(list.get(3).toString().trim());
                if (!StringUtils.isEmpty((Object)typeId)) {
                    if (CollectionUtils.isEmpty(materialTypeIds) || !materialTypeIds.contains(typeId)) {
                        noType = this.messageSource.getMessage("training.material.not.power.data", null, locale);
                        vo.setRemark(noType);
                        errorTypeList.add(vo);
                        continue;
                    }
                } else {
                    noType = this.messageSource.getMessage("training.material.no.type", null, locale);
                    vo.setRemark(noType);
                    errorTypeList.add(vo);
                    continue;
lbl160:
                    // 1 sources

                    noType = this.messageSource.getMessage("training.material.type.no.fill", null, locale);
                    vo.setRemark(noType);
                    errorTypeList.add(vo);
                    continue;
                }
                typeIds = typeId;
                vo.setMaterialTypeId(typeIds);
                if (list.size() > 4 && !StringUtils.isEmpty((Object)list.get(4))) {
                    if (list.get(4).toString().trim().length() <= 1000) {
                        vo.setDescription(list.get(4).toString().trim());
                    } else {
                        describeTooMore = this.messageSource.getMessage("training.material.describe.toomore", null, locale);
                        vo.setRemark(describeTooMore);
                        errorTypeList.add(vo);
                        continue;
                    }
                }
                finish = 30;
                if (list.size() > 7 && !StringUtils.isEmpty((Object)list.get(7))) {
                    finishTime = list.get(7).toString();
                    if (finishTime.contains("\u5206")) {
                        str1 = finishTime.split("\u5206");
                        num1 = Integer.parseInt(str1[0]);
                        num2 = 0;
                        if (str1.length > 1) {
                            num2 = Integer.parseInt(str1[1].substring(0, str1[1].length() - 1));
                        }
                        finish = num1 * 60 + num2;
                    } else if (finishTime.contains(this.messageSource.getMessage("training.paper.time.second", null, locale))) {
                        str1 = finishTime.split(this.messageSource.getMessage("training.paper.time.second", null, locale));
                        if (str1.length == 1) {
                            finish = Integer.parseInt(str1[0]);
                        }
                    } else if (finishTime.contains(":")) {
                        str1 = finishTime.split(":");
                        if (str1.length > 1) {
                            finish = Integer.parseInt(str1[0]) * 60 + Integer.parseInt(str1[1]);
                        }
                    } else if (finishTime.contains("\uff1a") && (str1 = finishTime.split("\uff1a")).length > 1) {
                        finish = Integer.parseInt(str1[0]) * 60 + Integer.parseInt(str1[1]);
                    }
                }
                vo.setShowName(vo.getMaterialName());
                vo.setFinishTime(Integer.valueOf(finish));
                vo.setEnterpriseId(user.getGroupId());
                vo.setCreater(user.getId());
                vo.setCreateTime(new Date());
                vo.setUpdater(user.getId());
                vo.setUpdateTime(new Date());
                vo.setIsCommodity(Integer.valueOf(1));
                vo.setIsComment(Integer.valueOf(1));
                vo.setFileType(Integer.valueOf(7));
                vo.setCoverType(Integer.valueOf(3));
                vo.setCoverUrl(this.productPicture);
                this.materialMapper.insert(vo);
                parts = new ArrayList<TrainingMaterialProductPicture>();
                sort1 = 1;
                if (list.size() > 5 && !StringUtils.isEmpty((Object)list.get(5))) {
                    urlStr = list.get(5).toString().trim().replace("\uff1b", ";");
                    urlStrs = urlStr.split(";");
                    str = urlStrs;
                    codeTooMore = ((String[])str).length;
                    for (var31_63 = 0; var31_63 < codeTooMore; ++var31_63) {
                        path = str[var31_63];
                        if (sort1 > 5) break;
                        fileName = path.trim().substring(path.trim().lastIndexOf("/") + 1);
                        imagePath = OssHelper.getImagePath(fileName, StorageModule.TRAINING);
                        url = this.ossUpUrl + imagePath;
                        picture = new TrainingMaterialProductPicture();
                        picture.setMaterialId(vo.getId());
                        picture.setPictureType(Integer.valueOf(1));
                        picture.setCreater(user.getId());
                        picture.setCreateTime(new Date());
                        picture.setEnterpriseId(user.getGroupId());
                        picture.setUrl(url);
                        picture.setSort(Integer.valueOf(sort1));
                        parts.add(picture);
                        ++sort1;
                        map = new HashMap<String, String>();
                        map.put("srcPath", path.trim());
                        map.put("fileName", fileName);
                        map.put("imagePath", imagePath);
                        list1.add(map);
                    }
                }
                if (!CollectionUtils.isEmpty(pictureDataList1 = picturesMap.get(key1 = i + "-5"))) {
                    str = pictureDataList1.iterator();
                    while (str.hasNext()) {
                        item = (PictureData)str.next();
                        if (sort1 > 5) break;
                        fileName = OssHelper.genImageName("." + item.suggestFileExtension());
                        imagePath = OssHelper.getImagePath(fileName, StorageModule.TRAINING);
                        url = this.ossUpUrl + (String)imagePath;
                        picture = new TrainingMaterialProductPicture();
                        picture.setMaterialId(vo.getId());
                        picture.setPictureType(Integer.valueOf(1));
                        picture.setCreater(user.getId());
                        picture.setCreateTime(new Date());
                        picture.setEnterpriseId(user.getGroupId());
                        picture.setUrl(url);
                        picture.setSort(Integer.valueOf(sort1));
                        parts.add(picture);
                        ++sort1;
                        map = new HashMap<String, Object>();
                        map.put("srcPath", item);
                        map.put("fileName", fileName);
                        map.put("imagePath", imagePath);
                        list2.add(map);
                    }
                }
                sort2 = 1;
                if (list.size() > 6 && !StringUtils.isEmpty((Object)list.get(6))) {
                    urlStr = list.get(6).toString().trim().replace("\uff1b", ";");
                    urlStrs = urlStr.split(";");
                    for (String path : urlStrs) {
                        fileName = path.trim().substring(path.trim().lastIndexOf("/") + 1);
                        imagePath = OssHelper.getImagePath(fileName, StorageModule.TRAINING);
                        url = this.ossUpUrl + imagePath;
                        picture = new TrainingMaterialProductPicture();
                        picture.setMaterialId(vo.getId());
                        picture.setPictureType(Integer.valueOf(2));
                        picture.setCreater(user.getId());
                        picture.setCreateTime(new Date());
                        picture.setEnterpriseId(user.getGroupId());
                        picture.setUrl((String)url);
                        picture.setSort(sort2);
                        parts.add(picture);
                        var40_82 = sort2;
                        var41_83 = sort2 = Integer.valueOf(sort2 + 1);
                        map = new HashMap<String, String>();
                        map.put("srcPath", path.trim());
                        map.put("fileName", fileName);
                        map.put("imagePath", imagePath);
                        list1.add(map);
                    }
                }
                if (!CollectionUtils.isEmpty(pictureDataList2 = picturesMap.get(key2 = i + "-6"))) {
                    for (PictureData item : pictureDataList2) {
                        fileName = OssHelper.genImageName("." + item.suggestFileExtension());
                        imagePath = OssHelper.getImagePath(fileName, StorageModule.TRAINING);
                        url = this.ossUpUrl + imagePath;
                        picture = new TrainingMaterialProductPicture();
                        picture.setMaterialId(vo.getId());
                        picture.setPictureType(Integer.valueOf(2));
                        picture.setCreater(user.getId());
                        picture.setCreateTime(new Date());
                        picture.setEnterpriseId(user.getGroupId());
                        picture.setUrl(url);
                        picture.setSort(sort2);
                        parts.add(picture);
                        url = sort2;
                        var39_81 = sort2 = Integer.valueOf(sort2 + 1);
                        map = new HashMap<String, Object>();
                        map.put("srcPath", item);
                        map.put("fileName", fileName);
                        map.put("imagePath", imagePath);
                        list2.add(map);
                    }
                }
                partList = new ArrayList<TrainingMaterialParameter>();
                is = true;
                if (excelList.get(1).size() > 8) {
                    sort = 1;
                    for (j = 8; j < excelList.get(1).size(); ++j) {
                        if (list.size() <= j || StringUtils.isEmpty((Object)list.get(j)) || StringUtils.isEmpty((Object)excelList.get(1).get(j))) continue;
                        if (sort > 20) break;
                        if (excelList.get(1).get(j).toString().length() > 10) {
                            nameTooMore = this.messageSource.getMessage("training.material.name.toomore", null, locale);
                            vo.setRemark(nameTooMore);
                            errorTypeList.add(vo);
                            is = false;
                            break;
                        }
                        if (list.get(j).toString().length() > 500) {
                            contentTooMore = this.messageSource.getMessage("training.material.content.toomore", null, locale);
                            vo.setRemark(contentTooMore);
                            errorTypeList.add(vo);
                            is = false;
                            break;
                        }
                        parameter = new TrainingMaterialParameter();
                        parameter.setMaterialId(vo.getId());
                        parameter.setParameterName(excelList.get(1).get(j).toString());
                        parameter.setParameterValue(list.get(j).toString());
                        parameter.setSort(Integer.valueOf(sort));
                        parameter.setIsTop(Integer.valueOf(0));
                        parameter.setCreater(user.getId());
                        parameter.setCreateTime(new Date());
                        parameter.setEnterpriseId(user.getGroupId());
                        partList.add(parameter);
                        ++sort;
                    }
                }
                if (is) {
                    if (!CollectionUtils.isEmpty(parts)) {
                        pictureList.addAll(parts);
                    }
                    if (!CollectionUtils.isEmpty(partList)) {
                        parameterList.addAll(partList);
                    }
                    this.materialSinglePermissionService.resetTypePermissionByMaterialIdList(Lists.newArrayList((Object[])new Integer[]{vo.getId()}));
                    trainingResource = new TrainingResource();
                    trainingResource.setObjectId(vo.getId());
                    this.saveResourceContent(trainingResource, vo);
                    this.resourceService.addResource(trainingResource, user);
                    continue;
                }
                wrapper1 = new LambdaUpdateWrapper();
                ((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)wrapper1.eq((Object)(SFunction & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getId(), (Lcom/ovopark/training/model/TrainingMaterial;)Ljava/lang/Object;)(), (Object)vo.getId())).set((Object)(SFunction & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getIsDel(), (Lcom/ovopark/training/model/TrainingMaterial;)Ljava/lang/Object;)(), (Object)1)).set((Object)(SFunction & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getUpdater(), (Lcom/ovopark/training/model/TrainingMaterial;)Ljava/lang/Object;)(), (Object)user.getId())).set((Object)(SFunction & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getUpdateTime(), (Lcom/ovopark/training/model/TrainingMaterial;)Ljava/lang/Object;)(), (Object)new Date());
                this.materialMapper.update(null, (Wrapper)wrapper1);
            }
            if (!CollectionUtils.isEmpty(pictureList)) {
                splistList1 = ListUtil.splistList(pictureList, 500);
                for (List<TrainingMaterialProductPicture> pictures : splistList1) {
                    this.materialProductPictureMapper.insertList(pictures);
                }
                if (!CollectionUtils.isEmpty(list1) || !CollectionUtils.isEmpty(list2)) {
                    CommonUtil.handleTask(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                if (!CollectionUtils.isEmpty((Collection)list1)) {
                                    OssHelper.pushUpFileList(list1);
                                }
                                if (!CollectionUtils.isEmpty((Collection)list2)) {
                                    OssHelper.pushFileList(list2);
                                }
                            }
                            catch (Exception e) {
                                log.error("\u56fe\u7247\u4e0a\u4f20", (Throwable)e);
                            }
                        }
                    });
                }
            }
            if (!CollectionUtils.isEmpty(parameterList)) {
                splistList2 = ListUtil.splistList(parameterList, 500);
                for (List<TrainingMaterialParameter> parameters : splistList2) {
                    this.materialParameterMapper.insertList(parameters);
                }
            }
        }
        catch (Exception e) {
            TrainingMaterialProductServiceImpl.log.error("\u8bd5\u9898\u6a21\u677f\u5bfc\u5165", (Throwable)e);
            vo = new TrainingMaterialVo();
            typeError = this.messageSource.getMessage("training.material.type.error", null, locale);
            vo.setRemark(typeError);
            errorTypeList.add(vo);
        }
        result.put("errorTypeList", errorTypeList);
        return result;
    }

    private void saveResourceContent(TrainingResource trainingResource, TrainingMaterialVo material) {
        trainingResource.setShowName(material.getMaterialName());
        trainingResource.setFileType(material.getFileType());
        trainingResource.setTypeId(material.getMaterialTypeId());
        trainingResource.setCoverType(material.getCoverType());
        trainingResource.setCoverUrl(material.getCoverUrl());
        trainingResource.setIsShow(material.getIsShow());
        trainingResource.setReadType(material.getReadType());
        trainingResource.setShareable(material.getShareable());
        trainingResource.setIsVisitorShare(Integer.valueOf(1));
        trainingResource.setIsDownload(material.getIsDownload());
        trainingResource.setDownloadType(material.getDownloadType());
        trainingResource.setVersion(material.getVersion());
        trainingResource.setIsComment(material.getIsComment());
        trainingResource.setIntroduction(material.getIntroduction());
    }

    public Boolean IsRepaetProductName(TrainingMaterialVo vo) {
        boolean is = false;
        if (!StringUtils.isEmpty((Object)vo.getProductCode())) {
            LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(TrainingMaterial::getProductCode, (Object)vo.getProductCode())).eq(TrainingMaterial::getEnterpriseId, (Object)vo.getEnterpriseId())).eq(TrainingMaterial::getIsCommodity, (Object)1)).eq(TrainingMaterial::getIsDel, (Object)0);
            List materials = this.materialMapper.selectList((Wrapper)wrapper);
            if (!CollectionUtils.isEmpty((Collection)materials)) {
                is = true;
            }
        }
        return is;
    }

    public Boolean IsIntegerNumber(String str) {
        String[] list;
        Boolean is = true;
        for (String vo : list = str.trim().split(",")) {
            if (vo.trim().matches("[0-9]*")) continue;
            is = false;
            break;
        }
        return is;
    }

    public Boolean IsStr(String str) {
        String[] list;
        Boolean is = true;
        for (String vo : list = str.trim().split(",")) {
            if (vo.trim().matches("[a-zA-Z0-9]*")) continue;
            is = false;
            break;
        }
        return is;
    }

    public Map<String, Integer> selectMaterialTypeMap(Users user) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        try {
            LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper1.eq(TrainingMaterialType::getEnterpriseId, (Object)user.getGroupId())).eq(TrainingMaterialType::getModuleType, (Object)1)).orderByAsc(TrainingMaterialType::getMaterialTypeLevel);
            List typeList = this.materialTypeMapper.selectList((Wrapper)wrapper1);
            if (!CollectionUtils.isEmpty((Collection)typeList)) {
                Map<Integer, List<TrainingMaterialType>> levelTypeMap = typeList.stream().collect(Collectors.groupingBy(TrainingMaterialType::getMaterialTypeLevel));
                HashMap<Integer, String> typeNameMap = new HashMap<Integer, String>();
                for (int i = 1; i < 6; ++i) {
                    List<TrainingMaterialType> levelList = levelTypeMap.get(i);
                    if (CollectionUtils.isEmpty(levelList)) continue;
                    for (TrainingMaterialType type : levelList) {
                        String sourceName = StringUtils.isEmpty((Object)type.getSourceId()) || StringUtils.isEmpty(typeNameMap.get(type.getSourceId())) ? "" : (String)typeNameMap.get(type.getSourceId());
                        typeNameMap.put(type.getId(), sourceName + (StringUtils.isEmpty((Object)sourceName) ? "" : "/") + type.getMaterialTypeName());
                        map.put(sourceName + (StringUtils.isEmpty((Object)sourceName) ? "" : "/") + type.getMaterialTypeName(), type.getId());
                    }
                }
            }
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u7d20\u6750\u7c7b\u578b\u540d\u79f0\u6821\u9a8c\u96c6\u5408", (Throwable)e);
        }
        return map;
    }

    public Integer selectMaterialTypeIdByName(String strs, Users user) {
        Integer typeId;
        block11: {
            typeId = null;
            try {
                String[] data = strs.split("/");
                String materialName1 = data[data.length - 1];
                LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper1.eq(TrainingMaterialType::getEnterpriseId, (Object)user.getGroupId())).eq(TrainingMaterialType::getMaterialTypeName, (Object)materialName1)).eq(TrainingMaterialType::getMaterialTypeLevel, (Object)data.length)).eq(TrainingMaterialType::getModuleType, (Object)1)).orderByDesc(TrainingMaterialType::getId);
                List typeList = this.materialTypeMapper.selectList((Wrapper)wrapper1);
                if (CollectionUtils.isEmpty((Collection)typeList)) break block11;
                for (TrainingMaterialType materialType : typeList) {
                    if (StringUtils.isEmpty((Object)materialType.getSourceId())) {
                        typeId = materialType.getId();
                    } else {
                        TrainingMaterialType type1 = (TrainingMaterialType)this.materialTypeMapper.selectById(materialType.getSourceId());
                        if (StringUtils.isEmpty((Object)type1) || data.length <= 1 || StringUtils.isEmpty((Object)data[data.length - 2]) || !type1.getMaterialTypeName().equals(data[data.length - 2])) continue;
                        if (StringUtils.isEmpty((Object)type1.getSourceId())) {
                            typeId = materialType.getId();
                        } else {
                            TrainingMaterialType type2 = (TrainingMaterialType)this.materialTypeMapper.selectById(type1.getSourceId());
                            if (StringUtils.isEmpty((Object)type2) || data.length <= 2 || StringUtils.isEmpty((Object)data[data.length - 3]) || !type2.getMaterialTypeName().equals(data[data.length - 3])) continue;
                            if (StringUtils.isEmpty((Object)type2.getSourceId())) {
                                typeId = materialType.getId();
                            } else {
                                TrainingMaterialType type3 = (TrainingMaterialType)this.materialTypeMapper.selectById(type2.getSourceId());
                                if (StringUtils.isEmpty((Object)type3) || data.length <= 3 || StringUtils.isEmpty((Object)data[data.length - 4]) || !type3.getMaterialTypeName().equals(data[data.length - 4])) continue;
                                if (StringUtils.isEmpty((Object)type3.getSourceId())) {
                                    typeId = materialType.getId();
                                } else {
                                    TrainingMaterialType type4 = (TrainingMaterialType)this.materialTypeMapper.selectById(type3.getSourceId());
                                    if (StringUtils.isEmpty((Object)type4) || data.length <= 4 || StringUtils.isEmpty((Object)data[data.length - 5]) || !type4.getMaterialTypeName().equals(data[data.length - 5]) || !StringUtils.isEmpty((Object)type4.getSourceId())) continue;
                                    typeId = materialType.getId();
                                }
                            }
                        }
                    }
                    break;
                }
            }
            catch (Exception e) {
                log.error("\u5339\u914d\u5206\u7c7b\u662f\u5426\u4e00\u81f4", (Throwable)e);
            }
        }
        return typeId;
    }

    public static byte[] toByteArray(Object obj) {
        byte[] bytes = null;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            ObjectOutputStream oos = new ObjectOutputStream(bos);
            oos.writeObject(obj);
            oos.flush();
            bytes = bos.toByteArray();
            oos.close();
            bos.close();
        }
        catch (Exception e) {
            log.error("\u5c06Object\u5bf9\u8c61\u8f6cbyte\u6570\u7ec4", (Throwable)e);
        }
        return bytes;
    }

    @Override
    public List<String> selectProductParamValues(List<Integer> materialIds) {
        List<String> paramters = new ArrayList<String>();
        LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
        wrapper1.in(TrainingMaterialParameter::getMaterialId, materialIds);
        List materialParameters = this.materialParameterMapper.selectList((Wrapper)wrapper1);
        if (!CollectionUtils.isEmpty((Collection)materialParameters)) {
            paramters = materialParameters.stream().map(TrainingMaterialParameter::getParameterName).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        }
        return paramters;
    }

    @Override
    public void updateProductParamShow(Map map) {
        if (!StringUtils.isEmpty(map.get("materials"))) {
            List materials = (List)map.get("materials");
            List parameters = (List)map.get("parameters");
            if (!CollectionUtils.isEmpty((Collection)parameters)) {
                TrainingMaterialParameter materialParameter = new TrainingMaterialParameter();
                materialParameter.setIsShow(Integer.valueOf(1));
                LambdaUpdateWrapper wrapper1 = new LambdaUpdateWrapper();
                ((LambdaUpdateWrapper)wrapper1.in(TrainingMaterialParameter::getMaterialId, (Collection)materials)).in(TrainingMaterialParameter::getParameterName, (Collection)parameters);
                this.materialParameterMapper.update(materialParameter, (Wrapper)wrapper1);
                materialParameter.setIsShow(Integer.valueOf(0));
                LambdaUpdateWrapper wrapper2 = new LambdaUpdateWrapper();
                ((LambdaUpdateWrapper)wrapper2.in(TrainingMaterialParameter::getMaterialId, (Collection)materials)).notIn(TrainingMaterialParameter::getParameterName, (Collection)parameters);
                this.materialParameterMapper.update(materialParameter, (Wrapper)wrapper2);
            } else {
                TrainingMaterialParameter materialParameter = new TrainingMaterialParameter();
                materialParameter.setIsShow(Integer.valueOf(0));
                LambdaUpdateWrapper wrapper1 = new LambdaUpdateWrapper();
                wrapper1.in(TrainingMaterialParameter::getMaterialId, (Collection)materials);
                this.materialParameterMapper.update(materialParameter, (Wrapper)wrapper1);
            }
        }
    }

    private static /* synthetic */ boolean lambda$importMaterialProduct$0(Object a) {
        return !"".equals(a.toString());
    }
}

