/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.training.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.google.common.collect.Lists;
import com.ovopark.organize.common.model.pojo.UsersPojo;
import com.ovopark.training.domain.UnitDO;
import com.ovopark.training.mapper.TrainingMapper;
import com.ovopark.training.mapper.TrainingMaterialMapper;
import com.ovopark.training.mapper.TrainingMessageMapper;
import com.ovopark.training.mapper.TrainingMessageUserMapper;
import com.ovopark.training.mapper.permission.UnitMapper;
import com.ovopark.training.model.Authenticator;
import com.ovopark.training.model.JPush;
import com.ovopark.training.model.TaskMessageBody;
import com.ovopark.training.model.Training;
import com.ovopark.training.model.TrainingMaterial;
import com.ovopark.training.model.TrainingMessage;
import com.ovopark.training.model.TrainingMessageUser;
import com.ovopark.training.model.Users;
import com.ovopark.training.model.material.UnitGroup;
import com.ovopark.training.service.JPushService;
import com.ovopark.training.service.TrainingMaterialNewService;
import com.ovopark.training.service.TrainingMessageService;
import com.ovopark.training.service.UserUtilService;
import com.ovopark.training.service.permission.UnitService;
import com.ovopark.training.service.resource.ResourceSinglePermissionService;
import com.ovopark.training.util.CommonUtil;
import com.ovopark.training.vo.TrainingMaterialVo;
import com.ovopark.training.vo.TrainingMessageVo;
import com.ovopark.training.vo.unit.UnitShowVo;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Service
public class TrainingMessageServiceImpl
implements TrainingMessageService {
    private static final Logger log = LoggerFactory.getLogger(TrainingMessageServiceImpl.class);
    @Autowired
    private TrainingMessageMapper trainingMessageMapper;
    @Autowired
    private TrainingMessageUserMapper trainingMessageUserMapper;
    @Autowired
    private UnitMapper unitMapper;
    @Autowired
    private UserUtilService userUtilService;
    @Autowired
    private UnitService unitService;
    @Autowired
    private JPushService jPushService;
    @Autowired
    private MessageSource messageSource;
    @Autowired
    private TrainingMaterialNewService trainingMaterialNewService;
    @Autowired
    private ResourceSinglePermissionService resourceSinglePermissionService;
    @Autowired
    private TrainingMaterialMapper trainingMaterialMapper;
    @Autowired
    private TrainingMapper trainingMapper;

    @Override
    public void saveTrainingMaterialMessage(final TrainingMessageVo trainingMessageVo, final Users user) {
        trainingMessageVo.setObjectType("TYPE_MATERIAL_SYSTEM");
        List<Integer> userIdList = this.saveTrainingMessage(trainingMessageVo, user);
        if (!CollectionUtils.isEmpty(userIdList)) {
            final List<Integer> finalUserIdList = userIdList = userIdList.stream().filter(Objects::nonNull).distinct().collect(Collectors.toList());
            CommonUtil.handleTask(new Runnable(){

                @Override
                public void run() {
                    try {
                        TrainingMaterial trainingMaterial = (TrainingMaterial)TrainingMessageServiceImpl.this.trainingMaterialMapper.selectById(trainingMessageVo.getObjectId());
                        if (!ObjectUtils.isEmpty((Object)trainingMaterial)) {
                            TrainingMaterialVo materialVo = new TrainingMaterialVo();
                            BeanUtils.copyProperties((Object)trainingMaterial, (Object)materialVo);
                            materialVo.setTitle(trainingMessageVo.getTitle());
                            TaskMessageBody body = new TaskMessageBody();
                            body.setType(85);
                            body.setTaskJson(JSONObject.toJSONString((Object)materialVo));
                            TrainingMessageServiceImpl.this.jPushService.sendWebSocketAll(trainingMessageVo.getTitle(), trainingMessageVo.getContent(), finalUserIdList, user.getGroupId(), materialVo.getId(), "TYPE_MATERIAL_SYSTEM", JSONObject.toJSONString((Object)materialVo), null, 0, 0, null, null);
                            TrainingMessageServiceImpl.this.jPushService.pushNotificationAll(JPush.MASSAGE_TYPE_NOTIFY, "TYPE_MATERIAL_SYSTEM", finalUserIdList, trainingMessageVo.getTitle(), trainingMessageVo.getContent(), body);
                            log.info("--\u63a8\u9001\u4eba--" + finalUserIdList);
                        }
                    }
                    catch (Exception e) {
                        log.error("\u7d20\u6750\u63a8\u9001:", (Throwable)e);
                    }
                }
            });
        }
    }

    private List<Integer> getUserIdList(UnitGroup messageUserUnitGroup, Users user) {
        List<Integer> tagUserIds;
        List<Integer> orgUserIds;
        List<Integer> roleUserIds;
        List<Object> userIdList = Lists.newArrayList();
        if (!CollectionUtils.isEmpty((Collection)messageUserUnitGroup.getUserIds())) {
            userIdList.addAll(messageUserUnitGroup.getUserIds().stream().filter(Objects::nonNull).map(Integer::parseInt).collect(Collectors.toList()));
        }
        if (!CollectionUtils.isEmpty((Collection)messageUserUnitGroup.getRoleIds()) && !CollectionUtils.isEmpty(roleUserIds = this.userUtilService.selectUsersByRoles(messageUserUnitGroup.getRoleIds().stream().filter(Objects::nonNull).map(Integer::parseInt).collect(Collectors.toList()), user.getGroupId()))) {
            userIdList.addAll(roleUserIds);
        }
        if (!CollectionUtils.isEmpty((Collection)messageUserUnitGroup.getOrganizeIds()) && !CollectionUtils.isEmpty(orgUserIds = this.userUtilService.selectUserIdsByOrganizeIds(messageUserUnitGroup.getOrganizeIds(), user.getGroupId()))) {
            userIdList.addAll(orgUserIds);
        }
        if (!CollectionUtils.isEmpty((Collection)messageUserUnitGroup.getTagIds()) && !CollectionUtils.isEmpty(tagUserIds = this.userUtilService.selectUserIdsByTagIds(messageUserUnitGroup.getTagIds().stream().filter(Objects::nonNull).map(Integer::parseInt).collect(Collectors.toList()), user.getGroupId(), user.getId()))) {
            userIdList.addAll(tagUserIds);
        }
        if (!CollectionUtils.isEmpty((Collection)userIdList)) {
            userIdList = userIdList.stream().distinct().collect(Collectors.toList());
        }
        return userIdList;
    }

    @Override
    public List<Integer> saveTrainingMessage(TrainingMessageVo trainingMessageVo, Users user) {
        Date now = new Date();
        if (trainingMessageVo.getId() == null) {
            trainingMessageVo.setCreater(user.getId());
            trainingMessageVo.setCreateTime(now);
            trainingMessageVo.setUpdater(user.getId());
            trainingMessageVo.setUpdateTime(now);
            trainingMessageVo.setEnterpriseId(user.getGroupId());
            this.trainingMessageMapper.insert(trainingMessageVo);
        } else {
            trainingMessageVo.setUpdater(user.getId());
            trainingMessageVo.setUpdateTime(now);
            this.trainingMessageMapper.updateById(trainingMessageVo);
            LambdaUpdateWrapper wrapper1 = new LambdaUpdateWrapper();
            wrapper1.eq(TrainingMessageUser::getMessageId, (Object)trainingMessageVo.getId());
            this.trainingMessageUserMapper.delete((Wrapper)wrapper1);
        }
        ArrayList userIdList = this.getUserIdListByPermission(trainingMessageVo, user);
        if (trainingMessageVo.getAppointType() != null && trainingMessageVo.getAppointType() == 2) {
            List<Integer> userIds;
            List<UnitDO> unitList = this.unitService.insertByUnitGroup(user.getGroupId(), trainingMessageVo.getMessageUserUnitGroup());
            if (!CollectionUtils.isEmpty(unitList)) {
                ArrayList<TrainingMessageUser> trainingMessageUserList = new ArrayList<TrainingMessageUser>();
                for (UnitDO unitDO : unitList) {
                    TrainingMessageUser trainingMessageUser = new TrainingMessageUser();
                    trainingMessageUser.setMessageId(trainingMessageVo.getId());
                    trainingMessageUser.setUnitId(unitDO.getId());
                    trainingMessageUser.setEnterpriseId(user.getGroupId());
                    trainingMessageUser.setCreater(user.getId());
                    trainingMessageUser.setCreateTime(new Date());
                    trainingMessageUserList.add(trainingMessageUser);
                }
                this.trainingMessageUserMapper.insertList(trainingMessageUserList);
            }
            if (CollectionUtils.isEmpty(userIds = this.getUserIdList(trainingMessageVo.getMessageUserUnitGroup(), user))) {
                userIdList = Lists.newArrayList();
            } else {
                userIdList.retainAll(userIds);
            }
        }
        return userIdList;
    }

    private List<Integer> getUserIdListByPermission(TrainingMessageVo trainingMessageVo, Users user) {
        List<Object> userIdList = Lists.newArrayList();
        if (trainingMessageVo.getObjectType().equals("TYPE_MATERIAL_SYSTEM")) {
            userIdList = this.resourceSinglePermissionService.getUserIdByMaterialId(trainingMessageVo.getObjectId(), user.getGroupId());
        } else if (trainingMessageVo.getObjectType().equals("TYPE_TRAINING_NEW_SYSTEM")) {
            userIdList = this.resourceSinglePermissionService.getUserIdByTrainId(trainingMessageVo.getObjectId(), user.getGroupId());
        }
        return userIdList;
    }

    @Override
    public TrainingMessageVo getTrainingMessageByMaterial(TrainingMessageVo trainingMessageVo, Users user) {
        trainingMessageVo.setObjectType("TYPE_MATERIAL_SYSTEM");
        return this.getTrainingMessage(trainingMessageVo, user);
    }

    @Override
    public TrainingMessageVo getTrainingMessage(TrainingMessageVo trainingMessageVo, Users user) {
        LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper1.eq(TrainingMessage::getObjectId, (Object)trainingMessageVo.getObjectId())).eq(TrainingMessage::getObjectType, (Object)trainingMessageVo.getObjectType())).orderByDesc(TrainingMessage::getId);
        List trainingMessageList = this.trainingMessageMapper.selectList((Wrapper)wrapper1);
        if (!CollectionUtils.isEmpty((Collection)trainingMessageList)) {
            TrainingMessage trainingMessage = (TrainingMessage)trainingMessageList.get(0);
            BeanUtils.copyProperties((Object)trainingMessage, (Object)trainingMessageVo);
            if (trainingMessageVo.getAppointType() != null && trainingMessageVo.getAppointType() == 2) {
                List unitList;
                LambdaQueryWrapper wrapper2 = new LambdaQueryWrapper();
                wrapper2.eq(TrainingMessageUser::getMessageId, (Object)trainingMessageVo.getId());
                List trainingMessageUserList = this.trainingMessageUserMapper.selectList((Wrapper)wrapper2);
                if (!CollectionUtils.isEmpty((Collection)trainingMessageUserList) && !CollectionUtils.isEmpty(unitList = trainingMessageUserList.stream().map(TrainingMessageUser::getUnitId).filter(Objects::nonNull).distinct().collect(Collectors.toList()))) {
                    List unitDOList = this.unitMapper.selectBatchIds(unitList);
                    List<String> userIdList = unitDOList.stream().filter(e -> e.getBizType().equals(1)).map(UnitDO::getBizId).distinct().collect(Collectors.toList());
                    List<String> roleIdList = unitDOList.stream().filter(e -> e.getBizType().equals(3)).map(UnitDO::getBizId).distinct().collect(Collectors.toList());
                    List<String> tagIdList = unitDOList.stream().filter(e -> e.getBizType().equals(2)).map(UnitDO::getBizId).distinct().collect(Collectors.toList());
                    List<String> organizeIdList = unitDOList.stream().filter(e -> e.getBizType().equals(4)).map(UnitDO::getBizId).distinct().collect(Collectors.toList());
                    List<UnitShowVo> list = this.userUtilService.getAllUserTypeData(userIdList, roleIdList, tagIdList, organizeIdList, user.getGroupId());
                    trainingMessageVo.setMessageUserNameList(list);
                }
            }
        } else {
            Locale locale = Authenticator.getInstance().getCurrentClient().getLocale();
            if (trainingMessageVo.getObjectType().equals("TYPE_MATERIAL_SYSTEM")) {
                Object[] objectArray;
                TrainingMaterial trainingMaterial = (TrainingMaterial)this.trainingMaterialMapper.selectById(trainingMessageVo.getObjectId());
                trainingMessageVo.setTitle(this.messageSource.getMessage("training.material.title", null, locale));
                if (ObjectUtils.isEmpty((Object)trainingMaterial)) {
                    objectArray = null;
                } else {
                    Object[] objectArray2 = new Object[1];
                    objectArray = objectArray2;
                    objectArray2[0] = trainingMaterial.getMaterialName();
                }
                trainingMessageVo.setContent(this.messageSource.getMessage("training.material.new", objectArray, locale));
            } else if (trainingMessageVo.getObjectType().equals("TYPE_TRAINING_NEW_SYSTEM")) {
                Training training = (Training)this.trainingMapper.selectById(trainingMessageVo.getObjectId());
                trainingMessageVo.setTitle(this.messageSource.getMessage("training.train.title", null, locale));
                trainingMessageVo.setContent(this.messageSource.getMessage("training.train.message.content", new Object[]{"[Name]", ObjectUtils.isEmpty((Object)training) ? "" : training.getTitle()}, locale));
            }
        }
        return trainingMessageVo;
    }

    @Override
    public void saveTrainingTrainMessage(final TrainingMessageVo trainingMessageVo, final Users user) {
        trainingMessageVo.setObjectType("TYPE_TRAINING_NEW_SYSTEM");
        List<Integer> userIdList = this.saveTrainingMessage(trainingMessageVo, user);
        if (!CollectionUtils.isEmpty(userIdList)) {
            final List<Integer> finalUserIdList = userIdList = userIdList.stream().filter(Objects::nonNull).distinct().collect(Collectors.toList());
            CommonUtil.handleTask(new Runnable(){

                @Override
                public void run() {
                    try {
                        Training training = (Training)TrainingMessageServiceImpl.this.trainingMapper.selectById(trainingMessageVo.getObjectId());
                        if (ObjectUtils.isEmpty((Object)training)) {
                            return;
                        }
                        training.setTitle(trainingMessageVo.getTitle());
                        TaskMessageBody body = new TaskMessageBody();
                        body.setType(99);
                        body.setTaskJson(JSONObject.toJSONString((Object)training));
                        String content = trainingMessageVo.getContent();
                        content = content.replace("[Name]", "{0}");
                        Map<Integer, UsersPojo> pojoMap = TrainingMessageServiceImpl.this.userUtilService.selectUserMap(finalUserIdList);
                        for (Integer userId : finalUserIdList) {
                            UsersPojo pojo = pojoMap.get(userId);
                            if (ObjectUtils.isEmpty((Object)pojo)) continue;
                            TrainingMessageServiceImpl.this.jPushService.sendWebSocket(trainingMessageVo.getTitle(), MessageFormat.format(content, pojo.getShowName()), userId, user.getGroupId(), training.getId(), "TYPE_TRAINING_NEW_SYSTEM", JSONObject.toJSONString((Object)training), null, 0, 0, null, null);
                            TrainingMessageServiceImpl.this.jPushService.pushNotification(JPush.MASSAGE_TYPE_NOTIFY, "TYPE_TRAINING_NEW_SYSTEM", userId, trainingMessageVo.getTitle(), MessageFormat.format(content, pojo.getShowName()), body);
                        }
                        log.info("\u63a8\u9001\u4eba:{}", (Object)JSON.toJSONString((Object)finalUserIdList));
                    }
                    catch (Exception e) {
                        log.error("\u8bfe\u7a0b\u63a8\u9001:", (Throwable)e);
                    }
                }
            });
        }
    }

    @Override
    public TrainingMessageVo getTrainingMessageByTrain(TrainingMessageVo trainingMessageVo, Users user) {
        trainingMessageVo.setObjectType("TYPE_TRAINING_NEW_SYSTEM");
        return this.getTrainingMessage(trainingMessageVo, user);
    }
}

