/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.training.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.google.common.collect.Lists;
import com.ovopark.cloud.log.model.LogPojo;
import com.ovopark.cloud.log.sdk.LogApi;
import com.ovopark.organize.common.base.BaseResult;
import com.ovopark.organize.common.model.mo.UserAndParentNameMo;
import com.ovopark.organize.common.model.mo.UserDutiesMo;
import com.ovopark.organize.common.model.mo.UserTagMo;
import com.ovopark.organize.common.model.mo.UsersAndOrgsMo;
import com.ovopark.organize.common.model.pojo.DepAndTagsPojo;
import com.ovopark.organize.common.model.pojo.DepartmentPojo;
import com.ovopark.organize.common.model.pojo.OrganizePojo;
import com.ovopark.organize.common.model.pojo.SimplePojo;
import com.ovopark.organize.common.model.pojo.UsersPojo;
import com.ovopark.organize.sdk.api.DepartmentApi;
import com.ovopark.organize.sdk.api.OrganizeApi;
import com.ovopark.organize.sdk.api.TagApi;
import com.ovopark.organize.sdk.api.UserApi;
import com.ovopark.organize.sdk.api.UserOrganizeApi;
import com.ovopark.privilege.api.RoleApi;
import com.ovopark.privilege.pojo.RolePojo;
import com.ovopark.training.bo.JsonResult;
import com.ovopark.training.bo.Page;
import com.ovopark.training.bo.UserBo;
import com.ovopark.training.mapper.TrainingChapterAttachMapper;
import com.ovopark.training.mapper.TrainingChapterMapper;
import com.ovopark.training.mapper.TrainingCourseConfigMapper;
import com.ovopark.training.mapper.TrainingCourseMapper;
import com.ovopark.training.mapper.TrainingCourseStageTaskMapper;
import com.ovopark.training.mapper.TrainingCourseUserMapper;
import com.ovopark.training.mapper.TrainingExamMapper;
import com.ovopark.training.mapper.TrainingExamOptionsMapper;
import com.ovopark.training.mapper.TrainingExamQuestionMapper;
import com.ovopark.training.mapper.TrainingExaminerMapper;
import com.ovopark.training.mapper.TrainingJobCertificationMapper;
import com.ovopark.training.mapper.TrainingJobStageTaskMapper;
import com.ovopark.training.mapper.TrainingJobUserMapper;
import com.ovopark.training.mapper.TrainingLearnManagerMapper;
import com.ovopark.training.mapper.TrainingLearnProjectMapper;
import com.ovopark.training.mapper.TrainingLoginUserMapper;
import com.ovopark.training.mapper.TrainingMapper;
import com.ovopark.training.mapper.TrainingMaterialTypeMapper;
import com.ovopark.training.mapper.TrainingOptionsMapper;
import com.ovopark.training.mapper.TrainingPaperMapper;
import com.ovopark.training.mapper.TrainingPaperQuestionMapper;
import com.ovopark.training.mapper.TrainingPaperRandomMapper;
import com.ovopark.training.mapper.TrainingPaperReviewerMapper;
import com.ovopark.training.mapper.TrainingPaperUserMapper;
import com.ovopark.training.mapper.TrainingQuestionMapper;
import com.ovopark.training.mapper.TrainingQuestionTypeMapper;
import com.ovopark.training.mapper.TrainingTaskScheduleMapper;
import com.ovopark.training.mapper.TrainingUserPaperMapper;
import com.ovopark.training.mapper.TrainingUserQuestionAttaMapper;
import com.ovopark.training.mapper.TrainingUserQuestionMapper;
import com.ovopark.training.mapper.TrainingUserQuestionPictureMapper;
import com.ovopark.training.model.Authenticator;
import com.ovopark.training.model.PaperAnalyse;
import com.ovopark.training.model.Role;
import com.ovopark.training.model.Training;
import com.ovopark.training.model.TrainingChapter;
import com.ovopark.training.model.TrainingChapterAttach;
import com.ovopark.training.model.TrainingCourse;
import com.ovopark.training.model.TrainingCourseConfig;
import com.ovopark.training.model.TrainingCourseStageTask;
import com.ovopark.training.model.TrainingCourseUser;
import com.ovopark.training.model.TrainingExam;
import com.ovopark.training.model.TrainingExamOptions;
import com.ovopark.training.model.TrainingExamQuestion;
import com.ovopark.training.model.TrainingExaminer;
import com.ovopark.training.model.TrainingJobCertification;
import com.ovopark.training.model.TrainingJobStageTask;
import com.ovopark.training.model.TrainingJobUser;
import com.ovopark.training.model.TrainingLearnManager;
import com.ovopark.training.model.TrainingLearnProject;
import com.ovopark.training.model.TrainingLoginUser;
import com.ovopark.training.model.TrainingMaterialType;
import com.ovopark.training.model.TrainingOptions;
import com.ovopark.training.model.TrainingPaper;
import com.ovopark.training.model.TrainingPaperQuestion;
import com.ovopark.training.model.TrainingPaperRandom;
import com.ovopark.training.model.TrainingPaperReviewer;
import com.ovopark.training.model.TrainingPaperUser;
import com.ovopark.training.model.TrainingQuestion;
import com.ovopark.training.model.TrainingQuestionType;
import com.ovopark.training.model.TrainingTaskSchedule;
import com.ovopark.training.model.TrainingUserPaper;
import com.ovopark.training.model.TrainingUserQuestion;
import com.ovopark.training.model.TrainingUserQuestionAtta;
import com.ovopark.training.model.TrainingUserQuestionPicture;
import com.ovopark.training.model.Users;
import com.ovopark.training.service.JPushService;
import com.ovopark.training.service.TrainingCommonService;
import com.ovopark.training.service.TrainingExamService;
import com.ovopark.training.service.TrainingPaperService;
import com.ovopark.training.service.UserUtilService;
import com.ovopark.training.util.DateUtils;
import com.ovopark.training.util.ExcelUtil;
import com.ovopark.training.util.ListUtil;
import com.ovopark.training.util.StringsUtils;
import com.ovopark.training.vo.OpenUserPaperVo;
import com.ovopark.training.vo.OrgVo;
import com.ovopark.training.vo.PaperAnalyseSearchVo;
import com.ovopark.training.vo.PaperAnalyseVo;
import com.ovopark.training.vo.PaperDetailExcelVo;
import com.ovopark.training.vo.PaperUserDetailSearchVo;
import com.ovopark.training.vo.PaperUserDetailVo;
import com.ovopark.training.vo.TagVo;
import com.ovopark.training.vo.TrainingExamQuestionVo;
import com.ovopark.training.vo.TrainingOptionsVo;
import com.ovopark.training.vo.TrainingPapersVo;
import com.ovopark.training.vo.TrainingQuestionVo;
import com.ovopark.training.vo.TrainingUserPaperVo;
import com.ovopark.training.vo.TrainingUserQuestionVo;
import com.ovopark.training.vo.TrainingsVo;
import com.ovopark.training.vo.UserExam;
import com.ovopark.training.vo.UserExamDetailVo;
import com.ovopark.training.vo.UserExamSearchVo;
import com.ovopark.training.vo.ValidDeletePaperVo;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.URLEncoder;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Service
public class TrainingPaperServiceImpl
implements TrainingPaperService {
    private static final Logger log = LoggerFactory.getLogger(TrainingPaperServiceImpl.class);
    @Autowired
    private TrainingPaperMapper paperMapper;
    @Autowired
    private TrainingUserPaperMapper userPaperMapper;
    @Autowired
    private TrainingPaperUserMapper trainingPaperUserMapper;
    @Autowired
    private TrainingExamService trainingExamService;
    @Autowired
    private UserApi userApi;
    @Autowired
    private UserUtilService userUtilService;
    @Autowired
    private TrainingExaminerMapper trainingExaminerMapper;
    @Autowired
    private TrainingExamMapper trainingExamMapper;
    @Autowired
    private TrainingMaterialTypeMapper trainingMaterialTypeMapper;
    @Autowired
    private JPushService jPushService;
    @Autowired
    private TrainingExamMapper examMapper;
    @Autowired
    private TrainingExamQuestionMapper examQuestionMapper;
    @Autowired
    private TrainingQuestionMapper questionMapper;
    @Autowired
    private TrainingExamOptionsMapper examOptionsMapper;
    @Autowired
    private TrainingOptionsMapper optionsMapper;
    @Autowired
    private TrainingUserQuestionMapper userQuestionMapper;
    @Autowired
    private TrainingUserQuestionPictureMapper userQuestionPictureMapper;
    @Autowired
    private TrainingPaperRandomMapper trainingPaperRandomMapper;
    @Autowired
    private TrainingExamService examService;
    @Autowired
    private TrainingUserQuestionAttaMapper trainingUserQuestionAttaMapper;
    @Autowired
    private TrainingChapterAttachMapper trainingChapterAttachMapper;
    @Autowired
    private TrainingChapterMapper trainingChapterMapper;
    @Autowired
    private TrainingMapper trainingMapper;
    @Autowired
    private TrainingCourseStageTaskMapper trainingCourseStageTaskMapper;
    @Autowired
    private TrainingTaskScheduleMapper trainingTaskScheduleMapper;
    @Autowired
    private TrainingJobStageTaskMapper trainingJobStageTaskMapper;
    @Autowired
    private TrainingUserPaperMapper trainingUserPaperMapper;
    @Autowired
    private TrainingPaperMapper trainingPaperMapper;
    @Autowired
    private TrainingUserQuestionMapper trainingUserQuestionMapper;
    @Autowired
    private TrainingExamQuestionMapper trainingExamQuestionMapper;
    @Autowired
    private TrainingQuestionTypeMapper trainingQuestionTypeMapper;
    @Autowired
    private TrainingQuestionMapper trainingQuestionMapper;
    @Autowired
    private UserOrganizeApi userOrganizeApi;
    @Autowired
    private TagApi tagApi;
    @Autowired
    private com.ovopark.privilege.api.UserApi priUserApi;
    @Autowired
    private TrainingCourseMapper trainingCourseMapper;
    @Autowired
    private TrainingLearnProjectMapper trainingLearnProjectMapper;
    @Autowired
    private TrainingJobCertificationMapper trainingJobCertificationMapper;
    @Autowired
    private OrganizeApi organizeApi;
    @Autowired
    private RoleApi roleApi;
    @Autowired
    private DepartmentApi departmentApi;
    @Autowired
    private TrainingExamOptionsMapper trainingExamOptionsMapper;
    @Autowired
    private TrainingOptionsMapper trainingOptionsMapper;
    @Autowired
    private TrainingPaperReviewerMapper trainingPaperReviewerMapper;
    @Autowired
    private TrainingCourseConfigMapper trainingCourseConfigMapper;
    @Autowired
    private TrainingLearnManagerMapper trainingLearnManagerMapper;
    @Autowired
    private TrainingJobUserMapper trainingJobUserMapper;
    @Autowired
    private TrainingCourseUserMapper trainingCourseUserMapper;
    @Autowired
    private MessageSource messageSource;
    @Autowired
    private LogApi logApi;
    @Autowired
    private TrainingLoginUserMapper trainingLoginUserMapper;
    @Autowired
    private TrainingPaperQuestionMapper trainingPaperQuestionMapper;
    @Autowired
    private TrainingCommonService trainingCommonService;

    @Override
    public Page<TrainingPapersVo> getPapers(Page<TrainingPapersVo> page, String name, String paperState, Users users, Integer typeId, Integer projectShow, Integer isTraining, Integer isPaperState) {
        List<TrainingPapersVo> trainingPaperVos;
        List<Integer> paperStates = new ArrayList<Integer>();
        if (!org.springframework.util.StringUtils.isEmpty((Object)paperState)) {
            paperStates = Arrays.asList(paperState.split(",")).stream().map(Integer::parseInt).collect(Collectors.toList());
        }
        if (!CollectionUtils.isEmpty(trainingPaperVos = this.paperMapper.selectByStateByPage(page, users.getGroupId(), name, paperStates, typeId, projectShow, isTraining, isPaperState))) {
            List<Integer> createrId = trainingPaperVos.stream().map(TrainingPaper::getCreater).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            Map<Object, Object> createMap = new HashMap();
            if (!CollectionUtils.isEmpty(createrId)) {
                createMap = this.userUtilService.selectUserMap(createrId);
            }
            List paperIds = trainingPaperVos.stream().map(TrainingPaper::getId).collect(Collectors.toList());
            Map<Object, Object> paperMap = new HashMap();
            Map<Object, Object> userPaperMap = new HashMap();
            Map<Object, Object> trainingUserPaperMap = new HashMap();
            Map<Object, Object> paperUserMap = new HashMap();
            if (!CollectionUtils.isEmpty(paperIds)) {
                List trainingUserPapers;
                List paperList = this.paperMapper.selectBatchIds(paperIds);
                if (!CollectionUtils.isEmpty((Collection)paperList)) {
                    paperMap = paperList.stream().collect(Collectors.toMap(TrainingPaper::getId, Function.identity()));
                }
                LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper1.in(TrainingUserPaper::getTrainingPaperId, paperIds)).isNotNull(TrainingUserPaper::getUserId)).isNotNull(TrainingUserPaper::getSubmitTime);
                List userPapers = this.userPaperMapper.selectList((Wrapper)wrapper1);
                List userPaperList = userPapers.stream().filter(e -> Objects.isNull(e.getSourceType()) || e.getSourceType() == 2).collect(Collectors.toList());
                if (!CollectionUtils.isEmpty(userPaperList)) {
                    userPaperMap = userPaperList.stream().collect(Collectors.groupingBy(TrainingUserPaper::getTrainingPaperId));
                }
                LambdaQueryWrapper wrapper2 = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper2.in(TrainingUserPaper::getTrainingPaperId, paperIds)).isNotNull(TrainingUserPaper::getLoginUserId)).isNotNull(TrainingUserPaper::getSubmitTime);
                List trainingUserPaperList = this.userPaperMapper.selectList((Wrapper)wrapper2);
                if (!CollectionUtils.isEmpty((Collection)trainingUserPaperList) && !CollectionUtils.isEmpty(trainingUserPapers = trainingUserPaperList.stream().filter(e -> Objects.isNull(e.getSourceType()) || e.getSourceType() == 2).collect(Collectors.toList()))) {
                    trainingUserPaperMap = trainingUserPapers.stream().collect(Collectors.groupingBy(TrainingUserPaper::getTrainingPaperId));
                }
                LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
                wrapper.in(TrainingPaperUser::getPaperId, paperIds);
                List list = this.trainingPaperUserMapper.selectList((Wrapper)wrapper);
                if (!CollectionUtils.isEmpty((Collection)list)) {
                    paperUserMap = list.stream().collect(Collectors.groupingBy(TrainingPaperUser::getPaperId));
                }
            }
            List<Integer> userIds = this.userUtilService.getUserListByGroupId(users.getGroupId());
            Iterator<TrainingPapersVo> iterator = trainingPaperVos.iterator();
            while (iterator.hasNext()) {
                List userIdList;
                List<Integer> reUserIds;
                List list;
                TrainingPapersVo trainingPaperVo;
                UsersPojo pojo = (UsersPojo)createMap.get((trainingPaperVo = iterator.next()).getCreater());
                trainingPaperVo.setCreateName(!org.springframework.util.StringUtils.isEmpty((Object)pojo) ? pojo.getShowName() : "");
                ArrayList<Integer> newUserIds = new ArrayList<Integer>();
                newUserIds.addAll(userIds);
                ArrayList<Object> myUserIds = new ArrayList<Object>();
                int needPaper = 0;
                int isPaper = 0;
                TrainingPaper paper = (TrainingPaper)paperMap.get(trainingPaperVo.getId());
                if (!(ObjectUtils.isEmpty((Object)paper) || paper.getLookLevel() == null || paper.getLookLevel() != 1 || CollectionUtils.isEmpty(newUserIds) || CollectionUtils.isEmpty((Collection)(list = (List)paperUserMap.get(trainingPaperVo.getId()))))) {
                    List<Integer> orgUserIds;
                    List<Integer> tagUserIds;
                    List<Integer> roleUserIds;
                    List<Integer> roleIdList = list.stream().map(TrainingPaperUser::getRoleId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
                    List<String> organizeIdList = list.stream().map(TrainingPaperUser::getOrganizeId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
                    List<Integer> tagIdList = list.stream().map(TrainingPaperUser::getTagId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
                    List whoCanSeeList = list.stream().map(TrainingPaperUser::getUserId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
                    myUserIds.addAll(whoCanSeeList);
                    if (!CollectionUtils.isEmpty(roleIdList) && !CollectionUtils.isEmpty(roleUserIds = this.userUtilService.selectUsersByRoles(roleIdList, users.getGroupId()))) {
                        myUserIds.addAll(roleUserIds);
                    }
                    if (!CollectionUtils.isEmpty(tagIdList) && !CollectionUtils.isEmpty(tagUserIds = this.userUtilService.selectUserIdsByTagIds(tagIdList, users.getGroupId(), users.getId()))) {
                        myUserIds.addAll(tagUserIds);
                    }
                    if (!CollectionUtils.isEmpty(organizeIdList) && !CollectionUtils.isEmpty(orgUserIds = this.userUtilService.selectUserIdsByOrganizeIds(organizeIdList, users.getGroupId()))) {
                        myUserIds.addAll(orgUserIds);
                    }
                    if (!CollectionUtils.isEmpty(myUserIds)) {
                        newUserIds.retainAll(myUserIds);
                    }
                }
                if (trainingPaperVo.getEndTime() != null && !CollectionUtils.isEmpty(reUserIds = this.userUtilService.selectOverGroupTime(trainingPaperVo.getEnterpriseId(), trainingPaperVo.getEndTime()))) {
                    newUserIds.removeAll(reUserIds);
                }
                if (CollectionUtils.isEmpty(newUserIds)) continue;
                needPaper = newUserIds.size();
                List userPapers = (List)userPaperMap.get(trainingPaperVo.getId());
                if (!CollectionUtils.isEmpty((Collection)userPapers) && !CollectionUtils.isEmpty(userIdList = userPapers.stream().map(TrainingUserPaper::getUserId).filter(Objects::nonNull).distinct().collect(Collectors.toList()))) {
                    userIdList.retainAll(newUserIds);
                    isPaper = userIdList.size();
                }
                trainingPaperVo.setIsPaper(Integer.valueOf(isPaper));
                trainingPaperVo.setNeedPaper(Integer.valueOf(needPaper));
                Integer loginUserCount = 0;
                List trainingUserPapers = (List)trainingUserPaperMap.get(trainingPaperVo.getId());
                if (!CollectionUtils.isEmpty((Collection)trainingUserPapers)) {
                    List userIdList2 = trainingUserPapers.stream().map(TrainingUserPaper::getLoginUserId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
                    loginUserCount = userIdList2.size();
                }
                trainingPaperVo.setLoginUserCount(loginUserCount);
            }
        }
        page.setContent(trainingPaperVos);
        return page;
    }

    @Override
    public List<TrainingsVo> selectProjectByPaper(Integer paperId) {
        List userIdList;
        BaseResult simplePojoBaseList;
        List<TrainingsVo> list = this.paperMapper.selectProjectByPaper(paperId);
        if (!CollectionUtils.isEmpty(list) && (simplePojoBaseList = this.userApi.getSimpleUserByIdList(userIdList = list.stream().map(Training::getCreator).distinct().collect(Collectors.toList()))) != null) {
            Locale locale = Authenticator.getInstance().getCurrentClient().getLocale();
            String trainName = this.messageSource.getMessage("training.job.train.name", null, locale);
            String jobName = this.messageSource.getMessage("training.job.job.name", null, locale);
            String learnName = this.messageSource.getMessage("training.learn.title", null, locale);
            String courseName = this.messageSource.getMessage("training.job.course.name", null, locale);
            Map simplePojoMap = ((List)simplePojoBaseList.getData()).stream().collect(Collectors.toMap(SimplePojo::getId, Function.identity()));
            for (TrainingsVo vo : list) {
                SimplePojo pojo = (SimplePojo)simplePojoMap.get(vo.getCreator());
                if (!org.springframework.util.StringUtils.isEmpty((Object)pojo)) {
                    vo.setCreatName(pojo.getName());
                }
                if ("train".equals(vo.getModulName())) {
                    vo.setModulName(trainName);
                    continue;
                }
                if ("job".equals(vo.getModulName())) {
                    vo.setModulName(jobName);
                    continue;
                }
                if ("learn".equals(vo.getModulName())) {
                    vo.setModulName(learnName);
                    continue;
                }
                if (!"course".equals(vo.getModulName())) continue;
                vo.setModulName(courseName);
            }
        }
        return list;
    }

    @Override
    public void updatePaperState(Integer paperId, Integer paperState, Users user) {
        Date now = new Date();
        TrainingPaper trainingPaper = (TrainingPaper)this.paperMapper.selectById(paperId);
        if (!ObjectUtils.isEmpty((Object)trainingPaper)) {
            Integer papeStateOld = trainingPaper.getPaperState();
            if (paperState != null && paperState != 3) {
                if (org.springframework.util.StringUtils.isEmpty((Object)trainingPaper.getStartTime()) || trainingPaper.getStartTime().compareTo(new Date()) <= 0) {
                    paperState = 2;
                }
                if (!org.springframework.util.StringUtils.isEmpty((Object)trainingPaper.getEndTime()) && trainingPaper.getEndTime().compareTo(new Date()) < 0) {
                    paperState = 3;
                }
            }
            trainingPaper.setUpdater(user.getId());
            trainingPaper.setUpdateTime(now);
            trainingPaper.setPaperState(paperState);
            if (trainingPaper.getPaperState() == 3) {
                trainingPaper.setEndTime(now);
                trainingPaper.setIsClose(Integer.valueOf(1));
            }
            if (!(org.springframework.util.StringUtils.isEmpty((Object)trainingPaper.getPaperState()) || org.springframework.util.StringUtils.isEmpty((Object)paperState) || trainingPaper.getPaperState() != 0 || trainingPaper.getPaperType() != 1 || paperState != 1 && paperState != 2 || org.springframework.util.StringUtils.isEmpty((Object)trainingPaper.getExamId()))) {
                trainingPaper.setExamId(this.examService.updateCopyExam(trainingPaper.getExamId(), user.getId()));
            }
            this.paperMapper.updateById(trainingPaper);
            if (trainingPaper.getIsTraining() == 0 && trainingPaper.getPaperState() == 3) {
                SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                this.jPushService.updateMessagesByObjectType(trainingPaper.getId(), "TYPE_PAPER_SYSTEM", null, null, 1, format.format(new Date()));
                this.jPushService.deleteMessages(trainingPaper.getId(), "TYPE_PAPER_SYSTEM", null, null, 1);
                if (trainingPaper.getLookLevel() != null && trainingPaper.getLookLevel() == 1) {
                    this.updateUsersByClose(paperId, user.getId(), user.getGroupId());
                }
            }
            if (trainingPaper.getIsTraining() == 0 && papeStateOld == 1 && paperState == 0) {
                this.jPushService.deleteMessages(trainingPaper.getId(), "TYPE_PAPER_SYSTEM", null, null, 1);
            }
        }
    }

    @Override
    public String deletePaper(Integer paperId, LogPojo pojo) {
        TrainingPaper paper = (TrainingPaper)this.paperMapper.selectById(paperId);
        if (!pojo.getEnterpriseId().equals(paper.getEnterpriseId())) {
            return JsonResult.error((String)"NO_PERMISSION", (Object)"\u65e0\u6743\u9650\u5220\u9664");
        }
        this.paperMapper.deleteById(paperId);
        if (!org.springframework.util.StringUtils.isEmpty((Object)paperId)) {
            try {
                this.jPushService.deleteMessages(paperId, "TYPE_PAPER_SYSTEM", null, null, 1);
            }
            catch (Exception e) {
                log.error("\u5220\u9664\u63a8\u9001\u4fe1\u606f", (Throwable)e);
            }
        }
        pojo.setI18nParam(paper.getTitle());
        this.logApi.save(pojo);
        return JsonResult.success();
    }

    @Override
    public TrainingPapersVo showPaperDetail(Integer paperId) {
        TrainingPaper trainingPaper = (TrainingPaper)this.paperMapper.selectById(paperId);
        TrainingPapersVo trainingPaperVo = new TrainingPapersVo();
        if (!ObjectUtils.isEmpty((Object)trainingPaper)) {
            TrainingMaterialType trainingMaterialType;
            Locale locale = Authenticator.getInstance().getCurrentClient().getLocale();
            trainingPaperVo.setPaperName(trainingPaper.getTitle());
            BeanUtils.copyProperties((Object)trainingPaper, (Object)trainingPaperVo);
            if (!org.springframework.util.StringUtils.isEmpty((Object)trainingPaper.getExamId())) {
                List<TrainingExamQuestionVo> trainingExamQuestionVos = this.trainingExamService.selectExamQuestion(trainingPaper.getExamId());
                trainingPaperVo.setTrainingExamQuestionVos(trainingExamQuestionVos);
                TrainingExam trainingExam = (TrainingExam)this.trainingExamMapper.selectById(trainingPaper.getExamId());
                if (!ObjectUtils.isEmpty((Object)trainingExam)) {
                    String examName = trainingExam == null ? "" : trainingExam.getName();
                    BigDecimal totalScore = trainingExam.getScore();
                    trainingPaperVo.setTotalScore(totalScore);
                    trainingPaperVo.setExamName(examName);
                }
            }
            StringBuffer sb = new StringBuffer("");
            ArrayList<UserBo> users = new ArrayList<UserBo>();
            if (trainingPaper.getLookLevel() != null && trainingPaper.getLookLevel() == 1) {
                List<Integer> whoCanSeeList = this.trainingPaperUserMapper.selectUserIdsByPaperId(trainingPaperVo.getId());
                if (!CollectionUtils.isEmpty(whoCanSeeList)) {
                    BaseResult base = this.userApi.getUserByIdList(whoCanSeeList);
                    if (base != null && !CollectionUtils.isEmpty((Collection)((Collection)base.getData()))) {
                        List pojoList = (List)base.getData();
                        for (UsersPojo pojo : pojoList) {
                            UserBo bo = new UserBo();
                            bo.setId(pojo.getId());
                            bo.setShowName(pojo.getShowName());
                            sb.append(pojo.getShowName()).append("\uff0c");
                            users.add(bo);
                        }
                    }
                    sb.delete(sb.length() - 1, sb.length());
                }
            } else {
                sb.append(this.messageSource.getMessage("training.all.people", null, locale));
            }
            LambdaQueryWrapper roleWrapper = new LambdaQueryWrapper();
            roleWrapper.eq(TrainingPaperUser::getPaperId, (Object)paperId);
            roleWrapper.isNotNull(TrainingPaperUser::getRoleId);
            List roleUserList = this.trainingPaperUserMapper.selectList((Wrapper)roleWrapper);
            if (!CollectionUtils.isEmpty((Collection)roleUserList)) {
                List roleIds = roleUserList.stream().map(TrainingPaperUser::getRoleId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
                com.ovopark.privilege.response.BaseResult base = this.roleApi.getRolePojoByIdList(roleIds);
                ArrayList<Role> rolesList = new ArrayList<Role>();
                if (base != null && !CollectionUtils.isEmpty((Collection)((Collection)base.getData()))) {
                    for (Object pojo : (List)base.getData()) {
                        Role role = new Role();
                        role.setId(pojo.getId());
                        role.setRoleName(pojo.getRoleName());
                        rolesList.add(role);
                        if (sb.length() > 1) {
                            sb.append("," + pojo.getRoleName());
                            continue;
                        }
                        sb.append(pojo.getRoleName());
                    }
                }
                trainingPaperVo.setRoleList(rolesList);
            }
            LambdaQueryWrapper tagWrapper = new LambdaQueryWrapper();
            tagWrapper.eq(TrainingPaperUser::getPaperId, (Object)paperId);
            tagWrapper.isNotNull(TrainingPaperUser::getTagId);
            List tagUserList = this.trainingPaperUserMapper.selectList((Wrapper)tagWrapper);
            if (!CollectionUtils.isEmpty((Collection)tagUserList)) {
                List tagIds = tagUserList.stream().map(TrainingPaperUser::getTagId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
                ArrayList<TagVo> tagList = new ArrayList<TagVo>();
                for (Integer tagId : tagIds) {
                    BaseResult result = this.tagApi.getUsersTagById(tagId);
                    if (result.getIsError().booleanValue() || result.getData() == null) continue;
                    UserTagMo pojo = (UserTagMo)result.getData();
                    TagVo tag = new TagVo();
                    tag.setId(pojo.getId());
                    tag.setName(pojo.getTagName());
                    tagList.add(tag);
                    if (sb.length() > 1) {
                        sb.append("," + pojo.getTagName());
                        continue;
                    }
                    sb.append(pojo.getTagName());
                }
                trainingPaperVo.setTagList(tagList);
            }
            LambdaQueryWrapper orgWrapper = new LambdaQueryWrapper();
            orgWrapper.eq(TrainingPaperUser::getPaperId, (Object)paperId);
            orgWrapper.isNotNull(TrainingPaperUser::getOrganizeId);
            List orgUserList = this.trainingPaperUserMapper.selectList((Wrapper)orgWrapper);
            if (!CollectionUtils.isEmpty((Collection)orgUserList)) {
                List organizeIds = orgUserList.stream().map(TrainingPaperUser::getOrganizeId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
                ArrayList<OrgVo> orgList = new ArrayList<OrgVo>();
                for (String organizeId : organizeIds) {
                    String[] depSplit;
                    OrgVo org;
                    OrganizePojo pojo;
                    BaseResult result;
                    if (organizeId.startsWith("O_")) {
                        String[] orgSplit = organizeId.split("O_");
                        result = this.organizeApi.getOrganizeById(Integer.valueOf(Integer.parseInt(orgSplit[1])));
                        if (result.getIsError().booleanValue() || result.getData() == null) continue;
                        pojo = (OrganizePojo)result.getData();
                        org = new OrgVo();
                        org.setId(organizeId);
                        org.setName(pojo.getName());
                        orgList.add(org);
                        if (sb.length() > 1) {
                            sb.append("," + pojo.getName());
                            continue;
                        }
                        sb.append(pojo.getName());
                        continue;
                    }
                    if (!organizeId.startsWith("S_") || (result = this.departmentApi.getDepartmentById(Integer.valueOf(Integer.parseInt((depSplit = organizeId.split("S_"))[1])))).getIsError().booleanValue() || result.getData() == null) continue;
                    pojo = (DepartmentPojo)result.getData();
                    org = new OrgVo();
                    org.setId(organizeId);
                    org.setName(pojo.getName());
                    orgList.add(org);
                    if (sb.length() > 1) {
                        sb.append("," + pojo.getName());
                        continue;
                    }
                    sb.append(pojo.getName());
                }
                trainingPaperVo.setOrganizeList(orgList);
            }
            ArrayList<UserBo> examiners = new ArrayList<UserBo>();
            StringBuffer sbExaminer = new StringBuffer("");
            if (trainingPaperVo.getReviewerType() != null) {
                List<Integer> userIdList = new ArrayList<Integer>();
                if (trainingPaperVo.getReviewerType() == 1) {
                    userIdList.add(trainingPaperVo.getCreater());
                } else if (trainingPaperVo.getReviewerType() == 4) {
                    LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
                    queryWrapper.eq(TrainingExaminer::getTrainingPaperId, (Object)paperId);
                    queryWrapper.eq(Objects.nonNull(trainingPaper.getEnterpriseId()), TrainingExaminer::getEnterpriseId, (Object)trainingPaper.getEnterpriseId());
                    List trainingExaminerList = this.trainingExaminerMapper.selectList((Wrapper)queryWrapper);
                    if (!CollectionUtils.isEmpty((Collection)trainingExaminerList)) {
                        userIdList = trainingExaminerList.stream().map(TrainingExaminer::getUserId).collect(Collectors.toList());
                    }
                }
                if (!CollectionUtils.isEmpty(userIdList)) {
                    Map<Integer, UsersPojo> usersPojoMap = this.userUtilService.selectUserMap(userIdList);
                    for (Integer userId : userIdList) {
                        UserBo userBo = new UserBo();
                        UsersPojo usersPojo = usersPojoMap.get(userId);
                        userBo.setId(userId);
                        userBo.setShowName(usersPojo.getShowName());
                        userBo.setUserName(usersPojo.getUserName());
                        examiners.add(userBo);
                    }
                    if (!CollectionUtils.isEmpty(examiners)) {
                        examiners.stream().forEach(u -> sbExaminer.append(u.getShowName()).append("\uff0c"));
                        sbExaminer.delete(sbExaminer.length() - 1, sbExaminer.length());
                    }
                }
            }
            trainingPaperVo.setExaminerNames(sbExaminer.toString());
            trainingPaperVo.setPaperUserNames(sb.toString());
            trainingPaperVo.setExaminerIds(examiners);
            trainingPaperVo.setPaperUserIds(users);
            if (trainingPaperVo.getTypeId() != null && !ObjectUtils.isEmpty((Object)(trainingMaterialType = (TrainingMaterialType)this.trainingMaterialTypeMapper.selectById(trainingPaperVo.getTypeId())))) {
                trainingPaperVo.setTypeName(trainingMaterialType.getMaterialTypeName());
                trainingPaperVo.setMaterialTypeLevel(trainingMaterialType.getMaterialTypeLevel());
                trainingPaperVo.setSourceId(trainingMaterialType.getSourceId());
                trainingPaperVo.setOriginId(trainingMaterialType.getOriginId());
            }
        }
        return trainingPaperVo;
    }

    @Override
    public List<TrainingPapersVo> selectPapersVoList(TrainingPapersVo papersVo, Users user) {
        BaseResult tagResult;
        List<Integer> roleList;
        ArrayList paperIds = new ArrayList();
        LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper1.isNull(TrainingPaper::getLookLevel)).ne(TrainingPaper::getPaperState, (Object)0)).isNotNull(TrainingPaper::getExamId)).eq(TrainingPaper::getEnterpriseId, (Object)user.getGroupId())).eq(TrainingPaper::getIsTraining, (Object)0)).isNull(TrainingPaper::getProjectShow);
        wrapper1.like(!org.springframework.util.StringUtils.isEmpty((Object)papersVo.getTitle()), TrainingPaper::getTitle, (Object)papersVo.getTitle());
        wrapper1.eq(!org.springframework.util.StringUtils.isEmpty((Object)papersVo.getId()), TrainingPaper::getId, (Object)papersVo.getId());
        if (!(org.springframework.util.StringUtils.isEmpty((Object)papersVo.getPaperState()) || papersVo.getPaperState() != 1 && papersVo.getPaperState() != 2)) {
            wrapper1.eq(TrainingPaper::getPaperState, (Object)papersVo.getPaperState());
        }
        wrapper1.and(wq -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wq.isNull(TrainingPaper::getEndTime)).or()).gt(TrainingPaper::getEndTime, (Object)user.getCreateTime());
        });
        List paper1 = this.paperMapper.selectList((Wrapper)wrapper1);
        if (!CollectionUtils.isEmpty((Collection)paper1)) {
            List paperId = paper1.stream().map(TrainingPaper::getId).distinct().collect(Collectors.toList());
            paperIds.addAll(paperId);
        }
        ArrayList allPaper = new ArrayList();
        LambdaQueryWrapper wrapper2 = new LambdaQueryWrapper();
        wrapper2.eq(TrainingPaperUser::getUserId, (Object)user.getId());
        wrapper2.eq(!org.springframework.util.StringUtils.isEmpty((Object)papersVo.getId()), TrainingPaperUser::getPaperId, (Object)papersVo.getId());
        List paper2 = this.trainingPaperUserMapper.selectList((Wrapper)wrapper2);
        if (!CollectionUtils.isEmpty((Collection)paper2)) {
            allPaper.addAll(paper2);
        }
        if (!CollectionUtils.isEmpty(roleList = this.userUtilService.selectUserRoleList(user))) {
            LambdaQueryWrapper roleWrapper = new LambdaQueryWrapper();
            roleWrapper.eq(TrainingPaperUser::getEnterpriseId, (Object)user.getGroupId());
            roleWrapper.eq(!org.springframework.util.StringUtils.isEmpty((Object)papersVo.getId()), TrainingPaperUser::getPaperId, (Object)papersVo.getId());
            roleWrapper.in(TrainingPaperUser::getRoleId, roleList);
            List rolePaper = this.trainingPaperUserMapper.selectList((Wrapper)roleWrapper);
            if (!CollectionUtils.isEmpty((Collection)rolePaper)) {
                allPaper.addAll(rolePaper);
            }
        }
        if (!(tagResult = this.tagApi.getUsersTagByUserId(user.getId())).getIsError().booleanValue() && !CollectionUtils.isEmpty((Collection)((Collection)tagResult.getData()))) {
            LambdaQueryWrapper tagWrapper = new LambdaQueryWrapper();
            tagWrapper.eq(TrainingPaperUser::getEnterpriseId, (Object)user.getGroupId());
            tagWrapper.eq(!org.springframework.util.StringUtils.isEmpty((Object)papersVo.getId()), TrainingPaperUser::getPaperId, (Object)papersVo.getId());
            tagWrapper.in(TrainingPaperUser::getTagId, (Collection)((List)tagResult.getData()).stream().map(UserTagMo::getId).distinct().collect(Collectors.toList()));
            List tagPaper = this.trainingPaperUserMapper.selectList((Wrapper)tagWrapper);
            if (!CollectionUtils.isEmpty((Collection)tagPaper)) {
                allPaper.addAll(tagPaper);
            }
        }
        ArrayList<String> orgIds = new ArrayList<String>();
        UsersAndOrgsMo mo = new UsersAndOrgsMo();
        mo.setGroupId(user.getGroupId());
        mo.setUserId(user.getId());
        mo.setRetainAll(Boolean.valueOf(false));
        mo.setShowAllPath(Boolean.valueOf(true));
        BaseResult orgResult = this.userOrganizeApi.getUserOrganizeByUserIdAndOrg(mo);
        if (!orgResult.getIsError().booleanValue() && !CollectionUtils.isEmpty((Map)((Map)orgResult.getData()))) {
            List list;
            Map map = (Map)orgResult.getData();
            if (!CollectionUtils.isEmpty((Collection)((Collection)map.get("O_")))) {
                list = (List)map.get("O_");
                for (Integer id : list) {
                    orgIds.add("O_" + id);
                }
            }
            if (!CollectionUtils.isEmpty((Collection)((Collection)map.get("S_")))) {
                list = (List)map.get("S_");
                for (Integer id : list) {
                    orgIds.add("S_" + id);
                }
            }
        }
        if (!CollectionUtils.isEmpty(orgIds)) {
            LambdaQueryWrapper orgWrapper = new LambdaQueryWrapper();
            orgWrapper.eq(TrainingPaperUser::getEnterpriseId, (Object)user.getGroupId());
            orgWrapper.eq(!org.springframework.util.StringUtils.isEmpty((Object)papersVo.getId()), TrainingPaperUser::getPaperId, (Object)papersVo.getId());
            orgWrapper.in(TrainingPaperUser::getOrganizeId, orgIds);
            List orgPaper = this.trainingPaperUserMapper.selectList((Wrapper)orgWrapper);
            if (!CollectionUtils.isEmpty((Collection)orgPaper)) {
                allPaper.addAll(orgPaper);
            }
        }
        if (!CollectionUtils.isEmpty(allPaper)) {
            List paper3;
            List paperId = allPaper.stream().map(TrainingPaperUser::getPaperId).distinct().collect(Collectors.toList());
            LambdaQueryWrapper wrapper3 = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper3.in(TrainingPaper::getId, paperId)).ne(TrainingPaper::getPaperState, (Object)0)).isNotNull(TrainingPaper::getExamId)).eq(TrainingPaper::getIsTraining, (Object)0)).isNull(TrainingPaper::getProjectShow);
            wrapper3.like(!org.springframework.util.StringUtils.isEmpty((Object)papersVo.getTitle()), TrainingPaper::getTitle, (Object)papersVo.getTitle());
            if (!(org.springframework.util.StringUtils.isEmpty((Object)papersVo.getPaperState()) || papersVo.getPaperState() != 1 && papersVo.getPaperState() != 2)) {
                wrapper3.eq(TrainingPaper::getPaperState, (Object)papersVo.getPaperState());
            }
            if (!CollectionUtils.isEmpty((Collection)(paper3 = this.paperMapper.selectList((Wrapper)wrapper3)))) {
                List paperId1 = paper3.stream().map(TrainingPaper::getId).distinct().collect(Collectors.toList());
                paperIds.addAll(paperId1);
            }
        }
        ArrayList<TrainingPapersVo> papersVos = new ArrayList<TrainingPapersVo>();
        if (!CollectionUtils.isEmpty(paperIds)) {
            LambdaQueryWrapper wrapper6 = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper6.eq(TrainingUserPaper::getUserId, (Object)user.getId())).in(TrainingUserPaper::getTrainingPaperId, paperIds)).and(wq -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wq.isNull(TrainingUserPaper::getSourceType)).or()).eq(TrainingUserPaper::getSourceType, (Object)2);
            })).orderByDesc(TrainingUserPaper::getSubmitTime);
            List userPaperList = this.userPaperMapper.selectList((Wrapper)wrapper6);
            Map<Object, Object> userPaperMap = new HashMap();
            if (!CollectionUtils.isEmpty((Collection)userPaperList)) {
                userPaperMap = userPaperList.stream().collect(Collectors.toMap(TrainingUserPaper::getTrainingPaperId, e -> new ArrayList<TrainingUserPaper>(Arrays.asList(e)), (oldList, newList) -> {
                    oldList.addAll(newList);
                    return oldList;
                }));
            }
            if (!org.springframework.util.StringUtils.isEmpty((Object)papersVo.getPaperState())) {
                List userPapers;
                ArrayList<Object> deList;
                Object paperId2;
                Object paper3;
                LambdaQueryWrapper wrapper3;
                if (papersVo.getPaperState() == 1) {
                    wrapper3 = new LambdaQueryWrapper();
                    ((LambdaQueryWrapper)wrapper3.eq(TrainingPaper::getPaperState, (Object)1)).eq(user.getGroupId() != null, TrainingPaper::getEnterpriseId, (Object)user.getGroupId());
                    paper3 = this.paperMapper.selectList((Wrapper)wrapper3);
                    if (!CollectionUtils.isEmpty((Collection)paper3)) {
                        paperId2 = paper3.stream().map(TrainingPaper::getId).distinct().collect(Collectors.toList());
                        paperIds.retainAll((Collection<?>)paperId2);
                    } else {
                        paperIds = new ArrayList();
                    }
                } else if (papersVo.getPaperState() == 2) {
                    deList = new ArrayList<Object>();
                    for (Object paperId2 : paperIds) {
                        userPapers = (List)userPaperMap.get(paperId2);
                        if (CollectionUtils.isEmpty((Collection)userPapers)) continue;
                        if (userPapers.size() > 1) {
                            deList.add(paperId2);
                            continue;
                        }
                        if (userPapers.size() != 1 || ((TrainingUserPaper)userPapers.get(0)).getSubmitTime() == null) continue;
                        deList.add(paperId2);
                    }
                    if (!CollectionUtils.isEmpty(deList)) {
                        paperIds.removeAll(deList);
                    }
                } else if (papersVo.getPaperState() == 3) {
                    deList = new ArrayList();
                    for (Object paperId2 : paperIds) {
                        userPapers = (List)userPaperMap.get(paperId2);
                        if (!CollectionUtils.isEmpty((Collection)userPapers)) {
                            if (userPapers.size() != 1 || ((TrainingUserPaper)userPapers.get(0)).getSubmitTime() != null) continue;
                            deList.add(paperId2);
                            continue;
                        }
                        deList.add(paperId2);
                    }
                    if (!CollectionUtils.isEmpty(deList)) {
                        paperIds.removeAll(deList);
                    }
                } else if (papersVo.getPaperState() == 4) {
                    wrapper3 = new LambdaQueryWrapper();
                    ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper3.eq(user.getGroupId() != null, TrainingPaper::getEnterpriseId, (Object)user.getGroupId())).eq(TrainingPaper::getPaperState, (Object)3)).gt(TrainingPaper::getEndTime, (Object)user.getCreateTime());
                    paper3 = this.paperMapper.selectList((Wrapper)wrapper3);
                    if (!CollectionUtils.isEmpty((Collection)paper3)) {
                        paperId2 = paper3.stream().map(TrainingPaper::getId).distinct().collect(Collectors.toList());
                        paperIds.retainAll((Collection<?>)paperId2);
                        if (!CollectionUtils.isEmpty(paperIds)) {
                            ArrayList<Integer> deList2 = new ArrayList<Integer>();
                            for (Integer paperId1 : paperIds) {
                                List userPapers2 = (List)userPaperMap.get(paperId1);
                                if (CollectionUtils.isEmpty((Collection)userPapers2)) continue;
                                if (userPapers2.size() > 1) {
                                    deList2.add(paperId1);
                                    continue;
                                }
                                if (userPapers2.size() != 1 || ((TrainingUserPaper)userPapers2.get(0)).getSubmitTime() == null) continue;
                                deList2.add(paperId1);
                            }
                            if (!CollectionUtils.isEmpty(deList2)) {
                                paperIds.removeAll(deList2);
                            }
                        }
                    } else {
                        paperIds = new ArrayList();
                    }
                }
            }
            if (!CollectionUtils.isEmpty(paperIds)) {
                LambdaQueryWrapper wrapper8 = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)wrapper8.in(TrainingPaper::getId, paperIds)).orderByDesc(TrainingPaper::getId);
                List paperList = this.paperMapper.selectList((Wrapper)wrapper8);
                Map<Object, Object> examMap = new HashMap();
                Map<Object, Object> examQuestionMap = new HashMap();
                Map<Object, Object> paperRandomMap = new HashMap();
                List examIds = paperList.stream().map(TrainingPaper::getExamId).distinct().collect(Collectors.toList());
                if (!CollectionUtils.isEmpty(examIds)) {
                    List examList = this.trainingExamMapper.selectBatchIds(examIds);
                    examMap = examList.stream().collect(Collectors.toMap(TrainingExam::getId, Function.identity()));
                    LambdaQueryWrapper wrapper9 = new LambdaQueryWrapper();
                    ((LambdaQueryWrapper)wrapper9.eq(TrainingExamQuestion::getQuestionType, (Object)1)).in(TrainingExamQuestion::getExamId, examIds);
                    List examQuestions = this.examQuestionMapper.selectList((Wrapper)wrapper9);
                    if (!CollectionUtils.isEmpty((Collection)examQuestions)) {
                        examQuestionMap = examQuestions.stream().collect(Collectors.toMap(TrainingExamQuestion::getExamId, e -> new ArrayList<TrainingExamQuestion>(Arrays.asList(e)), (oldList, newList) -> {
                            oldList.addAll(newList);
                            return oldList;
                        }));
                    }
                    LambdaQueryWrapper wrapper10 = new LambdaQueryWrapper();
                    ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper10.eq(TrainingPaperRandom::getQuestionType, (Object)1)).in(TrainingPaperRandom::getExamId, examIds)).gt(TrainingPaperRandom::getQuestionTypeNum, (Object)0);
                    List paperRandoms = this.trainingPaperRandomMapper.selectList((Wrapper)wrapper10);
                    if (!CollectionUtils.isEmpty((Collection)paperRandoms)) {
                        paperRandomMap = paperRandoms.stream().collect(Collectors.toMap(TrainingPaperRandom::getExamId, e -> new ArrayList<TrainingPaperRandom>(Arrays.asList(e)), (oldList, newList) -> {
                            oldList.addAll(newList);
                            return oldList;
                        }));
                    }
                }
                for (TrainingPaper paper : paperList) {
                    List userPapers = (List)userPaperMap.get(paper.getId());
                    if (paper.getIsMustLink() == 1 && CollectionUtils.isEmpty((Collection)userPapers)) continue;
                    TrainingPapersVo trainingPapersVo = new TrainingPapersVo();
                    BeanUtils.copyProperties((Object)paper, (Object)trainingPapersVo);
                    TrainingExam exam = (TrainingExam)examMap.get(paper.getExamId());
                    Integer questionCount = 0;
                    BigDecimal totalScore = new BigDecimal(0);
                    BigDecimal passScore = new BigDecimal(0);
                    Integer isReview = 0;
                    if (!org.springframework.util.StringUtils.isEmpty((Object)exam)) {
                        questionCount = exam.getCount();
                        totalScore = exam.getScore();
                        Integer passLine = 60;
                        if (!org.springframework.util.StringUtils.isEmpty((Object)paper.getPassLine())) {
                            passLine = paper.getPassLine();
                        }
                        passScore = exam.getScore().multiply(new BigDecimal(passLine)).multiply(new BigDecimal(0.01)).setScale(2, 4);
                        if (!org.springframework.util.StringUtils.isEmpty((Object)exam.getExamClass()) && exam.getExamClass() == 2) {
                            if (!CollectionUtils.isEmpty((Collection)((Collection)paperRandomMap.get(exam.getId())))) {
                                isReview = 1;
                            }
                        } else if (!CollectionUtils.isEmpty((Collection)((Collection)examQuestionMap.get(exam.getId())))) {
                            isReview = 1;
                        }
                    }
                    trainingPapersVo.setIsReview(isReview);
                    trainingPapersVo.setQuestionCount(questionCount);
                    trainingPapersVo.setTotalScore(totalScore);
                    trainingPapersVo.setPassScore(passScore);
                    if (!org.springframework.util.StringUtils.isEmpty((Object)papersVo.getPaperState())) {
                        if (papersVo.getPaperState() == 2) {
                            if (!CollectionUtils.isEmpty((Collection)userPapers) && ((TrainingUserPaper)userPapers.get(0)).getUpdateTime() != null) {
                                trainingPapersVo.setStatus(Integer.valueOf(2));
                                trainingPapersVo.setIsAutoRead(((TrainingUserPaper)userPapers.get(0)).getIsAutoRead());
                            } else {
                                trainingPapersVo.setStatus(Integer.valueOf(1));
                            }
                        } else if (papersVo.getPaperState() == 3) {
                            List questionList;
                            LambdaQueryWrapper questionWrapper;
                            BigDecimal score;
                            Integer scoreSelect = paper.getScoreSelect() != null ? paper.getScoreSelect() : 1;
                            trainingPapersVo.setPaperCount(Integer.valueOf(userPapers.size()));
                            if (scoreSelect == 0) {
                                List tempList = userPapers.stream().filter(e -> e.getPaperStatus() == 2).collect(Collectors.toList());
                                TrainingUserPaper temp = CollectionUtils.isEmpty(tempList) ? (TrainingUserPaper)userPapers.get(0) : (TrainingUserPaper)tempList.stream().sorted(Comparator.comparing(TrainingUserPaper::getScore).reversed()).collect(Collectors.toList()).get(0);
                                trainingPapersVo.setIsAutoRead(temp.getIsAutoRead());
                                if (temp.getPaperStatus() == 1) {
                                    trainingPapersVo.setStatus(Integer.valueOf(5));
                                } else {
                                    score = temp.getScore();
                                    trainingPapersVo.setScore(score);
                                    if (!org.springframework.util.StringUtils.isEmpty((Object)exam) && score.multiply(new BigDecimal(100)).compareTo(exam.getScore().multiply(new BigDecimal(paper.getPassLine()))) < 0) {
                                        trainingPapersVo.setStatus(Integer.valueOf(4));
                                    } else {
                                        trainingPapersVo.setStatus(Integer.valueOf(3));
                                    }
                                }
                                questionWrapper = new LambdaQueryWrapper();
                                questionWrapper.eq(TrainingUserQuestion::getUserPaperId, (Object)temp.getId());
                                questionWrapper.eq(TrainingUserQuestion::getIsReviewed, (Object)0);
                                questionWrapper.eq(TrainingUserQuestion::getQuestionType, (Object)1);
                                questionList = this.trainingUserQuestionMapper.selectList((Wrapper)questionWrapper);
                                if (CollectionUtils.isEmpty((Collection)questionList)) {
                                    trainingPapersVo.setIsReview(Integer.valueOf(0));
                                } else {
                                    trainingPapersVo.setIsReview(Integer.valueOf(1));
                                }
                            } else {
                                List tempList = userPapers.stream().filter(e -> e.getPaperStatus() == 2).collect(Collectors.toList());
                                TrainingUserPaper temp = CollectionUtils.isEmpty(tempList) ? (TrainingUserPaper)userPapers.get(0) : (TrainingUserPaper)tempList.get(0);
                                trainingPapersVo.setIsAutoRead(temp.getIsAutoRead());
                                if (temp.getPaperStatus() == 1) {
                                    trainingPapersVo.setStatus(Integer.valueOf(5));
                                } else {
                                    score = temp.getScore();
                                    trainingPapersVo.setScore(score);
                                    if (!org.springframework.util.StringUtils.isEmpty((Object)exam) && score.multiply(new BigDecimal(100)).compareTo(exam.getScore().multiply(new BigDecimal(paper.getPassLine()))) < 0) {
                                        trainingPapersVo.setStatus(Integer.valueOf(4));
                                    } else {
                                        trainingPapersVo.setStatus(Integer.valueOf(3));
                                    }
                                }
                                questionWrapper = new LambdaQueryWrapper();
                                questionWrapper.eq(TrainingUserQuestion::getUserPaperId, (Object)temp.getId());
                                questionWrapper.eq(TrainingUserQuestion::getIsReviewed, (Object)0);
                                questionWrapper.eq(TrainingUserQuestion::getQuestionType, (Object)1);
                                questionList = this.trainingUserQuestionMapper.selectList((Wrapper)questionWrapper);
                                if (CollectionUtils.isEmpty((Collection)questionList)) {
                                    trainingPapersVo.setIsReview(Integer.valueOf(0));
                                } else {
                                    trainingPapersVo.setIsReview(Integer.valueOf(1));
                                }
                            }
                        } else if (papersVo.getPaperState() == 4) {
                            if (!CollectionUtils.isEmpty((Collection)userPapers)) {
                                trainingPapersVo.setStatus(Integer.valueOf(7));
                                trainingPapersVo.setIsAutoRead(((TrainingUserPaper)userPapers.get(0)).getIsAutoRead());
                            } else {
                                trainingPapersVo.setStatus(Integer.valueOf(6));
                            }
                        }
                    }
                    papersVos.add(trainingPapersVo);
                }
            }
        }
        return papersVos;
    }

    @Override
    public TrainingPapersVo selectPapersVo(TrainingPapersVo papersVo) {
        UsersPojo pojo;
        TrainingExam exam;
        TrainingPaper paper = (TrainingPaper)this.paperMapper.selectById(papersVo.getId());
        if (!ObjectUtils.isEmpty((Object)paper)) {
            BeanUtils.copyProperties((Object)paper, (Object)papersVo);
        }
        if (!ObjectUtils.isEmpty((Object)papersVo) && papersVo.getPaperState() != null && papersVo.getPaperState() == 3 && papersVo.getIsTraining() == 1 && (org.springframework.util.StringUtils.isEmpty((Object)papersVo.getEndTime()) || papersVo.getEndTime().after(new Date()))) {
            papersVo.setPaperState(Integer.valueOf(2));
        }
        if (!ObjectUtils.isEmpty((Object)(exam = (TrainingExam)this.trainingExamMapper.selectById(papersVo.getExamId())))) {
            papersVo.setTotalScore(exam.getScore());
            papersVo.setPassScore(exam.getScore().multiply(new BigDecimal(papersVo.getPassLine())).multiply(new BigDecimal(0.01)).setScale(2, 4));
            papersVo.setQuestionCount(exam.getCount());
        }
        papersVo.setScoreSelect(Integer.valueOf(papersVo.getScoreSelect() == null ? 1 : papersVo.getScoreSelect()));
        papersVo.setStartTime(papersVo.getStartTime() == null ? papersVo.getUpdateTime() : papersVo.getStartTime());
        LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper1.eq(TrainingUserPaper::getTrainingPaperId, (Object)papersVo.getId())).eq(TrainingUserPaper::getUserId, (Object)papersVo.getUserId())).eq(!org.springframework.util.StringUtils.isEmpty((Object)papersVo.getSourceType()), TrainingUserPaper::getSourceType, (Object)papersVo.getSourceType())).eq(!org.springframework.util.StringUtils.isEmpty((Object)papersVo.getSourceProjectId()), TrainingUserPaper::getSourceProjectId, (Object)papersVo.getSourceProjectId())).eq(!org.springframework.util.StringUtils.isEmpty((Object)papersVo.getSourceTaskId()), TrainingUserPaper::getSourceTaskId, (Object)papersVo.getSourceTaskId())).eq(!org.springframework.util.StringUtils.isEmpty((Object)papersVo.getSourceShiftId()), TrainingUserPaper::getSourceShiftId, (Object)papersVo.getSourceShiftId())).orderByDesc(TrainingUserPaper::getId);
        List userPaperList = this.userPaperMapper.selectList((Wrapper)wrapper1);
        Integer paperCount = 0;
        Integer isNotFinish = 0;
        if (!CollectionUtils.isEmpty((Collection)userPaperList)) {
            papersVo.setIsAutoRead(((TrainingUserPaper)userPaperList.get(0)).getIsAutoRead());
            paperCount = userPaperList.size();
            if (((TrainingUserPaper)userPaperList.get(0)).getSubmitTime() == null) {
                isNotFinish = 1;
                Integer n = paperCount;
                Integer n2 = paperCount = Integer.valueOf(paperCount - 1);
            }
        }
        papersVo.setPaperCount(paperCount);
        papersVo.setIsNotFinish(isNotFinish);
        String name = "";
        if (!ObjectUtils.isEmpty((Object)papersVo.getCreater()) && !ObjectUtils.isEmpty((Object)(pojo = this.userUtilService.selectUser(paper.getCreater())))) {
            name = pojo.getShowName();
        }
        papersVo.setCreaterName(name);
        return papersVo;
    }

    @Override
    public int selectIsPaperPower(TrainingPapersVo papersVo, Users user) {
        int isInPaper = 0;
        TrainingPaper paper = (TrainingPaper)this.paperMapper.selectById(papersVo.getPaperId());
        if (!ObjectUtils.isEmpty((Object)paper)) {
            if (!Objects.isNull(paper.getLookLevel())) {
                List paperIdList;
                BaseResult tagResult;
                List<Integer> roleList;
                ArrayList allPaper = new ArrayList();
                LambdaQueryWrapper wrapper2 = new LambdaQueryWrapper();
                wrapper2.eq(TrainingPaperUser::getUserId, (Object)user.getId());
                wrapper2.eq(!org.springframework.util.StringUtils.isEmpty((Object)papersVo.getPaperId()), TrainingPaperUser::getPaperId, (Object)papersVo.getPaperId());
                List paper2 = this.trainingPaperUserMapper.selectList((Wrapper)wrapper2);
                if (!CollectionUtils.isEmpty((Collection)paper2)) {
                    allPaper.addAll(paper2);
                }
                if (!CollectionUtils.isEmpty(roleList = this.userUtilService.selectUserRoleList(user))) {
                    LambdaQueryWrapper roleWrapper = new LambdaQueryWrapper();
                    roleWrapper.eq(TrainingPaperUser::getEnterpriseId, (Object)user.getGroupId());
                    roleWrapper.eq(!org.springframework.util.StringUtils.isEmpty((Object)papersVo.getPaperId()), TrainingPaperUser::getPaperId, (Object)papersVo.getPaperId());
                    roleWrapper.in(TrainingPaperUser::getRoleId, roleList);
                    List rolePaper = this.trainingPaperUserMapper.selectList((Wrapper)roleWrapper);
                    if (!CollectionUtils.isEmpty((Collection)rolePaper)) {
                        allPaper.addAll(rolePaper);
                    }
                }
                if (!(tagResult = this.tagApi.getUsersTagByUserId(user.getId())).getIsError().booleanValue() && !CollectionUtils.isEmpty((Collection)((Collection)tagResult.getData()))) {
                    LambdaQueryWrapper tagWrapper = new LambdaQueryWrapper();
                    tagWrapper.eq(TrainingPaperUser::getEnterpriseId, (Object)user.getGroupId());
                    tagWrapper.eq(!org.springframework.util.StringUtils.isEmpty((Object)papersVo.getPaperId()), TrainingPaperUser::getPaperId, (Object)papersVo.getPaperId());
                    tagWrapper.in(TrainingPaperUser::getTagId, (Collection)((List)tagResult.getData()).stream().map(UserTagMo::getId).distinct().collect(Collectors.toList()));
                    List tagPaper = this.trainingPaperUserMapper.selectList((Wrapper)tagWrapper);
                    if (!CollectionUtils.isEmpty((Collection)tagPaper)) {
                        allPaper.addAll(tagPaper);
                    }
                }
                ArrayList<String> orgIds = new ArrayList<String>();
                UsersAndOrgsMo mo = new UsersAndOrgsMo();
                mo.setGroupId(user.getGroupId());
                mo.setUserId(user.getId());
                mo.setRetainAll(Boolean.valueOf(false));
                mo.setShowAllPath(Boolean.valueOf(true));
                BaseResult orgResult = this.userOrganizeApi.getUserOrganizeByUserIdAndOrg(mo);
                if (!orgResult.getIsError().booleanValue() && !CollectionUtils.isEmpty((Map)((Map)orgResult.getData()))) {
                    List list;
                    Map map = (Map)orgResult.getData();
                    if (!CollectionUtils.isEmpty((Collection)((Collection)map.get("O_")))) {
                        list = (List)map.get("O_");
                        for (Integer id : list) {
                            orgIds.add("O_" + id);
                        }
                    }
                    if (!CollectionUtils.isEmpty((Collection)((Collection)map.get("S_")))) {
                        list = (List)map.get("S_");
                        for (Integer id : list) {
                            orgIds.add("S_" + id);
                        }
                    }
                }
                if (!CollectionUtils.isEmpty(orgIds)) {
                    LambdaQueryWrapper orgWrapper = new LambdaQueryWrapper();
                    orgWrapper.eq(TrainingPaperUser::getEnterpriseId, (Object)user.getGroupId());
                    orgWrapper.eq(!org.springframework.util.StringUtils.isEmpty((Object)papersVo.getPaperId()), TrainingPaperUser::getPaperId, (Object)papersVo.getPaperId());
                    orgWrapper.in(TrainingPaperUser::getOrganizeId, orgIds);
                    List orgPaper = this.trainingPaperUserMapper.selectList((Wrapper)orgWrapper);
                    if (!CollectionUtils.isEmpty((Collection)orgPaper)) {
                        allPaper.addAll(orgPaper);
                    }
                }
                if ((paperIdList = allPaper.stream().map(TrainingPaperUser::getPaperId).distinct().collect(Collectors.toList())).contains(papersVo.getPaperId())) {
                    isInPaper = 0;
                } else {
                    this.jPushService.deleteMessages(papersVo.getPaperId(), "TYPE_PAPER_SYSTEM", user.getId(), null, 1);
                    isInPaper = 1;
                }
            }
        } else {
            this.jPushService.deleteMessages(papersVo.getPaperId(), "TYPE_PAPER_SYSTEM", user.getId(), null, 1);
            isInPaper = 2;
        }
        return isInPaper;
    }

    @Override
    public TrainingPapersVo selectPaperQuestions(TrainingUserPaperVo userPaperVo) {
        Date now = new Date();
        TrainingPapersVo papersVo = new TrainingPapersVo();
        Integer isReview = 0;
        ArrayList<TrainingUserQuestionVo> userQuestionVoList = new ArrayList<TrainingUserQuestionVo>();
        TrainingPaper paper = (TrainingPaper)this.paperMapper.selectById(userPaperVo.getTrainingPaperId());
        if (ObjectUtils.isEmpty((Object)paper)) {
            return papersVo;
        }
        BeanUtils.copyProperties((Object)paper, (Object)papersVo);
        TrainingUserPaper userPaper = new TrainingUserPaper();
        LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper1.eq(TrainingUserPaper::getUserId, (Object)userPaperVo.getUserId())).eq(TrainingUserPaper::getTrainingPaperId, (Object)userPaperVo.getTrainingPaperId())).eq(TrainingUserPaper::getPaperStatus, (Object)0)).isNotNull(TrainingUserPaper::getUserId)).orderByDesc(TrainingUserPaper::getId);
        List userPapers = this.userPaperMapper.selectList((Wrapper)wrapper1);
        if (!CollectionUtils.isEmpty((Collection)userPapers) && !ObjectUtils.isEmpty(userPapers.get(0))) {
            userPaper = (TrainingUserPaper)userPapers.get(0);
            isReview = this.getUserPaperQuestions(userPaperVo, userPaper, isReview, userQuestionVoList, now);
        } else {
            userPaper.setCreateTime(now);
            userPaper.setUpdateTime(now);
            userPaper.setTitle(papersVo.getTitle());
            userPaper.setPicUrl(papersVo.getPicUrl());
            userPaper.setTrainingPaperId(papersVo.getId());
            userPaper.setUserId(userPaperVo.getUserId());
            userPaper.setScore(new BigDecimal(0));
            userPaper.setPaperStatus(Integer.valueOf(0));
            userPaper.setPaperCreateTime(now);
            userPaper.setEnterpriseId(papersVo.getEnterpriseId());
            userPaper.setTrainingNavId(papersVo.getTrainingNavId());
            userPaper.setLookLevel(papersVo.getLookLevel());
            userPaper.setPaperCount(Integer.valueOf(papersVo.getRepetitionNum() == null ? 999 : papersVo.getRepetitionNum()));
            userPaper.setSourceType(userPaperVo.getSourceType());
            userPaper.setSourceProjectId(userPaperVo.getSourceProjectId());
            userPaper.setSourceTaskId(userPaperVo.getSourceTaskId());
            userPaper.setSourceShiftId(userPaperVo.getSourceShiftId());
            this.userPaperMapper.insert(userPaper);
        }
        if (!CollectionUtils.isEmpty(userQuestionVoList)) {
            papersVo.setUserQuestionVoList(userQuestionVoList);
            return papersVo;
        }
        if (paper.getExamId() == null) {
            return papersVo;
        }
        TrainingExam trainExam = (TrainingExam)this.examMapper.selectById(paper.getExamId());
        if (ObjectUtils.isEmpty((Object)trainExam)) {
            return papersVo;
        }
        if (trainExam.getExamClass() == 1) {
            LambdaQueryWrapper wrapper3 = new LambdaQueryWrapper();
            wrapper3.eq(TrainingExamQuestion::getExamId, (Object)paper.getExamId());
            List examQuestions = this.examQuestionMapper.selectList((Wrapper)wrapper3);
            if (CollectionUtils.isEmpty((Collection)examQuestions)) {
                return papersVo;
            }
            this.getFixedPaperQuestions(userPaperVo, examQuestions, paper, now, papersVo, userPaper, userQuestionVoList);
        } else {
            this.getRandomPaperQuestions(userPaperVo, trainExam, paper, now, papersVo, userPaper, userQuestionVoList);
        }
        if (!CollectionUtils.isEmpty(userQuestionVoList)) {
            this.userQuestionMapper.insertList(userQuestionVoList);
            for (TrainingUserQuestionVo userQuestionVo : userQuestionVoList) {
                if (userQuestionVo.getQuestionType() != 1) continue;
                isReview = 1;
            }
            userPaper.setIsReview(isReview);
            this.userPaperMapper.updateById(userPaper);
        }
        papersVo.setUserQuestionVoList(userQuestionVoList);
        return papersVo;
    }

    private void getRandomPaperQuestions(TrainingUserPaperVo userPaperVo, TrainingExam trainExam, TrainingPaper paper, Date now, TrainingPapersVo papersVo, TrainingUserPaper userPaper, List<TrainingUserQuestionVo> userQuestionVoList) {
        ArrayList<Integer> trainingQuestionType = new ArrayList();
        if (trainExam.getTrainingQuestion() != null) {
            String[] quess = trainExam.getTrainingQuestion().split(",");
            trainingQuestionType = Arrays.asList(quess).stream().map(Integer::parseInt).collect(Collectors.toList());
        }
        LambdaQueryWrapper wrapper3 = new LambdaQueryWrapper();
        wrapper3.eq(TrainingPaperRandom::getExamId, (Object)trainExam.getId());
        List trainingPaperRandoms = this.trainingPaperRandomMapper.selectList((Wrapper)wrapper3);
        ArrayList<TrainingQuestionVo> questionVoList = new ArrayList<TrainingQuestionVo>();
        if (!CollectionUtils.isEmpty((Collection)trainingPaperRandoms)) {
            TrainingQuestionVo trainingQuestionVo = null;
            for (TrainingPaperRandom trainingPaperRandom : trainingPaperRandoms) {
                List<TrainingQuestion> qList = this.questionMapper.selectRandByQuestionTypes(trainingPaperRandom.getQuestionType(), trainExam.getEnterpriseId(), trainingPaperRandom.getQuestionTypeNum(), trainingQuestionType);
                for (TrainingQuestion trainingQuestion : qList) {
                    trainingQuestionVo = new TrainingQuestionVo();
                    trainingQuestionVo.setId(trainingQuestion.getId());
                    trainingQuestionVo.setQuestionName(trainingQuestion.getName());
                    trainingQuestionVo.setRemark(trainingQuestion.getRemark());
                    trainingQuestionVo.setQuestionType(trainingQuestion.getQuestionType());
                    trainingQuestionVo.setScore(Double.valueOf(Double.parseDouble(trainingPaperRandom.getQuestionScore() + "")));
                    trainingQuestionVo.setPicturePath(trainingQuestion.getPicturePath());
                    questionVoList.add(trainingQuestionVo);
                }
            }
        }
        List questionIds = questionVoList.stream().map(TrainingQuestion::getId).collect(Collectors.toList());
        Map<Object, Object> questionMap = new HashMap();
        Map<Object, Object> optionMap = new HashMap();
        if (!CollectionUtils.isEmpty(questionIds)) {
            List questionList = this.questionMapper.selectBatchIds(questionIds);
            questionMap = questionList.stream().collect(Collectors.toMap(TrainingQuestion::getId, Function.identity()));
            List<Integer> questionList1 = questionList.stream().filter(e -> e.getQuestionType() == 0 || e.getQuestionType() == 3 || e.getQuestionType() == 4).map(TrainingQuestion::getId).collect(Collectors.toList());
            ArrayList<Integer> questionList2 = new ArrayList<Integer>(questionIds);
            questionList2.removeAll(questionList1);
            ArrayList<TrainingOptionsVo> optionList = new ArrayList<TrainingOptionsVo>();
            if (!CollectionUtils.isEmpty(questionList1)) {
                List<TrainingOptionsVo> optionList1 = this.optionsMapper.selectOptionsByQuestionId(questionList1);
                if (paper.getIsOption() != null && paper.getIsOption() == 1) {
                    Collections.shuffle(optionList1);
                }
                optionList.addAll(optionList1);
            }
            if (!CollectionUtils.isEmpty(questionList2)) {
                List<TrainingOptionsVo> optionList2 = this.optionsMapper.selectOptionsByQuestionId(questionList2);
                optionList.addAll(optionList2);
            }
            if (!CollectionUtils.isEmpty(optionList)) {
                optionMap = optionList.stream().collect(Collectors.groupingBy(TrainingOptionsVo::getQuestionId));
            }
        }
        TrainingUserQuestionVo userQuestionVo = null;
        TrainingOptionsVo vo1 = null;
        TrainingOptionsVo vo2 = null;
        for (TrainingQuestionVo questionVo : questionVoList) {
            TrainingQuestion question = (TrainingQuestion)questionMap.get(questionVo.getId());
            userQuestionVo = new TrainingUserQuestionVo();
            userQuestionVo.setCreateTime(now);
            userQuestionVo.setUpdateTime(now);
            userQuestionVo.setName(question.getName());
            userQuestionVo.setUserId(userPaperVo.getUserId());
            userQuestionVo.setQuestionId(question.getId());
            userQuestionVo.setPaperId(papersVo.getId());
            userQuestionVo.setUserPaperId(userPaper.getId());
            userQuestionVo.setIsCorrect(Integer.valueOf(0));
            userQuestionVo.setPicturePath(questionVo.getPicturePath());
            userQuestionVo.setRemark(question.getRemark());
            userQuestionVo.setEnterpriseId(papersVo.getEnterpriseId());
            userQuestionVo.setQuestionType(question.getQuestionType());
            userQuestionVo.setOriginScore(new BigDecimal(questionVo.getScore()));
            userQuestionVo.setScore(BigDecimal.ZERO);
            userQuestionVo.setIsEmpty(Integer.valueOf(1));
            userQuestionVo.setIsUpload(question.getIsUpload());
            userQuestionVo.setIsReviewed(Integer.valueOf(0));
            ArrayList<TrainingOptionsVo> optionsList = (ArrayList<TrainingOptionsVo>)optionMap.get(questionVo.getId());
            if (CollectionUtils.isEmpty((Collection)optionsList)) {
                optionsList = new ArrayList<TrainingOptionsVo>();
            }
            if (!org.springframework.util.StringUtils.isEmpty((Object)question.getQuestionType()) && question.getQuestionType() == 4) {
                optionsList = new ArrayList();
                vo1 = new TrainingOptionsVo();
                vo1.setIsAnswer(Integer.valueOf(1));
                vo1.setOptionsName(question.getIsCorrect().toString());
                vo1.setQuestionId(question.getId());
                vo2 = new TrainingOptionsVo();
                vo2.setIsAnswer(Integer.valueOf(0));
                vo2.setOptionsName(question.getIsCorrect() == 1 ? "0" : "1");
                vo2.setQuestionId(question.getId());
                if (question.getIsCorrect() == 1) {
                    optionsList.add(vo1);
                    optionsList.add(vo2);
                } else {
                    optionsList.add(vo2);
                    optionsList.add(vo1);
                }
                if (paper.getIsOption() != null && paper.getIsOption() == 1) {
                    Collections.shuffle(optionsList);
                }
            }
            userQuestionVo.setOptionsVoList(optionsList);
            userQuestionVo.setOptionsData(JSONArray.toJSONString(optionsList));
            userQuestionVoList.add(userQuestionVo);
        }
    }

    private void getFixedPaperQuestions(TrainingUserPaperVo userPaperVo, List<TrainingExamQuestion> examQuestions, TrainingPaper paper, Date now, TrainingPapersVo papersVo, TrainingUserPaper userPaper, List<TrainingUserQuestionVo> userQuestionVoList) {
        ArrayList<TrainingExamQuestion> singleList = new ArrayList<TrainingExamQuestion>();
        ArrayList<TrainingExamQuestion> essayList = new ArrayList<TrainingExamQuestion>();
        ArrayList<TrainingExamQuestion> fillList = new ArrayList<TrainingExamQuestion>();
        ArrayList<TrainingExamQuestion> multipleList = new ArrayList<TrainingExamQuestion>();
        ArrayList<TrainingExamQuestion> judgeList = new ArrayList<TrainingExamQuestion>();
        for (TrainingExamQuestion trainingExamQuestion : examQuestions) {
            if (trainingExamQuestion.getQuestionType() == 0) {
                singleList.add(trainingExamQuestion);
                continue;
            }
            if (trainingExamQuestion.getQuestionType() == 1) {
                essayList.add(trainingExamQuestion);
                continue;
            }
            if (trainingExamQuestion.getQuestionType() == 2) {
                fillList.add(trainingExamQuestion);
                continue;
            }
            if (trainingExamQuestion.getQuestionType() == 3) {
                multipleList.add(trainingExamQuestion);
                continue;
            }
            if (trainingExamQuestion.getQuestionType() != 4) continue;
            judgeList.add(trainingExamQuestion);
        }
        ArrayList<TrainingExamQuestion> examQuestions1 = new ArrayList<TrainingExamQuestion>();
        ArrayList<TrainingExamQuestion> examQuestions2 = new ArrayList<TrainingExamQuestion>();
        if (paper.getIsQuestion() != null && paper.getIsQuestion() == 1) {
            examQuestions = new ArrayList<TrainingExamQuestion>();
            if (!CollectionUtils.isEmpty(singleList)) {
                Collections.shuffle(singleList);
                examQuestions.addAll(singleList);
                examQuestions1.addAll(singleList);
            }
            if (!CollectionUtils.isEmpty(multipleList)) {
                Collections.shuffle(multipleList);
                examQuestions.addAll(multipleList);
                examQuestions1.addAll(multipleList);
            }
            if (!CollectionUtils.isEmpty(judgeList)) {
                Collections.shuffle(judgeList);
                examQuestions.addAll(judgeList);
                examQuestions1.addAll(judgeList);
            }
            if (!CollectionUtils.isEmpty(fillList)) {
                Collections.shuffle(fillList);
                examQuestions.addAll(fillList);
                examQuestions2.addAll(fillList);
            }
            if (!CollectionUtils.isEmpty(essayList)) {
                Collections.shuffle(essayList);
                examQuestions.addAll(essayList);
                examQuestions2.addAll(essayList);
            }
        } else {
            if (!CollectionUtils.isEmpty(singleList)) {
                examQuestions1.addAll(singleList);
            }
            if (!CollectionUtils.isEmpty(multipleList)) {
                examQuestions1.addAll(multipleList);
            }
            if (!CollectionUtils.isEmpty(judgeList)) {
                examQuestions1.addAll(judgeList);
            }
            if (!CollectionUtils.isEmpty(fillList)) {
                examQuestions2.addAll(fillList);
            }
            if (!CollectionUtils.isEmpty(essayList)) {
                examQuestions2.addAll(essayList);
            }
        }
        List questionIds1 = examQuestions1.stream().map(TrainingExamQuestion::getId).collect(Collectors.toList());
        List questionIds2 = examQuestions2.stream().map(TrainingExamQuestion::getId).collect(Collectors.toList());
        ArrayList<TrainingOptionsVo> optionList1 = new ArrayList<TrainingOptionsVo>();
        if (!CollectionUtils.isEmpty(questionIds1)) {
            LambdaQueryWrapper wrapper4 = new LambdaQueryWrapper();
            wrapper4.in(TrainingExamOptions::getExamQuestionId, questionIds1);
            List examOptionsList1 = this.examOptionsMapper.selectList((Wrapper)wrapper4);
            if (!CollectionUtils.isEmpty((Collection)examOptionsList1)) {
                TrainingOptionsVo optionsVo = null;
                for (Object examOptions : examOptionsList1) {
                    optionsVo = new TrainingOptionsVo();
                    optionsVo.setId(examOptions.getId());
                    optionsVo.setOptionsName(examOptions.getContent());
                    optionsVo.setIsAnswer(examOptions.getIsAnswer());
                    optionsVo.setQuestionId(examOptions.getExamQuestionId());
                    optionsVo.setPicturePath(examOptions.getPicturePath());
                    optionList1.add(optionsVo);
                }
            }
        }
        ArrayList<TrainingOptionsVo> optionList2 = new ArrayList<TrainingOptionsVo>();
        if (!CollectionUtils.isEmpty(questionIds2)) {
            LambdaQueryWrapper wrapper5 = new LambdaQueryWrapper();
            wrapper5.in(TrainingExamOptions::getExamQuestionId, questionIds2);
            List examOptionsList2 = this.examOptionsMapper.selectList((Wrapper)wrapper5);
            if (!CollectionUtils.isEmpty((Collection)examOptionsList2)) {
                TrainingOptionsVo optionsVo = null;
                for (TrainingExamOptions examOptions : examOptionsList2) {
                    optionsVo = new TrainingOptionsVo();
                    optionsVo.setId(examOptions.getId());
                    optionsVo.setOptionsName(examOptions.getContent());
                    optionsVo.setIsAnswer(examOptions.getIsAnswer());
                    optionsVo.setQuestionId(examOptions.getExamQuestionId());
                    optionsVo.setPicturePath(examOptions.getPicturePath());
                    optionList2.add(optionsVo);
                }
            }
        }
        ArrayList<TrainingOptionsVo> optionList = new ArrayList<TrainingOptionsVo>();
        Map<Object, Object> optionMap = new HashMap();
        if (!CollectionUtils.isEmpty(optionList1)) {
            if (paper.getIsOption() != null && paper.getIsOption() == 1) {
                Collections.shuffle(optionList1);
            }
            optionList.addAll(optionList1);
        }
        if (!CollectionUtils.isEmpty(optionList2)) {
            optionList.addAll(optionList2);
        }
        if (!CollectionUtils.isEmpty(optionList)) {
            optionMap = optionList.stream().collect(Collectors.groupingBy(TrainingOptionsVo::getQuestionId));
        }
        TrainingUserQuestionVo userQuestionVo = null;
        TrainingOptionsVo vo = null;
        for (TrainingExamQuestion examQuestion : examQuestions) {
            userQuestionVo = new TrainingUserQuestionVo();
            userQuestionVo.setCreateTime(now);
            userQuestionVo.setUpdateTime(now);
            userQuestionVo.setName(examQuestion.getContent());
            userQuestionVo.setUserId(userPaperVo.getUserId());
            userQuestionVo.setQuestionId(examQuestion.getId());
            userQuestionVo.setPaperId(papersVo.getId());
            userQuestionVo.setUserPaperId(userPaper.getId());
            userQuestionVo.setIsCorrect(Integer.valueOf(0));
            userQuestionVo.setEnterpriseId(papersVo.getEnterpriseId());
            userQuestionVo.setQuestionType(examQuestion.getQuestionType());
            userQuestionVo.setPicturePath(examQuestion.getPicturePath());
            userQuestionVo.setRemark(examQuestion.getRemark());
            userQuestionVo.setOriginScore(examQuestion.getScore());
            userQuestionVo.setIsEmpty(Integer.valueOf(1));
            userQuestionVo.setScore(BigDecimal.ZERO);
            userQuestionVo.setIsReviewed(Integer.valueOf(0));
            userQuestionVo.setIsUpload(examQuestion.getIsUpload());
            ArrayList<TrainingOptionsVo> optionsList = (ArrayList<TrainingOptionsVo>)optionMap.get(examQuestion.getId());
            if (CollectionUtils.isEmpty((Collection)optionsList)) {
                optionsList = new ArrayList<TrainingOptionsVo>();
            }
            if (!org.springframework.util.StringUtils.isEmpty((Object)examQuestion.getQuestionType()) && examQuestion.getQuestionType() == 4 && !CollectionUtils.isEmpty(optionsList) && optionsList.size() == 1) {
                TrainingOptionsVo vos = (TrainingOptionsVo)optionsList.get(0);
                vo = new TrainingOptionsVo();
                vo.setIsAnswer(Integer.valueOf(0));
                vo.setQuestionId(vos.getQuestionId());
                vo.setOptionsName(vos.getOptionsName().trim().equals("1") ? "0" : "1");
                if (vos.getOptionsName().trim().equals("1")) {
                    optionsList.add(vo);
                } else {
                    optionsList = new ArrayList();
                    optionsList.add(vo);
                    optionsList.add(vos);
                }
                if (paper.getIsOption() != null && paper.getIsOption() == 1) {
                    Collections.shuffle(optionsList);
                }
            }
            userQuestionVo.setOptionsVoList(optionsList);
            userQuestionVo.setOptionsData(JSONArray.toJSONString(optionsList));
            userQuestionVoList.add(userQuestionVo);
        }
    }

    private Integer getUserPaperQuestions(TrainingUserPaperVo userPaperVo, TrainingUserPaper userPaper, Integer isReview, List<TrainingUserQuestionVo> userQuestionVoList, Date now) {
        LambdaQueryWrapper wrapper2 = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper2.eq(TrainingUserQuestion::getUserPaperId, (Object)userPaper.getId())).eq(TrainingUserQuestion::getPaperId, (Object)userPaperVo.getTrainingPaperId())).eq(TrainingUserQuestion::getUserId, (Object)userPaperVo.getUserId());
        List userQuestionList = this.userQuestionMapper.selectList((Wrapper)wrapper2);
        if (!CollectionUtils.isEmpty((Collection)userQuestionList)) {
            Map<Object, Object> picMap = new HashMap();
            ArrayList<Integer> userQuestionIdList = new ArrayList<Integer>();
            for (TrainingUserQuestion userQuestion : userQuestionList) {
                if (userQuestion.getQuestionType() != 1) continue;
                userQuestionIdList.add(userQuestion.getId());
                isReview = 1;
            }
            if (!CollectionUtils.isEmpty(userQuestionIdList)) {
                LambdaQueryWrapper wrapper3 = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper3.in(TrainingUserQuestionPicture::getUserQuestionId, userQuestionIdList)).eq(TrainingUserQuestionPicture::getPictureType, (Object)1)).eq(TrainingUserQuestionPicture::getIsDelete, (Object)0);
                List userQuestionPictures = this.userQuestionPictureMapper.selectList((Wrapper)wrapper3);
                if (!CollectionUtils.isEmpty((Collection)userQuestionPictures)) {
                    picMap = userQuestionPictures.stream().collect(Collectors.groupingBy(TrainingUserQuestionPicture::getUserQuestionId));
                }
            }
            List optionsList = new ArrayList();
            TrainingUserQuestionVo userQuestionVo = null;
            for (TrainingUserQuestion userQuestion : userQuestionList) {
                userQuestionVo = new TrainingUserQuestionVo();
                BeanUtils.copyProperties((Object)userQuestion, (Object)userQuestionVo);
                if (!org.springframework.util.StringUtils.isEmpty((Object)userQuestionVo.getOptionsData())) {
                    optionsList = JSONObject.parseArray((String)userQuestionVo.getOptionsData(), TrainingOptionsVo.class);
                    if (userQuestion.getQuestionType() == 4) {
                        // empty if block
                    }
                }
                userQuestionVo.setOptionsVoList(optionsList);
                userQuestionVo.setOptionsData(null);
                if (userQuestion.getQuestionType() == 1) {
                    List questionPictureList = (List)picMap.get(userQuestion.getId());
                    userQuestionVo.setUserQuestionPictureList(questionPictureList);
                }
                userQuestionVo.setIsReviewed(Integer.valueOf(0));
                userQuestionVoList.add(userQuestionVo);
            }
        }
        if (org.springframework.util.StringUtils.isEmpty((Object)userPaper.getUpdateTime())) {
            userPaper.setUpdateTime(now);
        }
        userPaper.setSourceType(userPaperVo.getSourceType());
        userPaper.setSourceProjectId(userPaperVo.getSourceProjectId());
        userPaper.setSourceTaskId(userPaperVo.getSourceTaskId());
        userPaper.setSourceShiftId(userPaperVo.getSourceShiftId());
        userPaper.setIsReview(isReview);
        this.userPaperMapper.updateById(userPaper);
        return isReview;
    }

    @Override
    public void saveHalfQuestions(List<TrainingUserQuestionVo> userQuestionVoList) {
        try {
            if (!CollectionUtils.isEmpty(userQuestionVoList)) {
                TrainingUserQuestionVo userQuestionVo = userQuestionVoList.get(0);
                TrainingPaper paper = (TrainingPaper)this.paperMapper.selectById(userQuestionVo.getPaperId());
                ArrayList<Integer> userQuestionIdList = new ArrayList<Integer>();
                ArrayList<TrainingUserQuestionPicture> userQuestionPictureList = new ArrayList<TrainingUserQuestionPicture>();
                for (TrainingUserQuestionVo userQuestion : userQuestionVoList) {
                    ArrayList optionsList = userQuestion.getOptionsVoList();
                    if (CollectionUtils.isEmpty((Collection)optionsList)) {
                        optionsList = new ArrayList();
                    }
                    userQuestion.setOptionsData(JSONArray.toJSONString((Object)optionsList));
                    this.userQuestionMapper.updateById(userQuestion);
                    if (userQuestion.getQuestionType() == 1) {
                        userQuestionIdList.add(userQuestion.getId());
                    }
                    if (CollectionUtils.isEmpty((Collection)userQuestion.getUserQuestionPictureList())) continue;
                    for (TrainingUserQuestionPicture userQuestionPicture : userQuestion.getUserQuestionPictureList()) {
                        userQuestionPicture.setUserQuestionId(userQuestion.getId());
                        userQuestionPicture.setPictureType(Integer.valueOf(1));
                        userQuestionPicture.setCreateTime(new Date());
                        userQuestionPicture.setEnterpriseId(paper.getEnterpriseId());
                        userQuestionPicture.setIsDelete(Integer.valueOf(0));
                        userQuestionPictureList.add(userQuestionPicture);
                    }
                }
                if (!CollectionUtils.isEmpty(userQuestionIdList)) {
                    LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
                    ((LambdaUpdateWrapper)wrapper.in(TrainingUserQuestionPicture::getUserQuestionId, userQuestionIdList)).eq(TrainingUserQuestionPicture::getIsDelete, (Object)0);
                    TrainingUserQuestionPicture questionPicture = new TrainingUserQuestionPicture();
                    questionPicture.setIsDelete(Integer.valueOf(1));
                    this.userQuestionPictureMapper.update(questionPicture, (Wrapper)wrapper);
                }
                if (!CollectionUtils.isEmpty(userQuestionPictureList)) {
                    this.userQuestionPictureMapper.insertList(userQuestionPictureList);
                }
            }
        }
        catch (Exception e) {
            log.error("saveHalfQuestions", (Throwable)e);
        }
    }

    @Override
    public TrainingUserPaper saveUserQuestions(List<TrainingUserQuestionVo> userQuestionVoList) {
        TrainingUserPaper userPaper = new TrainingUserPaper();
        if (CollectionUtils.isEmpty(userQuestionVoList) || ObjectUtils.isEmpty((Object)userQuestionVoList.get(0))) {
            return userPaper;
        }
        TrainingUserQuestionVo userQuestionVo = userQuestionVoList.get(0);
        if (userQuestionVo.getUserPaperId() == null) {
            return userPaper;
        }
        userPaper = (TrainingUserPaper)this.userPaperMapper.selectById(userQuestionVo.getUserPaperId());
        if (ObjectUtils.isEmpty((Object)userPaper)) {
            return userPaper;
        }
        userPaper.setIsAutoRead(Integer.valueOf(1));
        userPaper.setPaperStatus(Integer.valueOf(2));
        BigDecimal totalScore = BigDecimal.ZERO;
        ArrayList<Integer> userQuestionIdList = new ArrayList<Integer>();
        ArrayList<TrainingUserQuestionPicture> userQuestionPictureList = new ArrayList<TrainingUserQuestionPicture>();
        TrainingPaper trainingPaper = (TrainingPaper)this.trainingPaperMapper.selectById(userPaper.getTrainingPaperId());
        for (TrainingUserQuestionVo userQuestion : userQuestionVoList) {
            Object object;
            Object object2;
            userQuestion.setIsCorrect(Integer.valueOf(0));
            userQuestion.setScore(new BigDecimal(0));
            List optionsList = userQuestion.getOptionsVoList();
            if (CollectionUtils.isEmpty((Collection)optionsList)) {
                optionsList = Lists.newArrayList();
            } else {
                TrainingPaper paper = (TrainingPaper)this.paperMapper.selectById(userPaper.getTrainingPaperId());
                if (!ObjectUtils.isEmpty((Object)paper)) {
                    Object list;
                    if (paper.getExamId() != null) {
                        TrainingExamOptions options;
                        LambdaQueryWrapper optionsWrapper;
                        TrainingExam exam = (TrainingExam)this.trainingExamMapper.selectById(paper.getExamId());
                        if (exam.getExamClass().equals(1)) {
                            optionsWrapper = new LambdaQueryWrapper();
                            optionsWrapper.eq(TrainingExamOptions::getExamQuestionId, (Object)userQuestion.getQuestionId());
                            list = this.trainingExamOptionsMapper.selectList((Wrapper)optionsWrapper);
                            if (!CollectionUtils.isEmpty((Collection)list)) {
                                object2 = list.iterator();
                                while (object2.hasNext()) {
                                    options = (TrainingExamOptions)object2.next();
                                    for (TrainingOptionsVo optionsVo : optionsList) {
                                        if (!options.getId().equals(optionsVo.getId())) continue;
                                        optionsVo.setIsAnswer(options.getIsAnswer());
                                    }
                                }
                            }
                        } else {
                            optionsWrapper = new LambdaQueryWrapper();
                            optionsWrapper.eq(TrainingOptions::getTrainingQuestionId, (Object)userQuestion.getQuestionId());
                            list = this.trainingOptionsMapper.selectList((Wrapper)optionsWrapper);
                            if (!CollectionUtils.isEmpty((Collection)list)) {
                                object2 = list.iterator();
                                while (object2.hasNext()) {
                                    options = (TrainingOptions)object2.next();
                                    for (TrainingOptionsVo optionsVo : optionsList) {
                                        if (!options.getId().equals(optionsVo.getId())) continue;
                                        optionsVo.setIsAnswer(options.getIsAnswer());
                                    }
                                }
                            }
                        }
                    } else {
                        LambdaQueryWrapper optionsWrapper = new LambdaQueryWrapper();
                        optionsWrapper.eq(TrainingOptions::getTrainingQuestionId, (Object)userQuestion.getQuestionId());
                        List list2 = this.trainingOptionsMapper.selectList((Wrapper)optionsWrapper);
                        if (!CollectionUtils.isEmpty((Collection)list2)) {
                            list = list2.iterator();
                            while (list.hasNext()) {
                                TrainingOptions options = (TrainingOptions)list.next();
                                for (TrainingOptionsVo optionsVo : optionsList) {
                                    if (!options.getId().equals(optionsVo.getId())) continue;
                                    optionsVo.setIsAnswer(options.getIsAnswer());
                                }
                            }
                        }
                    }
                }
            }
            if (!CollectionUtils.isEmpty((Collection)optionsList) && userQuestion.getQuestionType() == 0) {
                for (Object vo : optionsList) {
                    if (org.springframework.util.StringUtils.isEmpty((Object)vo.getIsSelect()) || vo.getIsSelect() != 1 || org.springframework.util.StringUtils.isEmpty((Object)vo.getIsAnswer()) || vo.getIsAnswer() != 1) continue;
                    userQuestion.setIsCorrect(Integer.valueOf(1));
                    userQuestion.setScore(userQuestion.getOriginScore());
                }
            } else if (userQuestion.getQuestionType() == 1) {
                userPaper.setIsReview(Integer.valueOf(1));
                if (!(ObjectUtils.isEmpty((Object)trainingPaper) || trainingPaper.getIsAutoRead() == null || !trainingPaper.getIsAutoRead().equals(1) || CollectionUtils.isEmpty((Collection)optionsList) || optionsList.size() == 1 && org.springframework.util.StringUtils.isEmpty((Object)((TrainingOptionsVo)optionsList.get(0)).getOptionsName()))) {
                    int rightNum = 0;
                    String answer = ((TrainingOptionsVo)optionsList.get(0)).getAnswer();
                    block8: for (Object vo2 : optionsList) {
                        if (org.springframework.util.StringUtils.isEmpty((Object)answer) || org.springframework.util.StringUtils.isEmpty((Object)vo2.getOptionsName())) continue;
                        List<String> optionsLists = StringsUtils.String2List(vo2.getOptionsName(), "&");
                        for (String option : optionsLists) {
                            if (!answer.contains(option)) continue;
                            ++rightNum;
                            continue block8;
                        }
                    }
                    userQuestion.setIsReviewed(Integer.valueOf(1));
                    userQuestion.setScore(new BigDecimal(userQuestion.getOriginScore().intValue() * rightNum / optionsList.size()));
                    if (rightNum == optionsList.size()) {
                        userQuestion.setIsCorrect(Integer.valueOf(1));
                    }
                    userPaper.setMarkingTime(new Date());
                    userPaper.setIsAutoRead(Integer.valueOf(1));
                } else {
                    userPaper.setPaperStatus(Integer.valueOf(1));
                    userQuestionIdList.add(userQuestion.getId());
                    if (!CollectionUtils.isEmpty((Collection)optionsList)) {
                        block10: for (Object vo : optionsList) {
                            Object vo2;
                            if (org.springframework.util.StringUtils.isEmpty((Object)vo.getAnswer()) || org.springframework.util.StringUtils.isEmpty((Object)vo.getOptionsName())) continue;
                            List<String> optionsLists = StringsUtils.String2List(vo.getOptionsName(), "&");
                            vo2 = optionsLists.iterator();
                            while (vo2.hasNext()) {
                                String option = (String)vo2.next();
                                if (!vo.getAnswer().contains(option)) continue;
                                continue block10;
                            }
                        }
                    }
                }
            } else if (!CollectionUtils.isEmpty((Collection)optionsList) && userQuestion.getQuestionType() == 2) {
                if (!ObjectUtils.isEmpty((Object)trainingPaper) && trainingPaper.getIsGapAutoRead() != null && trainingPaper.getIsGapAutoRead().equals(0)) {
                    userPaper.setPaperStatus(Integer.valueOf(1));
                    userPaper.setIsReview(Integer.valueOf(1));
                    userQuestion.setIsReviewed(Integer.valueOf(0));
                } else {
                    Object vo;
                    userQuestion.setIsReviewed(Integer.valueOf(1));
                    Integer correctNum = 0;
                    vo = optionsList.iterator();
                    while (vo.hasNext()) {
                        List<String> optionsLists;
                        TrainingOptionsVo vo3 = (TrainingOptionsVo)vo.next();
                        if (org.springframework.util.StringUtils.isEmpty((Object)vo3.getAnswer()) || org.springframework.util.StringUtils.isEmpty((Object)vo3.getOptionsName()) || !(optionsLists = StringsUtils.String2List(vo3.getOptionsName(), "&")).contains(vo3.getAnswer().trim())) continue;
                        object2 = correctNum;
                        correctNum = correctNum + 1;
                        object = correctNum;
                        vo3.setIsAnswer(Integer.valueOf(1));
                    }
                    if (correctNum > 0) {
                        if (correctNum.intValue() == optionsList.size()) {
                            userQuestion.setIsCorrect(Integer.valueOf(1));
                        }
                        userQuestion.setScore(userQuestion.getOriginScore().multiply(new BigDecimal(correctNum)).divide(new BigDecimal(optionsList.size()), 1, 4));
                    }
                }
            } else if (!CollectionUtils.isEmpty((Collection)optionsList) && userQuestion.getQuestionType() == 3) {
                Integer questionNum = 0;
                Integer correctNum = 0;
                for (Object vo2 : optionsList) {
                    if (!org.springframework.util.StringUtils.isEmpty((Object)vo2.getIsAnswer()) && vo2.getIsAnswer() == 1) {
                        object2 = questionNum;
                        questionNum = questionNum + 1;
                        object = questionNum;
                        if (org.springframework.util.StringUtils.isEmpty((Object)vo2.getIsSelect()) || vo2.getIsSelect() != 1) continue;
                        object2 = correctNum;
                        correctNum = correctNum + 1;
                        object = correctNum;
                        continue;
                    }
                    if (org.springframework.util.StringUtils.isEmpty((Object)vo2.getIsSelect()) || vo2.getIsSelect() != 1) continue;
                    object2 = correctNum;
                    correctNum = correctNum - 1;
                    object = correctNum;
                }
                if (correctNum > 0 && questionNum == correctNum) {
                    userQuestion.setIsCorrect(Integer.valueOf(1));
                    userQuestion.setScore(userQuestion.getOriginScore());
                }
            } else if (!CollectionUtils.isEmpty((Collection)optionsList) && userQuestion.getQuestionType() == 4) {
                for (Object vo : optionsList) {
                    if (org.springframework.util.StringUtils.isEmpty((Object)vo.getIsSelect()) || vo.getIsSelect() != 1 || org.springframework.util.StringUtils.isEmpty((Object)vo.getIsAnswer()) || vo.getIsAnswer() != 1) continue;
                    userQuestion.setIsCorrect(Integer.valueOf(1));
                    userQuestion.setScore(userQuestion.getOriginScore());
                }
            }
            userQuestion.setOptionsData(JSONArray.toJSONString((Object)optionsList));
            this.userQuestionMapper.updateById(userQuestion);
            if (!CollectionUtils.isEmpty((Collection)userQuestion.getUserQuestionPictureList())) {
                for (TrainingUserQuestionPicture userQuestionPicture : userQuestion.getUserQuestionPictureList()) {
                    userQuestionPicture.setUserQuestionId(userQuestion.getId());
                    userQuestionPicture.setPictureType(Integer.valueOf(1));
                    userQuestionPicture.setCreateTime(new Date());
                    userQuestionPicture.setEnterpriseId(userPaper.getEnterpriseId());
                    userQuestionPicture.setIsDelete(Integer.valueOf(0));
                    userQuestionPictureList.add(userQuestionPicture);
                }
            }
            totalScore = totalScore.add(userQuestion.getScore());
        }
        if (!CollectionUtils.isEmpty(userQuestionIdList)) {
            LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
            ((LambdaUpdateWrapper)wrapper.in(TrainingUserQuestionPicture::getUserQuestionId, userQuestionIdList)).eq(TrainingUserQuestionPicture::getIsDelete, (Object)0);
            TrainingUserQuestionPicture questionPicture = new TrainingUserQuestionPicture();
            questionPicture.setIsDelete(Integer.valueOf(1));
            this.userQuestionPictureMapper.update(questionPicture, (Wrapper)wrapper);
        }
        if (!CollectionUtils.isEmpty(userQuestionPictureList)) {
            this.userQuestionPictureMapper.insertList(userQuestionPictureList);
        }
        userPaper.setSubmitTime(new Date());
        userPaper.setScore(totalScore);
        this.userPaperMapper.updateById(userPaper);
        return userPaper;
    }

    @Override
    public TrainingUserPaperVo selectUserPaperResult(TrainingUserPaper userPaper) {
        TrainingExam exam;
        TrainingUserPaperVo userPaperVo = new TrainingUserPaperVo();
        if (ObjectUtils.isEmpty((Object)(userPaper = (TrainingUserPaper)this.userPaperMapper.selectById(userPaper.getId())))) {
            return userPaperVo;
        }
        BeanUtils.copyProperties((Object)userPaper, (Object)userPaperVo);
        TrainingPaper paper = (TrainingPaper)this.paperMapper.selectById(userPaper.getTrainingPaperId());
        if (ObjectUtils.isEmpty((Object)paper)) {
            return userPaperVo;
        }
        if (paper.getIsAutoRead() != null && paper.getIsAutoRead() == 1) {
            userPaperVo.setIsAutoRead(paper.getIsAutoRead());
        } else {
            userPaperVo.setIsAutoRead(Integer.valueOf(0));
        }
        Integer paperCount = paper.getRepetitionNum() == null ? 999 : paper.getRepetitionNum();
        Integer scoreSelect = paper.getScoreSelect() == null ? 1 : paper.getScoreSelect();
        userPaperVo.setScoreSelect(scoreSelect);
        Integer passLine = paper.getPassLine() == null ? 60 : paper.getPassLine();
        BigDecimal totalScore = new BigDecimal(100);
        if (paper.getExamId() != null && !ObjectUtils.isEmpty((Object)(exam = (TrainingExam)this.examMapper.selectById(paper.getExamId())))) {
            totalScore = exam.getScore();
        }
        LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper1.eq(TrainingUserPaper::getUserId, (Object)userPaper.getUserId())).eq(TrainingUserPaper::getTrainingPaperId, (Object)userPaper.getTrainingPaperId())).eq(!org.springframework.util.StringUtils.isEmpty((Object)userPaper.getSourceType()), TrainingUserPaper::getSourceType, (Object)userPaper.getSourceType())).eq(!org.springframework.util.StringUtils.isEmpty((Object)userPaper.getSourceProjectId()), TrainingUserPaper::getSourceProjectId, (Object)userPaper.getSourceProjectId())).eq(!org.springframework.util.StringUtils.isEmpty((Object)userPaper.getSourceTaskId()), TrainingUserPaper::getSourceTaskId, (Object)userPaper.getSourceTaskId())).eq(!org.springframework.util.StringUtils.isEmpty((Object)userPaper.getSourceShiftId()), TrainingUserPaper::getSourceShiftId, (Object)userPaper.getSourceShiftId())).orderByDesc(TrainingUserPaper::getId);
        List userPaperList = this.userPaperMapper.selectList((Wrapper)wrapper1);
        Integer paperNum = 0;
        BigDecimal actScore = BigDecimal.ZERO;
        if (!CollectionUtils.isEmpty((Collection)userPaperList)) {
            paperNum = userPaperList.size();
            paperCount = paperCount - paperNum;
            if (!CollectionUtils.isEmpty((Collection)userPaperList)) {
                for (int i = 0; i < userPaperList.size(); ++i) {
                    TrainingUserPaper up = (TrainingUserPaper)userPaperList.get(i);
                    if (!up.getPaperStatus().equals(2)) continue;
                    if (scoreSelect == 1) {
                        actScore = up.getScore();
                        break;
                    }
                    if (!(up.getScore().doubleValue() > actScore.doubleValue())) continue;
                    actScore = up.getScore();
                }
            }
        }
        userPaperVo.setPaperCount(paperCount);
        userPaperVo.setActScore(actScore);
        userPaperVo.setPaperNum(paperNum);
        Integer passStatus = 2;
        if (userPaperVo.getPaperStatus() == 1) {
            passStatus = 1;
        } else if (actScore.compareTo(totalScore.multiply(new BigDecimal(passLine)).divide(new BigDecimal(100), 2, 4)) < 0) {
            passStatus = 3;
        }
        userPaperVo.setPassStatus(passStatus);
        LambdaQueryWrapper wrapper2 = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper2.eq(TrainingUserPaper::getUserId, (Object)userPaper.getUserId())).eq(TrainingUserPaper::getTrainingPaperId, (Object)userPaper.getTrainingPaperId())).isNull(TrainingUserPaper::getSubmitTime);
        List list1 = this.userPaperMapper.selectList((Wrapper)wrapper2);
        if (!CollectionUtils.isEmpty((Collection)list1)) {
            userPaperVo.setIsNotFinish(Integer.valueOf(1));
        } else {
            userPaperVo.setIsNotFinish(Integer.valueOf(0));
        }
        LambdaQueryWrapper wrapper3 = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper3.eq(TrainingUserPaper::getTrainingPaperId, (Object)userPaper.getTrainingPaperId())).isNotNull(TrainingUserPaper::getUserId)).eq(!org.springframework.util.StringUtils.isEmpty((Object)userPaper.getSourceType()), TrainingUserPaper::getSourceType, (Object)userPaper.getSourceType())).eq(!org.springframework.util.StringUtils.isEmpty((Object)userPaper.getSourceProjectId()), TrainingUserPaper::getSourceProjectId, (Object)userPaper.getSourceProjectId())).eq(!org.springframework.util.StringUtils.isEmpty((Object)userPaper.getSourceTaskId()), TrainingUserPaper::getSourceTaskId, (Object)userPaper.getSourceTaskId())).eq(!org.springframework.util.StringUtils.isEmpty((Object)userPaper.getSourceShiftId()), TrainingUserPaper::getSourceShiftId, (Object)userPaper.getSourceShiftId())).isNotNull(TrainingUserPaper::getSubmitTime);
        List list2 = this.userPaperMapper.selectList((Wrapper)wrapper3);
        if (!CollectionUtils.isEmpty((Collection)list2)) {
            List userIds = list2.stream().map(TrainingUserPaper::getUserId).distinct().collect(Collectors.toList());
            userPaperVo.setJoinNum(Integer.valueOf(userIds.size()));
        } else {
            userPaperVo.setJoinNum(Integer.valueOf(0));
        }
        Integer rankingNum = this.userPaperMapper.selectScoreRankingByPaperId(paper.getId(), actScore, scoreSelect, userPaper.getSourceType(), userPaper.getSourceProjectId(), userPaper.getSourceTaskId(), userPaper.getSourceShiftId());
        userPaperVo.setRankingNum(Integer.valueOf(rankingNum + 1));
        LambdaQueryWrapper questionWrapper = new LambdaQueryWrapper();
        questionWrapper.eq(TrainingUserQuestion::getUserPaperId, (Object)userPaper.getId());
        questionWrapper.eq(TrainingUserQuestion::getIsReviewed, (Object)0);
        questionWrapper.eq(TrainingUserQuestion::getQuestionType, (Object)1);
        List questionList = this.trainingUserQuestionMapper.selectList((Wrapper)questionWrapper);
        if (CollectionUtils.isEmpty((Collection)questionList)) {
            userPaperVo.setIsReview(Integer.valueOf(0));
        } else {
            userPaperVo.setIsReview(Integer.valueOf(1));
        }
        return userPaperVo;
    }

    @Override
    public TrainingPapersVo selectUserPaperList(TrainingPapersVo papersVo) {
        TrainingExam exam;
        Integer userId = papersVo.getUserId();
        TrainingPaper paper = (TrainingPaper)this.paperMapper.selectById(papersVo.getId());
        if (ObjectUtils.isEmpty((Object)paper)) {
            return papersVo;
        }
        BeanUtils.copyProperties((Object)paper, (Object)papersVo);
        Integer scoreSelect = paper.getScoreSelect() == null ? 1 : paper.getScoreSelect();
        papersVo.setScoreSelect(scoreSelect);
        Integer passLine = paper.getPassLine() == null ? 60 : paper.getPassLine();
        BigDecimal totalScore = new BigDecimal(100);
        if (paper.getExamId() != null && !org.springframework.util.StringUtils.isEmpty((Object)(exam = (TrainingExam)this.examMapper.selectById(paper.getExamId())))) {
            totalScore = exam.getScore();
        }
        BigDecimal actScore = BigDecimal.ZERO;
        LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)wrapper1.eq(TrainingUserPaper::getUserId, (Object)userId)).eq(TrainingUserPaper::getTrainingPaperId, (Object)paper.getId());
        if (!org.springframework.util.StringUtils.isEmpty((Object)papersVo.getSourceType())) {
            wrapper1.and(wq -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wq.eq(TrainingUserPaper::getSourceType, (Object)papersVo.getSourceType())).or()).isNull(TrainingUserPaper::getSourceType);
            });
        } else {
            wrapper1.isNull(TrainingUserPaper::getSourceType);
        }
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper1.eq(!org.springframework.util.StringUtils.isEmpty((Object)papersVo.getSourceProjectId()), TrainingUserPaper::getSourceProjectId, (Object)papersVo.getSourceProjectId())).eq(!org.springframework.util.StringUtils.isEmpty((Object)papersVo.getSourceTaskId()) && papersVo.getSourceTaskId().compareTo(0) > 0, TrainingUserPaper::getSourceTaskId, (Object)papersVo.getSourceTaskId())).eq(!org.springframework.util.StringUtils.isEmpty((Object)papersVo.getSourceShiftId()), TrainingUserPaper::getSourceShiftId, (Object)papersVo.getSourceShiftId())).isNotNull(TrainingUserPaper::getSubmitTime)).orderByDesc(TrainingUserPaper::getId);
        List userPaperList = this.userPaperMapper.selectList((Wrapper)wrapper1);
        Integer paperNum = 0;
        if (!CollectionUtils.isEmpty((Collection)userPaperList)) {
            TrainingUserPaper userPaper;
            int i;
            paperNum = userPaperList.size();
            List userPaperIdList = userPaperList.stream().map(TrainingUserPaper::getId).collect(Collectors.toList());
            LambdaQueryWrapper wrapper4 = new LambdaQueryWrapper();
            wrapper4.in(TrainingUserQuestion::getUserPaperId, userPaperIdList);
            List userQuestionList = this.userQuestionMapper.selectList((Wrapper)wrapper4);
            Map<Object, Object> userQuestionMap = new HashMap();
            if (!CollectionUtils.isEmpty((Collection)userQuestionList)) {
                userQuestionMap = userQuestionList.stream().collect(Collectors.groupingBy(TrainingUserQuestion::getUserPaperId));
            }
            ArrayList<TrainingUserPaperVo> userPaperVoList = new ArrayList<TrainingUserPaperVo>();
            int topScoreIndex = 0;
            Integer newScoreIndex = null;
            for (i = 0; i < userPaperList.size(); ++i) {
                userPaper = (TrainingUserPaper)userPaperList.get(i);
                if (userPaper.getPaperStatus() == 1 || !userPaper.getPaperStatus().equals(2)) continue;
                if (userPaper.getScore().doubleValue() > actScore.doubleValue()) {
                    actScore = userPaper.getScore();
                    topScoreIndex = i;
                }
                if (newScoreIndex != null) continue;
                actScore = userPaper.getScore();
                newScoreIndex = i;
            }
            for (i = 0; i < userPaperList.size(); ++i) {
                userPaper = (TrainingUserPaper)userPaperList.get(i);
                TrainingUserPaperVo userPaperVo = new TrainingUserPaperVo();
                BeanUtils.copyProperties((Object)userPaper, (Object)userPaperVo);
                if (userPaperVo.getSubmitTime() != null && userPaperVo.getUpdateTime() != null) {
                    Integer totalTime = (int)((userPaper.getSubmitTime().getTime() - userPaper.getUpdateTime().getTime()) / 1000L);
                    userPaperVo.setTimeStr(DateUtils.getUseTimeFormal(totalTime));
                }
                if (userPaper.getPaperStatus() == 0) {
                    userPaperVo.setPassStatus(Integer.valueOf(4));
                    continue;
                }
                if (userPaper.getPaperStatus() == 1) {
                    userPaperVo.setPassStatus(Integer.valueOf(1));
                } else {
                    if (userPaper.getScore().compareTo(totalScore.multiply(new BigDecimal(passLine)).divide(new BigDecimal(100), 2, 4)) < 0) {
                        userPaperVo.setPassStatus(Integer.valueOf(3));
                    } else {
                        userPaperVo.setPassStatus(Integer.valueOf(2));
                    }
                    if (scoreSelect != null && scoreSelect == 0) {
                        if (topScoreIndex == i) {
                            userPaperVo.setIsSelect(1);
                            actScore = userPaper.getScore();
                        } else {
                            userPaperVo.setIsSelect(0);
                        }
                    } else if (scoreSelect != null && scoreSelect == 1) {
                        if (i == newScoreIndex) {
                            userPaperVo.setIsSelect(1);
                            actScore = userPaper.getScore();
                        } else {
                            userPaperVo.setIsSelect(0);
                        }
                    }
                    List questionList = (List)userQuestionMap.get(userPaperVo.getId());
                    Integer rightNum = 0;
                    Integer errorNum = 0;
                    Integer totalNum = 0;
                    if (!CollectionUtils.isEmpty((Collection)questionList)) {
                        totalNum = questionList.size();
                        for (TrainingUserQuestion userQuestion : questionList) {
                            Integer n;
                            Integer n2;
                            if (userQuestion.getIsCorrect() == 1) {
                                n2 = rightNum;
                                n = rightNum = Integer.valueOf(rightNum + 1);
                                continue;
                            }
                            n2 = errorNum;
                            n = errorNum = Integer.valueOf(errorNum + 1);
                        }
                    }
                    userPaperVo.setTotalCount(totalNum);
                    userPaperVo.setRightCount(rightNum);
                    userPaperVo.setErrorCount(errorNum);
                }
                userPaperVoList.add(userPaperVo);
            }
            papersVo.setUserPaperVoList(userPaperVoList);
        }
        papersVo.setPaperNum(paperNum);
        LambdaQueryWrapper wrapper2 = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)wrapper2.eq(TrainingUserPaper::getTrainingPaperId, (Object)paper.getId())).isNotNull(TrainingUserPaper::getUserId);
        if (!org.springframework.util.StringUtils.isEmpty((Object)papersVo.getSourceType())) {
            wrapper2.and(wq -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wq.eq(TrainingUserPaper::getSourceType, (Object)papersVo.getSourceType())).or()).isNull(TrainingUserPaper::getSourceType);
            });
        } else {
            wrapper2.isNull(TrainingUserPaper::getSourceType);
        }
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper2.eq(!org.springframework.util.StringUtils.isEmpty((Object)papersVo.getSourceProjectId()), TrainingUserPaper::getSourceProjectId, (Object)papersVo.getSourceProjectId())).eq(!org.springframework.util.StringUtils.isEmpty((Object)papersVo.getSourceTaskId()), TrainingUserPaper::getSourceTaskId, (Object)papersVo.getSourceTaskId())).eq(!org.springframework.util.StringUtils.isEmpty((Object)papersVo.getSourceShiftId()), TrainingUserPaper::getSourceShiftId, (Object)papersVo.getSourceShiftId())).isNotNull(TrainingUserPaper::getSubmitTime);
        List list2 = this.userPaperMapper.selectList((Wrapper)wrapper2);
        if (!CollectionUtils.isEmpty((Collection)list2)) {
            List userIds = list2.stream().map(TrainingUserPaper::getUserId).distinct().collect(Collectors.toList());
            papersVo.setJoinNum(Integer.valueOf(userIds.size()));
        } else {
            papersVo.setJoinNum(Integer.valueOf(0));
        }
        Integer rankingNum = this.userPaperMapper.selectScoreRankingByPaperId(paper.getId(), actScore, scoreSelect, papersVo.getSourceType(), papersVo.getSourceProjectId(), papersVo.getSourceTaskId(), papersVo.getSourceShiftId());
        papersVo.setRanking(Integer.valueOf(rankingNum + 1));
        return papersVo;
    }

    @Override
    public TrainingPapersVo selectFinishPaperQuestions(TrainingUserPaperVo userPaperVo) {
        TrainingPapersVo papersVo = new TrainingPapersVo();
        ArrayList<TrainingUserQuestionVo> userQuestionVoList = new ArrayList<TrainingUserQuestionVo>();
        TrainingUserPaper userPaper = (TrainingUserPaper)this.userPaperMapper.selectById(userPaperVo.getId());
        TrainingPaper paper = (TrainingPaper)this.paperMapper.selectById(userPaper.getTrainingPaperId());
        if (!ObjectUtils.isEmpty((Object)paper)) {
            BeanUtils.copyProperties((Object)paper, (Object)papersVo);
        }
        papersVo.setIsAutoRead(userPaper.getIsAutoRead());
        papersVo.setStatus(userPaper.getPaperStatus());
        if (!ObjectUtils.isEmpty((Object)userPaper)) {
            UsersPojo pojo = this.userUtilService.selectUser(userPaper.getUserId());
            papersVo.setUserName(pojo != null ? pojo.getShowName() : "");
            Map<Integer, List<String>> userOrganizeMap = this.userUtilService.selectOrganizeMap(Arrays.asList(userPaper.getUserId()), userPaper.getEnterpriseId());
            List<String> userStr = userOrganizeMap.get(userPaper.getUserId());
            if (!CollectionUtils.isEmpty(userStr)) {
                papersVo.setEnterpriseName(String.join((CharSequence)";", userStr));
            }
            UserBo bo = new UserBo();
            if (!ObjectUtils.isEmpty((Object)pojo)) {
                bo.setId(pojo.getId());
                bo.setUserName(pojo.getUserName());
                bo.setShowName(pojo.getShowName());
                bo.setThumbUrl(pojo.getThumbUrl());
            }
            bo.setOrganizes(CollectionUtils.isEmpty(userStr) ? "" : userStr.get(0));
            papersVo.setUserBo(bo);
            LambdaQueryWrapper wrapper2 = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper2.eq(TrainingUserQuestion::getUserId, (Object)userPaper.getUserId())).eq(TrainingUserQuestion::getPaperId, (Object)userPaper.getTrainingPaperId())).eq(TrainingUserQuestion::getUserPaperId, (Object)userPaper.getId());
            List userQuestionList = this.userQuestionMapper.selectList((Wrapper)wrapper2);
            if (!CollectionUtils.isEmpty((Collection)userQuestionList)) {
                Map<Object, Object> picMap = new HashMap();
                ArrayList<Integer> userQuestionIdList = new ArrayList<Integer>();
                for (TrainingUserQuestion userQuestion : userQuestionList) {
                    if (userQuestion.getQuestionType() != 1) continue;
                    userQuestionIdList.add(userQuestion.getId());
                }
                if (!CollectionUtils.isEmpty(userQuestionIdList)) {
                    LambdaQueryWrapper wrapper3 = new LambdaQueryWrapper();
                    ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper3.in(TrainingUserQuestionPicture::getUserQuestionId, userQuestionIdList)).eq(TrainingUserQuestionPicture::getPictureType, (Object)1)).eq(TrainingUserQuestionPicture::getIsDelete, (Object)0);
                    List userQuestionPictures = this.userQuestionPictureMapper.selectList((Wrapper)wrapper3);
                    if (!CollectionUtils.isEmpty((Collection)userQuestionPictures)) {
                        picMap = userQuestionPictures.stream().collect(Collectors.groupingBy(TrainingUserQuestionPicture::getUserQuestionId));
                    }
                }
                for (TrainingUserQuestion userQuestion : userQuestionList) {
                    TrainingUserQuestionVo userQuestionVo = new TrainingUserQuestionVo();
                    BeanUtils.copyProperties((Object)userQuestion, (Object)userQuestionVo);
                    List optionsList = new ArrayList();
                    if (!org.springframework.util.StringUtils.isEmpty((Object)userQuestionVo.getOptionsData())) {
                        optionsList = JSONObject.parseArray((String)userQuestionVo.getOptionsData(), TrainingOptionsVo.class);
                        if (userQuestionVo.getQuestionType() == 2 && !CollectionUtils.isEmpty(optionsList)) {
                            for (TrainingOptionsVo vo : optionsList) {
                                List<String> optionsLists = StringsUtils.String2List(vo.getOptionsName(), "&");
                                if (!CollectionUtils.isEmpty(optionsLists)) {
                                    if (!org.springframework.util.StringUtils.isEmpty((Object)vo.getAnswer()) && optionsLists.contains(vo.getAnswer().trim())) {
                                        vo.setIsCorrect(Integer.valueOf(1));
                                        continue;
                                    }
                                    vo.setIsCorrect(Integer.valueOf(0));
                                    continue;
                                }
                                vo.setIsCorrect(Integer.valueOf(1));
                            }
                        }
                    }
                    userQuestionVo.setOptionsVoList(optionsList);
                    if (userQuestion.getQuestionType() == 1) {
                        List questionPictureList = (List)picMap.get(userQuestion.getId());
                        userQuestionVo.setUserQuestionPictureList(questionPictureList);
                        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
                        wrapper.eq(TrainingUserQuestionAtta::getUserQuestionId, (Object)userQuestion.getId());
                        List list = this.trainingUserQuestionAttaMapper.selectList((Wrapper)wrapper);
                        if (!CollectionUtils.isEmpty((Collection)list)) {
                            userQuestionVo.setAttaList(list);
                        }
                    }
                    userQuestionVoList.add(userQuestionVo);
                }
            }
        }
        papersVo.setUserQuestionVoList(userQuestionVoList);
        LambdaQueryWrapper questionWrapper = new LambdaQueryWrapper();
        questionWrapper.eq(TrainingUserQuestion::getUserPaperId, (Object)userPaperVo.getId());
        questionWrapper.eq(TrainingUserQuestion::getIsReviewed, (Object)0);
        questionWrapper.eq(TrainingUserQuestion::getQuestionType, (Object)1);
        List questionList = this.trainingUserQuestionMapper.selectList((Wrapper)questionWrapper);
        if (CollectionUtils.isEmpty((Collection)questionList)) {
            papersVo.setIsReview(Integer.valueOf(0));
        } else {
            papersVo.setIsReview(Integer.valueOf(1));
        }
        return papersVo;
    }

    @Override
    public TrainingPapersVo selectPaperStatusCount(Users user) {
        BaseResult tagResult;
        List<Integer> roleList;
        List<Object> paperIds = new ArrayList();
        LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper1.isNull(TrainingPaper::getLookLevel)).ne(TrainingPaper::getPaperState, (Object)0)).isNotNull(TrainingPaper::getExamId)).eq(user.getGroupId() != null, TrainingPaper::getEnterpriseId, (Object)user.getGroupId())).eq(TrainingPaper::getIsTraining, (Object)0)).isNull(TrainingPaper::getProjectShow);
        List paper1 = this.paperMapper.selectList((Wrapper)wrapper1);
        if (!CollectionUtils.isEmpty((Collection)paper1)) {
            List paperId = paper1.stream().map(TrainingPaper::getId).distinct().collect(Collectors.toList());
            paperIds.addAll(paperId);
        }
        ArrayList allPaper = new ArrayList();
        LambdaQueryWrapper wrapper2 = new LambdaQueryWrapper();
        wrapper2.eq(TrainingPaperUser::getUserId, (Object)user.getId());
        List paper2 = this.trainingPaperUserMapper.selectList((Wrapper)wrapper2);
        if (!CollectionUtils.isEmpty((Collection)paper2)) {
            allPaper.addAll(paper2);
        }
        if (!CollectionUtils.isEmpty(roleList = this.userUtilService.selectUserRoleList(user))) {
            LambdaQueryWrapper roleWrapper = new LambdaQueryWrapper();
            roleWrapper.eq(TrainingPaperUser::getEnterpriseId, (Object)user.getGroupId());
            roleWrapper.in(TrainingPaperUser::getRoleId, roleList);
            List rolePaper = this.trainingPaperUserMapper.selectList((Wrapper)roleWrapper);
            if (!CollectionUtils.isEmpty((Collection)rolePaper)) {
                allPaper.addAll(rolePaper);
            }
        }
        if (!(tagResult = this.tagApi.getUsersTagByUserId(user.getId())).getIsError().booleanValue() && !CollectionUtils.isEmpty((Collection)((Collection)tagResult.getData()))) {
            LambdaQueryWrapper tagWrapper = new LambdaQueryWrapper();
            tagWrapper.eq(TrainingPaperUser::getEnterpriseId, (Object)user.getGroupId());
            tagWrapper.in(TrainingPaperUser::getTagId, (Collection)((List)tagResult.getData()).stream().map(UserTagMo::getId).distinct().collect(Collectors.toList()));
            List tagPaper = this.trainingPaperUserMapper.selectList((Wrapper)tagWrapper);
            if (!CollectionUtils.isEmpty((Collection)tagPaper)) {
                allPaper.addAll(tagPaper);
            }
        }
        ArrayList<String> orgIds = new ArrayList<String>();
        UsersAndOrgsMo mo = new UsersAndOrgsMo();
        mo.setGroupId(user.getGroupId());
        mo.setUserId(user.getId());
        mo.setRetainAll(Boolean.valueOf(false));
        mo.setShowAllPath(Boolean.valueOf(true));
        BaseResult orgResult = this.userOrganizeApi.getUserOrganizeByUserIdAndOrg(mo);
        if (!orgResult.getIsError().booleanValue() && !CollectionUtils.isEmpty((Map)((Map)orgResult.getData()))) {
            List list;
            Map map = (Map)orgResult.getData();
            if (!CollectionUtils.isEmpty((Collection)((Collection)map.get("O_")))) {
                list = (List)map.get("O_");
                for (Integer id : list) {
                    orgIds.add("O_" + id);
                }
            }
            if (!CollectionUtils.isEmpty((Collection)((Collection)map.get("S_")))) {
                list = (List)map.get("S_");
                for (Integer id : list) {
                    orgIds.add("S_" + id);
                }
            }
        }
        if (!CollectionUtils.isEmpty(orgIds)) {
            LambdaQueryWrapper orgWrapper = new LambdaQueryWrapper();
            orgWrapper.eq(TrainingPaperUser::getEnterpriseId, (Object)user.getGroupId());
            orgWrapper.in(TrainingPaperUser::getOrganizeId, orgIds);
            List orgPaper = this.trainingPaperUserMapper.selectList((Wrapper)orgWrapper);
            if (!CollectionUtils.isEmpty((Collection)orgPaper)) {
                allPaper.addAll(orgPaper);
            }
        }
        if (!CollectionUtils.isEmpty(allPaper)) {
            List paperId = allPaper.stream().map(TrainingPaperUser::getPaperId).distinct().collect(Collectors.toList());
            LambdaQueryWrapper wrapper3 = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper3.in(TrainingPaper::getId, paperId)).ne(TrainingPaper::getPaperState, (Object)0)).isNotNull(TrainingPaper::getExamId)).eq(TrainingPaper::getIsTraining, (Object)0)).isNull(TrainingPaper::getProjectShow);
            List paper3 = this.paperMapper.selectList((Wrapper)wrapper3);
            if (!CollectionUtils.isEmpty((Collection)paper3)) {
                List paperId1 = paper3.stream().map(TrainingPaper::getId).distinct().collect(Collectors.toList());
                paperIds.addAll(paperId1);
            }
        }
        paperIds = paperIds.stream().distinct().collect(Collectors.toList());
        TrainingPapersVo vo = new TrainingPapersVo();
        Integer notStartNum = 0;
        Integer goingNum = 0;
        Integer examinedNum = 0;
        Integer missNum = 0;
        if (!CollectionUtils.isEmpty(paperIds)) {
            List paperList = this.paperMapper.selectBatchIds(paperIds);
            LambdaQueryWrapper wrapper4 = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)wrapper4.eq(TrainingUserPaper::getUserId, (Object)user.getId())).and(wq -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wq.isNull(TrainingUserPaper::getSourceType)).or()).eq(TrainingUserPaper::getSourceType, (Object)2);
            });
            List userPaperList = this.userPaperMapper.selectList((Wrapper)wrapper4);
            Map<Object, Object> paperMap = new HashMap();
            if (!CollectionUtils.isEmpty((Collection)userPaperList)) {
                paperMap = userPaperList.stream().collect(Collectors.groupingBy(TrainingUserPaper::getTrainingPaperId));
            }
            for (TrainingPaper paper : paperList) {
                Integer n;
                Integer n2;
                List userPapers = (List)paperMap.get(paper.getId());
                if (paper.getIsMustLink() == 1 && CollectionUtils.isEmpty((Collection)userPapers)) continue;
                if (!org.springframework.util.StringUtils.isEmpty((Object)paper.getPaperState()) && paper.getPaperState() == 1) {
                    n2 = notStartNum;
                    n = notStartNum = Integer.valueOf(notStartNum + 1);
                    continue;
                }
                if (!org.springframework.util.StringUtils.isEmpty((Object)paper.getPaperState()) && paper.getPaperState() == 2) {
                    if (CollectionUtils.isEmpty((Collection)userPapers)) {
                        n2 = goingNum;
                        n = goingNum = Integer.valueOf(goingNum + 1);
                        continue;
                    }
                    if (!CollectionUtils.isEmpty((Collection)userPapers) && userPapers.size() == 1 && ((TrainingUserPaper)userPapers.get(0)).getSubmitTime() == null) {
                        n2 = goingNum;
                        n = goingNum = Integer.valueOf(goingNum + 1);
                        continue;
                    }
                    n2 = examinedNum;
                    n = examinedNum = Integer.valueOf(examinedNum + 1);
                    continue;
                }
                if (org.springframework.util.StringUtils.isEmpty((Object)paper.getPaperState()) || paper.getPaperState() != 3 || paper.getEndTime() == null || paper.getEndTime() != null && paper.getEndTime().before(user.getCreateTime())) continue;
                if (CollectionUtils.isEmpty((Collection)userPapers)) {
                    n2 = missNum;
                    n = missNum = Integer.valueOf(missNum + 1);
                    continue;
                }
                if (!CollectionUtils.isEmpty((Collection)userPapers) && userPapers.size() == 1 && ((TrainingUserPaper)userPapers.get(0)).getSubmitTime() == null) {
                    n2 = missNum;
                    n = missNum = Integer.valueOf(missNum + 1);
                    continue;
                }
                n2 = examinedNum;
                n = examinedNum = Integer.valueOf(examinedNum + 1);
            }
        }
        vo.setNotStartNum(notStartNum);
        vo.setGoingNum(goingNum);
        vo.setExaminedNum(examinedNum);
        vo.setMissNum(missNum);
        return vo;
    }

    @Override
    public String validDeletePaper(Integer enterpriseId, Integer paperId) {
        Object vo;
        ArrayList<Object> result = new ArrayList<Object>();
        Locale locale = Authenticator.getInstance().getCurrentClient().getLocale();
        LambdaQueryWrapper attachWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)attachWrapper.eq(TrainingChapterAttach::getEnterpriseId, (Object)enterpriseId)).eq(TrainingChapterAttach::getPaperId, (Object)paperId)).eq(TrainingChapterAttach::getIsDel, (Object)0);
        List list = this.trainingChapterAttachMapper.selectList((Wrapper)attachWrapper);
        if (!CollectionUtils.isEmpty((Collection)list)) {
            String trainName = this.messageSource.getMessage("training.job.train.name", null, locale);
            for (TrainingChapterAttach trainingChapterAttach : list) {
                TrainingChapter chapter = (TrainingChapter)this.trainingChapterMapper.selectById(trainingChapterAttach.getChapterId());
                if (chapter == null) continue;
                Training training = (Training)this.trainingMapper.selectById(chapter.getTrainingId());
                if (training != null) {
                    vo = new ValidDeletePaperVo();
                    vo.setModule(trainName);
                    vo.setTaskName(training.getTitle());
                    BaseResult userResult = this.userApi.getUserById(training.getCreator());
                    if (!userResult.getIsError().booleanValue() && userResult.getData() != null) {
                        vo.setCreator(((UsersPojo)userResult.getData()).getUserName());
                    }
                    vo.setCreateTime(training.getUpdateTime());
                    result.add(vo);
                    continue;
                }
                this.trainingChapterMapper.deleteById((Serializable)chapter);
                this.trainingChapterAttachMapper.delete((Wrapper)attachWrapper);
            }
        }
        LambdaQueryWrapper courseTaskWrapper = new LambdaQueryWrapper();
        courseTaskWrapper.eq(TrainingCourseStageTask::getEnterpriseId, (Object)enterpriseId);
        courseTaskWrapper.eq(TrainingCourseStageTask::getPaperId, (Object)paperId);
        List courseTaskList = this.trainingCourseStageTaskMapper.selectList((Wrapper)courseTaskWrapper);
        if (!CollectionUtils.isEmpty((Collection)courseTaskList)) {
            String courseName = this.messageSource.getMessage("training.job.course.name", null, locale);
            for (TrainingCourseStageTask trainingCourseStageTask : courseTaskList) {
                vo = new ValidDeletePaperVo();
                vo.setModule(courseName);
                TrainingCourse course = (TrainingCourse)this.trainingCourseMapper.selectById(trainingCourseStageTask.getCourseId());
                vo.setTaskName(course.getCourseName());
                BaseResult userResult = this.userApi.getUserById(trainingCourseStageTask.getCreater());
                if (!userResult.getIsError().booleanValue() && userResult.getData() != null) {
                    vo.setCreator(((UsersPojo)userResult.getData()).getUserName());
                }
                vo.setCreateTime(trainingCourseStageTask.getCreateTime());
                result.add(vo);
            }
        }
        LambdaQueryWrapper taskScheduleWrapper = new LambdaQueryWrapper();
        taskScheduleWrapper.eq(TrainingTaskSchedule::getPaperIdOld, (Object)paperId);
        List taskScheduleList = this.trainingTaskScheduleMapper.selectList((Wrapper)taskScheduleWrapper);
        if (!CollectionUtils.isEmpty((Collection)taskScheduleList)) {
            String learnName = this.messageSource.getMessage("training.learn.title", null, locale);
            for (TrainingTaskSchedule trainingTaskSchedule : taskScheduleList) {
                ValidDeletePaperVo vo2 = new ValidDeletePaperVo();
                vo2.setModule(learnName);
                TrainingLearnProject project = (TrainingLearnProject)this.trainingLearnProjectMapper.selectById(trainingTaskSchedule.getProjectId());
                vo2.setTaskName(project.getProjectName());
                BaseResult userResult = this.userApi.getUserById(trainingTaskSchedule.getCreater());
                if (!userResult.getIsError().booleanValue() && userResult.getData() != null) {
                    vo2.setCreator(((UsersPojo)userResult.getData()).getUserName());
                }
                vo2.setCreateTime(trainingTaskSchedule.getCreateTime());
                result.add(vo2);
            }
        }
        LambdaQueryWrapper jobTaskWrapper = new LambdaQueryWrapper();
        jobTaskWrapper.eq(TrainingJobStageTask::getEnterpriseId, (Object)enterpriseId);
        jobTaskWrapper.eq(TrainingJobStageTask::getPaperId, (Object)paperId);
        List jobTaskList = this.trainingJobStageTaskMapper.selectList((Wrapper)jobTaskWrapper);
        if (!CollectionUtils.isEmpty((Collection)jobTaskList)) {
            String jobName = this.messageSource.getMessage("training.job.job.name", null, locale);
            for (TrainingJobStageTask trainingJobStageTask : jobTaskList) {
                ValidDeletePaperVo vo3 = new ValidDeletePaperVo();
                vo3.setModule(jobName);
                TrainingJobCertification job = (TrainingJobCertification)this.trainingJobCertificationMapper.selectById(trainingJobStageTask.getJobId());
                vo3.setTaskName(job.getCertificationName());
                BaseResult userResult = this.userApi.getUserById(trainingJobStageTask.getCreater());
                if (!userResult.getIsError().booleanValue() && userResult.getData() != null) {
                    vo3.setCreator(((UsersPojo)userResult.getData()).getUserName());
                }
                vo3.setCreateTime(trainingJobStageTask.getCreateTime());
                result.add(vo3);
            }
        }
        return JsonResult.success(result);
    }

    @Override
    public PaperAnalyseVo selectPaperAnalyse(PaperAnalyseSearchVo paperVo) {
        List list;
        List userPaperList;
        PaperAnalyseVo vo = new PaperAnalyseVo();
        Locale locale = Authenticator.getInstance().getCurrentClient().getLocale();
        TrainingPaper trainingPaper = (TrainingPaper)this.trainingPaperMapper.selectById(Integer.valueOf(paperVo.getPaperId()));
        vo.setPaperName(trainingPaper.getTitle());
        TrainingExam trainingExam = (TrainingExam)this.trainingExamMapper.selectById(trainingPaper.getExamId());
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.eq(TrainingUserPaper::getTrainingPaperId, (Object)paperVo.getPaperId())).isNotNull(TrainingUserPaper::getSubmitTime);
        if (paperVo.getUserPaperType() != null) {
            if (paperVo.getUserPaperType() == 0) {
                queryWrapper.isNotNull(TrainingUserPaper::getUserId);
            } else {
                queryWrapper.isNotNull(TrainingUserPaper::getLoginUserId);
            }
        }
        if (paperVo.getShiftId() != null) {
            queryWrapper.eq(TrainingUserPaper::getSourceShiftId, (Object)paperVo.getShiftId());
        }
        if (CollectionUtils.isEmpty(userPaperList = (list = this.trainingUserPaperMapper.selectList((Wrapper)queryWrapper)).stream().filter(e -> Objects.isNull(e.getSourceType()) || Objects.nonNull(e.getSourceType()) && e.getSourceType() == paperVo.getSourceType()).collect(Collectors.toList()))) {
            vo.setPaperAnalyseList(Collections.emptyList());
            return vo;
        }
        List userPaperIdList = userPaperList.stream().map(TrainingUserPaper::getId).collect(Collectors.toList());
        LambdaQueryWrapper queryWrapper2 = new LambdaQueryWrapper();
        queryWrapper2.in(!CollectionUtils.isEmpty(userPaperIdList), TrainingUserQuestion::getUserPaperId, userPaperIdList);
        queryWrapper2.like(Objects.nonNull(paperVo.getQuestionName()), TrainingUserQuestion::getName, (Object)paperVo.getQuestionName());
        List trainingUserQuestionList = this.trainingUserQuestionMapper.selectList((Wrapper)queryWrapper2);
        Map<Integer, List<TrainingUserQuestion>> questionMap = trainingUserQuestionList.stream().collect(Collectors.groupingBy(TrainingUserQuestion::getQuestionId));
        ArrayList<PaperAnalyse> dataList = new ArrayList<PaperAnalyse>();
        AtomicInteger sort = new AtomicInteger(0);
        for (Map.Entry<Integer, List<TrainingUserQuestion>> entry : questionMap.entrySet()) {
            PaperAnalyse paperAnalyse = new PaperAnalyse();
            paperAnalyse.setSort(sort.incrementAndGet());
            List<TrainingUserQuestion> paperAnalyseList = entry.getValue();
            paperAnalyse.setId(paperAnalyseList.get(0).getId().intValue());
            List analyseCount = paperAnalyseList.stream().filter(e -> e.getIsEmpty() == 0).collect(Collectors.toList());
            List analyseRight = paperAnalyseList.stream().filter(e -> e.getIsCorrect() == 1).collect(Collectors.toList());
            paperAnalyse.setAnswerUser(analyseCount.size());
            paperAnalyse.setAnswerRightUser(analyseRight.size());
            if (analyseCount.size() == 0) {
                paperAnalyse.setAnswerRightRate("-");
                paperAnalyse.setAnswerRight(new BigDecimal(-1));
            }
            paperAnalyse.setAnswerRightRate(this.computeProportion2(analyseRight.size(), analyseCount.size()));
            paperAnalyse.setAnswerRight(this.computeProportion3(analyseRight.size(), analyseCount.size()));
            int questionType = paperAnalyseList.get(0).getQuestionType();
            String typeName = "";
            if (questionType == 0) {
                paperAnalyse.setOrder(1);
                typeName = this.messageSource.getMessage("training.user.details.singleChoiceQuestion", null, locale);
            } else if (questionType == 3) {
                paperAnalyse.setOrder(2);
                typeName = this.messageSource.getMessage("training.user.details.multipleChoiceQuestion", null, locale);
            } else if (questionType == 4) {
                paperAnalyse.setOrder(3);
                typeName = this.messageSource.getMessage("training.user.details.trueOrFalseQuestions", null, locale);
            } else if (questionType == 2) {
                paperAnalyse.setOrder(4);
                typeName = this.messageSource.getMessage("training.user.details.fillBlankQuestion", null, locale);
            } else if (questionType == 1) {
                paperAnalyse.setOrder(5);
                typeName = this.messageSource.getMessage("training.user.details.essayQuestion", null, locale);
            } else {
                paperAnalyse.setOrder(6);
            }
            paperAnalyse.setType(typeName);
            if (trainingExam.getExamClass() == 1) {
                TrainingExamQuestion examQuestion = (TrainingExamQuestion)this.trainingExamQuestionMapper.selectById(entry.getKey());
                TrainingQuestion question = (TrainingQuestion)this.trainingQuestionMapper.selectById(examQuestion.getQuestionId());
                if (Objects.isNull(question.getTypeId())) {
                    paperAnalyse.setQuestionType("");
                } else {
                    TrainingQuestionType trainingQuestionType = (TrainingQuestionType)this.trainingQuestionTypeMapper.selectById(question.getTypeId());
                    paperAnalyse.setQuestionType(ObjectUtils.isEmpty((Object)trainingQuestionType) ? "" : trainingQuestionType.getTitle());
                }
                paperAnalyse.setName(question.getName());
            } else {
                TrainingQuestion question = (TrainingQuestion)this.trainingQuestionMapper.selectById(entry.getKey());
                if (Objects.isNull(question) || Objects.isNull(question.getTypeId())) {
                    paperAnalyse.setQuestionType("");
                } else {
                    TrainingQuestionType trainingQuestionType = (TrainingQuestionType)this.trainingQuestionTypeMapper.selectById(question.getTypeId());
                    paperAnalyse.setQuestionType(ObjectUtils.isEmpty((Object)trainingQuestionType) ? "" : trainingQuestionType.getTitle());
                }
                paperAnalyse.setName(question.getName());
            }
            dataList.add(paperAnalyse);
        }
        List<Object> result = new ArrayList();
        result = trainingExam.getExamClass() == 1 ? dataList.stream().sorted(Comparator.comparing(PaperAnalyse::getId)).collect(Collectors.toList()) : dataList.stream().sorted(Comparator.comparing(PaperAnalyse::getOrder).thenComparing(PaperAnalyse::getId)).collect(Collectors.toList());
        if (paperVo.getOrderBy() != 0 && paperVo.getOrderBy() == 1) {
            result = paperVo.getOrder() == 1 ? dataList.stream().sorted(Comparator.comparing(PaperAnalyse::getAnswerRight)).collect(Collectors.toList()) : dataList.stream().sorted(Comparator.comparing(PaperAnalyse::getAnswerRight).reversed()).collect(Collectors.toList());
        }
        for (int i = 0; i < result.size(); ++i) {
            ((PaperAnalyse)result.get(i)).setSort(i + 1);
        }
        vo.setPaperAnalyseList(result);
        return vo;
    }

    @Override
    public void selectPaperAnalyseByExcel(HttpServletResponse response, PaperAnalyseSearchVo paperVo) {
        Locale locale = Authenticator.getInstance().getCurrentClient().getLocale();
        PaperAnalyseVo vo = this.selectPaperAnalyse(paperVo);
        List paperAnalyseList = vo.getPaperAnalyseList();
        String fileName = MessageFormat.format("{0}_{1}", vo.getPaperName(), this.messageSource.getMessage("training.question.detail", null, locale));
        fileName = ExcelUtil.getFileName(fileName) + ".xlsx";
        XSSFWorkbook wb = new XSSFWorkbook();
        XSSFSheet sheet = wb.createSheet(fileName);
        XSSFCellStyle titleSty = wb.createCellStyle();
        XSSFFont font = wb.createFont();
        font.setFontHeightInPoints((short)16);
        titleSty.setFont((Font)font);
        XSSFRow row = sheet.createRow(0);
        row.createCell(0).setCellValue(this.messageSource.getMessage("training.project.number", null, locale));
        String topic = this.messageSource.getMessage("training.paper.topic", null, locale);
        row.createCell(1).setCellValue(topic);
        row.createCell(2).setCellValue(this.messageSource.getMessage("training.user.details.type", null, locale));
        row.createCell(3).setCellValue(this.messageSource.getMessage("training.user.subject.bank", null, locale));
        row.createCell(4).setCellValue(this.messageSource.getMessage("training.course.answer.num", null, locale));
        row.createCell(5).setCellValue(this.messageSource.getMessage("training.course.answer.right.num", null, locale));
        row.createCell(6).setCellValue(this.messageSource.getMessage("training.course.answer.right.rate", null, locale));
        for (int i = 0; i < paperAnalyseList.size(); ++i) {
            row = sheet.createRow(i + 1);
            PaperAnalyse paperAnalyse = (PaperAnalyse)paperAnalyseList.get(i);
            row.createCell(0).setCellValue((double)paperAnalyse.getSort());
            row.createCell(1).setCellValue(paperAnalyse.getName());
            row.createCell(2).setCellValue(paperAnalyse.getType());
            row.createCell(3).setCellValue(paperAnalyse.getQuestionType());
            row.createCell(4).setCellValue((double)paperAnalyse.getAnswerUser());
            row.createCell(5).setCellValue((double)paperAnalyse.getAnswerRightUser());
            row.createCell(6).setCellValue(paperAnalyse.getAnswerRightRate());
        }
        try {
            response.setContentType("application/vnd.ms-excel; charset=utf-8");
            response.setHeader("Content-Disposition", "attachment; filename=" + URLEncoder.encode(fileName, "UTF-8"));
            ServletOutputStream out = response.getOutputStream();
            wb.write((OutputStream)out);
            out.flush();
            out.close();
            wb.close();
        }
        catch (IOException e) {
            log.error(e.getMessage());
        }
    }

    @Override
    public List<Integer> getPaperUserIdList(TrainingPaper trainingPaper, Integer userId) {
        ArrayList<Integer> userIds = new ArrayList();
        int groupId = trainingPaper.getEnterpriseId();
        if (Objects.isNull(trainingPaper.getLookLevel())) {
            List<Integer> limitUsers;
            BaseResult simplePojoBaseResult = this.userApi.getSimpleUserByKeyWord(Integer.valueOf(groupId), null, null);
            userIds = ((List)simplePojoBaseResult.getData()).stream().map(SimplePojo::getId).collect(Collectors.toList());
            if (trainingPaper.getEndTime() != null && trainingPaper.getPaperState() != null && trainingPaper.getPaperState() == 3 && !CollectionUtils.isEmpty(limitUsers = this.userUtilService.selectOverGroupTime(groupId, trainingPaper.getEndTime()))) {
                userIds.removeAll(limitUsers);
            }
        } else {
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.eq(TrainingPaperUser::getPaperId, (Object)trainingPaper.getId());
            List trainingPaperUserList = this.trainingPaperUserMapper.selectList((Wrapper)queryWrapper);
            for (TrainingPaperUser paperUser : trainingPaperUserList) {
                if (Objects.nonNull(paperUser.getUserId())) {
                    userIds.add(paperUser.getUserId());
                }
                if (Objects.nonNull(paperUser.getRoleId())) {
                    userIds.addAll(this.userUtilService.selectUsersByRoles(Collections.singletonList(paperUser.getRoleId()), groupId));
                }
                if (Objects.nonNull(paperUser.getTagId())) {
                    userIds.addAll(this.userUtilService.selectUserIdsByTagIds(Collections.singletonList(paperUser.getTagId()), groupId, userId));
                }
                if (!Objects.nonNull(paperUser.getOrganizeId())) continue;
                userIds.addAll(this.userUtilService.selectUserIdsByOrganizeIds(Collections.singletonList(paperUser.getOrganizeId()), groupId));
            }
        }
        return userIds;
    }

    @Override
    public Page<PaperUserDetailVo> selectPaperUserDetailByPage(PaperUserDetailSearchVo searchVo, Users user) {
        Page<PaperUserDetailVo> page = new Page<PaperUserDetailVo>();
        List<PaperUserDetailVo> dataList = this.selectPaperUserDetails(searchVo, user);
        if (!CollectionUtils.isEmpty(dataList)) {
            page = ListUtil.myPage(dataList, searchVo.getPageNumber(), searchVo.getPageSize());
        }
        return page;
    }

    @Override
    public List<Integer> getVisitorByName(String showName) {
        List<Integer> visitorIds = new ArrayList<Integer>();
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.like(TrainingLoginUser::getShowName, (Object)showName);
        List trainingLoginUserList = this.trainingLoginUserMapper.selectList((Wrapper)wrapper);
        if (!CollectionUtils.isEmpty((Collection)trainingLoginUserList)) {
            visitorIds = trainingLoginUserList.stream().map(TrainingLoginUser::getUserId).filter(Objects::nonNull).collect(Collectors.toList());
        }
        return visitorIds;
    }

    private List<TrainingUserPaper> getVisitorPapers(PaperUserDetailSearchVo searchVo) {
        List<Object> trainingUserPaperList = new ArrayList<TrainingUserPaper>();
        if (searchVo.getUserPaperType() == null || searchVo.getUserPaperType() == 1) {
            LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)wrapper1.eq(TrainingUserPaper::getTrainingPaperId, (Object)searchVo.getPaperId())).isNotNull(TrainingUserPaper::getLoginUserId);
            if (!org.springframework.util.StringUtils.isEmpty((Object)searchVo.getUserName())) {
                List<Integer> visitorIds = this.getVisitorByName(searchVo.getUserName());
                if (!CollectionUtils.isEmpty(visitorIds)) {
                    wrapper1.in(TrainingUserPaper::getLoginUserId, visitorIds);
                } else {
                    return trainingUserPaperList;
                }
            }
            trainingUserPaperList = this.trainingUserPaperMapper.selectList((Wrapper)wrapper1);
        }
        return trainingUserPaperList;
    }

    @Override
    public List<PaperUserDetailVo> selectPaperUserDetailsByList(PaperDetailExcelVo excelVo) {
        Users user = excelVo.getUsers();
        PaperUserDetailSearchVo searchVo = new PaperUserDetailSearchVo();
        BeanUtils.copyProperties((Object)excelVo, (Object)searchVo);
        ArrayList<PaperUserDetailVo> dataList = new ArrayList<PaperUserDetailVo>();
        TrainingPaper trainingPaper = (TrainingPaper)this.trainingPaperMapper.selectById(Integer.valueOf(searchVo.getPaperId()));
        List<Object> userIds = new ArrayList();
        if (searchVo.getUserPaperType() == null || searchVo.getUserPaperType() == 0) {
            userIds = this.getPaperUserIdList(trainingPaper, user.getId());
        }
        if (user.getGroupId() == null) {
            user.setGroupId(trainingPaper.getEnterpriseId());
        }
        if (!org.springframework.util.StringUtils.isEmpty((Object)searchVo.getUserName())) {
            List userIdList = (List)this.userUtilService.getCheckParameters(searchVo.getUserName(), null, null, user).get("userList");
            userIds.retainAll(userIdList);
        }
        List<TrainingUserPaper> trainingUserPaperList = this.getVisitorPapers(searchVo);
        if (CollectionUtils.isEmpty(userIds) && CollectionUtils.isEmpty(trainingUserPaperList)) {
            return dataList;
        }
        TrainingExam trainingExam = (TrainingExam)this.trainingExamMapper.selectById(trainingPaper.getExamId());
        HashMap<Integer, List<RolePojo>> userRoleMap = new HashMap();
        if (!CollectionUtils.isEmpty(userIds)) {
            HashMap<String, Object> parameter = new HashMap<String, Object>();
            parameter.put("userIds", StringUtils.join(userIds, (String)","));
            parameter.put("groupId", user.getGroupId());
            com.ovopark.privilege.response.BaseResult base = this.roleApi.getUserRoleList(parameter);
            if (base != null) {
                userRoleMap = (Map)base.getData();
            }
        }
        Map<Integer, UserDutiesMo> dutiesMap = this.userUtilService.selectDutiesMap(userIds, user.getGroupId());
        Map<Integer, String> parentMap = this.userUtilService.selectParentMap(userIds, user.getGroupId());
        Map<Integer, Integer> parentIdMap = this.userUtilService.selectParentIdMap(userIds, user.getGroupId());
        if (!CollectionUtils.isEmpty(userIds)) {
            List<String> userStr;
            UsersPojo usersPojo;
            PaperUserDetailVo vo;
            Object usersPojo2;
            List<Integer> userIdList = userIds.stream().distinct().collect(Collectors.toList());
            List userIdList2 = userIds.stream().distinct().collect(Collectors.toList());
            LambdaQueryWrapper queryWrapper2 = new LambdaQueryWrapper();
            queryWrapper2.eq(TrainingUserPaper::getTrainingPaperId, (Object)searchVo.getPaperId());
            queryWrapper2.in(TrainingUserPaper::getUserId, userIdList);
            List trainingUserPaperList2 = this.trainingUserPaperMapper.selectList((Wrapper)queryWrapper2);
            List trainingUserPapers = trainingUserPaperList2.stream().filter(e -> Objects.isNull(e.getSourceType()) || Objects.nonNull(e.getSourceType()) && e.getSourceType() == 2).collect(Collectors.toList());
            List userStudyList = trainingUserPapers.stream().map(TrainingUserPaper::getUserId).distinct().collect(Collectors.toList());
            Map<Integer, List<TrainingUserPaper>> trainingUserPaperMap = trainingUserPapers.stream().collect(Collectors.groupingBy(TrainingUserPaper::getUserId));
            userIdList2.removeAll(userStudyList);
            Map<Integer, List<String>> userOrganizeMap = this.userUtilService.selectOrganizeMap(userIdList, trainingPaper.getEnterpriseId());
            Map<Integer, UsersPojo> usersPojoMap = this.userUtilService.selectUserMap(userIds);
            Iterator iterator = userIdList2.iterator();
            while (iterator.hasNext()) {
                int userId = (Integer)iterator.next();
                PaperUserDetailVo vo2 = new PaperUserDetailVo();
                vo2.setUserId(userId);
                vo2.setIsVisitor(Integer.valueOf(0));
                usersPojo2 = usersPojoMap.get(userId);
                vo2.setUserName(usersPojo2.getShowName());
                vo2.setUserAccount(usersPojo2.getUserName());
                vo2.setUserNumber(usersPojo2.getEmployeeNumber());
                List<String> userStr2 = userOrganizeMap.get(vo2.getUserId());
                vo2.setDeptName(CollectionUtils.isEmpty(userStr2) ? "" : String.join((CharSequence)";\n", userStr2));
                vo2.setFinishTime(null);
                vo2.setPaperCount(-1);
                vo2.setScore(new BigDecimal(-1));
                vo2.setStatus(1);
                vo2.setUserSecond(0);
                this.fillRolePostParent(userRoleMap, dutiesMap, parentMap, parentIdMap, vo2);
                dataList.add(vo2);
            }
            ArrayList<Integer> userStarting = new ArrayList<Integer>();
            ArrayList<Integer> userWaitList = new ArrayList<Integer>();
            ArrayList<Integer> userFinishList = new ArrayList<Integer>();
            usersPojo2 = userStudyList.iterator();
            while (usersPojo2.hasNext()) {
                int userId = (Integer)usersPojo2.next();
                List<Object> trainingPaperList = trainingUserPaperMap.get(userId);
                if (CollectionUtils.isEmpty(trainingPaperList)) continue;
                List list = trainingPaperList.stream().filter(e -> e.getPaperStatus() == 2).collect(Collectors.toList());
                if (!CollectionUtils.isEmpty(list)) {
                    trainingPaperList = list;
                }
                TrainingUserPaper temp = trainingPaperList.get(0);
                for (TrainingUserPaper trainingUserPaper : trainingPaperList) {
                    if (Objects.isNull(trainingPaper.getScoreSelect()) || trainingPaper.getScoreSelect() == 1) {
                        if (!trainingUserPaper.getCreateTime().after(temp.getCreateTime())) continue;
                        temp = trainingUserPaper;
                        continue;
                    }
                    if (trainingUserPaper.getScore().intValue() <= temp.getScore().intValue()) continue;
                    temp = trainingUserPaper;
                }
                if (!org.springframework.util.StringUtils.isEmpty((Object)temp.getUpdateTime()) && temp.getPaperStatus() == 0) {
                    userStarting.add(userId);
                    continue;
                }
                if (!org.springframework.util.StringUtils.isEmpty((Object)temp.getSubmitTime()) && temp.getPaperStatus() == 1) {
                    userWaitList.add(userId);
                    continue;
                }
                userFinishList.add(userId);
            }
            usersPojo2 = userStarting.iterator();
            while (usersPojo2.hasNext()) {
                int userId = (Integer)usersPojo2.next();
                vo = new PaperUserDetailVo();
                vo.setUserId(userId);
                vo.setIsVisitor(Integer.valueOf(0));
                usersPojo = usersPojoMap.get(userId);
                vo.setUserName(usersPojo.getShowName());
                vo.setUserAccount(usersPojo.getUserName());
                vo.setUserNumber(usersPojo.getEmployeeNumber());
                userStr = userOrganizeMap.get(vo.getUserId());
                vo.setDeptName(CollectionUtils.isEmpty(userStr) ? "" : String.join((CharSequence)";\n", userStr));
                vo.setFinishTime(null);
                vo.setUserSecond(0);
                vo.setPaperCount(-1);
                vo.setScore(new BigDecimal(-1));
                vo.setStatus(2);
                this.fillRolePostParent(userRoleMap, dutiesMap, parentMap, parentIdMap, vo);
                dataList.add(vo);
            }
            usersPojo2 = userWaitList.iterator();
            while (usersPojo2.hasNext()) {
                int userId = (Integer)usersPojo2.next();
                vo = new PaperUserDetailVo();
                vo.setUserId(userId);
                vo.setIsVisitor(Integer.valueOf(0));
                usersPojo = usersPojoMap.get(userId);
                vo.setUserName(usersPojo.getShowName());
                vo.setUserAccount(usersPojo.getUserName());
                vo.setUserNumber(usersPojo.getEmployeeNumber());
                userStr = userOrganizeMap.get(vo.getUserId());
                vo.setDeptName(CollectionUtils.isEmpty(userStr) ? "" : String.join((CharSequence)";\n", userStr));
                List<TrainingUserPaper> list = trainingUserPaperMap.get(userId);
                vo.setFinishTime(trainingUserPaperMap.get(userId).get(0).getSubmitTime());
                vo.setUseTime(this.averageTime(list));
                vo.setUserSecond(this.averageTime2(list));
                vo.setPaperCount(list.size());
                vo.setStatus(5);
                vo.setScore(new BigDecimal(-1));
                this.fillRolePostParent(userRoleMap, dutiesMap, parentMap, parentIdMap, vo);
                dataList.add(vo);
            }
            int passLine = trainingPaper.getPassLine();
            Iterator iterator2 = userFinishList.iterator();
            while (iterator2.hasNext()) {
                int userId = (Integer)iterator2.next();
                PaperUserDetailVo vo3 = new PaperUserDetailVo();
                UsersPojo usersPojo3 = usersPojoMap.get(userId);
                vo3.setUserId(userId);
                vo3.setIsVisitor(Integer.valueOf(0));
                vo3.setUserNumber(usersPojo3.getEmployeeNumber());
                vo3.setUserName(usersPojo3.getShowName());
                vo3.setUserAccount(usersPojo3.getUserName());
                List<String> userStr3 = userOrganizeMap.get(vo3.getUserId());
                vo3.setDeptName(CollectionUtils.isEmpty(userStr3) ? "" : String.join((CharSequence)";\n", userStr3));
                BigDecimal bigDecimal = Objects.isNull(trainingExam) ? new BigDecimal(100) : trainingExam.getScore();
                List<Object> trainingPaperList = trainingUserPaperMap.get(userId);
                List userPaperList = trainingPaperList.stream().sorted(Comparator.comparing(TrainingUserPaper::getId).reversed()).collect(Collectors.toList());
                vo3.setPaperCount(userPaperList.size());
                vo3.setUseTime(this.averageTime(trainingPaperList));
                vo3.setUserSecond(this.averageTime2(trainingPaperList));
                if (!CollectionUtils.isEmpty(userPaperList)) {
                    List list;
                    BigDecimal score;
                    List list1 = trainingPaperList.stream().filter(e -> e.getPaperStatus() == 2).collect(Collectors.toList());
                    if (!CollectionUtils.isEmpty(list1)) {
                        trainingPaperList = list1;
                    }
                    TrainingUserPaper temp = trainingPaperList.get(0);
                    for (TrainingUserPaper trainingUserPaper : trainingPaperList) {
                        if (trainingUserPaper.getPaperStatus() == 1) continue;
                        if (Objects.isNull(trainingPaper.getScoreSelect()) || trainingPaper.getScoreSelect() == 1) {
                            if (temp.getPaperStatus() != 1 && !trainingUserPaper.getCreateTime().after(temp.getCreateTime())) continue;
                            temp = trainingUserPaper;
                            continue;
                        }
                        if (trainingPaper.getScoreSelect() == 0) {
                            if (temp.getPaperStatus() != 1 && trainingUserPaper.getScore().intValue() <= temp.getScore().intValue()) continue;
                            temp = trainingUserPaper;
                            continue;
                        }
                        if (trainingPaper.getScoreSelect() != 2 || temp.getPaperStatus() != 1 && !trainingUserPaper.getCreateTime().before(temp.getCreateTime())) continue;
                        temp = trainingUserPaper;
                    }
                    if (Objects.isNull(trainingPaper.getScoreSelect()) || trainingPaper.getScoreSelect() == 1) {
                        vo3.setFinishTime(temp.getSubmitTime());
                        if (temp.getPaperStatus() == 1 || temp.getPaperStatus() == 0) {
                            score = new BigDecimal(0);
                            int n = this.isPass(bigDecimal, score, passLine);
                            vo3.setFinishTime(temp.getSubmitTime());
                            vo3.setScore(new BigDecimal(-1));
                            vo3.setStatus(n);
                        } else {
                            score = temp.getScore();
                            int n = this.isPass(bigDecimal, score, passLine);
                            vo3.setFinishTime(temp.getSubmitTime());
                            vo3.setScore(score);
                            vo3.setStatus(n);
                        }
                    } else if (Objects.nonNull(trainingPaper.getScoreSelect()) && trainingPaper.getScoreSelect() == 2) {
                        score = temp.getScore();
                        int n = this.isPass(bigDecimal, score, passLine);
                        vo3.setFinishTime(temp.getSubmitTime());
                        vo3.setStatus(n);
                        vo3.setScore(score);
                    } else if (Objects.nonNull(trainingPaper.getScoreSelect()) && trainingPaper.getScoreSelect() == 0 && !CollectionUtils.isEmpty(list = userPaperList.stream().filter(e -> e.getPaperStatus() == 2).sorted(Comparator.comparing(TrainingUserPaper::getScore).reversed()).collect(Collectors.toList()))) {
                        BigDecimal bigDecimal2 = temp.getScore();
                        int status = this.isPass(bigDecimal, bigDecimal2, passLine);
                        vo3.setFinishTime(temp.getSubmitTime());
                        vo3.setStatus(status);
                        vo3.setScore(bigDecimal2);
                    }
                }
                this.fillRolePostParent(userRoleMap, dutiesMap, parentMap, parentIdMap, vo3);
                dataList.add(vo3);
            }
        }
        if (!CollectionUtils.isEmpty(trainingUserPaperList)) {
            List<PaperUserDetailVo> visitorPaperList = this.getVisitorPaperList(trainingUserPaperList, trainingPaper, trainingExam);
            dataList.addAll(visitorPaperList);
        }
        List<Object> result = new ArrayList();
        List<Object> dataList2 = new ArrayList();
        if (searchVo.getStatus() == 0) {
            dataList2 = searchVo.getOrderBy() != 0 ? (searchVo.getOrderBy() == 1 ? (searchVo.getOrder() == 1 ? dataList.stream().sorted(Comparator.comparing(PaperUserDetailVo::getFinishTime, Comparator.nullsFirst(Date::compareTo))).collect(Collectors.toList()) : dataList.stream().sorted(Comparator.comparing(PaperUserDetailVo::getFinishTime, Comparator.nullsFirst(Date::compareTo)).reversed()).collect(Collectors.toList())) : (searchVo.getOrderBy() == 2 ? (searchVo.getOrder() == 1 ? dataList.stream().sorted(Comparator.comparing(PaperUserDetailVo::getPaperCount)).collect(Collectors.toList()) : dataList.stream().sorted(Comparator.comparing(PaperUserDetailVo::getPaperCount).reversed()).collect(Collectors.toList())) : (searchVo.getOrderBy() == 3 ? (searchVo.getOrder() == 1 ? dataList.stream().sorted(Comparator.comparing(PaperUserDetailVo::getUserSecond)).collect(Collectors.toList()) : dataList.stream().sorted(Comparator.comparing(PaperUserDetailVo::getUserSecond).reversed()).collect(Collectors.toList())) : (searchVo.getOrder() == 1 ? dataList.stream().sorted(Comparator.comparing(PaperUserDetailVo::getScore)).collect(Collectors.toList()) : dataList.stream().sorted(Comparator.comparing(PaperUserDetailVo::getScore).reversed()).collect(Collectors.toList()))))) : dataList;
        } else {
            result = dataList.stream().filter(e -> e.getStatus() == searchVo.getStatus()).collect(Collectors.toList());
            if (searchVo.getOrderBy() != 0) {
                if (searchVo.getOrderBy() == 1) {
                    dataList2 = searchVo.getOrder() == 1 ? result.stream().sorted(Comparator.comparing(PaperUserDetailVo::getFinishTime, Comparator.nullsFirst(Date::compareTo))).collect(Collectors.toList()) : result.stream().sorted(Comparator.comparing(PaperUserDetailVo::getFinishTime, Comparator.nullsFirst(Date::compareTo)).reversed()).collect(Collectors.toList());
                } else if (searchVo.getOrderBy() == 2) {
                    dataList2 = searchVo.getOrder() == 1 ? result.stream().sorted(Comparator.comparing(PaperUserDetailVo::getPaperCount)).collect(Collectors.toList()) : result.stream().sorted(Comparator.comparing(PaperUserDetailVo::getPaperCount).reversed()).collect(Collectors.toList());
                } else if (searchVo.getOrderBy() == 3) {
                    dataList2 = searchVo.getOrder() == 1 ? result.stream().sorted(Comparator.comparing(PaperUserDetailVo::getUserSecond)).collect(Collectors.toList()) : result.stream().sorted(Comparator.comparing(PaperUserDetailVo::getUserSecond).reversed()).collect(Collectors.toList());
                } else if (searchVo.getOrderBy() == 4) {
                    dataList2 = searchVo.getOrder() == 1 ? result.stream().sorted(Comparator.comparing(PaperUserDetailVo::getScore)).collect(Collectors.toList()) : result.stream().sorted(Comparator.comparing(PaperUserDetailVo::getScore).reversed()).collect(Collectors.toList());
                }
            } else {
                dataList2 = result;
            }
        }
        return dataList2;
    }

    public List<PaperUserDetailVo> selectPaperUserDetails(PaperUserDetailSearchVo searchVo, Users user) {
        ArrayList<PaperUserDetailVo> dataList = new ArrayList<PaperUserDetailVo>();
        TrainingPaper trainingPaper = (TrainingPaper)this.trainingPaperMapper.selectById(Integer.valueOf(searchVo.getPaperId()));
        List<Object> userIds = new ArrayList();
        if (searchVo.getUserPaperType() == null || searchVo.getUserPaperType() == 0) {
            userIds = this.getPaperUserIdList(trainingPaper, user.getId());
        }
        if (user.getGroupId() == null) {
            user.setGroupId(trainingPaper.getEnterpriseId());
        }
        if (!org.springframework.util.StringUtils.isEmpty((Object)searchVo.getUserName())) {
            List userIdList = (List)this.userUtilService.getCheckParameters(searchVo.getUserName(), null, null, user).get("userList");
            userIds.retainAll(userIdList);
        }
        List<TrainingUserPaper> trainingUserPaperList = this.getVisitorPapers(searchVo);
        if (CollectionUtils.isEmpty(userIds) && CollectionUtils.isEmpty(trainingUserPaperList)) {
            return dataList;
        }
        TrainingExam trainingExam = (TrainingExam)this.trainingExamMapper.selectById(trainingPaper.getExamId());
        HashMap<Integer, List<RolePojo>> userRoleMap = new HashMap();
        if (!CollectionUtils.isEmpty(userIds)) {
            HashMap<String, Object> parameter = new HashMap<String, Object>();
            parameter.put("userIds", StringUtils.join(userIds, (String)","));
            parameter.put("groupId", user.getGroupId());
            com.ovopark.privilege.response.BaseResult base = this.roleApi.getUserRoleList(parameter);
            if (base != null) {
                userRoleMap = (Map)base.getData();
            }
        }
        Map<Integer, UserDutiesMo> dutiesMap = this.userUtilService.selectDutiesMap(userIds, user.getGroupId());
        Map<Integer, String> parentMap = this.userUtilService.selectParentMap(userIds, user.getGroupId());
        Map<Integer, Integer> parentIdMap = this.userUtilService.selectParentIdMap(userIds, user.getGroupId());
        if (!CollectionUtils.isEmpty(userIds)) {
            List<String> userStr;
            UsersPojo usersPojo;
            PaperUserDetailVo vo;
            Object usersPojo2;
            List<Integer> userIdList = userIds.stream().distinct().collect(Collectors.toList());
            List userIdList2 = userIds.stream().distinct().collect(Collectors.toList());
            LambdaQueryWrapper queryWrapper2 = new LambdaQueryWrapper();
            queryWrapper2.eq(TrainingUserPaper::getTrainingPaperId, (Object)searchVo.getPaperId());
            queryWrapper2.in(TrainingUserPaper::getUserId, userIdList);
            List trainingUserPaperList2 = this.trainingUserPaperMapper.selectList((Wrapper)queryWrapper2);
            List trainingUserPapers = trainingUserPaperList2.stream().filter(e -> Objects.isNull(e.getSourceType()) || Objects.nonNull(e.getSourceType()) && e.getSourceType() == 2).collect(Collectors.toList());
            List userStudyList = trainingUserPapers.stream().map(TrainingUserPaper::getUserId).distinct().collect(Collectors.toList());
            Map<Integer, List<TrainingUserPaper>> trainingUserPaperMap = trainingUserPapers.stream().collect(Collectors.groupingBy(TrainingUserPaper::getUserId));
            userIdList2.removeAll(userStudyList);
            Map<Integer, List<String>> userOrganizeMap = this.userUtilService.selectOrganizeMap(userIdList, trainingPaper.getEnterpriseId());
            Map<Integer, UsersPojo> usersPojoMap = this.userUtilService.selectUserMap(userIds);
            Iterator iterator = userIdList2.iterator();
            while (iterator.hasNext()) {
                int userId = (Integer)iterator.next();
                PaperUserDetailVo vo2 = new PaperUserDetailVo();
                vo2.setUserId(userId);
                vo2.setIsVisitor(Integer.valueOf(0));
                usersPojo2 = usersPojoMap.get(userId);
                vo2.setUserName(usersPojo2.getShowName());
                vo2.setUserNumber(usersPojo2.getEmployeeNumber());
                List<String> userStr2 = userOrganizeMap.get(vo2.getUserId());
                vo2.setDeptName(CollectionUtils.isEmpty(userStr2) ? "" : userStr2.get(0));
                vo2.setFinishTime(null);
                vo2.setPaperCount(-1);
                vo2.setScore(new BigDecimal(-1));
                vo2.setStatus(1);
                vo2.setUserSecond(0);
                this.fillRolePostParent(userRoleMap, dutiesMap, parentMap, parentIdMap, vo2);
                dataList.add(vo2);
            }
            ArrayList<Integer> userStarting = new ArrayList<Integer>();
            ArrayList<Integer> userWaitList = new ArrayList<Integer>();
            ArrayList<Integer> userFinishList = new ArrayList<Integer>();
            usersPojo2 = userStudyList.iterator();
            while (usersPojo2.hasNext()) {
                int userId = (Integer)usersPojo2.next();
                List<Object> trainingPaperList = trainingUserPaperMap.get(userId);
                if (CollectionUtils.isEmpty(trainingPaperList)) continue;
                List list = trainingPaperList.stream().filter(e -> e.getPaperStatus() == 2).collect(Collectors.toList());
                if (!CollectionUtils.isEmpty(list)) {
                    trainingPaperList = list;
                }
                TrainingUserPaper temp = trainingPaperList.get(0);
                for (TrainingUserPaper trainingUserPaper : trainingPaperList) {
                    if (trainingUserPaper.getPaperStatus() == 1) continue;
                    if (Objects.isNull(trainingPaper.getScoreSelect()) || trainingPaper.getScoreSelect() == 1) {
                        if (temp.getPaperStatus() != 1 && !trainingUserPaper.getCreateTime().after(temp.getCreateTime())) continue;
                        temp = trainingUserPaper;
                        continue;
                    }
                    if (temp.getPaperStatus() != 1 && trainingUserPaper.getScore().intValue() <= temp.getScore().intValue()) continue;
                    temp = trainingUserPaper;
                }
                if (!org.springframework.util.StringUtils.isEmpty((Object)temp.getUpdateTime()) && temp.getPaperStatus() == 0) {
                    userStarting.add(userId);
                    continue;
                }
                if (!org.springframework.util.StringUtils.isEmpty((Object)temp.getSubmitTime()) && temp.getPaperStatus() == 1) {
                    userWaitList.add(userId);
                    continue;
                }
                userFinishList.add(userId);
            }
            usersPojo2 = userStarting.iterator();
            while (usersPojo2.hasNext()) {
                int userId = (Integer)usersPojo2.next();
                vo = new PaperUserDetailVo();
                vo.setUserId(userId);
                vo.setIsVisitor(Integer.valueOf(0));
                usersPojo = usersPojoMap.get(userId);
                vo.setUserName(usersPojo.getShowName());
                vo.setUserNumber(usersPojo.getEmployeeNumber());
                userStr = userOrganizeMap.get(vo.getUserId());
                vo.setDeptName(CollectionUtils.isEmpty(userStr) ? "" : userStr.get(0));
                vo.setFinishTime(null);
                vo.setUserSecond(0);
                vo.setPaperCount(-1);
                vo.setScore(new BigDecimal(-1));
                vo.setStatus(2);
                this.fillRolePostParent(userRoleMap, dutiesMap, parentMap, parentIdMap, vo);
                dataList.add(vo);
            }
            usersPojo2 = userWaitList.iterator();
            while (usersPojo2.hasNext()) {
                int userId = (Integer)usersPojo2.next();
                vo = new PaperUserDetailVo();
                vo.setUserId(userId);
                vo.setIsVisitor(Integer.valueOf(0));
                usersPojo = usersPojoMap.get(userId);
                vo.setUserName(usersPojo.getShowName());
                vo.setUserNumber(usersPojo.getEmployeeNumber());
                userStr = userOrganizeMap.get(vo.getUserId());
                vo.setDeptName(CollectionUtils.isEmpty(userStr) ? "" : userStr.get(0));
                List<TrainingUserPaper> list = trainingUserPaperMap.get(userId);
                vo.setFinishTime(trainingUserPaperMap.get(userId).get(0).getSubmitTime());
                vo.setUseTime(this.averageTime(list));
                vo.setUserSecond(this.averageTime2(list));
                vo.setPaperCount(list.size());
                vo.setStatus(5);
                vo.setScore(new BigDecimal(-1));
                this.fillRolePostParent(userRoleMap, dutiesMap, parentMap, parentIdMap, vo);
                dataList.add(vo);
            }
            int passLine = trainingPaper.getPassLine();
            Iterator iterator2 = userFinishList.iterator();
            while (iterator2.hasNext()) {
                int userId = (Integer)iterator2.next();
                PaperUserDetailVo vo3 = new PaperUserDetailVo();
                UsersPojo usersPojo3 = usersPojoMap.get(userId);
                vo3.setUserId(userId);
                vo3.setIsVisitor(Integer.valueOf(0));
                vo3.setUserNumber(usersPojo3.getEmployeeNumber());
                vo3.setUserName(usersPojo3.getShowName());
                List<String> userStr3 = userOrganizeMap.get(vo3.getUserId());
                vo3.setDeptName(CollectionUtils.isEmpty(userStr3) ? "" : String.join((CharSequence)";\n", userStr3));
                BigDecimal bigDecimal = Objects.isNull(trainingExam) ? new BigDecimal(100) : trainingExam.getScore();
                List<Object> trainingPaperList = trainingUserPaperMap.get(userId);
                List userPaperList = trainingPaperList.stream().sorted(Comparator.comparing(TrainingUserPaper::getId).reversed()).collect(Collectors.toList());
                vo3.setPaperCount(userPaperList.size());
                vo3.setUseTime(this.averageTime(trainingPaperList));
                vo3.setUserSecond(this.averageTime2(trainingPaperList));
                if (!CollectionUtils.isEmpty(userPaperList)) {
                    List list;
                    BigDecimal score;
                    List list1 = trainingPaperList.stream().filter(e -> e.getPaperStatus() == 2).collect(Collectors.toList());
                    if (!CollectionUtils.isEmpty(list1)) {
                        trainingPaperList = list1;
                    }
                    TrainingUserPaper temp = trainingPaperList.get(0);
                    for (TrainingUserPaper trainingUserPaper : trainingPaperList) {
                        if (trainingUserPaper.getPaperStatus() == 1) continue;
                        if (Objects.isNull(trainingPaper.getScoreSelect()) || trainingPaper.getScoreSelect() == 1) {
                            if (temp.getPaperStatus() != 1 && !trainingUserPaper.getCreateTime().after(temp.getCreateTime())) continue;
                            temp = trainingUserPaper;
                            continue;
                        }
                        if (trainingPaper.getScoreSelect() == 0) {
                            if (temp.getPaperStatus() != 1 && trainingUserPaper.getScore().intValue() <= temp.getScore().intValue()) continue;
                            temp = trainingUserPaper;
                            continue;
                        }
                        if (trainingPaper.getScoreSelect() != 2 || temp.getPaperStatus() != 1 && !trainingUserPaper.getCreateTime().before(temp.getCreateTime())) continue;
                        temp = trainingUserPaper;
                    }
                    if (Objects.isNull(trainingPaper.getScoreSelect()) || trainingPaper.getScoreSelect() == 1) {
                        vo3.setFinishTime(temp.getSubmitTime());
                        if (temp.getPaperStatus() == 1 || temp.getPaperStatus() == 0) {
                            score = new BigDecimal(0);
                            int n = this.isPass(bigDecimal, score, passLine);
                            vo3.setFinishTime(temp.getSubmitTime());
                            vo3.setScore(new BigDecimal(-1));
                            vo3.setStatus(n);
                        } else {
                            score = temp.getScore();
                            int n = this.isPass(bigDecimal, score, passLine);
                            vo3.setFinishTime(temp.getSubmitTime());
                            vo3.setScore(score);
                            vo3.setStatus(n);
                        }
                    } else if (Objects.nonNull(trainingPaper.getScoreSelect()) && trainingPaper.getScoreSelect() == 2) {
                        score = temp.getScore();
                        int n = this.isPass(bigDecimal, score, passLine);
                        vo3.setFinishTime(temp.getSubmitTime());
                        vo3.setStatus(n);
                        vo3.setScore(score);
                    } else if (Objects.nonNull(trainingPaper.getScoreSelect()) && trainingPaper.getScoreSelect() == 0 && !CollectionUtils.isEmpty(list = userPaperList.stream().filter(e -> e.getPaperStatus() == 2).sorted(Comparator.comparing(TrainingUserPaper::getScore).reversed()).collect(Collectors.toList()))) {
                        BigDecimal bigDecimal2 = temp.getScore();
                        int status = this.isPass(bigDecimal, bigDecimal2, passLine);
                        vo3.setFinishTime(temp.getSubmitTime());
                        vo3.setStatus(status);
                        vo3.setScore(bigDecimal2);
                    }
                }
                this.fillRolePostParent(userRoleMap, dutiesMap, parentMap, parentIdMap, vo3);
                dataList.add(vo3);
            }
        }
        if (!CollectionUtils.isEmpty(trainingUserPaperList)) {
            List<PaperUserDetailVo> visitorPaperList = this.getVisitorPaperList(trainingUserPaperList, trainingPaper, trainingExam);
            dataList.addAll(visitorPaperList);
        }
        List<Object> result = new ArrayList();
        List<Object> dataList2 = new ArrayList();
        if (searchVo.getStatus() == 0) {
            dataList2 = searchVo.getOrderBy() != 0 ? (searchVo.getOrderBy() == 1 ? (searchVo.getOrder() == 1 ? dataList.stream().sorted(Comparator.comparing(PaperUserDetailVo::getFinishTime, Comparator.nullsFirst(Date::compareTo))).collect(Collectors.toList()) : dataList.stream().sorted(Comparator.comparing(PaperUserDetailVo::getFinishTime, Comparator.nullsFirst(Date::compareTo)).reversed()).collect(Collectors.toList())) : (searchVo.getOrderBy() == 2 ? (searchVo.getOrder() == 1 ? dataList.stream().sorted(Comparator.comparing(PaperUserDetailVo::getPaperCount)).collect(Collectors.toList()) : dataList.stream().sorted(Comparator.comparing(PaperUserDetailVo::getPaperCount).reversed()).collect(Collectors.toList())) : (searchVo.getOrderBy() == 3 ? (searchVo.getOrder() == 1 ? dataList.stream().sorted(Comparator.comparing(PaperUserDetailVo::getUserSecond)).collect(Collectors.toList()) : dataList.stream().sorted(Comparator.comparing(PaperUserDetailVo::getUserSecond).reversed()).collect(Collectors.toList())) : (searchVo.getOrder() == 1 ? dataList.stream().sorted(Comparator.comparing(PaperUserDetailVo::getScore)).collect(Collectors.toList()) : dataList.stream().sorted(Comparator.comparing(PaperUserDetailVo::getScore).reversed()).collect(Collectors.toList()))))) : dataList;
        } else {
            result = dataList.stream().filter(e -> e.getStatus() == searchVo.getStatus()).collect(Collectors.toList());
            if (searchVo.getOrderBy() != 0) {
                if (searchVo.getOrderBy() == 1) {
                    dataList2 = searchVo.getOrder() == 1 ? result.stream().sorted(Comparator.comparing(PaperUserDetailVo::getFinishTime, Comparator.nullsFirst(Date::compareTo))).collect(Collectors.toList()) : result.stream().sorted(Comparator.comparing(PaperUserDetailVo::getFinishTime, Comparator.nullsFirst(Date::compareTo)).reversed()).collect(Collectors.toList());
                } else if (searchVo.getOrderBy() == 2) {
                    dataList2 = searchVo.getOrder() == 1 ? result.stream().sorted(Comparator.comparing(PaperUserDetailVo::getPaperCount)).collect(Collectors.toList()) : result.stream().sorted(Comparator.comparing(PaperUserDetailVo::getPaperCount).reversed()).collect(Collectors.toList());
                } else if (searchVo.getOrderBy() == 3) {
                    dataList2 = searchVo.getOrder() == 1 ? result.stream().sorted(Comparator.comparing(PaperUserDetailVo::getUserSecond)).collect(Collectors.toList()) : result.stream().sorted(Comparator.comparing(PaperUserDetailVo::getUserSecond).reversed()).collect(Collectors.toList());
                } else if (searchVo.getOrderBy() == 4) {
                    dataList2 = searchVo.getOrder() == 1 ? result.stream().sorted(Comparator.comparing(PaperUserDetailVo::getScore)).collect(Collectors.toList()) : result.stream().sorted(Comparator.comparing(PaperUserDetailVo::getScore).reversed()).collect(Collectors.toList());
                }
            } else {
                dataList2 = result;
            }
        }
        return dataList2;
    }

    private void fillRolePostParent(Map<Integer, List<RolePojo>> userRoleMap, Map<Integer, UserDutiesMo> dutiesMap, Map<Integer, String> parentMap, Map<Integer, Integer> parentIdMap, PaperUserDetailVo vo) {
        if (!ObjectUtils.isEmpty(userRoleMap) && !CollectionUtils.isEmpty((Collection)userRoleMap.get(vo.getUserId()))) {
            StringBuilder role = new StringBuilder();
            for (RolePojo rolePojo : userRoleMap.get(vo.getUserId())) {
                role.append(rolePojo.getRoleName()).append(";\n");
            }
            vo.setRole(role.substring(0, role.length() - 2));
        }
        if (!ObjectUtils.isEmpty(dutiesMap) && dutiesMap.get(vo.getUserId()) != null) {
            vo.setPost(dutiesMap.get(vo.getUserId()).getDutieName());
        }
        if (!ObjectUtils.isEmpty(parentMap)) {
            vo.setParentName(parentMap.get(vo.getUserId()));
        }
        if (!ObjectUtils.isEmpty(parentIdMap)) {
            vo.setParentUserId(parentIdMap.get(vo.getUserId()));
        }
    }

    @Override
    public Map<Integer, List<TrainingLoginUser>> getTrainingLoginUserMap(List<Integer> loginUserIdList) {
        Map<Integer, List<TrainingLoginUser>> trainingLoginUserMap = new HashMap<Integer, List<TrainingLoginUser>>();
        if (!CollectionUtils.isEmpty(loginUserIdList)) {
            LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)wrapper.in(TrainingLoginUser::getUserId, loginUserIdList)).orderByDesc(TrainingLoginUser::getId);
            List trainingLoginUserList = this.trainingLoginUserMapper.selectList((Wrapper)wrapper);
            if (!CollectionUtils.isEmpty((Collection)trainingLoginUserList)) {
                trainingLoginUserMap = trainingLoginUserList.stream().collect(Collectors.groupingBy(TrainingLoginUser::getUserId));
            }
        }
        return trainingLoginUserMap;
    }

    private List<PaperUserDetailVo> getVisitorPaperList(List<TrainingUserPaper> trainingUserPaperList, TrainingPaper trainingPaper, TrainingExam trainingExam) {
        ArrayList<PaperUserDetailVo> visitorPaperList = new ArrayList<PaperUserDetailVo>();
        Map<Integer, List<TrainingUserPaper>> trainingUserPaperMap = trainingUserPaperList.stream().collect(Collectors.groupingBy(TrainingUserPaper::getLoginUserId));
        List<Integer> loginUserIdList = trainingUserPaperList.stream().map(TrainingUserPaper::getLoginUserId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        Map<Integer, List<TrainingLoginUser>> trainingLoginUserMap = this.getTrainingLoginUserMap(loginUserIdList);
        ArrayList<Integer> userStarting = new ArrayList<Integer>();
        ArrayList<Integer> userWaitList = new ArrayList<Integer>();
        ArrayList<Integer> userFinishList = new ArrayList<Integer>();
        for (int userId : trainingUserPaperMap.keySet()) {
            List<TrainingUserPaper> trainingPaperList = trainingUserPaperMap.get(userId);
            if (CollectionUtils.isEmpty(trainingPaperList)) continue;
            TrainingUserPaper temp = trainingPaperList.get(0);
            for (TrainingUserPaper userPaper : trainingPaperList) {
                if (userPaper.getPaperStatus() == 1) continue;
                if (Objects.isNull(trainingPaper.getScoreSelect()) || trainingPaper.getScoreSelect() == 1) {
                    if (temp.getPaperStatus() != 1 && !userPaper.getUpdateTime().after(temp.getUpdateTime())) continue;
                    temp = userPaper;
                    continue;
                }
                if (temp.getPaperStatus() != 1 && userPaper.getScore().intValue() <= temp.getScore().intValue()) continue;
                temp = userPaper;
            }
            if (!org.springframework.util.StringUtils.isEmpty((Object)temp.getUpdateTime()) && temp.getPaperStatus() == 0) {
                userStarting.add(userId);
                continue;
            }
            if (!org.springframework.util.StringUtils.isEmpty((Object)temp.getSubmitTime()) && temp.getPaperStatus() == 1) {
                userWaitList.add(userId);
                continue;
            }
            userFinishList.add(userId);
        }
        if (!CollectionUtils.isEmpty(userStarting)) {
            for (Integer userId : userStarting) {
                List<TrainingLoginUser> trainingLoginUserList = trainingLoginUserMap.get(userId);
                TrainingLoginUser trainingLoginUser = CollectionUtils.isEmpty(trainingLoginUserList) ? new TrainingLoginUser() : trainingLoginUserList.get(0);
                PaperUserDetailVo vo = new PaperUserDetailVo();
                vo.setUserId(userId.intValue());
                vo.setIsVisitor(Integer.valueOf(1));
                vo.setUserName(trainingLoginUser.getShowName());
                vo.setPost(trainingLoginUser.getPostName());
                vo.setUserNumber(trainingLoginUser.getEmployeeNumber());
                vo.setDeptName(trainingLoginUser.getDepartment());
                vo.setFinishTime(null);
                vo.setUserSecond(0);
                vo.setPaperCount(-1);
                vo.setScore(new BigDecimal(-1));
                vo.setStatus(2);
                visitorPaperList.add(vo);
            }
        }
        if (!CollectionUtils.isEmpty(userWaitList)) {
            for (int userId : userWaitList) {
                List<TrainingUserPaper> list = trainingUserPaperMap.get(userId);
                TrainingUserPaper trainingUserPaper = list.get(0);
                List<TrainingLoginUser> trainingLoginUserList = trainingLoginUserMap.get(userId);
                TrainingLoginUser trainingLoginUser = CollectionUtils.isEmpty(trainingLoginUserList) ? new TrainingLoginUser() : trainingLoginUserList.get(0);
                PaperUserDetailVo vo = new PaperUserDetailVo();
                vo.setUserId(userId);
                vo.setIsVisitor(Integer.valueOf(1));
                vo.setUserName(trainingLoginUser.getShowName());
                vo.setPost(trainingLoginUser.getPostName());
                vo.setUserNumber(trainingLoginUser.getEmployeeNumber());
                vo.setDeptName(trainingLoginUser.getDepartment());
                vo.setFinishTime(trainingUserPaper.getSubmitTime());
                vo.setUseTime(this.averageTime(list));
                vo.setUserSecond(this.averageTime2(list));
                vo.setPaperCount(list.size());
                vo.setStatus(5);
                vo.setScore(new BigDecimal(-1));
                visitorPaperList.add(vo);
            }
        }
        if (!CollectionUtils.isEmpty(userFinishList)) {
            int passLine = trainingPaper.getPassLine();
            Iterator iterator = userFinishList.iterator();
            while (iterator.hasNext()) {
                List list;
                BigDecimal score;
                int userId = (Integer)iterator.next();
                List<TrainingUserPaper> trainingPaperList = trainingUserPaperMap.get(userId);
                TrainingUserPaper trainingUserPaper = trainingPaperList.get(0);
                List<TrainingLoginUser> trainingLoginUserList = trainingLoginUserMap.get(userId);
                TrainingLoginUser trainingLoginUser = CollectionUtils.isEmpty(trainingLoginUserList) ? new TrainingLoginUser() : trainingLoginUserList.get(0);
                PaperUserDetailVo vo = new PaperUserDetailVo();
                vo.setUserId(userId);
                vo.setIsVisitor(Integer.valueOf(1));
                vo.setUserName(trainingLoginUser.getShowName());
                vo.setUserNumber(trainingLoginUser.getEmployeeNumber());
                vo.setDeptName(trainingLoginUser.getDepartment());
                vo.setPost(trainingLoginUser.getPostName());
                BigDecimal org_score = ObjectUtils.isEmpty((Object)trainingExam) ? new BigDecimal(100) : trainingExam.getScore();
                List userPaperList = trainingPaperList.stream().sorted(Comparator.comparing(TrainingUserPaper::getId).reversed()).collect(Collectors.toList());
                vo.setPaperCount(userPaperList.size());
                vo.setUseTime(this.averageTime(trainingPaperList));
                vo.setUserSecond(this.averageTime2(trainingPaperList));
                for (TrainingUserPaper userPaper : trainingPaperList) {
                    if (userPaper.getPaperStatus() == 1) continue;
                    if (Objects.isNull(trainingPaper.getScoreSelect()) || trainingPaper.getScoreSelect() == 1) {
                        if (trainingUserPaper.getPaperStatus() != 1 && !userPaper.getSubmitTime().after(trainingUserPaper.getSubmitTime())) continue;
                        trainingUserPaper = userPaper;
                        continue;
                    }
                    if (trainingPaper.getScoreSelect() == 0) {
                        if (trainingUserPaper.getPaperStatus() != 1 && userPaper.getScore().compareTo(trainingUserPaper.getScore()) <= 0) continue;
                        trainingUserPaper = userPaper;
                        continue;
                    }
                    if (trainingPaper.getScoreSelect() != 2 || trainingUserPaper.getPaperStatus() != 1 && !userPaper.getSubmitTime().before(trainingUserPaper.getSubmitTime())) continue;
                    trainingUserPaper = userPaper;
                }
                if (Objects.isNull(trainingPaper.getScoreSelect()) || trainingPaper.getScoreSelect() == 1) {
                    vo.setFinishTime(trainingUserPaper.getSubmitTime());
                    if (trainingUserPaper.getPaperStatus() == 1 || trainingUserPaper.getPaperStatus() == 0) {
                        score = new BigDecimal(0);
                        int status = this.isPass(org_score, score, passLine);
                        vo.setFinishTime(trainingUserPaper.getSubmitTime());
                        vo.setScore(new BigDecimal(-1));
                        vo.setStatus(status);
                    } else {
                        score = trainingUserPaper.getScore();
                        int status = this.isPass(org_score, score, passLine);
                        vo.setFinishTime(trainingUserPaper.getSubmitTime());
                        vo.setScore(score);
                        vo.setStatus(status);
                    }
                } else if (Objects.nonNull(trainingPaper.getScoreSelect()) && trainingPaper.getScoreSelect() == 2) {
                    score = trainingUserPaper.getScore();
                    int status = this.isPass(org_score, score, passLine);
                    vo.setFinishTime(trainingUserPaper.getSubmitTime());
                    vo.setStatus(status);
                    vo.setScore(score);
                } else if (Objects.nonNull(trainingPaper.getScoreSelect()) && trainingPaper.getScoreSelect() == 0 && !CollectionUtils.isEmpty(list = userPaperList.stream().filter(e -> e.getPaperStatus() == 2).sorted(Comparator.comparing(TrainingUserPaper::getScore).reversed()).collect(Collectors.toList()))) {
                    BigDecimal score2 = trainingUserPaper.getScore();
                    int status = this.isPass(org_score, score2, passLine);
                    vo.setFinishTime(trainingUserPaper.getSubmitTime());
                    vo.setStatus(status);
                    vo.setScore(score2);
                }
                visitorPaperList.add(vo);
            }
        }
        return visitorPaperList;
    }

    private List<PaperUserDetailVo> getAllVisitorPaperList(List<TrainingUserPaper> trainingUserPaperList, TrainingPaper trainingPaper, BigDecimal org_score) {
        List<Integer> loginUserIdList = trainingUserPaperList.stream().map(TrainingUserPaper::getLoginUserId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        Map<Integer, List<TrainingLoginUser>> trainingLoginUserMap = this.getTrainingLoginUserMap(loginUserIdList);
        ArrayList<PaperUserDetailVo> visitorPaperList = new ArrayList<PaperUserDetailVo>();
        int passLine = trainingPaper.getPassLine();
        for (TrainingUserPaper paper : trainingUserPaperList) {
            List<TrainingLoginUser> trainingLoginUserList = trainingLoginUserMap.get(paper.getLoginUserId());
            TrainingLoginUser trainingLoginUser = CollectionUtils.isEmpty(trainingLoginUserList) ? new TrainingLoginUser() : trainingLoginUserList.get(0);
            PaperUserDetailVo vo = new PaperUserDetailVo();
            vo.setUserId(paper.getLoginUserId().intValue());
            vo.setIsVisitor(Integer.valueOf(1));
            vo.setUserName(trainingLoginUser.getShowName());
            vo.setUserNumber(trainingLoginUser.getEmployeeNumber());
            vo.setDeptName(trainingLoginUser.getDepartment());
            vo.setPost(trainingLoginUser.getPostName());
            vo.setStartTime(paper.getUpdateTime());
            vo.setFinishTime(paper.getSubmitTime());
            vo.setPaperCount(1);
            vo.setUseTime(this.averageTime(Collections.singletonList(paper)));
            vo.setUserSecond(this.averageTime2(Collections.singletonList(paper)));
            if (Objects.nonNull(paper.getUpdateTime()) && paper.getPaperStatus() == 0) {
                vo.setStatus(2);
                vo.setScore(new BigDecimal(-2));
            } else if (Objects.nonNull(paper.getUpdateTime()) && paper.getPaperStatus() == 1) {
                vo.setStatus(5);
                vo.setScore(new BigDecimal(-1));
            } else {
                vo.setStatus(this.isPass(org_score, paper.getScore(), trainingPaper.getPassLine()));
                vo.setScore(paper.getScore());
            }
            visitorPaperList.add(vo);
        }
        return visitorPaperList;
    }

    private String averageTime(List<TrainingUserPaper> list) {
        if (CollectionUtils.isEmpty(list)) {
            return "0";
        }
        int count = list.size();
        if (count == 0) {
            return "0";
        }
        int timeSecond = 0;
        for (TrainingUserPaper paper : list) {
            timeSecond += DateUtils.countSecond(paper.getSubmitTime(), paper.getUpdateTime());
        }
        return DateUtils.getUseTimeFormal(timeSecond / count);
    }

    private int averageTime2(List<TrainingUserPaper> list) {
        if (CollectionUtils.isEmpty(list)) {
            return 0;
        }
        int count = list.size();
        int timeSecond = 0;
        for (TrainingUserPaper paper : list) {
            timeSecond += DateUtils.countSecond(paper.getSubmitTime(), paper.getUpdateTime());
        }
        if (count == 0) {
            return 0;
        }
        return timeSecond / count;
    }

    @Override
    public Map<String, Integer> selectPaperUserDetailByStatus(PaperUserDetailSearchVo searchVo, Users user) {
        Object temp;
        List trainingPaperList;
        int userId;
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        TrainingPaper trainingPaper = (TrainingPaper)this.trainingPaperMapper.selectById(Integer.valueOf(searchVo.getPaperId()));
        int groupId = trainingPaper.getEnterpriseId();
        int passLine = trainingPaper.getPassLine();
        TrainingExam trainingExam = (TrainingExam)this.trainingExamMapper.selectById(trainingPaper.getExamId());
        BigDecimal org_score = new BigDecimal(100);
        if (!ObjectUtils.isEmpty((Object)trainingExam)) {
            org_score = trainingExam.getScore();
        }
        List<Object> userIds = new ArrayList();
        if (searchVo.getUserPaperType() == null || searchVo.getUserPaperType() == 0) {
            userIds = this.getPaperUserIdList(trainingPaper, user.getId());
        }
        LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)wrapper1.eq(TrainingUserPaper::getTrainingPaperId, (Object)searchVo.getPaperId())).isNotNull(TrainingUserPaper::getLoginUserId);
        if (user.getGroupId() == null) {
            user.setGroupId(Integer.valueOf(groupId));
        }
        if (!org.springframework.util.StringUtils.isEmpty((Object)searchVo.getUserName())) {
            List userNames = (List)this.userUtilService.getCheckParameters(searchVo.getUserName(), null, null, user).get("userList");
            userIds.retainAll(userNames);
            wrapper1.like(TrainingUserPaper::getLoginShowName, (Object)searchVo.getUserName());
        }
        List trainingVisitorPaperList = new ArrayList();
        if (searchVo.getUserPaperType() == null || searchVo.getUserPaperType() == 1) {
            trainingVisitorPaperList = this.trainingUserPaperMapper.selectList((Wrapper)wrapper1);
        }
        List userIdList = userIds.stream().distinct().collect(Collectors.toList());
        List userIdList2 = userIds.stream().distinct().collect(Collectors.toList());
        Map<Object, Object> trainingUserPaperMap = new HashMap();
        List<Object> useStudyList = new ArrayList();
        if (!CollectionUtils.isEmpty(userIdList)) {
            LambdaQueryWrapper queryWrapper2 = new LambdaQueryWrapper();
            queryWrapper2.eq(TrainingUserPaper::getTrainingPaperId, (Object)searchVo.getPaperId());
            queryWrapper2.in(TrainingUserPaper::getUserId, userIdList);
            List trainingUserPaperList = this.trainingUserPaperMapper.selectList((Wrapper)queryWrapper2);
            List trainingUserPapers = trainingUserPaperList.stream().filter(e -> Objects.isNull(e.getSourceType()) || Objects.nonNull(e.getSourceType()) && e.getSourceType() == 2).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(trainingUserPapers)) {
                useStudyList = trainingUserPapers.stream().map(TrainingUserPaper::getUserId).distinct().collect(Collectors.toList());
                userIdList2.removeAll(useStudyList);
                trainingUserPaperMap = trainingUserPapers.stream().collect(Collectors.groupingBy(TrainingUserPaper::getUserId));
            }
        }
        AtomicInteger starting = new AtomicInteger();
        AtomicInteger pass = new AtomicInteger();
        AtomicInteger noPass = new AtomicInteger();
        AtomicInteger wait = new AtomicInteger();
        ArrayList<Integer> userFinishList = new ArrayList<Integer>();
        Iterator iterator = useStudyList.iterator();
        while (iterator.hasNext()) {
            userId = (Integer)iterator.next();
            trainingPaperList = (List)trainingUserPaperMap.get(userId);
            if (CollectionUtils.isEmpty((Collection)trainingPaperList)) continue;
            List list = trainingPaperList.stream().filter(e -> e.getPaperStatus() == 2).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(list)) {
                trainingPaperList = list;
            }
            temp = (TrainingUserPaper)trainingPaperList.get(0);
            for (Object userPaper : trainingPaperList) {
                if (userPaper.getPaperStatus() == 1) continue;
                if (Objects.isNull(trainingPaper.getScoreSelect()) || trainingPaper.getScoreSelect() == 1) {
                    if (!userPaper.getCreateTime().after(temp.getCreateTime())) continue;
                    temp = userPaper;
                    continue;
                }
                if (userPaper.getScore().intValue() <= temp.getScore().intValue()) continue;
                temp = userPaper;
            }
            if (Objects.nonNull(temp.getUpdateTime()) && temp.getPaperStatus() == 0) {
                starting.incrementAndGet();
                continue;
            }
            if (Objects.nonNull(temp.getSubmitTime()) && temp.getPaperStatus() == 1) {
                wait.incrementAndGet();
                continue;
            }
            userFinishList.add(userId);
        }
        iterator = userFinishList.iterator();
        while (iterator.hasNext()) {
            userId = (Integer)iterator.next();
            trainingPaperList = (List)trainingUserPaperMap.get(userId);
            List userPaperList = trainingPaperList.stream().sorted(Comparator.comparing(TrainingUserPaper::getId).reversed()).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(userPaperList)) continue;
            temp = (TrainingUserPaper)trainingPaperList.get(0);
            for (Object userPaper : trainingPaperList) {
                if (userPaper.getPaperStatus() == 1) continue;
                if (Objects.isNull(trainingPaper.getScoreSelect()) || trainingPaper.getScoreSelect() == 1) {
                    if (!userPaper.getCreateTime().after(temp.getCreateTime())) continue;
                    temp = userPaper;
                    continue;
                }
                if (trainingPaper.getScoreSelect() == 0) {
                    if (userPaper.getScore().intValue() <= temp.getScore().intValue()) continue;
                    temp = userPaper;
                    continue;
                }
                if (trainingPaper.getScoreSelect() != 2 || !userPaper.getCreateTime().before(temp.getCreateTime())) continue;
                temp = userPaper;
            }
            int status = this.isPass(org_score, temp.getScore(), passLine);
            if (status == 3) {
                pass.incrementAndGet();
                continue;
            }
            if (status != 4) continue;
            noPass.incrementAndGet();
        }
        if (!CollectionUtils.isEmpty(trainingVisitorPaperList)) {
            Map<Integer, List<TrainingUserPaper>> trainingVisitorPaperMap = trainingVisitorPaperList.stream().collect(Collectors.groupingBy(TrainingUserPaper::getLoginUserId));
            userFinishList = new ArrayList();
            for (int userId2 : trainingVisitorPaperMap.keySet()) {
                List<Object> trainingPaperList2 = trainingVisitorPaperMap.get(userId2);
                if (CollectionUtils.isEmpty(trainingPaperList2)) continue;
                List list = trainingPaperList2.stream().filter(e -> e.getPaperStatus() == 2).collect(Collectors.toList());
                if (!CollectionUtils.isEmpty(list)) {
                    trainingPaperList2 = list;
                }
                TrainingUserPaper temp2 = trainingPaperList2.get(0);
                for (TrainingUserPaper trainingUserPaper : trainingPaperList2) {
                    if (trainingUserPaper.getPaperStatus() == 1) continue;
                    if (Objects.isNull(trainingPaper.getScoreSelect()) || trainingPaper.getScoreSelect() == 1) {
                        if (temp2.getPaperStatus() != 1 && !trainingUserPaper.getUpdateTime().after(temp2.getUpdateTime())) continue;
                        temp2 = trainingUserPaper;
                        continue;
                    }
                    if (temp2.getPaperStatus() != 1 && trainingUserPaper.getScore().intValue() <= temp2.getScore().intValue()) continue;
                    temp2 = trainingUserPaper;
                }
                if (!org.springframework.util.StringUtils.isEmpty((Object)temp2.getUpdateTime()) && temp2.getPaperStatus() == 0) {
                    starting.incrementAndGet();
                    continue;
                }
                if (!org.springframework.util.StringUtils.isEmpty((Object)temp2.getSubmitTime()) && temp2.getPaperStatus() == 1) {
                    wait.incrementAndGet();
                    continue;
                }
                userFinishList.add(userId2);
            }
            for (int userId3 : userFinishList) {
                List<TrainingUserPaper> trainingPaperList2 = trainingVisitorPaperMap.get(userId3);
                List userPaperList = trainingPaperList2.stream().sorted(Comparator.comparing(TrainingUserPaper::getId).reversed()).collect(Collectors.toList());
                if (CollectionUtils.isEmpty(userPaperList)) continue;
                TrainingUserPaper temp3 = trainingPaperList2.get(0);
                for (TrainingUserPaper trainingUserPaper : trainingPaperList2) {
                    if (trainingUserPaper.getPaperStatus() == 1) continue;
                    if (Objects.isNull(trainingPaper.getScoreSelect()) || trainingPaper.getScoreSelect() == 1) {
                        if (!trainingUserPaper.getCreateTime().after(temp3.getCreateTime())) continue;
                        temp3 = trainingUserPaper;
                        continue;
                    }
                    if (trainingPaper.getScoreSelect() == 0) {
                        if (trainingUserPaper.getScore().intValue() <= temp3.getScore().intValue()) continue;
                        temp3 = trainingUserPaper;
                        continue;
                    }
                    if (trainingPaper.getScoreSelect() != 2 || !trainingUserPaper.getCreateTime().before(temp3.getCreateTime())) continue;
                    temp3 = trainingUserPaper;
                }
                int status = this.isPass(org_score, temp3.getScore(), passLine);
                if (status == 3) {
                    pass.incrementAndGet();
                    continue;
                }
                if (status != 4) continue;
                noPass.incrementAndGet();
            }
        }
        result.put("noStart", userIdList2.size());
        result.put("starting", starting.get());
        result.put("wait", wait.get());
        result.put("pass", pass.get());
        result.put("noPass", noPass.get());
        result.put("all", userIdList2.size() + starting.get() + wait.get() + pass.get() + noPass.get());
        return result;
    }

    @Override
    public UserExamDetailVo selectUserExamDetail(UserExamSearchVo searchVo) {
        TrainingExam trainingExam;
        TrainingPaper trainingPaper = (TrainingPaper)this.trainingPaperMapper.selectById(Integer.valueOf(searchVo.getPaperId()));
        BigDecimal org_score = new BigDecimal("100");
        if (trainingPaper.getExamId() != null && !ObjectUtils.isEmpty((Object)(trainingExam = (TrainingExam)this.trainingExamMapper.selectById(trainingPaper.getExamId())))) {
            org_score = trainingExam.getScore();
        }
        int passLine = trainingPaper.getPassLine();
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        if (searchVo.getIsVisitor() != null && searchVo.getIsVisitor() == 1) {
            queryWrapper.eq(TrainingUserPaper::getLoginUserId, (Object)searchVo.getUserId());
        } else {
            queryWrapper.eq(TrainingUserPaper::getUserId, (Object)searchVo.getUserId());
        }
        queryWrapper.eq(TrainingUserPaper::getTrainingPaperId, (Object)searchVo.getPaperId());
        queryWrapper.eq(!org.springframework.util.StringUtils.isEmpty((Object)searchVo.getSourceType()), TrainingUserPaper::getSourceType, (Object)searchVo.getSourceType());
        queryWrapper.eq(!org.springframework.util.StringUtils.isEmpty((Object)searchVo.getProjectId()), TrainingUserPaper::getSourceProjectId, (Object)searchVo.getProjectId());
        queryWrapper.eq(!org.springframework.util.StringUtils.isEmpty((Object)searchVo.getTaskId()), TrainingUserPaper::getSourceTaskId, (Object)searchVo.getTaskId());
        queryWrapper.orderByAsc(TrainingUserPaper::getId);
        List trainingUserPaperList = this.trainingUserPaperMapper.selectList((Wrapper)queryWrapper);
        ArrayList<UserExam> result = new ArrayList<UserExam>();
        UserExamDetailVo vo = new UserExamDetailVo();
        vo.setPaperId(searchVo.getPaperId());
        vo.setExamId(trainingPaper.getExamId().intValue());
        vo.setScoreSelect(trainingPaper.getScoreSelect());
        if (!CollectionUtils.isEmpty((Collection)trainingUserPaperList)) {
            int i;
            int topScoreIndex = 0;
            Integer newScoreIndex = null;
            double topScore = 0.0;
            for (i = trainingUserPaperList.size() - 1; i >= 0; --i) {
                TrainingUserPaper paper = (TrainingUserPaper)trainingUserPaperList.get(i);
                if (!paper.getPaperStatus().equals(2)) continue;
                if (topScore <= paper.getScore().doubleValue()) {
                    topScore = paper.getScore().doubleValue();
                    topScoreIndex = i;
                }
                if (newScoreIndex != null) continue;
                newScoreIndex = i;
            }
            for (i = 0; i < trainingUserPaperList.size(); ++i) {
                TrainingUserPaper trainingUserPaper = (TrainingUserPaper)trainingUserPaperList.get(i);
                UserExam userExam = new UserExam();
                userExam.setUserPaperId(trainingUserPaper.getId().intValue());
                userExam.setSort(i + 1);
                if (Objects.nonNull(trainingUserPaper.getUpdateTime()) && Objects.nonNull(trainingUserPaper.getSubmitTime()) && trainingUserPaper.getPaperStatus() == 1) {
                    userExam.setSubmitTime(trainingUserPaper.getSubmitTime());
                    userExam.setUserTime(DateUtils.getUseTimeFormal(DateUtils.countSecond(trainingUserPaper.getSubmitTime(), trainingUserPaper.getUpdateTime())));
                    userExam.setScore(new BigDecimal(-1));
                    userExam.setStatus(5);
                } else if (Objects.nonNull(trainingUserPaper.getSubmitTime()) && trainingUserPaper.getPaperStatus() == 2) {
                    userExam.setSubmitTime(trainingUserPaper.getSubmitTime());
                    userExam.setUserTime(DateUtils.getUseTimeFormal(DateUtils.countSecond(trainingUserPaper.getSubmitTime(), trainingUserPaper.getUpdateTime())));
                    BigDecimal score = trainingUserPaper.getScore();
                    userExam.setScore(score);
                    userExam.setStatus(this.isPass(org_score, score, passLine));
                    if (trainingPaper.getScoreSelect() != null && trainingPaper.getScoreSelect().equals(0)) {
                        if (topScoreIndex == i) {
                            userExam.setIsSelect(Integer.valueOf(1));
                        } else {
                            userExam.setIsSelect(Integer.valueOf(0));
                        }
                    } else if (newScoreIndex == i) {
                        userExam.setIsSelect(Integer.valueOf(1));
                    } else {
                        userExam.setIsSelect(Integer.valueOf(0));
                    }
                } else if (Objects.nonNull(trainingUserPaper.getUpdateTime()) && trainingUserPaper.getPaperStatus() == 0) {
                    userExam.setSubmitTime(null);
                    userExam.setUserTime("-");
                    userExam.setScore(new BigDecimal(-1));
                    userExam.setStatus(1);
                } else {
                    userExam.setSubmitTime(null);
                    userExam.setUserTime("-");
                    userExam.setScore(new BigDecimal(-1));
                    userExam.setStatus(2);
                }
                result.add(userExam);
            }
            vo.setUserExamList(result);
            return vo;
        }
        vo.setUserId(searchVo.getUserId());
        vo.setUserExamList(Collections.emptyList());
        return vo;
    }

    @Override
    public TrainingPaper selectById(int paperId) {
        return (TrainingPaper)this.trainingPaperMapper.selectById(Integer.valueOf(paperId));
    }

    @Override
    public void selectUserExamByExecl(HttpServletResponse response, PaperUserDetailSearchVo searchVo, Users user) {
        TrainingPaper trainingPaper = (TrainingPaper)this.trainingPaperMapper.selectById(Integer.valueOf(searchVo.getPaperId()));
        int groupId = trainingPaper.getEnterpriseId();
        Locale locale = Authenticator.getInstance().getCurrentClient().getLocale();
        String unPassName = this.messageSource.getMessage("training.learn.unpass", null, locale);
        String passName = this.messageSource.getMessage("training.learn.pass", null, locale);
        String waitRead = this.messageSource.getMessage("training.learn.wait.read", null, locale);
        SimpleDateFormat format = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        if (searchVo.getExportStatus() == 1) {
            List<PaperUserDetailVo> list = this.selectPaperUserDetails(searchVo, user);
            ArrayList<Integer> userIdList = new ArrayList();
            if (!CollectionUtils.isEmpty(list)) {
                userIdList = list.stream().filter(e -> e.getIsVisitor() == 0).map(PaperUserDetailVo::getUserId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            }
            Map<Object, Object> roleMap = new HashMap();
            Map<Object, Object> organizeMap = new HashMap();
            Map<Object, Object> parentMap = new HashMap();
            Map organMap1 = new HashMap();
            Map organMap2 = new HashMap();
            Map organMap3 = new HashMap();
            Map organMap4 = new HashMap();
            Map organMap5 = new HashMap();
            Map shopMap = new HashMap();
            Map shopDetailMap = new HashMap();
            if (!CollectionUtils.isEmpty(userIdList)) {
                organizeMap = this.userUtilService.selectOrganizeMap(userIdList, groupId);
                roleMap = this.userUtilService.selectRolesByUsers(userIdList, groupId);
                parentMap = this.userUtilService.selectParentMap(userIdList, groupId);
                UsersAndOrgsMo mo = new UsersAndOrgsMo();
                mo.setGroupId(Integer.valueOf(groupId));
                mo.setLevelList(Collections.singletonList(1));
                mo.setUserIdList(userIdList);
                mo.setShowDepartment(Boolean.valueOf(false));
                BaseResult base1 = this.userOrganizeApi.getUserOrganizeLevelByUserIds(mo);
                if (base1 != null) {
                    organMap1 = (Map)base1.getData();
                }
                mo.setLevelList(Collections.singletonList(2));
                BaseResult base2 = this.userOrganizeApi.getUserOrganizeLevelByUserIds(mo);
                if (base2 != null) {
                    organMap2 = (Map)base2.getData();
                }
                mo.setLevelList(Collections.singletonList(3));
                BaseResult base3 = this.userOrganizeApi.getUserOrganizeLevelByUserIds(mo);
                if (base3 != null) {
                    organMap3 = (Map)base3.getData();
                }
                mo.setLevelList(Collections.singletonList(4));
                BaseResult base4 = this.userOrganizeApi.getUserOrganizeLevelByUserIds(mo);
                if (base4 != null) {
                    organMap4 = (Map)base4.getData();
                }
                mo.setLevelList(Collections.singletonList(5));
                BaseResult base5 = this.userOrganizeApi.getUserOrganizeLevelByUserIds(mo);
                if (base5 != null) {
                    organMap5 = (Map)base5.getData();
                }
                UsersAndOrgsMo mo1 = new UsersAndOrgsMo();
                mo1.setGroupId(Integer.valueOf(groupId));
                mo1.setUserIdList(userIdList);
                mo1.setShowDepartment(Boolean.valueOf(true));
                BaseResult base = this.userOrganizeApi.getUserOrganizeLevelByUserIds(mo1);
                if (base != null && base.getData() != null) {
                    shopMap = (Map)base.getData();
                }
                mo1.setShowAllPath(Boolean.valueOf(true));
                BaseResult bases = this.userOrganizeApi.getUserOrganizePathtByUserIds(mo1);
                if (bases != null && bases.getData() != null) {
                    shopDetailMap = (Map)bases.getData();
                }
            }
            String fileName = MessageFormat.format("{0}_{1}_{2}", trainingPaper.getTitle(), this.messageSource.getMessage("training.exam.student.score", null, locale), DateUtils.format(new Date(), "yyyyMMdd"));
            fileName = ExcelUtil.getFileName(fileName) + ".xlsx";
            XSSFWorkbook wb = new XSSFWorkbook();
            XSSFSheet sheet = wb.createSheet(fileName);
            XSSFCellStyle titleSty = wb.createCellStyle();
            XSSFFont font = wb.createFont();
            font.setFontHeightInPoints((short)16);
            titleSty.setFont((Font)font);
            XSSFRow row = sheet.createRow(0);
            row.createCell(0).setCellValue("id");
            row.createCell(1).setCellValue(this.messageSource.getMessage("training.user.details.name", null, locale));
            row.createCell(2).setCellValue(this.messageSource.getMessage("training.user.details.employeeNumber", null, locale));
            row.createCell(3).setCellValue(this.messageSource.getMessage("training.course.analysis.role", null, locale));
            row.createCell(4).setCellValue(this.messageSource.getMessage("training.course.analysis.superior", null, locale));
            row.createCell(5).setCellValue(this.messageSource.getMessage("training.course.analysis.department", null, locale));
            row.createCell(6).setCellValue(this.messageSource.getMessage("training.course.analysis.first.organize", null, locale));
            row.createCell(7).setCellValue(this.messageSource.getMessage("training.course.analysis.second.organize", null, locale));
            row.createCell(8).setCellValue(this.messageSource.getMessage("training.course.analysis.third.organize", null, locale));
            row.createCell(9).setCellValue(this.messageSource.getMessage("training.course.analysis.fourth.organize", null, locale));
            row.createCell(10).setCellValue(this.messageSource.getMessage("training.course.analysis.fifth.organize", null, locale));
            row.createCell(11).setCellValue(this.messageSource.getMessage("training.course.analysis.dep", null, locale));
            row.createCell(12).setCellValue(this.messageSource.getMessage("training.paper.finish.time", null, locale));
            row.createCell(13).setCellValue(this.messageSource.getMessage("training.paper.num", null, locale));
            row.createCell(14).setCellValue(this.messageSource.getMessage("training.course.average.time", null, locale));
            row.createCell(15).setCellValue(this.messageSource.getMessage("training.paper.score", null, locale));
            row.createCell(16).setCellValue(this.messageSource.getMessage("training.paper.status", null, locale));
            for (int i = 0; i < list.size(); ++i) {
                List pojoList;
                List pojoList2;
                List pojoList3;
                List pojoList4;
                List pojoList5;
                List pojoList6;
                List pojoList7;
                row = sheet.createRow(i + 1);
                PaperUserDetailVo vo = list.get(i);
                row.createCell(0).setCellValue(String.valueOf(vo.getUserId()));
                row.createCell(1).setCellValue(vo.getUserName());
                row.createCell(2).setCellValue(vo.getUserNumber());
                String roleName = "";
                if (!CollectionUtils.isEmpty(roleMap) && !CollectionUtils.isEmpty((Collection)(pojoList7 = (List)roleMap.get(vo.getUserId())))) {
                    List listStr = pojoList7.stream().map(RolePojo::getRoleName).filter(Objects::nonNull).collect(Collectors.toList());
                    roleName = StringUtils.join(listStr, (String)",");
                }
                row.createCell(3).setCellValue(roleName);
                String parentName = "";
                if (!org.springframework.util.StringUtils.isEmpty(parentMap)) {
                    parentName = (String)parentMap.get(vo.getUserId());
                }
                row.createCell(4).setCellValue(parentName);
                String organName1 = "";
                if (!org.springframework.util.StringUtils.isEmpty(organMap1) && !CollectionUtils.isEmpty((Collection)(pojoList6 = (List)organMap1.get(vo.getUserId())))) {
                    pojoList6 = pojoList6.stream().distinct().collect(Collectors.toList());
                    organName1 = StringUtils.join(pojoList6, (String)",");
                }
                String departName = vo.getDeptName();
                List nameList = (List)organizeMap.get(vo.getUserId());
                if (!CollectionUtils.isEmpty((Collection)nameList)) {
                    departName = String.join((CharSequence)";\n", nameList);
                }
                row.createCell(5).setCellValue(departName);
                row.createCell(6).setCellValue(organName1);
                String organName2 = "";
                if (!org.springframework.util.StringUtils.isEmpty(organMap2) && !CollectionUtils.isEmpty((Collection)(pojoList5 = (List)organMap2.get(vo.getUserId())))) {
                    pojoList5 = pojoList5.stream().distinct().collect(Collectors.toList());
                    organName2 = StringUtils.join(pojoList5, (String)",");
                }
                row.createCell(7).setCellValue(organName2);
                String organName3 = "";
                if (!org.springframework.util.StringUtils.isEmpty(organMap3) && !CollectionUtils.isEmpty((Collection)(pojoList4 = (List)organMap3.get(vo.getUserId())))) {
                    pojoList4 = pojoList4.stream().distinct().collect(Collectors.toList());
                    organName3 = StringUtils.join(pojoList4, (String)",");
                }
                row.createCell(8).setCellValue(organName3);
                String organName4 = "";
                if (!org.springframework.util.StringUtils.isEmpty(organMap4) && !CollectionUtils.isEmpty((Collection)(pojoList3 = (List)organMap4.get(vo.getUserId())))) {
                    pojoList3 = pojoList3.stream().distinct().collect(Collectors.toList());
                    organName4 = StringUtils.join(pojoList3, (String)",");
                }
                row.createCell(9).setCellValue(organName4);
                String organName5 = "";
                if (!org.springframework.util.StringUtils.isEmpty(organMap5) && !CollectionUtils.isEmpty((Collection)(pojoList2 = (List)organMap5.get(vo.getUserId())))) {
                    pojoList2 = pojoList2.stream().distinct().collect(Collectors.toList());
                    organName5 = StringUtils.join(pojoList2, (String)",");
                }
                row.createCell(10).setCellValue(organName5);
                String shopName = "";
                if (!org.springframework.util.StringUtils.isEmpty(shopMap) && !CollectionUtils.isEmpty((Collection)(pojoList = (List)shopMap.get(vo.getUserId())))) {
                    pojoList = pojoList.stream().distinct().collect(Collectors.toList());
                    shopName = StringUtils.join(pojoList, (String)",");
                }
                row.createCell(11).setCellValue(shopName);
                List shopDeatailPathList = (List)shopDetailMap.get(vo.getUserId());
                String shopPathName = "";
                if (!CollectionUtils.isEmpty((Collection)shopDeatailPathList) && (shopPathName = String.join((CharSequence)";", shopDeatailPathList)).length() > 1000) {
                    shopPathName = shopPathName.substring(0, 1000);
                }
                row.createCell(12).setCellValue(Objects.nonNull(vo.getFinishTime()) ? format.format(vo.getFinishTime()) : "");
                row.createCell(13).setCellValue(vo.getPaperCount() == -1 ? "-" : String.valueOf(vo.getPaperCount()));
                row.createCell(14).setCellValue(vo.getUseTime());
                String statusName = "";
                String score = "";
                if (vo.getStatus() == 1) {
                    String unexam;
                    statusName = unexam = this.messageSource.getMessage("training.paper.unexam", null, locale);
                    score = "-";
                } else if (vo.getStatus() == 2) {
                    statusName = this.messageSource.getMessage("training.paper.ing", null, locale);
                    score = "-";
                } else if (vo.getStatus() == 3) {
                    statusName = passName;
                    score = String.valueOf(vo.getScore());
                } else if (vo.getStatus() == 4) {
                    statusName = unPassName;
                    score = String.valueOf(vo.getScore());
                } else if (vo.getStatus() == 5) {
                    statusName = waitRead;
                    score = "-";
                }
                row.createCell(15).setCellValue(score);
                row.createCell(16).setCellValue(statusName);
            }
            try {
                response.setContentType("application/vnd.ms-excel; charset=utf-8");
                response.setHeader("Content-Disposition", "attachment; filename=" + URLEncoder.encode(fileName, "UTF-8"));
                ServletOutputStream out = response.getOutputStream();
                wb.write((OutputStream)out);
                out.flush();
                out.close();
                wb.close();
            }
            catch (IOException e2) {
                log.error("", (Throwable)e2);
            }
        } else if (searchVo.getExportStatus() == 2) {
            List<PaperUserDetailVo> list = this.selectPaperUserDetailVo2(searchVo, user);
            ArrayList<Integer> userIdList = new ArrayList();
            if (!CollectionUtils.isEmpty(list)) {
                userIdList = list.stream().filter(e -> e.getIsVisitor() == 0).map(PaperUserDetailVo::getUserId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            }
            Map<Object, Object> roleMap = new HashMap();
            Map<Object, Object> parentMap = new HashMap();
            Map organMap1 = new HashMap();
            Map organMap2 = new HashMap();
            Map organMap3 = new HashMap();
            Map organMap4 = new HashMap();
            Map organMap5 = new HashMap();
            Map shopMap = new HashMap();
            Map shopDetailMap = new HashMap();
            if (!CollectionUtils.isEmpty(userIdList)) {
                roleMap = this.userUtilService.selectRolesByUsers(userIdList, groupId);
                parentMap = this.userUtilService.selectParentMap(userIdList, groupId);
                UsersAndOrgsMo mo = new UsersAndOrgsMo();
                mo.setGroupId(Integer.valueOf(groupId));
                mo.setLevelList(Collections.singletonList(1));
                mo.setUserIdList(userIdList);
                mo.setShowDepartment(Boolean.valueOf(false));
                BaseResult base1 = this.userOrganizeApi.getUserOrganizeLevelByUserIds(mo);
                if (base1 != null) {
                    organMap1 = (Map)base1.getData();
                }
                mo.setLevelList(Collections.singletonList(2));
                BaseResult base2 = this.userOrganizeApi.getUserOrganizeLevelByUserIds(mo);
                if (base2 != null) {
                    organMap2 = (Map)base2.getData();
                }
                mo.setLevelList(Collections.singletonList(3));
                BaseResult base3 = this.userOrganizeApi.getUserOrganizeLevelByUserIds(mo);
                if (base3 != null) {
                    organMap3 = (Map)base3.getData();
                }
                mo.setLevelList(Collections.singletonList(4));
                BaseResult base4 = this.userOrganizeApi.getUserOrganizeLevelByUserIds(mo);
                if (base4 != null) {
                    organMap4 = (Map)base4.getData();
                }
                mo.setLevelList(Collections.singletonList(5));
                BaseResult base5 = this.userOrganizeApi.getUserOrganizeLevelByUserIds(mo);
                if (base5 != null) {
                    organMap5 = (Map)base5.getData();
                }
                UsersAndOrgsMo mo1 = new UsersAndOrgsMo();
                mo1.setGroupId(Integer.valueOf(groupId));
                mo1.setUserIdList(userIdList);
                mo1.setShowDepartment(Boolean.valueOf(true));
                BaseResult base = this.userOrganizeApi.getUserOrganizeLevelByUserIds(mo1);
                if (base != null && base.getData() != null) {
                    shopMap = (Map)base.getData();
                }
                mo1.setShowAllPath(Boolean.valueOf(true));
                BaseResult bases = this.userOrganizeApi.getUserOrganizePathtByUserIds(mo1);
                if (bases != null && bases.getData() != null) {
                    shopDetailMap = (Map)bases.getData();
                }
            }
            String fileName = MessageFormat.format("{0}_{1}_{2}", trainingPaper.getTitle(), this.messageSource.getMessage("training.exam.student.detail", null, locale), DateUtils.format(new Date(), "yyyyMMdd"));
            fileName = ExcelUtil.getFileName(fileName) + ".xlsx";
            XSSFWorkbook wb = new XSSFWorkbook();
            XSSFSheet sheet = wb.createSheet(fileName);
            XSSFCellStyle titleSty = wb.createCellStyle();
            XSSFFont font = wb.createFont();
            font.setFontHeightInPoints((short)16);
            titleSty.setFont((Font)font);
            XSSFRow row = sheet.createRow(0);
            row.createCell(0).setCellValue("id");
            row.createCell(1).setCellValue(this.messageSource.getMessage("training.user.details.name", null, locale));
            row.createCell(2).setCellValue(this.messageSource.getMessage("training.user.details.employeeNumber", null, locale));
            row.createCell(3).setCellValue(this.messageSource.getMessage("training.course.analysis.role", null, locale));
            row.createCell(4).setCellValue(this.messageSource.getMessage("training.course.analysis.superior", null, locale));
            row.createCell(5).setCellValue(this.messageSource.getMessage("training.course.analysis.department", null, locale));
            row.createCell(6).setCellValue(this.messageSource.getMessage("training.course.analysis.first.organize", null, locale));
            row.createCell(7).setCellValue(this.messageSource.getMessage("training.course.analysis.second.organize", null, locale));
            row.createCell(8).setCellValue(this.messageSource.getMessage("training.course.analysis.third.organize", null, locale));
            row.createCell(9).setCellValue(this.messageSource.getMessage("training.course.analysis.fourth.organize", null, locale));
            row.createCell(10).setCellValue(this.messageSource.getMessage("training.course.analysis.fifth.organize", null, locale));
            row.createCell(11).setCellValue(this.messageSource.getMessage("training.course.analysis.dep", null, locale));
            row.createCell(12).setCellValue(this.messageSource.getMessage("training.paper.handtime", null, locale));
            row.createCell(13).setCellValue(this.messageSource.getMessage("training.operate.usetime", null, locale));
            row.createCell(14).setCellValue(this.messageSource.getMessage("training.paper.score", null, locale));
            row.createCell(15).setCellValue(this.messageSource.getMessage("training.paper.status", null, locale));
            for (int i = 0; i < list.size(); ++i) {
                List pojoList;
                List pojoList8;
                List pojoList9;
                List pojoList10;
                List pojoList11;
                List pojoList12;
                List pojoList13;
                row = sheet.createRow(i + 1);
                PaperUserDetailVo vo = list.get(i);
                row.createCell(0).setCellValue(String.valueOf(vo.getUserId()));
                row.createCell(1).setCellValue(vo.getUserName());
                row.createCell(2).setCellValue(vo.getUserNumber());
                String roleName = "";
                if (!org.springframework.util.StringUtils.isEmpty(roleMap) && !CollectionUtils.isEmpty((Collection)(pojoList13 = (List)roleMap.get(vo.getUserId())))) {
                    List listStr = pojoList13.stream().map(RolePojo::getRoleName).filter(Objects::nonNull).collect(Collectors.toList());
                    roleName = StringUtils.join(listStr, (String)",");
                }
                row.createCell(3).setCellValue(roleName);
                String parentName = "";
                if (!org.springframework.util.StringUtils.isEmpty(parentMap)) {
                    parentName = (String)parentMap.get(vo.getUserId());
                }
                row.createCell(4).setCellValue(parentName);
                String organName1 = "";
                if (!CollectionUtils.isEmpty(organMap1) && !CollectionUtils.isEmpty((Collection)(pojoList12 = (List)organMap1.get(vo.getUserId())))) {
                    pojoList12 = pojoList12.stream().distinct().collect(Collectors.toList());
                    organName1 = StringUtils.join(pojoList12, (String)",");
                }
                row.createCell(5).setCellValue(vo.getDeptName());
                row.createCell(6).setCellValue(organName1);
                String organName2 = "";
                if (!CollectionUtils.isEmpty(organMap2) && !CollectionUtils.isEmpty((Collection)(pojoList11 = (List)organMap2.get(vo.getUserId())))) {
                    pojoList11 = pojoList11.stream().distinct().collect(Collectors.toList());
                    organName2 = StringUtils.join(pojoList11, (String)",");
                }
                row.createCell(7).setCellValue(organName2);
                String organName3 = "";
                if (!CollectionUtils.isEmpty(organMap3) && !CollectionUtils.isEmpty((Collection)(pojoList10 = (List)organMap3.get(vo.getUserId())))) {
                    pojoList10 = pojoList10.stream().distinct().collect(Collectors.toList());
                    organName3 = StringUtils.join(pojoList10, (String)",");
                }
                row.createCell(8).setCellValue(organName3);
                String organName4 = "";
                if (!CollectionUtils.isEmpty(organMap4) && !CollectionUtils.isEmpty((Collection)(pojoList9 = (List)organMap4.get(vo.getUserId())))) {
                    pojoList9 = pojoList9.stream().distinct().collect(Collectors.toList());
                    organName4 = StringUtils.join(pojoList9, (String)",");
                }
                row.createCell(9).setCellValue(organName4);
                String organName5 = "";
                if (!CollectionUtils.isEmpty(organMap5) && !CollectionUtils.isEmpty((Collection)(pojoList8 = (List)organMap5.get(vo.getUserId())))) {
                    pojoList8 = pojoList8.stream().distinct().collect(Collectors.toList());
                    organName5 = StringUtils.join(pojoList8, (String)",");
                }
                row.createCell(10).setCellValue(organName5);
                String shopName = "";
                if (!org.springframework.util.StringUtils.isEmpty(shopMap) && !CollectionUtils.isEmpty((Collection)(pojoList = (List)shopMap.get(vo.getUserId())))) {
                    pojoList = pojoList.stream().distinct().collect(Collectors.toList());
                    shopName = StringUtils.join(pojoList, (String)",");
                }
                row.createCell(11).setCellValue(shopName);
                List shopDeatailPathList = (List)shopDetailMap.get(vo.getUserId());
                String shopPathName = "";
                if (!CollectionUtils.isEmpty((Collection)shopDeatailPathList) && (shopPathName = String.join((CharSequence)";", shopDeatailPathList)).length() > 1000) {
                    shopPathName = shopPathName.substring(0, 1000);
                }
                row.createCell(12).setCellValue(Objects.nonNull(vo.getFinishTime()) ? format.format(vo.getFinishTime()) : "");
                row.createCell(13).setCellValue(vo.getUseTime());
                String statusName = "";
                String score = "";
                if (vo.getStatus() == 1) {
                    String unexam;
                    statusName = unexam = this.messageSource.getMessage("training.paper.unexam", null, locale);
                    score = "-";
                } else if (vo.getStatus() == 2) {
                    statusName = this.messageSource.getMessage("training.paper.ing", null, locale);
                    score = "-";
                } else if (vo.getStatus() == 3) {
                    statusName = passName;
                    score = String.valueOf(vo.getScore());
                } else if (vo.getStatus() == 4) {
                    statusName = unPassName;
                    score = String.valueOf(vo.getScore());
                } else if (vo.getStatus() == 5) {
                    statusName = waitRead;
                    score = "-";
                }
                row.createCell(14).setCellValue(score);
                row.createCell(15).setCellValue(statusName);
            }
            try {
                response.setContentType("application/vnd.ms-excel; charset=utf-8");
                response.setHeader("Content-Disposition", "attachment; filename=" + URLEncoder.encode(fileName, "UTF-8"));
                ServletOutputStream out = response.getOutputStream();
                wb.write((OutputStream)out);
                out.flush();
                out.close();
                wb.close();
            }
            catch (IOException e3) {
                log.error(e3.getMessage());
            }
        }
    }

    private List<PaperUserDetailVo> selectPaperUserDetailVo(PaperUserDetailSearchVo searchVo, Users user) {
        TrainingExam trainingExam;
        TrainingPaper trainingPaper = (TrainingPaper)this.trainingPaperMapper.selectById(Integer.valueOf(searchVo.getPaperId()));
        BigDecimal org_score = new BigDecimal("100");
        if (trainingPaper.getExamId() != null && !ObjectUtils.isEmpty((Object)(trainingExam = (TrainingExam)this.trainingExamMapper.selectById(trainingPaper.getExamId())))) {
            org_score = trainingExam.getScore();
        }
        int groupId = trainingPaper.getEnterpriseId();
        List<Object> userIds = new ArrayList();
        if (searchVo.getUserPaperType() == null || searchVo.getUserPaperType() == 0) {
            userIds = this.getPaperUserIdList(trainingPaper, user.getId());
        }
        Users users = new Users();
        users.setGroupId(Integer.valueOf(groupId));
        if (!org.springframework.util.StringUtils.isEmpty((Object)searchVo.getUserName())) {
            List userNames = (List)this.userUtilService.getCheckParameters(searchVo.getUserName(), null, null, users).get("userList");
            userIds.retainAll(userNames);
        }
        ArrayList dataList = new ArrayList();
        ArrayList<PaperUserDetailVo> noStart = new ArrayList<PaperUserDetailVo>();
        ArrayList<PaperUserDetailVo> starting = new ArrayList<PaperUserDetailVo>();
        ArrayList<PaperUserDetailVo> userFinish = new ArrayList<PaperUserDetailVo>();
        ArrayList<PaperUserDetailVo> userWait = new ArrayList<PaperUserDetailVo>();
        if (!CollectionUtils.isEmpty(userIds)) {
            List<String> userStr;
            UsersPojo usersPojo;
            PaperUserDetailVo vo;
            List<Integer> userIdList = userIds.stream().distinct().collect(Collectors.toList());
            List userIdList2 = userIds.stream().distinct().collect(Collectors.toList());
            LambdaQueryWrapper queryWrapper2 = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper2.eq(TrainingUserPaper::getTrainingPaperId, (Object)searchVo.getPaperId())).in(TrainingUserPaper::getUserId, userIdList)).and(wq -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wq.isNull(TrainingUserPaper::getSourceType)).or()).eq(TrainingUserPaper::getSourceType, (Object)2);
            })).isNotNull(TrainingUserPaper::getUpdateTime);
            List trainingUserPapers = this.trainingUserPaperMapper.selectList((Wrapper)queryWrapper2);
            List userStudyList = trainingUserPapers.stream().map(TrainingUserPaper::getUserId).distinct().collect(Collectors.toList());
            Map<Integer, List<TrainingUserPaper>> trainingUserPaperMap = trainingUserPapers.stream().collect(Collectors.groupingBy(TrainingUserPaper::getUserId));
            userIdList2.removeAll(userStudyList);
            Map<Integer, List<String>> userOrganizeMap = this.userUtilService.selectOrganizeMap(userIdList, groupId);
            Map<Integer, UsersPojo> usersPojoMap = this.userUtilService.selectUserMap(userIds);
            ArrayList<Integer> userWaitList = new ArrayList<Integer>();
            ArrayList<Integer> userFinishList = new ArrayList<Integer>();
            Iterator iterator = userIdList2.iterator();
            while (iterator.hasNext()) {
                int userId = (Integer)iterator.next();
                PaperUserDetailVo vo2 = new PaperUserDetailVo();
                vo2.setUserId(userId);
                vo2.setIsVisitor(Integer.valueOf(0));
                UsersPojo usersPojo2 = usersPojoMap.get(userId);
                vo2.setUserName(usersPojo2.getShowName());
                vo2.setUserNumber(usersPojo2.getEmployeeNumber());
                List<String> userStr2 = userOrganizeMap.get(vo2.getUserId());
                vo2.setDeptName(CollectionUtils.isEmpty(userStr2) ? "" : userStr2.get(0));
                vo2.setStartTime(null);
                vo2.setFinishTime(null);
                vo2.setPaperCount(-1);
                vo2.setScore(new BigDecimal(-3));
                vo2.setStatus(1);
                noStart.add(vo2);
            }
            dataList.addAll(noStart);
            ArrayList<Integer> userStarting = new ArrayList<Integer>();
            Iterator<Object> iterator2 = userStudyList.iterator();
            while (iterator2.hasNext()) {
                int userId = (Integer)iterator2.next();
                List<TrainingUserPaper> trainingPaperList = trainingUserPaperMap.get(userId);
                List userPaperList = trainingPaperList.stream().sorted(Comparator.comparing(TrainingUserPaper::getId).reversed()).collect(Collectors.toList());
                if (CollectionUtils.isEmpty(userPaperList)) continue;
                TrainingUserPaper temp = trainingPaperList.get(0);
                for (TrainingUserPaper userPaper : trainingPaperList) {
                    if (userPaper.getPaperStatus() == 1) continue;
                    if (Objects.isNull(trainingPaper.getScoreSelect()) || trainingPaper.getScoreSelect() == 1) {
                        if (temp.getPaperStatus() != 1 && !userPaper.getUpdateTime().after(temp.getUpdateTime())) continue;
                        temp = userPaper;
                        continue;
                    }
                    if (temp.getPaperStatus() != 1 && userPaper.getScore().compareTo(temp.getScore()) <= 0) continue;
                    temp = userPaper;
                }
                if (Objects.nonNull(temp.getUpdateTime()) && temp.getPaperStatus() == 0) {
                    userStarting.add(userId);
                    continue;
                }
                if (Objects.nonNull(temp.getUpdateTime()) && temp.getPaperStatus() == 1) {
                    userWaitList.add(userId);
                    continue;
                }
                userFinishList.add(userId);
            }
            iterator2 = userStarting.iterator();
            while (iterator2.hasNext()) {
                int userId = (Integer)iterator2.next();
                vo = new PaperUserDetailVo();
                vo.setUserId(userId);
                vo.setIsVisitor(Integer.valueOf(0));
                usersPojo = usersPojoMap.get(userId);
                vo.setUserName(usersPojo.getShowName());
                vo.setUserNumber(usersPojo.getEmployeeNumber());
                userStr = userOrganizeMap.get(vo.getUserId());
                vo.setDeptName(CollectionUtils.isEmpty(userStr) ? "" : userStr.get(0));
                vo.setStartTime(null);
                vo.setFinishTime(null);
                vo.setPaperCount(-1);
                vo.setScore(new BigDecimal(-2));
                vo.setStatus(2);
                starting.add(vo);
            }
            dataList.addAll(starting);
            iterator2 = userWaitList.iterator();
            while (iterator2.hasNext()) {
                int userId = (Integer)iterator2.next();
                vo = new PaperUserDetailVo();
                vo.setUserId(userId);
                vo.setIsVisitor(Integer.valueOf(0));
                usersPojo = usersPojoMap.get(userId);
                vo.setUserName(usersPojo.getShowName());
                vo.setUserNumber(usersPojo.getEmployeeNumber());
                userStr = userOrganizeMap.get(vo.getUserId());
                vo.setDeptName(CollectionUtils.isEmpty(userStr) ? "" : userStr.get(0));
                List<TrainingUserPaper> list = trainingUserPaperMap.get(userId);
                vo.setStartTime(trainingUserPaperMap.get(userId).get(0).getUpdateTime());
                vo.setFinishTime(trainingUserPaperMap.get(userId).get(0).getSubmitTime());
                vo.setUseTime(this.averageTime(list));
                vo.setUserSecond(this.averageTime2(list));
                vo.setPaperCount(list.size());
                vo.setStatus(5);
                vo.setScore(new BigDecimal(-1));
                userWait.add(vo);
            }
            dataList.addAll(userWait);
            iterator2 = userFinishList.iterator();
            while (iterator2.hasNext()) {
                int userId = (Integer)iterator2.next();
                vo = new PaperUserDetailVo();
                usersPojo = usersPojoMap.get(userId);
                vo.setUserId(userId);
                vo.setIsVisitor(Integer.valueOf(0));
                vo.setUserNumber(usersPojo.getEmployeeNumber());
                vo.setUserName(usersPojo.getShowName());
                userStr = userOrganizeMap.get(vo.getUserId());
                vo.setDeptName(CollectionUtils.isEmpty(userStr) ? "" : userStr.get(0));
                int passLine = trainingPaper.getPassLine();
                List<TrainingUserPaper> trainingPaperList = trainingUserPaperMap.get(userId);
                List userPaperList = trainingPaperList.stream().sorted(Comparator.comparing(TrainingUserPaper::getId).reversed()).collect(Collectors.toList());
                vo.setPaperCount(userPaperList.size());
                vo.setUseTime(this.averageTime(trainingPaperList));
                vo.setUserSecond(this.averageTime2(trainingPaperList));
                if (!CollectionUtils.isEmpty(userPaperList)) {
                    BigDecimal score;
                    TrainingUserPaper temp = (TrainingUserPaper)userPaperList.get(0);
                    for (TrainingUserPaper userPaper : userPaperList) {
                        if (userPaper.getPaperStatus() == 1) continue;
                        if (Objects.isNull(trainingPaper.getScoreSelect()) || trainingPaper.getScoreSelect() == 1) {
                            if (temp.getPaperStatus() != 1 && !userPaper.getCreateTime().after(temp.getCreateTime())) continue;
                            temp = userPaper;
                            continue;
                        }
                        if (trainingPaper.getScoreSelect() == 0) {
                            if (temp.getPaperStatus() != 1 && userPaper.getScore().intValue() <= temp.getScore().intValue()) continue;
                            temp = userPaper;
                            continue;
                        }
                        if (trainingPaper.getScoreSelect() != 2 || temp.getPaperStatus() != 1 && !userPaper.getCreateTime().before(temp.getCreateTime())) continue;
                        temp = userPaper;
                    }
                    if (Objects.isNull(trainingPaper.getScoreSelect()) || trainingPaper.getScoreSelect() == 1) {
                        score = temp.getScore();
                        int status = this.isPass(org_score, score, passLine);
                        vo.setStartTime(temp.getUpdateTime());
                        vo.setFinishTime(temp.getSubmitTime());
                        vo.setStatus(status);
                        vo.setScore(score);
                    } else if (Objects.nonNull(trainingPaper.getScoreSelect()) && trainingPaper.getScoreSelect() == 2) {
                        score = temp.getScore();
                        int status = this.isPass(org_score, score, passLine);
                        vo.setStartTime(temp.getUpdateTime());
                        vo.setFinishTime(temp.getSubmitTime());
                        vo.setStatus(status);
                        vo.setScore(score);
                    } else if (Objects.nonNull(trainingPaper.getScoreSelect()) && trainingPaper.getScoreSelect() == 0) {
                        score = temp.getScore();
                        int status = this.isPass(org_score, score, passLine);
                        vo.setStartTime(temp.getUpdateTime());
                        vo.setFinishTime(temp.getSubmitTime());
                        vo.setStatus(status);
                        vo.setScore(score);
                    }
                }
                userFinish.add(vo);
            }
            dataList.addAll(userFinish);
        }
        List<Object> result = new ArrayList();
        List<Object> dataList2 = new ArrayList();
        if (searchVo.getStatus() == 0) {
            dataList2 = searchVo.getOrderBy() != 0 ? (searchVo.getOrderBy() == 1 ? (searchVo.getOrder() == 1 ? dataList.stream().sorted(Comparator.comparing(PaperUserDetailVo::getFinishTime, Comparator.nullsFirst(Date::compareTo))).collect(Collectors.toList()) : dataList.stream().sorted(Comparator.comparing(PaperUserDetailVo::getFinishTime, Comparator.nullsFirst(Date::compareTo)).reversed()).collect(Collectors.toList())) : (searchVo.getOrderBy() == 2 ? (searchVo.getOrder() == 1 ? dataList.stream().sorted(Comparator.comparing(PaperUserDetailVo::getPaperCount)).collect(Collectors.toList()) : dataList.stream().sorted(Comparator.comparing(PaperUserDetailVo::getPaperCount).reversed()).collect(Collectors.toList())) : (searchVo.getOrderBy() == 3 ? (searchVo.getOrder() == 1 ? dataList.stream().sorted(Comparator.comparing(PaperUserDetailVo::getUserSecond)).collect(Collectors.toList()) : dataList.stream().sorted(Comparator.comparing(PaperUserDetailVo::getUserSecond).reversed()).collect(Collectors.toList())) : (searchVo.getOrder() == 1 ? dataList.stream().sorted(Comparator.comparing(PaperUserDetailVo::getScore)).collect(Collectors.toList()) : dataList.stream().sorted(Comparator.comparing(PaperUserDetailVo::getScore).reversed()).collect(Collectors.toList()))))) : dataList.stream().sorted(Comparator.comparing(PaperUserDetailVo::getScore).reversed()).collect(Collectors.toList());
        } else {
            result = dataList.stream().filter(e -> e.getStatus() == searchVo.getStatus()).collect(Collectors.toList());
            if (searchVo.getOrderBy() != 0) {
                if (searchVo.getOrderBy() == 1) {
                    dataList2 = searchVo.getOrder() == 1 ? result.stream().sorted(Comparator.comparing(PaperUserDetailVo::getFinishTime, Comparator.nullsFirst(Date::compareTo))).collect(Collectors.toList()) : result.stream().sorted(Comparator.comparing(PaperUserDetailVo::getFinishTime, Comparator.nullsFirst(Date::compareTo)).reversed()).collect(Collectors.toList());
                } else if (searchVo.getOrderBy() == 2) {
                    dataList2 = searchVo.getOrder() == 1 ? result.stream().sorted(Comparator.comparing(PaperUserDetailVo::getPaperCount)).collect(Collectors.toList()) : result.stream().sorted(Comparator.comparing(PaperUserDetailVo::getPaperCount).reversed()).collect(Collectors.toList());
                } else if (searchVo.getOrderBy() == 3) {
                    dataList2 = searchVo.getOrder() == 1 ? result.stream().sorted(Comparator.comparing(PaperUserDetailVo::getUserSecond)).collect(Collectors.toList()) : result.stream().sorted(Comparator.comparing(PaperUserDetailVo::getUserSecond).reversed()).collect(Collectors.toList());
                } else if (searchVo.getOrderBy() == 4) {
                    dataList2 = searchVo.getOrder() == 1 ? result.stream().sorted(Comparator.comparing(PaperUserDetailVo::getScore)).collect(Collectors.toList()) : result.stream().sorted(Comparator.comparing(PaperUserDetailVo::getScore).reversed()).collect(Collectors.toList());
                }
            } else {
                dataList2 = result.stream().sorted(Comparator.comparing(PaperUserDetailVo::getScore).reversed()).collect(Collectors.toList());
            }
        }
        return dataList2;
    }

    @Override
    public List<PaperUserDetailVo> selectPaperUserDetailsByList2(PaperDetailExcelVo excelVo) {
        TrainingExam trainingExam;
        Users user = excelVo.getUsers();
        PaperUserDetailSearchVo searchVo = new PaperUserDetailSearchVo();
        BeanUtils.copyProperties((Object)excelVo, (Object)searchVo);
        ArrayList<PaperUserDetailVo> dataList = new ArrayList<PaperUserDetailVo>();
        TrainingPaper trainingPaper = (TrainingPaper)this.trainingPaperMapper.selectById(Integer.valueOf(searchVo.getPaperId()));
        List<Object> userIds = new ArrayList();
        if (searchVo.getUserPaperType() == null || searchVo.getUserPaperType() == 0) {
            userIds = this.getPaperUserIdList(trainingPaper, user.getId());
        }
        if (user.getGroupId() == null) {
            user.setGroupId(trainingPaper.getEnterpriseId());
        }
        if (!org.springframework.util.StringUtils.isEmpty((Object)searchVo.getUserName())) {
            List userIdList = (List)this.userUtilService.getCheckParameters(searchVo.getUserName(), null, null, user).get("userList");
            userIds.retainAll(userIdList);
        }
        List<TrainingUserPaper> trainingUserPaperList = this.getVisitorPapers(searchVo);
        if (CollectionUtils.isEmpty(userIds) && CollectionUtils.isEmpty(trainingUserPaperList)) {
            return dataList;
        }
        BigDecimal org_score = new BigDecimal("100");
        if (trainingPaper.getExamId() != null && !ObjectUtils.isEmpty((Object)(trainingExam = (TrainingExam)this.trainingExamMapper.selectById(trainingPaper.getExamId())))) {
            org_score = trainingExam.getScore();
        }
        int groupId = trainingPaper.getEnterpriseId();
        if (!CollectionUtils.isEmpty(userIds)) {
            List userStudyList;
            ArrayList noStart = new ArrayList();
            ArrayList userFinish = new ArrayList();
            List<Integer> userIdList = userIds.stream().distinct().collect(Collectors.toList());
            List unUserIds = userIds.stream().distinct().collect(Collectors.toList());
            Map<Integer, List<String>> userOrganizeMap = this.userUtilService.selectOrganizeMap(userIdList, groupId);
            Map<Integer, UsersPojo> usersPojoMap = this.userUtilService.selectUserMap(userIdList);
            Map<Integer, UserDutiesMo> dutiesMap = this.userUtilService.selectDutiesMap(userIdList, groupId);
            LambdaQueryWrapper queryWrapper2 = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper2.eq(TrainingUserPaper::getTrainingPaperId, (Object)searchVo.getPaperId())).in(TrainingUserPaper::getUserId, userIdList)).and(wq -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wq.isNull(TrainingUserPaper::getSourceType)).or()).eq(TrainingUserPaper::getSourceType, (Object)2);
            })).isNotNull(TrainingUserPaper::getUpdateTime);
            List trainingUserPapers = this.trainingUserPaperMapper.selectList((Wrapper)queryWrapper2);
            if (!CollectionUtils.isEmpty((Collection)trainingUserPapers) && !CollectionUtils.isEmpty(userStudyList = trainingUserPapers.stream().map(TrainingUserPaper::getUserId).distinct().collect(Collectors.toList()))) {
                for (TrainingUserPaper paper : trainingUserPapers) {
                    PaperUserDetailVo vo = new PaperUserDetailVo();
                    vo.setUserId(paper.getUserId().intValue());
                    vo.setIsVisitor(Integer.valueOf(0));
                    UsersPojo usersPojo = usersPojoMap.get(paper.getUserId());
                    vo.setUserName(usersPojo.getShowName());
                    vo.setUserAccount(usersPojo.getUserName());
                    vo.setUserNumber(usersPojo.getEmployeeNumber());
                    List<String> userStr = userOrganizeMap.get(vo.getUserId());
                    String departName = "";
                    if (!CollectionUtils.isEmpty(userStr)) {
                        departName = String.join((CharSequence)";\n", userStr);
                    }
                    vo.setDeptName(departName);
                    if (!ObjectUtils.isEmpty(dutiesMap) && dutiesMap.get(vo.getUserId()) != null) {
                        vo.setPost(dutiesMap.get(vo.getUserId()).getDutieName());
                    }
                    vo.setStartTime(paper.getUpdateTime());
                    vo.setFinishTime(paper.getSubmitTime());
                    vo.setPaperCount(1);
                    vo.setUseTime(this.averageTime(Collections.singletonList(paper)));
                    vo.setUserSecond(this.averageTime2(Collections.singletonList(paper)));
                    if (Objects.nonNull(paper.getUpdateTime()) && paper.getPaperStatus() == 0) {
                        vo.setStatus(2);
                        vo.setScore(new BigDecimal(-2));
                    } else if (Objects.nonNull(paper.getSubmitTime()) && paper.getPaperStatus() == 1) {
                        vo.setStatus(5);
                        vo.setScore(new BigDecimal(-1));
                    } else {
                        vo.setStatus(this.isPass(org_score, paper.getScore(), trainingPaper.getPassLine()));
                        vo.setScore(paper.getScore());
                    }
                    dataList.add(vo);
                }
                unUserIds.removeAll(userStudyList);
            }
            if (!CollectionUtils.isEmpty(unUserIds)) {
                Iterator iterator = unUserIds.iterator();
                while (iterator.hasNext()) {
                    int userId = (Integer)iterator.next();
                    PaperUserDetailVo vo = new PaperUserDetailVo();
                    vo.setUserId(userId);
                    vo.setIsVisitor(Integer.valueOf(0));
                    UsersPojo usersPojo = usersPojoMap.get(userId);
                    vo.setUserName(usersPojo.getShowName());
                    vo.setUserAccount(usersPojo.getUserName());
                    vo.setUserNumber(usersPojo.getEmployeeNumber());
                    List<String> userStr = userOrganizeMap.get(vo.getUserId());
                    vo.setDeptName(CollectionUtils.isEmpty(userStr) ? "" : String.join((CharSequence)";\n", userStr));
                    if (!ObjectUtils.isEmpty(dutiesMap) && dutiesMap.get(vo.getUserId()) != null) {
                        vo.setPost(dutiesMap.get(vo.getUserId()).getDutieName());
                    }
                    vo.setStartTime(null);
                    vo.setFinishTime(null);
                    vo.setPaperCount(-1);
                    vo.setUseTime("");
                    vo.setUserSecond(0);
                    vo.setScore(new BigDecimal(-3));
                    vo.setStatus(1);
                    dataList.add(vo);
                }
            }
        }
        if (!CollectionUtils.isEmpty(trainingUserPaperList)) {
            List<PaperUserDetailVo> visitorPaperList = this.getAllVisitorPaperList(trainingUserPaperList, trainingPaper, org_score);
            dataList.addAll(visitorPaperList);
        }
        List<Object> result = new ArrayList();
        List<Object> dataList2 = new ArrayList();
        if (searchVo.getStatus() == 0) {
            dataList2 = searchVo.getOrderBy() != 0 ? (searchVo.getOrderBy() == 1 ? (searchVo.getOrder() == 1 ? dataList.stream().sorted(Comparator.comparing(PaperUserDetailVo::getFinishTime, Comparator.nullsFirst(Date::compareTo))).collect(Collectors.toList()) : dataList.stream().sorted(Comparator.comparing(PaperUserDetailVo::getFinishTime, Comparator.nullsFirst(Date::compareTo)).reversed()).collect(Collectors.toList())) : (searchVo.getOrderBy() == 2 ? (searchVo.getOrder() == 1 ? dataList.stream().sorted(Comparator.comparing(PaperUserDetailVo::getPaperCount)).collect(Collectors.toList()) : dataList.stream().sorted(Comparator.comparing(PaperUserDetailVo::getPaperCount).reversed()).collect(Collectors.toList())) : (searchVo.getOrderBy() == 3 ? (searchVo.getOrder() == 1 ? dataList.stream().sorted(Comparator.comparing(PaperUserDetailVo::getUserSecond)).collect(Collectors.toList()) : dataList.stream().sorted(Comparator.comparing(PaperUserDetailVo::getUserSecond).reversed()).collect(Collectors.toList())) : (searchVo.getOrder() == 1 ? dataList.stream().sorted(Comparator.comparing(PaperUserDetailVo::getScore)).collect(Collectors.toList()) : dataList.stream().sorted(Comparator.comparing(PaperUserDetailVo::getScore).reversed()).collect(Collectors.toList()))))) : dataList;
        } else {
            List userIdByStatus = dataList.stream().filter(e -> e.getStatus() == searchVo.getStatus()).map(PaperUserDetailVo::getUserId).collect(Collectors.toList());
            result = dataList.stream().filter(e -> userIdByStatus.contains(e.getUserId())).collect(Collectors.toList());
            if (searchVo.getOrderBy() != 0) {
                if (searchVo.getOrderBy() == 1) {
                    dataList2 = searchVo.getOrder() == 1 ? result.stream().sorted(Comparator.comparing(PaperUserDetailVo::getFinishTime, Comparator.nullsFirst(Date::compareTo))).collect(Collectors.toList()) : result.stream().sorted(Comparator.comparing(PaperUserDetailVo::getFinishTime, Comparator.nullsFirst(Date::compareTo)).reversed()).collect(Collectors.toList());
                } else if (searchVo.getOrderBy() == 2) {
                    dataList2 = searchVo.getOrder() == 1 ? result.stream().sorted(Comparator.comparing(PaperUserDetailVo::getPaperCount)).collect(Collectors.toList()) : result.stream().sorted(Comparator.comparing(PaperUserDetailVo::getPaperCount).reversed()).collect(Collectors.toList());
                } else if (searchVo.getOrderBy() == 3) {
                    dataList2 = searchVo.getOrder() == 1 ? result.stream().sorted(Comparator.comparing(PaperUserDetailVo::getUserSecond)).collect(Collectors.toList()) : result.stream().sorted(Comparator.comparing(PaperUserDetailVo::getUserSecond).reversed()).collect(Collectors.toList());
                } else if (searchVo.getOrderBy() == 4) {
                    dataList2 = searchVo.getOrder() == 1 ? result.stream().sorted(Comparator.comparing(PaperUserDetailVo::getScore)).collect(Collectors.toList()) : result.stream().sorted(Comparator.comparing(PaperUserDetailVo::getScore).reversed()).collect(Collectors.toList());
                }
            } else {
                dataList2 = result;
            }
        }
        return dataList2;
    }

    private List<PaperUserDetailVo> selectPaperUserDetailVo2(PaperUserDetailSearchVo searchVo, Users user) {
        TrainingExam trainingExam;
        ArrayList<PaperUserDetailVo> dataList = new ArrayList<PaperUserDetailVo>();
        TrainingPaper trainingPaper = (TrainingPaper)this.trainingPaperMapper.selectById(Integer.valueOf(searchVo.getPaperId()));
        List<Object> userIds = new ArrayList();
        if (searchVo.getUserPaperType() == null || searchVo.getUserPaperType() == 0) {
            userIds = this.getPaperUserIdList(trainingPaper, user.getId());
        }
        if (user.getGroupId() == null) {
            user.setGroupId(trainingPaper.getEnterpriseId());
        }
        if (!org.springframework.util.StringUtils.isEmpty((Object)searchVo.getUserName())) {
            List userIdList = (List)this.userUtilService.getCheckParameters(searchVo.getUserName(), null, null, user).get("userList");
            userIds.retainAll(userIdList);
        }
        List<TrainingUserPaper> trainingUserPaperList = this.getVisitorPapers(searchVo);
        if (CollectionUtils.isEmpty(userIds) && CollectionUtils.isEmpty(trainingUserPaperList)) {
            return dataList;
        }
        BigDecimal org_score = new BigDecimal("100");
        if (trainingPaper.getExamId() != null && !ObjectUtils.isEmpty((Object)(trainingExam = (TrainingExam)this.trainingExamMapper.selectById(trainingPaper.getExamId())))) {
            org_score = trainingExam.getScore();
        }
        int groupId = trainingPaper.getEnterpriseId();
        if (!CollectionUtils.isEmpty(userIds)) {
            List userStudyList;
            ArrayList noStart = new ArrayList();
            ArrayList userFinish = new ArrayList();
            List<Integer> userIdList = userIds.stream().distinct().collect(Collectors.toList());
            List unUserIds = userIds.stream().distinct().collect(Collectors.toList());
            Map<Integer, List<String>> userOrganizeMap = this.userUtilService.selectOrganizeMap(userIdList, groupId);
            Map<Integer, UsersPojo> usersPojoMap = this.userUtilService.selectUserMap(userIdList);
            LambdaQueryWrapper queryWrapper2 = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper2.eq(TrainingUserPaper::getTrainingPaperId, (Object)searchVo.getPaperId())).in(TrainingUserPaper::getUserId, userIdList)).and(wq -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wq.isNull(TrainingUserPaper::getSourceType)).or()).eq(TrainingUserPaper::getSourceType, (Object)2);
            })).isNotNull(TrainingUserPaper::getUpdateTime);
            List trainingUserPapers = this.trainingUserPaperMapper.selectList((Wrapper)queryWrapper2);
            if (!CollectionUtils.isEmpty((Collection)trainingUserPapers) && !CollectionUtils.isEmpty(userStudyList = trainingUserPapers.stream().map(TrainingUserPaper::getUserId).distinct().collect(Collectors.toList()))) {
                for (TrainingUserPaper paper : trainingUserPapers) {
                    PaperUserDetailVo vo = new PaperUserDetailVo();
                    vo.setUserId(paper.getUserId().intValue());
                    vo.setIsVisitor(Integer.valueOf(0));
                    UsersPojo usersPojo = usersPojoMap.get(paper.getUserId());
                    vo.setUserName(usersPojo.getShowName());
                    vo.setUserNumber(usersPojo.getEmployeeNumber());
                    List<String> userStr = userOrganizeMap.get(vo.getUserId());
                    String departName = "";
                    if (!CollectionUtils.isEmpty(userStr)) {
                        departName = String.join((CharSequence)";\n", userStr);
                    }
                    vo.setDeptName(departName);
                    vo.setStartTime(paper.getUpdateTime());
                    vo.setFinishTime(paper.getSubmitTime());
                    vo.setPaperCount(1);
                    vo.setUseTime(this.averageTime(Collections.singletonList(paper)));
                    vo.setUserSecond(this.averageTime2(Collections.singletonList(paper)));
                    if (Objects.nonNull(paper.getUpdateTime()) && paper.getPaperStatus() == 0) {
                        vo.setStatus(2);
                        vo.setScore(new BigDecimal(-2));
                    } else if (Objects.nonNull(paper.getSubmitTime()) && paper.getPaperStatus() == 1) {
                        vo.setStatus(5);
                        vo.setScore(new BigDecimal(-1));
                    } else {
                        vo.setStatus(this.isPass(org_score, paper.getScore(), trainingPaper.getPassLine()));
                        vo.setScore(paper.getScore());
                    }
                    dataList.add(vo);
                }
                unUserIds.removeAll(userStudyList);
            }
            if (!CollectionUtils.isEmpty(unUserIds)) {
                Iterator iterator = unUserIds.iterator();
                while (iterator.hasNext()) {
                    int userId = (Integer)iterator.next();
                    PaperUserDetailVo vo = new PaperUserDetailVo();
                    vo.setUserId(userId);
                    vo.setIsVisitor(Integer.valueOf(0));
                    UsersPojo usersPojo = usersPojoMap.get(userId);
                    vo.setUserName(usersPojo.getShowName());
                    vo.setUserNumber(usersPojo.getEmployeeNumber());
                    List<String> userStr = userOrganizeMap.get(vo.getUserId());
                    vo.setDeptName(CollectionUtils.isEmpty(userStr) ? "" : userStr.get(0));
                    vo.setStartTime(null);
                    vo.setFinishTime(null);
                    vo.setPaperCount(-1);
                    vo.setUseTime("");
                    vo.setUserSecond(0);
                    vo.setScore(new BigDecimal(-3));
                    vo.setStatus(1);
                    dataList.add(vo);
                }
            }
        }
        if (!CollectionUtils.isEmpty(trainingUserPaperList)) {
            List<PaperUserDetailVo> visitorPaperList = this.getAllVisitorPaperList(trainingUserPaperList, trainingPaper, org_score);
            dataList.addAll(visitorPaperList);
        }
        List<Object> dataList2 = new ArrayList();
        dataList2 = searchVo.getOrderBy() != 0 ? (searchVo.getOrderBy() == 1 ? (searchVo.getOrder() == 1 ? dataList.stream().sorted(Comparator.comparing(PaperUserDetailVo::getFinishTime, Comparator.nullsFirst(Date::compareTo))).collect(Collectors.toList()) : dataList.stream().sorted(Comparator.comparing(PaperUserDetailVo::getFinishTime, Comparator.nullsFirst(Date::compareTo)).reversed()).collect(Collectors.toList())) : (searchVo.getOrderBy() == 2 ? (searchVo.getOrder() == 1 ? dataList.stream().sorted(Comparator.comparing(PaperUserDetailVo::getPaperCount)).collect(Collectors.toList()) : dataList.stream().sorted(Comparator.comparing(PaperUserDetailVo::getPaperCount).reversed()).collect(Collectors.toList())) : (searchVo.getOrderBy() == 3 ? (searchVo.getOrder() == 1 ? dataList.stream().sorted(Comparator.comparing(PaperUserDetailVo::getUserSecond)).collect(Collectors.toList()) : dataList.stream().sorted(Comparator.comparing(PaperUserDetailVo::getUserSecond).reversed()).collect(Collectors.toList())) : (searchVo.getOrder() == 1 ? dataList.stream().sorted(Comparator.comparing(PaperUserDetailVo::getScore)).collect(Collectors.toList()) : dataList.stream().sorted(Comparator.comparing(PaperUserDetailVo::getScore).reversed()).collect(Collectors.toList()))))) : dataList.stream().sorted(Comparator.comparing(PaperUserDetailVo::getScore).reversed()).collect(Collectors.toList());
        return dataList2;
    }

    private int isPass(BigDecimal org_score, BigDecimal score, int passLine) {
        BigDecimal percent = new BigDecimal(passLine).divide(new BigDecimal(100));
        BigDecimal result = org_score.multiply(percent);
        if (score.compareTo(result) >= 0) {
            return 3;
        }
        return 4;
    }

    private String computeProportion(int count, int total) {
        BigDecimal percentage = BigDecimal.ZERO;
        if (total < count) {
            return String.valueOf(new BigDecimal(100)).concat("%");
        }
        if (total != 0) {
            percentage = BigDecimal.valueOf(count).divide(BigDecimal.valueOf(total), 4, RoundingMode.HALF_UP).multiply(new BigDecimal(100));
        }
        return String.valueOf(percentage.setScale(2, RoundingMode.HALF_UP)).concat("%");
    }

    private String computeProportion2(int count, int total) {
        if (total == 0) {
            return "-";
        }
        if (total < count) {
            return String.valueOf(new BigDecimal(100)).concat("%");
        }
        BigDecimal percentage = BigDecimal.valueOf(count).divide(BigDecimal.valueOf(total), 4, RoundingMode.HALF_UP).multiply(new BigDecimal(100));
        return String.valueOf(percentage.setScale(2, RoundingMode.HALF_UP)).concat("%");
    }

    private BigDecimal computeProportion3(int count, int total) {
        if (total == 0) {
            return new BigDecimal(-1);
        }
        if (total < count) {
            return new BigDecimal(100);
        }
        BigDecimal percentage = BigDecimal.valueOf(count).divide(BigDecimal.valueOf(total), 4, RoundingMode.HALF_UP).multiply(new BigDecimal(100));
        return percentage.setScale(2, RoundingMode.HALF_UP);
    }

    @Override
    public void updateUsersByClose(Integer paperId, Integer userId, Integer groupId) {
        LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
        wrapper1.eq(TrainingPaperUser::getPaperId, (Object)paperId);
        List paperUserList = this.trainingPaperUserMapper.selectList((Wrapper)wrapper1);
        if (!CollectionUtils.isEmpty((Collection)paperUserList)) {
            List orgIds;
            List tagIds;
            List userIdList = paperUserList.stream().map(TrainingPaperUser::getUserId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            List<Integer> roleList = paperUserList.stream().map(TrainingPaperUser::getRoleId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            List<Integer> pojoList = this.userUtilService.selectUsersByRoles(roleList, groupId);
            if (!CollectionUtils.isEmpty(pojoList)) {
                pojoList.removeAll(userIdList);
                userIdList.addAll(pojoList);
                ArrayList<TrainingPaperUser> paperUsers = new ArrayList<TrainingPaperUser>();
                for (Integer pojoId : pojoList) {
                    TrainingPaperUser paperUser = new TrainingPaperUser();
                    paperUser.setPaperId(paperId);
                    paperUser.setUserId(pojoId);
                    paperUser.setEnterpriseId(groupId);
                    paperUsers.add(paperUser);
                }
                this.trainingPaperUserMapper.insertList(paperUsers);
            }
            if (!CollectionUtils.isEmpty(tagIds = paperUserList.stream().map(TrainingPaperUser::getTagId).filter(Objects::nonNull).distinct().collect(Collectors.toList()))) {
                DepAndTagsPojo pojo = new DepAndTagsPojo();
                pojo.setGroupId(groupId);
                pojo.setTagIds(tagIds);
                pojo.setUserId(userId);
                BaseResult tagResult = this.tagApi.getUsersByTags(pojo);
                if (!tagResult.getIsError().booleanValue() && !CollectionUtils.isEmpty((Collection)((Collection)tagResult.getData()))) {
                    ArrayList<TrainingPaperUser> paperUsers = new ArrayList<TrainingPaperUser>();
                    for (Map map : (List)tagResult.getData()) {
                        Integer id = (Integer)map.get("id");
                        if (userIdList.contains(id)) continue;
                        userIdList.add(id);
                        TrainingPaperUser paperUser = new TrainingPaperUser();
                        paperUser.setPaperId(paperId);
                        paperUser.setUserId(id);
                        paperUser.setEnterpriseId(groupId);
                        paperUsers.add(paperUser);
                    }
                    this.trainingPaperUserMapper.insertList(paperUsers);
                }
            }
            if (!CollectionUtils.isEmpty(orgIds = paperUserList.stream().map(TrainingPaperUser::getOrganizeId).filter(Objects::nonNull).distinct().collect(Collectors.toList()))) {
                UsersAndOrgsMo mo = new UsersAndOrgsMo();
                mo.setGroupId(groupId);
                mo.setOrganizeIds(orgIds);
                BaseResult userResult = this.userOrganizeApi.getUserByOrganizeIdsOrDepId(mo);
                if (!userResult.getIsError().booleanValue() && !CollectionUtils.isEmpty((Collection)((Collection)userResult.getData()))) {
                    List users = ((List)userResult.getData()).stream().map(UserAndParentNameMo::getUserId).distinct().collect(Collectors.toList());
                    ArrayList<TrainingPaperUser> paperUsers = new ArrayList<TrainingPaperUser>();
                    users.removeAll(userIdList);
                    if (!CollectionUtils.isEmpty(users)) {
                        for (Integer id : users) {
                            TrainingPaperUser paperUser = new TrainingPaperUser();
                            paperUser.setPaperId(paperId);
                            paperUser.setUserId(id);
                            paperUser.setEnterpriseId(groupId);
                            paperUsers.add(paperUser);
                        }
                        this.trainingPaperUserMapper.insertList(paperUsers);
                    }
                }
            }
            LambdaUpdateWrapper wrapper2 = new LambdaUpdateWrapper();
            ((LambdaUpdateWrapper)wrapper2.eq(TrainingPaperUser::getPaperId, (Object)paperId)).isNull(TrainingPaperUser::getUserId);
            this.trainingPaperUserMapper.delete((Wrapper)wrapper2);
        }
    }

    @Override
    public void savePaperReviewer(TrainingUserPaper trainingUserPaper) {
        TrainingPaper trainingPaper;
        if (!ObjectUtils.isEmpty((Object)trainingUserPaper) && trainingUserPaper.getTrainingPaperId() != null && !ObjectUtils.isEmpty((Object)(trainingPaper = (TrainingPaper)this.paperMapper.selectById(trainingUserPaper.getTrainingPaperId())))) {
            Date now = new Date();
            ArrayList<TrainingPaperReviewer> trainingPaperReviewerList = new ArrayList<TrainingPaperReviewer>();
            TrainingPaperReviewer trainingPaperReviewer = null;
            if (trainingPaper.getReviewerType() == 1 && trainingPaper.getProjectShow() != null && trainingUserPaper.getSourceType() != null) {
                if (trainingPaper.getProjectShow() == 1 || trainingPaper.getProjectShow() == 2) {
                    if (trainingUserPaper.getSourceProjectId() != null && trainingUserPaper.getSourceShiftId() != null) {
                        LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
                        ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper1.eq(TrainingLearnManager::getProjectId, (Object)trainingUserPaper.getSourceProjectId())).in(TrainingLearnManager::getManagerType, Arrays.asList(1, 2, 3))).and(wq -> {
                            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wq.isNull(TrainingLearnManager::getShiftId)).or()).eq(TrainingLearnManager::getShiftId, (Object)trainingUserPaper.getSourceShiftId());
                        });
                        List trainingLearnManagerList = this.trainingLearnManagerMapper.selectList((Wrapper)wrapper1);
                        if (!CollectionUtils.isEmpty((Collection)trainingLearnManagerList)) {
                            List<Object> userIdList = new ArrayList();
                            userIdList = trainingLearnManagerList.stream().map(TrainingLearnManager::getUserId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
                            List<Integer> roleIdList = trainingLearnManagerList.stream().map(TrainingLearnManager::getRoleId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
                            List<Integer> pojoList = this.userUtilService.selectUsersByRoles(roleIdList, trainingUserPaper.getEnterpriseId());
                            userIdList.addAll(pojoList);
                            if (!CollectionUtils.isEmpty(userIdList)) {
                                for (Integer n : userIdList) {
                                    trainingPaperReviewer = new TrainingPaperReviewer();
                                    trainingPaperReviewer.setUserId(n);
                                    trainingPaperReviewer.setUserPaperId(trainingUserPaper.getId());
                                    trainingPaperReviewer.setEnterpriseId(trainingUserPaper.getEnterpriseId());
                                    trainingPaperReviewer.setCreateTime(now);
                                    trainingPaperReviewerList.add(trainingPaperReviewer);
                                }
                            }
                        }
                    }
                } else if (trainingPaper.getProjectShow() == 3) {
                    if (trainingUserPaper.getSourceProjectId() != null) {
                        LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
                        ((LambdaQueryWrapper)wrapper1.eq(TrainingJobUser::getJobId, (Object)trainingUserPaper.getSourceProjectId())).eq(TrainingJobUser::getJobType, (Object)1);
                        List trainingJobUserList = this.trainingJobUserMapper.selectList((Wrapper)wrapper1);
                        if (!CollectionUtils.isEmpty((Collection)trainingJobUserList)) {
                            for (TrainingJobUser trainingJobUser : trainingJobUserList) {
                                trainingPaperReviewer = new TrainingPaperReviewer();
                                trainingPaperReviewer.setUserId(trainingJobUser.getUserId());
                                trainingPaperReviewer.setUserPaperId(trainingUserPaper.getId());
                                trainingPaperReviewer.setEnterpriseId(trainingUserPaper.getEnterpriseId());
                                trainingPaperReviewer.setCreateTime(now);
                                trainingPaperReviewerList.add(trainingPaperReviewer);
                            }
                        }
                    }
                } else if (trainingPaper.getProjectShow() == 4 && trainingUserPaper.getSourceProjectId() != null) {
                    LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
                    ((LambdaQueryWrapper)wrapper1.eq(TrainingCourseUser::getCourseId, (Object)trainingUserPaper.getSourceProjectId())).eq(TrainingCourseUser::getCourseType, (Object)2);
                    List trainingCourseUserList = this.trainingCourseUserMapper.selectList((Wrapper)wrapper1);
                    if (!CollectionUtils.isEmpty((Collection)trainingCourseUserList)) {
                        for (TrainingCourseUser trainingCourseUser : trainingCourseUserList) {
                            trainingPaperReviewer = new TrainingPaperReviewer();
                            trainingPaperReviewer.setUserId(trainingCourseUser.getUserId());
                            trainingPaperReviewer.setUserPaperId(trainingUserPaper.getId());
                            trainingPaperReviewer.setEnterpriseId(trainingUserPaper.getEnterpriseId());
                            trainingPaperReviewer.setCreateTime(now);
                            trainingPaperReviewerList.add(trainingPaperReviewer);
                        }
                    }
                }
            } else if (trainingPaper.getReviewerType() == 2 && trainingUserPaper.getUserId() != null) {
                ArrayList<String> orgIds = new ArrayList<String>();
                UsersAndOrgsMo mo = new UsersAndOrgsMo();
                mo.setGroupId(trainingUserPaper.getEnterpriseId());
                mo.setUserId(trainingUserPaper.getUserId());
                mo.setRetainAll(Boolean.valueOf(false));
                mo.setShowAllPath(Boolean.valueOf(true));
                BaseResult orgResult = this.userOrganizeApi.getUserOrganizeByUserIdAndOrg(mo);
                if (!orgResult.getIsError().booleanValue() && !CollectionUtils.isEmpty((Map)((Map)orgResult.getData()))) {
                    List list;
                    Map map = (Map)orgResult.getData();
                    if (!CollectionUtils.isEmpty((Collection)((Collection)map.get("O_")))) {
                        list = (List)map.get("O_");
                        for (Integer n : list) {
                            orgIds.add("O_" + n);
                        }
                    }
                    if (!CollectionUtils.isEmpty((Collection)((Collection)map.get("S_")))) {
                        list = (List)map.get("S_");
                        for (Integer n : list) {
                            orgIds.add("S_" + n);
                        }
                    }
                }
                if (!CollectionUtils.isEmpty(orgIds)) {
                    LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
                    wrapper1.eq(TrainingCourseConfig::getEnterpriseId, (Object)trainingUserPaper.getEnterpriseId());
                    List trainingCourseConfigList = this.trainingCourseConfigMapper.selectList((Wrapper)wrapper1);
                    if (!CollectionUtils.isEmpty((Collection)trainingCourseConfigList)) {
                        ArrayList<String> courseDirector = new ArrayList<String>();
                        block5: for (Object trainingCourseConfig : trainingCourseConfigList) {
                            List<String> areaIdList;
                            if (org.springframework.util.StringUtils.isEmpty((Object)trainingCourseConfig.getCourseAreaId()) || CollectionUtils.isEmpty(areaIdList = Arrays.asList(trainingCourseConfig.getCourseAreaId().split(",")))) continue;
                            for (String areaId : areaIdList) {
                                if (!orgIds.contains(areaId)) continue;
                                courseDirector.add(trainingCourseConfig.getCourseDirectorId());
                                continue block5;
                            }
                        }
                        ArrayList<String> arrayList = new ArrayList<String>();
                        for (String s : courseDirector) {
                            arrayList.addAll(Arrays.asList(s.split(",")));
                        }
                        List userIdList = arrayList.stream().map(Integer::parseInt).distinct().collect(Collectors.toList());
                        if (!CollectionUtils.isEmpty(userIdList)) {
                            for (Integer userId : userIdList) {
                                trainingPaperReviewer = new TrainingPaperReviewer();
                                trainingPaperReviewer.setUserId(userId);
                                trainingPaperReviewer.setUserPaperId(trainingUserPaper.getId());
                                trainingPaperReviewer.setEnterpriseId(trainingUserPaper.getEnterpriseId());
                                trainingPaperReviewer.setCreateTime(now);
                                trainingPaperReviewerList.add(trainingPaperReviewer);
                            }
                        }
                    }
                }
            } else if (trainingPaper.getReviewerType() == 3 && trainingUserPaper.getUserId() != null) {
                List userIdList;
                Map<Integer, Integer> leaderMap = this.userUtilService.selectParentIdMap(Arrays.asList(trainingUserPaper.getUserId()), trainingUserPaper.getEnterpriseId());
                if (!org.springframework.util.StringUtils.isEmpty(leaderMap) && !CollectionUtils.isEmpty(userIdList = leaderMap.values().stream().filter(Objects::nonNull).distinct().collect(Collectors.toList()))) {
                    for (Integer userId : userIdList) {
                        trainingPaperReviewer = new TrainingPaperReviewer();
                        trainingPaperReviewer.setUserId(userId);
                        trainingPaperReviewer.setUserPaperId(trainingUserPaper.getId());
                        trainingPaperReviewer.setEnterpriseId(trainingUserPaper.getEnterpriseId());
                        trainingPaperReviewer.setCreateTime(now);
                        trainingPaperReviewerList.add(trainingPaperReviewer);
                    }
                }
            } else if (trainingPaper.getReviewerType() == 4) {
                LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)wrapper1.eq(TrainingExaminer::getTrainingPaperId, (Object)trainingPaper.getId())).eq(TrainingExaminer::getEnterpriseId, (Object)trainingPaper.getEnterpriseId());
                List trainingExaminerList = this.trainingExaminerMapper.selectList((Wrapper)wrapper1);
                if (!CollectionUtils.isEmpty((Collection)trainingExaminerList)) {
                    for (TrainingExaminer trainingExaminer : trainingExaminerList) {
                        trainingPaperReviewer = new TrainingPaperReviewer();
                        trainingPaperReviewer.setUserId(trainingExaminer.getUserId());
                        trainingPaperReviewer.setUserPaperId(trainingUserPaper.getId());
                        trainingPaperReviewer.setEnterpriseId(trainingUserPaper.getEnterpriseId());
                        trainingPaperReviewer.setCreateTime(now);
                        trainingPaperReviewerList.add(trainingPaperReviewer);
                    }
                }
            }
            if (CollectionUtils.isEmpty(trainingPaperReviewerList)) {
                trainingPaperReviewer = new TrainingPaperReviewer();
                trainingPaperReviewer.setUserId(trainingPaper.getCreater());
                trainingPaperReviewer.setUserPaperId(trainingUserPaper.getId());
                trainingPaperReviewer.setEnterpriseId(trainingUserPaper.getEnterpriseId());
                trainingPaperReviewer.setCreateTime(now);
                trainingPaperReviewerList.add(trainingPaperReviewer);
            }
            if (!CollectionUtils.isEmpty(trainingPaperReviewerList)) {
                this.trainingPaperReviewerMapper.insertList(trainingPaperReviewerList);
            }
        }
    }

    @Override
    public void save85PaperReviewers(Integer enterpriseId) {
        Date now = new Date();
        LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)wrapper1.eq(TrainingPaper::getEnterpriseId, (Object)enterpriseId)).eq(TrainingPaper::getReviewerType, (Object)2);
        List trainingPaperList = this.trainingPaperMapper.selectList((Wrapper)wrapper1);
        if (!CollectionUtils.isEmpty((Collection)trainingPaperList)) {
            List trainingPaperIdList = trainingPaperList.stream().map(TrainingPaper::getId).collect(Collectors.toList());
            LambdaQueryWrapper wrapper2 = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper2.eq(TrainingUserPaper::getEnterpriseId, (Object)enterpriseId)).in(TrainingUserPaper::getTrainingPaperId, trainingPaperIdList)).eq(TrainingUserPaper::getPaperStatus, (Object)1)).isNotNull(TrainingUserPaper::getUserId);
            List trainingUserPaperList = this.trainingUserPaperMapper.selectList((Wrapper)wrapper2);
            if (!CollectionUtils.isEmpty((Collection)trainingUserPaperList)) {
                List userIdList = trainingUserPaperList.stream().map(TrainingUserPaper::getUserId).distinct().collect(Collectors.toList());
                LambdaQueryWrapper wrapper3 = new LambdaQueryWrapper();
                wrapper3.eq(TrainingCourseConfig::getEnterpriseId, (Object)enterpriseId);
                List trainingCourseConfigList = this.trainingCourseConfigMapper.selectList((Wrapper)wrapper3);
                HashMap userMap = new HashMap();
                ArrayList<String> orgIds = null;
                ArrayList<String> userIds = null;
                if (!CollectionUtils.isEmpty((Collection)trainingCourseConfigList)) {
                    for (Integer userId : userIdList) {
                        orgIds = new ArrayList<String>();
                        userIds = new ArrayList<String>();
                        UsersAndOrgsMo mo = new UsersAndOrgsMo();
                        mo.setGroupId(enterpriseId);
                        mo.setUserId(userId);
                        mo.setRetainAll(Boolean.valueOf(false));
                        mo.setShowAllPath(Boolean.valueOf(true));
                        BaseResult orgResult = this.userOrganizeApi.getUserOrganizeByUserIdAndOrg(mo);
                        if (!orgResult.getIsError().booleanValue() && !CollectionUtils.isEmpty((Map)((Map)orgResult.getData()))) {
                            Integer id;
                            Iterator iterator;
                            Object list;
                            Map map = (Map)orgResult.getData();
                            if (!CollectionUtils.isEmpty((Collection)((Collection)map.get("O_")))) {
                                list = (List)map.get("O_");
                                iterator = list.iterator();
                                while (iterator.hasNext()) {
                                    id = (Integer)iterator.next();
                                    orgIds.add("O_" + id);
                                }
                            }
                            if (!CollectionUtils.isEmpty((Collection)((Collection)map.get("S_")))) {
                                list = (List)map.get("S_");
                                iterator = list.iterator();
                                while (iterator.hasNext()) {
                                    id = (Integer)iterator.next();
                                    orgIds.add("S_" + id);
                                }
                            }
                        }
                        if (!CollectionUtils.isEmpty(orgIds)) {
                            ArrayList<String> courseDirector = new ArrayList<String>();
                            block3: for (TrainingCourseConfig trainingCourseConfig : trainingCourseConfigList) {
                                List<String> areaIdList;
                                if (org.springframework.util.StringUtils.isEmpty((Object)trainingCourseConfig.getCourseAreaId()) || CollectionUtils.isEmpty(areaIdList = Arrays.asList(trainingCourseConfig.getCourseAreaId().split(",")))) continue;
                                for (String areaId : areaIdList) {
                                    if (!orgIds.contains(areaId)) continue;
                                    courseDirector.add(trainingCourseConfig.getCourseDirectorId());
                                    continue block3;
                                }
                            }
                            for (String s : courseDirector) {
                                userIds.addAll(Arrays.asList(s.split(",")));
                            }
                        }
                        userMap.put(userId, userIds);
                    }
                }
                List trainingUserPaperIdList = trainingUserPaperList.stream().map(TrainingUserPaper::getId).collect(Collectors.toList());
                LambdaQueryWrapper wrapper4 = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)wrapper4.eq(TrainingPaperReviewer::getEnterpriseId, (Object)enterpriseId)).in(TrainingPaperReviewer::getUserPaperId, trainingUserPaperIdList);
                List trainingPaperReviewerList = this.trainingPaperReviewerMapper.selectList((Wrapper)wrapper4);
                Map<Object, Object> trainingPaperReviewerMap = new HashMap();
                if (!CollectionUtils.isEmpty((Collection)trainingPaperReviewerList)) {
                    trainingPaperReviewerMap = trainingPaperReviewerList.stream().collect(Collectors.groupingBy(TrainingPaperReviewer::getUserPaperId));
                }
                ArrayList<TrainingPaperReviewer> trainingPaperReviewers = new ArrayList<TrainingPaperReviewer>();
                TrainingPaperReviewer trainingPaperReviewer = null;
                for (TrainingUserPaper trainingUserPaper : trainingUserPaperList) {
                    List userIdStrList = (List)userMap.get(trainingUserPaper.getUserId());
                    if (!CollectionUtils.isEmpty((Collection)((Collection)trainingPaperReviewerMap.get(trainingUserPaper.getId()))) || CollectionUtils.isEmpty((Collection)userIdStrList)) continue;
                    for (String userId : userIdStrList) {
                        if (org.springframework.util.StringUtils.isEmpty((Object)userId)) continue;
                        trainingPaperReviewer = new TrainingPaperReviewer();
                        trainingPaperReviewer.setUserId(Integer.valueOf(userId));
                        trainingPaperReviewer.setUserPaperId(trainingUserPaper.getId());
                        trainingPaperReviewer.setEnterpriseId(enterpriseId);
                        trainingPaperReviewer.setCreateTime(now);
                        trainingPaperReviewers.add(trainingPaperReviewer);
                    }
                }
                if (!CollectionUtils.isEmpty(trainingPaperReviewers)) {
                    this.trainingPaperReviewerMapper.insertList(trainingPaperReviewers);
                }
            }
        }
    }

    @Override
    public Integer selectPaperIsUserPower(TrainingPapersVo papersVo, Users user) {
        Integer isPower = 0;
        TrainingPaper paper = (TrainingPaper)this.paperMapper.selectById(papersVo.getId());
        if (!ObjectUtils.isEmpty((Object)paper)) {
            if (user.getGroupId() != null && user.getGroupId().equals(paper.getEnterpriseId())) {
                if (!ObjectUtils.isEmpty((Object)paper.getLookLevel())) {
                    List tagIds;
                    BaseResult tagResult;
                    LambdaQueryWrapper wrapper2 = new LambdaQueryWrapper();
                    ((LambdaQueryWrapper)wrapper2.eq(TrainingPaperUser::getUserId, (Object)user.getId())).eq(TrainingPaperUser::getPaperId, (Object)papersVo.getId());
                    List paper2 = this.trainingPaperUserMapper.selectList((Wrapper)wrapper2);
                    if (!CollectionUtils.isEmpty((Collection)paper2)) {
                        isPower = 1;
                        return isPower;
                    }
                    List<Integer> roleList = this.userUtilService.selectUserRoleList(user);
                    if (!CollectionUtils.isEmpty(roleList)) {
                        LambdaQueryWrapper roleWrapper = new LambdaQueryWrapper();
                        roleWrapper.eq(TrainingPaperUser::getEnterpriseId, (Object)user.getGroupId());
                        roleWrapper.eq(TrainingPaperUser::getPaperId, (Object)papersVo.getId());
                        roleWrapper.in(TrainingPaperUser::getRoleId, roleList);
                        List rolePaper = this.trainingPaperUserMapper.selectList((Wrapper)roleWrapper);
                        if (!CollectionUtils.isEmpty((Collection)rolePaper)) {
                            isPower = 1;
                            return isPower;
                        }
                    }
                    if (!((tagResult = this.tagApi.getUsersTagByUserId(user.getId())).getIsError().booleanValue() || CollectionUtils.isEmpty((Collection)((Collection)tagResult.getData())) || CollectionUtils.isEmpty(tagIds = ((List)tagResult.getData()).stream().map(UserTagMo::getId).distinct().collect(Collectors.toList())))) {
                        LambdaQueryWrapper tagWrapper = new LambdaQueryWrapper();
                        tagWrapper.eq(TrainingPaperUser::getEnterpriseId, (Object)user.getGroupId());
                        tagWrapper.eq(TrainingPaperUser::getPaperId, (Object)papersVo.getId());
                        tagWrapper.in(TrainingPaperUser::getTagId, tagIds);
                        List tagPaper = this.trainingPaperUserMapper.selectList((Wrapper)tagWrapper);
                        if (!CollectionUtils.isEmpty((Collection)tagPaper)) {
                            isPower = 1;
                            return isPower;
                        }
                    }
                    ArrayList<String> orgIds = new ArrayList<String>();
                    UsersAndOrgsMo mo = new UsersAndOrgsMo();
                    mo.setGroupId(user.getGroupId());
                    mo.setUserId(user.getId());
                    mo.setRetainAll(Boolean.valueOf(false));
                    mo.setShowAllPath(Boolean.valueOf(true));
                    BaseResult orgResult = this.userOrganizeApi.getUserOrganizeByUserIdAndOrg(mo);
                    if (!orgResult.getIsError().booleanValue() && !CollectionUtils.isEmpty((Map)((Map)orgResult.getData()))) {
                        List list;
                        Map map = (Map)orgResult.getData();
                        if (!CollectionUtils.isEmpty((Collection)((Collection)map.get("O_")))) {
                            list = (List)map.get("O_");
                            for (Integer id : list) {
                                orgIds.add("O_" + id);
                            }
                        }
                        if (!CollectionUtils.isEmpty((Collection)((Collection)map.get("S_")))) {
                            list = (List)map.get("S_");
                            for (Integer id : list) {
                                orgIds.add("S_" + id);
                            }
                        }
                    }
                    if (!CollectionUtils.isEmpty(orgIds)) {
                        LambdaQueryWrapper orgWrapper = new LambdaQueryWrapper();
                        orgWrapper.eq(TrainingPaperUser::getEnterpriseId, (Object)user.getGroupId());
                        orgWrapper.eq(TrainingPaperUser::getPaperId, (Object)papersVo.getId());
                        orgWrapper.in(TrainingPaperUser::getOrganizeId, orgIds);
                        List orgPaper = this.trainingPaperUserMapper.selectList((Wrapper)orgWrapper);
                        if (!CollectionUtils.isEmpty((Collection)orgPaper)) {
                            isPower = 1;
                            return isPower;
                        }
                    }
                } else {
                    isPower = 1;
                }
            } else {
                isPower = 4;
            }
        } else {
            isPower = 2;
        }
        return isPower;
    }

    @Override
    public String getOpenUserPaperList(Integer enterpriseId, Date startDate, Date endDate) {
        List list;
        ArrayList<OpenUserPaperVo> result = new ArrayList<OpenUserPaperVo>();
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(TrainingUserPaper::getEnterpriseId, (Object)enterpriseId);
        if (startDate != null) {
            wrapper.ge(TrainingUserPaper::getCreateTime, (Object)startDate);
        }
        if (endDate != null) {
            wrapper.le(TrainingUserPaper::getCreateTime, (Object)endDate);
        }
        if (!CollectionUtils.isEmpty((Collection)(list = this.trainingUserPaperMapper.selectList((Wrapper)wrapper)))) {
            List paperIds = list.stream().map(TrainingUserPaper::getTrainingPaperId).distinct().collect(Collectors.toList());
            List paperList = this.paperMapper.selectBatchIds(paperIds);
            Map paperMap = paperList.stream().collect(Collectors.toMap(TrainingPaper::getId, Function.identity()));
            for (TrainingUserPaper userPaper : list) {
                OpenUserPaperVo vo = new OpenUserPaperVo();
                vo.setUserPaperId(userPaper.getId());
                vo.setUserId(userPaper.getUserId());
                vo.setPaperId(userPaper.getTrainingPaperId());
                vo.setScore(Double.valueOf(userPaper.getScore().doubleValue()));
                vo.setCreateTime(userPaper.getCreateTime());
                vo.setSubmitTime(userPaper.getSubmitTime());
                vo.setSourceType(userPaper.getSourceType());
                vo.setMarkingTime(userPaper.getMarkingTime());
                TrainingPaper paper = (TrainingPaper)paperMap.get(userPaper.getTrainingPaperId());
                Integer passLine = ObjectUtils.isEmpty((Object)paper) || paper.getPassLine() == null ? 60 : paper.getPassLine();
                BigDecimal totalScore = new BigDecimal(100);
                if (userPaper.getPaperStatus() == 0) {
                    vo.setPaperStatus(Integer.valueOf(4));
                    continue;
                }
                if (userPaper.getPaperStatus() == 1) {
                    vo.setPaperStatus(Integer.valueOf(1));
                } else if (userPaper.getScore().compareTo(totalScore.multiply(new BigDecimal(passLine)).divide(new BigDecimal(100), 2, 4)) < 0) {
                    vo.setPaperStatus(Integer.valueOf(3));
                } else {
                    vo.setPaperStatus(Integer.valueOf(2));
                }
                result.add(vo);
            }
        }
        return JsonResult.success(result);
    }

    @Override
    public Integer insertSamePaper(Integer trainingPaperId, Integer projectShow, Users user) {
        Date now = new Date();
        TrainingPaper paper = (TrainingPaper)this.trainingPaperMapper.selectById(trainingPaperId);
        paper.setId(null);
        paper.setProjectShow(projectShow);
        paper.setIsTraining(Integer.valueOf(1));
        paper.setCreater(user.getId());
        paper.setCreateTime(now);
        if (paper.getExamId() != null && (org.springframework.util.StringUtils.isEmpty((Object)paper.getPaperType()) || paper.getPaperType() == 1)) {
            paper.setExamId(this.examService.updateCopyExam(paper.getExamId(), user.getId()));
        }
        this.trainingPaperMapper.insert(paper);
        LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
        wrapper1.eq(TrainingExaminer::getTrainingPaperId, (Object)trainingPaperId);
        List trainingExaminerList = this.trainingExaminerMapper.selectList((Wrapper)wrapper1);
        if (!CollectionUtils.isEmpty((Collection)trainingExaminerList)) {
            for (TrainingExaminer trainingExaminer : trainingExaminerList) {
                trainingExaminer.setId(null);
                trainingExaminer.setTrainingPaperId(paper.getId());
            }
            this.trainingExaminerMapper.insertList(trainingExaminerList);
        }
        LambdaQueryWrapper paperUserWrapper = new LambdaQueryWrapper();
        paperUserWrapper.eq(TrainingPaperUser::getPaperId, (Object)trainingPaperId);
        List paperUserList = this.trainingPaperUserMapper.selectList((Wrapper)paperUserWrapper);
        if (!CollectionUtils.isEmpty((Collection)paperUserList)) {
            for (TrainingPaperUser paperUser : paperUserList) {
                paperUser.setId(null);
                paperUser.setPaperId(paper.getId());
            }
            this.trainingPaperUserMapper.insertList(paperUserList);
        }
        return paper.getId();
    }

    @Override
    public void saveNewPapersByOld(List<Integer> paperIdList) {
        List<Object> trainingPaperList = Lists.newArrayList();
        if (CollectionUtils.isEmpty(paperIdList)) {
            trainingPaperList = this.paperMapper.selectOldPapersByTraining();
        } else {
            LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)wrapper1.in(TrainingPaper::getId, paperIdList)).isNull(TrainingPaper::getExamId);
            trainingPaperList = this.paperMapper.selectList((Wrapper)wrapper1);
        }
        if (!CollectionUtils.isEmpty((Collection)trainingPaperList)) {
            Date now = new Date();
            List trainingPaperIdList = trainingPaperList.stream().map(TrainingPaper::getId).collect(Collectors.toList());
            LambdaQueryWrapper wrapper2 = new LambdaQueryWrapper();
            wrapper2.in(TrainingPaperQuestion::getPaperId, trainingPaperIdList);
            List trainingPaperQuestionList = this.trainingPaperQuestionMapper.selectList((Wrapper)wrapper2);
            List trainingQuestionIdList = trainingPaperQuestionList.stream().map(TrainingPaperQuestion::getQuestionId).collect(Collectors.toList());
            Map<Integer, List<TrainingPaperQuestion>> trainingPaperQuestionMap = trainingPaperQuestionList.stream().collect(Collectors.groupingBy(TrainingPaperQuestion::getPaperId));
            List trainingQuestionList = this.trainingQuestionMapper.selectBatchIds(trainingQuestionIdList);
            Map trainingQuestionMap = trainingQuestionList.stream().collect(Collectors.toMap(TrainingQuestion::getId, Function.identity()));
            LambdaQueryWrapper wrapper3 = new LambdaQueryWrapper();
            wrapper3.in(TrainingOptions::getTrainingQuestionId, trainingQuestionIdList);
            List trainingOptionsList = this.trainingOptionsMapper.selectList((Wrapper)wrapper3);
            Map<Integer, List<TrainingOptions>> trainingOptionsMap = trainingOptionsList.stream().collect(Collectors.groupingBy(TrainingOptions::getTrainingQuestionId));
            for (TrainingPaper trainingPaper : trainingPaperList) {
                trainingPaper.setPaperState(Integer.valueOf(2));
                trainingPaper.setPaperType(Integer.valueOf(1));
                trainingPaper.setPassLine(Integer.valueOf(60));
                TrainingExam trainingExam = new TrainingExam();
                trainingExam.setName(trainingPaper.getTitle());
                trainingExam.setExamClass(Integer.valueOf(1));
                trainingExam.setScore(new BigDecimal("100"));
                trainingExam.setStatus(Integer.valueOf(1));
                List<TrainingPaperQuestion> trainingPaperQuestions = trainingPaperQuestionMap.get(trainingPaper.getId());
                trainingExam.setCount(Integer.valueOf(trainingPaperQuestions.size()));
                trainingExam.setEnterpriseId(trainingPaper.getEnterpriseId());
                trainingExam.setCreateTime(now);
                trainingExam.setExamVersion(Integer.valueOf(2));
                this.trainingExamMapper.insert(trainingExam);
                trainingPaper.setExamId(trainingExam.getId());
                trainingPaper.setUpdateTime(now);
                for (TrainingPaperQuestion trainingPaperQuestion : trainingPaperQuestions) {
                    TrainingQuestion trainingQuestion = (TrainingQuestion)trainingQuestionMap.get(trainingPaperQuestion.getQuestionId());
                    if (ObjectUtils.isEmpty((Object)trainingQuestion)) continue;
                    TrainingExamQuestion trainingExamQuestion = new TrainingExamQuestion();
                    trainingExamQuestion.setExamId(trainingExam.getId());
                    trainingExamQuestion.setQuestionId(trainingQuestion.getId());
                    trainingExamQuestion.setContent(trainingQuestion.getName());
                    trainingExamQuestion.setQuestionType(trainingQuestion.getQuestionType());
                    trainingExamQuestion.setScore(trainingPaperQuestion.getScore());
                    trainingExamQuestion.setEnterpriseId(trainingQuestion.getEnterpriseId());
                    trainingExamQuestion.setCreateTime(now);
                    trainingExamQuestion.setRemark(trainingQuestion.getRemark());
                    trainingExamQuestion.setPicturePath(trainingQuestion.getPicturePath());
                    trainingExamQuestion.setIsUpload(trainingQuestion.getIsUpload());
                    this.trainingExamQuestionMapper.insert(trainingExamQuestion);
                    TrainingExamOptions trainingExamOptions = new TrainingExamOptions();
                    if (trainingQuestion.getQuestionType() == 4) {
                        trainingExamOptions.setExamQuestionId(trainingExamQuestion.getId());
                        trainingExamOptions.setContent(trainingQuestion.getIsCorrect().toString());
                        trainingExamOptions.setIsAnswer(Integer.valueOf(1));
                        trainingExamOptions.setCreateTime(now);
                        trainingExamOptions.setPicturePath(trainingQuestion.getPicturePath());
                        this.trainingExamOptionsMapper.insert(trainingExamOptions);
                        continue;
                    }
                    List<TrainingOptions> trainingOptionses = trainingOptionsMap.get(trainingQuestion.getId());
                    if (CollectionUtils.isEmpty(trainingOptionses)) continue;
                    for (TrainingOptions trainingOption : trainingOptionses) {
                        trainingExamOptions.setExamQuestionId(trainingExamQuestion.getId());
                        trainingExamOptions.setContent(trainingOption.getName());
                        trainingExamOptions.setIsAnswer(trainingOption.getIsAnswer());
                        trainingExamOptions.setCreateTime(now);
                        trainingExamOptions.setPicturePath(trainingOption.getPicturePath());
                        this.trainingExamOptionsMapper.insert(trainingExamOptions);
                    }
                }
                this.trainingPaperMapper.updateById(trainingPaper);
            }
        }
    }

    @Override
    public String getUserPaperStatus(TrainingPapersVo papersVo, Users user) {
        TrainingPaper trainingPaper = (TrainingPaper)this.trainingPaperMapper.selectById(papersVo.getId());
        if (ObjectUtils.isEmpty((Object)trainingPaper)) {
            return JsonResult.getSuccess((Object)"3", (Object)"");
        }
        TrainingExam trainingExam = new TrainingExam();
        if (trainingPaper.getExamId() != null) {
            trainingExam = (TrainingExam)this.trainingExamMapper.selectById(trainingPaper.getExamId());
        }
        LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper1.eq(TrainingUserPaper::getUserId, (Object)user.getId())).eq(TrainingUserPaper::getTrainingPaperId, (Object)papersVo.getId())).in(TrainingUserPaper::getPaperStatus, Arrays.asList("1", "2"))).isNotNull(TrainingUserPaper::getSubmitTime)).eq(TrainingUserPaper::getSourceType, (Object)papersVo.getSourceType())).eq(TrainingUserPaper::getSourceProjectId, (Object)papersVo.getSourceProjectId())).eq(!org.springframework.util.StringUtils.isEmpty((Object)papersVo.getSourceTaskId()), TrainingUserPaper::getSourceTaskId, (Object)papersVo.getSourceTaskId())).orderByDesc(TrainingUserPaper::getId);
        List trainingUserPapperList = this.trainingUserPaperMapper.selectList((Wrapper)wrapper1);
        Map<String, Object> map = this.trainingCommonService.isPaperStatus(trainingPaper, trainingExam, trainingUserPapperList);
        int status = Integer.parseInt(map.get("status").toString());
        String score = map.get("score").toString();
        if (status == 0) {
            return JsonResult.getSuccess((Object)"3", (Object)score);
        }
        if (status == 1) {
            return JsonResult.getSuccess((Object)"4", (Object)score);
        }
        if (status == 2) {
            return JsonResult.getSuccess((Object)"2", (Object)score);
        }
        if (status == 3) {
            return JsonResult.getSuccess((Object)"1", (Object)score);
        }
        return JsonResult.getSuccess((Object)"3", (Object)score);
    }
}

