/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.training.service.impl;

import cn.hutool.core.util.RandomUtil;
import cn.hutool.extra.servlet.ServletUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ovopark.api.RedisBaseApi;
import com.ovopark.api.SendSmsApi;
import com.ovopark.organize.common.model.pojo.UsersPojo;
import com.ovopark.pojo.BaseResult;
import com.ovopark.training.bo.JsonResult;
import com.ovopark.training.bo.Page;
import com.ovopark.training.mapper.TrainingExamMapper;
import com.ovopark.training.mapper.TrainingExamOptionsMapper;
import com.ovopark.training.mapper.TrainingExamQuestionMapper;
import com.ovopark.training.mapper.TrainingExaminerMapper;
import com.ovopark.training.mapper.TrainingLoginUserLogMapper;
import com.ovopark.training.mapper.TrainingLoginUserMapper;
import com.ovopark.training.mapper.TrainingOptionsMapper;
import com.ovopark.training.mapper.TrainingPaperMapper;
import com.ovopark.training.mapper.TrainingPaperRandomMapper;
import com.ovopark.training.mapper.TrainingPaperReviewerMapper;
import com.ovopark.training.mapper.TrainingQuestionMapper;
import com.ovopark.training.mapper.TrainingUserPaperMapper;
import com.ovopark.training.mapper.TrainingUserQuestionAttaMapper;
import com.ovopark.training.mapper.TrainingUserQuestionMapper;
import com.ovopark.training.mapper.TrainingUserQuestionPictureMapper;
import com.ovopark.training.model.TrainingExam;
import com.ovopark.training.model.TrainingExamOptions;
import com.ovopark.training.model.TrainingExamQuestion;
import com.ovopark.training.model.TrainingExaminer;
import com.ovopark.training.model.TrainingLoginUser;
import com.ovopark.training.model.TrainingLoginUserLog;
import com.ovopark.training.model.TrainingOptions;
import com.ovopark.training.model.TrainingPaper;
import com.ovopark.training.model.TrainingPaperRandom;
import com.ovopark.training.model.TrainingPaperReviewer;
import com.ovopark.training.model.TrainingQuestion;
import com.ovopark.training.model.TrainingUserPaper;
import com.ovopark.training.model.TrainingUserQuestion;
import com.ovopark.training.model.TrainingUserQuestionAtta;
import com.ovopark.training.model.TrainingUserQuestionPicture;
import com.ovopark.training.model.Users;
import com.ovopark.training.service.TrainingPaperVisitorService;
import com.ovopark.training.service.UserUtilService;
import com.ovopark.training.util.DateUtils;
import com.ovopark.training.util.LocaleUtil;
import com.ovopark.training.util.StringsUtils;
import com.ovopark.training.vo.PaperScreenNumVo;
import com.ovopark.training.vo.TrainingLoginUserVo;
import com.ovopark.training.vo.TrainingOptionsVo;
import com.ovopark.training.vo.TrainingPapersVo;
import com.ovopark.training.vo.TrainingQuestionVo;
import com.ovopark.training.vo.TrainingUserPaperVo;
import com.ovopark.training.vo.TrainingUserQuestionVo;
import java.math.BigDecimal;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
public class TrainingPaperVisitorServiceImpl
implements TrainingPaperVisitorService {
    private static final Logger log = LoggerFactory.getLogger(TrainingPaperVisitorServiceImpl.class);
    @Autowired
    private TrainingLoginUserMapper trainingLoginUserMapper;
    @Autowired
    private RedisBaseApi redisBaseApi;
    @Autowired
    private SendSmsApi sendSmsApi;
    @Autowired
    private TrainingLoginUserLogMapper trainingLoginUserLogMapper;
    @Autowired
    private TrainingPaperMapper trainingPaperMapper;
    @Autowired
    private TrainingUserPaperMapper trainingUserPaperMapper;
    @Autowired
    private TrainingExamMapper trainingExamMapper;
    @Autowired
    private UserUtilService userUtilService;
    @Autowired
    private TrainingUserQuestionMapper trainingUserQuestionMapper;
    @Autowired
    private TrainingUserQuestionPictureMapper trainingUserQuestionPictureMapper;
    @Autowired
    private TrainingExamQuestionMapper trainingExamQuestionMapper;
    @Autowired
    private TrainingExamOptionsMapper trainingExamOptionsMapper;
    @Autowired
    private TrainingPaperRandomMapper trainingPaperRandomMapper;
    @Autowired
    private TrainingQuestionMapper trainingQuestionMapper;
    @Autowired
    private TrainingOptionsMapper trainingOptionsMapper;
    @Autowired
    private TrainingUserQuestionAttaMapper trainingUserQuestionAttaMapper;
    @Value(value="${training.visitor.paper.verification}")
    private String visitorVerification;
    @Autowired
    private MessageSource messageSource;
    @Value(value="${training.visitor.paper.encrypt}")
    private String encrypt;
    @Autowired
    private TrainingPaperReviewerMapper trainingPaperReviewerMapper;
    @Autowired
    private TrainingExaminerMapper trainingExaminerMapper;

    @Override
    public String selectVisitorLoginVerificationCode(String mobilePhone, String language) {
        Locale locale = LocaleUtil.getLocale(language);
        if (StringUtils.isEmpty((Object)mobilePhone.trim())) {
            String visitorPhone = this.messageSource.getMessage("training.paper.visitor.phone", null, locale);
            return JsonResult.error((String)visitorPhone, (Object)"");
        }
        try {
            String phone = mobilePhone.trim();
            BaseResult baseResult = this.redisBaseApi.get("Training_VisitorTime_" + phone);
            if (baseResult != null && !StringUtils.isEmpty((Object)baseResult.getData())) {
                String visitorVerification = this.messageSource.getMessage("training.paper.visitor.verification", null, locale);
                return JsonResult.error((String)visitorVerification, (Object)"");
            }
            String verificationCode = String.format("%04d", RandomUtil.randomInt((int)0, (int)9999));
            BaseResult baseResultSms = this.sendSmsApi.sendSms(phone, this.visitorVerification, verificationCode);
            if (baseResultSms == null || baseResultSms.getIsError().booleanValue()) {
                log.error("\u6e38\u5ba2\u8003\u8bd5\u9a8c\u8bc1\u7801\u53d1\u9001\u5931\u8d25", (Object)(phone + JSON.toJSONString((Object)baseResultSms)));
                String visitorMessage = this.messageSource.getMessage("training.paper.visitor.message", null, locale);
                return JsonResult.error((String)visitorMessage, (Object)"");
            }
            this.redisBaseApi.setExpire("Training_VisitorTime_" + phone, verificationCode, Integer.valueOf(65));
            this.redisBaseApi.setExpire("Training_Visitor_" + phone, verificationCode, Integer.valueOf(910));
        }
        catch (Exception e) {
            log.error("\u6e38\u5ba2\u8003\u8bd5\u9a8c\u8bc1\u7801\u5931\u8d25" + mobilePhone, (Throwable)e);
            String visitorService = this.messageSource.getMessage("training.paper.visitor.service", null, locale);
            return JsonResult.error((String)visitorService, (Object)"");
        }
        return JsonResult.success();
    }

    public String getMacAddress() {
        String macAddress = "";
        try {
            InetAddress ipAddress = InetAddress.getLocalHost();
            NetworkInterface networkInterface = NetworkInterface.getByInetAddress(ipAddress);
            byte[] macAddressBytes = networkInterface.getHardwareAddress();
            StringBuilder macAddressBuilder = new StringBuilder();
            for (int i = 0; i < macAddressBytes.length; ++i) {
                macAddressBuilder.append(String.format("%02X%s", macAddressBytes[i], i < macAddressBytes.length - 1 ? "-" : ""));
            }
            macAddress = macAddressBuilder.toString();
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6mac\u5f02\u5e38", (Throwable)e);
        }
        return macAddress;
    }

    @Override
    public String saveVisitorLoginInformation(HttpServletRequest request, TrainingLoginUserVo trainingLoginUserVo, Users user) {
        Date now = new Date();
        LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper1.eq(TrainingLoginUser::getMobilePhone, (Object)trainingLoginUserVo.getMobilePhone())).eq(TrainingLoginUser::getUserId, (Object)user.getId())).eq(TrainingLoginUser::getIsDel, (Object)0);
        List trainingLoginUserList = this.trainingLoginUserMapper.selectList((Wrapper)wrapper1);
        if (!CollectionUtils.isEmpty((Collection)trainingLoginUserList)) {
            TrainingLoginUser trainingLoginUser = (TrainingLoginUser)trainingLoginUserList.get(0);
            trainingLoginUserVo.setId(trainingLoginUser.getId());
            trainingLoginUserVo.setUpdateTime(now);
            trainingLoginUserVo.setUserId(user.getId());
            if (StringUtils.isEmpty((Object)trainingLoginUserVo.getEmployeeNumber()) && !StringUtils.isEmpty((Object)trainingLoginUser.getEmployeeNumber())) {
                trainingLoginUserVo.setEmployeeNumber(trainingLoginUser.getEmployeeNumber());
            }
            if (StringUtils.isEmpty((Object)trainingLoginUserVo.getDepartment()) && !StringUtils.isEmpty((Object)trainingLoginUser.getDepartment())) {
                trainingLoginUserVo.setDepartment(trainingLoginUser.getDepartment());
            }
            if (StringUtils.isEmpty((Object)trainingLoginUserVo.getPostName()) && !StringUtils.isEmpty((Object)trainingLoginUser.getPostName())) {
                trainingLoginUserVo.setPostName(trainingLoginUser.getPostName());
            }
            this.trainingLoginUserMapper.updateById(trainingLoginUserVo);
        } else {
            trainingLoginUserVo.setCreateTime(now);
            trainingLoginUserVo.setUpdateTime(now);
            trainingLoginUserVo.setUserId(user.getId());
            this.trainingLoginUserMapper.insert(trainingLoginUserVo);
        }
        TrainingLoginUserLog trainingLoginUserLog = new TrainingLoginUserLog();
        trainingLoginUserLog.setLoginUserId(trainingLoginUserVo.getId());
        trainingLoginUserLog.setShowName(trainingLoginUserVo.getShowName());
        trainingLoginUserLog.setMobilePhone(trainingLoginUserVo.getMobilePhone());
        trainingLoginUserLog.setIp(ServletUtil.getClientIP((HttpServletRequest)request, (String[])new String[0]));
        trainingLoginUserLog.setCreateTime(now);
        this.trainingLoginUserLogMapper.insert(trainingLoginUserLog);
        return JsonResult.success();
    }

    @Override
    public String selectPapersVoVisitor(TrainingPapersVo papersVo, Users user) {
        UsersPojo usersPojo;
        papersVo.setUserId(user.getId());
        TrainingPaper paper = (TrainingPaper)this.trainingPaperMapper.selectById(papersVo.getId());
        if (ObjectUtils.isEmpty((Object)paper)) {
            return "PAPER_IS_DELETE";
        }
        BeanUtils.copyProperties((Object)paper, (Object)papersVo);
        TrainingExam exam = (TrainingExam)this.trainingExamMapper.selectById(papersVo.getExamId());
        if (!ObjectUtils.isEmpty((Object)exam)) {
            papersVo.setTotalScore(exam.getScore());
            papersVo.setPassScore(exam.getScore().multiply(new BigDecimal(papersVo.getPassLine())).divide(new BigDecimal("100"), 2, 4));
            papersVo.setQuestionCount(exam.getCount());
        }
        papersVo.setScoreSelect(Integer.valueOf(papersVo.getScoreSelect() == null ? 1 : papersVo.getScoreSelect()));
        papersVo.setStartTime(papersVo.getStartTime() == null ? papersVo.getUpdateTime() : papersVo.getStartTime());
        LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper1.eq(TrainingUserPaper::getTrainingPaperId, (Object)papersVo.getId())).eq(TrainingUserPaper::getLoginUserId, (Object)user.getId())).orderByDesc(TrainingUserPaper::getId);
        List userPaperList = this.trainingUserPaperMapper.selectList((Wrapper)wrapper1);
        Integer paperCount = 0;
        Integer isNotFinish = 0;
        if (!CollectionUtils.isEmpty((Collection)userPaperList)) {
            papersVo.setIsAutoRead(((TrainingUserPaper)userPaperList.get(0)).getIsAutoRead());
            paperCount = userPaperList.size();
            if (((TrainingUserPaper)userPaperList.get(0)).getSubmitTime() == null) {
                isNotFinish = 1;
                Integer n = paperCount;
                Integer n2 = paperCount = Integer.valueOf(paperCount - 1);
            }
        }
        papersVo.setPaperCount(paperCount);
        papersVo.setIsNotFinish(isNotFinish);
        String createName = "";
        if (Objects.nonNull(papersVo.getCreater()) && Objects.nonNull(usersPojo = this.userUtilService.selectUser(paper.getCreater()))) {
            createName = usersPojo.getShowName();
        }
        papersVo.setCreaterName(createName);
        return JsonResult.success((Object)papersVo);
    }

    private TrainingUserPaper savePaperLoginUser(TrainingUserPaper userPaper, TrainingUserPaperVo userPaperVo) {
        if (StringUtils.isEmpty((Object)userPaperVo.getLoginShowName())) {
            LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)wrapper1.eq(TrainingLoginUser::getUserId, (Object)userPaperVo.getUserId())).orderByDesc(TrainingLoginUser::getId);
            List trainingLoginUserList = this.trainingLoginUserMapper.selectList((Wrapper)wrapper1);
            if (!CollectionUtils.isEmpty((Collection)trainingLoginUserList)) {
                TrainingLoginUser trainingLoginUser = (TrainingLoginUser)trainingLoginUserList.get(0);
                userPaper.setLoginShowName(trainingLoginUser.getShowName());
                userPaper.setLoginDepName(trainingLoginUser.getDepartment());
                userPaper.setLoginEmployeeNumber(trainingLoginUser.getEmployeeNumber());
            }
        } else {
            userPaper.setLoginShowName(userPaperVo.getLoginShowName());
            userPaper.setLoginDepName(userPaperVo.getLoginDepName());
            userPaper.setLoginEmployeeNumber(userPaperVo.getLoginEmployeeNumber());
        }
        return userPaper;
    }

    @Override
    public String selectPaperQuestionsVisitor(TrainingUserPaperVo userPaperVo, Users user) {
        Date now = new Date();
        userPaperVo.setUserId(user.getId());
        TrainingPapersVo papersVo = new TrainingPapersVo();
        Integer isReview = 0;
        ArrayList<TrainingUserQuestionVo> userQuestionVoList = new ArrayList<TrainingUserQuestionVo>();
        TrainingPaper paper = (TrainingPaper)this.trainingPaperMapper.selectById(userPaperVo.getTrainingPaperId());
        if (!ObjectUtils.isEmpty((Object)paper)) {
            BeanUtils.copyProperties((Object)paper, (Object)papersVo);
        }
        TrainingUserPaper userPaper = new TrainingUserPaper();
        LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper1.eq(TrainingUserPaper::getLoginUserId, (Object)user.getId())).eq(TrainingUserPaper::getTrainingPaperId, (Object)userPaperVo.getTrainingPaperId())).eq(TrainingUserPaper::getPaperStatus, (Object)0)).orderByDesc(TrainingUserPaper::getId);
        List userPapers = this.trainingUserPaperMapper.selectList((Wrapper)wrapper1);
        if (!CollectionUtils.isEmpty((Collection)userPapers) && !ObjectUtils.isEmpty(userPapers.get(0))) {
            userPaper = (TrainingUserPaper)userPapers.get(0);
            LambdaQueryWrapper wrapper2 = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper2.eq(TrainingUserQuestion::getUserPaperId, (Object)userPaper.getId())).eq(TrainingUserQuestion::getPaperId, (Object)userPaperVo.getTrainingPaperId())).eq(TrainingUserQuestion::getUserId, (Object)user.getId());
            List userQuestionList = this.trainingUserQuestionMapper.selectList((Wrapper)wrapper2);
            if (!CollectionUtils.isEmpty((Collection)userQuestionList)) {
                Map<Object, Object> picMap = new HashMap();
                ArrayList<Integer> userQuestionIdList = new ArrayList<Integer>();
                for (TrainingUserQuestion userQuestion : userQuestionList) {
                    if (userQuestion.getQuestionType() != 1) continue;
                    userQuestionIdList.add(userQuestion.getId());
                    isReview = 1;
                }
                if (!CollectionUtils.isEmpty(userQuestionIdList)) {
                    LambdaQueryWrapper wrapper3 = new LambdaQueryWrapper();
                    ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper3.in(TrainingUserQuestionPicture::getUserQuestionId, userQuestionIdList)).eq(TrainingUserQuestionPicture::getPictureType, (Object)1)).eq(TrainingUserQuestionPicture::getIsDelete, (Object)0);
                    List userQuestionPictures = this.trainingUserQuestionPictureMapper.selectList((Wrapper)wrapper3);
                    if (!CollectionUtils.isEmpty((Collection)userQuestionPictures)) {
                        picMap = userQuestionPictures.stream().collect(Collectors.groupingBy(TrainingUserQuestionPicture::getUserQuestionId));
                    }
                }
                List optionsList = new ArrayList();
                TrainingUserQuestionVo userQuestionVo = null;
                for (TrainingUserQuestion userQuestion : userQuestionList) {
                    userQuestionVo = new TrainingUserQuestionVo();
                    BeanUtils.copyProperties((Object)userQuestion, (Object)userQuestionVo);
                    if (!StringUtils.isEmpty((Object)userQuestionVo.getOptionsData())) {
                        optionsList = JSONObject.parseArray((String)userQuestionVo.getOptionsData(), TrainingOptionsVo.class);
                        if (userQuestion.getQuestionType() == 4) {
                            // empty if block
                        }
                    }
                    userQuestionVo.setOptionsVoList(optionsList);
                    userQuestionVo.setOptionsData(null);
                    if (userQuestion.getQuestionType() == 1) {
                        List questionPictureList = (List)picMap.get(userQuestion.getId());
                        userQuestionVo.setUserQuestionPictureList(questionPictureList);
                    }
                    userQuestionVoList.add(userQuestionVo);
                }
            }
            if (StringUtils.isEmpty((Object)userPaper.getUpdateTime())) {
                userPaper.setUpdateTime(now);
            }
            userPaper.setIsReview(isReview);
            userPaper.setSourceType(Integer.valueOf(2));
            userPaper.setSourceProjectId(papersVo.getId());
            this.trainingUserPaperMapper.updateById(userPaper);
        } else {
            userPaper = this.savePaperLoginUser(userPaper, userPaperVo);
            userPaper.setCreateTime(now);
            userPaper.setUpdateTime(now);
            userPaper.setTitle(papersVo.getTitle());
            userPaper.setPicUrl(papersVo.getPicUrl());
            userPaper.setTrainingPaperId(papersVo.getId());
            userPaper.setUserPaperType(Integer.valueOf(1));
            userPaper.setLoginUserId(user.getId());
            userPaper.setScore(BigDecimal.ZERO);
            userPaper.setPaperStatus(Integer.valueOf(0));
            userPaper.setPaperCreateTime(now);
            userPaper.setEnterpriseId(papersVo.getEnterpriseId());
            userPaper.setTrainingNavId(papersVo.getTrainingNavId());
            userPaper.setLookLevel(papersVo.getLookLevel());
            userPaper.setPaperCount(Integer.valueOf(papersVo.getRepetitionNum() == null ? 999 : papersVo.getRepetitionNum()));
            userPaper.setSourceType(Integer.valueOf(2));
            userPaper.setSourceProjectId(papersVo.getId());
            this.trainingUserPaperMapper.insert(userPaper);
        }
        if (CollectionUtils.isEmpty(userQuestionVoList)) {
            TrainingExam trainExam = (TrainingExam)this.trainingExamMapper.selectById(paper.getExamId());
            if (!ObjectUtils.isEmpty((Object)trainExam)) {
                if (trainExam.getExamClass() == 1) {
                    userQuestionVoList.addAll(this.getFixedUserQuestionList(userPaperVo, paper, userPaper));
                } else {
                    userQuestionVoList.addAll(this.getRandomUserQuestionList(trainExam, userPaperVo, paper, userPaper));
                }
            }
            if (!CollectionUtils.isEmpty(userQuestionVoList)) {
                TrainingUserQuestion userQuestion = null;
                for (TrainingUserQuestionVo userQuestionVo : userQuestionVoList) {
                    userQuestion = new TrainingUserQuestion();
                    BeanUtils.copyProperties((Object)userQuestionVo, (Object)userQuestion);
                    if (userQuestion.getQuestionType() == 1) {
                        isReview = 1;
                    }
                    this.trainingUserQuestionMapper.insert(userQuestion);
                    userQuestionVo.setId(userQuestion.getId());
                }
                userPaper.setIsReview(isReview);
                this.trainingUserPaperMapper.updateById(userPaper);
            }
        }
        papersVo.setUserQuestionVoList(userQuestionVoList);
        return JsonResult.success((Object)papersVo);
    }

    private List<TrainingUserQuestionVo> getFixedUserQuestionList(TrainingUserPaperVo userPaperVo, TrainingPaper paper, TrainingUserPaper userPaper) {
        Date now = new Date();
        ArrayList<TrainingUserQuestionVo> userQuestionVoList = new ArrayList<TrainingUserQuestionVo>();
        LambdaQueryWrapper wrapper3 = new LambdaQueryWrapper();
        wrapper3.eq(TrainingExamQuestion::getExamId, (Object)paper.getExamId());
        ArrayList<TrainingExamQuestion> examQuestions = this.trainingExamQuestionMapper.selectList((Wrapper)wrapper3);
        if (!CollectionUtils.isEmpty((Collection)examQuestions)) {
            ArrayList<TrainingExamQuestion> singleList = new ArrayList<TrainingExamQuestion>();
            ArrayList<TrainingExamQuestion> essayList = new ArrayList<TrainingExamQuestion>();
            ArrayList<TrainingExamQuestion> fillList = new ArrayList<TrainingExamQuestion>();
            ArrayList<TrainingExamQuestion> multipleList = new ArrayList<TrainingExamQuestion>();
            ArrayList<TrainingExamQuestion> judgeList = new ArrayList<TrainingExamQuestion>();
            for (TrainingExamQuestion trainingExamQuestion : examQuestions) {
                if (trainingExamQuestion.getQuestionType() == 0) {
                    singleList.add(trainingExamQuestion);
                    continue;
                }
                if (trainingExamQuestion.getQuestionType() == 1) {
                    essayList.add(trainingExamQuestion);
                    continue;
                }
                if (trainingExamQuestion.getQuestionType() == 2) {
                    fillList.add(trainingExamQuestion);
                    continue;
                }
                if (trainingExamQuestion.getQuestionType() == 3) {
                    multipleList.add(trainingExamQuestion);
                    continue;
                }
                if (trainingExamQuestion.getQuestionType() != 4) continue;
                judgeList.add(trainingExamQuestion);
            }
            ArrayList<TrainingExamQuestion> examQuestions1 = new ArrayList<TrainingExamQuestion>();
            ArrayList<TrainingExamQuestion> examQuestions2 = new ArrayList<TrainingExamQuestion>();
            if (paper.getIsQuestion() != null && paper.getIsQuestion() == 1) {
                examQuestions = new ArrayList<TrainingExamQuestion>();
                if (!CollectionUtils.isEmpty(singleList)) {
                    Collections.shuffle(singleList);
                    examQuestions.addAll(singleList);
                    examQuestions1.addAll(singleList);
                }
                if (!CollectionUtils.isEmpty(multipleList)) {
                    Collections.shuffle(multipleList);
                    examQuestions.addAll(multipleList);
                    examQuestions1.addAll(multipleList);
                }
                if (!CollectionUtils.isEmpty(judgeList)) {
                    Collections.shuffle(judgeList);
                    examQuestions.addAll(judgeList);
                    examQuestions1.addAll(judgeList);
                }
                if (!CollectionUtils.isEmpty(fillList)) {
                    Collections.shuffle(fillList);
                    examQuestions.addAll(fillList);
                    examQuestions2.addAll(fillList);
                }
                if (!CollectionUtils.isEmpty(essayList)) {
                    Collections.shuffle(essayList);
                    examQuestions.addAll(essayList);
                    examQuestions2.addAll(essayList);
                }
            } else {
                if (!CollectionUtils.isEmpty(singleList)) {
                    examQuestions1.addAll(singleList);
                }
                if (!CollectionUtils.isEmpty(multipleList)) {
                    examQuestions1.addAll(multipleList);
                }
                if (!CollectionUtils.isEmpty(judgeList)) {
                    examQuestions1.addAll(judgeList);
                }
                if (!CollectionUtils.isEmpty(fillList)) {
                    examQuestions2.addAll(fillList);
                }
                if (!CollectionUtils.isEmpty(essayList)) {
                    examQuestions2.addAll(essayList);
                }
            }
            List questionIds1 = examQuestions1.stream().map(TrainingExamQuestion::getId).collect(Collectors.toList());
            List questionIds2 = examQuestions2.stream().map(TrainingExamQuestion::getId).collect(Collectors.toList());
            ArrayList<TrainingOptionsVo> optionList1 = new ArrayList<TrainingOptionsVo>();
            if (!CollectionUtils.isEmpty(questionIds1)) {
                LambdaQueryWrapper wrapper4 = new LambdaQueryWrapper();
                wrapper4.in(TrainingExamOptions::getExamQuestionId, questionIds1);
                List examOptionsList1 = this.trainingExamOptionsMapper.selectList((Wrapper)wrapper4);
                if (!CollectionUtils.isEmpty((Collection)examOptionsList1)) {
                    TrainingOptionsVo optionsVo = null;
                    for (Object examOptions : examOptionsList1) {
                        optionsVo = new TrainingOptionsVo();
                        optionsVo.setId(examOptions.getId());
                        optionsVo.setOptionsName(examOptions.getContent());
                        optionsVo.setIsAnswer(examOptions.getIsAnswer());
                        optionsVo.setQuestionId(examOptions.getExamQuestionId());
                        optionsVo.setPicturePath(examOptions.getPicturePath());
                        optionList1.add(optionsVo);
                    }
                }
            }
            ArrayList<TrainingOptionsVo> optionList2 = new ArrayList<TrainingOptionsVo>();
            if (!CollectionUtils.isEmpty(questionIds2)) {
                LambdaQueryWrapper wrapper5 = new LambdaQueryWrapper();
                wrapper5.in(TrainingExamOptions::getExamQuestionId, questionIds2);
                List examOptionsList2 = this.trainingExamOptionsMapper.selectList((Wrapper)wrapper5);
                if (!CollectionUtils.isEmpty((Collection)examOptionsList2)) {
                    TrainingOptionsVo optionsVo = null;
                    for (TrainingExamOptions examOptions : examOptionsList2) {
                        optionsVo = new TrainingOptionsVo();
                        optionsVo.setId(examOptions.getId());
                        optionsVo.setOptionsName(examOptions.getContent());
                        optionsVo.setIsAnswer(examOptions.getIsAnswer());
                        optionsVo.setQuestionId(examOptions.getExamQuestionId());
                        optionsVo.setPicturePath(examOptions.getPicturePath());
                        optionList2.add(optionsVo);
                    }
                }
            }
            ArrayList<TrainingOptionsVo> optionList = new ArrayList<TrainingOptionsVo>();
            Map<Object, Object> optionMap = new HashMap();
            if (!CollectionUtils.isEmpty(optionList1)) {
                if (paper.getIsOption() != null && paper.getIsOption() == 1) {
                    Collections.shuffle(optionList1);
                }
                optionList.addAll(optionList1);
            }
            if (!CollectionUtils.isEmpty(optionList2)) {
                optionList.addAll(optionList2);
            }
            if (!CollectionUtils.isEmpty(optionList)) {
                optionMap = optionList.stream().collect(Collectors.groupingBy(TrainingOptionsVo::getQuestionId));
            }
            TrainingUserQuestionVo userQuestionVo = null;
            TrainingOptionsVo vo = null;
            for (TrainingExamQuestion examQuestion : examQuestions) {
                userQuestionVo = new TrainingUserQuestionVo();
                userQuestionVo.setCreateTime(now);
                userQuestionVo.setUpdateTime(now);
                userQuestionVo.setName(examQuestion.getContent());
                userQuestionVo.setUserId(userPaperVo.getUserId());
                userQuestionVo.setQuestionId(examQuestion.getId());
                userQuestionVo.setPaperId(paper.getId());
                userQuestionVo.setUserPaperId(userPaper.getId());
                userQuestionVo.setIsCorrect(Integer.valueOf(0));
                userQuestionVo.setEnterpriseId(paper.getEnterpriseId());
                userQuestionVo.setQuestionType(examQuestion.getQuestionType());
                userQuestionVo.setPicturePath(examQuestion.getPicturePath());
                userQuestionVo.setRemark(examQuestion.getRemark());
                userQuestionVo.setOriginScore(examQuestion.getScore());
                userQuestionVo.setIsEmpty(Integer.valueOf(1));
                userQuestionVo.setScore(BigDecimal.ZERO);
                userQuestionVo.setIsUpload(examQuestion.getIsUpload());
                ArrayList<TrainingOptionsVo> optionsList = (ArrayList<TrainingOptionsVo>)optionMap.get(examQuestion.getId());
                if (CollectionUtils.isEmpty((Collection)optionsList)) {
                    optionsList = new ArrayList<TrainingOptionsVo>();
                }
                if (!StringUtils.isEmpty((Object)examQuestion.getQuestionType()) && examQuestion.getQuestionType() == 4 && !CollectionUtils.isEmpty(optionsList) && optionsList.size() == 1) {
                    TrainingOptionsVo vos = (TrainingOptionsVo)optionsList.get(0);
                    vo = new TrainingOptionsVo();
                    vo.setIsAnswer(Integer.valueOf(0));
                    vo.setQuestionId(vos.getQuestionId());
                    vo.setOptionsName(vos.getOptionsName().trim().equals("1") ? "0" : "1");
                    if (vos.getOptionsName().trim().equals("1")) {
                        optionsList.add(vo);
                    } else {
                        optionsList = new ArrayList();
                        optionsList.add(vo);
                        optionsList.add(vos);
                    }
                    if (paper.getIsOption() != null && paper.getIsOption() == 1) {
                        Collections.shuffle(optionsList);
                    }
                }
                userQuestionVo.setOptionsVoList(optionsList);
                userQuestionVo.setOptionsData(JSONArray.toJSONString(optionsList));
                userQuestionVoList.add(userQuestionVo);
            }
        }
        return userQuestionVoList;
    }

    private List<TrainingUserQuestionVo> getRandomUserQuestionList(TrainingExam trainExam, TrainingUserPaperVo userPaperVo, TrainingPaper paper, TrainingUserPaper userPaper) {
        ArrayList<TrainingUserQuestionVo> userQuestionVoList = new ArrayList<TrainingUserQuestionVo>();
        Date now = new Date();
        ArrayList<Integer> trainingQuestionType = new ArrayList();
        if (trainExam.getTrainingQuestion() != null) {
            String[] quess = trainExam.getTrainingQuestion().split(",");
            trainingQuestionType = Arrays.asList(quess).stream().map(Integer::parseInt).collect(Collectors.toList());
        }
        LambdaQueryWrapper wrapper3 = new LambdaQueryWrapper();
        wrapper3.eq(TrainingPaperRandom::getExamId, (Object)trainExam.getId());
        List trainingPaperRandoms = this.trainingPaperRandomMapper.selectList((Wrapper)wrapper3);
        ArrayList<TrainingQuestionVo> questionVoList = new ArrayList<TrainingQuestionVo>();
        if (!CollectionUtils.isEmpty((Collection)trainingPaperRandoms)) {
            TrainingQuestionVo trainingQuestionVo = null;
            for (TrainingPaperRandom trainingPaperRandom : trainingPaperRandoms) {
                List<TrainingQuestion> qList = this.trainingQuestionMapper.selectRandByQuestionTypes(trainingPaperRandom.getQuestionType(), trainExam.getEnterpriseId(), trainingPaperRandom.getQuestionTypeNum(), trainingQuestionType);
                for (TrainingQuestion trainingQuestion : qList) {
                    trainingQuestionVo = new TrainingQuestionVo();
                    trainingQuestionVo.setId(trainingQuestion.getId());
                    trainingQuestionVo.setQuestionName(trainingQuestion.getName());
                    trainingQuestionVo.setRemark(trainingQuestion.getRemark());
                    trainingQuestionVo.setQuestionType(trainingQuestion.getQuestionType());
                    trainingQuestionVo.setScore(Double.valueOf(Double.parseDouble(trainingPaperRandom.getQuestionScore() + "")));
                    trainingQuestionVo.setPicturePath(trainingQuestion.getPicturePath());
                    questionVoList.add(trainingQuestionVo);
                }
            }
        }
        List questionIds = questionVoList.stream().map(TrainingQuestion::getId).collect(Collectors.toList());
        Map<Object, Object> questionMap = new HashMap();
        Map<Object, Object> optionMap = new HashMap();
        if (!CollectionUtils.isEmpty(questionIds)) {
            List questionList = this.trainingQuestionMapper.selectBatchIds(questionIds);
            questionMap = questionList.stream().collect(Collectors.toMap(TrainingQuestion::getId, Function.identity()));
            List<Integer> questionList1 = questionList.stream().filter(e -> e.getQuestionType() == 0 || e.getQuestionType() == 3 || e.getQuestionType() == 4).map(TrainingQuestion::getId).collect(Collectors.toList());
            ArrayList<Integer> questionList2 = new ArrayList<Integer>(questionIds);
            questionList2.removeAll(questionList1);
            ArrayList<TrainingOptionsVo> optionList = new ArrayList<TrainingOptionsVo>();
            if (!CollectionUtils.isEmpty(questionList1)) {
                List<TrainingOptionsVo> optionList1 = this.trainingOptionsMapper.selectOptionsByQuestionId(questionList1);
                if (paper.getIsOption() != null && paper.getIsOption() == 1) {
                    Collections.shuffle(optionList1);
                }
                optionList.addAll(optionList1);
            }
            if (!CollectionUtils.isEmpty(questionList2)) {
                List<TrainingOptionsVo> optionList2 = this.trainingOptionsMapper.selectOptionsByQuestionId(questionList2);
                optionList.addAll(optionList2);
            }
            if (!CollectionUtils.isEmpty(optionList)) {
                optionMap = optionList.stream().collect(Collectors.groupingBy(TrainingOptionsVo::getQuestionId));
            }
        }
        TrainingUserQuestionVo userQuestionVo = null;
        TrainingOptionsVo vo1 = null;
        TrainingOptionsVo vo2 = null;
        for (TrainingQuestionVo questionVo : questionVoList) {
            TrainingQuestion question = (TrainingQuestion)questionMap.get(questionVo.getId());
            userQuestionVo = new TrainingUserQuestionVo();
            userQuestionVo.setCreateTime(now);
            userQuestionVo.setUpdateTime(now);
            userQuestionVo.setName(question.getName());
            userQuestionVo.setUserId(userPaperVo.getUserId());
            userQuestionVo.setQuestionId(question.getId());
            userQuestionVo.setPaperId(paper.getId());
            userQuestionVo.setUserPaperId(userPaper.getId());
            userQuestionVo.setIsCorrect(Integer.valueOf(0));
            userQuestionVo.setPicturePath(questionVo.getPicturePath());
            userQuestionVo.setRemark(question.getRemark());
            userQuestionVo.setEnterpriseId(paper.getEnterpriseId());
            userQuestionVo.setQuestionType(question.getQuestionType());
            userQuestionVo.setOriginScore(new BigDecimal(questionVo.getScore()));
            userQuestionVo.setScore(new BigDecimal(0));
            userQuestionVo.setIsEmpty(Integer.valueOf(1));
            userQuestionVo.setIsUpload(question.getIsUpload());
            ArrayList<TrainingOptionsVo> optionsList = (ArrayList<TrainingOptionsVo>)optionMap.get(questionVo.getId());
            if (CollectionUtils.isEmpty((Collection)optionsList)) {
                optionsList = new ArrayList<TrainingOptionsVo>();
            }
            if (!StringUtils.isEmpty((Object)question.getQuestionType()) && question.getQuestionType() == 4) {
                optionsList = new ArrayList();
                vo1 = new TrainingOptionsVo();
                vo1.setIsAnswer(Integer.valueOf(1));
                vo1.setOptionsName(question.getIsCorrect().toString());
                vo1.setQuestionId(question.getId());
                vo2 = new TrainingOptionsVo();
                vo2.setIsAnswer(Integer.valueOf(0));
                vo2.setOptionsName(question.getIsCorrect() == 1 ? "0" : "1");
                vo2.setQuestionId(question.getId());
                if (question.getIsCorrect() == 1) {
                    optionsList.add(vo1);
                    optionsList.add(vo2);
                } else {
                    optionsList.add(vo2);
                    optionsList.add(vo1);
                }
                if (paper.getIsOption() != null && paper.getIsOption() == 1) {
                    Collections.shuffle(optionsList);
                }
            }
            userQuestionVo.setOptionsVoList(optionsList);
            userQuestionVo.setOptionsData(JSONArray.toJSONString(optionsList));
            userQuestionVoList.add(userQuestionVo);
        }
        return userQuestionVoList;
    }

    @Override
    public TrainingUserPaper saveUserQuestionsVisitor(List<TrainingUserQuestionVo> userQuestionVoList, Users user) {
        Date now = new Date();
        TrainingUserPaper userPaper = new TrainingUserPaper();
        if (!CollectionUtils.isEmpty(userQuestionVoList) && !ObjectUtils.isEmpty((Object)userQuestionVoList.get(0))) {
            TrainingUserQuestionVo userQuestionVo = userQuestionVoList.get(0);
            userPaper = (TrainingUserPaper)this.trainingUserPaperMapper.selectById(userQuestionVo.getUserPaperId());
            userPaper.setIsAutoRead(Integer.valueOf(1));
            userPaper.setPaperStatus(Integer.valueOf(2));
            BigDecimal totalScore = BigDecimal.ZERO;
            ArrayList<Integer> userQuestionIdList = new ArrayList<Integer>();
            ArrayList<TrainingUserQuestionPicture> userQuestionPictureList = new ArrayList<TrainingUserQuestionPicture>();
            TrainingPaper trainingPaper = (TrainingPaper)this.trainingPaperMapper.selectById(userPaper.getTrainingPaperId());
            TrainingExam exam = null;
            if (!ObjectUtils.isEmpty((Object)trainingPaper) && trainingPaper.getExamId() != null) {
                exam = (TrainingExam)this.trainingExamMapper.selectById(trainingPaper.getExamId());
            }
            for (TrainingUserQuestionVo userQuestion : userQuestionVoList) {
                Object object;
                Object object2;
                userQuestion.setUserId(userPaper.getLoginUserId());
                userQuestion.setIsCorrect(Integer.valueOf(0));
                userQuestion.setScore(new BigDecimal(0));
                ArrayList optionsList = userQuestion.getOptionsVoList();
                if (CollectionUtils.isEmpty((Collection)optionsList)) {
                    optionsList = new ArrayList();
                } else if (!ObjectUtils.isEmpty((Object)trainingPaper)) {
                    List list;
                    if (trainingPaper.getExamId() != null) {
                        if (exam.getExamClass().equals(1)) {
                            LambdaQueryWrapper optionsWrapper = new LambdaQueryWrapper();
                            optionsWrapper.eq(TrainingExamOptions::getExamQuestionId, (Object)userQuestion.getQuestionId());
                            list = this.trainingExamOptionsMapper.selectList((Wrapper)optionsWrapper);
                            if (!CollectionUtils.isEmpty((Collection)list)) {
                                for (TrainingOptions options : list) {
                                    for (TrainingOptionsVo optionsVo : optionsList) {
                                        if (!options.getId().equals(optionsVo.getId())) continue;
                                        optionsVo.setIsAnswer(options.getIsAnswer());
                                    }
                                }
                            }
                        } else {
                            LambdaQueryWrapper optionsWrapper = new LambdaQueryWrapper();
                            optionsWrapper.eq(TrainingOptions::getTrainingQuestionId, (Object)userQuestion.getQuestionId());
                            list = this.trainingOptionsMapper.selectList((Wrapper)optionsWrapper);
                            if (!CollectionUtils.isEmpty((Collection)list)) {
                                for (TrainingOptions options : list) {
                                    for (TrainingOptionsVo optionsVo : optionsList) {
                                        if (!options.getId().equals(optionsVo.getId())) continue;
                                        optionsVo.setIsAnswer(options.getIsAnswer());
                                    }
                                }
                            }
                        }
                    } else {
                        LambdaQueryWrapper optionsWrapper = new LambdaQueryWrapper();
                        optionsWrapper.eq(TrainingOptions::getTrainingQuestionId, (Object)userQuestion.getQuestionId());
                        list = this.trainingOptionsMapper.selectList((Wrapper)optionsWrapper);
                        if (!CollectionUtils.isEmpty((Collection)list)) {
                            for (TrainingOptions options : list) {
                                for (TrainingOptionsVo optionsVo : optionsList) {
                                    if (!options.getId().equals(optionsVo.getId())) continue;
                                    optionsVo.setIsAnswer(options.getIsAnswer());
                                }
                            }
                        }
                    }
                }
                if (!CollectionUtils.isEmpty(optionsList) && userQuestion.getQuestionType() == 0) {
                    for (Object vo : optionsList) {
                        if (StringUtils.isEmpty((Object)vo.getIsSelect()) || vo.getIsSelect() != 1 || StringUtils.isEmpty((Object)vo.getIsAnswer()) || vo.getIsAnswer() != 1) continue;
                        userQuestion.setIsCorrect(Integer.valueOf(1));
                        userQuestion.setScore(userQuestion.getOriginScore());
                    }
                } else if (userQuestion.getQuestionType() == 1) {
                    userPaper.setIsReview(Integer.valueOf(1));
                    if (!(ObjectUtils.isEmpty((Object)trainingPaper) || trainingPaper.getIsAutoRead() == null || !trainingPaper.getIsAutoRead().equals(1) || CollectionUtils.isEmpty(optionsList) || optionsList.size() == 1 && StringUtils.isEmpty((Object)((TrainingOptionsVo)optionsList.get(0)).getOptionsName()))) {
                        int rightNum = 0;
                        String answer = ((TrainingOptionsVo)optionsList.get(0)).getAnswer();
                        block8: for (Object vo2 : optionsList) {
                            if (StringUtils.isEmpty((Object)answer) || StringUtils.isEmpty((Object)vo2.getOptionsName())) continue;
                            List<String> optionsLists = StringsUtils.String2List(vo2.getOptionsName(), "&");
                            for (String option : optionsLists) {
                                if (!answer.contains(option)) continue;
                                ++rightNum;
                                continue block8;
                            }
                        }
                        userQuestion.setIsReviewed(Integer.valueOf(1));
                        userQuestion.setScore(new BigDecimal(userQuestion.getOriginScore().intValue() * rightNum / optionsList.size()));
                        if (rightNum == optionsList.size()) {
                            userQuestion.setIsCorrect(Integer.valueOf(1));
                        }
                        userPaper.setMarkingTime(now);
                        userPaper.setIsAutoRead(Integer.valueOf(1));
                    } else {
                        userPaper.setPaperStatus(Integer.valueOf(1));
                        userQuestionIdList.add(userQuestion.getId());
                        if (!CollectionUtils.isEmpty(optionsList)) {
                            block10: for (Object vo : optionsList) {
                                Object vo2;
                                if (StringUtils.isEmpty((Object)vo.getAnswer()) || StringUtils.isEmpty((Object)vo.getOptionsName())) continue;
                                List<String> optionsLists = StringsUtils.String2List(vo.getOptionsName(), "&");
                                vo2 = optionsLists.iterator();
                                while (vo2.hasNext()) {
                                    String option = (String)vo2.next();
                                    if (!vo.getAnswer().contains(option)) continue;
                                    continue block10;
                                }
                            }
                        }
                    }
                } else if (!CollectionUtils.isEmpty(optionsList) && userQuestion.getQuestionType() == 2) {
                    if (!ObjectUtils.isEmpty((Object)trainingPaper) && trainingPaper.getIsGapAutoRead() != null && trainingPaper.getIsGapAutoRead().equals(0)) {
                        userPaper.setPaperStatus(Integer.valueOf(1));
                        userPaper.setIsReview(Integer.valueOf(1));
                        userQuestion.setIsReviewed(Integer.valueOf(0));
                    } else {
                        Object vo;
                        userQuestion.setIsReviewed(Integer.valueOf(1));
                        Integer correctNum = 0;
                        vo = optionsList.iterator();
                        while (vo.hasNext()) {
                            List<String> optionsLists;
                            TrainingOptionsVo vo3 = (TrainingOptionsVo)vo.next();
                            if (StringUtils.isEmpty((Object)vo3.getAnswer()) || StringUtils.isEmpty((Object)vo3.getOptionsName()) || !(optionsLists = StringsUtils.String2List(vo3.getOptionsName(), "&")).contains(vo3.getAnswer().trim())) continue;
                            object2 = correctNum;
                            correctNum = correctNum + 1;
                            object = correctNum;
                            vo3.setIsAnswer(Integer.valueOf(1));
                        }
                        if (correctNum > 0) {
                            if (correctNum.intValue() == optionsList.size()) {
                                userQuestion.setIsCorrect(Integer.valueOf(1));
                            }
                            userQuestion.setScore(userQuestion.getOriginScore().multiply(new BigDecimal(correctNum)).divide(new BigDecimal(optionsList.size()), 1, 4));
                        }
                    }
                } else if (!CollectionUtils.isEmpty(optionsList) && userQuestion.getQuestionType() == 3) {
                    Integer questionNum = 0;
                    Integer correctNum = 0;
                    for (Object vo2 : optionsList) {
                        if (!StringUtils.isEmpty((Object)vo2.getIsAnswer()) && vo2.getIsAnswer() == 1) {
                            object2 = questionNum;
                            questionNum = questionNum + 1;
                            object = questionNum;
                            if (StringUtils.isEmpty((Object)vo2.getIsSelect()) || vo2.getIsSelect() != 1) continue;
                            object2 = correctNum;
                            correctNum = correctNum + 1;
                            object = correctNum;
                            continue;
                        }
                        if (StringUtils.isEmpty((Object)vo2.getIsSelect()) || vo2.getIsSelect() != 1) continue;
                        object2 = correctNum;
                        correctNum = correctNum - 1;
                        object = correctNum;
                    }
                    if (correctNum > 0 && questionNum == correctNum) {
                        userQuestion.setIsCorrect(Integer.valueOf(1));
                        userQuestion.setScore(userQuestion.getOriginScore());
                    }
                } else if (!CollectionUtils.isEmpty(optionsList) && userQuestion.getQuestionType() == 4) {
                    for (Object vo : optionsList) {
                        if (StringUtils.isEmpty((Object)vo.getIsSelect()) || vo.getIsSelect() != 1 || StringUtils.isEmpty((Object)vo.getIsAnswer()) || vo.getIsAnswer() != 1) continue;
                        userQuestion.setIsCorrect(Integer.valueOf(1));
                        userQuestion.setScore(userQuestion.getOriginScore());
                    }
                }
                userQuestion.setOptionsData(JSONArray.toJSONString(optionsList));
                this.trainingUserQuestionMapper.updateById(userQuestion);
                if (!CollectionUtils.isEmpty((Collection)userQuestion.getUserQuestionPictureList())) {
                    for (TrainingUserQuestionPicture userQuestionPicture : userQuestion.getUserQuestionPictureList()) {
                        userQuestionPicture.setUserQuestionId(userQuestion.getId());
                        userQuestionPicture.setPictureType(Integer.valueOf(1));
                        userQuestionPicture.setCreateTime(now);
                        userQuestionPicture.setEnterpriseId(userPaper.getEnterpriseId());
                        userQuestionPicture.setIsDelete(Integer.valueOf(0));
                        userQuestionPictureList.add(userQuestionPicture);
                    }
                }
                totalScore = totalScore.add(userQuestion.getScore());
            }
            if (!CollectionUtils.isEmpty(userQuestionIdList)) {
                LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
                ((LambdaUpdateWrapper)wrapper.in(TrainingUserQuestionPicture::getUserQuestionId, userQuestionIdList)).eq(TrainingUserQuestionPicture::getIsDelete, (Object)0);
                TrainingUserQuestionPicture questionPicture = new TrainingUserQuestionPicture();
                questionPicture.setIsDelete(Integer.valueOf(1));
                this.trainingUserQuestionPictureMapper.update(questionPicture, (Wrapper)wrapper);
            }
            if (!CollectionUtils.isEmpty(userQuestionPictureList)) {
                this.trainingUserQuestionPictureMapper.insertList(userQuestionPictureList);
            }
            userPaper.setSubmitTime(now);
            userPaper.setScore(totalScore);
            this.trainingUserPaperMapper.updateById(userPaper);
        }
        if (!StringUtils.isEmpty((Object)userPaper.getIsReview()) && userPaper.getIsReview() == 1) {
            this.savePaperReviewer(userPaper);
        }
        return userPaper;
    }

    public void savePaperReviewer(TrainingUserPaper trainingUserPaper) {
        TrainingPaper trainingPaper;
        if (!ObjectUtils.isEmpty((Object)trainingUserPaper) && trainingUserPaper.getTrainingPaperId() != null && !ObjectUtils.isEmpty((Object)(trainingPaper = (TrainingPaper)this.trainingPaperMapper.selectById(trainingUserPaper.getTrainingPaperId())))) {
            Date now = new Date();
            ArrayList<TrainingPaperReviewer> trainingPaperReviewerList = new ArrayList<TrainingPaperReviewer>();
            TrainingPaperReviewer trainingPaperReviewer = null;
            if (trainingPaper.getReviewerType() == 4) {
                LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)wrapper1.eq(TrainingExaminer::getTrainingPaperId, (Object)trainingPaper.getId())).eq(TrainingExaminer::getEnterpriseId, (Object)trainingPaper.getEnterpriseId());
                List trainingExaminerList = this.trainingExaminerMapper.selectList((Wrapper)wrapper1);
                if (!CollectionUtils.isEmpty((Collection)trainingExaminerList)) {
                    for (TrainingExaminer trainingExaminer : trainingExaminerList) {
                        trainingPaperReviewer = new TrainingPaperReviewer();
                        trainingPaperReviewer.setUserId(trainingExaminer.getUserId());
                        trainingPaperReviewer.setUserPaperId(trainingUserPaper.getId());
                        trainingPaperReviewer.setEnterpriseId(trainingUserPaper.getEnterpriseId());
                        trainingPaperReviewer.setCreateTime(now);
                        trainingPaperReviewerList.add(trainingPaperReviewer);
                    }
                }
            }
            if (CollectionUtils.isEmpty(trainingPaperReviewerList)) {
                trainingPaperReviewer = new TrainingPaperReviewer();
                trainingPaperReviewer.setUserId(trainingPaper.getCreater());
                trainingPaperReviewer.setUserPaperId(trainingUserPaper.getId());
                trainingPaperReviewer.setEnterpriseId(trainingUserPaper.getEnterpriseId());
                trainingPaperReviewer.setCreateTime(now);
                trainingPaperReviewerList.add(trainingPaperReviewer);
            }
            if (!CollectionUtils.isEmpty(trainingPaperReviewerList)) {
                this.trainingPaperReviewerMapper.insertList(trainingPaperReviewerList);
            }
        }
    }

    @Override
    public TrainingUserPaperVo selectUserPaperResultVisitor(TrainingUserPaper userPaper, Users user) {
        TrainingUserPaperVo userPaperVo = new TrainingUserPaperVo();
        if (!ObjectUtils.isEmpty((Object)(userPaper = (TrainingUserPaper)this.trainingUserPaperMapper.selectById(userPaper.getId())))) {
            TrainingExam exam;
            BeanUtils.copyProperties((Object)userPaper, (Object)userPaperVo);
            TrainingPaper paper = (TrainingPaper)this.trainingPaperMapper.selectById(userPaper.getTrainingPaperId());
            if (paper.getIsAutoRead() != null && paper.getIsAutoRead() == 1) {
                userPaperVo.setIsAutoRead(paper.getIsAutoRead());
            } else {
                userPaperVo.setIsAutoRead(Integer.valueOf(0));
            }
            Integer paperCount = paper.getRepetitionNum() == null ? 999 : paper.getRepetitionNum();
            Integer scoreSelect = paper.getScoreSelect() == null ? 1 : paper.getScoreSelect();
            userPaperVo.setScoreSelect(scoreSelect);
            Integer passLine = paper.getPassLine() == null ? 60 : paper.getPassLine();
            BigDecimal totalScore = new BigDecimal(100);
            if (paper.getExamId() != null && !ObjectUtils.isEmpty((Object)(exam = (TrainingExam)this.trainingExamMapper.selectById(paper.getExamId())))) {
                totalScore = exam.getScore();
            }
            LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper1.eq(TrainingUserPaper::getLoginUserId, (Object)userPaper.getLoginUserId())).eq(TrainingUserPaper::getTrainingPaperId, (Object)userPaper.getTrainingPaperId())).orderByDesc(TrainingUserPaper::getId);
            List userPaperList = this.trainingUserPaperMapper.selectList((Wrapper)wrapper1);
            Integer paperNum = 0;
            BigDecimal actScore = new BigDecimal(0);
            if (!CollectionUtils.isEmpty((Collection)userPaperList)) {
                paperNum = userPaperList.size();
                paperCount = paperCount - paperNum;
                if (!CollectionUtils.isEmpty((Collection)userPaperList)) {
                    for (int i = 0; i < userPaperList.size(); ++i) {
                        TrainingUserPaper up = (TrainingUserPaper)userPaperList.get(i);
                        if (!up.getPaperStatus().equals(2)) continue;
                        if (scoreSelect == 1) {
                            actScore = up.getScore();
                            break;
                        }
                        if (!(up.getScore().doubleValue() > actScore.doubleValue())) continue;
                        actScore = up.getScore();
                    }
                }
            }
            userPaperVo.setPaperCount(paperCount);
            userPaperVo.setActScore(actScore);
            userPaperVo.setPaperNum(paperNum);
            Integer passStatus = 2;
            if (userPaperVo.getPaperStatus() == 1) {
                passStatus = 1;
            } else if (actScore.compareTo(totalScore.multiply(new BigDecimal(passLine)).divide(new BigDecimal(100), 2, 4)) < 0) {
                passStatus = 3;
            }
            userPaperVo.setPassStatus(passStatus);
            LambdaQueryWrapper wrapper2 = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper2.eq(TrainingUserPaper::getLoginUserId, (Object)userPaper.getLoginUserId())).eq(TrainingUserPaper::getTrainingPaperId, (Object)userPaper.getTrainingPaperId())).isNull(TrainingUserPaper::getSubmitTime);
            List list1 = this.trainingUserPaperMapper.selectList((Wrapper)wrapper2);
            if (!CollectionUtils.isEmpty((Collection)list1)) {
                userPaperVo.setIsNotFinish(Integer.valueOf(1));
            } else {
                userPaperVo.setIsNotFinish(Integer.valueOf(0));
            }
            userPaperVo.setJoinNum(null);
            userPaperVo.setRankingNum(null);
            LambdaQueryWrapper questionWrapper = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)questionWrapper.eq(TrainingUserQuestion::getUserPaperId, (Object)userPaper.getId())).eq(TrainingUserQuestion::getIsReviewed, (Object)0)).eq(TrainingUserQuestion::getQuestionType, (Object)1);
            List questionList = this.trainingUserQuestionMapper.selectList((Wrapper)questionWrapper);
            if (CollectionUtils.isEmpty((Collection)questionList)) {
                userPaperVo.setIsReview(Integer.valueOf(0));
            } else {
                userPaperVo.setIsReview(Integer.valueOf(1));
            }
        }
        return userPaperVo;
    }

    @Override
    public String selectUserPaperListVisitor(TrainingPapersVo papersVo, Users user) {
        Integer userId = user.getId();
        papersVo.setUserId(userId);
        TrainingPaper paper = (TrainingPaper)this.trainingPaperMapper.selectById(papersVo.getId());
        if (!ObjectUtils.isEmpty((Object)paper)) {
            TrainingExam exam;
            BeanUtils.copyProperties((Object)paper, (Object)papersVo);
            Integer scoreSelect = paper.getScoreSelect() == null ? 1 : paper.getScoreSelect();
            papersVo.setScoreSelect(scoreSelect);
            Integer passLine = paper.getPassLine() == null ? 60 : paper.getPassLine();
            BigDecimal totalScore = new BigDecimal(100);
            if (paper.getExamId() != null && !StringUtils.isEmpty((Object)(exam = (TrainingExam)this.trainingExamMapper.selectById(paper.getExamId())))) {
                totalScore = exam.getScore();
            }
            BigDecimal actScore = new BigDecimal(0);
            LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)wrapper1.eq(TrainingUserPaper::getLoginUserId, (Object)userId)).eq(TrainingUserPaper::getTrainingPaperId, (Object)paper.getId());
            if (!StringUtils.isEmpty((Object)papersVo.getSourceType())) {
                wrapper1.and(wq -> {
                    LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wq.eq(TrainingUserPaper::getSourceType, (Object)papersVo.getSourceType())).or()).isNull(TrainingUserPaper::getSourceType);
                });
            } else {
                wrapper1.isNull(TrainingUserPaper::getSourceType);
            }
            ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper1.eq(!StringUtils.isEmpty((Object)papersVo.getSourceProjectId()), TrainingUserPaper::getSourceProjectId, (Object)papersVo.getSourceProjectId())).eq(!StringUtils.isEmpty((Object)papersVo.getSourceTaskId()), TrainingUserPaper::getSourceTaskId, (Object)papersVo.getSourceTaskId())).eq(!StringUtils.isEmpty((Object)papersVo.getSourceShiftId()), TrainingUserPaper::getSourceShiftId, (Object)papersVo.getSourceShiftId())).isNotNull(TrainingUserPaper::getSubmitTime)).orderByDesc(TrainingUserPaper::getId);
            List userPaperList = this.trainingUserPaperMapper.selectList((Wrapper)wrapper1);
            Integer paperNum = 0;
            if (!CollectionUtils.isEmpty((Collection)userPaperList)) {
                TrainingUserPaper userPaper;
                int i;
                paperNum = userPaperList.size();
                List userPaperIdList = userPaperList.stream().map(TrainingUserPaper::getId).collect(Collectors.toList());
                LambdaQueryWrapper wrapper4 = new LambdaQueryWrapper();
                wrapper4.in(TrainingUserQuestion::getUserPaperId, userPaperIdList);
                List userQuestionList = this.trainingUserQuestionMapper.selectList((Wrapper)wrapper4);
                Map<Object, Object> userQuestionMap = new HashMap();
                if (!CollectionUtils.isEmpty((Collection)userQuestionList)) {
                    userQuestionMap = userQuestionList.stream().collect(Collectors.groupingBy(TrainingUserQuestion::getUserPaperId));
                }
                ArrayList<TrainingUserPaperVo> userPaperVoList = new ArrayList<TrainingUserPaperVo>();
                int topScoreIndex = 0;
                Integer newScoreIndex = null;
                for (i = 0; i < userPaperList.size(); ++i) {
                    userPaper = (TrainingUserPaper)userPaperList.get(i);
                    if (userPaper.getPaperStatus() == 1 || !userPaper.getPaperStatus().equals(2)) continue;
                    if (userPaper.getScore().compareTo(actScore) > 0) {
                        actScore = userPaper.getScore();
                        topScoreIndex = i;
                    }
                    if (newScoreIndex != null) continue;
                    actScore = userPaper.getScore();
                    newScoreIndex = i;
                }
                for (i = 0; i < userPaperList.size(); ++i) {
                    userPaper = (TrainingUserPaper)userPaperList.get(i);
                    TrainingUserPaperVo userPaperVo = new TrainingUserPaperVo();
                    BeanUtils.copyProperties((Object)userPaper, (Object)userPaperVo);
                    if (userPaperVo.getSubmitTime() != null && userPaperVo.getUpdateTime() != null) {
                        Integer totalTime = (int)((userPaper.getSubmitTime().getTime() - userPaper.getUpdateTime().getTime()) / 1000L);
                        userPaperVo.setTimeStr(DateUtils.getUseTimeFormal(totalTime));
                    }
                    if (userPaper.getPaperStatus() == 0) {
                        userPaperVo.setPassStatus(Integer.valueOf(4));
                        continue;
                    }
                    if (userPaper.getPaperStatus() == 1) {
                        userPaperVo.setPassStatus(Integer.valueOf(1));
                    } else {
                        if (userPaper.getScore().compareTo(totalScore.multiply(new BigDecimal(passLine)).divide(new BigDecimal(100), 2, 4)) < 0) {
                            userPaperVo.setPassStatus(Integer.valueOf(3));
                        } else {
                            userPaperVo.setPassStatus(Integer.valueOf(2));
                        }
                        if (scoreSelect != null && scoreSelect == 0) {
                            if (topScoreIndex == i) {
                                userPaperVo.setIsSelect(1);
                                actScore = userPaper.getScore();
                            } else {
                                userPaperVo.setIsSelect(0);
                            }
                        } else if (scoreSelect != null && scoreSelect == 1) {
                            if (i == newScoreIndex) {
                                userPaperVo.setIsSelect(1);
                                actScore = userPaper.getScore();
                            } else {
                                userPaperVo.setIsSelect(0);
                            }
                        }
                        List questionList = (List)userQuestionMap.get(userPaperVo.getId());
                        Integer rightNum = 0;
                        Integer errorNum = 0;
                        Integer totalNum = 0;
                        if (!CollectionUtils.isEmpty((Collection)questionList)) {
                            totalNum = questionList.size();
                            for (TrainingUserQuestion userQuestion : questionList) {
                                Integer n;
                                Integer n2;
                                if (userQuestion.getIsCorrect() == 1) {
                                    n2 = rightNum;
                                    n = rightNum = Integer.valueOf(rightNum + 1);
                                    continue;
                                }
                                n2 = errorNum;
                                n = errorNum = Integer.valueOf(errorNum + 1);
                            }
                        }
                        userPaperVo.setTotalCount(totalNum);
                        userPaperVo.setRightCount(rightNum);
                        userPaperVo.setErrorCount(errorNum);
                    }
                    userPaperVoList.add(userPaperVo);
                }
                papersVo.setUserPaperVoList(userPaperVoList);
            }
            papersVo.setPaperNum(paperNum);
            papersVo.setJoinNum(null);
            papersVo.setRanking(null);
        }
        return JsonResult.success((Object)papersVo);
    }

    @Override
    public TrainingPapersVo selectFinishPaperQuestionsVisitor(TrainingUserPaperVo userPaperVo, Users user) {
        TrainingPapersVo papersVo = new TrainingPapersVo();
        ArrayList<TrainingUserQuestionVo> userQuestionVoList = new ArrayList<TrainingUserQuestionVo>();
        TrainingUserPaper userPaper = (TrainingUserPaper)this.trainingUserPaperMapper.selectById(userPaperVo.getId());
        TrainingPaper paper = (TrainingPaper)this.trainingPaperMapper.selectById(userPaper.getTrainingPaperId());
        if (!ObjectUtils.isEmpty((Object)paper)) {
            BeanUtils.copyProperties((Object)paper, (Object)papersVo);
        }
        papersVo.setIsAutoRead(userPaper.getIsAutoRead());
        papersVo.setStatus(userPaper.getPaperStatus());
        if (!ObjectUtils.isEmpty((Object)userPaper)) {
            papersVo.setUserName(userPaper.getLoginShowName());
            papersVo.setEnterpriseName(userPaper.getLoginDepName());
            LambdaQueryWrapper wrapper2 = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper2.eq(TrainingUserQuestion::getUserId, (Object)userPaper.getLoginUserId())).eq(TrainingUserQuestion::getPaperId, (Object)userPaper.getTrainingPaperId())).eq(TrainingUserQuestion::getUserPaperId, (Object)userPaper.getId());
            List userQuestionList = this.trainingUserQuestionMapper.selectList((Wrapper)wrapper2);
            if (!CollectionUtils.isEmpty((Collection)userQuestionList)) {
                Map<Object, Object> picMap = new HashMap();
                ArrayList<Integer> userQuestionIdList = new ArrayList<Integer>();
                for (TrainingUserQuestion userQuestion : userQuestionList) {
                    if (userQuestion.getQuestionType() != 1) continue;
                    userQuestionIdList.add(userQuestion.getId());
                }
                if (!CollectionUtils.isEmpty(userQuestionIdList)) {
                    LambdaQueryWrapper wrapper3 = new LambdaQueryWrapper();
                    ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper3.in(TrainingUserQuestionPicture::getUserQuestionId, userQuestionIdList)).eq(TrainingUserQuestionPicture::getPictureType, (Object)1)).eq(TrainingUserQuestionPicture::getIsDelete, (Object)0);
                    List userQuestionPictures = this.trainingUserQuestionPictureMapper.selectList((Wrapper)wrapper3);
                    if (!CollectionUtils.isEmpty((Collection)userQuestionPictures)) {
                        picMap = userQuestionPictures.stream().collect(Collectors.groupingBy(TrainingUserQuestionPicture::getUserQuestionId));
                    }
                }
                for (TrainingUserQuestion userQuestion : userQuestionList) {
                    TrainingUserQuestionVo userQuestionVo = new TrainingUserQuestionVo();
                    BeanUtils.copyProperties((Object)userQuestion, (Object)userQuestionVo);
                    List optionsList = new ArrayList();
                    if (!StringUtils.isEmpty((Object)userQuestionVo.getOptionsData())) {
                        optionsList = JSONObject.parseArray((String)userQuestionVo.getOptionsData(), TrainingOptionsVo.class);
                        if (userQuestionVo.getQuestionType() == 2 && !CollectionUtils.isEmpty(optionsList)) {
                            for (TrainingOptionsVo vo : optionsList) {
                                List<String> optionsLists = StringsUtils.String2List(vo.getOptionsName(), "&");
                                if (!CollectionUtils.isEmpty(optionsLists)) {
                                    if (!StringUtils.isEmpty((Object)vo.getAnswer()) && optionsLists.contains(vo.getAnswer().trim())) {
                                        vo.setIsCorrect(Integer.valueOf(1));
                                        continue;
                                    }
                                    vo.setIsCorrect(Integer.valueOf(0));
                                    continue;
                                }
                                vo.setIsCorrect(Integer.valueOf(1));
                            }
                        }
                    }
                    userQuestionVo.setOptionsVoList(optionsList);
                    if (userQuestion.getQuestionType() == 1) {
                        List questionPictureList = (List)picMap.get(userQuestion.getId());
                        userQuestionVo.setUserQuestionPictureList(questionPictureList);
                        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
                        wrapper.eq(TrainingUserQuestionAtta::getUserQuestionId, (Object)userQuestion.getId());
                        List list = this.trainingUserQuestionAttaMapper.selectList((Wrapper)wrapper);
                        if (!CollectionUtils.isEmpty((Collection)list)) {
                            userQuestionVo.setAttaList(list);
                        }
                    }
                    userQuestionVoList.add(userQuestionVo);
                }
            }
        }
        papersVo.setUserQuestionVoList(userQuestionVoList);
        LambdaQueryWrapper questionWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)questionWrapper.eq(TrainingUserQuestion::getUserPaperId, (Object)userPaperVo.getId())).eq(TrainingUserQuestion::getIsReviewed, (Object)0)).eq(TrainingUserQuestion::getQuestionType, (Object)1);
        List questionList = this.trainingUserQuestionMapper.selectList((Wrapper)questionWrapper);
        if (CollectionUtils.isEmpty((Collection)questionList)) {
            papersVo.setIsReview(Integer.valueOf(0));
        } else {
            papersVo.setIsReview(Integer.valueOf(1));
        }
        return papersVo;
    }

    @Override
    public String addPaperScreenNumVisitor(Integer userPaperId, Users user) {
        TrainingUserPaper userPaper = (TrainingUserPaper)this.trainingUserPaperMapper.selectById(userPaperId);
        userPaper.setScreenNum(Integer.valueOf(userPaper.getScreenNum() + 1));
        this.trainingUserPaperMapper.updateById(userPaper);
        TrainingPaper paper = (TrainingPaper)this.trainingPaperMapper.selectById(userPaper.getTrainingPaperId());
        PaperScreenNumVo vo = new PaperScreenNumVo();
        vo.setIsScreen(Integer.valueOf(ObjectUtils.isEmpty((Object)paper) ? 0 : paper.getIsScreen()));
        vo.setScreenNum(Integer.valueOf(ObjectUtils.isEmpty((Object)paper) ? 0 : (paper.getScreenNum() != null ? paper.getScreenNum() : 0)));
        vo.setMyScreenNum(userPaper.getScreenNum());
        return JsonResult.success((Object)vo);
    }

    @Override
    public Page<TrainingPapersVo> getVisitorPaperByPage(Page<TrainingPapersVo> page, Integer enterpriseId, String title, Users user) {
        List<TrainingPapersVo> trainingPapersVoList = this.trainingPaperMapper.selectVisitorPaperByPage(page, enterpriseId, title);
        page.setContent(trainingPapersVoList);
        return page;
    }
}

