/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.training.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ovopark.organize.common.model.pojo.UsersPojo;
import com.ovopark.training.mapper.TrainingReviewAssignerMapper;
import com.ovopark.training.mapper.TrainingReviewConfigMapper;
import com.ovopark.training.model.Authenticator;
import com.ovopark.training.model.ReviewHead;
import com.ovopark.training.model.TrainingReviewAssigner;
import com.ovopark.training.model.TrainingReviewHeadConfig;
import com.ovopark.training.model.Users;
import com.ovopark.training.service.TrainingReviewConfigService;
import com.ovopark.training.service.UserUtilService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class TrainingReviewConfigServiceImpl
implements TrainingReviewConfigService {
    @Autowired
    private TrainingReviewConfigMapper trainingReviewConfigMapper;
    @Autowired
    private TrainingReviewAssignerMapper trainingReviewAssignerMapper;
    @Autowired
    private UserUtilService userUtilService;

    @Override
    public void saveConfig(TrainingReviewHeadConfig config) {
        LambdaQueryWrapper queryWrapper;
        Users user = Authenticator.getInstance().getCurrentUser();
        if (Objects.nonNull(config.getId())) {
            this.trainingReviewConfigMapper.deleteById(config.getId());
            if (Objects.nonNull(config.getAssigner())) {
                queryWrapper = new LambdaQueryWrapper();
                queryWrapper.eq(TrainingReviewAssigner::getConfigId, (Object)config.getId());
                this.trainingReviewAssignerMapper.delete((Wrapper)queryWrapper);
            }
        }
        queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(TrainingReviewAssigner::getEnterpriseId, (Object)user.getGroupId());
        this.trainingReviewAssignerMapper.delete((Wrapper)queryWrapper);
        config.setCreateTime(new Date());
        config.setUpdateTime(new Date());
        config.setEnterpriseId(user.getGroupId().intValue());
        int affected = this.trainingReviewConfigMapper.insert(config);
        if (affected > 0 && !StringUtils.isEmpty((Object)config.getAssigner())) {
            List assigners = Arrays.stream(config.getAssigner().split(",")).map(Integer::parseInt).collect(Collectors.toList());
            Iterator iterator = assigners.iterator();
            while (iterator.hasNext()) {
                int assignId = (Integer)iterator.next();
                TrainingReviewAssigner assigner = new TrainingReviewAssigner();
                assigner.setAssigner(assignId);
                assigner.setConfigId(config.getId().intValue());
                assigner.setEnterpriseId(user.getGroupId().intValue());
                assigner.setCreateTime(new Date());
                assigner.setUpdateTime(new Date());
                this.trainingReviewAssignerMapper.insert(assigner);
            }
        }
    }

    @Override
    public TrainingReviewHeadConfig selectReviewDirectorConfig(Users users) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(users.getGroupId() != null, TrainingReviewHeadConfig::getEnterpriseId, (Object)users.getGroupId());
        queryWrapper.orderByDesc(TrainingReviewHeadConfig::getId);
        List list = this.trainingReviewConfigMapper.selectList((Wrapper)queryWrapper);
        if (!CollectionUtils.isEmpty((Collection)list)) {
            Map<Integer, UsersPojo> userMap;
            TrainingReviewHeadConfig config = (TrainingReviewHeadConfig)list.get(0);
            if (!StringUtils.isEmpty((Object)config.getAssigner()) && !CollectionUtils.isEmpty(userMap = this.userUtilService.selectUserMap(Arrays.stream(config.getAssigner().split(",")).map(Integer::parseInt).collect(Collectors.toList())))) {
                List userIds = Arrays.stream(config.getAssigner().split(",")).map(Integer::parseInt).collect(Collectors.toList());
                ArrayList<ReviewHead> reviewHeads = new ArrayList<ReviewHead>();
                for (Integer userId : userIds) {
                    ReviewHead reviewHead = new ReviewHead();
                    reviewHead.setUserId(userId.intValue());
                    reviewHead.setUserName(userMap.get(userId).getShowName());
                    reviewHeads.add(reviewHead);
                }
                config.setUserNameList(reviewHeads);
            }
            return config;
        }
        return new TrainingReviewHeadConfig();
    }
}

