/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.training.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Lists;
import com.ovopark.organize.common.model.mo.SimpleSuperUserMo;
import com.ovopark.organize.common.model.mo.UserAndParentNameMo;
import com.ovopark.organize.common.model.mo.UserDutiesMo;
import com.ovopark.organize.common.model.mo.UserIdsAndDepIdsMo;
import com.ovopark.organize.common.model.mo.UserTagMo;
import com.ovopark.organize.common.model.mo.UsersAndOrgsMo;
import com.ovopark.organize.common.model.pojo.DepAndTagsPojo;
import com.ovopark.organize.common.model.pojo.DepartmentPojo;
import com.ovopark.organize.common.model.pojo.OrganizePojo;
import com.ovopark.organize.common.model.pojo.SimplePojo;
import com.ovopark.organize.common.model.pojo.UsersOrgIdsAndTagsPojo;
import com.ovopark.organize.sdk.api.DepartmentApi;
import com.ovopark.organize.sdk.api.OrganizeApi;
import com.ovopark.organize.sdk.api.TagApi;
import com.ovopark.organize.sdk.api.UserApi;
import com.ovopark.organize.sdk.api.UserOrganizeApi;
import com.ovopark.privilege.api.RoleApi;
import com.ovopark.privilege.pojo.RolePojo;
import com.ovopark.privilege.pojo.UsersPojo;
import com.ovopark.privilege.response.BaseResult;
import com.ovopark.training.mapper.TrainingJobUserMapper;
import com.ovopark.training.model.Authenticator;
import com.ovopark.training.model.TrainingJobUser;
import com.ovopark.training.model.Users;
import com.ovopark.training.service.UserUtilService;
import com.ovopark.training.vo.OrgVo;
import com.ovopark.training.vo.UserOrganizeAndDepVo;
import com.ovopark.training.vo.unit.UnitShowVo;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Service
public class UserUtilServiceImpl
implements UserUtilService {
    private static final Logger log = LoggerFactory.getLogger(UserUtilServiceImpl.class);
    @Autowired
    private UserOrganizeApi userOrganizeApi;
    @Autowired
    private UserApi userApi;
    @Autowired
    private com.ovopark.privilege.api.UserApi useApi;
    @Autowired
    private TagApi tagApi;
    @Autowired
    private RoleApi roleApi;
    @Autowired
    private OrganizeApi organizeApi;
    @Autowired
    private DepartmentApi departmentApi;
    @Autowired
    private TrainingJobUserMapper jobUserMapper;
    @Resource(name="oldCommon")
    private Executor executor;
    private LoadingCache<Integer, List<Integer>> enterpriseAllUserCache;

    @PostConstruct
    public void init() {
        this.enterpriseAllUserCache = CacheBuilder.newBuilder().expireAfterWrite(5L, TimeUnit.MINUTES).refreshAfterWrite(2L, TimeUnit.MINUTES).build(CacheLoader.asyncReloading((CacheLoader)new CacheLoader<Integer, List<Integer>>(){

            public List<Integer> load(Integer key) throws Exception {
                return UserUtilServiceImpl.this.getUserListByGroupId(key);
            }
        }, (Executor)this.executor));
    }

    @Override
    public List<Integer> selectChildUserList(List<Integer> userIdList, Users user, Boolean isBoolean) {
        List baseIds = new ArrayList();
        com.ovopark.organize.common.base.BaseResult baseResult = this.userOrganizeApi.getUserIdsByPrivilegeUserId(user.getGroupId(), user.getId());
        if (!org.springframework.util.StringUtils.isEmpty((Object)baseResult)) {
            baseIds = (List)baseResult.getData();
        }
        if (isBoolean.booleanValue()) {
            if (!CollectionUtils.isEmpty(userIdList) && !CollectionUtils.isEmpty(baseIds)) {
                baseIds.retainAll(userIdList);
            } else {
                baseIds = new ArrayList();
            }
        }
        return baseIds;
    }

    @Override
    public List<Integer> getUserIdsMapByPrivilegeUserId(Integer enterpriseId, Integer userId, Integer userStatus, List<Integer> roleIds, List<String> organizeIds) {
        UserIdsAndDepIdsMo userIdsAndDepIdsMo = new UserIdsAndDepIdsMo();
        userIdsAndDepIdsMo.setGroupId(enterpriseId);
        userIdsAndDepIdsMo.setUserId(userId);
        userIdsAndDepIdsMo.setStatus(userStatus);
        if (!CollectionUtils.isEmpty(organizeIds)) {
            userIdsAndDepIdsMo.setOrganizeIds(organizeIds);
        }
        if (!CollectionUtils.isEmpty(roleIds)) {
            userIdsAndDepIdsMo.setRoleIds(roleIds);
        }
        com.ovopark.organize.common.base.BaseResult userIdsMapByPrivilegeUserId = this.userOrganizeApi.getUserIdsMapByPrivilegeUserId(userIdsAndDepIdsMo);
        log.info("getUserIdsMapByPrivilegeUserId userId = {} userStatus= {} result:{}", new Object[]{userId, userStatus, JSON.toJSONString((Object)userIdsMapByPrivilegeUserId)});
        if (userIdsMapByPrivilegeUserId != null && !userIdsMapByPrivilegeUserId.getIsError().booleanValue()) {
            Map data = (Map)userIdsMapByPrivilegeUserId.getData();
            if (userStatus == null) {
                ArrayList<Integer> result = new ArrayList<Integer>();
                List userIds = (List)data.get("userIds");
                List resignation = (List)data.get("resignation");
                if (!CollectionUtils.isEmpty((Collection)userIds)) {
                    result.addAll(userIds);
                }
                if (!CollectionUtils.isEmpty((Collection)resignation)) {
                    result.addAll(resignation);
                }
                return result;
            }
            if (userStatus == 1) {
                return (List)data.get("resignation");
            }
            if (userStatus == 0) {
                return (List)data.get("userIds");
            }
        }
        return new ArrayList<Integer>();
    }

    @Override
    public List<Integer> selectJobChildUserList(List<Integer> userIdList, Integer jobId, Users user, Boolean isBoolean) {
        List<Integer> baseIds = new ArrayList();
        com.ovopark.organize.common.base.BaseResult baseResult = this.userOrganizeApi.getUserIdsByPrivilegeUserId(user.getGroupId(), user.getId());
        if (!org.springframework.util.StringUtils.isEmpty((Object)baseResult)) {
            baseIds = (List)baseResult.getData();
        }
        if (isBoolean.booleanValue()) {
            LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(TrainingJobUser::getJobId, (Object)jobId)).eq(TrainingJobUser::getJobType, (Object)1)).eq(TrainingJobUser::getUserId, (Object)user.getId());
            List jobUserList = this.jobUserMapper.selectList((Wrapper)wrapper);
            if (CollectionUtils.isEmpty((Collection)jobUserList)) {
                if (!CollectionUtils.isEmpty(userIdList) && !CollectionUtils.isEmpty(baseIds)) {
                    baseIds.retainAll(userIdList);
                } else {
                    baseIds = new ArrayList();
                }
            } else {
                baseIds = new ArrayList();
                baseIds.addAll(userIdList);
            }
        }
        return baseIds;
    }

    @Override
    public com.ovopark.organize.common.model.pojo.UsersPojo selectUser(Integer userId) {
        com.ovopark.organize.common.model.pojo.UsersPojo pojo = new com.ovopark.organize.common.model.pojo.UsersPojo();
        com.ovopark.organize.common.base.BaseResult userPojo = this.userApi.getUserById(userId);
        if (userPojo != null) {
            pojo = (com.ovopark.organize.common.model.pojo.UsersPojo)userPojo.getData();
        }
        return pojo;
    }

    @Override
    public String getUserNameById(Integer userId) {
        if (userId == null) {
            return "";
        }
        com.ovopark.organize.common.model.pojo.UsersPojo usersPojo = this.selectUser(userId);
        if (usersPojo == null) {
            return "";
        }
        return (String)org.apache.commons.lang3.StringUtils.defaultIfEmpty((CharSequence)usersPojo.getShowName(), (CharSequence)"");
    }

    @Override
    public Map<Integer, com.ovopark.organize.common.model.pojo.UsersPojo> selectUserMap(List<Integer> userIds) {
        com.ovopark.organize.common.base.BaseResult base;
        Map<Integer, Object> pojoMap = new HashMap<Integer, com.ovopark.organize.common.model.pojo.UsersPojo>();
        if (!CollectionUtils.isEmpty(userIds) && (base = this.userApi.getUserByIdList(userIds)) != null && !CollectionUtils.isEmpty((Collection)((Collection)base.getData()))) {
            pojoMap = ((List)base.getData()).stream().collect(Collectors.toMap(com.ovopark.organize.common.model.pojo.UsersPojo::getId, Function.identity()));
        }
        return pojoMap;
    }

    @Override
    public RolePojo selectRole(Integer roleId) {
        BaseResult base = this.roleApi.getRolePojoById(roleId);
        return (RolePojo)base.getData();
    }

    @Override
    public Map<Integer, RolePojo> selectRoleMap(List<Integer> roleIds) {
        Map<Integer, Object> pojoMap = new HashMap<Integer, RolePojo>();
        BaseResult base = this.roleApi.getRolePojoByIdList(roleIds);
        if (base != null && !CollectionUtils.isEmpty((Collection)((Collection)base.getData()))) {
            pojoMap = ((List)base.getData()).stream().collect(Collectors.toMap(RolePojo::getId, Function.identity()));
        }
        return pojoMap;
    }

    @Override
    public UserTagMo selectTag(Integer tagId) {
        com.ovopark.organize.common.base.BaseResult result = this.tagApi.getUsersTagById(tagId);
        return (UserTagMo)result.getData();
    }

    @Override
    public Map<Integer, UserTagMo> selectTagMap(List<Integer> tagIds, Integer groupId) {
        Map<Integer, Object> pojoMap = new HashMap<Integer, UserTagMo>();
        DepAndTagsPojo pojo = new DepAndTagsPojo();
        pojo.setTagIds(tagIds);
        pojo.setGroupId(groupId);
        com.ovopark.organize.common.base.BaseResult base = this.tagApi.getUsersTagByIds(pojo);
        if (!base.getIsError().booleanValue() && !CollectionUtils.isEmpty((Collection)((Collection)base.getData()))) {
            pojoMap = ((List)base.getData()).stream().collect(Collectors.toMap(UserTagMo::getId, Function.identity()));
        }
        return pojoMap;
    }

    @Override
    public OrgVo selectOrg(String organizeId) {
        String[] depSplit;
        com.ovopark.organize.common.base.BaseResult result;
        OrgVo org = new OrgVo();
        if (organizeId.startsWith("O_")) {
            String[] orgSplit = organizeId.split("O_");
            com.ovopark.organize.common.base.BaseResult result2 = this.organizeApi.getOrganizeById(Integer.valueOf(Integer.parseInt(orgSplit[1])));
            if (!result2.getIsError().booleanValue() && result2.getData() != null) {
                OrganizePojo pojo = (OrganizePojo)result2.getData();
                org.setId(organizeId);
                org.setName(pojo.getName());
            }
        } else if (organizeId.startsWith("S_") && !(result = this.departmentApi.getDepartmentById(Integer.valueOf(Integer.parseInt((depSplit = organizeId.split("S_"))[1])))).getIsError().booleanValue() && result.getData() != null) {
            DepartmentPojo pojo = (DepartmentPojo)result.getData();
            org.setId(organizeId);
            org.setName(pojo.getName());
        }
        return org;
    }

    @Override
    public Map<String, OrgVo> selectOrgMap(List<String> organizeIds) {
        Map<String, Object> pojoMap = new HashMap<String, OrgVo>();
        ArrayList<OrgVo> orgList = new ArrayList<OrgVo>();
        for (String organizeId : organizeIds) {
            String[] depSplit;
            OrgVo org;
            OrganizePojo pojo;
            com.ovopark.organize.common.base.BaseResult result;
            if (organizeId.startsWith("O_")) {
                String[] orgSplit = organizeId.split("O_");
                result = this.organizeApi.getOrganizeById(Integer.valueOf(Integer.parseInt(orgSplit[1])));
                if (result.getIsError().booleanValue() || result.getData() == null) continue;
                pojo = (OrganizePojo)result.getData();
                org = new OrgVo();
                org.setId(organizeId);
                org.setName(pojo.getName());
                orgList.add(org);
                continue;
            }
            if (!organizeId.startsWith("S_") || (result = this.departmentApi.getDepartmentById(Integer.valueOf(Integer.parseInt((depSplit = organizeId.split("S_"))[1])))).getIsError().booleanValue() || result.getData() == null) continue;
            pojo = (DepartmentPojo)result.getData();
            org = new OrgVo();
            org.setId(organizeId);
            org.setName(pojo.getName());
            orgList.add(org);
        }
        if (!CollectionUtils.isEmpty(orgList)) {
            pojoMap = orgList.stream().collect(Collectors.toMap(OrgVo::getId, Function.identity()));
        }
        return pojoMap;
    }

    @Override
    public Map<Integer, List<String>> selectOrganizeMap(List<Integer> userIds, Integer groupId) {
        com.ovopark.organize.common.base.BaseResult base;
        Map<Integer, List<String>> pojoMap = new HashMap<Integer, List<String>>();
        if (!CollectionUtils.isEmpty(userIds) && (base = this.userOrganizeApi.getUserOrganizeFirstByUserIds(groupId, userIds, null)) != null && !ObjectUtils.isEmpty((Object)base.getData())) {
            pojoMap = (Map)base.getData();
        }
        return pojoMap;
    }

    @Override
    public Map<Integer, String> selectParentMap(List<Integer> userIds, Integer groupId) {
        HashMap<Integer, String> parentMap = new HashMap<Integer, String>();
        if (!CollectionUtils.isEmpty(userIds)) {
            List parentList;
            SimpleSuperUserMo mo = new SimpleSuperUserMo();
            mo.setGroupId(groupId);
            mo.setUserList(userIds);
            mo.setFilterClose(Boolean.valueOf(true));
            com.ovopark.organize.common.base.BaseResult baseParent = this.userApi.getParentUsersByUserIds(mo);
            if (baseParent != null && !CollectionUtils.isEmpty((Collection)(parentList = (List)baseParent.getData()))) {
                Integer idValue = null;
                String parentName = "";
                for (Map map : parentList) {
                    idValue = null;
                    for (String key : map.keySet()) {
                        if ("id".equals(key)) {
                            idValue = Integer.valueOf(map.get(key).toString());
                            continue;
                        }
                        if (!"parentShowName".equals(key) || org.springframework.util.StringUtils.isEmpty(map.get(key))) continue;
                        parentName = map.get(key).toString();
                    }
                    if (idValue == null) continue;
                    parentMap.put(idValue, parentName);
                }
            }
        }
        return parentMap;
    }

    @Override
    public Map<Integer, Integer> selectParentIdMap(List<Integer> userIds, Integer groupId) {
        HashMap<Integer, Integer> parentMap = new HashMap<Integer, Integer>();
        if (!CollectionUtils.isEmpty(userIds)) {
            List parentList;
            SimpleSuperUserMo mo = new SimpleSuperUserMo();
            mo.setGroupId(groupId);
            mo.setUserList(userIds);
            mo.setFilterClose(Boolean.valueOf(true));
            com.ovopark.organize.common.base.BaseResult baseParent = this.userApi.getParentUsersByUserIds(mo);
            if (baseParent != null && !CollectionUtils.isEmpty((Collection)(parentList = (List)baseParent.getData()))) {
                Integer idValue = null;
                Integer parentId = null;
                for (Map map : parentList) {
                    idValue = null;
                    for (String key : map.keySet()) {
                        if ("id".equals(key)) {
                            idValue = Integer.valueOf(map.get(key).toString());
                            continue;
                        }
                        if (!"parentId".equals(key) || org.springframework.util.StringUtils.isEmpty(map.get(key))) continue;
                        parentId = Integer.valueOf(map.get(key).toString());
                    }
                    if (idValue == null) continue;
                    parentMap.put(idValue, parentId);
                }
            }
        }
        return parentMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<Integer, UserDutiesMo> selectDutiesMap(List<Integer> userIds, Integer groupId) {
        Map<Integer, Object> pojoMap = new HashMap<Integer, UserDutiesMo>();
        try {
            block6: {
                if (CollectionUtils.isEmpty(userIds)) break block6;
                SimpleSuperUserMo mo = new SimpleSuperUserMo();
                mo.setUserList(userIds);
                mo.setGroupId(groupId);
                com.ovopark.organize.common.base.BaseResult base = this.userApi.getUserDutiesByUserIds(mo);
                if (base == null) break;
                List pojoList = (List)base.getData();
                if (!CollectionUtils.isEmpty((Collection)pojoList)) {
                    pojoMap = pojoList.stream().collect(Collectors.toMap(UserDutiesMo::getUserId, Function.identity()));
                    return pojoMap;
                }
                break;
            }
        }
        catch (Exception e) {
            log.error("\u5c97\u4f4d\u96c6\u5408", (Throwable)e);
        }
        finally {
            return pojoMap;
        }
    }

    @Override
    public Map<String, Object> getCheckParameters(String userName, Integer dutiesId, List<String> organizeIds, Users user) {
        int isEffect = 0;
        ArrayList userList = new ArrayList();
        if (!org.springframework.util.StringUtils.isEmpty((Object)userName) || !org.springframework.util.StringUtils.isEmpty((Object)dutiesId)) {
            com.ovopark.organize.common.base.BaseResult base = this.userApi.getSimpleUserByKeyWord(user.getGroupId(), userName, dutiesId);
            if (base != null) {
                List pojoList = ((List)base.getData()).stream().map(SimplePojo::getId).distinct().collect(Collectors.toList());
                userList.addAll(pojoList);
            }
            isEffect = 1;
        }
        if (!CollectionUtils.isEmpty(organizeIds)) {
            UsersAndOrgsMo mo = new UsersAndOrgsMo();
            mo.setGroupId(user.getGroupId());
            mo.setOrganizeIds(organizeIds);
            com.ovopark.organize.common.base.BaseResult base = this.userOrganizeApi.getUserByOrganizeIdsOrDepId(mo);
            if (base != null && !CollectionUtils.isEmpty((Collection)((Collection)base.getData()))) {
                List pojoList = ((List)base.getData()).stream().map(UserAndParentNameMo::getUserId).distinct().collect(Collectors.toList());
                if (isEffect == 1) {
                    userList.retainAll(pojoList);
                } else {
                    userList.addAll(pojoList);
                }
            } else {
                userList = new ArrayList();
            }
            isEffect = 1;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("isEffect", isEffect);
        map.put("userList", userList);
        return map;
    }

    @Override
    public List<Integer> getFuzzyUserList(String userName, Users user) {
        ArrayList userList = Lists.newArrayList();
        com.ovopark.organize.common.base.BaseResult base = this.userApi.getSimpleUserByKeyWordAndFrozen(user.getGroupId(), userName, null, null, null);
        if (base != null && !CollectionUtils.isEmpty((Collection)((Collection)base.getData()))) {
            List pojoList = ((List)base.getData()).stream().map(SimplePojo::getId).distinct().collect(Collectors.toList());
            userList.addAll(pojoList);
        }
        return userList;
    }

    @Override
    public List<Integer> selectUserRoleList(Users user) {
        BaseResult base = this.roleApi.getRoleIdsByUser(user.getId(), user.getGroupId());
        List<Integer> roleList = new ArrayList<Integer>();
        if (base != null && !CollectionUtils.isEmpty((Collection)((Collection)base.getData()))) {
            roleList = (List)base.getData();
        }
        return roleList;
    }

    @Override
    public List<Integer> selectUserTagList(Users user) {
        com.ovopark.organize.common.base.BaseResult base = this.tagApi.getUsersTagByUserId(user.getId());
        List<Integer> tagList = new ArrayList<Integer>();
        if (!base.getIsError().booleanValue() && !CollectionUtils.isEmpty((Collection)((Collection)base.getData()))) {
            List moList = (List)base.getData();
            tagList = moList.stream().map(UserTagMo::getId).collect(Collectors.toList());
        }
        return tagList;
    }

    @Override
    public List<String> selectUserOrganizeList(Users user) {
        ArrayList<String> orgIds = new ArrayList<String>();
        UsersAndOrgsMo mo = new UsersAndOrgsMo();
        mo.setGroupId(user.getGroupId());
        mo.setUserId(user.getId());
        mo.setRetainAll(Boolean.valueOf(false));
        mo.setShowAllPath(Boolean.valueOf(true));
        com.ovopark.organize.common.base.BaseResult orgResult = this.userOrganizeApi.getUserOrganizeByUserIdAndOrg(mo);
        if (!orgResult.getIsError().booleanValue() && !CollectionUtils.isEmpty((Map)((Map)orgResult.getData()))) {
            List list;
            Map map = (Map)orgResult.getData();
            if (!CollectionUtils.isEmpty((Collection)((Collection)map.get("O_")))) {
                list = (List)map.get("O_");
                for (Integer id : list) {
                    orgIds.add("O_" + id);
                }
            }
            if (!CollectionUtils.isEmpty((Collection)((Collection)map.get("S_")))) {
                list = (List)map.get("S_");
                for (Integer id : list) {
                    orgIds.add("S_" + id);
                }
            }
        }
        return orgIds;
    }

    @Override
    public List<Integer> selectUsersByRoles(List<Integer> roleList, Integer groupId) {
        String roleIdStr;
        BaseResult baseResult;
        List<Integer> pojoList = new ArrayList<Integer>();
        if (!CollectionUtils.isEmpty(roleList) && (baseResult = this.useApi.getUserByRoleIds(roleIdStr = StringUtils.join(roleList, (String)","), groupId)) != null && !CollectionUtils.isEmpty((Collection)((Collection)baseResult.getData()))) {
            pojoList = ((List)baseResult.getData()).stream().map(UsersPojo::getId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        }
        return pojoList;
    }

    @Override
    public Map<Integer, List<RolePojo>> selectRolesByUsers(List<Integer> userIdList, Integer groupId) {
        Map<Integer, List<Object>> roleMap = new HashMap<Integer, List<RolePojo>>();
        if (!CollectionUtils.isEmpty(userIdList)) {
            String userStr = StringUtils.join(userIdList, (String)",");
            HashMap<String, Object> parameter = new HashMap<String, Object>();
            parameter.put("userIds", userStr);
            parameter.put("groupId", groupId);
            BaseResult base = this.roleApi.getUserRoleList(parameter);
            if (base != null) {
                roleMap = (Map)base.getData();
            }
        }
        return roleMap;
    }

    @Override
    public List<Integer> selectUserIdsByOrganizeIds(List<String> organizeIdList, Integer groupId) {
        List<Integer> userIds = new ArrayList<Integer>();
        if (!CollectionUtils.isEmpty(organizeIdList)) {
            UsersAndOrgsMo mo = new UsersAndOrgsMo();
            mo.setGroupId(groupId);
            mo.setOrganizeIds(organizeIdList);
            com.ovopark.organize.common.base.BaseResult baseResult = this.userOrganizeApi.getUserByOrganizeIdsOrDepId(mo);
            if (!Objects.isNull(baseResult) && !CollectionUtils.isEmpty((Collection)((Collection)baseResult.getData()))) {
                userIds = ((List)baseResult.getData()).stream().map(UserAndParentNameMo::getUserId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            }
        }
        return userIds;
    }

    @Override
    public List<Integer> selectUserIdsByTagIds(List<Integer> tagIdList, Integer groupId, Integer userId) {
        ArrayList<Integer> userIds = new ArrayList<Integer>();
        if (!CollectionUtils.isEmpty(tagIdList)) {
            DepAndTagsPojo pojo = new DepAndTagsPojo();
            pojo.setGroupId(groupId);
            pojo.setTagIds(tagIdList);
            if (userId == null) {
                pojo.setAllSuperDate(Boolean.valueOf(true));
            } else {
                pojo.setUserId(userId);
            }
            com.ovopark.organize.common.base.BaseResult baseResult = this.tagApi.getUsersByTags(pojo);
            if (!Objects.isNull(baseResult) && !Objects.isNull(baseResult.getData())) {
                for (Map map : (List)baseResult.getData()) {
                    Integer id = (Integer)map.get("id");
                    userIds.add(id);
                }
            }
        }
        return userIds;
    }

    @Override
    public List<Integer> selectUserTageByUserId(Integer userId) {
        com.ovopark.organize.common.base.BaseResult baseResult;
        List<Integer> tagIds = new ArrayList<Integer>();
        if (!(Objects.isNull(userId) || Objects.isNull(baseResult = this.tagApi.getUsersTagByUserId(userId)) || CollectionUtils.isEmpty((Collection)((Collection)baseResult.getData())))) {
            tagIds = ((List)baseResult.getData()).stream().map(UserTagMo::getId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        }
        return tagIds;
    }

    @Override
    public Map<Integer, String> selectUserOrganizeName(Integer groupId, List<Integer> userIdList) {
        HashMap<Integer, String> userOrganizeMap = new HashMap<Integer, String>();
        com.ovopark.organize.common.base.BaseResult base = this.userOrganizeApi.getUserOrganizeFirstByUserIds(groupId, userIdList, null);
        if (base != null && !ObjectUtils.isEmpty((Object)base.getData())) {
            Map map = (Map)base.getData();
            for (Integer userId : map.keySet()) {
                StringBuilder organizeName = new StringBuilder();
                List strList = (List)map.get(userId);
                if (!CollectionUtils.isEmpty((Collection)strList)) {
                    for (String name : strList) {
                        String[] datas = name.split("/");
                        organizeName.append(datas[datas.length - 1]).append(";\n");
                    }
                }
                userOrganizeMap.put(userId, organizeName.substring(0, organizeName.length() - 2));
            }
        }
        return userOrganizeMap;
    }

    @Override
    public List<Integer> selectOverGroupTime(Integer groupId, Date dateTime) {
        List<Integer> userRemoveList = new ArrayList<Integer>();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        com.ovopark.organize.common.base.BaseResult base = this.userApi.getUserGtCreateTime(groupId, format.format(dateTime));
        if (base != null && !CollectionUtils.isEmpty((Collection)((Collection)base.getData()))) {
            userRemoveList = (List)base.getData();
        }
        return userRemoveList;
    }

    @Override
    public Map<Integer, String> selectShopPath(Integer groupId) {
        HashMap<Integer, String> userOrganizeMap = new HashMap<Integer, String>();
        return userOrganizeMap;
    }

    @Override
    public List<Integer> getUserListByGroupIdWithCache(Integer groupId) {
        try {
            return (List)this.enterpriseAllUserCache.get((Object)groupId);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public List<Integer> getUserListByGroupId(Integer groupId) {
        com.ovopark.organize.common.base.BaseResult baseResult = this.userApi.getSimpleUserByKeyWord(groupId, null, null);
        if (!baseResult.getIsError().booleanValue() && !CollectionUtils.isEmpty((Collection)((Collection)baseResult.getData()))) {
            return ((List)baseResult.getData()).stream().map(SimplePojo::getId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        }
        return Lists.newArrayList();
    }

    @Override
    public List<Integer> getResignUserByGroupId(Integer groupId) {
        com.ovopark.organize.common.base.BaseResult resignUserByGroupId = this.userApi.getResignUserByGroupId(groupId);
        if (resignUserByGroupId != null && !CollectionUtils.isEmpty((Collection)((Collection)resignUserByGroupId.getData()))) {
            return ((List)resignUserByGroupId.getData()).stream().map(SimplePojo::getId).collect(Collectors.toList());
        }
        return null;
    }

    @Override
    public Map<String, List<Integer>> selectUserByOrganizeIdMap(List<String> organizeIds, Integer groupId) {
        if (CollectionUtils.isEmpty(organizeIds)) {
            return new HashMap<String, List<Integer>>();
        }
        organizeIds = organizeIds.stream().distinct().collect(Collectors.toList());
        UsersAndOrgsMo mo = new UsersAndOrgsMo();
        mo.setGroupId(groupId);
        mo.setOrganizeIds(organizeIds);
        log.info("getUserByOrganizeIdsOrDepId param:{}", (Object)JSON.toJSONString((Object)mo));
        com.ovopark.organize.common.base.BaseResult userMapByOrganizeIdsOrDepId = this.userOrganizeApi.getUserMapByOrganizeIdsOrDepId(mo);
        log.info("getUserByOrganizeIdsOrDepId result:{}", (Object)JSON.toJSONString((Object)userMapByOrganizeIdsOrDepId));
        if (!userMapByOrganizeIdsOrDepId.getIsError().booleanValue() && !CollectionUtils.isEmpty((Map)((Map)userMapByOrganizeIdsOrDepId.getData()))) {
            return ((Map)userMapByOrganizeIdsOrDepId.getData()).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((List)entry.getValue()).stream().map(UserAndParentNameMo::getUserId).collect(Collectors.toList())));
        }
        return new HashMap<String, List<Integer>>();
    }

    @Override
    public Map<Integer, List<Integer>> selectUserByRoleIdMap(List<Integer> roleIds, Integer groupId) {
        HashMap<Integer, List<Integer>> result = new HashMap<Integer, List<Integer>>();
        if (CollectionUtils.isEmpty(roleIds)) {
            return result;
        }
        String roleIdStr = roleIds.stream().distinct().map(it -> it.toString()).collect(Collectors.joining(","));
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("roleIds", roleIdStr);
        map.put("groupId", groupId);
        log.info("getUserByRoleIds param :{}", (Object)roleIdStr);
        BaseResult userMapByRoleIds = this.useApi.getUserMapByRoleIds(map);
        log.info("getUserByRoleIds result:{}", (Object)JSON.toJSONString((Object)userMapByRoleIds));
        if (userMapByRoleIds != null && !CollectionUtils.isEmpty((Map)((Map)userMapByRoleIds.getData()))) {
            Map data = (Map)userMapByRoleIds.getData();
            data.forEach((k, v) -> result.put((Integer)k, v.stream().map(UsersPojo::getId).collect(Collectors.toList())));
        }
        return result;
    }

    @Override
    public Map<Integer, List<Integer>> selectUserByTagIdMap(List<Integer> tagIds, Integer groupId, Integer userId) {
        if (CollectionUtils.isEmpty(tagIds)) {
            return new HashMap<Integer, List<Integer>>();
        }
        tagIds = tagIds.stream().distinct().collect(Collectors.toList());
        DepAndTagsPojo pojo = new DepAndTagsPojo();
        pojo.setGroupId(groupId);
        pojo.setTagIds(tagIds);
        pojo.setUserId(userId);
        log.info("getUsersByTags param:{}", (Object)JSON.toJSONString((Object)pojo));
        com.ovopark.organize.common.base.BaseResult tagResult = this.tagApi.getUsersByTags(pojo);
        log.info("getUsersByTags result:{}", (Object)JSON.toJSONString((Object)tagResult));
        if (!tagResult.getIsError().booleanValue() && !CollectionUtils.isEmpty((Collection)((Collection)tagResult.getData()))) {
            List data = (List)tagResult.getData();
            HashMap<Integer, List<Integer>> result = new HashMap<Integer, List<Integer>>();
            for (Map map : data) {
                Object tagIdsObject = map.get("tagIds");
                if (tagIdsObject == null) continue;
                String tagIdsStr = tagIdsObject.toString();
                if (tagIdsStr.contains(",")) {
                    Arrays.asList(tagIdsStr.split(",")).forEach(tagIdStr -> {
                        Integer tagId = Integer.valueOf(tagIdStr);
                        Integer userIdValue = (Integer)map.get("id");
                        ArrayList<Integer> tagIdList = (ArrayList<Integer>)result.get(tagId);
                        if (tagIdList == null) {
                            tagIdList = new ArrayList<Integer>();
                            result.put(tagId, tagIdList);
                        }
                        tagIdList.add(userIdValue);
                    });
                    continue;
                }
                Integer tagId = Integer.valueOf(tagIdsStr);
                Integer userIdValue = (Integer)map.get("id");
                ArrayList<Integer> tagIdList = (ArrayList<Integer>)result.get(tagId);
                if (tagIdList == null) {
                    tagIdList = new ArrayList<Integer>();
                    result.put(tagId, tagIdList);
                }
                tagIdList.add(userIdValue);
            }
            return result;
        }
        return new HashMap<Integer, List<Integer>>();
    }

    @Override
    public Map<Integer, UserOrganizeAndDepVo> getUserOrganizeAndDepVoMap(Integer groupId, List<Integer> userIds) {
        if (!CollectionUtils.isEmpty(userIds)) {
            userIds = userIds.stream().distinct().collect(Collectors.toList());
        }
        UsersOrgIdsAndTagsPojo pojo = new UsersOrgIdsAndTagsPojo();
        pojo.setGroupId(groupId);
        pojo.setUserIds(userIds);
        pojo.setLocale(Authenticator.getInstance().getCurrentClient().getLocale());
        pojo.setShowDepPath(Boolean.FALSE);
        log.info("getOrganizeAndDepByUserIdsAndLocal groupId :{},userIds : {} ", (Object)groupId, (Object)JSON.toJSONString(userIds));
        com.ovopark.organize.common.base.BaseResult userOrganizesResult = this.userOrganizeApi.getOrganizeAndDepByUserIdsAndLocal(pojo);
        log.info("getOrganizeAndDepByUserIdsAndLocal result {}", (Object)JSON.toJSONString((Object)userOrganizesResult));
        Map<Integer, Object> userOrganizeAndDepMap = new HashMap<Integer, UserOrganizeAndDepVo>();
        if (!CollectionUtils.isEmpty((Collection)((Collection)userOrganizesResult.getData()))) {
            List userOrganizesMap = (List)userOrganizesResult.getData();
            ArrayList<UserOrganizeAndDepVo> userOrganizeAndDeps = new ArrayList<UserOrganizeAndDepVo>();
            for (Map userOrganizes : userOrganizesMap) {
                UserOrganizeAndDepVo userOrganizeAndDep = new UserOrganizeAndDepVo();
                userOrganizeAndDep.setUserId((Integer)userOrganizes.get("userId"));
                userOrganizeAndDep.setUserName((String)userOrganizes.get("showName"));
                userOrganizeAndDep.setThumbUrl((String)userOrganizes.get("thumbUrl"));
                String depPathName = Objects.isNull(userOrganizes.get("depPathName")) ? "" : (String)userOrganizes.get("depPathName");
                String organizeName = Objects.isNull(userOrganizes.get("organizeName")) ? "" : (String)userOrganizes.get("organizeName");
                userOrganizeAndDep.setOrganizeName(depPathName + (org.springframework.util.StringUtils.isEmpty((Object)depPathName) ? "" : (org.springframework.util.StringUtils.isEmpty((Object)organizeName) ? "" : ",")) + organizeName);
                userOrganizeAndDep.setDepName((String)userOrganizes.get("depName"));
                userOrganizeAndDep.setJobNumber((String)userOrganizes.get("employeeNumber"));
                userOrganizeAndDep.setShopLeader(userOrganizes.get("parentName") != null ? (String)userOrganizes.get("parentName") : "");
                userOrganizeAndDep.setShopIds((String)userOrganizes.get("shopIds"));
                userOrganizeAndDep.setRole((String)userOrganizes.get("roleName"));
                userOrganizeAndDeps.add(userOrganizeAndDep);
            }
            if (userOrganizeAndDeps.size() > 0) {
                userOrganizeAndDepMap = userOrganizeAndDeps.stream().collect(Collectors.toMap(UserOrganizeAndDepVo::getUserId, Function.identity(), (u1, u2) -> u1));
            }
        }
        return userOrganizeAndDepMap;
    }

    @Override
    public List<UnitShowVo> getAllUserTypeData(List<String> userIdList, List<String> roleIdList, List<String> tagIdList, List<String> organizeIdList, Integer enterpriseId) {
        List<UnitShowVo> list = this.getShowListByUserIds(userIdList);
        list.addAll(this.getShowListByRoleIds(roleIdList));
        list.addAll(this.getShowListByTagIds(tagIdList, enterpriseId));
        list.addAll(this.getShowListByOrgIds(organizeIdList));
        return list;
    }

    private List<UnitShowVo> getShowListByUserIds(List<String> userIdList) {
        ArrayList list = Lists.newArrayList();
        if (CollectionUtils.isEmpty(userIdList)) {
            return list;
        }
        List intUserIdList = userIdList.stream().filter(Objects::nonNull).map(Integer::parseInt).collect(Collectors.toList());
        com.ovopark.organize.common.base.BaseResult base = this.userApi.getUserByIdList(intUserIdList);
        if (base == null || CollectionUtils.isEmpty((Collection)((Collection)base.getData()))) {
            return list;
        }
        for (com.ovopark.organize.common.model.pojo.UsersPojo usersPojo : (List)base.getData()) {
            UnitShowVo unitShowVo = new UnitShowVo(usersPojo.getId(), usersPojo.getShowName(), 1);
            unitShowVo.setUnitType(1);
            list.add(unitShowVo);
        }
        return list;
    }

    private List<UnitShowVo> getShowListByRoleIds(List<String> idList) {
        ArrayList list = Lists.newArrayList();
        if (CollectionUtils.isEmpty(idList)) {
            return list;
        }
        List intIdList = idList.stream().filter(Objects::nonNull).map(Integer::parseInt).collect(Collectors.toList());
        BaseResult base = this.roleApi.getRolePojoByIdList(intIdList);
        if (base == null || CollectionUtils.isEmpty((Collection)((Collection)base.getData()))) {
            return list;
        }
        for (RolePojo pojo : (List)base.getData()) {
            UnitShowVo unitShowVo = new UnitShowVo(pojo.getId(), pojo.getRoleName(), 2);
            unitShowVo.setUnitType(3);
            list.add(unitShowVo);
        }
        return list;
    }

    private List<UnitShowVo> getShowListByTagIds(List<String> idList, int enterpriseId) {
        ArrayList list = Lists.newArrayList();
        if (CollectionUtils.isEmpty(idList)) {
            return list;
        }
        DepAndTagsPojo param = new DepAndTagsPojo();
        param.setTagIds(idList.stream().filter(Objects::nonNull).map(Integer::parseInt).collect(Collectors.toList()));
        param.setGroupId(Integer.valueOf(enterpriseId));
        com.ovopark.organize.common.base.BaseResult base = this.tagApi.getUsersTagByIds(param);
        if (base.getIsError().booleanValue() || CollectionUtils.isEmpty((Collection)((Collection)base.getData()))) {
            return list;
        }
        for (UserTagMo pojo : (List)base.getData()) {
            UnitShowVo unitShowVo = new UnitShowVo(pojo.getId(), pojo.getTagName(), 3);
            unitShowVo.setUnitType(2);
            list.add(unitShowVo);
        }
        return list;
    }

    private List<UnitShowVo> getShowListByOrgIds(List<String> idList) {
        ArrayList list = Lists.newArrayList();
        if (CollectionUtils.isEmpty(idList)) {
            return list;
        }
        for (String organizeId : idList) {
            String[] depSplit;
            UnitShowVo unitShowVo;
            OrganizePojo pojo;
            com.ovopark.organize.common.base.BaseResult result;
            if (organizeId.startsWith("O_")) {
                String[] orgSplit = organizeId.split("O_");
                result = this.organizeApi.getOrganizeById(Integer.valueOf(Integer.parseInt(orgSplit[1])));
                if (result.getIsError().booleanValue() || ObjectUtils.isEmpty((Object)result.getData()) || ((OrganizePojo)result.getData()).getId() == null) continue;
                pojo = (OrganizePojo)result.getData();
                unitShowVo = new UnitShowVo(organizeId, pojo.getName(), 4);
                unitShowVo.setUnitType(4);
                list.add(unitShowVo);
                continue;
            }
            if (!organizeId.startsWith("S_") || (result = this.departmentApi.getDepartmentById(Integer.valueOf(Integer.parseInt((depSplit = organizeId.split("S_"))[1])))).getIsError().booleanValue() || ObjectUtils.isEmpty((Object)result.getData()) || ((DepartmentPojo)result.getData()).getId() == null) continue;
            pojo = (DepartmentPojo)result.getData();
            unitShowVo = new UnitShowVo(organizeId, pojo.getName(), 4);
            unitShowVo.setUnitType(4);
            list.add(unitShowVo);
        }
        return list;
    }

    @Override
    public List<Integer> getAllUserId(List<String> userIdList, List<String> roleIdList, List<String> tagIdList, List<String> organizeIdList, Integer groupId, Integer user) {
        List<Integer> tagUserIds;
        List<Integer> orgUserIds;
        List<Integer> roleUserIds;
        List<Object> userIds = Lists.newArrayList();
        if (!CollectionUtils.isEmpty(userIdList)) {
            userIds.addAll(userIdList.stream().map(Integer::parseInt).collect(Collectors.toList()));
        }
        if (!CollectionUtils.isEmpty(roleIdList) && !CollectionUtils.isEmpty(roleUserIds = this.selectUsersByRoles(roleIdList.stream().filter(Objects::nonNull).map(Integer::parseInt).collect(Collectors.toList()), groupId))) {
            userIds.addAll(roleUserIds);
        }
        if (!CollectionUtils.isEmpty(organizeIdList) && !CollectionUtils.isEmpty(orgUserIds = this.selectUserIdsByOrganizeIds(organizeIdList, groupId))) {
            userIds.addAll(orgUserIds);
        }
        if (!CollectionUtils.isEmpty(tagIdList) && !CollectionUtils.isEmpty(tagUserIds = this.selectUserIdsByTagIds(tagIdList.stream().filter(Objects::nonNull).map(Integer::parseInt).collect(Collectors.toList()), groupId, user))) {
            userIds.addAll(tagUserIds);
        }
        if (!CollectionUtils.isEmpty((Collection)userIds)) {
            userIds = userIds.stream().distinct().collect(Collectors.toList());
        }
        return userIds;
    }

    @Override
    public List<Integer> getAllUserId(List<String> userIds, List<String> roleIdList, List<String> tagIdList, List<String> organizeIdList, Integer groupId) {
        return this.getAllUserId(userIds, roleIdList, tagIdList, organizeIdList, groupId, null);
    }

    @Override
    public List<Integer> getSuperAdminByGroupId(Integer enterpriseId) {
        BaseResult base = this.useApi.getSuperAdminByGroupId(enterpriseId);
        if (base != null && !CollectionUtils.isEmpty((Collection)((Collection)base.getData()))) {
            return ((List)base.getData()).stream().map(UsersPojo::getId).collect(Collectors.toList());
        }
        return Lists.newArrayList();
    }
}

