/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.training.service.material;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ovopark.training.mapper.TrainingMaterialMapper;
import com.ovopark.training.model.TrainingMaterial;
import com.ovopark.training.service.material.MaterialService;
import com.ovopark.training.vo.TrainingUserViewTimeVo;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class MaterialServiceImpl
implements MaterialService {
    @Autowired
    private TrainingMaterialMapper materialMapper;

    @Override
    public TrainingMaterial getById(Integer materialId) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(TrainingMaterial::getId, (Object)materialId);
        return (TrainingMaterial)this.materialMapper.selectOne((Wrapper)wrapper);
    }

    @Override
    public BigDecimal getMaterialFinishRate(TrainingMaterial trainingMaterial, Integer viewTime) {
        if (ObjectUtil.isEmpty((Object)trainingMaterial)) {
            return BigDecimal.ZERO;
        }
        if (viewTime == null) {
            return BigDecimal.ZERO;
        }
        BigDecimal finishTime = this.getFinishTime(trainingMaterial);
        if (finishTime.compareTo(new BigDecimal(viewTime)) <= 0) {
            return BigDecimal.ONE;
        }
        return new BigDecimal(viewTime).divide(finishTime, 2, 1);
    }

    private BigDecimal getFinishTime(TrainingMaterial trainingMaterial) {
        BigDecimal finishTime = new BigDecimal("30");
        if (trainingMaterial.getIsVideo() != null && trainingMaterial.getIsVideo() == 1 && trainingMaterial.getDuration() != null && trainingMaterial.getFinishRate() != null) {
            finishTime = new BigDecimal(trainingMaterial.getDuration()).multiply(trainingMaterial.getFinishRate()).divide(new BigDecimal(100), 0, 0);
        } else if (trainingMaterial.getFinishTime() != null) {
            finishTime = new BigDecimal(trainingMaterial.getFinishTime());
        }
        return finishTime;
    }

    @Override
    public Integer getMaterialStudyStatus(Integer trainingMaterialId, Map<Integer, TrainingMaterial> trainingMaterialMap, Map<Integer, List<TrainingUserViewTimeVo>> trainingViewMap, Integer studyStatus) {
        TrainingMaterial trainingMaterial = trainingMaterialMap.get(trainingMaterialId);
        List<TrainingUserViewTimeVo> trainingUserViewTimeVos = trainingViewMap.get(trainingMaterialId);
        if (!CollectionUtils.isEmpty(trainingUserViewTimeVos)) {
            TrainingUserViewTimeVo trainingUserViewTimeVo = trainingUserViewTimeVos.get(0);
            Integer viewTimes = trainingUserViewTimeVo.getViewTimes();
            BigDecimal readRate = this.getMaterialFinishRate(trainingMaterial, viewTimes);
            if (readRate.compareTo(BigDecimal.ONE) >= 0) {
                studyStatus = 3;
            } else if (readRate.compareTo(BigDecimal.ZERO) > 0) {
                studyStatus = 2;
            }
        }
        return studyStatus;
    }
}

