/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.training.service.materialtype;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.ovopark.organize.common.model.mo.DepIdAndFilterTagMo;
import com.ovopark.organize.common.model.pojo.ImportTaskPojo;
import com.ovopark.organize.common.model.pojo.OrganizeTagPojo;
import com.ovopark.organize.common.model.pojo.SimplePojo;
import com.ovopark.organize.common.model.pojo.UsersPojo;
import com.ovopark.organize.sdk.api.ImportTaskApi;
import com.ovopark.organize.sdk.api.OrganizeApi;
import com.ovopark.organize.sdk.api.TagApi;
import com.ovopark.organize.sdk.api.UserApi;
import com.ovopark.privilege.api.RoleApi;
import com.ovopark.privilege.pojo.RolePojo;
import com.ovopark.privilege.response.BaseResult;
import com.ovopark.training.bo.JsonResult;
import com.ovopark.training.domain.MaterialTypePermissionDO;
import com.ovopark.training.enhancer.subject.resp.Result;
import com.ovopark.training.enhancer.subject.resp.ResultUtils;
import com.ovopark.training.event.model.MaterialTypeStatCountByMoveEvent;
import com.ovopark.training.event.model.MaterialTypeStatCountEvent;
import com.ovopark.training.mapper.TrainingMaterialTypeMapper;
import com.ovopark.training.mapper.permission.MaterialTypePermissionMapper;
import com.ovopark.training.model.Authenticator;
import com.ovopark.training.model.TrainingMaterialType;
import com.ovopark.training.model.Users;
import com.ovopark.training.param.material.MaterialTypeQueryParam;
import com.ovopark.training.service.TrainingMaterialService;
import com.ovopark.training.service.UserUtilService;
import com.ovopark.training.service.materialtype.MaterialTypeService;
import com.ovopark.training.service.permission.UnitService;
import com.ovopark.training.service.permission.material.MaterialPermissionFacade;
import com.ovopark.training.service.permission.material.MaterialSinglePermissionService;
import com.ovopark.training.service.permission.material.MaterialTypePermissionService;
import com.ovopark.training.service.resource.ResourceService;
import com.ovopark.training.subject.permission.model.MaterialTypeInfoPermissionVO;
import com.ovopark.training.util.DateUtils;
import com.ovopark.training.util.ExcelUtil;
import com.ovopark.training.util.OssHelper;
import com.ovopark.training.util.TrainModuleUtils;
import com.ovopark.training.vo.BatchMaterialTypeVo;
import com.ovopark.training.vo.TrainingMaterialTypeVo;
import com.ovopark.training.vo.ValidBatchMaterialTypeVo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;
import org.springframework.web.multipart.MultipartFile;

@Service
public class MaterialTypeServiceImpl
implements MaterialTypeService {
    private static final Logger log = LoggerFactory.getLogger(MaterialTypeServiceImpl.class);
    @Autowired
    private TrainingMaterialTypeMapper materialTypeMapper;
    @Autowired
    private UserUtilService userUtilService;
    @Autowired
    private MaterialPermissionFacade materialPermissionFacade;
    @Autowired
    private MaterialSinglePermissionService materialSinglePermissionService;
    @Autowired
    private MessageSource messageSource;
    @Autowired
    private MaterialTypePermissionService materialTypePermissionService;
    @Autowired
    private TrainingMaterialService materialService;
    @Autowired
    private TrainingMaterialTypeMapper trainingMaterialTypeMapper;
    @Autowired
    private TagApi tagApi;
    @Autowired
    private OrganizeApi organizeApi;
    @Autowired
    private RoleApi roleApi;
    @Autowired
    private UserApi userApi;
    @Autowired
    private UnitService unitService;
    @Autowired
    private MaterialTypePermissionMapper materialTypePermissionMapper;
    @Autowired
    private ImportTaskApi importTaskApi;
    @Autowired
    private ResourceService resourceService;

    @Override
    public List<TrainingMaterialTypeVo> selectAllMaterialTypeByPermissionType(MaterialTypeQueryParam queryParam, Users user, int permissionType) {
        List<Integer> validMaterialTypeIdList = this.getMaterialTypeByUserPowerV2(user, permissionType, queryParam.getModuleType());
        if (CollectionUtils.isEmpty(validMaterialTypeIdList)) {
            return Lists.newArrayList();
        }
        HashSet validMaterialTypeIdSet = Sets.newHashSet(validMaterialTypeIdList);
        String queryName = queryParam.getMaterialTypeName();
        Integer moduleType2 = queryParam.getModuleType();
        LambdaQueryWrapper nameLikeQuery = new LambdaQueryWrapper();
        nameLikeQuery.in(TrainingMaterialType::getId, (Collection)validMaterialTypeIdSet);
        if (StringUtils.isNotEmpty((String)queryName)) {
            nameLikeQuery.like(TrainingMaterialType::getMaterialTypeName, (Object)queryName);
        }
        nameLikeQuery.eq(TrainingMaterialType::getModuleType, (Object)moduleType2);
        List targetList = this.materialTypeMapper.selectList((Wrapper)nameLikeQuery);
        if (CollectionUtils.isEmpty((Collection)targetList)) {
            return Lists.newArrayList();
        }
        Map<Integer, TrainingMaterialType> structNodeMap = this.getStructNodeMapByTargetList(targetList);
        Collection structList = structNodeMap.values().stream().sorted(Comparator.comparingInt(TrainingMaterialType::getMaterialTypeLevel).thenComparing(TrainingMaterialType::getSort)).collect(Collectors.toList());
        Map<Integer, List<TrainingMaterialType>> sourceListMap = structList.stream().filter(v -> v.getSourceId() != null).collect(Collectors.groupingBy(TrainingMaterialType::getSourceId));
        Set<Integer> targetIdSet = targetList.stream().map(TrainingMaterialType::getId).collect(Collectors.toSet());
        ArrayList viewList = Lists.newArrayList();
        for (TrainingMaterialType v2 : structList) {
            List<TrainingMaterialTypeVo> childViewList;
            if (v2.getMaterialTypeLevel() != 1) continue;
            TrainingMaterialTypeVo view = MaterialTypeServiceImpl.buildViewByMaterialType(v2);
            if (targetIdSet.contains(v2.getId())) {
                childViewList = this.buildChildView(v2.getId(), sourceListMap, targetIdSet, 2);
                view.setMaterialTypeVoList(childViewList);
                view.setShowLevel(Integer.valueOf(1));
                viewList.add(view);
                continue;
            }
            childViewList = this.buildChildView(v2.getId(), sourceListMap, targetIdSet, 1);
            viewList.addAll(childViewList);
        }
        return viewList;
    }

    private List<TrainingMaterialTypeVo> buildChildView(Integer typeId, Map<Integer, List<TrainingMaterialType>> sourceListMap, Set<Integer> targetIdSet, int level) {
        ArrayList views = Lists.newArrayList();
        List<TrainingMaterialType> childList = sourceListMap.get(typeId);
        if (CollectionUtils.isEmpty(childList)) {
            return views;
        }
        for (TrainingMaterialType child : childList) {
            List<TrainingMaterialTypeVo> nextChildViewList;
            TrainingMaterialTypeVo childView = MaterialTypeServiceImpl.buildViewByMaterialType(child);
            childView.setShowLevel(Integer.valueOf(level));
            if (targetIdSet.contains(child.getId())) {
                nextChildViewList = this.buildChildView(child.getId(), sourceListMap, targetIdSet, level + 1);
                childView.setMaterialTypeVoList(nextChildViewList);
                views.add(childView);
                continue;
            }
            nextChildViewList = this.buildChildView(child.getId(), sourceListMap, targetIdSet, level);
            views.addAll(nextChildViewList);
        }
        return views;
    }

    private Map<Integer, TrainingMaterialType> getStructNodeMapByTargetList(List<TrainingMaterialType> targetList) {
        HashSet idSet = Sets.newHashSet();
        for (TrainingMaterialType trainingMaterialType : targetList) {
            String[] split = StringUtils.split((String)trainingMaterialType.getIdPath(), (String)",");
            idSet.addAll(Arrays.stream(split).map(Integer::parseInt).collect(Collectors.toList()));
        }
        List<TrainingMaterialType> structList = this.getByIdList(idSet);
        structList.addAll(targetList);
        return structList.stream().collect(Collectors.toMap(TrainingMaterialType::getId, v -> v, (v1, v2) -> v1));
    }

    private TrainingMaterialTypeVo getRootNodeAndLoadChild(TrainingMaterialTypeVo targetNode, Map<Integer, TrainingMaterialType> structNodeMap, HashSet<Integer> validMaterialTypeIdSet, Map<Integer, TrainingMaterialTypeVo> existNodeMap) {
        TrainingMaterialType validSourceNode = this.getValidSourceNode(targetNode.getSourceId(), structNodeMap, validMaterialTypeIdSet);
        if (validSourceNode == null) {
            return targetNode;
        }
        existNodeMap.put(targetNode.getId(), targetNode);
        TrainingMaterialTypeVo existResultNode = existNodeMap.get(validSourceNode.getId());
        if (existResultNode != null) {
            existResultNode.getMaterialTypeVoList().add(targetNode);
            return null;
        }
        TrainingMaterialTypeVo sourceViewNode = MaterialTypeServiceImpl.buildViewByMaterialType(validSourceNode);
        sourceViewNode.getMaterialTypeVoList().add(targetNode);
        return this.getRootNodeAndLoadChild(sourceViewNode, structNodeMap, validMaterialTypeIdSet, existNodeMap);
    }

    private List<TrainingMaterialTypeVo> processOrder(List<TrainingMaterialTypeVo> viewList, int level, Map<Integer, TrainingMaterialType> structNodeMap) {
        if (CollectionUtils.isEmpty(viewList)) {
            return viewList;
        }
        viewList = viewList.stream().sorted(Comparator.comparingInt(value -> this.getTargetLevelSort((TrainingMaterialType)value, level, structNodeMap)).thenComparingInt(TrainingMaterialType::getId)).peek(v -> v.setMaterialTypeVoList(this.processOrder(v.getMaterialTypeVoList(), level + 1, structNodeMap))).collect(Collectors.toList());
        return viewList;
    }

    private int getTargetLevelSort(TrainingMaterialType type, int level, Map<Integer, TrainingMaterialType> structNodeMap) {
        if (type.getMaterialTypeLevel() <= level) {
            return type.getSort();
        }
        Integer sourceId = type.getSourceId();
        TrainingMaterialType sourceType = structNodeMap.get(sourceId);
        return this.getTargetLevelSort(sourceType, level, structNodeMap);
    }

    private List<Integer> getAllTypeId(TrainingMaterialTypeVo materialType) {
        return this.getAllTypeId(materialType.getEnterpriseId(), materialType.getModuleType());
    }

    private List<Integer> getAllTypeId(Integer enterpriseId, Integer moduleType2) {
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        if (enterpriseId == null) {
            query.isNull(TrainingMaterialType::getEnterpriseId);
        } else {
            query.eq(TrainingMaterialType::getEnterpriseId, (Object)enterpriseId);
        }
        query.eq(TrainingMaterialType::getModuleType, (Object)moduleType2);
        query.select(new SFunction[]{TrainingMaterialType::getId});
        return this.materialTypeMapper.selectList((Wrapper)query).stream().map(TrainingMaterialType::getId).collect(Collectors.toList());
    }

    private List<TrainingMaterialType> getByIdList(Collection<Integer> idList) {
        if (CollectionUtils.isEmpty(idList)) {
            return Lists.newArrayList();
        }
        LambdaQueryWrapper structQuery = new LambdaQueryWrapper();
        structQuery.in(TrainingMaterialType::getId, idList);
        return this.materialTypeMapper.selectList((Wrapper)structQuery);
    }

    private List<TrainingMaterialType> getByOriginList(Collection<Integer> originList) {
        if (CollectionUtils.isEmpty(originList)) {
            return Lists.newArrayList();
        }
        LambdaQueryWrapper structQuery = new LambdaQueryWrapper();
        structQuery.in(TrainingMaterialType::getOriginId, originList);
        return this.materialTypeMapper.selectList((Wrapper)structQuery);
    }

    private TrainingMaterialType getValidSourceNode(Integer sourceId, Map<Integer, TrainingMaterialType> structNodeMap, HashSet<Integer> validMaterialTypeIdSet) {
        if (sourceId == null || sourceId <= 0) {
            return null;
        }
        TrainingMaterialType sourceNode = structNodeMap.get(sourceId);
        if (sourceNode == null) {
            return null;
        }
        if (validMaterialTypeIdSet.contains(sourceNode.getId())) {
            return sourceNode;
        }
        return this.getValidSourceNode(sourceNode.getSourceId(), structNodeMap, validMaterialTypeIdSet);
    }

    private static TrainingMaterialTypeVo buildViewByMaterialType(TrainingMaterialType materialType) {
        TrainingMaterialTypeVo vo = new TrainingMaterialTypeVo();
        BeanUtils.copyProperties((Object)materialType, (Object)vo);
        vo.setMaterialTypeVoList((List)Lists.newArrayList());
        return vo;
    }

    @Override
    public List<Integer> getMaterialTypeByUserPowerV2(Users user, Integer permissionType, Integer moduleType2) {
        boolean hasGlobal = this.materialPermissionFacade.validGlobal(user, permissionType);
        if (hasGlobal) {
            return this.getAllTypeId(user.getGroupId(), moduleType2);
        }
        Set<Integer> validMaterialTypeIdSet = this.materialTypePermissionService.getValidMaterialTypeIdSet(user, permissionType);
        List<Integer> singleList = this.materialSinglePermissionService.getMaterialTypeIdListByPermissionTypeAndSource(user, permissionType, 2);
        validMaterialTypeIdSet.addAll(singleList);
        return validMaterialTypeIdSet.stream().distinct().collect(Collectors.toList());
    }

    @Override
    public List<Integer> getMaterialTypeByPermissionAndTypeIdList(Users user, Integer permissionType, int moduleType2, Integer materialTypeId, boolean coverChild) {
        if (materialTypeId == null) {
            return this.getMaterialTypeByUserPowerV2(user, permissionType, moduleType2);
        }
        ArrayList resultList = Lists.newArrayList();
        resultList.add(materialTypeId);
        if (coverChild) {
            resultList.addAll(this.getChildTypeIdListNest(materialTypeId));
        }
        Set<Integer> validMaterialTypeIdSet = this.materialPermissionFacade.getValidMaterialTypeIdSet(user, permissionType, resultList);
        return Lists.newArrayList(validMaterialTypeIdSet);
    }

    @Override
    public String getWholePathById(Integer materialTypeId) {
        TrainingMaterialType trainingMaterialType = (TrainingMaterialType)this.materialTypeMapper.selectById(materialTypeId);
        if (ObjectUtils.isEmpty((Object)trainingMaterialType)) {
            return "";
        }
        if (StringUtils.isEmpty((String)trainingMaterialType.getIdPath())) {
            return trainingMaterialType.getMaterialTypeName();
        }
        return this.getPathByIdPath(trainingMaterialType.getIdPath()).concat(trainingMaterialType.getMaterialTypeName());
    }

    @Override
    public Map<Integer, String> getWholePathMap(Collection<Integer> materialTypeIds, Integer isNewSymbol) {
        List<TrainingMaterialType> list = this.getByIdList(materialTypeIds);
        HashSet idSet = Sets.newHashSet();
        for (TrainingMaterialType trainingMaterialType : list) {
            String[] split = StringUtils.split((String)trainingMaterialType.getIdPath(), (String)",");
            idSet.addAll(Arrays.stream(split).map(Integer::parseInt).collect(Collectors.toList()));
        }
        List<TrainingMaterialType> structList = this.getByIdList(idSet);
        structList.addAll(list);
        Map<Integer, TrainingMaterialType> structNodeMap = structList.stream().collect(Collectors.toMap(TrainingMaterialType::getId, v -> v, (v1, v2) -> v1));
        HashMap resultMap = Maps.newHashMap();
        for (Integer typeId : materialTypeIds) {
            String wholePath = this.getWholePath("", typeId, structNodeMap, isNewSymbol);
            resultMap.put(typeId, wholePath);
        }
        return resultMap;
    }

    private String getWholePath(String path, Integer typeId, Map<Integer, TrainingMaterialType> structNodeMap, Integer isNewSymbol) {
        log.info("getWholePath path:{} typeId:{}", (Object)path, (Object)typeId);
        TrainingMaterialType type = structNodeMap.get(typeId);
        String resultPath = StringUtils.isEmpty((String)path) ? type.getMaterialTypeName() : (isNewSymbol != null && isNewSymbol == 1 ? type.getMaterialTypeName() + "->" + path : type.getMaterialTypeName() + " / " + path);
        Integer sourceId = type.getSourceId();
        if (sourceId == null) {
            return resultPath;
        }
        return this.getWholePath(resultPath, sourceId, structNodeMap, isNewSymbol);
    }

    @Override
    public List<Integer> getChildTypeIdListNest(Integer materialTypeId) {
        List<TrainingMaterialType> childList = this.getChildTypeListNest(materialTypeId);
        return childList.stream().map(TrainingMaterialType::getId).collect(Collectors.toList());
    }

    private List<TrainingMaterialType> getChildTypeListNest(Integer materialTypeId) {
        TrainingMaterialType trainingMaterialType = this.getById(materialTypeId);
        if (trainingMaterialType == null) {
            log.warn("materialTypeId not found {}", (Object)materialTypeId);
            return Lists.newArrayList();
        }
        String childIdPathKey = "";
        if (StringUtils.isNotEmpty((String)trainingMaterialType.getIdPath())) {
            childIdPathKey = childIdPathKey + trainingMaterialType.getIdPath() + ",";
        }
        childIdPathKey = childIdPathKey + materialTypeId;
        return this.getListByIdPathStart(childIdPathKey);
    }

    private List<TrainingMaterialType> getListByIdPathStart(String idPathKey) {
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().likeRight(TrainingMaterialType::getIdPath, (Object)idPathKey);
        return this.materialTypeMapper.selectList((Wrapper)queryWrapper);
    }

    @Override
    public String insertMaterialType(TrainingMaterialType materialType) {
        boolean validPermission;
        TrainingMaterialType mt;
        TrainingMaterialTypeVo materialTypeVo = new TrainingMaterialTypeVo();
        Users user = Authenticator.getInstance().getCurrentUser();
        if (user == null) {
            return "INVALID_TOKEN";
        }
        Locale locale = Authenticator.getInstance().getCurrentClient().getLocale();
        Integer sourceId = materialType.getSourceId();
        if (sourceId != null && ObjectUtils.isEmpty((Object)(mt = this.getById(sourceId)))) {
            return JsonResult.error((String)this.messageSource.getMessage("training.material.type.none", null, locale), null);
        }
        if (TrainModuleUtils.permissionEnable(materialType.getModuleType()) && !(validPermission = sourceId != null ? this.materialTypePermissionService.valid(sourceId, user, 3) : this.materialPermissionFacade.validGlobal(user, 3))) {
            return JsonResult.error((String)this.messageSource.getMessage("training.material.not.power.data", null, locale), null);
        }
        if (materialType.getMaterialTypeName().trim().length() > 30) {
            return JsonResult.error((String)this.messageSource.getMessage("training.material.type.over", null, locale), null);
        }
        if (materialType.getModuleType().compareTo(6) != 0) {
            materialType.setEnterpriseId(user.getGroupId());
        }
        materialType.setCreater(user.getId());
        materialType.setUpdater(user.getId());
        materialType.setIdPath(this.buildIdPath(materialType));
        materialType.setOptionExtend(Integer.valueOf(materialType.getOptionExtend() == null ? 0 : materialType.getOptionExtend()));
        materialType.setOptionCover(Integer.valueOf(materialType.getOptionCover() == null ? 0 : materialType.getOptionCover()));
        this.processCoverExtend(materialType);
        Map<String, Object> map = this.materialService.insertMaterialType(materialType);
        String isNum = map.get("isNum").toString();
        if ("0".equals(isNum)) {
            return JsonResult.error((String)this.messageSource.getMessage("training.material.same.type", null, locale), null);
        }
        materialType = (TrainingMaterialType)map.get("materialType");
        if (!ObjectUtils.isEmpty((Object)materialType)) {
            materialTypeVo.setIsPower(Integer.valueOf(1));
            materialTypeVo.setId(materialType.getId());
            materialTypeVo.setMaterialTypeLevel(materialType.getMaterialTypeLevel());
            materialTypeVo.setMaterialTypeName(materialType.getMaterialTypeName());
            materialTypeVo.setModuleType(materialType.getModuleType());
            materialTypeVo.setSort(materialType.getSort());
            materialTypeVo.setEnterpriseId(materialType.getEnterpriseId());
            materialTypeVo.setCreater(materialType.getCreater());
            materialTypeVo.setCreateTime(materialType.getCreateTime());
            materialTypeVo.setSourceId(sourceId);
            materialTypeVo.setOriginId(materialType.getOriginId());
        }
        if (materialType.getMaterialTypeLevel() != null && materialType.getMaterialTypeLevel() == 1 && !ObjectUtils.isEmpty((Object)map.get("total"))) {
            materialTypeVo.setMaterialCount(Integer.valueOf(map.get("total").toString()));
        }
        return JsonResult.success((Object)materialTypeVo);
    }

    @Override
    public void processCoverExtend(TrainingMaterialType materialType) {
        Integer sourceId;
        log.info("\u5904\u7406\u8986\u76d6\u903b\u8f91 {}", (Object)materialType);
        Integer optionCover = materialType.getOptionCover();
        Integer optionExtend = materialType.getOptionExtend();
        if (optionCover == null || optionExtend == null) {
            throw new RuntimeException("optionCover extend\u4e0d\u80fd\u4e3a\u7a7a");
        }
        materialType.setExtendPass(Integer.valueOf(0));
        materialType.setExtend(Integer.valueOf(0));
        if (optionCover == 1) {
            materialType.setExtendPass(Integer.valueOf(1));
        }
        if ((sourceId = materialType.getSourceId()) == null || sourceId <= 0) {
            log.info("\u65e0\u7236\u7ea7\u5206\u7c7b");
            return;
        }
        TrainingMaterialType source = this.getById(sourceId);
        Integer sourceExtendPass = source.getExtendPass();
        if (sourceExtendPass == 1) {
            materialType.setExtend(Integer.valueOf(1));
            materialType.setExtendPass(Integer.valueOf(1));
            materialType.setOptionCover(Integer.valueOf(0));
            materialType.setOptionExtend(Integer.valueOf(0));
        }
        if (optionExtend == 1) {
            materialType.setExtend(Integer.valueOf(1));
        }
    }

    @Override
    public void processChildExtendAndPermission(TrainingMaterialType materialType, Integer preExtendPass) {
        log.info("\u5904\u7406\u5b50\u7c7b\u7ee7\u627f\u903b\u8f91 {} pre: {}", (Object)materialType, (Object)preExtendPass);
        Integer sourceId = materialType.getSourceId();
        Integer currentTypeId = materialType.getId();
        Integer extendPass = materialType.getExtendPass();
        if (extendPass == 1) {
            List<Integer> childTypeIdListNest = this.getChildTypeIdListNest(currentTypeId);
            this.updateExtendAndExtendPassByIdList(childTypeIdListNest, 1);
            this.updateOptionExtendAndOptionCoverByIdList(childTypeIdListNest, 0);
            this.materialTypePermissionService.batchOverridePermissionForExtend(currentTypeId, childTypeIdListNest);
            log.info("\u6240\u6709\u5b50\u7c7b\u7ee7\u627f\u6743\u9650");
            return;
        }
        LambdaQueryWrapper eq = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(TrainingMaterialType::getExtend, (Object)1)).eq(TrainingMaterialType::getSourceId, (Object)currentTypeId);
        List listBySourceIdExtend = this.materialTypeMapper.selectList((Wrapper)eq);
        for (TrainingMaterialType trainingMaterialType : listBySourceIdExtend) {
            this.materialTypePermissionService.overridePermissionForExtend(currentTypeId, trainingMaterialType.getId());
            this.processChildExtendAndPermission(trainingMaterialType, null);
            log.info("\u5b50\u7c7b\u4e3b\u52a8\u7ee7\u627f");
        }
        if (preExtendPass != null && preExtendPass == 1 && extendPass == 0) {
            List<Integer> childTypeIdListNest = this.getChildTypeIdListNest(currentTypeId);
            this.updateExtendAndExtendPassByIdList(childTypeIdListNest, 0);
            log.info("\u6240\u6709\u5b50\u7c7b\u53d6\u6d88\u7ee7\u627f\u6743\u9650");
        }
    }

    private void updateOptionExtendAndOptionCoverByIdList(List<Integer> childTypeIdList, int target) {
        if (CollectionUtils.isEmpty(childTypeIdList)) {
            return;
        }
        int res = this.materialTypeMapper.updateOptionExtendAndOptionCoverByIdList(childTypeIdList, target);
    }

    @Override
    public Result<Object> syncMaterialTypeIdPath(Integer startMaterialTypeId, Integer endMaterialTypeId) {
        log.info("\u7d20\u6750\u5206\u7c7bidPath\u6e05\u6d17 \u5f00\u59cbid{} \u7ed3\u675fid{}", (Object)startMaterialTypeId, (Object)endMaterialTypeId);
        LambdaQueryWrapper materialTypeQuery = new LambdaQueryWrapper();
        materialTypeQuery.between(TrainingMaterialType::getId, (Object)startMaterialTypeId, (Object)endMaterialTypeId);
        materialTypeQuery.eq(TrainingMaterialType::getMaterialTypeLevel, (Object)1);
        materialTypeQuery.in(TrainingMaterialType::getModuleType, (Collection)Lists.newArrayList((Object[])new Integer[]{1, 5}));
        List list = this.materialTypeMapper.selectList((Wrapper)materialTypeQuery);
        int successCount = 0;
        int failCount = 0;
        for (TrainingMaterialType trainingMaterialType : list) {
            boolean success = this.processIdPathByRootType(trainingMaterialType.getId());
            if (success) {
                ++successCount;
                continue;
            }
            log.info("\u7d20\u6750\u5206\u7c7bidPath\u6e05\u6d17\u5931\u8d25 {}", (Object)trainingMaterialType.getId());
            ++failCount;
        }
        HashMap result = Maps.newHashMap();
        result.put("successCount", successCount);
        result.put("failCount", failCount);
        log.info("\u7d20\u6750\u5206\u7c7bidPath\u6e05\u6d17 \u7ed3\u675f {}", (Object)JSON.toJSONString((Object)result));
        return ResultUtils.success((Object)result);
    }

    private boolean processIdPathByRootType(Integer id) {
        List<TrainingMaterialType> byOriginList = this.getByOriginList(Lists.newArrayList((Object[])new Integer[]{id}));
        return this.processIdPathByTypeList(id, byOriginList, true);
    }

    private boolean processIdPathBySourceType(Integer id) {
        List<TrainingMaterialType> childNestList = this.getChildTypeListNest(id);
        return this.processIdPathByTypeList(id, childNestList, false);
    }

    private boolean processIdPathByTypeList(Integer id, List<TrainingMaterialType> childNestList, boolean check) {
        Map<Integer, TrainingMaterialType> idChildMap = childNestList.stream().collect(Collectors.toMap(TrainingMaterialType::getId, v -> v));
        Map<Integer, List<TrainingMaterialType>> levelMap = childNestList.stream().collect(Collectors.groupingBy(TrainingMaterialType::getMaterialTypeLevel));
        Set<Integer> levelSet = levelMap.keySet();
        for (Integer level : levelSet) {
            List<TrainingMaterialType> levelList = levelMap.get(level);
            if (CollectionUtils.isEmpty(levelList)) continue;
            for (TrainingMaterialType trainingMaterialType : levelList) {
                if (level == 1) {
                    throw new RuntimeException("level 1 is not allowed");
                }
                if (level == 2) {
                    String idPath = id + "";
                    this.checkAndUpdateIdPath(trainingMaterialType, idPath, check);
                    continue;
                }
                Integer sourceId = trainingMaterialType.getSourceId();
                TrainingMaterialType source = idChildMap.get(sourceId);
                if (source == null) {
                    log.info("source is null id:{} sourceId:{}", (Object)trainingMaterialType.getId(), (Object)sourceId);
                    continue;
                }
                String idPath = source.getIdPath() + "," + source.getId();
                this.checkAndUpdateIdPath(trainingMaterialType, idPath, check);
            }
        }
        return true;
    }

    private void checkAndUpdateIdPath(TrainingMaterialType trainingMaterialType, String idPath, boolean check) {
        if (!StringUtils.equals((String)idPath, (String)trainingMaterialType.getIdPath())) {
            if (check) {
                log.info("\u68c0\u67e5\u51fa\u5f02\u5e38idPath\u5df2\u81ea\u52a8\u4fee\u590d id:{} sourceIdPath: {}, idPath:{}", new Object[]{trainingMaterialType.getId(), trainingMaterialType.getIdPath(), idPath});
            }
            trainingMaterialType.setIdPath(idPath);
            this.updateIdPathById(trainingMaterialType.getId(), idPath);
        }
    }

    @Override
    public String buildIdPath(TrainingMaterialType trainingMaterialType) {
        return this.buildIdPath(trainingMaterialType.getMaterialTypeLevel(), trainingMaterialType.getSourceId());
    }

    @Override
    public String buildIdPath(Integer materialTypeLevel, Integer sourceId) {
        if (materialTypeLevel == null) {
            throw new RuntimeException("materialTypeLevel is null");
        }
        if (materialTypeLevel == 1) {
            return "";
        }
        if (materialTypeLevel == 2) {
            return String.valueOf(sourceId);
        }
        TrainingMaterialType source = this.getById(sourceId);
        if (source == null) {
            throw new RuntimeException("source is null");
        }
        return source.getIdPath() + "," + source.getId();
    }

    private void updateIdPathById(Integer id, String s) {
        this.materialTypeMapper.updateIdPathById(id, s);
        log.info("updateIdPathById id:{} idPath:{}", (Object)id, (Object)s);
    }

    @Override
    public TrainingMaterialType getById(Integer materialTypeId) {
        return (TrainingMaterialType)this.materialTypeMapper.selectById(materialTypeId);
    }

    @Override
    public void updateOptionExtend(int materialTypeId, int targetExtend) {
        int res = this.materialTypeMapper.updateOptionExtend(materialTypeId, targetExtend);
        log.info("updateOptionExtend materialTypeId:{} targetExtend:{} res:{}", new Object[]{materialTypeId, targetExtend, res});
    }

    @Override
    public void updateOptionCover(int materialTypeId, int cover) {
        int res = this.materialTypeMapper.updateOptionCover(materialTypeId, cover);
        log.info("updateOptionCover materialTypeId:{} cover:{} res:{}", new Object[]{materialTypeId, cover, res});
    }

    @Override
    public List<TrainingMaterialType> getListBySourceId(Integer sourceId) {
        LambdaQueryWrapper eq = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(TrainingMaterialType::getSourceId, (Object)sourceId);
        return this.materialTypeMapper.selectList((Wrapper)eq);
    }

    @Override
    public void updateExtendAndExtendPassByIdList(List<Integer> childList, Integer target) {
        if (CollectionUtils.isEmpty(childList)) {
            return;
        }
        this.materialTypeMapper.updateExtendAndExtendPassByIdList(childList, target);
        log.info("updateExtendAndExtendPassByIdList childList:{} target:{}", childList, (Object)target);
    }

    @Override
    public void updateExtendAndExtendPassById(Integer id, int extend, Integer extendPass) {
        log.info("updateExtendAndExtendPassById id:{} extend:{} extendPass:{}", new Object[]{id, extend, extendPass});
        this.materialTypeMapper.updateExtendAndExtendPassById(id, extend, extendPass);
    }

    @Override
    public void resetIdPathBySource(Integer id) {
        TrainingMaterialType source = this.getById(id);
        this.processIdPathBySourceType(source.getId());
        log.info("resetIdPathBySource id:{} success", (Object)id);
    }

    @Override
    public void updateExtendAndCoverAll(TrainingMaterialType materialType) {
        int res = this.materialTypeMapper.updateExtendAndCoverAll(materialType.getId(), materialType.getOptionCover(), materialType.getOptionExtend(), materialType.getExtend(), materialType.getExtendPass());
        log.info("updateExtendAndCoverAll res:{}", (Object)res);
    }

    @Override
    public Result<MaterialTypeInfoPermissionVO> getInfoWithPermission(Integer materialTypeId, Users user) {
        MaterialTypeInfoPermissionVO view = new MaterialTypeInfoPermissionVO();
        TrainingMaterialType typeInfo = this.getById(materialTypeId);
        TrainingMaterialTypeVo typeView = new TrainingMaterialTypeVo();
        BeanUtils.copyProperties((Object)typeInfo, (Object)typeView);
        typeView.setCreatorName(this.userUtilService.getUserNameById(typeInfo.getCreater()));
        view.setTypeInfo(typeView);
        List list = (List)this.materialTypePermissionService.getList(materialTypeId, user).getData();
        view.setPermissionList(list);
        String path = this.getPathByIdPath(typeInfo.getIdPath());
        if (path.endsWith(" / ")) {
            typeView.setPath(path.substring(0, path.length() - 3));
        } else {
            typeView.setPath(path);
        }
        return ResultUtils.success((Object)view);
    }

    private String getPathByIdPath(String idPath) {
        if (StringUtils.isBlank((String)idPath)) {
            return "";
        }
        String[] split = idPath.split(",");
        ArrayList idList = Lists.newArrayList();
        for (String s : split) {
            idList.add(Integer.valueOf(s));
        }
        List<TrainingMaterialType> list = this.getByIdList(idList);
        StringBuilder sb = new StringBuilder();
        for (TrainingMaterialType trainingMaterialType : list) {
            sb.append(trainingMaterialType.getMaterialTypeName()).append(" / ");
        }
        return sb.toString();
    }

    @Override
    public String downBatchMaterialType(Integer groupId) {
        XSSFWorkbook workbook = new XSSFWorkbook();
        Sheet sheet = workbook.createSheet("\u5bfc\u5165\u5206\u7c7b\u4eba\u5458\u6743\u9650(\u9700\u586b\u5199)");
        sheet.addMergedRegion(new CellRangeAddress(0, 0, 0, 4));
        sheet.setColumnWidth(0, 7680);
        sheet.setColumnWidth(1, 7680);
        sheet.setColumnWidth(2, 7680);
        sheet.setColumnWidth(3, 7680);
        sheet.setColumnWidth(4, 7680);
        Row row0 = sheet.createRow(0);
        row0.setHeightInPoints(110.0f);
        CellStyle cs = workbook.createCellStyle();
        cs.setWrapText(true);
        Cell r0c1 = row0.createCell(0);
        Font font = workbook.createFont();
        font.setColor(IndexedColors.RED.getIndex());
        cs.setFont(font);
        r0c1.setCellStyle(cs);
        r0c1.setCellValue("\u586b\u5199\u987b\u77e5\n1.\u201c*\u201d\u4e3a\u5fc5\u586b\u9879\n2.\u5206\u7c7b\u540d\u79f0\uff1a\u9700\u586b\u5199\u5206\u7c7b\u5168\u8def\u5f84\uff0c\u53ef\u4ece\u5206\u7c7b\u5217\u8868(sheet2)\u4e2d\u590d\u5236\u9700\u8981\u8bbe\u7f6e\u7684\u6743\u9650\u7684\u5206\u7c7b\n3.\u7c7b\u578b\uff1a\u4eba\u5458\u3001\u89d2\u8272\u3001\u6807\u7b7e\u3001\u90e8\u95e8\u3001\u5168\u90e8\u4eba\u5458\n4.\u540d\u79f0\uff1a\u7528\u6237\u540d\u3001\u89d2\u8272\u540d\u79f0\u3001\u6807\u7b7e\u540d\u79f0\u3001\u90e8\u95e8\u540d\u79f0\u3001\u5168\u90e8\u4eba\u5458\n5.\u6743\u9650\uff1a\u67e5\u770b\u3001\u4e0b\u8f7d\u3001\u5206\u53d1\u3001\u7ef4\u62a4\n6.\u8be5\u8868\u683c\u4e0d\u53ef\u65b0\u589e\u5206\u7c7b");
        Row row1 = sheet.createRow(1);
        CellStyle cellStyle = workbook.createCellStyle();
        cellStyle.setWrapText(true);
        cellStyle.setFillForegroundColor(IndexedColors.LIGHT_YELLOW.getIndex());
        cellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        cellStyle.setBorderBottom(BorderStyle.THIN);
        cellStyle.setBorderLeft(BorderStyle.THIN);
        cellStyle.setBorderRight(BorderStyle.THIN);
        cellStyle.setBorderTop(BorderStyle.THIN);
        cellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        Cell r1c0 = row1.createCell(0);
        Font font1 = workbook.createFont();
        font1.setBold(true);
        font1.setFontHeightInPoints((short)12);
        cellStyle.setFont(font1);
        r1c0.setCellStyle(cellStyle);
        r1c0.setCellValue("*\u5206\u7c7b\u540d\u79f0");
        Cell r1c1 = row1.createCell(1);
        r1c1.setCellStyle(cellStyle);
        r1c1.setCellValue("*\u7c7b\u578b");
        Cell r1c2 = row1.createCell(2);
        r1c2.setCellStyle(cellStyle);
        r1c2.setCellValue("*\u540d\u79f0");
        Cell r1c3 = row1.createCell(3);
        r1c3.setCellStyle(cellStyle);
        r1c3.setCellValue("*\u6743\u9650");
        CellStyle cellStyle1 = workbook.createCellStyle();
        cellStyle1.setWrapText(true);
        cellStyle1.setFillForegroundColor(IndexedColors.LIGHT_YELLOW.getIndex());
        cellStyle1.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        cellStyle1.setBorderBottom(BorderStyle.THIN);
        cellStyle1.setBorderLeft(BorderStyle.THIN);
        cellStyle1.setBorderRight(BorderStyle.THIN);
        cellStyle1.setBorderTop(BorderStyle.THIN);
        cellStyle1.setVerticalAlignment(VerticalAlignment.CENTER);
        Row row2 = sheet.createRow(2);
        row2.setHeightInPoints(80.0f);
        Cell r2c0 = row2.createCell(0);
        r2c0.setCellStyle(cellStyle1);
        r2c0.setCellValue("\u9700\u586b\u5199\u5206\u7c7b\u5168\u8def\u5f84\uff0c\u53ef\u4ece\u5206\u7c7b\u5217\u8868(sheet2)\u4e2d\u590d\u5236\u9700\u8981\u8bbe\u7f6e\u7684\u6743\u9650\u7684\u5206\u7c7b\uff0c\u5c42\u7ea7\u95f4\u7528->\u533a\u9694");
        Cell r2c1 = row2.createCell(1);
        r2c1.setCellStyle(cellStyle1);
        r2c1.setCellValue("\u4eba\u5458\u3001\u89d2\u8272\u3001\u6807\u7b7e\u3001\u90e8\u95e8\u3001\u5168\u90e8\u4eba\u5458");
        Cell r2c2 = row2.createCell(2);
        r2c2.setCellStyle(cellStyle1);
        r2c2.setCellValue("\u7528\u6237\u540d\u3001\u89d2\u8272\u540d\u79f0\u3001\u6807\u7b7e\u540d\u79f0\u3001\u90e8\u95e8\u540d\u79f0\u3001\u5168\u90e8\u4eba\u5458\uff0c\u5c42\u7ea7\u95f4\u7528/\u533a\u9694");
        Cell r2c3 = row2.createCell(3);
        r2c3.setCellStyle(cellStyle1);
        r2c3.setCellValue("\u67e5\u770b\u3001\u4e0b\u8f7d\u3001\u5206\u53d1\u3001\u7ef4\u62a4");
        Row row3 = sheet.createRow(3);
        Cell r3c0 = row3.createCell(0);
        r3c0.setCellValue("\u5206\u7c7b\u4e00");
        Cell r3c1 = row3.createCell(1);
        r3c1.setCellValue("\u5168\u90e8\u4eba\u5458");
        Cell r3c2 = row3.createCell(2);
        r3c2.setCellValue("\u5168\u90e8\u4eba\u5458");
        Cell r3c3 = row3.createCell(3);
        r3c3.setCellValue("\u67e5\u770b\u3001\u4e0b\u8f7d\u3001\u5206\u53d1\u3001\u7ef4\u62a4");
        Cell r3c4 = row3.createCell(4);
        r3c4.setCellValue("\u793a\u4f8b\u8bf7\u5220\u9664");
        Row row4 = sheet.createRow(4);
        Cell r4c0 = row4.createCell(0);
        r4c0.setCellValue("\u5206\u7c7b\u4e00->\u5206\u7c7b\u4e8c");
        Cell r4c1 = row4.createCell(1);
        r4c1.setCellValue("\u89d2\u8272");
        Cell r4c2 = row4.createCell(2);
        r4c2.setCellValue("\u7763\u5bfc\u3010\u7cfb\u7edf\u81ea\u5e26\u3011");
        Cell r4c3 = row4.createCell(3);
        r4c3.setCellValue("\u67e5\u770b\u3001\u4e0b\u8f7d");
        Cell r4c4 = row4.createCell(4);
        r4c4.setCellValue("\u793a\u4f8b\u8bf7\u5220\u9664");
        Row row5 = sheet.createRow(5);
        Cell r5c0 = row5.createCell(0);
        r5c0.setCellValue("\u5206\u7c7b\u4e00->\u5206\u7c7b\u4e8c");
        Cell r5c1 = row5.createCell(1);
        r5c1.setCellValue("\u6807\u7b7e");
        Cell r5c2 = row5.createCell(2);
        r5c2.setCellValue("\u6807\u7b7e\u4e00");
        Cell r5c3 = row5.createCell(3);
        r5c3.setCellValue("\u67e5\u770b\u3001\u4e0b\u8f7d");
        Cell r5c4 = row5.createCell(4);
        r5c4.setCellValue("\u793a\u4f8b\u8bf7\u5220\u9664");
        Row row6 = sheet.createRow(6);
        Cell r6c0 = row6.createCell(0);
        r6c0.setCellValue("\u5206\u7c7b\u4e00->\u5206\u7c7b\u4e8c");
        Cell r6c1 = row6.createCell(1);
        r6c1.setCellValue("\u90e8\u95e8");
        Cell r6c2 = row6.createCell(2);
        r6c2.setCellValue("\u4e07\u5e97\u638c/\u82cf\u5dde\u603b\u90e8");
        Cell r6c3 = row6.createCell(3);
        r6c3.setCellValue("\u67e5\u770b\u3001\u4e0b\u8f7d");
        Cell r6c4 = row6.createCell(4);
        r6c4.setCellValue("\u793a\u4f8b\u8bf7\u5220\u9664");
        Row row7 = sheet.createRow(7);
        Cell r7c0 = row7.createCell(0);
        r7c0.setCellValue("\u5206\u7c7b\u4e00->\u5206\u7c7b\u4e8c");
        Cell r7c1 = row7.createCell(1);
        r7c1.setCellValue("\u4eba\u5458");
        Cell r7c2 = row7.createCell(2);
        r7c2.setCellValue("zhangsan");
        Cell r7c3 = row7.createCell(3);
        r7c3.setCellValue("\u67e5\u770b\u3001\u4e0b\u8f7d\u3001\u5206\u53d1\u3001\u7ef4\u62a4");
        Cell r7c4 = row7.createCell(4);
        r7c4.setCellValue("\u793a\u4f8b\u8bf7\u5220\u9664");
        Sheet sheet1 = workbook.createSheet("\u5206\u7c7b\u5217\u8868");
        Row s1r0 = sheet1.createRow(0);
        Cell s1r0c0 = s1r0.createCell(0);
        s1r0c0.setCellValue("\u5206\u7c7b\u540d\u79f0");
        ArrayList<String> typeList = new ArrayList<String>();
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(TrainingMaterialType::getEnterpriseId, (Object)groupId);
        wrapper.eq(TrainingMaterialType::getModuleType, (Object)1);
        wrapper.eq(TrainingMaterialType::getMaterialTypeLevel, (Object)1);
        List list = this.trainingMaterialTypeMapper.selectList((Wrapper)wrapper);
        if (!org.springframework.util.CollectionUtils.isEmpty((Collection)list)) {
            Map<Integer, String> nameMap = this.getWholePathMap(list.stream().map(TrainingMaterialType::getId).collect(Collectors.toList()), 1);
            for (Integer key : nameMap.keySet()) {
                typeList.add(nameMap.get(key));
            }
        }
        LambdaQueryWrapper wrapper2 = new LambdaQueryWrapper();
        wrapper2.eq(TrainingMaterialType::getEnterpriseId, (Object)groupId);
        wrapper2.eq(TrainingMaterialType::getModuleType, (Object)1);
        wrapper2.eq(TrainingMaterialType::getMaterialTypeLevel, (Object)2);
        List list2 = this.trainingMaterialTypeMapper.selectList((Wrapper)wrapper2);
        if (!org.springframework.util.CollectionUtils.isEmpty((Collection)list2)) {
            Map<Integer, String> nameMap = this.getWholePathMap(list2.stream().map(TrainingMaterialType::getId).collect(Collectors.toList()), 1);
            for (Integer key : nameMap.keySet()) {
                typeList.add(nameMap.get(key));
            }
        }
        LambdaQueryWrapper wrapper3 = new LambdaQueryWrapper();
        wrapper3.eq(TrainingMaterialType::getEnterpriseId, (Object)groupId);
        wrapper3.eq(TrainingMaterialType::getModuleType, (Object)1);
        wrapper3.eq(TrainingMaterialType::getMaterialTypeLevel, (Object)3);
        List list3 = this.trainingMaterialTypeMapper.selectList((Wrapper)wrapper3);
        if (!org.springframework.util.CollectionUtils.isEmpty((Collection)list3)) {
            Map<Integer, String> nameMap = this.getWholePathMap(list3.stream().map(TrainingMaterialType::getId).collect(Collectors.toList()), 1);
            for (Integer key : nameMap.keySet()) {
                typeList.add(nameMap.get(key));
            }
        }
        LambdaQueryWrapper wrapper4 = new LambdaQueryWrapper();
        wrapper4.eq(TrainingMaterialType::getEnterpriseId, (Object)groupId);
        wrapper4.eq(TrainingMaterialType::getModuleType, (Object)1);
        wrapper4.eq(TrainingMaterialType::getMaterialTypeLevel, (Object)4);
        List list4 = this.trainingMaterialTypeMapper.selectList((Wrapper)wrapper4);
        if (!org.springframework.util.CollectionUtils.isEmpty((Collection)list4)) {
            Map<Integer, String> nameMap = this.getWholePathMap(list4.stream().map(TrainingMaterialType::getId).collect(Collectors.toList()), 1);
            for (Integer key : nameMap.keySet()) {
                typeList.add(nameMap.get(key));
            }
        }
        LambdaQueryWrapper wrapper5 = new LambdaQueryWrapper();
        wrapper5.eq(TrainingMaterialType::getEnterpriseId, (Object)groupId);
        wrapper5.eq(TrainingMaterialType::getModuleType, (Object)1);
        wrapper5.eq(TrainingMaterialType::getMaterialTypeLevel, (Object)5);
        List list5 = this.trainingMaterialTypeMapper.selectList((Wrapper)wrapper5);
        if (!org.springframework.util.CollectionUtils.isEmpty((Collection)list5)) {
            Map<Integer, String> nameMap = this.getWholePathMap(list5.stream().map(TrainingMaterialType::getId).collect(Collectors.toList()), 1);
            for (Integer key : nameMap.keySet()) {
                typeList.add(nameMap.get(key));
            }
        }
        for (int i = 0; i < typeList.size(); ++i) {
            Row s1r = sheet1.createRow(i + 1);
            Cell s1r0c = s1r.createCell(0);
            s1r0c.setCellValue((String)typeList.get(i));
        }
        String fileUrl = OssHelper.uploadExcel((Workbook)workbook, "\u6279\u91cf\u5bfc\u5165\u5206\u7c7b\u6743\u9650\u6a21\u677f" + DateUtils.format(new Date(), "yyyyMMddHHmm") + ".xlsx");
        return JsonResult.success((Object)fileUrl);
    }

    private String getErrorMaterialType(Map<BatchMaterialTypeVo, String> errorMap, Integer enterpriseId) {
        XSSFWorkbook workbook = new XSSFWorkbook();
        Sheet sheet = workbook.createSheet("\u5bfc\u5165\u5206\u7c7b\u4eba\u5458\u6743\u9650(\u9700\u586b\u5199)");
        sheet.addMergedRegion(new CellRangeAddress(0, 0, 1, 4));
        sheet.setColumnWidth(0, 7680);
        sheet.setColumnWidth(1, 7680);
        sheet.setColumnWidth(2, 7680);
        sheet.setColumnWidth(3, 7680);
        sheet.setColumnWidth(4, 7680);
        Row row0 = sheet.createRow(0);
        row0.setHeightInPoints(110.0f);
        CellStyle cs = workbook.createCellStyle();
        cs.setWrapText(true);
        Cell r0c1 = row0.createCell(1);
        Font font = workbook.createFont();
        font.setColor(IndexedColors.RED.getIndex());
        cs.setFont(font);
        r0c1.setCellStyle(cs);
        r0c1.setCellValue("\u586b\u5199\u987b\u77e5\n1.\u201c*\u201d\u4e3a\u5fc5\u586b\u9879\n2.\u5206\u7c7b\u540d\u79f0\uff1a\u9700\u586b\u5199\u5206\u7c7b\u5168\u8def\u5f84\uff0c\u53ef\u4ece\u5206\u7c7b\u5217\u8868(sheet2)\u4e2d\u590d\u5236\u9700\u8981\u8bbe\u7f6e\u7684\u6743\u9650\u7684\u5206\u7c7b\n3.\u7c7b\u578b\uff1a\u4eba\u5458\u3001\u89d2\u8272\u3001\u6807\u7b7e\u3001\u90e8\u95e8\u3001\u5168\u90e8\u4eba\u5458\n4.\u540d\u79f0\uff1a\u7528\u6237\u540d\u3001\u89d2\u8272\u540d\u79f0\u3001\u6807\u7b7e\u540d\u79f0\u3001\u90e8\u95e8\u540d\u79f0\u3001\u5168\u90e8\u4eba\u5458\n5.\u6743\u9650\uff1a\u67e5\u770b\u3001\u4e0b\u8f7d\u3001\u5206\u53d1\u3001\u7ef4\u62a4\n6.\u8be5\u8868\u683c\u4e0d\u53ef\u65b0\u589e\u5206\u7c7b");
        Row row1 = sheet.createRow(1);
        CellStyle cellStyle = workbook.createCellStyle();
        cellStyle.setWrapText(true);
        cellStyle.setFillForegroundColor(IndexedColors.LIGHT_YELLOW.getIndex());
        cellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        cellStyle.setBorderBottom(BorderStyle.THIN);
        cellStyle.setBorderLeft(BorderStyle.THIN);
        cellStyle.setBorderRight(BorderStyle.THIN);
        cellStyle.setBorderTop(BorderStyle.THIN);
        cellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        Font font1 = workbook.createFont();
        font1.setBold(true);
        font1.setFontHeightInPoints((short)12);
        cellStyle.setFont(font1);
        Cell r1c0 = row1.createCell(0);
        r1c0.setCellStyle(cellStyle);
        r1c0.setCellValue("\u9519\u8bef\u63d0\u793a\u5217");
        Cell r1c1 = row1.createCell(1);
        r1c1.setCellStyle(cellStyle);
        r1c1.setCellValue("*\u5206\u7c7b\u540d\u79f0");
        Cell r1c2 = row1.createCell(2);
        r1c2.setCellStyle(cellStyle);
        r1c2.setCellValue("*\u7c7b\u578b");
        Cell r1c3 = row1.createCell(3);
        r1c3.setCellStyle(cellStyle);
        r1c3.setCellValue("*\u540d\u79f0");
        Cell r1c4 = row1.createCell(4);
        r1c4.setCellStyle(cellStyle);
        r1c4.setCellValue("*\u6743\u9650");
        CellStyle cellStyle1 = workbook.createCellStyle();
        cellStyle1.setWrapText(true);
        cellStyle1.setFillForegroundColor(IndexedColors.LIGHT_YELLOW.getIndex());
        cellStyle1.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        cellStyle1.setBorderBottom(BorderStyle.THIN);
        cellStyle1.setBorderLeft(BorderStyle.THIN);
        cellStyle1.setBorderRight(BorderStyle.THIN);
        cellStyle1.setBorderTop(BorderStyle.THIN);
        cellStyle1.setVerticalAlignment(VerticalAlignment.CENTER);
        Row row2 = sheet.createRow(2);
        row2.setHeightInPoints(80.0f);
        Cell r2c0 = row2.createCell(0);
        r2c0.setCellStyle(cellStyle1);
        r2c0.setCellValue("\u8bf7\u4fee\u6539\u8868\u683c\u4e2d\u63d0\u793a\u7684\u9519\u8bef\u540e\uff0c\u5220\u9664A\u5217\uff08\u9519\u8bef\u63d0\u793a\u5217\uff09\uff0c\u7136\u540e\u91cd\u65b0\u5bfc\u5165\u8868\u683c");
        Cell r2c1 = row2.createCell(1);
        r2c1.setCellStyle(cellStyle1);
        r2c1.setCellValue("\u9700\u586b\u5199\u5206\u7c7b\u5168\u8def\u5f84\uff0c\u53ef\u4ece\u5206\u7c7b\u5217\u8868(sheet2)\u4e2d\u590d\u5236\u9700\u8981\u8bbe\u7f6e\u7684\u6743\u9650\u7684\u5206\u7c7b\uff0c\u5c42\u7ea7\u95f4\u7528->\u533a\u9694");
        Cell r2c2 = row2.createCell(2);
        r2c2.setCellStyle(cellStyle1);
        r2c2.setCellValue("\u4eba\u5458\u3001\u89d2\u8272\u3001\u6807\u7b7e\u3001\u90e8\u95e8\u3001\u5168\u90e8\u4eba\u5458");
        Cell r2c3 = row2.createCell(3);
        r2c3.setCellStyle(cellStyle1);
        r2c3.setCellValue("\u7528\u6237\u540d\u3001\u89d2\u8272\u540d\u79f0\u3001\u6807\u7b7e\u540d\u79f0\u3001\u90e8\u95e8\u540d\u79f0\u3001\u5168\u90e8\u4eba\u5458\uff0c\u5c42\u7ea7\u95f4\u7528/\u533a\u9694");
        Cell r2c4 = row2.createCell(4);
        r2c4.setCellStyle(cellStyle1);
        r2c4.setCellValue("\u67e5\u770b\u3001\u4e0b\u8f7d\u3001\u5206\u53d1\u3001\u7ef4\u62a4");
        int i = 3;
        for (BatchMaterialTypeVo key : errorMap.keySet()) {
            Row row = sheet.createRow(i);
            Cell cell0 = row.createCell(0);
            cell0.setCellValue(errorMap.get(key));
            Cell cell1 = row.createCell(1);
            cell1.setCellValue(key.getMaterialTypeName());
            Cell cell2 = row.createCell(2);
            cell2.setCellValue(key.getUnitName());
            Cell cell3 = row.createCell(3);
            cell3.setCellValue(key.getUnitDetailName());
            Cell cell4 = row.createCell(4);
            cell4.setCellValue(key.getPermissionTypeName());
            ++i;
        }
        Sheet sheet1 = workbook.createSheet("\u5206\u7c7b\u5217\u8868");
        Row s1r0 = sheet1.createRow(0);
        Cell s1r0c0 = s1r0.createCell(0);
        s1r0c0.setCellValue("\u5206\u7c7b\u540d\u79f0");
        ArrayList<String> typeList = new ArrayList<String>();
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(TrainingMaterialType::getEnterpriseId, (Object)enterpriseId);
        wrapper.eq(TrainingMaterialType::getModuleType, (Object)1);
        wrapper.eq(TrainingMaterialType::getMaterialTypeLevel, (Object)1);
        List list = this.trainingMaterialTypeMapper.selectList((Wrapper)wrapper);
        if (!org.springframework.util.CollectionUtils.isEmpty((Collection)list)) {
            Map<Integer, String> nameMap = this.getWholePathMap(list.stream().map(TrainingMaterialType::getId).collect(Collectors.toList()), 1);
            for (Integer key : nameMap.keySet()) {
                typeList.add(nameMap.get(key));
            }
        }
        LambdaQueryWrapper wrapper2 = new LambdaQueryWrapper();
        wrapper2.eq(TrainingMaterialType::getEnterpriseId, (Object)enterpriseId);
        wrapper2.eq(TrainingMaterialType::getModuleType, (Object)1);
        wrapper2.eq(TrainingMaterialType::getMaterialTypeLevel, (Object)2);
        List list2 = this.trainingMaterialTypeMapper.selectList((Wrapper)wrapper2);
        if (!org.springframework.util.CollectionUtils.isEmpty((Collection)list2)) {
            Map<Integer, String> nameMap = this.getWholePathMap(list2.stream().map(TrainingMaterialType::getId).collect(Collectors.toList()), 1);
            for (Integer key : nameMap.keySet()) {
                typeList.add(nameMap.get(key));
            }
        }
        LambdaQueryWrapper wrapper3 = new LambdaQueryWrapper();
        wrapper3.eq(TrainingMaterialType::getEnterpriseId, (Object)enterpriseId);
        wrapper3.eq(TrainingMaterialType::getModuleType, (Object)1);
        wrapper3.eq(TrainingMaterialType::getMaterialTypeLevel, (Object)3);
        List list3 = this.trainingMaterialTypeMapper.selectList((Wrapper)wrapper3);
        if (!org.springframework.util.CollectionUtils.isEmpty((Collection)list3)) {
            Map<Integer, String> nameMap = this.getWholePathMap(list3.stream().map(TrainingMaterialType::getId).collect(Collectors.toList()), 1);
            for (Integer key : nameMap.keySet()) {
                typeList.add(nameMap.get(key));
            }
        }
        LambdaQueryWrapper wrapper4 = new LambdaQueryWrapper();
        wrapper4.eq(TrainingMaterialType::getEnterpriseId, (Object)enterpriseId);
        wrapper4.eq(TrainingMaterialType::getModuleType, (Object)1);
        wrapper4.eq(TrainingMaterialType::getMaterialTypeLevel, (Object)4);
        List list4 = this.trainingMaterialTypeMapper.selectList((Wrapper)wrapper4);
        if (!org.springframework.util.CollectionUtils.isEmpty((Collection)list4)) {
            Map<Integer, String> nameMap = this.getWholePathMap(list4.stream().map(TrainingMaterialType::getId).collect(Collectors.toList()), 1);
            for (Integer key : nameMap.keySet()) {
                typeList.add(nameMap.get(key));
            }
        }
        LambdaQueryWrapper wrapper5 = new LambdaQueryWrapper();
        wrapper5.eq(TrainingMaterialType::getEnterpriseId, (Object)enterpriseId);
        wrapper5.eq(TrainingMaterialType::getModuleType, (Object)1);
        wrapper5.eq(TrainingMaterialType::getMaterialTypeLevel, (Object)5);
        List list5 = this.trainingMaterialTypeMapper.selectList((Wrapper)wrapper5);
        if (!org.springframework.util.CollectionUtils.isEmpty((Collection)list5)) {
            Map<Integer, String> nameMap = this.getWholePathMap(list5.stream().map(TrainingMaterialType::getId).collect(Collectors.toList()), 1);
            for (Integer key : nameMap.keySet()) {
                typeList.add(nameMap.get(key));
            }
        }
        for (int j = 0; j < typeList.size(); ++j) {
            Row s1r = sheet1.createRow(j + 1);
            Cell s1r0c = s1r.createCell(0);
            s1r0c.setCellValue((String)typeList.get(j));
        }
        String fileUrl = OssHelper.uploadExcel((Workbook)workbook, "\u6279\u91cf\u5bfc\u5165\u5206\u7c7b\u6743\u9650\u6a21\u677f\u9519\u8bef\u62a5\u544a" + DateUtils.format(new Date(), "yyyyMMddHHmm") + ".xlsx");
        return fileUrl;
    }

    private ValidBatchMaterialTypeVo validBatchMaterialTypeData(Users user, MultipartFile file) {
        ValidBatchMaterialTypeVo result = new ValidBatchMaterialTypeVo();
        Workbook workbook = null;
        try {
            Sheet sheet;
            Row row2;
            workbook = ExcelUtil.getWorkbook(file.getInputStream(), file.getOriginalFilename());
            if (null == workbook) {
                result.setErrorMsg("\u521b\u5efaExcel\u5de5\u4f5c\u8584\u4e3a\u7a7a\uff01");
            }
            if ((row2 = (sheet = workbook.getSheetAt(0)).getRow(1)).getCell(0) == null || row2.getCell(1) == null || row2.getCell(2) == null || row2.getCell(3) == null) {
                result.setErrorMsg("\u6a21\u677f\u9519\u8bef");
                return result;
            }
            if (!row2.getCell(0).getStringCellValue().contains("\u5206\u7c7b\u540d\u79f0")) {
                result.setErrorMsg("\u65e0\u5206\u7c7b\u540d\u79f0");
                return result;
            }
            if (!row2.getCell(1).getStringCellValue().contains("\u7c7b\u578b")) {
                result.setErrorMsg("\u65e0\u7c7b\u578b");
                return result;
            }
            if (!row2.getCell(2).getStringCellValue().contains("\u540d\u79f0")) {
                result.setErrorMsg("\u65e0\u540d\u79f0");
                return result;
            }
            if (!row2.getCell(3).getStringCellValue().contains("\u6743\u9650")) {
                result.setErrorMsg("\u65e0\u6743\u9650");
                return result;
            }
            HashMap<BatchMaterialTypeVo, String> errorMap = new HashMap<BatchMaterialTypeVo, String>();
            ArrayList<BatchMaterialTypeVo> successData = new ArrayList<BatchMaterialTypeVo>();
            result.setTotalCount(sheet.getLastRowNum() - 2);
            ArrayList<BatchMaterialTypeVo> list = new ArrayList<BatchMaterialTypeVo>();
            for (int i = 3; i <= sheet.getLastRowNum(); ++i) {
                BatchMaterialTypeVo vo = new BatchMaterialTypeVo();
                Row row = sheet.getRow(i);
                if (row == null) continue;
                vo.setEnterpriseId(user.getGroupId());
                vo.setUserId(user.getId());
                vo.setMaterialTypeName(ExcelUtil.getCellValue(row.getCell(0)));
                vo.setUnitName(ExcelUtil.getCellValue(row.getCell(1)));
                vo.setUnitDetailName(ExcelUtil.getCellValue(row.getCell(2)));
                vo.setPermissionTypeName(ExcelUtil.getCellValue(row.getCell(3)));
                list.add(vo);
            }
            for (BatchMaterialTypeVo vo : list) {
                if (StringUtils.isEmpty((String)vo.getMaterialTypeName())) continue;
                String[] nameStrs = vo.getMaterialTypeName().split("->");
                LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
                wrapper.eq(TrainingMaterialType::getEnterpriseId, (Object)vo.getEnterpriseId());
                wrapper.eq(TrainingMaterialType::getMaterialTypeName, (Object)nameStrs[nameStrs.length - 1]);
                wrapper.eq(TrainingMaterialType::getMaterialTypeLevel, (Object)nameStrs.length);
                List typeList = this.trainingMaterialTypeMapper.selectList((Wrapper)wrapper);
                if (CollectionUtils.isEmpty((Collection)typeList)) {
                    errorMap.put(vo, "\u5206\u7c7b\u4e0d\u5b58\u5728");
                    continue;
                }
                Map<Integer, String> nameMap = this.getWholePathMap(typeList.stream().map(TrainingMaterialType::getId).collect(Collectors.toList()), 1);
                int dataNum = 0;
                Integer materialTypeId = null;
                for (Integer key : nameMap.keySet()) {
                    if (!nameMap.get(key).equals(vo.getMaterialTypeName())) continue;
                    ++dataNum;
                    materialTypeId = key;
                }
                if (dataNum == 0) {
                    errorMap.put(vo, "\u5206\u7c7b\u4e0d\u5b58\u5728");
                    continue;
                }
                if (dataNum > 1) {
                    errorMap.put(vo, "\u5206\u7c7b\u91cd\u590d");
                    continue;
                }
                TrainingMaterialType type = (TrainingMaterialType)this.trainingMaterialTypeMapper.selectById(materialTypeId);
                if (type != null && type.getExtend() == 1) {
                    errorMap.put(vo, "\u5f53\u524d\u5206\u7c7b\u7ee7\u627f\u4e86\u7236\u7ea7\u5206\u7c7b\u6743\u9650\uff0c\u65e0\u6cd5\u4fee\u6539");
                    continue;
                }
                ArrayList<String> typeNameList = new ArrayList<String>();
                typeNameList.add("\u4eba\u5458");
                typeNameList.add("\u89d2\u8272");
                typeNameList.add("\u6807\u7b7e");
                typeNameList.add("\u90e8\u95e8");
                typeNameList.add("\u5168\u90e8\u4eba\u5458");
                if (!typeNameList.contains(vo.getUnitName())) {
                    errorMap.put(vo, "\u7c7b\u578b\u4e0d\u5b58\u5728");
                    continue;
                }
                if (vo.getUnitName().equals("\u5168\u90e8\u4eba\u5458")) {
                    if (!vo.getUnitDetailName().equals("\u5168\u90e8\u4eba\u5458")) {
                        errorMap.put(vo, "\u540d\u79f0\u9519\u8bef");
                        continue;
                    }
                } else if (vo.getUnitName().equals("\u90e8\u95e8")) {
                    DepIdAndFilterTagMo mo = new DepIdAndFilterTagMo();
                    ArrayList<String> organizeList = new ArrayList<String>();
                    organizeList.add(vo.getUnitDetailName());
                    mo.setGroupId(user.getGroupId());
                    mo.setOrganizeIds(organizeList);
                    mo.setUserId(vo.getUserId());
                    com.ovopark.organize.common.base.BaseResult orgResult = this.organizeApi.getOrganizeIdByPath(mo);
                    if (orgResult.getIsError().booleanValue() || CollectionUtils.isEmpty((Collection)((Collection)orgResult.getData()))) {
                        errorMap.put(vo, "\u540d\u79f0\u9519\u8bef");
                        continue;
                    }
                } else if (vo.getUnitName().equals("\u6807\u7b7e")) {
                    OrganizeTagPojo tagPojo = new OrganizeTagPojo();
                    tagPojo.setUserId(vo.getUserId());
                    tagPojo.setGroupId(vo.getEnterpriseId());
                    ArrayList<String> tagNameList = new ArrayList<String>();
                    tagNameList.add(vo.getUnitDetailName());
                    tagPojo.setTagNames(tagNameList);
                    com.ovopark.organize.common.base.BaseResult tagResult = this.tagApi.getUserTagIdByName(tagPojo);
                    if (tagResult.getIsError().booleanValue() || CollectionUtils.isEmpty((Collection)((Collection)tagResult.getData()))) {
                        errorMap.put(vo, "\u540d\u79f0\u9519\u8bef");
                        continue;
                    }
                } else if (vo.getUnitName().equals("\u89d2\u8272")) {
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    map.put("roleName", vo.getUnitDetailName());
                    map.put("groupId", user.getGroupId());
                    BaseResult roleResult = this.roleApi.getRoleByName(map);
                    if (roleResult.getIsError().booleanValue() || roleResult.getData() == null) {
                        errorMap.put(vo, "\u540d\u79f0\u9519\u8bef");
                        continue;
                    }
                } else if (vo.getUnitName().equals("\u4eba\u5458")) {
                    ArrayList<String> userNameList = new ArrayList<String>();
                    userNameList.add(vo.getUnitDetailName());
                    com.ovopark.organize.common.base.BaseResult userResult = this.userApi.getUserByUserNames(vo.getEnterpriseId(), userNameList);
                    if (userResult.getIsError().booleanValue() || CollectionUtils.isEmpty((Collection)((Collection)userResult.getData()))) {
                        errorMap.put(vo, "\u540d\u79f0\u9519\u8bef");
                        continue;
                    }
                }
                ArrayList<String> permissionTypeNameList = new ArrayList<String>();
                permissionTypeNameList.add("\u67e5\u770b");
                permissionTypeNameList.add("\u4e0b\u8f7d");
                permissionTypeNameList.add("\u5206\u53d1");
                permissionTypeNameList.add("\u7ef4\u62a4");
                String[] permissionTypeNameStrs = vo.getPermissionTypeName().split("\u3001");
                for (int i = 0; i < permissionTypeNameStrs.length; ++i) {
                    if (permissionTypeNameList.contains(permissionTypeNameStrs[i])) continue;
                    errorMap.put(vo, "\u6743\u9650\u4e0d\u5b58\u5728");
                    break;
                }
                successData.add(vo);
            }
            result.setErrorData(errorMap);
            result.setSuccessData(successData);
            return result;
        }
        catch (Exception e) {
            e.printStackTrace();
            result.setErrorMsg("\u6a21\u677f\u9519\u8bef");
            return result;
        }
    }

    @Override
    public String validBatchMaterialType(Users user, MultipartFile file) {
        ValidBatchMaterialTypeVo result = this.validBatchMaterialTypeData(user, file);
        if (!result.getErrorData().isEmpty()) {
            return JsonResult.error(null, (Object)result.getErrorData());
        }
        return JsonResult.success();
    }

    @Override
    public String importBatchMaterialType(Users user, MultipartFile file, Integer taskId) {
        try {
            ValidBatchMaterialTypeVo result = this.validBatchMaterialTypeData(user, file);
            List successList = result.getSuccessData();
            Map errirList = result.getErrorData();
            Workbook workbook = ExcelUtil.getWorkbook(file.getInputStream(), file.getOriginalFilename());
            String fileUrl = OssHelper.uploadExcel(workbook, file.getOriginalFilename());
            if (!StringUtils.isEmpty((String)result.getErrorMsg())) {
                ImportTaskPojo pojo = new ImportTaskPojo();
                pojo.setId(taskId);
                pojo.setCreateTime(new Date());
                pojo.setCreateId(user.getId());
                pojo.setGroupId(user.getGroupId());
                pojo.setModuleType(Integer.valueOf(11));
                pojo.setTaskType(Integer.valueOf(1));
                pojo.setName("\u5bfc\u5165\u5206\u7c7b\u6743\u9650:" + DateUtils.getDateStr(new Date(), "yyyyMMddHHmmss"));
                pojo.setRepeatType(Integer.valueOf(1));
                pojo.setUniqueKey("name");
                pojo.setUserId(user.getId());
                pojo.setUrl(fileUrl);
                pojo.setStatus(Integer.valueOf(3));
                pojo.setMessage(result.getErrorMsg());
                pojo.setSuccessCount(Integer.valueOf(0));
                pojo.setErrorCount(Integer.valueOf(CollectionUtils.size((Object)errirList)));
                com.ovopark.organize.common.base.BaseResult INFO = this.importTaskApi.saveImportTask(pojo);
                log.info("importBatchMaterialTypeResult:{}", (Object)JSONObject.toJSONString((Object)INFO));
                return JsonResult.success();
            }
            ArrayList<MaterialTypePermissionDO> addList = new ArrayList<MaterialTypePermissionDO>();
            if (!CollectionUtils.isEmpty((Collection)successList)) {
                for (Object vo : successList) {
                    Long unitId;
                    MaterialTypePermissionDO permission = new MaterialTypePermissionDO();
                    permission.setEnterpriseId(vo.getEnterpriseId());
                    permission.setSourceType(Integer.valueOf(0));
                    String[] nameStrs = vo.getMaterialTypeName().split("->");
                    LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
                    wrapper.eq(TrainingMaterialType::getEnterpriseId, (Object)vo.getEnterpriseId());
                    wrapper.eq(TrainingMaterialType::getMaterialTypeName, (Object)nameStrs[nameStrs.length - 1]);
                    wrapper.eq(TrainingMaterialType::getMaterialTypeLevel, (Object)nameStrs.length);
                    List typeList = this.trainingMaterialTypeMapper.selectList((Wrapper)wrapper);
                    Map<Integer, String> nameMap = this.getWholePathMap(typeList.stream().map(TrainingMaterialType::getId).collect(Collectors.toList()), 1);
                    for (Integer key : nameMap.keySet()) {
                        if (!nameMap.get(key).equals(vo.getMaterialTypeName())) continue;
                        permission.setMaterialTypeId(key);
                        break;
                    }
                    if (vo.getUnitName().equals("\u5168\u90e8\u4eba\u5458")) {
                        permission.setPermissionType(Integer.valueOf(9));
                        Long unitId2 = this.unitService.getIdByBizIdAndType("1", 9, vo.getEnterpriseId());
                        permission.setUnitId(unitId2);
                    } else if (vo.getUnitName().equals("\u90e8\u95e8")) {
                        DepIdAndFilterTagMo mo = new DepIdAndFilterTagMo();
                        ArrayList<String> organizeList = new ArrayList<String>();
                        organizeList.add(vo.getUnitDetailName());
                        mo.setGroupId(user.getGroupId());
                        mo.setOrganizeIds(organizeList);
                        mo.setUserId(vo.getUserId());
                        com.ovopark.organize.common.base.BaseResult orgResult = this.organizeApi.getOrganizeIdByPath(mo);
                        if (!orgResult.getIsError().booleanValue() && !CollectionUtils.isEmpty((Collection)((Collection)orgResult.getData()))) {
                            permission.setPermissionType(Integer.valueOf(4));
                            unitId = this.unitService.getIdByBizIdAndType("O_" + ((SimplePojo)((List)orgResult.getData()).get(0)).getId(), 4, vo.getEnterpriseId());
                            permission.setUnitId(unitId);
                        }
                    } else if (vo.getUnitName().equals("\u6807\u7b7e")) {
                        OrganizeTagPojo tagPojo = new OrganizeTagPojo();
                        tagPojo.setUserId(vo.getUserId());
                        tagPojo.setGroupId(vo.getEnterpriseId());
                        ArrayList<String> tagNameList = new ArrayList<String>();
                        tagNameList.add(vo.getUnitDetailName());
                        tagPojo.setTagNames(tagNameList);
                        com.ovopark.organize.common.base.BaseResult tagResult = this.tagApi.getUserTagIdByName(tagPojo);
                        if (!tagResult.getIsError().booleanValue() && !CollectionUtils.isEmpty((Collection)((Collection)tagResult.getData()))) {
                            permission.setPermissionType(Integer.valueOf(2));
                            unitId = this.unitService.getIdByBizIdAndType(((SimplePojo)((List)tagResult.getData()).get(0)).getId().toString(), 2, vo.getEnterpriseId());
                            permission.setUnitId(unitId);
                        }
                    } else if (vo.getUnitName().equals("\u89d2\u8272")) {
                        HashMap<String, Object> map = new HashMap<String, Object>();
                        map.put("roleName", vo.getUnitDetailName());
                        map.put("groupId", user.getGroupId());
                        BaseResult roleResult = this.roleApi.getRoleByName(map);
                        if (!roleResult.getIsError().booleanValue() && roleResult.getData() != null) {
                            permission.setPermissionType(Integer.valueOf(3));
                            Long unitId3 = this.unitService.getIdByBizIdAndType(((RolePojo)roleResult.getData()).getId().toString(), 3, vo.getEnterpriseId());
                            permission.setUnitId(unitId3);
                        }
                    } else if (vo.getUnitName().equals("\u4eba\u5458")) {
                        ArrayList<String> userNameList = new ArrayList<String>();
                        userNameList.add(vo.getUnitDetailName());
                        com.ovopark.organize.common.base.BaseResult userResult = this.userApi.getUserByUserNames(vo.getEnterpriseId(), userNameList);
                        if (!userResult.getIsError().booleanValue() && !CollectionUtils.isEmpty((Collection)((Collection)userResult.getData()))) {
                            permission.setPermissionType(Integer.valueOf(1));
                            Long unitId4 = this.unitService.getIdByBizIdAndType(((UsersPojo)((List)userResult.getData()).get(0)).getId().toString(), 1, vo.getEnterpriseId());
                            permission.setUnitId(unitId4);
                        }
                    }
                    LambdaQueryWrapper permissionWrapper = new LambdaQueryWrapper();
                    permissionWrapper.eq(MaterialTypePermissionDO::getMaterialTypeId, (Object)permission.getMaterialTypeId());
                    permissionWrapper.eq(MaterialTypePermissionDO::getEnterpriseId, (Object)permission.getEnterpriseId());
                    permissionWrapper.eq(MaterialTypePermissionDO::getUnitId, (Object)permission.getUnitId());
                    permissionWrapper.eq(MaterialTypePermissionDO::getDeleted, (Object)0);
                    this.materialTypePermissionMapper.delete((Wrapper)permissionWrapper);
                    String[] permissionTypeNameStrs = vo.getPermissionTypeName().split("\u3001");
                    for (int i = 0; i < permissionTypeNameStrs.length; ++i) {
                        MaterialTypePermissionDO typeDo = new MaterialTypePermissionDO();
                        BeanUtils.copyProperties((Object)permission, (Object)typeDo);
                        String string = permissionTypeNameStrs[i];
                        if ("\u67e5\u770b".equals(string)) {
                            typeDo.setPermissionType(Integer.valueOf(1));
                        } else if ("\u4e0b\u8f7d".equals(string)) {
                            typeDo.setPermissionType(Integer.valueOf(4));
                        } else if ("\u5206\u53d1".equals(string)) {
                            typeDo.setPermissionType(Integer.valueOf(5));
                        } else if ("\u7ef4\u62a4".equals(string)) {
                            typeDo.setPermissionType(Integer.valueOf(3));
                        }
                        boolean exist = this.materialTypePermissionService.checkExist(typeDo.getMaterialTypeId(), typeDo.getUnitId(), typeDo.getPermissionType());
                        if (exist) {
                            vo.setPermissionTypeName(string);
                            continue;
                        }
                        addList.add(typeDo);
                    }
                }
                if (!CollectionUtils.isEmpty(addList)) {
                    this.materialTypePermissionService.batchInsert(addList);
                    Set typeIdSet = addList.stream().map(MaterialTypePermissionDO::getMaterialTypeId).collect(Collectors.toSet());
                    for (Integer typeId : typeIdSet) {
                        TrainingMaterialType type = this.getById(typeId);
                        this.materialTypePermissionService.onMaterialTypePermissionChange(typeId);
                        this.processChildExtendAndPermission(type, null);
                    }
                }
            }
            ImportTaskPojo pojo = new ImportTaskPojo();
            pojo.setId(taskId);
            pojo.setCreateTime(new Date());
            pojo.setCreateId(user.getId());
            pojo.setGroupId(user.getGroupId());
            pojo.setModuleType(Integer.valueOf(11));
            pojo.setTaskType(Integer.valueOf(1));
            pojo.setName("\u5bfc\u5165\u5206\u7c7b\u6743\u9650:" + DateUtils.getDateStr(new Date(), "yyyyMMddHHmmss"));
            pojo.setRepeatType(Integer.valueOf(1));
            pojo.setUniqueKey("name");
            pojo.setUserId(user.getId());
            pojo.setUrl(fileUrl);
            if (!errirList.isEmpty()) {
                String errorUrl = this.getErrorMaterialType(errirList, user.getGroupId());
                pojo.setErrorCount(Integer.valueOf(errirList.size()));
                pojo.setErrorUrl(errorUrl);
            }
            pojo.setStatus(Integer.valueOf(2));
            if (result.getTotalCount() - errirList.size() == 0) {
                pojo.setStatus(Integer.valueOf(3));
            }
            pojo.setSuccessCount(Integer.valueOf(result.getTotalCount() - errirList.size()));
            pojo.setErrorCount(Integer.valueOf(errirList.size()));
            com.ovopark.organize.common.base.BaseResult INFO = this.importTaskApi.saveImportTask(pojo);
            log.info("importBatchMaterialTypeResult:{}", (Object)JSONObject.toJSONString((Object)INFO));
            return JsonResult.success((Object)pojo);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("importBatchMaterialType error", (Throwable)e);
            return JsonResult.error(null, (Object)e.getMessage());
        }
    }

    @Override
    public void onMaterialTypeStatCountEvent(MaterialTypeStatCountEvent event) {
        List<Integer> materialTypeIdList = event.getMaterialTypeIdList();
        log.info("onMaterialTypeStatCountEvent materialTypeIdList:{}", materialTypeIdList);
        for (Integer materialTypeId : materialTypeIdList) {
            this.processStatCount(materialTypeId);
        }
    }

    @Override
    public void onMaterialTypeStatCountByMoveEvent(MaterialTypeStatCountByMoveEvent event) {
        List<Integer> materialTypeIdList = event.getMaterialTypeIdList();
        log.info("onMaterialTypeStatCountByMoveEvent materialTypeIdList:{}", materialTypeIdList);
        for (Integer materialTypeId : materialTypeIdList) {
            this.processStatCountByMove(materialTypeId);
        }
    }

    @Override
    public Result<Object> syncMaterialTypeStatCount(Integer startMaterialTypeId, Integer endMaterialTypeId) {
        log.info("\u7d20\u6750\u5206\u7c7b\u7edf\u8ba1count\u6e05\u6d17 \u5f00\u59cbid{} \u7ed3\u675fid{}", (Object)startMaterialTypeId, (Object)endMaterialTypeId);
        LambdaQueryWrapper materialTypeQuery = new LambdaQueryWrapper();
        materialTypeQuery.between(TrainingMaterialType::getId, (Object)startMaterialTypeId, (Object)endMaterialTypeId);
        materialTypeQuery.eq(TrainingMaterialType::getMaterialTypeLevel, (Object)1);
        materialTypeQuery.in(TrainingMaterialType::getModuleType, (Collection)Lists.newArrayList((Object[])new Integer[]{1}));
        materialTypeQuery.select(new SFunction[]{TrainingMaterialType::getId});
        List list = this.materialTypeMapper.selectList((Wrapper)materialTypeQuery);
        int successCount = 0;
        int failCount = 0;
        for (TrainingMaterialType trainingMaterialType : list) {
            boolean success = this.resetStatCountByRootTypeId(trainingMaterialType.getId());
            if (success) {
                ++successCount;
                continue;
            }
            log.info("\u7d20\u6750\u5206\u7c7b\u7edf\u8ba1count\u6e05\u6d17\u5931\u8d25 {}", (Object)trainingMaterialType.getId());
            ++failCount;
        }
        HashMap result = Maps.newHashMap();
        result.put("successCount", successCount);
        result.put("failCount", failCount);
        log.info("\u7d20\u6750\u5206\u7c7b\u7edf\u8ba1count\u6e05\u6d17 \u7ed3\u675f {}", (Object)JSON.toJSONString((Object)result));
        return ResultUtils.success((Object)result);
    }

    private boolean resetStatCountByRootTypeId(Integer rootId) {
        List<TrainingMaterialType> childNestList = this.getByOriginList(Lists.newArrayList((Object[])new Integer[]{rootId}));
        Map<Integer, List<TrainingMaterialType>> levelMap = childNestList.stream().collect(Collectors.groupingBy(TrainingMaterialType::getMaterialTypeLevel));
        Set<Integer> levelSet = levelMap.keySet();
        ArrayList levelDesc = Lists.newArrayList(levelSet);
        levelDesc.sort(Comparator.reverseOrder());
        for (Integer level : levelDesc) {
            List<TrainingMaterialType> levelList = levelMap.get(level);
            if (CollectionUtils.isEmpty(levelList)) continue;
            for (TrainingMaterialType trainingMaterialType : levelList) {
                Integer typeId = trainingMaterialType.getId();
                this.updateCountByTypeId(typeId);
            }
        }
        this.updateCountByTypeId(rootId);
        return true;
    }

    private void updateCountByTypeId(Integer typeId) {
        int materialCount = this.resourceService.countMaterialByType(typeId);
        int trainCount = this.resourceService.countTrainByType(typeId);
        List<TrainingMaterialType> childList = this.getListBySourceId(typeId);
        Integer materialCountCoverChild = materialCount;
        Integer trainCountCoverChild = trainCount;
        if (CollectionUtils.isNotEmpty(childList)) {
            for (TrainingMaterialType child : childList) {
                materialCountCoverChild = materialCountCoverChild + child.getMaterialCountCoverChild();
                trainCountCoverChild = trainCountCoverChild + child.getTrainCountCoverChild();
            }
        }
        this.updateStatCount(typeId, materialCount, materialCountCoverChild, trainCount, trainCountCoverChild);
    }

    private void processStatCount(Integer materialTypeId) {
        TrainingMaterialType type = this.getById(materialTypeId);
        int materialCount = this.resourceService.countMaterialByType(materialTypeId);
        int materialDiff = materialCount - type.getMaterialCount();
        int trainCount = this.resourceService.countTrainByType(materialTypeId);
        int trainDiff = trainCount - type.getTrainCount();
        log.info("processStatCount materialTypeId:{} materialCount:{} trainCount:{} materialDiff:{} trainDiff:{}", new Object[]{materialTypeId, materialCount, trainCount, materialDiff, trainDiff});
        if (materialDiff == 0 && trainDiff == 0) {
            log.info("processStatCount \u6570\u91cf\u6ca1\u53d8\u5316 id {}", (Object)materialTypeId);
            return;
        }
        List<Integer> coverList = this.getIdListByIdPath(type.getIdPath());
        coverList.add(materialTypeId);
        int res = this.updateCoverStatCountByDiff(coverList, materialDiff, trainDiff);
        ArrayList list = Lists.newArrayList();
        list.add(materialTypeId);
        this.updateStatCountByDiff(list, materialDiff, trainDiff);
    }

    private void processStatCountByMove(Integer materialTypeId) {
        int childMaterialCount = 0;
        int childTrainCount = 0;
        List<TrainingMaterialType> childList = this.getListBySourceId(materialTypeId);
        for (TrainingMaterialType child : childList) {
            childMaterialCount += child.getMaterialCountCoverChild().intValue();
            childTrainCount += child.getTrainCountCoverChild().intValue();
        }
        TrainingMaterialType type = this.getById(materialTypeId);
        int materialDiff = type.getMaterialCount() + childMaterialCount - type.getMaterialCountCoverChild();
        int trainDiff = type.getTrainCount() + childTrainCount - type.getTrainCountCoverChild();
        log.info("processStatCountByMove materialTypeId:{} materialCount:{} trainCount:{} materialDiff:{} trainDiff:{}", new Object[]{materialTypeId, type.getMaterialCount(), type.getTrainCount(), materialDiff, trainDiff});
        if (materialDiff == 0 && trainDiff == 0) {
            log.info("processStatCount \u6570\u91cf\u6ca1\u53d8\u5316 id {}", (Object)materialTypeId);
            return;
        }
        List<Integer> parentIdList = this.getIdListByIdPath(type.getIdPath());
        parentIdList.add(materialTypeId);
        int res = this.updateCoverStatCountByDiff(parentIdList, materialDiff, trainDiff);
    }

    private int updateCoverStatCountByDiff(List<Integer> idList, int materialDiff, int trainDiff) {
        return this.materialTypeMapper.updateCoverStatCountByDiff(idList, materialDiff, trainDiff);
    }

    private int updateStatCountByDiff(List<Integer> idList, int materialDiff, int trainDiff) {
        return this.materialTypeMapper.updateStatCountByDiff(idList, materialDiff, trainDiff);
    }

    private List<Integer> getIdListByIdPath(String idPath) {
        if (StringUtils.isEmpty((String)idPath)) {
            return Lists.newArrayList();
        }
        String[] split = StringUtils.split((String)idPath, (String)",");
        return Arrays.stream(split).map(Integer::valueOf).collect(Collectors.toList());
    }

    private int updateStatCount(Integer materialTypeId, int materialCount, int materialCountCoverChild, int trainCount, int trainCountCoverChild) {
        return this.materialTypeMapper.updateStatCount(materialTypeId, materialCount, materialCountCoverChild, trainCount, trainCountCoverChild);
    }
}

