/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.training.service.paperChannel;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ovopark.training.dto.ProjectInfoDto;
import com.ovopark.training.enums.PaperSourceEnum;
import com.ovopark.training.mapper.TrainingPaperUserMapper;
import com.ovopark.training.mapper.TrainingUserPaperMapper;
import com.ovopark.training.model.TrainingPaperUser;
import com.ovopark.training.model.TrainingUserPaper;
import com.ovopark.training.model.Users;
import com.ovopark.training.request.ExamineeDetailRequest;
import com.ovopark.training.service.UserUtilService;
import com.ovopark.training.service.paperChannel.PaperChannel;
import com.ovopark.training.service.paperChannel.PaperUtil;
import com.ovopark.training.vo.PaperManagementExamineeDetailVo;
import com.ovopark.training.vo.PaperVo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class PaperChannelArrangeSeparately
implements PaperChannel {
    private static final Logger log = LoggerFactory.getLogger(PaperChannelArrangeSeparately.class);
    @Autowired
    private TrainingPaperUserMapper trainingPaperUserMapper;
    @Autowired
    private TrainingUserPaperMapper trainingUserPaperMapper;
    @Resource
    private UserUtilService userUtilService;
    @Autowired
    private PaperUtil paperUtil;

    @Override
    public Map<Integer, List<Integer>> handlePaperUserScope(List<PaperVo> allPaperList, Users user) {
        List<Integer> allUserId = this.userUtilService.getUserListByGroupId(user.getGroupId());
        List paperIdList = allPaperList.stream().filter(paperVo -> paperVo.getLookLevel() != null && paperVo.getLookLevel().equals(1)).map(paperVo -> paperVo.getId()).collect(Collectors.toList());
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.in(TrainingPaperUser::getPaperId, paperIdList);
        List paperUserList = this.trainingPaperUserMapper.selectList((Wrapper)wrapper);
        Map<Integer, List<TrainingPaperUser>> registeredParticipantsMap = paperUserList.stream().collect(Collectors.groupingBy(TrainingPaperUser::getPaperId));
        HashMap<Integer, List<Integer>> result = new HashMap<Integer, List<Integer>>();
        allPaperList.forEach(paperVo -> {
            List<Integer> reUserIds;
            List trainingPaperUserList;
            List<Integer> myUserIds;
            Integer paperId = paperVo.getId();
            ArrayList initialUserIdList = new ArrayList();
            initialUserIdList.addAll(allUserId);
            if (registeredParticipantsMap.containsKey(paperId) && !CollectionUtils.isEmpty(myUserIds = this.getConfigUserIdList(trainingPaperUserList = (List)registeredParticipantsMap.get(paperId), user))) {
                initialUserIdList.retainAll(myUserIds);
            }
            if (paperVo.getEndTime() != null && !CollectionUtils.isEmpty(reUserIds = this.userUtilService.selectOverGroupTime(paperVo.getEnterpriseId(), paperVo.getEndTime()))) {
                initialUserIdList.removeAll(reUserIds);
            }
            result.put(paperId, initialUserIdList.stream().distinct().collect(Collectors.toList()));
        });
        return result;
    }

    private List<Integer> getConfigUserIdList(List<TrainingPaperUser> trainingPaperUserList, Users user) {
        List<Integer> orgUserIds;
        List<Integer> tagUserIds;
        List<Integer> roleUserIds;
        ArrayList<Integer> myUserIds = new ArrayList<Integer>();
        List<Integer> roleIdList = trainingPaperUserList.stream().map(TrainingPaperUser::getRoleId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        List<String> organizeIdList = trainingPaperUserList.stream().map(TrainingPaperUser::getOrganizeId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        List<Integer> tagIdList = trainingPaperUserList.stream().map(TrainingPaperUser::getTagId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        List userIdList = trainingPaperUserList.stream().map(TrainingPaperUser::getUserId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        myUserIds.addAll(userIdList);
        if (!CollectionUtils.isEmpty(roleIdList) && !CollectionUtils.isEmpty(roleUserIds = this.userUtilService.selectUsersByRoles(roleIdList, user.getGroupId()))) {
            myUserIds.addAll(roleUserIds);
        }
        if (!CollectionUtils.isEmpty(tagIdList) && !CollectionUtils.isEmpty(tagUserIds = this.userUtilService.selectUserIdsByTagIds(tagIdList, user.getGroupId(), null))) {
            myUserIds.addAll(tagUserIds);
        }
        if (!CollectionUtils.isEmpty(organizeIdList) && !CollectionUtils.isEmpty(orgUserIds = this.userUtilService.selectUserIdsByOrganizeIds(organizeIdList, user.getGroupId()))) {
            myUserIds.addAll(orgUserIds);
        }
        return myUserIds;
    }

    @Override
    public Map<Integer, PaperVo> handlePaperSituation(List<PaperVo> allPaperList, Users user) {
        List paperIds = allPaperList.stream().map(PaperVo::getId).collect(Collectors.toList());
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(TrainingUserPaper::getSourceType, (Object)PaperSourceEnum.ARRANGE_SEPARATELY.getUserPaperTableValue());
        wrapper.in(TrainingUserPaper::getTrainingPaperId, paperIds);
        List trainingUserPapers = this.trainingUserPaperMapper.selectList((Wrapper)wrapper);
        Map<Integer, List<Integer>> paperUserScopeMap = this.handlePaperUserScope(allPaperList, user);
        Map<Integer, PaperVo> res = PaperUtil.getPaperSituationMap(allPaperList, trainingUserPapers, paperUserScopeMap);
        return res;
    }

    @Override
    public void handleOldData(Integer enterpriseId) {
    }

    @Override
    public void handleOldDataTwo(Integer enterpriseId) {
    }

    @Override
    public void handleOldDataThree(Integer enterpriseId) {
    }

    @Override
    public ProjectInfoDto getSourceProjectInfo(Integer projectId) {
        return null;
    }

    @Override
    public List<PaperManagementExamineeDetailVo> selectExamineeDetails(ExamineeDetailRequest request, PaperVo paperVo, Users user) {
        List<TrainingUserPaper> trainingUserPapers = this.getUserPaperList(paperVo, null, null);
        List<Integer> paperUserIdList = null;
        if ((request.getUserType() == null || request.getUserType() == 0) && CollectionUtils.isEmpty(paperUserIdList = this.getPaperUserScopeByPaper(paperVo, user))) {
            return new ArrayList<PaperManagementExamineeDetailVo>();
        }
        List<PaperManagementExamineeDetailVo> res = this.paperUtil.getExamineeDetails(request, paperVo, trainingUserPapers, paperUserIdList, user);
        return res;
    }

    @Override
    public List<Integer> getPaperUserScopeByPaper(PaperVo paper, Users user) {
        List<Integer> reUserIds;
        List<Integer> userIds = this.userUtilService.getUserListByGroupId(user.getGroupId());
        if (paper.getLookLevel() != null && paper.getLookLevel().equals(1)) {
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.eq(TrainingPaperUser::getPaperId, (Object)paper.getId());
            List trainingPaperUserList = this.trainingPaperUserMapper.selectList((Wrapper)queryWrapper);
            List<Integer> myUserIds = this.getConfigUserIdList(trainingPaperUserList, user);
            if (!CollectionUtils.isEmpty(myUserIds)) {
                userIds.retainAll(myUserIds);
            }
        }
        if (paper.getEndTime() != null && !CollectionUtils.isEmpty(reUserIds = this.userUtilService.selectOverGroupTime(paper.getEnterpriseId(), paper.getEndTime()))) {
            userIds.removeAll(reUserIds);
        }
        return userIds;
    }

    @Override
    public List<TrainingUserPaper> getUserPaperList(PaperVo paper, Integer userId, Integer userType) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(TrainingUserPaper::getSourceType, (Object)PaperSourceEnum.ARRANGE_SEPARATELY.getUserPaperTableValue());
        wrapper.eq(TrainingUserPaper::getTrainingPaperId, (Object)paper.getId());
        if (userId != null) {
            if (userType == null || userType == 0) {
                wrapper.eq(TrainingUserPaper::getUserId, (Object)userId);
            } else {
                wrapper.eq(TrainingUserPaper::getLoginUserId, (Object)userId);
            }
        }
        List trainingUserPapers = this.trainingUserPaperMapper.selectList((Wrapper)wrapper);
        return trainingUserPapers;
    }

    @Override
    public void updatePaperVoByShiftId(PaperVo paperVo, Integer shiftId) {
    }
}

