/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.training.service.paperChannel;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.ovopark.training.dto.ProjectInfoDto;
import com.ovopark.training.enums.PaperSourceEnum;
import com.ovopark.training.mapper.TrainingChapterAttachMapper;
import com.ovopark.training.mapper.TrainingChapterMapper;
import com.ovopark.training.mapper.TrainingCourseStageTaskMapper;
import com.ovopark.training.mapper.TrainingJobStageTaskMapper;
import com.ovopark.training.mapper.TrainingMapper;
import com.ovopark.training.mapper.TrainingPaperUserMapper;
import com.ovopark.training.mapper.TrainingTaskScheduleMapper;
import com.ovopark.training.mapper.TrainingUserPaperMapper;
import com.ovopark.training.mapper.TrainingUserQuestionMapper;
import com.ovopark.training.model.Training;
import com.ovopark.training.model.TrainingChapter;
import com.ovopark.training.model.TrainingChapterAttach;
import com.ovopark.training.model.TrainingCourseStageTask;
import com.ovopark.training.model.TrainingJobStageTask;
import com.ovopark.training.model.TrainingResource;
import com.ovopark.training.model.TrainingTaskSchedule;
import com.ovopark.training.model.TrainingUserPaper;
import com.ovopark.training.model.TrainingUserQuestion;
import com.ovopark.training.model.Users;
import com.ovopark.training.request.ExamineeDetailRequest;
import com.ovopark.training.service.UserUtilService;
import com.ovopark.training.service.paperChannel.PaperChannel;
import com.ovopark.training.service.paperChannel.PaperUtil;
import com.ovopark.training.service.resource.ResourceService;
import com.ovopark.training.service.resource.ResourceSinglePermissionService;
import com.ovopark.training.vo.PaperManagementExamineeDetailVo;
import com.ovopark.training.vo.PaperVo;
import com.ovopark.training.vo.unit.UnitShowVo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PaperChannelCourse
implements PaperChannel {
    private static final Logger log = LoggerFactory.getLogger(PaperChannelCourse.class);
    @Resource
    private UserUtilService userUtilService;
    @Autowired
    private TrainingPaperUserMapper trainingPaperUserMapper;
    @Autowired
    private TrainingMapper trainingMapper;
    @Autowired
    private TrainingChapterMapper trainingChapterMapper;
    @Autowired
    private PaperUtil paperUtil;
    @Autowired
    private TrainingChapterAttachMapper trainingChapterAttachMapper;
    @Autowired
    private TrainingUserPaperMapper trainingUserPaperMapper;
    @Autowired
    private TrainingUserQuestionMapper trainingUserQuestionMapper;
    @Autowired
    private TrainingCourseStageTaskMapper trainingCourseStageTaskMapper;
    @Autowired
    private TrainingJobStageTaskMapper trainingJobStageTaskMapper;
    @Autowired
    private TrainingTaskScheduleMapper trainingTaskScheduleMapper;
    @Autowired
    private ResourceService resourceService;
    @Autowired
    private ResourceSinglePermissionService resourceSinglePermissionService;

    @Override
    public Map<Integer, List<Integer>> handlePaperUserScope(List<PaperVo> allPaperList, Users user) {
        List<Integer> trainingIdList = allPaperList.stream().map(PaperVo::getProjectId).collect(Collectors.toList());
        Map<Integer, List<Integer>> userIdMapByTrainIdList = this.resourceSinglePermissionService.getUserIdMapByTrainIdList(trainingIdList, user.getGroupId());
        HashMap<Integer, List<Integer>> result = new HashMap<Integer, List<Integer>>();
        allPaperList.forEach(paperVo -> {
            Integer paperId = paperVo.getId();
            Integer projectId = paperVo.getProjectId();
            if (userIdMapByTrainIdList.containsKey(projectId)) {
                result.put(paperId, (List<Integer>)userIdMapByTrainIdList.get(projectId));
            }
        });
        return result;
    }

    @Override
    public Map<Integer, PaperVo> handlePaperSituation(List<PaperVo> allPaperList, Users user) {
        List paperIds = allPaperList.stream().map(PaperVo::getId).collect(Collectors.toList());
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(TrainingUserPaper::getSourceType, (Object)PaperSourceEnum.COURSE.getUserPaperTableValue());
        wrapper.in(TrainingUserPaper::getTrainingPaperId, paperIds);
        List trainingUserPapers = this.trainingUserPaperMapper.selectList((Wrapper)wrapper);
        Map<Integer, PaperVo> res = PaperUtil.getPaperSituationMap(allPaperList, trainingUserPapers, null);
        return res;
    }

    @Override
    public void handleOldData(Integer enterpriseId) {
        LambdaQueryWrapper trainingChapterAttachLambdaQueryWrapper = new LambdaQueryWrapper();
        trainingChapterAttachLambdaQueryWrapper.isNotNull(TrainingChapterAttach::getPaperId);
        trainingChapterAttachLambdaQueryWrapper.isNotNull(TrainingChapterAttach::getTrainingId);
        trainingChapterAttachLambdaQueryWrapper.select(new SFunction[]{TrainingChapterAttach::getTrainingId, TrainingChapterAttach::getChapterId, TrainingChapterAttach::getId, TrainingChapterAttach::getPaperId, TrainingChapterAttach::getIsDel});
        List trainingChapterAttachList = this.trainingChapterAttachMapper.selectList((Wrapper)trainingChapterAttachLambdaQueryWrapper);
        LambdaQueryWrapper trainingLambdaQueryWrapper = new LambdaQueryWrapper();
        trainingLambdaQueryWrapper.eq(Training::getIsDel, (Object)0);
        trainingLambdaQueryWrapper.select(new SFunction[]{Training::getId});
        List trainingList = this.trainingMapper.selectList((Wrapper)trainingLambdaQueryWrapper);
        Set trainingIdSet = trainingList.stream().map(Training::getId).collect(Collectors.toSet());
        LambdaQueryWrapper chapterLambdaQueryWrapper = new LambdaQueryWrapper();
        chapterLambdaQueryWrapper.eq(TrainingChapter::getIsDel, (Object)0);
        chapterLambdaQueryWrapper.select(new SFunction[]{TrainingChapter::getId});
        List trainingChapterList = this.trainingChapterMapper.selectList((Wrapper)chapterLambdaQueryWrapper);
        Set chapterIdSet = trainingChapterList.stream().map(TrainingChapter::getId).collect(Collectors.toSet());
        trainingChapterAttachList.forEach(trainingChapterAttach -> {
            Integer trainingId = trainingChapterAttach.getTrainingId();
            Integer chapterId = trainingChapterAttach.getChapterId();
            Integer attachId = trainingChapterAttach.getId();
            Integer paperId = trainingChapterAttach.getPaperId();
            Integer isDel = 0;
            if (trainingChapterAttach.getIsDel().equals(1)) {
                isDel = 1;
            } else if (!chapterIdSet.contains(chapterId)) {
                isDel = 1;
            } else if (!trainingIdSet.contains(trainingId)) {
                isDel = 1;
            }
            Integer newPaperId = this.paperUtil.copyPaper(paperId, PaperSourceEnum.COURSE.getPaperTableValue(), trainingId, attachId, null, isDel);
            ArrayList allUserPaperIdList = new ArrayList();
            LambdaQueryWrapper trainingUserPaperLambdaQueryWrapper = new LambdaQueryWrapper();
            trainingUserPaperLambdaQueryWrapper.eq(TrainingUserPaper::getTrainingPaperId, (Object)paperId);
            trainingUserPaperLambdaQueryWrapper.eq(TrainingUserPaper::getSourceProjectId, (Object)trainingId);
            trainingUserPaperLambdaQueryWrapper.eq(TrainingUserPaper::getSourceType, (Object)PaperSourceEnum.COURSE.getUserPaperTableValue());
            trainingUserPaperLambdaQueryWrapper.select(new SFunction[]{TrainingUserPaper::getId, TrainingUserPaper::getSourceProjectId, TrainingUserPaper::getSourceTaskId});
            List trainingUserPaperList = this.trainingUserPaperMapper.selectList((Wrapper)trainingUserPaperLambdaQueryWrapper);
            if (trainingUserPaperList != null && trainingUserPaperList.size() > 0) {
                allUserPaperIdList.addAll(trainingUserPaperList.stream().map(TrainingUserPaper::getId).collect(Collectors.toList()));
                trainingUserPaperList.forEach(trainingUserPaper -> {
                    trainingUserPaper.setTrainingPaperId(newPaperId);
                    trainingUserPaper.setSourceProjectId(trainingId);
                    trainingUserPaper.setSourceTaskId(attachId);
                    this.trainingUserPaperMapper.updateById(trainingUserPaper);
                });
            }
            LambdaQueryWrapper trainingCourseStageTaskLambdaQueryWrapper = new LambdaQueryWrapper();
            trainingCourseStageTaskLambdaQueryWrapper.eq(TrainingCourseStageTask::getTrainingId, (Object)trainingId);
            trainingCourseStageTaskLambdaQueryWrapper.eq(TrainingCourseStageTask::getTaskType, (Object)1);
            trainingCourseStageTaskLambdaQueryWrapper.select(new SFunction[]{TrainingCourseStageTask::getId, TrainingCourseStageTask::getCourseId});
            List trainingCourseStageTaskList = this.trainingCourseStageTaskMapper.selectList((Wrapper)trainingCourseStageTaskLambdaQueryWrapper);
            if (trainingCourseStageTaskList != null && trainingCourseStageTaskList.size() > 0) {
                trainingCourseStageTaskList.forEach(trainingCourseStageTask -> {
                    Integer courseId = trainingCourseStageTask.getCourseId();
                    Integer taskId = trainingCourseStageTask.getId();
                    LambdaQueryWrapper trainingUserPaperCourseLambdaQueryWrapper = new LambdaQueryWrapper();
                    trainingUserPaperCourseLambdaQueryWrapper.eq(TrainingUserPaper::getTrainingPaperId, (Object)paperId);
                    trainingUserPaperCourseLambdaQueryWrapper.eq(TrainingUserPaper::getSourceProjectId, (Object)courseId);
                    trainingUserPaperCourseLambdaQueryWrapper.eq(TrainingUserPaper::getSourceTaskId, (Object)taskId);
                    trainingUserPaperCourseLambdaQueryWrapper.eq(TrainingUserPaper::getSourceType, (Object)PaperSourceEnum.TRAINING_PLAN.getUserPaperTableValue());
                    trainingUserPaperCourseLambdaQueryWrapper.select(new SFunction[]{TrainingUserPaper::getId});
                    List trainingUserPaperCourseList = this.trainingUserPaperMapper.selectList((Wrapper)trainingUserPaperCourseLambdaQueryWrapper);
                    if (trainingUserPaperCourseList != null && trainingUserPaperCourseList.size() > 0) {
                        allUserPaperIdList.addAll(trainingUserPaperCourseList.stream().map(TrainingUserPaper::getId).collect(Collectors.toList()));
                        trainingUserPaperCourseList.forEach(trainingUserPaperCourse -> {
                            trainingUserPaperCourse.setTrainingPaperId(newPaperId);
                            this.trainingUserPaperMapper.updateById(trainingUserPaperCourse);
                        });
                    }
                });
            }
            LambdaQueryWrapper trainingJobStageTaskLambdaQueryWrapper = new LambdaQueryWrapper();
            trainingJobStageTaskLambdaQueryWrapper.eq(TrainingJobStageTask::getTrainingId, (Object)trainingId);
            trainingJobStageTaskLambdaQueryWrapper.eq(TrainingJobStageTask::getTaskType, (Object)1);
            trainingJobStageTaskLambdaQueryWrapper.select(new SFunction[]{TrainingJobStageTask::getId, TrainingJobStageTask::getJobId});
            List trainingJobStageTaskList = this.trainingJobStageTaskMapper.selectList((Wrapper)trainingJobStageTaskLambdaQueryWrapper);
            if (trainingJobStageTaskList != null && trainingJobStageTaskList.size() > 0) {
                trainingJobStageTaskList.forEach(trainingJobStageTask -> {
                    Integer jobId = trainingJobStageTask.getJobId();
                    Integer taskId = trainingJobStageTask.getId();
                    LambdaQueryWrapper trainingUserPaperJobLambdaQueryWrapper = new LambdaQueryWrapper();
                    trainingUserPaperJobLambdaQueryWrapper.eq(TrainingUserPaper::getTrainingPaperId, (Object)paperId);
                    trainingUserPaperJobLambdaQueryWrapper.eq(TrainingUserPaper::getSourceProjectId, (Object)jobId);
                    trainingUserPaperJobLambdaQueryWrapper.eq(TrainingUserPaper::getSourceTaskId, (Object)taskId);
                    trainingUserPaperJobLambdaQueryWrapper.eq(TrainingUserPaper::getSourceType, (Object)PaperSourceEnum.JOB_CERTIFICATION.getUserPaperTableValue());
                    trainingUserPaperJobLambdaQueryWrapper.select(new SFunction[]{TrainingUserPaper::getId});
                    List trainingUserPaperJobList = this.trainingUserPaperMapper.selectList((Wrapper)trainingUserPaperJobLambdaQueryWrapper);
                    if (trainingUserPaperJobList != null && trainingUserPaperJobList.size() > 0) {
                        allUserPaperIdList.addAll(trainingUserPaperJobList.stream().map(TrainingUserPaper::getId).collect(Collectors.toList()));
                        trainingUserPaperJobList.forEach(trainingUserPaperCourse -> {
                            trainingUserPaperCourse.setTrainingPaperId(newPaperId);
                            this.trainingUserPaperMapper.updateById(trainingUserPaperCourse);
                        });
                    }
                });
            }
            LambdaQueryWrapper trainingTaskScheduleLambdaQueryWrapper = new LambdaQueryWrapper();
            trainingTaskScheduleLambdaQueryWrapper.eq(TrainingTaskSchedule::getTrainingId, (Object)trainingId);
            trainingTaskScheduleLambdaQueryWrapper.eq(TrainingTaskSchedule::getTaskType, (Object)1);
            trainingTaskScheduleLambdaQueryWrapper.select(new SFunction[]{TrainingTaskSchedule::getId, TrainingTaskSchedule::getProjectId});
            List trainingTaskScheduleList = this.trainingTaskScheduleMapper.selectList((Wrapper)trainingTaskScheduleLambdaQueryWrapper);
            if (trainingTaskScheduleList != null && trainingTaskScheduleList.size() > 0) {
                trainingTaskScheduleList.forEach(trainingTaskSchedule -> {
                    Integer getProjectId = trainingTaskSchedule.getProjectId();
                    Integer taskId = trainingTaskSchedule.getId();
                    LambdaQueryWrapper trainingUserPaperJobLambdaQueryWrapper = new LambdaQueryWrapper();
                    trainingUserPaperJobLambdaQueryWrapper.eq(TrainingUserPaper::getTrainingPaperId, (Object)paperId);
                    trainingUserPaperJobLambdaQueryWrapper.eq(TrainingUserPaper::getSourceProjectId, (Object)getProjectId);
                    trainingUserPaperJobLambdaQueryWrapper.eq(TrainingUserPaper::getSourceTaskId, (Object)taskId);
                    trainingUserPaperJobLambdaQueryWrapper.eq(TrainingUserPaper::getSourceType, (Object)PaperSourceEnum.LEARNING_PROJECTS_ONE.getUserPaperTableValue());
                    trainingUserPaperJobLambdaQueryWrapper.select(new SFunction[]{TrainingUserPaper::getId});
                    List trainingUserPapers = this.trainingUserPaperMapper.selectList((Wrapper)trainingUserPaperJobLambdaQueryWrapper);
                    if (trainingUserPapers != null && trainingUserPapers.size() > 0) {
                        allUserPaperIdList.addAll(trainingUserPapers.stream().map(TrainingUserPaper::getId).collect(Collectors.toList()));
                        trainingUserPapers.forEach(trainingUserPaper -> {
                            trainingUserPaper.setTrainingPaperId(newPaperId);
                            this.trainingUserPaperMapper.updateById(trainingUserPaper);
                        });
                    }
                });
            }
            if (allUserPaperIdList.size() > 0) {
                LambdaQueryWrapper trainingUserQuestionLambdaQueryWrapper = new LambdaQueryWrapper();
                trainingUserQuestionLambdaQueryWrapper.eq(TrainingUserQuestion::getPaperId, (Object)paperId);
                trainingUserQuestionLambdaQueryWrapper.in(TrainingUserQuestion::getUserPaperId, allUserPaperIdList);
                trainingUserQuestionLambdaQueryWrapper.select(new SFunction[]{TrainingUserQuestion::getId, TrainingUserQuestion::getPaperId});
                List trainingUserQuestionList = this.trainingUserQuestionMapper.selectList((Wrapper)trainingUserQuestionLambdaQueryWrapper);
                trainingUserQuestionList.forEach(trainingUserQuestion -> {
                    trainingUserQuestion.setPaperId(newPaperId);
                    this.trainingUserQuestionMapper.updateById(trainingUserQuestion);
                });
            }
            log.info("\u8bfe\u7a0btraining_id:{},\u5c0f\u8282attach_id:{},\u539f\u7ed1\u5b9a\u8003\u8bd5paper_id:{},\u590d\u5236\u65b0\u8003\u8bd5new_paper_id:{},\u8be5\u8bfe\u7a0b\u6216\u7ed1\u5b9a\u8be5\u8bfe\u7a0b\u7684\u9879\u76ee\u4ea7\u751f\u7684\u8003\u8bd5\u8bb0\u5f55\uff1a{}", new Object[]{trainingId, attachId, paperId, newPaperId, allUserPaperIdList});
        });
    }

    @Override
    public void handleOldDataTwo(Integer enterpriseId) {
    }

    @Override
    public void handleOldDataThree(Integer enterpriseId) {
    }

    @Override
    public ProjectInfoDto getSourceProjectInfo(Integer trainingId) {
        Training training = (Training)this.trainingMapper.selectById(trainingId);
        ProjectInfoDto paperInfoDto = new ProjectInfoDto();
        paperInfoDto.setProjectName(training.getTitle());
        return paperInfoDto;
    }

    @Override
    public List<PaperManagementExamineeDetailVo> selectExamineeDetails(ExamineeDetailRequest request, PaperVo paperVo, Users user) {
        List<TrainingUserPaper> trainingUserPapers = this.getUserPaperList(paperVo, null, null);
        List<PaperManagementExamineeDetailVo> res = this.paperUtil.getExamineeDetails(request, paperVo, trainingUserPapers, null, user);
        return res;
    }

    @Override
    public List<Integer> getPaperUserScopeByPaper(PaperVo paper, Users user) {
        TrainingResource resource = this.resourceService.getByTrainId(paper.getProjectId());
        List<UnitShowVo> readShow = this.resourceSinglePermissionService.getSingleUnitShowListByMaterial(resource.getId(), 1);
        List<Integer> userIds = readShow.stream().map(UnitShowVo::getId).filter(s -> s != null && !s.isEmpty()).map(Integer::parseInt).collect(Collectors.toList());
        return userIds;
    }

    @Override
    public List<TrainingUserPaper> getUserPaperList(PaperVo paper, Integer userId, Integer userType) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(TrainingUserPaper::getSourceType, (Object)PaperSourceEnum.COURSE.getUserPaperTableValue());
        wrapper.eq(TrainingUserPaper::getTrainingPaperId, (Object)paper.getId());
        wrapper.eq(TrainingUserPaper::getSourceProjectId, (Object)paper.getProjectId());
        if (userId != null) {
            if (userType == 0) {
                wrapper.eq(TrainingUserPaper::getUserId, (Object)userId);
            } else {
                wrapper.eq(TrainingUserPaper::getLoginUserId, (Object)userId);
            }
        }
        List trainingUserPapers = this.trainingUserPaperMapper.selectList((Wrapper)wrapper);
        return trainingUserPapers;
    }

    @Override
    public void updatePaperVoByShiftId(PaperVo paperVo, Integer shiftId) {
    }
}

