/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.training.service.paperChannel;

import com.alibaba.nacos.client.naming.utils.CollectionUtils;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.ovopark.training.dto.ProjectInfoDto;
import com.ovopark.training.enums.PaperSourceEnum;
import com.ovopark.training.mapper.TrainingLearnProjectMapper;
import com.ovopark.training.mapper.TrainingLearnShiftMapper;
import com.ovopark.training.mapper.TrainingLearnUserMapper;
import com.ovopark.training.mapper.TrainingPaperMapper;
import com.ovopark.training.mapper.TrainingProjectTaskMapper;
import com.ovopark.training.mapper.TrainingTaskScheduleMapper;
import com.ovopark.training.mapper.TrainingUserPaperMapper;
import com.ovopark.training.mapper.TrainingUserQuestionMapper;
import com.ovopark.training.model.TrainingLearnProject;
import com.ovopark.training.model.TrainingLearnShift;
import com.ovopark.training.model.TrainingLearnUser;
import com.ovopark.training.model.TrainingPaper;
import com.ovopark.training.model.TrainingProjectTask;
import com.ovopark.training.model.TrainingTaskSchedule;
import com.ovopark.training.model.TrainingUserPaper;
import com.ovopark.training.model.TrainingUserQuestion;
import com.ovopark.training.model.Users;
import com.ovopark.training.request.ExamineeDetailRequest;
import com.ovopark.training.service.TrainingLearnProjectService;
import com.ovopark.training.service.paperChannel.PaperChannel;
import com.ovopark.training.service.paperChannel.PaperUtil;
import com.ovopark.training.util.ContextUtil;
import com.ovopark.training.vo.PaperManagementExamineeDetailVo;
import com.ovopark.training.vo.PaperVo;
import com.ovopark.training.vo.TrainingLearnShiftVo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PaperChannelLearningProjects
implements PaperChannel {
    private static final Logger log = LoggerFactory.getLogger(PaperChannelLearningProjects.class);
    @Autowired
    private TrainingPaperMapper trainingPaperMapper;
    @Autowired
    private TrainingLearnProjectMapper trainingLearnProjectMapper;
    @Autowired
    private TrainingProjectTaskMapper traingingProjectTaskMapper;
    @Autowired
    private TrainingLearnShiftMapper trainingLearnShiftMapper;
    @Autowired
    private TrainingTaskScheduleMapper trainingTaskScheduleMapper;
    @Autowired
    private PaperUtil paperUtil;
    @Autowired
    private TrainingUserPaperMapper trainingUserPaperMapper;
    @Autowired
    private TrainingUserQuestionMapper trainingUserQuestionMapper;
    @Autowired
    private TrainingLearnShiftMapper learnShiftMapper;
    @Autowired
    private TrainingLearnUserMapper learnUserMapper;
    @Autowired
    private TrainingLearnProjectService trainingLearnProjectService;

    @Override
    public Map<Integer, List<Integer>> handlePaperUserScope(List<PaperVo> allPaperList, Users user) {
        return null;
    }

    @Override
    public Map<Integer, PaperVo> handlePaperSituation(List<PaperVo> allPaperList, Users user) {
        return null;
    }

    @Override
    public void handleOldData(Integer enterpriseId) {
        LambdaQueryWrapper learnProjectLambdaQueryWrapper = new LambdaQueryWrapper();
        learnProjectLambdaQueryWrapper.eq(enterpriseId != null, TrainingLearnProject::getEnterpriseId, (Object)enterpriseId);
        learnProjectLambdaQueryWrapper.select(new SFunction[]{TrainingLearnProject::getId});
        List jobIdList = this.trainingLearnProjectMapper.selectList((Wrapper)learnProjectLambdaQueryWrapper);
        Set<Object> projectIdSet = !CollectionUtils.isEmpty((Collection)jobIdList) ? jobIdList.stream().map(TrainingLearnProject::getId).collect(Collectors.toSet()) : new HashSet();
        LambdaQueryWrapper projectTaskLambdaQueryWrapper = new LambdaQueryWrapper();
        projectTaskLambdaQueryWrapper.in(TrainingProjectTask::getProjectId, projectIdSet);
        projectTaskLambdaQueryWrapper.select(new SFunction[]{TrainingProjectTask::getId});
        List taskIdList = this.traingingProjectTaskMapper.selectList((Wrapper)projectTaskLambdaQueryWrapper);
        Set<Object> taskIdSet = !CollectionUtils.isEmpty((Collection)taskIdList) ? taskIdList.stream().map(TrainingProjectTask::getId).collect(Collectors.toSet()) : new HashSet();
        LambdaQueryWrapper learnShiftLambdaQueryWrapper = new LambdaQueryWrapper();
        learnShiftLambdaQueryWrapper.eq(enterpriseId != null, TrainingLearnShift::getEnterpriseId, (Object)enterpriseId);
        learnShiftLambdaQueryWrapper.select(new SFunction[]{TrainingLearnShift::getId});
        List shiftList = this.trainingLearnShiftMapper.selectList((Wrapper)learnShiftLambdaQueryWrapper);
        Set<Object> shiftIdSet = !CollectionUtils.isEmpty((Collection)shiftList) ? shiftList.stream().map(TrainingLearnShift::getId).collect(Collectors.toSet()) : new HashSet();
        LambdaQueryWrapper trainingPaperLambdaQueryWrapper = new LambdaQueryWrapper();
        trainingPaperLambdaQueryWrapper.or(orWrapper -> {
            orWrapper.eq(TrainingPaper::getProjectShow, (Object)PaperSourceEnum.LEARNING_PROJECTS_ONE.getPaperTableValue());
            orWrapper.eq(TrainingPaper::getProjectShow, (Object)PaperSourceEnum.LEARNING_PROJECTS_TWO.getPaperTableValue());
        });
        trainingPaperLambdaQueryWrapper.eq(enterpriseId != null, TrainingPaper::getEnterpriseId, (Object)enterpriseId);
        trainingPaperLambdaQueryWrapper.select(new SFunction[]{TrainingPaper::getId});
        List trainingPapers = this.trainingPaperMapper.selectList((Wrapper)trainingPaperLambdaQueryWrapper);
        List<Object> trainingPaperIdList = !CollectionUtils.isEmpty((Collection)trainingPapers) ? trainingPapers.stream().map(TrainingPaper::getId).collect(Collectors.toList()) : new ArrayList();
        LambdaQueryWrapper trainingTaskScheduleLambdaQueryWrapper = new LambdaQueryWrapper();
        trainingTaskScheduleLambdaQueryWrapper.in(TrainingTaskSchedule::getPaperId, trainingPaperIdList);
        trainingTaskScheduleLambdaQueryWrapper.select(new SFunction[]{TrainingTaskSchedule::getId, TrainingTaskSchedule::getTaskId, TrainingTaskSchedule::getProjectId, TrainingTaskSchedule::getShiftId, TrainingTaskSchedule::getPaperId});
        List trainingJobStageTaskList = this.trainingTaskScheduleMapper.selectList((Wrapper)trainingTaskScheduleLambdaQueryWrapper);
        Map<Object, Object> trainingJobStageTaskMap = new HashMap();
        if (!CollectionUtils.isEmpty((Collection)trainingJobStageTaskList)) {
            trainingJobStageTaskMap = trainingJobStageTaskList.stream().collect(Collectors.toMap(TrainingTaskSchedule::getPaperId, taskSchedule -> taskSchedule));
        }
        if (!CollectionUtils.isEmpty(trainingPaperIdList)) {
            for (Integer n : trainingPaperIdList) {
                TrainingPaper trainingPaper = new TrainingPaper();
                trainingPaper.setId(n);
                if (trainingJobStageTaskMap.containsKey(n)) {
                    TrainingTaskSchedule trainingTaskSchedule2 = (TrainingTaskSchedule)trainingJobStageTaskMap.get(n);
                    Integer projectId = trainingTaskSchedule2.getProjectId();
                    Integer taskId = trainingTaskSchedule2.getTaskId();
                    Integer taskScheduleId = trainingTaskSchedule2.getId();
                    Integer shiftId = trainingTaskSchedule2.getShiftId();
                    trainingPaper.setProjectId(projectId);
                    trainingPaper.setShiftId(shiftId);
                    Integer isDel = 0;
                    if (!projectIdSet.contains(projectId)) {
                        isDel = 1;
                    } else if (!taskIdSet.contains(taskId)) {
                        isDel = 1;
                    } else if (shiftId != null && !shiftIdSet.contains(shiftId)) {
                        isDel = 1;
                    }
                    trainingPaper.setIsDel(isDel);
                } else {
                    trainingPaper.setIsDel(Integer.valueOf(1));
                }
                this.trainingPaperMapper.updateById(trainingPaper);
            }
        }
        LambdaQueryWrapper paperLambdaQueryWrapper = new LambdaQueryWrapper();
        paperLambdaQueryWrapper.eq(TrainingPaper::getProjectShow, null);
        paperLambdaQueryWrapper.eq(enterpriseId != null, TrainingPaper::getEnterpriseId, (Object)enterpriseId);
        paperLambdaQueryWrapper.select(new SFunction[]{TrainingPaper::getId});
        List list = this.trainingPaperMapper.selectList((Wrapper)paperLambdaQueryWrapper);
        List<Object> paperIdList = !CollectionUtils.isEmpty((Collection)list) ? list.stream().map(TrainingPaper::getId).collect(Collectors.toList()) : new ArrayList();
        if (!CollectionUtils.isEmpty(paperIdList)) {
            LambdaQueryWrapper taskScheduleLambdaQueryWrapper = new LambdaQueryWrapper();
            taskScheduleLambdaQueryWrapper.in(TrainingTaskSchedule::getPaperId, paperIdList);
            taskScheduleLambdaQueryWrapper.eq(TrainingTaskSchedule::getTaskType, (Object)2);
            taskScheduleLambdaQueryWrapper.select(new SFunction[]{TrainingTaskSchedule::getId, TrainingTaskSchedule::getTaskId, TrainingTaskSchedule::getProjectId, TrainingTaskSchedule::getShiftId, TrainingTaskSchedule::getPaperId});
            List trainingTaskScheduleList = this.trainingTaskScheduleMapper.selectList((Wrapper)taskScheduleLambdaQueryWrapper);
            if (!CollectionUtils.isEmpty((Collection)trainingTaskScheduleList)) {
                trainingTaskScheduleList.forEach(trainingTaskSchedule -> {
                    Integer projectId = trainingTaskSchedule.getProjectId();
                    Integer taskId = trainingTaskSchedule.getTaskId();
                    Integer taskScheduleId = trainingTaskSchedule.getId();
                    Integer shiftId = trainingTaskSchedule.getShiftId();
                    Integer paperId = trainingTaskSchedule.getPaperId();
                    Integer isDel = 0;
                    if (!projectIdSet.contains(projectId)) {
                        isDel = 1;
                    } else if (!taskIdSet.contains(taskId)) {
                        isDel = 1;
                    } else if (!shiftIdSet.contains(shiftId)) {
                        isDel = 1;
                    }
                    Integer newPaperId = this.paperUtil.copyPaper(paperId, PaperSourceEnum.LEARNING_PROJECTS_ONE.getPaperTableValue(), projectId, taskScheduleId, shiftId, isDel);
                    LambdaQueryWrapper trainingUserPaperLambdaQueryWrapper = new LambdaQueryWrapper();
                    trainingUserPaperLambdaQueryWrapper.eq(TrainingUserPaper::getTrainingPaperId, (Object)paperId);
                    trainingUserPaperLambdaQueryWrapper.eq(TrainingUserPaper::getSourceProjectId, (Object)projectId);
                    trainingUserPaperLambdaQueryWrapper.eq(TrainingUserPaper::getSourceTaskId, (Object)taskScheduleId);
                    trainingUserPaperLambdaQueryWrapper.eq(TrainingUserPaper::getSourceShiftId, (Object)shiftId);
                    trainingUserPaperLambdaQueryWrapper.eq(TrainingUserPaper::getSourceType, (Object)PaperSourceEnum.LEARNING_PROJECTS_ONE.getUserPaperTableValue());
                    trainingUserPaperLambdaQueryWrapper.select(new SFunction[]{TrainingUserPaper::getId, TrainingUserPaper::getSourceProjectId, TrainingUserPaper::getSourceTaskId});
                    List trainingUserPaperList = this.trainingUserPaperMapper.selectList((Wrapper)trainingUserPaperLambdaQueryWrapper);
                    ArrayList allUserPaperIdList = new ArrayList();
                    if (trainingUserPaperList != null && trainingUserPaperList.size() > 0) {
                        allUserPaperIdList.addAll(trainingUserPaperList.stream().map(TrainingUserPaper::getId).collect(Collectors.toList()));
                        trainingUserPaperList.forEach(trainingUserPaper -> {
                            trainingUserPaper.setTrainingPaperId(newPaperId);
                            this.trainingUserPaperMapper.updateById(trainingUserPaper);
                        });
                    }
                    if (allUserPaperIdList.size() > 0) {
                        LambdaQueryWrapper trainingUserQuestionLambdaQueryWrapper = new LambdaQueryWrapper();
                        trainingUserQuestionLambdaQueryWrapper.eq(TrainingUserQuestion::getPaperId, (Object)paperId);
                        trainingUserQuestionLambdaQueryWrapper.eq(TrainingUserQuestion::getUserPaperId, allUserPaperIdList);
                        trainingUserQuestionLambdaQueryWrapper.select(new SFunction[]{TrainingUserQuestion::getId, TrainingUserQuestion::getPaperId});
                        List trainingUserQuestionList = this.trainingUserQuestionMapper.selectList((Wrapper)trainingUserQuestionLambdaQueryWrapper);
                        trainingUserQuestionList.forEach(trainingUserQuestion -> {
                            trainingUserQuestion.setPaperId(newPaperId);
                            this.trainingUserQuestionMapper.updateById(trainingUserQuestion);
                        });
                    }
                    log.info("\u5b66\u4e60\u9879\u76eeproject_id:{},\u4efb\u52a1task_id:{},\u73ed\u6b21shift_id:{},\u539f\u7ed1\u5b9a\u8003\u8bd5paper_id:{},\u590d\u5236\u65b0\u8003\u8bd5new_paper_id:{},\u8be5\u4efb\u52a1\u4ea7\u751f\u7684\u8003\u8bd5\u8bb0\u5f55\uff1a{}", new Object[]{projectId, taskScheduleId, shiftId, paperId, newPaperId, allUserPaperIdList});
                });
            }
        }
    }

    @Override
    public void handleOldDataTwo(Integer enterpriseId) {
    }

    @Override
    public void handleOldDataThree(Integer enterpriseId) {
    }

    @Override
    public ProjectInfoDto getSourceProjectInfo(Integer projectId) {
        TrainingLearnProject trainingLearnProject = (TrainingLearnProject)this.trainingLearnProjectMapper.selectById(projectId);
        ProjectInfoDto paperInfoDto = new ProjectInfoDto();
        paperInfoDto.setProjectName(trainingLearnProject.getProjectName());
        return paperInfoDto;
    }

    @Override
    public List<PaperManagementExamineeDetailVo> selectExamineeDetails(ExamineeDetailRequest request, PaperVo paperVo, Users user) {
        List<TrainingUserPaper> trainingUserPapers = this.getUserPaperList(paperVo, null, null);
        LambdaQueryWrapper trainingLearnShiftLambdaQueryWrapper = new LambdaQueryWrapper();
        trainingLearnShiftLambdaQueryWrapper.eq(TrainingLearnShift::getId, (Object)paperVo.getShiftId());
        trainingLearnShiftLambdaQueryWrapper.select(new SFunction[]{TrainingLearnShift::getShiftName});
        TrainingLearnShift trainingLearnShift = (TrainingLearnShift)this.trainingLearnShiftMapper.selectOne((Wrapper)trainingLearnShiftLambdaQueryWrapper);
        paperVo.setShiftName(trainingLearnShift.getShiftName());
        List<PaperManagementExamineeDetailVo> res = this.paperUtil.getExamineeDetails(request, paperVo, trainingUserPapers, null, user);
        return res;
    }

    @Override
    public List<Integer> getPaperUserScopeByPaper(PaperVo paper, Users user) {
        LambdaQueryWrapper userWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)userWrapper.eq(TrainingLearnUser::getShiftId, (Object)paper.getShiftId())).eq(TrainingLearnUser::getIsDelete, (Object)0);
        List learnUserList = this.learnUserMapper.selectList((Wrapper)userWrapper);
        List userIds = learnUserList.stream().map(TrainingLearnUser::getUserId).collect(Collectors.toList());
        return userIds.stream().distinct().collect(Collectors.toList());
    }

    @Override
    public void updatePaperVoByShiftId(PaperVo paper, Integer shiftId) {
        if (shiftId == null) {
            Users user = ContextUtil.getUser();
            TrainingLearnShiftVo trainingLearnShiftVo = new TrainingLearnShiftVo();
            trainingLearnShiftVo.setProjectId(paper.getProjectId());
            List<TrainingLearnShift> trainingLearnShifts = this.trainingLearnProjectService.selectShiftName(trainingLearnShiftVo, user);
            if (CollectionUtils.isEmpty(trainingLearnShifts)) {
                return;
            }
            shiftId = trainingLearnShifts.get(0).getId();
        }
        if (shiftId != paper.getShiftId()) {
            Integer projectId = paper.getProjectId();
            LambdaQueryWrapper trainingTaskScheduleLambdaQueryWrapper = new LambdaQueryWrapper();
            trainingTaskScheduleLambdaQueryWrapper.eq(TrainingTaskSchedule::getProjectId, (Object)projectId);
            trainingTaskScheduleLambdaQueryWrapper.eq(TrainingTaskSchedule::getShiftId, (Object)shiftId);
            trainingTaskScheduleLambdaQueryWrapper.eq(TrainingTaskSchedule::getTaskType, (Object)2);
            trainingTaskScheduleLambdaQueryWrapper.select(new SFunction[]{TrainingTaskSchedule::getPaperId});
            TrainingTaskSchedule trainingTaskSchedule = (TrainingTaskSchedule)this.trainingTaskScheduleMapper.selectOne((Wrapper)trainingTaskScheduleLambdaQueryWrapper);
            if (trainingTaskSchedule == null) {
                throw new RuntimeException("\u627e\u4e0d\u5230\u7ed1\u5b9a\u8be5\u73ed\u6b21\u7684\u4efb\u52a1\u8003\u8bd5");
            }
            paper = this.trainingPaperMapper.getTrainingPaperById(trainingTaskSchedule.getPaperId());
        }
    }

    @Override
    public List<TrainingUserPaper> getUserPaperList(PaperVo paper, Integer userId, Integer userType) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(TrainingUserPaper::getSourceType, (Object)PaperSourceEnum.LEARNING_PROJECTS_ONE.getUserPaperTableValue());
        wrapper.eq(TrainingUserPaper::getTrainingPaperId, (Object)paper.getId());
        wrapper.eq(TrainingUserPaper::getSourceProjectId, (Object)paper.getProjectId());
        wrapper.eq(TrainingUserPaper::getSourceShiftId, (Object)paper.getShiftId());
        if (userId != null) {
            if (userType == 0) {
                wrapper.eq(TrainingUserPaper::getUserId, (Object)userId);
            } else {
                wrapper.eq(TrainingUserPaper::getLoginUserId, (Object)userId);
            }
        }
        List trainingUserPapers = this.trainingUserPaperMapper.selectList((Wrapper)wrapper);
        return trainingUserPapers;
    }
}

