/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.training.service.paperChannel;

import com.ovopark.training.enums.PaperSourceEnum;
import com.ovopark.training.service.paperChannel.PaperChannel;
import com.ovopark.training.service.paperChannel.PaperChannelArrangeSeparately;
import com.ovopark.training.service.paperChannel.PaperChannelCourse;
import com.ovopark.training.service.paperChannel.PaperChannelJobCertification;
import com.ovopark.training.service.paperChannel.PaperChannelLearningProjects;
import com.ovopark.training.service.paperChannel.PaperChannelTrainingPlan;
import com.ovopark.training.vo.PaperVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PaperChannerlFactory {
    @Autowired
    private PaperChannelArrangeSeparately paperChannelArrangeSeparately;
    @Autowired
    private PaperChannelLearningProjects paperChannelLearningProjects;
    @Autowired
    private PaperChannelJobCertification paperChannelJobCertification;
    @Autowired
    private PaperChannelTrainingPlan paperChannelTrainingPlan;
    @Autowired
    private PaperChannelCourse paperChannelCourse;

    public PaperChannel getPaperChannel(Integer projectShow) {
        if (PaperSourceEnum.ARRANGE_SEPARATELY.getPaperTableValue() == projectShow) {
            return this.paperChannelArrangeSeparately;
        }
        if (PaperSourceEnum.LEARNING_PROJECTS_ONE.getPaperTableValue().equals(projectShow)) {
            return this.paperChannelLearningProjects;
        }
        if (PaperSourceEnum.LEARNING_PROJECTS_TWO.getPaperTableValue().equals(projectShow)) {
            return this.paperChannelLearningProjects;
        }
        if (PaperSourceEnum.JOB_CERTIFICATION.getPaperTableValue().equals(projectShow)) {
            return this.paperChannelJobCertification;
        }
        if (PaperSourceEnum.TRAINING_PLAN.getPaperTableValue().equals(projectShow)) {
            return this.paperChannelTrainingPlan;
        }
        if (PaperSourceEnum.COURSE.getPaperTableValue().equals(projectShow)) {
            return this.paperChannelCourse;
        }
        return null;
    }

    public PaperChannel getPaperChannel(PaperVo paperVo, Integer shiftId) {
        Integer projectShow = paperVo.getProjectShow();
        PaperChannel res = null;
        if (PaperSourceEnum.ARRANGE_SEPARATELY.getPaperTableValue() == projectShow) {
            res = this.paperChannelArrangeSeparately;
        } else if (PaperSourceEnum.LEARNING_PROJECTS_ONE.getPaperTableValue().equals(projectShow)) {
            res = this.paperChannelLearningProjects;
            res.updatePaperVoByShiftId(paperVo, shiftId);
        } else if (PaperSourceEnum.LEARNING_PROJECTS_TWO.getPaperTableValue().equals(projectShow)) {
            res = this.paperChannelLearningProjects;
            res.updatePaperVoByShiftId(paperVo, shiftId);
        } else if (PaperSourceEnum.JOB_CERTIFICATION.getPaperTableValue().equals(projectShow)) {
            res = this.paperChannelJobCertification;
        } else if (PaperSourceEnum.TRAINING_PLAN.getPaperTableValue().equals(projectShow)) {
            res = this.paperChannelTrainingPlan;
        } else if (PaperSourceEnum.COURSE.getPaperTableValue().equals(projectShow)) {
            res = this.paperChannelCourse;
        }
        return res;
    }
}

