/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.training.service.permission.material;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.ovopark.training.constants.PermissionConst;
import com.ovopark.training.domain.MaterialTypePermissionDO;
import com.ovopark.training.enhancer.subject.resp.Result;
import com.ovopark.training.enhancer.subject.resp.ResultUtils;
import com.ovopark.training.event.EventHelper;
import com.ovopark.training.mapper.TrainingMaterialTypeMapper;
import com.ovopark.training.mapper.permission.MaterialTypePermissionMapper;
import com.ovopark.training.model.TrainingMaterialType;
import com.ovopark.training.model.Users;
import com.ovopark.training.service.CommonRemoteService;
import com.ovopark.training.service.OrganizeService;
import com.ovopark.training.service.materialtype.MaterialTypeService;
import com.ovopark.training.service.permission.UnitService;
import com.ovopark.training.service.permission.material.MaterialTypePermissionService;
import com.ovopark.training.subject.permission.model.MaterialTypePermissionBO;
import com.ovopark.training.subject.permission.model.MaterialTypePermissionCreateParam;
import com.ovopark.training.subject.permission.model.MaterialTypePermissionUpdateParam;
import com.ovopark.training.vo.unit.UnitShowVo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MaterialTypePermissionServiceImpl
implements MaterialTypePermissionService {
    private static final Logger log = LoggerFactory.getLogger(MaterialTypePermissionServiceImpl.class);
    @Autowired
    private MaterialTypePermissionMapper typePermissionMapper;
    @Autowired
    private CommonRemoteService commonRemoteService;
    @Autowired
    private UnitService unitService;
    @Autowired
    private TrainingMaterialTypeMapper materialTypeMapper;
    @Autowired
    private MaterialTypeService materialTypeService;
    @Autowired
    private OrganizeService organizeService;

    @Override
    public Result<List<MaterialTypePermissionBO>> getList(Integer materialTypeId, Users user) {
        List<MaterialTypePermissionBO> list = this.typePermissionMapper.selectBusinessList(materialTypeId, PermissionConst.SOURCE_TYPE_SHOW_LIST);
        List<Long> unitIdList = list.stream().map(MaterialTypePermissionBO::getUnitId).collect(Collectors.toList());
        Map<Long, UnitShowVo> unitShowVoMap = this.unitService.getShowMap(unitIdList);
        list = list.stream().filter(v -> {
            UnitShowVo unit = (UnitShowVo)unitShowVoMap.get(v.getUnitId());
            if (unit == null) {
                return false;
            }
            v.setUnit(unit);
            return true;
        }).peek(materialTypePermissionBO -> {
            String[] split = StringUtils.split((String)materialTypePermissionBO.getCheckedPermissionTypes(), (String)",");
            Set<Integer> collect = Arrays.stream(split).map(Integer::parseInt).collect(Collectors.toSet());
            materialTypePermissionBO.setCheckedPermissionTypeList(collect);
        }).collect(Collectors.toList());
        return ResultUtils.success(list);
    }

    @Override
    public Set<Integer> getValidMaterialTypeIdSet(Users user, int permissionType, List<Integer> materialTypeIds) {
        if (CollectionUtils.isEmpty(materialTypeIds)) {
            return Sets.newHashSet();
        }
        Boolean isSuper = this.commonRemoteService.isSuper(user.getId());
        if (isSuper.booleanValue()) {
            return Sets.newHashSet(materialTypeIds);
        }
        List<Long> unitIdList = this.unitService.getIdListByUserId(user.getId());
        LambdaQueryWrapper q = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(MaterialTypePermissionDO::getMaterialTypeId, materialTypeIds)).in(MaterialTypePermissionDO::getUnitId, unitIdList)).eq(MaterialTypePermissionDO::getDeleted, (Object)0)).in(MaterialTypePermissionDO::getPermissionType, (Collection)PermissionConst.getListByPermissionType((int)permissionType));
        q.select(new SFunction[]{MaterialTypePermissionDO::getMaterialTypeId});
        return this.typePermissionMapper.selectList((Wrapper)q).stream().map(MaterialTypePermissionDO::getMaterialTypeId).collect(Collectors.toSet());
    }

    @Override
    public Set<Integer> getValidMaterialTypeIdSet(Users user, int permissionType) {
        List<Long> unitIdList = this.unitService.getIdListByUserId(user.getId());
        LambdaQueryWrapper q = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(MaterialTypePermissionDO::getUnitId, unitIdList)).eq(MaterialTypePermissionDO::getDeleted, (Object)0)).in(MaterialTypePermissionDO::getPermissionType, (Collection)PermissionConst.getListByPermissionType((int)permissionType));
        q.select(new SFunction[]{MaterialTypePermissionDO::getMaterialTypeId});
        return this.typePermissionMapper.selectList((Wrapper)q).stream().map(MaterialTypePermissionDO::getMaterialTypeId).collect(Collectors.toSet());
    }

    @Override
    public List<Integer> getMaterialTypePowerOwner(Integer materialTypeId, Users user) {
        LambdaQueryWrapper eq = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(MaterialTypePermissionDO::getMaterialTypeId, (Object)materialTypeId)).eq(MaterialTypePermissionDO::getPermissionType, (Object)1)).eq(MaterialTypePermissionDO::getDeleted, (Object)0);
        eq.in(MaterialTypePermissionDO::getUnitId, new Object[0]);
        List<Long> unitIdList = this.typePermissionMapper.selectList((Wrapper)eq).stream().map(MaterialTypePermissionDO::getUnitId).collect(Collectors.toList());
        return this.unitService.getAllUserIdByUnitIdList(unitIdList, user.getGroupId());
    }

    @Override
    public void onTypeDelete(List<Integer> typeIds) {
        log.info("onTypeDelete typeIds:{}", typeIds);
        if (CollectionUtils.isEmpty(typeIds)) {
            return;
        }
        LambdaUpdateWrapper update = (LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().set(MaterialTypePermissionDO::getDeleted, (Object)1)).in(MaterialTypePermissionDO::getMaterialTypeId, typeIds);
        this.typePermissionMapper.update(null, (Wrapper)update);
    }

    @Override
    public List<MaterialTypePermissionDO> getAllByPermissionTypes(int materialTypeId, Collection<Integer> permissionTypes) {
        LambdaQueryWrapper q = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(MaterialTypePermissionDO::getMaterialTypeId, (Object)materialTypeId)).in(MaterialTypePermissionDO::getPermissionType, permissionTypes)).eq(MaterialTypePermissionDO::getDeleted, (Object)0);
        return this.typePermissionMapper.selectList((Wrapper)q);
    }

    @Override
    public Result<Object> copyPermission(Integer enterpriseId, Integer sourceTypeId, String targetTypeIds) {
        List<Object> sourceList = this.getListByMaterialTypeId(sourceTypeId);
        String[] split = StringUtils.split((String)targetTypeIds, (String)",");
        List<Integer> idList = Arrays.stream(split).map(Integer::valueOf).collect(Collectors.toList());
        idList.remove(sourceTypeId);
        sourceList = sourceList.stream().filter(v -> v.getSourceType() == 0).collect(Collectors.toList());
        this.batchCopyPermissionForCopy(sourceList, idList);
        return ResultUtils.success();
    }

    @Override
    public void onMaterialTypePermissionChange(Integer materialTypeId) {
        ArrayList list = Lists.newArrayList();
        list.add(materialTypeId);
        EventHelper.sendMaterialTypePermissionChange(this, list);
    }

    private void onMaterialTypePermissionChange(List<Integer> materialTypeIdList) {
        EventHelper.sendMaterialTypePermissionChange(this, materialTypeIdList);
    }

    @Override
    public Result<Void> create(MaterialTypePermissionCreateParam param, Users user) {
        boolean valid = this.valid(param.getMaterialTypeId(), user, 3);
        if (!valid) {
            return ResultUtils.fail((String)"permission denied");
        }
        List<MaterialTypePermissionUpdateParam> itemList = param.getItemList();
        for (MaterialTypePermissionUpdateParam item : itemList) {
            Long unitId = this.unitService.getIdByBizIdAndType(item.getBizId(), item.getBizType(), user.getGroupId());
            Set<Integer> checkedPermissionTypes = item.getCheckedPermissionTypes();
            this.createByPermissionTypes(user.getGroupId(), unitId, param.getMaterialTypeId(), checkedPermissionTypes);
        }
        return ResultUtils.success();
    }

    @Override
    public Result<Void> update(MaterialTypePermissionUpdateParam param, Users user) {
        Long unitId = param.getUnitId();
        Integer deleted = param.getDeleted();
        if (deleted != null && deleted == 1) {
            this.removeByTypeIdAndUnitId(param.getMaterialTypeId(), unitId);
            return ResultUtils.success();
        }
        if (unitId == null) {
            unitId = this.unitService.getIdByBizIdAndType(param.getBizId(), param.getBizType(), user.getGroupId());
        }
        Set<Integer> checkedPermissionTypes = param.getCheckedPermissionTypes();
        this.updateByTypeIdAndUnitId(user.getGroupId(), param.getMaterialTypeId(), unitId, checkedPermissionTypes);
        return ResultUtils.success();
    }

    private List<MaterialTypePermissionDO> getListByMaterialTypeId(Integer materialTypeId) {
        LambdaQueryWrapper q = new LambdaQueryWrapper();
        q.eq(MaterialTypePermissionDO::getMaterialTypeId, (Object)materialTypeId);
        q.eq(MaterialTypePermissionDO::getDeleted, (Object)0);
        return this.typePermissionMapper.selectList((Wrapper)q);
    }

    private List<MaterialTypePermissionDO> getListByMaterialTypeIdAndSource(Integer materialTypeId, List<Integer> sourceTypeList) {
        LambdaQueryWrapper q = new LambdaQueryWrapper();
        q.eq(MaterialTypePermissionDO::getMaterialTypeId, (Object)materialTypeId);
        q.in(MaterialTypePermissionDO::getSourceType, sourceTypeList);
        q.eq(MaterialTypePermissionDO::getDeleted, (Object)0);
        return this.typePermissionMapper.selectList((Wrapper)q);
    }

    @Override
    public void onMaterialTypeCreate(TrainingMaterialType materialType) {
        this.insertForCreator(materialType);
        Integer sourceId = materialType.getSourceId();
        if (sourceId == null || sourceId <= 0) {
            log.info("\u65e0\u7236\u7ea7\u5206\u7c7b");
            return;
        }
        Integer extend = materialType.getExtend();
        if (extend == 0) {
            return;
        }
        TrainingMaterialType source = this.materialTypeService.getById(sourceId);
        this.overridePermissionForExtend(source.getId(), materialType.getId());
    }

    private void insertForCreator(TrainingMaterialType materialType) {
        MaterialTypePermissionDO typePermissionDO = new MaterialTypePermissionDO();
        typePermissionDO.setMaterialTypeId(materialType.getId());
        typePermissionDO.setSourceType(Integer.valueOf(1));
        typePermissionDO.setPermissionType(Integer.valueOf(9));
        typePermissionDO.setEnterpriseId(materialType.getEnterpriseId());
        Integer creater = materialType.getCreater();
        if (creater == null) {
            return;
        }
        Long unitId = this.unitService.getUnitIdByUserId(creater, materialType.getEnterpriseId());
        typePermissionDO.setUnitId(unitId);
        this.insert(typePermissionDO);
    }

    @Override
    public void overridePermissionForExtend(int sourceId, int targetId) {
        List<MaterialTypePermissionDO> sourceList = this.getListByMaterialTypeId(sourceId);
        ArrayList childTypeIdList = Lists.newArrayList();
        childTypeIdList.add(targetId);
        this.batchCopyPermissionForExtend(sourceList, childTypeIdList);
    }

    @Override
    public void batchOverridePermissionForExtend(Integer sourceId, List<Integer> childTypeIdListNest) {
        List<MaterialTypePermissionDO> sourceList = this.getListByMaterialTypeId(sourceId);
        this.batchCopyPermissionForExtend(sourceList, childTypeIdListNest);
    }

    private void batchCopyPermissionForExtend(List<MaterialTypePermissionDO> sourceList, List<Integer> childTypeIdList) {
        if (CollectionUtils.isEmpty(childTypeIdList)) {
            return;
        }
        LambdaQueryWrapper q = new LambdaQueryWrapper();
        q.in(MaterialTypePermissionDO::getMaterialTypeId, childTypeIdList);
        q.in(MaterialTypePermissionDO::getSourceType, (Collection)Lists.newArrayList((Object[])new Integer[]{2, 0}));
        q.eq(MaterialTypePermissionDO::getDeleted, (Object)0);
        List targetOldExtendPermissionList = this.typePermissionMapper.selectList((Wrapper)q);
        List<Long> targetOldExtendPermissionIdList = targetOldExtendPermissionList.stream().map(MaterialTypePermissionDO::getId).collect(Collectors.toList());
        ArrayList newList = Lists.newArrayList();
        for (MaterialTypePermissionDO typePermissionDO : sourceList) {
            if (typePermissionDO.getSourceType() == 1) continue;
            for (Integer childId : childTypeIdList) {
                MaterialTypePermissionDO n = new MaterialTypePermissionDO();
                BeanUtils.copyProperties((Object)typePermissionDO, (Object)n);
                n.setMaterialTypeId(childId);
                n.setSourceType(Integer.valueOf(2));
                n.setId(null);
                newList.add(n);
            }
        }
        this.batchInsert(newList);
        this.removeByIdList(targetOldExtendPermissionIdList);
        this.onMaterialTypePermissionChange(childTypeIdList);
    }

    private void batchCopyPermissionForCopy(List<MaterialTypePermissionDO> sourceList, List<Integer> typeIdList) {
        if (CollectionUtils.isEmpty(typeIdList)) {
            return;
        }
        ArrayList newList = Lists.newArrayList();
        for (MaterialTypePermissionDO typePermissionDO : sourceList) {
            if (typePermissionDO.getSourceType() == 1) continue;
            for (Integer childId : typeIdList) {
                MaterialTypePermissionDO n = new MaterialTypePermissionDO();
                BeanUtils.copyProperties((Object)typePermissionDO, (Object)n);
                n.setMaterialTypeId(childId);
                n.setSourceType(Integer.valueOf(2));
                n.setId(null);
                newList.add(n);
            }
        }
        this.batchInsert(newList);
        this.onMaterialTypePermissionChange(typeIdList);
    }

    @Override
    public boolean valid(Integer typeId, Users user, int permissionType) {
        Boolean isSuper = this.commonRemoteService.isSuper(user.getId());
        if (isSuper.booleanValue()) {
            return true;
        }
        return this.containsByType(typeId, user, permissionType);
    }

    private void updateByTypeIdAndUnitId(Integer groupId, Integer materialTypeId, Long unitId, Set<Integer> checkedPermissionTypes) {
        if (CollectionUtils.isEmpty(checkedPermissionTypes)) {
            this.removeByTypeIdAndUnitId(materialTypeId, unitId);
            return;
        }
        List<Long> oldIdList = this.getIdListByMaterialTypeIdAndUnitId(materialTypeId, unitId);
        this.createByPermissionTypes(groupId, unitId, materialTypeId, checkedPermissionTypes);
        if (CollectionUtils.isNotEmpty(oldIdList)) {
            this.removeByIdList(oldIdList);
        }
    }

    private Result<Void> createByPermissionTypes(Integer groupId, Long unitId, Integer materialTypeId, Set<Integer> checkedPermissionTypes) {
        ArrayList domainList = Lists.newArrayList();
        for (Integer checkedPermissionType : checkedPermissionTypes) {
            MaterialTypePermissionDO domain = new MaterialTypePermissionDO();
            domain.setUnitId(unitId);
            domain.setMaterialTypeId(materialTypeId);
            domain.setPermissionType(checkedPermissionType);
            domain.setSourceType(Integer.valueOf(0));
            domain.setEnterpriseId(groupId);
            domainList.add(domain);
        }
        this.batchInsert(domainList);
        return ResultUtils.success();
    }

    private List<Long> getIdListByMaterialTypeIdAndUnitId(Integer materialTypeId, Long unitId) {
        LambdaQueryWrapper select = ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(MaterialTypePermissionDO::getMaterialTypeId, (Object)materialTypeId)).eq(MaterialTypePermissionDO::getUnitId, (Object)unitId)).in(MaterialTypePermissionDO::getSourceType, (Collection)Lists.newArrayList((Object[])new Integer[]{2, 0}))).eq(MaterialTypePermissionDO::getDeleted, (Object)0)).select(new SFunction[]{MaterialTypePermissionDO::getId});
        return this.typePermissionMapper.selectList((Wrapper)select).stream().map(MaterialTypePermissionDO::getId).collect(Collectors.toList());
    }

    private boolean containsByType(Integer typeId, Users user, int permissionType) {
        List<Long> unitIdList = this.unitService.getIdListByUserId(user.getId());
        List permissionList = PermissionConst.getListByPermissionType((int)permissionType);
        LambdaQueryWrapper q = new LambdaQueryWrapper();
        q.eq(MaterialTypePermissionDO::getMaterialTypeId, (Object)typeId);
        q.in(MaterialTypePermissionDO::getUnitId, unitIdList);
        q.eq(MaterialTypePermissionDO::getDeleted, (Object)0);
        q.in(MaterialTypePermissionDO::getPermissionType, (Collection)permissionList);
        q.last("limit 1");
        MaterialTypePermissionDO typePermissionDO = (MaterialTypePermissionDO)this.typePermissionMapper.selectOne((Wrapper)q);
        return typePermissionDO != null;
    }

    @Override
    public void batchInsert(List<MaterialTypePermissionDO> permissionList) {
        if (CollectionUtils.isEmpty(permissionList)) {
            return;
        }
        log.info("\u6279\u91cf\u63d2\u5165\u7d20\u6750\u5206\u7c7b\u6743\u9650 permissionList:{}", permissionList);
        this.typePermissionMapper.batchInsert(permissionList);
    }

    @Override
    public boolean checkExist(Integer materialTypeId, Long unitId, Integer permissionType) {
        LambdaQueryWrapper permissionWrapper = new LambdaQueryWrapper();
        permissionWrapper.eq(MaterialTypePermissionDO::getPermissionType, (Object)permissionType);
        permissionWrapper.eq(MaterialTypePermissionDO::getMaterialTypeId, (Object)materialTypeId);
        permissionWrapper.eq(MaterialTypePermissionDO::getUnitId, (Object)unitId);
        permissionWrapper.eq(MaterialTypePermissionDO::getDeleted, (Object)0);
        permissionWrapper.last("limit 1");
        MaterialTypePermissionDO d = (MaterialTypePermissionDO)this.typePermissionMapper.selectOne((Wrapper)permissionWrapper);
        return d != null;
    }

    private void insert(MaterialTypePermissionDO typePermissionDO) {
        log.info("\u63d2\u5165\u7d20\u6750\u5206\u7c7b\u6743\u9650 typePermissionDO:{}", (Object)typePermissionDO);
        this.typePermissionMapper.insert(typePermissionDO);
    }

    private void removeByTypeIdAndUnitId(Integer materialTypeId, Long unitId) {
        int res = this.typePermissionMapper.removeByMaterialTypeIdAndUnitId(materialTypeId, unitId, PermissionConst.SOURCE_TYPE_CAN_MODIFY_LIST);
        log.info("\u5220\u9664\u7d20\u6750\u5206\u7c7b\u6743\u9650 typeId:{} unitId:{} res:{}", new Object[]{materialTypeId, unitId, res});
    }

    private void removeByIdList(List<Long> idList) {
        if (CollectionUtils.isEmpty(idList)) {
            return;
        }
        int res = this.typePermissionMapper.removeByIdList(idList);
        log.info("\u5220\u9664\u7d20\u6750\u5206\u7c7b\u6743\u9650 idList:{} res:{}", idList, (Object)res);
    }
}

