/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.training.service.permission.material;

import com.ovopark.training.enhancer.subject.resp.Result;
import com.ovopark.training.enhancer.subject.resp.ResultUtils;
import com.ovopark.training.model.TrainingMaterialType;
import com.ovopark.training.model.Users;
import com.ovopark.training.service.materialtype.MaterialTypeService;
import com.ovopark.training.service.permission.material.MaterialTypePermissionService;
import com.ovopark.training.service.permission.material.TypePermissionManage;
import com.ovopark.training.subject.permission.model.MaterialTypePermissionUpdateAllParam;
import com.ovopark.training.subject.permission.model.MaterialTypePermissionUpdateParam;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TypePermissionManageImpl
implements TypePermissionManage {
    @Autowired
    private MaterialTypePermissionService materialTypePermissionService;
    @Autowired
    private MaterialTypeService materialTypeService;

    @Override
    public Result<Void> updateAll(MaterialTypePermissionUpdateAllParam param, Users user) {
        Integer sourceId;
        Integer materialTypeId = param.getMaterialTypeId();
        boolean valid = this.materialTypePermissionService.valid(materialTypeId, user, 3);
        if (!valid) {
            return ResultUtils.fail((String)"permission denied");
        }
        TrainingMaterialType materialType = this.materialTypeService.getById(materialTypeId);
        if (materialType == null) {
            return ResultUtils.fail((String)"material type not found");
        }
        Integer preExtendPass = materialType.getExtendPass();
        if (param.getOptionCover() != null) {
            materialType.setOptionCover(param.getOptionCover());
        }
        if (param.getOptionExtend() != null) {
            materialType.setOptionExtend(param.getOptionExtend());
        }
        this.materialTypeService.processCoverExtend(materialType);
        this.materialTypeService.updateExtendAndCoverAll(materialType);
        Integer extend = materialType.getExtend();
        if (extend != 1) {
            List<MaterialTypePermissionUpdateParam> itemList = param.getItemList();
            for (MaterialTypePermissionUpdateParam item : itemList) {
                item.setMaterialTypeId(param.getMaterialTypeId());
                this.materialTypePermissionService.update(item, user);
            }
        }
        if ((sourceId = materialType.getSourceId()) != null && extend == 1) {
            this.materialTypePermissionService.overridePermissionForExtend(sourceId, materialType.getId());
        } else {
            this.materialTypePermissionService.onMaterialTypePermissionChange(materialTypeId);
        }
        this.materialTypeService.processChildExtendAndPermission(materialType, preExtendPass);
        return ResultUtils.success();
    }
}

