/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.training.service.report;

import cn.hutool.core.date.DateUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.ovopark.organize.common.model.mo.UserAndParentNameMo;
import com.ovopark.organize.common.model.pojo.SimplePojo;
import com.ovopark.organize.common.model.pojo.UsersOrgIdsAndTagsPojo;
import com.ovopark.organize.sdk.api.UserApi;
import com.ovopark.organize.sdk.api.UserOrganizeApi;
import com.ovopark.privilege.api.RoleApi;
import com.ovopark.privilege.pojo.RolePojo;
import com.ovopark.privilege.pojo.UsersPojo;
import com.ovopark.privilege.response.BaseResult;
import com.ovopark.training.bo.Page;
import com.ovopark.training.delegate.DelegateHelper;
import com.ovopark.training.enhancer.subject.resp.Result;
import com.ovopark.training.enhancer.subject.resp.ResultUtils;
import com.ovopark.training.mapper.TrainingChapterAttachMapper;
import com.ovopark.training.mapper.TrainingCommentMapper;
import com.ovopark.training.mapper.TrainingMaterialCommentMapper;
import com.ovopark.training.mapper.TrainingMaterialMapper;
import com.ovopark.training.mapper.TrainingResourceMapper;
import com.ovopark.training.mapper.TrainingUserPaperMapper;
import com.ovopark.training.mapper.TrainingUserViewTimeDayMapper;
import com.ovopark.training.mapper.TrainingUserViewTimeMapper;
import com.ovopark.training.mapper.TrainingUserViewTimeMaterialMapper;
import com.ovopark.training.mapper.TrainingUserViewTimeTrainingMapper;
import com.ovopark.training.model.TrainingChapterAttach;
import com.ovopark.training.model.TrainingComment;
import com.ovopark.training.model.TrainingMaterial;
import com.ovopark.training.model.TrainingMaterialComment;
import com.ovopark.training.model.TrainingResource;
import com.ovopark.training.model.TrainingUserPaper;
import com.ovopark.training.model.TrainingUserViewTime;
import com.ovopark.training.model.TrainingUserViewTimeDay;
import com.ovopark.training.model.TrainingUserViewTimeMaterial;
import com.ovopark.training.model.TrainingUserViewTimeTraining;
import com.ovopark.training.model.Users;
import com.ovopark.training.model.param.TrainingReportParam;
import com.ovopark.training.model.param.UserReportParam;
import com.ovopark.training.model.view.DepartmentTrainingReportVo;
import com.ovopark.training.service.CommonRemoteService;
import com.ovopark.training.service.TrainingService;
import com.ovopark.training.service.UserUtilService;
import com.ovopark.training.service.report.ReportService;
import com.ovopark.training.util.DateUtils;
import com.ovopark.training.util.ListUtil;
import com.ovopark.training.util.StringsUtils;
import com.ovopark.training.vo.OrgVo;
import com.ovopark.training.vo.UserReportTrainingVo;
import com.ovopark.training.vo.UserReportVo;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Service
public class ReportServiceImpl
implements ReportService {
    private static final Logger log = LoggerFactory.getLogger(ReportServiceImpl.class);
    @Autowired
    private DelegateHelper delegateHelper;
    @Autowired
    private CommonRemoteService commonRemoteService;
    @Autowired
    private UserApi userApi;
    @Autowired
    private UserUtilService userUtilService;
    @Autowired
    private TrainingUserViewTimeDayMapper trainingUserViewTimeDayMapper;
    @Autowired
    private TrainingUserViewTimeMapper trainingUserViewTimeMapper;
    @Autowired
    private UserOrganizeApi userOrganizeApi;
    @Autowired
    private TrainingService trainingService;
    @Autowired
    private TrainingResourceMapper trainingResourceMapper;
    @Autowired
    private TrainingUserViewTimeMaterialMapper trainingUserViewTimeMaterialMapper;
    @Autowired
    private TrainingUserViewTimeTrainingMapper trainingUserViewTimeTrainingMapper;
    @Autowired
    private TrainingMaterialMapper trainingMaterialMapper;
    @Autowired
    private RoleApi roleApi;
    @Autowired
    private TrainingChapterAttachMapper trainingChapterAttachMapper;
    @Autowired
    private TrainingMaterialCommentMapper trainingMaterialCommentMapper;
    @Autowired
    private TrainingCommentMapper trainingCommentMapper;
    @Autowired
    private TrainingUserPaperMapper trainingUserPaperMapper;

    @Override
    public Page<DepartmentTrainingReportVo> getDepartmentTrainingReportByPage(TrainingReportParam trainingReportParam, Users user) {
        Page page = new Page();
        if (ObjectUtils.isEmpty((Object)trainingReportParam)) {
            return page;
        }
        Integer pageSize = trainingReportParam.getPageSize() == null ? 10 : trainingReportParam.getPageSize();
        Integer pageNumber = trainingReportParam.getPageNumber() == null ? 1 : trainingReportParam.getPageNumber();
        page.setPageNumber(pageNumber.intValue());
        page.setPageSize(pageSize.intValue());
        String depId = trainingReportParam.getDepId();
        List<Object> organizeIds = !org.springframework.util.StringUtils.isEmpty((Object)depId) ? StringsUtils.stringToList(depId) : Lists.newArrayList();
        List<Object> userOrganizeList = null;
        if (this.commonRemoteService.isSuper(user.getId()).booleanValue()) {
            if (CollectionUtils.isEmpty((Collection)organizeIds)) {
                return page;
            }
            userOrganizeList = Lists.newArrayList();
            ReportServiceImpl reportServiceImpl = this;
            Map<String, OrgVo> orgVoMap = reportServiceImpl.delegateHelper.getUserUtilService().selectOrgMap((List<String>)organizeIds);
            for (String string : organizeIds) {
                OrgVo orgVo = orgVoMap.get(string);
                if (ObjectUtils.isEmpty((Object)orgVo)) continue;
                HashMap map = Maps.newHashMap();
                map.put("id", string);
                map.put("name", orgVo.getName());
                userOrganizeList.add(map);
            }
        } else {
            ReportServiceImpl reportServiceImpl = this;
            userOrganizeList = reportServiceImpl.delegateHelper.getUserOrganizeDelegate().getUserOrganizeByUserId(Collections.singletonList(user.getId()), user.getGroupId());
            if (!CollectionUtils.isEmpty((Collection)organizeIds)) {
                userOrganizeList = userOrganizeList.stream().filter(m -> organizeIds.contains("O_".concat(m.get("id").toString()))).collect(Collectors.toList());
            }
        }
        if (CollectionUtils.isEmpty(userOrganizeList)) {
            return page;
        }
        Page<Object> myPage = ListUtil.myPage(userOrganizeList, page.getPageNumber(), page.getPageSize());
        page.setPageCount(myPage.getPageCount());
        page.setTotalCount(myPage.getTotalCount());
        userOrganizeList = myPage.getContent();
        List<DepartmentTrainingReportVo> departmentTrainingReportVos = this.getDepartmentTrainingReportVos(trainingReportParam, user, (List<Map<String, Object>>)userOrganizeList);
        page.setContent(departmentTrainingReportVos);
        return page;
    }

    private List<DepartmentTrainingReportVo> getDepartmentTrainingReportVos(TrainingReportParam trainingReportParam, Users user, List<Map<String, Object>> userOrganizeList) {
        String today = DateUtil.today();
        String startDate = trainingReportParam.getStartDate() == null ? today : trainingReportParam.getStartDate();
        String endDate = trainingReportParam.getEndDate() == null ? today : trainingReportParam.getEndDate();
        String startTime = DateUtil.beginOfDay((Date)DateUtil.parse((CharSequence)startDate)).toString();
        String endTime = DateUtil.endOfDay((Date)DateUtil.parse((CharSequence)endDate)).toString();
        Map<String, List<UserAndParentNameMo>> depUserMap = this.getDepUserMap(trainingReportParam, user, userOrganizeList);
        List<Object> userIds = Lists.newArrayList();
        if (!ObjectUtils.isEmpty(depUserMap)) {
            userIds = depUserMap.values().stream().flatMap(Collection::stream).map(UserAndParentNameMo::getUserId).distinct().collect(Collectors.toList());
        }
        Map<Object, Object> userViewTimeDayMap = Maps.newHashMap();
        Map<Object, Object> userViewTimeMaterialMap = Maps.newHashMap();
        Map<Object, Object> userViewTimeTrainingMap = Maps.newHashMap();
        List<Object> usersPojoIdList = Lists.newArrayList();
        Map<Object, Object> resourceMap = Maps.newHashMap();
        if (!CollectionUtils.isEmpty((Collection)userIds)) {
            List<TrainingResource> selectNewResourceList;
            List<TrainingUserViewTimeDay> trainingUserViewTimeDays = this.getTrainingUserViewTimeDays(user, endDate, today, userIds, startTime, endTime, startDate);
            if (!CollectionUtils.isEmpty(trainingUserViewTimeDays)) {
                userViewTimeDayMap = trainingUserViewTimeDays.stream().collect(Collectors.groupingBy(TrainingUserViewTimeDay::getUserId));
            }
            userViewTimeMaterialMap = this.getUserFinishMaterial(user, userIds, startTime, endTime, (Map<Integer, List<Integer>>)userViewTimeMaterialMap);
            userViewTimeTrainingMap = this.getUserFinishTraining(user, userIds, startTime, endTime, (Map<Integer, List<Integer>>)userViewTimeTrainingMap);
            ReportServiceImpl reportServiceImpl = this;
            List<UsersPojo> usersPojoList = reportServiceImpl.delegateHelper.getUserOrganizeDelegate().getCoursePrivilegesUserList(user.getGroupId(), "TRAINING_ONLINE_LEARNING,KNOWLEDGE_LIBRARY,MATERIAL_MANAGE,COURSE_MANAGE_NEW");
            if (!CollectionUtils.isEmpty(usersPojoList)) {
                usersPojoIdList = usersPojoList.stream().map(UsersPojo::getId).distinct().collect(Collectors.toList());
                usersPojoIdList.retainAll(userIds);
            }
            if (!CollectionUtils.isEmpty(selectNewResourceList = this.trainingResourceMapper.selectNewResourceList(user.getGroupId(), userIds, startTime, endTime))) {
                resourceMap = selectNewResourceList.stream().collect(Collectors.groupingBy(TrainingResource::getCreater));
            }
        }
        ArrayList departmentTrainingReportVos = Lists.newArrayList();
        DepartmentTrainingReportVo reportVo = null;
        for (Map<String, Object> userOrganize : userOrganizeList) {
            reportVo = new DepartmentTrainingReportVo();
            reportVo.setDepartmentName(userOrganize.get("name").toString());
            List<UserAndParentNameMo> moList = depUserMap.get(userOrganize.get("id").toString());
            List userIdList = moList.stream().map(UserAndParentNameMo::getUserId).distinct().collect(Collectors.toList());
            Integer userCount = CollectionUtils.isEmpty(userIdList) ? 0 : userIdList.size();
            reportVo.setUserCount(userCount);
            ArrayList<Object> pojoIdList = new ArrayList<Object>(usersPojoIdList);
            pojoIdList.retainAll(userIdList);
            reportVo.setUserEnableCount(CollectionUtils.isEmpty(pojoIdList) ? 0 : pojoIdList.size());
            Integer trainCount = 0;
            Integer trainUserCount = 0;
            Integer trainUserTimeCount = 0;
            Integer finishUserTimeCount = 0;
            Integer userTime = 0;
            if (!CollectionUtils.isEmpty(userIdList)) {
                for (Integer userId : userIdList) {
                    List userViewTimeDays;
                    List trainingResourceList = (List)resourceMap.get(userId);
                    if (!CollectionUtils.isEmpty((Collection)trainingResourceList)) {
                        trainCount = trainCount + trainingResourceList.size();
                    }
                    if (CollectionUtils.isEmpty((Collection)(userViewTimeDays = (List)userViewTimeDayMap.get(userId)))) continue;
                    Integer n = trainUserCount;
                    Integer n2 = trainUserCount = Integer.valueOf(trainUserCount + 1);
                    trainUserTimeCount = trainUserTimeCount + userViewTimeDays.stream().mapToInt(TrainingUserViewTimeDay::getViewCount).sum();
                    userTime = userTime + userViewTimeDays.stream().mapToInt(TrainingUserViewTimeDay::getViewTime).sum();
                    List viewTimeMaterialList = (List)userViewTimeMaterialMap.get(userId);
                    List viewTimeTrainingList = (List)userViewTimeTrainingMap.get(userId);
                    finishUserTimeCount = finishUserTimeCount + ((CollectionUtils.isEmpty((Collection)viewTimeMaterialList) ? 0 : viewTimeMaterialList.size()) + (CollectionUtils.isEmpty((Collection)viewTimeTrainingList) ? 0 : viewTimeTrainingList.size()));
                }
            }
            reportVo.setTrainCount(trainCount);
            reportVo.setTrainUserCount(trainUserCount);
            reportVo.setTrainUserTimeCount(trainUserTimeCount);
            reportVo.setUserAvgCount(userCount == 0 ? BigDecimal.ZERO : new BigDecimal(trainUserTimeCount).divide(new BigDecimal(userCount), 2, RoundingMode.HALF_UP));
            reportVo.setFinishUserTimeCount(finishUserTimeCount);
            reportVo.setFinishUserCount(userCount == 0 ? BigDecimal.ZERO : new BigDecimal(finishUserTimeCount).divide(new BigDecimal(userCount), 2, RoundingMode.HALF_UP));
            reportVo.setUserTime(new BigDecimal(userTime).divide(new BigDecimal(60), 2, RoundingMode.HALF_DOWN));
            reportVo.setUserAvgTime(userCount == 0 ? BigDecimal.ZERO : reportVo.getUserTime().divide(new BigDecimal(userCount), 2, RoundingMode.HALF_DOWN));
            departmentTrainingReportVos.add(reportVo);
        }
        return departmentTrainingReportVos;
    }

    private Map<Integer, List<Integer>> getUserFinishMaterial(Users user, List<Integer> userIds, String startTime, String endTime, Map<Integer, List<Integer>> userViewTimeMaterialMap) {
        List userViewTimeMaterials = this.trainingUserViewTimeMaterialMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(TrainingUserViewTime::getEnterpriseId, (Object)user.getGroupId())).in(TrainingUserViewTime::getUserId, userIds)).ge(TrainingUserViewTimeMaterial::getFinishTime, (Object)startTime)).le(TrainingUserViewTimeMaterial::getFinishTime, (Object)endTime));
        if (!CollectionUtils.isEmpty((Collection)userViewTimeMaterials)) {
            userViewTimeMaterialMap = userViewTimeMaterials.stream().collect(Collectors.groupingBy(TrainingUserViewTime::getUserId, Collectors.mapping(TrainingUserViewTime::getMaterialId, Collectors.toList())));
        }
        return userViewTimeMaterialMap;
    }

    private Map<Integer, List<Integer>> getUserFinishTraining(Users user, List<Integer> userIds, String startTime, String endTime, Map<Integer, List<Integer>> viewTimeTrainingMap) {
        List userViewTimeTrainings = this.trainingUserViewTimeTrainingMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(TrainingUserViewTime::getEnterpriseId, (Object)user.getGroupId())).in(TrainingUserViewTime::getUserId, userIds)).ge(TrainingUserViewTimeTraining::getFinishTime, (Object)startTime)).le(TrainingUserViewTimeTraining::getFinishTime, (Object)endTime)).isNotNull(TrainingUserViewTime::getTrainingId));
        if (!CollectionUtils.isEmpty((Collection)userViewTimeTrainings)) {
            Map userViewTimeTrainingMap = userViewTimeTrainings.stream().collect(Collectors.groupingBy(TrainingUserViewTime::getUserId, Collectors.mapping(TrainingUserViewTime::getTrainingId, Collectors.toList())));
            List trainingIds = userViewTimeTrainings.stream().map(TrainingUserViewTime::getTrainingId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            List trainingChapterAttachList = this.trainingChapterAttachMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(TrainingChapterAttach::getEnterpriseId, (Object)user.getGroupId())).in(TrainingChapterAttach::getTrainingId, trainingIds)).eq(TrainingChapterAttach::getIsDel, (Object)0));
            Map<Object, Object> trainingChapterAttachMap = Maps.newHashMap();
            Map<Object, Object> viewTimeMaterialMap = Maps.newHashMap();
            Map<Object, Object> userPaperMap = Maps.newHashMap();
            if (!CollectionUtils.isEmpty((Collection)trainingChapterAttachList)) {
                List userPaperList;
                List paperIds;
                List userViewTimeMaterialList;
                trainingChapterAttachMap = trainingChapterAttachList.stream().collect(Collectors.groupingBy(TrainingChapterAttach::getTrainingId));
                List materialIds = trainingChapterAttachList.stream().map(TrainingChapterAttach::getMaterialId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
                if (!CollectionUtils.isEmpty(materialIds) && !CollectionUtils.isEmpty((Collection)(userViewTimeMaterialList = this.trainingUserViewTimeMaterialMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(TrainingUserViewTime::getEnterpriseId, (Object)user.getGroupId())).in(TrainingUserViewTime::getMaterialId, materialIds)).in(TrainingUserViewTime::getUserId, userIds)).le(TrainingUserViewTimeMaterial::getFinishTime, (Object)endTime))))) {
                    viewTimeMaterialMap = userViewTimeMaterialList.stream().collect(Collectors.groupingBy(TrainingUserViewTime::getUserId));
                }
                if (!CollectionUtils.isEmpty(paperIds = trainingChapterAttachList.stream().map(TrainingChapterAttach::getPaperId).filter(Objects::nonNull).distinct().collect(Collectors.toList())) && !CollectionUtils.isEmpty((Collection)(userPaperList = this.trainingUserPaperMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(TrainingUserPaper::getEnterpriseId, (Object)user.getGroupId())).in(TrainingUserPaper::getUserId, userIds)).in(TrainingUserPaper::getTrainingPaperId, paperIds)).le(TrainingUserPaper::getSubmitTime, (Object)endTime)).eq(TrainingUserPaper::getSourceType, (Object)1))))) {
                    userPaperMap = userPaperList.stream().collect(Collectors.groupingBy(TrainingUserPaper::getUserId));
                }
            }
            ArrayList trainingIdList = null;
            List<Object> materialIdList = null;
            Map<Object, Object> paperMap = null;
            for (Integer userId : userViewTimeTrainingMap.keySet()) {
                trainingIdList = Lists.newArrayList();
                List viewTimeMaterialList = (List)viewTimeMaterialMap.get(userId);
                materialIdList = Lists.newArrayList();
                if (!CollectionUtils.isEmpty((Collection)viewTimeMaterialList)) {
                    materialIdList = viewTimeMaterialList.stream().map(TrainingUserViewTime::getMaterialId).collect(Collectors.toList());
                }
                List userPaperList = (List)userPaperMap.get(userId);
                paperMap = Maps.newHashMap();
                if (!CollectionUtils.isEmpty((Collection)userPaperList)) {
                    paperMap = userPaperList.stream().collect(Collectors.groupingBy(TrainingUserPaper::getTrainingPaperId));
                }
                for (Integer trainingId : userViewTimeTrainingMap.get(userId)) {
                    List trainingChapterAttaches = (List)trainingChapterAttachMap.get(trainingId);
                    if (CollectionUtils.isEmpty((Collection)trainingChapterAttaches)) continue;
                    Boolean isFinish = true;
                    for (TrainingChapterAttach trainingChapterAttach : trainingChapterAttaches) {
                        if (trainingChapterAttach.getMaterialId() != null) {
                            if (materialIdList.contains(trainingChapterAttach.getMaterialId())) continue;
                            isFinish = false;
                            break;
                        }
                        if (trainingChapterAttach.getPaperId() == null) continue;
                        List userPapers = (List)paperMap.get(trainingChapterAttach.getPaperId());
                        if (CollectionUtils.isEmpty((Collection)userPapers)) {
                            isFinish = false;
                            break;
                        }
                        List projectIds = userPapers.stream().map(TrainingUserPaper::getSourceProjectId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
                        if (CollectionUtils.isEmpty(projectIds) || projectIds.contains(trainingId)) continue;
                        isFinish = false;
                        break;
                    }
                    if (!isFinish.booleanValue()) continue;
                    trainingIdList.add(trainingId);
                }
                viewTimeTrainingMap.put(userId, trainingIdList);
            }
        }
        return viewTimeTrainingMap;
    }

    private Map<String, List<UserAndParentNameMo>> getDepUserMap(TrainingReportParam trainingReportParam, Users user, List<Map<String, Object>> userOrganizeList) {
        List<Integer> userStatus = trainingReportParam.getUserStatus();
        Integer isFrozenNum = 0;
        Integer isDelete = 0;
        if (!CollectionUtils.isEmpty(userStatus)) {
            if (userStatus.contains(0) && userStatus.contains(1) && userStatus.contains(2)) {
                isFrozenNum = null;
                isDelete = null;
            } else if (userStatus.contains(0) && userStatus.contains(1)) {
                isFrozenNum = null;
            } else if (userStatus.contains(0) && userStatus.contains(2)) {
                isDelete = null;
            } else if (userStatus.contains(1) && userStatus.contains(2)) {
                isFrozenNum = 1;
                isDelete = 1;
            } else if (userStatus.contains(1)) {
                isFrozenNum = 1;
            } else if (userStatus.contains(2)) {
                isDelete = 2;
                isFrozenNum = null;
            }
        }
        List<String> organizeIds = userOrganizeList.stream().map(m -> m.get("id").toString()).collect(Collectors.toList());
        ReportServiceImpl reportServiceImpl = this;
        Map<String, List<UserAndParentNameMo>> depUserMap = reportServiceImpl.delegateHelper.getUserOrganizeDelegate().getUserByOrganizeIdMap(organizeIds, user.getGroupId(), isFrozenNum, isDelete);
        return depUserMap;
    }

    private List<TrainingUserViewTimeDay> getTrainingUserViewTimeDays(Users user, String endDate, String today, List<Integer> userIds, String startTime, String endTime, String startDate) {
        List<Object> trainingUserViewTimeDays = Lists.newArrayList();
        if (CollectionUtils.isEmpty(userIds)) {
            return trainingUserViewTimeDays;
        }
        if (endDate.compareToIgnoreCase(today) < 0) {
            LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper1.eq(TrainingUserViewTimeDay::getEnterpriseId, (Object)user.getGroupId())).in(TrainingUserViewTimeDay::getUserId, userIds)).ge(TrainingUserViewTimeDay::getCreateTime, (Object)startTime)).le(TrainingUserViewTimeDay::getCreateTime, (Object)endTime)).in(TrainingUserViewTimeDay::getLearnType, Arrays.asList(0, 1));
            trainingUserViewTimeDays = this.trainingUserViewTimeDayMapper.selectList((Wrapper)wrapper1);
        } else if (startDate.compareToIgnoreCase(today) < 0 && endDate.compareToIgnoreCase(today) >= 0) {
            List<TrainingUserViewTimeDay> trainingUserViewTimeDays2;
            LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper1.eq(TrainingUserViewTimeDay::getEnterpriseId, (Object)user.getGroupId())).in(TrainingUserViewTimeDay::getUserId, userIds)).ge(TrainingUserViewTimeDay::getCreateTime, (Object)startTime)).le(TrainingUserViewTimeDay::getCreateTime, (Object)endTime)).in(TrainingUserViewTimeDay::getLearnType, Arrays.asList(0, 1));
            List trainingUserViewTimeDays1 = this.trainingUserViewTimeDayMapper.selectList((Wrapper)wrapper1);
            if (!CollectionUtils.isEmpty((Collection)trainingUserViewTimeDays1)) {
                trainingUserViewTimeDays.addAll(trainingUserViewTimeDays1);
            }
            if (!CollectionUtils.isEmpty(trainingUserViewTimeDays2 = this.trainingUserViewTimeMapper.getTodayViewTimeList(userIds, startTime, user.getGroupId()))) {
                trainingUserViewTimeDays.addAll(trainingUserViewTimeDays2);
            }
        } else if (startDate.compareToIgnoreCase(today) == 0) {
            trainingUserViewTimeDays = this.trainingUserViewTimeMapper.getTodayViewTimeList(userIds, startTime, user.getGroupId());
        }
        return trainingUserViewTimeDays;
    }

    @Override
    public List<DepartmentTrainingReportVo> getDepartmentTrainingReportByExport(TrainingReportParam trainingReportParam) {
        List<Object> departmentTrainingReportVos = Lists.newArrayList();
        if (ObjectUtils.isEmpty((Object)trainingReportParam)) {
            return departmentTrainingReportVos;
        }
        Users user = new Users();
        user.setId(trainingReportParam.getUserId());
        user.setGroupId(trainingReportParam.getEnterpriseId());
        String depId = trainingReportParam.getDepId();
        List<Object> organizeIds = !org.springframework.util.StringUtils.isEmpty((Object)depId) ? StringsUtils.stringToList(depId) : Lists.newArrayList();
        List<Object> userOrganizeList = null;
        if (this.commonRemoteService.isSuper(user.getId()).booleanValue()) {
            if (CollectionUtils.isEmpty((Collection)organizeIds)) {
                return departmentTrainingReportVos;
            }
            userOrganizeList = Lists.newArrayList();
            ReportServiceImpl reportServiceImpl = this;
            Map<String, OrgVo> orgVoMap = reportServiceImpl.delegateHelper.getUserUtilService().selectOrgMap((List<String>)organizeIds);
            for (String string : organizeIds) {
                OrgVo orgVo = orgVoMap.get(string);
                if (ObjectUtils.isEmpty((Object)orgVo)) continue;
                HashMap map = Maps.newHashMap();
                map.put("id", string);
                map.put("name", orgVo.getName());
                userOrganizeList.add(map);
            }
        } else {
            ReportServiceImpl reportServiceImpl = this;
            userOrganizeList = reportServiceImpl.delegateHelper.getUserOrganizeDelegate().getUserOrganizeByUserId(Collections.singletonList(user.getId()), user.getGroupId());
            if (!CollectionUtils.isEmpty((Collection)organizeIds)) {
                userOrganizeList = userOrganizeList.stream().filter(m -> organizeIds.contains("O_".concat(m.get("id").toString()))).collect(Collectors.toList());
            }
        }
        if (CollectionUtils.isEmpty(userOrganizeList)) {
            return departmentTrainingReportVos;
        }
        departmentTrainingReportVos = this.getDepartmentTrainingReportVos(trainingReportParam, user, userOrganizeList);
        return departmentTrainingReportVos;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Result<Page<UserReportVo>> getUserReportByPage(Users users, Integer pageNumber, Integer pageSize, String startDate, String endDate, List<Integer> userStatus, String organizeIds, String depIds, List<Integer> userList) {
        int fromIndex;
        Page page = new Page();
        page.setPageNumber(pageNumber.intValue());
        page.setPageSize(pageSize.intValue());
        ArrayList<UserReportVo> reportList = new ArrayList<UserReportVo>();
        List<Object> roleUserId = new ArrayList();
        Boolean isSuper = this.commonRemoteService.isSuper(users.getId());
        if (!isSuper.booleanValue()) {
            com.ovopark.organize.common.base.BaseResult pojoResult;
            com.ovopark.organize.common.base.BaseResult userResult = this.userApi.getUserPrivilegedUsers(users.getId(), users.getGroupId());
            if (userResult == null || CollectionUtils.isEmpty((Collection)((Collection)userResult.getData()))) return ResultUtils.success((Object)page);
            roleUserId = (List)userResult.getData();
            ArrayList result = new ArrayList();
            if (CollectionUtils.isEmpty(userStatus)) {
                pojoResult = this.userApi.getSimpleUserByKeyWordAndFrozen(users.getGroupId(), null, null, null, null);
                if (pojoResult != null && !CollectionUtils.isEmpty((Collection)((Collection)pojoResult.getData()))) {
                    result.addAll((Collection)pojoResult.getData());
                }
            } else {
                if (userStatus.contains(0) && (pojoResult = this.userApi.getSimpleUserByKeyWordAndFrozen(users.getGroupId(), null, null, Integer.valueOf(0), Integer.valueOf(0))) != null && !CollectionUtils.isEmpty((Collection)((Collection)pojoResult.getData()))) {
                    result.addAll((Collection)pojoResult.getData());
                }
                if (userStatus.contains(1) && (pojoResult = this.userApi.getSimpleUserByKeyWordAndFrozen(users.getGroupId(), null, null, Integer.valueOf(1), Integer.valueOf(0))) != null && !CollectionUtils.isEmpty((Collection)((Collection)pojoResult.getData()))) {
                    result.addAll((Collection)pojoResult.getData());
                }
                if (userStatus.contains(2) && (pojoResult = this.userApi.getSimpleUserByKeyWordAndFrozen(users.getGroupId(), null, null, null, Integer.valueOf(1))) != null && !CollectionUtils.isEmpty((Collection)((Collection)pojoResult.getData()))) {
                    result.addAll((Collection)pojoResult.getData());
                }
            }
            if (result != null && !CollectionUtils.isEmpty(result)) {
                roleUserId.retainAll(result.stream().map(SimplePojo::getId).collect(Collectors.toSet()));
            }
        } else {
            com.ovopark.organize.common.base.BaseResult pojoResult;
            ArrayList result = new ArrayList();
            if (CollectionUtils.isEmpty(userStatus)) {
                pojoResult = this.userApi.getSimpleUserByKeyWordAndFrozen(users.getGroupId(), null, null, null, null);
                if (pojoResult != null && !CollectionUtils.isEmpty((Collection)((Collection)pojoResult.getData()))) {
                    result.addAll((Collection)pojoResult.getData());
                }
            } else {
                if (userStatus.contains(0) && (pojoResult = this.userApi.getSimpleUserByKeyWordAndFrozen(users.getGroupId(), null, null, Integer.valueOf(0), Integer.valueOf(0))) != null && !CollectionUtils.isEmpty((Collection)((Collection)pojoResult.getData()))) {
                    result.addAll((Collection)pojoResult.getData());
                }
                if (userStatus.contains(1) && (pojoResult = this.userApi.getSimpleUserByKeyWordAndFrozen(users.getGroupId(), null, null, Integer.valueOf(1), Integer.valueOf(0))) != null && !CollectionUtils.isEmpty((Collection)((Collection)pojoResult.getData()))) {
                    result.addAll((Collection)pojoResult.getData());
                }
                if (userStatus.contains(2) && (pojoResult = this.userApi.getSimpleUserByKeyWordAndFrozen(users.getGroupId(), null, null, null, Integer.valueOf(1))) != null && !CollectionUtils.isEmpty((Collection)((Collection)pojoResult.getData()))) {
                    result.addAll((Collection)pojoResult.getData());
                }
            }
            if (result != null && !CollectionUtils.isEmpty(result)) {
                roleUserId = result.stream().map(SimplePojo::getId).collect(Collectors.toList());
            }
        }
        if (!CollectionUtils.isEmpty(userList)) {
            roleUserId.retainAll(userList);
        }
        if (!org.springframework.util.StringUtils.isEmpty((Object)organizeIds) || !org.springframework.util.StringUtils.isEmpty((Object)depIds)) {
            UsersOrgIdsAndTagsPojo usersOrgIdsAndTagsPojo = new UsersOrgIdsAndTagsPojo();
            usersOrgIdsAndTagsPojo.setGroupId(users.getGroupId());
            usersOrgIdsAndTagsPojo.setOrganizeId(org.springframework.util.StringUtils.isEmpty((Object)organizeIds) ? null : StringsUtils.StringToList(organizeIds, ","));
            usersOrgIdsAndTagsPojo.setDepartmentIds(org.springframework.util.StringUtils.isEmpty((Object)depIds) ? null : StringsUtils.StringToList(depIds, ","));
            com.ovopark.organize.common.base.BaseResult baseResult = this.userOrganizeApi.getUserOrganizeByTagAndOrgIds(usersOrgIdsAndTagsPojo);
            List userIdList = (List)baseResult.getData();
            roleUserId.retainAll(userIdList);
            if (CollectionUtils.isEmpty(roleUserId)) {
                return ResultUtils.success((Object)page);
            }
        }
        if ((fromIndex = (page.getPageNumber() - 1) * page.getPageSize()) >= roleUserId.size()) {
            return ResultUtils.success((Object)page);
        }
        int toIndex = Math.min(fromIndex + page.getPageSize(), roleUserId.size());
        page.setPageCount(Long.valueOf(roleUserId.size() % page.getPageSize() == 0 ? (long)(roleUserId.size() / page.getPageSize()) : (long)(roleUserId.size() / page.getPageSize() + 1)));
        page.setTotalCount(Long.valueOf(roleUserId.size()));
        List<Object> subList = roleUserId.subList(fromIndex, toIndex);
        Map<Integer, List<String>> userOrganizeMap = this.userUtilService.selectOrganizeMap(subList, users.getGroupId());
        Map<Integer, com.ovopark.organize.common.model.pojo.UsersPojo> usersPojoMap = this.userUtilService.selectUserMap(subList);
        Map userRoleMap = new HashMap();
        if (!CollectionUtils.isEmpty(subList)) {
            HashMap<String, Object> parameter = new HashMap<String, Object>();
            parameter.put("userIds", StringUtils.join(subList, (String)","));
            parameter.put("groupId", users.getGroupId());
            BaseResult baseResult = this.roleApi.getUserRoleList(parameter);
            if (baseResult != null) {
                userRoleMap = (Map)baseResult.getData();
            }
        }
        for (Integer n : subList) {
            UserReportVo vo = new UserReportVo();
            if (!CollectionUtils.isEmpty(usersPojoMap) && usersPojoMap.get(n) != null) {
                com.ovopark.organize.common.model.pojo.UsersPojo pojo = usersPojoMap.get(n);
                vo.setUserId(pojo.getUserId());
                vo.setShowName(pojo.getShowName());
                vo.setMobilePhone(pojo.getMobilePhone());
                vo.setEmail(pojo.getMail());
                vo.setOnboardingDate(DateUtils.format(pojo.getCreateTime(), "yyyy-MM-dd"));
                if (pojo.getIsDel() == 0 && pojo.getIsFrozen() == 1) {
                    vo.setUserStatus(Integer.valueOf(1));
                } else if (pojo.getIsDel() != null && pojo.getIsDel() == 1) {
                    vo.setUserStatus(Integer.valueOf(2));
                } else {
                    vo.setUserStatus(Integer.valueOf(0));
                }
                List<String> userStr = userOrganizeMap.get(n);
                vo.setOrganizeName(CollectionUtils.isEmpty(userStr) ? "" : String.join((CharSequence)";\n", userStr));
                if (!CollectionUtils.isEmpty((Collection)((Collection)userRoleMap.get(n)))) {
                    StringBuilder role = new StringBuilder();
                    for (RolePojo rolePojo : (List)userRoleMap.get(n)) {
                        role.append(rolePojo.getRoleName()).append(";\n");
                    }
                    vo.setRoleName(role.substring(0, role.length() - 2));
                }
                ArrayList<UserReportTrainingVo> trainingList = new ArrayList<UserReportTrainingVo>();
                ArrayList<Integer> userIds = new ArrayList<Integer>();
                userIds.add(n);
                List<TrainingResource> list = this.trainingResourceMapper.selectNewResourceList(users.getGroupId(), userIds, startDate, endDate);
                if (!CollectionUtils.isEmpty(list)) {
                    vo.setNewTrainingCount(list.size());
                    for (TrainingResource resource : list) {
                        List viewTimeList;
                        LambdaQueryWrapper timeWrapper;
                        UserReportTrainingVo trainingVo = new UserReportTrainingVo();
                        trainingVo.setTrainingName(resource.getShowName());
                        trainingVo.setStudyNum(resource.getViewCount().intValue());
                        trainingVo.setIsUsing(resource.getIsUsing());
                        trainingVo.setFileType(resource.getFileType());
                        trainingVo.setIsShow(resource.getIsShow());
                        trainingVo.setScore(resource.getScore());
                        trainingVo.setRecommend(resource.getRecommend().intValue());
                        trainingVo.setCreateTime(DateUtils.format(resource.getCreateTime(), "yyyy-MM-dd HH:mm"));
                        trainingVo.setUpdateTime(DateUtils.format(resource.getUpdateTime(), "yyyy-MM-dd HH:mm"));
                        trainingVo.setVersion(resource.getVersion().intValue());
                        trainingVo.setLikeCount(resource.getLikeCount().intValue());
                        trainingVo.setDownloads(resource.getDownloads().intValue());
                        if (resource.getFileType().equals(8)) {
                            timeWrapper = new LambdaQueryWrapper();
                            timeWrapper.eq(TrainingUserViewTime::getEnterpriseId, (Object)users.getGroupId());
                            timeWrapper.eq(TrainingUserViewTime::getTrainingId, (Object)resource.getObjectId());
                            viewTimeList = this.trainingUserViewTimeMapper.selectList((Wrapper)timeWrapper);
                            if (!CollectionUtils.isEmpty((Collection)viewTimeList)) {
                                trainingVo.setStudyNum(viewTimeList.stream().map(TrainingUserViewTime::getUserId).distinct().collect(Collectors.toList()).size());
                                int totalStudyTime = viewTimeList.stream().mapToInt(TrainingUserViewTime::getViewTime).sum();
                                trainingVo.setStudyTime(Double.valueOf(new BigDecimal(totalStudyTime).divide(new BigDecimal(60), 2, RoundingMode.HALF_UP).doubleValue()));
                                Map<String, Object> map = this.trainingService.getLearnerSummary(users, resource.getObjectId());
                                if (map != null && map.get("finish") != null) {
                                    trainingVo.setFinishNum(((Integer)map.get("finish")).intValue());
                                }
                            }
                            int time = 0;
                            LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
                            wrapper.eq(TrainingChapterAttach::getTrainingId, (Object)resource.getObjectId());
                            wrapper.eq(TrainingChapterAttach::getIsDel, (Object)0);
                            List attachList = this.trainingChapterAttachMapper.selectList((Wrapper)wrapper);
                            if (!CollectionUtils.isEmpty((Collection)attachList)) {
                                LambdaQueryWrapper materialWrapper = new LambdaQueryWrapper();
                                materialWrapper.in(TrainingMaterial::getId, (Collection)attachList.stream().map(TrainingChapterAttach::getMaterialId).collect(Collectors.toList()));
                                List materialList = this.trainingMaterialMapper.selectList((Wrapper)materialWrapper);
                                if (!CollectionUtils.isEmpty((Collection)materialList)) {
                                    for (TrainingMaterial material : materialList) {
                                        if (material.getIsVideo() == 0) {
                                            time += material.getFinishTime().intValue();
                                            continue;
                                        }
                                        time += material.getDuration().intValue();
                                    }
                                }
                            }
                            trainingVo.setStandardTime(Double.valueOf(new BigDecimal(time).divide(new BigDecimal(60), 2, RoundingMode.HALF_UP).doubleValue()));
                            LambdaQueryWrapper commentWrapper = new LambdaQueryWrapper();
                            commentWrapper.eq(TrainingMaterialComment::getEnterpriseId, (Object)resource.getEnterpriseId());
                            commentWrapper.eq(TrainingMaterialComment::getType, (Object)2);
                            commentWrapper.eq(TrainingMaterialComment::getMaterialId, (Object)resource.getObjectId());
                            commentWrapper.eq(TrainingMaterialComment::getIsCollect, (Object)1);
                            List commentList = this.trainingMaterialCommentMapper.selectList((Wrapper)commentWrapper);
                            if (!CollectionUtils.isEmpty((Collection)commentList)) {
                                trainingVo.setCollectNum(commentList.size());
                            }
                            LambdaQueryWrapper comWrapper = new LambdaQueryWrapper();
                            comWrapper.eq(TrainingComment::getTrainingId, (Object)resource.getObjectId());
                            comWrapper.eq(TrainingComment::getCommentType, (Object)1);
                            comWrapper.eq(TrainingComment::getIsDel, (Object)0);
                            List comList = this.trainingCommentMapper.selectList((Wrapper)comWrapper);
                            if (!CollectionUtils.isEmpty((Collection)comList)) {
                                trainingVo.setCommentUserNum(comList.stream().map(TrainingComment::getUserId).distinct().collect(Collectors.toList()).size());
                                trainingVo.setCommentNum(comList.size());
                            }
                        } else {
                            timeWrapper = new LambdaQueryWrapper();
                            timeWrapper.eq(TrainingUserViewTime::getEnterpriseId, (Object)users.getGroupId());
                            timeWrapper.eq(TrainingUserViewTime::getMaterialId, (Object)resource.getObjectId());
                            viewTimeList = this.trainingUserViewTimeMapper.selectList((Wrapper)timeWrapper);
                            if (!CollectionUtils.isEmpty((Collection)viewTimeList)) {
                                trainingVo.setStudyNum(viewTimeList.stream().map(TrainingUserViewTime::getUserId).distinct().collect(Collectors.toList()).size());
                                int totalStudyTime = viewTimeList.stream().mapToInt(TrainingUserViewTime::getViewTime).sum();
                                trainingVo.setStudyTime(Double.valueOf(new BigDecimal(totalStudyTime).divide(new BigDecimal(60), 2, RoundingMode.HALF_UP).doubleValue()));
                                Map<String, Object> map = this.trainingService.getLearnerSummary(users, resource.getObjectId());
                                if (map != null && map.get("finish") != null) {
                                    trainingVo.setFinishNum(((Integer)map.get("finish")).intValue());
                                }
                            }
                            TrainingMaterial material = (TrainingMaterial)this.trainingMaterialMapper.selectById(resource.getObjectId());
                            int finiashTime = 0;
                            finiashTime = material.getIsVideo() == 0 ? material.getFinishTime().intValue() : material.getDuration().intValue();
                            trainingVo.setStandardTime(Double.valueOf(new BigDecimal(finiashTime).divide(new BigDecimal(60), 2, RoundingMode.HALF_UP).doubleValue()));
                            LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
                            wrapper.eq(TrainingUserViewTime::getEnterpriseId, (Object)users.getGroupId());
                            wrapper.gt(TrainingUserViewTime::getViewTime, (Object)finiashTime);
                            wrapper.eq(TrainingUserViewTime::getMaterialId, (Object)resource.getObjectId());
                            wrapper.groupBy(TrainingUserViewTime::getUserId);
                            List materialList = this.trainingUserViewTimeMaterialMapper.selectList((Wrapper)wrapper);
                            trainingVo.setFinishNum(materialList.size());
                            LambdaQueryWrapper commentWrapper = new LambdaQueryWrapper();
                            commentWrapper.eq(TrainingMaterialComment::getEnterpriseId, (Object)resource.getEnterpriseId());
                            commentWrapper.eq(TrainingMaterialComment::getType, (Object)1);
                            commentWrapper.eq(TrainingMaterialComment::getMaterialId, (Object)resource.getObjectId());
                            commentWrapper.eq(TrainingMaterialComment::getIsCollect, (Object)1);
                            List commentList = this.trainingMaterialCommentMapper.selectList((Wrapper)commentWrapper);
                            if (!CollectionUtils.isEmpty((Collection)commentList)) {
                                trainingVo.setCollectNum(commentList.size());
                            }
                            LambdaQueryWrapper comWrapper = new LambdaQueryWrapper();
                            comWrapper.eq(TrainingComment::getTrainingId, (Object)resource.getObjectId());
                            comWrapper.eq(TrainingComment::getCommentType, (Object)4);
                            comWrapper.eq(TrainingComment::getIsDel, (Object)0);
                            List comList = this.trainingCommentMapper.selectList((Wrapper)comWrapper);
                            if (!CollectionUtils.isEmpty((Collection)comList)) {
                                trainingVo.setCommentUserNum(comList.stream().map(TrainingComment::getUserId).distinct().collect(Collectors.toList()).size());
                                trainingVo.setCommentNum(comList.size());
                            }
                        }
                        trainingList.add(trainingVo);
                    }
                    vo.setTrainingList(trainingList);
                }
            }
            reportList.add(vo);
        }
        page.setContent(reportList);
        return ResultUtils.success((Object)page);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public List<UserReportVo> getUserReportByExport(UserReportParam param) {
        ArrayList<UserReportVo> reportList = new ArrayList<UserReportVo>();
        ArrayList<Integer> roleUserId = new ArrayList();
        Boolean isSuper = this.commonRemoteService.isSuper(param.getUserId());
        if (!isSuper.booleanValue()) {
            com.ovopark.organize.common.base.BaseResult pojoResult;
            com.ovopark.organize.common.base.BaseResult userResult = this.userApi.getUserPrivilegedUsers(param.getUserId(), param.getEnterpriseId());
            if (userResult == null || CollectionUtils.isEmpty((Collection)((Collection)userResult.getData()))) return reportList;
            roleUserId = (List)userResult.getData();
            ArrayList result = new ArrayList();
            if (CollectionUtils.isEmpty(param.getUserStatus())) {
                pojoResult = this.userApi.getSimpleUserByKeyWordAndFrozen(param.getEnterpriseId(), null, null, null, null);
                if (pojoResult != null && !CollectionUtils.isEmpty((Collection)((Collection)pojoResult.getData()))) {
                    result.addAll((Collection)pojoResult.getData());
                }
            } else {
                if (param.getUserStatus().contains(0) && (pojoResult = this.userApi.getSimpleUserByKeyWordAndFrozen(param.getEnterpriseId(), null, null, Integer.valueOf(0), Integer.valueOf(0))) != null && !CollectionUtils.isEmpty((Collection)((Collection)pojoResult.getData()))) {
                    result.addAll((Collection)pojoResult.getData());
                }
                if (param.getUserStatus().contains(1) && (pojoResult = this.userApi.getSimpleUserByKeyWordAndFrozen(param.getEnterpriseId(), null, null, Integer.valueOf(1), null)) != null && !CollectionUtils.isEmpty((Collection)((Collection)pojoResult.getData()))) {
                    result.addAll((Collection)pojoResult.getData());
                }
                if (param.getUserStatus().contains(2) && (pojoResult = this.userApi.getSimpleUserByKeyWordAndFrozen(param.getEnterpriseId(), null, null, null, Integer.valueOf(1))) != null && !CollectionUtils.isEmpty((Collection)((Collection)pojoResult.getData()))) {
                    result.addAll((Collection)pojoResult.getData());
                }
            }
            if (result != null && !CollectionUtils.isEmpty(result)) {
                roleUserId.retainAll(result.stream().map(SimplePojo::getId).collect(Collectors.toList()));
            }
        } else {
            com.ovopark.organize.common.base.BaseResult pojoResult;
            ArrayList result = new ArrayList();
            if (CollectionUtils.isEmpty(param.getUserStatus())) {
                pojoResult = this.userApi.getSimpleUserByKeyWordAndFrozen(param.getEnterpriseId(), null, null, null, null);
                if (pojoResult != null && !CollectionUtils.isEmpty((Collection)((Collection)pojoResult.getData()))) {
                    result.addAll((Collection)pojoResult.getData());
                }
            } else {
                if (param.getUserStatus().contains(0) && (pojoResult = this.userApi.getSimpleUserByKeyWordAndFrozen(param.getEnterpriseId(), null, null, Integer.valueOf(0), Integer.valueOf(0))) != null && !CollectionUtils.isEmpty((Collection)((Collection)pojoResult.getData()))) {
                    result.addAll((Collection)pojoResult.getData());
                }
                if (param.getUserStatus().contains(1) && (pojoResult = this.userApi.getSimpleUserByKeyWordAndFrozen(param.getEnterpriseId(), null, null, Integer.valueOf(1), null)) != null && !CollectionUtils.isEmpty((Collection)((Collection)pojoResult.getData()))) {
                    result.addAll((Collection)pojoResult.getData());
                }
                if (param.getUserStatus().contains(2) && (pojoResult = this.userApi.getSimpleUserByKeyWordAndFrozen(param.getEnterpriseId(), null, null, null, Integer.valueOf(1))) != null && !CollectionUtils.isEmpty((Collection)((Collection)pojoResult.getData()))) {
                    result.addAll((Collection)pojoResult.getData());
                }
            }
            if (result != null && !CollectionUtils.isEmpty(result)) {
                roleUserId = result.stream().map(SimplePojo::getId).collect(Collectors.toList());
            }
        }
        if (!CollectionUtils.isEmpty(param.getUserList())) {
            roleUserId.retainAll(param.getUserList());
        }
        if (!org.springframework.util.StringUtils.isEmpty((Object)param.getOrganizeIds()) || !org.springframework.util.StringUtils.isEmpty((Object)param.getDepIds())) {
            UsersOrgIdsAndTagsPojo usersOrgIdsAndTagsPojo = new UsersOrgIdsAndTagsPojo();
            usersOrgIdsAndTagsPojo.setGroupId(param.getEnterpriseId());
            usersOrgIdsAndTagsPojo.setOrganizeId(org.springframework.util.StringUtils.isEmpty((Object)param.getOrganizeIds()) ? null : StringsUtils.StringToList(param.getOrganizeIds(), ","));
            usersOrgIdsAndTagsPojo.setDepartmentIds(org.springframework.util.StringUtils.isEmpty((Object)param.getDepIds()) ? null : StringsUtils.StringToList(param.getDepIds(), ","));
            com.ovopark.organize.common.base.BaseResult baseResult = this.userOrganizeApi.getUserOrganizeByTagAndOrgIds(usersOrgIdsAndTagsPojo);
            List userIdList = (List)baseResult.getData();
            roleUserId.retainAll(userIdList);
            if (CollectionUtils.isEmpty(roleUserId)) {
                return reportList;
            }
        }
        Map<Integer, List<String>> userOrganizeMap = this.userUtilService.selectOrganizeMap(roleUserId, param.getEnterpriseId());
        Map<Integer, com.ovopark.organize.common.model.pojo.UsersPojo> usersPojoMap = this.userUtilService.selectUserMap(roleUserId);
        Map userRoleMap = new HashMap();
        if (!CollectionUtils.isEmpty(roleUserId)) {
            HashMap<String, Object> parameter = new HashMap<String, Object>();
            parameter.put("userIds", StringUtils.join(roleUserId, (String)","));
            parameter.put("groupId", param.getEnterpriseId());
            BaseResult base = this.roleApi.getUserRoleList(parameter);
            if (base != null) {
                userRoleMap = (Map)base.getData();
            }
        }
        for (Integer uId : roleUserId) {
            UserReportVo vo = new UserReportVo();
            if (!CollectionUtils.isEmpty(usersPojoMap) && usersPojoMap.get(uId) != null) {
                com.ovopark.organize.common.model.pojo.UsersPojo pojo = usersPojoMap.get(uId);
                vo.setUserId(pojo.getUserId());
                vo.setShowName(pojo.getShowName());
                vo.setMobilePhone(pojo.getMobilePhone());
                vo.setEmail(pojo.getMail());
                vo.setOnboardingDate(DateUtils.format(pojo.getCreateTime(), "yyyy-MM-dd"));
                if (pojo.getIsDel() != null && pojo.getIsDel() == 1) {
                    vo.setUserStatus(Integer.valueOf(2));
                } else if (pojo.getIsFrozen() != null && pojo.getIsFrozen() == 1) {
                    vo.setUserStatus(Integer.valueOf(1));
                } else {
                    vo.setUserStatus(Integer.valueOf(0));
                }
                List<String> userStr = userOrganizeMap.get(uId);
                vo.setOrganizeName(CollectionUtils.isEmpty(userStr) ? "" : String.join((CharSequence)";\n", userStr));
                if (!CollectionUtils.isEmpty((Collection)((Collection)userRoleMap.get(uId)))) {
                    StringBuilder role = new StringBuilder();
                    for (RolePojo rolePojo : (List)userRoleMap.get(uId)) {
                        role.append(rolePojo.getRoleName()).append(";\n");
                    }
                    vo.setRoleName(role.substring(0, role.length() - 2));
                }
                ArrayList<UserReportTrainingVo> trainingList = new ArrayList<UserReportTrainingVo>();
                ArrayList<Integer> userIds = new ArrayList<Integer>();
                userIds.add(uId);
                List<TrainingResource> list = this.trainingResourceMapper.selectNewResourceList(param.getEnterpriseId(), userIds, param.getStartDate(), param.getEndDate());
                if (!CollectionUtils.isEmpty(list)) {
                    vo.setNewTrainingCount(list.size());
                    for (TrainingResource resource : list) {
                        Map<String, Object> map;
                        List viewTimeList;
                        LambdaQueryWrapper timeWrapper;
                        UserReportTrainingVo trainingVo = new UserReportTrainingVo();
                        trainingVo.setTrainingName(resource.getShowName());
                        trainingVo.setStudyNum(resource.getViewCount().intValue());
                        trainingVo.setIsUsing(resource.getIsUsing());
                        trainingVo.setFileType(resource.getFileType());
                        trainingVo.setIsShow(resource.getIsShow());
                        trainingVo.setScore(resource.getScore());
                        trainingVo.setRecommend(resource.getRecommend().intValue());
                        trainingVo.setCreateTime(DateUtils.format(resource.getCreateTime(), "yyyy-MM-dd HH:mm"));
                        trainingVo.setUpdateTime(DateUtils.format(resource.getUpdateTime(), "yyyy-MM-dd HH:mm"));
                        trainingVo.setVersion(resource.getVersion().intValue());
                        trainingVo.setLikeCount(resource.getLikeCount().intValue());
                        trainingVo.setDownloads(resource.getDownloads().intValue());
                        if (resource.getFileType().equals(8)) {
                            timeWrapper = new LambdaQueryWrapper();
                            timeWrapper.eq(TrainingUserViewTime::getEnterpriseId, (Object)param.getEnterpriseId());
                            timeWrapper.eq(TrainingUserViewTime::getTrainingId, (Object)resource.getObjectId());
                            viewTimeList = this.trainingUserViewTimeMapper.selectList((Wrapper)timeWrapper);
                            if (!CollectionUtils.isEmpty((Collection)viewTimeList)) {
                                trainingVo.setStudyNum(viewTimeList.stream().map(TrainingUserViewTime::getUserId).distinct().collect(Collectors.toList()).size());
                                int totalStudyTime = viewTimeList.stream().mapToInt(TrainingUserViewTime::getViewTime).sum();
                                trainingVo.setStudyTime(Double.valueOf(new BigDecimal(totalStudyTime).divide(new BigDecimal(60), 2, RoundingMode.HALF_UP).doubleValue()));
                                Users users = new Users();
                                users.setId(param.getUserId());
                                users.setGroupId(param.getEnterpriseId());
                                map = this.trainingService.getLearnerSummary(users, resource.getObjectId());
                                if (map != null && map.get("finish") != null) {
                                    trainingVo.setFinishNum(((Integer)map.get("finish")).intValue());
                                }
                            }
                            int time = 0;
                            LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
                            wrapper.eq(TrainingChapterAttach::getTrainingId, (Object)resource.getObjectId());
                            wrapper.eq(TrainingChapterAttach::getIsDel, (Object)0);
                            List attachList = this.trainingChapterAttachMapper.selectList((Wrapper)wrapper);
                            if (!CollectionUtils.isEmpty((Collection)attachList)) {
                                LambdaQueryWrapper materialWrapper = new LambdaQueryWrapper();
                                materialWrapper.in(TrainingMaterial::getId, (Collection)attachList.stream().map(TrainingChapterAttach::getMaterialId).collect(Collectors.toList()));
                                List materialList = this.trainingMaterialMapper.selectList((Wrapper)materialWrapper);
                                if (!CollectionUtils.isEmpty((Collection)materialList)) {
                                    for (TrainingMaterial material : materialList) {
                                        if (material.getIsVideo() == 0) {
                                            time += material.getFinishTime().intValue();
                                            continue;
                                        }
                                        time += material.getDuration().intValue();
                                    }
                                }
                            }
                            trainingVo.setStandardTime(Double.valueOf(new BigDecimal(time).divide(new BigDecimal(60), 2, RoundingMode.HALF_UP).doubleValue()));
                            LambdaQueryWrapper commentWrapper = new LambdaQueryWrapper();
                            commentWrapper.eq(TrainingMaterialComment::getEnterpriseId, (Object)resource.getEnterpriseId());
                            commentWrapper.eq(TrainingMaterialComment::getType, (Object)2);
                            commentWrapper.eq(TrainingMaterialComment::getMaterialId, (Object)resource.getObjectId());
                            commentWrapper.eq(TrainingMaterialComment::getIsCollect, (Object)1);
                            List commentList = this.trainingMaterialCommentMapper.selectList((Wrapper)commentWrapper);
                            if (!CollectionUtils.isEmpty((Collection)commentList)) {
                                trainingVo.setCollectNum(commentList.size());
                            }
                            LambdaQueryWrapper comWrapper = new LambdaQueryWrapper();
                            comWrapper.eq(TrainingComment::getTrainingId, (Object)resource.getObjectId());
                            comWrapper.eq(TrainingComment::getCommentType, (Object)1);
                            comWrapper.eq(TrainingComment::getIsDel, (Object)0);
                            List comList = this.trainingCommentMapper.selectList((Wrapper)comWrapper);
                            if (!CollectionUtils.isEmpty((Collection)comList)) {
                                trainingVo.setCommentUserNum(comList.stream().map(TrainingComment::getUserId).distinct().collect(Collectors.toList()).size());
                                trainingVo.setCommentNum(comList.size());
                            }
                        } else {
                            timeWrapper = new LambdaQueryWrapper();
                            timeWrapper.eq(TrainingUserViewTime::getEnterpriseId, (Object)resource.getEnterpriseId());
                            timeWrapper.eq(TrainingUserViewTime::getMaterialId, (Object)resource.getObjectId());
                            viewTimeList = this.trainingUserViewTimeMapper.selectList((Wrapper)timeWrapper);
                            if (!CollectionUtils.isEmpty((Collection)viewTimeList)) {
                                trainingVo.setStudyNum(viewTimeList.stream().map(TrainingUserViewTime::getUserId).distinct().collect(Collectors.toList()).size());
                                int totalStudyTime = viewTimeList.stream().mapToInt(TrainingUserViewTime::getViewTime).sum();
                                trainingVo.setStudyTime(Double.valueOf(new BigDecimal(totalStudyTime).divide(new BigDecimal(60), 2, RoundingMode.HALF_UP).doubleValue()));
                                Users users = new Users();
                                users.setId(param.getUserId());
                                users.setGroupId(param.getEnterpriseId());
                                map = this.trainingService.getLearnerSummary(users, resource.getObjectId());
                                if (map != null && map.get("finish") != null) {
                                    trainingVo.setFinishNum(((Integer)map.get("finish")).intValue());
                                }
                            }
                            TrainingMaterial material = (TrainingMaterial)this.trainingMaterialMapper.selectById(resource.getObjectId());
                            int finiashTime = 0;
                            finiashTime = material.getIsVideo() == 0 ? material.getFinishTime().intValue() : material.getDuration().intValue();
                            trainingVo.setStandardTime(Double.valueOf(new BigDecimal(finiashTime).divide(new BigDecimal(60), 2, RoundingMode.HALF_UP).doubleValue()));
                            LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
                            wrapper.eq(TrainingUserViewTime::getEnterpriseId, (Object)param.getEnterpriseId());
                            wrapper.gt(TrainingUserViewTime::getViewTime, (Object)finiashTime);
                            wrapper.eq(TrainingUserViewTime::getMaterialId, (Object)resource.getObjectId());
                            wrapper.groupBy(TrainingUserViewTime::getUserId);
                            List materialList = this.trainingUserViewTimeMaterialMapper.selectList((Wrapper)wrapper);
                            trainingVo.setFinishNum(materialList.size());
                            LambdaQueryWrapper commentWrapper = new LambdaQueryWrapper();
                            commentWrapper.eq(TrainingMaterialComment::getEnterpriseId, (Object)resource.getEnterpriseId());
                            commentWrapper.eq(TrainingMaterialComment::getType, (Object)1);
                            commentWrapper.eq(TrainingMaterialComment::getMaterialId, (Object)resource.getObjectId());
                            commentWrapper.eq(TrainingMaterialComment::getIsCollect, (Object)1);
                            List commentList = this.trainingMaterialCommentMapper.selectList((Wrapper)commentWrapper);
                            if (!CollectionUtils.isEmpty((Collection)commentList)) {
                                trainingVo.setCollectNum(commentList.size());
                            }
                            LambdaQueryWrapper comWrapper = new LambdaQueryWrapper();
                            comWrapper.eq(TrainingComment::getTrainingId, (Object)resource.getObjectId());
                            comWrapper.eq(TrainingComment::getCommentType, (Object)4);
                            comWrapper.eq(TrainingComment::getIsDel, (Object)0);
                            List comList = this.trainingCommentMapper.selectList((Wrapper)comWrapper);
                            if (!CollectionUtils.isEmpty((Collection)comList)) {
                                trainingVo.setCommentUserNum(comList.stream().map(TrainingComment::getUserId).distinct().collect(Collectors.toList()).size());
                                trainingVo.setCommentNum(comList.size());
                            }
                        }
                        trainingList.add(trainingVo);
                    }
                    vo.setTrainingList(trainingList);
                }
            }
            reportList.add(vo);
        }
        return reportList;
    }
}

