/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.training.service.resource;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.ovopark.training.bo.JsonResult;
import com.ovopark.training.constants.PermissionConst;
import com.ovopark.training.domain.MaterialPermissionDO;
import com.ovopark.training.domain.MaterialTypePermissionDO;
import com.ovopark.training.domain.UnitDO;
import com.ovopark.training.enums.biz.MaterialSingleTypeEnum;
import com.ovopark.training.mapper.TrainingMapper;
import com.ovopark.training.mapper.TrainingMaterialMapper;
import com.ovopark.training.mapper.TrainingMaterialPowerMapper;
import com.ovopark.training.mapper.TrainingMaterialPowerUserMapper;
import com.ovopark.training.mapper.TrainingMaterialTypeMapper;
import com.ovopark.training.mapper.TrainingResourceMapper;
import com.ovopark.training.mapper.TrainingUserMapper;
import com.ovopark.training.mapper.permission.MaterialPermissionMapper;
import com.ovopark.training.mapper.permission.PermissionMapper;
import com.ovopark.training.model.TrainingMaterialType;
import com.ovopark.training.model.TrainingResource;
import com.ovopark.training.model.Users;
import com.ovopark.training.model.material.UnitGroup;
import com.ovopark.training.param.material.MaterialBatchUpdatePermissionParam;
import com.ovopark.training.service.OrganizeService;
import com.ovopark.training.service.UserUtilService;
import com.ovopark.training.service.permission.UnitService;
import com.ovopark.training.service.permission.material.MaterialTypePermissionService;
import com.ovopark.training.service.resource.ResourceService;
import com.ovopark.training.service.resource.ResourceSinglePermissionService;
import com.ovopark.training.util.ContextUtil;
import com.ovopark.training.vo.unit.UnitShowVo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Service
public class ResourceSinglePermissionServiceImpl
implements ResourceSinglePermissionService {
    private static final Logger log = LoggerFactory.getLogger(ResourceSinglePermissionServiceImpl.class);
    @Autowired
    private PermissionMapper permissionMapper;
    @Autowired
    private MaterialPermissionMapper materialPermissionMapper;
    @Autowired
    private UnitService unitService;
    @Autowired
    private MaterialTypePermissionService materialTypePermissionService;
    @Autowired
    private TrainingMaterialPowerMapper powerMapper;
    @Autowired
    private TrainingMaterialPowerUserMapper powerUserMapper;
    @Autowired
    private ResourceService resourceService;
    @Autowired
    private TrainingResourceMapper resourceMapper;
    @Autowired
    private TrainingMaterialMapper materialMapper;
    @Autowired
    private TrainingMaterialTypeMapper materialTypeMapper;
    @Autowired
    private OrganizeService organizeService;
    @Autowired
    private TrainingMapper trainingMapper;
    @Autowired
    private TrainingUserMapper trainingUserMapper;
    @Autowired
    private UserUtilService userUtilService;
    @Resource(name="oldCommon")
    private Executor oldCommonExecutor;

    @Override
    public boolean insertResource(TrainingResource resource) {
        log.info("\u65b0\u589e\u8d44\u6e90\u4fdd\u5b58\u6743\u9650 {}", (Object)resource);
        this.resetBySourceSingle(resource);
        this.resetBySourceType(resource);
        return true;
    }

    private void resetBySourceType(TrainingResource resource) {
        this.removeAllByPermissionSource(resource.getId(), 1);
        this.filterPermissionTypesAndProcessBySourceFollowType(resource);
    }

    @Override
    public boolean updateResource(TrainingResource sourceResource, TrainingResource targetResource) {
        boolean downloadTypeChange;
        boolean readTypeChange;
        log.info("\u66f4\u65b0\u7d20\u6750\u4fdd\u5b58\u6743\u9650 {}", (Object)targetResource);
        Integer oldMaterialTypeId = sourceResource.getTypeId();
        Integer materialTypeId = targetResource.getTypeId();
        boolean sameType = oldMaterialTypeId.equals(materialTypeId);
        boolean resetType = false;
        boolean resetSingle = false;
        if (sameType) {
            log.info("\u5206\u7c7b\u4e0d\u53d8");
        } else {
            log.info("\u5206\u7c7b\u53d8\u5316");
            resetType = true;
            this.updatePermissionTypeId(targetResource.getId(), materialTypeId);
        }
        log.info("\u66f4\u65b0\u7d20\u6750\u4fdd\u5b58\u6743\u9650 {}", (Object)targetResource);
        Integer readType = targetResource.getReadType();
        if (readType == null) {
            if (resetType) {
                this.resetBySourceType(targetResource);
            }
            return true;
        }
        boolean bl = readTypeChange = !Objects.equals(readType, sourceResource.getReadType());
        if (readTypeChange || this.hasSingleChange(targetResource, targetResource.getReadSingleGroup(), 1)) {
            log.info("\u67e5\u770b\u6743\u9650\u6539\u52a8");
            resetSingle = true;
            resetType = true;
        }
        boolean bl2 = downloadTypeChange = targetResource.getDownloadType() != null && !Objects.equals(targetResource.getDownloadType(), sourceResource.getDownloadType());
        if (resetSingle || downloadTypeChange || this.hasSingleChange(targetResource, targetResource.getDownloadSingleGroup(), 4)) {
            log.info("\u4e0b\u8f7d\u6743\u9650\u6539\u52a8");
            resetSingle = true;
            resetType = true;
        }
        if (resetType) {
            this.resetBySourceType(targetResource);
        }
        if (resetSingle) {
            this.resetBySourceSingle(targetResource);
        }
        return true;
    }

    private void updatePermissionTypeId(Integer resourceId, Integer materialTypeId) {
        LambdaUpdateWrapper set = (LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(MaterialPermissionDO::getResourceId, (Object)resourceId)).eq(MaterialPermissionDO::getPermissionSource, (Object)2)).set(MaterialPermissionDO::getMaterialTypeId, (Object)materialTypeId);
        int update = this.materialPermissionMapper.update(null, (Wrapper)set);
    }

    private boolean resetMaterialByType(Integer materialTypeId) {
        log.info("\u5206\u7c7b {} \u6743\u9650\u53d8\u5316", (Object)materialTypeId);
        List<TrainingResource> resourceList = this.resourceService.getListByTypeId(materialTypeId);
        for (TrainingResource resource : resourceList) {
            if (resource.getEnterpriseId() == null) continue;
            this.resetBySourceType(resource);
        }
        return true;
    }

    private boolean resetByType(Integer materialTypeId) {
        log.info("\u5206\u7c7b {} \u6743\u9650\u53d8\u5316", (Object)materialTypeId);
        List<TrainingResource> resourceList = this.resourceService.getListByTypeId(materialTypeId);
        for (TrainingResource resource : resourceList) {
            if (resource.getEnterpriseId() == null) continue;
            this.resetBySourceType(resource);
        }
        return true;
    }

    @Override
    public void resetTypePermissionByResourceIdList(List<Integer> resourceIdList) {
        log.info("\u91cd\u7f6e\u7d20\u6750\u6743\u9650 {}", resourceIdList);
        if (CollectionUtils.isEmpty(resourceIdList)) {
            return;
        }
        List<TrainingResource> resourceList = this.resourceService.getListByIdList(resourceIdList);
        for (TrainingResource resource : resourceList) {
            this.resetBySourceType(resource);
            this.updatePermissionTypeId(resource.getId(), resource.getTypeId());
        }
    }

    @Override
    public boolean onMaterialTypePermissionChange(Integer materialTypeId) {
        return this.resetByType(materialTypeId);
    }

    @Override
    public boolean onMaterialTypeListPermissionChange(List<Integer> materialTypeIdList) {
        if (CollectionUtils.isEmpty(materialTypeIdList)) {
            return true;
        }
        List distinctList = materialTypeIdList.stream().distinct().collect(Collectors.toList());
        for (Integer materialTypeId : distinctList) {
            this.resetByType(materialTypeId);
        }
        return true;
    }

    @Override
    public String syncMaterialPermission(Integer startMaterialTypeId, Integer endMaterialTypeId) {
        log.info("\u5e95\u8868\u6743\u9650\u6e05\u6d17 \u5f00\u59cbid{} \u7ed3\u675fid{}", (Object)startMaterialTypeId, (Object)endMaterialTypeId);
        LambdaQueryWrapper materialTypeQuery = new LambdaQueryWrapper();
        materialTypeQuery.between(TrainingMaterialType::getId, (Object)startMaterialTypeId, (Object)endMaterialTypeId);
        List list = this.materialTypeMapper.selectList((Wrapper)materialTypeQuery);
        int successCount = 0;
        int failCount = 0;
        for (TrainingMaterialType trainingMaterialType : list) {
            boolean success = this.resetMaterialByType(trainingMaterialType.getId());
            if (success) {
                ++successCount;
                continue;
            }
            log.info("\u5e95\u8868\u6743\u9650\u6e05\u6d17 \u5931\u8d25 {}", (Object)trainingMaterialType.getId());
            ++failCount;
        }
        HashMap result = Maps.newHashMap();
        result.put("successCount", successCount);
        result.put("failCount", failCount);
        log.info("\u5e95\u8868\u6743\u9650\u6e05\u6d17 \u7ed3\u675f {}", (Object)JSON.toJSONString((Object)result));
        return JsonResult.success((Object)result);
    }

    @Override
    public void batchUpdate(MaterialBatchUpdatePermissionParam param) {
        List trainIdList;
        List materialIdList = param.getMaterialIdList();
        List<Object> resourceIdList = Lists.newArrayList();
        if (!CollectionUtils.isEmpty((Collection)materialIdList)) {
            resourceIdList = this.resourceService.getIdListByMaterialIdList(materialIdList);
        }
        if (!CollectionUtils.isEmpty((Collection)(trainIdList = param.getTrainIdList()))) {
            resourceIdList = this.resourceService.getIdListByTrainIdList(trainIdList);
        }
        Map<Integer, Integer> materialIdTypeMap = this.getMaterialTypeMapByResourceIdList((List<Integer>)resourceIdList);
        for (Integer n : resourceIdList) {
            this.resetBySingleTypeAndPermissionType(n, materialIdTypeMap.get(n), param.getPermissionType(), param.getSingleType(), param.getSingleGroup());
        }
    }

    @Override
    public List<UnitShowVo> getSingleUnitShowListByMaterial(Integer resourceId, int permissionType) {
        List<Long> unitIdList = this.getUnitIdListByPermissionType(resourceId, permissionType, 2);
        List<UnitDO> list = this.unitService.getListById(unitIdList);
        return this.unitService.getShowListByUnitList(list);
    }

    @Override
    public List<UnitDO> getUnitListByMaterialAndPermissionType(Integer resourceId, int permissionType) {
        List<Long> unitIdList = this.getUnitIdListByPermissionType(resourceId, permissionType);
        return this.unitService.getListById(unitIdList);
    }

    @Override
    public boolean valid(Integer resourceId, Users user, int permissionType) {
        return this.valid(resourceId, user.getId(), permissionType);
    }

    @Override
    public boolean valid(Integer resourceId, Integer userId, int permissionType) {
        List<Long> unitIdList = this.unitService.getIdListByUserId(userId);
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(MaterialPermissionDO::getResourceId, (Object)resourceId)).in(MaterialPermissionDO::getPermissionType, (Collection)PermissionConst.getListByPermissionType((int)permissionType))).in(MaterialPermissionDO::getUnitId, unitIdList);
        wrapper.last("limit 1");
        MaterialPermissionDO one = (MaterialPermissionDO)this.materialPermissionMapper.selectOne((Wrapper)wrapper);
        return one != null;
    }

    @Override
    public List<Integer> getMaterialTypeIdListByPermissionTypeAndSource(Users user, Integer permissionType, int permissionSource) {
        List<Long> unitIdList = this.unitService.getIdListByUserId(user.getId());
        LambdaQueryWrapper wrapper = new QueryWrapper().select(new String[]{"distinct `material_type_id`"}).lambda();
        wrapper.in(MaterialPermissionDO::getUnitId, unitIdList);
        wrapper.eq(MaterialPermissionDO::getPermissionType, (Object)permissionType);
        wrapper.eq(MaterialPermissionDO::getPermissionSource, (Object)permissionSource);
        return this.materialPermissionMapper.selectList((Wrapper)wrapper).stream().map(MaterialPermissionDO::getMaterialTypeId).collect(Collectors.toList());
    }

    @Override
    public Map<Integer, List<Integer>> getUserIdMapByTrainIdList(List<Integer> trainingIdList, Integer groupId) {
        HashMap result = Maps.newHashMap();
        List<Integer> superUserId = this.userUtilService.getSuperAdminByGroupId(groupId);
        for (Integer trainingId : trainingIdList) {
            TrainingResource resource = this.resourceService.getByTrainId(trainingId);
            if (ObjectUtils.isEmpty((Object)resource)) continue;
            List<Long> unitIdList = this.getUnitIdListByPermissionType(resource.getId(), 1);
            HashSet userSet = Sets.newHashSet();
            List<Integer> userIdList = this.unitService.getAllUserIdByUnitIdList(unitIdList, groupId);
            userSet.addAll(userIdList);
            userSet.addAll(superUserId);
            result.put(trainingId, Lists.newArrayList((Iterable)userSet));
        }
        return result;
    }

    @Override
    public List<Integer> getUserIdByTrainId(Integer trainingId, Integer groupId) {
        ArrayList list = Lists.newArrayList();
        list.add(trainingId);
        Map<Integer, List<Integer>> map = this.getUserIdMapByTrainIdList(list, groupId);
        return map.get(trainingId);
    }

    @Override
    public List<Integer> getUserIdByMaterialId(Integer materialId, Integer groupId) {
        List<Integer> superUserId = this.userUtilService.getSuperAdminByGroupId(groupId);
        TrainingResource resource = this.resourceService.getByMaterialId(materialId);
        List<Long> unitIdList = this.getUnitIdListByPermissionType(resource.getId(), 1);
        HashSet userSet = Sets.newHashSet();
        List<Integer> userIdList = this.unitService.getAllUserIdByUnitIdList(unitIdList, groupId);
        userSet.addAll(userIdList);
        userSet.addAll(superUserId);
        return Lists.newArrayList((Iterable)userSet);
    }

    @Override
    public Set<Integer> getValidResourceIdSet(Users user, int permissionType, List<Integer> resourceIds) {
        if (CollectionUtils.isEmpty(resourceIds)) {
            return Sets.newHashSet();
        }
        List<Long> unitIdList = this.unitService.getIdListByUserId(user.getId());
        if (CollectionUtils.isEmpty(unitIdList)) {
            return Sets.newHashSet();
        }
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(MaterialPermissionDO::getResourceId, resourceIds)).in(MaterialPermissionDO::getPermissionType, (Collection)PermissionConst.getListByPermissionType((int)permissionType))).in(MaterialPermissionDO::getUnitId, unitIdList);
        wrapper.select(new SFunction[]{MaterialPermissionDO::getResourceId});
        wrapper.groupBy(MaterialPermissionDO::getResourceId);
        List list = this.materialPermissionMapper.selectList((Wrapper)wrapper);
        return list.stream().map(MaterialPermissionDO::getResourceId).collect(Collectors.toSet());
    }

    @Override
    public boolean isTrainContainsAll(Integer resourceId, int permissionType, Integer groupId) {
        long allUnitId = this.unitService.getUnitIdByConstantBiz("1", groupId);
        LambdaQueryWrapper query = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(MaterialPermissionDO::getResourceId, (Object)resourceId)).eq(MaterialPermissionDO::getPermissionType, (Object)permissionType)).eq(MaterialPermissionDO::getUnitId, (Object)allUnitId);
        query.last("limit 1");
        MaterialPermissionDO materialPermissionDO = (MaterialPermissionDO)this.materialPermissionMapper.selectOne((Wrapper)query);
        return materialPermissionDO != null;
    }

    @Override
    public void onResourceDelete(List<Integer> resourceIdList) {
        log.info("\u5220\u9664\u8d44\u6e90\u6743\u9650 {}", resourceIdList);
        if (CollectionUtils.isEmpty(resourceIdList)) {
            return;
        }
        for (Integer resourceId : resourceIdList) {
            this.removeAll(resourceId);
        }
    }

    private List<Long> getUnitIdListByPermissionType(Integer resourceId, int permissionType, int permissionSource) {
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(MaterialPermissionDO::getResourceId, (Object)resourceId)).eq(MaterialPermissionDO::getPermissionSource, (Object)permissionSource)).eq(MaterialPermissionDO::getPermissionType, (Object)permissionType);
        wrapper.select(new SFunction[]{MaterialPermissionDO::getUnitId});
        return this.materialPermissionMapper.selectList((Wrapper)wrapper).stream().map(MaterialPermissionDO::getUnitId).collect(Collectors.toList());
    }

    private List<Long> getUnitIdListByPermissionType(Integer resourceId, int permissionType) {
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(MaterialPermissionDO::getResourceId, (Object)resourceId)).eq(MaterialPermissionDO::getPermissionType, (Object)permissionType);
        wrapper.select(new SFunction[]{MaterialPermissionDO::getUnitId});
        return this.materialPermissionMapper.selectList((Wrapper)wrapper).stream().map(MaterialPermissionDO::getUnitId).collect(Collectors.toList());
    }

    private Map<Integer, Integer> getMaterialTypeMapByResourceIdList(List<Integer> resourceIdList) {
        return this.resourceService.getResourceIdTypeIdMapByIdList(resourceIdList);
    }

    private boolean hasSingleChange(TrainingResource resource, UnitGroup unitGroup, int materialPermissionType) {
        List<UnitDO> unitList = this.unitService.insertByUnitGroup(resource.getEnterpriseId(), unitGroup);
        Set unitIdSet = unitList.stream().map(UnitDO::getId).collect(Collectors.toSet());
        LambdaQueryWrapper permissionQuery = new LambdaQueryWrapper();
        permissionQuery.eq(MaterialPermissionDO::getResourceId, (Object)resource.getId());
        permissionQuery.eq(MaterialPermissionDO::getPermissionType, (Object)materialPermissionType);
        List permissionList = this.materialPermissionMapper.selectList((Wrapper)permissionQuery);
        Set oldUnitIdSet = permissionList.stream().map(MaterialPermissionDO::getUnitId).collect(Collectors.toSet());
        return oldUnitIdSet.size() != unitIdSet.size() || !oldUnitIdSet.containsAll(unitIdSet);
    }

    private void resetBySingleTypeAndPermissionType(int resourceId, int materialTypeId, int permissionType, int singleType, UnitGroup unitGroup) {
        this.removeAllByPermissionType(resourceId, permissionType);
        if (this.isFollowTypeEnable(singleType)) {
            this.processBySourceFollowTypePermissionTypes(resourceId, materialTypeId, Lists.newArrayList((Object[])new Integer[]{permissionType}));
        }
        if (this.isSingleEnable(singleType)) {
            this.processSingleSave(resourceId, materialTypeId, ContextUtil.getEnterpriseId(), unitGroup, permissionType);
        }
    }

    private void processBySourceFollowTypePermissionTypes(int resourceId, int materialTypeId, Collection<Integer> needProcessPermissionTypes) {
        List<MaterialTypePermissionDO> permissionList = this.materialTypePermissionService.getAllByPermissionTypes(materialTypeId, needProcessPermissionTypes);
        ArrayList list = Lists.newArrayList();
        for (MaterialTypePermissionDO permission : permissionList) {
            MaterialPermissionDO materialPermissionDO = ResourceSinglePermissionServiceImpl.buildPermissionByResource(resourceId, materialTypeId, permission.getEnterpriseId());
            materialPermissionDO.setUnitId(permission.getUnitId());
            materialPermissionDO.setPermissionType(permission.getPermissionType());
            materialPermissionDO.setPermissionSource(Integer.valueOf(1));
            list.add(materialPermissionDO);
        }
        this.batchInsertPermission(list);
    }

    private void filterPermissionTypesAndProcessBySourceFollowType(TrainingResource resource) {
        Integer downloadType;
        log.info("\u5904\u7406\u7d20\u6750\u6743\u9650 \u7d20\u6750id {} ", (Object)resource.getId());
        HashSet needProcessPermissionTypeSet = Sets.newHashSet((Object[])new Integer[]{2, 9});
        Integer readType = resource.getReadType();
        if (this.isFollowTypeEnable(readType)) {
            needProcessPermissionTypeSet.add(1);
        }
        if (this.isFollowTypeEnable(downloadType = resource.getDownloadType())) {
            needProcessPermissionTypeSet.add(4);
        }
        this.processBySourceFollowTypePermissionTypes(resource.getId(), resource.getTypeId(), needProcessPermissionTypeSet);
    }

    private static MaterialPermissionDO buildPermissionByResource(Integer resourceId, Integer materialTypeId, Integer enterpriseId) {
        MaterialPermissionDO materialPermissionDO = new MaterialPermissionDO();
        materialPermissionDO.setResourceId(resourceId);
        materialPermissionDO.setMaterialTypeId(materialTypeId);
        materialPermissionDO.setEnterpriseId(enterpriseId);
        return materialPermissionDO;
    }

    private void resetBySourceSingle(TrainingResource resource) {
        Integer downloadType;
        this.removeAllByPermissionSource(resource.getId(), 2);
        Integer readType = resource.getReadType();
        if (this.isSingleEnable(readType)) {
            this.processSingleSave(resource, resource.getReadSingleGroup(), 1);
        }
        if (this.isSingleEnable(downloadType = resource.getDownloadType())) {
            this.processSingleSave(resource, resource.getDownloadSingleGroup(), 4);
        }
    }

    private boolean isSingleEnable(Integer singleType) {
        return MaterialSingleTypeEnum.isSingleEnable((Integer)singleType);
    }

    private boolean isFollowTypeEnable(Integer singleType) {
        return MaterialSingleTypeEnum.isTypeEnable((Integer)singleType);
    }

    private void removeAllByPermissionSource(Integer resourceId, int permissionSource) {
        LambdaUpdateWrapper luw = new LambdaUpdateWrapper();
        luw.eq(MaterialPermissionDO::getResourceId, (Object)resourceId);
        luw.eq(MaterialPermissionDO::getPermissionSource, (Object)permissionSource);
        this.materialPermissionMapper.delete((Wrapper)luw);
    }

    private void removeAllByPermissionType(Integer materialId, int permissionType) {
        LambdaUpdateWrapper luw = new LambdaUpdateWrapper();
        luw.eq(MaterialPermissionDO::getResourceId, (Object)materialId);
        luw.eq(MaterialPermissionDO::getPermissionType, (Object)permissionType);
        this.materialPermissionMapper.delete((Wrapper)luw);
    }

    private void removeAll(Integer materialId) {
        LambdaUpdateWrapper luw = new LambdaUpdateWrapper();
        luw.eq(MaterialPermissionDO::getResourceId, (Object)materialId);
        this.materialPermissionMapper.delete((Wrapper)luw);
    }

    private void processSingleSave(TrainingResource materialVo, UnitGroup unitGroup, int permissionType) {
        this.processSingleSave(materialVo.getId(), materialVo.getTypeId(), materialVo.getEnterpriseId(), unitGroup, permissionType);
    }

    private void processSingleSave(Integer resourceId, Integer materialTypeId, Integer enterpriseId, UnitGroup unitGroup, int permissionType) {
        List<UnitDO> unitList = this.unitService.insertByUnitGroup(enterpriseId, unitGroup);
        ArrayList list = Lists.newArrayList();
        for (UnitDO unit : unitList) {
            MaterialPermissionDO materialPermissionDO = ResourceSinglePermissionServiceImpl.buildPermissionByResource(resourceId, materialTypeId, enterpriseId);
            materialPermissionDO.setUnitId(unit.getId());
            materialPermissionDO.setPermissionType(Integer.valueOf(permissionType));
            materialPermissionDO.setPermissionSource(Integer.valueOf(2));
            list.add(materialPermissionDO);
        }
        this.batchInsertPermission(list);
    }

    private void insertPermission(MaterialPermissionDO materialPermissionDO) {
        int insert = this.materialPermissionMapper.insert(materialPermissionDO);
    }

    private void batchInsertPermission(List<MaterialPermissionDO> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        int res = this.materialPermissionMapper.batchInsert(list);
    }
}

