/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.training.service.train;

import cn.hutool.core.map.MapUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.ovopark.organize.common.base.BaseResult;
import com.ovopark.organize.common.model.pojo.UsersOrgIdsAndTagsPojo;
import com.ovopark.organize.common.model.pojo.UsersPojo;
import com.ovopark.organize.sdk.api.UserOrganizeApi;
import com.ovopark.training.bo.JsonResult;
import com.ovopark.training.domain.UnitDO;
import com.ovopark.training.enhancer.subject.resp.Result;
import com.ovopark.training.enhancer.subject.resp.ResultUtils;
import com.ovopark.training.event.EventHelper;
import com.ovopark.training.mapper.TrainingAndMaterialMapper;
import com.ovopark.training.mapper.TrainingChapterAttachMapper;
import com.ovopark.training.mapper.TrainingChapterMapper;
import com.ovopark.training.mapper.TrainingLecturerLevelMapper;
import com.ovopark.training.mapper.TrainingLecturerMapper;
import com.ovopark.training.mapper.TrainingMapper;
import com.ovopark.training.mapper.TrainingMaterialAttachMapper;
import com.ovopark.training.mapper.TrainingMaterialCommentMapper;
import com.ovopark.training.mapper.TrainingMaterialLecturerMapper;
import com.ovopark.training.mapper.TrainingMaterialMapper;
import com.ovopark.training.mapper.TrainingPaperMapper;
import com.ovopark.training.mapper.TrainingUserLastViewMapper;
import com.ovopark.training.mapper.TrainingUserPaperMapper;
import com.ovopark.training.mapper.TrainingUserViewTimeTrainingMapper;
import com.ovopark.training.model.Training;
import com.ovopark.training.model.TrainingAndMaterial;
import com.ovopark.training.model.TrainingChapter;
import com.ovopark.training.model.TrainingChapterAttach;
import com.ovopark.training.model.TrainingLecturer;
import com.ovopark.training.model.TrainingLecturerLevel;
import com.ovopark.training.model.TrainingMaterial;
import com.ovopark.training.model.TrainingMaterialAttach;
import com.ovopark.training.model.TrainingMaterialComment;
import com.ovopark.training.model.TrainingMaterialLecturer;
import com.ovopark.training.model.TrainingPaper;
import com.ovopark.training.model.TrainingResource;
import com.ovopark.training.model.TrainingUserLastView;
import com.ovopark.training.model.TrainingUserPaper;
import com.ovopark.training.model.TrainingUserViewTime;
import com.ovopark.training.model.TrainingUserViewTimeTraining;
import com.ovopark.training.model.Users;
import com.ovopark.training.model.bo.ResourceUpdateBo;
import com.ovopark.training.model.bo.UserTrainingStatusBo;
import com.ovopark.training.model.view.ResourcesVo;
import com.ovopark.training.param.material.MaterialBatchUpdatePermissionParam;
import com.ovopark.training.param.train.TrainBatchUpdateShareableParam;
import com.ovopark.training.request.DeptStudyTrainingOverviewReq;
import com.ovopark.training.response.DeptFinishLessonOverviewResponse;
import com.ovopark.training.response.DeptLessonOverviewResponse;
import com.ovopark.training.service.CommonRemoteService;
import com.ovopark.training.service.IDimensionSummarizeService;
import com.ovopark.training.service.TrainingCommonService;
import com.ovopark.training.service.UserUtilService;
import com.ovopark.training.service.material.MaterialService;
import com.ovopark.training.service.materialtype.MaterialTypeService;
import com.ovopark.training.service.permission.material.MaterialPermissionFacade;
import com.ovopark.training.service.resource.ResourceService;
import com.ovopark.training.service.resource.ResourceSinglePermissionService;
import com.ovopark.training.service.train.TrainService;
import com.ovopark.training.util.DateUtils;
import com.ovopark.training.vo.TrainingChapterAttachVo;
import com.ovopark.training.vo.TrainingChapterVo;
import com.ovopark.training.vo.TrainingLecturerVo;
import com.ovopark.training.vo.TrainingMaterialVo;
import com.ovopark.training.vo.TrainingPapersVo;
import com.ovopark.training.vo.TrainingUserViewTimeVo;
import com.ovopark.training.vo.TrainingsVo;
import com.ovopark.training.vo.unit.UnitShowVo;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
public class TrainServiceImpl
implements TrainService {
    private static final Logger log = LoggerFactory.getLogger(TrainServiceImpl.class);
    @Autowired
    private UserOrganizeApi userOrganizeApi;
    @Autowired
    private TrainingMapper trainingMapper;
    @Autowired
    private TrainingChapterMapper trainingChapterMapper;
    @Autowired
    private TrainingChapterAttachMapper trainingChapterAttachMapper;
    @Autowired
    private TrainingAndMaterialMapper trainingAndMaterialMapper;
    @Autowired
    private TrainingMaterialMapper trainingMaterialMapper;
    @Autowired
    private TrainingMaterialAttachMapper trainingMaterialAttachMapper;
    @Autowired
    private TrainingMaterialLecturerMapper trainingMaterialLecturerMapper;
    @Autowired
    private TrainingPaperMapper trainingPaperMapper;
    @Autowired
    private TrainingUserPaperMapper trainingUserPaperMapper;
    @Autowired
    private TrainingLecturerMapper trainingLecturerMapper;
    @Autowired
    private TrainingLecturerLevelMapper trainingLecturerLevelMapper;
    @Autowired
    private ResourceService resourceService;
    @Autowired
    private UserUtilService userUtilService;
    @Autowired
    private TrainingCommonService trainingCommonService;
    @Autowired
    private ResourceSinglePermissionService resourceSinglePermissionService;
    @Autowired
    private TrainingMaterialCommentMapper trainingMaterialCommentMapper;
    @Autowired
    private TrainingUserLastViewMapper trainingUserLastViewMapper;
    @Autowired
    private MaterialTypeService materialTypeService;
    @Autowired
    private MaterialPermissionFacade materialPermissionFacade;
    @Autowired
    private MaterialService materialService;
    @Autowired
    private CommonRemoteService commonRemoteService;
    @Resource
    private TrainingUserViewTimeTrainingMapper trainingUserViewTimeTrainingMapper;
    @Resource
    private IDimensionSummarizeService dimensionSummarizeService;

    @Override
    public void addTrainingTrain(TrainingsVo trainingsVo, Users user) {
        if (ObjectUtils.isEmpty((Object)trainingsVo) || CollectionUtils.isEmpty((Collection)trainingsVo.getChapterVos())) {
            return;
        }
        Date now = new Date();
        Training training = new Training();
        BeanUtils.copyProperties((Object)trainingsVo, (Object)training);
        training.setCreator(user.getId());
        training.setStartTime(now);
        training.setUpdateTime(now);
        training.setUpdater(user.getId());
        training.setViewCount(Integer.valueOf(0));
        if (training.getStatus().equals(0)) {
            trainingsVo.setIsUsing(Integer.valueOf(0));
            training.setIsUsing(Integer.valueOf(0));
        }
        training.setEnterpriseId(user.getGroupId());
        training.setProjectShow(Integer.valueOf(5));
        this.trainingMapper.insert(training);
        TrainingResource trainingResource = new TrainingResource();
        trainingResource.setObjectId(training.getId());
        this.saveResourceContent(trainingResource, trainingsVo);
        this.resourceService.addResource(trainingResource, user);
        this.saveInsertContent(trainingsVo, user, now, training);
        this.saveInsertAttachAndLecturer(trainingsVo, user, training, now);
    }

    private void saveResourceContent(TrainingResource trainingResource, TrainingsVo training) {
        trainingResource.setShowName(training.getTitle());
        trainingResource.setFileType(Integer.valueOf(8));
        trainingResource.setTypeId(training.getTrainingType());
        trainingResource.setIsUsing(training.getIsUsing());
        trainingResource.setCoverType(training.getCoverType());
        trainingResource.setCoverUrl(training.getPath());
        trainingResource.setIsShow(training.getIsShow());
        trainingResource.setReadType(training.getReadType());
        trainingResource.setShareable(training.getIsShare());
        trainingResource.setIsVisitorShare(training.getIsVisitorShare());
        trainingResource.setIsComment(training.getIsComment());
        trainingResource.setIsDownload(Integer.valueOf(1));
        trainingResource.setVersion(training.getVersion());
        trainingResource.setIntroduction(training.getDescription());
        trainingResource.setReadSingleGroup(training.getReadSingleGroup());
    }

    private void saveInsertAttachAndLecturer(TrainingsVo trainingsVo, Users user, Training training, Date now) {
        List lecturerVoList;
        List attachList = trainingsVo.getTrainingMaterialAttachList();
        if (!CollectionUtils.isEmpty((Collection)attachList)) {
            for (TrainingMaterialAttach attach : attachList) {
                attach.setType(Integer.valueOf(2));
                attach.setMaterialId(training.getId());
                attach.setEnterpriseId(user.getGroupId());
                attach.setCreateTime(now);
                this.trainingMaterialAttachMapper.insert(attach);
            }
        }
        if (!CollectionUtils.isEmpty((Collection)(lecturerVoList = trainingsVo.getLecturerVoList()))) {
            ArrayList materialLecturerList = Lists.newArrayList();
            for (TrainingLecturerVo lecturerVo : lecturerVoList) {
                TrainingMaterialLecturer materialLecturer = new TrainingMaterialLecturer();
                materialLecturer.setType(Integer.valueOf(2));
                materialLecturer.setMaterialId(training.getId());
                materialLecturer.setLecturerId(lecturerVo.getId());
                materialLecturer.setEnterpriseId(user.getGroupId());
                materialLecturer.setCreaterId(user.getId());
                materialLecturer.setCreateTime(new Date());
                materialLecturerList.add(materialLecturer);
            }
            this.trainingMaterialLecturerMapper.insertList(materialLecturerList);
        }
    }

    private void saveInsertContent(TrainingsVo trainingsVo, Users user, Date now, Training training) {
        ArrayList<TrainingChapterAttach> chapterAttachList = new ArrayList<TrainingChapterAttach>();
        ArrayList<TrainingAndMaterial> andMaterialList = new ArrayList<TrainingAndMaterial>();
        for (TrainingChapterVo trainingChapterVo : trainingsVo.getChapterVos()) {
            TrainingChapter trainingChapter = this.saveTrainingChapter(now, training, trainingChapterVo);
            this.saveInsertContentAttach(user, training, trainingChapterVo, trainingChapter, chapterAttachList, andMaterialList);
        }
        if (!CollectionUtils.isEmpty(chapterAttachList)) {
            this.trainingChapterAttachMapper.insertList(chapterAttachList);
        }
        if (!CollectionUtils.isEmpty(andMaterialList)) {
            this.trainingAndMaterialMapper.insertList(andMaterialList);
        }
    }

    private TrainingChapter saveTrainingChapter(Date now, Training training, TrainingChapterVo trainingChapterVo) {
        TrainingChapter trainingChapter = new TrainingChapter();
        trainingChapter.setChapterSort(trainingChapterVo.getChapterSort());
        trainingChapter.setCreateTime(now);
        trainingChapter.setName(trainingChapterVo.getName());
        trainingChapter.setTrainingId(training.getId());
        trainingChapter.setIsLock(Integer.valueOf(trainingChapterVo.getIsLock() == null ? 0 : trainingChapterVo.getIsLock()));
        if (!StringUtils.isEmpty((Object)training.getIsLock()) && training.getIsLock() == 1) {
            trainingChapter.setIsTop(Integer.valueOf(0));
        } else {
            trainingChapter.setIsTop(Integer.valueOf(StringUtils.isEmpty((Object)trainingChapterVo.getIsTop()) ? 0 : trainingChapterVo.getIsTop()));
        }
        this.trainingChapterMapper.insert(trainingChapter);
        return trainingChapter;
    }

    private void saveInsertContentAttach(Users user, Training training, TrainingChapterVo trainingChapterVo, TrainingChapter trainingChapter, List<TrainingChapterAttach> chapterAttachList, List<TrainingAndMaterial> andMaterialList) {
        if (CollectionUtils.isEmpty((Collection)trainingChapterVo.getAttachVoList())) {
            return;
        }
        for (TrainingChapterAttachVo attachVo : trainingChapterVo.getAttachVoList()) {
            TrainingPaper trainingPaper;
            TrainingChapterAttach trainingChapterAttach = new TrainingChapterAttach();
            trainingChapterAttach.setAttachSort(attachVo.getAttachSort());
            trainingChapterAttach.setCreateTime(new Date());
            trainingChapterAttach.setEnterpriseId(user.getGroupId());
            trainingChapterAttach.setTrainingId(training.getId());
            if (!StringUtils.isEmpty((Object)attachVo.getMaterialId())) {
                TrainingMaterial trainingMaterial = (TrainingMaterial)this.trainingMaterialMapper.selectById(attachVo.getMaterialId());
                trainingChapterAttach.setMaterialId(attachVo.getMaterialId());
                trainingChapterAttach.setChapterId(trainingChapter.getId());
                trainingChapterAttach.setUrl(trainingMaterial.getMaterialPath());
                trainingChapterAttach.setFileName(trainingMaterial.getMaterialName());
                chapterAttachList.add(trainingChapterAttach);
            } else if (!StringUtils.isEmpty((Object)attachVo.getPaperId()) && !StringUtils.isEmpty((Object)(trainingPaper = (TrainingPaper)this.trainingPaperMapper.selectById(attachVo.getPaperId())))) {
                trainingChapterAttach.setPaperId(attachVo.getPaperId());
                trainingChapterAttach.setChapterId(trainingChapter.getId());
                trainingChapterAttach.setFileName(trainingPaper.getTitle());
                chapterAttachList.add(trainingChapterAttach);
            }
            if (StringUtils.isEmpty((Object)attachVo.getMaterialId())) continue;
            TrainingAndMaterial andMaterial = new TrainingAndMaterial();
            andMaterial.setMaterialId(attachVo.getMaterialId());
            andMaterial.setTrainingId(training.getId());
            andMaterial.setChapterId(trainingChapter.getId());
            andMaterial.setCreateTime(new Date());
            andMaterial.setCreater(user.getId());
            andMaterialList.add(andMaterial);
        }
    }

    @Override
    public void updateTrainingTrain(TrainingsVo trainingsVo, Users user) {
        if (ObjectUtils.isEmpty((Object)trainingsVo)) {
            return;
        }
        Date now = new Date();
        Training training = new Training();
        BeanUtils.copyProperties((Object)trainingsVo, (Object)training);
        if (trainingsVo.getStatus() != null && !trainingsVo.getStatus().equals(0)) {
            trainingsVo.setIsUsing(Integer.valueOf(1));
            training.setIsUsing(Integer.valueOf(1));
        }
        training.setUpdateTime(now);
        training.setUpdater(user.getId());
        training.setEnterpriseId(user.getGroupId());
        training.setVersion(Integer.valueOf(training.getVersion() == null ? 2 : training.getVersion() + 1));
        trainingsVo.setVersion(training.getVersion());
        training.setProjectShow(Integer.valueOf(5));
        this.trainingMapper.updateById(training);
        TrainingResource resource = this.resourceService.getResource(training.getId(), 8);
        TrainingResource trainingResource = new TrainingResource();
        Integer preTypeId = resource.getTypeId();
        trainingResource.setId(resource.getId());
        this.saveResourceContent(trainingResource, trainingsVo);
        this.resourceService.updateResource(trainingResource, user);
        this.saveUpdateContent(trainingsVo, user, now, training);
        this.saveUpdateAttachAndLecturer(trainingsVo, user, training, now);
        EventHelper.sendMaterialTypeStatCountEvent(this, preTypeId, trainingsVo.getTrainingType());
    }

    private void saveUpdateAttachAndLecturer(TrainingsVo trainingsVo, Users user, Training training, Date now) {
        LambdaUpdateWrapper wrapper1 = new LambdaUpdateWrapper();
        ((LambdaUpdateWrapper)((LambdaUpdateWrapper)wrapper1.eq(TrainingMaterialAttach::getMaterialId, (Object)training.getId())).eq(TrainingMaterialAttach::getType, (Object)2)).set(TrainingMaterialAttach::getIsDel, (Object)1);
        this.trainingMaterialAttachMapper.update(null, (Wrapper)wrapper1);
        LambdaUpdateWrapper wrapper2 = new LambdaUpdateWrapper();
        ((LambdaUpdateWrapper)wrapper2.eq(TrainingMaterialLecturer::getMaterialId, (Object)training.getId())).eq(TrainingMaterialLecturer::getType, (Object)2);
        this.trainingMaterialLecturerMapper.delete((Wrapper)wrapper2);
        this.saveInsertAttachAndLecturer(trainingsVo, user, training, now);
    }

    private void saveUpdateContent(TrainingsVo trainingsVo, Users user, Date now, Training training) {
        LambdaUpdateWrapper wrapper1 = new LambdaUpdateWrapper();
        ((LambdaUpdateWrapper)wrapper1.eq(TrainingChapter::getTrainingId, (Object)training.getId())).set(TrainingChapter::getIsDel, (Object)1);
        this.trainingChapterMapper.update(null, (Wrapper)wrapper1);
        LambdaUpdateWrapper wrapper2 = new LambdaUpdateWrapper();
        ((LambdaUpdateWrapper)wrapper2.eq(TrainingChapterAttach::getTrainingId, (Object)training.getId())).set(TrainingChapterAttach::getIsDel, (Object)1);
        this.trainingChapterAttachMapper.update(null, (Wrapper)wrapper2);
        LambdaUpdateWrapper wrapper3 = new LambdaUpdateWrapper();
        wrapper3.eq(TrainingAndMaterial::getTrainingId, (Object)training.getId());
        this.trainingAndMaterialMapper.delete((Wrapper)wrapper3);
        this.saveInsertContent(trainingsVo, user, now, training);
    }

    @Override
    public TrainingsVo getTrainingTrainDetail(TrainingsVo trainingsVo, Users user) {
        Training training = (Training)this.trainingMapper.selectById(trainingsVo.getId());
        if (ObjectUtils.isEmpty((Object)training)) {
            return trainingsVo;
        }
        BeanUtils.copyProperties((Object)training, (Object)trainingsVo);
        trainingsVo.setTypes(Integer.valueOf(2));
        if (trainingsVo.getTrainingType() != null) {
            trainingsVo.setTrainingTypeName(this.materialTypeService.getWholePathById(trainingsVo.getTrainingType()));
        }
        this.getTrainingsVo(trainingsVo);
        this.getTrainingAttachAndLecturer(trainingsVo);
        TrainingResource resource = this.resourceService.getByTrainId(trainingsVo.getId());
        trainingsVo.setIsUsing(resource.getIsUsing());
        trainingsVo.setVersion(resource.getVersion());
        List<UnitShowVo> readShow = this.resourceSinglePermissionService.getSingleUnitShowListByMaterial(resource.getId(), 1);
        trainingsVo.setReadSingleUnitShowList(readShow);
        return trainingsVo;
    }

    private void getTrainingsVo(TrainingsVo trainingsVo) {
        LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper1.eq(TrainingChapter::getTrainingId, (Object)trainingsVo.getId())).eq(TrainingChapter::getIsDel, (Object)0)).orderByAsc(TrainingChapter::getChapterSort);
        List trainingChapterList = this.trainingChapterMapper.selectList((Wrapper)wrapper1);
        LambdaQueryWrapper wrapper2 = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper2.eq(TrainingChapterAttach::getTrainingId, (Object)trainingsVo.getId())).eq(TrainingChapterAttach::getIsDel, (Object)0)).orderByAsc(TrainingChapterAttach::getAttachSort);
        List trainingChapterAttachList = this.trainingChapterAttachMapper.selectList((Wrapper)wrapper2);
        Map<Integer, List<TrainingChapterAttach>> trainingChapterAttachMap = trainingChapterAttachList.stream().collect(Collectors.groupingBy(TrainingChapterAttach::getChapterId));
        List materialIds = trainingChapterAttachList.stream().map(TrainingChapterAttach::getMaterialId).filter(Objects::nonNull).collect(Collectors.toList());
        Map<Object, Object> trainingMaterialMap = Maps.newHashMap();
        Integer finishTime = 0;
        if (!CollectionUtils.isEmpty(materialIds)) {
            LambdaQueryWrapper wrapper3 = new LambdaQueryWrapper();
            wrapper3.in(TrainingMaterial::getId, materialIds);
            List trainingMaterialList = this.trainingMaterialMapper.selectList((Wrapper)wrapper3);
            if (!CollectionUtils.isEmpty((Collection)trainingMaterialList)) {
                finishTime = trainingMaterialList.stream().mapToInt(this::getMaterialTime).sum();
                trainingMaterialMap = trainingMaterialList.stream().collect(Collectors.toMap(TrainingMaterial::getId, Function.identity()));
            }
        }
        trainingsVo.setTotalTime(finishTime);
        ArrayList trainingChapterVoList = Lists.newArrayList();
        if (!CollectionUtils.isEmpty((Collection)trainingChapterList)) {
            for (TrainingChapter trainingChapter : trainingChapterList) {
                TrainingChapterVo trainingChapterVo = new TrainingChapterVo();
                BeanUtils.copyProperties((Object)trainingChapter, (Object)trainingChapterVo);
                List<TrainingChapterAttach> trainingChapterAttaches = trainingChapterAttachMap.get(trainingChapter.getId());
                ArrayList trainingChapterAttachVoList = Lists.newArrayList();
                if (!CollectionUtils.isEmpty(trainingChapterAttaches)) {
                    for (TrainingChapterAttach trainingChapterAttach : trainingChapterAttaches) {
                        TrainingMaterial trainingMaterial;
                        TrainingChapterAttachVo trainingChapterAttachVo = new TrainingChapterAttachVo();
                        BeanUtils.copyProperties((Object)trainingChapterAttach, (Object)trainingChapterAttachVo);
                        if (trainingChapterAttach.getMaterialId() != null && !ObjectUtils.isEmpty((Object)(trainingMaterial = (TrainingMaterial)trainingMaterialMap.get(trainingChapterAttach.getMaterialId())))) {
                            trainingChapterAttachVo.setFileType(trainingMaterial.getFileType());
                            trainingChapterAttachVo.setFinishTime(this.getMaterialTime(trainingMaterial));
                        }
                        trainingChapterAttachVoList.add(trainingChapterAttachVo);
                    }
                }
                trainingChapterVo.setChapterAttachs((List)trainingChapterAttachVoList);
                trainingChapterVoList.add(trainingChapterVo);
            }
        }
        trainingsVo.setChapterVos((List)trainingChapterVoList);
    }

    private Integer getMaterialTime(TrainingMaterial trainingMaterial) {
        Integer finishTime = 0;
        finishTime = trainingMaterial.getFileType() == 3 || trainingMaterial.getFileType() == 4 ? Integer.valueOf(trainingMaterial.getDuration() != null ? trainingMaterial.getDuration() : 0) : Integer.valueOf(trainingMaterial.getFinishTime() != null ? trainingMaterial.getFinishTime() : 0);
        return finishTime;
    }

    private void getTrainingAttachAndLecturer(TrainingsVo trainingsVo) {
        LambdaQueryWrapper wrapper3 = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper3.eq(TrainingMaterialAttach::getMaterialId, (Object)trainingsVo.getId())).eq(TrainingMaterialAttach::getType, (Object)trainingsVo.getTypes())).eq(TrainingMaterialAttach::getIsDel, (Object)0)).orderByAsc(TrainingMaterialAttach::getId);
        List trainingMaterialAttachList = this.trainingMaterialAttachMapper.selectList((Wrapper)wrapper3);
        trainingsVo.setTrainingMaterialAttachList(trainingMaterialAttachList);
        LambdaQueryWrapper wrapper4 = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper4.eq(TrainingMaterialLecturer::getMaterialId, (Object)trainingsVo.getId())).eq(TrainingMaterialLecturer::getType, (Object)trainingsVo.getTypes())).orderByAsc(TrainingMaterialLecturer::getId);
        List trainingMaterialLecturerList = this.trainingMaterialLecturerMapper.selectList((Wrapper)wrapper4);
        if (CollectionUtils.isEmpty((Collection)trainingMaterialLecturerList)) {
            return;
        }
        List lecturerIds = trainingMaterialLecturerList.stream().map(TrainingMaterialLecturer::getLecturerId).distinct().collect(Collectors.toList());
        List trainingLecturerList = this.trainingLecturerMapper.selectBatchIds(lecturerIds);
        if (CollectionUtils.isEmpty((Collection)trainingLecturerList)) {
            return;
        }
        ArrayList trainingLecturerVoList = Lists.newArrayList();
        List levelIdList = trainingLecturerList.stream().map(TrainingLecturer::getLevelId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        List trainingLecturerLevelList = this.trainingLecturerLevelMapper.selectBatchIds(levelIdList);
        Map lecturerLevelMap = trainingLecturerLevelList.stream().collect(Collectors.toMap(TrainingLecturerLevel::getId, Function.identity()));
        for (TrainingLecturer trainingLecturer : trainingLecturerList) {
            TrainingLecturerVo trainingLecturerVo = new TrainingLecturerVo();
            BeanUtils.copyProperties((Object)trainingLecturer, (Object)trainingLecturerVo);
            TrainingLecturerLevel trainingLecturerLevel = (TrainingLecturerLevel)lecturerLevelMap.get(trainingLecturerVo.getLevelId());
            if (!ObjectUtils.isEmpty((Object)trainingLecturerLevel)) {
                trainingLecturerVo.setLevelName(trainingLecturerLevel.getLevelName());
            }
            trainingLecturerVoList.add(trainingLecturerVo);
        }
        trainingsVo.setLecturerVoList((List)trainingLecturerVoList);
    }

    @Override
    public TrainingsVo getTrainContent(TrainingsVo trainingsVo, Users user) {
        UsersPojo usersPojo;
        Integer type = trainingsVo.getTypes();
        if (type == null) {
            return trainingsVo;
        }
        List<Object> materialIds = Lists.newArrayList();
        if (type == 1) {
            TrainingMaterial trainingMaterial = (TrainingMaterial)this.trainingMaterialMapper.selectById(trainingsVo.getId());
            if (ObjectUtils.isEmpty((Object)trainingMaterial)) {
                return trainingsVo;
            }
            trainingMaterial.setIsDownload(this.materialPermissionFacade.getIsDownload(trainingMaterial, user));
            this.CopyMaterialValues(trainingsVo, trainingMaterial, user);
        } else if (type == 2) {
            Training training = (Training)this.trainingMapper.selectById(trainingsVo.getId());
            if (ObjectUtils.isEmpty((Object)training)) {
                return trainingsVo;
            }
            BeanUtils.copyProperties((Object)training, (Object)trainingsVo);
            materialIds = this.getTrainingAttachStatusVo(trainingsVo, user);
        }
        if (trainingsVo.getCreator() != null && !ObjectUtils.isEmpty((Object)(usersPojo = this.userUtilService.selectUser(trainingsVo.getCreator())))) {
            trainingsVo.setCreatName(usersPojo.getShowName());
            trainingsVo.setCreatUrl(usersPojo.getThumbUrl());
        }
        this.getTrainingAttachAndLecturer(trainingsVo);
        if (type == 2 && !CollectionUtils.isEmpty((Collection)materialIds)) {
            LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.in(TrainingMaterialAttach::getMaterialId, (Collection)materialIds)).eq(TrainingMaterialAttach::getType, (Object)1)).eq(TrainingMaterialAttach::getIsDel, (Object)0)).orderByAsc(TrainingMaterialAttach::getId);
            List trainingMaterialAttachList = this.trainingMaterialAttachMapper.selectList((Wrapper)wrapper);
            if (!CollectionUtils.isEmpty((Collection)trainingMaterialAttachList)) {
                if (!CollectionUtils.isEmpty((Collection)trainingsVo.getTrainingMaterialAttachList())) {
                    trainingsVo.getTrainingMaterialAttachList().addAll(trainingMaterialAttachList);
                } else {
                    trainingsVo.setTrainingMaterialAttachList(trainingMaterialAttachList);
                }
            }
        }
        this.getTrainingComment(trainingsVo, user);
        return trainingsVo;
    }

    @Override
    public Result<Void> batchUpdatePermission(MaterialBatchUpdatePermissionParam param, Users user) {
        ResourceUpdateBo resourceUpdateBo = new ResourceUpdateBo();
        List trainIdList = param.getTrainIdList();
        Integer singleType = param.getSingleType();
        Integer permissionType = param.getPermissionType();
        if (permissionType != 1) {
            return ResultUtils.fail();
        }
        this.trainingMapper.batchUpdateReadType(trainIdList, singleType, user.getId());
        resourceUpdateBo.setReadType(singleType);
        resourceUpdateBo.setType(2);
        ResourcesVo resourcesVo = new ResourcesVo();
        resourcesVo.setObjectIdList(trainIdList);
        resourcesVo.setResourceUpdateBo(resourceUpdateBo);
        this.resourceService.saveBatchResourceInPermission(resourcesVo, user);
        this.resourceSinglePermissionService.batchUpdate(param);
        return ResultUtils.success();
    }

    @Override
    public Result<Void> batchUpdateShareable(TrainBatchUpdateShareableParam param, Users user) {
        List<Integer> resourceIdList = this.resourceService.getIdListByTrainIdList(param.getTrainIdList());
        this.trainingMapper.batchUpdateShareable(param.getTrainIdList(), param.getShareable(), user.getId());
        return this.resourceService.batchUpdateShareable(resourceIdList, param.getShareable(), user);
    }

    private void getTrainingComment(TrainingsVo trainingsVo, Users user) {
        LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper1.eq(TrainingMaterialComment::getMaterialId, (Object)trainingsVo.getId())).eq(TrainingMaterialComment::getType, (Object)trainingsVo.getTypes())).eq(TrainingMaterialComment::getUserId, (Object)user.getId())).orderByAsc(TrainingMaterialComment::getId)).last(" limit 1 ");
        TrainingMaterialComment trainingMaterialComment = (TrainingMaterialComment)this.trainingMaterialCommentMapper.selectOne((Wrapper)wrapper1);
        if (ObjectUtils.isEmpty((Object)trainingMaterialComment)) {
            return;
        }
        trainingsVo.setIsLike(trainingMaterialComment.getIsLike());
        trainingsVo.setIsCollect(trainingMaterialComment.getIsCollect());
        trainingsVo.setStars(new BigDecimal(trainingMaterialComment.getStars()));
    }

    private void CopyMaterialValues(TrainingsVo trainingsVo, TrainingMaterial trainingMaterial, Users user) {
        List<TrainingUserViewTimeVo> viewList;
        trainingsVo.setCreator(trainingMaterial.getCreater());
        Integer finishTime = this.getMaterialFinishTime(trainingMaterial);
        trainingsVo.setTotalTime(finishTime);
        trainingsVo.setPath(trainingMaterial.getCoverUrl());
        trainingsVo.setCoverType(trainingMaterial.getCoverType());
        trainingsVo.setDescription(trainingMaterial.getIntroduction());
        trainingsVo.setTitle(trainingMaterial.getMaterialName());
        trainingsVo.setScore(trainingMaterial.getScore());
        trainingsVo.setIsShare(trainingMaterial.getShareable());
        trainingsVo.setIsComment(trainingMaterial.getIsComment());
        BigDecimal rate = BigDecimal.ZERO;
        Integer readTimes = 0;
        Integer totalStatus = 1;
        if (trainingsVo.getIsProgress() != null && trainingsVo.getIsProgress() == 1) {
            trainingsVo.setLearnType(Integer.valueOf(0));
        }
        if (!CollectionUtils.isEmpty(viewList = this.trainingCommonService.selectViewTimeByMaterial(trainingsVo.getLearnType(), user.getId(), Collections.singletonList(trainingMaterial.getId()), null, trainingsVo.getTaskId(), null))) {
            TrainingUserViewTimeVo trainingUserViewTimeVo = viewList.get(0);
            readTimes = trainingUserViewTimeVo.getViewTimes();
            if (finishTime.compareTo(readTimes) <= 0) {
                rate = BigDecimal.ONE;
                totalStatus = 3;
            } else {
                rate = new BigDecimal(readTimes).divide(new BigDecimal(finishTime), 2, 1);
                totalStatus = 2;
            }
        }
        trainingsVo.setReadRate(rate);
        trainingsVo.setTotalStatus(totalStatus);
        TrainingChapterVo trainingChapterVo = new TrainingChapterVo();
        TrainingChapterAttachVo trainingChapterAttachVo = new TrainingChapterAttachVo();
        TrainingMaterialVo trainingMaterialVo = new TrainingMaterialVo();
        BeanUtils.copyProperties((Object)trainingMaterial, (Object)trainingMaterialVo);
        trainingMaterialVo.setFinishTime(finishTime);
        trainingChapterAttachVo.setMaterialVo(trainingMaterialVo);
        trainingChapterAttachVo.setReadTimes(readTimes);
        trainingChapterAttachVo.setAttachType(Integer.valueOf(1));
        trainingChapterAttachVo.setIsLock(Integer.valueOf(0));
        trainingChapterAttachVo.setMaterialId(trainingMaterialVo.getId());
        trainingChapterAttachVo.setUrl(trainingMaterialVo.getMaterialPath());
        trainingChapterVo.setChapterAttachs(Collections.singletonList(trainingChapterAttachVo));
        trainingsVo.setChapterVos(Collections.singletonList(trainingChapterVo));
    }

    private List<Integer> getTrainingAttachStatusVo(TrainingsVo trainingsVo, Users user) {
        List paperIds;
        List<Object> materialIds = Lists.newArrayList();
        Map<Object, Object> trainingMaterialMap = Maps.newHashMap();
        Map<Object, Object> trainingViewMap = Maps.newHashMap();
        Map<Object, Object> trainingPaperMap = Maps.newHashMap();
        Map<Object, Object> trainingUserPaperMap = Maps.newHashMap();
        LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper1.eq(TrainingChapter::getTrainingId, (Object)trainingsVo.getId())).eq(TrainingChapter::getIsDel, (Object)0)).orderByAsc(TrainingChapter::getChapterSort);
        List trainingChapterList = this.trainingChapterMapper.selectList((Wrapper)wrapper1);
        if (CollectionUtils.isEmpty((Collection)trainingChapterList)) {
            return materialIds;
        }
        LambdaQueryWrapper wrapper2 = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper2.eq(TrainingChapterAttach::getTrainingId, (Object)trainingsVo.getId())).eq(TrainingChapterAttach::getIsDel, (Object)0)).orderByAsc(TrainingChapterAttach::getAttachSort);
        List trainingChapterAttachList = this.trainingChapterAttachMapper.selectList((Wrapper)wrapper2);
        if (CollectionUtils.isEmpty((Collection)trainingChapterAttachList)) {
            return materialIds;
        }
        Map<Integer, List<TrainingChapterAttach>> trainingChapterAttachMap = trainingChapterAttachList.stream().collect(Collectors.groupingBy(TrainingChapterAttach::getChapterId));
        trainingsVo.setChapterNum(Integer.valueOf(trainingChapterAttachList.size()));
        Integer learnType = trainingsVo.getLearnType();
        if (trainingsVo.getIsProgress() != null && trainingsVo.getIsProgress() == 1) {
            trainingsVo.setLearnType(Integer.valueOf(0));
        }
        if (!CollectionUtils.isEmpty((Collection)(materialIds = trainingChapterAttachList.stream().map(TrainingChapterAttach::getMaterialId).filter(Objects::nonNull).collect(Collectors.toList())))) {
            List trainingMaterialList = this.trainingMaterialMapper.selectBatchIds(materialIds);
            Map<Integer, Integer> materialIdResourceIdMap = this.resourceService.getMaterialIdResourceIdMap(materialIds);
            ArrayList resourceIds = Lists.newArrayList(materialIdResourceIdMap.values());
            Set<Integer> validResourceIdSet = this.materialPermissionFacade.getValidResourceIdSet(user, 4, resourceIds);
            trainingMaterialMap = trainingMaterialList.stream().peek(v -> {
                Integer resourceId = (Integer)materialIdResourceIdMap.get(v.getId());
                v.setIsDownload(Integer.valueOf(validResourceIdSet.contains(resourceId) ? 1 : 0));
            }).collect(Collectors.toMap(TrainingMaterial::getId, Function.identity()));
            List<TrainingUserViewTimeVo> viewList = this.trainingCommonService.selectViewTimeByMaterial(trainingsVo.getLearnType(), user.getId(), materialIds, null, trainingsVo.getTaskId(), trainingsVo.getTurns());
            if (!CollectionUtils.isEmpty(viewList)) {
                trainingViewMap = viewList.stream().collect(Collectors.groupingBy(TrainingUserViewTime::getMaterialId));
            }
        }
        if (!CollectionUtils.isEmpty(paperIds = trainingChapterAttachList.stream().map(TrainingChapterAttach::getPaperId).filter(Objects::nonNull).collect(Collectors.toList()))) {
            List trainingPaperList = this.trainingPaperMapper.selectBatchIds(paperIds);
            trainingPaperMap = trainingPaperList.stream().collect(Collectors.toMap(TrainingPaper::getId, Function.identity()));
            LambdaQueryWrapper wrapper4 = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper4.eq(TrainingUserPaper::getUserId, (Object)user.getId())).in(TrainingUserPaper::getTrainingPaperId, paperIds)).eq(TrainingUserPaper::getSourceType, (Object)this.getSourceTypeByLearnType(learnType));
            if (learnType != null && learnType == 1) {
                wrapper4.eq(TrainingUserPaper::getSourceProjectId, (Object)trainingsVo.getId());
            }
            ((LambdaQueryWrapper)wrapper4.eq(trainingsVo.getTaskId() != null, TrainingUserPaper::getSourceTaskId, (Object)trainingsVo.getTaskId())).isNotNull(TrainingUserPaper::getSubmitTime);
            List trainingUserPaperList = this.trainingUserPaperMapper.selectList((Wrapper)wrapper4);
            if (!CollectionUtils.isEmpty((Collection)trainingUserPaperList)) {
                trainingUserPaperMap = trainingUserPaperList.stream().collect(Collectors.groupingBy(TrainingUserPaper::getTrainingPaperId));
            }
        }
        this.getTrainingChapterAttachData(trainingsVo, user, trainingChapterList, trainingChapterAttachMap, trainingMaterialMap, trainingViewMap, trainingPaperMap, trainingUserPaperMap, trainingChapterAttachList);
        return materialIds;
    }

    private Integer getSourceTypeByLearnType(Integer learnType) {
        if (learnType == 1) {
            return 1;
        }
        if (learnType == 2) {
            return 3;
        }
        if (learnType == 3) {
            return 4;
        }
        if (learnType == 4) {
            return 5;
        }
        return 1;
    }

    private void getTrainingChapterAttachData(TrainingsVo trainingsVo, Users user, List<TrainingChapter> trainingChapterList, Map<Integer, List<TrainingChapterAttach>> trainingChapterAttachMap, Map<Integer, TrainingMaterial> trainingMaterialMap, Map<Integer, List<TrainingUserViewTimeVo>> trainingViewMap, Map<Integer, TrainingPaper> trainingPaperMap, Map<Integer, List<TrainingUserPaper>> trainingUserPaperMap, List<TrainingChapterAttach> trainingChapterAttachList) {
        Integer taskId = this.getLastAttachId(trainingsVo, user);
        Integer totalTime = 0;
        Integer totalStatus = 1;
        Integer finishCount = 0;
        Integer first = 1;
        Integer isLastLock = 0;
        Integer isChapterLock = trainingsVo.getIsLock() == null ? 0 : trainingsVo.getIsLock();
        ArrayList trainingChapterVoList = Lists.newArrayList();
        for (TrainingChapter trainingChapter : trainingChapterList) {
            TrainingChapterVo trainingChapterVo = new TrainingChapterVo();
            BeanUtils.copyProperties((Object)trainingChapter, (Object)trainingChapterVo);
            Integer isChapterAttachLock = isChapterLock;
            List<TrainingChapterAttach> trainingChapterAttaches = trainingChapterAttachMap.get(trainingChapter.getId());
            if (CollectionUtils.isEmpty(trainingChapterAttaches)) continue;
            ArrayList trainingChapterAttachVoList = Lists.newArrayList();
            Integer isFinishView = 1;
            for (TrainingChapterAttach trainingChapterAttach : trainingChapterAttaches) {
                TrainingChapterAttachVo trainingChapterAttachVo = new TrainingChapterAttachVo();
                BeanUtils.copyProperties((Object)trainingChapterAttach, (Object)trainingChapterAttachVo);
                Integer isLock = isLastLock;
                if (taskId != null && taskId.compareTo(trainingChapterAttach.getId()) == 0) {
                    trainingChapterAttachVo.setIsLastView(Integer.valueOf(1));
                } else {
                    trainingChapterAttachVo.setIsLastView(Integer.valueOf(0));
                }
                if (trainingChapterAttachVo.getMaterialId() != null) {
                    trainingChapterAttachVo.setAttachType(Integer.valueOf(1));
                    Integer readTimes = 0;
                    TrainingMaterial trainingMaterial = trainingMaterialMap.get(trainingChapterAttachVo.getMaterialId());
                    if (ObjectUtils.isEmpty((Object)trainingMaterial)) continue;
                    TrainingMaterialVo trainingMaterialVo = new TrainingMaterialVo();
                    BeanUtils.copyProperties((Object)trainingMaterial, (Object)trainingMaterialVo);
                    Integer finishTime = this.getMaterialFinishTime(trainingMaterial);
                    totalTime = totalTime + finishTime;
                    trainingMaterialVo.setFinishTime(finishTime);
                    List<TrainingUserViewTimeVo> trainingUserViewTimeVos = trainingViewMap.get(trainingChapterAttachVo.getMaterialId());
                    if (CollectionUtils.isEmpty(trainingUserViewTimeVos)) {
                        trainingChapterAttachVo.setAttachStatus(Integer.valueOf(1));
                        isFinishView = 0;
                    } else {
                        TrainingUserViewTimeVo trainingUserViewTimeVo = trainingUserViewTimeVos.get(0);
                        readTimes = trainingUserViewTimeVo.getViewTimes();
                        if (finishTime.compareTo(readTimes) <= 0) {
                            trainingChapterAttachVo.setAttachStatus(Integer.valueOf(3));
                            Integer n = finishCount;
                            Integer n2 = finishCount = Integer.valueOf(finishCount + 1);
                        } else {
                            trainingChapterAttachVo.setAttachStatus(Integer.valueOf(2));
                            isFinishView = 0;
                        }
                        totalStatus = 2;
                    }
                    trainingChapterAttachVo.setMaterialVo(trainingMaterialVo);
                    trainingChapterAttachVo.setReadTimes(readTimes);
                } else if (trainingChapterAttachVo.getPaperId() != null) {
                    List<TrainingUserPaper> trainingUserPapers;
                    trainingChapterAttachVo.setAttachType(Integer.valueOf(2));
                    TrainingPaper trainingPaper = trainingPaperMap.get(trainingChapterAttachVo.getPaperId());
                    if (!ObjectUtils.isEmpty((Object)trainingPaper)) {
                        TrainingPapersVo trainingPapersVo = new TrainingPapersVo();
                        BeanUtils.copyProperties((Object)trainingPaper, (Object)trainingPapersVo);
                        trainingChapterAttachVo.setPaperVo(trainingPapersVo);
                    }
                    if (CollectionUtils.isEmpty(trainingUserPapers = trainingUserPaperMap.get(trainingChapterAttachVo.getPaperId()))) {
                        trainingChapterAttachVo.setAttachStatus(Integer.valueOf(1));
                        isFinishView = 0;
                    } else {
                        trainingChapterAttachVo.setAttachStatus(Integer.valueOf(3));
                        totalStatus = 2;
                        Integer n = finishCount;
                        Integer n3 = finishCount = Integer.valueOf(finishCount + 1);
                    }
                }
                if (first == 1) {
                    isLock = 0;
                }
                trainingChapterAttachVo.setIsLock(isLock);
                isLastLock = isLock;
                trainingChapterAttachVoList.add(trainingChapterAttachVo);
                Integer n = first;
                Integer n4 = first = Integer.valueOf(first + 1);
                if (isChapterAttachLock != 1 || trainingChapterAttachVo.getAttachStatus() == 3) continue;
                isLastLock = 1;
            }
            if (isChapterLock == 1 && isFinishView == 0) {
                isLastLock = 1;
            }
            trainingChapterVo.setChapterAttachs((List)trainingChapterAttachVoList);
            trainingChapterVoList.add(trainingChapterVo);
            Integer n = first;
            Integer n5 = first = Integer.valueOf(first + 1);
        }
        if (finishCount >= trainingChapterAttachList.size()) {
            totalStatus = 3;
        }
        trainingsVo.setFinishCount(finishCount);
        trainingsVo.setTotalTime(totalTime);
        trainingsVo.setTotalStatus(totalStatus);
        trainingsVo.setChapterVos((List)trainingChapterVoList);
    }

    private Integer getLastAttachId(TrainingsVo trainingsVo, Users user) {
        LambdaQueryWrapper lastWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)lastWrapper.eq(TrainingUserLastView::getProjectId, (Object)trainingsVo.getId())).eq(TrainingUserLastView::getUserId, (Object)user.getId())).eq(TrainingUserLastView::getLearnType, (Object)1)).orderByDesc(TrainingUserLastView::getId);
        List viewList = this.trainingUserLastViewMapper.selectList((Wrapper)lastWrapper);
        if (!CollectionUtils.isEmpty((Collection)viewList)) {
            return ((TrainingUserLastView)viewList.get(0)).getTaskId();
        }
        return null;
    }

    private Integer getMaterialFinishTime(TrainingMaterial trainingMaterial) {
        Integer finishTime = 0;
        finishTime = trainingMaterial.getFileType() == 3 || trainingMaterial.getFileType() == 4 ? Integer.valueOf(trainingMaterial.getDuration() != null && trainingMaterial.getFinishRate() != null ? new BigDecimal(trainingMaterial.getDuration()).multiply(trainingMaterial.getFinishRate()).divide(new BigDecimal("100"), 0, 0).intValue() : 0) : Integer.valueOf(trainingMaterial.getFinishTime() != null ? trainingMaterial.getFinishTime() : 0);
        return finishTime;
    }

    @Override
    public List<Integer> getUserIdListByTrain(Integer trainingId, Users user) {
        List<Object> userIdList = Lists.newArrayList();
        Training training = (Training)this.trainingMapper.selectById(trainingId);
        if (ObjectUtils.isEmpty((Object)training)) {
            return userIdList;
        }
        TrainingResource trainingResource = this.resourceService.getByTrainId(training.getId());
        if (ObjectUtils.isEmpty((Object)trainingResource)) {
            return userIdList;
        }
        List<UnitDO> unitDOList = this.resourceSinglePermissionService.getUnitListByMaterialAndPermissionType(trainingResource.getId(), 1);
        if (!CollectionUtils.isEmpty(unitDOList)) {
            List<String> userIds = unitDOList.stream().filter(e -> e.getBizType() == 1).map(UnitDO::getBizId).collect(Collectors.toList());
            List<String> roleIdList = unitDOList.stream().filter(e -> e.getBizType() == 3).map(UnitDO::getBizId).collect(Collectors.toList());
            List<String> tagIdList = unitDOList.stream().filter(e -> e.getBizType() == 2).map(UnitDO::getBizId).collect(Collectors.toList());
            List<String> organizeIdList = unitDOList.stream().filter(e -> e.getBizType() == 4).map(UnitDO::getBizId).collect(Collectors.toList());
            userIdList = this.userUtilService.getAllUserId(userIds, roleIdList, tagIdList, organizeIdList, user.getGroupId(), user.getId());
        }
        return userIdList;
    }

    @Override
    public Map<Integer, UserTrainingStatusBo> isFinishTraining(Integer trainingId, List<Integer> userIdList, Integer learnType, Integer projectId, Integer taskId) {
        Map<Object, Object> resultMap = Maps.newHashMap();
        LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)wrapper1.eq(TrainingChapterAttach::getTrainingId, (Object)trainingId)).eq(TrainingChapterAttach::getIsDel, (Object)0);
        List trainingChapterAttachList = this.trainingChapterAttachMapper.selectList((Wrapper)wrapper1);
        if (CollectionUtils.isEmpty((Collection)trainingChapterAttachList)) {
            return resultMap;
        }
        List<Integer> trainingMaterialIdList = trainingChapterAttachList.stream().map(TrainingChapterAttach::getMaterialId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        Map<Object, Object> viewTimeMap = Maps.newHashMap();
        Map<Object, Object> trainingMaterialMap = Maps.newHashMap();
        if (!CollectionUtils.isEmpty(trainingMaterialIdList)) {
            List trainingMaterialList = this.trainingMaterialMapper.selectBatchIds(trainingMaterialIdList);
            List<TrainingUserViewTimeVo> trainingUserViewTimeVoList = this.trainingCommonService.selectViewTimeByUserId(0, userIdList, trainingMaterialIdList, null, null);
            if (!CollectionUtils.isEmpty(trainingUserViewTimeVoList)) {
                viewTimeMap = trainingUserViewTimeVoList.stream().collect(Collectors.groupingBy(TrainingUserViewTime::getUserId));
            }
            if (!CollectionUtils.isEmpty((Collection)trainingMaterialList)) {
                trainingMaterialMap = trainingMaterialList.stream().collect(Collectors.toMap(TrainingMaterial::getId, Function.identity()));
            }
        }
        List trainingPaperIdList = trainingChapterAttachList.stream().map(TrainingChapterAttach::getPaperId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        Map<Object, Object> trainingUserPaperMap = Maps.newHashMap();
        if (!CollectionUtils.isEmpty(trainingPaperIdList)) {
            LambdaQueryWrapper wrapper3 = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper3.in(TrainingUserPaper::getTrainingPaperId, trainingPaperIdList)).in(TrainingUserPaper::getUserId, userIdList)).eq(TrainingUserPaper::getSourceType, (Object)learnType)).eq(TrainingUserPaper::getSourceProjectId, (Object)projectId)).eq(TrainingUserPaper::getSourceTaskId, (Object)taskId)).isNotNull(TrainingUserPaper::getSubmitTime);
            List trainingUserPaperList = this.trainingUserPaperMapper.selectList((Wrapper)wrapper3);
            if (!CollectionUtils.isEmpty((Collection)trainingUserPaperList)) {
                trainingUserPaperMap = trainingUserPaperList.stream().collect(Collectors.groupingBy(TrainingUserPaper::getUserId));
            }
        }
        ArrayList userTrainingStatusBoList = Lists.newArrayList();
        userIdList = userIdList.stream().distinct().collect(Collectors.toList());
        for (Integer userId : userIdList) {
            boolean isFinish = true;
            Integer viewTimes = 0;
            UserTrainingStatusBo userTrainingStatusBo = new UserTrainingStatusBo();
            for (TrainingChapterAttach trainingChapterAttach : trainingChapterAttachList) {
                if (trainingChapterAttach.getMaterialId() != null) {
                    TrainingMaterial trainingMaterial = (TrainingMaterial)trainingMaterialMap.get(trainingChapterAttach.getMaterialId());
                    List viewTimeList = (List)viewTimeMap.get(userId);
                    if (CollectionUtils.isEmpty((Collection)viewTimeList)) {
                        isFinish = false;
                        break;
                    }
                    TrainingUserViewTimeVo trainingUserViewTimeVo = viewTimeList.stream().filter(e -> e.getMaterialId().compareTo(trainingChapterAttach.getMaterialId()) == 0).findFirst().orElse(null);
                    if (ObjectUtils.isEmpty((Object)trainingUserViewTimeVo)) {
                        isFinish = false;
                        break;
                    }
                    viewTimes = viewTimes + trainingUserViewTimeVo.getViewTimes();
                    BigDecimal readRate = this.materialService.getMaterialFinishRate(trainingMaterial, trainingUserViewTimeVo.getViewTimes());
                    if (readRate.compareTo(BigDecimal.ONE) >= 0) continue;
                    isFinish = false;
                    break;
                }
                if (trainingChapterAttach.getPaperId() == null) continue;
                List trainingUserPaperList = (List)trainingUserPaperMap.get(userId);
                if (CollectionUtils.isEmpty((Collection)trainingUserPaperList)) {
                    isFinish = false;
                    break;
                }
                TrainingUserPaper trainingUserPaper = trainingUserPaperList.stream().filter(e -> e.getTrainingPaperId().compareTo(trainingChapterAttach.getPaperId()) == 0).findFirst().orElse(null);
                if (!ObjectUtils.isEmpty((Object)trainingUserPaper)) continue;
                isFinish = false;
                break;
            }
            userTrainingStatusBo.setUserId(userId);
            userTrainingStatusBo.setIsFinish(isFinish);
            userTrainingStatusBo.setViewTimes(viewTimes);
            userTrainingStatusBoList.add(userTrainingStatusBo);
        }
        resultMap = userTrainingStatusBoList.stream().collect(Collectors.toMap(UserTrainingStatusBo::getUserId, Function.identity()));
        return resultMap;
    }

    @Override
    public Integer getTrainingStudyStatus(List<TrainingChapterAttach> trainingChapterAttachList, Integer studyStatus, Map<Integer, TrainingMaterial> trainingMaterialMap, Map<Integer, List<TrainingUserViewTimeVo>> trainingViewMap, Map<Integer, List<TrainingUserPaper>> trainingUserPaperMap) {
        Integer finishNum = 0;
        for (TrainingChapterAttach trainingChapterAttach : trainingChapterAttachList) {
            if (trainingChapterAttach.getMaterialId() != null) {
                studyStatus = this.materialService.getMaterialStudyStatus(trainingChapterAttach.getMaterialId(), trainingMaterialMap, trainingViewMap, 1);
            } else if (trainingChapterAttach.getPaperId() != null) {
                List<TrainingUserPaper> trainingUserPapers = trainingUserPaperMap.get(trainingChapterAttach.getPaperId());
                studyStatus = !CollectionUtils.isEmpty(trainingUserPapers) ? Integer.valueOf(3) : Integer.valueOf(1);
            }
            if (studyStatus == 2) break;
            if (studyStatus != 3) continue;
            Integer n = finishNum;
            Integer n2 = finishNum = Integer.valueOf(finishNum + 1);
        }
        if (studyStatus == 3 && finishNum.compareTo(trainingChapterAttachList.size()) < 0) {
            studyStatus = 2;
        }
        return studyStatus;
    }

    private Training getById(Integer id) {
        return (Training)this.trainingMapper.selectById(id);
    }

    @Override
    public String getCompleteStudyUseTimeOverview(Integer groupId, Users users, Integer trainId) {
        LinkedHashMap<String, Integer> overviewMap = this.createInitMap();
        Training training = (Training)this.trainingMapper.selectById(trainId);
        if (training == null) {
            return JsonResult.success(overviewMap);
        }
        List userViewTimes = Optional.ofNullable(this.trainingUserViewTimeTrainingMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(TrainingUserViewTime::getEnterpriseId, (Object)groupId)).eq(TrainingUserViewTime::getTrainingId, (Object)trainId)).eq(TrainingUserViewTime::getLearnType, (Object)1)).select(new SFunction[]{TrainingUserViewTime::getTrainingId, TrainingUserViewTime::getViewTime, TrainingUserViewTime::getUserId, TrainingUserViewTime::getCreateTime, TrainingUserViewTime::getTaskId, TrainingUserViewTimeTraining::getFinishTime}))).orElse(new ArrayList());
        List trainingUserPapers = Optional.ofNullable(this.trainingUserPaperMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(TrainingUserPaper::getEnterpriseId, (Object)groupId)).eq(TrainingUserPaper::getSourceType, (Object)1)).eq(TrainingUserPaper::getSourceProjectId, (Object)trainId)).select(new SFunction[]{TrainingUserPaper::getUserId, TrainingUserPaper::getCreateTime}))).orElse(new ArrayList(0));
        List examStudyInfo = trainingUserPapers.stream().map(x -> {
            TrainingUserViewTimeTraining trainingUserViewTimeTraining = new TrainingUserViewTimeTraining();
            trainingUserViewTimeTraining.setUserId(x.getUserId());
            trainingUserViewTimeTraining.setCreateTime(x.getCreateTime());
            trainingUserViewTimeTraining.setFinishTime(x.getCreateTime());
            return trainingUserViewTimeTraining;
        }).collect(Collectors.toList());
        userViewTimes.addAll(examStudyInfo);
        List roleUserId = userViewTimes.stream().map(TrainingUserViewTime::getUserId).distinct().collect(Collectors.toList());
        Map<Integer, Set<Integer>> trainIdAndRelateUserIdMap = this.dimensionSummarizeService.queryNewFinishCourseUserIds(new HashSet<Integer>(roleUserId), Collections.singletonList(trainId), users);
        if (MapUtil.isEmpty(trainIdAndRelateUserIdMap)) {
            return JsonResult.success(overviewMap);
        }
        if (CollectionUtils.isEmpty((Collection)trainIdAndRelateUserIdMap.get(trainId))) {
            return JsonResult.success(overviewMap);
        }
        Set<Integer> userIds = trainIdAndRelateUserIdMap.get(trainId);
        Map<Integer, List<TrainingUserViewTimeTraining>> userIdAndMaterialListMap = userViewTimes.stream().filter(x -> userIds.contains(x.getUserId())).collect(Collectors.groupingBy(TrainingUserViewTime::getUserId));
        for (Map.Entry<Integer, List<TrainingUserViewTimeTraining>> map : userIdAndMaterialListMap.entrySet()) {
            Integer alreadyNum;
            Date minCreateTime = map.getValue().stream().min(Comparator.comparing(TrainingUserViewTime::getCreateTime)).get().getCreateTime();
            Optional<TrainingUserViewTimeTraining> maxCreateTimePresent = map.getValue().stream().filter(x -> !Objects.isNull(x.getFinishTime())).max(Comparator.comparing(TrainingUserViewTimeTraining::getFinishTime));
            if (!maxCreateTimePresent.isPresent()) continue;
            Date maxCreateTime = maxCreateTimePresent.get().getFinishTime();
            BigDecimal days = DateUtils.countExactDays(minCreateTime, maxCreateTime);
            if (days.compareTo(new BigDecimal(1)) <= 0) {
                alreadyNum = overviewMap.get("1\u5929\u5185");
                overviewMap.put("1\u5929\u5185", alreadyNum + 1);
                continue;
            }
            if (days.compareTo(new BigDecimal(7)) <= 0) {
                alreadyNum = overviewMap.get("2-7\u5929");
                overviewMap.put("2-7\u5929", alreadyNum + 1);
                continue;
            }
            if (days.compareTo(new BigDecimal(30)) <= 0) {
                alreadyNum = overviewMap.get("8-30\u5929");
                overviewMap.put("8-30\u5929", alreadyNum + 1);
                continue;
            }
            if (days.compareTo(new BigDecimal(90)) <= 0) {
                alreadyNum = overviewMap.get("31-90\u5929");
                overviewMap.put("31-90\u5929", alreadyNum + 1);
                continue;
            }
            alreadyNum = overviewMap.get("90\u5929\u4ee5\u4e0a");
            overviewMap.put("90\u5929\u4ee5\u4e0a", alreadyNum + 1);
        }
        return JsonResult.success(overviewMap);
    }

    @Override
    public String getDeptStudyOverview(DeptStudyTrainingOverviewReq req, Users user) {
        DeptFinishLessonOverviewResponse response = new DeptFinishLessonOverviewResponse();
        List roleUserId = new ArrayList();
        if (!CollectionUtils.isEmpty((Collection)req.getOrganizeIdList())) {
            List organizeIds = req.getOrganizeIdList().stream().map(x -> Integer.valueOf(x.substring(2, x.length()))).collect(Collectors.toList());
            UsersOrgIdsAndTagsPojo usersOrgIdsAndTagsPojo = new UsersOrgIdsAndTagsPojo();
            usersOrgIdsAndTagsPojo.setGroupId(user.getGroupId());
            usersOrgIdsAndTagsPojo.setOrganizeId(organizeIds);
            usersOrgIdsAndTagsPojo.setDepartmentIds(null);
            BaseResult baseResult = this.userOrganizeApi.getUserOrganizeByTagAndOrgIds(usersOrgIdsAndTagsPojo);
            roleUserId = (List)baseResult.getData();
            if (CollectionUtils.isEmpty(roleUserId)) {
                return JsonResult.success((Object)response);
            }
        } else {
            return JsonResult.success((Object)response);
        }
        List userViewTimes = Optional.ofNullable(this.trainingUserViewTimeTrainingMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(TrainingUserViewTime::getEnterpriseId, (Object)user.getGroupId())).eq(TrainingUserViewTime::getTrainingId, (Object)req.getTrainId())).in(!CollectionUtils.isEmpty(roleUserId), TrainingUserViewTime::getUserId, roleUserId)).eq(TrainingUserViewTime::getLearnType, (Object)1)).select(new SFunction[]{TrainingUserViewTime::getTrainingId, TrainingUserViewTime::getViewTime, TrainingUserViewTime::getUserId, TrainingUserViewTime::getCreateTime, TrainingUserViewTime::getTaskId}))).orElse(new ArrayList());
        List trainingUserPapers = Optional.ofNullable(this.trainingUserPaperMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(TrainingUserPaper::getEnterpriseId, (Object)user.getGroupId())).eq(TrainingUserPaper::getSourceType, (Object)1)).eq(TrainingUserPaper::getSourceProjectId, (Object)req.getTrainId())).in(!CollectionUtils.isEmpty(roleUserId), TrainingUserPaper::getUserId, roleUserId)).select(new SFunction[]{TrainingUserPaper::getUserId, TrainingUserPaper::getCreateTime}))).orElse(new ArrayList(0));
        List examStudyInfo = trainingUserPapers.stream().map(x -> {
            TrainingUserViewTimeTraining trainingUserViewTimeTraining = new TrainingUserViewTimeTraining();
            trainingUserViewTimeTraining.setUserId(x.getUserId());
            trainingUserViewTimeTraining.setCreateTime(x.getCreateTime());
            return trainingUserViewTimeTraining;
        }).collect(Collectors.toList());
        userViewTimes.addAll(examStudyInfo);
        long studyUserNum = userViewTimes.stream().map(TrainingUserViewTime::getUserId).distinct().count();
        response.setStudyUserNum(Integer.valueOf((int)studyUserNum));
        List studyUserIds = userViewTimes.stream().map(TrainingUserViewTime::getUserId).distinct().collect(Collectors.toList());
        Map<Integer, Set<Integer>> trainIdAndRelateUserIdMap = this.dimensionSummarizeService.queryNewFinishCourseUserIds(new HashSet<Integer>(studyUserIds), Collections.singletonList(req.getTrainId()), user);
        Set<Integer> finishUserNum = trainIdAndRelateUserIdMap.get(req.getTrainId());
        response.setFinishStudyUserNum(Integer.valueOf(finishUserNum.size()));
        return JsonResult.success((Object)response);
    }

    @Override
    public String getStudyCourseOverview(DeptStudyTrainingOverviewReq req, Users user) {
        DeptLessonOverviewResponse response = new DeptLessonOverviewResponse();
        ArrayList roleUserId = new ArrayList();
        List userViewTimes = Optional.ofNullable(this.trainingUserViewTimeTrainingMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(TrainingUserViewTime::getEnterpriseId, (Object)user.getGroupId())).eq(TrainingUserViewTime::getTrainingId, (Object)req.getTrainId())).in(!CollectionUtils.isEmpty(roleUserId), TrainingUserViewTime::getUserId, roleUserId)).eq(TrainingUserViewTime::getLearnType, (Object)1)).select(new SFunction[]{TrainingUserViewTime::getTrainingId, TrainingUserViewTime::getViewTime, TrainingUserViewTime::getUserId, TrainingUserViewTime::getCreateTime, TrainingUserViewTimeTraining::getUpdateTime, TrainingUserViewTime::getTaskId}))).orElse(new ArrayList());
        List trainingUserPapers = Optional.ofNullable(this.trainingUserPaperMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(TrainingUserPaper::getEnterpriseId, (Object)user.getGroupId())).eq(TrainingUserPaper::getSourceType, (Object)1)).eq(TrainingUserPaper::getSourceProjectId, (Object)req.getTrainId())).in(!CollectionUtils.isEmpty(roleUserId), TrainingUserPaper::getUserId, roleUserId)).select(new SFunction[]{TrainingUserPaper::getUserId, TrainingUserPaper::getCreateTime}))).orElse(new ArrayList(0));
        List examStudyInfo = trainingUserPapers.stream().map(x -> {
            TrainingUserViewTimeTraining trainingUserViewTimeTraining = new TrainingUserViewTimeTraining();
            trainingUserViewTimeTraining.setUserId(x.getUserId());
            trainingUserViewTimeTraining.setCreateTime(x.getCreateTime());
            trainingUserViewTimeTraining.setUpdateTime(x.getCreateTime());
            return trainingUserViewTimeTraining;
        }).collect(Collectors.toList());
        userViewTimes.addAll(examStudyInfo);
        long studyUserNum = userViewTimes.stream().map(TrainingUserViewTime::getUserId).distinct().count();
        List totalStudyUserId = userViewTimes.stream().map(TrainingUserViewTime::getUserId).distinct().collect(Collectors.toList());
        response.setTotalStudyNum(Integer.valueOf((int)studyUserNum));
        LocalDateTime latestSevenDaysBegin = LocalDate.now().atStartOfDay().minusDays(6L);
        long latestSevenDayStudyUserNum = userViewTimes.stream().filter(x -> DateUtils.dateToLocalDateTime(x.getUpdateTime()).isAfter(latestSevenDaysBegin) && DateUtils.dateToLocalDateTime(x.getUpdateTime()).isBefore(LocalDateTime.now())).map(TrainingUserViewTime::getUserId).distinct().count();
        response.setWeekStudyNum(Integer.valueOf((int)latestSevenDayStudyUserNum));
        Map<Integer, Set<Integer>> trainIdAndRelateUserIdMap = this.dimensionSummarizeService.queryNewFinishCourseUserIds(new HashSet<Integer>(totalStudyUserId), Collections.singletonList(req.getTrainId()), user);
        Set<Integer> finishUserNum = trainIdAndRelateUserIdMap.get(req.getTrainId());
        response.setFinishStudyNum(Integer.valueOf(finishUserNum.size()));
        return JsonResult.success((Object)response);
    }

    private LinkedHashMap<String, Integer> createInitMap() {
        LinkedHashMap<String, Integer> overViewMap = new LinkedHashMap<String, Integer>();
        overViewMap.put("1\u5929\u5185", 0);
        overViewMap.put("2-7\u5929", 0);
        overViewMap.put("8-30\u5929", 0);
        overViewMap.put("31-90\u5929", 0);
        overViewMap.put("90\u5929\u4ee5\u4e0a", 0);
        return overViewMap;
    }

    @Override
    public void saveTrainingViewCount(Integer trainingId) {
        Training training = (Training)this.trainingMapper.selectById(trainingId);
        if (!ObjectUtils.isEmpty((Object)training)) {
            LambdaUpdateWrapper wrapper1 = new LambdaUpdateWrapper();
            ((LambdaUpdateWrapper)wrapper1.eq(Training::getId, (Object)trainingId)).set(Training::getViewCount, (Object)((training.getViewCount() == null ? 0 : training.getViewCount()) + 1));
            this.trainingMapper.update(null, (Wrapper)wrapper1);
            this.resourceService.saveResourceAddViewCount(trainingId, 8);
        }
    }
}

