/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.training.util;

import com.alibaba.fastjson.JSONObject;
import com.ovopark.training.bo.TokenBo;
import com.ovopark.training.model.Authenticator;
import com.ovopark.training.model.ClientInfo;
import com.ovopark.training.model.Users;
import com.ovopark.training.service.UserUtilService;
import com.ovopark.training.util.AesUtil;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import java.util.concurrent.Executor;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CommonUtil {
    private static final Logger log = LoggerFactory.getLogger(CommonUtil.class);
    @Autowired
    private UserUtilService userUtilService;
    @Resource(name="oldCommon")
    private Executor commonExecutor;
    private static Executor service;

    @PostConstruct
    public void init() {
        service = this.commonExecutor;
    }

    public static String generateToken(Users user) {
        String content = user.getId().toString() + "," + user.getUserName() + "," + user.getPassword();
        return AesUtil.encrypttoStr((String)content, (String)"kedacom.com");
    }

    public static String generateEternalToken(Users user) {
        String content = user.getId().toString();
        return AesUtil.encrypttoStr((String)content, (String)"kedacom.com");
    }

    public static TokenBo decodeToken(String token) {
        TokenBo tokenBo = new TokenBo();
        if (StringUtils.isEmpty((String)token)) {
            tokenBo.setResult("INVALID_TOKEN");
            return tokenBo;
        }
        try {
            byte[] chars = AesUtil.decrypt((String)token, (String)"kedacom.com");
            if (chars != null && chars.length > 0) {
                String result = new String(AesUtil.decrypt((String)token, (String)"kedacom.com"));
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                String[] array = new String[]{};
                array = result.split(",");
                if (array.length >= 3) {
                    tokenBo.setUserId(Integer.valueOf(Integer.parseInt(array[0])));
                    tokenBo.setUserName(array[1]);
                    tokenBo.setPassword(array[2]);
                    if (array.length >= 5) {
                        tokenBo.setDate(sdf.parse(array[3]));
                        tokenBo.setExpires(Long.valueOf(Long.parseLong(array[4])));
                    }
                } else if (array.length == 1) {
                    tokenBo.setUserId(Integer.valueOf(Integer.parseInt(array[0])));
                } else {
                    tokenBo.setResult("INVALID_TOKEN");
                }
            } else {
                tokenBo.setResult("INVALID_TOKEN");
            }
        }
        catch (Exception e) {
            tokenBo.setResult("INVALID_TOKEN");
        }
        return tokenBo;
    }

    public static String createActivateCode(int length) {
        String base = "abcdefghijklmnopqrstuvwxyz123456789";
        Random random = new Random();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < length; ++i) {
            int number = random.nextInt(base.length());
            sb.append(base.charAt(number));
        }
        return sb.toString();
    }

    public static List<String> str2strList(String str) {
        ArrayList<String> list = new ArrayList<String>();
        if (StringUtils.isNotBlank((String)str)) {
            String[] arr;
            for (String s : arr = str.split(",")) {
                list.add(s);
            }
        }
        return list;
    }

    public static List<Integer> str2IntList(String str) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        if (StringUtils.isNotBlank((String)str)) {
            String[] arr;
            for (String i : arr = str.split(",")) {
                list.add(new Integer(i));
            }
        }
        return list;
    }

    public static void main(String[] args) {
        CommonUtil.decodeToken("DA4363D9B2640D67942F4EA3D8E50CBE");
        Users user = new Users();
        user.setId(Integer.valueOf(125327));
        user.setUserName("\u72d0\u72f8\u5c0f\u5996050001");
        user.setPassword("044090c03e7b261139780ff6b46e20d9");
        System.out.println(CommonUtil.generateEternalToken(user));
    }

    public static List<String> getBetweenDates(String minDate, String maxDate) throws ParseException {
        ArrayList<String> listDate = new ArrayList<String>();
        Calendar startCalendar = Calendar.getInstance();
        Calendar endCalendar = Calendar.getInstance();
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date startDate = df.parse(minDate);
        startCalendar.setTime(startDate);
        Date endDate = df.parse(maxDate);
        endCalendar.setTime(endDate);
        listDate.add(df.format(startCalendar.getTime()));
        while (true) {
            startCalendar.add(5, 1);
            if (startCalendar.getTimeInMillis() > endCalendar.getTimeInMillis()) break;
            listDate.add(df.format(startCalendar.getTime()));
        }
        return listDate;
    }

    public static boolean isMobileNO(String mobiles) {
        boolean flag = false;
        try {
            Pattern p = Pattern.compile("^1\\d{10}$");
            Matcher m = p.matcher(mobiles);
            flag = m.matches();
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            flag = false;
        }
        return flag;
    }

    public static String getLocale() {
        Locale locale = CommonUtil.getLocaleBase();
        return JSONObject.toJSONString((Object)locale);
    }

    private static Locale getLocaleBase() {
        Locale locale = Locale.SIMPLIFIED_CHINESE;
        ClientInfo ci = Authenticator.getInstance().getCurrentClient();
        if (ci != null && ci.getLocale() != null) {
            locale = ci.getLocale();
        }
        return locale;
    }

    public static void handleTask(Runnable runnable) {
        service.execute(runnable);
    }

    public static String getTerminalByToken(HttpServletRequest req) {
        String authorization = req.getHeader("Ovo-Authorization");
        if (StringUtils.isEmpty((String)authorization)) {
            return null;
        }
        String[] auths = authorization.split(" ");
        return auths[1];
    }
}

