/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.training.util;

import com.ovopark.training.enhancer.utils.EhContextUtil;
import com.ovopark.training.model.Authenticator;
import com.ovopark.training.model.ClientInfo;
import com.ovopark.training.model.Users;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContextUtil {
    private static final Logger log = LoggerFactory.getLogger(ContextUtil.class);
    private static final ThreadLocal<HashMap<String, Object>> envStore = ThreadLocal.withInitial(HashMap::new);

    public static void clear() {
        envStore.remove();
    }

    public static void remove(String contextKey) {
        envStore.get().remove(contextKey);
    }

    public static void putAll(HashMap<String, Object> keyValue) {
        envStore.get().putAll(keyValue);
    }

    public static HashMap<String, Object> getAll() {
        return new HashMap<String, Object>((Map)envStore.get());
    }

    public static void put(String key, Object value) {
        envStore.get().put(key, value);
    }

    public static Object get(String key) {
        return envStore.get().get(key);
    }

    public static void setResponse(ServletResponse servletResponse) {
        ContextUtil.put("response", servletResponse);
    }

    public static ServletResponse getResponse() {
        return (ServletResponse)ContextUtil.get("response");
    }

    public static void setUserId(int userId) {
        log.debug("setUserId:{}", (Object)userId);
        ContextUtil.put("userId", userId);
        EhContextUtil.setUserId((int)userId);
    }

    public static int getUserId() {
        Integer userId = (Integer)ContextUtil.get("userId");
        return userId == null ? 0 : userId;
    }

    public static void setEnterpriseId(Integer enterpriseId) {
        ContextUtil.put("enterpriseId", enterpriseId);
        EhContextUtil.setEnterpriseId((Integer)enterpriseId);
    }

    public static Integer getEnterpriseId() {
        return (Integer)ContextUtil.get("enterpriseId");
    }

    public static Users getUser() {
        return Authenticator.getUser();
    }

    public ClientInfo getCurrentClient() {
        return Authenticator.getInstance().getCurrentClient();
    }
}

