/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.training.util;

import cn.hutool.http.HttpResponse;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Component
public class DcStorageUrlUtils {
    private static final Logger log = LoggerFactory.getLogger(DcStorageUrlUtils.class);
    private static DcStorageUrlUtils utils;
    @Value(value="${project.dc.fileConvertAddress}")
    private String fileConvertAddress;
    @Value(value="${project.urlNeedConvert}")
    private Boolean urlNeedConvert;

    @PostConstruct
    public void init() {
        utils = this;
        DcStorageUrlUtils.utils.fileConvertAddress = this.fileConvertAddress + "/api/dc/storage/standard/batch/expire/url";
        DcStorageUrlUtils.utils.urlNeedConvert = this.urlNeedConvert;
    }

    public static String urlConvert(String urls) {
        if (ObjectUtils.isEmpty((Object)urls)) {
            return urls;
        }
        return DcStorageUrlUtils.urlBatchConvert(Collections.singletonList(urls)).get(0);
    }

    public static List<String> urlBatchConvert(List<String> urls) {
        try {
            if (!DcStorageUrlUtils.utils.urlNeedConvert.booleanValue() || CollectionUtils.isEmpty(urls)) {
                return urls;
            }
            JSONObject param = new JSONObject();
            param.put("urlList", urls);
            param.put("time", (Object)3600);
            param.put("timeUnit", (Object)2);
            HttpResponse response = HttpUtil.createPost((String)DcStorageUrlUtils.utils.fileConvertAddress).body(param.toJSONString()).timeout(30000).execute();
            if (response != null && response.getStatus() == 200) {
                JSONObject jsonObject = JSONObject.parseObject((String)response.body());
                log.info("urlBatchConvert success params = {} result = {}", (Object)JSON.toJSONString((Object)param), (Object)jsonObject);
                if (jsonObject != null && jsonObject.getInteger("code") == 0) {
                    return jsonObject.getJSONArray("data").toJavaList(String.class);
                }
            }
            log.error("urlBatchConvert  error params = {} result = {}", (Object)JSON.toJSONString((Object)param), response != null ? JSON.toJSONString((Object)response.body()) : null);
        }
        catch (Exception e) {
            log.error("urlBatchConvert exception\uff1a{}", (Throwable)e);
        }
        return urls;
    }

    public static void main(String[] args) {
        ArrayList<String> urls = new ArrayList<String>();
        urls.add("https://111.10.38.128:8182/qiniu/cloud-watch/211/2024/12/13/1(1).jpg");
        urls.add("https://111.10.38.128:8182/qiniu/oa-task/211/2024/12/20/1(1).jpg");
        List<String> strings = DcStorageUrlUtils.urlBatchConvert(urls);
        System.out.println(JSON.toJSONString(strings));
    }
}

