/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.training.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.poi.hssf.usermodel.DVConstraint;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFClientAnchor;
import org.apache.poi.hssf.usermodel.HSSFDataFormat;
import org.apache.poi.hssf.usermodel.HSSFDataValidation;
import org.apache.poi.hssf.usermodel.HSSFDateUtil;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFName;
import org.apache.poi.hssf.usermodel.HSSFPicture;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.Comment;
import org.apache.poi.ss.usermodel.DataValidation;
import org.apache.poi.ss.usermodel.DataValidationConstraint;
import org.apache.poi.ss.usermodel.Drawing;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.PictureData;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.ss.util.CellRangeAddressList;
import org.apache.poi.xssf.usermodel.XSSFClientAnchor;
import org.apache.poi.xssf.usermodel.XSSFDrawing;
import org.apache.poi.xssf.usermodel.XSSFPicture;
import org.apache.poi.xssf.usermodel.XSSFShape;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class ExcelUtil {
    private static final Logger log = LoggerFactory.getLogger(ExcelUtil.class);
    private static final String excel2003L = ".xls";
    private static final String excel2007U = ".xlsx";
    private static final int EXCEL_MAX_ROW = 60000;

    public static Workbook createWorkBook(InputStream in) throws Exception {
        try {
            HSSFWorkbook hSSFWorkbook = new HSSFWorkbook(in);
            return hSSFWorkbook;
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    public static String getCellStringValue(Cell cell) {
        if (cell == null) {
            return "";
        }
        cell.setCellType(1);
        RichTextString str = cell.getRichStringCellValue();
        return str.getString();
    }

    public static void initCell(Cell cell, CellStyle style, String value) {
        cell.setCellStyle(style);
        cell.setCellValue(value);
    }

    public static void initCell(Cell cell, CellStyle style, String value, Comment comment) {
        cell.setCellStyle(style);
        cell.setCellValue(value);
        cell.setCellComment(comment);
    }

    public static Comment getCellComment(Drawing drawing, HSSFClientAnchor anchor, String content) {
        Comment comment = drawing.createCellComment((ClientAnchor)anchor);
        comment.setString((RichTextString)new HSSFRichTextString(content));
        return comment;
    }

    public static CellStyle getHeadStyle(Workbook wb) {
        CellStyle style = wb.createCellStyle();
        style.setFillForegroundColor((short)44);
        style.setFillPattern((short)1);
        style.setBorderTop((short)2);
        style.setBorderRight((short)2);
        style.setBorderBottom((short)2);
        style.setBorderLeft((short)2);
        style.setAlignment((short)2);
        style.setVerticalAlignment((short)1);
        Font font = wb.createFont();
        font.setBoldweight((short)700);
        style.setFont(font);
        style.setLocked(true);
        return style;
    }

    public static CellStyle getBodyStyle(Workbook wb) {
        CellStyle style = wb.createCellStyle();
        style.setBorderTop((short)1);
        style.setBorderRight((short)1);
        style.setBorderBottom((short)1);
        style.setBorderLeft((short)1);
        return style;
    }

    public static CellStyle getErrorStyle(Workbook wb) {
        CellStyle style = wb.createCellStyle();
        Font font = wb.createFont();
        font.setColor((short)10);
        style.setFont(font);
        return style;
    }

    public static HSSFWorkbook dropDownList2003(Workbook wb, Sheet realSheet, String[] datas, int startRow, int endRow, int startCol, int endCol, String hiddenSheetName, int hiddenSheetIndex) throws Exception {
        HSSFWorkbook workbook = (HSSFWorkbook)wb;
        HSSFSheet hidden = workbook.createSheet(hiddenSheetName);
        workbook.setSheetHidden(hiddenSheetIndex, true);
        HSSFRow row = null;
        HSSFCell cell = null;
        int length = datas.length;
        for (int i = 0; i < length; ++i) {
            row = hidden.createRow(i);
            cell = row.createCell(0);
            cell.setCellValue(datas[i]);
        }
        DVConstraint constraint = DVConstraint.createFormulaListConstraint((String)(hiddenSheetName + "!$A$1:$A" + datas.length));
        CellRangeAddressList addressList = null;
        HSSFDataValidation validation = null;
        row = null;
        cell = null;
        HSSFCellStyle style = workbook.createCellStyle();
        style.setDataFormat(HSSFDataFormat.getBuiltinFormat((String)"0"));
        style.setAlignment((short)2);
        style.setVerticalAlignment((short)1);
        for (int i = startRow; i <= endRow; ++i) {
            row = (HSSFRow)realSheet.createRow(i);
            cell = row.createCell(startCol);
            cell.setCellStyle((CellStyle)style);
            addressList = new CellRangeAddressList(i, i, startCol, endCol);
            validation = new HSSFDataValidation(addressList, (DataValidationConstraint)constraint);
            ((HSSFSheet)realSheet).addValidationData((DataValidation)validation);
            validation.setSuppressDropDownArrow(true);
            validation.setShowErrorBox(true);
        }
        return workbook;
    }

    public static void setDataCellStyles(HSSFWorkbook workbook, HSSFSheet sheet) {
        HSSFCellStyle cellStyle = workbook.createCellStyle();
        cellStyle.setBorderBottom((short)1);
        cellStyle.setBorderLeft((short)1);
        cellStyle.setBorderRight((short)1);
        cellStyle.setBorderTop((short)1);
        cellStyle.setFillForegroundColor((short)42);
        cellStyle.setFillPattern((short)1);
        cellStyle.setAlignment((short)1);
        HSSFFont font = workbook.createFont();
        font.setFontName("\u5b8b\u4f53");
        font.setFontHeightInPoints((short)11);
        cellStyle.setFont(font);
        HSSFDataFormat format = workbook.createDataFormat();
        cellStyle.setDataFormat(format.getFormat("@"));
    }

    public static void creatHideSheet(HSSFWorkbook workbook, String hideSheetName, List<String> province) {
        HSSFSheet sheet = workbook.createSheet(hideSheetName);
        HSSFRow provinceRow = sheet.createRow(0);
        ExcelUtil.creatRow(provinceRow, province);
    }

    public static void creatRow(HSSFRow currentRow, List<String> text) {
        if (text != null) {
            int i = 0;
            for (String cellValue : text) {
                HSSFCell userNameLableCell = currentRow.createCell(i++);
                userNameLableCell.setCellValue(cellValue);
            }
        }
    }

    public static void creatExcelNameList(HSSFWorkbook workbook, String hideSheetName, List<String> province) {
        HSSFName name = workbook.createName();
        name.setNameName("province");
        name.setRefersToFormula(hideSheetName + "!$A$1:$" + ExcelUtil.getcellColumnFlag(province.size()) + "$1");
    }

    public static String getcellColumnFlag(int num) {
        String columFiled = "";
        int chuNum = 0;
        int yuNum = 0;
        if (num >= 1 && num <= 26) {
            columFiled = ExcelUtil.doHandle(num);
        } else {
            chuNum = num / 26;
            yuNum = num % 26;
            columFiled = columFiled + ExcelUtil.doHandle(chuNum);
            columFiled = columFiled + ExcelUtil.doHandle(yuNum);
        }
        return columFiled;
    }

    public static String doHandle(int num) {
        String[] charArr = new String[]{"A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z"};
        return charArr[num - 1].toString();
    }

    public static HSSFDataValidation getDataValidationByFormula(String formulaString, int naturalRowIndex, int naturalColumnIndex) {
        DVConstraint constraint = DVConstraint.createFormulaListConstraint((String)formulaString);
        int firstRow = naturalRowIndex;
        int lastRow = naturalRowIndex;
        int firstCol = naturalColumnIndex - 1;
        int lastCol = naturalColumnIndex - 1;
        CellRangeAddressList regions = new CellRangeAddressList(firstRow, lastRow, firstCol, lastCol);
        HSSFDataValidation data_validation_list = new HSSFDataValidation(regions, (DataValidationConstraint)constraint);
        return data_validation_list;
    }

    public static void creatAppRow(HSSFSheet hssfSheet, int naturalRowIndex, int i) {
        HSSFRow hssfRow = hssfSheet.createRow(naturalRowIndex);
        Cell province = hssfRow.createCell(i);
        province.setCellValue("");
        HSSFDataValidation data_validation_list1 = ExcelUtil.getDataValidationByFormula("province", naturalRowIndex, i + 1);
        hssfSheet.addValidationData((DataValidation)data_validation_list1);
    }

    public static List<Row> readExcel_xls(File file, String sheetName) throws Exception {
        if (!file.exists()) {
            throw new IOException("\u6587\u4ef6\u540d\u4e3a" + file.getName() + "Excel\u6587\u4ef6\u4e0d\u5b58\u5728\uff01");
        }
        Workbook wb = null;
        ArrayList<Row> rowList = new ArrayList();
        FileInputStream inp = new FileInputStream(file);
        wb = WorkbookFactory.create((InputStream)inp);
        rowList = ExcelUtil.readExcel(wb, sheetName);
        return rowList;
    }

    public static List<Row> readCheckExcel_xlsx(File file, String sheetName) throws IOException {
        if (!file.exists()) {
            throw new IOException("\u6587\u4ef6\u540d\u4e3a" + file.getName() + "Excel\u6587\u4ef6\u4e0d\u5b58\u5728\uff01");
        }
        XSSFWorkbook wb = null;
        List<Row> rowList = new ArrayList<Row>();
        try {
            FileInputStream fis = new FileInputStream(file);
            wb = new XSSFWorkbook((InputStream)fis);
            rowList = ExcelUtil.readExcel((Workbook)wb, sheetName);
        }
        catch (IOException e) {
            log.error("readCheckExcel_xlsx", (Throwable)e);
        }
        return rowList;
    }

    private static List<Row> readExcel(Workbook wb, String sheetName) {
        ArrayList<Row> rowList = new ArrayList<Row>();
        Sheet sheet = wb.getSheet(sheetName);
        if (sheet == null) {
            sheet = wb.getSheetAt(0);
        }
        int startReadPos = 0;
        int lastRowNum = sheet.getLastRowNum();
        Row row = null;
        for (int i = startReadPos; i <= lastRowNum; ++i) {
            row = sheet.getRow(i);
            if (row == null) continue;
            rowList.add(row);
            for (int j = 0; j < row.getLastCellNum(); ++j) {
                String value = ExcelUtil.getCellValue(row.getCell(j));
                if (value.equals("")) continue;
            }
        }
        return rowList;
    }

    public static String getCellValue(Cell cell) {
        Object result = "";
        if (!StringUtils.isEmpty((Object)cell)) {
            switch (cell.getCellType()) {
                case 1: {
                    result = cell.getStringCellValue();
                    break;
                }
                case 0: {
                    SimpleDateFormat format = null;
                    if (HSSFDateUtil.isCellDateFormatted((Cell)cell)) {
                        format = cell.getCellStyle().getDataFormat() == 14 ? new SimpleDateFormat("yyyy-MM-dd") : (cell.getCellStyle().getDataFormat() == 21 ? new SimpleDateFormat("HH:mm:ss") : new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"));
                        result = format.format(cell.getDateCellValue());
                        break;
                    }
                    if (cell.getCellStyle().getDataFormat() == 31) {
                        format = new SimpleDateFormat("yyyy\u5e74MM\u6708dd\u65e5");
                        result = format.format(cell.getDateCellValue());
                        break;
                    }
                    if (cell.getCellStyle().getDataFormat() == 57) {
                        format = new SimpleDateFormat("yyyy\u5e74MM\u6708");
                        result = format.format(cell.getDateCellValue());
                        break;
                    }
                    if (cell.getCellStyle().getDataFormat() == 58) {
                        format = new SimpleDateFormat("MM\u6708dd\u65e5");
                        result = format.format(cell.getDateCellValue());
                        break;
                    }
                    DecimalFormat formats = new DecimalFormat("#.#####");
                    result = formats.format(cell.getNumericCellValue());
                    break;
                }
                case 4: {
                    result = cell.getBooleanCellValue();
                    break;
                }
                case 2: {
                    result = cell.getCellFormula();
                    break;
                }
                case 5: {
                    result = cell.getErrorCellValue();
                    break;
                }
                case 3: {
                    break;
                }
            }
        }
        return result.toString();
    }

    public static Workbook getWorkbook(InputStream inStr, String fileName) throws Exception {
        HSSFWorkbook wb = null;
        String fileType = fileName.substring(fileName.lastIndexOf("."));
        if (excel2003L.equals(fileType)) {
            wb = new HSSFWorkbook(inStr);
        } else if (excel2007U.equals(fileType)) {
            wb = new XSSFWorkbook(inStr);
        } else {
            throw new Exception("\u89e3\u6790\u7684\u6587\u4ef6\u683c\u5f0f\u6709\u8bef\uff01");
        }
        return wb;
    }

    public static List<List<Object>> getBankListByExcel(InputStream in, String fileName, Integer sheetId) throws Exception {
        ArrayList<List<Object>> list = new ArrayList<List<Object>>();
        Workbook work = ExcelUtil.getWorkbook(in, fileName);
        if (null == work) {
            throw new Exception("\u521b\u5efaExcel\u5de5\u4f5c\u8584\u4e3a\u7a7a\uff01");
        }
        Sheet sheet = null;
        Row row = null;
        Cell cell = null;
        if (sheetId == null) {
            for (int i = 0; i < work.getNumberOfSheets(); ++i) {
                sheet = work.getSheetAt(i);
                if (sheet == null) continue;
                for (int j = sheet.getFirstRowNum(); j <= sheet.getLastRowNum(); ++j) {
                    row = sheet.getRow(j);
                    if (row == null) continue;
                    ArrayList<String> li = new ArrayList<String>();
                    for (int y = 0; y < row.getLastCellNum(); ++y) {
                        cell = row.getCell(y);
                        li.add(ExcelUtil.getCellValue(cell));
                    }
                    list.add(li);
                }
            }
        } else {
            sheet = work.getSheetAt(sheetId.intValue());
            for (int j = sheet.getFirstRowNum(); j <= sheet.getLastRowNum(); ++j) {
                row = sheet.getRow(j);
                if (row == null) continue;
                ArrayList<String> li = new ArrayList<String>();
                for (int y = 0; y < row.getLastCellNum(); ++y) {
                    cell = row.getCell(y);
                    li.add(ExcelUtil.getCellValue(cell));
                }
                list.add(li);
            }
        }
        return list;
    }

    public static List<String> getSheetNameByExcel(InputStream in, String fileName, Integer sheetId) throws Exception {
        ArrayList<String> list = new ArrayList<String>();
        Workbook work = ExcelUtil.getWorkbook(in, fileName);
        if (null == work) {
            throw new Exception("\u521b\u5efaExcel\u5de5\u4f5c\u8584\u4e3a\u7a7a\uff01");
        }
        for (int i = 0; i < sheetId; ++i) {
            Sheet sheet = work.getSheetAt(i);
            if (sheet == null) continue;
            list.add(sheet.getSheetName().trim());
        }
        return list;
    }

    public static List<List<Object>> getBankListByExcel1(InputStream in, String fileName, Integer sheetId) throws Exception {
        ArrayList<List<Object>> list = null;
        Workbook work = ExcelUtil.getWorkbook(in, fileName);
        if (null == work) {
            throw new Exception("\u521b\u5efaExcel\u5de5\u4f5c\u8584\u4e3a\u7a7a\uff01");
        }
        Sheet sheet = null;
        Row row = null;
        Cell cell = null;
        list = new ArrayList<List<Object>>();
        if (sheetId == null) {
            for (int i = 0; i < work.getNumberOfSheets(); ++i) {
                sheet = work.getSheetAt(i);
                if (sheet == null) continue;
                for (int j = sheet.getFirstRowNum(); j <= sheet.getLastRowNum(); ++j) {
                    row = sheet.getRow(j);
                    if (row == null) {
                        list.add(new ArrayList());
                        continue;
                    }
                    ArrayList<String> li = new ArrayList<String>();
                    for (int y = 0; y < row.getLastCellNum(); ++y) {
                        cell = row.getCell(y);
                        li.add(ExcelUtil.getCellValue(cell));
                    }
                    list.add(li);
                }
            }
        } else {
            sheet = work.getSheetAt(sheetId.intValue());
            for (int j = sheet.getFirstRowNum(); j <= sheet.getLastRowNum(); ++j) {
                row = sheet.getRow(j);
                if (row == null) {
                    list.add(new ArrayList());
                    continue;
                }
                ArrayList<String> li = new ArrayList<String>();
                for (int y = 0; y < row.getLastCellNum(); ++y) {
                    cell = row.getCell(y);
                    li.add(ExcelUtil.getCellValue(cell));
                }
                list.add(li);
            }
        }
        return list;
    }

    public static Map<String, List<PictureData>> getRowPictures(String fileName, InputStream is) throws Exception {
        return ExcelUtil.getPictures(fileName, is, ClientAnchor::getRow1, ClientAnchor::getCol1);
    }

    public static Map<String, List<PictureData>> getRowPicturesForMoreSheet(String fileName, InputStream is) throws Exception {
        return ExcelUtil.getPicturesMoreSheet(fileName, is, ClientAnchor::getRow1, ClientAnchor::getCol1);
    }

    public static Map<String, Map<Integer, TreeMap<Integer, PictureData>>> getRowPicturesForMoreSheet2(String fileName, InputStream is) throws Exception {
        return ExcelUtil.getPicturesMoreSheet2(fileName, is, ClientAnchor::getRow1, ClientAnchor::getCol1);
    }

    public static Map<String, List<PictureData>> getPictures(String fileName, InputStream is, ExtractPictureKey extractor1, ExtractPictureKey extractor2) throws Exception {
        XSSFClientAnchor cAnchor;
        XSSFPicture picture;
        List list;
        XSSFDrawing drawingPatriarch;
        HashMap<String, List<PictureData>> map = new HashMap<String, List<PictureData>>();
        Workbook workbook = ExcelUtil.getWorkbook(is, fileName);
        Sheet sheet = workbook.getSheetAt(0);
        if (sheet instanceof XSSFSheet) {
            drawingPatriarch = ((XSSFSheet)sheet).getDrawingPatriarch();
            if (drawingPatriarch == null) {
                return map;
            }
            list = drawingPatriarch.getShapes();
            for (XSSFShape shape : list) {
                if (!(shape instanceof XSSFPicture)) continue;
                picture = (XSSFPicture)shape;
                cAnchor = (XSSFClientAnchor)picture.getAnchor();
                map.computeIfAbsent(extractor1.extract((ClientAnchor)cAnchor) + "-" + extractor2.extract((ClientAnchor)cAnchor), k -> new ArrayList()).add(picture.getPictureData());
            }
        }
        if (sheet instanceof HSSFSheet) {
            drawingPatriarch = ((HSSFSheet)sheet).getDrawingPatriarch();
            if (drawingPatriarch == null) {
                return map;
            }
            list = drawingPatriarch.getChildren();
            for (XSSFShape shape : list) {
                if (!(shape instanceof HSSFPicture)) continue;
                picture = (HSSFPicture)shape;
                cAnchor = picture.getClientAnchor();
                map.computeIfAbsent(extractor1.extract((ClientAnchor)cAnchor) + "-" + extractor2.extract((ClientAnchor)cAnchor), k -> new ArrayList()).add(picture.getPictureData());
            }
        }
        return map;
    }

    public static Map<String, List<PictureData>> getPicturesMoreSheet(String fileName, InputStream is, ExtractPictureKey extractor1, ExtractPictureKey extractor2) throws Exception {
        HashMap<String, List<PictureData>> map = new HashMap<String, List<PictureData>>();
        Workbook workbook = ExcelUtil.getWorkbook(is, fileName);
        int sheetNum = workbook.getNumberOfSheets();
        for (int i = 0; i < 6; ++i) {
            XSSFClientAnchor cAnchor;
            XSSFPicture picture;
            List list;
            XSSFDrawing drawingPatriarch;
            Sheet sheet = workbook.getSheetAt(i);
            if (sheet instanceof XSSFSheet) {
                drawingPatriarch = ((XSSFSheet)sheet).getDrawingPatriarch();
                if (drawingPatriarch == null) continue;
                list = drawingPatriarch.getShapes();
                for (XSSFShape shape : list) {
                    if (!(shape instanceof XSSFPicture)) continue;
                    picture = (XSSFPicture)shape;
                    cAnchor = (XSSFClientAnchor)picture.getAnchor();
                    if (picture.getPictureData() == null) continue;
                    String data1 = sheet.getSheetName();
                    int data2 = extractor1.extract((ClientAnchor)cAnchor);
                    int data3 = extractor2.extract((ClientAnchor)cAnchor);
                    map.computeIfAbsent(data1 + "-" + data2 + "-" + data3, k -> new ArrayList()).add(picture.getPictureData());
                }
            }
            if (!(sheet instanceof HSSFSheet) || (drawingPatriarch = ((HSSFSheet)sheet).getDrawingPatriarch()) == null) continue;
            list = drawingPatriarch.getChildren();
            for (XSSFShape shape : list) {
                if (!(shape instanceof HSSFPicture)) continue;
                picture = (HSSFPicture)shape;
                cAnchor = picture.getClientAnchor();
                map.computeIfAbsent(sheet.getSheetName() + "-" + extractor1.extract((ClientAnchor)cAnchor) + "-" + extractor2.extract((ClientAnchor)cAnchor), k -> new ArrayList()).add(picture.getPictureData());
            }
        }
        return map;
    }

    public static Map<String, Map<Integer, TreeMap<Integer, PictureData>>> getPicturesMoreSheet2(String fileName, InputStream is, ExtractPictureKey extractor1, ExtractPictureKey extractor2) throws Exception {
        HashMap map = new HashMap();
        HashMap<String, Map<Integer, TreeMap<Integer, PictureData>>> sheetMap = new HashMap<String, Map<Integer, TreeMap<Integer, PictureData>>>();
        Workbook workbook = ExcelUtil.getWorkbook(is, fileName);
        int sheetNum = workbook.getNumberOfSheets();
        for (int i = 0; i < 6; ++i) {
            XSSFClientAnchor cAnchor;
            XSSFPicture picture;
            List list;
            XSSFDrawing drawingPatriarch;
            TreeMap<Integer, Object> colMap = new TreeMap<Integer, Object>();
            HashMap<Integer, TreeMap<Integer, Object>> rowMap = new HashMap<Integer, TreeMap<Integer, Object>>();
            Sheet sheet = workbook.getSheetAt(i);
            if (sheet instanceof XSSFSheet) {
                drawingPatriarch = ((XSSFSheet)sheet).getDrawingPatriarch();
                if (drawingPatriarch == null) continue;
                list = drawingPatriarch.getShapes();
                for (XSSFShape shape : list) {
                    if (!(shape instanceof XSSFPicture)) continue;
                    picture = (XSSFPicture)shape;
                    cAnchor = (XSSFClientAnchor)picture.getAnchor();
                    colMap.put(extractor2.extract((ClientAnchor)cAnchor), picture.getPictureData());
                    rowMap.put(extractor1.extract((ClientAnchor)cAnchor), colMap);
                }
                sheetMap.put(sheet.getSheetName(), rowMap);
            }
            if (!(sheet instanceof HSSFSheet) || (drawingPatriarch = ((HSSFSheet)sheet).getDrawingPatriarch()) == null) continue;
            list = drawingPatriarch.getChildren();
            for (XSSFShape shape : list) {
                if (!(shape instanceof HSSFPicture)) continue;
                picture = (HSSFPicture)shape;
                cAnchor = picture.getClientAnchor();
                colMap.put(extractor2.extract((ClientAnchor)cAnchor), picture.getPictureData());
                rowMap.put(extractor1.extract((ClientAnchor)cAnchor), colMap);
            }
            sheetMap.put(sheet.getSheetName(), rowMap);
        }
        return sheetMap;
    }

    public static String getFileName(String fileName) {
        fileName = fileName.replace("[", "").replace("]", "").replace(":", "").replace("\\", "").replace("/", "").replace("?", "").replace("*", "").replace("|", "").replace("<", "").replace(">", "").replace(",", "").replace(";", "").replace(".", "").replace("+", "").replace("\"", "").replace("@", "");
        return fileName;
    }

    @FunctionalInterface
    static interface ExtractPictureKey {
        public int extract(ClientAnchor var1);
    }
}

