/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.training.util;

import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import org.springframework.util.CollectionUtils;

public class StringsUtils {
    public static List<String> stringToList(String strArr) {
        return Arrays.stream(strArr.split(",")).map(s -> s.trim()).collect(Collectors.toList());
    }

    public static String ListToString(List list, String sign) {
        if (CollectionUtils.isEmpty((Collection)list)) {
            return null;
        }
        List list1 = list.stream().map(x -> x + "").collect(Collectors.toList());
        return list1.stream().collect(Collectors.joining(","));
    }

    public static String tripSign(String str) {
        return str.replaceAll("[\n`~!@#$%^&*()+=|{}':;',\\[\\].<>/?~\uff01@#\uffe5%\u2026\u2026&*\uff08\uff09\u2014\u2014+|{}\u3010\u3011\u2018\uff1b\uff1a\u201d\u201c\u2019\u3002\uff0c \u3001\uff1f]", "");
    }

    public static String addSign(String str, int line, String sign) {
        String regex = "\\S{" + line + "}(?!$)";
        String result = str.replaceAll(regex, "$0" + sign);
        return result;
    }

    public static List<Integer> StringToList(String content, String split) {
        ArrayList<Integer> reuslt = new ArrayList<Integer>();
        if (StringUtils.isNotBlank((CharSequence)content)) {
            String[] arr;
            for (String obj : arr = content.split(split)) {
                if (!StringUtils.isNotBlank((CharSequence)obj) || reuslt.contains(Integer.parseInt(obj.trim()))) continue;
                reuslt.add(Integer.parseInt(obj.trim()));
            }
        }
        return reuslt;
    }

    public static List<String> String2List(String content, String split) {
        ArrayList<String> reuslt = new ArrayList<String>();
        if (StringUtils.isNotBlank((CharSequence)content)) {
            String[] arr;
            for (String obj : arr = content.split(split)) {
                if (!StringUtils.isNotBlank((CharSequence)obj)) continue;
                reuslt.add(obj.trim());
            }
        }
        return reuslt;
    }

    public static String getRandomNumber(int length) {
        String str = "";
        Random random = new Random();
        char[] chars = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789".toCharArray();
        for (int i = 0; i < length; ++i) {
            str = str + chars[random.nextInt(62)];
        }
        return str;
    }

    public static float getSimilarityRatio(String str, String target) {
        return 1.0f - (float)StringsUtils.compare(str, target) / (float)Math.max(str.length(), target.length());
    }

    private static int compare(String str, String target) {
        int j;
        int i;
        int n = str.length();
        int m = target.length();
        if (n == 0) {
            return m;
        }
        if (m == 0) {
            return n;
        }
        int[][] d = new int[n + 1][m + 1];
        for (i = 0; i <= n; ++i) {
            d[i][0] = i;
        }
        for (j = 0; j <= m; ++j) {
            d[0][j] = j;
        }
        for (i = 1; i <= n; ++i) {
            char ch1 = str.charAt(i - 1);
            for (j = 1; j <= m; ++j) {
                char ch2 = target.charAt(j - 1);
                int temp = ch1 == ch2 ? 0 : 1;
                d[i][j] = StringsUtils.min(d[i - 1][j] + 1, d[i][j - 1] + 1, d[i - 1][j - 1] + temp);
            }
        }
        return d[n][m];
    }

    private static int min(int one, int two, int three) {
        return (one = Math.min(one, two)) < three ? one : three;
    }
}

