/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.training.util;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TencentLiveUtils {
    private static final Logger log = LoggerFactory.getLogger(TencentLiveUtils.class);
    private static final char[] DIGITS_LOWER = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public static void main(String[] args) {
        System.out.println(TencentLiveUtils.getSafeUrl("txrtmp", "11212122", 1469762325L));
    }

    public static String getSafeUrl(String key, String streamId, long txTime) {
        String input = key + streamId + Long.toHexString(txTime).toUpperCase();
        String txSecret = null;
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            txSecret = TencentLiveUtils.byteArrayToHexString(messageDigest.digest(input.getBytes("UTF-8")));
        }
        catch (NoSuchAlgorithmException e) {
            log.error("", (Throwable)e);
        }
        catch (UnsupportedEncodingException e) {
            log.error("", (Throwable)e);
        }
        return txSecret == null ? "" : "txSecret=" + txSecret + "&" + "txTime=" + Long.toHexString(txTime).toUpperCase();
    }

    private static String byteArrayToHexString(byte[] data) {
        char[] out = new char[data.length << 1];
        int j = 0;
        for (int i = 0; i < data.length; ++i) {
            out[j++] = DIGITS_LOWER[(0xF0 & data[i]) >>> 4];
            out[j++] = DIGITS_LOWER[0xF & data[i]];
        }
        return new String(out);
    }
}

