/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.training.util;

import com.itextpdf.text.BaseColor;
import com.itextpdf.text.Element;
import com.itextpdf.text.Font;
import com.itextpdf.text.Image;
import com.itextpdf.text.Phrase;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.pdf.BaseFont;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfGState;
import com.itextpdf.text.pdf.PdfPCell;
import com.itextpdf.text.pdf.PdfPTable;
import com.itextpdf.text.pdf.PdfReader;
import com.itextpdf.text.pdf.PdfStamper;
import java.io.InputStream;
import java.io.OutputStream;

public class TextPDFUtil {
    public static void addTableGroupTitle(PdfPTable table, PdfPCell cell, String text) {
        cell = new PdfPCell(new Phrase(text, TextPDFUtil.getColorFont(BaseColor.WHITE)));
        table.addCell(TextPDFUtil.addTitleCell(cell, 25, new BaseColor(69, 153, 241), 2, false));
    }

    public static void addTableGroupTitle(PdfPTable table, PdfPCell cell, String text, int colspan) {
        cell = new PdfPCell(new Phrase(text, TextPDFUtil.getColorFont(BaseColor.WHITE)));
        table.addCell(TextPDFUtil.addTitleCell(cell, 25, new BaseColor(69, 153, 241), colspan, false));
    }

    public static void addSuggestLine(PdfPTable table, PdfPCell cell, String suggestText, BaseColor fontColor) throws Exception {
        TextPDFUtil.addSuggestLine(table, cell, suggestText, fontColor, 0, 10.0f, 30.0f);
    }

    public static void addSuggestLine(PdfPTable table, PdfPCell cell, String suggestText, BaseColor fontColor, int colspan, float ... widths) throws Exception {
        cell = new PdfPCell(new Phrase("\u6838\u67e5\u5efa\u8bae\uff1a", TextPDFUtil.getColorFont()));
        cell.setColspan(1);
        table.addCell(TextPDFUtil.addBaseCell(cell, 23, new BaseColor(238, 238, 238), false));
        cell = new PdfPCell(new Phrase(suggestText, TextPDFUtil.getColorFont(fontColor)));
        if (colspan > 0) {
            cell.setColspan(colspan);
        }
        table.addCell(TextPDFUtil.addBaseCell(cell, 23, new BaseColor(238, 238, 238), false));
        table.setWidths(TextPDFUtil.getColumnWiths(widths));
    }

    public static Element addTableGroupLine(String groupText) {
        PdfPTable tableBaseInfoIndex = new PdfPTable(1);
        tableBaseInfoIndex.setWidthPercentage(20.0f);
        PdfPCell cellBaseInfo = new PdfPCell(new Phrase(groupText, TextPDFUtil.getColorFont()));
        cellBaseInfo.setHorizontalAlignment(1);
        tableBaseInfoIndex.addCell(TextPDFUtil.addTitleCell(cellBaseInfo, 28, new BaseColor(238, 238, 238), 2, false));
        tableBaseInfoIndex.addCell(TextPDFUtil.addBlankLine(10, 1));
        return tableBaseInfoIndex;
    }

    public static Element addHeadLine(String groupText) {
        PdfPTable tableBaseInfoIndex = new PdfPTable(1);
        tableBaseInfoIndex.setWidthPercentage(100.0f);
        PdfPCell cellBaseInfo = new PdfPCell(new Phrase(groupText, TextPDFUtil.getHeadFont()));
        cellBaseInfo.setBorderWidth(0.0f);
        cellBaseInfo.setMinimumHeight(80.0f);
        cellBaseInfo.setHorizontalAlignment(1);
        cellBaseInfo.setVerticalAlignment(5);
        tableBaseInfoIndex.addCell(cellBaseInfo);
        return tableBaseInfoIndex;
    }

    public static PdfPCell addOneLineBox(String groupText, int col) {
        PdfPCell cell = new PdfPCell(new Phrase(groupText, TextPDFUtil.getColorFont()));
        cell.setColspan(col);
        cell.setMinimumHeight(35.0f);
        cell.setRowspan(1);
        cell.setHorizontalAlignment(1);
        cell.setVerticalAlignment(5);
        return cell;
    }

    public static PdfPCell addTwoLineBox(String groupText, int col) {
        PdfPCell cell = new PdfPCell(new Phrase(groupText, TextPDFUtil.getColorFont()));
        cell.setColspan(col);
        cell.setMinimumHeight(45.0f);
        cell.setRowspan(2);
        cell.setHorizontalAlignment(1);
        cell.setVerticalAlignment(5);
        return cell;
    }

    public static Font getColorFont(BaseColor color, int fontSize, String fontFamily) {
        Font font = new Font(TextPDFUtil.getFont());
        font.setColor(color);
        if (!(fontSize <= 0 || null == fontFamily && "".equals(fontFamily))) {
            font.setSize((float)fontSize);
            font.setFamily(fontFamily);
        }
        return font;
    }

    public static Font getColorFont(BaseColor color) {
        return TextPDFUtil.getColorFont(color, 0, null);
    }

    public static Font getColorFont() {
        Font font = new Font(TextPDFUtil.getFont());
        return font;
    }

    public static Font getHeadFont() {
        Font font = new Font(TextPDFUtil.getFont());
        font.setSize(25.0f);
        return font;
    }

    public static float[] getColumnWiths(float ... widths) {
        float[] columnWidths = new float[widths.length];
        for (int i = 0; i < widths.length; ++i) {
            columnWidths[i] = widths[i];
        }
        return columnWidths;
    }

    public static PdfPCell addTitleCell(PdfPCell titleCell, int fixedHeight, BaseColor baseColor, int colspan, boolean isBottomBorder) {
        titleCell.setColspan(colspan);
        titleCell.setFixedHeight((float)fixedHeight);
        titleCell.setUseVariableBorders(true);
        titleCell.setUseAscender(true);
        titleCell.setUseDescender(true);
        titleCell.setBackgroundColor(baseColor);
        if (isBottomBorder) {
            titleCell.setBorder(2);
            titleCell.setBorderColorBottom(BaseColor.LIGHT_GRAY);
        } else {
            titleCell.setBorder(0);
        }
        titleCell.setVerticalAlignment(5);
        return titleCell;
    }

    public static PdfPCell addBlankLine(int fixedHeight, int colspan) {
        PdfPCell blankLine = new PdfPCell();
        blankLine.setFixedHeight((float)fixedHeight);
        blankLine.setBorder(0);
        blankLine.setColspan(colspan);
        return blankLine;
    }

    public static PdfPCell addBaseCell(PdfPCell baseCell) {
        baseCell.setFixedHeight(23.0f);
        baseCell.setUseVariableBorders(true);
        baseCell.setUseAscender(true);
        baseCell.setUseDescender(true);
        baseCell.setBorder(2);
        baseCell.setBorderColorBottom(BaseColor.LIGHT_GRAY);
        baseCell.setVerticalAlignment(5);
        return baseCell;
    }

    public static PdfPCell addBaseCell(PdfPCell baseCell, boolean isBottomBorder) {
        baseCell.setFixedHeight(23.0f);
        baseCell.setUseVariableBorders(true);
        baseCell.setUseAscender(true);
        baseCell.setUseDescender(true);
        if (isBottomBorder) {
            baseCell.setBorder(2);
            baseCell.setBorderColorBottom(BaseColor.LIGHT_GRAY);
        } else {
            baseCell.setBorder(0);
        }
        baseCell.setVerticalAlignment(5);
        return baseCell;
    }

    public static PdfPCell addBaseCell(PdfPCell baseCell, int fixedHeight, BaseColor color, boolean isBottomBorder) {
        baseCell.setFixedHeight((float)fixedHeight);
        baseCell.setUseVariableBorders(true);
        baseCell.setUseAscender(true);
        baseCell.setUseDescender(true);
        if (null != color) {
            baseCell.setBackgroundColor(color);
        }
        if (isBottomBorder) {
            baseCell.setBorder(2);
            baseCell.setBorderColorBottom(BaseColor.LIGHT_GRAY);
        } else {
            baseCell.setBorder(0);
        }
        baseCell.setVerticalAlignment(5);
        return baseCell;
    }

    public static BaseFont getFont() {
        BaseFont bf = null;
        try {
            bf = BaseFont.createFont((String)"STSong-Light", (String)"UniGB-UCS2-H", (boolean)false);
        }
        catch (Exception e) {
            System.out.println("Exception = " + e.getMessage());
        }
        return bf;
    }

    public static void stringWaterMark(InputStream input, OutputStream output, String waterMarkString, int xAmout, int yAmout, float opacity, float rotation, int waterMarkFontSize, BaseColor color) {
        try {
            PdfReader reader = new PdfReader(input);
            PdfStamper stamper = new PdfStamper(reader, output);
            BaseFont baseFont = BaseFont.createFont((String)"STSong-Light", (String)"UniGB-UCS2-H", (boolean)false);
            int total = reader.getNumberOfPages() + 1;
            for (int i = 1; i < total; ++i) {
                Rectangle pageRect = stamper.getReader().getPageSizeWithRotation(i);
                float x = pageRect.getWidth() / (float)xAmout;
                float y = pageRect.getHeight() / (float)yAmout;
                PdfContentByte over = stamper.getOverContent(i);
                PdfGState gs = new PdfGState();
                gs.setFillOpacity(opacity);
                over.setGState(gs);
                over.saveState();
                over.beginText();
                over.setColorFill(color);
                over.setFontAndSize(baseFont, (float)waterMarkFontSize);
                for (int n = 0; n < xAmout + 1; ++n) {
                    for (int m = 0; m < yAmout + 1; ++m) {
                        over.showTextAligned(1, waterMarkString, x * (float)n, y * (float)m, rotation);
                    }
                }
                over.endText();
            }
            stamper.close();
        }
        catch (Exception e) {
            new Exception("NetAnd PDF add Text Watermark error" + e.getMessage());
        }
    }

    public static void imageWaterMark(InputStream input, OutputStream output, String imageFile, float opacity) {
        try {
            PdfReader reader = new PdfReader(input);
            PdfStamper stamper = new PdfStamper(reader, output);
            Rectangle pageRect = stamper.getReader().getPageSize(1);
            float w = pageRect.getWidth();
            float h = pageRect.getHeight();
            int total = reader.getNumberOfPages() + 1;
            Image image = Image.getInstance((String)imageFile);
            image.setAbsolutePosition(0.0f, 0.0f);
            image.scaleAbsolute(w, h);
            PdfGState gs = new PdfGState();
            gs.setFillOpacity(opacity);
            for (int i = 1; i < total; ++i) {
                Rectangle pagesize = reader.getPageSizeWithRotation(i);
                float x = (pagesize.getLeft() + pagesize.getRight()) / 2.0f;
                float y = (pagesize.getTop() + pagesize.getBottom()) / 2.0f;
                PdfContentByte over = stamper.getOverContent(i);
                over.setGState(gs);
                over.saveState();
                over.beginText();
                over.addImage(image);
            }
            stamper.close();
        }
        catch (Exception e) {
            new Exception("NetAnd PDF add image Watermark error" + e.getMessage());
        }
    }

    public static void addTableHeaderData(PdfPTable tableMobileHeader, PdfPCell cellMobileHeader, int clospan, float fixedHeight, int padding, int border, BaseColor borderColor, BaseColor backgroundColor, int vertical, int horizontal) {
        cellMobileHeader.setUseBorderPadding(true);
        cellMobileHeader.setUseAscender(true);
        if (clospan > 0) {
            cellMobileHeader.setColspan(clospan);
        }
        cellMobileHeader.setUseDescender(true);
        cellMobileHeader.setFixedHeight(fixedHeight);
        cellMobileHeader.setPadding((float)padding);
        cellMobileHeader.setVerticalAlignment(vertical);
        cellMobileHeader.setHorizontalAlignment(horizontal);
        if (null != backgroundColor) {
            cellMobileHeader.setBackgroundColor(backgroundColor);
        }
        cellMobileHeader.setBorder(border);
        cellMobileHeader.setBorderColor(borderColor);
        tableMobileHeader.addCell(cellMobileHeader);
    }

    public static void addTableHeaderData(PdfPTable tableMobileHeader, PdfPCell cellMobileHeader, int clospan, BaseColor backgroundColor) {
        TextPDFUtil.addTableHeaderData(tableMobileHeader, cellMobileHeader, clospan, 100.0f, 10, 30, BaseColor.WHITE, backgroundColor, 0, 0);
    }
}

