/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.training.util;

import com.ovopark.training.util.OssHelper;
import com.ovopark.training.util.StorageModule;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WaterMarkUtil {
    private static final Logger log = LoggerFactory.getLogger(WaterMarkUtil.class);

    public static String addWaterMark(String srcImgPath, String tarImgPath, String ossUpUrl, List<Map<String, Object>> list) {
        String url = "";
        try {
            OssHelper.downLoadFile(srcImgPath, tarImgPath);
            File srcImgFile = new File(tarImgPath);
            BufferedImage srcImg = ImageIO.read(srcImgFile);
            int srcImgWidth = ((Image)srcImg).getWidth(null);
            int srcImgHeight = ((Image)srcImg).getHeight(null);
            BufferedImage bufImg = new BufferedImage(srcImgWidth, srcImgHeight, 1);
            Graphics2D g = bufImg.createGraphics();
            g.drawImage(srcImg, 0, 0, srcImgWidth, srcImgHeight, null);
            for (int i = 0; i < list.size(); ++i) {
                Map<String, Object> map = list.get(i);
                g.setColor((Color)map.get("markContentColor"));
                g.setFont((Font)map.get("font"));
                if (map.get("middle") != null && "1".equals(map.get("middle").toString())) {
                    int middle = g.getFontMetrics(g.getFont()).charsWidth(map.get("waterMarkContent").toString().toCharArray(), 0, map.get("waterMarkContent").toString().length());
                    g.drawString(map.get("waterMarkContent").toString(), (float)((srcImgWidth - middle) / 2), Float.parseFloat(map.get("length").toString()) * (float)srcImgHeight);
                    continue;
                }
                g.drawString(map.get("waterMarkContent").toString(), Float.parseFloat(map.get("width").toString()) * (float)srcImgWidth, Float.parseFloat(map.get("length").toString()) * (float)srcImgHeight);
            }
            g.dispose();
            FileOutputStream outImgStream = new FileOutputStream(tarImgPath);
            ImageIO.write((RenderedImage)bufImg, "png", outImgStream);
            outImgStream.flush();
            outImgStream.close();
            File fileUrl = new File(tarImgPath);
            url = ossUpUrl + OssHelper.uploadFile(fileUrl, StorageModule.TRAINING);
            fileUrl.delete();
        }
        catch (Exception e) {
            log.error("addWaterMark", (Throwable)e);
        }
        return url;
    }
}

