/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.utils;

import com.alibaba.fastjson.JSONObject;
import com.ovopark.utils.ReturnCode;

public class ResultBody {
    private String code;
    private String message;
    private Object result;
    private Object data;
    private boolean isError;

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public Object getResult() {
        return this.result;
    }

    public void setResult(Object result) {
        this.result = result;
    }

    public Object getData() {
        return this.data;
    }

    public void setData(Object data) {
        this.data = data;
    }

    public Boolean getIsError() {
        return this.isError;
    }

    public void setIsError(Boolean isError) {
        this.isError = isError;
    }

    public static ResultBody success() {
        ResultBody rb = new ResultBody();
        rb.setCode("0");
        rb.setMessage(ReturnCode.SUCCESS.getName());
        rb.setData(null);
        rb.setIsError(false);
        rb.setResult(ReturnCode.SUCCESS.getDesc());
        return rb;
    }

    public static ResultBody success(Object data) {
        ResultBody rb = new ResultBody();
        rb.setCode("0");
        rb.setMessage(ReturnCode.SUCCESS.getName());
        rb.setData(data);
        rb.setIsError(false);
        rb.setResult(ReturnCode.SUCCESS.getDesc());
        return rb;
    }

    public static ResultBody success(String code, String message, Object data, String desc) {
        ResultBody rb = new ResultBody();
        rb.setCode(code);
        rb.setMessage(message);
        rb.setIsError(false);
        rb.setData(data);
        rb.setResult(desc);
        return rb;
    }

    public static ResultBody error() {
        ResultBody rb = new ResultBody();
        rb.setCode("-1");
        rb.setMessage(ReturnCode.ERROR.getName());
        rb.setIsError(true);
        rb.setResult(ReturnCode.ERROR.getDesc());
        return rb;
    }

    public static ResultBody error(String code, String message, Object data, String desc) {
        ResultBody rb = new ResultBody();
        rb.setCode(code);
        rb.setMessage(message);
        rb.setData(data);
        rb.setIsError(true);
        rb.setResult(desc);
        return rb;
    }

    public static ResultBody paramError() {
        ResultBody rb = new ResultBody();
        rb.setCode("20000001");
        rb.setMessage(ReturnCode.PARAM_ERROR.getName());
        rb.setIsError(true);
        rb.setData(null);
        rb.setResult(ReturnCode.PARAM_ERROR.getDesc());
        return rb;
    }

    public static ResultBody paramError(Object data) {
        ResultBody rb = new ResultBody();
        rb.setCode("20000001");
        rb.setMessage(ReturnCode.PARAM_ERROR.getName());
        rb.setIsError(true);
        rb.setData(data);
        rb.setResult(ReturnCode.PARAM_ERROR.getDesc());
        return rb;
    }

    public String toString() {
        return JSONObject.toJSONString((Object)this);
    }

    public static void main(String[] args) {
        System.out.println(ResultBody.success());
    }
}

