package com.ovopark.training.enhancer.config;

import com.ovopark.training.enhancer.filter.EhContextFilter;
import com.ovopark.training.enhancer.filter.EhLogFilter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.filter.CommonsRequestLoggingFilter;

/**
 * 2
 */
@Configuration
@ConditionalOnProperty(name = "enhancer.enable", havingValue = "true", matchIfMissing = true)
public class EhConfigurations {

    @Bean
    @ConditionalOnProperty(name = "enhancer.eh-context-filter.enable", havingValue = "true", matchIfMissing = true)
    public EhContextFilter ehContextFilter() {
        return new EhContextFilter();
        // 123
//        FilterRegistrationBean<EhContextFilter> registrationBean = new FilterRegistrationBean<>();
//        registrationBean.setFilter(filter);
//        registrationBean.addUrlPatterns("/*"); // 只对/api/开头的路径应用过滤器
//        registrationBean.setName("EhContextFilter");
//        registrationBean.setOrder(100); // 设置过滤器顺序
//        return registrationBean;
    }

    @Bean
    @ConditionalOnProperty(name = "enhancer.eh-log-filter.enable", havingValue = "true", matchIfMissing = true)
    public EhLogFilter ehLogFilter() {
        return new EhLogFilter();
    }

    @ConditionalOnProperty(name = "enhancer.commons-request-logging-filter.enable",
            havingValue = "true", matchIfMissing = false)
    @Bean
    public CommonsRequestLoggingFilter logFilter() {
        CommonsRequestLoggingFilter filter = new CommonsRequestLoggingFilter();
        filter.setIncludeQueryString(true);
        filter.setIncludePayload(true);
        filter.setIncludeHeaders(true);
        filter.setIncludeClientInfo(true);
        filter.setAfterMessagePrefix("REQUEST DATA-");
        return filter;
    }

}