package com.ovopark.training.enhancer.utils;

import lombok.extern.slf4j.Slf4j;

import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import java.util.HashMap;

@Slf4j
public class EhContextUtil {
    
    private static final ThreadLocal<HashMap<String, Object>> envStore = ThreadLocal.withInitial(HashMap::new);

    public EhContextUtil() {
    }

    public static void clear() {
        envStore.get().clear();
    }

    public static void remove(String contextKey) {
        envStore.get().remove(contextKey);
    }

    public static void putAll(HashMap<String, Object> keyValue) {
        (envStore.get()).putAll(keyValue);
    }

    public static HashMap<String, Object> getAll() {
        return new HashMap<>(envStore.get());
    }

    public static void put(String key, Object value) {
        envStore.get().put(key, value);
    }

    public static Object get(String key) {
        return envStore.get().get(key);
    }

    public static void setRequest(ServletRequest servletRequest) {
       put("request", servletRequest);
    }

    public static ServletRequest getRequest() {
        return (ServletRequest)get("request");
    }

    public static void setResponse(ServletResponse servletResponse) {
       put("response", servletResponse);
    }

    public static ServletResponse getResponse() {
        return (ServletResponse)get("response");
    }

    public static void setClientIp(String ip) {
       put("clientIp", ip);
    }

    public static String getClientIp() {
        return (String)get("clientIp");
    }

    public static void setUserAgent(String userAgent) {
       put("userAgent", userAgent);
    }

    public static String getUserAgent() {
        return (String)get("userAgent");
    }

    public static void setUserId(int userId) {
        log.debug("setUserId:{}", userId);
       put("userId", userId);
    }

    public static int getUserId() {
        Integer userId = (Integer)get("userId");
        return userId == null ? 0 : userId;
    }

    public static void setTraceId(String requestId) {
        put("traceId", requestId);
    }

    public static String getTraceId() {
        return String.valueOf(get("traceId"));
    }

    public static void setEnterpriseId(Integer enterpriseId) {
        put("enterpriseId", enterpriseId);
    }

    public static Integer getEnterpriseId() {
        return (Integer)get("enterpriseId");
    }

    public static void setStartTime(Long startTime) {
        put("startTime", startTime);
    }

    public static Long getStartTime() {
        return (Long)get("startTime");
    }

}
