/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.training.enhancer.filter;

import com.ovopark.training.enhancer.utils.EhContextUtil;
import com.ovopark.training.enhancer.utils.HttpUtils;
import java.io.IOException;
import java.util.UUID;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.core.annotation.Order;
import org.springframework.web.filter.OncePerRequestFilter;

@Order(value=100)
public class EhContextFilter
extends OncePerRequestFilter {
    private static final Logger log = LoggerFactory.getLogger(EhContextFilter.class);

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        String requestId = request.getHeader("requestId");
        if (requestId == null) {
            requestId = UUID.randomUUID().toString();
        }
        EhContextUtil.setTraceId(requestId);
        MDC.put((String)"traceId", (String)requestId);
        String remoteIp = HttpUtils.getRemoteIp(request);
        MDC.put((String)"requestIp", (String)remoteIp);
        EhContextUtil.setRequest((ServletRequest)request);
        String userAgent = request.getHeader("User-Agent");
        EhContextUtil.setUserAgent(userAgent);
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }
}

