package com.ovopark.training.enhancer.subject.gracefulshutdown;

import lombok.Getter;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.actuate.endpoint.annotation.ReadOperation;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.event.ContextClosedEvent;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;

import java.util.Date;

@Slf4j
@Component
@Endpoint(id = "shutdown-graceful")
@RefreshScope
public class GracefulShutdownEndpoint {

    @Autowired
    private GracefulShutdownProperties gracefulShutdownProperties;

    @Autowired
    private ShutdownManager shutdownManager;

    @Getter
    private Date startShutdown;
    private Date stopShutdown;

    public GracefulShutdownEndpoint() {
    }

    @EventListener
    public void onClose(ContextClosedEvent event){
        if (this.stopShutdown != null && this.startShutdown != null) {
            long seconds = (this.stopShutdown.getTime() - this.startShutdown.getTime()) / 1000L;
            log.info("Shutdown performed in {} second(s)", seconds);
        }
    }

    @ReadOperation
    public String invoke() {
        startShutdown = new Date();
        new Thread(() -> {
            try {
                shutdownManager.pause();
                shutdownManager.shutdown(gracefulShutdownProperties.getTimeout());
                stopShutdown = new Date();
                System.exit(0);
            } catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }).start();
        return "done";
    }

}


