package com.ovopark.training.enhancer.subject.gracefulshutdown.shutdown;

import com.ovopark.training.enhancer.subject.gracefulshutdown.GracefulShutdownProperties;
import com.ovopark.training.enhancer.subject.gracefulshutdown.OrderedShutdown;
import lombok.Setter;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.client.serviceregistry.Registration;
import org.springframework.cloud.client.serviceregistry.ServiceRegistry;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.Ordered;

@Slf4j
public class AutoServiceRegistrationShutdown implements OrderedShutdown, ApplicationContextAware {
    private ApplicationContext applicationContext;
    @Autowired
    private GracefulShutdownProperties gracefulShutdownProperties;
    @Setter
    private ServiceRegistry serviceRegistry;
    @Setter
    private Registration registration;
    public AutoServiceRegistrationShutdown() {
    }

    public void pause() throws InterruptedException {
        if (this.registration != null) {
            this.serviceRegistry.setStatus(this.registration, "DOWN");
            log.info("De-registered from service registry.");
        }
    }

    public void shutdown(Integer delay) throws InterruptedException {
//        AutoServiceRegistration autoServiceRegistration = (AutoServiceRegistration)this.applicationContext.getBean(AutoServiceRegistration.class);
//        if (autoServiceRegistration != null) {
//            ((AbstractAutoServiceRegistration)autoServiceRegistration).stop();
//        }
        if (this.registration != null) {
            this.serviceRegistry.deregister(this.registration);
            log.info("De-registered from service registry.");
        }

        log.info("We are now in OUT_OF_SERVICE mode, please wait {} second(s)...",  this.gracefulShutdownProperties.getWait() );
        Thread.sleep((long)(this.gracefulShutdownProperties.getWait() * 1000));
    }

    public int getOrder() {
        return Ordered.HIGHEST_PRECEDENCE;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}
