/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.training.enhancer.subject.gracefulshutdown;

import com.ovopark.training.enhancer.subject.gracefulshutdown.GracefulShutdownProperties;
import com.ovopark.training.enhancer.subject.gracefulshutdown.ShutdownManager;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.actuate.endpoint.annotation.ReadOperation;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.event.ContextClosedEvent;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;

@Component
@Endpoint(id="shutdown-graceful")
@RefreshScope
public class GracefulShutdownEndpoint {
    private static final Logger log = LoggerFactory.getLogger(GracefulShutdownEndpoint.class);
    @Autowired
    private GracefulShutdownProperties gracefulShutdownProperties;
    @Autowired
    private ShutdownManager shutdownManager;
    private Date startShutdown;
    private Date stopShutdown;

    @EventListener
    public void onClose(ContextClosedEvent event) {
        if (this.stopShutdown != null && this.startShutdown != null) {
            long seconds = (this.stopShutdown.getTime() - this.startShutdown.getTime()) / 1000L;
            log.info("Shutdown performed in {} second(s)", (Object)seconds);
        }
    }

    @ReadOperation
    public String invoke() {
        this.startShutdown = new Date();
        new Thread(() -> {
            try {
                this.shutdownManager.pause();
                this.shutdownManager.shutdown(this.gracefulShutdownProperties.getTimeout());
                this.stopShutdown = new Date();
                System.exit(0);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }).start();
        return "done";
    }

    public Date getStartShutdown() {
        return this.startShutdown;
    }
}

