/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.training.enhancer.subject.tracing;

import com.ovopark.training.enhancer.subject.tracing.EhTraceContext;
import com.ovopark.training.enhancer.subject.tracing.WrappingExecutorService;
import com.ovopark.training.enhancer.utils.EhContextUtil;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import org.slf4j.MDC;

public class TracingHelper {
    public static TracingHelper getInstance() {
        return Holder.INSTANCE;
    }

    public static Executor executorService(ThreadPoolExecutor poolExecutor) {
        class CurrentTraceContextExecutorService
        extends WrappingExecutorService {
            final /* synthetic */ ThreadPoolExecutor val$poolExecutor;

            CurrentTraceContextExecutorService(ThreadPoolExecutor threadPoolExecutor) {
                this.val$poolExecutor = threadPoolExecutor;
            }

            @Override
            protected ExecutorService delegate() {
                return this.val$poolExecutor;
            }

            protected <C> Callable<C> wrap(Callable<C> task) {
                return TracingHelper.getInstance().wrap(task);
            }

            @Override
            protected Runnable wrap(Runnable task) {
                return TracingHelper.getInstance().wrap(task);
            }
        }
        return new CurrentTraceContextExecutorService(poolExecutor);
    }

    private Runnable wrap(final Runnable task) {
        final EhTraceContext invocationContext = this.get();
        class CurrentTraceContextRunnable
        implements Runnable {
            CurrentTraceContextRunnable() {
            }

            @Override
            public void run() {
                TracingHelper.this.processTrace(invocationContext);
                try {
                    task.run();
                }
                finally {
                    MDC.clear();
                }
            }
        }
        return new CurrentTraceContextRunnable();
    }

    private EhTraceContext get() {
        EhTraceContext ehTraceContext = new EhTraceContext();
        ehTraceContext.setTraceId(EhContextUtil.getTraceId());
        return ehTraceContext;
    }

    private <C> Callable<C> wrap(final Callable<C> task) {
        final EhTraceContext invocationContext = this.get();
        class CurrentTraceContextCallable
        implements Callable<C> {
            CurrentTraceContextCallable() {
            }

            @Override
            public C call() throws Exception {
                Object call;
                TracingHelper.this.processTrace(invocationContext);
                try {
                    call = task.call();
                }
                finally {
                    MDC.clear();
                }
                return call;
            }
        }
        return new CurrentTraceContextCallable();
    }

    private void processTrace(EhTraceContext invocationContext) {
        MDC.put((String)"traceId", (String)invocationContext.getTraceId());
        MDC.put((String)"requestId", (String)invocationContext.getTraceId());
    }

    static class Holder {
        private static final TracingHelper INSTANCE = new TracingHelper();

        Holder() {
        }
    }
}

