
##  策略模式工厂

### 效果

此时，若想新建一个策略工厂，则只需将策略接口作为参数传入泛型策略工厂即可，无需再写重复的样板代码，策略工厂的复用性大大提高，也大大提高了我们的开发效率。


### 优点

将策略接口类型参数化，策略工厂不受接口类型限制，成为任意接口的策略工厂。

### 缺点

系统的抽象程度、复杂度变高，不利于直观理解。

```java
import org.springframework.beans.factory.annotation.Autowired;

public interface StrategyInterfaceFoo extends BaseStrategy<String> {

    Void handle();
}

public interface StrategyInterfaceBar extends BaseStrategy<Integer> {

    String process();
}

public class BeanConfig {
    @Bean
    public HandlerFactory<String, StrategyInterfaceFoo> strategyInterfaceFooFactory() {
        return new HandlerFactory<>(StrategyInterfaceFoo.class);
    }

    @Bean
    public HandlerFactory<Integer, StrategyInterfaceBar> strategyInterfaceBarFactory() {
        return new HandlerFactory<>(StrategyInterfaceBar.class);
    }
}


/**
 * 下面以StrategyInterfaceFoo举例
 */
public class StrategyADefineA implements StrategyInterfaceFoo{

    @Override
    public String getType() {
        "A";
    }
    
    @Override
    public void handle() {
        System.out.println("handle define A.");
    }
}

public class StrategyADefineB implements StrategyInterfaceFoo{
    
    @Override
    public String getType() {
        "B";
    }

    @Override
    public void handle() {
        System.out.println("handle define B.");
    }
}

public class DemoFoo {
    
    @Autowired
    private HandlerFactory<String, StrategyInterfaceFoo> strategyFooFactory;

    public void foo(){
        StrategyInterfaceFoo strategyA = strategyAFactory.getStrategy("A");
        strategyA.handle();
        
        StrategyInterfaceFoo strategyB = strategyAFactory.getStrategy("B");
        strategyB.handle();
    }
}
```