package com.ovopark.training.enhancer.subject.datasource;

import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;

import javax.sql.DataSource;
import java.util.HashMap;
import java.util.Map;

@Slf4j
@Configuration
@ConditionalOnProperty(name = "routing-datasource.enable", havingValue = "true", matchIfMissing = false)
public class RoutingDataSourceConfig {

    @Bean
    @Primary
    @ConditionalOnMissingBean
    public RoutingDataSource primaryDataSource(Map<String, DataSource> dataSourceMap,
                                               @Value("${routing-datasource.default:master}") String defaultDataSource) {
        RoutingDataSource routing = new RoutingDataSource();
        routing.setTargetDataSources(new HashMap<>(dataSourceMap));
        routing.setDefaultTargetDataSource(dataSourceMap.get(defaultDataSource));
        return routing;
    }

    @Bean
    public RoutingDataSourceAspect dataSourceAspect() {
        return new RoutingDataSourceAspect();
    }

}
