
## 策略模式工厂

### 效果

通过泛型策略工厂的实现,我们可以轻松创建新的策略工厂,只需将策略接口作为泛型参数传入即可。这种方式避免了重复编写样板代码,大大提高了策略工厂的复用性和开发效率。

### 优点

1. 通过泛型参数化策略接口类型,使策略工厂具有通用性
2. 减少重复代码,提高代码复用率
3. 遵循开闭原则,易于扩展新的策略
4. 运行时动态获取策略实现

### 缺点

1. 系统抽象程度提高,增加了理解难度
2. 需要合理设计泛型边界,避免类型安全问题

### 代码示例
```java

// 定义策略接口
public interface IFood extends BaseStrategy<Integer> {

    Result<String> eat(User user);
}

// 配置策略工厂
@Configuration
public class BeanConfig {

    @Bean
    public HandlerFactory<Integer, IFood> foodFactory() {
        return new HandlerFactory<>(IFood.class);
    }
}

// 实现策略
/**
 * 下面以FoodChicken举例
 */
public class FoodChicken implements IFood{

    @Override
    public int getType() {
        return 1;
    }
    
    @Override
    public void eat(User user) {
        System.out.println("{} 吃了 鸡肉", user.getName());
    }
}

// 实现策略
public class FoodBeef implements IFood{
    
    @Override
    public int getType() {
        return 2;
    }

    @Override
    public void eat(User user) {
        System.out.println("{} 吃了 牛肉", user.getName());
    }
}

// 使用策略
public class DemoFood {
    
    @Autowired
    private HandlerFactory<Integer, IFood> foodFactory;

    public Result<String> eat(int type, User user){
        IFood food = foodFactory.getStrategy(type);
        if (food == null) {
            throw new IllegalArgumentException("Invalid type: " + type);
        }
        Result<String> result = food.eat(user);
        return result;
    }
}
```