/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.training.enhancer.subject.tracing;

import com.ovopark.training.enhancer.subject.tracing.WrappingExecutorService;
import com.ovopark.training.enhancer.utils.EhContextUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.function.Consumer;
import org.slf4j.MDC;

public class TracingHelper {
    public static TracingHelper getInstance() {
        return Holder.INSTANCE;
    }

    public static Executor executorService(ThreadPoolExecutor poolExecutor) {
        return TracingHelper.executorService(poolExecutor, null);
    }

    public static Executor executorService(final ThreadPoolExecutor poolExecutor, final Consumer<Throwable> exceptionCallback) {
        class CurrentTraceContextExecutorService
        extends WrappingExecutorService {
            CurrentTraceContextExecutorService() {
            }

            @Override
            protected ExecutorService delegate() {
                return poolExecutor;
            }

            protected <C> Callable<C> wrap(Callable<C> task) {
                return TracingHelper.getInstance().wrap(task, (Consumer<Throwable>)exceptionCallback);
            }

            @Override
            protected Runnable wrap(Runnable task) {
                return TracingHelper.getInstance().wrap(task, (Consumer<Throwable>)exceptionCallback);
            }
        }
        return new CurrentTraceContextExecutorService();
    }

    private Runnable wrap(final Runnable task, final Consumer<Throwable> exceptionCallback) {
        final Map contextMap = MDC.getCopyOfContextMap();
        final HashMap<String, Object> ehContextMap = EhContextUtil.getAll();
        class CurrentTraceContextRunnable
        implements Runnable {
            CurrentTraceContextRunnable() {
            }

            @Override
            public void run() {
                MDC.setContextMap(new HashMap(contextMap));
                EhContextUtil.putAll(new HashMap<String, Object>(ehContextMap));
                try {
                    task.run();
                }
                catch (Exception exception) {
                    if (exceptionCallback != null) {
                        exceptionCallback.accept(exception);
                    }
                    throw exception;
                }
                finally {
                    MDC.clear();
                }
            }
        }
        return new CurrentTraceContextRunnable();
    }

    private <C> Callable<C> wrap(final Callable<C> task, final Consumer<Throwable> exceptionCallback) {
        final Map contextMap = MDC.getCopyOfContextMap();
        final HashMap<String, Object> ehContextMap = EhContextUtil.getAll();
        class CurrentTraceContextCallable
        implements Callable<C> {
            CurrentTraceContextCallable() {
            }

            @Override
            public C call() throws Exception {
                Object call;
                MDC.setContextMap(new HashMap(contextMap));
                EhContextUtil.putAll(new HashMap<String, Object>(ehContextMap));
                try {
                    call = task.call();
                }
                catch (Exception exception) {
                    if (exceptionCallback != null) {
                        exceptionCallback.accept(exception);
                    }
                    throw exception;
                }
                finally {
                    MDC.clear();
                }
                return call;
            }
        }
        return new CurrentTraceContextCallable();
    }

    static class Holder {
        private static final TracingHelper INSTANCE = new TracingHelper();

        Holder() {
        }
    }
}

